/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.instancemanager;

import com.l2jserver.Config;
import com.l2jserver.gameserver.GameTimeController;
import com.l2jserver.gameserver.instancemanager.RaidBossSpawnManager;
import com.l2jserver.gameserver.model.L2Spawn;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2RaidBossInstance;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javolution.util.FastMap;

public class DayNightSpawnManager {
    private static Logger _log = Logger.getLogger(DayNightSpawnManager.class.getName());
    private static Map<L2Spawn, L2Npc> _dayCreatures;
    private static Map<L2Spawn, L2Npc> _nightCreatures;
    private static Map<L2Spawn, L2RaidBossInstance> _bosses;

    public static DayNightSpawnManager getInstance() {
        return SingletonHolder._instance;
    }

    private DayNightSpawnManager() {
        _dayCreatures = new FastMap();
        _nightCreatures = new FastMap();
        _bosses = new FastMap();
        _log.info("DayNightSpawnManager: Day/Night handler initialized");
    }

    public void addDayCreature(L2Spawn spawnDat) {
        if (_dayCreatures.containsKey(spawnDat)) {
            _log.warning("DayNightSpawnManager: Spawn already added into day map");
            return;
        }
        _dayCreatures.put(spawnDat, null);
    }

    public void addNightCreature(L2Spawn spawnDat) {
        if (_nightCreatures.containsKey(spawnDat)) {
            _log.warning("DayNightSpawnManager: Spawn already added into night map");
            return;
        }
        _nightCreatures.put(spawnDat, null);
    }

    public void spawnDayCreatures() {
        this.spawnCreatures(_nightCreatures, _dayCreatures, "night", "day");
    }

    public void spawnNightCreatures() {
        this.spawnCreatures(_dayCreatures, _nightCreatures, "day", "night");
    }

    private void spawnCreatures(Map<L2Spawn, L2Npc> UnSpawnCreatures, Map<L2Spawn, L2Npc> SpawnCreatures, String UnspawnLogInfo, String SpawnLogInfo) {
        try {
            int i;
            if (!UnSpawnCreatures.isEmpty()) {
                i = 0;
                for (L2Npc dayCreature : UnSpawnCreatures.values()) {
                    if (dayCreature == null) continue;
                    dayCreature.getSpawn().stopRespawn();
                    dayCreature.deleteMe();
                    ++i;
                }
                if (Config.DEBUG) {
                    _log.info("DayNightSpawnManager: Deleted " + i + " " + UnspawnLogInfo + " creatures");
                }
            }
            i = 0;
            L2Npc creature = null;
            for (L2Spawn spawnDat : SpawnCreatures.keySet()) {
                if (SpawnCreatures.get(spawnDat) == null) {
                    creature = spawnDat.doSpawn();
                    if (creature == null) continue;
                    SpawnCreatures.remove(spawnDat);
                    SpawnCreatures.put(spawnDat, creature);
                    creature.setCurrentHp(creature.getMaxHp());
                    creature.setCurrentMp(creature.getMaxMp());
                    creature.getSpawn().startRespawn();
                    if (creature.isDecayed()) {
                        creature.setDecayed(false);
                    }
                    if (creature.isDead()) {
                        creature.doRevive();
                    }
                } else {
                    creature = SpawnCreatures.get(spawnDat);
                    if (creature == null) continue;
                    creature.getSpawn().startRespawn();
                    if (creature.isDecayed()) {
                        creature.setDecayed(false);
                    }
                    if (creature.isDead()) {
                        creature.doRevive();
                    }
                    creature.setCurrentHp(creature.getMaxHp());
                    creature.setCurrentMp(creature.getMaxMp());
                    creature.spawnMe();
                }
                ++i;
            }
            if (Config.DEBUG) {
                _log.info("DayNightSpawnManager: Spawning " + i + " " + SpawnLogInfo + " creatures");
            }
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Error while spawning creatures: " + e.getMessage(), e);
        }
    }

    private void changeMode(int mode) {
        if (_nightCreatures.isEmpty() && _dayCreatures.isEmpty()) {
            return;
        }
        switch (mode) {
            case 0: {
                this.spawnDayCreatures();
                this.specialNightBoss(0);
                break;
            }
            case 1: {
                this.spawnNightCreatures();
                this.specialNightBoss(1);
                break;
            }
            default: {
                _log.warning("DayNightSpawnManager: Wrong mode sent");
            }
        }
    }

    public void notifyChangeMode() {
        try {
            if (GameTimeController.getInstance().isNowNight()) {
                this.changeMode(1);
            } else {
                this.changeMode(0);
            }
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Error while notifyChangeMode(): " + e.getMessage(), e);
        }
    }

    public void cleanUp() {
        _nightCreatures.clear();
        _dayCreatures.clear();
        _bosses.clear();
    }

    private void specialNightBoss(int mode) {
        try {
            for (L2Spawn spawn : _bosses.keySet()) {
                L2RaidBossInstance boss = _bosses.get(spawn);
                if (boss == null && mode == 1) {
                    boss = (L2RaidBossInstance)spawn.doSpawn();
                    RaidBossSpawnManager.getInstance().notifySpawnNightBoss(boss);
                    _bosses.remove(spawn);
                    _bosses.put(spawn, boss);
                    continue;
                }
                if (boss == null && mode == 0) continue;
                if (boss.getNpcId() == 25328 && boss.getRaidStatus().equals((Object)RaidBossSpawnManager.StatusEnum.ALIVE)) {
                    this.handleHellmans(boss, mode);
                }
                return;
            }
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Error while specialNoghtBoss(): " + e.getMessage(), e);
        }
    }

    private void handleHellmans(L2RaidBossInstance boss, int mode) {
        switch (mode) {
            case 0: {
                boss.deleteMe();
                _log.info("DayNightSpawnManager: Deleting Hellman raidboss");
                break;
            }
            case 1: {
                boss.spawnMe();
                _log.info("DayNightSpawnManager: Spawning Hellman raidboss");
            }
        }
    }

    public L2RaidBossInstance handleBoss(L2Spawn spawnDat) {
        if (_bosses.containsKey(spawnDat)) {
            return _bosses.get(spawnDat);
        }
        if (GameTimeController.getInstance().isNowNight()) {
            L2RaidBossInstance raidboss = (L2RaidBossInstance)spawnDat.doSpawn();
            _bosses.put(spawnDat, raidboss);
            return raidboss;
        }
        _bosses.put(spawnDat, null);
        return null;
    }

    private static class SingletonHolder {
        protected static final DayNightSpawnManager _instance = new DayNightSpawnManager();

        private SingletonHolder() {
        }
    }
}

