/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.instancemanager;

import com.l2jserver.Config;
import com.l2jserver.L2DatabaseFactory;
import com.l2jserver.gameserver.ItemsAutoDestroy;
import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.instancemanager.CursedWeaponsManager;
import com.l2jserver.gameserver.model.L2ItemInstance;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.templates.item.L2EtcItemType;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ItemsOnGroundManager {
    static final Logger _log = Logger.getLogger(ItemsOnGroundManager.class.getName());
    protected CopyOnWriteArrayList<L2ItemInstance> _items = null;
    private final StoreInDb _task = new StoreInDb();

    private ItemsOnGroundManager() {
        if (Config.SAVE_DROPPED_ITEM) {
            this._items = new CopyOnWriteArrayList();
        }
        if (Config.SAVE_DROPPED_ITEM_INTERVAL > 0) {
            ThreadPoolManager.getInstance().scheduleGeneralAtFixedRate(new StoreInDb(), Config.SAVE_DROPPED_ITEM_INTERVAL, Config.SAVE_DROPPED_ITEM_INTERVAL);
        }
        this.load();
    }

    public static final ItemsOnGroundManager getInstance() {
        return SingletonHolder._instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load() {
        Connection con;
        if (!Config.SAVE_DROPPED_ITEM && Config.CLEAR_DROPPED_ITEM_TABLE) {
            this.emptyTable();
        }
        if (!Config.SAVE_DROPPED_ITEM) {
            return;
        }
        if (Config.DESTROY_DROPPED_PLAYER_ITEM) {
            con = null;
            try {
                String str = null;
                if (!Config.DESTROY_EQUIPABLE_PLAYER_ITEM) {
                    str = "update itemsonground set drop_time=? where drop_time=-1 and equipable=0";
                } else if (Config.DESTROY_EQUIPABLE_PLAYER_ITEM) {
                    str = "update itemsonground set drop_time=? where drop_time=-1";
                }
                con = L2DatabaseFactory.getInstance().getConnection();
                PreparedStatement statement = con.prepareStatement(str);
                statement.setLong(1, System.currentTimeMillis());
                statement.execute();
                statement.close();
            }
            catch (Exception e) {
                _log.log(Level.SEVERE, "Error while updating table ItemsOnGround " + e.getMessage(), e);
            }
            finally {
                L2DatabaseFactory.close(con);
            }
        }
        con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            Statement s = con.createStatement();
            int count = 0;
            ResultSet result = s.executeQuery("select object_id,item_id,count,enchant_level,x,y,z,drop_time,equipable from itemsonground");
            while (result.next()) {
                L2ItemInstance item = new L2ItemInstance(result.getInt(1), result.getInt(2));
                L2World.getInstance().storeObject(item);
                if (item.isStackable() && result.getInt(3) > 1) {
                    item.setCount(result.getInt(3));
                }
                if (result.getInt(4) > 0) {
                    item.setEnchantLevel(result.getInt(4));
                }
                item.getPosition().setWorldPosition(result.getInt(5), result.getInt(6), result.getInt(7));
                item.getPosition().setWorldRegion(L2World.getInstance().getRegion(item.getPosition().getWorldPosition()));
                item.getPosition().getWorldRegion().addVisibleObject(item);
                item.setDropTime(result.getLong(8));
                item.setProtected(result.getLong(8) == -1L);
                item.setIsVisible(true);
                L2World.getInstance().addVisibleObject(item, item.getPosition().getWorldRegion());
                this._items.add(item);
                ++count;
                if (Config.LIST_PROTECTED_ITEMS.contains(item.getItemId()) || result.getLong(8) <= -1L || (Config.AUTODESTROY_ITEM_AFTER <= 0 || item.getItemType() == L2EtcItemType.HERB) && (Config.HERB_AUTO_DESTROY_TIME <= 0 || item.getItemType() != L2EtcItemType.HERB)) continue;
                ItemsAutoDestroy.getInstance().addItem(item);
            }
            result.close();
            s.close();
            if (count > 0) {
                _log.info("ItemsOnGroundManager: restored " + count + " items.");
            } else {
                _log.info("Initializing ItemsOnGroundManager.");
            }
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "Error while loading ItemsOnGround " + e.getMessage(), e);
        }
        finally {
            L2DatabaseFactory.close(con);
        }
        if (Config.EMPTY_DROPPED_ITEM_TABLE_AFTER_LOAD) {
            this.emptyTable();
        }
    }

    public void save(L2ItemInstance item) {
        if (!Config.SAVE_DROPPED_ITEM) {
            return;
        }
        if (item.getInstanceId() != 0) {
            return;
        }
        this._items.add(item);
    }

    public void removeObject(L2Object item) {
        if (Config.SAVE_DROPPED_ITEM && this._items != null) {
            this._items.remove(item);
        }
    }

    public void saveInDb() {
        this._task.run();
    }

    public void cleanUp() {
        this._items.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void emptyTable() {
        Connection conn = null;
        try {
            conn = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement del = conn.prepareStatement("delete from itemsonground");
            del.execute();
            del.close();
        }
        catch (Exception e1) {
            _log.log(Level.SEVERE, "Error while cleaning table ItemsOnGround " + e1.getMessage(), e1);
        }
        finally {
            L2DatabaseFactory.close(conn);
        }
    }

    private static class SingletonHolder {
        protected static final ItemsOnGroundManager _instance = new ItemsOnGroundManager();

        private SingletonHolder() {
        }
    }

    protected class StoreInDb
    extends Thread {
        protected StoreInDb() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized void run() {
            if (!Config.SAVE_DROPPED_ITEM) {
                return;
            }
            ItemsOnGroundManager.this.emptyTable();
            if (ItemsOnGroundManager.this._items.isEmpty()) {
                if (Config.DEBUG) {
                    _log.warning("ItemsOnGroundManager: nothing to save...");
                }
                return;
            }
            Connection con = null;
            PreparedStatement statement = null;
            try {
                con = L2DatabaseFactory.getInstance().getConnection();
                statement = con.prepareStatement("INSERT INTO itemsonground(object_id,item_id,count,enchant_level,x,y,z,drop_time,equipable) VALUES(?,?,?,?,?,?,?,?,?)");
                for (L2ItemInstance item : ItemsOnGroundManager.this._items) {
                    if (item == null || CursedWeaponsManager.getInstance().isCursed(item.getItemId())) continue;
                    try {
                        statement.setInt(1, item.getObjectId());
                        statement.setInt(2, item.getItemId());
                        statement.setLong(3, item.getCount());
                        statement.setInt(4, item.getEnchantLevel());
                        statement.setInt(5, item.getX());
                        statement.setInt(6, item.getY());
                        statement.setInt(7, item.getZ());
                        if (item.isProtected()) {
                            statement.setLong(8, -1L);
                        } else {
                            statement.setLong(8, item.getDropTime());
                        }
                        if (item.isEquipable()) {
                            statement.setLong(9, 1L);
                        } else {
                            statement.setLong(9, 0L);
                        }
                        statement.execute();
                        statement.clearParameters();
                    }
                    catch (Exception e) {
                        _log.log(Level.SEVERE, "Error while inserting into table ItemsOnGround: " + e.getMessage(), e);
                    }
                }
                statement.close();
            }
            catch (SQLException e) {
                _log.log(Level.SEVERE, "SQL error while storing items on ground: " + e.getMessage(), e);
            }
            finally {
                L2DatabaseFactory.close(con);
            }
            if (Config.DEBUG) {
                _log.warning("ItemsOnGroundManager: " + ItemsOnGroundManager.this._items.size() + " items on ground saved");
            }
        }
    }
}

