/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model;

import com.l2jserver.Config;
import com.l2jserver.gameserver.datatables.ItemTable;
import com.l2jserver.gameserver.model.ItemRequest;
import com.l2jserver.gameserver.model.L2ItemInstance;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.itemcontainer.PcInventory;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.InventoryUpdate;
import com.l2jserver.gameserver.network.serverpackets.ItemList;
import com.l2jserver.gameserver.network.serverpackets.StatusUpdate;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.templates.item.L2EtcItemType;
import com.l2jserver.gameserver.templates.item.L2Item;
import com.l2jserver.gameserver.util.Util;
import java.util.List;
import java.util.logging.Logger;
import javolution.util.FastList;
import javolution.util.FastSet;

public class TradeList {
    private static final Logger _log = Logger.getLogger(TradeList.class.getName());
    private final L2PcInstance _owner;
    private L2PcInstance _partner;
    private final List<TradeItem> _items = new FastList();
    private String _title;
    private boolean _packaged;
    private boolean _confirmed = false;
    private boolean _locked = false;

    public TradeList(L2PcInstance owner) {
        this._owner = owner;
    }

    public L2PcInstance getOwner() {
        return this._owner;
    }

    public void setPartner(L2PcInstance partner) {
        this._partner = partner;
    }

    public L2PcInstance getPartner() {
        return this._partner;
    }

    public void setTitle(String title) {
        this._title = title;
    }

    public String getTitle() {
        return this._title;
    }

    public boolean isLocked() {
        return this._locked;
    }

    public boolean isConfirmed() {
        return this._confirmed;
    }

    public boolean isPackaged() {
        return this._packaged;
    }

    public void setPackaged(boolean value) {
        this._packaged = value;
    }

    public TradeItem[] getItems() {
        return this._items.toArray(new TradeItem[this._items.size()]);
    }

    public TradeItem[] getAvailableItems(PcInventory inventory) {
        FastList list = FastList.newInstance();
        for (TradeItem item : this._items) {
            item = new TradeItem(item, item.getCount(), item.getPrice());
            inventory.adjustAvailableItem(item);
            list.add((Object)item);
        }
        TradeItem[] result = (TradeItem[])list.toArray((Object[])new TradeItem[list.size()]);
        FastList.recycle((FastList)list);
        return result;
    }

    public int getItemCount() {
        return this._items.size();
    }

    public TradeItem adjustAvailableItem(L2ItemInstance item) {
        if (item.isStackable()) {
            for (TradeItem exclItem : this._items) {
                if (exclItem.getItem().getItemId() != item.getItemId()) continue;
                if (item.getCount() <= exclItem.getCount()) {
                    return null;
                }
                return new TradeItem(item, item.getCount() - exclItem.getCount(), (long)item.getReferencePrice());
            }
        }
        return new TradeItem(item, item.getCount(), (long)item.getReferencePrice());
    }

    public void adjustItemRequest(ItemRequest item) {
        for (TradeItem filtItem : this._items) {
            if (filtItem.getObjectId() != item.getObjectId()) continue;
            if (filtItem.getCount() < item.getCount()) {
                item.setCount(filtItem.getCount());
            }
            return;
        }
        item.setCount(0L);
    }

    public synchronized TradeItem addItem(int objectId, long count) {
        return this.addItem(objectId, count, 0L);
    }

    public synchronized TradeItem addItem(int objectId, long count, long price) {
        if (this.isLocked()) {
            _log.warning(this._owner.getName() + ": Attempt to modify locked TradeList!");
            return null;
        }
        L2Object o = L2World.getInstance().findObject(objectId);
        if (!(o instanceof L2ItemInstance)) {
            _log.warning(this._owner.getName() + ": Attempt to add invalid item to TradeList!");
            return null;
        }
        L2ItemInstance item = (L2ItemInstance)o;
        if (!((item.isTradeable() || this.getOwner().isGM() && Config.GM_TRADE_RESTRICTED_ITEMS) && item.getItemType() != L2EtcItemType.QUEST)) {
            return null;
        }
        if (count <= 0L || count > item.getCount()) {
            return null;
        }
        if (!item.isStackable() && count > 1L) {
            _log.warning(this._owner.getName() + ": Attempt to add non-stackable item to TradeList with count > 1!");
            return null;
        }
        if (99900000000L / count < price) {
            _log.warning(this._owner.getName() + ": Attempt to overflow adena !");
            return null;
        }
        for (TradeItem checkitem : this._items) {
            if (checkitem.getObjectId() != objectId) continue;
            return null;
        }
        TradeItem titem = new TradeItem(item, count, price);
        this._items.add(titem);
        this.invalidateConfirmation();
        return titem;
    }

    public synchronized TradeItem addItemByItemId(int itemId, long count, long price) {
        if (this.isLocked()) {
            _log.warning(this._owner.getName() + ": Attempt to modify locked TradeList!");
            return null;
        }
        L2Item item = ItemTable.getInstance().getTemplate(itemId);
        if (item == null) {
            _log.warning(this._owner.getName() + ": Attempt to add invalid item to TradeList!");
            return null;
        }
        if (!item.isTradeable() || item.getItemType() == L2EtcItemType.QUEST) {
            return null;
        }
        if (!item.isStackable() && count > 1L) {
            _log.warning(this._owner.getName() + ": Attempt to add non-stackable item to TradeList with count > 1!");
            return null;
        }
        if (99900000000L / count < price) {
            _log.warning(this._owner.getName() + ": Attempt to overflow adena !");
            return null;
        }
        TradeItem titem = new TradeItem(item, count, price);
        this._items.add(titem);
        this.invalidateConfirmation();
        return titem;
    }

    public synchronized TradeItem removeItem(int objectId, int itemId, long count) {
        if (this.isLocked()) {
            _log.warning(this._owner.getName() + ": Attempt to modify locked TradeList!");
            return null;
        }
        for (TradeItem titem : this._items) {
            if (titem.getObjectId() != objectId && titem.getItem().getItemId() != itemId) continue;
            if (this._partner != null) {
                TradeList partnerList = this._partner.getActiveTradeList();
                if (partnerList == null) {
                    _log.warning(this._partner.getName() + ": Trading partner (" + this._partner.getName() + ") is invalid in this trade!");
                    return null;
                }
                partnerList.invalidateConfirmation();
            }
            if (count != -1L && titem.getCount() > count) {
                titem.setCount(titem.getCount() - count);
            } else {
                this._items.remove(titem);
            }
            return titem;
        }
        return null;
    }

    public synchronized void updateItems() {
        for (TradeItem titem : this._items) {
            L2ItemInstance item = this._owner.getInventory().getItemByObjectId(titem.getObjectId());
            if (item == null || titem.getCount() < 1L) {
                this.removeItem(titem.getObjectId(), -1, -1L);
                continue;
            }
            if (item.getCount() >= titem.getCount()) continue;
            titem.setCount(item.getCount());
        }
    }

    public void lock() {
        this._locked = true;
    }

    public synchronized void clear() {
        this._items.clear();
        this._locked = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean confirm() {
        if (this._confirmed) {
            return true;
        }
        if (this._partner != null) {
            TradeList sync2;
            TradeList sync1;
            TradeList partnerList = this._partner.getActiveTradeList();
            if (partnerList == null) {
                _log.warning(this._partner.getName() + ": Trading partner (" + this._partner.getName() + ") is invalid in this trade!");
                return false;
            }
            if (this.getOwner().getObjectId() > partnerList.getOwner().getObjectId()) {
                sync1 = partnerList;
                sync2 = this;
            } else {
                sync1 = this;
                sync2 = partnerList;
            }
            TradeList tradeList = sync1;
            synchronized (tradeList) {
                TradeList tradeList2 = sync2;
                synchronized (tradeList2) {
                    this._confirmed = true;
                    if (partnerList.isConfirmed()) {
                        partnerList.lock();
                        this.lock();
                        if (!partnerList.validate()) {
                            return false;
                        }
                        if (!this.validate()) {
                            return false;
                        }
                        this.doExchange(partnerList);
                    } else {
                        this._partner.onTradeConfirm(this._owner);
                    }
                }
            }
        }
        this._confirmed = true;
        return this._confirmed;
    }

    public void invalidateConfirmation() {
        this._confirmed = false;
    }

    private boolean validate() {
        if (this._owner == null || L2World.getInstance().getPlayer(this._owner.getObjectId()) == null) {
            _log.warning("Invalid owner of TradeList");
            return false;
        }
        for (TradeItem titem : this._items) {
            L2ItemInstance item = this._owner.checkItemManipulation(titem.getObjectId(), titem.getCount(), "transfer");
            if (item != null && item.getCount() >= 1L) continue;
            _log.warning(this._owner.getName() + ": Invalid Item in TradeList");
            return false;
        }
        return true;
    }

    private boolean TransferItems(L2PcInstance partner, InventoryUpdate ownerIU, InventoryUpdate partnerIU) {
        for (TradeItem titem : this._items) {
            L2ItemInstance oldItem = this._owner.getInventory().getItemByObjectId(titem.getObjectId());
            if (oldItem == null) {
                return false;
            }
            L2ItemInstance newItem = this._owner.getInventory().transferItem("Trade", titem.getObjectId(), titem.getCount(), partner.getInventory(), this._owner, this._partner);
            if (newItem == null) {
                return false;
            }
            if (ownerIU != null) {
                if (oldItem.getCount() > 0L && oldItem != newItem) {
                    ownerIU.addModifiedItem(oldItem);
                } else {
                    ownerIU.addRemovedItem(oldItem);
                }
            }
            if (partnerIU == null) continue;
            if (newItem.getCount() > titem.getCount()) {
                partnerIU.addModifiedItem(newItem);
                continue;
            }
            partnerIU.addNewItem(newItem);
        }
        return true;
    }

    public int countItemsSlots(L2PcInstance partner) {
        int slots = 0;
        for (TradeItem item : this._items) {
            L2Item template;
            if (item == null || (template = ItemTable.getInstance().getTemplate(item.getItem().getItemId())) == null) continue;
            if (!template.isStackable()) {
                slots = (int)((long)slots + item.getCount());
                continue;
            }
            if (partner.getInventory().getItemByItemId(item.getItem().getItemId()) != null) continue;
            ++slots;
        }
        return slots;
    }

    public int calcItemsWeight() {
        long weight = 0L;
        for (TradeItem item : this._items) {
            L2Item template;
            if (item == null || (template = ItemTable.getInstance().getTemplate(item.getItem().getItemId())) == null) continue;
            weight += item.getCount() * (long)template.getWeight();
        }
        return (int)Math.min(weight, Integer.MAX_VALUE);
    }

    private void doExchange(TradeList partnerList) {
        boolean success = false;
        if (!this.getOwner().getInventory().validateWeight(partnerList.calcItemsWeight()) || !partnerList.getOwner().getInventory().validateWeight(this.calcItemsWeight())) {
            partnerList.getOwner().sendPacket(new SystemMessage(SystemMessageId.WEIGHT_LIMIT_EXCEEDED));
            this.getOwner().sendPacket(new SystemMessage(SystemMessageId.WEIGHT_LIMIT_EXCEEDED));
        } else if (!this.getOwner().getInventory().validateCapacity(partnerList.countItemsSlots(this.getOwner())) || !partnerList.getOwner().getInventory().validateCapacity(this.countItemsSlots(partnerList.getOwner()))) {
            partnerList.getOwner().sendPacket(new SystemMessage(SystemMessageId.SLOTS_FULL));
            this.getOwner().sendPacket(new SystemMessage(SystemMessageId.SLOTS_FULL));
        } else {
            InventoryUpdate ownerIU = Config.FORCE_INVENTORY_UPDATE ? null : new InventoryUpdate();
            InventoryUpdate partnerIU = Config.FORCE_INVENTORY_UPDATE ? null : new InventoryUpdate();
            partnerList.TransferItems(this.getOwner(), partnerIU, ownerIU);
            this.TransferItems(partnerList.getOwner(), ownerIU, partnerIU);
            if (ownerIU != null) {
                this._owner.sendPacket(ownerIU);
            } else {
                this._owner.sendPacket(new ItemList(this._owner, false));
            }
            if (partnerIU != null) {
                this._partner.sendPacket(partnerIU);
            } else {
                this._partner.sendPacket(new ItemList(this._partner, false));
            }
            StatusUpdate playerSU = new StatusUpdate(this._owner.getObjectId());
            playerSU.addAttribute(14, this._owner.getCurrentLoad());
            this._owner.sendPacket(playerSU);
            playerSU = new StatusUpdate(this._partner.getObjectId());
            playerSU.addAttribute(14, this._partner.getCurrentLoad());
            this._partner.sendPacket(playerSU);
            success = true;
        }
        partnerList.getOwner().onTradeFinish(success);
        this.getOwner().onTradeFinish(success);
    }

    public synchronized boolean privateStoreBuy(L2PcInstance player, FastSet<ItemRequest> items) {
        if (this._locked) {
            return false;
        }
        if (!this.validate()) {
            this.lock();
            return false;
        }
        int slots = 0;
        int weight = 0;
        long totalPrice = 0L;
        PcInventory ownerInventory = this._owner.getInventory();
        PcInventory playerInventory = player.getInventory();
        for (ItemRequest item : items) {
            boolean found = false;
            for (TradeItem ti : this._items) {
                if (ti.getObjectId() != item.getObjectId()) continue;
                if (ti.getPrice() != item.getPrice()) break;
                if (ti.getCount() < item.getCount()) {
                    item.setCount(ti.getCount());
                }
                found = true;
                break;
            }
            if (!found) {
                if (this.isPackaged()) {
                    Util.handleIllegalPlayerAction(player, "[TradeList.privateStoreBuy()] Player " + player.getName() + " tried to cheat the package sell and buy only a part of the package! Ban this player for bot usage!", Config.DEFAULT_PUNISH);
                    return false;
                }
                item.setCount(0L);
                continue;
            }
            if (99900000000L / item.getCount() < item.getPrice()) {
                this.lock();
                return false;
            }
            if (99900000000L < (totalPrice += item.getCount() * item.getPrice()) || totalPrice < 0L) {
                this.lock();
                return false;
            }
            L2ItemInstance oldItem = this._owner.checkItemManipulation(item.getObjectId(), item.getCount(), "sell");
            if (oldItem == null || !oldItem.isTradeable()) {
                this.lock();
                return false;
            }
            L2Item template = ItemTable.getInstance().getTemplate(item.getItemId());
            if (template == null) continue;
            weight = (int)((long)weight + item.getCount() * (long)template.getWeight());
            if (!template.isStackable()) {
                slots = (int)((long)slots + item.getCount());
                continue;
            }
            if (playerInventory.getItemByItemId(item.getItemId()) != null) continue;
            ++slots;
        }
        if (totalPrice > playerInventory.getAdena()) {
            player.sendPacket(new SystemMessage(SystemMessageId.YOU_NOT_ENOUGH_ADENA));
            return false;
        }
        if (!playerInventory.validateWeight(weight)) {
            player.sendPacket(new SystemMessage(SystemMessageId.WEIGHT_LIMIT_EXCEEDED));
            return false;
        }
        if (!playerInventory.validateCapacity(slots)) {
            player.sendPacket(new SystemMessage(SystemMessageId.SLOTS_FULL));
            return false;
        }
        InventoryUpdate ownerIU = new InventoryUpdate();
        InventoryUpdate playerIU = new InventoryUpdate();
        L2ItemInstance adenaItem = playerInventory.getAdenaInstance();
        playerInventory.reduceAdena("PrivateStore", totalPrice, player, this._owner);
        playerIU.addItem(adenaItem);
        ownerInventory.addAdena("PrivateStore", totalPrice, this._owner, player);
        ownerIU.addItem(ownerInventory.getAdenaInstance());
        boolean ok = true;
        for (ItemRequest item : items) {
            SystemMessage msg;
            if (item.getCount() == 0L) continue;
            L2ItemInstance oldItem = this._owner.checkItemManipulation(item.getObjectId(), item.getCount(), "sell");
            if (oldItem == null) {
                this.lock();
                ok = false;
                break;
            }
            L2ItemInstance newItem = ownerInventory.transferItem("PrivateStore", item.getObjectId(), item.getCount(), playerInventory, this._owner, player);
            if (newItem == null) {
                ok = false;
                break;
            }
            this.removeItem(item.getObjectId(), -1, item.getCount());
            if (oldItem.getCount() > 0L && oldItem != newItem) {
                ownerIU.addModifiedItem(oldItem);
            } else {
                ownerIU.addRemovedItem(oldItem);
            }
            if (newItem.getCount() > item.getCount()) {
                playerIU.addModifiedItem(newItem);
            } else {
                playerIU.addNewItem(newItem);
            }
            if (newItem.isStackable()) {
                msg = new SystemMessage(SystemMessageId.C1_PURCHASED_S3_S2_S);
                msg.addString(player.getName());
                msg.addItemName(newItem);
                msg.addItemNumber(item.getCount());
                this._owner.sendPacket(msg);
                msg = new SystemMessage(SystemMessageId.PURCHASED_S3_S2_S_FROM_C1);
                msg.addString(this._owner.getName());
                msg.addItemName(newItem);
                msg.addItemNumber(item.getCount());
                player.sendPacket(msg);
                continue;
            }
            msg = new SystemMessage(SystemMessageId.C1_PURCHASED_S2);
            msg.addString(player.getName());
            msg.addItemName(newItem);
            this._owner.sendPacket(msg);
            msg = new SystemMessage(SystemMessageId.PURCHASED_S2_FROM_C1);
            msg.addString(this._owner.getName());
            msg.addItemName(newItem);
            player.sendPacket(msg);
        }
        this._owner.sendPacket(ownerIU);
        player.sendPacket(playerIU);
        return ok;
    }

    public synchronized boolean privateStoreSell(L2PcInstance player, ItemRequest[] items) {
        if (this._locked) {
            return false;
        }
        boolean ok = false;
        PcInventory ownerInventory = this._owner.getInventory();
        PcInventory playerInventory = player.getInventory();
        InventoryUpdate ownerIU = new InventoryUpdate();
        InventoryUpdate playerIU = new InventoryUpdate();
        long totalPrice = 0L;
        for (ItemRequest item : items) {
            SystemMessage msg;
            L2ItemInstance newItem;
            int objectId;
            L2ItemInstance oldItem;
            boolean found = false;
            for (TradeItem ti : this._items) {
                if (ti.getItem().getItemId() != item.getItemId()) continue;
                if (ti.getPrice() != item.getPrice()) break;
                if (ti.getCount() < item.getCount()) {
                    item.setCount(ti.getCount());
                }
                found = item.getCount() > 0L;
                break;
            }
            if (!found) continue;
            if (99900000000L / item.getCount() < item.getPrice()) {
                this.lock();
                break;
            }
            long _totalPrice = totalPrice + item.getCount() * item.getPrice();
            if (99900000000L < _totalPrice || _totalPrice < 0L) {
                this.lock();
                break;
            }
            if (ownerInventory.getAdena() < _totalPrice || (oldItem = player.checkItemManipulation(objectId = item.getObjectId(), item.getCount(), "sell")) == null && ((oldItem = playerInventory.getItemByItemId(item.getItemId())) == null || (oldItem = player.checkItemManipulation(objectId = oldItem.getObjectId(), item.getCount(), "sell")) == null) || !oldItem.isTradeable() || (newItem = playerInventory.transferItem("PrivateStore", objectId, item.getCount(), ownerInventory, player, this._owner)) == null) continue;
            this.removeItem(-1, item.getItemId(), item.getCount());
            ok = true;
            totalPrice = _totalPrice;
            if (oldItem.getCount() > 0L && oldItem != newItem) {
                playerIU.addModifiedItem(oldItem);
            } else {
                playerIU.addRemovedItem(oldItem);
            }
            if (newItem.getCount() > item.getCount()) {
                ownerIU.addModifiedItem(newItem);
            } else {
                ownerIU.addNewItem(newItem);
            }
            if (newItem.isStackable()) {
                msg = new SystemMessage(SystemMessageId.PURCHASED_S3_S2_S_FROM_C1);
                msg.addString(player.getName());
                msg.addItemName(newItem);
                msg.addItemNumber(item.getCount());
                this._owner.sendPacket(msg);
                msg = new SystemMessage(SystemMessageId.C1_PURCHASED_S3_S2_S);
                msg.addString(this._owner.getName());
                msg.addItemName(newItem);
                msg.addItemNumber(item.getCount());
                player.sendPacket(msg);
                continue;
            }
            msg = new SystemMessage(SystemMessageId.PURCHASED_S2_FROM_C1);
            msg.addString(player.getName());
            msg.addItemName(newItem);
            this._owner.sendPacket(msg);
            msg = new SystemMessage(SystemMessageId.C1_PURCHASED_S2);
            msg.addString(this._owner.getName());
            msg.addItemName(newItem);
            player.sendPacket(msg);
        }
        if (totalPrice > 0L) {
            if (totalPrice > ownerInventory.getAdena()) {
                return false;
            }
            L2ItemInstance adenaItem = ownerInventory.getAdenaInstance();
            ownerInventory.reduceAdena("PrivateStore", totalPrice, this._owner, player);
            ownerIU.addItem(adenaItem);
            playerInventory.addAdena("PrivateStore", totalPrice, player, this._owner);
            playerIU.addItem(playerInventory.getAdenaInstance());
        }
        if (ok) {
            this._owner.sendPacket(ownerIU);
            player.sendPacket(playerIU);
        }
        return ok;
    }

    public class TradeItem {
        private int _objectId;
        private final L2Item _item;
        private int _enchant;
        private int _type2;
        private long _count;
        private long _storeCount;
        private long _price;
        private final byte _elemAtkType;
        private final int _elemAtkPower;
        private int[] _elemDefAttr = new int[]{0, 0, 0, 0, 0, 0};

        public TradeItem(L2ItemInstance item, long count, long price) {
            this._objectId = item.getObjectId();
            this._item = item.getItem();
            this._enchant = item.getEnchantLevel();
            this._type2 = item.getCustomType2();
            this._count = count;
            this._price = price;
            this._elemAtkType = item.getAttackElementType();
            this._elemAtkPower = item.getAttackElementPower();
            for (byte i = 0; i < 6; i = (byte)(i + 1)) {
                this._elemDefAttr[i] = item.getElementDefAttr(i);
            }
        }

        public TradeItem(L2Item item, long count, long price) {
            this._objectId = 0;
            this._item = item;
            this._enchant = 0;
            this._type2 = 0;
            this._count = count;
            this._storeCount = count;
            this._price = price;
            this._elemAtkType = (byte)-1;
            this._elemAtkPower = 0;
        }

        public TradeItem(TradeItem item, long count, long price) {
            this._objectId = item.getObjectId();
            this._item = item.getItem();
            this._enchant = item.getEnchant();
            this._type2 = 0;
            this._count = count;
            this._storeCount = count;
            this._price = price;
            this._elemAtkType = item.getAttackElementType();
            this._elemAtkPower = item.getAttackElementPower();
            for (byte i = 0; i < 6; i = (byte)(i + 1)) {
                this._elemDefAttr[i] = item.getElementDefAttr(i);
            }
        }

        public void setObjectId(int objectId) {
            this._objectId = objectId;
        }

        public int getObjectId() {
            return this._objectId;
        }

        public L2Item getItem() {
            return this._item;
        }

        public void setEnchant(int enchant) {
            this._enchant = enchant;
        }

        public int getEnchant() {
            return this._enchant;
        }

        public int getCustomType2() {
            return this._type2;
        }

        public void setCount(long count) {
            this._count = count;
        }

        public long getCount() {
            return this._count;
        }

        public long getStoreCount() {
            return this._storeCount;
        }

        public void setPrice(long price) {
            this._price = price;
        }

        public long getPrice() {
            return this._price;
        }

        public byte getAttackElementType() {
            return this._elemAtkType;
        }

        public int getAttackElementPower() {
            return this._elemAtkPower;
        }

        public int getElementDefAttr(byte i) {
            return this._elemDefAttr[i];
        }
    }
}

