/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor.instance;

import com.l2jserver.gameserver.instancemanager.AirShipManager;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.actor.instance.L2AirShipInstance;
import com.l2jserver.gameserver.model.actor.instance.L2NpcInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.NpcSay;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.templates.chars.L2NpcTemplate;

public class L2AirShipControllerInstance
extends L2NpcInstance {
    private L2AirShipInstance _ship = null;

    public L2AirShipControllerInstance(int objectId, L2NpcTemplate template) {
        super(objectId, template);
        this.setInstanceType(L2Object.InstanceType.L2AirShipControllerInstance);
        AirShipManager.getInstance().registerATC(this);
    }

    @Override
    public void onBypassFeedback(L2PcInstance player, String command) {
        if (command.equalsIgnoreCase("board")) {
            if (player.getPet() != null) {
                player.sendPacket(new SystemMessage(SystemMessageId.RELEASE_PET_ON_BOAT));
                return;
            }
            if (player.isTransformed()) {
                player.sendPacket(new SystemMessage(SystemMessageId.CANT_POLYMORPH_ON_BOAT));
                return;
            }
            if (player.isFlyingMounted()) {
                player.sendPacket(new SystemMessage(SystemMessageId.YOU_CANNOT_MOUNT_NOT_MEET_REQUEIREMENTS));
                return;
            }
            if (this._ship != null) {
                this._ship.addPassenger(player);
                return;
            }
        } else {
            super.onBypassFeedback(player, command);
        }
    }

    public void broadcastMessage(String message) {
        this.broadcastPacket(new NpcSay(this.getObjectId(), 1, this.getNpcId(), message));
    }

    public void dockShip(L2AirShipInstance ship) {
        this._ship = ship;
    }
}

