/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor.instance;

import com.l2jserver.gameserver.ai.L2AirShipAI;
import com.l2jserver.gameserver.model.L2CharPosition;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.Location;
import com.l2jserver.gameserver.model.actor.L2Vehicle;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.serverpackets.ExAirShipInfo;
import com.l2jserver.gameserver.network.serverpackets.ExGetOffAirShip;
import com.l2jserver.gameserver.network.serverpackets.ExGetOnAirShip;
import com.l2jserver.gameserver.network.serverpackets.ExMoveToLocationAirShip;
import com.l2jserver.gameserver.network.serverpackets.ExStopMoveAirShip;
import com.l2jserver.gameserver.templates.chars.L2CharTemplate;
import com.l2jserver.util.Point3D;
import java.util.logging.Logger;

public class L2AirShipInstance
extends L2Vehicle {
    protected static final Logger _airShiplog = Logger.getLogger(L2AirShipInstance.class.getName());

    public L2AirShipInstance(int objectId, L2CharTemplate template) {
        super(objectId, template);
        this.setInstanceType(L2Object.InstanceType.L2AirShipInstance);
        this.setAI(new L2AirShipAI(new L2Vehicle.AIAccessor()));
    }

    @Override
    public boolean isAirShip() {
        return true;
    }

    @Override
    public boolean moveToNextRoutePoint() {
        boolean result = super.moveToNextRoutePoint();
        if (result) {
            this.broadcastPacket(new ExMoveToLocationAirShip(this));
        }
        return result;
    }

    @Override
    public boolean addPassenger(L2PcInstance player) {
        if (!super.addPassenger(player)) {
            return false;
        }
        player.setVehicle(this);
        player.setInVehiclePosition(new Point3D(0, 0, 0));
        player.broadcastPacket(new ExGetOnAirShip(player, this));
        player.getKnownList().removeAllKnownObjects();
        player.setXYZ(this.getX(), this.getY(), this.getZ());
        player.revalidateZone(true);
        return true;
    }

    @Override
    public void oustPlayer(L2PcInstance player) {
        super.oustPlayer(player);
        Location loc = this.getOustLoc();
        if (player.isOnline() > 0) {
            player.broadcastPacket(new ExGetOffAirShip(player, this, loc.getX(), loc.getY(), loc.getZ()));
            player.getKnownList().removeAllKnownObjects();
            player.setXYZ(loc.getX(), loc.getY(), loc.getZ());
            player.revalidateZone(true);
        } else {
            player.setXYZInvisible(loc.getX(), loc.getY(), loc.getZ());
        }
    }

    @Override
    public void stopMove(L2CharPosition pos, boolean updateKnownObjects) {
        super.stopMove(pos, updateKnownObjects);
        this.broadcastPacket(new ExStopMoveAirShip(this));
    }

    @Override
    public void sendInfo(L2PcInstance activeChar) {
        activeChar.sendPacket(new ExAirShipInfo(this));
    }
}

