/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor.instance;

import com.l2jserver.gameserver.ai.L2BoatAI;
import com.l2jserver.gameserver.model.L2CharPosition;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.Location;
import com.l2jserver.gameserver.model.actor.L2Vehicle;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.serverpackets.VehicleDeparture;
import com.l2jserver.gameserver.network.serverpackets.VehicleInfo;
import com.l2jserver.gameserver.network.serverpackets.VehicleStarted;
import com.l2jserver.gameserver.templates.chars.L2CharTemplate;
import java.util.logging.Logger;

public class L2BoatInstance
extends L2Vehicle {
    protected static final Logger _logBoat = Logger.getLogger(L2BoatInstance.class.getName());

    public L2BoatInstance(int objectId, L2CharTemplate template) {
        super(objectId, template);
        this.setInstanceType(L2Object.InstanceType.L2BoatInstance);
        this.setAI(new L2BoatAI(new L2Vehicle.AIAccessor()));
    }

    @Override
    public boolean isBoat() {
        return true;
    }

    @Override
    public boolean moveToNextRoutePoint() {
        boolean result = super.moveToNextRoutePoint();
        if (result) {
            this.broadcastPacket(new VehicleDeparture(this));
        }
        return result;
    }

    @Override
    public void oustPlayer(L2PcInstance player) {
        super.oustPlayer(player);
        Location loc = this.getOustLoc();
        if (player.isOnline() > 0) {
            player.teleToLocation(loc.getX(), loc.getY(), loc.getZ());
        } else {
            player.setXYZInvisible(loc.getX(), loc.getY(), loc.getZ());
        }
    }

    @Override
    public void stopMove(L2CharPosition pos, boolean updateKnownObjects) {
        super.stopMove(pos, updateKnownObjects);
        this.broadcastPacket(new VehicleStarted(this, 0));
        this.broadcastPacket(new VehicleInfo(this));
    }

    @Override
    public void sendInfo(L2PcInstance activeChar) {
        activeChar.sendPacket(new VehicleInfo(this));
    }
}

