/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.entity;

import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.datatables.CharNameTable;
import com.l2jserver.gameserver.idfactory.IdFactory;
import com.l2jserver.gameserver.instancemanager.MailManager;
import com.l2jserver.gameserver.model.itemcontainer.Mail;
import com.l2jserver.util.Rnd;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.concurrent.ScheduledFuture;

public class Message {
    private static final int EXPIRATION = 360;
    private static final int COD_EXPIRATION = 12;
    private static final int UNLOAD_ATTACHMENTS_INTERVAL = 900000;
    public static final int DELETED = 0;
    public static final int READED = 1;
    public static final int REJECTED = 2;
    private final int _messageId;
    private final int _senderId;
    private final int _receiverId;
    private final long _expiration;
    private String _senderName = null;
    private String _receiverName = null;
    private final String _subject;
    private final String _content;
    private boolean _unread;
    private boolean _fourStars;
    private boolean _news;
    private boolean _deletedBySender;
    private boolean _deletedByReceiver;
    private long _reqAdena;
    private boolean _hasAttachments;
    private Mail _attachments = null;
    private ScheduledFuture<?> _unloadTask = null;

    public Message(ResultSet rset) throws SQLException {
        this._messageId = rset.getInt("messageId");
        this._senderId = rset.getInt("senderId");
        this._receiverId = rset.getInt("receiverId");
        this._subject = rset.getString("subject");
        this._content = rset.getString("content");
        this._expiration = rset.getLong("expiration");
        this._reqAdena = rset.getLong("reqAdena");
        this._hasAttachments = rset.getBoolean("hasAttachments");
        this._unread = rset.getBoolean("isUnread");
        this._deletedBySender = rset.getBoolean("isDeletedBySender");
        this._deletedByReceiver = rset.getBoolean("isDeletedByReceiver");
        this._fourStars = rset.getBoolean("isFourStars");
        this._news = rset.getBoolean("isNews");
    }

    public Message(int senderId, int receiverId, boolean isCod, String subject, String text, long reqAdena) {
        this._messageId = IdFactory.getInstance().getNextId();
        this._senderId = senderId;
        this._receiverId = receiverId;
        this._subject = subject;
        this._content = text;
        this._expiration = isCod ? System.currentTimeMillis() + 43200000L : System.currentTimeMillis() + 1296000000L;
        this._hasAttachments = false;
        this._unread = true;
        this._deletedBySender = false;
        this._deletedByReceiver = false;
        this._reqAdena = reqAdena;
    }

    public Message(Message msg) {
        this._messageId = IdFactory.getInstance().getNextId();
        this._senderId = msg.getSenderId();
        this._receiverId = msg.getSenderId();
        this._subject = "";
        this._content = "";
        this._expiration = System.currentTimeMillis() + 1296000000L;
        this._unread = true;
        this._deletedBySender = true;
        this._deletedByReceiver = false;
        this._fourStars = true;
        this._reqAdena = 0L;
        this._hasAttachments = true;
        this._attachments = msg.getAttachments();
        msg.removeAttachments();
        this._attachments.setNewMessageId(this._messageId);
        this._unloadTask = ThreadPoolManager.getInstance().scheduleGeneral(new AttachmentsUnloadTask(this), 900000 + Rnd.get(900000));
    }

    public static final PreparedStatement getStatement(Message msg, Connection con) throws SQLException {
        PreparedStatement stmt = con.prepareStatement("INSERT INTO messages (messageId, senderId, receiverId, subject, content, expiration, reqAdena, hasAttachments, isUnread, isDeletedBySender, isDeletedByReceiver, isFourStars, isNews) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
        stmt.setInt(1, msg._messageId);
        stmt.setInt(2, msg._senderId);
        stmt.setInt(3, msg._receiverId);
        stmt.setString(4, msg._subject);
        stmt.setString(5, msg._content);
        stmt.setLong(6, msg._expiration);
        stmt.setLong(7, msg._reqAdena);
        stmt.setString(8, String.valueOf(msg._hasAttachments));
        stmt.setString(9, String.valueOf(msg._unread));
        stmt.setString(10, String.valueOf(msg._deletedBySender));
        stmt.setString(11, String.valueOf(msg._deletedByReceiver));
        stmt.setString(12, String.valueOf(msg._fourStars));
        stmt.setString(13, String.valueOf(msg._news));
        return stmt;
    }

    public final int getId() {
        return this._messageId;
    }

    public final int getSenderId() {
        return this._senderId;
    }

    public final int getReceiverId() {
        return this._receiverId;
    }

    public final String getSenderName() {
        if (this._senderName == null) {
            if (this._fourStars) {
                return "****";
            }
            this._senderName = CharNameTable.getInstance().getNameById(this._senderId);
            if (this._senderName == null) {
                this._senderName = "";
            }
        }
        return this._senderName;
    }

    public final String getReceiverName() {
        if (this._receiverName == null) {
            this._receiverName = CharNameTable.getInstance().getNameById(this._receiverId);
            if (this._receiverName == null) {
                this._receiverName = "";
            }
        }
        return this._receiverName;
    }

    public final String getSubject() {
        return this._subject;
    }

    public final String getContent() {
        return this._content;
    }

    public final boolean isLocked() {
        return this._reqAdena > 0L;
    }

    public final long getExpiration() {
        return this._expiration;
    }

    public final int getExpirationSeconds() {
        return (int)(this._expiration / 1000L);
    }

    public final boolean isUnread() {
        return this._unread;
    }

    public final void markAsRead() {
        if (this._unread) {
            this._unread = false;
            MailManager.getInstance().markAsReadInDb(this._messageId);
        }
    }

    public final boolean isDeletedBySender() {
        return this._deletedBySender;
    }

    public final void setDeletedBySender() {
        if (!this._deletedBySender) {
            this._deletedBySender = true;
            if (this._deletedByReceiver) {
                MailManager.getInstance().deleteMessageInDb(this._messageId);
            } else {
                MailManager.getInstance().markAsDeletedBySenderInDb(this._messageId);
            }
        }
    }

    public final boolean isDeletedByReceiver() {
        return this._deletedByReceiver;
    }

    public final void setDeletedByReceiver() {
        if (!this._deletedByReceiver) {
            this._deletedByReceiver = true;
            if (this._deletedBySender) {
                MailManager.getInstance().deleteMessageInDb(this._messageId);
            } else {
                MailManager.getInstance().markAsDeletedByReceiverInDb(this._messageId);
            }
        }
    }

    public final boolean isFourStars() {
        return this._fourStars;
    }

    public final boolean isNews() {
        return this._news;
    }

    public final void setIsNews(boolean val) {
        this._news = val;
    }

    public final long getReqAdena() {
        return this._reqAdena;
    }

    public final synchronized Mail getAttachments() {
        if (!this._hasAttachments) {
            return null;
        }
        if (this._attachments == null) {
            this._attachments = new Mail(this._senderId, this._messageId);
            this._attachments.restore();
            this._unloadTask = ThreadPoolManager.getInstance().scheduleGeneral(new AttachmentsUnloadTask(this), 900000 + Rnd.get(900000));
        }
        return this._attachments;
    }

    public final boolean hasAttachments() {
        return this._hasAttachments;
    }

    public final synchronized void removeAttachments() {
        if (this._attachments != null) {
            this._attachments = null;
            this._hasAttachments = false;
            MailManager.getInstance().removeAttachmentsInDb(this._messageId);
            if (this._unloadTask != null) {
                this._unloadTask.cancel(false);
            }
        }
    }

    public final synchronized Mail createAttachments() {
        if (this._hasAttachments || this._attachments != null) {
            return null;
        }
        this._attachments = new Mail(this._senderId, this._messageId);
        this._hasAttachments = true;
        this._unloadTask = ThreadPoolManager.getInstance().scheduleGeneral(new AttachmentsUnloadTask(this), 900000 + Rnd.get(900000));
        return this._attachments;
    }

    protected final synchronized void unloadAttachments() {
        if (this._attachments != null) {
            this._attachments.deleteMe();
            this._attachments = null;
        }
    }

    class AttachmentsUnloadTask
    implements Runnable {
        private Message _msg;

        AttachmentsUnloadTask(Message msg) {
            this._msg = msg;
        }

        @Override
        public void run() {
            if (this._msg != null) {
                this._msg.unloadAttachments();
                this._msg = null;
            }
        }
    }
}

