/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.Config;
import com.l2jserver.gameserver.handler.ChatHandler;
import com.l2jserver.gameserver.handler.IChatHandler;
import com.l2jserver.gameserver.model.L2ItemInstance;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.util.Util;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public final class Say2
extends L2GameClientPacket {
    private static final String _C__38_SAY2 = "[C] 38 Say2";
    private static Logger _log = Logger.getLogger(Say2.class.getName());
    private static Logger _logChat = Logger.getLogger("chat");
    public static final int ALL = 0;
    public static final int SHOUT = 1;
    public static final int TELL = 2;
    public static final int PARTY = 3;
    public static final int CLAN = 4;
    public static final int GM = 5;
    public static final int PETITION_PLAYER = 6;
    public static final int PETITION_GM = 7;
    public static final int TRADE = 8;
    public static final int ALLIANCE = 9;
    public static final int ANNOUNCEMENT = 10;
    public static final int BOAT = 11;
    public static final int L2FRIEND = 12;
    public static final int MSNCHAT = 13;
    public static final int PARTYMATCH_ROOM = 14;
    public static final int PARTYROOM_COMMANDER = 15;
    public static final int PARTYROOM_ALL = 16;
    public static final int HERO_VOICE = 17;
    public static final int CRITICAL_ANNOUNCE = 18;
    public static final int SCREEN_ANNOUNCE = 19;
    public static final int BATTLEFIELD = 20;
    public static final int MPCC_ROOM = 21;
    private static final String[] CHAT_NAMES = new String[]{"ALL", "SHOUT", "TELL", "PARTY", "CLAN", "GM", "PETITION_PLAYER", "PETITION_GM", "TRADE", "ALLIANCE", "ANNOUNCEMENT", "BOAT", "L2FRIEND", "MSNCHAT", "PARTYMATCH_ROOM", "PARTYROOM_COMMANDER", "PARTYROOM_ALL", "HERO_VOICE", "CRITICAL_ANNOUNCE", "SCREEN_ANNOUNCE", "BATTLEFIELD", "MPCC_ROOM"};
    private static final String[] WALKER_COMMAND_LIST = new String[]{"USESKILL", "USEITEM", "BUYITEM", "SELLITEM", "SAVEITEM", "LOADITEM", "MSG", "SET", "DELAY", "LABEL", "JMP", "CALL", "RETURN", "MOVETO", "NPCSEL", "NPCDLG", "DLGSEL", "CHARSTATUS", "POSOUTRANGE", "POSINRANGE", "GOHOME", "SAY", "EXIT", "PAUSE", "STRINDLG", "STRNOTINDLG", "CHANGEWAITTYPE", "FORCEATTACK", "ISMEMBER", "REQUESTJOINPARTY", "REQUESTOUTPARTY", "QUITPARTY", "MEMBERSTATUS", "CHARBUFFS", "ITEMCOUNT", "FOLLOWTELEPORT"};
    private String _text;
    private int _type;
    private String _target;

    @Override
    protected void readImpl() {
        this._text = this.readS();
        this._type = this.readD();
        this._target = this._type == 2 ? this.readS() : null;
    }

    @Override
    protected void runImpl() {
        IChatHandler handler;
        L2PcInstance activeChar;
        if (Config.DEBUG) {
            _log.info("Say2: Msg Type = '" + this._type + "' Text = '" + this._text + "'.");
        }
        if ((activeChar = ((L2GameClient)this.getClient()).getActiveChar()) == null) {
            return;
        }
        if (this._type < 0 || this._type >= CHAT_NAMES.length) {
            _log.warning("Say2: Invalid type: " + this._type + " Player : " + activeChar.getName() + " text: " + this._text);
            return;
        }
        if (this._text.isEmpty()) {
            _log.warning(activeChar.getName() + ": sending empty text. Possible packet hack!");
            return;
        }
        if (this._text.length() > 105 && !activeChar.isGM()) {
            activeChar.sendPacket(new SystemMessage(SystemMessageId.DONT_SPAM));
            return;
        }
        if (Config.L2WALKER_PROTECTION && this._type == 2 && this.checkBot(this._text)) {
            Util.handleIllegalPlayerAction(activeChar, "Client Emulator Detect: Player " + activeChar.getName() + " using l2walker.", Config.DEFAULT_PUNISH);
            return;
        }
        if (activeChar.isCursedWeaponEquipped() && (this._type == 8 || this._type == 1)) {
            activeChar.sendPacket(new SystemMessage(SystemMessageId.SHOUT_AND_TRADE_CHAT_CANNOT_BE_USED_WHILE_POSSESSING_CURSED_WEAPON));
            return;
        }
        if (activeChar.isChatBanned() && (this._type == 0 || this._type == 1 || this._type == 8 || this._type == 17)) {
            activeChar.sendPacket(new SystemMessage(SystemMessageId.CHATTING_IS_CURRENTLY_PROHIBITED));
            return;
        }
        if (activeChar.isInJail() && Config.JAIL_DISABLE_CHAT && (this._type == 2 || this._type == 1 || this._type == 8 || this._type == 17)) {
            activeChar.sendMessage("You can not chat with players outside of the jail.");
            return;
        }
        if (this._type == 6 && activeChar.isGM()) {
            this._type = 7;
        }
        if (Config.LOG_CHAT) {
            LogRecord record = new LogRecord(Level.INFO, this._text);
            record.setLoggerName("chat");
            if (this._type == 2) {
                record.setParameters(new Object[]{CHAT_NAMES[this._type], "[" + activeChar.getName() + " to " + this._target + "]"});
            } else {
                record.setParameters(new Object[]{CHAT_NAMES[this._type], "[" + activeChar.getName() + "]"});
            }
            _logChat.log(record);
        }
        if (this._text.indexOf(8) >= 0 && !this.parseAndPublishItem(activeChar)) {
            return;
        }
        if (Config.USE_SAY_FILTER) {
            this.checkText();
        }
        if ((handler = ChatHandler.getInstance().getChatHandler(this._type)) != null) {
            handler.handleChat(this._type, activeChar, this._target, this._text);
        }
    }

    private boolean checkBot(String text) {
        for (String botCommand : WALKER_COMMAND_LIST) {
            if (!text.startsWith(botCommand)) continue;
            return true;
        }
        return false;
    }

    private void checkText() {
        String filteredText = this._text;
        for (String pattern : Config.FILTER_LIST) {
            filteredText = filteredText.replaceAll("(?i)" + pattern, Config.CHAT_FILTER_CHARS);
        }
        this._text = filteredText;
    }

    private boolean parseAndPublishItem(L2PcInstance owner) {
        int pos1 = -1;
        while ((pos1 = this._text.indexOf(8, pos1)) > -1) {
            int pos = this._text.indexOf("ID=", pos1);
            if (pos == -1) {
                return false;
            }
            StringBuilder result = new StringBuilder(9);
            pos += 3;
            while (Character.isDigit(this._text.charAt(pos))) {
                result.append(this._text.charAt(pos++));
            }
            int id = Integer.parseInt(result.toString());
            L2Object item = L2World.getInstance().findObject(id);
            if (item instanceof L2ItemInstance) {
                if (owner.getInventory().getItemByObjectId(id) == null) {
                    _log.info(this.getClient() + " trying publish item which doesnt own! ID:" + id);
                    return false;
                }
            } else {
                _log.info(this.getClient() + " trying publish object which is not item! ID:" + id);
                return false;
            }
            ((L2ItemInstance)item).publish();
            pos1 = this._text.indexOf(8, pos) + 1;
            if (pos1 != 0) continue;
            _log.info(this.getClient() + " sent invalid publish item msg! ID:" + id);
            return false;
        }
        return true;
    }

    @Override
    public String getType() {
        return _C__38_SAY2;
    }
}

