/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.script;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class DateRange {
    private Date _startDate;
    private Date _endDate;
    private static SimpleDateFormat format_JP = new SimpleDateFormat("yyyy/MM/dd", Locale.JAPAN);

    public DateRange(Date from, Date to) {
        this._startDate = from;
        this._endDate = to;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DateRange parse(String dateRange, DateFormat format) {
        String[] date = dateRange.split("-");
        if (date.length == 2) {
            if (date[0].matches("\\d{4}/\\d{1,2}/\\d{1,2}")) {
                format = format_JP;
            }
            try {
                DateFormat dateFormat = format;
                synchronized (dateFormat) {
                    Date start = format.parse(date[0]);
                    Date end = format.parse(date[1]);
                    return new DateRange(start, end);
                }
            }
            catch (ParseException e) {
                System.err.println("Invalid Date Format.");
                e.printStackTrace();
            }
        }
        return new DateRange(null, null);
    }

    public boolean isValid() {
        return this._startDate != null && this._endDate != null;
    }

    public boolean isWithinRange(Date date) {
        return date.after(this._startDate) && date.before(this._endDate);
    }

    public Date getEndDate() {
        return this._endDate;
    }

    public Date getStartDate() {
        return this._startDate;
    }
}

