/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.script.faenor;

import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.script.DateRange;
import com.l2jserver.gameserver.script.IntList;
import com.l2jserver.gameserver.script.Parser;
import com.l2jserver.gameserver.script.ParserFactory;
import com.l2jserver.gameserver.script.ScriptEngine;
import com.l2jserver.gameserver.script.faenor.FaenorParser;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.script.ScriptContext;
import org.w3c.dom.Node;

public class FaenorEventParser
extends FaenorParser {
    static Logger _log = Logger.getLogger(FaenorEventParser.class.getName());
    private DateRange _eventDates = null;

    @Override
    public void parseScript(final Node eventNode, ScriptContext context) {
        String ID = FaenorEventParser.attribute(eventNode, "ID");
        _log.fine("Parsing Event \"" + ID + "\"");
        this._eventDates = DateRange.parse(FaenorEventParser.attribute(eventNode, "Active"), DATE_FORMAT);
        Date currentDate = new Date();
        if (this._eventDates.getEndDate().before(currentDate)) {
            _log.info("Event ID: (" + ID + ") has passed... Ignored.");
            return;
        }
        if (this._eventDates.getStartDate().after(currentDate)) {
            _log.info("Event ID: (" + ID + ") is not active yet... Ignored.");
            ThreadPoolManager.getInstance().scheduleGeneral(new Runnable(){

                @Override
                public void run() {
                    FaenorEventParser.this.parseEventDropAndMessage(eventNode);
                }
            }, this._eventDates.getStartDate().getTime() - currentDate.getTime());
            return;
        }
        this.parseEventDropAndMessage(eventNode);
    }

    protected void parseEventDropAndMessage(Node eventNode) {
        for (Node node = eventNode.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (FaenorEventParser.isNodeName(node, "DropList")) {
                this.parseEventDropList(node);
                continue;
            }
            if (!FaenorEventParser.isNodeName(node, "Message")) continue;
            this.parseEventMessage(node);
        }
    }

    private void parseEventMessage(Node sysMsg) {
        _log.fine("Parsing Event Message.");
        try {
            String type = FaenorEventParser.attribute(sysMsg, "Type");
            String[] message = FaenorEventParser.attribute(sysMsg, "Msg").split("\n");
            if (type.equalsIgnoreCase("OnJoin")) {
                _bridge.onPlayerLogin(message, this._eventDates);
            }
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Error in event parser: " + e.getMessage(), e);
        }
    }

    private void parseEventDropList(Node dropList) {
        _log.fine("Parsing Droplist.");
        for (Node node = dropList.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!FaenorEventParser.isNodeName(node, "AllDrop")) continue;
            this.parseEventDrop(node);
        }
    }

    private void parseEventDrop(Node drop) {
        _log.fine("Parsing Drop.");
        try {
            int[] items = IntList.parse(FaenorEventParser.attribute(drop, "Items"));
            int[] count = IntList.parse(FaenorEventParser.attribute(drop, "Count"));
            double chance = FaenorEventParser.getPercent(FaenorEventParser.attribute(drop, "Chance"));
            _bridge.addEventDrop(items, count, chance, this._eventDates);
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "ERROR(parseEventDrop):" + e.getMessage(), e);
        }
    }

    static {
        ScriptEngine.parserFactories.put(FaenorEventParser.getParserName("Event"), new FaenorEventParserFactory());
    }

    static class FaenorEventParserFactory
    extends ParserFactory {
        FaenorEventParserFactory() {
        }

        @Override
        public Parser create() {
            return new FaenorEventParser();
        }
    }
}

