/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.templates.item;

import com.l2jserver.gameserver.datatables.SkillTable;
import com.l2jserver.gameserver.handler.ISkillHandler;
import com.l2jserver.gameserver.handler.SkillHandler;
import com.l2jserver.gameserver.model.L2Effect;
import com.l2jserver.gameserver.model.L2ItemInstance;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.L2Skill;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.quest.Quest;
import com.l2jserver.gameserver.skills.Env;
import com.l2jserver.gameserver.skills.Formulas;
import com.l2jserver.gameserver.skills.SkillHolder;
import com.l2jserver.gameserver.skills.conditions.Condition;
import com.l2jserver.gameserver.skills.conditions.ConditionGameChance;
import com.l2jserver.gameserver.skills.funcs.Func;
import com.l2jserver.gameserver.skills.funcs.FuncTemplate;
import com.l2jserver.gameserver.templates.StatsSet;
import com.l2jserver.gameserver.templates.item.L2Item;
import com.l2jserver.gameserver.templates.item.L2WeaponType;
import com.l2jserver.gameserver.templates.skills.L2SkillType;
import com.l2jserver.util.StringUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import javolution.util.FastList;

public final class L2Weapon
extends L2Item {
    private final int _soulShotCount;
    private final int _spiritShotCount;
    private final int _pDam;
    private final int _rndDam;
    private final int _critical;
    private final double _hitModifier;
    private final int _avoidModifier;
    private final int _shieldDef;
    private final double _shieldDefRate;
    private final int _atkSpeed;
    private final int _atkReuse;
    private final int _mpConsume;
    private final int _mDam;
    private L2Skill _enchant4Skill = null;
    private final int _changeWeaponId;
    private SkillHolder[] _skillHolder;
    protected L2Skill _skillsOnCast;
    protected Condition _skillsOnCastCondition;
    protected L2Skill _skillsOnCrit;
    protected Condition _skillsOnCritCondition;

    public L2Weapon(L2WeaponType type, StatsSet set) {
        super(type, set);
        L2Skill skill;
        this._soulShotCount = set.getInteger("soulshots");
        this._spiritShotCount = set.getInteger("spiritshots");
        this._pDam = set.getInteger("p_dam");
        this._rndDam = set.getInteger("rnd_dam");
        this._critical = set.getInteger("critical");
        this._hitModifier = set.getDouble("hit_modify");
        this._avoidModifier = set.getInteger("avoid_modify");
        this._shieldDef = set.getInteger("shield_def");
        this._shieldDefRate = set.getDouble("shield_def_rate");
        this._atkSpeed = set.getInteger("atk_speed");
        this._atkReuse = set.getInteger("atk_reuse", type == L2WeaponType.BOW ? 1500 : (type == L2WeaponType.CROSSBOW ? 1200 : 0));
        this._mpConsume = set.getInteger("mp_consume");
        this._mDam = set.getInteger("m_dam");
        String[] skills = set.getString("skill").split(";");
        this._skillHolder = new SkillHolder[skills.length];
        int iterator = 0;
        for (String st : skills) {
            String[] info = st.split("-");
            if (info == null || info.length != 2) continue;
            int id = 0;
            int level = 0;
            try {
                id = Integer.parseInt(info[0]);
                level = Integer.parseInt(info[1]);
            }
            catch (Exception nfe) {
                _log.info(StringUtil.concat("> Couldnt parse ", st, " in weapon skills!"));
                continue;
            }
            if (id <= 0 || level <= 0) continue;
            this._skillHolder[iterator] = new SkillHolder(id, level);
            iterator = (byte)(iterator + 1);
        }
        int sId = set.getInteger("enchant4_skill_id");
        int sLv = set.getInteger("enchant4_skill_lvl");
        if (sId > 0 && sLv > 0) {
            this._enchant4Skill = SkillTable.getInstance().getInfo(sId, sLv);
        }
        sId = set.getInteger("onCast_skill_id");
        sLv = set.getInteger("onCast_skill_lvl");
        int sCh = set.getInteger("onCast_skill_chance");
        if (sId > 0 && sLv > 0 && sCh > 0) {
            skill = SkillTable.getInstance().getInfo(sId, sLv);
            this.attachOnCast(skill, sCh);
        }
        sId = set.getInteger("onCrit_skill_id");
        sLv = set.getInteger("onCrit_skill_lvl");
        sCh = set.getInteger("onCrit_skill_chance");
        if (sId > 0 && sLv > 0 && sCh > 0) {
            skill = SkillTable.getInstance().getInfo(sId, sLv);
            this.attachOnCrit(skill, sCh);
        }
        this._changeWeaponId = set.getInteger("change_weaponId");
    }

    @Override
    public L2WeaponType getItemType() {
        return (L2WeaponType)this._type;
    }

    @Override
    public int getItemMask() {
        return this.getItemType().mask();
    }

    public int getSoulShotCount() {
        return this._soulShotCount;
    }

    public int getSpiritShotCount() {
        return this._spiritShotCount;
    }

    public int getPDamage() {
        return this._pDam;
    }

    public int getRandomDamage() {
        return this._rndDam;
    }

    public int getAttackSpeed() {
        return this._atkSpeed;
    }

    public int getAttackReuseDelay() {
        return this._atkReuse;
    }

    public int getAvoidModifier() {
        return this._avoidModifier;
    }

    public int getCritical() {
        return this._critical;
    }

    public double getHitModifier() {
        return this._hitModifier;
    }

    public int getMDamage() {
        return this._mDam;
    }

    public int getMpConsume() {
        return this._mpConsume;
    }

    public int getShieldDef() {
        return this._shieldDef;
    }

    public double getShieldDefRate() {
        return this._shieldDefRate;
    }

    public SkillHolder[] getSkills() {
        return this._skillHolder;
    }

    public L2Skill getEnchant4Skill() {
        return this._enchant4Skill;
    }

    public int getChangeWeaponId() {
        return this._changeWeaponId;
    }

    @Override
    public Func[] getStatFuncs(L2ItemInstance instance, L2Character player) {
        if (this._funcTemplates == null || this._funcTemplates.length == 0) {
            return _emptyFunctionSet;
        }
        ArrayList<Func> funcs = new ArrayList<Func>(this._funcTemplates.length);
        Env env = new Env();
        env.player = player;
        env.item = instance;
        for (FuncTemplate t : this._funcTemplates) {
            Func f = t.getFunc(env, instance);
            if (f == null) continue;
            funcs.add(f);
        }
        return funcs.toArray(new Func[funcs.size()]);
    }

    public L2Effect[] getSkillEffects(L2Character caster, L2Character target, boolean crit) {
        if (this._skillsOnCrit == null || !crit) {
            return _emptyEffectSet;
        }
        FastList effects = new FastList();
        Env env = new Env();
        env.player = caster;
        env.target = target;
        env.skill = this._skillsOnCrit;
        if (!this._skillsOnCritCondition.test(env)) {
            return _emptyEffectSet;
        }
        byte shld = Formulas.calcShldUse(caster, target, this._skillsOnCrit);
        if (!Formulas.calcSkillSuccess(caster, target, this._skillsOnCrit, shld, false, false, false)) {
            return _emptyEffectSet;
        }
        if (target.getFirstEffect(this._skillsOnCrit.getId()) != null) {
            target.getFirstEffect(this._skillsOnCrit.getId()).exit();
        }
        for (L2Effect e : this._skillsOnCrit.getEffects(caster, target, new Env(shld, false, false, false))) {
            effects.add(e);
        }
        if (effects.isEmpty()) {
            return _emptyEffectSet;
        }
        return effects.toArray(new L2Effect[effects.size()]);
    }

    public L2Effect[] getSkillEffects(L2Character caster, L2Character target, L2Skill trigger) {
        if (this._skillsOnCast == null) {
            return _emptyEffectSet;
        }
        if (trigger.isOffensive() != this._skillsOnCast.isOffensive()) {
            return _emptyEffectSet;
        }
        if (trigger.isToggle() && this._skillsOnCast.getSkillType() == L2SkillType.BUFF) {
            return _emptyEffectSet;
        }
        if (!trigger.isMagic() && this._skillsOnCast.getSkillType() == L2SkillType.BUFF) {
            return _emptyEffectSet;
        }
        Env env = new Env();
        env.player = caster;
        env.target = target;
        env.skill = this._skillsOnCast;
        if (!this._skillsOnCastCondition.test(env)) {
            return _emptyEffectSet;
        }
        byte shld = Formulas.calcShldUse(caster, target, this._skillsOnCast);
        if (this._skillsOnCast.isOffensive() && !Formulas.calcSkillSuccess(caster, target, this._skillsOnCast, shld, false, false, false)) {
            return _emptyEffectSet;
        }
        try {
            ISkillHandler handler = SkillHandler.getInstance().getSkillHandler(this._skillsOnCast.getSkillType());
            L2Object[] targets = new L2Character[]{target};
            if (handler != null) {
                handler.useSkill(caster, this._skillsOnCast, targets);
            } else {
                this._skillsOnCast.useSkill(caster, targets);
            }
            if (caster instanceof L2PcInstance) {
                Collection<L2Object> objs = caster.getKnownList().getKnownObjects().values();
                for (L2Object spMob : objs) {
                    L2Npc npcMob;
                    if (!(spMob instanceof L2Npc) || (npcMob = (L2Npc)spMob).getTemplate().getEventQuests(Quest.QuestEventType.ON_SKILL_SEE) == null) continue;
                    for (Quest quest : npcMob.getTemplate().getEventQuests(Quest.QuestEventType.ON_SKILL_SEE)) {
                        quest.notifySkillSee(npcMob, (L2PcInstance)caster, this._skillsOnCast, targets, false);
                    }
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return _emptyEffectSet;
    }

    public void attachOnCrit(L2Skill skill, int chance) {
        if (this._skillsOnCrit == null) {
            this._skillsOnCrit = skill;
            this._skillsOnCritCondition = new ConditionGameChance(chance);
        }
    }

    public void attachOnCast(L2Skill skill, int chance) {
        this._skillsOnCast = skill;
        this._skillsOnCastCondition = new ConditionGameChance(chance);
    }
}

