/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class L2SyncList<T>
implements List<T> {
    private final List<T> _list;
    private final ReentrantReadWriteLock _rw = new ReentrantReadWriteLock();
    private final ReentrantReadWriteLock.ReadLock _rl = this._rw.readLock();
    private final ReentrantReadWriteLock.WriteLock _wl = this._rw.writeLock();

    public L2SyncList() {
        this._list = new ArrayList<T>();
    }

    public L2SyncList(List<T> list) {
        this._list = list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get(int index) {
        this._rl.lock();
        try {
            T t = this._list.get(index);
            return t;
        }
        finally {
            this._rl.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean equals(Object o) {
        this._rl.lock();
        try {
            boolean bl = ((Object)this._list).equals(o);
            return bl;
        }
        finally {
            this._rl.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int hashCode() {
        this._rl.lock();
        try {
            int n = ((Object)this._list).hashCode();
            return n;
        }
        finally {
            this._rl.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T set(int index, T element) {
        this._wl.lock();
        try {
            T t = this._list.set(index, element);
            return t;
        }
        finally {
            this._wl.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(int index, T element) {
        this._wl.lock();
        try {
            this._list.add(index, element);
        }
        finally {
            this._wl.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(T element) {
        this._wl.lock();
        try {
            boolean bl = this._list.add(element);
            return bl;
        }
        finally {
            this._wl.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T remove(int index) {
        this._wl.lock();
        try {
            T t = this._list.remove(index);
            return t;
        }
        finally {
            this._wl.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object value) {
        this._wl.lock();
        try {
            boolean bl = this._list.remove(value);
            return bl;
        }
        finally {
            this._wl.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeAll(Collection<?> list) {
        this._wl.lock();
        try {
            boolean bl = this._list.removeAll(list);
            return bl;
        }
        finally {
            this._wl.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean retainAll(Collection<?> list) {
        this._wl.lock();
        try {
            boolean bl = this._list.retainAll(list);
            return bl;
        }
        finally {
            this._wl.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int indexOf(Object o) {
        this._rl.lock();
        try {
            int n = this._list.indexOf(o);
            return n;
        }
        finally {
            this._rl.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object o) {
        this._rl.lock();
        try {
            boolean bl = this._list.contains(o);
            return bl;
        }
        finally {
            this._rl.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsAll(Collection<?> list) {
        this._rl.lock();
        try {
            boolean bl = this._list.containsAll(list);
            return bl;
        }
        finally {
            this._rl.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int lastIndexOf(Object o) {
        this._rl.lock();
        try {
            int n = this._list.lastIndexOf(o);
            return n;
        }
        finally {
            this._rl.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addAll(Collection<? extends T> list) {
        this._wl.lock();
        try {
            boolean bl = this._list.addAll(list);
            return bl;
        }
        finally {
            this._wl.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        this._wl.lock();
        try {
            boolean bl = this._list.addAll(index, c);
            return bl;
        }
        finally {
            this._wl.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<T> subList(int fromIndex, int toIndex) {
        this._rl.lock();
        try {
            L2SyncList<T> l2SyncList = new L2SyncList<T>(this._list.subList(fromIndex, toIndex));
            return l2SyncList;
        }
        finally {
            this._rl.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        this._wl.lock();
        try {
            this._list.clear();
        }
        finally {
            this._wl.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        this._rl.lock();
        try {
            int n = this._list.size();
            return n;
        }
        finally {
            this._rl.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        this._rl.lock();
        try {
            boolean bl = this._list.isEmpty();
            return bl;
        }
        finally {
            this._rl.unlock();
        }
    }

    @Override
    public ListIterator<T> listIterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ListIterator<T> listIterator(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<T> iterator() {
        return new Itr(this._list.toArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object[] toArray() {
        this._rl.lock();
        try {
            Object[] objectArray = this._list.toArray();
            return objectArray;
        }
        finally {
            this._rl.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T[] toArray(T[] a) {
        this._rl.lock();
        try {
            T[] TArray = this._list.toArray(a);
            return TArray;
        }
        finally {
            this._rl.unlock();
        }
    }

    private class Itr
    implements Iterator<T> {
        int cursor;
        int lastRet = -1;
        int size;
        T[] elementData;

        public Itr(T[] data) {
            this.elementData = data;
            this.size = data != null ? data.length : 0;
        }

        @Override
        public boolean hasNext() {
            return this.cursor != this.size;
        }

        @Override
        public T next() {
            int i = this.cursor;
            if (i >= this.size) {
                throw new NoSuchElementException();
            }
            this.cursor = i + 1;
            this.lastRet = i;
            return this.elementData[this.lastRet];
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

