/** yeXgz **/
/*
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program. If not, see <http://www.gnu.org/licenses/>.
 */
package ai.individual;

import com.l2jserver.gameserver.instancemanager.grandbosses.FrintezzaManager;
import com.l2jserver.gameserver.instancemanager.lastimperialtomb.LastImperialTombManager;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.L2Skill;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.quest.Quest;
import com.l2jserver.gameserver.model.quest.QuestState;

/**
 * L2J_JP CREATE SANDMAN
 * JOJO Sync: l2jfree-datapack rev4963, timestamp 2008/12/30 19:43
 * JOJO Implements Soul Breaking Arrow and Dewdrop of Destruction.
 *
 * JOJO javaɏ (lastimperialtomb.py timestamp 2010/02/23 )
 */

public class LastImperialTomb extends Quest
{
	private static final String qn = "lastimperialtomb";

	// NPC
	private static final int GUIDE         = 32011;
	private static final int ALARM_DEVICE  = 18328;
	private static final int CHOIR_PRAYER  = 18339;
	private static final int CHOIR_CAPTAIN = 18334;
	private static final int FRINTEZZA     = 29045;
	private static final int SCARLET_VAN_HALISHA_WEAK   = 29046;
	private static final int SCARLET_VAN_HALISHA_STRONG = 29047;

	public LastImperialTomb(int id, String name, String descr)
	{
		super(id, name, descr);
	}

	@Override
	public String onTalk(L2Npc npc, L2PcInstance player)
	{
		QuestState st = player.getQuestState(qn);
		if (st == null) return "<html><head><body>I have no tasks for you</body></html>";
		switch (npc.getNpcId()) {
		case GUIDE: // Frintezza Teleporter
			if (player.isFlying()) {
				return "<html><body>tebT e|[^[:<br>Co[撆͒ɓ邱Ƃ͂ł܂B</body></html>";
			//	return "<html><body>Imperial Tomb Guide:<br>To enter, get off the wyvern.</body></html>";
			}
			return LastImperialTombManager.getInstance().registration(-1, npc, player);
		default:
			throw new IllegalArgumentException("npcId is " + npc.getNpcId());
		}
	}

	@Override
	public String onAdvEvent(String event, L2Npc npc, L2PcInstance player)
	{
//		String htmltext = event;
		if (event.equals("0") || event.equals("1") || event.equals("2")) {
			return LastImperialTombManager.getInstance().registration(Integer.valueOf(event), npc,player);
		}
		else
			throw new IllegalArgumentException("event is '" + event + "'");
//		return htmltext;
  }

	@Override
	public String onKill(L2Npc npc, L2PcInstance player, boolean isPet)
	{
		QuestState st = player.getQuestState(qn);
		switch (npc.getNpcId()) {
		case ALARM_DEVICE:
			if (st.getRandom(100) < 33) {
				st.giveItems(8556, 1);	// Dewdrop of Destruction
//				st.dropItem(npc, player, 8556, 1);	// Dewdrop of Destruction
			}
			LastImperialTombManager.getInstance().onKillHallAlarmDevice();
			break;
		case CHOIR_PRAYER:
			LastImperialTombManager.getInstance().onKillDarkChoirPlayer();
			break;
		case CHOIR_CAPTAIN:
			if (st.getRandom(100) < 33) {
				st.giveItems(8192, 1);	// Soul Breaking Arrow
//				st.dropItem(npc, player, 8192, 1);	// Soul Breaking Arrow
			}
			LastImperialTombManager.getInstance().onKillDarkChoirCaptain();
			break;
		case SCARLET_VAN_HALISHA_STRONG:
		case SCARLET_VAN_HALISHA_WEAK:
			FrintezzaManager.getInstance().onKillScarlet(player);
			break;
		case FRINTEZZA:
			FrintezzaManager.getInstance().onKillFrintezza(player);
			break;
		case 18329:
		case 18330:
		case 18331:
		case 18332:
		case 18333:
			if (st.getRandom(100) < 20) {
				st.giveItems(8556, 1);	// Dewdrop of Destruction
//				st.dropItem(npc, player, 8556, 1);	// Dewdrop of Destruction
			}
			break;
		default:
			throw new IllegalArgumentException("npcId is " + npc.getNpcId());
		}
		return null;
	}

	@Override
	public String onSkillSee(L2Npc npc, L2PcInstance player, L2Skill skill, L2Object[] targets, boolean isPet)
	{
		QuestState st = player.getQuestState(qn);
		if (st == null) return null;
		if (targets[0] == npc) {
			switch (skill.getId()) {
			case 2234:
				// skills/2200-2299.xml
				//  <skill id="2234" name="Soul Breaking Arrow">
				//  <target npcId="29045"/> <!-- Frintezza -->
				FrintezzaManager.getInstance().onSoulBreakingArrow(npc, player);
				break;
			case 2276:
				// skills/2200-2299.xml
				//  <skill id="2276" name="Dewdrop of Destruction">
				//  <target npcId="29048 29049"/> <!-- Evil Spirit -->
				npc.doDie(player);
				break;
			}
		}
		return null;
	}

	// Quest class and state definition
	public static void main(String[] args)
	{
		final Quest QUEST = new LastImperialTomb(-1, qn, "ai");

		// Quest NPC starter initialization
		QUEST.addStartNpc(GUIDE);
		
		QUEST.addTalkId(GUIDE);
		
		QUEST.addKillId(ALARM_DEVICE);
		QUEST.addKillId(18329);	// Hall Keeper Captain
		QUEST.addKillId(18330);	// Hall Keeper Wizard
		QUEST.addKillId(18331);	// Hall Keeper Guard
		QUEST.addKillId(18332);	// Hall Keeper Patrol
		QUEST.addKillId(18333);	// Hall Keeper Suicidal Soldier
		QUEST.addKillId(CHOIR_PRAYER);
		QUEST.addKillId(CHOIR_CAPTAIN);
		QUEST.addKillId(SCARLET_VAN_HALISHA_WEAK);
		QUEST.addKillId(SCARLET_VAN_HALISHA_STRONG);
		QUEST.addKillId(FRINTEZZA);
		
		QUEST.addSkillSeeId(FRINTEZZA);
		QUEST.addSkillSeeId(29048);	// Evil Spirit
		QUEST.addSkillSeeId(29049);	// Evil Spirit
	}
}
