/** yeXgz **/
/*
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program. If not, see <http://www.gnu.org/licenses/>.
 */
package ai.individual;

import com.l2jserver.gameserver.instancemanager.grandbosses.VanHalterManager;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.quest.Quest;

/**
 * L2J_JP CREATE SANDMAN
 * JOJO Sync: l2jfree-datapack rev5271, timestamp 2009/03/05 01:50
 *
 * JOJO javaɏ (vanhalter.py timestamp 2009/12/27 )
 */

// Main Quest Code
public class Vanhalter extends Quest
{
	private static String qn = "vanhalter";

	// NPC
	private static final int ANDREAS_VAN_HALTER = 29062;
	private static final int ANDREAS_CAPTAIN    = 22188;

	public Vanhalter(int id, String name, String descr)
	{
		super(id, name, descr);
	}

	@Override
	public String onAttack(L2Npc npc, L2PcInstance player, int damage, boolean isPet)
	{
		switch (npc.getNpcId()) {
		case ANDREAS_VAN_HALTER:
			if (npc.getStatus().getCurrentHp() / npc.getMaxHp() <= 0.20)	// HP less than 20%
				VanHalterManager.getInstance().callRoyalGuardHelper();
			break;
		default:
			throw new IllegalArgumentException("npcId is " + npc.getNpcId());
		}
		return null;
	}

	@Override
	public String onKill(L2Npc npc, L2PcInstance player, boolean isPet)
	{
		final int npcId = npc.getNpcId();
		switch (npcId) {
		case ANDREAS_CAPTAIN:
			VanHalterManager.getInstance().checkRoyalGuardCaptainDestroy();
			break;
		case ANDREAS_VAN_HALTER:
			VanHalterManager.getInstance().onKillVanhalter(player);
		//	VanHalterManager.getInstance().enterInterval();
			break;
		case 32058: case 32059: case 32060: case 32061: case 32062: case 32063: case 32064: case 32065: case 32066:	// Triol's Revelation
			VanHalterManager.getInstance().removeBleeding(npcId);
			VanHalterManager.getInstance().checkTriolRevelationDestroy(npc);
			break;
		default:
			throw new IllegalArgumentException("npcId is " + npc.getNpcId());
		}
		return null;
	}

	@Override
	public String onAggroRangeEnter(L2Npc npc, L2PcInstance player, boolean isPet)
	{
		// Triol's Revelation
		VanHalterManager.getInstance().enableBleeding();
		return null;
	}

	// Quest class and state definition
	public static void main(String[] args)
	{
		final Quest QUEST = new Vanhalter(-1, qn, "ai");

		// Quest NPC starter initialization
		// High Priestess van Halter
		QUEST.addAttackId(ANDREAS_VAN_HALTER);
		QUEST.addKillId(ANDREAS_VAN_HALTER);
		// Andreas' Captain of the Royal Guard
		QUEST.addKillId(ANDREAS_CAPTAIN);
		// Triol's Revelation
		for (int npc : new int[]{ 32058, 32059, 32060, 32061, 32062, 32063, 32064, 32065, 32066 }) {
			QUEST.addKillId(npc);
			QUEST.addAggroRangeEnterId(npc);
		}
	}
}
