# By L2J_JP SANDMAN
# JOJO Sync: l2jfree-datapack rev4814, timestamp 2008/11/21 04:53
import sys
from com.l2jserver.gameserver.instancemanager import GrandBossManager
from com.l2jserver.gameserver.instancemanager.grandbosses import SailrenManager
from com.l2jserver.gameserver.model.entity.GrandBossState import StateEnum
from com.l2jserver.gameserver.model.quest import State
from com.l2jserver.gameserver.model.quest import QuestState
from com.l2jserver.gameserver.model.quest.jython import QuestJython as JQuest
from com.l2jserver.gameserver.network.serverpackets import NpcSay
from com.l2jserver.gameserver.util import Broadcast

qn = "sailren"

#NPC
STATUE          =   32109   #V[̐Α/Shilen's Stone Statue
VELOCIRAPTOR    =   22218   #FLvg/Velociraptor
PTEROSAUR       =   22199   #tHNX/Pterosaur
TYRANNOSAURUS   =   22217   #eBmUEX/Tyrannosaurus
SAILREN         =   29065   #TC/Sailren

#ITEM
GAZKH   =   8784    #JWN/Gazkh

# Boss: sailren
class sailren (JQuest):

  def __init__(self,id,name,descr): JQuest.__init__(self,id,name,descr)

  def onTalk (self,npc,player):
    st = player.getQuestState(qn)
    if not st : return "<html><body>NGXg𐋍sĂȂ܂B</body></html>"
    npcId = npc.getNpcId()
    if npcId == STATUE :
      if player.isFlying() :
        return "<html><body>V[̐Α:<br>Co[ɓ撆́Aɓ邱Ƃ͂łȂB</body></html>"
      # return "<html><body>Shilen's Stone Statue:<br>You may not enter while flying a wyvern</body></html>"
      if not st.getQuestItemsCount(GAZKH) :
        st.exitQuest(1)
        return "<html><head><body>V[̐Α:<br>TC𕕈󂷂ɂ<font color=LEVEL>JWN</font>KvB</body></html>"
      # return "<html><head><body>Shilen's Stone Statue:<br><font color=LEVEL>Gazkh</font> is necessary for seal the sailren.</body></html>"
      ENTRY_SATAT = SailrenManager.getInstance().canIntoSailrenLair(player)
      if ENTRY_SATAT == StateEnum.ALIVE or ENTRY_SATAT == StateEnum.DEAD :
        st.exitQuest(1)
        return "<html><head><body>V[̐Α:<br>łɑ̎҂TCƓĂBނ̎זĂ͂ȂB</body></html>"
      # return "<html><head><body>Shilen's Stone Statue:<br>Another adventurers have already fought against the sailren. Do not obstruct them.</body></html>"
      elif ENTRY_SATAT == StateEnum.INTERVAL :
        st.exitQuest(1)
        return "data/html/default/32109-INTERVAL.htm"
#       return "<html><head><body>V[̐Α:<br>̓TC̗͂ɋɂBɓ邱Ƃ͂łȂB</body></html>"
      # return "<html><head><body>Shilen's Stone Statue:<br>The sailren is very powerful now. It is not possible to enter the inside.</body></html>"
      elif ENTRY_SATAT == -4 :
        st.exitQuest(1)
        return "<html><head><body>V[̐Α:<br>lŃTC𕕈󂵂悤ǂƍlȂƂBԂAĂȂB</body></html>"
      # return "<html><head><body>Shilen's Stone Statue:<br>You seal the sailren alone? You should not do so! Bring the companion.</body></html>"
      elif ENTRY_SATAT == StateEnum.NOTSPAWN :
        st.takeItems(GAZKH,1)
        SailrenManager.getInstance().setSailrenSpawnTask(VELOCIRAPTOR)
        SailrenManager.getInstance().entryToSailrenLair(player)
        return "<html><head><body>V[̐Α:<br>N̗͂ŃTC𕕂ĂقBK^FB</body></html>"
      # return "<html><head><body>Shilen's Stone Statue:<br>Please seal the sailren by your ability.</body></html>"

  def onKill (self,npc,player,isPet):
    if not SailrenManager.getInstance().getZone().isInsideZone(player) : return #[JOJO]
    st = player.getQuestState(qn)
    npcId = npc.getNpcId()
    if npcId == VELOCIRAPTOR :
      SailrenManager.getInstance().setSailrenSpawnTask(PTEROSAUR)
    elif npcId == PTEROSAUR :
      SailrenManager.getInstance().setSailrenSpawnTask(TYRANNOSAURUS)
    elif npcId == TYRANNOSAURUS :
      npc.broadcastPacket(NpcSay(npc.getObjectId(), 0, npc.getNpcId(), "`Ill炵dԂĂ͂I܂̂ɂȂ邾낤DDD"))
      SailrenManager.getInstance().setSailrenSpawnTask(SAILREN)
    elif npcId == SAILREN :
      Broadcast.announceToOnlinePlayers("Â̓̃TCS܂B") #[JOJO]
      SailrenManager.getInstance().setCubeSpawn()
      if not st: return
      st.exitQuest(1)
    return

# Quest class and state definition
QUEST = sailren(-1, qn, "ai")

# Quest NPC starter initialization
QUEST.addStartNpc(STATUE)
QUEST.addTalkId(STATUE)
QUEST.addKillId(VELOCIRAPTOR)
QUEST.addKillId(PTEROSAUR)
QUEST.addKillId(TYRANNOSAURUS)
QUEST.addKillId(SAILREN)