-- Information about category:
-- Only one drop will be given per category, except in the cases when category is -1.
-- Category -1 is used for SPOIL/SWEEP drops only!  Do NOT change this.
-- In general, category 0 is for adena and 1 seal stone color (each seal stone color should be in a different category).
-- In general, category 1 is for full drops and parts of equipable items.  However, you can change this.
-- In general, category 2 is for all other items.  However, you can change this.
-- In general, more categories are only used for RBs who have 1 item per category (i.e. do not really drop categorized),
-- with the sole exception of category 200 that is used for Life Stones. However, you can change this too.
-- You can create more categories as you see fit.  Just make sure the "category" number is non-negative!!
-- Also, it is NOT a problem if category numbers are skipped (so you can have -1, 1, 5, 10 as your categories).
--
-- If you wish to allow more than one item to be given from the same category, you can
-- split them up over several categories.
-- In addition, RBs and Grandbosses (mainly) may have the exact same item repeated in multiple categories.
-- This allows mobs to give 1 copy of the drop to each of several people (if they are lucky enough to get the drops).
-- Calculation for each drop, when in categories, is equivallent in chance as when outside of categories.
-- First, the sum of chances for each category is calculated as category chance.  If the category is selected
-- for drops (i.e. its chance is successful), then exactly 1 item from that category will be selected, with 
-- such a chance that the overall probability is maintained unchanged. 
--
-- Category Explanation (non-RaidBoss & non-GrandBoss)
--   -1 is sweep
--    0 is adena and one of the seal stones (your choice)
--    1 is any item that is in weapon.sql, any item in armor.sql, and some of the items from etcitem. Before dropping the column, I had those marked in etcitem.sql. However, you can recognize them easily. If they are parts unique for crafting equipable items, it's category 1.
--    2 is almost all of the other items except:
--    3 and 4 are used for the other two seal stones (1 category each).
--
-- Category Explanation (RaidBoss & their minions)
--    0 is full armor and armor mats
--    1 is full weapon and weapon mats
--    2 is anything else (scrolls,arrows,etc)
--
-- Category Explanation (GrandBoss)
--    0+ is defined catagories
--    Any other mobs within this range (minions, etc) use the default drop categories (most often 2)

DROP TABLE IF EXISTS `droplist`;
CREATE TABLE `droplist` (
  `mobId` INT NOT NULL DEFAULT '0',
  `itemId` INT NOT NULL DEFAULT '0',
  `min` INT NOT NULL DEFAULT '0',
  `max` INT NOT NULL DEFAULT '0',
  `category` INT NOT NULL DEFAULT '0',
  `chance` INT NOT NULL DEFAULT '0',
  PRIMARY KEY (`mobId`,`itemId`,`category`),
  KEY `key_mobId` (`mobId`)
);

INSERT INTO `droplist` VALUES
(18001,1806,1,1,-1,10868),-- Recipe: Soulshot: B-Grade
(18001,57,765,1528,0,700000),-- Adena
(18001,4069,1,1,1,2102),-- Tunic of Zubei Fabric
(18001,4070,1,1,1,3192),-- Stockings of Zubei Fabric
(18001,4071,1,1,1,1615),-- Avadon Robe Fabric
(18001,1419,1,1,2,200000),-- Blood Mark
(18001,1864,1,1,2,166667),-- Stem
(18001,1866,1,1,2,62500),-- Suede
(18001,1878,1,1,2,37037),-- Braided Hemp
(18001,1885,1,1,2,7092),-- High Grade Suede
(18001,1889,1,1,2,5435),-- Compound Braid
(18001,4197,1,1,2,8),-- Recipe: Demon Dagger
(18003,1871,1,1,-1,9797),-- Charcoal
(18010,57,173,347,0,700000),-- Adena
(18012,57,148,293,0,700000),-- Adena
(18013,57,148,293,0,700000),-- Adena
(18014,57,228,455,0,700000),-- Adena
(18015,57,194,387,0,700000),-- Adena
(18017,57,194,387,0,700000),-- Adena
(18018,57,253,504,0,700000),-- Adena
(18020,57,305,611,0,700000),-- Adena
(18022,57,265,529,0,700000),-- Adena
(18023,57,265,529,0,700000),-- Adena
(18024,57,381,761,0,700000),-- Adena
(18025,57,335,669,0,700000),-- Adena
(18027,57,335,669,0,700000),-- Adena
(18028,57,414,829,0,700000),-- Adena
(18030,57,486,972,0,700000),-- Adena
(18032,57,431,863,0,700000),-- Adena
(18033,57,431,863,0,700000),-- Adena
(18034,57,585,1171,0,700000),-- Adena
(18035,57,525,1049,0,700000),-- Adena
(18037,57,525,1049,0,700000),-- Adena
(18038,57,629,1257,0,700000),-- Adena
(18040,57,721,1443,0,700000),-- Adena
(18042,57,651,1302,0,700000),-- Adena
(18043,57,651,1302,0,700000),-- Adena
(18044,57,848,1697,0,700000),-- Adena
(18045,57,770,1541,0,700000),-- Adena
(18047,57,770,1541,0,700000),-- Adena
(18048,57,902,1804,0,700000),-- Adena
(18050,57,902,1804,0,700000),-- Adena
(18052,57,902,1804,0,700000),-- Adena
(18053,57,902,1804,0,700000),-- Adena
(18054,57,902,1804,0,700000),-- Adena
(18055,57,902,1804,0,700000),-- Adena
(18057,57,902,1804,0,700000),-- Adena
(18058,57,902,1804,0,700000),-- Adena
(18060,57,173,347,0,700000),-- Adena
(18062,57,148,293,0,700000),-- Adena
(18063,57,148,293,0,700000),-- Adena
(18064,57,228,455,0,700000),-- Adena
(18065,57,194,387,0,700000),-- Adena
(18067,57,194,387,0,700000),-- Adena
(18068,57,253,504,0,700000),-- Adena
(18070,57,305,611,0,700000),-- Adena
(18072,57,265,529,0,700000),-- Adena
(18073,57,265,529,0,700000),-- Adena
(18074,57,381,761,0,700000),-- Adena
(18075,57,335,669,0,700000),-- Adena
(18077,57,335,669,0,700000),-- Adena
(18078,57,414,829,0,700000),-- Adena
(18080,57,486,972,0,700000),-- Adena
(18082,57,431,863,0,700000),-- Adena
(18083,57,431,863,0,700000),-- Adena
(18084,57,585,1171,0,700000),-- Adena
(18085,57,525,1049,0,700000),-- Adena
(18087,57,525,1049,0,700000),-- Adena
(18088,57,629,1257,0,700000),-- Adena
(18090,57,721,1443,0,700000),-- Adena
(18092,57,651,1302,0,700000),-- Adena
(18093,57,651,1302,0,700000),-- Adena
(18094,57,848,1697,0,700000),-- Adena
(18095,57,770,1541,0,700000),-- Adena
(18097,57,770,1541,0,700000),-- Adena
(18098,57,902,1804,0,700000),-- Adena
(18100,57,902,1804,0,700000),-- Adena
(18102,57,902,1804,0,700000),-- Adena
(18103,57,902,1804,0,700000),-- Adena
(18104,57,902,1804,0,700000),-- Adena
(18105,57,902,1804,0,700000),-- Adena
(18107,57,902,1804,0,700000),-- Adena
(18108,57,902,1804,0,700000),-- Adena
(18109,955,1,1,2,2000),-- Scroll: Enchant Weapon (Grade D)
(18109,956,1,1,2,15000),-- Scroll: Enchant Armor (Grade D)
(18109,1060,1,1,2,50000),-- Lesser Healing Potion
(18109,1061,1,1,2,50000),-- Healing Potion
(18110,951,1,1,2,1500),-- Scroll: Enchant Weapon (Grade C)
(18110,952,1,1,2,12000),-- Scroll: Enchant Armor (Grade C)
(18110,1061,1,1,2,50000),-- Healing Potion
(18110,1832,1,1,2,25000),-- Greater Antidote
(18110,1834,1,1,2,25000),-- Emergency Dressing
(18111,734,1,1,2,25000),-- Haste Potion
(18111,735,1,1,2,25000),-- Potion of Alacrity
(18111,951,1,1,2,2000),-- Scroll: Enchant Weapon (Grade C)
(18111,952,1,1,2,18000),-- Scroll: Enchant Armor (Grade C)
(18111,1539,1,1,2,50000),-- Greater Healing Potion
(18112,734,1,1,2,25000),-- Haste Potion
(18112,735,1,1,2,25000),-- Potion of Alacrity
(18112,947,1,1,2,500),-- Scroll: Enchant Weapon (Grade B)
(18112,948,1,1,2,7000),-- Scroll: Enchant Armor (Grade B)
(18112,1539,1,1,2,50000),-- Greater Healing Potion
(18113,729,1,1,2,300),-- Scroll: Enchant Weapon (Grade A)
(18113,730,1,1,2,2500),-- Scroll: Enchant Armor (Grade A)
(18113,734,1,1,2,25000),-- Haste Potion
(18113,735,1,1,2,25000),-- Potion of Alacrity
(18113,1539,1,1,2,50000),-- Greater Healing Potion
(18114,955,1,1,2,2000),-- Scroll: Enchant Weapon (Grade D)
(18114,956,1,1,2,15000),-- Scroll: Enchant Armor (Grade D)
(18114,1060,1,1,2,50000),-- Lesser Healing Potion
(18114,1061,1,1,2,50000),-- Healing Potion
(18115,951,1,1,2,1500),-- Scroll: Enchant Weapon (Grade C)
(18115,952,1,1,2,12000),-- Scroll: Enchant Armor (Grade C)
(18115,1061,1,1,2,50000),-- Healing Potion
(18115,1832,1,1,2,25000),-- Greater Antidote
(18115,1834,1,1,2,25000),-- Emergency Dressing
(18116,734,1,1,2,25000),-- Haste Potion
(18116,735,1,1,2,25000),-- Potion of Alacrity
(18116,951,1,1,2,2000),-- Scroll: Enchant Weapon (Grade C)
(18116,952,1,1,2,18000),-- Scroll: Enchant Armor (Grade C)
(18116,1539,1,1,2,50000),-- Greater Healing Potion
(18117,734,1,1,2,25000),-- Haste Potion
(18117,735,1,1,2,25000),-- Potion of Alacrity
(18117,947,1,1,2,500),-- Scroll: Enchant Weapon (Grade B)
(18117,948,1,1,2,7000),-- Scroll: Enchant Armor (Grade B)
(18117,1539,1,1,2,50000),-- Greater Healing Potion
(18118,729,1,1,2,300),-- Scroll: Enchant Weapon (Grade A)
(18118,730,1,1,2,2500),-- Scroll: Enchant Armor (Grade A)
(18118,734,1,1,2,25000),-- Haste Potion
(18118,735,1,1,2,25000),-- Potion of Alacrity
(18118,1539,1,1,2,50000),-- Greater Healing Potion
(18256,57,1370,2743,0,700000),-- Adena
(18256,81,1,1,1,2),-- Dragon Slayer
(18256,151,1,1,1,2),-- Sword of Miracles 
(18256,2500,1,1,1,2),-- Dark Legion\'s Edge
(18256,5529,1,1,1,440),-- Dragon Slayer Edge
(18256,5545,1,1,1,440),-- Dark Legion\'s Edge Blade
(18256,5546,1,1,1,483),-- Sword of Miracles Edge
(18256,959,1,1,2,8),-- Scroll: Enchant Weapon (Grade S)
(18256,1895,1,1,2,54858),-- Metallic Fiber
(18256,4040,1,1,2,3841),-- Mold Lubricant
(18256,4042,1,1,2,3201),-- Enria
(18256,4043,1,1,2,6401),-- Asofe
(18265,57,480,858,0,700000),-- Adena
(18265,955,1,1,2,3740),-- Scroll: Enchant Weapon (Grade D)
(18265,956,1,1,2,31162),-- Scroll: Enchant Armor (Grade D)
(18266,57,483,891,0,700000),-- Adena
(18266,955,1,1,2,3855),-- Scroll: Enchant Weapon (Grade D)
(18266,956,1,1,2,32122),-- Scroll: Enchant Armor (Grade D)
(18267,57,484,932,0,700000),-- Adena
(18267,955,1,1,2,3905),-- Scroll: Enchant Weapon (Grade D)
(18267,956,1,1,2,32541),-- Scroll: Enchant Armor (Grade D)
(18268,57,708,1417,0,700000),-- Adena
(18268,955,1,1,2,5804),-- Scroll: Enchant Weapon (Grade D)
(18268,956,1,1,2,48367),-- Scroll: Enchant Armor (Grade D)
(18269,57,732,1465,0,700000),-- Adena
(18269,955,1,1,2,5940),-- Scroll: Enchant Weapon (Grade D)
(18269,956,1,1,2,49492),-- Scroll: Enchant Armor (Grade D)
(18270,57,758,1520,0,700000),-- Adena
(18270,955,1,1,2,6163),-- Scroll: Enchant Weapon (Grade D)
(18270,956,1,1,2,51357),-- Scroll: Enchant Armor (Grade D)
(18271,57,789,1572,0,700000),-- Adena
(18271,955,1,1,2,6338),-- Scroll: Enchant Weapon (Grade D)
(18271,956,1,1,2,52816),-- Scroll: Enchant Armor (Grade D)
(18272,57,1257,2519,0,700000),-- Adena
(18272,951,1,1,2,4563),-- Scroll: Enchant Weapon (Grade C)
(18272,952,1,1,2,33462),-- Scroll: Enchant Armor (Grade C)
(18273,57,1293,2582,0,700000),-- Adena
(18273,951,1,1,2,4604),-- Scroll: Enchant Weapon (Grade C)
(18273,952,1,1,2,33756),-- Scroll: Enchant Armor (Grade C)
(18274,57,1330,2656,0,700000),-- Adena
(18274,951,1,1,2,4652),-- Scroll: Enchant Weapon (Grade C)
(18274,952,1,1,2,34111),-- Scroll: Enchant Armor (Grade C)
(18275,57,1952,3909,0,700000),-- Adena
(18275,951,1,1,2,6718),-- Scroll: Enchant Weapon (Grade C)
(18275,952,1,1,2,49264),-- Scroll: Enchant Armor (Grade C)
(18276,57,1997,3995,0,700000),-- Adena
(18276,947,1,1,2,1468),-- Scroll: Enchant Weapon (Grade B)
(18276,948,1,1,2,9176),-- Scroll: Enchant Armor (Grade B)
(18277,57,2049,4095,0,700000),-- Adena
(18277,947,1,1,2,1433),-- Scroll: Enchant Weapon (Grade B)
(18277,948,1,1,2,8957),-- Scroll: Enchant Armor (Grade B)
(18278,57,2683,5361,0,700000),-- Adena
(18278,947,1,1,2,1877),-- Scroll: Enchant Weapon (Grade B)
(18278,948,1,1,2,11732),-- Scroll: Enchant Armor (Grade B)
(18279,57,2736,5473,0,700000),-- Adena
(18279,947,1,1,2,1916),-- Scroll: Enchant Weapon (Grade B)
(18279,948,1,1,2,11969),-- Scroll: Enchant Armor (Grade B)
(18280,57,2790,5576,0,700000),-- Adena
(18280,729,1,1,2,543),-- Scroll: Enchant Weapon (Grade A)
(18280,730,1,1,2,4067),-- Scroll: Enchant Armor (Grade A)
(18281,57,2849,5701,0,700000),-- Adena
(18281,729,1,1,2,555),-- Scroll: Enchant Weapon (Grade A)
(18281,730,1,1,2,4157),-- Scroll: Enchant Armor (Grade A)
(18282,57,4009,8028,0,700000),-- Adena
(18282,729,1,1,2,781),-- Scroll: Enchant Weapon (Grade A)
(18282,730,1,1,2,5854),-- Scroll: Enchant Armor (Grade A)
(18283,57,4078,8168,0,700000),-- Adena
(18283,959,1,1,2,286),-- Scroll: Enchant Weapon (Grade S)
(18283,960,1,1,2,2860),-- Scroll: Enchant Armor (Grade S)
(18284,57,4146,8295,0,700000),-- Adena
(18284,959,1,1,2,291),-- Scroll: Enchant Weapon (Grade S)
(18284,960,1,1,2,2904),-- Scroll: Enchant Armor (Grade S)
(18285,57,5312,10638,0,700000),-- Adena
(18285,959,1,1,2,373),-- Scroll: Enchant Weapon (Grade S)
(18285,960,1,1,2,3724),-- Scroll: Enchant Armor (Grade S)
(18286,57,5393,10798,0,700000),-- Adena
(18286,959,1,1,2,378),-- Scroll: Enchant Weapon (Grade S)
(18286,960,1,1,2,3780),-- Scroll: Enchant Armor (Grade S)
(18287,57,186,372,0,700000),-- Adena
(18287,955,1,1,2,1508),-- Scroll: Enchant Weapon (Grade D)
(18287,956,1,1,2,12560),-- Scroll: Enchant Armor (Grade D)
(18288,57,207,413,0,700000),-- Adena
(18288,955,1,1,2,1680),-- Scroll: Enchant Weapon (Grade D)
(18288,956,1,1,2,13997),-- Scroll: Enchant Armor (Grade D)
(18289,57,308,617,0,700000),-- Adena
(18289,951,1,1,2,1119),-- Scroll: Enchant Weapon (Grade C)
(18289,952,1,1,2,8205),-- Scroll: Enchant Armor (Grade C)
(18290,57,338,676,0,700000),-- Adena
(18290,951,1,1,2,1205),-- Scroll: Enchant Weapon (Grade C)
(18290,952,1,1,2,8833),-- Scroll: Enchant Armor (Grade C)
(18291,57,472,944,0,700000),-- Adena
(18291,947,1,1,2,347),-- Scroll: Enchant Weapon (Grade B)
(18291,948,1,1,2,2168),-- Scroll: Enchant Armor (Grade B)
(18292,57,519,1010,0,700000),-- Adena
(18292,947,1,1,2,375),-- Scroll: Enchant Weapon (Grade B)
(18292,948,1,1,2,2342),-- Scroll: Enchant Armor (Grade B)
(18293,57,681,1361,0,700000),-- Adena
(18293,729,1,1,2,133),-- Scroll: Enchant Weapon (Grade A)
(18293,730,1,1,2,993),-- Scroll: Enchant Armor (Grade A)
(18294,57,728,1457,0,700000),-- Adena
(18294,729,1,1,2,142),-- Scroll: Enchant Weapon (Grade A)
(18294,730,1,1,2,1063),-- Scroll: Enchant Armor (Grade A)
(18295,57,938,1879,0,700000),-- Adena
(18295,729,1,1,2,183),-- Scroll: Enchant Weapon (Grade A)
(18295,730,1,1,2,1370),-- Scroll: Enchant Armor (Grade A)
(18296,57,995,1993,0,700000),-- Adena
(18296,959,1,1,2,70),-- Scroll: Enchant Weapon (Grade S)
(18296,960,1,1,2,698),-- Scroll: Enchant Armor (Grade S)
(18297,57,1239,2481,0,700000),-- Adena
(18297,959,1,1,2,87),-- Scroll: Enchant Weapon (Grade S)
(18297,960,1,1,2,869),-- Scroll: Enchant Armor (Grade S)
(18298,57,1301,2604,0,700000),-- Adena
(18298,959,1,1,2,92),-- Scroll: Enchant Weapon (Grade S)
(18298,960,1,1,2,912),-- Scroll: Enchant Armor (Grade S)
(18319,6529,1,1,1,1159),-- Baby Duck Rod
(18319,6519,1,1,2,86953),-- Green Colored Lure - Low Grade
(18319,6522,1,1,2,57969),-- Purple Colored Lure - Low Grade
(18319,6525,1,1,2,72461),-- Yellow Colored Lure - Low Grade
(18319,6535,12,36,2,120768),-- Fishing Shot: non-grade
(18320,6530,1,1,1,527),-- Albatross Rod
(18320,6519,1,1,2,131712),-- Green Colored Lure - Low Grade
(18320,6522,1,1,2,87808),-- Purple Colored Lure - Low Grade
(18320,6525,1,1,2,109760),-- Yellow Colored Lure - Low Grade
(18320,6536,12,36,2,109760),-- Fishing Shot: D-grade
(18321,6531,1,1,1,200),-- Pelican Rod
(18321,6520,2,6,2,33251),-- Green Colored Lure 
(18321,6523,1,1,2,110836),-- Purple Colored Lure
(18321,6526,1,1,2,133003),-- Yellow Colored Lure
(18321,6537,12,36,2,118753),-- Fishing Shot: C-grade
(18322,6532,1,1,1,108),-- KingFisher Rod
(18322,6520,2,6,2,67551),-- Green Colored Lure 
(18322,6523,1,1,2,180134),-- Purple Colored Lure
(18322,6526,3,9,2,36027),-- Yellow Colored Lure
(18322,6538,15,45,2,43232),-- Fishing Shot: B-grade
(18323,6533,1,1,1,41),-- Cygnus Pole
(18323,6521,2,6,2,67649),-- Green Colored Lure - High Grade
(18323,6524,1,1,2,202945),-- Purple Colored Lure - High Grade
(18323,6527,2,6,2,45099),-- Yellow Colored Lure - High Grade
(18323,6539,3,9,2,169121),-- Fishing Shot: A-grade
(18324,6533,1,1,1,61),-- Cygnus Pole
(18324,6521,2,6,2,81602),-- Green Colored Lure - High Grade
(18324,6524,1,1,2,244805),-- Purple Colored Lure - High Grade
(18324,6527,2,6,2,54401),-- Yellow Colored Lure - High Grade
(18324,6539,3,9,2,204004),-- Fishing Shot: A-grade
(18325,6534,1,1,1,17),-- Triton Pole
(18325,6521,2,6,2,70774),-- Green Colored Lure - High Grade
(18325,6524,1,1,2,212320),-- Purple Colored Lure - High Grade
(18325,6527,2,6,2,47183),-- Yellow Colored Lure - High Grade
(18325,6540,3,9,2,141547),-- Fishing Shot: S-grade
(18326,6534,1,1,1,30),-- Triton Pole
(18326,6521,2,6,2,85774),-- Green Colored Lure - High Grade
(18326,6524,1,1,2,257320),-- Purple Colored Lure - High Grade
(18326,6527,2,6,2,57183),-- Yellow Colored Lure - High Grade
(18326,6540,3,9,2,171547),-- Fishing Shot: S-grade
(18345,8787,1,1,2,250000),-- Sprigant\'s Fruit
(18346,8787,1,1,2,250000),-- Sprigant\'s Fruit
(18485,9691,1,1,2,1000000),-- Water Dragon Scale
(18485,9700,1,1,3,360000),-- Water Dragon Claw
(18554,955,1,1,2,320754),-- Scroll: Enchant Weapon (Grade D)
(18554,956,3,8,2,377358),-- Scroll: Enchant Armor (Grade D)
(18554,25,1,11,1,188679),-- Piece Bone Breastplate
(18554,1926,8,20,1,245283),-- Piece Bone Breastplate Fragment
(18554,1928,37,72,1,188679),-- Piece Bone Gaiters Fragment
(18554,26,1,2,3,320754),-- Bronze Breastplate
(18554,34,4,10,3,56603),-- Bronze Gaiters
(18555,955,1,1,2,332602),-- Scroll: Enchant Weapon (Grade D)
(18555,956,3,9,2,461947),-- Scroll: Enchant Armor (Grade D)
(18555,465,1,3,3,426212),-- Cursed Stockings
(18555,432,1,1,3,354881),-- Cursed Tunic
(18555,465,1,3,4,284140),-- Cursed Stockings
(18555,432,2,4,4,177440),-- Cursed Tunic
(18557,955,1,1,2,332602),-- Scroll: Enchant Weapon (Grade D)
(18557,956,3,9,2,461947),-- Scroll: Enchant Armor (Grade D)
(18557,465,1,3,3,426212),-- Cursed Stockings
(18557,432,1,1,3,354881),-- Cursed Tunic
(18557,465,1,3,4,284140),-- Cursed Stockings
(18557,432,2,4,4,177440),-- Cursed Tunic
(18558,955,1,1,2,425207),-- Scroll: Enchant Weapon (Grade D)
(18558,956,12,36,2,147641),-- Scroll: Enchant Armor (Grade D)
(18558,63,3,9,1,39948),-- Gauntlets
(18558,2447,1,1,1,239691),-- Gloves of Knowledge
(18558,553,4,10,1,34241),-- Iron Boots
(18558,2423,1,1,1,159796),-- Boots of Knowledge
(18558,2422,1,1,1,159796),-- Reinforced Leather Boots
(18558,2446,1,1,1,239691),-- Reinforced Leather Gloves
(18558,1940,60,180,1,58283),-- Iron Boots Design
(18558,63,3,9,3,26632),-- Gauntlets
(18558,2447,1,1,3,159796),-- Gloves of Knowledge
(18558,553,4,10,3,22828),-- Iron Boots
(18558,2423,5,13,3,26632),-- Boots of Knowledge
(18558,2422,4,12,3,29961),-- Reinforced Leather Boots
(18558,2446,1,1,3,159796),-- Reinforced Leather Gloves
(18558,1940,60,180,3,38856),-- Iron Boots Design
(18559,955,1,1,2,471698),-- Scroll: Enchant Weapon (Grade D)
(18559,956,12,36,2,163784),-- Scroll: Enchant Armor (Grade D)
(18559,628,1,3,1,43758),-- Hoplon
(18559,47,1,1,1,413972),-- Helmet
(18559,628,1,3,3,295839),-- Hoplon
(18559,47,2,4,3,206986),-- Helmet
(18561,955,1,1,2,471698),-- Scroll: Enchant Weapon (Grade D)
(18561,956,12,36,2,163784),-- Scroll: Enchant Armor (Grade D)
(18561,83,1,1,1,22021),-- Sword of Magic
(18561,124,1,1,1,16314),-- Two-Handed Sword
(18561,127,1,1,1,16314),-- Crimson Sword
(18561,130,1,1,1,16314),-- Elven Sword
(18561,144,1,1,1,22021),-- Sword of Occult
(18561,2026,1,1,1,486625),-- Two-Handed Sword Edge
(18561,83,1,1,3,14681),-- Sword of Magic
(18561,124,1,1,3,10876),-- Two-Handed Sword
(18561,127,1,1,3,10876),-- Crimson Sword
(18561,130,1,1,3,10876),-- Elven Sword
(18561,144,1,1,3,14681),-- Sword of Occult
(18561,2026,1,3,3,364966),-- Two-Handed Sword Edge
(18562,951,1,1,2,263413),-- Scroll: Enchant Weapon (Grade C)
(18562,952,3,9,2,321950),-- Scroll: Enchant Armor (Grade C)
(18562,353,1,1,1,74310),-- Half Plate Armor
(18562,380,1,1,1,118896),-- Plate Gaiters
(18562,1950,8,22,1,470143),-- Half Plate Temper
(18562,1951,4,12,1,241832),-- Plate Gaiters Part
(18562,353,1,1,3,49540),-- Half Plate Armor
(18562,380,1,1,3,79264),-- Plate Gaiters
(18562,1950,8,22,3,161221),-- Half Plate Temper
(18562,1951,24,72,3,117536),-- Plate Gaiters Part
(18564,951,1,1,2,299779),-- Scroll: Enchant Weapon (Grade C)
(18564,952,3,9,2,366396),-- Scroll: Enchant Armor (Grade C)
(18564,281,1,1,1,28860),-- Crystallized Ice Bow
(18564,2074,1,3,1,600579),-- Crystallized Ice Bow Shaft
(18564,281,1,1,3,19240),-- Crystallized Ice Bow
(18564,2074,3,9,3,300284),-- Crystallized Ice Bow Shaft
(18565,951,1,1,2,299779),-- Scroll: Enchant Weapon (Grade C)
(18565,952,3,9,2,366396),-- Scroll: Enchant Armor (Grade C)
(18565,631,1,1,1,166264),-- Eldarake
(18565,1964,40,120,1,85651),-- Eldarake Temper
(18565,2413,1,1,1,116396),-- Chain Hood
(18565,2495,1,1,1,166264),-- Chain Shield
(18565,2936,14,42,1,253782),-- Chain Hood Pattern
(18565,2945,9,27,1,253782),-- Chain Shield Fragment
(18565,631,1,1,3,110843),-- Eldarake
(18565,1964,40,120,3,57101),-- Eldarake Temper
(18565,2413,1,1,3,77598),-- Chain Hood
(18565,2495,1,1,3,110843),-- Chain Shield
(18565,2936,14,42,3,148178),-- Chain Hood Pattern
(18565,2945,81,243,3,42298),-- Chain Shield Fragment
(18566,947,1,1,2,76242),-- Scroll: Enchant Weapon (Grade B)
(18566,948,1,1,2,476514),-- Scroll: Enchant Armor (Grade B)
(18566,2120,1,3,1,706305),-- Great Pata Blade
(18566,266,1,1,1,12478),-- Great Pata
(18566,2120,1,3,3,470870),-- Great Pata Blade
(18566,266,1,1,3,8319),-- Great Pata
(18568,947,1,1,2,103909),-- Scroll: Enchant Weapon (Grade B)
(18568,948,1,1,2,649434),-- Scroll: Enchant Armor (Grade B)
(18568,357,1,1,1,12556),-- Zubei\'s Breastplate
(18568,383,1,1,1,20086),-- Zubei\'s Gaiters
(18568,2376,1,1,1,12556),-- Avadon Breastplate
(18568,2379,1,1,1,20086),-- Avadon Gaiters
(18568,4056,16,48,1,56673),-- Zubei\'s Breastplate Part
(18568,4057,6,18,1,233561),-- Zubei\'s Gaiter Material
(18568,4064,3,7,1,241800),-- Avadon Breastplate Part
(18568,4065,11,31,1,133464),-- Avadon Gaiters Material
(18568,357,1,1,3,8371),-- Zubei\'s Breastplate
(18568,383,1,1,3,13390),-- Zubei\'s Gaiters
(18568,2376,1,1,3,8371),-- Avadon Breastplate
(18568,2379,1,1,3,13390),-- Avadon Gaiters
(18568,4056,16,48,3,37781),-- Zubei\'s Breastplate Part
(18568,4057,6,18,3,155704),-- Zubei\'s Gaiter Material
(18568,4064,23,67,3,40301),-- Avadon Breastplate Part
(18568,4065,11,31,3,88974),-- Avadon Gaiters Material
(18570,947,1,1,2,103909),-- Scroll: Enchant Weapon (Grade B)
(18570,948,1,1,2,649434),-- Scroll: Enchant Armor (Grade B)
(18570,78,1,1,1,4000),-- Great Sword
(18570,142,1,1,1,4000),-- Keshanberk
(18570,148,1,1,1,4000),-- Sword of Valhalla
(18570,4104,1,3,1,254821),-- Great Sword Blade
(18570,4107,2,4,1,250894),-- Keshanberk Blade
(18570,4108,2,6,1,188171),-- Sword of Valhalla Blade
(18570,78,1,1,3,2666),-- Great Sword
(18570,142,1,1,3,2666),-- Keshanberk
(18570,148,1,1,3,2666),-- Sword of Valhalla
(18570,4104,5,15,3,76453),-- Great Sword Blade
(18570,4107,2,4,3,167249),-- Keshanberk Blade
(18570,4108,2,6,3,125436),-- Sword of Valhalla Blade
(18571,729,1,1,2,38277),-- Scroll: Enchant Weapon (Grade A)
(18571,730,1,1,2,287074),-- Scroll: Enchant Armor (Grade A)
(18571,2398,1,1,1,14311),-- Blue Wolf Tunic
(18571,2399,1,1,1,14311),-- Tunic of Doom
(18571,2403,1,1,1,22904),-- Blue Wolf Stockings
(18571,2404,1,1,1,22904),-- Stockings of Doom
(18571,4084,16,48,1,72165),-- Blue Wolf Tunic Fabric
(18571,4085,3,7,1,307897),-- Tunic of Doom Pattern
(18571,4086,6,18,1,259838),-- Blue Wolf Stockings Pattern
(18571,4087,11,31,1,148479),-- Stockings of Doom Pattern
(18571,2398,1,1,3,9540),-- Blue Wolf Tunic
(18571,2399,1,1,3,9540),-- Tunic of Doom
(18571,2403,1,1,3,15269),-- Blue Wolf Stockings
(18571,2404,1,1,3,15269),-- Stockings of Doom
(18571,4084,16,48,3,48109),-- Blue Wolf Tunic Fabric
(18571,4085,23,67,3,51317),-- Tunic of Doom Pattern
(18571,4086,6,18,3,173221),-- Blue Wolf Stockings Pattern
(18571,4087,11,31,3,98983),-- Stockings of Doom Pattern
(18573,729,1,1,2,38550),-- Scroll: Enchant Weapon (Grade A)
(18573,730,1,1,2,289124),-- Scroll: Enchant Armor (Grade A)
(18573,601,1,1,1,43252),-- Boots of Doom
(18573,2439,1,1,1,43252),-- Blue Wolf Boots
(18573,2475,1,1,1,43252),-- Doom Gloves
(18573,2487,1,1,1,43252),-- Blue Wolf Gloves
(18573,4090,11,31,1,190722),-- Blue Wolf Boots Design
(18573,4091,16,48,1,187744),-- Doom Gloves Part
(18573,4096,23,67,1,133508),-- Blue Wolf Gloves Fabric
(18573,4099,60,180,1,50065),-- Doom Boots Part
(18573,601,1,1,3,28835),-- Boots of Doom
(18573,2439,1,1,3,28835),-- Blue Wolf Boots
(18573,2475,1,1,3,28835),-- Doom Gloves
(18573,2487,1,1,3,28835),-- Blue Wolf Gloves
(18573,4090,116,346,3,26008),-- Blue Wolf Boots Design
(18573,4091,16,48,3,125161),-- Doom Gloves Part
(18573,4096,23,67,3,89003),-- Blue Wolf Gloves Fabric
(18573,4099,60,180,3,33376),-- Doom Boots Part
(18575,729,1,1,2,38550),-- Scroll: Enchant Weapon (Grade A)
(18575,730,1,1,2,289124),-- Scroll: Enchant Armor (Grade A)
(18575,171,1,1,1,2122),-- Deadman\'s Glory
(18575,175,1,1,1,2122),-- Art of Battle Axe
(18575,210,1,1,1,2122),-- Staff of Evil Spirits
(18575,7893,1,1,1,2122),-- Kaim Vanul Bones
(18575,7901,1,1,1,2122),-- Star Buster
(18575,4116,1,3,1,233901),-- Deadman\'s Glory Stone
(18575,4117,2,4,1,155934),-- Art of Battle Axe Blade
(18575,4118,1,1,1,295484),-- Evil Spirit Head
(18575,8340,2,6,1,116950),-- Bones Head of Kaim Vanul
(18575,8348,3,7,1,93402),-- Star Buster Head
(18575,171,1,1,3,1415),-- Deadman\'s Glory
(18575,175,1,1,3,1415),-- Art of Battle Axe
(18575,210,1,1,3,1415),-- Staff of Evil Spirits
(18575,7893,1,1,3,1415),-- Kaim Vanul Bones
(18575,7901,1,1,3,1415),-- Star Buster
(18575,4116,1,3,3,155938),-- Deadman\'s Glory Stone
(18575,4117,2,4,3,103958),-- Art of Battle Axe Blade
(18575,4118,3,9,3,73869),-- Evil Spirit Head
(18575,8340,2,6,3,77969),-- Bones Head of Kaim Vanul
(18575,8348,3,7,3,62270),-- Star Buster Head
(18577,729,1,1,2,39024),-- Scroll: Enchant Weapon (Grade A)
(18577,730,1,1,2,292676),-- Scroll: Enchant Armor (Grade A)
(18577,6323,1,1,1,26959),-- Sealed Phoenix Necklace
(18577,6324,1,1,1,35945),-- Sealed Phoenix Earring
(18577,6325,1,1,1,53917),-- Sealed Phoenix Ring
(18577,6341,9,27,1,277542),-- Sealed Phoenix Earring Gemstone
(18577,6343,14,42,1,137925),-- Sealed Phoenix Necklace Beads
(18577,6345,40,120,1,86372),-- Sealed Phoenix Ring Gemstone
(18577,6323,1,1,3,17972),-- Sealed Phoenix Necklace
(18577,6324,1,1,3,23963),-- Sealed Phoenix Earring
(18577,6325,1,1,3,35944),-- Sealed Phoenix Ring
(18577,6341,9,27,3,185028),-- Sealed Phoenix Earring Gemstone
(18577,6343,14,42,3,91950),-- Sealed Phoenix Necklace Beads
(18577,6345,40,120,3,57581),-- Sealed Phoenix Ring Gemstone
(20003,116,1,1,-1,452932),-- Magic Ring
(20003,1786,1,1,-1,45293),-- Recipe: Broad Sword
(20003,1871,1,1,-1,56617),-- Charcoal
(20003,57,30,42,0,700000),-- Adena
(20003,112,1,1,1,102689),-- Apprentice\'s Earring
(20003,116,1,1,1,156087),-- Magic Ring
(20003,118,1,1,1,76514),-- Necklace of Magic
(20003,1788,1,1,2,7805),-- Recipe: Bow 
(20003,1864,1,1,2,19512),-- Stem
(20003,1865,1,1,2,9756),-- Varnish
(20003,1866,1,1,2,6504),-- Suede
(20003,1868,1,1,2,19512),-- Thread
(20003,1873,1,1,2,3903),-- Silver Nugget
(20004,1866,1,1,-1,51827),-- Suede
(20004,2005,1,1,-1,5553),-- Broadsword Blade
(20004,2006,1,1,-1,5553),-- Willow Staff Head
(20004,57,41,58,0,700000),-- Adena
(20004,1119,1,1,1,6514),-- Short Leather Gloves
(20004,1122,1,1,1,6514),-- Cotton Shoes
(20004,1129,1,1,1,6514),-- Crude Leather Shoes
(20004,1666,1,1,2,5104),-- Recipe: Wooden Arrow
(20004,1866,1,1,2,10206),-- Suede
(20004,1871,1,1,2,15309),-- Charcoal
(20005,1060,1,1,-1,216259),-- Lesser Healing Potion
(20005,1666,1,1,-1,32439),-- Recipe: Wooden Arrow
(20005,1866,1,1,-1,64878),-- Suede
(20005,57,51,72,0,700000),-- Adena
(20005,19,1,1,1,11733),-- Small Shield
(20005,42,1,1,1,8213),-- Leather Cap
(20005,17,10,30,2,71865),-- Wooden Arrow
(20005,1789,1,1,2,2657),-- Recipe: Cedar Staff
(20005,1865,1,1,2,14373),-- Varnish
(20005,1870,1,1,2,14373),-- Coal
(20006,113,1,1,-1,41407),-- Mystic\'s Earring
(20006,1060,1,1,-1,285245),-- Lesser Healing Potion
(20006,2006,1,1,-1,9169),-- Willow Staff Head
(20006,57,69,94,0,700000),-- Adena
(20006,14,1,1,1,790),-- Bow
(20006,2007,1,1,1,2709),-- Bow Shaft
(20006,1866,1,1,2,16852),-- Suede
(20006,1871,1,1,2,25278),-- Charcoal
(20006,2136,1,1,2,7435),-- Recipe: Cokes
(20007,1122,1,1,-1,63337),-- Cotton Shoes
(20007,1866,1,1,-1,99228),-- Suede
(20007,1875,1,1,-1,9923),-- Stone of Purity
(20007,57,80,108,0,700000),-- Adena
(20007,22,1,1,1,4702),-- Leather Shirt
(20007,29,1,1,1,7516),-- Leather Pants
(20007,1796,1,1,2,36869),-- Recipe: Leather Tunic
(20007,1864,1,1,2,58621),-- Stem
(20007,1869,1,1,2,29311),-- Iron Ore
(20008,1793,1,1,-1,16388),-- Recipe: Sword of Reflection
(20008,1870,1,1,-1,222882),-- Coal
(20008,1871,1,1,-1,222882),-- Charcoal
(20008,57,114,168,0,700000),-- Adena
(20008,255,1,1,1,317),-- Fox Claw Gloves
(20008,2371,1,1,1,675),-- Fist of Butcher
(20008,1792,1,1,2,3228),-- Recipe: Short Spear
(20008,1865,1,1,2,43891),-- Varnish
(20008,1870,1,1,2,43891),-- Coal
(20009,43,1,1,-1,14567),-- Wooden Helmet
(20009,1831,1,1,-1,594351),-- Antidote
(20009,1870,1,1,-1,222882),-- Coal
(20009,57,114,168,0,700000),-- Adena
(20009,255,1,1,1,317),-- Fox Claw Gloves
(20009,2371,1,1,1,675),-- Fist of Butcher
(20009,736,1,1,2,21946),-- Scroll of Escape
(20009,1866,1,1,2,29261),-- Suede
(20009,1871,1,1,2,43891),-- Charcoal
(20010,1792,1,1,-1,17030),-- Recipe: Short Spear
(20010,1833,1,1,-1,617635),-- Bandage
(20010,1896,1,1,-1,98141),-- Necklace of Anguish Chain
(20010,57,116,177,0,700000),-- Adena
(20010,271,1,1,1,658),-- Hunting Bow
(20010,1798,1,1,2,44716),-- Recipe: Leather Helmet
(20010,1866,1,1,2,30407),-- Suede
(20010,1871,1,1,2,45610),-- Charcoal
(20011,1792,1,1,-1,17541),-- Recipe: Short Spear
(20011,1867,1,1,-1,318082),-- Animal Skin
(20011,1921,1,1,-1,153911),-- Leather Shoes Texture
(20011,57,120,182,0,700000),-- Adena
(20011,271,1,1,1,678),-- Hunting Bow
(20011,1799,1,1,2,69598),-- Recipe: Leather Gloves
(20011,1867,1,1,2,62638),-- Animal Skin
(20011,1872,1,1,2,62638),-- Animal Bone
(20012,734,1,1,-1,40386),-- Haste Potion
(20012,1865,1,1,-1,242317),-- Varnish
(20012,1897,1,1,-1,57694),-- Necklace of Wisdom Chain
(20012,57,120,187,0,700000),-- Adena
(20012,1101,1,1,1,918),-- Tunic of Devotion
(20012,1104,1,1,1,1465),-- Stockings of Devotion
(20012,1800,1,1,2,11255),-- Recipe: Piece Bone Breastplate
(20012,1865,1,1,2,35789),-- Varnish
(20012,1870,1,1,2,35789),-- Coal
(20012,6035,1,1,2,2983),-- Magic Haste Potion
(20013,1866,1,2,-1,143423),-- Suede
(20013,1896,1,1,-1,91159),-- Necklace of Anguish Chain
(20013,1922,1,1,-1,54881),-- Leather Tunic Pattern
(20013,57,113,160,0,700000),-- Adena
(20013,9,1,1,1,204),-- Cedar Staff
(20013,154,1,1,1,204),-- Dwarven Mace
(20013,2008,1,1,1,1649),-- Cedar Staff Head
(20013,1792,1,1,2,3115),-- Recipe: Short Spear
(20013,1865,1,1,2,42366),-- Varnish
(20013,1870,1,1,2,42366),-- Coal
(20014,1867,1,2,-1,328104),-- Animal Skin
(20014,2254,1,1,-1,10085),-- Recipe: Composition Bow
(20014,57,120,193,0,700000),-- Adena
(20014,2,1,1,1,69),-- Long Sword
(20014,120,1,1,1,69),-- Sword of Reflection
(20014,121,1,1,1,69),-- Sword of Watershadow
(20014,2012,1,1,1,758),-- Sword of Reflection Blade
(20014,1800,1,1,2,15239),-- Recipe: Piece Bone Breastplate
(20014,1867,1,1,2,64612),-- Animal Skin
(20014,1872,1,1,2,64612),-- Animal Bone
(20015,1798,1,1,-1,237113),-- Recipe: Leather Helmet
(20015,1864,1,1,-1,483710),-- Stem
(20015,1871,1,1,-1,241855),-- Charcoal
(20015,57,127,180,0,700000),-- Adena
(20015,9,1,1,1,229),-- Cedar Staff
(20015,154,1,1,1,229),-- Dwarven Mace
(20015,2008,1,1,1,1853),-- Cedar Staff Head
(20015,1798,1,1,2,46693),-- Recipe: Leather Helmet
(20015,1864,1,1,2,95254),-- Stem
(20015,1869,1,1,2,47627),-- Iron Ore
(20016,37,1,1,-1,23711),-- Leather Shoes
(20016,1833,1,1,-1,644946),-- Bandage
(20016,1865,1,1,-1,241855),-- Varnish
(20016,57,127,180,0,700000),-- Adena
(20016,271,1,1,1,687),-- Hunting Bow
(20016,736,1,1,2,23814),-- Scroll of Escape
(20016,1866,1,1,2,31752),-- Suede
(20016,1871,1,1,2,47627),-- Charcoal
(20017,1870,1,1,-1,251000),-- Coal
(20017,1897,1,1,-1,59762),-- Necklace of Wisdom Chain
(20017,57,122,197,0,700000),-- Adena
(20017,2,1,1,1,71),-- Long Sword
(20017,120,1,1,1,71),-- Sword of Reflection
(20017,121,1,1,1,71),-- Sword of Watershadow
(20017,2012,1,1,1,773),-- Sword of Reflection Blade
(20017,1817,1,1,2,7415),-- Recipe: Cord
(20017,1865,1,1,2,37071),-- Varnish
(20017,1870,1,1,2,37071),-- Coal
(20017,5268,1,1,2,1483),-- Recipe: Greater Soulshot (D) Compressed Package (100%)
(20019,1792,1,1,-1,16388),-- Recipe: Short Spear
(20019,1864,1,1,-1,445764),-- Stem
(20019,1923,1,1,-1,91345),-- Leather Stocking Pattern
(20019,57,114,168,0,700000),-- Adena
(20019,429,1,1,1,1076),-- Leather Tunic
(20019,464,1,1,1,1723),-- Leather Stockings
(20019,1922,1,1,1,8398),-- Leather Tunic Pattern
(20019,1923,1,1,1,13491),-- Leather Stocking Pattern
(20019,1793,1,1,2,3228),-- Recipe: Sword of Reflection
(20019,1866,1,1,2,29261),-- Suede
(20019,1871,1,1,2,43891),-- Charcoal
(20020,1799,1,1,-1,371205),-- Recipe: Leather Gloves
(20020,1831,1,1,-1,668170),-- Antidote
(20020,1896,1,1,-1,106171),-- Necklace of Anguish Chain
(20020,57,128,189,0,700000),-- Adena
(20020,37,1,1,1,4837),-- Leather Shoes
(20020,49,1,1,1,4837),-- Gloves
(20020,1921,1,1,1,31834),-- Leather Shoes Texture
(20020,1794,1,1,2,3628),-- Recipe: Forest Bow
(20020,1865,1,1,2,49342),-- Varnish
(20020,1870,1,1,2,49342),-- Coal
(20021,1792,1,1,-1,16388),-- Recipe: Short Spear
(20021,1793,1,1,-1,16388),-- Recipe: Sword of Reflection
(20021,1921,1,1,-1,143795),-- Leather Shoes Texture
(20021,57,114,168,0,700000),-- Adena
(20021,9,1,1,1,211),-- Cedar Staff
(20021,154,1,1,1,211),-- Dwarven Mace
(20021,2008,1,1,1,1708),-- Cedar Staff Head
(20021,1060,1,1,2,73151),-- Lesser Healing Potion
(20021,1798,1,1,2,32273),-- Recipe: Leather Helmet
(20021,1865,1,1,2,32918),-- Varnish
(20021,1870,1,1,2,32918),-- Coal
(20022,1831,1,1,-1,505199),-- Antidote
(20022,1872,1,1,-1,252599),-- Animal Bone
(20022,1921,1,1,-1,122225),-- Leather Shoes Texture
(20022,57,97,143,0,700000),-- Adena
(20022,20,1,1,1,5230),-- Buckler
(20022,43,1,1,1,3657),-- Wooden Helmet
(20022,1799,1,1,2,55270),-- Recipe: Leather Gloves
(20022,1864,1,1,2,74615),-- Stem
(20022,1869,1,1,2,37307),-- Iron Ore
(20023,1831,1,1,-1,617635),-- Antidote
(20023,1868,1,1,-1,463226),-- Thread
(20023,1922,1,1,-1,59085),-- Leather Tunic Pattern
(20023,57,116,177,0,700000),-- Adena
(20023,429,1,1,1,1118),-- Leather Tunic
(20023,464,1,1,1,1791),-- Leather Stockings
(20023,1922,1,1,1,8727),-- Leather Tunic Pattern
(20023,1923,1,1,1,14020),-- Leather Stocking Pattern
(20023,735,1,1,2,2851),-- Potion of Alacrity
(20023,1803,1,1,2,28746),-- Recipe: Necklace of Wisdom
(20023,1868,1,1,2,68415),-- Thread
(20023,1873,1,1,2,13683),-- Silver Nugget
(20024,734,1,1,-1,41833),-- Haste Potion
(20024,1864,1,1,-1,501999),-- Stem
(20024,1897,1,1,-1,59762),-- Necklace of Wisdom Chain
(20024,57,122,197,0,700000),-- Adena
(20024,2,1,1,1,71),-- Long Sword
(20024,120,1,1,1,71),-- Sword of Reflection
(20024,121,1,1,1,71),-- Sword of Watershadow
(20024,2012,1,1,1,773),-- Sword of Reflection Blade
(20024,1801,1,1,2,24901),-- Recipe: Piece Bone Gaiters
(20024,1864,1,1,2,98856),-- Stem
(20024,1869,1,1,2,49428),-- Iron Ore
(20025,1799,1,1,-1,349993),-- Recipe: Leather Gloves
(20025,1866,1,1,-1,157497),-- Suede
(20025,1869,1,1,-1,236245),-- Iron Ore
(20025,57,119,180,0,700000),-- Adena
(20025,429,1,1,1,1140),-- Leather Tunic
(20025,464,1,1,1,1827),-- Leather Stockings
(20025,1922,1,1,1,8902),-- Leather Tunic Pattern
(20025,1923,1,1,1,14301),-- Leather Stocking Pattern
(20025,736,1,1,2,23262),-- Scroll of Escape
(20025,1866,1,1,2,31015),-- Suede
(20025,1871,1,1,2,46523),-- Charcoal
(20026,1865,1,1,-1,260380),-- Varnish
(20026,1866,1,1,-1,173586),-- Suede
(20026,1923,1,1,-1,106713),-- Leather Stocking Pattern
(20026,57,131,199,0,700000),-- Adena
(20026,37,1,1,1,5027),-- Leather Shoes
(20026,49,1,1,1,5027),-- Gloves
(20026,1921,1,1,1,33081),-- Leather Shoes Texture
(20026,1792,1,1,2,3771),-- Recipe: Short Spear
(20026,1865,1,1,2,51275),-- Varnish
(20026,1870,1,1,2,51275),-- Coal
(20027,1800,1,1,-1,74706),-- Recipe: Piece Bone Breastplate
(20027,1801,1,1,-1,119680),-- Recipe: Piece Bone Gaiters
(20027,1924,1,1,-1,76634),-- Leather Helmet Design
(20027,57,118,183,0,700000),-- Adena
(20027,176,1,1,1,134),-- Journeyman\'s Staff
(20027,2501,1,1,1,134),-- Bone Club
(20027,1800,1,1,2,11034),-- Recipe: Piece Bone Breastplate
(20027,1865,1,1,2,35087),-- Varnish
(20027,1870,1,1,2,35087),-- Coal
(20027,5158,1,1,2,1404),-- Recipe: Spiritshot (D) Compressed Package (100%)
(20028,734,1,1,-1,39594),-- Haste Potion
(20028,1801,1,1,-1,119680),-- Recipe: Piece Bone Gaiters
(20028,1868,1,1,-1,475131),-- Thread
(20028,57,118,183,0,700000),-- Adena
(20028,845,1,1,1,1026),-- Cat\'s Eye Earring
(20028,877,1,1,1,1539),-- Ring of Wisdom
(20028,908,1,1,1,769),-- Necklace of Wisdom
(20028,1897,1,1,1,8354),-- Necklace of Wisdom Chain
(20028,1817,1,1,2,9357),-- Recipe: Cord
(20028,1864,1,1,2,93565),-- Stem
(20028,1869,1,1,2,46783),-- Iron Ore
(20029,1864,1,1,-1,534142),-- Stem
(20029,1897,1,1,-1,63588),-- Necklace of Wisdom Chain
(20029,2013,1,1,-1,5764),-- Forest Bow Shaft
(20029,57,132,206,0,700000),-- Adena
(20029,15,1,1,1,150),-- Short Spear
(20029,2011,1,1,1,1800),-- Short Spear Edge
(20029,1865,1,1,2,39445),-- Varnish
(20029,1870,1,1,2,39445),-- Coal
(20029,2139,1,1,2,7889),-- Recipe: Steel Mold
(20029,5268,1,1,2,1578),-- Recipe: Greater Soulshot (D) Compressed Package (100%)
(20030,1794,1,1,-1,17030),-- Recipe: Forest Bow
(20030,1798,1,1,-1,227072),-- Recipe: Leather Helmet
(20030,1831,1,1,-1,617635),-- Antidote
(20030,57,116,177,0,700000),-- Adena
(20030,216,1,1,1,329),-- Dirk
(20030,2009,1,1,1,2427),-- Dirk Blade
(20030,1793,1,1,2,3354),-- Recipe: Sword of Reflection
(20030,1865,1,1,2,45611),-- Varnish
(20030,1870,1,1,2,45611),-- Coal
(20031,24,1,1,-1,2629),-- Bone Breastplate
(20031,1865,1,1,-1,205065),-- Varnish
(20031,1924,1,1,-1,66150),-- Leather Helmet Design
(20031,57,100,161,0,700000),-- Adena
(20031,24,1,1,1,388),-- Bone Breastplate
(20031,31,1,1,1,620),-- Bone Gaiters
(20031,390,1,1,1,388),-- Cotton Shirt
(20031,412,1,1,1,620),-- Cotton Pants
(20031,1865,1,1,2,30287),-- Varnish
(20031,1870,1,1,2,30287),-- Coal
(20031,2140,1,1,2,6058),-- Recipe: High Grade Suede
(20031,5273,1,1,2,1212),-- Recipe: Greater Spiritshot (D) Compressed Package(100%)
(20032,734,1,1,-1,41013),-- Haste Potion
(20032,1800,1,1,-1,77383),-- Recipe: Piece Bone Breastplate
(20032,1868,1,1,-1,492156),-- Thread
(20032,57,120,193,0,700000),-- Adena
(20032,24,1,1,1,466),-- Bone Breastplate
(20032,31,1,1,1,744),-- Bone Gaiters
(20032,390,1,1,1,466),-- Cotton Shirt
(20032,412,1,1,1,744),-- Cotton Pants
(20032,1865,1,1,2,48459),-- Varnish
(20032,1870,1,1,2,48459),-- Coal
(20032,2141,1,1,2,9692),-- Recipe: Silver Mold
(20033,1924,1,1,-1,66150),-- Leather Helmet Design
(20033,1925,1,1,-1,134469),-- Leather Gloves Lining
(20033,2139,1,1,-1,41013),-- Recipe: Steel Mold
(20033,57,100,161,0,700000),-- Adena
(20033,845,1,1,1,886),-- Cat\'s Eye Earring
(20033,877,1,1,1,1328),-- Ring of Wisdom
(20033,908,1,1,1,664),-- Necklace of Wisdom
(20033,1897,1,1,1,7212),-- Necklace of Wisdom Chain
(20033,1865,1,1,2,30287),-- Varnish
(20033,1870,1,1,2,30287),-- Coal
(20033,2142,1,1,2,6058),-- Recipe: Varnish of Purity
(20033,5158,1,1,2,1212),-- Recipe: Spiritshot (D) Compressed Package (100%)
(20034,1868,1,1,-1,501999),-- Thread
(20034,1873,1,1,-1,100400),-- Silver Nugget
(20034,2254,1,1,-1,10287),-- Recipe: Composition Bow
(20034,57,122,197,0,700000),-- Adena
(20034,256,1,1,1,282),-- Cestus
(20034,1868,1,1,2,74142),-- Thread
(20034,1873,1,1,2,14829),-- Silver Nugget
(20034,2143,1,1,2,7415),-- Recipe: Synthetic Cokes
(20034,6035,1,1,2,3090),-- Magic Haste Potion
(20035,1868,1,1,-1,492156),-- Thread
(20035,1925,1,1,-1,161363),-- Leather Gloves Lining
(20035,2140,1,1,-1,49216),-- Recipe: High Grade Suede
(20035,57,120,193,0,700000),-- Adena
(20035,38,1,1,1,1860),-- Low Boots
(20035,50,1,1,1,1860),-- Leather Gloves
(20035,1925,1,1,1,31776),-- Leather Gloves Lining
(20035,1817,1,1,2,7269),-- Recipe: Cord
(20035,1868,1,1,2,72688),-- Thread
(20035,1873,1,1,2,14538),-- Silver Nugget
(20035,5268,1,1,2,1454),-- Recipe: Greater Soulshot (D) Compressed Package (100%)
(20036,735,1,1,-1,21527),-- Potion of Alacrity
(20036,1873,1,1,-1,103328),-- Silver Nugget
(20036,2175,1,1,-1,210017),-- Recipe: Boots
(20036,57,124,204,0,700000),-- Adena
(20036,845,1,1,1,1116),-- Cat\'s Eye Earring
(20036,877,1,1,1,1673),-- Ring of Wisdom
(20036,908,1,1,1,837),-- Necklace of Wisdom
(20036,1897,1,1,1,9084),-- Necklace of Wisdom Chain
(20036,1864,1,1,2,76304),-- Stem
(20036,1869,1,1,2,38152),-- Iron Ore
(20036,1878,1,1,2,15261),-- Braided Hemp
(20036,2173,1,1,2,10340),-- Recipe: Hard Leather Shirt
(20038,1868,1,1,-1,557163),-- Thread
(20038,2011,1,1,-1,6355),-- Short Spear Edge
(20038,2174,1,1,-1,121122),-- Recipe: Hard Leather Gaiters
(20038,57,133,220,0,700000),-- Adena
(20038,217,1,1,1,157),-- Shining Knife
(20038,218,1,1,1,157),-- Throwing Knife
(20038,1831,1,1,2,54859),-- Antidote
(20038,1867,1,1,2,27430),-- Animal Skin
(20038,1869,1,1,2,20573),-- Iron Ore
(20038,1870,1,1,2,20573),-- Coal
(20038,1871,1,1,2,20573),-- Charcoal
(20038,1872,1,1,2,27430),-- Animal Bone
(20038,2174,1,1,2,8945),-- Recipe: Hard Leather Gaiters
(20038,5273,1,1,2,823),-- Recipe: Greater Spiritshot (D) Compressed Package(100%)
(20039,1801,1,1,-1,127585),-- Recipe: Piece Bone Gaiters
(20039,1872,1,1,-1,337674),-- Animal Bone
(20039,2011,1,1,-1,5777),-- Short Spear Edge
(20039,57,121,200,0,700000),-- Adena
(20039,44,1,1,1,957),-- Leather Helmet
(20039,102,1,1,1,1368),-- Round Shield
(20039,945,1,1,1,2834),-- Skeleton Buckler
(20039,1924,1,1,1,12066),-- Leather Helmet Design
(20039,735,1,1,2,1782),-- Potion of Alacrity
(20039,1864,1,1,2,42748),-- Stem
(20039,1865,1,1,2,21374),-- Varnish
(20039,1866,1,1,2,14250),-- Suede
(20039,1868,1,1,2,42748),-- Thread
(20039,1873,1,1,2,8550),-- Silver Nugget
(20039,2175,1,1,2,17377),-- Recipe: Boots
(20040,2012,1,1,-1,4397),-- Sword of Reflection Blade
(20040,2140,1,1,-1,42209),-- Recipe: High Grade Suede
(20040,2175,1,1,-1,171583),-- Recipe: Boots
(20040,57,101,167,0,700000),-- Adena
(20040,44,1,1,1,797),-- Leather Helmet
(20040,102,1,1,1,1140),-- Round Shield
(20040,945,1,1,1,2361),-- Skeleton Buckler
(20040,1924,1,1,1,10055),-- Leather Helmet Design
(20040,1868,1,1,2,62340),-- Thread
(20040,1873,1,1,2,12468),-- Silver Nugget
(20040,2252,1,1,2,1278),-- Recipe: Iron Hammer
(20040,5158,1,1,2,1247),-- Recipe: Spiritshot (D) Compressed Package (100%)
(20041,1817,1,1,-1,47452),-- Recipe: Cord
(20041,1880,1,1,-1,23726),-- Steel
(20041,2012,1,1,-1,4943),-- Sword of Reflection Blade
(20041,57,114,187,0,700000),-- Adena
(20041,217,1,1,1,134),-- Shining Knife
(20041,218,1,1,1,134),-- Throwing Knife
(20041,1866,1,1,2,31148),-- Suede
(20041,1871,1,1,2,46722),-- Charcoal
(20041,2253,1,1,2,1915),-- Recipe: Sword Breaker
(20042,734,1,1,-1,43053),-- Haste Potion
(20042,2013,1,1,-1,5575),-- Forest Bow Shaft
(20042,57,124,204,0,700000),-- Adena
(20042,309,1,1,1,146),-- Tears of Eva
(20042,310,1,1,1,146),-- Relic of The Saints
(20042,1867,1,1,2,40696),-- Animal Skin
(20042,1872,1,1,2,40696),-- Animal Bone
(20042,1882,1,1,2,6783),-- Leather
(20042,2254,1,1,2,1251),-- Recipe: Composition Bow
(20042,5268,1,1,2,1221),-- Recipe: Greater Soulshot (D) Compressed Package (100%)
(20043,1817,1,1,-1,58608),-- Recipe: Cord
(20043,1864,1,1,-1,586083),-- Stem
(20043,1924,1,1,-1,94529),-- Leather Helmet Design
(20043,57,137,234,0,700000),-- Adena
(20043,2,1,1,1,82),-- Long Sword
(20043,120,1,1,1,82),-- Sword of Reflection
(20043,121,1,1,1,82),-- Sword of Watershadow
(20043,2012,1,1,1,902),-- Sword of Reflection Blade
(20043,1831,1,1,2,57707),-- Antidote
(20043,1864,1,1,2,43280),-- Stem
(20043,1865,1,1,2,21640),-- Varnish
(20043,1866,1,1,2,14427),-- Suede
(20043,1868,1,1,2,43280),-- Thread
(20043,1873,1,1,2,8657),-- Silver Nugget
(20043,2143,1,1,2,4328),-- Recipe: Synthetic Cokes
(20043,5158,1,1,2,866),-- Recipe: Spiritshot (D) Compressed Package (100%)
(20044,1865,1,1,-1,266401),-- Varnish
(20044,1872,1,1,-1,355202),-- Animal Bone
(20044,2142,1,1,-1,53280),-- Recipe: Varnish of Purity
(20044,57,125,213,0,700000),-- Adena
(20044,309,1,1,1,150),-- Tears of Eva
(20044,310,1,1,1,150),-- Relic of The Saints
(20044,1867,1,1,2,52461),-- Animal Skin
(20044,1872,1,1,2,52461),-- Animal Bone
(20044,1881,1,1,2,5246),-- Coarse Bone Powder
(20044,2144,1,1,2,7870),-- Recipe: Compound Braid
(20045,734,1,1,-1,44835),-- Haste Potion
(20045,1925,1,1,-1,176402),-- Leather Gloves Lining
(20045,57,126,215,0,700000),-- Adena
(20045,217,1,1,1,152),-- Shining Knife
(20045,218,1,1,1,152),-- Throwing Knife
(20045,1866,1,1,2,26488),-- Suede
(20045,1871,1,1,2,39732),-- Charcoal
(20045,2150,1,1,2,18654),-- Recipe: Blue Diamond Necklace
(20045,5268,1,1,2,1590),-- Recipe: Greater Soulshot (D) Compressed Package (100%)
(20046,735,1,1,-1,20390),-- Potion of Alacrity
(20046,1897,1,1,-1,58257),-- Necklace of Wisdom Chain
(20046,2139,1,1,-1,48936),-- Recipe: Steel Mold
(20046,57,115,195,0,700000),-- Adena
(20046,845,1,1,1,1057),-- Cat\'s Eye Earring
(20046,877,1,1,1,1585),-- Ring of Wisdom
(20046,908,1,1,1,792),-- Necklace of Wisdom
(20046,1897,1,1,1,8604),-- Necklace of Wisdom Chain
(20046,1867,1,1,2,48184),-- Animal Skin
(20046,1872,1,1,2,48184),-- Animal Bone
(20046,1882,1,1,2,8031),-- Leather
(20046,2173,1,1,2,9794),-- Recipe: Hard Leather Shirt
(20047,38,1,1,-1,8522),-- Low Boots
(20047,1869,1,1,-1,222001),-- Iron Ore
(20047,2139,1,1,-1,44400),-- Recipe: Steel Mold
(20047,57,104,177,0,700000),-- Adena
(20047,24,1,1,1,420),-- Bone Breastplate
(20047,31,1,1,1,671),-- Bone Gaiters
(20047,390,1,1,1,420),-- Cotton Shirt
(20047,412,1,1,1,671),-- Cotton Pants
(20047,734,1,1,2,3644),-- Haste Potion
(20047,1864,1,1,2,43717),-- Stem
(20047,1869,1,1,2,21859),-- Iron Ore
(20047,1878,1,1,2,8744),-- Braided Hemp
(20047,2174,1,1,2,9504),-- Recipe: Hard Leather Gaiters
(20047,5273,1,1,2,875),-- Recipe: Greater Spiritshot (D) Compressed Package(100%)
(20048,50,1,1,-1,6785),-- Leather Gloves
(20048,1924,1,1,-1,74091),-- Leather Helmet Design
(20048,2144,1,1,-1,45937),-- Recipe: Compound Braid
(20048,57,106,184,0,700000),-- Adena
(20048,256,1,1,1,258),-- Cestus
(20048,1868,1,1,2,90461),-- Thread
(20048,1873,1,1,2,18092),-- Silver Nugget
(20048,2142,1,1,2,9046),-- Recipe: Varnish of Purity
(20049,1882,1,1,-1,61249),-- Leather
(20049,1924,1,1,-1,88910),-- Leather Helmet Design
(20049,2140,1,1,-1,55124),-- Recipe: High Grade Suede
(20049,57,127,221,0,700000),-- Adena
(20049,256,1,1,1,310),-- Cestus
(20049,1867,1,1,2,43421),-- Animal Skin
(20049,1872,1,1,2,43421),-- Animal Bone
(20049,1881,1,1,2,4343),-- Coarse Bone Powder
(20049,2143,1,1,2,6514),-- Recipe: Synthetic Cokes
(20049,5158,1,1,2,1303),-- Recipe: Spiritshot (D) Compressed Package (100%)
(20050,735,1,1,-1,25265),-- Potion of Alacrity
(20050,1866,1,1,-1,202121),-- Suede
(20050,1925,1,1,-1,198808),-- Leather Gloves Lining
(20050,57,140,243,0,700000),-- Adena
(20050,15,1,1,1,171),-- Short Spear
(20050,2011,1,1,1,2044),-- Short Spear Edge
(20050,1831,1,1,2,119407),-- Antidote
(20050,1866,1,1,2,29852),-- Suede
(20050,1871,1,1,2,44778),-- Charcoal
(20050,2144,1,1,2,8956),-- Recipe: Compound Braid
(20051,1867,1,1,-1,371096),-- Animal Skin
(20051,1925,1,1,-1,182506),-- Leather Gloves Lining
(20051,2254,1,1,-1,11407),-- Recipe: Composition Bow
(20051,57,129,223,0,700000),-- Adena
(20051,272,1,1,1,157),-- Forest Bow
(20051,2013,1,1,1,1775),-- Forest Bow Shaft
(20051,1867,1,1,2,43847),-- Animal Skin
(20051,1872,1,1,2,43847),-- Animal Bone
(20051,1881,1,1,2,4385),-- Coarse Bone Powder
(20051,2150,1,1,2,15439),-- Recipe: Blue Diamond Necklace
(20051,5268,1,1,2,1316),-- Recipe: Greater Soulshot (D) Compressed Package (100%)
(20052,1866,1,1,-1,193642),-- Suede
(20052,1868,1,1,-1,580926),-- Thread
(20052,1869,1,1,-1,290463),-- Iron Ore
(20052,57,132,236,0,700000),-- Adena
(20052,219,1,1,1,91),-- Sword Breaker
(20052,2015,1,1,1,1047),-- Sword Breaker Edge
(20052,1804,1,1,2,1373),-- Recipe: Soulshot: D-Grade
(20052,1864,1,1,2,68639),-- Stem
(20052,1869,1,1,2,34319),-- Iron Ore
(20052,1880,1,1,2,3432),-- Steel
(20052,5158,1,1,2,1373),-- Recipe: Spiritshot (D) Compressed Package (100%)
(20053,1898,1,1,-1,36155),-- Blue Diamond Necklace Gem
(20053,1926,1,1,-1,35553),-- Piece Bone Breastplate Fragment
(20053,2015,1,1,-1,4292),-- Sword Breaker Edge
(20053,57,160,286,0,700000),-- Adena
(20053,39,1,1,1,1459),-- Boots
(20053,51,1,1,1,1459),-- Bracer
(20053,1930,1,1,1,17773),-- Boot Lining
(20053,1864,1,1,2,83174),-- Stem
(20053,1869,1,1,2,41587),-- Iron Ore
(20053,1878,1,1,2,16635),-- Braided Hemp
(20053,2151,1,1,2,11584),-- Recipe: Necklace of Devotion
(20053,5437,1,1,2,1017),-- Recipe: Heavy Sword(100%)
(20054,1804,1,1,-1,13669),-- Recipe: Soulshot: D-Grade
(20054,1880,1,1,-1,34172),-- Steel
(20054,3032,1,1,-1,13669),-- Recipe: Spiritshot D
(20054,57,156,278,0,700000),-- Adena
(20054,39,1,1,1,1417),-- Boots
(20054,51,1,1,1,1417),-- Bracer
(20054,1930,1,1,1,17255),-- Boot Lining
(20054,1867,1,1,2,53834),-- Animal Skin
(20054,1872,1,1,2,53834),-- Animal Bone
(20054,1882,1,1,2,8972),-- Leather
(20054,2176,1,1,2,19318),-- Recipe: Leather Boots
(20054,5268,1,1,2,1615),-- Recipe: Greater Soulshot (D) Compressed Package (100%)
(20055,1926,1,1,-1,34517),-- Piece Bone Breastplate Fragment
(20055,1928,1,1,-1,49777),-- Piece Bone Gaiters Fragment
(20055,2176,1,1,-1,163503),-- Recipe: Leather Boots
(20055,57,156,278,0,700000),-- Adena
(20055,219,1,1,1,107),-- Sword Breaker
(20055,2015,1,1,1,1231),-- Sword Breaker Edge
(20055,735,1,1,2,3365),-- Potion of Alacrity
(20055,1864,1,1,2,80751),-- Stem
(20055,1869,1,1,2,40376),-- Iron Ore
(20055,1880,1,1,2,4038),-- Steel
(20055,2177,1,1,2,12900),-- Recipe: Bone Helmet
(20056,1926,1,1,-1,34201),-- Piece Bone Breastplate Fragment
(20056,2151,1,1,-1,94314),-- Recipe: Necklace of Devotion
(20056,5163,1,1,-1,13543),-- Recipe: Blessed Spiritshot (D) Compressed Package (100%)
(20056,57,154,276,0,700000),-- Adena
(20056,27,1,1,1,352),-- Hard Leather Shirt
(20056,33,1,1,1,565),-- Hard Leather Gaiters
(20056,1927,1,1,1,3989),-- Hard Leather Shirt Pattern
(20056,1929,1,1,1,6452),-- Hard Leather Gaiters Material
(20056,734,1,1,2,8334),-- Haste Potion
(20056,1868,1,1,2,100013),-- Thread
(20056,1873,1,1,2,20003),-- Silver Nugget
(20056,2256,1,1,2,1223),-- Recipe: Assassin Knife
(20057,1927,1,1,-1,24556),-- Hard Leather Shirt Pattern
(20057,2176,1,1,-1,147276),-- Recipe: Leather Boots
(20057,2258,1,1,-1,7526),-- Recipe: Temptation of Abyss
(20057,57,140,251,0,700000),-- Adena
(20057,1102,1,1,1,640),-- Tunic of Magic
(20057,1105,1,1,1,1028),-- Stockings of Magic
(20057,1865,1,1,2,45461),-- Varnish
(20057,1870,1,1,2,45461),-- Coal
(20057,2257,1,1,2,1111),-- Recipe: Trident
(20057,5273,1,1,2,1818),-- Recipe: Greater Spiritshot (D) Compressed Package(100%)
(20058,1865,1,1,-1,362125),-- Varnish
(20058,1873,1,1,-1,144850),-- Silver Nugget
(20058,1926,1,1,-1,36578),-- Piece Bone Breastplate Fragment
(20058,57,164,295,0,700000),-- Adena
(20058,16,1,1,1,228),-- Long Spear
(20058,1865,1,1,2,53483),-- Varnish
(20058,1870,1,1,2,53483),-- Coal
(20058,1879,1,1,2,8914),-- Cokes
(20058,2258,1,1,2,1308),-- Recipe: Temptation of Abyss
(20059,32,1,1,-1,4734),-- Piece Bone Gaiters
(20059,1879,1,1,-1,60354),-- Cokes
(20059,2177,1,1,-1,115695),-- Recipe: Bone Helmet
(20059,57,164,295,0,700000),-- Adena
(20059,625,1,1,1,2161),-- Bone Shield
(20059,1148,1,1,1,1506),-- Hard Leather Helmet
(20059,1865,1,1,2,53483),-- Varnish
(20059,1870,1,1,2,53483),-- Coal
(20059,3032,1,1,2,2139),-- Recipe: Spiritshot D
(20059,5158,1,1,2,2139),-- Recipe: Spiritshot (D) Compressed Package (100%)
(20060,1869,1,1,-1,369368),-- Iron Ore
(20060,1928,1,1,-1,53805),-- Piece Bone Gaiters Fragment
(20060,57,168,301,0,700000),-- Adena
(20060,87,1,1,1,58),-- Iron Hammer
(20060,155,1,1,1,58),-- Buzdygan
(20060,177,1,1,1,58),-- Mage Staff
(20060,2014,1,1,1,627),-- Iron Hammer Head
(20060,735,1,1,2,3637),-- Potion of Alacrity
(20060,1865,1,1,2,43642),-- Varnish
(20060,1870,1,1,2,43642),-- Coal
(20060,3953,1,1,2,1746),-- Recipe: Blessed Spiritshot D
(20060,6666,1,1,2,43642),-- Deluxe Chest Key - Grade 2
(20061,1880,1,1,-1,38571),-- Steel
(20061,1927,1,1,-1,30770),-- Hard Leather Shirt Pattern
(20061,2176,1,1,-1,184549),-- Recipe: Leather Boots
(20061,57,177,312,0,700000),-- Adena
(20061,273,1,1,1,121),-- Composition Bow
(20061,2016,1,1,1,1335),-- Composition Bow Shaft
(20061,1866,1,1,2,30382),-- Suede
(20061,1871,1,1,2,45573),-- Charcoal
(20061,2257,1,1,2,1114),-- Recipe: Trident
(20061,5268,1,1,2,1823),-- Recipe: Greater Soulshot (D) Compressed Package (100%)
(20061,6666,1,1,2,45573),-- Deluxe Chest Key - Grade 2
(20062,27,1,1,-1,2663),-- Hard Leather Shirt
(20062,1929,1,1,-1,48793),-- Hard Leather Gaiters Material
(20062,2257,1,1,-1,9246),-- Recipe: Trident
(20062,57,173,305,0,700000),-- Adena
(20062,219,1,1,1,119),-- Sword Breaker
(20062,2015,1,1,1,1362),-- Sword Breaker Edge
(20062,1867,1,1,2,59572),-- Animal Skin
(20062,1872,1,1,2,59572),-- Animal Bone
(20062,1881,1,1,2,5957),-- Coarse Bone Powder
(20062,2258,1,1,2,1092),-- Recipe: Temptation of Abyss
(20062,6666,1,1,2,44679),-- Deluxe Chest Key - Grade 2
(20063,34,1,1,-1,3486),-- Bronze Gaiters
(20063,2176,1,1,-1,196828),-- Recipe: Leather Boots
(20063,2177,1,1,-1,131428),-- Recipe: Bone Helmet
(20063,57,183,337,0,700000),-- Adena
(20063,273,1,1,1,129),-- Composition Bow
(20063,2016,1,1,1,1424),-- Composition Bow Shaft
(20063,1804,1,1,2,1621),-- Recipe: Soulshot: D-Grade
(20063,1867,1,1,2,54006),-- Animal Skin
(20063,1872,1,1,2,54006),-- Animal Bone
(20063,1882,1,1,2,9001),-- Leather
(20063,8294,1,1,2,990),-- Recipe: Steel Sword (100%)
(20063,6666,1,1,2,40504),-- Deluxe Chest Key - Grade 2
(20064,1873,1,1,-1,162950),-- Silver Nugget
(20064,1926,1,1,-1,41149),-- Piece Bone Breastplate Fragment
(20064,1930,1,1,-1,104455),-- Boot Lining
(20064,57,181,335,0,700000),-- Adena
(20064,27,1,1,1,424),-- Hard Leather Shirt
(20064,33,1,1,1,680),-- Hard Leather Gaiters
(20064,1927,1,1,1,4800),-- Hard Leather Shirt Pattern
(20064,1929,1,1,1,7763),-- Hard Leather Gaiters Material
(20064,734,1,1,2,8022),-- Haste Potion
(20064,1866,1,1,2,32089),-- Suede
(20064,1871,1,1,2,48133),-- Charcoal
(20064,2179,1,1,2,23030),-- Recipe: Crafted Leather Gloves
(20064,5273,1,1,2,1925),-- Recipe: Greater Spiritshot (D) Compressed Package(100%)
(20066,347,1,1,-1,1387),-- Ring Mail Breastplate
(20066,1865,1,1,-1,445204),-- Varnish
(20066,1873,1,1,-1,178082),-- Silver Nugget
(20066,57,196,367,0,700000),-- Adena
(20066,347,1,1,1,389),-- Ring Mail Breastplate
(20066,376,1,1,1,623),-- Iron Plate Gaiters
(20066,1868,1,1,2,99945),-- Thread
(20066,1873,1,1,2,19989),-- Silver Nugget
(20066,2178,1,1,2,7996),-- Recipe: Dark Stockings
(20066,8294,1,1,2,1222),-- Recipe: Steel Sword (100%)
(20066,5549,1,1,2,4997),-- Metallic Thread
(20067,1869,1,1,-1,419687),-- Iron Ore
(20067,2020,1,1,-1,7347),-- Temptation of Abyss Piece
(20067,2180,1,1,-1,31555),-- Recipe: Scale Mail
(20067,57,185,346,0,700000),-- Adena
(20067,847,1,1,1,569),-- Red Crescent Earring
(20067,890,1,1,1,853),-- Ring of Devotion
(20067,910,1,1,1,427),-- Necklace of Devotion
(20067,1899,1,1,1,9201),-- Necklace of Devotion Chain
(20067,1864,1,1,2,117771),-- Stem
(20067,1869,1,1,2,58885),-- Iron Ore
(20067,1878,1,1,2,23554),-- Braided Hemp
(20067,2180,1,1,2,4428),-- Recipe: Scale Mail
(20068,391,1,1,-1,1871),-- Puma Skin Shirt
(20068,1899,1,1,-1,70456),-- Necklace of Devotion Chain
(20068,2261,1,1,-1,7002),-- Recipe: Conjuror\'s Staff
(20068,57,196,374,0,700000),-- Adena
(20068,101,1,1,1,32),-- Scroll of Wisdom
(20068,312,1,1,1,32),-- Branch of Life
(20068,313,1,1,1,32),-- Temptation of Abyss
(20068,314,1,1,1,32),-- Proof of Revenge
(20068,2020,1,1,1,886),-- Temptation of Abyss Piece
(20068,1864,1,1,2,126534),-- Stem
(20068,1869,1,1,2,63267),-- Iron Ore
(20068,1878,1,1,2,25307),-- Braided Hemp
(20068,2262,1,1,2,982),-- Recipe: Elven Bow
(20070,1872,1,1,-1,621523),-- Animal Bone
(20070,2152,1,1,-1,82067),-- Recipe: Enchanted Necklace
(20070,2182,1,1,-1,55959),-- Recipe: Scale Gaiters
(20070,57,201,388,0,700000),-- Adena
(20070,40,1,1,1,812),-- Leather Boots
(20070,604,1,1,1,812),-- Crafted Leather Gloves
(20070,1931,1,1,1,8550),-- Leather Boot Lining
(20070,1934,1,1,1,8550),-- Crafted Leather Gloves Lining
(20070,1867,1,1,2,69763),-- Animal Skin
(20070,1872,1,1,2,69763),-- Animal Bone
(20070,1875,1,1,2,3488),-- Stone of Purity
(20070,1881,1,1,2,6976),-- Coarse Bone Powder
(20070,2263,1,1,2,813),-- Recipe: Dwarven Trident
(20072,1931,1,1,-1,64050),-- Leather Boot Lining
(20072,2263,1,1,-1,7608),-- Recipe: Dwarven Trident
(20072,3953,1,1,-1,19599),-- Recipe: Blessed Spiritshot D
(20072,57,210,411,0,700000),-- Adena
(20072,45,1,1,1,761),-- Bone Helmet
(20072,626,1,1,1,1085),-- Bronze Shield
(20072,1932,1,1,1,14550),-- Bone Helmet Design
(20072,1866,1,1,2,26190),-- Suede
(20072,1871,1,1,2,39285),-- Charcoal
(20072,1885,1,1,2,3274),-- High Grade Suede
(20072,2262,1,1,2,610),-- Recipe: Elven Bow
(20072,5220,1,1,2,1571),-- Metal Hardener
(20072,6035,1,1,2,3274),-- Magic Haste Potion
(20072,6666,1,1,2,39285),-- Deluxe Chest Key - Grade 2
(20074,1061,1,1,-1,307751),-- Healing Potion
(20074,1869,1,1,-1,507790),-- Iron Ore
(20074,1900,1,1,-1,55557),-- Enchanted Necklace Chain
(20074,57,215,426,0,700000),-- Adena
(20074,605,1,1,1,1084),-- Leather Gauntlets
(20074,1123,1,1,1,1084),-- Blue Buckskin Boots
(20074,1864,1,1,2,92496),-- Stem
(20074,1869,1,1,2,46248),-- Iron Ore
(20074,1880,1,1,2,4625),-- Steel
(20074,5550,1,1,2,617),-- Durable Metal Plate
(20074,737,1,1,2,4625),-- Scroll of Resurrection
(20074,6387,1,1,2,1850),-- Blessed Scroll of Resurrection for Pets
(20075,348,1,1,-1,908),-- Scale Mail
(20075,1061,1,1,-1,282105),-- Healing Potion
(20075,2153,1,1,-1,72391),-- Recipe: Tiger\'s Eye Earring
(20075,57,197,391,0,700000),-- Adena
(20075,848,1,1,1,388),-- Enchanted Earring
(20075,879,1,1,1,583),-- Enchanted Ring
(20075,911,1,1,1,291),-- Enchanted Necklace
(20075,1900,1,1,1,6958),-- Enchanted Necklace Chain
(20075,955,1,1,2,170),-- Scroll: Enchant Weapon (Grade D)
(20075,1831,1,1,2,113051),-- Antidote
(20075,1866,1,1,2,28263),-- Suede
(20075,1871,1,1,2,42394),-- Charcoal
(20075,1877,1,1,2,1696),-- Adamantite Nugget
(20075,2193,1,1,2,5675),-- Recipe: Boots of Power
(20076,1880,1,1,-1,53866),-- Steel
(20076,1900,1,1,-1,58935),-- Enchanted Necklace Chain
(20076,2250,1,1,-1,134666),-- Recipe: Bone Arrow
(20076,57,228,452,0,700000),-- Adena
(20076,605,1,1,1,1150),-- Leather Gauntlets
(20076,1123,1,1,1,1150),-- Blue Buckskin Boots
(20076,956,1,1,2,1635),-- Scroll: Enchant Armor (Grade D)
(20076,1864,1,1,2,98119),-- Stem
(20076,1869,1,1,2,49060),-- Iron Ore
(20076,1880,1,1,2,4906),-- Steel
(20076,2274,1,1,2,350),-- Recipe: Skull Breaker
(20076,5550,1,1,2,654),-- Durable Metal Plate
(20077,1933,1,1,-1,62468),-- Dark Stocking Fabric
(20077,2153,1,1,-1,82578),-- Recipe: Tiger\'s Eye Earring
(20077,2183,1,1,-1,34933),-- Recipe: Mithril Banded Mail
(20077,57,224,448,0,700000),-- Adena
(20077,46,1,1,1,756),-- Bronze Helmet
(20077,627,1,1,1,1078),-- Aspis
(20077,955,1,1,2,290),-- Scroll: Enchant Weapon (Grade D)
(20077,1865,1,1,2,72540),-- Varnish
(20077,1870,1,1,2,72540),-- Coal
(20077,1874,1,1,2,4836),-- Oriharukon Ore
(20078,1900,1,1,-1,58094),-- Enchanted Necklace Chain
(20078,2023,1,1,-1,6580),-- Conjuror\'s Staff Head
(20078,2024,1,1,-1,7564),-- Elven Bow Shaft
(20078,57,224,448,0,700000),-- Adena
(20078,433,1,1,1,94),-- Elven Tunic
(20078,434,1,1,1,94),-- White Tunic
(20078,435,1,1,1,94),-- Mystic\'s Tunic
(20078,466,1,1,1,151),-- Elven Stockings
(20078,467,1,1,1,151),-- Dark Stockings
(20078,468,1,1,1,151),-- Mystic\'s Stockings
(20078,1933,1,1,1,4267),-- Dark Stocking Fabric
(20078,1936,1,1,1,2968),-- White Tunic Pattern
(20078,736,1,1,2,29016),-- Scroll of Escape
(20078,1868,1,1,2,116063),-- Thread
(20078,1873,1,1,2,23213),-- Silver Nugget
(20078,1889,1,1,2,3869),-- Compound Braid
(20078,5549,1,1,2,5803),-- Metallic Thread
(20079,1866,1,1,-1,353985),-- Suede
(20079,1881,1,1,-1,70797),-- Coarse Bone Powder
(20079,2266,1,1,-1,5491),-- Recipe: Shilen Knife
(20079,57,224,448,0,700000),-- Adena
(20079,848,1,1,1,442),-- Enchanted Earring
(20079,879,1,1,1,665),-- Enchanted Ring
(20079,911,1,1,1,332),-- Enchanted Necklace
(20079,1900,1,1,1,7936),-- Enchanted Necklace Chain
(20079,1061,1,1,2,25122),-- Healing Potion
(20079,1867,1,1,2,55268),-- Animal Skin
(20079,1872,1,1,2,55268),-- Animal Bone
(20079,1875,1,1,2,2763),-- Stone of Purity
(20079,1881,1,1,2,5527),-- Coarse Bone Powder
(20079,2183,1,1,2,2727),-- Recipe: Mithril Banded Mail
(20079,2278,1,1,2,296),-- Recipe: Strengthened Long Bow
(20080,1878,1,1,-1,230138),-- Braided Hemp
(20080,2021,1,1,-1,7264),-- Spinebone Sword Blade
(20080,2268,1,1,-1,5950),-- Recipe: Tome of Blood
(20080,57,243,485,0,700000),-- Adena
(20080,259,1,1,1,127),-- Single-Edged Jamadhr
(20080,737,1,1,2,5240),-- Scroll of Resurrection
(20080,1864,1,1,2,104801),-- Stem
(20080,1869,1,1,2,52401),-- Iron Ore
(20080,1878,1,1,2,20960),-- Braided Hemp
(20080,1884,1,1,2,32247),-- Cord
(20080,6387,1,1,2,2096),-- Blessed Scroll of Resurrection for Pets
(20081,1061,1,2,-1,583400),-- Healing Potion
(20081,1933,1,1,-1,113248),-- Dark Stocking Fabric
(20081,57,406,814,0,700000),-- Adena
(20081,848,1,1,1,802),-- Enchanted Earring
(20081,879,1,1,1,1206),-- Enchanted Ring
(20081,911,1,1,1,602),-- Enchanted Necklace
(20081,1900,1,1,1,14388),-- Enchanted Necklace Chain
(20081,1874,1,1,2,5010),-- Oriharukon Ore
(20081,1878,1,1,2,30059),-- Braided Hemp
(20081,1884,1,1,2,46244),-- Cord
(20081,1889,1,1,2,5010),-- Compound Braid
(20081,2267,1,1,2,777),-- Recipe: Gastraphetes
(20081,2274,1,1,2,537),-- Recipe: Skull Breaker
(20081,5220,1,1,2,3006),-- Metal Hardener
(20082,1884,1,1,-1,357298),-- Cord
(20082,1901,1,1,-1,80195),-- Tiger\'s Eye Earring Stone
(20082,2275,1,1,-1,4147),-- Recipe: Heavy Bone Club
(20082,57,245,491,0,700000),-- Adena
(20082,63,1,1,1,226),-- Gauntlets
(20082,553,1,1,1,226),-- Iron Boots
(20082,1940,1,1,1,6582),-- Iron Boots Design
(20082,2422,1,1,1,226),-- Reinforced Leather Boots
(20082,2423,1,1,1,226),-- Boots of Knowledge
(20082,2446,1,1,1,226),-- Reinforced Leather Gloves
(20082,2447,1,1,1,226),-- Gloves of Knowledge
(20082,1832,1,1,2,42875),-- Greater Antidote
(20082,1875,1,1,2,2573),-- Stone of Purity
(20082,1879,1,1,2,6431),-- Cokes
(20082,1885,1,1,2,3216),-- High Grade Suede
(20082,2154,1,1,2,4131),-- Recipe: Elven Earring
(20082,2190,1,1,2,2756),-- Recipe: Mithril Stockings
(20082,5549,1,1,2,3859),-- Metallic Thread
(20082,5550,1,1,2,515),-- Durable Metal Plate
(20083,2154,1,1,-1,76237),-- Recipe: Elven Earring
(20083,2975,1,1,-1,63577),-- Recipe: Brigandine Helmet
(20083,2987,1,1,-1,69132),-- Recipe: Plate Shield
(20083,57,301,602,0,700000),-- Adena
(20083,393,1,1,1,108),-- Mithril Banded Mail
(20083,394,1,1,1,108),-- Reinforced Leather Shirt
(20083,415,1,1,1,172),-- Mithril Banded Gaiters
(20083,416,1,1,1,172),-- Reinforced Leather Gaiters
(20083,1938,1,1,1,4242),-- Mithril Banded Mail Material
(20083,1939,1,1,1,5542),-- Mithril Banded Gaiters Material
(20083,1874,1,1,2,3155),-- Oriharukon Ore
(20083,1878,1,1,2,18930),-- Braided Hemp
(20083,1884,1,1,2,29123),-- Cord
(20083,1889,1,1,2,3155),-- Compound Braid
(20083,2155,1,1,2,7596),-- Recipe: Elven Ring
(20083,2286,1,1,2,263),-- Recipe: Bonebreaker
(20083,2985,1,1,2,4839),-- Recipe: Plate Boots
(20083,5220,1,1,2,1893),-- Metal Hardener
(20084,1885,1,1,-1,55207),-- High Grade Suede
(20084,1938,1,1,-1,44537),-- Mithril Banded Mail Material
(20084,2978,1,1,-1,88686),-- Recipe: Elven Mithril Boots
(20084,57,280,558,0,700000),-- Adena
(20084,47,1,1,1,601),-- Helmet
(20084,628,1,1,1,859),-- Hoplon
(20084,1341,10,30,2,146765),-- Bone Arrow
(20084,1876,1,1,2,8806),-- Mithril Ore
(20084,1877,1,1,2,1761),-- Adamantite Nugget
(20084,1880,1,1,2,4403),-- Steel
(20084,1881,1,1,2,5871),-- Coarse Bone Powder
(20084,1882,1,1,2,9784),-- Leather
(20084,2269,1,1,2,315),-- Recipe: Morning Star
(20084,2971,1,1,2,2354),-- Recipe: Mithril Scale Gaiters
(20085,2155,1,1,-1,122961),-- Recipe: Elven Ring
(20085,2278,1,1,-1,5472),-- Recipe: Strengthened Long Bow
(20085,2422,1,1,-1,3918),-- Reinforced Leather Boots
(20085,57,324,645,0,700000),-- Adena
(20085,63,1,1,1,298),-- Gauntlets
(20085,553,1,1,1,298),-- Iron Boots
(20085,1940,1,1,1,8684),-- Iron Boots Design
(20085,2422,1,1,1,298),-- Reinforced Leather Boots
(20085,2423,1,1,1,298),-- Boots of Knowledge
(20085,2446,1,1,1,298),-- Reinforced Leather Gloves
(20085,2447,1,1,1,298),-- Gloves of Knowledge
(20085,1865,1,1,2,67884),-- Varnish
(20085,1870,1,1,2,67884),-- Coal
(20085,1874,1,1,2,4526),-- Oriharukon Ore
(20085,2270,1,1,2,485),-- Recipe: Goat Head Staff
(20085,2293,1,1,2,377),-- Recipe: Glaive
(20085,2986,1,1,2,6941),-- Recipe: Sage\'s Worn Gloves
(20086,469,1,1,-1,1607),-- Stockings of Knowledge
(20086,1868,1,3,-1,588224),-- Thread
(20086,1939,1,1,-1,51667),-- Mithril Banded Gaiters Material
(20086,57,248,496,0,700000),-- Adena
(20086,436,1,1,1,267),-- Tunic of Knowledge
(20086,469,1,1,1,428),-- Stockings of Knowledge
(20086,1874,1,1,2,2979),-- Oriharukon Ore
(20086,1878,1,1,2,17872),-- Braided Hemp
(20086,1884,1,1,2,27495),-- Cord
(20086,1889,1,1,2,2979),-- Compound Braid
(20086,2972,1,1,2,2389),-- Recipe: Brigandine Gaiters
(20086,8307,1,1,2,319),-- Recipe: Priest Mace (100%)
(20086,5220,1,1,2,1787),-- Metal Hardener
(20087,1866,1,1,-1,940782),-- Suede
(20087,1940,1,1,-1,210623),-- Iron Boots Design
(20087,2191,1,1,-1,188912),-- Recipe: RIP Gauntlets
(20087,57,596,1189,0,700000),-- Adena
(20087,393,1,1,1,214),-- Mithril Banded Mail
(20087,394,1,1,1,214),-- Reinforced Leather Shirt
(20087,415,1,1,1,342),-- Mithril Banded Gaiters
(20087,416,1,1,1,342),-- Reinforced Leather Gaiters
(20087,1938,1,1,1,8407),-- Mithril Banded Mail Material
(20087,1939,1,1,1,10984),-- Mithril Banded Gaiters Material
(20087,1832,1,1,2,104210),-- Greater Antidote
(20087,1866,1,1,2,62526),-- Suede
(20087,1871,1,1,2,93789),-- Charcoal
(20087,1877,1,1,2,3752),-- Adamantite Nugget
(20087,2975,1,1,2,8374),-- Recipe: Brigandine Helmet
(20087,2980,1,1,2,12555),-- Recipe: Brigandine Gauntlets
(20087,2984,1,1,2,9590),-- Recipe: Salamander Skin Boots
(20087,3020,1,1,2,521),-- Recipe: Elven Long Sword
(20088,1875,1,1,-1,104629),-- Stone of Purity
(20088,1895,1,1,-1,448410),-- Metallic Fiber
(20088,2149,1,1,-1,112102),-- Recipe: Metallic Fiber
(20088,57,662,1326,0,700000),-- Adena
(20088,293,1,1,1,112),-- War Hammer
(20088,296,1,1,1,112),-- Dwarven Pike
(20088,1867,1,1,2,185435),-- Animal Skin
(20088,1872,1,1,2,185435),-- Animal Bone
(20088,1875,1,1,2,9272),-- Stone of Purity
(20088,1881,1,1,2,18544),-- Coarse Bone Powder
(20088,2270,1,1,2,994),-- Recipe: Goat Head Staff
(20088,2288,1,1,2,772),-- Recipe: Ghost Staff
(20089,1884,1,1,-1,402384),-- Cord
(20089,1902,1,1,-1,66249),-- Elven Earring Beads
(20089,2159,1,1,-1,40363),-- Recipe: Necklace of Darkness
(20089,57,276,551,0,700000),-- Adena
(20089,395,1,1,1,98),-- Manticore Skin Shirt
(20089,417,1,1,1,157),-- Manticore Skin Gaiters
(20089,1942,1,1,1,4310),-- Manticore Skin Shirt Texture
(20089,1943,1,1,1,7612),-- Manticore Skin Gaiters Pattern
(20089,1825,1,1,2,3018),-- Recipe: Oriharukon
(20089,1875,1,1,2,2817),-- Stone of Purity
(20089,1879,1,1,2,7042),-- Cokes
(20089,1885,1,1,2,3521),-- High Grade Suede
(20089,2205,1,1,2,1337),-- Recipe: Chain Gaiters
(20089,2989,1,1,2,2235),-- Recipe: Chain Hood
(20089,5549,1,1,2,4225),-- Metallic Thread
(20089,5550,1,1,2,563),-- Durable Metal Plate
(20090,1825,1,1,-1,102760),-- Recipe: Oriharukon
(20090,1868,1,7,-1,719317),-- Thread
(20090,2197,1,1,-1,30160),-- Recipe: Salamander Skin Mail
(20090,57,608,1214,0,700000),-- Adena
(20090,352,1,1,1,108),-- Brigandine Tunic
(20090,1941,1,1,1,4929),-- Brigandine Temper
(20090,2377,1,1,1,173),-- Mithril Scale Gaiters
(20090,2378,1,1,1,173),-- Brigandine Gaiters
(20090,2918,1,1,1,7353),-- Mithril Scale Gaiters Material
(20090,2919,1,1,1,7353),-- Brigandine Gaiters Material
(20090,1341,10,30,2,309857),-- Bone Arrow
(20090,1876,1,1,2,18592),-- Mithril Ore
(20090,1877,1,1,2,3718),-- Adamantite Nugget
(20090,1880,1,1,2,9296),-- Steel
(20090,1881,1,1,2,12394),-- Coarse Bone Powder
(20090,1882,1,1,2,20657),-- Leather
(20090,2158,1,1,2,11504),-- Recipe: Mithril Ring
(20090,5472,1,1,2,6640),-- Recipe: Metallic Thread(100%)
(20092,1666,1,1,-1,49062),-- Recipe: Wooden Arrow
(20092,1866,1,1,-1,98124),-- Suede
(20092,2005,1,1,-1,10513),-- Broadsword Blade
(20092,57,79,107,0,700000),-- Adena
(20092,113,1,1,1,9350),-- Mystic\'s Earring
(20092,875,1,1,1,13802),-- Ring of Knowledge
(20092,906,1,1,1,6984),-- Necklace of Knowledge
(20092,1867,1,1,2,19323),-- Animal Skin
(20092,1869,1,1,2,14493),-- Iron Ore
(20092,1870,1,1,2,14493),-- Coal
(20092,1871,1,1,2,14493),-- Charcoal
(20092,1872,1,1,2,19323),-- Animal Bone
(20092,2137,1,1,2,4263),-- Recipe: Steel
(20093,1666,1,1,-1,60652),-- Recipe: Wooden Arrow
(20093,1867,1,1,-1,242609),-- Animal Skin
(20093,2007,1,1,-1,12997),-- Bow Shaft
(20093,57,98,132,0,700000),-- Adena
(20093,3,1,1,1,1120),-- Broadsword
(20093,2005,1,1,1,3840),-- Broadsword Blade
(20093,1060,1,1,2,59720),-- Lesser Healing Potion
(20093,1867,1,1,2,35832),-- Animal Skin
(20093,1872,1,1,2,35832),-- Animal Bone
(20093,2138,1,1,2,7905),-- Recipe: Coarse Bone Powder (100%)
(20095,1864,1,1,-1,297315),-- Stem
(20095,2006,1,1,-1,10618),-- Willow Staff Head
(20095,57,80,108,0,700000),-- Adena
(20095,428,1,1,1,2348),-- Feriotic Tunic
(20095,463,1,1,1,3753),-- Feriotic Stockings
(20095,1100,1,1,1,2348),-- Cotton Tunic
(20095,1103,1,1,1,3753),-- Cotton Stockings
(20095,1789,1,1,2,5412),-- Recipe: Cedar Staff
(20095,1864,1,1,2,58548),-- Stem
(20095,1869,1,1,2,29274),-- Iron Ore
(20096,1792,1,1,-1,14822),-- Recipe: Short Spear
(20096,1799,1,1,-1,298635),-- Recipe: Leather Gloves
(20096,1921,1,1,-1,130051),-- Leather Shoes Texture
(20096,57,109,147,0,700000),-- Adena
(20096,37,1,1,1,3892),-- Leather Shoes
(20096,49,1,1,1,3892),-- Gloves
(20096,1921,1,1,1,25611),-- Leather Shoes Texture
(20096,736,1,1,2,9924),-- Scroll of Escape
(20096,1867,1,1,2,26464),-- Animal Skin
(20096,1869,1,1,2,19848),-- Iron Ore
(20096,1870,1,1,2,19848),-- Coal
(20096,1871,1,1,2,19848),-- Charcoal
(20096,1872,1,1,2,26464),-- Animal Bone
(20097,1793,1,1,-1,12352),-- Recipe: Sword of Reflection
(20097,1864,1,1,-1,335964),-- Stem
(20097,1872,1,1,-1,223976),-- Animal Bone
(20097,57,91,122,0,700000),-- Adena
(20097,23,1,1,1,1081),-- Wooden Breastplate
(20097,30,1,1,1,1732),-- Hard Leather Pants
(20097,2386,1,1,1,1732),-- Wooden Gaiters
(20097,1792,1,1,2,2433),-- Recipe: Short Spear
(20097,1867,1,1,2,44106),-- Animal Skin
(20097,1872,1,1,2,44106),-- Animal Bone
(20098,1867,1,1,-1,292048),-- Animal Skin
(20098,1870,1,1,-1,219036),-- Coal
(20098,1896,1,1,-1,92812),-- Necklace of Anguish Chain
(20098,57,117,161,0,700000),-- Adena
(20098,66,1,1,1,207),-- Gladius
(20098,1333,1,1,1,207),-- Brandish
(20098,2010,1,1,1,1679),-- Brandish Blade
(20098,1793,1,1,2,3172),-- Recipe: Sword of Reflection
(20098,1865,1,1,2,43134),-- Varnish
(20098,1870,1,1,2,43134),-- Coal
(20099,1831,1,1,-1,473949),-- Antidote
(20099,1896,1,1,-1,75310),-- Necklace of Anguish Chain
(20099,2009,1,1,-1,6303),-- Dirk Blade
(20099,57,95,131,0,700000),-- Adena
(20099,66,1,1,1,168),-- Gladius
(20099,1333,1,1,1,168),-- Brandish
(20099,2010,1,1,1,1363),-- Brandish Blade
(20099,1794,1,1,2,1287),-- Recipe: Forest Bow
(20099,1864,1,1,2,35000),-- Stem
(20099,1865,1,1,2,17500),-- Varnish
(20099,1866,1,1,2,11667),-- Suede
(20099,1868,1,1,2,35000),-- Thread
(20099,1873,1,1,2,7000),-- Silver Nugget
(20100,1792,1,1,-1,13849),-- Recipe: Short Spear
(20100,1833,1,1,-1,502269),-- Bandage
(20100,1866,1,1,-1,125567),-- Suede
(20100,57,99,140,0,700000),-- Adena
(20100,271,1,1,1,535),-- Hunting Bow
(20100,1799,1,1,2,54950),-- Recipe: Leather Gloves
(20100,1866,1,1,2,24728),-- Suede
(20100,1871,1,1,2,37091),-- Charcoal
(20101,20,1,1,-1,23417),-- Buckler
(20101,1793,1,1,-1,18424),-- Recipe: Sword of Reflection
(20101,1921,1,1,-1,161654),-- Leather Shoes Texture
(20101,57,128,189,0,700000),-- Adena
(20101,114,1,1,1,2193),-- Earring of Strength
(20101,115,1,1,1,2193),-- Earring of Wisdom
(20101,876,1,1,1,3290),-- Ring of Anguish
(20101,907,1,1,1,1645),-- Necklace of Anguish
(20101,1896,1,1,1,12545),-- Necklace of Anguish Chain
(20101,1803,1,1,2,20732),-- Recipe: Necklace of Wisdom
(20101,1864,1,1,2,49342),-- Stem
(20101,1865,1,1,2,24671),-- Varnish
(20101,1866,1,1,2,16448),-- Suede
(20101,1868,1,1,2,49342),-- Thread
(20101,1873,1,1,2,9869),-- Silver Nugget
(20102,1793,1,1,-1,14067),-- Recipe: Sword of Reflection
(20102,1866,1,1,-1,127538),-- Suede
(20102,1922,1,1,-1,48803),-- Leather Tunic Pattern
(20102,57,98,145,0,700000),-- Adena
(20102,271,1,1,1,543),-- Hunting Bow
(20102,736,1,1,2,18837),-- Scroll of Escape
(20102,1864,1,1,2,75346),-- Stem
(20102,1869,1,1,2,37673),-- Iron Ore
(20103,1803,1,1,-1,198526),-- Recipe: Necklace of Wisdom
(20103,1871,1,1,-1,236245),-- Charcoal
(20103,1921,1,1,-1,152416),-- Leather Shoes Texture
(20103,57,119,180,0,700000),-- Adena
(20103,37,1,1,1,4561),-- Leather Shoes
(20103,49,1,1,1,4561),-- Gloves
(20103,1921,1,1,1,30015),-- Leather Shoes Texture
(20103,17,10,30,2,174458),-- Wooden Arrow
(20103,1794,1,1,2,2566),-- Recipe: Forest Bow
(20103,1867,1,1,2,46523),-- Animal Skin
(20103,1872,1,1,2,46523),-- Animal Bone
(20104,1868,1,1,-1,386022),-- Thread
(20104,1869,1,1,-1,193011),-- Iron Ore
(20104,57,97,147,0,700000),-- Adena
(20104,271,1,1,1,548),-- Hunting Bow
(20104,17,10,30,2,142531),-- Wooden Arrow
(20104,736,1,1,2,14254),-- Scroll of Escape
(20104,1868,1,1,2,57013),-- Thread
(20104,1873,1,1,2,11403),-- Silver Nugget
(20105,734,1,1,-1,39986),-- Haste Potion
(20105,1801,1,1,-1,120865),-- Recipe: Piece Bone Gaiters
(20105,1872,1,1,-1,319890),-- Animal Bone
(20105,57,119,185,0,700000),-- Adena
(20105,15,1,1,1,135),-- Short Spear
(20105,2011,1,1,1,1617),-- Short Spear Edge
(20105,735,1,1,2,2953),-- Potion of Alacrity
(20105,1867,1,1,2,47246),-- Animal Skin
(20105,1872,1,1,2,47246),-- Animal Bone
(20105,2140,1,1,2,7087),-- Recipe: High Grade Suede
(20106,734,1,1,-1,39594),-- Haste Potion
(20106,1897,1,1,-1,56563),-- Necklace of Wisdom Chain
(20106,2150,1,1,-1,111533),-- Recipe: Blue Diamond Necklace
(20106,57,118,183,0,700000),-- Adena
(20106,38,1,1,1,1796),-- Low Boots
(20106,50,1,1,1,1796),-- Leather Gloves
(20106,1925,1,1,1,30677),-- Leather Gloves Lining
(20106,1867,1,1,2,46783),-- Animal Skin
(20106,1872,1,1,2,46783),-- Animal Bone
(20106,2141,1,1,2,7018),-- Recipe: Silver Mold
(20106,5273,1,1,2,1404),-- Recipe: Greater Spiritshot (D) Compressed Package(100%)
(20107,734,1,1,-1,32995),-- Haste Potion
(20107,1869,1,1,-1,197971),-- Iron Ore
(20107,1897,1,1,-1,47136),-- Necklace of Wisdom Chain
(20107,57,98,153,0,700000),-- Adena
(20107,217,1,1,1,112),-- Shining Knife
(20107,218,1,1,1,112),-- Throwing Knife
(20107,1865,1,1,2,29239),-- Varnish
(20107,1870,1,1,2,29239),-- Coal
(20107,2142,1,1,2,5848),-- Recipe: Varnish of Purity
(20107,6035,1,1,2,2437),-- Magic Haste Potion
(20108,734,1,1,-1,41833),-- Haste Potion
(20108,1800,1,1,-1,78931),-- Recipe: Piece Bone Breastplate
(20108,1866,1,1,-1,167333),-- Suede
(20108,57,122,197,0,700000),-- Adena
(20108,38,1,1,1,1897),-- Low Boots
(20108,50,1,1,1,1897),-- Leather Gloves
(20108,1925,1,1,1,32412),-- Leather Gloves Lining
(20108,735,1,1,2,3090),-- Potion of Alacrity
(20108,1867,1,1,2,49428),-- Animal Skin
(20108,1872,1,1,2,49428),-- Animal Bone
(20108,2144,1,1,2,7415),-- Recipe: Compound Braid
(20109,845,1,1,-1,11752),-- Cat\'s Eye Earring
(20109,1865,1,1,-1,401928),-- Varnish
(20109,1924,1,1,-1,129654),-- Leather Helmet Design
(20109,57,196,315,0,700000),-- Adena
(20109,24,1,1,1,761),-- Bone Breastplate
(20109,31,1,1,1,1215),-- Bone Gaiters
(20109,390,1,1,1,761),-- Cotton Shirt
(20109,412,1,1,1,1215),-- Cotton Pants
(20109,1864,1,1,2,67842),-- Stem
(20109,1865,1,1,2,33921),-- Varnish
(20109,1866,1,1,2,22614),-- Suede
(20109,1868,1,1,2,67842),-- Thread
(20109,1873,1,1,2,13569),-- Silver Nugget
(20109,2150,1,1,2,15926),-- Recipe: Blue Diamond Necklace
(20109,5273,1,1,2,1357),-- Recipe: Greater Spiritshot (D) Compressed Package(100%)
(20110,734,1,1,-1,64842),-- Haste Potion
(20110,1801,1,1,-1,195995),-- Recipe: Piece Bone Gaiters
(20110,1897,1,1,-1,92631),-- Necklace of Wisdom Chain
(20110,57,190,305,0,700000),-- Adena
(20110,24,1,1,1,737),-- Bone Breastplate
(20110,31,1,1,1,1176),-- Bone Gaiters
(20110,390,1,1,1,737),-- Cotton Shirt
(20110,412,1,1,1,1176),-- Cotton Pants
(20110,1866,1,1,2,51076),-- Suede
(20110,1871,1,1,2,76613),-- Charcoal
(20110,2173,1,1,2,20763),-- Recipe: Hard Leather Shirt
(20112,1800,1,1,-1,123442),-- Recipe: Piece Bone Breastplate
(20112,1801,1,1,-1,197756),-- Recipe: Piece Bone Gaiters
(20112,1924,1,1,-1,126628),-- Leather Helmet Design
(20112,57,188,310,0,700000),-- Adena
(20112,1101,1,1,1,1486),-- Tunic of Devotion
(20112,1104,1,1,1,2374),-- Stockings of Devotion
(20112,734,1,1,2,7730),-- Haste Potion
(20112,1800,1,1,2,14586),-- Recipe: Piece Bone Breastplate
(20112,1864,1,1,2,92762),-- Stem
(20112,1869,1,1,2,46381),-- Iron Ore
(20112,1878,1,1,2,18553),-- Braided Hemp
(20113,1870,1,1,-1,400397),-- Coal
(20113,1879,1,1,-1,66733),-- Cokes
(20113,1925,1,1,-1,262556),-- Leather Gloves Lining
(20113,57,192,316,0,700000),-- Adena
(20113,24,1,1,1,758),-- Bone Breastplate
(20113,31,1,1,1,1210),-- Bone Gaiters
(20113,390,1,1,1,758),-- Cotton Shirt
(20113,412,1,1,1,1210),-- Cotton Pants
(20113,1801,1,1,2,23834),-- Recipe: Piece Bone Gaiters
(20113,1865,1,1,2,47309),-- Varnish
(20113,1870,1,1,2,47309),-- Coal
(20113,1879,1,1,2,7885),-- Cokes
(20113,5273,1,1,2,1893),-- Recipe: Greater Spiritshot (D) Compressed Package(100%)
(20114,735,1,1,-1,33735),-- Potion of Alacrity
(20114,1817,1,1,-1,80965),-- Recipe: Cord
(20114,2011,1,1,-1,9235),-- Short Spear Edge
(20114,57,190,323,0,700000),-- Adena
(20114,845,1,1,1,1748),-- Cat\'s Eye Earring
(20114,877,1,1,1,2622),-- Ring of Wisdom
(20114,908,1,1,1,1311),-- Necklace of Wisdom
(20114,1897,1,1,1,14236),-- Necklace of Wisdom Chain
(20114,1817,1,1,2,11958),-- Recipe: Cord
(20114,1866,1,1,2,39860),-- Suede
(20114,1871,1,1,2,59790),-- Charcoal
(20114,6035,1,1,2,4983),-- Magic Haste Potion
(20115,2012,1,1,-1,8603),-- Sword of Reflection Blade
(20115,2013,1,1,-1,8912),-- Forest Bow Shaft
(20115,2139,1,1,-1,82584),-- Recipe: Steel Mold
(20115,57,194,330,0,700000),-- Adena
(20115,38,1,1,1,3121),-- Low Boots
(20115,50,1,1,1,3121),-- Leather Gloves
(20115,1925,1,1,1,53321),-- Leather Gloves Lining
(20115,1867,1,1,2,46466),-- Animal Skin
(20115,1869,1,1,2,34849),-- Iron Ore
(20115,1870,1,1,2,34849),-- Coal
(20115,1871,1,1,2,34849),-- Charcoal
(20115,1872,1,1,2,46466),-- Animal Bone
(20115,2139,1,1,2,6970),-- Recipe: Steel Mold
(20115,5158,1,1,2,1394),-- Recipe: Spiritshot (D) Compressed Package (100%)
(20117,734,1,1,-1,42109),-- Haste Potion
(20117,1868,1,1,-1,505303),-- Thread
(20117,1925,1,1,-1,165673),-- Leather Gloves Lining
(20117,57,117,203,0,700000),-- Adena
(20117,176,1,1,1,142),-- Journeyman\'s Staff
(20117,2501,1,1,1,142),-- Bone Club
(20117,735,1,1,2,2488),-- Potion of Alacrity
(20117,1867,1,1,2,39803),-- Animal Skin
(20117,1872,1,1,2,39803),-- Animal Bone
(20117,1882,1,1,2,6634),-- Leather
(20117,2173,1,1,2,8090),-- Recipe: Hard Leather Shirt
(20118,846,1,1,-1,4723),-- Coral Earring
(20118,1866,1,1,-1,193642),-- Suede
(20118,5549,1,1,-1,29046),-- Metallic Thread
(20118,57,132,236,0,700000),-- Adena
(20118,87,1,1,1,46),-- Iron Hammer
(20118,155,1,1,1,46),-- Buzdygan
(20118,177,1,1,1,46),-- Mage Staff
(20118,2014,1,1,1,493),-- Iron Hammer Head
(20118,1868,1,1,2,85798),-- Thread
(20118,1873,1,1,2,17160),-- Silver Nugget
(20118,2179,1,1,2,20526),-- Recipe: Crafted Leather Gloves
(20118,5273,1,1,2,1716),-- Recipe: Greater Spiritshot (D) Compressed Package(100%)
(20120,1787,1,1,-1,30885),-- Recipe: Willow Staff
(20120,1864,1,1,-1,77212),-- Stem
(20120,1874,1,1,-1,2574),-- Oriharukon Ore
(20120,57,19,29,0,700000),-- Adena
(20120,13,1,1,1,13530),-- Short Bow
(20120,1060,1,1,2,22174),-- Lesser Healing Potion
(20120,1786,1,1,2,7983),-- Recipe: Broad Sword
(20120,1865,1,1,2,9979),-- Varnish
(20120,1870,1,1,2,9979),-- Coal
(20121,1786,1,1,-1,45293),-- Recipe: Broad Sword
(20121,1788,1,1,-1,45293),-- Recipe: Bow 
(20121,1864,1,1,-1,113233),-- Stem
(20121,57,30,42,0,700000),-- Adena
(20121,4,1,1,1,9921),-- Club
(20121,7,1,1,1,9921),-- Apprentice\'s Rod
(20121,17,10,30,2,73166),-- Wooden Arrow
(20121,1786,1,1,2,11707),-- Recipe: Broad Sword
(20121,1866,1,1,2,9756),-- Suede
(20121,1871,1,1,2,14634),-- Charcoal
(20130,1060,1,1,-1,172757),-- Lesser Healing Potion
(20130,1666,1,1,-1,25914),-- Recipe: Wooden Arrow
(20130,2005,1,1,-1,5553),-- Broadsword Blade
(20130,57,41,58,0,700000),-- Adena
(20130,1119,1,1,1,6514),-- Short Leather Gloves
(20130,1122,1,1,1,6514),-- Cotton Shoes
(20130,1129,1,1,1,6514),-- Crude Leather Shoes
(20130,1666,1,1,2,5103),-- Recipe: Wooden Arrow
(20130,1864,1,1,2,30618),-- Stem
(20130,1869,1,1,2,15309),-- Iron Ore
(20131,1666,1,1,-1,32439),-- Recipe: Wooden Arrow
(20131,1789,1,1,-1,17988),-- Recipe: Cedar Staff
(20131,2006,1,1,-1,6951),-- Willow Staff Head
(20131,57,51,72,0,700000),-- Adena
(20131,19,1,1,1,11733),-- Small Shield
(20131,42,1,1,1,8213),-- Leather Cap
(20131,1797,1,1,2,38715),-- Recipe: Leather Stockings
(20131,1865,1,1,2,19164),-- Varnish
(20131,1870,1,1,2,19164),-- Coal
(20132,1060,1,1,-1,330759),-- Lesser Healing Potion
(20132,2006,1,1,-1,10632),-- Willow Staff Head
(20132,57,80,108,0,700000),-- Adena
(20132,254,1,1,1,1832),-- Iron Gloves
(20132,734,1,1,2,3664),-- Haste Potion
(20132,1797,1,1,2,44410),-- Recipe: Leather Stockings
(20132,1867,1,1,2,29311),-- Animal Skin
(20132,1872,1,1,2,29311),-- Animal Bone
(20134,356,1,1,-1,233),-- Full Plate Armor
(20134,947,1,1,-1,832),-- Scroll: Enchant Weapon (Grade B)
(20134,1871,1,5,-1,693087),-- Charcoal
(20134,57,821,1673,0,700000),-- Adena
(20134,357,1,1,1,10),-- Zubei\'s Breastplate
(20134,383,1,1,1,15),-- Zubei\'s Gaiters
(20134,2376,1,1,1,10),-- Avadon Breastplate
(20134,2379,1,1,1,15),-- Avadon Gaiters
(20134,4056,1,1,1,1390),-- Zubei\'s Breastplate Part
(20134,4057,1,1,1,2148),-- Zubei\'s Gaiter Material
(20134,4064,1,1,1,1390),-- Avadon Breastplate Part
(20134,4065,1,1,1,2148),-- Avadon Gaiters Material
(20134,947,1,1,2,20),-- Scroll: Enchant Weapon (Grade B)
(20134,1866,1,1,2,34121),-- Suede
(20134,1871,1,1,2,51182),-- Charcoal
(20134,1885,1,1,2,4265),-- High Grade Suede
(20134,4041,1,1,2,445),-- Mold Hardener
(20134,4192,1,1,2,39),-- Recipe: Sword of Damascus
(20134,4993,1,1,2,637),-- Recipe: Doom Gloves (60%)
(20134,5220,1,1,2,2047),-- Metal Hardener
(20134,8728,1,1,200,853),-- Life Stone: level 61
(20134,8738,1,1,200,213),-- Mid-Grade Life Stone: level 61
(20134,8748,1,1,200,21),-- High-Grade Life Stone: level 61
(20134,8758,1,1,200,5),-- Top-Grade Life Stone: level 61
(20135,1882,1,1,-1,207728),-- Leather
(20135,2038,1,1,-1,9877),-- Maingauche Edge
(20135,5231,1,1,-1,66770),-- Recipe: Metal Hardener (100%)
(20135,57,390,779,0,700000),-- Adena
(20135,261,1,1,1,45),-- Bich\'Hwa
(20135,2039,1,1,1,2446),-- Bich\'Hwa Edge
(20135,1867,1,1,2,92039),-- Animal Skin
(20135,1872,1,1,2,92039),-- Animal Bone
(20135,1882,1,1,2,15340),-- Leather
(20135,1894,1,1,2,2422),-- Crafted Leather
(20135,2286,1,1,2,383),-- Recipe: Bonebreaker
(20135,2296,1,1,2,383),-- Recipe: Atuba Mace
(20135,2985,1,1,2,7058),-- Recipe: Plate Boots
(20136,1539,1,3,-1,508898),-- Greater Healing Potion
(20136,1914,1,1,-1,257308),-- Earring of Binding Gemstone
(20136,4601,1,1,-1,10178),-- Greater Dye of Strength <Str+3 Con-3>
(20136,57,1812,3683,0,700000),-- Adena
(20136,75,1,1,1,10),-- Caliburs
(20136,76,1,1,1,10),-- Sword of Delusion
(20136,77,1,1,1,10),-- Tsurugi
(20136,84,1,1,1,10),-- Homunkulus\'s Sword
(20136,134,1,1,1,10),-- Sword of Nightmare
(20136,145,1,1,1,10),-- Sword of Whispering Death
(20136,2089,1,1,1,860),-- Caliburs Edge
(20136,2090,1,1,1,860),-- Delusional Blade
(20136,2091,1,1,1,860),-- Tsurugi Blade
(20136,2092,1,1,1,860),-- Homunkulus\'s Sword Blade
(20136,2095,1,1,1,860),-- Sword of Nightmare Blade
(20136,2096,1,1,1,860),-- Sword of Whispering Death Blade
(20136,1864,1,3,2,172185),-- Stem
(20136,1869,1,1,2,172185),-- Iron Ore
(20136,1880,1,1,2,17219),-- Steel
(20136,2169,1,1,2,3047),-- Recipe: Necklace of Binding
(20136,2232,1,1,2,990),-- Recipe: Drake Leather Armor
(20136,4043,1,1,2,5740),-- Asofe
(20136,5550,1,1,2,2296),-- Durable Metal Plate
(20136,8725,1,1,200,4783),-- Life Stone: level 52
(20136,8735,1,1,200,1195),-- Mid-Grade Life Stone: level 52
(20136,8745,1,1,200,120),-- High-Grade Life Stone: level 52
(20136,8755,1,1,200,24),-- Top-Grade Life Stone: level 52
(20137,1877,1,1,-1,78092),-- Adamantite Nugget
(20137,2961,1,1,-1,106305),-- Full Plate Boots Part
(20137,4049,1,1,-1,102402),-- Adamantite Earring Gemstone
(20137,57,770,1572,0,700000),-- Adena
(20137,11889,1,1,1,55),-- Common Item - Great Sword
(20137,11916,1,1,1,55),-- Common Item - Keshanberk
(20137,11900,1,1,1,55),-- Common Item - Sword of Valhalla
(20137,4104,1,1,1,550),-- Great Sword Blade
(20137,4107,1,1,1,541),-- Keshanberk Blade
(20137,4108,1,1,1,541),-- Sword of Valhalla Blade
(20137,1864,1,1,2,88720),-- Stem
(20137,1869,1,1,2,44360),-- Iron Ore
(20137,1880,1,1,2,4436),-- Steel
(20137,4043,1,1,2,1479),-- Asofe
(20137,4163,1,1,2,294),-- Recipe: Blue Wolf Stockings
(20137,4952,1,1,2,570),-- Recipe: Avadon Circlet (60%)
(20137,4999,1,1,2,552),-- Recipe: Doom Boots (60%)
(20137,5550,1,1,2,592),-- Durable Metal Plate
(20137,6669,1,1,2,10316),-- Deluxe Chest Key - Grade 5
(20137,8727,1,1,200,887),-- Life Stone: level 58
(20137,8737,1,1,200,222),-- Mid-Grade Life Stone: level 58
(20137,8747,1,1,200,22),-- High-Grade Life Stone: level 58
(20137,8757,1,1,200,5),-- Top-Grade Life Stone: level 58
(20143,1792,1,1,-1,15682),-- Recipe: Short Spear
(20143,1867,1,1,-1,284370),-- Animal Skin
(20143,1872,1,1,-1,284370),-- Animal Bone
(20143,57,114,157,0,700000),-- Adena
(20143,20,1,1,1,5888),-- Buckler
(20143,43,1,1,1,4117),-- Wooden Helmet
(20143,17,10,30,2,157499),-- Wooden Arrow
(20143,1798,1,1,2,30882),-- Recipe: Leather Helmet
(20143,1866,1,1,2,21000),-- Suede
(20143,1871,1,1,2,31500),-- Charcoal
(20144,1880,1,1,-1,71999),-- Steel
(20144,1901,1,1,-1,99446),-- Tiger\'s Eye Earring Stone
(20144,2272,1,1,-1,5143),-- Recipe: Sword of Revolution
(20144,57,304,607,0,700000),-- Adena
(20144,393,1,1,1,109),-- Mithril Banded Mail
(20144,394,1,1,1,109),-- Reinforced Leather Shirt
(20144,415,1,1,1,174),-- Mithril Banded Gaiters
(20144,416,1,1,1,174),-- Reinforced Leather Gaiters
(20144,1938,1,1,1,4289),-- Mithril Banded Mail Material
(20144,1939,1,1,1,5604),-- Mithril Banded Gaiters Material
(20144,1341,10,30,2,127602),-- Bone Arrow
(20144,1875,1,1,2,2552),-- Stone of Purity
(20144,1879,1,1,2,6380),-- Cokes
(20144,1885,1,1,2,3190),-- High Grade Suede
(20144,2274,1,1,2,273),-- Recipe: Skull Breaker
(20144,2976,1,1,2,5125),-- Recipe: Manticore Skin Boots
(20144,2985,1,1,2,3914),-- Recipe: Plate Boots
(20144,5549,1,1,2,3828),-- Metallic Thread
(20144,5550,1,1,2,510),-- Durable Metal Plate
(20144,6667,1,1,2,23926),-- Deluxe Chest Key - Grade 3
(20145,2153,1,1,-1,93789),-- Recipe: Tiger\'s Eye Earring
(20145,2183,1,1,-1,39675),-- Recipe: Mithril Banded Mail
(20145,2268,1,1,-1,6236),-- Recipe: Tome of Blood
(20145,57,254,510,0,700000),-- Adena
(20145,848,1,1,1,502),-- Enchanted Earring
(20145,879,1,1,1,756),-- Enchanted Ring
(20145,911,1,1,1,377),-- Enchanted Necklace
(20145,1900,1,1,1,9014),-- Enchanted Necklace Chain
(20145,1868,1,1,2,109850),-- Thread
(20145,1873,1,1,2,21970),-- Silver Nugget
(20145,1889,1,1,2,3662),-- Compound Braid
(20145,2268,1,1,2,568),-- Recipe: Tome of Blood
(20145,2276,1,1,2,392),-- Recipe: Maingauche
(20145,5549,1,1,2,5492),-- Metallic Thread
(20146,1869,1,3,-1,742616),-- Iron Ore
(20146,1914,1,1,-1,83440),-- Earring of Binding Gemstone
(20146,1915,1,1,-1,130858),-- Ring of Ages Gemstone
(20146,57,587,1194,0,700000),-- Adena
(20146,103,1,1,1,77),-- Tower Shield
(20146,107,1,1,1,77),-- Composite Shield
(20146,517,1,1,1,54),-- Composite Helmet
(20146,1149,1,1,1,54),-- Shining Circlet
(20146,1978,1,1,1,4921),-- Tower Shield Fragment
(20146,1983,1,1,1,3367),-- Shining Circlet Pattern
(20146,2957,1,1,1,3367),-- Composite Helmet Design
(20146,4055,1,1,1,4921),-- Composite Shield Fragment
(20146,1866,1,1,2,31498),-- Suede
(20146,1871,1,1,2,47246),-- Charcoal
(20146,1877,1,1,2,1890),-- Adamantite Nugget
(20146,2170,1,1,2,1114),-- Recipe: Nassen\'s Earring
(20146,3014,1,1,2,1320),-- Recipe: Full Plate Boots
(20146,4040,1,1,2,945),-- Mold Lubricant
(20146,4041,1,1,2,411),-- Mold Hardener
(20146,4188,1,1,2,54),-- Recipe: Hell Knife
(20146,4609,1,1,2,105),-- Greater Dye of Mental Strength <Men+3 Int-3>
(20146,8725,1,1,200,1312),-- Life Stone: level 52
(20146,8735,1,1,200,328),-- Mid-Grade Life Stone: level 52
(20146,8745,1,1,200,33),-- High-Grade Life Stone: level 52
(20146,8755,1,1,200,7),-- Top-Grade Life Stone: level 52
(20147,1870,1,2,-1,341721),-- Coal
(20147,1876,1,1,-1,68344),-- Mithril Ore
(20147,57,156,278,0,700000),-- Adena
(20147,27,1,1,1,355),-- Hard Leather Shirt
(20147,33,1,1,1,570),-- Hard Leather Gaiters
(20147,1927,1,1,1,4026),-- Hard Leather Shirt Pattern
(20147,1929,1,1,1,6512),-- Hard Leather Gaiters Material
(20147,1868,1,1,2,100939),-- Thread
(20147,1873,1,1,2,20188),-- Silver Nugget
(20147,2255,1,1,2,1234),-- Recipe: Saber
(20147,6666,1,1,2,50470),-- Deluxe Chest Key - Grade 2
(20153,30,1,1,-1,10554),-- Hard Leather Pants
(20153,1831,1,1,-1,537542),-- Antidote
(20153,1867,1,1,-1,268771),-- Animal Skin
(20153,57,109,147,0,700000),-- Adena
(20153,429,1,1,1,973),-- Leather Tunic
(20153,464,1,1,1,1559),-- Leather Stockings
(20153,1922,1,1,1,7596),-- Leather Tunic Pattern
(20153,1923,1,1,1,12202),-- Leather Stocking Pattern
(20153,1793,1,1,2,2919),-- Recipe: Sword of Reflection
(20153,1867,1,1,2,52928),-- Animal Skin
(20153,1872,1,1,2,52928),-- Animal Bone
(20154,1898,1,1,-1,35102),-- Blue Diamond Necklace Gem
(20154,1929,1,1,-1,44093),-- Hard Leather Gaiters Material
(20154,2178,1,1,-1,54675),-- Recipe: Dark Stockings
(20154,57,156,278,0,700000),-- Adena
(20154,846,1,1,1,821),-- Coral Earring
(20154,878,1,1,1,1231),-- Blue Coral Ring
(20154,909,1,1,1,615),-- Blue Diamond Necklace
(20154,1898,1,1,1,5184),-- Blue Diamond Necklace Gem
(20154,1868,1,1,2,100939),-- Thread
(20154,1873,1,1,2,20188),-- Silver Nugget
(20154,2256,1,1,2,1234),-- Recipe: Assassin Knife
(20154,5158,1,1,2,2019),-- Recipe: Spiritshot (D) Compressed Package (100%)
(20155,1804,1,1,-1,15428),-- Recipe: Soulshot: D-Grade
(20155,1865,1,1,-1,385707),-- Varnish
(20155,1898,1,1,-1,39621),-- Blue Diamond Necklace Gem
(20155,57,177,312,0,700000),-- Adena
(20155,846,1,1,1,926),-- Coral Earring
(20155,878,1,1,1,1389),-- Blue Coral Ring
(20155,909,1,1,1,695),-- Blue Diamond Necklace
(20155,1898,1,1,1,5852),-- Blue Diamond Necklace Gem
(20155,735,1,1,2,2713),-- Potion of Alacrity
(20155,1864,1,1,2,65104),-- Stem
(20155,1869,1,1,2,32552),-- Iron Ore
(20155,1880,1,1,2,3255),-- Steel
(20155,3032,1,1,2,1302),-- Recipe: Spiritshot D
(20155,5273,1,1,2,1302),-- Recipe: Greater Spiritshot (D) Compressed Package(100%)
(20155,6666,1,1,2,32552),-- Deluxe Chest Key - Grade 2
(20156,1899,1,1,-1,66888),-- Necklace of Devotion Chain
(20156,2181,1,1,-1,42851),-- Recipe: White Tunic
(20156,57,188,353,0,700000),-- Adena
(20156,847,1,1,1,580),-- Red Crescent Earring
(20156,890,1,1,1,870),-- Ring of Devotion
(20156,910,1,1,1,435),-- Necklace of Devotion
(20156,1899,1,1,1,9385),-- Necklace of Devotion Chain
(20156,1061,1,1,2,20801),-- Healing Potion
(20156,1876,1,1,2,6864),-- Mithril Ore
(20156,1877,1,1,2,1373),-- Adamantite Nugget
(20156,1880,1,1,2,3432),-- Steel
(20156,1881,1,1,2,4576),-- Coarse Bone Powder
(20156,1882,1,1,2,7627),-- Leather
(20156,2181,1,1,2,3436),-- Recipe: White Tunic
(20157,1879,1,1,-1,102726),-- Cokes
(20157,2024,1,1,-1,8780),-- Elven Bow Shaft
(20157,2153,1,1,-1,95856),-- Recipe: Tiger\'s Eye Earring
(20157,57,261,517,0,700000),-- Adena
(20157,86,1,1,1,14),-- Tomahawk
(20157,179,1,1,1,14),-- Mace of Prayer
(20157,180,1,1,1,14),-- Mace of Judgment
(20157,181,1,1,1,14),-- Mace of Miracle
(20157,182,1,1,1,14),-- Doom Hammer
(20157,183,1,1,1,14),-- Mystic Staff
(20157,184,1,1,1,14),-- Conjuror\'s Staff
(20157,185,1,1,1,14),-- Staff of Mana
(20157,2022,1,1,1,525),-- Mace of Judgment Head
(20157,2023,1,1,1,417),-- Conjuror\'s Staff Head
(20157,1061,1,1,2,25516),-- Healing Potion
(20157,1829,1,1,2,168413),-- Scroll of Escape: Clan Hall
(20157,1864,1,1,2,84204),-- Stem
(20157,1869,1,1,2,42102),-- Iron Ore
(20157,1878,1,1,2,16841),-- Braided Hemp
(20157,1884,1,1,2,25909),-- Cord
(20157,2274,1,1,2,301),-- Recipe: Skull Breaker
(20157,2282,1,1,2,301),-- Recipe: Cursed Maingauche
(20158,1876,1,1,-1,136283),-- Mithril Ore
(20158,1901,1,1,-1,94118),-- Tiger\'s Eye Earring Stone
(20158,1939,1,1,-1,59852),-- Mithril Banded Gaiters Material
(20158,57,288,574,0,700000),-- Adena
(20158,436,1,1,1,310),-- Tunic of Knowledge
(20158,469,1,1,1,495),-- Stockings of Knowledge
(20158,1864,1,1,2,120767),-- Stem
(20158,1869,1,1,2,60384),-- Iron Ore
(20158,1880,1,1,2,6038),-- Steel
(20158,2271,1,1,2,431),-- Recipe: Winged Spear
(20158,2972,1,1,2,3229),-- Recipe: Brigandine Gaiters
(20158,5550,1,1,2,805),-- Durable Metal Plate
(20160,1874,1,1,-1,32992),-- Oriharukon Ore
(20160,2152,1,1,-1,87127),-- Recipe: Enchanted Necklace
(20160,2261,1,1,-1,7685),-- Recipe: Conjuror\'s Staff
(20160,57,212,415,0,700000),-- Adena
(20160,258,1,1,1,176),-- Bagh-Nakh
(20160,1874,1,1,2,3086),-- Oriharukon Ore
(20160,1878,1,1,2,18516),-- Braided Hemp
(20160,1884,1,1,2,28486),-- Cord
(20160,1889,1,1,2,3086),-- Compound Braid
(20160,2152,1,1,2,8150),-- Recipe: Enchanted Necklace
(20160,5220,1,1,2,1852),-- Metal Hardener
(20161,1806,1,1,-1,3247),-- Recipe: Soulshot: B-Grade
(20161,1872,1,5,-1,721517),-- Animal Bone
(20161,1984,1,1,-1,34800),-- Theca Leather Armor Pattern
(20161,57,643,1305,0,700000),-- Adena
(20161,266,1,1,1,13),-- Great Pata
(20161,2120,1,1,1,1439),-- Great Pata Blade
(20161,1806,1,1,2,80),-- Recipe: Soulshot: B-Grade
(20161,1867,1,1,2,53281),-- Animal Skin
(20161,1872,1,1,2,53281),-- Animal Bone
(20161,1882,1,1,2,8880),-- Leather
(20161,1894,1,1,2,1402),-- Crafted Leather
(20161,3955,1,1,2,80),-- Recipe: Blessed Spiritshot B
(20161,4042,1,1,2,666),-- Enria
(20161,4180,1,1,2,4440),-- Recipe: Silver Arrow
(20161,5165,1,1,2,80),-- Recipe: Blessed Spiritshot (B) Compressed Package (100%)
(20161,5280,1,1,2,80),-- Recipe: Greater Blessed Spiritshot (B) Compressed Package(100%)
(20161,6669,1,1,2,9293),-- Deluxe Chest Key - Grade 5
(20161,8726,1,1,200,925),-- Life Stone: level 55
(20161,8736,1,1,200,231),-- Mid-Grade Life Stone: level 55
(20161,8746,1,1,200,23),-- High-Grade Life Stone: level 55
(20161,8756,1,1,200,5),-- Top-Grade Life Stone: level 55
(20168,955,1,1,-1,2124),-- Scroll: Enchant Weapon (Grade D)
(20168,1061,1,1,-1,321804),-- Healing Potion
(20168,1877,1,1,-1,21239),-- Adamantite Nugget
(20168,57,224,448,0,700000),-- Adena
(20168,46,1,1,1,756),-- Bronze Helmet
(20168,627,1,1,1,1078),-- Aspis
(20168,1865,1,1,2,48360),-- Varnish
(20168,1870,1,1,2,48360),-- Coal
(20168,1875,1,1,2,3224),-- Stone of Purity
(20168,1879,1,1,2,8060),-- Cokes
(20168,2184,1,1,2,5080),-- Recipe: Mithril Banded Gaiters
(20168,2274,1,1,2,345),-- Recipe: Skull Breaker
(20171,1880,1,1,-1,45092),-- Steel
(20171,1899,1,1,-1,70456),-- Necklace of Devotion Chain
(20171,2019,1,1,-1,9697),-- Trident Edge
(20171,57,196,374,0,700000),-- Adena
(20171,101,1,1,1,32),-- Scroll of Wisdom
(20171,312,1,1,1,32),-- Branch of Life
(20171,313,1,1,1,32),-- Temptation of Abyss
(20171,314,1,1,1,32),-- Proof of Revenge
(20171,2020,1,1,1,886),-- Temptation of Abyss Piece
(20171,1061,1,1,2,25562),-- Healing Potion
(20171,1875,1,1,2,2812),-- Stone of Purity
(20171,1879,1,1,2,7030),-- Cokes
(20171,2263,1,1,2,655),-- Recipe: Dwarven Trident
(20171,5549,1,1,2,4218),-- Metallic Thread
(20171,6666,1,1,2,42178),-- Deluxe Chest Key - Grade 2
(20176,1873,1,1,-1,287994),-- Silver Nugget
(20176,2154,1,1,-1,77086),-- Recipe: Elven Earring
(20176,2273,1,1,-1,5143),-- Recipe: Tarbar
(20176,57,304,607,0,700000),-- Adena
(20176,63,1,1,1,280),-- Gauntlets
(20176,553,1,1,1,280),-- Iron Boots
(20176,1940,1,1,1,8163),-- Iron Boots Design
(20176,2422,1,1,1,280),-- Reinforced Leather Boots
(20176,2423,1,1,1,280),-- Boots of Knowledge
(20176,2446,1,1,1,280),-- Reinforced Leather Gloves
(20176,2447,1,1,1,280),-- Gloves of Knowledge
(20176,1867,1,1,2,72916),-- Animal Skin
(20176,1872,1,1,2,72916),-- Animal Bone
(20176,1882,1,1,2,12153),-- Leather
(20176,2286,1,1,2,304),-- Recipe: Bonebreaker
(20176,2977,1,1,2,7321),-- Recipe: Brigandine Boots
(20176,2981,1,1,2,7321),-- Recipe: Elven Mithril Gloves
(20176,2985,1,1,2,5592),-- Recipe: Plate Boots
(20190,1864,1,3,-1,533484),-- Stem
(20190,1900,1,1,-1,58368),-- Enchanted Necklace Chain
(20190,2025,1,1,-1,7389),-- Dwarven Trident Edge
(20190,57,226,448,0,700000),-- Adena
(20190,275,1,1,1,39),-- Long Bow
(20190,276,1,1,1,39),-- Elven Bow
(20190,2024,1,1,1,1385),-- Elven Bow Shaft
(20190,1866,1,1,2,38870),-- Suede
(20190,1871,1,1,2,58306),-- Charcoal
(20190,1885,1,1,2,4859),-- High Grade Suede
(20190,2153,1,1,2,9068),-- Recipe: Tiger\'s Eye Earring
(20190,5220,1,1,2,2332),-- Metal Hardener
(20191,1900,1,1,-1,59256),-- Enchanted Necklace Chain
(20191,2153,1,1,-1,84230),-- Recipe: Tiger\'s Eye Earring
(20191,2264,1,1,-1,5601),-- Recipe: Two-handed Sword
(20191,57,228,457,0,700000),-- Adena
(20191,605,1,1,1,1156),-- Leather Gauntlets
(20191,1123,1,1,1,1156),-- Blue Buckskin Boots
(20191,1867,1,1,2,56374),-- Animal Skin
(20191,1872,1,1,2,56374),-- Animal Bone
(20191,1882,1,1,2,9396),-- Leather
(20191,2185,1,1,2,8323),-- Recipe: Iron Boots
(20191,2274,1,1,2,302),-- Recipe: Skull Breaker
(20191,2279,1,1,2,302),-- Recipe: War Pick
(20191,6667,1,1,2,26425),-- Deluxe Chest Key - Grade 3
(20192,1901,1,1,-1,97496),-- Tiger\'s Eye Earring Stone
(20192,2146,1,1,-1,50419),-- Recipe: Artisan\'s frame
(20192,2447,1,1,-1,3611),-- Gloves of Knowledge
(20192,57,298,595,0,700000),-- Adena
(20192,223,1,1,1,20),-- Kukuri
(20192,238,1,1,1,20),-- Dagger of Mana
(20192,239,1,1,1,20),-- Mystic Knife
(20192,241,1,1,1,20),-- Shilen Knife
(20192,2028,1,1,1,892),-- Shilen Knife Edge
(20192,1864,1,1,2,107230),-- Stem
(20192,1869,1,1,2,53615),-- Iron Ore
(20192,1878,1,1,2,21446),-- Braided Hemp
(20192,1884,1,1,2,32994),-- Cord
(20192,2978,1,1,2,7177),-- Recipe: Elven Mithril Boots
(20192,8307,1,1,2,383),-- Recipe: Priest Mace (100%)
(20192,6667,1,1,2,33509),-- Deluxe Chest Key - Grade 3
(20193,1874,1,1,-1,50678),-- Oriharukon Ore
(20193,1882,1,1,-1,168925),-- Leather
(20193,2027,1,1,-1,9958),-- Spiked Club Head
(20193,57,320,642,0,700000),-- Adena
(20193,47,1,1,1,690),-- Helmet
(20193,628,1,1,1,986),-- Hoplon
(20193,1341,10,30,2,192463),-- Bone Arrow
(20193,1867,1,1,2,76985),-- Animal Skin
(20193,1872,1,1,2,76985),-- Animal Bone
(20193,1882,1,1,2,12831),-- Leather
(20193,1894,1,1,2,2026),-- Crafted Leather
(20193,2271,1,1,2,412),-- Recipe: Winged Spear
(20193,2286,1,1,2,321),-- Recipe: Bonebreaker
(20197,1876,1,1,-1,91400),-- Mithril Ore
(20197,2020,1,1,-1,8000),-- Temptation of Abyss Piece
(20197,2259,1,1,-1,7096),-- Recipe: Spinebone Sword
(20197,57,197,380,0,700000),-- Adena
(20197,847,1,1,1,620),-- Red Crescent Earring
(20197,890,1,1,1,929),-- Ring of Devotion
(20197,910,1,1,1,465),-- Necklace of Devotion
(20197,1899,1,1,1,10019),-- Necklace of Devotion Chain
(20197,1341,10,30,2,106868),-- Bone Arrow
(20197,1876,1,1,2,6412),-- Mithril Ore
(20197,1877,1,1,2,1282),-- Adamantite Nugget
(20197,1880,1,1,2,3206),-- Steel
(20197,1881,1,1,2,4275),-- Coarse Bone Powder
(20197,1882,1,1,2,7125),-- Leather
(20197,8294,1,1,2,784),-- Recipe: Steel Sword (100%)
(20197,2178,1,1,2,5130),-- Recipe: Dark Stockings
(20198,1832,1,3,-1,575495),-- Greater Antidote
(20198,57,220,435,0,700000),-- Adena
(20198,259,1,1,1,114),-- Single-Edged Jamadhr
(20198,1874,1,1,2,2359),-- Oriharukon Ore
(20198,1878,1,1,2,14152),-- Braided Hemp
(20198,1884,1,1,2,21772),-- Cord
(20198,1889,1,1,2,2359),-- Compound Braid
(20198,2183,1,1,2,2328),-- Recipe: Mithril Banded Mail
(20198,2274,1,1,2,253),-- Recipe: Skull Breaker
(20198,2982,1,1,2,4513),-- Recipe: Brigandine Shield
(20198,5220,1,1,2,1415),-- Metal Hardener
(20199,1834,1,1,-1,702070),-- Emergency Dressing
(20199,1882,1,1,-1,140414),-- Leather
(20199,1900,1,1,-1,69132),-- Enchanted Necklace Chain
(20199,57,267,533,0,700000),-- Adena
(20199,605,1,1,1,1349),-- Leather Gauntlets
(20199,1123,1,1,1,1349),-- Blue Buckskin Boots
(20199,1867,1,1,2,92077),-- Animal Skin
(20199,1872,1,1,2,92077),-- Animal Bone
(20199,1882,1,1,2,15346),-- Leather
(20199,2250,1,1,2,17264),-- Recipe: Bone Arrow
(20199,6035,1,1,2,5755); -- Magic Haste Potion

INSERT INTO `droplist` VALUES 
(20200,1061,1,1,-1,338473),-- Healing Potion
(20200,1877,1,1,-1,22339),-- Adamantite Nugget
(20200,2183,1,1,-1,36742),-- Recipe: Mithril Banded Mail
(20200,57,236,471,0,700000),-- Adena
(20200,433,1,1,1,99),-- Elven Tunic
(20200,434,1,1,1,99),-- White Tunic
(20200,435,1,1,1,99),-- Mystic\'s Tunic
(20200,466,1,1,1,159),-- Elven Stockings
(20200,467,1,1,1,159),-- Dark Stockings
(20200,468,1,1,1,159),-- Mystic\'s Stockings
(20200,1933,1,1,1,4488),-- Dark Stocking Fabric
(20200,1936,1,1,1,3122),-- White Tunic Pattern
(20200,955,1,1,2,136),-- Scroll: Enchant Weapon (Grade D)
(20200,1834,1,1,2,37678),-- Emergency Dressing
(20200,1875,1,1,2,2261),-- Stone of Purity
(20200,1879,1,1,2,5652),-- Cokes
(20200,1885,1,1,2,2826),-- High Grade Suede
(20200,2188,1,1,2,2422),-- Recipe: Manticore Skin Gaiters
(20200,5549,1,1,2,3391),-- Metallic Thread
(20200,5550,1,1,2,452),-- Durable Metal Plate
(20200,6667,1,1,2,21194),-- Deluxe Chest Key - Grade 3
(20201,466,1,1,-1,2769),-- Elven Stockings
(20201,1870,1,1,-1,664672),-- Coal
(20201,1933,1,1,-1,78197),-- Dark Stocking Fabric
(20201,57,280,562,0,700000),-- Adena
(20201,392,1,1,1,472),-- Lion Skin Shirt
(20201,414,1,1,1,757),-- Lion Skin Gaiters
(20201,737,1,1,2,5189),-- Scroll of Resurrection
(20201,1876,1,1,2,10378),-- Mithril Ore
(20201,1877,1,1,2,2075),-- Adamantite Nugget
(20201,1880,1,1,2,5189),-- Steel
(20201,1881,1,1,2,6918),-- Coarse Bone Powder
(20201,1882,1,1,2,11531),-- Leather
(20201,6387,1,1,2,2076),-- Blessed Scroll of Resurrection for Pets
(20202,1872,1,1,-1,881920),-- Animal Bone
(20202,2154,1,1,-1,70818),-- Recipe: Elven Earring
(20202,2198,1,1,-1,13867),-- Recipe: Sage\'s Rag
(20202,57,279,557,0,700000),-- Adena
(20202,849,1,1,1,356),-- Tiger\'s Eye Earring
(20202,880,1,1,1,533),-- Black Pearl Ring
(20202,912,1,1,1,267),-- Near Forest Necklace
(20202,1901,1,1,1,12143),-- Tiger\'s Eye Earring Stone
(20202,1874,1,1,2,3349),-- Oriharukon Ore
(20202,1878,1,1,2,20096),-- Braided Hemp
(20202,1884,1,1,2,30917),-- Cord
(20202,1889,1,1,2,3349),-- Compound Braid
(20202,2272,1,1,2,359),-- Recipe: Sword of Revolution
(20202,2274,1,1,2,359),-- Recipe: Skull Breaker
(20202,5220,1,1,2,2010),-- Metal Hardener
(20203,1882,1,2,-1,59453),-- Leather
(20203,1897,1,1,-1,63700),-- Necklace of Wisdom Chain
(20203,57,124,215,0,700000),-- Adena
(20203,176,1,1,1,151),-- Journeyman\'s Staff
(20203,2501,1,1,1,151),-- Bone Club
(20203,1867,1,1,2,42148),-- Animal Skin
(20203,1872,1,1,2,42148),-- Animal Bone
(20203,1882,1,1,2,7025),-- Leather
(20203,2174,1,1,2,13744),-- Recipe: Hard Leather Gaiters
(20203,5273,1,1,2,1265),-- Recipe: Greater Spiritshot (D) Compressed Package(100%)
(20204,1867,1,1,-1,549120),-- Animal Skin
(20204,1868,1,1,-1,823680),-- Thread
(20204,2014,1,1,-1,4734),-- Iron Hammer Head
(20204,57,188,333,0,700000),-- Adena
(20204,846,1,1,1,989),-- Coral Earring
(20204,878,1,1,1,1484),-- Blue Coral Ring
(20204,909,1,1,1,742),-- Blue Diamond Necklace
(20204,1898,1,1,1,6248),-- Blue Diamond Necklace Gem
(20204,1831,1,1,2,129762),-- Antidote
(20204,1867,1,1,2,64881),-- Animal Skin
(20204,1872,1,1,2,64881),-- Animal Bone
(20204,1882,1,1,2,10813),-- Leather
(20204,3953,1,1,2,1947),-- Recipe: Blessed Spiritshot D
(20205,1868,1,1,-1,814752),-- Thread
(20205,1871,1,1,-1,407376),-- Charcoal
(20205,1928,1,1,-1,59341),-- Piece Bone Gaiters Fragment
(20205,57,181,334,0,700000),-- Adena
(20205,257,1,1,1,256),-- Viper\'s Fang
(20205,1868,1,1,2,120333),-- Thread
(20205,1873,1,1,2,24067),-- Silver Nugget
(20205,2255,1,1,2,1471),-- Recipe: Saber
(20205,6037,1,1,2,120333),-- Waking Scroll
(20206,376,1,1,-1,2072),-- Iron Plate Gaiters
(20206,1899,1,1,-1,64927),-- Necklace of Devotion Chain
(20206,2182,1,1,-1,49884),-- Recipe: Scale Gaiters
(20206,57,183,343,0,700000),-- Adena
(20206,391,1,1,1,484),-- Puma Skin Shirt
(20206,413,1,1,1,775),-- Puma Skin Gaiters
(20206,1864,1,1,2,93284),-- Stem
(20206,1869,1,1,2,46642),-- Iron Ore
(20206,1880,1,1,2,4664),-- Steel
(20206,2182,1,1,2,5599),-- Recipe: Scale Gaiters
(20206,6666,1,1,2,46642),-- Deluxe Chest Key - Grade 2
(20207,2152,1,1,-1,144764),-- Recipe: Enchanted Necklace
(20207,2181,1,1,-1,82308),-- Recipe: White Tunic
(20207,2263,1,1,-1,12768),-- Recipe: Dwarven Trident
(20207,57,357,682,0,700000),-- Adena
(20207,220,1,1,1,293),-- Crafted Dagger
(20207,1865,1,1,2,92295),-- Varnish
(20207,1870,1,1,2,92295),-- Coal
(20207,1875,1,1,2,6153),-- Stone of Purity
(20207,1879,1,1,2,15383),-- Cokes
(20207,2152,1,1,2,16249),-- Recipe: Enchanted Necklace
(20208,1869,1,1,-1,858524),-- Iron Ore
(20208,1872,1,3,-1,572349),-- Animal Bone
(20208,1931,1,1,-1,112225),-- Leather Boot Lining
(20208,57,371,714,0,700000),-- Adena
(20208,45,1,1,1,1333),-- Bone Helmet
(20208,626,1,1,1,1901),-- Bronze Shield
(20208,1932,1,1,1,25493),-- Bone Helmet Design
(20208,1866,1,1,2,53537),-- Suede
(20208,1871,1,1,2,80305),-- Charcoal
(20208,1885,1,1,2,6692),-- High Grade Suede
(20208,2180,1,1,2,6038),-- Recipe: Scale Mail
(20208,5220,1,1,2,3212),-- Metal Hardener
(20208,6666,1,1,2,80305),-- Deluxe Chest Key - Grade 2
(20209,45,1,1,-1,7714),-- Bone Helmet
(20209,1889,1,1,-1,61967),-- Compound Braid
(20209,2178,1,1,-1,148721),-- Recipe: Dark Stockings
(20209,57,398,780,0,700000),-- Adena
(20209,274,1,1,1,331),-- Strengthened Bow
(20209,1061,1,1,2,63233),-- Healing Potion
(20209,1867,1,1,2,139111),-- Animal Skin
(20209,1872,1,1,2,139111),-- Animal Bone
(20209,1882,1,1,2,23185),-- Leather
(20209,2178,1,1,2,16693),-- Recipe: Dark Stockings
(20210,377,1,1,-1,2947),-- Scale Gaiters
(20210,1900,1,1,-1,103336),-- Enchanted Necklace Chain
(20210,2183,1,1,-1,62137),-- Recipe: Mithril Banded Mail
(20210,57,400,793,0,700000),-- Adena
(20210,348,1,1,1,252),-- Scale Mail
(20210,377,1,1,1,403),-- Scale Gaiters
(20210,1935,1,1,1,7209),-- Scale Mail Fragment
(20210,1937,1,1,1,11086),-- Scale Gaiters Fragment
(20210,1868,1,1,2,172042),-- Thread
(20210,1873,1,1,2,34409),-- Silver Nugget
(20210,1889,1,1,2,5735),-- Compound Braid
(20210,2184,1,1,2,9036),-- Recipe: Mithril Banded Gaiters
(20210,2274,1,1,2,614),-- Recipe: Skull Breaker
(20210,5549,1,1,2,8602),-- Metallic Thread
(20211,1865,1,3,-1,503685),-- Varnish
(20211,1869,1,6,-1,503685),-- Iron Ore
(20211,57,425,850,0,700000),-- Adena
(20211,86,1,1,1,22),-- Tomahawk
(20211,179,1,1,1,22),-- Mace of Prayer
(20211,180,1,1,1,22),-- Mace of Judgment
(20211,181,1,1,1,22),-- Mace of Miracle
(20211,182,1,1,1,22),-- Doom Hammer
(20211,183,1,1,1,22),-- Mystic Staff
(20211,184,1,1,1,22),-- Conjuror\'s Staff
(20211,185,1,1,1,22),-- Staff of Mana
(20211,2022,1,1,1,857),-- Mace of Judgment Head
(20211,2023,1,1,1,682),-- Conjuror\'s Staff Head
(20211,1864,1,1,2,183497),-- Stem
(20211,1869,1,1,2,91748),-- Iron Ore
(20211,1880,1,1,2,9175),-- Steel
(20211,5550,1,1,2,1223),-- Durable Metal Plate
(20211,2264,1,1,2,949),-- Recipe: Two-handed Sword
(20211,2280,1,1,2,655),-- Recipe: Crucifix of Blood
(20213,1884,1,5,-1,688339),-- Cord
(20213,1894,1,1,-1,117742),-- Crafted Leather
(20213,2292,1,1,-1,18643),-- Recipe: Light Crossbow
(20213,57,1401,2796,0,700000),-- Adena
(20213,352,1,1,1,252),-- Brigandine Tunic
(20213,1941,1,1,1,11497),-- Brigandine Temper
(20213,2377,1,1,1,403),-- Mithril Scale Gaiters
(20213,2378,1,1,1,403),-- Brigandine Gaiters
(20213,2918,1,1,1,17152),-- Mithril Scale Gaiters Material
(20213,2919,1,1,1,17152),-- Brigandine Gaiters Material
(20213,1341,80,240,2,90344),-- Bone Arrow
(20213,1864,9,27,2,24092),-- Stem
(20213,1869,2,6,2,43365),-- Iron Ore
(20213,1878,1,1,2,86731),-- Braided Hemp
(20213,1884,1,1,2,133432),-- Cord
(20213,2286,1,1,2,1205),-- Recipe: Bonebreaker
(20213,2290,1,1,2,1205),-- Recipe: Mithril Dagger
(20213,2983,1,1,2,14750),-- Recipe: Plate Helmet
(20214,1877,1,1,-1,87132),-- Adamantite Nugget
(20214,1879,1,1,-1,363049),-- Cokes
(20214,2997,1,1,-1,172880),-- Recipe: Karmian Gloves
(20214,57,883,1766,0,700000),-- Adena
(20214,851,1,1,1,391),-- Omen Beast\'s Eye Earring
(20214,882,1,1,1,586),-- Mithril Ring
(20214,914,1,1,1,293),-- Necklace of Darkness
(20214,1905,1,1,1,17734),-- Omen Beast\'s Eye Earring Gemstone
(20214,1906,1,1,1,25059),-- Mithril Ring Wire
(20214,1907,1,1,1,12682),-- Necklace of Darkness Gem
(20214,1805,1,1,2,608),-- Recipe: Soulshot: C-Grade
(20214,1865,1,1,2,182306),-- Varnish
(20214,1870,1,1,2,182306),-- Coal
(20214,1875,1,1,2,12154),-- Stone of Purity
(20214,1879,1,1,2,30384),-- Cokes
(20214,5269,1,1,2,607),-- Recipe: Greater Soulshot (C) Compressed Package(100%)
(20215,1872,1,7,-1,839007),-- Animal Bone
(20215,2206,1,1,-1,66412),-- Recipe: Mithril Shirt
(20215,4469,1,1,-1,14383),-- Dye of Strength <Str+1 Con-1>
(20215,57,1014,2049,0,700000),-- Adena
(20215,297,1,1,1,91),-- Glaive
(20215,2055,1,1,1,5226),-- Glaive Edge
(20215,1866,1,1,2,105328),-- Suede
(20215,1871,1,1,2,157991),-- Charcoal
(20215,1885,1,1,2,13166),-- High Grade Suede
(20215,2205,1,1,2,5000),-- Recipe: Chain Gaiters
(20215,2212,1,1,2,5663),-- Recipe: Plated Leather Gaiters
(20215,2299,1,1,2,690),-- Recipe: Big Hammer
(20215,2989,1,1,2,8359),-- Recipe: Chain Hood
(20215,5220,1,1,2,6320),-- Metal Hardener
(20216,1905,1,1,-1,218797),-- Omen Beast\'s Eye Earring Gemstone
(20216,2297,1,1,-1,9822),-- Recipe: Flamberge
(20216,2933,1,1,-1,251030),-- Sage\'s Worn Gloves Lining
(20216,57,889,1806,0,700000),-- Adena
(20216,61,1,1,1,250),-- Mithril Gloves
(20216,607,1,1,1,250),-- Ogre Power Gauntlets
(20216,1125,1,1,1,250),-- Assault Boots
(20216,1949,1,1,1,10505),-- Mithril Gloves Design
(20216,1957,1,1,1,10505),-- Assault Boots Part
(20216,1963,1,1,1,10505),-- Ogre Power Gauntlets Part
(20216,2427,1,1,1,250),-- Salamander Skin Boots
(20216,2428,1,1,1,250),-- Plate Boots
(20216,2451,1,1,1,250),-- Sage\'s Worn Gloves
(20216,2931,1,1,1,10505),-- Salamander Skin Boot Lining
(20216,2932,1,1,1,10505),-- Plate Boots Design
(20216,2933,1,1,1,10505),-- Sage\'s Worn Gloves Lining
(20216,1867,1,3,2,125496),-- Animal Skin
(20216,1872,1,1,2,250991),-- Animal Bone
(20216,1882,1,1,2,41832),-- Leather
(20216,1894,1,1,2,6605),-- Crafted Leather
(20216,2314,1,1,2,822),-- Recipe: Body Slasher
(20216,5269,1,1,2,627),-- Recipe: Greater Soulshot (C) Compressed Package(100%)
(20217,1873,1,3,-1,524276),-- Silver Nugget
(20217,2075,1,1,-1,20560),-- Orcish Glaive Blade
(20217,2163,1,1,-1,133744),-- Recipe: Earring of Protection
(20217,57,1032,2115,0,700000),-- Adena
(20217,62,1,1,1,142),-- Mithril Boots
(20217,1958,1,1,1,6187),-- Mithril Boots Design
(20217,2429,1,1,1,142),-- Chain Boots
(20217,2430,1,1,1,142),-- Karmian Boots
(20217,2431,1,1,1,142),-- Plated Leather Boots
(20217,2432,1,1,1,142),-- Dwarven Chain Boots
(20217,2433,1,1,1,142),-- Boots of Seal
(20217,2452,1,1,1,142),-- Reinforced Mithril Gloves
(20217,2453,1,1,1,142),-- Chain Gloves
(20217,2454,1,1,1,142),-- Karmian Gloves
(20217,2937,1,1,1,6187),-- Chain Boots Part
(20217,2938,1,1,1,6187),-- Karmian Boots Fabric
(20217,2939,1,1,1,6187),-- Plate Leather Boot Lining
(20217,2940,1,1,1,6187),-- Dwarven Chain Boots Part
(20217,2941,1,1,1,6187),-- Boots of Seal Pattern
(20217,2942,1,1,1,6187),-- Reinforced Mithril Gloves Design
(20217,2943,1,1,1,6187),-- Chain Gloves Design
(20217,2944,1,1,1,6187),-- Karmian Gloves Fabric
(20217,1868,1,1,2,206484),-- Thread
(20217,1873,1,1,2,41297),-- Silver Nugget
(20217,1889,1,1,2,6883),-- Compound Braid
(20217,2163,1,1,2,5267),-- Recipe: Earring of Protection
(20217,2321,1,1,2,360),-- Recipe: Stiletto
(20217,2225,1,1,2,2244),-- Recipe: Demon's Stockings
(20217,5279,1,1,2,344),-- Recipe: Greater Blessed Spiritshot (C) Compressed Package(100%)
(20217,5549,1,1,2,10324),-- Metallic Thread
(20217,8723,1,1,200,4130),-- Life Stone: level 46
(20217,8733,1,1,200,1032),-- Mid-Grade Life Stone: level 46
(20217,8743,1,1,200,103),-- High-Grade Life Stone: level 46
(20217,8753,1,1,200,20),-- Top-Grade Life Stone: level 46
(20218,1876,1,1,-1,545172),-- Mithril Ore
(20218,1908,1,1,-1,258131),-- Moonstone Earring Wire
(20218,2073,1,1,-1,21069),-- Chakram Edge
(20218,57,1078,2190,0,700000),-- Adena
(20218,631,1,1,1,421),-- Eldarake
(20218,1964,1,1,1,17350),-- Eldarake Temper
(20218,2413,1,1,1,295),-- Chain Hood
(20218,2495,1,1,1,421),-- Chain Shield
(20218,2936,1,1,1,15758),-- Chain Hood Pattern
(20218,2945,1,1,1,17350),-- Chain Shield Fragment
(20218,1864,1,1,2,214714),-- Stem
(20218,1869,1,1,2,107357),-- Iron Ore
(20218,1878,1,1,2,42943),-- Braided Hemp
(20218,1884,1,1,2,66066),-- Cord
(20218,2217,1,1,2,6352),-- Recipe: Knight\'s Shield
(20218,2319,1,1,2,374),-- Recipe: Raid Sword
(20218,2320,1,1,2,374),-- Recipe: Cursed Staff
(20218,4039,1,1,2,3578),-- Mold Glue
(20218,8723,1,1,200,4294),-- Life Stone: level 46
(20218,8733,1,1,200,1073),-- Mid-Grade Life Stone: level 46
(20218,8743,1,1,200,107),-- High-Grade Life Stone: level 46
(20218,8753,1,1,200,22),-- Top-Grade Life Stone: level 46
(20219,1873,1,3,-1,614037),-- Silver Nugget
(20219,2060,1,1,-1,24378),-- Stormbringer Blade
(20219,2164,1,1,-1,236168),-- Recipe: Ring of Protection
(20219,57,1209,2473,0,700000),-- Adena
(20219,281,1,1,1,82),-- Crystallized Ice Bow
(20219,2074,1,1,1,5139),-- Crystallized Ice Bow Shaft
(20219,1865,1,1,2,131910),-- Varnish
(20219,1870,1,1,2,131910),-- Coal
(20219,1874,1,1,2,8794),-- Oriharukon Ore
(20219,2230,1,1,2,2556),-- Recipe: Theca Leather Gaiters
(20219,2326,1,1,2,459),-- Recipe: Horn of Glory
(20219,4039,1,1,2,4397),-- Mold Glue
(20219,4043,1,1,2,4397),-- Asofe
(20219,8723,1,1,200,5276),-- Life Stone: level 46
(20219,8733,1,1,200,1319),-- Mid-Grade Life Stone: level 46
(20219,8743,1,1,200,132),-- High-Grade Life Stone: level 46
(20219,8753,1,1,200,27),-- Top-Grade Life Stone: level 46
(20220,1895,1,1,-1,883618),-- Metallic Fiber
(20220,1911,1,1,-1,230023),-- Earring of Protection Gemstone
(20220,2944,1,1,-1,277992),-- Karmian Gloves Fabric
(20220,57,1221,2490,0,700000),-- Adena
(20220,1126,1,1,1,184),-- Crimson Boots
(20220,1974,1,1,1,9603),-- Crimson Boot Fabric
(20220,2434,1,1,1,184),-- Rind Leather Boots
(20220,2455,1,1,1,200),-- Plated Leather Gloves
(20220,2456,1,1,1,184),-- Dwarven Chain Gloves
(20220,2457,1,1,1,184),-- Gloves of Seal
(20220,2458,1,1,1,184),-- Rind Leather Gloves
(20220,2946,1,1,1,6382),-- Plate Leather Gloves Design
(20220,2948,1,1,1,9603),-- Rind Leather Boot Lining
(20220,2949,1,1,1,9603),-- Dwarven Chain Gloves Design
(20220,2950,1,1,1,9603),-- Gloves of Seal Pattern
(20220,2951,1,1,1,9603),-- Rind Leather Gloves Design
(20220,951,1,1,2,208),-- Scroll: Enchant Weapon (Grade C)
(20220,1866,1,1,2,76127),-- Suede
(20220,1871,1,1,2,114191),-- Charcoal
(20220,1877,1,1,2,4568),-- Adamantite Nugget
(20220,2343,1,1,2,266),-- Recipe: Mace of the Underworld
(20220,2345,1,1,2,266),-- Recipe: Dark Screamer
(20220,4040,1,1,2,2284),-- Mold Lubricant
(20220,4041,1,1,2,993),-- Mold Hardener
(20220,8724,1,1,200,3806),-- Life Stone: level 49
(20220,8734,1,1,200,952),-- Mid-Grade Life Stone: level 49
(20220,8744,1,1,200,95),-- High-Grade Life Stone: level 49
(20220,8754,1,1,200,19),-- Top-Grade Life Stone: level 49
(20221,951,1,1,-1,8105),-- Scroll: Enchant Weapon (Grade C)
(20221,2073,1,1,-1,34456),-- Chakram Edge
(20221,2352,1,1,-1,9326),-- Recipe: Widow Maker
(20221,57,1763,3583,0,700000),-- Adena
(20221,1126,1,1,1,266),-- Crimson Boots
(20221,1974,1,1,1,13842),-- Crimson Boot Fabric
(20221,2434,1,1,1,266),-- Rind Leather Boots
(20221,2455,1,1,1,288),-- Plated Leather Gloves
(20221,2456,1,1,1,266),-- Dwarven Chain Gloves
(20221,2457,1,1,1,266),-- Gloves of Seal
(20221,2458,1,1,1,266),-- Rind Leather Gloves
(20221,2946,1,1,1,9200),-- Plate Leather Gloves Design
(20221,2948,1,1,1,13842),-- Rind Leather Boot Lining
(20221,2949,1,1,1,13842),-- Dwarven Chain Gloves Design
(20221,2950,1,1,1,13842),-- Gloves of Seal Pattern
(20221,2951,1,1,1,13842),-- Rind Leather Gloves Design
(20221,1539,1,1,2,31352),-- Greater Healing Potion
(20221,1867,1,1,2,188108),-- Animal Skin
(20221,1872,1,1,2,188108),-- Animal Bone
(20221,1875,1,1,2,9405),-- Stone of Purity
(20221,1881,1,1,2,18811),-- Coarse Bone Powder
(20221,2334,1,1,2,328),-- Recipe: Sword of Whispering Death
(20221,2351,1,1,2,295),-- Recipe: Scorpion
(20221,3005,1,1,2,5758),-- Recipe: Demon\'s Boots
(20221,4041,1,1,2,1227),-- Mold Hardener
(20221,6668,1,1,2,50386),-- Deluxe Chest Key - Grade 4
(20221,8724,1,1,200,4703),-- Life Stone: level 49
(20221,8734,1,1,200,1176),-- Mid-Grade Life Stone: level 49
(20221,8744,1,1,200,117),-- High-Grade Life Stone: level 49
(20221,8754,1,1,200,23),-- Top-Grade Life Stone: level 49
(20222,1876,1,1,-1,679016),-- Mithril Ore
(20222,1895,1,3,-1,485011),-- Metallic Fiber
(20222,2168,1,1,-1,86389),-- Recipe: Necklace of Mermaid
(20222,57,1340,2733,0,700000),-- Adena
(20222,500,1,1,1,270),-- Great Helmet
(20222,632,1,1,1,385),-- Knight\'s Shield
(20222,1971,1,1,1,15348),-- Great Helmet Material
(20222,1972,1,1,1,20056),-- Knight\'s Shield Fragment
(20222,2496,1,1,1,418),-- Dwarven Chain Shield
(20222,2947,1,1,1,17907),-- Dwarven Chain Shield Fragment
(20222,1539,1,1,2,27858),-- Greater Healing Potion
(20222,1868,1,1,2,250715),-- Thread
(20222,1873,1,1,2,50143),-- Silver Nugget
(20222,1876,1,1,2,25071),-- Mithril Ore
(20222,1895,1,1,2,35816),-- Metallic Fiber
(20222,2222,1,1,2,783),-- Recipe: Composite Armor
(20222,3006,1,1,2,5117),-- Recipe: Demon\'s Gloves
(20222,4042,1,1,2,2089),-- Enria
(20222,8724,1,1,200,4178),-- Life Stone: level 49
(20222,8734,1,1,200,1045),-- Mid-Grade Life Stone: level 49
(20222,8744,1,1,200,104),-- High-Grade Life Stone: level 49
(20222,8754,1,1,200,21),-- Top-Grade Life Stone: level 49
(20223,734,1,1,-1,49539),-- Haste Potion
(20223,1864,1,1,-1,594474),-- Stem
(20223,2011,1,1,-1,6781),-- Short Spear Edge
(20223,57,137,239,0,700000),-- Adena
(20223,845,1,1,1,1284),-- Cat\'s Eye Earring
(20223,877,1,1,1,1925),-- Ring of Wisdom
(20223,908,1,1,1,963),-- Necklace of Wisdom
(20223,1897,1,1,1,10453),-- Necklace of Wisdom Chain
(20223,1864,1,1,2,87799),-- Stem
(20223,1869,1,1,2,43900),-- Iron Ore
(20223,1878,1,1,2,17560),-- Braided Hemp
(20223,2175,1,1,2,35691),-- Recipe: Boots
(20224,1865,1,1,-1,466983),-- Varnish
(20224,1898,1,1,-1,47969),-- Blue Diamond Necklace Gem
(20224,2178,1,1,-1,74717),-- Recipe: Dark Stockings
(20224,57,212,381,0,700000),-- Adena
(20224,27,1,1,1,486),-- Hard Leather Shirt
(20224,33,1,1,1,779),-- Hard Leather Gaiters
(20224,1927,1,1,1,5502),-- Hard Leather Shirt Pattern
(20224,1929,1,1,1,8899),-- Hard Leather Gaiters Material
(20224,1867,1,1,2,73568),-- Animal Skin
(20224,1872,1,1,2,73568),-- Animal Bone
(20224,1881,1,1,2,7357),-- Coarse Bone Powder
(20224,5153,1,1,2,2207),-- Recipe: Soulshot (D) Compressed Package (100%)
(20224,5268,1,1,2,2207),-- Recipe: Greater Soulshot (D) Compressed Package (100%)
(20225,1931,1,1,-1,54861),-- Leather Boot Lining
(20225,2152,1,1,-1,73889),-- Recipe: Enchanted Necklace
(20225,2259,1,1,-1,6517),-- Recipe: Spinebone Sword
(20225,57,185,346,0,700000),-- Adena
(20225,40,1,1,1,732),-- Leather Boots
(20225,604,1,1,1,732),-- Crafted Leather Gloves
(20225,1931,1,1,1,7697),-- Leather Boot Lining
(20225,1934,1,1,1,7697),-- Crafted Leather Gloves Lining
(20225,1865,1,1,2,39257),-- Varnish
(20225,1870,1,1,2,39257),-- Coal
(20225,1875,1,1,2,2617),-- Stone of Purity
(20225,1879,1,1,2,6543),-- Cokes
(20225,2259,1,1,2,610),-- Recipe: Spinebone Sword
(20225,5437,1,1,2,960),-- Recipe: Heavy Sword(100%)
(20226,413,1,1,-1,2937),-- Puma Skin Gaiters
(20226,1868,1,1,-1,884148),-- Thread
(20226,1899,1,1,-1,69074),-- Necklace of Devotion Chain
(20226,57,192,367,0,700000),-- Adena
(20226,123,1,1,1,39),-- Saber
(20226,2017,1,1,1,824),-- Saber Blade
(20226,5285,1,1,1,39),-- Heavy Sword
(20226,5531,1,1,1,1041),-- Heavy Sword Edge
(20226,1866,1,1,2,41351),-- Suede
(20226,1871,1,1,2,62027),-- Charcoal
(20226,2178,1,1,2,9924),-- Recipe: Dark Stockings
(20226,5220,1,1,2,2481),-- Metal Hardener
(20227,1899,1,1,-1,72835),-- Necklace of Devotion Chain
(20227,2178,1,1,-1,74583),-- Recipe: Dark Stockings
(20227,2260,1,1,-1,7238),-- Recipe: Mace of Judgment
(20227,57,201,388,0,700000),-- Adena
(20227,391,1,1,1,543),-- Puma Skin Shirt
(20227,413,1,1,1,869),-- Puma Skin Gaiters
(20227,1867,1,1,2,69763),-- Animal Skin
(20227,1872,1,1,2,69763),-- Animal Bone
(20227,1882,1,1,2,11627),-- Leather
(20227,2181,1,1,2,5237),-- Recipe: White Tunic
(20227,6035,1,1,2,4360),-- Magic Haste Potion
(20228,1884,1,1,-1,328429),-- Cord
(20228,1931,1,1,-1,69764),-- Leather Boot Lining
(20228,2180,1,1,-1,40128),-- Recipe: Scale Mail
(20228,57,229,448,0,700000),-- Adena
(20228,847,1,1,1,724),-- Red Crescent Earring
(20228,890,1,1,1,1085),-- Ring of Devotion
(20228,910,1,1,1,543),-- Necklace of Devotion
(20228,1899,1,1,1,11701),-- Necklace of Devotion Chain
(20228,1831,1,1,2,133123),-- Antidote
(20228,1868,1,1,2,99843),-- Thread
(20228,1873,1,1,2,19969),-- Silver Nugget
(20228,1889,1,1,2,3328),-- Compound Braid
(20228,2180,1,1,2,3754),-- Recipe: Scale Mail
(20228,5549,1,1,2,4992),-- Metallic Thread
(20229,414,1,1,-1,2458),-- Lion Skin Gaiters
(20229,1061,1,1,-1,357490),-- Healing Potion
(20229,1864,1,3,-1,589858),-- Stem
(20229,57,249,498,0,700000),-- Adena
(20229,848,1,1,1,491),-- Enchanted Earring
(20229,879,1,1,1,739),-- Enchanted Ring
(20229,911,1,1,1,369),-- Enchanted Necklace
(20229,1900,1,1,1,8817),-- Enchanted Necklace Chain
(20229,1832,1,1,2,51164),-- Greater Antidote
(20229,1864,1,1,2,92095),-- Stem
(20229,1869,1,1,2,46048),-- Iron Ore
(20229,1880,1,1,2,4605),-- Steel
(20229,2265,1,1,2,476),-- Recipe: Spiked Club
(20229,2274,1,1,2,329),-- Recipe: Skull Breaker
(20229,5550,1,1,2,614),-- Durable Metal Plate
(20230,434,1,1,-1,1746),-- White Tunic
(20230,1834,1,1,-1,745819),-- Emergency Dressing
(20230,1870,1,1,-1,671237),-- Coal
(20230,57,284,566,0,700000),-- Adena
(20230,292,1,1,1,148),-- Pike
(20230,956,1,1,2,3057),-- Scroll: Enchant Armor (Grade D)
(20230,1865,1,1,2,91701),-- Varnish
(20230,1870,1,1,2,91701),-- Coal
(20230,1874,1,1,2,6113),-- Oriharukon Ore
(20231,1832,1,1,-1,722627),-- Greater Antidote
(20231,1877,1,1,-1,26015),-- Adamantite Nugget
(20231,2282,1,1,-1,4645),-- Recipe: Cursed Maingauche
(20231,57,274,550,0,700000),-- Adena
(20231,605,1,1,1,1389),-- Leather Gauntlets
(20231,1123,1,1,1,1389),-- Blue Buckskin Boots
(20231,955,1,1,2,237),-- Scroll: Enchant Weapon (Grade D)
(20231,1832,1,1,2,65815),-- Greater Antidote
(20231,1866,1,1,2,39489),-- Suede
(20231,1871,1,1,2,59233),-- Charcoal
(20231,1877,1,1,2,2369),-- Adamantite Nugget
(20231,2277,1,1,2,423),-- Recipe: Bich\'hwa
(20232,1901,1,1,-1,87485),-- Tiger\'s Eye Earring Stone
(20232,2027,1,1,-1,8298),-- Spiked Club Head
(20232,2147,1,1,-1,45242),-- Recipe: Blacksmith\'s frame
(20232,57,268,535,0,700000),-- Adena
(20232,47,1,1,1,575),-- Helmet
(20232,628,1,1,1,821),-- Hoplon
(20232,1867,1,1,2,74838),-- Animal Skin
(20232,1872,1,1,2,74838),-- Animal Bone
(20232,1875,1,1,2,3742),-- Stone of Purity
(20232,1881,1,1,2,7484),-- Coarse Bone Powder
(20232,2156,1,1,2,4490),-- Recipe: Elven Necklace
(20232,2191,1,1,2,7514),-- Recipe: RIP Gauntlets
(20233,955,1,1,-1,2969),-- Scroll: Enchant Weapon (Grade D)
(20233,2154,1,1,-1,79458),-- Recipe: Elven Earring
(20233,2280,1,1,-1,5301),-- Recipe: Crucifix of Blood
(20233,57,313,625,0,700000),-- Adena
(20233,849,1,1,1,399),-- Tiger\'s Eye Earring
(20233,880,1,1,1,598),-- Black Pearl Ring
(20233,912,1,1,1,299),-- Near Forest Necklace
(20233,1901,1,1,1,13625),-- Tiger\'s Eye Earring Stone
(20233,1832,1,1,2,62633),-- Greater Antidote
(20233,1868,1,1,2,112739),-- Thread
(20233,1873,1,1,2,22548),-- Silver Nugget
(20233,1876,1,1,2,11274),-- Mithril Ore
(20233,2273,1,1,2,403),-- Recipe: Tarbar
(20233,2274,1,1,2,403),-- Recipe: Skull Breaker
(20233,2975,1,1,2,5033),-- Recipe: Brigandine Helmet
(20234,1879,1,1,-1,124798),-- Cokes
(20234,1938,1,1,-1,50339),-- Mithril Banded Mail Material
(20234,2971,1,1,-1,40042),-- Recipe: Mithril Scale Gaiters
(20234,57,316,631,0,700000),-- Adena
(20234,293,1,1,1,53),-- War Hammer
(20234,296,1,1,1,53),-- Dwarven Pike
(20234,1868,1,1,2,159250),-- Thread
(20234,1873,1,1,2,31850),-- Silver Nugget
(20234,1876,1,1,2,15925),-- Mithril Ore
(20234,2188,1,1,2,5687),-- Recipe: Manticore Skin Gaiters
(20234,2979,1,1,2,10659),-- Recipe: Manticore Skin Gloves
(20235,2074,1,1,-1,8417),-- Crystallized Ice Bow Shaft
(20235,2163,1,1,-1,60630),-- Recipe: Earring of Protection
(20235,2340,1,1,-1,2764),-- Recipe: Pa\'agrian Hammer
(20235,57,470,955,0,700000),-- Adena
(20235,96,1,1,1,11),-- Scythe
(20235,298,1,1,1,11),-- Orcish Glaive
(20235,302,1,1,1,11),-- Body Slasher
(20235,2062,1,1,1,734),-- Scythe Edge
(20235,2075,1,1,1,734),-- Orcish Glaive Blade
(20235,2076,1,1,1,734),-- Body Slasher Blade
(20235,1865,1,1,2,56163),-- Varnish
(20235,1870,1,1,2,56163),-- Coal
(20235,1874,1,1,2,3744),-- Oriharukon Ore
(20235,2216,1,1,2,2321),-- Recipe: Great Helmet
(20235,4039,1,1,2,1872),-- Mold Glue
(20235,4043,1,1,2,1872),-- Asofe
(20235,8723,1,1,200,2247),-- Life Stone: level 46
(20235,8733,1,1,200,562),-- Mid-Grade Life Stone: level 46
(20235,8743,1,1,200,56),-- High-Grade Life Stone: level 46
(20235,8753,1,1,200,11),-- Top-Grade Life Stone: level 46
(20236,1908,1,1,-1,116435),-- Moonstone Earring Wire
(20236,2219,1,1,-1,76370),-- Recipe: Crimson Boots
(20236,3021,1,1,-1,4284),-- Recipe: Dwarven War Hammer
(20236,57,484,990,0,700000),-- Adena
(20236,62,1,1,1,66),-- Mithril Boots
(20236,1958,1,1,1,2902),-- Mithril Boots Design
(20236,2429,1,1,1,66),-- Chain Boots
(20236,2430,1,1,1,66),-- Karmian Boots
(20236,2431,1,1,1,66),-- Plated Leather Boots
(20236,2432,1,1,1,66),-- Dwarven Chain Boots
(20236,2433,1,1,1,66),-- Boots of Seal
(20236,2452,1,1,1,66),-- Reinforced Mithril Gloves
(20236,2453,1,1,1,66),-- Chain Gloves
(20236,2454,1,1,1,66),-- Karmian Gloves
(20236,2937,1,1,1,2902),-- Chain Boots Part
(20236,2938,1,1,1,2902),-- Karmian Boots Fabric
(20236,2939,1,1,1,2902),-- Plate Leather Boot Lining
(20236,2940,1,1,1,2902),-- Dwarven Chain Boots Part
(20236,2941,1,1,1,2902),-- Boots of Seal Pattern
(20236,2942,1,1,1,2902),-- Reinforced Mithril Gloves Design
(20236,2943,1,1,1,2902),-- Chain Gloves Design
(20236,2944,1,1,1,2902),-- Karmian Gloves Fabric
(20236,1865,1,1,2,58111),-- Varnish
(20236,1870,1,1,2,58111),-- Coal
(20236,1874,1,1,2,3874),-- Oriharukon Ore
(20236,2216,1,1,2,2401),-- Recipe: Great Helmet
(20236,4039,1,1,2,1037),-- Mold Glue
(20236,4043,1,1,2,1937),-- Asofe
(20236,8723,1,1,200,2324),-- Life Stone: level 46
(20236,8733,1,1,200,581),-- Mid-Grade Life Stone: level 46
(20236,8743,1,1,200,58),-- High-Grade Life Stone: level 46
(20236,8753,1,1,200,12),-- Top-Grade Life Stone: level 46
(20237,951,1,1,-1,3007),-- Scroll: Enchant Weapon (Grade C)
(20237,2329,1,1,-1,3846),-- Recipe: Tsurugi
(20237,3010,1,1,-1,44939),-- Recipe: Composite Helmet
(20237,57,653,1332,0,700000),-- Adena
(20237,282,1,1,1,17),-- Elemental Bow
(20237,285,1,1,1,17),-- Noble Elven Bow
(20237,2085,1,1,1,1267),-- Crossbow Shaft
(20237,2086,1,1,1,1267),-- Elven Bow of Nobility Shaft
(20237,952,1,1,2,814),-- Scroll: Enchant Armor (Grade C)
(20237,1342,10,30,2,122123),-- Fine Steel Arrow
(20237,1864,1,1,2,122124),-- Stem
(20237,1869,1,1,2,61062),-- Iron Ore
(20237,1880,1,1,2,6106),-- Steel
(20237,2230,1,1,2,1183),-- Recipe: Theca Leather Gaiters
(20237,4043,1,1,2,2035),-- Asofe
(20237,5550,1,1,2,814),-- Durable Metal Plate
(20237,8724,1,1,200,5952),-- Life Stone: level 49
(20237,8734,1,1,200,509),-- Mid-Grade Life Stone: level 49
(20237,8744,1,1,200,51),-- High-Grade Life Stone: level 49
(20237,8754,1,1,200,10),-- Top-Grade Life Stone: level 49
(20238,1877,1,1,-1,63734),-- Adamantite Nugget
(20238,2357,1,1,-1,2599),-- Recipe: Crystal Dagger
(20238,4041,1,1,-1,13855),-- Mold Hardener
(20238,57,630,1281,0,700000),-- Adena
(20238,355,1,1,1,71),-- Dwarven Chain Mail Shirt
(20238,382,1,1,1,114),-- Dwarven Chain Gaiters
(20238,1968,1,1,1,4253),-- Dwarven Chain Mail Shirt Material
(20238,1969,1,1,1,6745),-- Dwarven Chain Gaiters Material
(20238,1866,1,1,2,39221),-- Suede
(20238,1871,1,1,2,58831),-- Charcoal
(20238,1877,1,1,2,2353),-- Adamantite Nugget
(20238,2335,1,1,2,137),-- Recipe: War Axe
(20238,2348,1,1,2,137),-- Recipe: Heathen\'s Book
(20238,4040,1,1,2,1177),-- Mold Lubricant
(20238,4041,1,1,2,512),-- Mold Hardener
(20238,6668,1,1,2,21011),-- Deluxe Chest Key - Grade 4
(20238,8724,1,1,200,1961),-- Life Stone: level 49
(20238,8734,1,1,200,490),-- Mid-Grade Life Stone: level 49
(20238,8744,1,1,200,49),-- High-Grade Life Stone: level 49
(20238,8754,1,1,200,10),-- Top-Grade Life Stone: level 49
(20239,1867,1,5,-1,753426),-- Animal Skin
(20239,2079,1,1,-1,11647),-- Bec De Corbin Blade
(20239,3007,1,1,-1,61644),-- Recipe: Theca Leather Boots
(20239,57,669,1365,0,700000),-- Adena
(20239,73,1,1,1,8),-- Shamshir
(20239,74,1,1,1,8),-- Katana
(20239,131,1,1,1,8),-- Spirit Sword
(20239,133,1,1,1,8),-- Raid Sword
(20239,2077,1,1,1,624),-- Shamshir Blade
(20239,2078,1,1,1,624),-- Katana Blade
(20239,2080,1,1,1,624),-- Spirit Sword Blade
(20239,2081,1,1,1,624),-- Raid Sword Blade
(20239,952,1,1,2,835),-- Scroll: Enchant Armor (Grade C)
(20239,1867,1,1,2,83456),-- Animal Skin
(20239,1872,1,1,2,83456),-- Animal Bone
(20239,1875,1,1,2,4173),-- Stone of Purity
(20239,1881,1,1,2,8346),-- Coarse Bone Powder
(20239,2351,1,1,2,131),-- Recipe: Scorpion
(20239,3007,1,1,2,2276),-- Recipe: Theca Leather Boots
(20239,4041,1,1,2,544),-- Mold Hardener
(20239,8724,1,1,200,2086),-- Life Stone: level 49
(20239,8734,1,1,200,522),-- Mid-Grade Life Stone: level 49
(20239,8744,1,1,200,52),-- High-Grade Life Stone: level 49
(20239,8754,1,1,200,11),-- Top-Grade Life Stone: level 49
(20240,2092,1,1,-1,9934),-- Homunkulus\'s Sword Blade
(20240,2353,1,1,-1,2974),-- Recipe: Samurai Longsword
(20240,4601,1,1,-1,5051),-- Greater Dye of Strength <Str+3 Con-3>
(20240,57,722,1466,0,700000),-- Adena
(20240,265,1,1,1,23),-- Fist Blade
(20240,2108,1,1,1,2019),-- Fist Blade Piece
(20240,1864,1,1,2,137054),-- Stem
(20240,1869,1,1,2,68527),-- Iron Ore
(20240,1878,1,1,2,27411),-- Braided Hemp
(20240,1884,1,1,2,42171),-- Cord
(20240,3019,1,1,2,1827),-- Recipe: Full Plate Shield
(20240,3022,1,1,2,112),-- Recipe: Yaksa Mace
(20240,4039,1,1,2,2284),-- Mold Glue
(20240,8725,1,1,200,1903),-- Life Stone: level 52
(20240,8735,1,1,200,476),-- Mid-Grade Life Stone: level 52
(20240,8745,1,1,200,48),-- High-Grade Life Stone: level 52
(20240,8755,1,1,200,9),-- Top-Grade Life Stone: level 52
(20241,1539,1,1,-1,402767),-- Greater Healing Potion
(20241,2100,1,1,-1,10217),-- Paradia Staff Head
(20241,3015,1,1,-1,50627),-- Recipe: Drake Leather Gloves
(20241,57,720,1455,0,700000),-- Adena
(20241,854,1,1,1,110),-- Earring of Binding
(20241,885,1,1,1,165),-- Ring of Ages
(20241,917,1,1,1,83),-- Necklace of Mermaid
(20241,1914,1,1,1,7017),-- Earring of Binding Gemstone
(20241,1915,1,1,1,11005),-- Ring of Ages Gemstone
(20241,1916,1,1,1,5315),-- Necklace of Mermaid Teardrop
(20241,1867,1,1,2,76873),-- Animal Skin
(20241,1872,1,1,2,76873),-- Animal Bone
(20241,1875,1,1,2,3844),-- Stone of Purity
(20241,1881,1,1,2,7687),-- Coarse Bone Powder
(20241,2359,1,1,2,94),-- Recipe: Eminence Bow
(20241,3014,1,1,2,1610),-- Recipe: Full Plate Boots
(20241,4041,1,1,2,501),-- Mold Hardener
(20241,4604,1,1,2,128),-- Greater Dye of Constitution <Con+3 Dex-3>
(20241,4609,1,1,2,128),-- Greater Dye of Mental Strength <Men+3 Int-3>
(20241,8725,1,1,200,1601),-- Life Stone: level 52
(20241,8735,1,1,200,400),-- Mid-Grade Life Stone: level 52
(20241,8745,1,1,200,40),-- High-Grade Life Stone: level 52
(20241,8755,1,1,200,8),-- Top-Grade Life Stone: level 52
(20242,1868,1,9,-1,774035),-- Thread
(20242,1918,1,1,-1,83806),-- Nassen\'s Earring Gemstone
(20242,1985,1,1,-1,66727),-- Theca Leather Gaiters Pattern
(20242,57,766,1556,0,700000),-- Adena
(20242,400,1,1,1,38),-- Theca Leather Armor
(20242,401,1,1,1,18),-- Drake Leather Armor
(20242,420,1,1,1,60),-- Theca Leather Gaiters
(20242,1984,1,1,1,2553),-- Theca Leather Armor Pattern
(20242,1985,1,1,1,4106),-- Theca Leather Gaiters Pattern
(20242,1987,1,1,1,1817),-- Drake Leather Armor Texture
(20242,1867,1,1,2,68047),-- Animal Skin
(20242,1872,1,1,2,68047),-- Animal Bone
(20242,1875,1,1,2,3402),-- Stone of Purity
(20242,1881,1,1,2,6805),-- Coarse Bone Powder
(20242,3034,1,1,2,102),-- Recipe: Spiritshot B
(20242,4041,1,1,2,444),-- Mold Hardener
(20242,4941,1,1,2,393),-- Recipe: Zubei\'s Gaiters  (60%)
(20242,4959,1,1,2,983),-- Recipe: Avadon Boots (60%)
(20242,5270,1,1,2,102),-- Recipe: Greater Soulshot (B) Compressed Package(100%)
(20242,6669,1,1,2,11869),-- Deluxe Chest Key - Grade 5
(20242,8726,1,1,200,1181),-- Life Stone: level 55
(20242,8736,1,1,200,295),-- Mid-Grade Life Stone: level 55
(20242,8746,1,1,200,30),-- High-Grade Life Stone: level 55
(20242,8756,1,1,200,6),-- Top-Grade Life Stone: level 55
(20243,1806,1,1,-1,3451),-- Recipe: Soulshot: B-Grade
(20243,1873,1,1,-1,690175),-- Silver Nugget
(20243,4599,1,1,-1,5751),-- Greater Dye of Wit <Wit+2 Int-2>
(20243,57,682,1388,0,700000),-- Adena
(20243,203,1,1,1,3),-- Pa\'agrian Axe
(20243,204,1,1,1,3),-- Deadman\'s Staff
(20243,205,1,1,1,3),-- Ghoul\'s Staff
(20243,206,1,1,1,3),-- Demon\'s Staff
(20243,2112,1,1,1,309),-- Pa\'agrian Axe Blade
(20243,2116,1,1,1,300),-- Deadman\'s Staff Head
(20243,2117,1,1,1,300),-- Ghoul\'s Staff Head
(20243,2118,1,1,1,300),-- Demon\'s Staff Head
(20243,2503,1,1,1,3),-- Yaksa Mace
(20243,2969,1,1,1,306),-- Yaksa Mace Head
(20243,1864,1,1,2,106181),-- Stem
(20243,1869,1,1,2,53091),-- Iron Ore
(20243,1880,1,1,2,5309),-- Steel
(20243,4043,1,1,2,1770),-- Asofe
(20243,4144,1,1,2,546),-- Recipe: Zubei\'s Leather Gaiters
(20243,4184,1,1,2,61),-- Recipe: Sprite\'s Staff
(20243,5155,1,1,2,106),-- Recipe: Soulshot (B) Compressed Package (100%)
(20243,5550,1,1,2,708),-- Durable Metal Plate
(20243,8726,1,1,200,1229),-- Life Stone: level 55
(20243,8736,1,1,200,307),-- Mid-Grade Life Stone: level 55
(20243,8746,1,1,200,31),-- High-Grade Life Stone: level 55
(20243,8756,1,1,200,6),-- Top-Grade Life Stone: level 55
(20244,2117,1,1,-1,8346),-- Ghoul\'s Staff Head
(20244,3955,1,1,-1,3548),-- Recipe: Blessed Spiritshot B
(20244,4592,1,1,-1,5913),-- Greater Dye of Constitution <Con+2 Dex-2>
(20244,57,701,1428,0,700000),-- Adena
(20244,400,1,1,1,34),-- Theca Leather Armor
(20244,401,1,1,1,16),-- Drake Leather Armor
(20244,420,1,1,1,55),-- Theca Leather Gaiters
(20244,1984,1,1,1,2340),-- Theca Leather Armor Pattern
(20244,1985,1,1,1,3764),-- Theca Leather Gaiters Pattern
(20244,1987,1,1,1,1665),-- Drake Leather Armor Texture
(20244,1867,1,1,2,72778),-- Animal Skin
(20244,1872,1,1,2,72778),-- Animal Bone
(20244,1875,1,1,2,3639),-- Stone of Purity
(20244,1881,1,1,2,7278),-- Coarse Bone Powder
(20244,4041,1,1,2,475),-- Mold Hardener
(20244,4185,1,1,2,63),-- Recipe: Keshanberk
(20244,5436,1,1,2,89),-- Recipe: Berserker Blade(100%)
(20244,8322,1,1,2,63),-- Recipe: Ice Storm Hammer (60%)
(20244,8726,1,1,200,1264),-- Life Stone: level 55
(20244,8736,1,1,200,316),-- Mid-Grade Life Stone: level 55
(20244,8746,1,1,200,32),-- High-Grade Life Stone: level 55
(20244,8756,1,1,200,6),-- Top-Grade Life Stone: level 55
(20245,1895,1,1,-1,526594),-- Metallic Fiber
(20245,4071,1,1,-1,33383),-- Avadon Robe Fabric
(20245,4129,1,1,-1,19947),-- Recipe: Earrings of Black Ore
(20245,57,727,1485,0,700000),-- Adena
(20245,12160,1,1,1,435),-- Common Item - Zubei\'s Helmet
(20245,12159,1,1,1,621),-- Common Item - Zubei\'s Shield
(20245,12171,1,1,1,621),-- Common Item - Avadon Shield
(20245,12170,1,1,1,435),-- Common Item - Avadon Circlet
(20245,4072,1,1,1,3056),-- Avadon Circlet Pattern
(20245,4101,1,1,1,3945),-- Zubei\'s Shield Fragment
(20245,4102,1,1,1,3056),-- Zubei\'s Helmet Design
(20245,4439,1,1,1,4693),-- Avadon Shield Fragment
(20245,1864,1,1,2,83756),-- Stem
(20245,1869,1,1,2,41878),-- Iron Ore
(20245,1878,1,1,2,16751),-- Braided Hemp
(20245,1884,1,1,2,25771),-- Cord
(20245,4039,1,1,2,1396),-- Mold Glue
(20245,4945,1,1,2,322),-- Recipe: Avadon Gaiters (60%)
(20245,4999,1,1,2,521),-- Recipe: Doom Boots (60%)
(20245,8322,1,1,2,48),-- Recipe: Ice Storm Hammer (60%)
(20245,6036,1,1,2,1396),-- Greater Magic Haste Potion
(20245,8726,1,1,200,969),-- Life Stone: level 55
(20245,8736,1,1,200,242),-- Mid-Grade Life Stone: level 55
(20245,8746,1,1,200,24),-- High-Grade Life Stone: level 55
(20245,8756,1,1,200,5),-- Top-Grade Life Stone: level 55
(20246,947,1,1,-1,945),-- Scroll: Enchant Weapon (Grade B)
(20246,2964,1,1,-1,128620),-- Divine Gloves Pattern
(20246,4049,1,1,-1,123897),-- Adamantite Earring Gemstone
(20246,57,933,1900,0,700000),-- Adena
(20246,12338,1,1,1,953),-- Common Item - Adamantite Earring
(20246,12340,1,1,1,1436),-- Common Item - Adamantite Ring
(20246,12339,1,1,1,716),-- Common Item - Adamantite Necklace
(20246,4049,1,1,1,6100),-- Adamantite Earring Gemstone
(20246,4050,1,1,1,7205),-- Adamantite Ring Wire
(20246,4051,1,1,1,4510),-- Adamantite Necklace Chain
(20246,1864,1,1,2,116288),-- Stem
(20246,1869,1,1,2,58144),-- Iron Ore
(20246,1880,1,1,2,5814),-- Steel
(20246,4043,1,1,2,1938),-- Asofe
(20246,4157,1,1,2,289),-- Recipe: Blue Wolf Gaiters
(20246,4176,1,1,2,723),-- Recipe: Doom Boots
(20246,4969,1,1,2,67),-- Recipe: Hell Knife (60%)
(20246,5550,1,1,2,775),-- Durable Metal Plate
(20246,8727,1,1,200,1163),-- Life Stone: level 58
(20246,8737,1,1,200,291),-- Mid-Grade Life Stone: level 58
(20246,8747,1,1,200,29),-- High-Grade Life Stone: level 58
(20246,8757,1,1,200,6),-- Top-Grade Life Stone: level 58
(20248,955,1,1,-1,2256),-- Scroll: Enchant Weapon (Grade D)
(20248,1865,1,1,-1,564065),-- Varnish
(20248,2250,1,1,-1,141016),-- Recipe: Bone Arrow
(20248,57,239,476,0,700000),-- Adena
(20248,86,1,1,1,12),-- Tomahawk
(20248,179,1,1,1,12),-- Mace of Prayer
(20248,180,1,1,1,12),-- Mace of Judgment
(20248,181,1,1,1,12),-- Mace of Miracle
(20248,182,1,1,1,12),-- Doom Hammer
(20248,183,1,1,1,12),-- Mystic Staff
(20248,184,1,1,1,12),-- Conjuror\'s Staff
(20248,185,1,1,1,12),-- Staff of Mana
(20248,2022,1,1,1,480),-- Mace of Judgment Head
(20248,2023,1,1,1,382),-- Conjuror\'s Staff Head
(20248,1829,1,1,2,20549),-- Scroll of Escape: Clan Hall
(20248,1865,1,1,2,51373),-- Varnish
(20248,1870,1,1,2,51373),-- Coal
(20248,1874,1,1,2,3425),-- Oriharukon Ore
(20248,2192,1,1,2,6553),-- Recipe: Kite Shield
(20248,2274,1,1,2,367),-- Recipe: Skull Breaker
(20249,1865,1,3,-1,600835),-- Varnish
(20249,1873,1,2,-1,480668),-- Silver Nugget
(20249,57,508,1015,0,700000),-- Adena
(20249,260,1,1,1,172),-- Triple-Edged Jamadhr
(20249,1341,20,60,2,152124),-- Bone Arrow
(20249,1868,1,1,2,182548),-- Thread
(20249,1873,1,1,2,36510),-- Silver Nugget
(20249,1889,1,1,2,6085),-- Compound Braid
(20249,2186,1,1,2,3053),-- Recipe: Brigandine Tunic
(20249,5549,1,1,2,9127),-- Metallic Thread
(20249,6667,1,1,2,57046),-- Deluxe Chest Key - Grade 3
(20250,1884,1,1,-1,281232),-- Cord
(20250,1899,1,1,-1,71407),-- Necklace of Devotion Chain
(20250,2259,1,1,-1,7096),-- Recipe: Spinebone Sword
(20250,57,197,380,0,700000),-- Adena
(20250,847,1,1,1,620),-- Red Crescent Earring
(20250,890,1,1,1,929),-- Ring of Devotion
(20250,910,1,1,1,465),-- Necklace of Devotion
(20250,1899,1,1,1,10019),-- Necklace of Devotion Chain
(20250,1865,1,1,2,51297),-- Varnish
(20250,1870,1,1,2,51297),-- Coal
(20250,1874,1,1,2,3420),-- Oriharukon Ore
(20250,2182,1,1,2,6158),-- Recipe: Scale Gaiters
(20250,5437,1,1,2,1254),-- Recipe: Heavy Sword(100%)
(20251,1880,1,1,-1,48038),-- Steel
(20251,2017,1,1,-1,6384),-- Saber Blade
(20251,2152,1,1,-1,84573),-- Recipe: Enchanted Necklace
(20251,57,206,403,0,700000),-- Adena
(20251,123,1,1,1,43),-- Saber
(20251,2017,1,1,1,896),-- Saber Blade
(20251,5285,1,1,1,43),-- Heavy Sword
(20251,5531,1,1,1,1132),-- Heavy Sword Edge
(20251,1866,1,1,2,44934),-- Suede
(20251,1871,1,1,2,67401),-- Charcoal
(20251,1877,1,1,2,2696),-- Adamantite Nugget
(20251,2181,1,1,2,6747),-- Recipe: White Tunic
(20252,1061,1,1,-1,304704),-- Healing Potion
(20252,1865,1,1,-1,502762),-- Varnish
(20252,1900,1,1,-1,55007),-- Enchanted Necklace Chain
(20252,57,213,422,0,700000),-- Adena
(20252,605,1,1,1,1073),-- Leather Gauntlets
(20252,1123,1,1,1,1073),-- Blue Buckskin Boots
(20252,1867,1,1,2,45790),-- Animal Skin
(20252,1872,1,1,2,45790),-- Animal Bone
(20252,1875,1,1,2,2290),-- Stone of Purity
(20252,1881,1,1,2,4579),-- Coarse Bone Powder
(20252,2185,1,1,2,6760),-- Recipe: Iron Boots
(20252,2187,1,1,2,1533),-- Recipe: Manticore Skin Shirt
(20252,2274,1,1,2,245),-- Recipe: Skull Breaker
(20252,6666,1,1,2,34342),-- Deluxe Chest Key - Grade 2
(20253,1900,1,1,-1,58669),-- Enchanted Necklace Chain
(20253,2153,1,1,-1,83396),-- Recipe: Tiger\'s Eye Earring
(20253,2265,1,1,-1,5545),-- Recipe: Spiked Club
(20253,57,226,452,0,700000),-- Adena
(20253,348,1,1,1,143),-- Scale Mail
(20253,377,1,1,1,229),-- Scale Gaiters
(20253,1935,1,1,1,4093),-- Scale Mail Fragment
(20253,1937,1,1,1,6294),-- Scale Gaiters Fragment
(20253,1868,1,1,2,117213),-- Thread
(20253,1873,1,1,2,23443),-- Silver Nugget
(20253,1876,1,1,2,11721),-- Mithril Ore
(20253,2266,1,1,2,606),-- Recipe: Shilen Knife
(20253,2971,1,1,2,3134),-- Recipe: Mithril Scale Gaiters
(20254,1899,1,1,-1,77326),-- Necklace of Devotion Chain
(20254,2181,1,1,-1,49538),-- Recipe: White Tunic
(20254,2262,1,1,-1,7685),-- Recipe: Elven Bow
(20254,57,212,415,0,700000),-- Adena
(20254,291,1,1,1,88),-- Trident
(20254,2019,1,1,1,2987),-- Trident Edge
(20254,1876,1,1,2,9258),-- Mithril Ore
(20254,1877,1,1,2,1852),-- Adamantite Nugget
(20254,1880,1,1,2,4629),-- Steel
(20254,1881,1,1,2,6172),-- Coarse Bone Powder
(20254,1882,1,1,2,10287),-- Leather
(20254,2182,1,1,2,5557),-- Recipe: Scale Gaiters
(20265,1866,1,1,-1,449035),-- Suede
(20265,1872,1,1,-1,898071),-- Animal Bone
(20265,2015,1,1,-1,8214),-- Sword Breaker Edge
(20265,57,306,549,0,700000),-- Adena
(20265,219,1,1,1,219),-- Sword Breaker
(20265,2015,1,1,1,2426),-- Sword Breaker Edge
(20265,1867,1,1,2,106111),-- Animal Skin
(20265,1872,1,1,2,106111),-- Animal Bone
(20265,1882,1,1,2,17685),-- Leather
(20265,5158,1,1,2,3183),-- Recipe: Spiritshot (D) Compressed Package (100%)
(20265,8294,1,1,2,3183),-- Recipe: Steel Sword (100%)
(20266,1866,1,1,-1,279792),-- Suede
(20266,1878,1,1,-1,167875),-- Braided Hemp
(20266,2180,1,1,-1,31555),-- Recipe: Scale Mail
(20266,57,185,346,0,700000),-- Adena
(20266,432,1,1,1,489),-- Cursed Tunic
(20266,465,1,1,1,782),-- Cursed Stockings
(20266,1874,1,1,2,3926),-- Oriharukon Ore
(20266,1878,1,1,2,23554),-- Braided Hemp
(20266,2260,1,1,2,914),-- Recipe: Mace of Judgment
(20266,5220,1,1,2,2355),-- Metal Hardener
(20267,1061,1,1,-1,341857),-- Healing Potion
(20267,1882,1,1,-1,125348),-- Leather
(20267,2203,1,1,-1,122890),-- Recipe: Mithril Boots
(20267,57,239,476,0,700000),-- Adena
(20267,69,1,1,1,25),-- Bastard Sword
(20267,125,1,1,1,25),-- Spinebone Sword
(20267,126,1,1,1,25),-- Artisan\'s Sword
(20267,128,1,1,1,25),-- Knight\'s Sword
(20267,2021,1,1,1,778),-- Spinebone Sword Blade
(20267,1868,1,1,2,123295),-- Thread
(20267,1873,1,1,2,24659),-- Silver Nugget
(20267,1876,1,1,2,12330),-- Mithril Ore
(20267,2153,1,1,2,9588),-- Recipe: Tiger\'s Eye Earring
(20267,2274,1,1,2,440),-- Recipe: Skull Breaker
(20268,1878,1,2,-1,308026),-- Braided Hemp
(20268,1900,1,1,-1,84252),-- Enchanted Necklace Chain
(20268,57,324,651,0,700000),-- Adena
(20268,275,1,1,1,57),-- Long Bow
(20268,276,1,1,1,57),-- Elven Bow
(20268,2024,1,1,1,1998),-- Elven Bow Shaft
(20268,956,1,1,2,2805),-- Scroll: Enchant Armor (Grade D)
(20268,1867,1,1,2,112216),-- Animal Skin
(20268,1872,1,1,2,112216),-- Animal Bone
(20268,1875,1,1,2,5611),-- Stone of Purity
(20268,1881,1,1,2,11222),-- Coarse Bone Powder
(20269,1879,1,1,-1,111342),-- Cokes
(20269,2029,1,1,-1,7969),-- Gastraphetes Shaft
(20269,2154,1,1,-1,71526),-- Recipe: Elven Earring
(20269,57,282,563,0,700000),-- Adena
(20269,157,1,1,1,32),-- Spiked Club
(20269,186,1,1,1,32),-- Staff of Magic
(20269,2027,1,1,1,1551),-- Spiked Club Head
(20269,1875,1,1,2,2960),-- Stone of Purity
(20269,1879,1,1,2,7400),-- Cokes
(20269,1885,1,1,2,3700),-- High Grade Suede
(20269,2275,1,1,2,317),-- Recipe: Heavy Bone Club
(20269,2286,1,1,2,247),-- Recipe: Bonebreaker
(20269,5549,1,1,2,4440),-- Metallic Thread
(20269,5550,1,1,2,592),-- Durable Metal Plate
(20269,6667,1,1,2,27750),-- Deluxe Chest Key - Grade 3
(20270,1901,1,1,-1,130274),-- Tiger\'s Eye Earring Stone
(20270,2972,1,1,-1,50438),-- Recipe: Brigandine Gaiters
(20270,2976,1,1,-1,126263),-- Recipe: Manticore Skin Boots
(20270,57,398,795,0,700000),-- Adena
(20270,393,1,1,1,143),-- Mithril Banded Mail
(20270,394,1,1,1,143),-- Reinforced Leather Shirt
(20270,415,1,1,1,228),-- Mithril Banded Gaiters
(20270,416,1,1,1,228),-- Reinforced Leather Gaiters
(20270,1938,1,1,1,5619),-- Mithril Banded Mail Material
(20270,1939,1,1,1,7341),-- Mithril Banded Gaiters Material
(20270,1341,20,60,2,167161),-- Bone Arrow
(20270,1865,1,1,2,100297),-- Varnish
(20270,1870,1,1,2,100297),-- Coal
(20270,1874,1,1,2,6686),-- Oriharukon Ore
(20270,2980,1,1,2,13426),-- Recipe: Brigandine Gauntlets
(20271,1882,1,1,-1,170847),-- Leather
(20271,2155,1,1,-1,123405),-- Recipe: Elven Ring
(20271,2271,1,1,-1,5492),-- Recipe: Winged Spear
(20271,57,325,650,0,700000),-- Adena
(20271,849,1,1,1,414),-- Tiger\'s Eye Earring
(20271,880,1,1,1,619),-- Black Pearl Ring
(20271,912,1,1,1,310),-- Near Forest Necklace
(20271,1901,1,1,1,14115),-- Tiger\'s Eye Earring Stone
(20271,1874,1,1,2,3406),-- Oriharukon Ore
(20271,1878,1,1,2,20439),-- Braided Hemp
(20271,1884,1,1,2,31444),-- Cord
(20271,1889,1,1,2,3406),-- Compound Braid
(20271,2187,1,1,2,2281),-- Recipe: Manticore Skin Shirt
(20271,2269,1,1,2,365),-- Recipe: Morning Star
(20271,2293,1,1,2,284),-- Recipe: Glaive
(20271,5220,1,1,2,2044),-- Metal Hardener
(20291,1879,1,1,-1,69130),-- Cokes
(20291,1898,1,1,-1,42607),-- Blue Diamond Necklace Gem
(20291,2255,1,1,-1,10141),-- Recipe: Saber
(20291,57,189,337,0,700000),-- Adena
(20291,27,1,1,1,431),-- Hard Leather Shirt
(20291,33,1,1,1,692),-- Hard Leather Gaiters
(20291,1927,1,1,1,4887),-- Hard Leather Shirt Pattern
(20291,1929,1,1,1,7904),-- Hard Leather Gaiters Material
(20291,734,1,1,2,8168),-- Haste Potion
(20291,1864,1,1,2,98016),-- Stem
(20291,1869,1,1,2,49008),-- Iron Ore
(20291,1878,1,1,2,19603),-- Braided Hemp
(20291,2257,1,1,2,1198),-- Recipe: Trident
(20292,2139,1,1,-1,61663),-- Recipe: Steel Mold
(20292,2150,1,1,-1,144749),-- Recipe: Blue Diamond Necklace
(20292,5220,1,1,-1,12333),-- Metal Hardener
(20292,57,142,248,0,700000),-- Adena
(20292,845,1,1,1,1331),-- Cat\'s Eye Earring
(20292,877,1,1,1,1997),-- Ring of Wisdom
(20292,908,1,1,1,999),-- Necklace of Wisdom
(20292,1897,1,1,1,10842),-- Necklace of Wisdom Chain
(20292,1866,1,1,2,30358),-- Suede
(20292,1871,1,1,2,45537),-- Charcoal
(20292,2252,1,1,2,1867),-- Recipe: Iron Hammer
(20292,5158,1,1,2,1822),-- Recipe: Spiritshot (D) Compressed Package (100%)
(20307,1060,1,1,-1,330759),-- Lesser Healing Potion
(20307,1867,1,1,-1,198456),-- Animal Skin
(20307,2137,1,1,-1,43777),-- Recipe: Steel
(20307,57,80,108,0,700000),-- Adena
(20307,5,1,1,1,458),-- Mace
(20307,8,1,1,1,458),-- Willow Staff
(20307,152,1,1,1,709),-- Heavy Chisel
(20307,2006,1,1,1,1570),-- Willow Staff Head
(20307,1802,1,1,2,31517),-- Recipe: Necklace of Anguish
(20307,1864,1,1,2,29311),-- Stem
(20307,1865,1,1,2,14656),-- Varnish
(20307,1866,1,1,2,9771),-- Suede
(20307,1868,1,1,2,29311),-- Thread
(20307,1873,1,1,2,5863),-- Silver Nugget
(20308,1868,1,2,-1,475131),-- Thread
(20308,1897,1,1,-1,56563),-- Necklace of Wisdom Chain
(20308,1924,1,1,-1,76634),-- Leather Helmet Design
(20308,57,118,183,0,700000),-- Adena
(20308,38,1,1,1,1796),-- Low Boots
(20308,50,1,1,1,1796),-- Leather Gloves
(20308,1925,1,1,1,30677),-- Leather Gloves Lining
(20308,1868,1,1,2,70174),-- Thread
(20308,1873,1,1,2,14035),-- Silver Nugget
(20308,2143,1,1,2,7018),-- Recipe: Synthetic Cokes
(20308,5158,1,1,2,1404),-- Recipe: Spiritshot (D) Compressed Package (100%)
(20310,735,1,1,-1,19993),-- Potion of Alacrity
(20310,1800,1,1,-1,75446),-- Recipe: Piece Bone Breastplate
(20310,1872,1,1,-1,319890),-- Animal Bone
(20310,57,119,185,0,700000),-- Adena
(20310,38,1,1,1,1814),-- Low Boots
(20310,50,1,1,1,1814),-- Leather Gloves
(20310,1925,1,1,1,30981),-- Leather Gloves Lining
(20310,1865,1,1,2,47246),-- Varnish
(20310,1870,1,1,2,47246),-- Coal
(20310,2144,1,1,2,9450),-- Recipe: Compound Braid
(20311,1060,1,1,-1,172757),-- Lesser Healing Potion
(20311,2005,1,1,-1,5553),-- Broadsword Blade
(20311,57,41,58,0,700000),-- Adena
(20311,1119,1,1,1,6514),-- Short Leather Gloves
(20311,1122,1,1,1,6514),-- Cotton Shoes
(20311,1129,1,1,1,6514),-- Crude Leather Shoes
(20311,1060,1,1,2,25515),-- Lesser Healing Potion
(20311,1789,1,1,2,2123),-- Recipe: Cedar Staff
(20311,1868,1,1,2,22964),-- Thread
(20311,1873,1,1,2,4593),-- Silver Nugget
(20312,1666,1,1,-1,32439),-- Recipe: Wooden Arrow
(20312,1866,1,1,-1,64878),-- Suede
(20312,2136,1,1,-1,28622),-- Recipe: Cokes
(20312,57,51,72,0,700000),-- Adena
(20312,19,1,1,1,11733),-- Small Shield
(20312,42,1,1,1,8213),-- Leather Cap
(20312,734,1,1,2,2396),-- Haste Potion
(20312,1802,1,1,2,30910),-- Recipe: Necklace of Anguish
(20312,1864,1,1,2,28746),-- Stem
(20312,1869,1,1,2,14373),-- Iron Ore
(20313,22,1,1,-1,19461),-- Leather Shirt
(20313,1814,1,1,-1,95767),-- Recipe: Leather
(20313,2006,1,1,-1,12997),-- Willow Staff Head
(20313,57,98,132,0,700000),-- Adena
(20313,428,1,1,1,2874),-- Feriotic Tunic
(20313,463,1,1,1,4594),-- Feriotic Stockings
(20313,1100,1,1,1,2874),-- Cotton Tunic
(20313,1103,1,1,1,4594),-- Cotton Stockings
(20313,1790,1,1,2,4968),-- Recipe: Dirk
(20313,1864,1,1,2,53748),-- Stem
(20313,1869,1,1,2,26874),-- Iron Ore
(20313,6037,1,1,2,53747),-- Waking Scroll
(20314,1869,1,1,-1,865765),-- Iron Ore
(20314,1874,1,1,-1,57718),-- Oriharukon Ore
(20314,4472,1,1,-1,4947),-- Dye of Constitution <Con+1 Dex-1>
(20314,57,349,705,0,700000),-- Adena
(20314,70,1,1,1,16),-- Claymore
(20314,2047,1,1,1,955),-- Claymore Blade
(20314,2499,1,1,1,16),-- Elven Long Sword
(20314,2967,1,1,1,942),-- Elven Long Sword Blade
(20314,1864,1,1,2,124214),-- Stem
(20314,1869,1,1,2,62107),-- Iron Ore
(20314,1878,1,1,2,24843),-- Braided Hemp
(20314,1884,1,1,2,38220),-- Cord
(20314,2205,1,1,2,1965),-- Recipe: Chain Gaiters
(20314,2209,1,1,2,4670),-- Recipe: Eldarake
(20314,2299,1,1,2,271),-- Recipe: Big Hammer
(20316,1792,1,1,-1,14822),-- Recipe: Short Spear
(20316,1803,1,1,-1,169394),-- Recipe: Necklace of Wisdom
(20316,1864,1,1,-1,403157),-- Stem
(20316,57,109,147,0,700000),-- Adena
(20316,23,1,1,1,1297),-- Wooden Breastplate
(20316,30,1,1,1,2078),-- Hard Leather Pants
(20316,2386,1,1,1,2078),-- Wooden Gaiters
(20316,734,1,1,2,4962),-- Haste Potion
(20316,1794,1,1,2,2190),-- Recipe: Forest Bow
(20316,1865,1,1,2,29772),-- Varnish
(20316,1870,1,1,2,29772),-- Coal
(20317,1786,1,1,-1,30885),-- Recipe: Broad Sword
(20317,1867,1,1,-1,51475),-- Animal Skin
(20317,57,19,29,0,700000),-- Adena
(20317,1,1,1,1,13530),-- Short Sword
(20317,1787,1,1,2,5322),-- Recipe: Willow Staff
(20317,1867,1,1,2,8870),-- Animal Skin
(20317,1869,1,1,2,6653),-- Iron Ore
(20317,1870,1,1,2,6653),-- Coal
(20317,1871,1,1,2,6653),-- Charcoal
(20317,1872,1,1,2,8870),-- Animal Bone
(20318,1060,1,1,-1,171046),-- Lesser Healing Potion
(20318,1866,1,1,-1,51314),-- Suede
(20318,2005,1,1,-1,5498),-- Broadsword Blade
(20318,57,41,58,0,700000),-- Adena
(20318,3,1,1,1,474),-- Broadsword
(20318,2005,1,1,1,1625),-- Broadsword Blade
(20318,1866,1,1,2,15158),-- Suede
(20318,1871,1,1,2,22736),-- Charcoal
(20319,1787,1,1,-1,45293),-- Recipe: Willow Staff
(20319,1865,1,1,-1,56617),-- Varnish
(20319,57,30,42,0,700000),-- Adena
(20319,112,1,1,1,102689),-- Apprentice\'s Earring
(20319,116,1,1,1,156087),-- Magic Ring
(20319,118,1,1,1,76514),-- Necklace of Magic
(20319,1787,1,1,2,7805),-- Recipe: Willow Staff
(20319,1864,1,1,2,19512),-- Stem
(20319,1865,1,1,2,9756),-- Varnish
(20319,1866,1,1,2,6504),-- Suede
(20319,1868,1,1,2,19512),-- Thread
(20319,1873,1,1,2,3903),-- Silver Nugget
(20320,1831,1,1,-1,557587),-- Antidote
(20320,1867,1,1,-1,278794),-- Animal Skin
(20320,2010,1,1,-1,8136),-- Brandish Blade
(20320,57,112,154,0,700000),-- Adena
(20320,216,1,1,1,297),-- Dirk
(20320,2009,1,1,1,2191),-- Dirk Blade
(20320,1799,1,1,2,61001),-- Recipe: Leather Gloves
(20320,1867,1,1,2,54902),-- Animal Skin
(20320,1872,1,1,2,54902),-- Animal Bone
(20321,1060,1,1,-1,396420),-- Lesser Healing Potion
(20321,1870,1,1,-1,178389),-- Coal
(20321,2005,1,1,-1,12742),-- Broadsword Blade
(20321,57,96,130,0,700000),-- Adena
(20321,5,1,1,1,549),-- Mace
(20321,8,1,1,1,549),-- Willow Staff
(20321,152,1,1,1,850),-- Heavy Chisel
(20321,2006,1,1,1,1882),-- Willow Staff Head
(20321,1791,1,1,2,2783),-- Recipe: Brandish
(20321,1833,1,1,2,40148),-- Bandage
(20321,1864,1,1,2,30111),-- Stem
(20321,1865,1,1,2,15056),-- Varnish
(20321,1866,1,1,2,10037),-- Suede
(20321,1868,1,1,2,30111),-- Thread
(20321,1873,1,1,2,6023),-- Silver Nugget
(20322,1796,1,1,-1,156757),-- Recipe: Leather Tunic
(20322,1870,1,1,-1,124622),-- Coal
(20322,2005,1,1,-1,8902),-- Broadsword Blade
(20322,57,67,91,0,700000),-- Adena
(20322,12,1,1,1,767),-- Knife
(20322,215,1,1,1,767),-- Doom Dagger
(20322,17,10,30,2,92028),-- Wooden Arrow
(20322,1867,1,1,2,24541),-- Animal Skin
(20322,1872,1,1,2,24541),-- Animal Bone
(20322,2137,1,1,2,5414),-- Recipe: Steel
(20323,1792,1,1,-1,16716),-- Recipe: Short Spear
(20323,1865,1,1,-1,227339),-- Varnish
(20323,1869,1,1,-1,227339),-- Iron Ore
(20323,57,116,172,0,700000),-- Adena
(20323,216,1,1,1,323),-- Dirk
(20323,2009,1,1,1,2382),-- Dirk Blade
(20323,1792,1,1,2,2469),-- Recipe: Short Spear
(20323,1866,1,1,2,22385),-- Suede
(20323,1871,1,1,2,33577),-- Charcoal
(20323,6037,1,1,2,67153),-- Waking Scroll
(20324,1791,1,1,-1,33633),-- Recipe: Brandish
(20324,1871,1,1,-1,181957),-- Charcoal
(20324,2006,1,1,-1,12997),-- Willow Staff Head
(20324,57,98,132,0,700000),-- Adena
(20324,5,1,1,1,560),-- Mace
(20324,8,1,1,1,560),-- Willow Staff
(20324,152,1,1,1,867),-- Heavy Chisel
(20324,2006,1,1,1,1920),-- Willow Staff Head
(20324,1795,1,1,2,67608),-- Recipe:Leather Shoes
(20324,1867,1,1,2,23888),-- Animal Skin
(20324,1869,1,1,2,17916),-- Iron Ore
(20324,1870,1,1,2,17916),-- Coal
(20324,1871,1,1,2,17916),-- Charcoal
(20324,1872,1,1,2,23888),-- Animal Bone
(20325,118,1,1,-1,222026),-- Necklace of Magic
(20325,1786,1,1,-1,45293),-- Recipe: Broad Sword
(20325,1787,1,1,-1,45293),-- Recipe: Willow Staff
(20325,57,30,42,0,700000),-- Adena
(20325,112,1,1,1,102689),-- Apprentice\'s Earring
(20325,116,1,1,1,156087),-- Magic Ring
(20325,118,1,1,1,76514),-- Necklace of Magic
(20325,1060,1,1,2,26015),-- Lesser Healing Potion
(20325,1788,1,1,2,9366),-- Recipe: Bow 
(20325,1865,1,1,2,11707),-- Varnish
(20325,1870,1,1,2,11707),-- Coal
(20325,6037,1,1,2,23414),-- Waking Scroll
(20326,2006,1,1,-1,8902),-- Willow Staff Head
(20326,2007,1,1,-1,8902),-- Bow Shaft
(20326,2135,1,1,-1,36653),-- Recipe: Braided Hemp
(20326,57,67,91,0,700000),-- Adena
(20326,22,1,1,1,3937),-- Leather Shirt
(20326,29,1,1,1,6293),-- Leather Pants
(20326,1864,1,1,2,24542),-- Stem
(20326,1865,1,1,2,12271),-- Varnish
(20326,1866,1,1,2,8181),-- Suede
(20326,1868,1,1,2,24542),-- Thread
(20326,1873,1,1,2,4909),-- Silver Nugget
(20326,2138,1,1,2,3609),-- Recipe: Coarse Bone Powder (100%)
(20327,1865,1,1,-1,56617),-- Varnish
(20327,1870,1,1,-1,56617),-- Coal
(20327,1872,1,1,-1,75489),-- Animal Bone
(20327,57,30,42,0,700000),-- Adena
(20327,112,1,1,1,102689),-- Apprentice\'s Earring
(20327,116,1,1,1,156087),-- Magic Ring
(20327,118,1,1,1,76514),-- Necklace of Magic
(20327,1786,1,1,2,15609),-- Recipe: Broad Sword
(20327,1867,1,1,2,26015),-- Animal Skin
(20327,1872,1,1,2,26015),-- Animal Bone
(20328,1865,1,1,-1,124622),-- Varnish
(20328,1869,1,1,-1,124622),-- Iron Ore
(20328,2137,1,1,-1,36653),-- Recipe: Steel
(20328,57,67,91,0,700000),-- Adena
(20328,12,1,1,1,767),-- Knife
(20328,215,1,1,1,767),-- Doom Dagger
(20328,1060,1,1,2,23373),-- Lesser Healing Potion
(20328,1666,1,1,2,3506),-- Recipe: Wooden Arrow
(20328,1867,1,1,2,14024),-- Animal Skin
(20328,1869,1,1,2,10518),-- Iron Ore
(20328,1870,1,1,2,10518),-- Coal
(20328,1871,1,1,2,10518),-- Charcoal
(20328,1872,1,1,2,14024),-- Animal Bone
(20329,1869,1,1,-1,287587),-- Iron Ore
(20329,1880,1,1,-1,28759),-- Steel
(20329,1898,1,1,-1,29542),-- Blue Diamond Necklace Gem
(20329,57,131,234,0,700000),-- Adena
(20329,16,1,1,1,181),-- Long Spear
(20329,1867,1,1,2,32362),-- Animal Skin
(20329,1869,1,1,2,24271),-- Iron Ore
(20329,1870,1,1,2,24271),-- Coal
(20329,1871,1,1,2,24271),-- Charcoal
(20329,1872,1,1,2,32362),-- Animal Bone
(20329,2258,1,1,2,593),-- Recipe: Temptation of Abyss
(20329,5268,1,1,2,971),-- Recipe: Greater Soulshot (D) Compressed Package (100%)
(20330,1792,1,1,-1,12352),-- Recipe: Short Spear
(20330,1866,1,1,-1,111988),-- Suede
(20330,1896,1,1,-1,71179),-- Necklace of Anguish Chain
(20330,57,91,122,0,700000),-- Adena
(20330,37,1,1,1,3243),-- Leather Shoes
(20330,49,1,1,1,3243),-- Gloves
(20330,1921,1,1,1,21342),-- Leather Shoes Texture
(20330,1798,1,1,2,32431),-- Recipe: Leather Helmet
(20330,1864,1,1,2,66159),-- Stem
(20330,1869,1,1,2,33080),-- Iron Ore
(20331,1871,1,1,-1,148657),-- Charcoal
(20331,2005,1,1,-1,10618),-- Broadsword Blade
(20331,2007,1,1,-1,10618),-- Bow Shaft
(20331,57,80,108,0,700000),-- Adena
(20331,113,1,1,1,9443),-- Mystic\'s Earring
(20331,875,1,1,1,13940),-- Ring of Knowledge
(20331,906,1,1,1,7054),-- Necklace of Knowledge
(20331,734,1,1,2,3660),-- Haste Potion
(20331,1796,1,1,2,27617),-- Recipe: Leather Tunic
(20331,1865,1,1,2,21956),-- Varnish
(20331,1870,1,1,2,21956),-- Coal
(20333,1792,1,1,-1,17783),-- Recipe: Short Spear
(20333,1798,1,1,-1,237113),-- Recipe: Leather Helmet
(20333,2008,1,1,-1,9411),-- Cedar Staff Head
(20333,57,127,180,0,700000),-- Adena
(20333,255,1,1,1,343),-- Fox Claw Gloves
(20333,2371,1,1,1,733),-- Fist of Butcher
(20333,734,1,1,2,5954),-- Haste Potion
(20333,1803,1,1,2,30018),-- Recipe: Necklace of Wisdom
(20333,1868,1,1,2,71441),-- Thread
(20333,1873,1,1,2,14289),-- Silver Nugget
(20335,734,1,1,-1,40607),-- Haste Potion
(20335,1867,1,1,-1,324856),-- Animal Skin
(20335,1897,1,1,-1,58010),-- Necklace of Wisdom Chain
(20335,57,119,191,0,700000),-- Adena
(20335,2,1,1,1,69),-- Long Sword
(20335,120,1,1,1,69),-- Sword of Reflection
(20335,121,1,1,1,69),-- Sword of Watershadow
(20335,2012,1,1,1,750),-- Sword of Reflection Blade
(20335,1867,1,1,2,47979),-- Animal Skin
(20335,1872,1,1,2,47979),-- Animal Bone
(20335,2174,1,1,2,15646),-- Recipe: Hard Leather Gaiters
(20335,5158,1,1,2,1440),-- Recipe: Spiritshot (D) Compressed Package (100%)
(20336,29,1,1,-1,21303),-- Leather Pants
(20336,1060,1,1,-1,276937),-- Lesser Healing Potion
(20336,1802,1,1,-1,268004),-- Recipe: Necklace of Anguish
(20336,57,67,91,0,700000),-- Adena
(20336,428,1,1,1,1969),-- Feriotic Tunic
(20336,463,1,1,1,3146),-- Feriotic Stockings
(20336,1100,1,1,1,1969),-- Cotton Tunic
(20336,1103,1,1,1,3146),-- Cotton Stockings
(20336,1789,1,1,2,2269),-- Recipe: Cedar Staff
(20336,1864,1,1,2,24541),-- Stem
(20336,1865,1,1,2,12271),-- Varnish
(20336,1866,1,1,2,8181),-- Suede
(20336,1868,1,1,2,24541),-- Thread
(20336,1873,1,1,2,4909),-- Silver Nugget
(20338,1898,1,1,-1,32496),-- Blue Diamond Necklace Gem
(20338,1927,1,1,-1,25237),-- Hard Leather Shirt Pattern
(20338,3032,1,1,-1,12654),-- Recipe: Spiritshot D
(20338,57,144,257,0,700000),-- Adena
(20338,16,1,1,1,199),-- Long Spear
(20338,1831,1,1,2,124592),-- Antidote
(20338,1868,1,1,2,93444),-- Thread
(20338,1873,1,1,2,18689),-- Silver Nugget
(20338,3032,1,1,2,1869),-- Recipe: Spiritshot D
(20340,1792,1,1,-1,13068),-- Recipe: Short Spear
(20340,57,95,131,0,700000),-- Adena
(20340,255,1,1,1,252),-- Fox Claw Gloves
(20340,2371,1,1,1,539),-- Fist of Butcher
(20340,1803,1,1,2,29412),-- Recipe: Necklace of Wisdom
(20340,1865,1,1,2,35000),-- Varnish
(20340,1870,1,1,2,35000),-- Coal
(20341,1897,1,1,-1,58257),-- Necklace of Wisdom Chain
(20341,2141,1,1,-1,48936),-- Recipe: Silver Mold
(20341,2143,1,1,-1,48936),-- Recipe: Synthetic Cokes
(20341,57,115,195,0,700000),-- Adena
(20341,44,1,1,1,924),-- Leather Helmet
(20341,102,1,1,1,1321),-- Round Shield
(20341,945,1,1,1,2738),-- Skeleton Buckler
(20341,1924,1,1,1,11657),-- Leather Helmet Design
(20341,1866,1,1,2,32123),-- Suede
(20341,1871,1,1,2,48184),-- Charcoal
(20341,2175,1,1,2,39174),-- Recipe: Boots
(20342,429,1,1,-1,6970),-- Leather Tunic
(20342,1793,1,1,-1,15682),-- Recipe: Sword of Reflection
(20342,1870,1,1,-1,213277),-- Coal
(20342,57,114,157,0,700000),-- Adena
(20342,255,1,1,1,303),-- Fox Claw Gloves
(20342,2371,1,1,1,646),-- Fist of Butcher
(20342,736,1,1,2,21000),-- Scroll of Escape
(20342,1864,1,1,2,83999),-- Stem
(20342,1869,1,1,2,42000),-- Iron Ore
(20343,1060,1,1,-1,404348),-- Lesser Healing Potion
(20343,1795,1,1,-1,686629),-- Recipe:Leather Shoes
(20343,2005,1,1,-1,12997),-- Broadsword Blade
(20343,57,98,132,0,700000),-- Adena
(20343,113,1,1,1,11558),-- Mystic\'s Earring
(20343,875,1,1,1,17062),-- Ring of Knowledge
(20343,906,1,1,1,8634),-- Necklace of Knowledge
(20343,1797,1,1,2,72387),-- Recipe: Leather Stockings
(20343,1864,1,1,2,71663),-- Stem
(20343,1869,1,1,2,35832),-- Iron Ore
(20345,1925,1,1,-1,145655),-- Leather Gloves Lining
(20345,2174,1,1,-1,96576),-- Recipe: Hard Leather Gaiters
(20345,5220,1,1,-1,8885),-- Metal Hardener
(20345,57,110,171,0,700000),-- Adena
(20345,24,1,1,1,421),-- Bone Breastplate
(20345,31,1,1,1,671),-- Bone Gaiters
(20345,390,1,1,1,421),-- Cotton Shirt
(20345,412,1,1,1,671),-- Cotton Pants
(20345,1800,1,1,2,8254),-- Recipe: Piece Bone Breastplate
(20345,1831,1,1,2,69986),-- Antidote
(20345,1866,1,1,2,17497),-- Suede
(20345,1871,1,1,2,26245),-- Charcoal
(20345,5268,1,1,2,1050),-- Recipe: Greater Soulshot (D) Compressed Package (100%)
(20346,1803,1,1,-1,169366),-- Recipe: Necklace of Wisdom
(20346,1831,1,1,-1,537455),-- Antidote
(20346,1869,1,1,-1,201546),-- Iron Ore
(20346,57,106,150,0,700000),-- Adena
(20346,20,1,1,1,5564),-- Buckler
(20346,43,1,1,1,3891),-- Wooden Helmet
(20346,736,1,1,2,19845),-- Scroll of Escape
(20346,1866,1,1,2,26460),-- Suede
(20346,1871,1,1,2,39690),-- Charcoal
(20348,1794,1,1,-1,14192),-- Recipe: Forest Bow
(20348,1831,1,1,-1,514696),-- Antidote
(20348,1896,1,1,-1,81784),-- Necklace of Anguish Chain
(20348,57,97,147,0,700000),-- Adena
(20348,66,1,1,1,183),-- Gladius
(20348,1333,1,1,1,183),-- Brandish
(20348,2010,1,1,1,1479),-- Brandish Blade
(20348,1799,1,1,2,56309),-- Recipe: Leather Gloves
(20348,1866,1,1,2,25339),-- Suede
(20348,1871,1,1,2,38009),-- Charcoal
(20349,1794,1,1,-1,13182),-- Recipe: Forest Bow
(20349,1921,1,1,-1,115664),-- Leather Shoes Texture
(20349,2009,1,1,-1,6357),-- Dirk Blade
(20349,57,94,133,0,700000),-- Adena
(20349,23,1,1,1,1154),-- Wooden Breastplate
(20349,30,1,1,1,1849),-- Hard Leather Pants
(20349,2386,1,1,1,1849),-- Wooden Gaiters
(20349,1792,1,1,2,2596),-- Recipe: Short Spear
(20349,1867,1,1,2,47073),-- Animal Skin
(20349,1872,1,1,2,47073),-- Animal Bone
(20350,1800,1,1,-1,63500),-- Recipe: Piece Bone Breastplate
(20350,1866,1,1,-1,134620),-- Suede
(20350,2150,1,1,-1,94803),-- Recipe: Blue Diamond Necklace
(20350,57,100,156,0,700000),-- Adena
(20350,845,1,1,1,872),-- Cat\'s Eye Earring
(20350,877,1,1,1,1308),-- Ring of Wisdom
(20350,908,1,1,1,654),-- Necklace of Wisdom
(20350,1897,1,1,1,7102),-- Necklace of Wisdom Chain
(20350,734,1,1,2,4971),-- Haste Potion
(20350,1868,1,1,2,59648),-- Thread
(20350,1873,1,1,2,11930),-- Silver Nugget
(20350,2150,1,1,2,14002),-- Recipe: Blue Diamond Necklace
(20351,735,1,1,-1,19140),-- Potion of Alacrity
(20351,1897,1,1,-1,54686),-- Necklace of Wisdom Chain
(20351,2173,1,1,-1,62245),-- Recipe: Hard Leather Shirt
(20351,57,106,184,0,700000),-- Adena
(20351,272,1,1,1,129),-- Forest Bow
(20351,2013,1,1,1,1465),-- Forest Bow Shaft
(20351,1864,1,1,2,67846),-- Stem
(20351,1869,1,1,2,33923),-- Iron Ore
(20351,1878,1,1,2,13570),-- Braided Hemp
(20351,2253,1,1,2,1391),-- Recipe: Sword Breaker
(20352,26,1,1,-1,1791),-- Bronze Breastplate
(20352,1878,1,1,-1,135435),-- Braided Hemp
(20352,57,154,276,0,700000),-- Adena
(20352,68,1,1,1,107),-- Falchion
(20352,5284,1,1,1,107),-- Zweihander
(20352,1864,1,1,2,80011),-- Stem
(20352,1869,1,1,2,40005),-- Iron Ore
(20352,1878,1,1,2,16002),-- Braided Hemp
(20352,5163,1,1,2,1600),-- Recipe: Blessed Spiritshot (D) Compressed Package (100%)
(20352,5273,1,1,2,1600),-- Recipe: Greater Spiritshot (D) Compressed Package(100%)
(20353,1864,1,1,-1,580926),-- Stem
(20353,1878,1,1,-1,116185),-- Braided Hemp
(20353,2256,1,1,-1,7102),-- Recipe: Assassin Knife
(20353,57,132,236,0,700000),-- Adena
(20353,16,1,1,1,183),-- Long Spear
(20353,1864,1,1,2,68639),-- Stem
(20353,1869,1,1,2,34319),-- Iron Ore
(20353,1878,1,1,2,13728),-- Braided Hemp
(20353,3953,1,1,2,1373),-- Recipe: Blessed Spiritshot D
(20353,5273,1,1,2,1373),-- Recipe: Greater Spiritshot (D) Compressed Package(100%)
(20356,1868,1,1,-1,856162),-- Thread
(20356,1873,1,1,-1,171232),-- Silver Nugget
(20356,1899,1,1,-1,66888),-- Necklace of Devotion Chain
(20356,57,188,353,0,700000),-- Adena
(20356,220,1,1,1,153),-- Crafted Dagger
(20356,1868,1,1,2,120126),-- Thread
(20356,1873,1,1,2,24025),-- Silver Nugget
(20356,2178,1,1,2,9610),-- Recipe: Dark Stockings
(20356,5549,1,1,2,6006),-- Metallic Thread
(20357,1804,1,1,-1,14485),-- Recipe: Soulshot: D-Grade
(20357,1898,1,1,-1,37198),-- Blue Diamond Necklace Gem
(20357,1926,1,1,-1,36578),-- Piece Bone Breastplate Fragment
(20357,57,164,295,0,700000),-- Adena
(20357,68,1,1,1,114),-- Falchion
(20357,5284,1,1,1,114),-- Zweihander
(20357,1864,1,1,2,106966),-- Stem
(20357,1869,1,1,2,53483),-- Iron Ore
(20357,1880,1,1,2,5348),-- Steel
(20357,2176,1,1,2,25590),-- Recipe: Leather Boots
(20358,1924,1,1,-1,81695),-- Leather Helmet Design
(20358,2140,1,1,-1,50651),-- Recipe: High Grade Suede
(20358,2141,1,1,-1,50651),-- Recipe: Silver Mold
(20358,57,121,200,0,700000),-- Adena
(20358,217,1,1,1,143),-- Shining Knife
(20358,218,1,1,1,143),-- Throwing Knife
(20358,1800,1,1,2,15684),-- Recipe: Piece Bone Breastplate
(20358,1866,1,1,2,33248),-- Suede
(20358,1871,1,1,2,49872),-- Charcoal
(20359,44,1,1,-1,6680),-- Leather Helmet
(20359,1872,1,1,-1,348237),-- Animal Bone
(20359,1924,1,1,-1,84251),-- Leather Helmet Design
(20359,57,122,208,0,700000),-- Adena
(20359,176,1,1,1,147),-- Journeyman\'s Staff
(20359,2501,1,1,1,147),-- Bone Club
(20359,1865,1,1,2,38575),-- Varnish
(20359,1870,1,1,2,38575),-- Coal
(20359,2252,1,1,2,1581),-- Recipe: Iron Hammer
(20359,5268,1,1,2,1543),-- Recipe: Greater Soulshot (D) Compressed Package (100%)
(20360,908,1,1,-1,5210),-- Necklace of Wisdom
(20360,1801,1,1,-1,119680),-- Recipe: Piece Bone Gaiters
(20360,2175,1,1,-1,193143),-- Recipe: Boots
(20360,57,118,183,0,700000),-- Adena
(20360,44,1,1,1,897),-- Leather Helmet
(20360,102,1,1,1,1283),-- Round Shield
(20360,945,1,1,1,2658),-- Skeleton Buckler
(20360,1924,1,1,1,11319),-- Leather Helmet Design
(20360,1867,1,1,2,46782),-- Animal Skin
(20360,1872,1,1,2,46782),-- Animal Bone
(20360,2173,1,1,2,9509),-- Recipe: Hard Leather Shirt
(20360,5273,1,1,2,1404),-- Recipe: Greater Spiritshot (D) Compressed Package(100%)
(20361,42,1,1,-1,43748),-- Leather Cap
(20361,1790,1,1,-1,28303),-- Recipe: Dirk
(20361,2005,1,1,-1,10937),-- Broadsword Blade
(20361,57,82,111,0,700000),-- Adena
(20361,14,1,1,1,942),-- Bow
(20361,2007,1,1,1,3231),-- Bow Shaft
(20361,735,1,1,2,1885),-- Potion of Alacrity
(20361,1802,1,1,2,48633),-- Recipe: Necklace of Anguish
(20361,1864,1,1,2,45229),-- Stem
(20361,1869,1,1,2,22615),-- Iron Ore
(20362,1792,1,1,-1,13068),-- Recipe: Short Spear
(20362,1799,1,1,-1,263305),-- Recipe: Leather Gloves
(20362,1867,1,1,-1,236975),-- Animal Skin
(20362,57,95,131,0,700000),-- Adena
(20362,37,1,1,1,3431),-- Leather Shoes
(20362,49,1,1,1,3431),-- Gloves
(20362,1921,1,1,1,22581),-- Leather Shoes Texture
(20362,1060,1,1,2,58333),-- Lesser Healing Potion
(20362,1792,1,1,2,1931),-- Recipe: Short Spear
(20362,1864,1,1,2,52500),-- Stem
(20362,1869,1,1,2,26250),-- Iron Ore
(20363,1867,1,1,-1,198456),-- Animal Skin
(20363,2005,1,1,-1,10632),-- Broadsword Blade
(20363,2006,1,1,-1,10632),-- Willow Staff Head
(20363,57,80,108,0,700000),-- Adena
(20363,254,1,1,1,1832),-- Iron Gloves
(20363,735,1,1,2,1832),-- Potion of Alacrity
(20363,1814,1,1,2,11570),-- Recipe: Leather
(20363,1864,1,1,2,43966),-- Stem
(20363,1869,1,1,2,21983),-- Iron Ore
(20364,1867,1,1,-1,303119),-- Animal Skin
(20364,1896,1,1,-1,96330),-- Necklace of Anguish Chain
(20364,2008,1,1,-1,8846),-- Cedar Staff Head
(20364,57,116,172,0,700000),-- Adena
(20364,255,1,1,1,323),-- Fox Claw Gloves
(20364,2371,1,1,1,689),-- Fist of Butcher
(20364,1793,1,1,2,3292),-- Recipe: Sword of Reflection
(20364,1865,1,1,2,44769),-- Varnish
(20364,1870,1,1,2,44769),-- Coal
(20365,1864,1,1,-1,249244),-- Stem
(20365,1866,1,1,-1,83081),-- Suede
(20365,1871,1,1,-1,124622),-- Charcoal
(20365,57,67,91,0,700000),-- Adena
(20365,22,1,1,1,3937),-- Leather Shirt
(20365,29,1,1,1,6293),-- Leather Pants
(20365,1666,1,1,2,8181),-- Recipe: Wooden Arrow
(20365,1866,1,1,2,16361),-- Suede
(20365,1871,1,1,2,24541),-- Charcoal
(20367,1831,1,1,-1,612488),-- Antidote
(20367,1864,1,1,-1,459366),-- Stem
(20367,1896,1,1,-1,97323),-- Necklace of Anguish Chain
(20367,57,106,184,0,700000),-- Adena
(20367,44,1,1,1,868),-- Leather Helmet
(20367,102,1,1,1,1240),-- Round Shield
(20367,945,1,1,1,2570),-- Skeleton Buckler
(20367,1924,1,1,1,10943),-- Leather Helmet Design
(20367,735,1,1,2,2262),-- Potion of Alacrity
(20367,1864,1,1,2,54276),-- Stem
(20367,1869,1,1,2,27138),-- Iron Ore
(20367,1878,1,1,2,10856),-- Braided Hemp
(20367,5153,1,1,2,1086),-- Recipe: Soulshot (D) Compressed Package (100%)
(20368,1793,1,1,-1,14820),-- Recipe: Sword of Reflection
(20368,1833,1,1,-1,537455),-- Bandage
(20368,1873,1,1,-1,80618),-- Silver Nugget
(20368,57,106,150,0,700000),-- Adena
(20368,271,1,1,1,572),-- Hunting Bow
(20368,1793,1,1,2,2919),-- Recipe: Sword of Reflection
(20368,1866,1,1,2,26460),-- Suede
(20368,1871,1,1,2,39690),-- Charcoal
(20369,390,1,1,-1,3124),-- Cotton Shirt
(20369,1897,1,1,-1,58010),-- Necklace of Wisdom Chain
(20369,2143,1,1,-1,48728),-- Recipe: Synthetic Cokes
(20369,57,119,191,0,700000),-- Adena
(20369,1101,1,1,1,923),-- Tunic of Devotion
(20369,1104,1,1,1,1473),-- Stockings of Devotion
(20369,1868,1,1,2,95958),-- Thread
(20369,1873,1,1,2,19192),-- Silver Nugget
(20369,2175,1,1,2,39008),-- Recipe: Boots
(20370,1794,1,1,-1,15375),-- Recipe: Forest Bow
(20370,1864,1,1,-1,418191),-- Stem
(20370,1922,1,1,-1,53341),-- Leather Tunic Pattern
(20370,57,112,154,0,700000),-- Adena
(20370,23,1,1,1,1346),-- Wooden Breastplate
(20370,30,1,1,1,2156),-- Hard Leather Pants
(20370,2386,1,1,1,2156),-- Wooden Gaiters
(20370,1793,1,1,2,3028),-- Recipe: Sword of Reflection
(20370,1864,1,1,2,82352),-- Stem
(20370,1869,1,1,2,41176),-- Iron Ore
(20371,114,1,1,-1,14583),-- Earring of Strength
(20371,1869,1,1,-1,196871),-- Iron Ore
(20371,1896,1,1,-1,83420),-- Necklace of Anguish Chain
(20371,57,99,150,0,700000),-- Adena
(20371,429,1,1,1,950),-- Leather Tunic
(20371,464,1,1,1,1522),-- Leather Stockings
(20371,1922,1,1,1,7418),-- Leather Tunic Pattern
(20371,1923,1,1,1,11917),-- Leather Stocking Pattern
(20371,1803,1,1,2,32579),-- Recipe: Necklace of Wisdom
(20371,1866,1,1,2,25846),-- Suede
(20371,1871,1,1,2,38769),-- Charcoal
(20372,1864,1,1,-1,303261),-- Stem
(20372,1870,1,2,-1,151631),-- Coal
(20372,57,81,110,0,700000),-- Adena
(20372,3,1,1,1,933),-- Broadsword
(20372,2005,1,1,1,3200),-- Broadsword Blade
(20372,1814,1,1,2,15716),-- Recipe: Leather
(20372,1864,1,1,2,59719),-- Stem
(20372,1869,1,1,2,29860),-- Iron Ore
(20373,1793,1,1,-1,12352),-- Recipe: Sword of Reflection
(20373,1869,1,1,-1,167982),-- Iron Ore
(20373,1871,1,1,-1,167982),-- Charcoal
(20373,57,91,122,0,700000),-- Adena
(20373,255,1,1,1,238),-- Fox Claw Gloves
(20373,2371,1,1,1,509),-- Fist of Butcher
(20373,1799,1,1,2,49008),-- Recipe: Leather Gloves
(20373,1864,1,1,2,66160),-- Stem
(20373,1869,1,1,2,33080),-- Iron Ore
(20374,1871,1,1,-1,401688),-- Charcoal
(20374,1898,1,1,-1,41262),-- Blue Diamond Necklace Gem
(20374,2255,1,1,-1,9821),-- Recipe: Saber
(20374,57,182,327,0,700000),-- Adena
(20374,257,1,1,1,252),-- Viper\'s Fang
(20374,1868,1,1,2,118652),-- Thread
(20374,1873,1,1,2,23730),-- Silver Nugget
(20374,5158,1,1,2,2373),-- Recipe: Spiritshot (D) Compressed Package (100%)
(20374,5273,1,1,2,2373),-- Recipe: Greater Spiritshot (D) Compressed Package(100%)
(20375,1804,1,1,-1,11619),-- Recipe: Soulshot: D-Grade
(20375,2014,1,1,-1,3339),-- Iron Hammer Head
(20375,2257,1,1,-1,7102),-- Recipe: Trident
(20375,57,132,236,0,700000),-- Adena
(20375,16,1,1,1,183),-- Long Spear
(20375,1865,1,1,2,34319),-- Varnish
(20375,1870,1,1,2,34319),-- Coal
(20375,1879,1,1,2,5720),-- Cokes
(20375,5158,1,1,2,1373),-- Recipe: Spiritshot (D) Compressed Package (100%)
(20378,49,1,1,-1,19759),-- Gloves
(20378,1831,1,1,-1,537455),-- Antidote
(20378,1896,1,1,-1,85401),-- Necklace of Anguish Chain
(20378,57,106,150,0,700000),-- Adena
(20378,114,1,1,1,1764),-- Earring of Strength
(20378,115,1,1,1,1764),-- Earring of Wisdom
(20378,876,1,1,1,2646),-- Ring of Anguish
(20378,907,1,1,1,1323),-- Necklace of Anguish
(20378,1896,1,1,1,10091),-- Necklace of Anguish Chain
(20378,736,1,1,2,19845),-- Scroll of Escape
(20378,1866,1,1,2,26460),-- Suede
(20378,1871,1,1,2,39690),-- Charcoal
(20379,1792,1,1,-1,18424),-- Recipe: Short Spear
(20379,1871,1,1,-1,250564),-- Charcoal
(20379,1872,1,1,-1,334085),-- Animal Bone
(20379,57,128,189,0,700000),-- Adena
(20379,114,1,1,1,2193),-- Earring of Strength
(20379,115,1,1,1,2193),-- Earring of Wisdom
(20379,876,1,1,1,3290),-- Ring of Anguish
(20379,907,1,1,1,1645),-- Necklace of Anguish
(20379,1896,1,1,1,12545),-- Necklace of Anguish Chain
(20379,1794,1,1,2,3629),-- Recipe: Forest Bow
(20379,1867,1,1,2,65789),-- Animal Skin
(20379,1872,1,1,2,65789),-- Animal Bone
(20380,1866,1,1,-1,178047),-- Suede
(20380,1869,1,1,-1,267071),-- Iron Ore
(20380,1873,1,1,-1,106828),-- Silver Nugget
(20380,57,132,206,0,700000),-- Adena
(20380,176,1,1,1,151),-- Journeyman\'s Staff
(20380,2501,1,1,1,151),-- Bone Club
(20380,1866,1,1,2,35062),-- Suede
(20380,1871,1,1,2,52593),-- Charcoal
(20380,2174,1,1,2,22867),-- Recipe: Hard Leather Gaiters
(20381,1867,1,1,-1,198210),-- Animal Skin
(20381,1875,1,1,-1,9910),-- Stone of Purity
(20381,2006,1,1,-1,10618),-- Willow Staff Head
(20381,57,80,108,0,700000),-- Adena
(20381,99,1,1,1,1830),-- Apprentice\'s Spellbook
(20381,1865,1,1,2,29274),-- Varnish
(20381,1870,1,1,2,29274),-- Coal
(20381,2136,1,1,2,8611),-- Recipe: Cokes
(20382,1831,1,1,-1,447952),-- Antidote
(20382,1870,1,1,-1,167982),-- Coal
(20382,2008,1,1,-1,6536),-- Cedar Staff Head
(20382,57,91,122,0,700000),-- Adena
(20382,20,1,1,1,4637),-- Buckler
(20382,43,1,1,1,3243),-- Wooden Helmet
(20382,1803,1,1,2,27798),-- Recipe: Necklace of Wisdom
(20382,1866,1,1,2,22053),-- Suede
(20382,1871,1,1,2,33080),-- Charcoal
(20385,1060,1,1,-1,285245),-- Lesser Healing Potion
(20385,2005,1,1,-1,9169),-- Broadsword Blade
(20385,57,69,94,0,700000),-- Adena
(20385,14,1,1,1,790),-- Bow
(20385,2007,1,1,1,2709),-- Bow Shaft
(20385,1790,1,1,2,4673),-- Recipe: Dirk
(20385,1868,1,1,2,50555),-- Thread
(20385,1873,1,1,2,10111),-- Silver Nugget
(20386,1060,1,1,-1,404348),-- Lesser Healing Potion
(20386,1666,1,1,-1,60652),-- Recipe: Wooden Arrow
(20386,1796,1,1,-1,228876),-- Recipe: Leather Tunic
(20386,57,98,132,0,700000),-- Adena
(20386,3,1,1,1,1120),-- Broadsword
(20386,2005,1,1,1,3840),-- Broadsword Blade
(20386,17,10,30,2,134369),-- Wooden Arrow
(20386,1666,1,1,2,8958),-- Recipe: Wooden Arrow
(20386,1864,1,1,2,53748),-- Stem
(20386,1869,1,1,2,26874),-- Iron Ore
(20387,1794,1,1,-1,15682),-- Recipe: Forest Bow
(20387,1833,1,1,-1,568739),-- Bandage
(20387,1896,1,1,-1,90372),-- Necklace of Anguish Chain
(20387,57,114,157,0,700000),-- Adena
(20387,66,1,1,1,202),-- Gladius
(20387,1333,1,1,1,202),-- Brandish
(20387,2010,1,1,1,1635),-- Brandish Blade
(20387,1794,1,1,2,3089),-- Recipe: Forest Bow
(20387,1864,1,1,2,83999),-- Stem
(20387,1869,1,1,2,42000),-- Iron Ore
(20388,1833,1,1,-1,537542),-- Bandage
(20388,1880,1,1,-1,20158),-- Steel
(20388,57,109,147,0,700000),-- Adena
(20388,37,1,1,1,3892),-- Leather Shoes
(20388,49,1,1,1,3892),-- Gloves
(20388,1921,1,1,1,25611),-- Leather Shoes Texture
(20388,735,1,1,2,2481),-- Potion of Alacrity
(20388,736,1,1,2,14886),-- Scroll of Escape
(20388,1864,1,1,2,59543),-- Stem
(20388,1869,1,1,2,29772),-- Iron Ore
(20389,734,1,1,-1,32995),-- Haste Potion
(20389,1872,1,1,-1,263962),-- Animal Bone
(20389,2011,1,1,-1,4516),-- Short Spear Edge
(20389,57,98,153,0,700000),-- Adena
(20389,44,1,1,1,748),-- Leather Helmet
(20389,102,1,1,1,1069),-- Round Shield
(20389,945,1,1,1,2215),-- Skeleton Buckler
(20389,1924,1,1,1,9433),-- Leather Helmet Design
(20389,1867,1,1,2,38986),-- Animal Skin
(20389,1872,1,1,2,38986),-- Animal Bone
(20389,2175,1,1,2,23772),-- Recipe: Boots
(20389,5158,1,1,2,1170),-- Recipe: Spiritshot (D) Compressed Package (100%)
(20390,1873,1,1,-1,84419),-- Silver Nugget
(20390,1881,1,1,-1,28140),-- Coarse Bone Powder
(20390,1897,1,1,-1,50249),-- Necklace of Wisdom Chain
(20390,57,101,167,0,700000),-- Adena
(20390,2,1,1,1,59),-- Long Sword
(20390,120,1,1,1,59),-- Sword of Reflection
(20390,121,1,1,1,59),-- Sword of Watershadow
(20390,2012,1,1,1,650),-- Sword of Reflection Blade
(20390,734,1,1,2,4157),-- Haste Potion
(20390,1801,1,1,2,12563),-- Recipe: Piece Bone Gaiters
(20390,1868,1,1,2,49872),-- Thread
(20390,1873,1,1,2,9975),-- Silver Nugget
(20390,5158,1,1,2,998),-- Recipe: Spiritshot (D) Compressed Package (100%)
(20392,1798,1,1,-1,227072),-- Recipe: Leather Helmet
(20392,1831,1,1,-1,617635),-- Antidote
(20392,1833,1,1,-1,617635),-- Bandage
(20392,57,116,177,0,700000),-- Adena
(20392,23,1,1,1,1490),-- Wooden Breastplate
(20392,30,1,1,1,2388),-- Hard Leather Pants
(20392,2386,1,1,1,2388),-- Wooden Gaiters
(20392,736,1,1,2,17104),-- Scroll of Escape
(20392,1060,1,1,2,76017),-- Lesser Healing Potion
(20392,1864,1,1,2,68416),-- Stem
(20392,1869,1,1,2,34208),-- Iron Ore
(20393,1897,1,1,-1,56563),-- Necklace of Wisdom Chain
(20393,2252,1,1,-1,9736),-- Recipe: Iron Hammer
(20393,57,118,183,0,700000),-- Adena
(20393,217,1,1,1,134),-- Shining Knife
(20393,218,1,1,1,134),-- Throwing Knife
(20393,1867,1,1,2,62377),-- Animal Skin
(20393,1872,1,1,2,62377),-- Animal Bone
(20393,2252,1,1,2,1918),-- Recipe: Iron Hammer
(20400,1803,1,1,-1,175710),-- Recipe: Necklace of Wisdom
(20400,1921,1,1,-1,134900),-- Leather Shoes Texture
(20400,1923,1,1,-1,85695),-- Leather Stocking Pattern
(20400,57,112,154,0,700000),-- Adena
(20400,114,1,1,1,1830),-- Earring of Strength
(20400,115,1,1,1,1830),-- Earring of Wisdom
(20400,876,1,1,1,2745),-- Ring of Anguish
(20400,907,1,1,1,1373),-- Necklace of Anguish
(20400,1896,1,1,1,10469),-- Necklace of Anguish Chain
(20400,1798,1,1,2,40369),-- Recipe: Leather Helmet
(20400,1864,1,1,2,82352),-- Stem
(20400,1869,1,1,2,41176),-- Iron Ore
(20401,1866,1,1,-1,252096),-- Suede
(20401,1873,1,1,-1,151258),-- Silver Nugget
(20401,2151,1,1,-1,105333),-- Recipe: Necklace of Devotion
(20401,57,173,305,0,700000),-- Adena
(20401,87,1,1,1,59),-- Iron Hammer
(20401,155,1,1,1,59),-- Buzdygan
(20401,177,1,1,1,59),-- Mage Staff
(20401,2014,1,1,1,642),-- Iron Hammer Head
(20401,1866,1,1,2,37233),-- Suede
(20401,1871,1,1,2,55849),-- Charcoal
(20401,5153,1,1,2,2234),-- Recipe: Soulshot (D) Compressed Package (100%)
(20401,5158,1,1,2,2234),-- Recipe: Spiritshot (D) Compressed Package (100%)
(20402,1871,1,1,-1,407376),-- Charcoal
(20402,1880,1,1,-1,40738),-- Steel
(20402,2179,1,1,-1,194917),-- Recipe: Crafted Leather Gloves
(20402,57,181,334,0,700000),-- Adena
(20402,25,1,1,1,328),-- Piece Bone Breastplate
(20402,26,1,1,1,212),-- Bronze Breastplate
(20402,32,1,1,1,524),-- Piece Bone Gaiters
(20402,34,1,1,1,340),-- Bronze Gaiters
(20402,1926,1,1,1,4052),-- Piece Bone Breastplate Fragment
(20402,1928,1,1,1,5843),-- Piece Bone Gaiters Fragment
(20402,1866,1,1,2,40111),-- Suede
(20402,1871,1,1,2,60166),-- Charcoal
(20402,2256,1,1,2,1471),-- Recipe: Assassin Knife
(20402,5158,1,1,2,2407),-- Recipe: Spiritshot (D) Compressed Package (100%)
(20403,734,1,1,-1,39594),-- Haste Potion
(20403,1868,1,1,-1,475131),-- Thread
(20403,2012,1,1,-1,4949),-- Sword of Reflection Blade
(20403,57,118,183,0,700000),-- Adena
(20403,38,1,1,1,1796),-- Low Boots
(20403,50,1,1,1,1796),-- Leather Gloves
(20403,1925,1,1,1,30677),-- Leather Gloves Lining
(20403,735,1,1,2,2340),-- Potion of Alacrity
(20403,1867,1,1,2,37426),-- Animal Skin
(20403,1872,1,1,2,37426),-- Animal Bone
(20403,2253,1,1,2,1151),-- Recipe: Sword Breaker
(20403,5268,1,1,2,1123),-- Recipe: Greater Soulshot (D) Compressed Package (100%)
(20404,735,1,1,-1,16828),-- Potion of Alacrity
(20404,1897,1,1,-1,48079),-- Necklace of Wisdom Chain
(20404,2253,1,1,-1,8276),-- Recipe: Sword Breaker
(20404,57,100,156,0,700000),-- Adena
(20404,1101,1,1,1,765),-- Tunic of Devotion
(20404,1104,1,1,1,1221),-- Stockings of Devotion
(20404,1866,1,1,2,19883),-- Suede
(20404,1871,1,1,2,29824),-- Charcoal
(20404,2254,1,1,2,1223),-- Recipe: Composition Bow
(20404,6035,1,1,2,2486),-- Magic Haste Potion
(20410,1792,1,1,-1,17371),-- Recipe: Short Spear
(20410,1868,1,1,-1,472491),-- Thread
(20410,2009,1,1,-1,8377),-- Dirk Blade
(20410,57,119,180,0,700000),-- Adena
(20410,9,1,1,1,224),-- Cedar Staff
(20410,154,1,1,1,224),-- Dwarven Mace
(20410,2008,1,1,1,1811),-- Cedar Staff Head
(20410,1793,1,1,2,3421),-- Recipe: Sword of Reflection
(20410,1867,1,1,2,62030),-- Animal Skin
(20410,1872,1,1,2,62030),-- Animal Bone
(20411,735,1,1,-1,21105),-- Potion of Alacrity
(20411,1897,1,1,-1,60299),-- Necklace of Wisdom Chain
(20411,2141,1,1,-1,50651),-- Recipe: Silver Mold
(20411,57,121,200,0,700000),-- Adena
(20411,217,1,1,1,143),-- Shining Knife
(20411,218,1,1,1,143),-- Throwing Knife
(20411,1817,1,1,2,5985),-- Recipe: Cord
(20411,1864,1,1,2,59847),-- Stem
(20411,1869,1,1,2,29924),-- Iron Ore
(20411,1878,1,1,2,11970),-- Braided Hemp
(20411,6037,1,1,2,59847),-- Waking Scroll
(20415,735,1,1,-1,18798),-- Potion of Alacrity
(20415,1865,1,1,-1,225572),-- Varnish
(20415,2144,1,1,-1,45114),-- Recipe: Compound Braid
(20415,57,110,177,0,700000),-- Adena
(20415,309,1,1,1,127),-- Tears of Eva
(20415,310,1,1,1,127),-- Relic of The Saints
(20415,1864,1,1,2,44421),-- Stem
(20415,1865,1,1,2,22211),-- Varnish
(20415,1866,1,1,2,14807),-- Suede
(20415,1868,1,1,2,44421),-- Thread
(20415,1873,1,1,2,8885),-- Silver Nugget
(20415,2253,1,1,2,911),-- Recipe: Sword Breaker
(20416,102,1,1,-1,8488),-- Round Shield
(20416,1924,1,1,-1,74887),-- Leather Helmet Design
(20416,2254,1,1,-1,9514),-- Recipe: Composition Bow
(20416,57,111,183,0,700000),-- Adena
(20416,1101,1,1,1,879),-- Tunic of Devotion
(20416,1104,1,1,1,1404),-- Stockings of Devotion
(20416,1866,1,1,2,22859),-- Suede
(20416,1871,1,1,2,34288),-- Charcoal
(20416,2139,1,1,2,6858),-- Recipe: Steel Mold
(20416,5268,1,1,2,1372),-- Recipe: Greater Soulshot (D) Compressed Package (100%)
(20418,1800,1,1,-1,78852),-- Recipe: Piece Bone Breastplate
(20418,1872,1,1,-1,334331),-- Animal Bone
(20418,1925,1,1,-1,164425),-- Leather Gloves Lining
(20418,57,120,198,0,700000),-- Adena
(20418,845,1,1,1,1083),-- Cat\'s Eye Earring
(20418,877,1,1,1,1624),-- Ring of Wisdom
(20418,908,1,1,1,812),-- Necklace of Wisdom
(20418,1897,1,1,1,8818),-- Necklace of Wisdom Chain
(20418,1867,1,1,2,49379),-- Animal Skin
(20418,1872,1,1,2,49379),-- Animal Bone
(20418,1882,1,1,2,8230),-- Leather
(20418,2140,1,1,2,7407),-- Recipe: High Grade Suede
(20420,1804,1,1,-1,11619),-- Recipe: Soulshot: D-Grade
(20420,1866,1,1,-1,193642),-- Suede
(20420,1868,1,1,-1,580926),-- Thread
(20420,57,132,236,0,700000),-- Adena
(20420,1102,1,1,1,604),-- Tunic of Magic
(20420,1105,1,1,1,970),-- Stockings of Magic
(20420,1864,1,1,2,57199),-- Stem
(20420,1865,1,1,2,28599),-- Varnish
(20420,1866,1,1,2,19066),-- Suede
(20420,1868,1,1,2,57199),-- Thread
(20420,1873,1,1,2,11440),-- Silver Nugget
(20420,5163,1,1,2,1144),-- Recipe: Blessed Spiritshot (D) Compressed Package (100%)
(20421,1866,1,1,-1,205204),-- Suede
(20421,1898,1,1,-1,31619),-- Blue Diamond Necklace Gem
(20421,1929,1,1,-1,39717),-- Hard Leather Gaiters Material
(20421,57,140,251,0,700000),-- Adena
(20421,273,1,1,1,97),-- Composition Bow
(20421,2016,1,1,1,1065),-- Composition Bow Shaft
(20421,1867,1,1,2,40409),-- Animal Skin
(20421,1869,1,1,2,30307),-- Iron Ore
(20421,1870,1,1,2,30307),-- Coal
(20421,1871,1,1,2,30307),-- Charcoal
(20421,1872,1,1,2,40409),-- Animal Bone
(20421,5278,1,1,2,1212),-- Recipe: Greater Blessed Spiritshot (D) Compressed Package(100%)
(20422,1864,1,1,-1,497816),-- Stem
(20422,1869,1,1,-1,248908),-- Iron Ore
(20422,2013,1,1,-1,5372),-- Forest Bow Shaft
(20422,57,121,195,0,700000),-- Adena
(20422,176,1,1,1,140),-- Journeyman\'s Staff
(20422,2501,1,1,1,140),-- Bone Club
(20422,1864,1,1,2,73524),-- Stem
(20422,1869,1,1,2,36762),-- Iron Ore
(20422,2254,1,1,2,1507),-- Recipe: Composition Bow
(20422,5273,1,1,2,1471),-- Recipe: Greater Spiritshot (D) Compressed Package(100%)
(20423,1792,1,1,-1,14067),-- Recipe: Short Spear
(20423,1793,1,1,-1,14067),-- Recipe: Sword of Reflection
(20423,1921,1,1,-1,123424),-- Leather Shoes Texture
(20423,57,98,145,0,700000),-- Adena
(20423,271,1,1,1,543),-- Hunting Bow
(20423,1867,1,1,2,75346),-- Animal Skin
(20423,1872,1,1,2,75346),-- Animal Bone
(20424,1870,1,1,-1,227995),-- Coal
(20424,1880,1,1,-1,22799),-- Steel
(20424,2142,1,1,-1,45599),-- Recipe: Varnish of Purity
(20424,57,107,182,0,700000),-- Adena
(20424,2,1,1,1,64),-- Long Sword
(20424,120,1,1,1,64),-- Sword of Reflection
(20424,121,1,1,1,64),-- Sword of Watershadow
(20424,2012,1,1,1,702),-- Sword of Reflection Blade
(20424,1865,1,1,2,44898),-- Varnish
(20424,1870,1,1,2,44898),-- Coal
(20424,2253,1,1,2,1841),-- Recipe: Sword Breaker
(20425,1831,1,1,-1,473949),-- Antidote
(20425,1869,1,1,-1,177731),-- Iron Ore
(20425,57,95,131,0,700000),-- Adena
(20425,66,1,1,1,168),-- Gladius
(20425,1333,1,1,1,168),-- Brandish
(20425,2010,1,1,1,1363),-- Brandish Blade
(20425,1799,1,1,2,51851),-- Recipe: Leather Gloves
(20425,1866,1,1,2,23333),-- Suede
(20425,1871,1,1,2,35000),-- Charcoal
(20426,1796,1,1,-1,224389),-- Recipe: Leather Tunic
(20426,2005,1,1,-1,12742),-- Broadsword Blade
(20426,57,96,130,0,700000),-- Adena
(20426,113,1,1,1,11332),-- Mystic\'s Earring
(20426,875,1,1,1,16728),-- Ring of Knowledge
(20426,906,1,1,1,8465),-- Necklace of Knowledge
(20426,1060,1,1,2,58549),-- Lesser Healing Potion
(20426,1868,1,1,2,52694),-- Thread
(20426,1873,1,1,2,10539),-- Silver Nugget
(20426,2137,1,1,2,7750),-- Recipe: Steel
(20427,1060,1,1,-1,330350),-- Lesser Healing Potion
(20427,1666,1,1,-1,49552),-- Recipe: Wooden Arrow
(20427,1866,1,1,-1,99105),-- Suede
(20427,57,80,108,0,700000),-- Adena
(20427,254,1,1,1,1830),-- Iron Gloves
(20427,1864,1,1,2,58549),-- Stem
(20427,1869,1,1,2,29274),-- Iron Ore
(20427,2138,1,1,2,8611),-- Recipe: Coarse Bone Powder (100%)
(20428,1831,1,1,-1,594351),-- Antidote
(20428,1864,1,1,-1,445764),-- Stem
(20428,1896,1,1,-1,94441),-- Necklace of Anguish Chain
(20428,57,114,168,0,700000),-- Adena
(20428,114,1,1,1,1951),-- Earring of Strength
(20428,115,1,1,1,1951),-- Earring of Wisdom
(20428,876,1,1,1,2926),-- Ring of Anguish
(20428,907,1,1,1,1463),-- Necklace of Anguish
(20428,1896,1,1,1,11159),-- Necklace of Anguish Chain
(20428,1799,1,1,2,27868),-- Recipe: Leather Gloves
(20428,1833,1,1,2,50161),-- Bandage
(20428,1864,1,1,2,37621),-- Stem
(20428,1865,1,1,2,18811),-- Varnish
(20428,1866,1,1,2,12541),-- Suede
(20428,1868,1,1,2,37621),-- Thread
(20428,1873,1,1,2,7525),-- Silver Nugget
(20429,1792,1,1,-1,13657),-- Recipe: Short Spear
(20429,1921,1,1,-1,119829),-- Leather Shoes Texture
(20429,2009,1,1,-1,6586),-- Dirk Blade
(20429,57,95,140,0,700000),-- Adena
(20429,429,1,1,1,896),-- Leather Tunic
(20429,464,1,1,1,1436),-- Leather Stockings
(20429,1922,1,1,1,6999),-- Leather Tunic Pattern
(20429,1923,1,1,1,11243),-- Leather Stocking Pattern
(20429,1803,1,1,2,30736),-- Recipe: Necklace of Wisdom
(20429,1868,1,1,2,73152),-- Thread
(20429,1873,1,1,2,14631),-- Silver Nugget
(20432,1871,1,1,-1,15920),-- Charcoal
(20432,1873,1,1,-1,6368),-- Silver Nugget
(20432,57,8,12,0,700000),-- Adena
(20432,11,1,1,1,5579),-- Bone Dagger
(20432,17,10,30,2,11757),-- Wooden Arrow
(20432,1787,1,1,2,1881),-- Recipe: Willow Staff
(20432,1864,1,1,2,4703),-- Stem
(20432,1865,1,1,2,2352),-- Varnish
(20432,1866,1,1,2,1568),-- Suede
(20432,1868,1,1,2,4703),-- Thread
(20432,1873,1,1,2,941),-- Silver Nugget
(20433,1864,1,1,-1,430270),-- Stem
(20433,1865,1,1,-1,215135),-- Varnish
(20433,1921,1,1,-1,138797),-- Leather Shoes Texture
(20433,57,113,160,0,700000),-- Adena
(20433,429,1,1,1,1038),-- Leather Tunic
(20433,464,1,1,1,1664),-- Leather Stockings
(20433,1922,1,1,1,8106),-- Leather Tunic Pattern
(20433,1923,1,1,1,13023),-- Leather Stocking Pattern
(20433,735,1,1,2,2648),-- Potion of Alacrity
(20433,1794,1,1,2,2337),-- Recipe: Forest Bow
(20433,1865,1,1,2,31774),-- Varnish
(20433,1870,1,1,2,31774),-- Coal
(20435,1793,1,1,-1,14332),-- Recipe: Sword of Reflection
(20435,1833,1,1,-1,519792),-- Bandage
(20435,1871,1,1,-1,194922),-- Charcoal
(20435,57,98,149,0,700000),-- Adena
(20435,216,1,1,1,277),-- Dirk
(20435,2009,1,1,1,2043),-- Dirk Blade
(20435,1794,1,1,2,2823),-- Recipe: Forest Bow
(20435,1867,1,1,2,51180),-- Animal Skin
(20435,1872,1,1,2,51180),-- Animal Bone
(20436,1869,1,1,-1,378144),-- Iron Ore
(20436,1898,1,1,-1,38844),-- Blue Diamond Necklace Gem
(20436,2016,1,1,-1,4431),-- Composition Bow Shaft
(20436,57,173,305,0,700000),-- Adena
(20436,16,1,1,1,238),-- Long Spear
(20436,1865,1,1,2,74465),-- Varnish
(20436,1870,1,1,2,74465),-- Coal
(20436,5158,1,1,2,2979),-- Recipe: Spiritshot (D) Compressed Package (100%)
(20437,1804,1,1,-1,13669),-- Recipe: Soulshot: D-Grade
(20437,2016,1,1,-1,4004),-- Composition Bow Shaft
(20437,2258,1,1,-1,8355),-- Recipe: Temptation of Abyss
(20437,57,156,278,0,700000),-- Adena
(20437,39,1,1,1,1417),-- Boots
(20437,51,1,1,1,1417),-- Bracer
(20437,1930,1,1,1,17255),-- Boot Lining
(20437,1866,1,1,2,33647),-- Suede
(20437,1871,1,1,2,50470),-- Charcoal
(20437,5268,1,1,2,2019),-- Recipe: Greater Soulshot (D) Compressed Package (100%)
(20437,5437,1,1,2,1234),-- Recipe: Heavy Sword(100%)
(20438,1865,1,1,-1,450915),-- Varnish
(20438,1869,1,1,-1,450915),-- Iron Ore
(20438,1899,1,1,-1,70456),-- Necklace of Devotion Chain
(20438,57,196,374,0,700000),-- Adena
(20438,291,1,1,1,80),-- Trident
(20438,2019,1,1,1,2722),-- Trident Edge
(20438,1875,1,1,2,3374),-- Stone of Purity
(20438,1879,1,1,2,8436),-- Cokes
(20438,2180,1,1,2,3806),-- Recipe: Scale Mail
(20438,5549,1,1,2,5061),-- Metallic Thread
(20438,6666,1,1,2,50613),-- Deluxe Chest Key - Grade 2
(20439,2015,1,1,-1,4871),-- Sword Breaker Edge
(20439,2151,1,1,-1,111250),-- Recipe: Necklace of Devotion
(20439,2255,1,1,-1,9765),-- Recipe: Saber
(20439,57,177,327,0,700000),-- Adena
(20439,25,1,1,1,321),-- Piece Bone Breastplate
(20439,26,1,1,1,208),-- Bronze Breastplate
(20439,32,1,1,1,514),-- Piece Bone Gaiters
(20439,34,1,1,1,333),-- Bronze Gaiters
(20439,1926,1,1,1,3972),-- Piece Bone Breastplate Fragment
(20439,1928,1,1,1,5728),-- Piece Bone Gaiters Fragment
(20439,1868,1,1,2,157297),-- Thread
(20439,1873,1,1,2,31460),-- Silver Nugget
(20439,2257,1,1,2,1923),-- Recipe: Trident
(20442,1786,1,1,-1,44845),-- Recipe: Broad Sword
(20442,1864,1,1,-1,112112),-- Stem
(20442,5549,1,1,-1,5606),-- Metallic Thread
(20442,57,30,42,0,700000),-- Adena
(20442,4,1,1,1,9823),-- Club
(20442,7,1,1,1,9823),-- Apprentice\'s Rod
(20442,17,10,30,2,72442),-- Wooden Arrow
(20442,1787,1,1,2,11591),-- Recipe: Willow Staff
(20442,1868,1,1,2,28977),-- Thread
(20442,1873,1,1,2,5796),-- Silver Nugget
(20446,1869,1,1,-1,77741),-- Iron Ore
(20446,1870,1,1,-1,77741),-- Coal
(20446,2007,1,1,-1,5553),-- Bow Shaft
(20446,57,41,58,0,700000),-- Adena
(20446,22,1,1,1,2456),-- Leather Shirt
(20446,29,1,1,1,3925),-- Leather Pants
(20446,1791,1,1,2,2830),-- Recipe: Brandish
(20446,1864,1,1,2,30618),-- Stem
(20446,1869,1,1,2,15309); -- Iron Ore

INSERT INTO `droplist` VALUES 
(20447,1060,1,1,-1,285245),-- Lesser Healing Potion
(20447,1797,1,1,-1,259314),-- Recipe: Leather Stockings
(20447,2138,1,1,-1,37753),-- Recipe: Coarse Bone Powder (100%)
(20447,57,69,94,0,700000),-- Adena
(20447,14,1,1,1,790),-- Bow
(20447,2007,1,1,1,2709),-- Bow Shaft
(20447,1791,1,1,2,4673),-- Recipe: Brandish
(20447,1868,1,1,2,50555),-- Thread
(20447,1873,1,1,2,10111),-- Silver Nugget
(20448,1666,1,1,-1,32439),-- Recipe: Wooden Arrow
(20448,1789,1,1,-1,17988),-- Recipe: Cedar Staff
(20448,2006,1,1,-1,6951),-- Willow Staff Head
(20448,57,51,72,0,700000),-- Adena
(20448,3,1,1,1,599),-- Broadsword
(20448,2005,1,1,1,2054),-- Broadsword Blade
(20448,1866,1,1,2,19164),-- Suede
(20448,1871,1,1,2,28746),-- Charcoal
(20449,115,1,1,-1,17114),-- Earring of Wisdom
(20449,1873,1,1,-1,92414),-- Silver Nugget
(20449,1896,1,1,-1,97896),-- Necklace of Anguish Chain
(20449,57,116,177,0,700000),-- Adena
(20449,429,1,1,1,1115),-- Leather Tunic
(20449,464,1,1,1,1786),-- Leather Stockings
(20449,1922,1,1,1,8705),-- Leather Tunic Pattern
(20449,1923,1,1,1,13985),-- Leather Stocking Pattern
(20449,1798,1,1,2,44605),-- Recipe: Leather Helmet
(20449,1868,1,1,2,90993),-- Thread
(20449,1873,1,1,2,18199),-- Silver Nugget
(20450,1666,1,1,-1,41345),-- Recipe: Wooden Arrow
(20450,1870,1,1,-1,124035),-- Coal
(20450,57,67,90,0,700000),-- Adena
(20450,5,1,1,1,382),-- Mace
(20450,8,1,1,1,382),-- Willow Staff
(20450,152,1,1,1,591),-- Heavy Chisel
(20450,2006,1,1,1,1309),-- Willow Staff Head
(20450,1864,1,1,2,48851),-- Stem
(20450,1869,1,1,2,24426),-- Iron Ore
(20450,2135,1,1,2,7184),-- Recipe: Braided Hemp
(20455,1794,1,1,-1,13930),-- Recipe: Forest Bow
(20455,1869,1,1,-1,189449),-- Iron Ore
(20455,1896,1,1,-1,80275),-- Necklace of Anguish Chain
(20455,57,97,143,0,700000),-- Adena
(20455,20,1,1,1,5230),-- Buckler
(20455,43,1,1,1,3657),-- Wooden Helmet
(20455,736,1,1,2,18654),-- Scroll of Escape
(20455,1868,1,1,2,74614),-- Thread
(20455,1873,1,1,2,14923),-- Silver Nugget
(20456,1788,1,1,-1,30885),-- Recipe: Bow 
(20456,1868,1,1,-1,77212),-- Thread
(20456,1872,1,1,-1,51475),-- Animal Bone
(20456,57,19,29,0,700000),-- Adena
(20456,308,1,1,1,13530),-- Buffalo\'s Horn
(20456,17,10,30,2,49891),-- Wooden Arrow
(20456,1788,1,1,2,7983),-- Recipe: Bow 
(20456,1868,1,1,2,19957),-- Thread
(20456,1873,1,1,2,3992),-- Silver Nugget
(20457,1864,1,1,-1,587232),-- Stem
(20457,1866,1,1,-1,195744),-- Suede
(20457,2013,1,1,-1,6337),-- Forest Bow Shaft
(20457,57,138,234,0,700000),-- Adena
(20457,15,1,1,1,165),-- Short Spear
(20457,2011,1,1,1,1979),-- Short Spear Edge
(20457,1864,1,1,2,69384),-- Stem
(20457,1869,1,1,2,34692),-- Iron Ore
(20457,1880,1,1,2,3470),-- Steel
(20457,2254,1,1,2,1422),-- Recipe: Composition Bow
(20457,5273,1,1,2,1388),-- Recipe: Greater Spiritshot (D) Compressed Package(100%)
(20458,1898,1,1,-1,42655),-- Blue Diamond Necklace Gem
(20458,2176,1,1,-1,198681),-- Recipe: Leather Boots
(20458,2256,1,1,-1,10153),-- Recipe: Assassin Knife
(20458,57,188,329,0,700000),-- Adena
(20458,846,1,1,1,997),-- Coral Earring
(20458,878,1,1,1,1496),-- Blue Coral Ring
(20458,909,1,1,1,748),-- Blue Diamond Necklace
(20458,1898,1,1,1,6300),-- Blue Diamond Necklace Gem
(20458,1804,1,1,2,1402),-- Recipe: Soulshot: D-Grade
(20458,1864,1,1,2,70089),-- Stem
(20458,1869,1,1,2,35045),-- Iron Ore
(20458,1880,1,1,2,3504),-- Steel
(20458,5268,1,1,2,1402),-- Recipe: Greater Soulshot (D) Compressed Package (100%)
(20458,5437,1,1,2,857),-- Recipe: Heavy Sword(100%)
(20458,6666,1,1,2,35045),-- Deluxe Chest Key - Grade 2
(20460,1792,1,1,-1,17371),-- Recipe: Short Spear
(20460,1833,1,1,-1,629988),-- Bandage
(20460,1866,1,1,-1,157497),-- Suede
(20460,57,119,180,0,700000),-- Adena
(20460,66,1,1,1,224),-- Gladius
(20460,1333,1,1,1,224),-- Brandish
(20460,2010,1,1,1,1811),-- Brandish Blade
(20460,1799,1,1,2,68922),-- Recipe: Leather Gloves
(20460,1867,1,1,2,62030),-- Animal Skin
(20460,1872,1,1,2,62030),-- Animal Bone
(20461,1803,1,1,-1,165438),-- Recipe: Necklace of Wisdom
(20461,1896,1,1,-1,83420),-- Necklace of Anguish Chain
(20461,2010,1,1,-1,7660),-- Brandish Blade
(20461,57,99,150,0,700000),-- Adena
(20461,66,1,1,1,186),-- Gladius
(20461,1333,1,1,1,186),-- Brandish
(20461,2010,1,1,1,1509),-- Brandish Blade
(20461,1803,1,1,2,32579),-- Recipe: Necklace of Wisdom
(20461,1867,1,1,2,51692),-- Animal Skin
(20461,1872,1,1,2,51692),-- Animal Bone
(20462,1800,1,1,-1,65776),-- Recipe: Piece Bone Breastplate
(20462,1865,1,1,-1,209166),-- Varnish
(20462,1872,1,2,-1,278888),-- Animal Bone
(20462,57,102,164,0,700000),-- Adena
(20462,256,1,1,1,235),-- Cestus
(20462,1800,1,1,2,12953),-- Recipe: Piece Bone Breastplate
(20462,1867,1,1,2,54920),-- Animal Skin
(20462,1872,1,1,2,54920),-- Animal Bone
(20463,1799,1,1,-1,273567),-- Recipe: Leather Gloves
(20463,1921,1,1,-1,119134),-- Leather Shoes Texture
(20463,2010,1,1,-1,7185),-- Brandish Blade
(20463,57,97,137,0,700000),-- Adena
(20463,271,1,1,1,524),-- Hunting Bow
(20463,1798,1,1,2,35651),-- Recipe: Leather Helmet
(20463,1864,1,1,2,72727),-- Stem
(20463,1869,1,1,2,36364),-- Iron Ore
(20464,464,1,1,-1,9305),-- Leather Stockings
(20464,1870,1,1,-1,177731),-- Coal
(20464,1874,1,1,-1,11849),-- Oriharukon Ore
(20464,57,95,131,0,700000),-- Adena
(20464,9,1,1,1,168),-- Cedar Staff
(20464,154,1,1,1,168),-- Dwarven Mace
(20464,2008,1,1,1,1363),-- Cedar Staff Head
(20464,1803,1,1,2,29412),-- Recipe: Necklace of Wisdom
(20464,1865,1,1,2,35000),-- Varnish
(20464,1870,1,1,2,35000),-- Coal
(20466,734,1,1,-1,41833),-- Haste Potion
(20466,1868,1,1,-1,501999),-- Thread
(20466,1897,1,1,-1,59762),-- Necklace of Wisdom Chain
(20466,57,122,197,0,700000),-- Adena
(20466,24,1,1,1,475),-- Bone Breastplate
(20466,31,1,1,1,759),-- Bone Gaiters
(20466,390,1,1,1,475),-- Cotton Shirt
(20466,412,1,1,1,759),-- Cotton Pants
(20466,1801,1,1,2,18676),-- Recipe: Piece Bone Gaiters
(20466,1867,1,1,2,49428),-- Animal Skin
(20466,1872,1,1,2,49428),-- Animal Bone
(20466,5158,1,1,2,1483),-- Recipe: Spiritshot (D) Compressed Package (100%)
(20468,1790,1,1,-1,14370),-- Recipe: Dirk
(20468,1814,1,1,-1,40916),-- Recipe: Leather
(20468,2005,1,1,-1,5553),-- Broadsword Blade
(20468,57,41,58,0,700000),-- Adena
(20468,99,1,1,1,957),-- Apprentice\'s Spellbook
(20468,1795,1,1,2,57770),-- Recipe:Leather Shoes
(20468,1864,1,1,2,30618),-- Stem
(20468,1869,1,1,2,15309),-- Iron Ore
(20469,1666,1,1,-1,42787),-- Recipe: Wooden Arrow
(20469,1864,1,1,-1,256721),-- Stem
(20469,2007,1,1,-1,9169),-- Bow Shaft
(20469,57,69,94,0,700000),-- Adena
(20469,14,1,1,1,790),-- Bow
(20469,2007,1,1,1,2709),-- Bow Shaft
(20469,1795,1,1,2,71539),-- Recipe:Leather Shoes
(20469,1833,1,1,2,50554),-- Bandage
(20469,1868,1,1,2,37916),-- Thread
(20469,1873,1,1,2,7584),-- Silver Nugget
(20470,1060,1,1,-1,216259),-- Lesser Healing Potion
(20470,1791,1,1,-1,17988),-- Recipe: Brandish
(20470,2006,1,1,-1,6951),-- Willow Staff Head
(20470,57,51,72,0,700000),-- Adena
(20470,19,1,1,1,11733),-- Small Shield
(20470,42,1,1,1,8213),-- Leather Cap
(20470,735,1,1,2,1198),-- Potion of Alacrity
(20470,1864,1,1,2,28746),-- Stem
(20470,1869,1,1,2,14373),-- Iron Ore
(20470,2135,1,1,2,4228),-- Recipe: Braided Hemp
(20471,428,1,1,-1,19461),-- Feriotic Tunic
(20471,1797,1,1,-1,367589),-- Recipe: Leather Stockings
(20471,1869,1,1,-1,181957),-- Iron Ore
(20471,57,98,132,0,700000),-- Adena
(20471,3,1,1,1,1120),-- Broadsword
(20471,2005,1,1,1,3840),-- Broadsword Blade
(20471,1666,1,1,2,11944),-- Recipe: Wooden Arrow
(20471,1864,1,1,2,71663),-- Stem
(20471,1869,1,1,2,35832),-- Iron Ore
(20472,1864,1,1,-1,426554),-- Stem
(20472,1867,1,1,-1,284370),-- Animal Skin
(20472,1922,1,1,-1,54407),-- Leather Tunic Pattern
(20472,57,114,157,0,700000),-- Adena
(20472,66,1,1,1,202),-- Gladius
(20472,1333,1,1,1,202),-- Brandish
(20472,2010,1,1,1,1635),-- Brandish Blade
(20472,736,1,1,2,21000),-- Scroll of Escape
(20472,1864,1,1,2,83999),-- Stem
(20472,1869,1,1,2,42000),-- Iron Ore
(20473,23,1,1,-1,6588),-- Wooden Breastplate
(20473,1831,1,1,-1,537542),-- Antidote
(20473,1896,1,1,-1,85415),-- Necklace of Anguish Chain
(20473,57,109,147,0,700000),-- Adena
(20473,9,1,1,1,191),-- Cedar Staff
(20473,154,1,1,1,191),-- Dwarven Mace
(20473,2008,1,1,1,1545),-- Cedar Staff Head
(20473,1792,1,1,2,2919),-- Recipe: Short Spear
(20473,1864,1,1,2,79391),-- Stem
(20473,1869,1,1,2,39696),-- Iron Ore
(20474,1792,1,1,-1,17030),-- Recipe: Short Spear
(20474,1799,1,1,-1,343131),-- Recipe: Leather Gloves
(20474,1866,1,1,-1,154409),-- Suede
(20474,57,116,177,0,700000),-- Adena
(20474,216,1,1,1,329),-- Dirk
(20474,2009,1,1,1,2427),-- Dirk Blade
(20474,736,1,1,2,11403),-- Scroll of Escape
(20474,1867,1,1,2,30407),-- Animal Skin
(20474,1869,1,1,2,22806),-- Iron Ore
(20474,1870,1,1,2,22806),-- Coal
(20474,1871,1,1,2,22806),-- Charcoal
(20474,1872,1,1,2,30407),-- Animal Bone
(20475,426,1,1,-1,68329),-- Tunic
(20475,1786,1,1,-1,30885),-- Recipe: Broad Sword
(20475,1873,1,1,-1,15442),-- Silver Nugget
(20475,57,19,29,0,700000),-- Adena
(20475,253,1,1,1,13530),-- Spiked Gloves
(20475,1786,1,1,2,10644),-- Recipe: Broad Sword
(20475,1868,1,1,2,26609),-- Thread
(20475,1873,1,1,2,5322),-- Silver Nugget
(20476,945,1,1,-1,17997),-- Skeleton Buckler
(20476,1866,1,1,-1,158377),-- Suede
(20476,5549,1,1,-1,23757),-- Metallic Thread
(20476,57,118,183,0,700000),-- Adena
(20476,2,1,1,1,67),-- Long Sword
(20476,120,1,1,1,67),-- Sword of Reflection
(20476,121,1,1,1,67),-- Sword of Watershadow
(20476,2012,1,1,1,732),-- Sword of Reflection Blade
(20476,1800,1,1,2,11034),-- Recipe: Piece Bone Breastplate
(20476,1868,1,1,2,70174),-- Thread
(20476,1873,1,1,2,14035),-- Silver Nugget
(20476,5273,1,1,2,1404),-- Recipe: Greater Spiritshot (D) Compressed Package(100%)
(20477,906,1,1,-1,18547),-- Necklace of Knowledge
(20477,1060,1,1,-1,171046),-- Lesser Healing Potion
(20477,1872,1,1,-1,102628),-- Animal Bone
(20477,57,41,58,0,700000),-- Adena
(20477,12,1,1,1,474),-- Knife
(20477,215,1,1,1,474),-- Doom Dagger
(20477,1796,1,1,2,14300),-- Recipe: Leather Tunic
(20477,1833,1,1,2,30315),-- Bandage
(20477,1866,1,1,2,7579),-- Suede
(20477,1871,1,1,2,11369),-- Charcoal
(20478,735,1,1,-1,22557),-- Potion of Alacrity
(20478,1801,1,1,-1,136366),-- Recipe: Piece Bone Gaiters
(20478,1897,1,1,-1,64449),-- Necklace of Wisdom Chain
(20478,57,132,212,0,700000),-- Adena
(20478,217,1,1,1,153),-- Shining Knife
(20478,218,1,1,1,153),-- Throwing Knife
(20478,735,1,1,2,2221),-- Potion of Alacrity
(20478,1817,1,1,2,5331),-- Recipe: Cord
(20478,1831,1,1,2,71073),-- Antidote
(20478,1864,1,1,2,53305),-- Stem
(20478,1869,1,1,2,26653),-- Iron Ore
(20478,6037,1,1,2,53305),-- Waking Scroll
(20479,1792,1,1,-1,17199),-- Recipe: Short Spear
(20479,1793,1,1,-1,17199),-- Recipe: Sword of Reflection
(20479,1922,1,1,-1,59670),-- Leather Tunic Pattern
(20479,57,118,179,0,700000),-- Adena
(20479,9,1,1,1,221),-- Cedar Staff
(20479,154,1,1,1,221),-- Dwarven Mace
(20479,2008,1,1,1,1793),-- Cedar Staff Head
(20479,1792,1,1,2,2541),-- Recipe: Short Spear
(20479,1833,1,1,2,92124),-- Bandage
(20479,1867,1,1,2,46062),-- Animal Skin
(20479,1872,1,1,2,46062),-- Animal Bone
(20480,1864,1,1,-1,356778),-- Stem
(20480,2005,1,1,-1,12742),-- Broadsword Blade
(20480,2007,1,1,-1,12742),-- Bow Shaft
(20480,57,96,130,0,700000),-- Adena
(20480,22,1,1,1,5636),-- Leather Shirt
(20480,29,1,1,1,9007),-- Leather Pants
(20480,1789,1,1,2,6494),-- Recipe: Cedar Staff
(20480,1864,1,1,2,70258),-- Stem
(20480,1869,1,1,2,35129),-- Iron Ore
(20481,1786,1,1,-1,12736),-- Recipe: Broad Sword
(20481,1788,1,1,-1,12736),-- Recipe: Bow 
(20481,1868,1,1,-1,31839),-- Thread
(20481,57,8,12,0,700000),-- Adena
(20481,426,1,1,1,14565),-- Tunic
(20481,462,1,1,1,23181),-- Stockings
(20481,17,10,30,2,20574),-- Wooden Arrow
(20481,1786,1,1,2,3292),-- Recipe: Broad Sword
(20481,1868,1,1,2,8230),-- Thread
(20481,1873,1,1,2,1646),-- Silver Nugget
(20483,1833,1,1,-1,654568),-- Bandage
(20483,1868,1,2,-1,490926),-- Thread
(20483,57,120,192,0,700000),-- Adena
(20483,845,1,1,1,1060),-- Cat\'s Eye Earring
(20483,877,1,1,1,1590),-- Ring of Wisdom
(20483,908,1,1,1,795),-- Necklace of Wisdom
(20483,1897,1,1,1,8632),-- Necklace of Wisdom Chain
(20483,1864,1,1,2,41433),-- Stem
(20483,1865,1,1,2,20716),-- Varnish
(20483,1866,1,1,2,13811),-- Suede
(20483,1868,1,1,2,41433),-- Thread
(20483,1873,1,1,2,8287),-- Silver Nugget
(20483,2139,1,1,2,4144),-- Recipe: Steel Mold
(20483,5268,1,1,2,829),-- Recipe: Greater Soulshot (D) Compressed Package (100%)
(20487,1060,1,1,-1,439936),-- Lesser Healing Potion
(20487,1897,1,1,-1,47136),-- Necklace of Wisdom Chain
(20487,2136,1,1,-1,58227),-- Recipe: Cokes
(20487,57,98,153,0,700000),-- Adena
(20487,217,1,1,1,112),-- Shining Knife
(20487,218,1,1,1,112),-- Throwing Knife
(20487,1800,1,1,2,12260),-- Recipe: Piece Bone Breastplate
(20487,1865,1,1,2,38986),-- Varnish
(20487,1870,1,1,2,38986),-- Coal
(20488,412,1,1,-1,4198),-- Cotton Pants
(20488,734,1,1,-1,34178),-- Haste Potion
(20488,1800,1,1,-1,64486),-- Recipe: Piece Bone Breastplate
(20488,57,100,161,0,700000),-- Adena
(20488,256,1,1,1,231),-- Cestus
(20488,1864,1,1,2,80765),-- Stem
(20488,1869,1,1,2,40383),-- Iron Ore
(20488,2140,1,1,2,8077),-- Recipe: High Grade Suede
(20489,1060,1,1,-1,433160),-- Lesser Healing Potion
(20489,1872,1,1,-1,259896),-- Animal Bone
(20489,1896,1,1,-1,82594),-- Necklace of Anguish Chain
(20489,57,98,149,0,700000),-- Adena
(20489,429,1,1,1,941),-- Leather Tunic
(20489,464,1,1,1,1507),-- Leather Stockings
(20489,1922,1,1,1,7345),-- Leather Tunic Pattern
(20489,1923,1,1,1,11799),-- Leather Stocking Pattern
(20489,1793,1,1,2,2823),-- Recipe: Sword of Reflection
(20489,1868,1,1,2,76770),-- Thread
(20489,1873,1,1,2,15354),-- Silver Nugget
(20491,876,1,1,-1,16827),-- Ring of Anguish
(20491,1794,1,1,-1,14476),-- Recipe: Forest Bow
(20491,1803,1,1,-1,165438),-- Recipe: Necklace of Wisdom
(20491,57,99,150,0,700000),-- Adena
(20491,37,1,1,1,3801),-- Leather Shoes
(20491,49,1,1,1,3801),-- Gloves
(20491,1921,1,1,1,25013),-- Leather Shoes Texture
(20491,1794,1,1,2,2851),-- Recipe: Forest Bow
(20491,1866,1,1,2,25846),-- Suede
(20491,1871,1,1,2,38769),-- Charcoal
(20492,25,1,1,-1,2327),-- Piece Bone Breastplate
(20492,1865,1,1,-1,284768),-- Varnish
(20492,1879,1,1,-1,47461),-- Cokes
(20492,57,130,231,0,700000),-- Adena
(20492,27,1,1,1,296),-- Hard Leather Shirt
(20492,33,1,1,1,475),-- Hard Leather Gaiters
(20492,1927,1,1,1,3355),-- Hard Leather Shirt Pattern
(20492,1929,1,1,1,5427),-- Hard Leather Gaiters Material
(20492,1865,1,1,2,33646),-- Varnish
(20492,1870,1,1,2,33646),-- Coal
(20492,1879,1,1,2,5608),-- Cokes
(20492,5278,1,1,2,1346),-- Recipe: Greater Blessed Spiritshot (D) Compressed Package(100%)
(20492,5437,1,1,2,823),-- Recipe: Heavy Sword(100%)
(20494,1804,1,1,-1,29714),-- Recipe: Soulshot: D-Grade
(20494,1881,1,1,-1,99048),-- Coarse Bone Powder
(20494,2179,1,1,-1,355437),-- Recipe: Crafted Leather Gloves
(20494,57,330,609,0,700000),-- Adena
(20494,257,1,1,1,467),-- Viper\'s Fang
(20494,735,1,1,2,7314),-- Potion of Alacrity
(20494,1866,1,1,2,58515),-- Suede
(20494,1871,1,1,2,87772),-- Charcoal
(20494,2258,1,1,2,2146),-- Recipe: Temptation of Abyss
(20494,5268,1,1,2,3511),-- Recipe: Greater Soulshot (D) Compressed Package (100%)
(20495,1900,1,1,-1,123441),-- Enchanted Necklace Chain
(20495,1936,1,1,-1,92328),-- White Tunic Pattern
(20495,2267,1,1,-1,11668),-- Recipe: Gastraphetes
(20495,57,476,952,0,700000),-- Adena
(20495,69,1,1,1,50),-- Bastard Sword
(20495,125,1,1,1,50),-- Spinebone Sword
(20495,126,1,1,1,50),-- Artisan\'s Sword
(20495,128,1,1,1,50),-- Knight\'s Sword
(20495,2021,1,1,1,1557),-- Spinebone Sword Blade
(20495,955,1,1,2,274),-- Scroll: Enchant Weapon (Grade D)
(20495,1875,1,1,2,4567),-- Stone of Purity
(20495,1879,1,1,2,11417),-- Cokes
(20495,1885,1,1,2,5709),-- High Grade Suede
(20495,2274,1,1,2,489),-- Recipe: Skull Breaker
(20495,2975,1,1,2,6116),-- Recipe: Brigandine Helmet
(20495,5549,1,1,2,6850),-- Metallic Thread
(20495,5550,1,1,2,913),-- Durable Metal Plate
(20495,6667,1,1,2,42815),-- Deluxe Chest Key - Grade 3
(20496,465,1,1,-1,5934),-- Cursed Stockings
(20496,1885,1,1,-1,74420),-- High Grade Suede
(20496,2152,1,1,-1,157224),-- Recipe: Enchanted Necklace
(20496,57,386,743,0,700000),-- Adena
(20496,274,1,1,1,318),-- Strengthened Bow
(20496,1876,1,1,2,14320),-- Mithril Ore
(20496,1877,1,1,2,2864),-- Adamantite Nugget
(20496,1880,1,1,2,7160),-- Steel
(20496,1881,1,1,2,9547),-- Coarse Bone Powder
(20496,1882,1,1,2,15911),-- Leather
(20496,2260,1,1,2,1112),-- Recipe: Mace of Judgment
(20496,6666,1,1,2,71600),-- Deluxe Chest Key - Grade 2
(20497,1899,1,1,-1,143825),-- Necklace of Devotion Chain
(20497,2018,1,1,-1,12232),-- Assassin Knife Edge
(20497,2259,1,1,-1,14293),-- Recipe: Spinebone Sword
(20497,57,395,773,0,700000),-- Adena
(20497,391,1,1,1,1072),-- Puma Skin Shirt
(20497,413,1,1,1,1716),-- Puma Skin Gaiters
(20497,1874,1,1,2,5740),-- Oriharukon Ore
(20497,1878,1,1,2,34440),-- Braided Hemp
(20497,1884,1,1,2,52985),-- Cord
(20497,1889,1,1,2,5740),-- Compound Braid
(20497,2261,1,1,2,1337),-- Recipe: Conjuror\'s Staff
(20497,5220,1,1,2,3444),-- Metal Hardener
(20498,1885,1,1,-1,71544),-- High Grade Suede
(20498,2262,1,1,-1,13331),-- Recipe: Elven Bow
(20498,3953,1,1,-1,34341),-- Recipe: Blessed Spiritshot D
(20498,57,371,714,0,700000),-- Adena
(20498,45,1,1,1,1333),-- Bone Helmet
(20498,626,1,1,1,1901),-- Bronze Shield
(20498,1932,1,1,1,25493),-- Bone Helmet Design
(20498,1875,1,1,2,5354),-- Stone of Purity
(20498,1879,1,1,2,13384),-- Cokes
(20498,1885,1,1,2,6692),-- High Grade Suede
(20498,2261,1,1,2,1247),-- Recipe: Conjuror\'s Staff
(20498,5549,1,1,2,8030),-- Metallic Thread
(20498,5550,1,1,2,1071),-- Durable Metal Plate
(20499,1870,1,1,-1,822258),-- Coal
(20499,1880,1,1,-1,82226),-- Steel
(20499,2017,1,1,-1,10927),-- Saber Blade
(20499,57,357,682,0,700000),-- Adena
(20499,40,1,1,1,1433),-- Leather Boots
(20499,604,1,1,1,1433),-- Crafted Leather Gloves
(20499,1931,1,1,1,15081),-- Leather Boot Lining
(20499,1934,1,1,1,15081),-- Crafted Leather Gloves Lining
(20499,1876,1,1,2,15382),-- Mithril Ore
(20499,1877,1,1,2,3076),-- Adamantite Nugget
(20499,1880,1,1,2,7691),-- Steel
(20499,1881,1,1,2,10255),-- Coarse Bone Powder
(20499,1882,1,1,2,17092),-- Leather
(20499,2182,1,1,2,9233),-- Recipe: Scale Gaiters
(20500,1867,1,3,-1,520412),-- Animal Skin
(20500,1931,1,1,-1,102042),-- Leather Boot Lining
(20500,1932,1,1,-1,123908),-- Bone Helmet Design
(20500,57,344,644,0,700000),-- Adena
(20500,847,1,1,1,1058),-- Red Crescent Earring
(20500,890,1,1,1,1587),-- Ring of Devotion
(20500,910,1,1,1,794),-- Necklace of Devotion
(20500,1899,1,1,1,17114),-- Necklace of Devotion Chain
(20500,1874,1,1,2,7302),-- Oriharukon Ore
(20500,1878,1,1,2,43810),-- Braided Hemp
(20500,2262,1,1,2,1701),-- Recipe: Elven Bow
(20500,5220,1,1,2,4381),-- Metal Hardener
(20501,1870,1,1,-1,944489),-- Coal
(20501,1933,1,1,-1,111116),-- Dark Stocking Fabric
(20501,2153,1,1,-1,146888),-- Recipe: Tiger\'s Eye Earring
(20501,57,400,793,0,700000),-- Adena
(20501,433,1,1,1,168),-- Elven Tunic
(20501,434,1,1,1,168),-- White Tunic
(20501,435,1,1,1,168),-- Mystic\'s Tunic
(20501,466,1,1,1,269),-- Elven Stockings
(20501,467,1,1,1,269),-- Dark Stockings
(20501,468,1,1,1,269),-- Mystic\'s Stockings
(20501,1933,1,1,1,7590),-- Dark Stocking Fabric
(20501,1936,1,1,1,5280),-- White Tunic Pattern
(20501,1875,1,1,2,4915),-- Stone of Purity
(20501,1879,1,1,2,12289),-- Cokes
(20501,1885,1,1,2,6144),-- High Grade Suede
(20501,2264,1,1,2,762),-- Recipe: Two-handed Sword
(20501,2274,1,1,2,527),-- Recipe: Skull Breaker
(20501,5549,1,1,2,7373),-- Metallic Thread
(20501,5550,1,1,2,983),-- Durable Metal Plate
(20502,1871,1,1,-1,233906),-- Charcoal
(20502,1896,1,1,-1,99113),-- Necklace of Anguish Chain
(20502,1923,1,1,-1,95863),-- Leather Stocking Pattern
(20502,57,118,179,0,700000),-- Adena
(20502,23,1,1,1,1505),-- Wooden Breastplate
(20502,30,1,1,1,2411),-- Hard Leather Pants
(20502,2386,1,1,1,2411),-- Wooden Gaiters
(20502,1798,1,1,2,45159),-- Recipe: Leather Helmet
(20502,1868,1,1,2,92123),-- Thread
(20502,1873,1,1,2,18425),-- Silver Nugget
(20504,1792,1,1,-1,13930),-- Recipe: Short Spear
(20504,1921,1,1,-1,122225),-- Leather Shoes Texture
(20504,2010,1,1,-1,7372),-- Brandish Blade
(20504,57,97,143,0,700000),-- Adena
(20504,20,1,1,1,5230),-- Buckler
(20504,43,1,1,1,3657),-- Wooden Helmet
(20504,1792,1,1,2,2744),-- Recipe: Short Spear
(20504,1865,1,1,2,37307),-- Varnish
(20504,1870,1,1,2,37307),-- Coal
(20505,734,1,1,-1,45036),-- Haste Potion
(20505,1800,1,1,-1,84973),-- Recipe: Piece Bone Breastplate
(20505,1869,1,1,-1,270215),-- Iron Ore
(20505,57,125,217,0,700000),-- Adena
(20505,217,1,1,1,152),-- Shining Knife
(20505,218,1,1,1,152),-- Throwing Knife
(20505,1817,1,1,2,6386),-- Recipe: Cord
(20505,1864,1,1,2,63854),-- Stem
(20505,1869,1,1,2,31927),-- Iron Ore
(20505,1878,1,1,2,12771),-- Braided Hemp
(20505,5273,1,1,2,1278),-- Recipe: Greater Spiritshot (D) Compressed Package(100%)
(20506,1864,1,1,-1,492156),-- Stem
(20506,1924,1,1,-1,79380),-- Leather Helmet Design
(20506,2150,1,1,-1,115530),-- Recipe: Blue Diamond Necklace
(20506,57,120,193,0,700000),-- Adena
(20506,24,1,1,1,466),-- Bone Breastplate
(20506,31,1,1,1,744),-- Bone Gaiters
(20506,390,1,1,1,466),-- Cotton Shirt
(20506,412,1,1,1,744),-- Cotton Pants
(20506,1864,1,1,2,72688),-- Stem
(20506,1869,1,1,2,36344),-- Iron Ore
(20506,2141,1,1,2,7269),-- Recipe: Silver Mold
(20506,5273,1,1,2,1454),-- Recipe: Greater Spiritshot (D) Compressed Package(100%)
(20507,1866,1,1,-1,232371),-- Suede
(20507,1898,1,1,-1,35804),-- Blue Diamond Necklace Gem
(20507,3032,1,1,-1,13942),-- Recipe: Spiritshot D
(20507,57,159,283,0,700000),-- Adena
(20507,273,1,1,1,110),-- Composition Bow
(20507,2016,1,1,1,1206),-- Composition Bow Shaft
(20507,1804,1,1,2,1647),-- Recipe: Soulshot: D-Grade
(20507,1864,1,1,2,82366),-- Stem
(20507,1869,1,1,2,41183),-- Iron Ore
(20507,1878,1,1,2,16473),-- Braided Hemp
(20507,5273,1,1,2,1647),-- Recipe: Greater Spiritshot (D) Compressed Package(100%)
(20508,1800,1,1,-1,78931),-- Recipe: Piece Bone Breastplate
(20508,1866,1,2,-1,167333),-- Suede
(20508,57,122,197,0,700000),-- Adena
(20508,1101,1,1,1,950),-- Tunic of Devotion
(20508,1104,1,1,1,1518),-- Stockings of Devotion
(20508,1867,1,1,2,65904),-- Animal Skin
(20508,1872,1,1,2,65904),-- Animal Bone
(20508,2142,1,1,2,9886),-- Recipe: Varnish of Purity
(20509,1060,1,1,-1,330759),-- Lesser Healing Potion
(20509,1129,1,1,-1,63370),-- Crude Leather Shoes
(20509,2005,1,1,-1,10632),-- Broadsword Blade
(20509,57,80,108,0,700000),-- Adena
(20509,428,1,1,1,2351),-- Feriotic Tunic
(20509,463,1,1,1,3758),-- Feriotic Stockings
(20509,1100,1,1,1,2351),-- Cotton Tunic
(20509,1103,1,1,1,3758),-- Cotton Stockings
(20509,17,10,30,2,109915),-- Wooden Arrow
(20509,1864,1,1,2,43966),-- Stem
(20509,1869,1,1,2,21983),-- Iron Ore
(20509,2136,1,1,2,6466),-- Recipe: Cokes
(20510,1792,1,1,-1,15222),-- Recipe: Short Spear
(20510,1798,1,1,-1,202966),-- Recipe: Leather Helmet
(20510,1923,1,1,-1,84846),-- Leather Stocking Pattern
(20510,57,110,152,0,700000),-- Adena
(20510,23,1,1,1,1332),-- Wooden Breastplate
(20510,30,1,1,1,2134),-- Hard Leather Pants
(20510,2386,1,1,1,2134),-- Wooden Gaiters
(20510,1792,1,1,2,2998),-- Recipe: Short Spear
(20510,1868,1,1,2,81537),-- Thread
(20510,1873,1,1,2,16308),-- Silver Nugget
(20511,734,1,1,-1,40780),-- Haste Potion
(20511,1897,1,1,-1,58257),-- Necklace of Wisdom Chain
(20511,2144,1,1,-1,48936),-- Recipe: Compound Braid
(20511,57,115,195,0,700000),-- Adena
(20511,176,1,1,1,138),-- Journeyman\'s Staff
(20511,2501,1,1,1,138),-- Bone Club
(20511,735,1,1,2,1721),-- Potion of Alacrity
(20511,1800,1,1,2,6494),-- Recipe: Piece Bone Breastplate
(20511,1867,1,1,2,27534),-- Animal Skin
(20511,1869,1,1,2,20650),-- Iron Ore
(20511,1870,1,1,2,20650),-- Coal
(20511,1871,1,1,2,20650),-- Charcoal
(20511,1872,1,1,2,27534),-- Animal Bone
(20514,1870,1,1,-1,231613),-- Coal
(20514,1872,1,1,-1,308818),-- Animal Bone
(20514,57,116,177,0,700000),-- Adena
(20514,20,1,1,1,6394),-- Buckler
(20514,43,1,1,1,4471),-- Wooden Helmet
(20514,734,1,1,2,5702),-- Haste Potion
(20514,1799,1,1,2,50678),-- Recipe: Leather Gloves
(20514,1865,1,1,2,34208),-- Varnish
(20514,1870,1,1,2,34208),-- Coal
(20515,735,1,1,-1,19797),-- Potion of Alacrity
(20515,1865,1,1,-1,237565),-- Varnish
(20515,2013,1,1,-1,5127),-- Forest Bow Shaft
(20515,57,118,183,0,700000),-- Adena
(20515,15,1,1,1,134),-- Short Spear
(20515,2011,1,1,1,1601),-- Short Spear Edge
(20515,1801,1,1,2,17676),-- Recipe: Piece Bone Gaiters
(20515,1865,1,1,2,35087),-- Varnish
(20515,1870,1,1,2,35087),-- Coal
(20515,5158,1,1,2,1404),-- Recipe: Spiritshot (D) Compressed Package (100%)
(20517,1831,1,1,-1,473949),-- Antidote
(20517,1869,1,1,-1,177731),-- Iron Ore
(20517,1921,1,1,-1,114665),-- Leather Shoes Texture
(20517,57,95,131,0,700000),-- Adena
(20517,271,1,1,1,505),-- Hunting Bow
(20517,1793,1,1,2,1931),-- Recipe: Sword of Reflection
(20517,1833,1,1,2,69999),-- Bandage
(20517,1864,1,1,2,52499),-- Stem
(20517,1869,1,1,2,26250),-- Iron Ore
(20518,1831,1,1,-1,492420),-- Antidote
(20518,1864,1,1,-1,369315),-- Stem
(20518,1866,1,1,-1,123105),-- Suede
(20518,57,97,137,0,700000),-- Adena
(20518,271,1,1,1,524),-- Hunting Bow
(20518,1799,1,1,2,53872),-- Recipe: Leather Gloves
(20518,1865,1,1,2,36364),-- Varnish
(20518,1870,1,1,2,36364),-- Coal
(20521,1896,1,1,-1,106171),-- Necklace of Anguish Chain
(20521,1897,1,1,-1,59658),-- Necklace of Wisdom Chain
(20521,2143,1,1,-1,50113),-- Recipe: Synthetic Cokes
(20521,57,128,189,0,700000),-- Adena
(20521,9,1,1,1,237),-- Cedar Staff
(20521,154,1,1,1,237),-- Dwarven Mace
(20521,2008,1,1,1,1921),-- Cedar Staff Head
(20521,734,1,1,2,6168),-- Haste Potion
(20521,1793,1,1,2,2722),-- Recipe: Sword of Reflection
(20521,1866,1,1,2,24671),-- Suede
(20521,1871,1,1,2,37007),-- Charcoal
(20525,1867,1,1,-1,51475),-- Animal Skin
(20525,1872,1,1,-1,51475),-- Animal Bone
(20525,5549,1,1,-1,3861),-- Metallic Thread
(20525,57,19,29,0,700000),-- Adena
(20525,1,1,1,1,13530),-- Short Sword
(20525,1060,1,1,2,22174),-- Lesser Healing Potion
(20525,1787,1,1,2,7983),-- Recipe: Willow Staff
(20525,1868,1,1,2,19957),-- Thread
(20525,1873,1,1,2,3992),-- Silver Nugget
(20526,1833,1,1,-1,694345),-- Bandage
(20526,1921,1,1,-1,167987),-- Leather Shoes Texture
(20526,5220,1,1,-1,10415),-- Metal Hardener
(20526,57,131,199,0,700000),-- Adena
(20526,114,1,1,1,2279),-- Earring of Strength
(20526,115,1,1,1,2279),-- Earring of Wisdom
(20526,876,1,1,1,3418),-- Ring of Anguish
(20526,907,1,1,1,1709),-- Necklace of Anguish
(20526,1896,1,1,1,13036),-- Necklace of Anguish Chain
(20526,1803,1,1,2,43088),-- Recipe: Necklace of Wisdom
(20526,1866,1,1,2,34184),-- Suede
(20526,1871,1,1,2,51275),-- Charcoal
(20528,1833,1,1,-1,568013),-- Bandage
(20528,1922,1,1,-1,54338),-- Leather Tunic Pattern
(20528,57,112,158,0,700000),-- Adena
(20528,216,1,1,1,303),-- Dirk
(20528,2009,1,1,1,2232),-- Dirk Blade
(20528,1803,1,1,2,35249),-- Recipe: Necklace of Wisdom
(20528,1865,1,1,2,41946),-- Varnish
(20528,1870,1,1,2,41946),-- Coal
(20529,1121,1,1,-1,636783),-- Apprentice\'s Shoes
(20529,1786,1,1,-1,12736),-- Recipe: Broad Sword
(20529,1867,1,1,-1,21226),-- Animal Skin
(20529,57,8,12,0,700000),-- Adena
(20529,35,1,1,1,29390),-- Cloth Shoes
(20529,36,1,1,1,29390),-- Leather Sandals
(20529,48,1,1,1,29390),-- Short Gloves
(20529,1121,1,1,1,164584),-- Apprentice\'s Shoes
(20529,1788,1,1,2,4389),-- Recipe: Bow 
(20529,1868,1,1,2,10973),-- Thread
(20529,1873,1,1,2,2195),-- Silver Nugget
(20530,1787,1,1,-1,12736),-- Recipe: Willow Staff
(20530,1867,1,1,-1,21226),-- Animal Skin
(20530,1868,1,1,-1,31839),-- Thread
(20530,57,8,12,0,700000),-- Adena
(20530,426,1,1,1,14565),-- Tunic
(20530,462,1,1,1,23181),-- Stockings
(20530,1060,1,1,2,9144),-- Lesser Healing Potion
(20530,1786,1,1,2,3292),-- Recipe: Broad Sword
(20530,1868,1,1,2,8230),-- Thread
(20530,1873,1,1,2,1646),-- Silver Nugget
(20531,1788,1,1,-1,12736),-- Recipe: Bow 
(20531,1872,1,1,-1,21226),-- Animal Bone
(20531,1873,1,1,-1,6368),-- Silver Nugget
(20531,57,8,12,0,700000),-- Adena
(20531,426,1,1,1,14565),-- Tunic
(20531,462,1,1,1,23181),-- Stockings
(20531,1787,1,1,2,4389),-- Recipe: Willow Staff
(20531,1868,1,1,2,10973),-- Thread
(20531,1873,1,1,2,2195),-- Silver Nugget
(20532,35,1,1,-1,127969),-- Cloth Shoes
(20532,1786,1,1,-1,14332),-- Recipe: Broad Sword
(20532,1787,1,1,-1,14332),-- Recipe: Willow Staff
(20532,57,8,13,0,700000),-- Adena
(20532,18,1,1,1,61740),-- Leather Shield
(20532,41,1,1,1,44100),-- Cloth Cap
(20532,1786,1,1,2,4940),-- Recipe: Broad Sword
(20532,1868,1,1,2,12349),-- Thread
(20532,1873,1,1,2,2470),-- Silver Nugget
(20533,1872,1,1,-1,23887),-- Animal Bone
(20533,5549,1,1,-1,1792),-- Metallic Thread
(20533,57,8,13,0,700000),-- Adena
(20533,13,1,1,1,6279),-- Short Bow
(20533,1060,1,1,2,10291),-- Lesser Healing Potion
(20533,1787,1,1,2,3705),-- Recipe: Willow Staff
(20533,1868,1,1,2,9262),-- Thread
(20533,1873,1,1,2,1853),-- Silver Nugget
(20534,1786,1,1,-1,14332),-- Recipe: Broad Sword
(20534,1868,1,1,-1,35831),-- Thread
(20534,57,8,13,0,700000),-- Adena
(20534,21,1,1,1,16391),-- Shirt
(20534,28,1,1,1,26087),-- Pants
(20534,1788,1,1,2,4940),-- Recipe: Bow 
(20534,1868,1,1,2,12349),-- Thread
(20534,1873,1,1,2,2470),-- Silver Nugget
(20535,36,1,1,-1,127969),-- Leather Sandals
(20535,1787,1,1,-1,14332),-- Recipe: Willow Staff
(20535,1867,1,1,-1,23887),-- Animal Skin
(20535,57,8,13,0,700000),-- Adena
(20535,21,1,1,1,16391),-- Shirt
(20535,28,1,1,1,26087),-- Pants
(20535,17,10,30,2,23153),-- Wooden Arrow
(20535,1786,1,1,2,3705),-- Recipe: Broad Sword
(20535,1865,1,1,2,4631),-- Varnish
(20535,1870,1,1,2,4631),-- Coal
(20536,18,1,1,-1,180709),-- Leather Shield
(20536,1788,1,1,-1,21685),-- Recipe: Bow 
(20536,1871,1,1,-1,27106),-- Charcoal
(20536,57,13,20,0,700000),-- Adena
(20536,13,1,1,1,9500),-- Short Bow
(20536,1787,1,1,2,7474),-- Recipe: Willow Staff
(20536,1864,1,1,2,18683),-- Stem
(20536,1869,1,1,2,9342),-- Iron Ore
(20537,1788,1,1,-1,21685),-- Recipe: Bow 
(20537,1864,1,1,-1,54213),-- Stem
(20537,1867,1,1,-1,36142),-- Animal Skin
(20537,57,13,20,0,700000),-- Adena
(20537,308,1,1,1,9500),-- Buffalo\'s Horn
(20537,1060,1,1,2,15569),-- Lesser Healing Potion
(20537,1788,1,1,2,5605),-- Recipe: Bow 
(20537,1864,1,1,2,14012),-- Stem
(20537,1869,1,1,2,7006),-- Iron Ore
(20538,1786,1,1,-1,21685),-- Recipe: Broad Sword
(20538,1865,1,1,-1,27106),-- Varnish
(20538,1869,1,1,-1,27106),-- Iron Ore
(20538,57,13,20,0,700000),-- Adena
(20538,1,1,1,1,9500),-- Short Sword
(20538,1786,1,1,2,7474),-- Recipe: Broad Sword
(20538,1864,1,1,2,18683),-- Stem
(20538,1869,1,1,2,9342),-- Iron Ore
(20539,41,1,1,-1,129078),-- Cloth Cap
(20539,1786,1,1,-1,21685),-- Recipe: Broad Sword
(20539,1787,1,1,-1,21685),-- Recipe: Willow Staff
(20539,57,13,20,0,700000),-- Adena
(20539,253,1,1,1,9500),-- Spiked Gloves
(20539,17,10,30,2,35031),-- Wooden Arrow
(20539,1787,1,1,2,5605),-- Recipe: Willow Staff
(20539,1864,1,1,2,14013),-- Stem
(20539,1869,1,1,2,7007),-- Iron Ore
(20540,1831,1,1,-1,460056),-- Antidote
(20540,1873,1,1,-1,69008),-- Silver Nugget
(20540,1896,1,1,-1,73102),-- Necklace of Anguish Chain
(20540,57,92,127,0,700000),-- Adena
(20540,23,1,1,1,1110),-- Wooden Breastplate
(20540,30,1,1,1,1779),-- Hard Leather Pants
(20540,2386,1,1,1,1779),-- Wooden Gaiters
(20540,736,1,1,2,16987),-- Scroll of Escape
(20540,1868,1,1,2,67947),-- Thread
(20540,1873,1,1,2,13590),-- Silver Nugget
(20541,1897,1,1,-1,48342),-- Necklace of Wisdom Chain
(20541,1925,1,1,-1,133138),-- Leather Gloves Lining
(20541,2173,1,1,-1,55023),-- Recipe: Hard Leather Shirt
(20541,57,99,159,0,700000),-- Adena
(20541,272,1,1,1,114),-- Forest Bow
(20541,2013,1,1,1,1295),-- Forest Bow Shaft
(20541,734,1,1,2,2499),-- Haste Potion
(20541,1864,1,1,2,29987),-- Stem
(20541,1865,1,1,2,14994),-- Varnish
(20541,1866,1,1,2,9996),-- Suede
(20541,1868,1,1,2,29987),-- Thread
(20541,1873,1,1,2,5998),-- Silver Nugget
(20541,2143,1,1,2,2999),-- Recipe: Synthetic Cokes
(20541,5158,1,1,2,600),-- Recipe: Spiritshot (D) Compressed Package (100%)
(20542,734,1,1,-1,37733),-- Haste Potion
(20542,1869,1,1,-1,226397),-- Iron Ore
(20542,1878,1,1,-1,90559),-- Braided Hemp
(20542,57,106,181,0,700000),-- Adena
(20542,272,1,1,1,127),-- Forest Bow
(20542,2013,1,1,1,1444),-- Forest Bow Shaft
(20542,1801,1,1,2,13476),-- Recipe: Piece Bone Gaiters
(20542,1864,1,1,2,53500),-- Stem
(20542,1869,1,1,2,26750),-- Iron Ore
(20542,1878,1,1,2,10700),-- Braided Hemp
(20542,5158,1,1,2,1070),-- Recipe: Spiritshot (D) Compressed Package (100%)
(20543,908,1,1,-1,4987),-- Necklace of Wisdom
(20543,1882,1,1,-1,50535),-- Leather
(20543,2252,1,1,-1,9320),-- Recipe: Iron Hammer
(20543,57,105,183,0,700000),-- Adena
(20543,309,1,1,1,128),-- Tears of Eva
(20543,310,1,1,1,128),-- Relic of The Saints
(20543,1867,1,1,2,35826),-- Animal Skin
(20543,1872,1,1,2,35826),-- Animal Bone
(20543,1882,1,1,2,5971),-- Leather
(20543,2139,1,1,2,5374),-- Recipe: Steel Mold
(20543,6037,1,1,2,53739),-- Waking Scroll
(20544,1788,1,1,-1,21685),-- Recipe: Bow 
(20544,1870,1,1,-1,27106),-- Coal
(20544,1872,1,1,-1,36142),-- Animal Bone
(20544,57,13,20,0,700000),-- Adena
(20544,21,1,1,1,24800),-- Shirt
(20544,28,1,1,1,39470),-- Pants
(20544,1788,1,1,2,7474),-- Recipe: Bow 
(20544,1864,1,1,2,18683),-- Stem
(20544,1869,1,1,2,9342),-- Iron Ore
(20545,21,1,1,-1,28176),-- Shirt
(20545,1786,1,1,-1,12736),-- Recipe: Broad Sword
(20545,1873,1,1,-1,6368),-- Silver Nugget
(20545,57,8,12,0,700000),-- Adena
(20545,18,1,1,1,54861),-- Leather Shield
(20545,41,1,1,1,39187),-- Cloth Cap
(20545,17,10,30,2,16459),-- Wooden Arrow
(20545,1788,1,1,2,2634),-- Recipe: Bow 
(20545,1868,1,1,2,6584),-- Thread
(20545,1873,1,1,2,1317),-- Silver Nugget
(20545,6037,1,1,2,6584),-- Waking Scroll
(20546,1877,1,1,-1,27257),-- Adamantite Nugget
(20546,2279,1,1,-1,4867),-- Recipe: War Pick
(20546,2979,1,1,-1,91220),-- Recipe: Manticore Skin Gloves
(20546,57,288,574,0,700000),-- Adena
(20546,849,1,1,1,367),-- Tiger\'s Eye Earring
(20546,880,1,1,1,549),-- Black Pearl Ring
(20546,912,1,1,1,275),-- Near Forest Necklace
(20546,1901,1,1,1,12510),-- Tiger\'s Eye Earring Stone
(20546,1876,1,1,2,9058),-- Mithril Ore
(20546,1877,1,1,2,1812),-- Adamantite Nugget
(20546,1880,1,1,2,4529),-- Steel
(20546,1881,1,1,2,6038),-- Coarse Bone Powder
(20546,1882,1,1,2,10064),-- Leather
(20546,2274,1,1,2,323),-- Recipe: Skull Breaker
(20546,2276,1,1,2,323),-- Recipe: Maingauche
(20546,2976,1,1,2,6063),-- Recipe: Manticore Skin Boots
(20547,1804,1,1,-1,15126),-- Recipe: Soulshot: D-Grade
(20547,1898,1,1,-1,38844),-- Blue Diamond Necklace Gem
(20547,2151,1,1,-1,105333),-- Recipe: Necklace of Devotion
(20547,57,173,305,0,700000),-- Adena
(20547,39,1,1,1,1568),-- Boots
(20547,51,1,1,1,1568),-- Bracer
(20547,1930,1,1,1,19094),-- Boot Lining
(20547,734,1,1,2,7447),-- Haste Potion
(20547,1865,1,1,2,44679),-- Varnish
(20547,1870,1,1,2,44679),-- Coal
(20547,5163,1,1,2,1787),-- Recipe: Blessed Spiritshot (D) Compressed Package (100%)
(20547,5268,1,1,2,1787),-- Recipe: Greater Soulshot (D) Compressed Package (100%)
(20548,1804,1,1,-1,15428),-- Recipe: Soulshot: D-Grade
(20548,1865,1,1,-1,385707),-- Varnish
(20548,1930,1,1,-1,98899),-- Boot Lining
(20548,57,177,312,0,700000),-- Adena
(20548,625,1,1,1,2301),-- Bone Shield
(20548,1148,1,1,1,1605),-- Hard Leather Helmet
(20548,1864,1,1,2,113932),-- Stem
(20548,1869,1,1,2,56966),-- Iron Ore
(20548,1880,1,1,2,5697),-- Steel
(20548,5268,1,1,2,2279),-- Recipe: Greater Soulshot (D) Compressed Package (100%)
(20549,1880,1,1,-1,140167),-- Steel
(20549,1901,1,1,-1,193601),-- Tiger\'s Eye Earring Stone
(20549,1938,1,1,-1,94230),-- Mithril Banded Mail Material
(20549,57,592,1181,0,700000),-- Adena
(20549,83,1,1,1,45),-- Sword of Magic
(20549,124,1,1,1,33),-- Two-Handed Sword
(20549,127,1,1,1,33),-- Crimson Sword
(20549,130,1,1,1,33),-- Elven Sword
(20549,144,1,1,1,45),-- Sword of Occult
(20549,2026,1,1,1,1495),-- Two-Handed Sword Edge
(20549,1341,20,60,2,207017),-- Bone Arrow
(20549,1866,1,1,2,82807),-- Suede
(20549,1871,1,1,2,124210),-- Charcoal
(20549,1877,1,1,2,4968),-- Adamantite Nugget
(20549,2277,1,1,2,887),-- Recipe: Bich\'hwa
(20549,6667,1,1,2,77631),-- Deluxe Chest Key - Grade 3
(20550,394,1,1,-1,1325),-- Reinforced Leather Shirt
(20550,2154,1,1,-1,82984),-- Recipe: Elven Earring
(20550,2276,1,1,-1,5536),-- Recipe: Maingauche
(20550,57,327,655,0,700000),-- Adena
(20550,393,1,1,1,117),-- Mithril Banded Mail
(20550,394,1,1,1,117),-- Reinforced Leather Shirt
(20550,415,1,1,1,188),-- Mithril Banded Gaiters
(20550,416,1,1,1,188),-- Reinforced Leather Gaiters
(20550,1938,1,1,1,4617),-- Mithril Banded Mail Material
(20550,1939,1,1,1,6033),-- Mithril Banded Gaiters Material
(20550,1868,1,1,2,117742),-- Thread
(20550,1873,1,1,2,23549),-- Silver Nugget
(20550,1889,1,1,2,3925),-- Compound Braid
(20550,2148,1,1,2,4205),-- Recipe: Crafted Leather
(20550,2272,1,1,2,421),-- Recipe: Sword of Revolution
(20550,2274,1,1,2,421),-- Recipe: Skull Breaker
(20550,5549,1,1,2,5887),-- Metallic Thread
(20551,1874,1,1,-1,52310),-- Oriharukon Ore
(20551,1902,1,1,-1,79498),-- Elven Earring Beads
(20551,2034,1,1,-1,8290),-- Sword of Revolution Blade
(20551,57,332,662,0,700000),-- Adena
(20551,850,1,1,1,188),-- Elven Earring
(20551,881,1,1,1,282),-- Elven Ring
(20551,913,1,1,1,141),-- Elven Necklace
(20551,1902,1,1,1,6849),-- Elven Earring Beads
(20551,1903,1,1,1,11276),-- Elven Ring Piece
(20551,1904,1,1,1,6309),-- Elven Necklace Beads
(20551,1867,1,1,2,77258),-- Animal Skin
(20551,1872,1,1,2,77258),-- Animal Bone
(20551,1875,1,1,2,3863),-- Stone of Purity
(20551,1881,1,1,2,7726),-- Coarse Bone Powder
(20551,2145,1,1,2,4139),-- Recipe: Mithril Alloy
(20551,2287,1,1,2,322),-- Recipe: Atuba Hammer
(20551,2288,1,1,2,322),-- Recipe: Ghost Staff
(20552,1825,1,1,-1,120549),-- Recipe: Oriharukon
(20552,1902,1,1,-1,170992),-- Elven Earring Beads
(20552,1903,1,1,-1,281516),-- Elven Ring Piece
(20552,57,714,1424,0,700000),-- Adena
(20552,129,1,1,1,81),-- Sword of Revolution
(20552,2034,1,1,1,4609),-- Sword of Revolution Blade
(20552,1864,1,3,2,145401),-- Stem
(20552,1869,1,1,2,145401),-- Iron Ore
(20552,1878,1,1,2,58160),-- Braided Hemp
(20552,1884,1,1,2,89477),-- Cord
(20552,2208,1,1,2,14868),-- Recipe: Ogre Power Gauntlets
(20552,2285,1,1,2,808),-- Recipe: Claymore
(20553,1865,1,1,-1,869731),-- Varnish
(20553,1904,1,1,-1,81170),-- Elven Necklace Beads
(20553,2145,1,1,-1,62124),-- Recipe: Mithril Alloy
(20553,57,368,733,0,700000),-- Adena
(20553,318,1,1,1,42),-- Crucifix of Blood
(20553,2042,1,1,1,2077),-- Crucifix of Blood Piece
(20553,1865,1,1,2,74931),-- Varnish
(20553,1870,1,1,2,74931),-- Coal
(20553,1875,1,1,2,4995),-- Stone of Purity
(20553,1879,1,1,2,12488),-- Cokes
(20553,2208,1,1,2,7662),-- Recipe: Ogre Power Gauntlets
(20553,2285,1,1,2,416),-- Recipe: Claymore
(20554,1902,1,1,-1,103148),-- Elven Earring Beads
(20554,1941,1,1,-1,40488),-- Brigandine Temper
(20554,2146,1,1,-1,72720),-- Recipe: Artisan\'s frame
(20554,57,425,848,0,700000),-- Adena
(20554,224,1,1,1,24),-- Maingauche
(20554,1660,1,1,1,24),-- Cursed Maingauche
(20554,2038,1,1,1,1390),-- Maingauche Edge
(20554,2044,1,1,1,1390),-- Cursed Maingauche Edge
(20554,1864,1,1,2,150361),-- Stem
(20554,1869,1,1,2,75181),-- Iron Ore
(20554,1880,1,1,2,7518),-- Steel
(20554,2208,1,1,2,7687),-- Recipe: Ogre Power Gauntlets
(20554,5473,1,1,2,5370),-- Recipe: Durable Metal Plate(100%)
(20554,5550,1,1,2,1002),-- Durable Metal Plate
(20554,6036,1,1,2,2506),-- Greater Magic Haste Potion
(20555,1878,1,1,-1,366579),-- Braided Hemp
(20555,1903,1,1,-1,152869),-- Elven Ring Piece
(20555,2296,1,1,-1,5091),-- Recipe: Atuba Mace
(20555,57,383,764,0,700000),-- Adena
(20555,395,1,1,1,138),-- Manticore Skin Shirt
(20555,417,1,1,1,220),-- Manticore Skin Gaiters
(20555,1942,1,1,1,6041),-- Manticore Skin Shirt Texture
(20555,1943,1,1,1,9407),-- Manticore Skin Gaiters Pattern
(20555,1864,1,1,2,157911),-- Stem
(20555,1869,1,1,2,78955),-- Iron Ore
(20555,1880,1,1,2,7896),-- Steel
(20555,2208,1,1,2,8073),-- Recipe: Ogre Power Gauntlets
(20555,5473,1,1,2,5640),-- Recipe: Durable Metal Plate(100%)
(20555,5550,1,1,2,1053),-- Durable Metal Plate
(20556,1874,1,1,-1,64821),-- Oriharukon Ore
(20556,1957,1,1,-1,108518),-- Assault Boots Part
(20556,2305,1,1,-1,4246),-- Recipe: Crystal Staff
(20556,57,394,788,0,700000),-- Adena
(20556,438,1,1,1,133),-- Sage\'s Rag
(20556,1953,1,1,1,7820),-- Sage\'s Rag Lining
(20556,1865,1,1,2,81376),-- Varnish
(20556,1870,1,1,2,81376),-- Coal
(20556,1874,1,1,2,5425),-- Oriharukon Ore
(20556,2160,1,1,2,5250),-- Recipe: Moonstone Earring
(20556,2205,1,1,2,2575),-- Recipe: Chain Gaiters
(20556,5154,1,1,2,271),-- Recipe: Soulshot (C) Compressed Package (100%)
(20557,2055,1,1,-1,8505),-- Glaive Edge
(20557,3954,1,1,-1,3429),-- Recipe: Blessed Spiritshot C
(20557,4469,1,1,-1,5878),-- Dye of Strength <Str+1 Con-1>
(20557,57,414,837,0,700000),-- Adena
(20557,297,1,1,1,37),-- Glaive
(20557,2055,1,1,1,2136),-- Glaive Edge
(20557,1866,1,1,2,49193),-- Suede
(20557,1871,1,1,2,73790),-- Charcoal
(20557,1877,1,1,2,2952),-- Adamantite Nugget
(20557,2297,1,1,2,322),-- Recipe: Flamberge
(20557,2994,1,1,2,5856),-- Recipe: Boots of Seal
(20557,5154,1,1,2,246),-- Recipe: Soulshot (C) Compressed Package (100%)
(20557,6668,1,1,2,26354),-- Deluxe Chest Key - Grade 4
(20558,1905,1,1,-1,103435),-- Omen Beast\'s Eye Earring Gemstone
(20558,2310,1,1,-1,4643),-- Recipe: Dark Elven Dagger
(20558,2932,1,1,-1,118674),-- Plate Boots Design
(20558,57,420,854,0,700000),-- Adena
(20558,851,1,1,1,191),-- Omen Beast\'s Eye Earring
(20558,882,1,1,1,286),-- Mithril Ring
(20558,914,1,1,1,143),-- Necklace of Darkness
(20558,1905,1,1,1,8656),-- Omen Beast\'s Eye Earring Gemstone
(20558,1906,1,1,1,12232),-- Mithril Ring Wire
(20558,1907,1,1,1,6191),-- Necklace of Darkness Gem
(20558,1342,10,30,2,133487),-- Fine Steel Arrow
(20558,1875,1,1,2,4450),-- Stone of Purity
(20558,1879,1,1,2,11124),-- Cokes
(20558,1885,1,1,2,5562),-- High Grade Suede
(20558,2303,1,1,2,291),-- Recipe: Skull Graver
(20558,2988,1,1,2,2816),-- Recipe: Tempered Mithril Gaiters
(20558,5549,1,1,2,6674),-- Metallic Thread
(20558,5550,1,1,2,890),-- Durable Metal Plate
(20559,1873,1,1,-1,500056),-- Silver Nugget
(20559,2163,1,1,-1,63783),-- Recipe: Earring of Protection
(20559,2164,1,1,-1,96165),-- Recipe: Ring of Protection
(20559,57,492,1009,0,700000),-- Adena
(20559,71,1,1,1,17),-- Flamberge
(20559,72,1,1,1,17),-- Stormbringer
(20559,2059,1,1,1,1097),-- Flamberge Blade
(20559,2060,1,1,1,1173),-- Stormbringer Blade
(20559,1895,1,1,2,21101),-- Metallic Fiber
(20559,2164,1,1,2,5681),-- Recipe: Ring of Protection
(20559,2219,1,1,2,4587),-- Recipe: Crimson Boots
(20559,5154,1,1,2,246),-- Recipe: Soulshot (C) Compressed Package (100%)
(20559,8723,1,1,200,2954),-- Life Stone: level 46 
(20559,8733,1,1,200,739),-- Mid-Grade Life Stone: level 46
(20559,8743,1,1,200,74),-- High-Grade Life Stone: level 46
(20559,8753,1,1,200,15),-- Top-Grade Life Stone: level 46
(20560,1908,1,1,-1,110326),-- Moonstone Earring Wire
(20560,2165,1,1,-1,44638),-- Recipe: Necklace of Protection
(20560,2320,1,1,-1,4059),-- Recipe: Cursed Staff
(20560,57,461,936,0,700000),-- Adena
(20560,852,1,1,1,154),-- Moonstone Earring
(20560,883,1,1,1,231),-- Aquastone Ring
(20560,915,1,1,1,115),-- Aquastone Necklace
(20560,1908,1,1,1,8691),-- Moonstone Earring Wire
(20560,1909,1,1,1,12394),-- Aquastone Ring Wire
(20560,1910,1,1,1,6911),-- Aquastone Necklace Chain
(20560,1864,1,1,2,84711),-- Stem
(20560,1865,1,1,2,42355),-- Varnish
(20560,1866,1,1,2,28237),-- Suede
(20560,1868,1,1,2,84711),-- Thread
(20560,1873,1,1,2,16942),-- Silver Nugget
(20560,2225,1,1,2,921),-- Recipe: Demon\'s Stockings
(20560,2321,1,1,2,148),-- Recipe: Stiletto
(20560,2323,1,1,2,148),-- Recipe: Elemental Bow
(20560,3003,1,1,2,2631),-- Recipe: Gloves of Seal
(20560,8723,1,1,200,1694),-- Life Stone: level 46 
(20560,8733,1,1,200,424),-- Mid-Grade Life Stone: level 46 
(20560,8743,1,1,200,42),-- High-Grade Life Stone: level 46
(20560,8753,1,1,200,9),-- Top-Grade Life Stone: level 46
(20561,1880,1,1,-1,137957),-- Steel
(20561,2164,1,1,-1,106120),-- Recipe: Ring of Protection
(20561,2940,1,1,-1,124006),-- Dwarven Chain Boots Part
(20561,57,543,1111,0,700000),-- Adena
(20561,96,1,1,1,12),-- Scythe
(20561,298,1,1,1,12),-- Orcish Glaive
(20561,302,1,1,1,12),-- Body Slasher
(20561,2062,1,1,1,852),-- Scythe Edge
(20561,2075,1,1,1,852),-- Orcish Glaive Blade
(20561,2076,1,1,1,852),-- Body Slasher Blade
(20561,1832,1,1,2,60371),-- Greater Antidote
(20561,1866,1,1,2,36222),-- Suede
(20561,1871,1,1,2,54333),-- Charcoal
(20561,1885,1,1,2,4528),-- High Grade Suede
(20561,4041,1,1,2,472),-- Mold Hardener
(20561,5220,1,1,2,2173),-- Metal Hardener
(20561,6037,1,1,2,108667),-- Waking Scroll
(20561,6668,1,1,2,19405),-- Deluxe Chest Key - Grade 4
(20561,8723,1,1,200,2173),-- Life Stone: level 46
(20561,8733,1,1,200,543),-- Mid-Grade Life Stone: level 46
(20561,8743,1,1,200,54),-- High-Grade Life Stone: level 46
(20561,8753,1,1,200,11),-- Top-Grade Life Stone: level 46
(20562,440,1,1,-1,440),-- Robe of Seal
(20562,1867,1,3,-1,885212),-- Animal Skin
(20562,2346,1,1,-1,3088),-- Recipe: Fist Blade
(20562,57,524,1069,0,700000),-- Adena
(20562,853,1,1,1,130),-- Earring of Protection
(20562,884,1,1,1,196),-- Ring of Protection
(20562,916,1,1,1,98),-- Necklace of Protection
(20562,1911,1,1,1,7293),-- Earring of Protection Gemstone
(20562,1912,1,1,1,10567),-- Ring of Protection Gemstone
(20562,1913,1,1,1,5963),-- Necklace of Protection Gemstone
(20562,1342,10,30,2,90512),-- Fine Steel Arrow
(20562,1864,1,1,2,90512),-- Stem
(20562,1869,1,1,2,45256),-- Iron Ore
(20562,1880,1,1,2,4526),-- Steel
(20562,2166,1,1,2,1534),-- Recipe: Earrings of Binding (100%)
(20562,2226,1,1,2,1847),-- Recipe: Mithril Gauntlets
(20562,2230,1,1,2,877),-- Recipe: Theca Leather Gaiters
(20562,4043,1,1,2,1509),-- Asofe
(20562,5550,1,1,2,604),-- Durable Metal Plate
(20562,8724,1,1,200,1509),-- Life Stone: level 49
(20562,8734,1,1,200,377),-- Mid-Grade Life Stone: level 49
(20562,8744,1,1,200,38),-- High-Grade Life Stone: level 49
(20562,8754,1,1,200,8),-- Top-Grade Life Stone: level 49
(20563,1825,1,1,-1,77898),-- Recipe: Oriharukon
(20563,1864,1,5,-1,727049),-- Stem
(20563,1941,1,1,-1,43371),-- Brigandine Temper
(20563,57,455,909,0,700000),-- Adena
(20563,606,1,1,1,123),-- Rip Gauntlets
(20563,1124,1,1,1,123),-- Boots of Power
(20563,1946,1,1,1,4761),-- Rip Gauntlets Pattern
(20563,1948,1,1,1,4761),-- Boots of Power Pattern
(20563,2424,1,1,1,123),-- Manticore Skin Boots
(20563,2425,1,1,1,123),-- Brigandine Boots
(20563,2426,1,1,1,123),-- Elven Mithril Boots
(20563,2448,1,1,1,123),-- Manticore Skin Gloves
(20563,2449,1,1,1,123),-- Brigandine Gauntlets
(20563,2450,1,1,1,123),-- Elven Mithril Gloves
(20563,2923,1,1,1,4761),-- Manticore Skin Boot Lining
(20563,2924,1,1,1,4761),-- Brigandine Boots Design
(20563,2925,1,1,1,4761),-- Elven Mithril Boots Design
(20563,2926,1,1,1,4761),-- Manticore Skin Gloves Lining
(20563,2927,1,1,1,4761),-- Brigandine Gauntlets Pattern
(20563,2928,1,1,1,4761),-- Elven Mithril Gloves Design
(20563,1865,1,1,2,93957),-- Varnish
(20563,1870,1,1,2,93957),-- Coal
(20563,1874,1,1,2,6264),-- Oriharukon Ore
(20563,2160,1,1,2,6062),-- Recipe: Moonstone Earring
(20563,2205,1,1,2,2973),-- Recipe: Chain Gaiters
(20563,5154,1,1,2,313),-- Recipe: Soulshot (C) Compressed Package (100%)
(20564,1864,1,5,-1,661179),-- Stem
(20564,1885,1,1,-1,82647),-- High Grade Suede
(20564,2306,1,1,-1,4331),-- Recipe: Stick of Faith
(20564,57,402,804,0,700000),-- Adena
(20564,630,1,1,1,210),-- Square Shield
(20564,1956,1,1,1,9421),-- Square Shield Fragment
(20564,2412,1,1,1,147),-- Plate Helmet
(20564,2494,1,1,1,210),-- Plate Shield
(20564,2930,1,1,1,6691),-- Plate Helmet Design
(20564,2934,1,1,1,9421),-- Plate Shield Fragment
(20564,1866,1,1,2,47431),-- Suede
(20564,1871,1,1,2,71146),-- Charcoal
(20564,1877,1,1,2,2846),-- Adamantite Nugget
(20564,2297,1,1,2,311),-- Recipe: Flamberge
(20564,2994,1,1,2,5647),-- Recipe: Boots of Seal
(20564,5154,1,1,2,237),-- Recipe: Soulshot (C) Compressed Package (100%)
(20564,6668,1,1,2,25409),-- Deluxe Chest Key - Grade 4
(20565,1865,1,3,-1,572525),-- Varnish
(20565,3954,1,1,-1,3817),-- Recipe: Blessed Spiritshot C
(20565,4470,1,1,-1,6543),-- Dye of Strength <Str+1 Dex-1>
(20565,57,461,932,0,700000),-- Adena
(20565,262,1,1,1,41),-- Scallop Jamadhr
(20565,2053,1,1,1,2378),-- Scallop Jamadhr Edge
(20565,1875,1,1,2,5476),-- Stone of Purity
(20565,1879,1,1,2,13690),-- Cokes
(20565,1885,1,1,2,6845),-- High Grade Suede
(20565,2303,1,1,2,359),-- Recipe: Skull Graver
(20565,2988,1,1,2,3466),-- Recipe: Tempered Mithril Gaiters
(20565,5549,1,1,2,8214),-- Metallic Thread
(20565,5550,1,1,2,1095),-- Durable Metal Plate
(20566,1905,1,1,-1,117445),-- Omen Beast\'s Eye Earring Gemstone
(20566,2995,1,1,-1,95820),-- Recipe: Reinforced Mithril Gloves
(20566,3000,1,1,-1,77393),-- Recipe: Dwarven Chain Shield
(20566,57,477,970,0,700000),-- Adena
(20566,630,1,1,1,256),-- Square Shield
(20566,1956,1,1,1,11469),-- Square Shield Fragment
(20566,2412,1,1,1,179),-- Plate Helmet
(20566,2494,1,1,1,256),-- Plate Shield
(20566,2930,1,1,1,8145),-- Plate Helmet Design
(20566,2934,1,1,1,11469),-- Plate Shield Fragment
(20566,1895,1,1,2,21653),-- Metallic Fiber
(20566,2164,1,1,2,5830),-- Recipe: Ring of Protection
(20566,2219,1,1,2,4707),-- Recipe: Crimson Boots
(20566,5154,1,1,2,253),-- Recipe: Soulshot (C) Compressed Package (100%)
(20566,8723,1,1,200,3031),-- Life Stone: level 46 
(20566,8733,1,1,200,758),-- Mid-Grade Life Stone: level 46
(20566,8743,1,1,200,76),-- High-Grade Life Stone: level 46
(20566,8753,1,1,200,15),-- Top-Grade Life Stone: 46
(20567,2061,1,1,-1,10331),-- Big Hammer Head
(20567,2165,1,1,-1,51209),-- Recipe: Necklace of Protection
(20567,3004,1,1,-1,83015),-- Recipe: Rind Leather Gloves
(20567,57,526,1078,0,700000),-- Adena
(20567,263,1,1,1,36),-- Chakram
(20567,2073,1,1,1,2441),-- Chakram Edge
(20567,1864,1,1,2,97180),-- Stem
(20567,1865,1,1,2,48590),-- Varnish
(20567,1866,1,1,2,32393),-- Suede
(20567,1868,1,1,2,97180),-- Thread
(20567,1873,1,1,2,19436),-- Silver Nugget
(20567,2225,1,1,2,1056),-- Recipe: Demon\'s Stockings
(20567,2321,1,1,2,169),-- Recipe: Stiletto
(20567,2323,1,1,2,169),-- Recipe: Elemental Bow
(20567,3003,1,1,2,3018),-- Recipe: Gloves of Seal
(20567,8723,1,1,200,1944),-- Life Stone: level 46 
(20567,8733,1,1,200,486),-- Mid-Grade Life Stone: level 46 
(20567,8743,1,1,200,49),-- High-Grade Life Stone: level 46
(20567,8753,1,1,200,10),-- Top-Grade Life Stone: 46
(20568,1884,1,1,-1,724122),-- Cord
(20568,1908,1,1,-1,111430),-- Moonstone Earring Wire
(20568,1961,1,1,-1,37654),-- Mithril Shirt Fabric
(20568,57,465,945,0,700000),-- Adena
(20568,89,1,1,1,4),-- Big Hammer
(20568,160,1,1,1,4),-- Battle Axe
(20568,161,1,1,1,4),-- Silver Axe
(20568,173,1,1,1,4),-- Skull Graver
(20568,191,1,1,1,4),-- Heavy Doom Hammer
(20568,192,1,1,1,4),-- Crystal Staff
(20568,193,1,1,1,4),-- Stick of Faith
(20568,194,1,1,1,4),-- Heavy Doom Axe
(20568,2061,1,1,1,269),-- Big Hammer Head
(20568,2063,1,1,1,269),-- Battle Axe Head
(20568,2064,1,1,1,269),-- Silver Axe Head
(20568,2065,1,1,1,269),-- Skull Graver Head
(20568,2066,1,1,1,273),-- Heavy Doom Hammer Head
(20568,2067,1,1,1,250),-- Crystal Staff Head
(20568,2068,1,1,1,250),-- Stick of Faith Shaft
(20568,2069,1,1,1,273),-- Heavy Doom Axe Blade
(20568,1864,1,1,2,101114),-- Stem
(20568,1865,1,1,2,50557),-- Varnish
(20568,1866,1,1,2,33704),-- Suede
(20568,1868,1,1,2,101114),-- Thread
(20568,1873,1,1,2,20223),-- Silver Nugget
(20568,2321,1,1,2,176),-- Recipe: Stiletto
(20568,2324,1,1,2,176),-- Recipe: Elven Bow of Nobility
(20568,8723,1,1,200,2022),-- Life Stone: level 46
(20568,8733,1,1,200,506),-- Mid-Grade Life Stone: level 46
(20568,8743,1,1,200,50),-- High-Grade Life Stone: level 46
(20568,8753,1,1,200,10),-- Top-Grade Life Stone: 46
(20569,1961,1,1,-1,40920),-- Mithril Shirt Fabric
(20569,2213,1,1,-1,19856),-- Recipe: Dwarven Chain Mail Shirt
(20569,3001,1,1,-1,79425),-- Recipe: Rind Leather Boots
(20569,57,504,1030,0,700000),-- Adena
(20569,631,1,1,1,198),-- Eldarake
(20569,1964,1,1,1,8139),-- Eldarake Temper
(20569,2413,1,1,1,138),-- Chain Hood
(20569,2495,1,1,1,198),-- Chain Shield
(20569,2936,1,1,1,7392),-- Chain Hood Pattern
(20569,2945,1,1,1,8139),-- Chain Shield Fragment
(20569,1865,1,1,2,50363),-- Varnish
(20569,1870,1,1,2,50363),-- Coal
(20569,1875,1,1,2,3358),-- Stone of Purity
(20569,1879,1,1,2,8394),-- Cokes
(20569,2220,1,1,2,1043),-- Recipe: Rind Leather Armor
(20569,2230,1,1,2,976),-- Recipe: Theca Leather Gaiters
(20569,2508,1,1,2,41969),-- Cursed Bone
(20569,4040,1,1,2,1007),-- Mold Lubricant
(20569,8723,1,1,200,2015),-- Life Stone: level 46
(20569,8733,1,1,200,504),-- Mid-Grade Life Stone: level 46
(20569,8743,1,1,200,50),-- High-Grade Life Stone: 46
(20569,8753,1,1,200,10),-- Top-Grade Life Stone: 46
(20570,1911,1,1,-1,95383),-- Earring of Protection Gemstone
(20570,2216,1,1,-1,52993),-- Recipe: Great Helmet
(20570,3008,1,1,-1,46633),-- Recipe: Theca Leather Gloves
(20570,57,506,1033,0,700000),-- Adena
(20570,355,1,1,1,57),-- Dwarven Chain Mail Shirt
(20570,382,1,1,1,92),-- Dwarven Chain Gaiters
(20570,1968,1,1,1,3423),-- Dwarven Chain Mail Shirt Material
(20570,1969,1,1,1,5429),-- Dwarven Chain Gaiters Material
(20570,1866,1,1,2,34437),-- Suede
(20570,1871,1,1,2,51655),-- Charcoal
(20570,1885,1,1,2,4305),-- High Grade Suede
(20570,2167,1,1,2,2635),-- Recipe: Ring of Ages
(20570,2343,1,1,2,120),-- Recipe: Mace of the Underworld
(20570,4041,1,1,2,449),-- Mold Hardener
(20570,5220,1,1,2,2066),-- Metal Hardener
(20570,8724,1,1,200,1722),-- Life Stone: level 49
(20570,8734,1,1,200,430),-- Mid-Grade Life Stone: level 49
(20570,8744,1,1,200,43),-- High-Grade Life Stone: level 49
(20570,8754,1,1,200,9),-- Top-Grade Life Stone: level 49
(20571,951,1,1,-1,2756),-- Scroll: Enchant Weapon (Grade C)
(20571,2335,1,1,-1,3525),-- Recipe: War Axe
(20571,2968,1,1,-1,10228),-- Dwarven Warhammer Head
(20571,57,599,1219,0,700000),-- Adena
(20571,73,1,1,1,8),-- Shamshir
(20571,74,1,1,1,8),-- Katana
(20571,131,1,1,1,8),-- Spirit Sword
(20571,133,1,1,1,8),-- Raid Sword
(20571,2077,1,1,1,558),-- Shamshir Blade
(20571,2078,1,1,1,558),-- Katana Blade
(20571,2080,1,1,1,558),-- Spirit Sword Blade
(20571,2081,1,1,1,558),-- Raid Sword Blade
(20571,1866,1,1,2,34445),-- Suede
(20571,1871,1,1,2,51668),-- Charcoal
(20571,1885,1,1,2,4306),-- High Grade Suede
(20571,2336,1,1,2,120),-- Recipe: Nirvana Axe
(20571,2351,1,1,2,108),-- Recipe: Scorpion
(20571,2508,1,1,2,43057),-- Cursed Bone
(20571,4041,1,1,2,449),-- Mold Hardener
(20571,5220,1,1,2,2067),-- Metal Hardener
(20571,6668,1,1,2,18453),-- Deluxe Chest Key - Grade 4
(20571,8724,1,1,200,1722),-- Life Stone: level 49
(20571,8734,1,1,200,431),-- Mid-Grade Life Stone: level 49
(20571,8744,1,1,200,43),-- High-Grade Life Stone: level 49
(20571,8754,1,1,200,9),-- Top-Grade Life Stone: level 49
(20572,1894,1,1,-1,58315),-- Crafted Leather
(20572,2950,1,1,-1,139779),-- Gloves of Seal Pattern
(20572,4125,1,1,-1,73865),-- Recipe: Maestro Mold
(20572,57,656,1338,0,700000),-- Adena
(20572,94,1,1,1,33),-- Bec de Corbin
(20572,2079,1,1,1,2530),-- Bec De Corbin Blade
(20572,1342,10,30,2,113290),-- Fine Steel Arrow
(20572,1867,1,1,2,75526),-- Animal Skin
(20572,1872,1,1,2,75526),-- Animal Bone
(20572,1882,1,1,2,12588),-- Leather
(20572,1894,1,1,2,1987),-- Crafted Leather
(20572,2224,1,1,2,770),-- Recipe: Demon\'s Tunic
(20572,2508,1,1,2,47204),-- Cursed Bone
(20572,3009,1,1,2,2312),-- Recipe: Composite Boots
(20572,4042,1,1,2,944),-- Enria
(20572,8724,1,1,200,1888),-- Life Stone: level 49
(20572,8734,1,1,200,472),-- Mid-Grade Life Stone: level 49
(20572,8744,1,1,200,47),-- High-Grade Life Stone: level 49
(20572,8754,1,1,200,9),-- Top-Grade Life Stone: level 49
(20573,2119,1,1,-1,5433),-- Crystal Dagger Blade
(20573,4122,1,1,-1,52996),-- Recipe: Maestro Holder
(20573,5549,1,1,-1,119240),-- Metallic Thread
(20573,57,472,959,0,700000),-- Adena
(20573,64,1,1,1,131),-- Composite Boots
(20573,608,1,1,1,131),-- Mithril Gauntlets
(20573,1981,1,1,1,7251),-- Mithril Gauntlets Design
(20573,2956,1,1,1,7251),-- Composite Boots Part
(20573,1342,10,30,2,75862),-- Fine Steel Arrow
(20573,1868,1,1,2,75862),-- Thread
(20573,1873,1,1,2,15172),-- Silver Nugget
(20573,1889,1,1,2,2529),-- Compound Braid
(20573,2231,1,1,2,163),-- Recipe: Full Plate Armor
(20573,3014,1,1,2,1059),-- Recipe: Full Plate Boots
(20573,3019,1,1,2,1011),-- Recipe: Full Plate Shield
(20573,4044,1,1,2,1264),-- Thons
(20573,5549,1,1,2,3793),-- Metallic Thread
(20573,8725,1,1,200,1054),-- Life Stone: level 52
(20573,8735,1,1,200,263),-- Mid-Grade Life Stone: level 52
(20573,8745,1,1,200,26),-- High-Grade Life Stone: level 52
(20573,8755,1,1,200,5),-- Top-Grade Life Stone: level 52
(20574,1539,1,1,-1,278794),-- Greater Healing Potion
(20574,1867,1,3,-1,836382),-- Animal Skin
(20574,4601,1,1,-1,2788),-- Greater Dye of Strength <Str+3 Con-3>
(20574,57,497,1009,0,700000),-- Adena
(20574,75,1,1,1,3),-- Caliburs
(20574,76,1,1,1,3),-- Sword of Delusion
(20574,77,1,1,1,3),-- Tsurugi
(20574,84,1,1,1,3),-- Homunkulus\'s Sword
(20574,134,1,1,1,3),-- Sword of Nightmare
(20574,145,1,1,1,3),-- Sword of Whispering Death
(20574,2089,1,1,1,236),-- Caliburs Edge
(20574,2090,1,1,1,236),-- Delusional Blade
(20574,2091,1,1,1,236),-- Tsurugi Blade
(20574,2092,1,1,1,236),-- Homunkulus\'s Sword Blade
(20574,2095,1,1,1,236),-- Sword of Nightmare Blade
(20574,2096,1,1,1,236),-- Sword of Whispering Death Blade
(20574,1539,1,1,2,8868),-- Greater Healing Potion
(20574,1864,1,1,2,79817),-- Stem
(20574,1869,1,1,2,39909),-- Iron Ore
(20574,1880,1,1,2,3991),-- Steel
(20574,4043,1,1,2,1330),-- Asofe
(20574,4122,1,1,2,1774),-- Recipe: Maestro Holder
(20574,4123,1,1,2,1774),-- Recipe: Maestro Anvil Lock
(20574,4609,1,1,2,89),-- Greater Dye of Mental Strength <Men+3 Int-3>
(20574,5550,1,1,2,532),-- Durable Metal Plate
(20574,8725,1,1,200,1109),-- Life Stone: level 52
(20574,8735,1,1,200,277),-- Mid-Grade Life Stone: level 52
(20574,8745,1,1,200,28),-- High-Grade Life Stone: level 52
(20574,8755,1,1,200,6),-- Top-Grade Life Stone: level 52
(20575,1806,1,1,-1,2826),-- Recipe: Soulshot: B-Grade
(20575,1870,1,3,-1,706598),-- Coal
(20575,4598,1,1,-1,4711),-- Greater Dye of Mental Strength <Men+2 Wit-2>
(20575,57,558,1137,0,700000),-- Adena
(20575,135,1,1,1,6),-- Samurai Longsword
(20575,2115,1,1,1,598),-- Samurai Longsword Blade
(20575,5286,1,1,1,6),-- Berserker Blade
(20575,5530,1,1,1,598),-- Berserker Blade Edge
(20575,1865,1,1,2,40138),-- Varnish
(20575,1870,1,1,2,40138),-- Coal
(20575,1874,1,1,2,2676),-- Oriharukon Ore
(20575,4039,1,1,2,1338),-- Mold Glue
(20575,4043,1,1,2,1338),-- Asofe
(20575,4145,1,1,2,176),-- Recipe: Avadon Leather Armor
(20575,4180,1,1,2,4460),-- Recipe: Silver Arrow
(20575,4184,1,1,2,46),-- Recipe: Sprite\'s Staff
(20575,5165,1,1,2,80),-- Recipe: Blessed Spiritshot (B) Compressed Package (100%)
(20575,8726,1,1,200,929),-- Life Stone: level 55
(20575,8736,1,1,200,232),-- Mid-Grade Life Stone: level 55
(20575,8746,1,1,200,23),-- High-Grade Life Stone: level 55
(20575,8756,1,1,200,4),-- Top-Grade Life Stone: level 55
(20576,2119,1,1,-1,12928),-- Crystal Dagger Blade
(20576,4145,1,1,-1,12443),-- Recipe: Avadon Leather Armor
(20576,4591,1,1,-1,9457),-- Greater Dye of Constitution <Con+2 Str-2>
(20576,57,1121,2284,0,700000),-- Adena
(20576,119,1,1,1,80),-- Necklace of Binding
(20576,855,1,1,1,107),-- Nassen\'s Earring
(20576,886,1,1,1,161),-- Ring of Binding
(20576,1918,1,1,1,7562),-- Nassen\'s Earring Gemstone
(20576,1920,1,1,1,5974),-- Necklace of Binding Chain
(20576,2917,1,1,1,10029),-- Ring of Binding Gemstone
(20576,1865,1,1,2,80580),-- Varnish
(20576,1870,1,1,2,80580),-- Coal
(20576,1875,1,1,2,5372),-- Stone of Purity
(20576,1879,1,1,2,13430),-- Cokes
(20576,4040,1,1,2,1612),-- Mold Lubricant
(20576,4178,1,1,2,1478),-- Recipe: Zubei\'s Shield (100%)
(20576,4187,1,1,2,93),-- Recipe: Kris
(20576,5155,1,1,2,161),-- Recipe: Soulshot (B) Compressed Package (100%)
(20576,5275,1,1,2,161),-- Recipe: Greater Spiritshot (B) Compressed Package(100%)
(20576,8726,1,1,200,1865),-- Life Stone: level 55
(20576,8736,1,1,200,466),-- Mid-Grade Life Stone: level 55
(20576,8746,1,1,200,47),-- High-Grade Life Stone: level 55
(20576,8756,1,1,200,10),-- Top-Grade Life Stone: level 55
(20577,351,1,1,-1,904),-- Blast Plate
(20577,2030,1,1,-1,8256),-- Tome of Blood Page
(20577,2154,1,1,-1,75575),-- Recipe: Elven Earring
(20577,57,298,595,0,700000),-- Adena
(20577,849,1,1,1,380),-- Tiger\'s Eye Earring
(20577,880,1,1,1,569),-- Black Pearl Ring
(20577,912,1,1,1,285),-- Near Forest Necklace
(20577,1901,1,1,1,12960),-- Tiger\'s Eye Earring Stone
(20577,1867,1,1,2,71486),-- Animal Skin
(20577,1872,1,1,2,71486),-- Animal Bone
(20577,1875,1,1,2,3574),-- Stone of Purity
(20577,1881,1,1,2,7149),-- Coarse Bone Powder
(20577,2154,1,1,2,5740),-- Recipe: Elven Earring
(20577,2270,1,1,2,383),-- Recipe: Goat Head Staff
(20577,2274,1,1,2,383),-- Recipe: Skull Breaker
(20578,1882,1,1,-1,170581),-- Leather
(20578,1901,1,1,-1,106024),-- Tiger\'s Eye Earring Stone
(20578,1939,1,1,-1,67424),-- Mithril Banded Gaiters Material
(20578,57,324,649,0,700000),-- Adena
(20578,278,1,1,1,55),-- Gastraphetes
(20578,2029,1,1,1,2434),-- Gastraphetes Shaft
(20578,1868,1,1,2,136045),-- Thread
(20578,1873,1,1,2,27209),-- Silver Nugget
(20578,1889,1,1,2,4535),-- Compound Braid
(20578,2273,1,1,2,486),-- Recipe: Tarbar
(20578,5549,1,1,2,6802),-- Metallic Thread
(20578,6037,1,1,2,136045),-- Waking Scroll
(20579,1889,1,1,-1,53356),-- Compound Braid
(20579,1943,1,1,-1,63570),-- Manticore Skin Gaiters Pattern
(20579,1946,1,1,-1,108154),-- Rip Gauntlets Pattern
(20579,57,338,675,0,700000),-- Adena
(20579,606,1,1,1,90),-- Rip Gauntlets
(20579,1124,1,1,1,90),-- Boots of Power
(20579,1946,1,1,1,3494),-- Rip Gauntlets Pattern
(20579,1948,1,1,1,3494),-- Boots of Power Pattern
(20579,2424,1,1,1,90),-- Manticore Skin Boots
(20579,2425,1,1,1,90),-- Brigandine Boots
(20579,2426,1,1,1,90),-- Elven Mithril Boots
(20579,2448,1,1,1,90),-- Manticore Skin Gloves
(20579,2449,1,1,1,90),-- Brigandine Gauntlets
(20579,2450,1,1,1,90),-- Elven Mithril Gloves
(20579,2923,1,1,1,3494),-- Manticore Skin Boot Lining
(20579,2924,1,1,1,3494),-- Brigandine Boots Design
(20579,2925,1,1,1,3494),-- Elven Mithril Boots Design
(20579,2926,1,1,1,3494),-- Manticore Skin Gloves Lining
(20579,2927,1,1,1,3494),-- Brigandine Gauntlets Pattern
(20579,2928,1,1,1,3494),-- Elven Mithril Gloves Design
(20579,1868,1,1,2,118204),-- Thread
(20579,1873,1,1,2,23641),-- Silver Nugget
(20579,1889,1,1,2,3940),-- Compound Braid
(20579,2146,1,1,2,4222),-- Recipe: Artisan\'s frame
(20579,2286,1,1,2,328),-- Recipe: Bonebreaker
(20579,5549,1,1,2,5910),-- Metallic Thread
(20579,6668,1,1,2,21108),-- Deluxe Chest Key - Grade 4
(20580,1868,1,7,-1,767821),-- Thread
(20580,1881,1,1,-1,204752),-- Coarse Bone Powder
(20580,2031,1,1,-1,15545),-- Morning Star Head
(20580,57,649,1296,0,700000),-- Adena
(20580,395,1,1,1,231),-- Manticore Skin Shirt
(20580,417,1,1,1,369),-- Manticore Skin Gaiters
(20580,1942,1,1,1,10122),-- Manticore Skin Shirt Texture
(20580,1943,1,1,1,15762),-- Manticore Skin Gaiters Pattern
(20580,1868,1,1,2,264603),-- Thread
(20580,1873,1,1,2,52921),-- Silver Nugget
(20580,1889,1,1,2,8820),-- Compound Braid
(20580,2194,1,1,2,13528),-- Recipe: Mithril Gloves
(20580,2288,1,1,2,735),-- Recipe: Ghost Staff
(20580,5549,1,1,2,13230),-- Metallic Thread
(20581,1902,1,1,-1,88119),-- Elven Earring Beads
(20581,2036,1,1,-1,8804),-- Skull Breaker Head
(20581,2202,1,1,-1,88930),-- Recipe: Assault Boots
(20581,57,368,733,0,700000),-- Adena
(20581,279,1,1,1,42),-- Strengthened Long Bow
(20581,2040,1,1,1,2601),-- Strengthened Long Bow Shaft
(20581,1341,10,30,2,166513),-- Bone Arrow
(20581,1875,1,1,2,3330),-- Stone of Purity
(20581,1879,1,1,2,8326),-- Cokes
(20581,1885,1,1,2,4163),-- High Grade Suede
(20581,2198,1,1,2,1047),-- Recipe: Sage\'s Rag
(20581,2287,1,1,2,278),-- Recipe: Atuba Hammer
(20581,2293,1,1,2,278),-- Recipe: Glaive
(20581,5549,1,1,2,4995),-- Metallic Thread
(20581,5550,1,1,2,666),-- Durable Metal Plate
(20582,1825,1,1,-1,124192),-- Recipe: Oriharukon
(20582,1894,1,1,-1,61006),-- Crafted Leather
(20582,1942,1,1,-1,88686),-- Manticore Skin Shirt Texture
(20582,57,726,1449,0,700000),-- Adena
(20582,629,1,1,1,497),-- Kite Shield
(20582,1947,1,1,1,21568),-- Kite Shield Fragment
(20582,2411,1,1,1,348),-- Brigandine Helmet
(20582,2493,1,1,1,497),-- Brigandine Shield
(20582,2922,1,1,1,5769),-- Brigandine Helmet Design
(20582,2929,1,1,1,21568),-- Brigandine Shield Fragment
(20582,1341,20,60,2,213992),-- Bone Arrow
(20582,1864,1,3,2,85597),-- Stem
(20582,1869,1,1,2,128395),-- Iron Ore
(20582,1880,1,1,2,12839),-- Steel
(20582,2987,1,1,2,12466),-- Recipe: Plate Shield
(20582,3020,1,1,2,713),-- Recipe: Elven Long Sword
(20582,5550,1,1,2,1712),-- Durable Metal Plate
(20583,1903,1,1,-1,152869),-- Elven Ring Piece
(20583,1944,1,1,-1,46746),-- Mithril Tunic Fabric
(20583,2157,1,1,-1,75739),-- Recipe: Omen Beast\'s Eye Earring
(20583,57,383,764,0,700000),-- Adena
(20583,261,1,1,1,44),-- Bich\'Hwa
(20583,2039,1,1,1,2398),-- Bich\'Hwa Edge
(20583,1865,1,1,2,78955),-- Varnish
(20583,1870,1,1,2,78955),-- Coal
(20583,1874,1,1,2,5264),-- Oriharukon Ore
(20583,2160,1,1,2,5094),-- Recipe: Moonstone Earring
(20583,2205,1,1,2,2499),-- Recipe: Chain Gaiters
(20583,5154,1,1,2,263),-- Recipe: Soulshot (C) Compressed Package (100%)
(20584,1805,1,1,-1,4180),-- Recipe: Soulshot: C-Grade
(20584,2211,1,1,-1,28114),-- Recipe: Plated Leather Armor
(20584,2988,1,1,-1,52906),-- Recipe: Tempered Mithril Gaiters
(20584,57,508,1017,0,700000),-- Adena
(20584,280,1,1,1,45),-- Light Crossbow
(20584,2054,1,1,1,2680),-- Light Crossbow Shaft
(20584,1866,1,1,2,59965),-- Suede
(20584,1871,1,1,2,89948),-- Charcoal
(20584,1877,1,1,2,3598),-- Adamantite Nugget
(20584,2994,1,1,2,7139),-- Recipe: Boots of Seal
(20584,2297,1,1,2,393),-- Recipe: Flamberge
(20584,5154,1,1,2,300),-- Recipe: Soulshot (C) Compressed Package (100%)
(20584,6668,1,1,2,32124),-- Deluxe Chest Key - Grade 4
(20585,1905,1,1,-1,120264),-- Omen Beast\'s Eye Earring Gemstone
(20585,2204,1,1,-1,24481),-- Recipe: Chain Mail Shirt
(20585,2308,1,1,-1,5399),-- Recipe: Cursed Dagger
(20585,57,498,1006,0,700000),-- Adena
(20585,159,1,1,1,9),-- Bonebreaker
(20585,187,1,1,1,9),-- Atuba Hammer
(20585,188,1,1,1,9),-- Ghost Staff
(20585,189,1,1,1,9),-- Staff of Life
(20585,190,1,1,1,9),-- Atuba Mace
(20585,2048,1,1,1,513),-- Bonebreaker Head
(20585,2049,1,1,1,513),-- Atuba Hammer Head
(20585,2050,1,1,1,544),-- Ghost Staff Head
(20585,2051,1,1,1,544),-- Staff of Life Shaft
(20585,2058,1,1,1,513),-- Atuba Mace Head
(20585,1875,1,1,2,5912),-- Stone of Purity
(20585,1879,1,1,2,14781),-- Cokes
(20585,1885,1,1,2,7391),-- High Grade Suede
(20585,2303,1,1,2,387),-- Recipe: Skull Graver
(20585,2988,1,1,2,3742),-- Recipe: Tempered Mithril Gaiters
(20585,5549,1,1,2,8869),-- Metallic Thread
(20585,5550,1,1,2,1182),-- Durable Metal Plate
(20586,1884,1,1,-1,733590),-- Cord
(20586,2314,1,1,-1,5206),-- Recipe: Body Slasher
(20586,3954,1,1,-1,3974),-- Recipe: Blessed Spiritshot C
(20586,57,471,957,0,700000),-- Adena
(20586,70,1,1,1,22),-- Claymore
(20586,2047,1,1,1,1316),-- Claymore Blade
(20586,2499,1,1,1,22),-- Elven Long Sword
(20586,2967,1,1,1,1298),-- Elven Long Sword Blade
(20586,1895,1,1,2,21379),-- Metallic Fiber
(20586,2164,1,1,2,5756),-- Recipe: Ring of Protection
(20586,2219,1,1,2,4648),-- Recipe: Crimson Boots
(20586,5154,1,1,2,249),-- Recipe: Soulshot (C) Compressed Package (100%)
(20586,8723,1,1,200,2993),-- Life Stone: level 46 
(20586,8733,1,1,200,748),-- Mid-Grade Life Stone: level 46
(20586,8743,1,1,200,75),-- High-Grade Life Stone: level 46 
(20586,8753,1,1,200,15),-- Top-Grade Life Stone: level 46
(20587,1875,1,1,-1,74876),-- Stone of Purity
(20587,1953,1,1,-1,35975),-- Sage\'s Rag Lining
(20587,2062,1,1,-1,8809),-- Scythe Edge
(20587,57,442,906,0,700000),-- Adena
(20587,89,1,1,1,4),-- Big Hammer
(20587,160,1,1,1,4),-- Battle Axe
(20587,161,1,1,1,4),-- Silver Axe
(20587,173,1,1,1,4),-- Skull Graver
(20587,191,1,1,1,4),-- Heavy Doom Hammer
(20587,192,1,1,1,4),-- Crystal Staff
(20587,193,1,1,1,4),-- Stick of Faith
(20587,194,1,1,1,4),-- Heavy Doom Axe
(20587,2061,1,1,1,256),-- Big Hammer Head
(20587,2063,1,1,1,256),-- Battle Axe Head
(20587,2064,1,1,1,256),-- Silver Axe Head
(20587,2065,1,1,1,256),-- Skull Graver Head
(20587,2066,1,1,1,260),-- Heavy Doom Hammer Head
(20587,2067,1,1,1,239),-- Crystal Staff Head
(20587,2068,1,1,1,239),-- Stick of Faith Shaft
(20587,2069,1,1,1,260),-- Heavy Doom Axe Blade
(20587,1864,1,1,2,81664),-- Stem
(20587,1865,1,1,2,40832),-- Varnish
(20587,1866,1,1,2,27221),-- Suede
(20587,1868,1,1,2,81664),-- Thread
(20587,1873,1,1,2,16333),-- Silver Nugget
(20587,2225,1,1,2,888),-- Recipe: Demon\'s Stockings
(20587,2321,1,1,2,142),-- Recipe: Stiletto
(20587,2323,1,1,2,142),-- Recipe: Elemental Bow
(20587,3003,1,1,2,2536),-- Recipe: Gloves of Seal
(20587,8723,1,1,200,1633),-- Life Stone: level 46 
(20587,8733,1,1,200,408),-- Mid-Grade Life Stone: level 46 
(20587,8743,1,1,200,41),-- High-Grade Life Stone: level 46 
(20587,8753,1,1,200,8),-- Top-Grade Life Stone: level 46
(20588,1959,1,1,-1,59745),-- Chain Mail Shirt Material
(20588,2324,1,1,-1,7728),-- Recipe: Elven Bow of Nobility
(20588,57,585,1188,0,700000),-- Adena
(20588,71,1,1,1,20),-- Flamberge
(20588,72,1,1,1,20),-- Stormbringer
(20588,2059,1,1,1,1298),-- Flamberge Blade
(20588,2060,1,1,1,1387),-- Stormbringer Blade
(20588,1868,1,1,2,127064),-- Thread
(20588,1873,1,1,2,25413),-- Silver Nugget
(20588,3003,1,1,2,3946),-- Recipe: Gloves of Seal
(20588,4044,1,1,2,2118),-- Thons
(20588,5549,1,1,2,6353),-- Metallic Thread
(20588,1889,1,1,2,4236),-- Compound Braid
(20588,2214,1,1,2,1576),-- Recipe: Dwarven Chain Gaiters
(20588,8723,1,1,200,2541),-- Life Stone: level 46
(20588,8733,1,1,200,635),-- Mid-Grade Life Stone: level 46
(20588,8743,1,1,200,63),-- High-Grade Life Stone: level 46 
(20588,8753,1,1,200,13),-- Top-Grade Life Stone: level 46
(20589,1908,1,1,-1,209311),-- Moonstone Earring Wire
(20589,1961,1,1,-1,70730),-- Mithril Shirt Fabric
(20589,1962,1,1,-1,70730),-- Karmian Tunic Pattern
(20589,57,874,1776,0,700000),-- Adena
(20589,439,1,1,1,179),-- Karmian Tunic
(20589,471,1,1,1,287),-- Karmian Stockings
(20589,1954,1,1,1,13885),-- Karmian Stocking Design
(20589,1962,1,1,1,8358),-- Karmian Tunic Pattern
(20589,1868,1,1,2,189934),-- Thread
(20589,1873,1,1,2,37987),-- Silver Nugget
(20589,1889,1,1,2,6331),-- Compound Braid
(20589,2214,1,1,2,2356),-- Recipe: Dwarven Chain Gaiters
(20589,3003,1,1,2,5899),-- Recipe: Gloves of Seal
(20589,4044,1,1,2,3166),-- Thons
(20589,5549,1,1,2,9496),-- Metallic Thread
(20589,8723,1,1,200,3799),-- Life Stone: level 46
(20589,8733,1,1,200,950),-- Mid-Grade Life Stone: level 46
(20589,8743,1,1,200,95),-- High-Grade Life Stone: level 46 
(20589,8753,1,1,200,19),-- Top-Grade Life Stone: level 46
(20590,2068,1,1,-1,16483),-- Stick of Faith Shaft
(20590,2163,1,1,-1,116683),-- Recipe: Earring of Protection
(20590,2935,1,1,-1,121583),-- Tempered Mithril Gaiters Fragment
(20590,57,901,1842,0,700000),-- Adena
(20590,354,1,1,1,139),-- Chain Mail Shirt
(20590,381,1,1,1,222),-- Chain Gaiters
(20590,1959,1,1,1,7278),-- Chain Mail Shirt Material
(20590,1960,1,1,1,14805),-- Chain Gaiters Part
(20590,1867,1,1,2,131014),-- Animal Skin
(20590,1872,1,1,2,131014),-- Animal Bone
(20590,1882,1,1,2,21836),-- Leather
(20590,1894,1,1,2,3448),-- Crafted Leather
(20590,4042,1,1,2,1638),-- Enria
(20590,2230,1,1,2,1904),-- Recipe: Theca Leather Gaiters
(20590,2320,1,1,2,342),-- Recipe: Cursed Staff
(20590,8723,1,1,200,3930),-- Life Stone: level 46
(20590,8733,1,1,200,983),-- Mid-Grade Life Stone: level 46
(20590,8743,1,1,200,98),-- High-Grade Life Stone: level 46 
(20590,8753,1,1,200,20),-- Top-Grade Life Stone: level 46
(20591,951,1,1,-1,4876),-- Scroll: Enchant Weapon (Grade C)
(20591,1911,1,1,-1,199446),-- Earring of Protection Gemstone
(20591,2947,1,1,-1,191540),-- Dwarven Chain Shield Fragment
(20591,57,1058,2159,0,700000),-- Adena
(20591,94,1,1,1,54),-- Bec de Corbin
(20591,2079,1,1,1,4081),-- Bec De Corbin Blade
(20591,1867,1,1,2,144017),-- Animal Skin
(20591,1872,1,1,2,144017),-- Animal Bone
(20591,1882,1,1,2,24003),-- Leather
(20591,1894,1,1,2,3790),-- Crafted Leather
(20591,4042,1,1,2,1800),-- Enria
(20591,2230,1,1,2,2093),-- Recipe: Theca Leather Gaiters
(20591,2320,1,1,2,376),-- Recipe: Cursed Staff
(20591,8723,1,1,200,4320),-- Life Stone: level 46
(20591,8733,1,1,200,1080),-- Mid-Grade Life Stone: level 46
(20591,8743,1,1,200,108),-- High-Grade Life Stone: level 46
(20591,8753,1,1,200,22),-- Top-Grade Life Stone: level 46
(20592,1880,1,1,-1,368745),-- Steel
(20592,2166,1,1,-1,124998),-- Recipe: Earrings of Binding (100%)
(20592,2951,1,1,-1,310141),-- Rind Leather Gloves Design
(20592,57,1458,2964,0,700000),-- Adena
(20592,195,1,1,1,37),-- Cursed Staff
(20592,2082,1,1,1,2879),-- Cursed Staff Head
(20592,2502,1,1,1,37),-- Dwarven War Hammer
(20592,2968,1,1,1,2756),-- Dwarven Warhammer Head
(20592,1866,1,1,2,99020),-- Suede
(20592,1871,1,1,2,148530),-- Charcoal
(20592,1877,1,1,2,5941),-- Adamantite Nugget
(20592,4040,1,1,2,2971),-- Mold Lubricant
(20592,4041,1,1,2,1292),-- Mold Hardener
(20592,2340,1,1,2,345),-- Recipe: Pa\'agrian Hammer
(20592,3006,1,1,2,6062),-- Recipe: Demon\'s Gloves
(20592,8724,1,1,200,4951),-- Life Stone: level 49
(20592,8734,1,1,200,1238),-- Mid-Grade Life Stone: level 49
(20592,8744,1,1,200,124),-- High-Grade Life Stone: level 49
(20592,8754,1,1,200,25),-- Top-Grade Life Stone: level 49
(20593,1912,1,1,-1,426659),-- Ring of Protection Gemstone
(20593,2083,1,1,-1,26308),-- Stiletto Edge
(20593,2341,1,1,-1,9208),-- Recipe: Sage\'s Staff
(20593,57,1563,3187,0,700000),-- Adena
(20593,398,1,1,1,128),-- Plated Leather
(20593,399,1,1,1,118),-- Rind Leather Armor
(20593,418,1,1,1,204),-- Plated Leather Gaiters
(20593,419,1,1,1,189),-- Rind Leather Gaiters
(20593,1966,1,1,1,8006),-- Plated Leather Fragment
(20593,1967,1,1,1,11960),-- Plated Leather Gaiters Material
(20593,1975,1,1,1,7202),-- Rind Leather Armor Design
(20593,1976,1,1,1,13334),-- Rind Leather Gaiters Material
(20593,1866,1,1,2,106322),-- Suede
(20593,1871,1,1,2,159484),-- Charcoal
(20593,1877,1,1,2,6379),-- Adamantite Nugget
(20593,4040,1,1,2,3190),-- Mold Lubricant
(20593,4041,1,1,2,1387),-- Mold Hardener
(20593,2340,1,1,2,371),-- Recipe: Pa\'agrian Hammer
(20593,3006,1,1,2,6509),-- Recipe: Demon\'s Gloves
(20593,8724,1,1,200,5316),-- Life Stone: level 49
(20593,8734,1,1,200,1329),-- Mid-Grade Life Stone: level 49
(20593,8744,1,1,200,133),-- High-Grade Life Stone: level 49
(20593,8754,1,1,200,26),-- Top-Grade Life Stone: level 49
(20594,1871,1,5,-1,902788),-- Charcoal
(20594,1895,1,1,-1,773819),-- Metallic Fiber
(20594,1978,1,1,-1,173613),-- Tower Shield Fragment
(20594,57,1071,2178,0,700000),-- Adena
(20594,231,1,1,1,17),-- Grace Dagger
(20594,233,1,1,1,17),-- Dark Screamer
(20594,2106,1,1,1,1526),-- Grace Dagger Edge
(20594,2107,1,1,1,1526),-- Dark Screamer Edge
(20594,6669,1,1,2,20036),-- Deluxe Chest Key - Grade 5
(20594,1867,1,1,2,114873),-- Animal Skin
(20594,1872,1,1,2,114873),-- Animal Bone
(20594,1882,1,1,2,19145),-- Leather
(20594,1894,1,1,2,3023),-- Crafted Leather
(20594,4042,1,1,2,1436),-- Enria
(20594,2234,1,1,2,1284),-- Recipe: Divine Stockings
(20594,2356,1,1,2,140),-- Recipe: Demon\'s Staff
(20596,4609,1,1,2,192),-- Greater Dye of Mental Strength <Men+3 Int-3>
(20594,8725,1,1,200,2393),-- Life Stone: level 52
(20594,8735,1,1,200,598),-- Mid-Grade Life Stone: level 52
(20594,8745,1,1,200,60),-- High-Grade Life Stone: level 52
(20594,8755,1,1,200,12),-- Top-Grade Life Stone: level 52
(20595,1894,1,1,-1,98988),-- Crafted Leather
(20595,2096,1,1,-1,15374),-- Sword of Whispering Death Blade
(20595,2354,1,1,-1,4602),-- Recipe: Deadman\'s Staff
(20595,57,1117,2270,0,700000),-- Adena
(20595,231,1,1,1,18),-- Grace Dagger
(20595,233,1,1,1,18),-- Dark Screamer
(20595,2106,1,1,1,1589),-- Grace Dagger Edge
(20595,2107,1,1,1,1589),-- Dark Screamer Edge
(20595,1865,1,1,2,106060),-- Varnish
(20595,1870,1,1,2,106060),-- Coal
(20595,1874,1,1,2,7071),-- Oriharukon Ore
(20595,3014,1,1,2,2963),-- Recipe: Full Plate Boots
(20595,4039,1,1,2,3535),-- Mold Glue
(20595,4043,1,1,2,3535),-- Asofe
(20595,4125,1,1,2,4714),-- Recipe: Maestro Mold
(20595,8725,1,1,200,2946),-- Life Stone: level 52
(20595,8735,1,1,200,736),-- Mid-Grade Life Stone: level 52
(20595,8745,1,1,200,74),-- High-Grade Life Stone: level 52
(20595,8755,1,1,200,15),-- Top-Grade Life Stone: level 52
(20596,1539,1,1,-1,665319),-- Greater Healing Potion
(20596,1875,1,1,-1,199596),-- Stone of Purity
(20596,4609,1,1,-1,6653),-- Greater Dye of Mental Strength <Men+3 Int-3>
(20596,57,1189,2403,0,700000),-- Adena
(20596,162,1,1,1,5),-- War Axe
(20596,174,1,1,1,5),-- Nirvana Axe
(20596,196,1,1,1,5),-- Stick of Eternity
(20596,197,1,1,1,5),-- Paradia Staff
(20596,199,1,1,1,5),-- Pa\'agrian Hammer
(20596,200,1,1,1,5),-- Sage\'s Staff
(20596,201,1,1,1,5),-- Club of Nature
(20596,202,1,1,1,5),-- Mace of The Underworld
(20596,2097,1,1,1,414),-- War Axe Blade
(20596,2098,1,1,1,414),-- Nirvana Axe Blade
(20596,2099,1,1,1,436),-- Stick of Eternity Shaft
(20596,2100,1,1,1,436),-- Paradia Staff Head
(20596,2102,1,1,1,421),-- Pa\'agrian Hammer Head
(20596,2103,1,1,1,436),-- Sage\'s Staff Head
(20596,2104,1,1,1,436),-- Club of Nature Head
(20596,2105,1,1,1,414),-- Mace of The Underworld Head
(20596,1868,1,1,2,176872),-- Thread
(20596,1873,1,1,2,35375),-- Silver Nugget
(20596,1876,1,1,2,17687),-- Mithril Ore
(20596,1895,1,1,2,25267),-- Metallic Fiber
(20596,3017,1,1,2,2470),-- Recipe: Divine Gloves
(20596,4042,1,1,2,1474),-- Enria
(20596,4608,1,1,2,197),-- Greater Dye of Intelligence <Int+3 Wit-3>
(20596,5155,1,1,2,177),-- Recipe: Soulshot (B) Compressed Package (100%)
(20596,6669,1,1,2,20566),-- Deluxe Chest Key - Grade 5
(20596,8725,1,1,200,2456),-- Life Stone: level 52
(20596,8735,1,1,200,614),-- Mid-Grade Life Stone: level 52
(20596,8745,1,1,200,61),-- High-Grade Life Stone: level 52
(20596,8755,1,1,200,13),-- Top-Grade Life Stone: level 52
(20597,1918,1,1,-1,215903),-- Nassen\'s Earring Gemstone
(20597,2113,1,1,-1,24141),-- Scorpion Blade
(20597,3034,1,1,-1,9970),-- Recipe: Spiritshot B
(20597,57,1973,4008,0,700000),-- Adena
(20597,442,1,1,1,112),-- Divine Tunic
(20597,473,1,1,1,178),-- Divine Stockings
(20597,1988,1,1,1,8842),-- Divine Tunic Fabric
(20597,1989,1,1,1,13869),-- Divine Stocking Pattern
(20597,1865,1,1,2,153391),-- Varnish
(20597,1870,1,1,2,153391),-- Coal
(20597,1874,1,1,2,10226),-- Oriharukon Ore
(20597,4039,1,1,2,5113),-- Mold Glue
(20597,4043,1,1,2,5113),-- Asofe
(20597,4133,1,1,2,738),-- Recipe: Zubei\'s Breastplate
(20597,4941,1,1,2,1180),-- Recipe: Zubei\'s Gaiters  (60%)
(20597,4959,1,1,2,2955),-- Recipe: Avadon Boots (60%)
(20597,8726,1,1,200,3551),-- Life Stone: level 55
(20597,8736,1,1,200,888),-- Mid-Grade Life Stone: level 55
(20597,8746,1,1,200,89),-- High-Grade Life Stone: level 55
(20597,8756,1,1,200,17),-- Top-Grade Life Stone: level 55
(20598,1806,1,1,-1,9226),-- Recipe: Soulshot: B-Grade
(20598,2120,1,1,-1,22159),-- Great Pata Blade
(20598,4180,1,1,-1,512556),-- Recipe: Silver Arrow
(20598,57,1822,3711,0,700000),-- Adena
(20598,442,1,1,1,103),-- Divine Tunic
(20598,473,1,1,1,165),-- Divine Stockings
(20598,1988,1,1,1,8182),-- Divine Tunic Fabric
(20598,1989,1,1,1,12834),-- Divine Stocking Pattern
(20598,1864,1,3,2,141939),-- Stem
(20598,1869,1,1,2,141939),-- Iron Ore
(20598,1878,1,1,2,56776),-- Braided Hemp
(20598,1884,1,1,2,87347),-- Cord
(20598,4039,1,1,2,47231),-- Mold Glue
(20598,4178,1,1,2,2604),-- Recipe: Zubei\'s Shield (100%)
(20598,5160,1,1,2,284),-- Recipe: Spiritshot (B) Compressed Package (100%)
(20598,4184,1,1,2,164),-- Recipe: Sprite\'s Staff
(20598,8726,1,1,200,3286),-- Life Stone: level 55
(20598,8736,1,1,200,821),-- Mid-Grade Life Stone: level 55
(20598,8746,1,1,200,82),-- High-Grade Life Stone: level 55
(20598,8756,1,1,200,16),-- Top-Grade Life Stone: level 55
(20599,2120,1,1,-1,23008),-- Great Pata Blade
(20599,4146,1,1,-1,30703),-- Recipe: Tunic of Zubei
(20599,4590,1,1,-1,15966),-- Greater Dye of Strength <Str+2 Dex-2>
(20599,57,1893,3856,0,700000),-- Adena
(20599,2436,1,1,1,119),-- Theca Leather Boots
(20599,2437,1,1,1,92),-- Drake Leather Boots
(20599,2438,1,1,1,92),-- Full Plate Boots
(20599,2460,1,1,1,119),-- Theca Leather Gloves
(20599,2461,1,1,1,92),-- Drake Leather Gloves
(20599,2462,1,1,1,92),-- Full Plate Gauntlets
(20599,2463,1,1,1,92),-- Divine Gloves
(20599,2954,1,1,1,7997),-- Theca Leather Boots Texture
(20599,2955,1,1,1,7997),-- Theca Leather Gloves Texture
(20599,2960,1,1,1,6880),-- Drake Leather Boots Design
(20599,2961,1,1,1,6880),-- Full Plate Boots Part
(20599,2962,1,1,1,6880),-- Drake Leather Gloves Design
(20599,2963,1,1,1,6880),-- Full Plate Gauntlets Part
(20599,2964,1,1,1,6880),-- Divine Gloves Pattern
(20599,1864,1,3,2,147376),-- Stem
(20599,1869,1,1,2,147376),-- Iron Ore
(20599,1878,1,1,2,58951),-- Braided Hemp
(20599,1884,1,1,2,90693),-- Cord
(20599,4039,1,1,2,4912),-- Mold Glue
(20599,4178,1,1,2,2704),-- Recipe: Zubei\'s Shield (100%)
(20599,4184,1,1,2,179),-- Recipe: Sprite\'s Staff
(20599,5160,1,1,2,295),-- Recipe: Spiritshot (B) Compressed Package (100%)
(20599,8726,1,1,200,3412),-- Life Stone: level 55
(20599,8736,1,1,200,853),-- Mid-Grade Life Stone: level 55
(20599,8746,1,1,200,85),-- High-Grade Life Stone: level 55
(20599,8756,1,1,200,17),-- Top-Grade Life Stone: level 55
(20600,1825,1,1,-1,77127),-- Recipe: Oriharukon
(20600,1873,1,1,-1,431910),-- Silver Nugget
(20600,1945,1,1,-1,85765),-- Mithril Stocking Design
(20600,57,451,900,0,700000),-- Adena
(20600,629,1,1,1,309),-- Kite Shield
(20600,1947,1,1,1,13394),-- Kite Shield Fragment
(20600,2411,1,1,1,216),-- Brigandine Helmet
(20600,2493,1,1,1,309),-- Brigandine Shield
(20600,2922,1,1,1,3583),-- Brigandine Helmet Design
(20600,2929,1,1,1,13394),-- Brigandine Shield Fragment
(20600,1868,1,1,2,186053),-- Thread
(20600,1873,1,1,2,37211),-- Silver Nugget
(20600,1889,1,1,2,6202),-- Compound Braid
(20600,2286,1,1,2,517),-- Recipe: Bonebreaker
(20600,5231,1,1,2,6645),-- Recipe: Metal Hardener (100%)
(20600,5549,1,1,2,9303),-- Metallic Thread
(20601,1880,1,1,-1,97232),-- Steel
(20601,1905,1,1,-1,94584),-- Omen Beast\'s Eye Earring Gemstone
(20601,2304,1,1,-1,4246),-- Recipe: Heavy Doom Hammer
(20601,57,394,788,0,700000),-- Adena
(20601,353,1,1,1,81),-- Half Plate Armor
(20601,380,1,1,1,130),-- Plate Gaiters
(20601,1950,1,1,1,3962),-- Half Plate Temper
(20601,1951,1,1,1,6162),-- Plate Gaiters Part
(20601,1864,1,1,2,162752),-- Stem
(20601,1869,1,1,2,81376),-- Iron Ore
(20601,1880,1,1,2,8138),-- Steel
(20601,2199,1,1,2,3433),-- Recipe: Karmian Stockings
(20601,5269,1,1,2,271),-- Recipe: Greater Soulshot (C) Compressed Package(100%)
(20601,5550,1,1,2,1085),-- Durable Metal Plate
(20602,1873,1,1,-1,525391),-- Silver Nugget
(20602,1889,1,1,-1,87565),-- Compound Braid
(20602,2999,1,1,-1,88153),-- Recipe: Plated Leather Gloves
(20602,57,529,1069,0,700000),-- Adena
(20602,280,1,1,1,48),-- Light Crossbow
(20602,2054,1,1,1,2806),-- Light Crossbow Shaft
(20602,1868,1,1,2,164892),-- Thread
(20602,1873,1,1,2,32978),-- Silver Nugget
(20602,1876,1,1,2,16489),-- Mithril Ore
(20602,1895,1,1,2,23556),-- Metallic Fiber
(20602,2205,1,1,2,2609),-- Recipe: Chain Gaiters
(20602,2300,1,1,2,360),-- Recipe: Scythe
(20602,2311,1,1,2,360),-- Recipe: Chakram
(20602,5154,1,1,2,275),-- Recipe: Soulshot (C) Compressed Package (100%)
(20603,1872,1,3,-1,723055),-- Animal Bone
(20603,1952,1,1,-1,34740),-- Salamander Skin Mail Texture
(20603,2311,1,1,-1,4736),-- Recipe: Chakram
(20603,57,429,871,0,700000),-- Adena
(20603,61,1,1,1,121),-- Mithril Gloves
(20603,607,1,1,1,121),-- Ogre Power Gauntlets
(20603,1125,1,1,1,121),-- Assault Boots
(20603,1949,1,1,1,5066),-- Mithril Gloves Design
(20603,1957,1,1,1,5066),-- Assault Boots Part
(20603,1963,1,1,1,5066),-- Ogre Power Gauntlets Part
(20603,2427,1,1,1,121),-- Salamander Skin Boots
(20603,2428,1,1,1,121),-- Plate Boots
(20603,2451,1,1,1,121),-- Sage\'s Worn Gloves
(20603,2931,1,1,1,5066),-- Salamander Skin Boot Lining
(20603,2932,1,1,1,5066),-- Plate Boots Design
(20603,2933,1,1,1,5066),-- Sage\'s Worn Gloves Lining
(20603,1867,1,1,2,103738),-- Animal Skin
(20603,1872,1,1,2,103738),-- Animal Bone
(20603,1875,1,1,2,5187),-- Stone of Purity
(20603,1881,1,1,2,10374),-- Coarse Bone Powder
(20603,2991,1,1,2,6175),-- Recipe: Karmian Boots
(20603,5279,1,1,2,259),-- Recipe: Greater Blessed Spiritshot (C) Compressed Package(100%)
(20603,6668,1,1,2,27787),-- Deluxe Chest Key - Grade 4
(20604,2322,1,1,-1,4611),-- Recipe: Soulfire Dirk
(20604,2323,1,1,-1,4611),-- Recipe: Elemental Bow
(20604,4553,1,1,-1,5293),-- Greater Dye of Strength <Str+1 Con-1>
(20604,57,521,1068,0,700000),-- Adena
(20604,852,1,1,1,175),-- Moonstone Earring
(20604,883,1,1,1,262),-- Aquastone Ring
(20604,915,1,1,1,131),-- Aquastone Necklace
(20604,1908,1,1,1,9871),-- Moonstone Earring Wire
(20604,1909,1,1,1,14077),-- Aquastone Ring Wire
(20604,1910,1,1,1,7849),-- Aquastone Necklace Chain
(20604,1867,1,1,2,119127),-- Animal Skin
(20604,1872,1,1,2,119127),-- Animal Bone
(20604,1875,1,1,2,5956),-- Stone of Purity
(20604,1881,1,1,2,11913),-- Coarse Bone Powder
(20604,2991,1,1,2,7091),-- Recipe: Karmian Boots
(20604,5279,1,1,2,298),-- Recipe: Greater Blessed Spiritshot (C) Compressed Package(100%)
(20604,6668,1,1,2,31909),-- Deluxe Chest Key - Grade 4
(20605,1867,1,3,-1,800154),-- Animal Skin
(20605,1908,1,1,-1,113658),-- Moonstone Earring Wire
(20605,2059,1,1,-1,8915),-- Flamberge Blade
(20605,57,475,964,0,700000),-- Adena
(20605,439,1,1,1,97),-- Karmian Tunic
(20605,471,1,1,1,156),-- Karmian Stockings
(20605,1954,1,1,1,7540),-- Karmian Stocking Design
(20605,1962,1,1,1,4538),-- Karmian Tunic Pattern
(20605,1868,1,1,2,103136),-- Thread
(20605,1873,1,1,2,20627),-- Silver Nugget
(20605,1889,1,1,2,3438),-- Compound Braid
(20605,2214,1,1,2,1280),-- Recipe: Dwarven Chain Gaiters
(20605,3003,1,1,2,3203),-- Recipe: Gloves of Seal
(20605,4044,1,1,2,1719),-- Thons
(20605,5549,1,1,2,5157),-- Metallic Thread
(20605,8723,1,1,200,2063),-- Life Stone: level 46
(20605,8733,1,1,200,516),-- Mid-Grade Life Stone: level 46
(20605,8743,1,1,200,52),-- High-Grade Life Stone: level 46
(20605,8753,1,1,200,10),-- Top-Grade Life Stone: level 46
(20606,1932,1,1,-1,125162),-- Bone Helmet Design
(20606,2152,1,1,-1,138824),-- Recipe: Enchanted Necklace
(20606,2260,1,1,-1,12244),-- Recipe: Mace of Judgment
(20606,57,340,656,0,700000),-- Adena
(20606,220,1,1,1,281),-- Crafted Dagger
(20606,1864,1,1,2,177016),-- Stem
(20606,1869,1,1,2,88508),-- Iron Ore
(20606,1880,1,1,2,8851),-- Steel
(20606,2262,1,1,2,1374),-- Recipe: Elven Bow
(20606,5550,1,1,2,1180),-- Durable Metal Plate
(20607,626,1,1,-1,9809),-- Bronze Shield
(20607,1899,1,1,-1,129508),-- Necklace of Devotion Chain
(20607,2020,1,1,-1,14509),-- Temptation of Abyss Piece
(20607,57,355,696,0,700000),-- Adena
(20607,101,1,1,1,59),-- Scroll of Wisdom
(20607,312,1,1,1,59),-- Branch of Life
(20607,313,1,1,1,59),-- Temptation of Abyss
(20607,314,1,1,1,59),-- Proof of Revenge
(20607,2020,1,1,1,1629),-- Temptation of Abyss Piece
(20607,1865,1,1,2,116294),-- Varnish
(20607,1870,1,1,2,116294),-- Coal
(20607,1874,1,1,2,7753),-- Oriharukon Ore
(20607,2262,1,1,2,1805),-- Recipe: Elven Bow
(20608,1874,1,1,-1,55672),-- Oriharukon Ore
(20608,2022,1,1,-1,13008),-- Mace of Judgment Head
(20608,2153,1,1,-1,129874),-- Recipe: Tiger\'s Eye Earring
(20608,57,354,701,0,700000),-- Adena
(20608,315,1,1,1,184),-- Divine Tome
(20608,1867,1,1,2,86922),-- Animal Skin
(20608,1872,1,1,2,86922),-- Animal Bone
(20608,1875,1,1,2,4346),-- Stone of Purity
(20608,1881,1,1,2,8692),-- Coarse Bone Powder
(20608,2189,1,1,2,2910),-- Recipe: Mithril Tunic
(20608,2265,1,1,2,674),-- Recipe: Spiked Club
(20608,2274,1,1,2,466),-- Recipe: Skull Breaker
(20609,433,1,1,-1,2256),-- Elven Tunic
(20609,1900,1,1,-1,94887),-- Enchanted Necklace Chain
(20609,2265,1,1,-1,8969),-- Recipe: Spiked Club
(20609,57,366,732,0,700000),-- Adena
(20609,259,1,1,1,191),-- Single-Edged Jamadhr
(20609,956,1,1,2,2633),-- Scroll: Enchant Armor (Grade D)
(20609,1866,1,1,2,52658),-- Suede
(20609,1871,1,1,2,78988),-- Charcoal
(20609,1885,1,1,2,6582),-- High Grade Suede
(20609,5220,1,1,2,3160),-- Metal Hardener
(20609,6667,1,1,2,49367),-- Deluxe Chest Key - Grade 3
(20610,1864,1,3,-1,874300),-- Stem
(20610,2025,1,1,-1,12109),-- Dwarven Trident Edge
(20610,2267,1,1,-1,9041),-- Recipe: Gastraphetes
(20610,57,370,737,0,700000),-- Adena
(20610,292,1,1,1,193),-- Pike
(20610,1341,20,60,2,99536),-- Bone Arrow
(20610,1864,1,1,2,119443),-- Stem
(20610,1865,1,1,2,59721),-- Varnish
(20610,1866,1,1,2,39814),-- Suede
(20610,1868,1,1,2,119443),-- Thread
(20610,1873,1,1,2,22889),-- Silver Nugget
(20610,2183,1,1,2,3929),-- Recipe: Mithril Banded Mail
(20610,2270,1,1,2,427),-- Recipe: Goat Head Staff
(20611,467,1,1,-1,3857),-- Dark Stockings
(20611,1884,1,1,-1,569592),-- Cord
(20611,2153,1,1,-1,143948),-- Recipe: Tiger\'s Eye Earring
(20611,57,390,782,0,700000),-- Adena
(20611,86,1,1,1,20),-- Tomahawk
(20611,179,1,1,1,20),-- Mace of Prayer
(20611,180,1,1,1,20),-- Mace of Judgment
(20611,181,1,1,1,20),-- Mace of Miracle
(20611,182,1,1,1,20),-- Doom Hammer
(20611,183,1,1,1,20),-- Mystic Staff
(20611,184,1,1,1,20),-- Conjuror\'s Staff
(20611,185,1,1,1,20),-- Staff of Mana
(20611,2022,1,1,1,788),-- Mace of Judgment Head
(20611,2023,1,1,1,627),-- Conjuror\'s Staff Head
(20611,1829,1,1,2,28903),-- Scroll of Escape: Clan Hall
(20611,1834,1,1,2,80285),-- Emergency Dressing
(20611,1864,1,1,2,144514),-- Stem
(20611,1869,1,1,2,72257),-- Iron Ore
(20611,1878,1,1,2,28903),-- Braided Hemp
(20611,1884,1,1,2,44466),-- Cord
(20611,2193,1,1,2,9673),-- Recipe: Boots of Power
(20612,349,1,1,-1,1496),-- Compound Scale Mail
(20612,1869,1,3,-1,527615),-- Iron Ore
(20612,1885,1,1,-1,87936),-- High Grade Suede
(20612,57,446,892,0,700000),-- Adena
(20612,436,1,1,1,480),-- Tunic of Knowledge
(20612,469,1,1,1,766),-- Stockings of Knowledge
(20612,1832,1,1,2,89057),-- Greater Antidote
(20612,1866,1,1,2,53434),-- Suede
(20612,1871,1,1,2,80151),-- Charcoal
(20612,1885,1,1,2,6679),-- High Grade Suede
(20612,2188,1,1,2,5725),-- Recipe: Manticore Skin Gaiters
(20612,2274,1,1,2,572),-- Recipe: Skull Breaker
(20612,5220,1,1,2,3206),-- Metal Hardener
(20613,40,1,1,-1,9795),-- Leather Boots
(20613,1899,1,1,-1,123206),-- Necklace of Devotion Chain
(20613,1934,1,1,-1,103074),-- Crafted Leather Gloves Lining
(20613,57,340,656,0,700000),-- Adena
(20613,432,1,1,1,918),-- Cursed Tunic
(20613,465,1,1,1,1470),-- Cursed Stockings
(20613,1831,1,3,2,84294),-- Antidote
(20613,1864,1,1,2,126440),-- Stem
(20613,1865,1,1,2,63220),-- Varnish
(20613,1866,1,1,2,42147),-- Suede
(20613,1868,1,1,2,126440),-- Thread
(20613,1873,1,1,2,25288),-- Silver Nugget
(20613,2263,1,1,2,982),-- Recipe: Dwarven Trident
(20614,1869,1,1,-1,774589),-- Iron Ore
(20614,1899,1,1,-1,121030),-- Necklace of Devotion Chain
(20614,2152,1,1,-1,136371),-- Recipe: Enchanted Necklace
(20614,57,332,650,0,700000),-- Adena
(20614,220,1,1,1,276),-- Crafted Dagger
(20614,1834,1,1,2,96605),-- Emergency Dressing
(20614,1865,1,1,2,86945),-- Varnish
(20614,1870,1,1,2,86945),-- Coal
(20614,1874,1,1,2,5796),-- Oriharukon Ore
(20614,2263,1,1,2,1350),-- Recipe: Dwarven Trident
(20615,392,1,1,-1,2324),-- Lion Skin Shirt
(20615,1900,1,1,-1,97766),-- Enchanted Necklace Chain
(20615,2185,1,1,-1,175902),-- Recipe: Iron Boots
(20615,57,379,750,0,700000),-- Adena
(20615,46,1,1,1,1272),-- Bronze Helmet
(20615,627,1,1,1,1815),-- Aspis
(20615,1834,1,1,2,77510),-- Emergency Dressing
(20615,1875,1,1,2,4651),-- Stone of Purity
(20615,1879,1,1,2,11627),-- Cokes
(20615,1885,1,1,2,5813),-- High Grade Suede
(20615,2266,1,1,2,721),-- Recipe: Shilen Knife
(20615,5549,1,1,2,6976),-- Metallic Thread
(20615,5550,1,1,2,930),-- Durable Metal Plate
(20616,1874,1,1,-1,61682),-- Oriharukon Ore
(20616,1937,1,1,-1,79487),-- Scale Gaiters Fragment
(20616,2153,1,1,-1,143893),-- Recipe: Tiger\'s Eye Earring
(20616,57,390,781,0,700000),-- Adena
(20616,433,1,1,1,164),-- Elven Tunic
(20616,434,1,1,1,164),-- White Tunic
(20616,435,1,1,1,164),-- Mystic\'s Tunic
(20616,466,1,1,1,263),-- Elven Stockings
(20616,467,1,1,1,263),-- Dark Stockings
(20616,468,1,1,1,263),-- Mystic\'s Stockings
(20616,1933,1,1,1,7436),-- Dark Stocking Fabric
(20616,1936,1,1,1,5172),-- White Tunic Pattern
(20616,737,1,1,2,6320),-- Scroll of Resurrection
(20616,1867,1,1,2,84267),-- Animal Skin
(20616,1872,1,1,2,84267),-- Animal Bone
(20616,1875,1,1,2,4213),-- Stone of Purity
(20616,1881,1,1,2,8427),-- Coarse Bone Powder
(20616,2274,1,1,2,452),-- Recipe: Skull Breaker
(20616,2976,1,1,2,8461),-- Recipe: Manticore Skin Boots
(20616,6667,1,1,2,39500),-- Deluxe Chest Key - Grade 3
(20617,435,1,1,-1,2296),-- Mystic\'s Tunic
(20617,1875,1,1,-1,58864),-- Stone of Purity
(20617,1933,1,1,-1,103877),-- Dark Stocking Fabric
(20617,57,373,744,0,700000),-- Adena
(20617,392,1,1,1,628),-- Lion Skin Shirt
(20617,414,1,1,1,1005),-- Lion Skin Gaiters
(20617,1867,1,1,2,128667),-- Animal Skin
(20617,1872,1,1,2,128667),-- Animal Bone
(20617,1875,1,1,2,6433),-- Stone of Purity
(20617,1881,1,1,2,12867),-- Coarse Bone Powder
(20617,2184,1,1,2,10136),-- Recipe: Mithril Banded Gaiters
(20618,955,1,1,-1,3901),-- Scroll: Enchant Weapon (Grade D)
(20618,1885,1,1,-1,81279),-- High Grade Suede
(20618,1935,1,1,-1,54489),-- Scale Mail Fragment
(20618,57,411,824,0,700000),-- Adena
(20618,315,1,1,1,215),-- Divine Tome
(20618,1875,1,1,2,5922),-- Stone of Purity
(20618,1879,1,1,2,14805),-- Cokes
(20618,1885,1,1,2,7403),-- High Grade Suede
(20618,2153,1,1,2,13815),-- Recipe: Tiger\'s Eye Earring
(20618,5549,1,1,2,8883),-- Metallic Thread
(20618,5550,1,1,2,1184),-- Durable Metal Plate
(20619,1867,1,3,-1,557594),-- Animal Skin
(20619,2270,1,1,-1,7153),-- Recipe: Goat Head Staff
(20619,2981,1,1,-1,134055),-- Recipe: Elven Mithril Gloves
(20619,57,423,846,0,700000),-- Adena
(20619,157,1,1,1,48),-- Spiked Club
(20619,186,1,1,1,48),-- Staff of Magic
(20619,2027,1,1,1,2325),-- Spiked Club Head
(20619,1867,1,1,2,118318),-- Animal Skin
(20619,1872,1,1,2,118318),-- Animal Bone
(20619,1875,1,1,2,5916),-- Stone of Purity
(20619,1881,1,1,2,11832),-- Coarse Bone Powder
(20619,2154,1,1,2,9501),-- Recipe: Elven Earring
(20619,2278,1,1,2,634),-- Recipe: Strengthened Long Bow
(20620,948,1,1,-1,13180),-- Scroll: Enchant Armor (Grade B)
(20620,4039,1,1,-1,175735),-- Mold Glue
(20620,4051,1,1,-1,204462),-- Adamantite Necklace Chain
(20620,57,2089,4237,0,700000),-- Adena
(20620,78,1,1,1,8),-- Great Sword
(20620,142,1,1,1,8),-- Keshanberk
(20620,148,1,1,1,8),-- Sword of Valhalla
(20620,4104,1,1,1,1485),-- Great Sword Blade
(20620,4107,1,1,1,1462),-- Keshanberk Blade
(20620,4108,1,1,1,1462),-- Sword of Valhalla Blade
(20620,1894,1,1,2,4967),-- Crafted Leather
(20620,4039,1,1,2,4719),-- Mold Glue
(20620,4041,1,1,2,1231),-- Mold Hardener
(20620,4044,1,1,2,4719),-- Thons
(20620,4402,1,1,2,283),-- Blue Dimensional Stone
(20620,4614,1,1,2,195),-- Greater Dye of Strength <Str+4 Dex-4>
(20620,4999,1,1,2,1761),-- Recipe: Doom Boots (60%)
(20620,8728,1,1,200,2360),-- Life Stone: level 61
(20620,8738,1,1,200,590),-- Mid-Grade Life Stone: level 61
(20620,8748,1,1,200,59),-- High-Grade Life Stone: level 61
(20620,8758,1,1,200,12),-- Top-Grade Life Stone: level 61
(20621,4052,1,1,-1,201691),-- Earring of Black Ore Piece
(20621,4199,1,1,-1,4349),-- Recipe: Bow of Peril
(20621,5230,1,1,-1,7596),-- Recipe: Mithril Arrow (100%)
(20621,57,2259,4576,0,700000),-- Adena
(20621,2391,1,1,1,28),-- Blue Wolf Leather Armor
(20621,2392,1,1,1,28),-- Leather Armor of Doom
(20621,4082,1,1,1,4754),-- Blue Wolf Leather Armor Texture
(20621,4083,1,1,1,4754),-- Leather Armor of Doom Design
(20621,1868,1,1,2,305952),-- Thread
(20621,1873,1,1,2,61190),-- Silver Nugget
(20621,1876,1,1,2,30595),-- Mithril Ore
(20621,1895,1,1,2,43707),-- Metallic Fiber
(20621,4042,1,1,2,2550),-- Enria
(20621,4623,1,1,2,211),-- Greater Dye of Wit <Wit+4 Int-4>
(20621,5276,1,1,2,204),-- Recipe: Greater Spiritshot (A) Compressed Package(100%)
(20621,8729,1,1,200,2040),-- Life Stone: level 64
(20621,8739,1,1,200,510),-- Mid-Grade Life Stone: level 64
(20621,8749,1,1,200,51),-- High-Grade Life Stone: level 64
(20621,8759,1,1,200,10),-- Top-Grade Life Stone: level 64
(20622,4042,1,1,-1,101646),-- Enria
(20622,4044,1,1,-1,203292),-- Thons
(20622,4053,1,1,-1,261413),-- Ring of Black Ore Gemstone
(20622,57,2419,4898,0,700000),-- Adena
(20622,864,1,1,1,84),-- Earring of Black Ore
(20622,895,1,1,1,127),-- Ring of Black Ore
(20622,926,1,1,1,63),-- Necklace of Black Ore
(20622,4052,1,1,1,10629),-- Earring of Black Ore Piece
(20622,4053,1,1,1,12869),-- Ring of Black Ore Gemstone
(20622,4054,1,1,1,5913),-- Necklace of Black Ore Beads
(20622,1867,1,1,2,200165),-- Animal Skin
(20622,1872,1,1,2,200165),-- Animal Bone
(20622,1882,1,1,2,33361),-- Leather
(20622,1894,1,1,2,5267),-- Crafted Leather
(20622,4042,1,1,2,2502),-- Enria
(20622,4401,1,1,2,300),-- Green Dimensional Stone
(20622,4988,1,1,2,994),-- Recipe: Blue Wolf Stockings (60%)
(20622,6670,1,1,2,25021),-- Deluxe Chest Key - Grade 6
(20622,8729,1,1,200,2002),-- Life Stone: level 64
(20622,8739,1,1,200,500),-- Mid-Grade Life Stone: level 64
(20622,8749,1,1,200,50),-- High-Grade Life Stone: level 64
(20622,8759,1,1,200,10),-- Top-Grade Life Stone: level 64
(20623,4039,1,1,-1,271715),-- Mold Glue
(20623,4040,1,1,-1,163029),-- Mold Lubricant
(20623,5230,1,1,-1,10869),-- Recipe: Mithril Arrow (100%)
(20623,57,3236,6545,0,700000),-- Adena
(20623,110,1,1,1,124),-- Doom Shield
(20623,2416,1,1,1,86),-- Blue Wolf Helmet
(20623,2417,1,1,1,86),-- Doom Helmet
(20623,4077,1,1,1,18054),-- Doom Shield Fragment
(20623,4088,1,1,1,15168),-- Blue Wolf Helmet Design
(20623,4089,1,1,1,15168),-- Doom Helmet Pattern
(20623,1868,1,3,2,218892),-- Thread
(20623,1873,1,1,2,87557),-- Silver Nugget
(20623,1889,1,1,2,14593),-- Compound Braid
(20623,4044,1,1,2,7296),-- Thons
(20623,4177,1,1,2,4217),-- Recipe: Zubei\'s Gauntlets
(20623,5332,1,1,2,631),-- Recipe: Sealed Dark Crystal Leather Armor(60%)
(20623,5549,1,1,2,21889),-- Metallic Thread
(20623,8729,1,1,200,2919),-- Life Stone: level 64
(20623,8739,1,1,200,729),-- Mid-Grade Life Stone: level 64
(20623,8749,1,1,200,73),-- High-Grade Life Stone: level 64
(20623,8759,1,1,200,15),-- Top-Grade Life Stone: level 64
(20624,1877,1,1,-1,332612),-- Adamantite Nugget
(20624,4052,1,1,-1,294399),-- Earring of Black Ore Piece
(20624,4054,1,1,-1,163784),-- Necklace of Black Ore Beads
(20624,57,3295,6681,0,700000),-- Adena
(20624,79,1,1,1,8),-- Sword of Damascus
(20624,7889,1,1,1,8),-- Wizard\'s Tear
(20624,7883,1,1,1,8),-- Guardian Sword
(20624,4114,1,1,1,1792),-- Sword of Damascus Blade
(20624,8336,1,1,1,1792),-- Blade of the Wizard\'s Tear
(20624,8330,1,1,1,1789),-- Guardian Sword Blade
(20624,1868,1,3,2,188939),-- Thread
(20624,1873,1,1,2,75576),-- Silver Nugget
(20624,1876,1,1,2,37788),-- Mithril Ore
(20624,1895,1,1,2,53983),-- Metallic Fiber
(20624,4042,1,1,2,3149),-- Enria
(20624,4154,1,1,2,2236),-- Recipe: Doom Shield
(20624,5340,1,1,2,871),-- Recipe: Sealed Dark Crystalline Leggings(60%)
(20624,4403,1,1,2,378),-- Red Dimensional Stone
(20624,5281,1,1,2,252),-- Recipe: Greater Blessed Spiritshot (A) Compressed Package(100%)
(20624,8729,1,1,200,2519),-- Life Stone: level 64
(20624,8739,1,1,200,630),-- Mid-Grade Life Stone: level 64
(20624,8749,1,1,200,63),-- High-Grade Life Stone: level 64
(20624,8759,1,1,200,12),-- Top-Grade Life Stone: level 64
(20625,4043,1,1,-1,277527),-- Asofe
(20625,4044,1,1,-1,277527),-- Thons
(20625,5230,1,1,-1,11101),-- Recipe: Mithril Arrow (100%)
(20625,57,3298,6689,0,700000),-- Adena
(20625,268,1,1,1,24),-- Bellion Cestus
(20625,4120,1,1,1,5274),-- Bellion Cestus Edge
(20625,8336,1,1,1,52),-- Blade of the Wizard\'s Tear
(20625,8330,1,1,1,104),-- Guardian Sword Blade
(20625,1894,1,1,2,8629),-- Crafted Leather
(20625,4039,1,1,2,8198),-- Mold Glue
(20625,4041,1,1,2,2139),-- Mold Hardener
(20625,4044,1,1,2,8198),-- Thons
(20625,4192,1,1,2,188),-- Recipe: Sword of Damascus
(20625,8729,1,1,200,3279),-- Life Stone: level 64
(20625,8739,1,1,200,820),-- Mid-Grade Life Stone: level 64
(20625,8749,1,1,200,82),-- High-Grade Life Stone: level 64
(20625,8759,1,1,200,16),-- Top-Grade Life Stone: level 64
(20625,5276,1,1,2,328); -- Recipe: Greater Spiritshot (A) Compressed Package(100%)

INSERT INTO `droplist` VALUES 
(20626,1875,1,1,-1,685963),-- Stone of Purity
(20626,4053,1,1,-1,441039),-- Ring of Black Ore Gemstone
(20626,5230,1,1,-1,13719),-- Recipe: Mithril Arrow (100%)
(20626,57,4056,8290,0,700000),-- Adena
(20626,358,1,1,1,41),-- Blue Wolf Breastplate
(20626,2380,1,1,1,65),-- Blue Wolf Gaiters
(20626,2381,1,1,1,25),-- Doom Plate Armor
(20626,4078,1,1,1,7400),-- Blue Wolf Breastplate Part
(20626,4080,1,1,1,10421),-- Blue Wolf Gaiters Material
(20626,4081,1,1,1,4993),-- Doom Plate Armor Temper
(20626,1867,1,3,2,112568),-- Animal Skin
(20626,1872,1,3,2,168853),-- Animal Bone
(20626,1875,1,1,2,16885),-- Stone of Purity
(20626,1881,1,1,2,33771),-- Coarse Bone Powder
(20626,4041,1,1,2,2202),-- Mold Hardener
(20626,5334,1,1,2,499),-- Recipe: Sealed Tallum Leather Armor(60%)
(20626,4402,1,1,2,506),-- Blue Dimensional Stone
(20626,4615,1,1,2,349),-- Greater Dye of Constitution <Con+4 Str-4>
(20626,8730,1,1,200,2814),-- Life Stone: level 67
(20626,8740,1,1,200,704),-- Mid-Grade Life Stone: level 67
(20626,8750,1,1,200,70),-- High-Grade Life Stone: level 67
(20626,8760,1,1,200,14),-- Top-Grade Life Stone: level 67
(20627,1877,1,1,-1,413122),-- Adamantite Nugget
(20627,5478,1,2,-1,86849),-- Sealed Dark Crystal Leather Armor Pattern
(20627,57,4085,8305,0,700000),-- Adena
(20627,5290,1,1,1,86),-- Sealed Dark Crystal Gloves
(20627,5291,1,1,1,86),-- Sealed Dark Crystal Boots
(20627,5295,1,1,1,86),-- Sealed Tallum Gloves
(20627,5296,1,1,1,86),-- Sealed Tallum Boots
(20627,5496,1,1,1,8943),-- Sealed Dark Crystal Boots Lining
(20627,5497,1,1,1,8943),-- Sealed Tallum Boots Lining
(20627,5508,1,1,1,8943),-- Sealed Dark Crystal Gloves Design
(20627,5509,1,1,1,8943),-- Sealed Tallum Gloves Design
(20627,1866,1,1,2,169486),-- Suede
(20627,1871,1,1,2,254229),-- Charcoal
(20627,1877,1,1,2,10169),-- Adamantite Nugget
(20627,3956,1,1,2,339),-- Recipe: Blessed Spiritshot A
(20627,4040,1,1,2,5084),-- Mold Lubricant
(20627,4041,1,1,2,2211),-- Mold Hardener
(20627,4973,1,1,2,2751),-- Recipe: Earring of Black Ore (70%)
(20627,6670,1,1,2,42371),-- Deluxe Chest Key - Grade 6
(20627,8730,1,1,200,2825),-- Life Stone: level 67
(20627,8740,1,1,200,706),-- Mid-Grade Life Stone: level 67
(20627,8750,1,1,200,71),-- High-Grade Life Stone: level 67
(20627,8760,1,1,200,15),-- Top-Grade Life Stone: level 67
(20628,1807,1,1,-1,14876),-- Recipe: Soulshot: A-Grade
(20628,1895,1,7,-1,796908),-- Metallic Fiber
(20628,5479,1,1,-1,66016),-- Sealed Tallum Leather Armor Pattern
(20628,57,4416,8967,0,700000),-- Adena
(20628,5304,1,1,1,41),-- Sealed Tallum Tunic
(20628,5305,1,1,1,66),-- Sealed Tallum Stockings
(20628,5308,1,1,1,25),-- Sealed Dark Crystal Robe
(20628,5485,1,1,1,4618),-- Sealed Tallum Tunic Texture
(20628,5486,1,1,1,3250),-- Sealed Dark Crystal Robe Fabric
(20628,5489,1,1,1,7249),-- Sealed Tallum Stockings Fabric
(20628,1895,1,1,2,94158),-- Metallic Fiber
(20628,4040,1,1,2,6591),-- Mold Lubricant
(20628,4042,1,1,2,5493),-- Enria
(20628,4043,1,1,2,10985),-- Asofe
(20628,4401,1,1,2,659),-- Green Dimensional Stone
(20628,4988,1,1,2,2182),-- Recipe: Blue Wolf Stockings (60%)
(20628,8730,1,1,200,3662),-- Life Stone: level 67
(20628,8740,1,1,200,915),-- Mid-Grade Life Stone: level 67
(20628,8750,1,1,200,92),-- High-Grade Life Stone: level 67
(20628,8760,1,1,200,18),-- Top-Grade Life Stone: level 67
(20629,3035,1,1,-1,17470),-- Recipe: Spiritshot A
(20629,4077,1,1,-1,589396),-- Doom Shield Fragment
(20629,4078,1,1,-1,191386),-- Blue Wolf Breastplate Part
(20629,57,5182,10542,0,700000),-- Adena
(20629,5289,1,1,1,97),-- Sealed Dark Crystal Helmet
(20629,5292,1,1,1,138),-- Sealed Dark Crystal Shield
(20629,5294,1,1,1,97),-- Sealed Tallum Helmet
(20629,5494,1,1,1,13546),-- Sealed Dark Crystal Shield Fragment
(20629,5525,1,1,1,9970),-- Sealed Dark Crystal Helmet Design
(20629,5526,1,1,1,9970),-- Sealed Tallum Helm Design
(20629,1868,3,9,2,129007),-- Thread
(20629,1873,1,1,2,154808),-- Silver Nugget
(20629,1876,1,1,2,77404),-- Mithril Ore
(20629,1895,1,1,2,110578),-- Metallic Fiber
(20629,4042,1,1,2,6450),-- Enria
(20629,5006,1,1,2,295),-- Recipe: Bellion Cestus (60%)
(20629,8730,1,1,200,4300),-- Life Stone: level 67
(20629,8740,1,1,200,1075),-- Mid-Grade Life Stone: level 67
(20629,8750,1,1,200,107),-- High-Grade Life Stone: level 67
(20629,8760,1,1,200,22),-- Top-Grade Life Stone: level 67
(20630,1902,1,1,-1,92852),-- Elven Earring Beads
(20630,1943,1,1,-1,72792),-- Manticore Skin Gaiters Pattern
(20630,2291,1,1,-1,5091),-- Recipe: Scallop Jamadhr
(20630,57,383,764,0,700000),-- Adena
(20630,629,1,1,1,262),-- Kite Shield
(20630,1947,1,1,1,11368),-- Kite Shield Fragment
(20630,2411,1,1,1,183),-- Brigandine Helmet
(20630,2493,1,1,1,262),-- Brigandine Shield
(20630,2922,1,1,1,3041),-- Brigandine Helmet Design
(20630,2929,1,1,1,11368),-- Brigandine Shield Fragment
(20630,1866,1,1,2,45118),-- Suede
(20630,1871,1,1,2,67676),-- Charcoal
(20630,1885,1,1,2,5640),-- High Grade Suede
(20630,2286,1,1,2,376),-- Recipe: Bonebreaker
(20630,2987,1,1,2,6570),-- Recipe: Plate Shield
(20630,5220,1,1,2,2707),-- Metal Hardener
(20630,5472,1,1,2,4834),-- Recipe: Metallic Thread(100%)
(20631,1873,1,1,-1,501547),-- Silver Nugget
(20631,2996,1,1,-1,99513),-- Recipe: Chain Gloves
(20631,2998,1,1,-1,94276),-- Recipe: Chain Shield
(20631,57,508,1017,0,700000),-- Adena
(20631,61,1,1,1,140),-- Mithril Gloves
(20631,607,1,1,1,140),-- Ogre Power Gauntlets
(20631,1125,1,1,1,140),-- Assault Boots
(20631,1949,1,1,1,5856),-- Mithril Gloves Design
(20631,1957,1,1,1,5856),-- Assault Boots Part
(20631,1963,1,1,1,5856),-- Ogre Power Gauntlets Part
(20631,2427,1,1,1,140),-- Salamander Skin Boots
(20631,2428,1,1,1,140),-- Plate Boots
(20631,2451,1,1,1,140),-- Sage\'s Worn Gloves
(20631,2931,1,1,1,5856),-- Salamander Skin Boot Lining
(20631,2932,1,1,1,5856),-- Plate Boots Design
(20631,2933,1,1,1,5856),-- Sage\'s Worn Gloves Lining
(20631,1342,10,30,2,157409),-- Fine Steel Arrow
(20631,1868,1,1,2,157409),-- Thread
(20631,1873,1,1,2,31482),-- Silver Nugget
(20631,1889,1,1,2,5247),-- Compound Braid
(20631,2203,1,1,2,17144),-- Recipe: Mithril Boots
(20631,5164,1,1,2,262),-- Recipe: Blessed Spiritshot (C) Compressed Package (100%)
(20631,5274,1,1,2,262),-- Recipe: Greater Spiritshot (C) Compressed Package(100%)
(20631,5549,1,1,2,7871),-- Metallic Thread
(20632,1873,1,1,-1,499421),-- Silver Nugget
(20632,1880,1,1,-1,124855),-- Steel
(20632,1951,1,1,-1,63026),-- Plate Gaiters Part
(20632,57,503,1016,0,700000),-- Adena
(20632,353,1,1,1,104),-- Half Plate Armor
(20632,380,1,1,1,167),-- Plate Gaiters
(20632,1950,1,1,1,5088),-- Half Plate Temper
(20632,1951,1,1,1,7913),-- Plate Gaiters Part
(20632,1864,1,1,2,156741),-- Stem
(20632,1869,1,1,2,78371),-- Iron Ore
(20632,1880,1,1,2,7837),-- Steel
(20632,2205,1,1,2,2480),-- Recipe: Chain Gaiters
(20632,2301,1,1,2,342),-- Recipe: Battle Axe
(20632,5274,1,1,2,261),-- Recipe: Greater Spiritshot (C) Compressed Package(100%)
(20632,5550,1,1,2,1045),-- Durable Metal Plate
(20632,6668,1,1,2,27990),-- Deluxe Chest Key - Grade 4
(20633,2212,1,1,-1,43920),-- Recipe: Plated Leather Gaiters
(20633,2313,1,1,-1,5351),-- Recipe: Orcish Glaive
(20633,4469,1,1,-1,7002),-- Dye of Strength <Str+1 Con-1>
(20633,57,485,984,0,700000),-- Adena
(20633,851,1,1,1,220),-- Omen Beast\'s Eye Earring
(20633,882,1,1,1,330),-- Mithril Ring
(20633,914,1,1,1,165),-- Necklace of Darkness
(20633,1905,1,1,1,9976),-- Omen Beast\'s Eye Earring Gemstone
(20633,1906,1,1,1,14097),-- Mithril Ring Wire
(20633,1907,1,1,1,7134),-- Necklace of Darkness Gem
(20633,1868,1,1,2,175808),-- Thread
(20633,1873,1,1,2,35162),-- Silver Nugget
(20633,1876,1,1,2,17581),-- Mithril Ore
(20633,1895,1,1,2,25115),-- Metallic Fiber
(20633,2211,1,1,2,1971),-- Recipe: Plated Leather Armor
(20633,2992,1,1,2,6976),-- Recipe: Plated Leather Boots
(20633,5159,1,1,2,293),-- Recipe: Spiritshot (C) Compressed Package (100%)
(20634,1880,1,1,-1,234850),-- Steel
(20634,1908,1,1,-1,222396),-- Moonstone Earring Wire
(20634,2213,1,1,-1,36467),-- Recipe: Dwarven Chain Mail Shirt
(20634,57,925,1895,0,700000),-- Adena
(20634,354,1,1,1,143),-- Chain Mail Shirt
(20634,381,1,1,1,228),-- Chain Gaiters
(20634,1959,1,1,1,7474),-- Chain Mail Shirt Material
(20634,1960,1,1,1,15204),-- Chain Gaiters Part
(20634,1867,1,1,2,123326),-- Animal Skin
(20634,1872,1,1,2,123326),-- Animal Bone
(20634,1875,1,1,2,6166),-- Stone of Purity
(20634,1881,1,1,2,12333),-- Coarse Bone Powder
(20634,2215,1,1,2,1178),-- Recipe: Robe of Seal
(20634,2225,1,1,2,2011),-- Recipe: Demon\'s Stockings
(20634,2251,1,1,2,15416),-- Recipe: Steel Arrow
(20634,2321,1,1,2,322),-- Recipe: Stiletto
(20634,8723,1,1,200,3700),-- Life Stone: level 46
(20634,8733,1,1,200,925),-- Mid-Grade Life Stone: level 46
(20634,8743,1,1,200,92),-- High-Grade Life Stone: level 46
(20634,8753,1,1,200,18),-- Top-Grade Life Stone: level 46
(20635,1959,1,1,-1,32009),-- Chain Mail Shirt Material
(20635,2163,1,1,-1,60630),-- Recipe: Earring of Protection
(20635,2215,1,1,-1,15138),-- Recipe: Robe of Seal
(20635,57,470,955,0,700000),-- Adena
(20635,263,1,1,1,32),-- Chakram
(20635,2073,1,1,1,2170),-- Chakram Edge
(20635,1866,1,1,2,34038),-- Suede
(20635,1871,1,1,2,51058),-- Charcoal
(20635,1885,1,1,2,4255),-- High Grade Suede
(20635,3002,1,1,2,3171),-- Recipe: Dwarven Chain Gloves
(20635,3004,1,1,2,3171),-- Recipe: Rind Leather Gloves
(20635,4041,1,1,2,444),-- Mold Hardener
(20635,5220,1,1,2,2042),-- Metal Hardener
(20635,8723,1,1,200,2042),-- Life Stone: level 46
(20635,8733,1,1,200,511),-- Mid-Grade Life Stone: level 46
(20635,8743,1,1,200,51),-- High-Grade Life Stone: level 46
(20635,8753,1,1,200,10),-- Top-Grade Life Stone: level 46
(20636,1909,1,1,-1,178638),-- Aquastone Ring Wire
(20636,2163,1,1,-1,67491),-- Recipe: Earring of Protection
(20636,2214,1,1,-1,32824),-- Recipe: Dwarven Chain Gaiters
(20636,57,521,1066,0,700000),-- Adena
(20636,89,1,1,1,4),-- Big Hammer
(20636,160,1,1,1,4),-- Battle Axe
(20636,161,1,1,1,4),-- Silver Axe
(20636,173,1,1,1,4),-- Skull Graver
(20636,191,1,1,1,4),-- Heavy Doom Hammer
(20636,192,1,1,1,4),-- Crystal Staff
(20636,193,1,1,1,4),-- Stick of Faith
(20636,194,1,1,1,4),-- Heavy Doom Axe
(20636,2061,1,1,1,302),-- Big Hammer Head
(20636,2063,1,1,1,302),-- Battle Axe Head
(20636,2064,1,1,1,302),-- Silver Axe Head
(20636,2065,1,1,1,302),-- Skull Graver Head
(20636,2066,1,1,1,307),-- Heavy Doom Hammer Head
(20636,2067,1,1,1,282),-- Crystal Staff Head
(20636,2068,1,1,1,282),-- Stick of Faith Shaft
(20636,2069,1,1,1,306),-- Heavy Doom Axe Blade
(20636,1867,1,1,2,75780),-- Animal Skin
(20636,1872,1,1,2,75780),-- Animal Bone
(20636,1882,1,1,2,12630),-- Leather
(20636,1894,1,1,2,1994),-- Crafted Leather
(20636,2230,1,1,2,1101),-- Recipe: Theca Leather Gaiters
(20636,2320,1,1,2,198),-- Recipe: Cursed Staff
(20636,4042,1,1,2,947),-- Enria
(20636,8723,1,1,200,2273),-- Life Stone: level 46
(20636,8733,1,1,200,568),-- Mid-Grade Life Stone: level 46
(20636,8743,1,1,200,57),-- High-Grade Life Stone: level 46
(20636,8753,1,1,200,11),-- Top-Grade Life Stone: level 46
(20637,440,1,1,-1,457),-- Robe of Seal
(20637,2337,1,1,-1,3209),-- Recipe: Stick of Eternity
(20637,2338,1,1,-1,3209),-- Recipe: Paradia Staff
(20637,57,545,1111,0,700000),-- Adena
(20637,1126,1,1,1,82),-- Crimson Boots
(20637,1974,1,1,1,4284),-- Crimson Boot Fabric
(20637,2434,1,1,1,82),-- Rind Leather Boots
(20637,2455,1,1,1,89),-- Plated Leather Gloves
(20637,2456,1,1,1,82),-- Dwarven Chain Gloves
(20637,2457,1,1,1,82),-- Gloves of Seal
(20637,2458,1,1,1,82),-- Rind Leather Gloves
(20637,2946,1,1,1,2847),-- Plate Leather Gloves Design
(20637,2948,1,1,1,4284),-- Rind Leather Boot Lining
(20637,2949,1,1,1,4284),-- Dwarven Chain Gloves Design
(20637,2950,1,1,1,4284),-- Gloves of Seal Pattern
(20637,2951,1,1,1,4284),-- Rind Leather Gloves Design
(20637,1539,1,1,2,11320),-- Greater Healing Potion
(20637,1864,1,1,2,101885),-- Stem
(20637,1869,1,1,2,50942),-- Iron Ore
(20637,1880,1,1,2,5094),-- Steel
(20637,2222,1,1,2,318),-- Recipe: Composite Armor
(20637,4043,1,1,2,1698),-- Asofe
(20637,5550,1,1,2,679),-- Durable Metal Plate
(20637,6668,1,1,2,18194),-- Deluxe Chest Key - Grade 4
(20637,8724,1,1,200,1698),-- Life Stone: level 49
(20637,8734,1,1,200,425),-- Mid-Grade Life Stone: level 49
(20637,8744,1,1,200,42),-- High-Grade Life Stone: level 49
(20637,8754,1,1,200,8),-- Top-Grade Life Stone: level 49
(20638,1873,1,1,-1,576200),-- Silver Nugget
(20638,1911,1,1,-1,107140),-- Earring of Protection Gemstone
(20638,2946,1,1,-1,80520),-- Plate Leather Gloves Design
(20638,57,570,1158,0,700000),-- Adena
(20638,282,1,1,1,14),-- Elemental Bow
(20638,285,1,1,1,14),-- Noble Elven Bow
(20638,2085,1,1,1,1104),-- Crossbow Shaft
(20638,2086,1,1,1,1104),-- Elven Bow of Nobility Shaft
(20638,952,1,1,2,655),-- Scroll: Enchant Armor (Grade C)
(20638,1867,1,1,2,65462),-- Animal Skin
(20638,1872,1,1,2,65462),-- Animal Bone
(20638,1882,1,1,2,10910),-- Leather
(20638,1894,1,1,2,1723),-- Crafted Leather
(20638,2338,1,1,2,114),-- Recipe: Paradia Staff
(20638,2351,1,1,2,103),-- Recipe: Scorpion
(20638,3005,1,1,2,2004),-- Recipe: Demon\'s Boots
(20638,4042,1,1,2,818),-- Enria
(20638,8724,1,1,200,1637),-- Life Stone: level 49
(20638,8734,1,1,200,409),-- Mid-Grade Life Stone: level 49
(20638,8744,1,1,200,41),-- High-Grade Life Stone: level 49
(20638,8754,1,1,200,8),-- Top-Grade Life Stone: level 49
(20639,951,1,1,-1,5510),-- Scroll: Enchant Weapon (Grade C)
(20639,2334,1,1,-1,7048),-- Recipe: Sword of Whispering Death
(20639,2342,1,1,-1,7048),-- Recipe: Club of Nature
(20639,57,1196,2440,0,700000),-- Adena
(20639,227,1,1,1,30),-- Stiletto
(20639,242,1,1,1,30),-- Soulfire Dirk
(20639,2083,1,1,1,2231),-- Stiletto Edge
(20639,2084,1,1,1,2231),-- Soulfire Dirk Blade
(20639,1868,1,1,2,223802),-- Thread
(20639,1873,1,1,2,44760),-- Silver Nugget
(20639,1889,1,1,2,7460),-- Compound Braid
(20639,2328,1,1,2,260),-- Recipe: Sword of Delusion
(20639,4044,1,1,2,3730),-- Thons
(20639,4132,1,1,2,4337),-- Recipe: Composite Shield
(20639,5549,1,1,2,11190),-- Metallic Thread
(20639,6668,1,1,2,39965),-- Deluxe Chest Key - Grade 4
(20639,8724,1,1,200,3730),-- Life Stone: level 49
(20639,8734,1,1,200,932),-- Mid-Grade Life Stone: level 49
(20639,8744,1,1,200,93),-- High-Grade Life Stone: level 49
(20639,8754,1,1,200,19),-- Top-Grade Life Stone: level 49
(20640,1539,1,1,-1,323580),-- Greater Healing Potion
(20640,1868,1,7,-1,728055),-- Thread
(20640,1870,1,3,-1,728055),-- Coal
(20640,57,576,1171,0,700000),-- Adena
(20640,283,1,1,1,18),-- Akat Long Bow
(20640,2109,1,1,1,1688),-- Akat Longbow Shaft
(20640,1865,1,1,2,46320),-- Varnish
(20640,1870,1,1,2,46320),-- Coal
(20640,1875,1,1,2,3088),-- Stone of Purity
(20640,1879,1,1,2,7720),-- Cokes
(20640,2233,1,1,2,433),-- Recipe: Divine Tunic
(20640,2970,1,1,2,1642),-- Recipe: Ring of Binding
(20640,3014,1,1,2,1294),-- Recipe: Full Plate Boots
(20640,4040,1,1,2,926),-- Mold Lubricant
(20640,6669,1,1,2,10772),-- Deluxe Chest Key - Grade 5
(20640,8725,1,1,200,1287),-- Life Stone: level 52
(20640,8735,1,1,200,322),-- Mid-Grade Life Stone: level 52
(20640,8745,1,1,200,32),-- High-Grade Life Stone: level 52
(20640,8755,1,1,200,6),-- Top-Grade Life Stone: level 52
(20641,2097,1,1,-1,9668),-- War Axe Blade
(20641,2355,1,1,-1,2944),-- Recipe: Ghoul\'s Staff
(20641,4042,1,1,-1,30082),-- Enria
(20641,57,715,1452,0,700000),-- Adena
(20641,854,1,1,1,110),-- Earring of Binding
(20641,885,1,1,1,165),-- Ring of Ages
(20641,917,1,1,1,82),-- Necklace of Mermaid
(20641,1914,1,1,1,6988),-- Earring of Binding Gemstone
(20641,1915,1,1,1,10959),-- Ring of Ages Gemstone
(20641,1916,1,1,1,5293),-- Necklace of Mermaid Teardrop
(20641,1867,1,1,2,82934),-- Animal Skin
(20641,1872,1,1,2,82934),-- Animal Bone
(20641,1882,1,1,2,13822),-- Leather
(20641,1894,1,1,2,2182),-- Crafted Leather
(20641,2353,1,1,2,101),-- Recipe: Samurai Longsword
(20641,4042,1,1,2,1037),-- Enria
(20641,4124,1,1,2,2765),-- Recipe: Craftsman Mold
(20641,4609,1,1,2,138),-- Greater Dye of Mental Strength <Men+3 Int-3>
(20641,8725,1,1,200,1728),-- Life Stone: level 52
(20641,8735,1,1,200,432),-- Mid-Grade Life Stone: level 52
(20641,8745,1,1,200,43),-- High-Grade Life Stone: level 52
(20641,8755,1,1,200,8),-- Top-Grade Life Stone: level 52
(20642,2103,1,1,-1,9533),-- Sage\'s Staff Head
(20642,2358,1,1,-1,2759),-- Recipe: Great Pata
(20642,4602,1,1,-1,3758),-- Greater Dye of Strength <Str+3 Dex-3>
(20642,57,672,1357,0,700000),-- Adena
(20642,283,1,1,1,21),-- Akat Long Bow
(20642,2109,1,1,1,1961),-- Akat Longbow Shaft
(20642,1342,10,30,2,186488),-- Fine Steel Arrow
(20642,1868,1,1,2,93244),-- Thread
(20642,1873,1,1,2,18649),-- Silver Nugget
(20642,1876,1,1,2,9324),-- Mithril Ore
(20642,1895,1,1,2,13321),-- Metallic Fiber
(20642,3015,1,1,2,1302),-- Recipe: Drake Leather Gloves
(20642,3017,1,1,2,1302),-- Recipe: Divine Gloves
(20642,4042,1,1,2,777),-- Enria
(20642,4606,1,1,2,104),-- Greater Dye of Dexterity <Dex+3 Con-3>
(20642,5155,1,1,2,93),-- Recipe: Soulshot (B) Compressed Package (100%)
(20642,8725,1,1,200,1295),-- Life Stone: level 52
(20642,8735,1,1,200,324),-- Mid-Grade Life Stone: level 52
(20642,8745,1,1,200,32),-- High-Grade Life Stone: level 52
(20642,8755,1,1,200,7),-- Top-Grade Life Stone: level 52
(20643,1918,1,1,-1,75426),-- Nassen\'s Earring Gemstone
(20643,2114,1,1,-1,8434),-- Widowmaker Head
(20643,3955,1,1,-1,3483),-- Recipe: Blessed Spiritshot B
(20643,57,689,1400,0,700000),-- Adena
(20643,2414,1,1,1,78),-- Full Plate Helmet
(20643,2497,1,1,1,111),-- Full Plate Shield
(20643,2959,1,1,1,5561),-- Full Plate Helmet Design
(20643,2966,1,1,1,8797),-- Full Plate Shield Fragment
(20643,1894,1,1,2,1880),-- Crafted Leather
(20643,4039,1,1,2,1786),-- Mold Glue
(20643,4041,1,1,2,466),-- Mold Hardener
(20643,4044,1,1,2,1786),-- Thons
(20643,4126,1,1,2,884),-- Recipe: Adamantite Earrings
(20643,5270,1,1,2,107),-- Recipe: Greater Soulshot (B) Compressed Package(100%)
(20643,5275,1,1,2,107),-- Recipe: Greater Spiritshot (B) Compressed Package(100%)
(20643,6669,1,1,2,12462),-- Deluxe Chest Key - Grade 5
(20643,8726,1,1,200,1240),-- Life Stone: level 55
(20643,8736,1,1,200,310),-- Mid-Grade Life Stone: level 55
(20643,8746,1,1,200,31),-- High-Grade Life Stone: level 55
(20643,8756,1,1,200,6),-- Top-Grade Life Stone: level 55
(20644,1806,1,1,-1,3417),-- Recipe: Soulshot: B-Grade
(20644,1865,1,3,-1,854261),-- Varnish
(20644,1987,1,1,-1,26066),-- Drake Leather Armor Texture
(20644,57,675,1374,0,700000),-- Adena
(20644,442,1,1,1,38),-- Divine Tunic
(20644,473,1,1,1,61),-- Divine Stockings
(20644,1988,1,1,1,3030),-- Divine Tunic Fabric
(20644,1989,1,1,1,4753),-- Divine Stocking Pattern
(20644,1864,1,1,2,97052),-- Stem
(20644,1869,1,1,2,48526),-- Iron Ore
(20644,1878,1,1,2,19410),-- Braided Hemp
(20644,1884,1,1,2,29862),-- Cord
(20644,4039,1,1,2,1618),-- Mold Glue
(20644,4142,1,1,2,373),-- Recipe: Avadon Gaiters
(20644,4147,1,1,2,499),-- Recipe: Stockings of Zubei
(20644,4184,1,1,2,56),-- Recipe: Sprite\'s Staff
(20644,5160,1,1,2,97),-- Recipe: Spiritshot (B) Compressed Package (100%)
(20644,8726,1,1,200,1123),-- Life Stone: level 55
(20644,8736,1,1,200,281),-- Mid-Grade Life Stone: level 55
(20644,8746,1,1,200,28),-- High-Grade Life Stone: level 55
(20644,8756,1,1,200,6),-- Top-Grade Life Stone: level 55
(20645,1885,1,1,-1,320445),-- High Grade Suede
(20645,1920,1,1,-1,131577),-- Necklace of Binding Chain
(20645,2121,1,1,-1,17683),-- Eminence Bow Shaft
(20645,57,1520,3096,0,700000),-- Adena
(20645,286,1,1,1,30),-- Eminence Bow
(20645,2121,1,1,1,3265),-- Eminence Bow Shaft
(20645,1865,1,1,2,118318),-- Varnish
(20645,1870,1,1,2,118318),-- Coal
(20645,1874,1,1,2,7888),-- Oriharukon Ore
(20645,4039,1,1,2,3944),-- Mold Glue
(20645,4043,1,1,2,3944),-- Asofe
(20645,4179,1,1,2,1521),-- Recipe: Zubei\'s Helmet
(20645,4189,1,1,2,136),-- Recipe: Arthro Nail
(20645,5275,1,1,2,237),-- Recipe: Greater Spiritshot (B) Compressed Package(100%)
(20645,8726,1,1,200,2739),-- Life Stone: level 55
(20645,8736,1,1,200,685),-- Mid-Grade Life Stone: level 55
(20645,8746,1,1,200,69),-- High-Grade Life Stone: level 55
(20645,8756,1,1,200,13),-- Top-Grade Life Stone: level 55
(20646,2122,1,1,-1,13225),-- Orcish Poleaxe Blade
(20646,3034,1,1,-1,5795),-- Recipe: Spiritshot B
(20646,4044,1,1,-1,96583),-- Thons
(20646,57,1145,2333,0,700000),-- Adena
(20646,299,1,1,1,8),-- Orcish Poleaxe
(20646,301,1,1,1,10),-- Scorpion
(20646,303,1,1,1,10),-- Widow Maker
(20646,2113,1,1,1,864),-- Scorpion Blade
(20646,2114,1,1,1,864),-- Widowmaker Head
(20646,2122,1,1,1,814),-- Orcish Poleaxe Blade
(20646,1864,1,1,2,178307),-- Stem
(20646,1869,1,1,2,89153),-- Iron Ore
(20646,1878,1,1,2,35662),-- Braided Hemp
(20646,1884,1,1,2,54864),-- Cord
(20646,4039,1,1,2,2972),-- Mold Glue
(20646,4186,1,1,2,103),-- Recipe: Sword of Valhalla
(20646,4190,1,1,2,103),-- Recipe: Dark Elven Long Bow
(20646,5165,1,1,2,178),-- Recipe: Blessed Spiritshot (B) Compressed Package (100%)
(20646,8726,1,1,200,2064),-- Life Stone: level 55
(20646,8736,1,1,200,516),-- Mid-Grade Life Stone: level 55
(20646,8746,1,1,200,52),-- High-Grade Life Stone: level 55
(20646,8756,1,1,200,10),-- Top-Grade Life Stone: level 55
(20647,947,1,1,-1,1166),-- Scroll: Enchant Weapon (Grade B)
(20647,2960,1,1,-1,158666),-- Drake Leather Boots Design
(20647,4049,1,1,-1,152841),-- Adamantite Earring Gemstone
(20647,57,1150,2348,0,700000),-- Adena
(20647,554,1,1,1,54),-- Zubei\'s Boots
(20647,600,1,1,1,54),-- Avadon Boots
(20647,612,1,1,1,54),-- Zubei\'s Gauntlets
(20647,2464,1,1,1,54),-- Avadon Gloves
(20647,4073,1,1,1,5600),-- Avadon Gloves Part
(20647,4097,1,1,1,5600),-- Zubei\'s Boots Design
(20647,4098,1,1,1,5600),-- Avadon Boots Design
(20647,4100,1,1,1,5600),-- Zubei\'s Gauntlets Part
(20647,1865,1,1,2,71727),-- Varnish
(20647,1870,1,1,2,71727),-- Coal
(20647,1875,1,1,2,4782),-- Stone of Purity
(20647,1879,1,1,2,11955),-- Cokes
(20647,4040,1,1,2,1434),-- Mold Lubricant
(20647,4176,1,1,2,892),-- Recipe: Doom Boots
(20647,4946,1,1,2,460),-- Recipe: Zubei\'s Leather Shirt (60%)
(20647,5280,1,1,2,144),-- Recipe: Greater Blessed Spiritshot (B) Compressed Package(100%)
(20647,8727,1,1,200,1434),-- Life Stone: level 58
(20647,8737,1,1,200,359),-- Mid-Grade Life Stone: level 58
(20647,8747,1,1,200,36),-- High-Grade Life Stone: level 58
(20647,8757,1,1,200,7),-- Top-Grade Life Stone: level 58
(20648,1868,1,13,-1,897647),-- Thread
(20648,2963,1,1,-1,171074),-- Full Plate Gauntlets Part
(20648,4191,1,1,-1,3620),-- Recipe: Great Axe
(20648,57,1239,2531,0,700000),-- Adena
(20648,554,1,1,1,58),-- Zubei\'s Boots
(20648,600,1,1,1,58),-- Avadon Boots
(20648,612,1,1,1,58),-- Zubei\'s Gauntlets
(20648,2464,1,1,1,58),-- Avadon Gloves
(20648,4073,1,1,1,6038),-- Avadon Gloves Part
(20648,4097,1,1,1,6038),-- Zubei\'s Boots Design
(20648,4098,1,1,1,6038),-- Avadon Boots Design
(20648,4100,1,1,1,6038),-- Zubei\'s Gauntlets Part
(20648,1868,1,1,2,154671),-- Thread
(20648,1873,1,1,2,30934),-- Silver Nugget
(20648,1876,1,1,2,15467),-- Mithril Ore
(20648,1895,1,1,2,22096),-- Metallic Fiber
(20648,4042,1,1,2,1289),-- Enria
(20648,4961,1,1,2,1419),-- Recipe: Zubei\'s Shield (60%)
(20648,4999,1,1,2,962),-- Recipe: Doom Boots (60%)
(20648,6669,1,1,2,17985),-- Deluxe Chest Key - Grade 5
(20648,8727,1,1,200,1547),-- Life Stone: level 58
(20648,8737,1,1,200,387),-- Mid-Grade Life Stone: level 58
(20648,8747,1,1,200,39),-- High-Grade Life Stone: level 58
(20648,8757,1,1,200,8),-- Top-Grade Life Stone: level 58
(20649,2112,1,1,-1,16014),-- Pa\'agrian Axe Blade
(20649,4133,1,1,-1,15899),-- Recipe: Zubei\'s Breastplate
(20649,5549,1,1,-1,330694),-- Metallic Thread
(20649,57,1306,2660,0,700000),-- Adena
(20649,78,1,1,1,5),-- Great Sword
(20649,142,1,1,1,5),-- Keshanberk
(20649,148,1,1,1,5),-- Sword of Valhalla
(20649,4104,1,1,1,931),-- Great Sword Blade
(20649,4107,1,1,1,917),-- Keshanberk Blade
(20649,4108,1,1,1,917),-- Sword of Valhalla Blade
(20649,1832,1,1,2,83489),-- Greater Antidote
(20649,1868,1,1,2,150280),-- Thread
(20649,1873,1,1,2,30056),-- Silver Nugget
(20649,1889,1,1,2,5009),-- Compound Braid
(20649,4044,1,1,2,2505),-- Thons
(20649,4194,1,1,2,57),-- Recipe: Deadman\'s Glory
(20649,4970,1,1,2,87),-- Recipe: Arthro Nail (60%)
(20649,8311,1,1,2,57),-- Recipe: Kaim Vanul\'s Bones (100%)
(20649,5549,1,1,2,7514),-- Metallic Thread
(20649,8727,1,1,200,1503),-- Life Stone: level 58
(20649,8737,1,1,200,376),-- Mid-Grade Life Stone: level 58
(20649,8747,1,1,200,38),-- High-Grade Life Stone: level 58
(20649,8757,1,1,200,8),-- Top-Grade Life Stone: level 58
(20650,4049,1,1,-1,188177),-- Adamantite Earring Gemstone
(20650,4195,1,1,-1,2739),-- Recipe: Art of Battle Axe
(20650,4613,1,1,-1,4948),-- Greater Dye of Strength <Str+4 Con-4>
(20650,57,1417,2887,0,700000),-- Adena
(20650,856,1,1,1,76),-- Adamantite Earring
(20650,887,1,1,1,114),-- Adamantite Ring
(20650,918,1,1,1,57),-- Adamantite Necklace
(20650,4049,1,1,1,9264),-- Adamantite Earring Gemstone
(20650,4050,1,1,1,10943),-- Adamantite Ring Wire
(20650,4051,1,1,1,6849),-- Adamantite Necklace Chain
(20650,948,1,1,2,221),-- Scroll: Enchant Armor (Grade B)
(20650,1867,1,1,2,117746),-- Animal Skin
(20650,1872,1,1,2,117746),-- Animal Bone
(20650,1882,1,1,2,19624),-- Leather
(20650,1894,1,1,2,3099),-- Crafted Leather
(20650,4042,1,1,2,1472),-- Enria
(20650,4167,1,1,2,1098),-- Recipe: Blue Wolf Boots
(20650,4168,1,1,2,1098),-- Recipe: Doom Gloves
(20650,8728,1,1,200,1472),-- Life Stone: level 61
(20650,8738,1,1,200,368),-- Mid-Grade Life Stone: level 61
(20650,8748,1,1,200,37),-- High-Grade Life Stone: level 61
(20650,8758,1,1,200,7),-- Top-Grade Life Stone: level 61
(20651,4050,1,2,-1,206850),-- Adamantite Ring Wire
(20651,4196,1,1,-1,2549),-- Recipe: Staff of Evil Spirits
(20651,57,1320,2684,0,700000),-- Adena
(20651,78,1,1,1,5),-- Great Sword
(20651,142,1,1,1,5),-- Keshanberk
(20651,148,1,1,1,5),-- Sword of Valhalla
(20651,4104,1,1,1,940),-- Great Sword Blade
(20651,4107,1,1,1,926),-- Keshanberk Blade
(20651,4108,1,1,1,926),-- Sword of Valhalla Blade
(20651,948,1,1,2,205),-- Scroll: Enchant Armor (Grade B)
(20651,1867,1,1,2,109573),-- Animal Skin
(20651,1872,1,1,2,109573),-- Animal Bone
(20651,1882,1,1,2,18262),-- Leather
(20651,1894,1,1,2,2884),-- Crafted Leather
(20651,4042,1,1,2,1370),-- Enria
(20651,4167,1,1,2,1022),-- Recipe: Blue Wolf Boots
(20651,4168,1,1,2,1022),-- Recipe: Doom Gloves
(20651,8728,1,1,200,1370),-- Life Stone: level 61
(20651,8738,1,1,200,342),-- Mid-Grade Life Stone: level 61
(20651,8748,1,1,200,34),-- High-Grade Life Stone: level 61
(20651,8758,1,1,200,7),-- Top-Grade Life Stone: level 61
(20652,4042,1,1,-1,58802),-- Enria
(20652,4043,1,1,-1,117603),-- Asofe
(20652,4129,1,1,-1,38183),-- Recipe: Earrings of Black Ore
(20652,57,1398,2835,0,700000),-- Adena
(20652,2384,1,1,1,29),-- Zubei\'s Leather Shirt
(20652,2388,1,1,1,46),-- Zubei\'s Leather Gaiters
(20652,2390,1,1,1,18),-- Avadon Leather Armor
(20652,4066,1,1,1,4096),-- Zubei\'s Leather Shirt Fabric
(20652,4067,1,1,1,6219),-- Zubei\'s Leather Gaiter Texture
(20652,4068,1,1,1,3147),-- Avadon Leather Armor Lining
(20652,1864,1,1,2,173691),-- Stem
(20652,1869,1,1,2,86845),-- Iron Ore
(20652,1880,1,1,2,8684),-- Steel
(20652,4043,1,1,2,2895),-- Asofe
(20652,4173,1,1,2,1080),-- Recipe: Blue Wolf Gloves
(20652,4615,1,1,2,120),-- Greater Dye of Constitution <Con+4 Str-4>
(20652,4998,1,1,2,1080),-- Recipe: Blue Wolf Gloves (60%)
(20652,5550,1,1,2,1158),-- Durable Metal Plate
(20652,8728,1,1,200,1448),-- Life Stone: level 61
(20652,8738,1,1,200,362),-- Mid-Grade Life Stone: level 61
(20652,8748,1,1,200,36),-- High-Grade Life Stone: level 61
(20652,8758,1,1,200,7),-- Top-Grade Life Stone: level 61
(20654,4052,1,1,-1,232857),-- Earring of Black Ore Piece
(20654,4064,1,1,-1,119042),-- Avadon Breastplate Part
(20654,5230,1,1,-1,8769),-- Recipe: Mithril Arrow (100%)
(20654,57,2608,5284,0,700000),-- Adena
(20654,2398,1,1,1,26),-- Blue Wolf Tunic
(20654,2399,1,1,1,26),-- Tunic of Doom
(20654,2403,1,1,1,42),-- Blue Wolf Stockings
(20654,2404,1,1,1,42),-- Stockings of Doom
(20654,4084,1,1,1,4222),-- Blue Wolf Tunic Fabric
(20654,4085,1,1,1,4222),-- Tunic of Doom Pattern
(20654,4086,1,1,1,5701),-- Blue Wolf Stockings Pattern
(20654,4087,1,1,1,5701),-- Stockings of Doom Pattern
(20654,1894,1,1,2,6197),-- Crafted Leather
(20654,4039,1,1,2,5887),-- Mold Glue
(20654,4041,1,1,2,1536),-- Mold Hardener
(20654,4044,1,1,2,5887),-- Thons
(20654,4624,1,1,2,244),-- Greater Dye of Wit <Wit+4 Men-4>
(20654,5276,1,1,2,235),-- Recipe: Greater Spiritshot (A) Compressed Package(100%)
(20654,6036,1,1,2,5887),-- Greater Magic Haste Potion
(20654,8729,1,1,200,2355),-- Life Stone: level 64
(20654,8739,1,1,200,589),-- Mid-Grade Life Stone: level 64
(20654,8749,1,1,200,59),-- High-Grade Life Stone: level 64
(20654,8759,1,1,200,12),-- Top-Grade Life Stone: level 64
(20655,4053,1,1,-1,254190),-- Ring of Black Ore Gemstone
(20655,4067,1,1,-1,212287),-- Zubei\'s Leather Gaiter Texture
(20655,4160,1,1,-1,16800),-- Recipe: Leather Armor of Doom
(20655,57,2352,4762,0,700000),-- Adena
(20655,110,1,1,1,90),-- Doom Shield
(20655,2416,1,1,1,63),-- Blue Wolf Helmet
(20655,2417,1,1,1,63),-- Doom Helmet
(20655,4077,1,1,1,13134),-- Doom Shield Fragment
(20655,4088,1,1,1,11035),-- Blue Wolf Helmet Design
(20655,4089,1,1,1,11035),-- Doom Helmet Pattern
(20655,1343,20,60,2,96248),-- Silver Arrow
(20655,1865,1,1,2,134746),-- Varnish
(20655,1870,1,1,2,134746),-- Coal
(20655,1874,1,1,2,8983),-- Oriharukon Ore
(20655,4039,1,1,2,4491),-- Mold Glue
(20655,4043,1,1,2,4491),-- Asofe
(20655,4989,1,1,2,892),-- Recipe: Stockings of Doom (60%)
(20655,5276,1,1,2,180),-- Recipe: Greater Spiritshot (A) Compressed Package(100%)
(20655,6670,1,1,2,22458),-- Deluxe Chest Key - Grade 6
(20655,8729,1,1,200,1797),-- Life Stone: level 64
(20655,8739,1,1,200,449),-- Mid-Grade Life Stone: level 64
(20655,8749,1,1,200,45),-- High-Grade Life Stone: level 64
(20655,8759,1,1,200,9),-- Top-Grade Life Stone: level 64
(20656,4040,1,2,-1,114237),-- Mold Lubricant
(20656,4069,1,1,-1,134666),-- Tunic of Zubei Fabric
(20656,57,2265,4587,0,700000),-- Adena
(20656,2398,1,1,1,23),-- Blue Wolf Tunic
(20656,2399,1,1,1,23),-- Tunic of Doom
(20656,2403,1,1,1,36),-- Blue Wolf Stockings
(20656,2404,1,1,1,36),-- Stockings of Doom
(20656,4084,1,1,1,3666),-- Blue Wolf Tunic Fabric
(20656,4085,1,1,1,3666),-- Tunic of Doom Pattern
(20656,4086,1,1,1,4950),-- Blue Wolf Stockings Pattern
(20656,4087,1,1,1,4951),-- Stockings of Doom Pattern
(20656,1895,1,1,2,48205),-- Metallic Fiber
(20656,4040,1,1,2,3374),-- Mold Lubricant
(20656,4042,1,1,2,2812),-- Enria
(20656,4043,1,1,2,5624),-- Asofe
(20656,4990,1,1,2,1394),-- Recipe: Blue Wolf Helmet (60%)
(20656,6670,1,1,2,28120),-- Deluxe Chest Key - Grade 6
(20656,8729,1,1,200,2250),-- Life Stone: level 64
(20656,8739,1,1,200,562),-- Mid-Grade Life Stone: level 64
(20656,8749,1,1,200,56),-- High-Grade Life Stone: level 64
(20656,8759,1,1,200,11),-- Top-Grade Life Stone: level 64
(20657,1877,1,1,-1,168837),-- Adamantite Nugget
(20657,1914,1,1,-1,237131),-- Earring of Binding Gemstone
(20657,1920,1,1,-1,144429),-- Necklace of Binding Chain
(20657,57,1676,3389,0,700000),-- Adena
(20657,2398,1,1,1,17),-- Blue Wolf Tunic
(20657,2399,1,1,1,17),-- Tunic of Doom
(20657,2403,1,1,1,27),-- Blue Wolf Stockings
(20657,2404,1,1,1,27),-- Stockings of Doom
(20657,4084,1,1,1,2709),-- Blue Wolf Tunic Fabric
(20657,4085,1,1,1,2709),-- Tunic of Doom Pattern
(20657,4086,1,1,1,3658),-- Blue Wolf Stockings Pattern
(20657,4087,1,1,1,3658),-- Stockings of Doom Pattern
(20657,1866,1,1,2,69266),-- Suede
(20657,1871,1,1,2,103900),-- Charcoal
(20657,1877,1,1,2,4156),-- Adamantite Nugget
(20657,4040,1,1,2,2078),-- Mold Lubricant
(20657,4041,1,1,2,903),-- Mold Hardener
(20657,4960,1,1,2,2002),-- Recipe: Zubei\'s Gauntlets (60%)
(20657,5276,1,1,2,139),-- Recipe: Greater Spiritshot (A) Compressed Package(100%)
(20657,8300,1,1,2,57),-- Recipe: Infernal Master (60%)
(20657,8729,1,1,200,1385),-- Life Stone: level 64
(20657,8739,1,1,200,346),-- Mid-Grade Life Stone: level 64
(20657,8749,1,1,200,35),-- High-Grade Life Stone: level 64
(20657,8759,1,1,200,7),-- Top-Grade Life Stone: level 64
(20658,1960,1,1,-1,223012),-- Chain Gaiters Part
(20658,2220,1,1,-1,84264),-- Recipe: Rind Leather Armor
(20658,4054,1,1,-1,80165),-- Necklace of Black Ore Beads
(20658,57,1613,3270,0,700000),-- Adena
(20658,864,1,1,1,56),-- Earring of Black Ore
(20658,895,1,1,1,85),-- Ring of Black Ore
(20658,926,1,1,1,42),-- Necklace of Black Ore
(20658,4052,1,1,1,7094),-- Earring of Black Ore Piece
(20658,4053,1,1,1,8588),-- Ring of Black Ore Gemstone
(20658,4054,1,1,1,3946),-- Necklace of Black Ore Beads
(20658,730,1,1,2,83),-- Scroll: Enchant Armor (Grade A)
(20658,1832,1,1,2,111315),-- Greater Antidote
(20658,1866,1,1,2,66789),-- Suede
(20658,1871,1,1,2,100184),-- Charcoal
(20658,1885,1,1,2,8349),-- High Grade Suede
(20658,4041,1,1,2,871),-- Mold Hardener
(20658,4155,1,1,2,311),-- Recipe: Blue Wolf Breastplate
(20658,5220,1,1,2,4007),-- Metal Hardener
(20658,8729,1,1,200,1336),-- Life Stone: level 64
(20658,8739,1,1,200,334),-- Mid-Grade Life Stone: level 64
(20658,8749,1,1,200,33),-- High-Grade Life Stone: level 64
(20658,8759,1,1,200,7),-- Top-Grade Life Stone: level 64
(20659,1885,1,1,-1,109145),-- High Grade Suede
(20659,2062,1,1,-1,10273),-- Scythe Edge
(20659,2163,1,1,-1,66824),-- Recipe: Earring of Protection
(20659,57,518,1052,0,700000),-- Adena
(20659,631,1,1,1,202),-- Eldarake
(20659,1964,1,1,1,8336),-- Eldarake Temper
(20659,2413,1,1,1,142),-- Chain Hood
(20659,2495,1,1,1,202),-- Chain Shield
(20659,2936,1,1,1,7571),-- Chain Hood Pattern
(20659,2945,1,1,1,8336),-- Chain Shield Fragment
(20659,1868,1,1,2,95232),-- Thread
(20659,1873,1,1,2,19046),-- Silver Nugget
(20659,1889,1,1,2,3174),-- Compound Braid
(20659,2215,1,1,2,607),-- Recipe: Robe of Seal
(20659,2225,1,1,2,1035),-- Recipe: Demon\'s Stockings
(20659,2321,1,1,2,166),-- Recipe: Stiletto
(20659,3021,1,1,2,166),-- Recipe: Dwarven War Hammer
(20659,4044,1,1,2,1587),-- Thons
(20659,5549,1,1,2,4762),-- Metallic Thread
(20659,8723,1,1,200,1905),-- Life Stone: level 46
(20659,8733,1,1,200,476),-- Mid-Grade Life Stone: level 46
(20659,8743,1,1,200,48),-- High-Grade Life Stone: level 46
(20659,8753,1,1,200,9),-- Top-Grade Life Stone: level 46
(20660,1908,1,1,-1,153154),-- Moonstone Earring Wire
(20660,2084,1,1,-1,10746),-- Soulfire Dirk Blade
(20660,2330,1,1,-1,3761),-- Recipe: Homunkulus\'s Sword
(20660,57,637,1303,0,700000),-- Adena
(20660,439,1,1,1,131),-- Karmian Tunic
(20660,471,1,1,1,210),-- Karmian Stockings
(20660,1954,1,1,1,10160),-- Karmian Stocking Design
(20660,1962,1,1,1,6115),-- Karmian Tunic Pattern
(20660,1864,1,1,2,152872),-- Stem
(20660,1869,1,1,2,76436),-- Iron Ore
(20660,1880,1,1,2,7644),-- Steel
(20660,2163,1,1,2,3900),-- Recipe: Earring of Protection
(20660,4043,1,1,2,2548),-- Asofe
(20660,5550,1,1,2,1019),-- Durable Metal Plate
(20660,8723,1,1,200,3057),-- Life Stone: level 46
(20660,8733,1,1,200,764),-- Mid-Grade Life Stone: level 46
(20660,8743,1,1,200,76),-- High-Grade Life Stone: level 46
(20660,8753,1,1,200,15),-- Top-Grade Life Stone: level 46
(20661,2166,1,1,-1,51732),-- Recipe: Earrings of Binding (100%)
(20661,2223,1,1,-1,59150),-- Recipe: Tower Shield
(20661,2347,1,1,-1,3549),-- Recipe: Akat Long Bow
(20661,57,602,1229,0,700000),-- Adena
(20661,500,1,1,1,121),-- Great Helmet
(20661,632,1,1,1,173),-- Knight\'s Shield
(20661,1971,1,1,1,6899),-- Great Helmet Material
(20661,1972,1,1,1,9015),-- Knight\'s Shield Fragment
(20661,2496,1,1,1,188),-- Dwarven Chain Shield
(20661,2947,1,1,1,8050),-- Dwarven Chain Shield Fragment
(20661,1343,10,30,2,68996),-- Silver Arrow
(20661,1868,1,1,2,96595),-- Thread
(20661,1873,1,1,2,19319),-- Silver Nugget
(20661,1876,1,1,2,9659),-- Mithril Ore
(20661,1895,1,1,2,13799),-- Metallic Fiber
(20661,2223,1,1,2,1872),-- Recipe: Tower Shield
(20661,2230,1,1,2,936),-- Recipe: Theca Leather Gaiters
(20661,3005,1,1,2,1971),-- Recipe: Demon\'s Boots
(20661,4042,1,1,2,805),-- Enria
(20661,6668,1,1,2,17249),-- Deluxe Chest Key - Grade 4
(20661,8724,1,1,200,1610),-- Life Stone: level 49
(20661,8734,1,1,200,402),-- Mid-Grade Life Stone: level 49
(20661,8744,1,1,200,40),-- High-Grade Life Stone: level 49
(20661,8754,1,1,200,8),-- Top-Grade Life Stone: level 49
(20662,951,1,1,-1,2897),-- Scroll: Enchant Weapon (Grade C)
(20662,1873,1,1,-1,637338),-- Silver Nugget
(20662,1911,1,1,-1,118508),-- Earring of Protection Gemstone
(20662,57,630,1281,0,700000),-- Adena
(20662,73,1,1,1,8),-- Shamshir
(20662,74,1,1,1,8),-- Katana
(20662,131,1,1,1,8),-- Spirit Sword
(20662,133,1,1,1,8),-- Raid Sword
(20662,2077,1,1,1,586),-- Shamshir Blade
(20662,2078,1,1,1,586),-- Katana Blade
(20662,2080,1,1,1,586),-- Spirit Sword Blade
(20662,2081,1,1,1,586),-- Raid Sword Blade
(20662,1343,10,30,2,84045),-- Silver Arrow
(20662,1866,1,1,2,39221),-- Suede
(20662,1871,1,1,2,58831),-- Charcoal
(20662,1877,1,1,2,2353),-- Adamantite Nugget
(20662,2340,1,1,2,137),-- Recipe: Pa\'agrian Hammer
(20662,3006,1,1,2,2401),-- Recipe: Demon\'s Gloves
(20662,4040,1,1,2,1177),-- Mold Lubricant
(20662,4041,1,1,2,512),-- Mold Hardener
(20662,8724,1,1,200,1961),-- Life Stone: level 49
(20662,8734,1,1,200,490),-- Mid-Grade Life Stone: level 49
(20662,8744,1,1,200,49),-- High-Grade Life Stone: level 49
(20662,8754,1,1,200,10),-- Top-Grade Life Stone: level 49
(20663,951,1,1,-1,2539),-- Scroll: Enchant Weapon (Grade C)
(20663,1981,1,1,-1,82154),-- Mithril Gauntlets Design
(20663,4123,1,1,-1,62072),-- Recipe: Maestro Anvil Lock
(20663,57,551,1124,0,700000),-- Adena
(20663,853,1,1,1,137),-- Earring of Protection
(20663,884,1,1,1,206),-- Ring of Protection
(20663,916,1,1,1,103),-- Necklace of Protection
(20663,1911,1,1,1,7671),-- Earring of Protection Gemstone
(20663,1912,1,1,1,11114),-- Ring of Protection Gemstone
(20663,1913,1,1,1,6272),-- Necklace of Protection Gemstone
(20663,1866,1,1,2,37503),-- Suede
(20663,1871,1,1,2,56255),-- Charcoal
(20663,1877,1,1,2,2250),-- Adamantite Nugget
(20663,2340,1,1,2,131),-- Recipe: Pa\'agrian Hammer
(20663,3006,1,1,2,2296),-- Recipe: Demon\'s Gloves
(20663,4040,1,1,2,1125),-- Mold Lubricant
(20663,4041,1,1,2,489),-- Mold Hardener
(20663,8724,1,1,200,1875),-- Life Stone: level 49
(20663,8734,1,1,200,469),-- Mid-Grade Life Stone: level 49
(20663,8744,1,1,200,47),-- High-Grade Life Stone: level 49
(20663,8754,1,1,200,9),-- Top-Grade Life Stone: level 49
(20664,1865,1,3,-1,735264),-- Varnish
(20664,1867,1,5,-1,653568),-- Animal Skin
(20664,2098,1,1,-1,7876),-- Nirvana Axe Blade
(20664,57,582,1182,0,700000),-- Adena
(20664,64,1,1,1,161),-- Composite Boots
(20664,608,1,1,1,161),-- Mithril Gauntlets
(20664,1981,1,1,1,8943),-- Mithril Gauntlets Design
(20664,2956,1,1,1,8943),-- Composite Boots Part
(20664,1539,1,1,2,9653),-- Greater Healing Potion
(20664,1867,1,1,2,57916),-- Animal Skin
(20664,1872,1,1,2,57916),-- Animal Bone
(20664,1882,1,1,2,9653),-- Leather
(20664,1894,1,1,2,1524),-- Crafted Leather
(20664,2234,1,1,2,647),-- Recipe: Divine Stockings
(20664,2356,1,1,2,71),-- Recipe: Demon\'s Staff
(20664,4042,1,1,2,724),-- Enria
(20664,4609,1,1,2,97),-- Greater Dye of Mental Strength <Men+3 Int-3>
(20664,6669,1,1,2,10102),-- Deluxe Chest Key - Grade 5
(20664,8725,1,1,200,1207),-- Life Stone: level 52
(20664,8735,1,1,200,302),-- Mid-Grade Life Stone: level 52
(20664,8745,1,1,200,30),-- High-Grade Life Stone: level 52
(20664,8755,1,1,200,6),-- Top-Grade Life Stone: level 52
(20665,2104,1,1,-1,10174),-- Club of Nature Head
(20665,2359,1,1,-1,2944),-- Recipe: Eminence Bow
(20665,4043,1,1,-1,60164),-- Asofe
(20665,57,715,1452,0,700000),-- Adena
(20665,162,1,1,1,3),-- War Axe
(20665,174,1,1,1,3),-- Nirvana Axe
(20665,196,1,1,1,3),-- Stick of Eternity
(20665,197,1,1,1,3),-- Paradia Staff
(20665,199,1,1,1,3),-- Pa\'agrian Hammer
(20665,200,1,1,1,3),-- Sage\'s Staff
(20665,201,1,1,1,3),-- Club of Nature
(20665,202,1,1,1,3),-- Mace of The Underworld
(20665,2097,1,1,1,250),-- War Axe Blade
(20665,2098,1,1,1,250),-- Nirvana Axe Blade
(20665,2099,1,1,1,263),-- Stick of Eternity Shaft
(20665,2100,1,1,1,263),-- Paradia Staff Head
(20665,2102,1,1,1,254),-- Pa\'agrian Hammer Head
(20665,2103,1,1,1,263),-- Sage\'s Staff Head
(20665,2104,1,1,1,263),-- Club of Nature Head
(20665,2105,1,1,1,250),-- Mace of The Underworld Head
(20665,1865,1,1,2,67855),-- Varnish
(20665,1870,1,1,2,67855),-- Coal
(20665,1874,1,1,2,4524),-- Oriharukon Ore
(20665,3014,1,1,2,1895),-- Recipe: Full Plate Boots
(20665,4039,1,1,2,2262),-- Mold Glue
(20665,4043,1,1,2,2262),-- Asofe
(20665,4125,1,1,2,3016),-- Recipe: Maestro Mold
(20665,8725,1,1,200,1885),-- Life Stone: level 52
(20665,8735,1,1,200,471),-- Mid-Grade Life Stone: level 52
(20665,8745,1,1,200,47),-- High-Grade Life Stone: level 52
(20665,8755,1,1,200,9),-- Top-Grade Life Stone: level 52
(20666,1884,1,3,-1,577821),-- Cord
(20666,1977,1,1,-1,27780),-- Composite Armor Temper
(20666,4606,1,1,-1,4173),-- Greater Dye of Dexterity <Dex+3 Con-3>
(20666,57,746,1507,0,700000),-- Adena
(20666,64,1,1,1,206),-- Composite Boots
(20666,608,1,1,1,206),-- Mithril Gauntlets
(20666,1981,1,1,1,11420),-- Mithril Gauntlets Design
(20666,2956,1,1,1,11420),-- Composite Boots Part
(20666,1865,1,1,2,59738),-- Varnish
(20666,1870,1,1,2,59738),-- Coal
(20666,1874,1,1,2,3982),-- Oriharukon Ore
(20666,3955,1,1,2,120),-- Recipe: Blessed Spiritshot B
(20666,4039,1,1,2,1991),-- Mold Glue
(20666,4043,1,1,2,1991),-- Asofe
(20666,4607,1,1,2,133),-- Greater Dye of Intelligence <Int+3 Men-3>
(20666,4609,1,1,2,133),-- Greater Dye of Mental Strength <Men+3 Int-3>
(20666,5280,1,1,2,120),-- Recipe: Greater Blessed Spiritshot (B) Compressed Package(100%)
(20666,8725,1,1,200,1659),-- Life Stone: level 52
(20666,8735,1,1,200,415),-- Mid-Grade Life Stone: level 52
(20666,8745,1,1,200,41),-- High-Grade Life Stone: level 52
(20666,875,1,1,200,8),-- Top-Grade Life Stone: level 52
(20667,1988,1,1,-1,37181),-- Divine Tunic Fabric
(20667,4141,1,1,-1,9303),-- Recipe: Avadon Breastplate
(20667,4604,1,1,-1,4300),-- Greater Dye of Constitution <Con+3 Dex-3>
(20667,57,766,1556,0,700000),-- Adena
(20667,299,1,1,1,5),-- Orcish Poleaxe
(20667,301,1,1,1,6),-- Scorpion
(20667,303,1,1,1,6),-- Widow Maker
(20667,2113,1,1,1,577),-- Scorpion Blade
(20667,2114,1,1,1,577),-- Widowmaker Head
(20667,2122,1,1,1,544),-- Orcish Poleaxe Blade
(20667,1875,1,1,2,3664),-- Stone of Purity
(20667,1879,1,1,2,9160),-- Cokes
(20667,1885,1,1,2,4580),-- High Grade Suede
(20667,4127,1,1,2,1360),-- Recipe: Adamantite Ring
(20667,4184,1,1,2,63),-- Recipe: Sprite\'s Staff
(20667,5155,1,1,2,110),-- Recipe: Soulshot (B) Compressed Package (100%)
(20667,5165,1,1,2,110),-- Recipe: Blessed Spiritshot (B) Compressed Package (100%)
(20667,5549,1,1,2,5496),-- Metallic Thread
(20667,5550,1,1,2,733),-- Durable Metal Plate
(20667,8726,1,1,200,1272),-- Life Stone: level 55
(20667,8735,1,1,200,318),-- Mid-Grade Life Stone: level 52
(20667,8745,1,1,200,32),-- High-Grade Life Stone: level 52
(20667,8756,1,1,200,6),-- Top-Grade Life Stone: level 55
(20668,1806,1,1,-1,3451),-- Recipe: Soulshot: B-Grade
(20668,2917,1,1,-1,99106),-- Ring of Binding Gemstone
(20668,4147,1,1,-1,17733),-- Recipe: Stockings of Zubei
(20668,57,682,1388,0,700000),-- Adena
(20668,203,1,1,1,3),-- Pa\'agrian Axe
(20668,204,1,1,1,3),-- Deadman\'s Staff
(20668,205,1,1,1,3),-- Ghoul\'s Staff
(20668,206,1,1,1,3),-- Demon\'s Staff
(20668,2112,1,1,1,309),-- Pa\'agrian Axe Blade
(20668,2116,1,1,1,300),-- Deadman\'s Staff Head
(20668,2117,1,1,1,300),-- Ghoul\'s Staff Head
(20668,2118,1,1,1,300),-- Demon\'s Staff Head
(20668,2503,1,1,1,3),-- Yaksa Mace
(20668,2969,1,1,1,306),-- Yaksa Mace Head
(20668,1866,1,1,2,35394),-- Suede
(20668,1871,1,1,2,53091),-- Charcoal
(20668,1885,1,1,2,4424),-- High Grade Suede
(20668,4041,1,1,2,462),-- Mold Hardener
(20668,4148,1,1,2,233),-- Recipe: Avadon Robe
(20668,4936,1,1,2,974),-- Recipe: Avadon Shield (60%)
(20668,8309,1,1,2,61),-- Recipe: Spell Breaker (100%)
(20668,5220,1,1,2,2124),-- Metal Hardener
(20668,8726,1,1,200,1229),-- Life Stone: level 55
(20668,8736,1,1,200,307),-- Mid-Grade Life Stone: level 55
(20668,8746,1,1,200,31),-- High-Grade Life Stone: level 55
(20668,8756,1,1,200,6),-- Top-Grade Life Stone: level 55
(20669,4057,1,1,-1,60231),-- Zubei\'s Gaiter Material
(20669,4198,1,1,-1,1644),-- Recipe: Bellion Cestus
(20669,4589,1,1,-1,7177),-- Greater Dye of Strength <Str+2 Con-2>
(20669,57,851,1734,0,700000),-- Adena
(20669,286,1,1,1,17),-- Eminence Bow
(20669,2121,1,1,1,1828),-- Eminence Bow Shaft
(20669,1866,1,1,2,37859),-- Suede
(20669,1871,1,1,2,56789),-- Charcoal
(20669,1877,1,1,2,2272),-- Adamantite Nugget
(20669,4040,1,1,2,1136),-- Mold Lubricant
(20669,4041,1,1,2,494),-- Mold Hardener
(20669,4186,1,1,2,65),-- Recipe: Sword of Valhalla
(20669,4191,1,1,2,65),-- Recipe: Great Axe
(20669,5160,1,1,2,114),-- Recipe: Spiritshot (B) Compressed Package (100%)
(20669,5275,1,1,2,114),-- Recipe: Greater Spiritshot (B) Compressed Package(100%)
(20669,6669,1,1,2,13207),-- Deluxe Chest Key - Grade 5
(20669,8726,1,1,200,1315),-- Life Stone: level 55
(20669,8736,1,1,200,329),-- Mid-Grade Life Stone: level 55
(20669,8746,1,1,200,33),-- High-Grade Life Stone: level 55
(20669,8756,1,1,200,7),-- Top-Grade Life Stone: level 55
(20670,948,1,1,-1,5579),-- Scroll: Enchant Armor (Grade B)
(20670,4065,1,1,-1,62421),-- Avadon Gaiters Material
(20670,4129,1,1,-1,24151),-- Recipe: Earrings of Black Ore
(20670,57,884,1793,0,700000),-- Adena
(20670,12160,1,1,1,526),-- Common Item - Zubei\'s Helmet
(20670,12159,1,1,1,752),-- Common Item - Zubei\'s Shield
(20670,12171,1,1,1,752),-- Common Item - Avadon Shield
(20670,12170,1,1,1,526),-- Common Item - Avadon Circlet
(20670,4072,1,1,1,3701),-- Avadon Circlet Pattern
(20670,4101,1,1,1,4776),-- Zubei\'s Shield Fragment
(20670,4102,1,1,1,3701),-- Zubei\'s Helmet Design
(20670,4439,1,1,1,5682),-- Avadon Shield Fragment
(20670,1864,1,1,2,109861),-- Stem
(20670,1869,1,1,2,54931),-- Iron Ore
(20670,1880,1,1,2,5493),-- Steel
(20670,4043,1,1,2,1831),-- Asofe
(20670,4164,1,1,2,364),-- Recipe: Stockings of Doom
(20670,4168,1,1,2,683),-- Recipe: Doom Gloves
(20670,4616,1,1,2,76),-- Greater Dye of Constitution <Con+4 Dex-4>
(20670,5550,1,1,2,732),-- Durable Metal Plate
(20670,8728,1,1,200,915),-- Life Stone: level 61
(20670,8738,1,1,200,229),-- Mid-Grade Life Stone: level 61
(20670,8748,1,1,200,23),-- High-Grade Life Stone: level 61
(20670,8758,1,1,200,5),-- Top-Grade Life Stone: level 61
(20671,947,1,1,-1,934),-- Scroll: Enchant Weapon (Grade B)
(20671,2098,1,1,-1,12502),-- Nirvana Axe Blade
(20671,4052,1,1,-1,82640),-- Earring of Black Ore Piece
(20671,57,926,1875,0,700000),-- Adena
(20671,358,1,1,1,9),-- Blue Wolf Breastplate
(20671,2380,1,1,1,15),-- Blue Wolf Gaiters
(20671,2381,1,1,1,6),-- Doom Plate Armor
(20671,4078,1,1,1,1679),-- Blue Wolf Breastplate Part
(20671,4080,1,1,1,2364),-- Blue Wolf Gaiters Material
(20671,4081,1,1,1,1133),-- Doom Plate Armor Temper
(20671,1864,1,1,2,114913),-- Stem
(20671,1869,1,1,2,57457),-- Iron Ore
(20671,1880,1,1,2,5746),-- Steel
(20671,4043,1,1,2,1915),-- Asofe
(20671,4168,1,1,2,715),-- Recipe: Doom Gloves
(20671,4164,1,1,2,381),-- Recipe: Stockings of Doom (100%)
(20671,5550,1,1,2,766),-- Durable Metal Plate
(20671,4616,1,1,2,79),-- Greater Dye of CON
(20671,8728,1,1,200,958),-- Life Stone: level 61
(20671,8738,1,1,200,239),-- Mid-Grade Life Stone: level 61
(20671,8748,1,1,200,24),-- High-Grade Life Stone: level 61
(20671,8758,1,1,200,5),-- Top-Grade Life Stone: level 61
(20672,4052,1,1,-1,83872),-- Earring of Black Ore Piece
(20672,4070,1,1,-1,84802),-- Stockings of Zubei Fabric
(20672,4154,1,1,-1,28035),-- Recipe: Doom Shield
(20672,57,940,1902,0,700000),-- Adena
(20672,601,1,1,1,28),-- Boots of Doom
(20672,2439,1,1,1,28),-- Blue Wolf Boots
(20672,2475,1,1,1,28),-- Doom Gloves
(20672,2487,1,1,1,28),-- Blue Wolf Gloves
(20672,4090,1,1,1,3927),-- Blue Wolf Boots Design
(20672,4091,1,1,1,3927),-- Doom Gloves Part
(20672,4096,1,1,1,3927),-- Blue Wolf Gloves Fabric
(20672,4099,1,1,1,3927),-- Doom Boots Part
(20672,1868,1,1,2,127228),-- Thread
(20672,1873,1,1,2,25445),-- Silver Nugget
(20672,1889,1,1,2,4241),-- Compound Braid
(20672,4044,1,1,2,2120),-- Thons
(20672,4991,1,1,2,526),-- Recipe: Doom Helmet (60%)
(20672,5276,1,1,2,85),-- Recipe: Greater Spiritshot (A) Compressed Package(100%)
(20672,5549,1,1,2,6361),-- Metallic Thread
(20672,8729,1,1,200,848),-- Life Stone: level 64
(20672,8739,1,1,200,212),-- Mid-Grade Life Stone: level 64
(20672,8749,1,1,200,21),-- High-Grade Life Stone: level 64
(20672,8759,1,1,200,4),-- Top-Grade Life Stone: level 64
(20673,4041,1,1,-1,21521),-- Mold Hardener
(20673,4052,1,1,-1,87623),-- Earring of Black Ore Piece
(20673,5230,1,1,-1,3300),-- Recipe: Mithril Arrow (100%)
(20673,57,983,1987,0,700000),-- Adena
(20673,79,1,1,1,2),-- Sword of Damascus
(20673,7889,1,1,1,2),-- Wizard\'s Tear
(20673,7883,1,1,1,2),-- Guardian Sword
(20673,4114,1,1,1,534),-- Sword of Damascus Blade
(20673,8336,1,1,1,534),-- Blade of the Wizard\'s Tear
(20673,8330,1,1,1,533),-- Guardian Sword Blade
(20673,1867,1,1,2,88612),-- Animal Skin
(20673,1872,1,1,2,88612),-- Animal Bone
(20673,1875,1,1,2,4431),-- Stone of Purity
(20673,1881,1,1,2,8861),-- Coarse Bone Powder
(20673,4041,1,1,2,578),-- Mold Hardener
(20673,4150,1,1,2,1281),-- Recipe: Avadon Gloves
(20673,6037,1,1,2,132918),-- Waking Scroll
(20673,8729,1,1,200,886),-- Life Stone: level 64
(20673,8739,1,1,200,222),-- Mid-Grade Life Stone: level 64
(20673,8749,1,1,200,22),-- High-Grade Life Stone: level 64
(20673,8759,1,1,200,4),-- Top-Grade Life Stone: level 64
(20674,2089,1,1,-1,19453),-- Caliburs Edge
(20674,4053,1,1,-1,153008),-- Ring of Black Ore Gemstone
(20674,4124,1,1,-1,158653),-- Recipe: Craftsman Mold
(20674,57,1415,2868,0,700000),-- Adena
(20674,601,1,1,1,43),-- Boots of Doom
(20674,2439,1,1,1,43),-- Blue Wolf Boots
(20674,2475,1,1,1,43),-- Doom Gloves
(20674,2487,1,1,1,43),-- Blue Wolf Gloves
(20674,4090,1,1,1,5917),-- Blue Wolf Boots Design
(20674,4091,1,1,1,5917),-- Doom Gloves Part
(20674,4096,1,1,1,5917),-- Blue Wolf Gloves Fabric
(20674,4099,1,1,1,5917),-- Doom Boots Part
(20674,1867,1,1,2,117159),-- Animal Skin
(20674,1872,1,1,2,117159),-- Animal Bone
(20674,1875,1,1,2,5858),-- Stone of Purity
(20674,1881,1,1,2,11716),-- Coarse Bone Powder
(20674,4041,1,1,2,764),-- Mold Hardener
(20674,4157,1,1,2,437),-- Recipe: Blue Wolf Gaiters
(20674,8316,1,1,2,33),-- Recipe: Flaming Dragon Skull (60%)
(20674,5276,1,1,2,117),-- Recipe: Greater Spiritshot (A) Compressed Package(100%)
(20674,8729,1,1,200,1172),-- Life Stone: level 64
(20674,8739,1,1,200,293),-- Mid-Grade Life Stone: level 64
(20674,8749,1,1,200,29),-- High-Grade Life Stone: level 64
(20674,8759,1,1,200,6),-- Top-Grade Life Stone: level 64
(20675,1539,1,1,-1,339759),-- Greater Healing Potion
(20675,4042,1,1,-1,25482),-- Enria
(20675,4602,1,1,-1,3398),-- Greater Dye of Strength <Str+3 Dex-3>
(20675,57,605,1229,0,700000),-- Adena
(20675,60,1,1,1,52),-- Composite Armor
(20675,1977,1,1,1,4676),-- Composite Armor Temper
(20675,1867,1,1,2,70252),-- Animal Skin
(20675,1872,1,1,2,70252),-- Animal Bone
(20675,1875,1,1,2,3513),-- Stone of Purity
(20675,1881,1,1,2,7025),-- Coarse Bone Powder
(20675,2353,1,1,2,86),-- Recipe: Samurai Longsword
(20675,4041,1,1,2,458),-- Mold Hardener
(20675,4184,1,1,2,61),-- Recipe: Sprite\'s Staff
(20675,5155,1,1,2,105),-- Recipe: Soulshot (B) Compressed Package (100%)
(20675,8725,1,1,200,1464),-- Life Stone: level 52
(20675,8735,1,1,200,366),-- Mid-Grade Life Stone: level 52
(20675,8745,1,1,200,37),-- High-Grade Life Stone: level 52
(20675,8755,1,1,200,8),-- Top-Grade Life Stone: level 52
(20676,1807,1,1,-1,3415),-- Recipe: Soulshot: A-Grade
(20676,5478,1,1,-1,21536),-- Sealed Dark Crystal Leather Armor Pattern
(20676,5479,1,1,-1,15155),-- Sealed Tallum Leather Armor Pattern
(20676,57,1015,2058,0,700000),-- Adena
(20676,12341,1,1,1,585),-- Common Item - Earring of Black Ore
(20676,12343,1,1,1,876),-- Common Item - Ring of Black Ore
(20676,12342,1,1,1,439),-- Common Item - Necklace of Black Ore
(20676,4052,1,1,1,4464),-- Earring of Black Ore Piece
(20676,4053,1,1,1,5404),-- Ring of Black Ore Gemstone
(20676,4054,1,1,1,2483),-- Necklace of Black Ore Beads
(20676,1867,1,1,2,100869),-- Animal Skin
(20676,1872,1,1,2,100869),-- Animal Bone
(20676,1882,1,1,2,16811),-- Leather
(20676,1894,1,1,2,2654),-- Crafted Leather
(20676,4042,1,1,2,1261),-- Enria
(20676,6036,1,1,2,2522),-- Greater Magic Haste Potion
(20676,8729,1,1,200,1009),-- Life Stone: level 64
(20676,8739,1,1,200,252),-- Mid-Grade Life Stone: level 64
(20676,8749,1,1,200,25),-- High-Grade Life Stone: level 64
(20676,8759,1,1,200,5),-- Top-Grade Life Stone: level 64
(20677,3035,1,1,-1,3845),-- Recipe: Spiritshot A
(20677,5230,1,1,-1,3845),-- Recipe: Mithril Arrow (100%)
(20677,5482,1,1,-1,38058),-- Sealed Dark Crystalline Leggings Design
(20677,57,1142,2317,0,700000),-- Adena
(20677,11944,1,1,1,139),-- Common Item - Bow of Peril
(20677,4121,1,1,1,1855),-- Bow of Peril Shaft
(20677,1864,1,1,2,170349),-- Stem
(20677,1869,1,1,2,85174),-- Iron Ore
(20677,1880,1,1,2,8518),-- Steel
(20677,4043,1,1,2,2839),-- Asofe
(20677,5550,1,1,2,1136),-- Durable Metal Plate
(20677,8316,1,1,2,32),-- Recipe: Flaming Dragon Skull (60%)
(20677,8729,1,1,200,1136),-- Life Stone: level 64
(20677,8739,1,1,200,284),-- Mid-Grade Life Stone: level 64
(20677,8749,1,1,200,28),-- High-Grade Life Stone: level 64
(20677,8759,1,1,200,6),-- Top-Grade Life Stone: level 64
(20678,1918,1,1,-1,71130),-- Nassen\'s Earring Gemstone
(20678,1989,1,1,-1,49499),-- Divine Stocking Pattern
(20678,4142,1,1,-1,12634),-- Recipe: Avadon Gaiters
(20678,57,650,1321,0,700000),-- Adena
(20678,266,1,1,1,13),-- Great Pata
(20678,2120,1,1,1,1456),-- Great Pata Blade
(20678,1895,1,1,2,15751),-- Metallic Fiber
(20678,4040,1,1,2,1103),-- Mold Lubricant
(20678,4042,1,1,2,919),-- Enria
(20678,4043,1,1,2,1838),-- Asofe
(20678,4128,1,1,2,682),-- Recipe: Adamantite Necklace
(20678,4134,1,1,2,424),-- Recipe: Zubei\'s Gaiters
(20678,5280,1,1,2,110),-- Recipe: Greater Blessed Spiritshot (B) Compressed Package(100%)
(20678,8726,1,1,200,1276),-- Life Stone: level 55
(20678,8736,1,1,200,319),-- Mid-Grade Life Stone: level 55
(20678,8746,1,1,200,32),-- High-Grade Life Stone: level 55
(20678,8756,1,1,200,6),-- Top-Grade Life Stone: level 55
(20679,1806,1,1,-1,3383),-- Recipe: Soulshot: B-Grade
(20679,1920,1,1,-1,57882),-- Necklace of Binding Chain
(20679,4148,1,1,-1,7419),-- Recipe: Avadon Robe
(20679,57,668,1361,0,700000),-- Adena
(20679,203,1,1,1,3),-- Pa\'agrian Axe
(20679,204,1,1,1,3),-- Deadman\'s Staff
(20679,205,1,1,1,3),-- Ghoul\'s Staff
(20679,206,1,1,1,3),-- Demon\'s Staff
(20679,2112,1,1,1,302),-- Pa\'agrian Axe Blade
(20679,2116,1,1,1,294),-- Deadman\'s Staff Head
(20679,2117,1,1,1,294),-- Ghoul\'s Staff Head
(20679,2118,1,1,1,294),-- Demon\'s Staff Head
(20679,2503,1,1,1,3),-- Yaksa Mace
(20679,2969,1,1,1,300),-- Yaksa Mace Head
(20679,1867,1,1,2,64061),-- Animal Skin
(20679,1869,1,1,2,48046),-- Iron Ore
(20679,1870,1,1,2,48046),-- Coal
(20679,1871,1,1,2,48046),-- Charcoal
(20679,1872,1,1,2,64061),-- Animal Bone
(20679,4143,1,1,2,308),-- Recipe: Zubei\'s Leather Shirt
(20679,4149,1,1,2,618),-- Recipe: Avadon Circlet
(20679,4186,1,1,2,55),-- Recipe: Sword of Valhalla
(20679,5160,1,1,2,96),-- Recipe: Spiritshot (B) Compressed Package (100%)
(20679,8726,1,1,200,1112),-- Life Stone: level 55
(20679,8736,1,1,200,278),-- Mid-Grade Life Stone: level 55
(20679,8746,1,1,200,28),-- High-Grade Life Stone: level 55
(20679,8756,1,1,200,5),-- Top-Grade Life Stone: level 55
(20680,1873,1,1,-1,716613),-- Silver Nugget
(20680,1876,1,1,-1,358306),-- Mithril Ore
(20680,3034,1,1,-1,3583),-- Recipe: Spiritshot B
(20680,57,708,1442,0,700000),-- Adena
(20680,299,1,1,1,5),-- Orcish Poleaxe
(20680,301,1,1,1,6),-- Scorpion
(20680,303,1,1,1,6),-- Widow Maker
(20680,2113,1,1,1,534),-- Scorpion Blade
(20680,2114,1,1,1,534),-- Widowmaker Head
(20680,2122,1,1,1,503),-- Orcish Poleaxe Blade
(20680,1874,1,1,2,3675),-- Oriharukon Ore
(20680,1878,1,1,2,22050),-- Braided Hemp
(20680,1884,1,1,2,33922),-- Cord
(20680,1889,1,1,2,3675),-- Compound Braid
(20680,4441,1,1,2,1011),-- Recipe: Avadon Shield
(20680,5220,1,1,2,2205),-- Metal Hardener
(20680,5280,1,1,2,110),-- Recipe: Greater Blessed Spiritshot (B) Compressed Package(100%)
(20680,8311,1,1,2,42),-- Recipe: Kaim Vanul\'s Bones (100%)
(20680,8726,1,1,200,1276),-- Life Stone: level 55
(20680,8736,1,1,200,319),-- Mid-Grade Life Stone: level 55
(20680,8746,1,1,200,32),-- High-Grade Life Stone: level 55
(20680,8756,1,1,200,6),-- Top-Grade Life Stone: level 55
(20681,1873,1,1,-1,494213),-- Silver Nugget
(20681,1908,1,1,-1,117001),-- Moonstone Earring Wire
(20681,2063,1,1,-1,9550),-- Battle Axe Head
(20681,57,489,993,0,700000),-- Adena
(20681,71,1,1,1,17),-- Flamberge
(20681,72,1,1,1,17),-- Stormbringer
(20681,2059,1,1,1,1085),-- Flamberge Blade
(20681,2060,1,1,1,1159),-- Stormbringer Blade
(20681,1866,1,1,2,32441),-- Suede
(20681,1871,1,1,2,48661),-- Charcoal
(20681,1885,1,1,2,4055),-- High Grade Suede
(20681,2225,1,1,2,1058),-- Recipe: Demon\'s Stockings
(20681,2321,1,1,2,170),-- Recipe: Stiletto
(20681,4041,1,1,2,423),-- Mold Hardener
(20681,4440,1,1,2,170),-- Recipe: Knuckle Duster
(20681,5220,1,1,2,1946),-- Metal Hardener
(20681,8723,1,1,200,1946),-- Life Stone: level 46
(20681,8733,1,1,200,487),-- Mid-Grade Life Stone: level 46
(20681,8743,1,1,200,49),-- High-Grade Life Stone: level 46
(20681,8753,1,1,200,10),-- Top-Grade Life Stone: level 46
(20682,951,1,1,-1,2236),-- Scroll: Enchant Weapon (Grade C)
(20682,1876,1,1,-1,245912),-- Mithril Ore
(20682,4039,1,1,-1,40985),-- Mold Glue
(20682,57,484,990,0,700000),-- Adena
(20682,397,1,1,1,100),-- Mithril Shirt
(20682,1961,1,1,1,4649),-- Mithril Shirt Fabric
(20682,2387,1,1,1,160),-- Tempered Mithril Gaiters
(20682,2935,1,1,1,7724),-- Tempered Mithril Gaiters Fragment
(20682,1865,1,1,2,58111),-- Varnish
(20682,1870,1,1,2,58111),-- Coal
(20682,1874,1,1,2,3874),-- Oriharukon Ore
(20682,2323,1,1,2,202),-- Recipe: Elemental Bow
(20682,4039,1,1,2,1937),-- Mold Glue
(20682,4043,1,1,2,1937),-- Asofe
(20682,8723,1,1,200,2324),-- Life Stone: level 46
(20682,8733,1,1,200,581),-- Mid-Grade Life Stone: level 46
(20682,8743,1,1,200,58),-- High-Grade Life Stone: level 46
(20682,8753,1,1,200,12),-- Top-Grade Life Stone: level 46
(20683,1889,1,1,-1,106562),-- Compound Braid
(20683,1974,1,1,-1,134435),-- Crimson Boot Fabric
(20683,2336,1,1,-1,3717),-- Recipe: Nirvana Axe
(20683,57,631,1287,0,700000),-- Adena
(20683,227,1,1,1,16),-- Stiletto
(20683,242,1,1,1,16),-- Soulfire Dirk
(20683,2083,1,1,1,1176),-- Stiletto Edge
(20683,2084,1,1,1,1176),-- Soulfire Dirk Blade
(20683,1868,1,1,2,118038),-- Thread
(20683,1873,1,1,2,23608),-- Silver Nugget
(20683,1889,1,1,2,3935),-- Compound Braid
(20683,2224,1,1,2,802),-- Recipe: Demon\'s Tunic
(20683,2230,1,1,2,1144),-- Recipe: Theca Leather Gaiters
(20683,3005,1,1,2,802),-- Recipe: Demon\'s Boots
(20683,4044,1,1,2,1967),-- Thons
(20683,5549,1,1,2,5902),-- Metallic Thread
(20683,8724,1,1,200,1967),-- Life Stone: level 49
(20683,8734,1,1,200,492),-- Mid-Grade Life Stone: level 49
(20683,8744,1,1,200,49),-- High-Grade Life Stone: level 49
(20683,8754,1,1,200,10),-- Top-Grade Life Stone: level 49
(20684,1876,1,1,-1,334736),-- Mithril Ore
(20684,1966,1,1,-1,61106),-- Plated Leather Fragment
(20684,2078,1,1,-1,11121),-- Katana Blade
(20684,57,662,1345,0,700000),-- Adena
(20684,398,1,1,1,54),-- Plated Leather
(20684,399,1,1,1,50),-- Rind Leather Armor
(20684,418,1,1,1,86),-- Plated Leather Gaiters
(20684,419,1,1,1,80),-- Rind Leather Gaiters
(20684,1966,1,1,1,3384),-- Plated Leather Fragment
(20684,1967,1,1,1,5056),-- Plated Leather Gaiters Material
(20684,1975,1,1,1,3045),-- Rind Leather Armor Design
(20684,1976,1,1,1,5637),-- Rind Leather Gaiters Material
(20684,1539,1,1,2,13733),-- Greater Healing Potion
(20684,1866,1,1,2,41198),-- Suede
(20684,1871,1,1,2,61798),-- Charcoal
(20684,1877,1,1,2,2472),-- Adamantite Nugget
(20684,2341,1,1,2,144),-- Recipe: Sage\'s Staff
(20684,4040,1,1,2,1236),-- Mold Lubricant
(20684,4041,1,1,2,537),-- Mold Hardener
(20684,6668,1,1,2,22071),-- Deluxe Chest Key - Grade 4
(20684,8724,1,1,200,2060),-- Life Stone: level 49
(20684,8734,1,1,200,515),-- Mid-Grade Life Stone: level 49
(20684,8744,1,1,200,51),-- High-Grade Life Stone: level 49
(20684,8754,1,1,200,10),-- Top-Grade Life Stone: level 49
(20685,1970,1,1,-1,31188),-- Robe of Seal Fabric
(20685,2090,1,1,-1,7611),-- Delusional Blade
(20685,2166,1,1,-1,47343),-- Recipe: Earrings of Binding (100%)
(20685,57,551,1124,0,700000),-- Adena
(20685,195,1,1,1,14),-- Cursed Staff
(20685,2082,1,1,1,1090),-- Cursed Staff Head
(20685,2502,1,1,1,14),-- Dwarven War Hammer
(20685,2968,1,1,1,1044),-- Dwarven Warhammer Head
(20685,1867,1,1,2,75007),-- Animal Skin
(20685,1872,1,1,2,75007),-- Animal Bone
(20685,1875,1,1,2,3750),-- Stone of Purity
(20685,1881,1,1,2,7501),-- Coarse Bone Powder
(20685,2330,1,1,2,131),-- Recipe: Homunkulus\'s Sword
(20685,2351,1,1,2,118),-- Recipe: Scorpion
(20685,4041,1,1,2,489),-- Mold Hardener
(20685,8724,1,1,200,1875),-- Life Stone: level 49
(20685,8734,1,1,200,469),-- Mid-Grade Life Stone: level 49
(20685,8744,1,1,200,47),-- High-Grade Life Stone: level 49
(20685,8754,1,1,200,9),-- Top-Grade Life Stone: level 49
(20686,1880,1,1,-1,291368),-- Steel
(20686,2169,1,1,-1,51570),-- Recipe: Necklace of Binding
(20686,2231,1,1,-1,12559),-- Recipe: Full Plate Armor
(20686,57,1152,2343,0,700000),-- Adena
(20686,326,1,1,1,36),-- Heathen\'s Book
(20686,2110,1,1,1,3397),-- Heathen\'s Book Page
(20686,1866,1,1,2,66940),-- Suede
(20686,1871,1,1,2,100410),-- Charcoal
(20686,1877,1,1,2,4016),-- Adamantite Nugget
(20686,2354,1,1,2,164),-- Recipe: Deadman\'s Staff
(20686,2358,1,1,2,164),-- Recipe: Great Pata
(20686,4040,1,1,2,2008),-- Mold Lubricant
(20686,4041,1,1,2,873),-- Mold Hardener
(20686,4609,1,1,2,223),-- Greater Dye of Mental Strength <Men+3 Int-3>
(20686,8725,1,1,200,2789),-- Life Stone: level 52
(20686,8735,1,1,200,697),-- Mid-Grade Life Stone: level 52
(20686,8745,1,1,200,70),-- High-Grade Life Stone: level 52
(20686,8755,1,1,200,14),-- Top-Grade Life Stone: level 52
(20745,848,1,1,-1,6478),-- Enchanted Earring
(20745,1832,1,3,-1,590229),-- Greater Antidote
(20745,1901,1,1,-1,146742),-- Tiger\'s Eye Earring Stone
(20745,57,449,895,0,700000),-- Adena
(20745,393,1,1,1,161),-- Mithril Banded Mail
(20745,394,1,1,1,161),-- Reinforced Leather Shirt
(20745,415,1,1,1,257),-- Mithril Banded Gaiters
(20745,416,1,1,1,257),-- Reinforced Leather Gaiters
(20745,1938,1,1,1,6329),-- Mithril Banded Mail Material
(20745,1939,1,1,1,8296),-- Mithril Banded Gaiters Material
(20745,1867,1,1,2,150634),-- Animal Skin
(20745,1872,1,1,2,150634),-- Animal Bone
(20745,1882,1,1,2,25106),-- Leather
(20745,2156,1,1,2,9038),-- Recipe: Elven Necklace
(20745,2272,1,1,2,807),-- Recipe: Sword of Revolution
(20746,1061,1,1,-1,504445),-- Healing Potion
(20746,1900,1,1,-1,91065),-- Enchanted Necklace Chain
(20746,2153,1,1,-1,129445),-- Recipe: Tiger\'s Eye Earring
(20746,57,352,702,0,700000),-- Adena
(20746,259,1,1,1,184),-- Single-Edged Jamadhr
(20746,1865,1,1,2,75806),-- Varnish
(20746,1870,1,1,2,75806),-- Coal
(20746,1875,1,1,2,5054),-- Stone of Purity
(20746,1879,1,1,2,12634),-- Cokes
(20746,2184,1,1,2,7963),-- Recipe: Mithril Banded Gaiters
(20746,2272,1,1,2,541),-- Recipe: Sword of Revolution
(20747,1900,1,1,-1,128083),-- Enchanted Necklace Chain
(20747,2024,1,1,-1,16676),-- Elven Bow Shaft
(20747,2203,1,1,-1,255050),-- Recipe: Mithril Boots
(20747,57,493,989,0,700000),-- Adena
(20747,46,1,1,1,1666),-- Bronze Helmet
(20747,627,1,1,1,2378),-- Aspis
(20747,1867,1,1,2,121854),-- Animal Skin
(20747,1872,1,1,2,121854),-- Animal Bone
(20747,1875,1,1,2,6093),-- Stone of Purity
(20747,1881,1,1,2,12185),-- Coarse Bone Powder
(20747,2183,1,1,2,6012),-- Recipe: Mithril Banded Mail
(20747,2274,1,1,2,653),-- Recipe: Skull Breaker
(20747,2282,1,1,2,653),-- Recipe: Cursed Maingauche
(20748,1061,1,1,-1,668138),-- Healing Potion
(20748,1866,1,1,-1,734952),-- Suede
(20748,1871,1,3,-1,551214),-- Charcoal
(20748,57,467,925,0,700000),-- Adena
(20748,275,1,1,1,81),-- Long Bow
(20748,276,1,1,1,81),-- Elven Bow
(20748,2024,1,1,1,2861),-- Elven Bow Shaft
(20748,956,1,1,2,2869),-- Scroll: Enchant Armor (Grade D)
(20748,1831,1,1,2,229499),-- Antidote
(20748,1866,1,1,2,57375),-- Suede
(20748,1871,1,1,2,86062),-- Charcoal
(20748,1885,1,1,2,7172),-- High Grade Suede
(20748,2190,1,1,2,6147),-- Recipe: Mithril Stockings
(20748,5220,1,1,2,3442),-- Metal Hardener
(20749,1871,1,3,-1,585341),-- Charcoal
(20749,2025,1,1,-1,16214),-- Dwarven Trident Edge
(20749,2153,1,1,-1,182066),-- Recipe: Tiger\'s Eye Earring
(20749,57,493,989,0,700000),-- Adena
(20749,46,1,1,1,1666),-- Bronze Helmet
(20749,627,1,1,1,2378),-- Aspis
(20749,1866,1,1,2,106622),-- Suede
(20749,1871,1,1,2,159933),-- Charcoal
(20749,1877,1,1,2,6397),-- Adamantite Nugget
(20749,2184,1,1,2,16800),-- Recipe: Mithril Banded Gaiters
(20750,1933,1,1,-1,134288),-- Dark Stocking Fabric
(20750,1935,1,1,-1,63768),-- Scale Mail Fragment
(20750,2183,1,1,-1,75095),-- Recipe: Mithril Banded Mail
(20750,57,484,958,0,700000),-- Adena
(20750,222,1,1,1,252),-- Poniard Dagger
(20750,1829,1,1,2,49900),-- Scroll of Escape: Clan Hall
(20750,1831,1,3,2,166334),-- Antidote
(20750,1867,1,3,2,55445),-- Animal Skin
(20750,1872,1,1,2,166335),-- Animal Bone
(20750,1882,1,1,2,27723),-- Leather
(20751,1894,1,1,-1,152968),-- Crafted Leather
(20751,1949,1,1,-1,486561),-- Mithril Gloves Design
(20751,2161,1,1,-1,423261),-- Recipe: Aquastone Ring
(20751,57,1716,3517,0,700000),-- Adena
(20751,62,1,1,1,236),-- Mithril Boots
(20751,1958,1,1,1,10289),-- Mithril Boots Design
(20751,2429,1,1,1,236),-- Chain Boots
(20751,2430,1,1,1,236),-- Karmian Boots
(20751,2431,1,1,1,236),-- Plated Leather Boots
(20751,2432,1,1,1,236),-- Dwarven Chain Boots
(20751,2433,1,1,1,236),-- Boots of Seal
(20751,2452,1,1,1,236),-- Reinforced Mithril Gloves
(20751,2453,1,1,1,236),-- Chain Gloves
(20751,2454,1,1,1,236),-- Karmian Gloves
(20751,2937,1,1,1,10289),-- Chain Boots Part
(20751,2938,1,1,1,10289),-- Karmian Boots Fabric
(20751,2939,1,1,1,10289),-- Plate Leather Boot Lining
(20751,2940,1,1,1,10289),-- Dwarven Chain Boots Part
(20751,2941,1,1,1,10289),-- Boots of Seal Pattern
(20751,2942,1,1,1,10289),-- Reinforced Mithril Gloves Design
(20751,2943,1,1,1,10289),-- Chain Gloves Design
(20751,2944,1,1,1,10289),-- Karmian Gloves Fabric
(20751,1894,1,1,2,9037),-- Crafted Leather
(20751,2216,1,1,2,10643),-- Recipe: Great Helmet
(20751,2225,1,1,2,5599),-- Recipe: Demon\'s Stockings
(20751,2321,1,1,2,897),-- Recipe: Stiletto
(20751,8723,1,1,200,10302),-- Life Stone: level 46
(20751,8733,1,1,200,2575),-- Mid-Grade Life Stone: level 46
(20751,8743,1,1,200,258),-- High-Grade Life Stone: level 46 
(20751,8753,1,1,200,51),-- Top-Grade Life Stone: level 46 
(20752,1805,1,1,-1,7711),-- Recipe: Soulshot: C-Grade
(20752,1905,1,1,-1,225036),-- Omen Beast\'s Eye Earring Gemstone
(20752,5549,1,1,-1,231337),-- Metallic Thread
(20752,57,932,1883,0,700000),-- Adena
(20752,353,1,1,1,193),-- Half Plate Armor
(20752,380,1,1,1,309),-- Plate Gaiters
(20752,1950,1,1,1,9426),-- Half Plate Temper
(20752,1951,1,1,1,14661),-- Plate Gaiters Part
(20752,1868,1,1,2,331905),-- Thread
(20752,1873,1,1,2,66381),-- Silver Nugget
(20752,1889,1,1,2,11063),-- Compound Braid
(20752,2160,1,1,2,10706),-- Recipe: Moonstone Earring
(20752,2312,1,1,2,725),-- Recipe: Crystallized Ice Bow
(20752,5159,1,1,2,553),-- Recipe: Spiritshot (C) Compressed Package (100%)
(20752,5549,1,1,2,16595),-- Metallic Thread
(20753,1874,1,1,-1,250765),-- Oriharukon Ore
(20753,1875,1,1,-1,250765),-- Stone of Purity
(20753,4601,1,1,-1,8359),-- Greater Dye of Strength <Str+3 Con-3>
(20753,57,1488,3024,0,700000),-- Adena
(20753,75,1,1,1,8),-- Caliburs
(20753,76,1,1,1,8),-- Sword of Delusion
(20753,77,1,1,1,8),-- Tsurugi
(20753,84,1,1,1,8),-- Homunkulus\'s Sword
(20753,134,1,1,1,8),-- Sword of Nightmare
(20753,145,1,1,1,8),-- Sword of Whispering Death
(20753,2089,1,1,1,706),-- Caliburs Edge
(20753,2090,1,1,1,706),-- Delusional Blade
(20753,2091,1,1,1,706),-- Tsurugi Blade
(20753,2092,1,1,1,706),-- Homunkulus\'s Sword Blade
(20753,2095,1,1,1,706),-- Sword of Nightmare Blade
(20753,2096,1,1,1,706),-- Sword of Whispering Death Blade
(20753,1342,10,30,2,239311),-- Fine Steel Arrow
(20753,1868,1,3,2,119655),-- Thread
(20753,1873,1,1,2,47862),-- Silver Nugget
(20753,1889,1,1,2,7977),-- Compound Braid
(20753,2355,1,1,2,195),-- Recipe: Ghoul\'s Staff
(20753,3019,1,1,2,3191),-- Recipe: Full Plate Shield
(20753,4044,1,1,2,3988),-- Thons
(20753,4609,1,1,2,266),-- Greater Dye of Mental Strength <Men+3 Int-3>
(20753,5549,1,1,2,11965),-- Metallic Thread
(20753,8725,1,1,200,3324),-- Life Stone: level 52
(20753,8735,1,1,200,831),-- Mid-Grade Life Stone: level 52
(20753,8745,1,1,200,83),-- High-Grade Life Stone: level 52
(20753,8755,1,1,200,17),-- Top-Grade Life Stone: level 52
(20754,1869,1,9,-1,826759),-- Iron Ore
(20754,1911,1,1,-1,307460),-- Earring of Protection Gemstone
(20754,1967,1,1,-1,225459),-- Plated Leather Gaiters Material
(20754,57,1634,3323,0,700000),-- Adena
(20754,94,1,1,1,83),-- Bec de Corbin
(20754,2079,1,1,1,6292),-- Bec De Corbin Blade
(20754,1864,1,3,2,166508),-- Stem
(20754,1869,1,1,2,166508),-- Iron Ore
(20754,1880,1,1,2,16651),-- Steel
(20754,2167,1,1,2,8495),-- Recipe: Ring of Ages
(20754,3009,1,1,2,6796),-- Recipe: Composite Boots
(20754,4043,1,1,2,5550),-- Asofe
(20754,5550,1,1,2,2220),-- Durable Metal Plate
(20754,8724,1,1,200,5550),-- Life Stone: level 49
(20754,8734,1,1,200,1388),-- Mid-Grade Life Stone: level 49
(20754,8744,1,1,200,139),-- High-Grade Life Stone: level 49
(20754,8754,1,1,200,28),-- Top-Grade Life Stone: level 49
(20755,1061,1,1,-1,484352),-- Healing Potion
(20755,1900,1,1,-1,87438),-- Enchanted Necklace Chain
(20755,2184,1,1,-1,83948),-- Recipe: Mithril Banded Gaiters
(20755,57,337,674,0,700000),-- Adena
(20755,222,1,1,1,176),-- Poniard Dagger
(20755,1341,10,30,2,181969),-- Bone Arrow
(20755,1829,1,1,2,21836),-- Scroll of Escape: Clan Hall
(20755,1876,1,1,2,10918),-- Mithril Ore
(20755,1877,1,1,2,2184),-- Adamantite Nugget
(20755,1880,1,1,2,5459),-- Steel
(20755,1881,1,1,2,7279),-- Coarse Bone Powder
(20755,1882,1,1,2,12131),-- Leather
(20755,2274,1,1,2,390),-- Recipe: Skull Breaker
(20756,1899,1,1,-1,121223),-- Necklace of Devotion Chain
(20756,1932,1,1,-1,123147),-- Bone Helmet Design
(20756,2262,1,1,-1,12047),-- Recipe: Elven Bow
(20756,57,333,651,0,700000),-- Adena
(20756,274,1,1,1,276),-- Strengthened Bow
(20756,1868,1,1,2,174168),-- Thread
(20756,1873,1,1,2,34834),-- Silver Nugget
(20756,1876,1,1,2,17417),-- Mithril Ore
(20756,2152,1,1,2,15332),-- Recipe: Enchanted Necklace
(20756,6035,1,1,2,7257),-- Magic Haste Potion
(20757,847,1,1,-1,5530),-- Red Crescent Earring
(20757,1868,1,3,-1,572349),-- Thread
(20757,2180,1,1,-1,43034),-- Recipe: Scale Mail
(20757,57,247,476,0,700000),-- Adena
(20757,291,1,1,1,102),-- Trident
(20757,2019,1,1,1,3454),-- Trident Edge
(20757,1875,1,1,2,3569),-- Stone of Purity
(20757,1879,1,1,2,8923),-- Cokes
(20757,1885,1,1,2,4461),-- High Grade Suede
(20757,2152,1,1,2,9425),-- Recipe: Enchanted Necklace
(20757,5549,1,1,2,5354),-- Metallic Thread
(20757,5550,1,1,2,714),-- Durable Metal Plate
(20758,2167,1,1,-1,107248),-- Recipe: Ring of Ages
(20758,2946,1,1,-1,117499),-- Plate Leather Gloves Design
(20758,57,830,1692,0,700000),-- Adena
(20758,853,1,1,1,206),-- Earring of Protection
(20758,884,1,1,1,310),-- Ring of Protection
(20758,916,1,1,1,155),-- Necklace of Protection
(20758,1911,1,1,1,11547),-- Earring of Protection Gemstone
(20758,1912,1,1,1,16729),-- Ring of Protection Gemstone
(20758,1913,1,1,1,9440),-- Necklace of Protection Gemstone
(20758,952,1,1,2,1242),-- Scroll: Enchant Armor (Grade C)
(20758,1867,1,1,2,124183),-- Animal Skin
(20758,1872,1,1,2,124183),-- Animal Bone
(20758,1875,1,1,2,6209),-- Stone of Purity
(20758,1881,1,1,2,12418),-- Coarse Bone Powder
(20758,4041,1,1,2,810),-- Mold Hardener
(20758,8724,1,1,200,3104),-- Life Stone: level 49
(20758,8734,1,1,200,776),-- Mid-Grade Life Stone: level 49
(20758,8744,1,1,200,78),-- High-Grade Life Stone: level 49
(20758,8754,1,1,200,16),-- Top-Grade Life Stone: level 49
(20759,1912,1,1,-1,212904),-- Ring of Protection Gemstone
(20759,2166,1,1,-1,66974),-- Recipe: Earrings of Binding (100%)
(20759,2167,1,1,-1,100803),-- Recipe: Ring of Ages
(20759,57,781,1588,0,700000),-- Adena
(20759,398,1,1,1,64),-- Plated Leather
(20759,399,1,1,1,59),-- Rind Leather Armor
(20759,418,1,1,1,102),-- Plated Leather Gaiters
(20759,419,1,1,1,94),-- Rind Leather Gaiters
(20759,1966,1,1,1,3995),-- Plated Leather Fragment
(20759,1967,1,1,1,5968),-- Plated Leather Gaiters Material
(20759,1975,1,1,1,3594),-- Rind Leather Armor Design
(20759,1976,1,1,1,6654),-- Rind Leather Gaiters Material
(20759,952,1,1,2,1061),-- Scroll: Enchant Armor (Grade C)
(20759,1865,1,1,2,79853),-- Varnish
(20759,1870,1,1,2,79853),-- Coal
(20759,1874,1,1,2,5306),-- Oriharukon Ore
(20759,2168,1,1,2,2025),-- Recipe: Necklace of Mermaid
(20759,4039,1,1,2,2653),-- Mold Glue
(20759,4043,1,1,2,2653),-- Asofe
(20759,8724,1,1,200,2653),-- Life Stone: level 49
(20759,8734,1,1,200,663),-- Mid-Grade Life Stone: level 49
(20759,8744,1,1,200,66),-- High-Grade Life Stone: level 49
(20759,8754,1,1,200,14),-- Top-Grade Life Stone: level 49
(20760,951,1,1,-1,3728),-- Scroll: Enchant Weapon (Grade C)
(20760,1871,1,5,-1,683553),-- Charcoal
(20760,1911,1,1,-1,152522),-- Earring of Protection Gemstone
(20760,57,809,1651,0,700000),-- Adena
(20760,398,1,1,1,66),-- Plated Leather
(20760,399,1,1,1,61),-- Rind Leather Armor
(20760,418,1,1,1,106),-- Plated Leather Gaiters
(20760,419,1,1,1,98),-- Rind Leather Gaiters
(20760,1966,1,1,1,4146),-- Plated Leather Fragment
(20760,1967,1,1,1,6194),-- Plated Leather Gaiters Material
(20760,1975,1,1,1,3730),-- Rind Leather Armor Design
(20760,1976,1,1,1,6906),-- Rind Leather Gaiters Material
(20760,951,1,1,2,138),-- Scroll: Enchant Weapon (Grade C)
(20760,1866,1,1,2,50478),-- Suede
(20760,1871,1,1,2,75717),-- Charcoal
(20760,1877,1,1,2,3029),-- Adamantite Nugget
(20760,2327,1,1,2,176),-- Recipe: Caliburs
(20760,2343,1,1,2,176),-- Recipe: Mace of the Underworld
(20760,4040,1,1,2,1514),-- Mold Lubricant
(20760,4041,1,1,2,658),-- Mold Hardener
(20760,8724,1,1,200,2524),-- Life Stone: level 49
(20760,8734,1,1,200,631),-- Mid-Grade Life Stone: level 49
(20760,8744,1,1,200,63),-- High-Grade Life Stone: level 49
(20760,8754,1,1,200,13),-- Top-Grade Life Stone: level 49
(20761,1807,1,1,-1,11067),-- Recipe: Soulshot: A-Grade
(20761,1874,1,1,-1,553373),-- Oriharukon Ore
(20761,1875,1,1,-1,553373),-- Stone of Purity
(20761,57,3285,6671,0,700000),-- Adena
(20761,5287,1,1,1,23),-- Sealed Dark Crystal breastplate
(20761,5288,1,1,1,37),-- Sealed Dark Crystal Gaiters
(20761,5293,1,1,1,14),-- Sealed Tallum Plate Armor
(20761,5520,1,1,1,2635),-- Sealed Dark Crystal Breastplate Pattern
(20761,5521,1,1,1,1860),-- Sealed Tallum Plate Armor Pattern
(20761,5524,1,1,1,4028),-- Sealed Dark Crystal Gaiters Pattern
(20761,1868,1,3,2,204322),-- Thread
(20761,1873,1,1,2,81729),-- Silver Nugget
(20761,1889,1,1,2,13621),-- Compound Braid
(20761,4044,1,1,2,6811),-- Thons
(20761,4403,1,1,2,409),-- Red Dimensional Stone
(20761,4989,1,1,2,1353),-- Recipe: Stockings of Doom (60%)
(20761,5338,1,1,2,264),-- Recipe: Sealed Majestic Leather Armor(60%)
(20761,5549,1,1,2,20432),-- Metallic Thread
(20761,8730,1,1,200,2270),-- Life Stone: level 67
(20761,8740,1,1,200,567),-- Mid-Grade Life Stone: level 67
(20761,8750,1,1,200,57),-- High-Grade Life Stone: level 67
(20761,8760,1,1,200,12),-- Top-Grade Life Stone: level 67
(20762,1807,1,1,-1,7790),-- Recipe: Soulshot: A-Grade
(20762,5478,1,1,-1,49132),-- Sealed Dark Crystal Leather Armor Pattern
(20762,57,2311,4698,0,700000),-- Adena
(20762,5297,1,1,1,22),-- Sealed Dark Crystal Leather Armor
(20762,5298,1,1,1,34),-- Sealed Dark Crystalline Leggings
(20762,5301,1,1,1,13),-- Sealed Tallum Leather Armor
(20762,5478,1,1,1,2419),-- Sealed Dark Crystal Leather Armor Pattern
(20762,5479,1,1,1,1702),-- Sealed Tallum Leather Armor Pattern
(20762,5482,1,1,1,3796),-- Sealed Dark Crystalline Leggings Design
(20762,1807,1,1,2,209),-- Recipe: Soulshot: A-Grade
(20762,5336,1,1,2,203),-- Recipe: Sealed Leather Armor of Nightmare(60%)
(20762,1867,1,1,2,209196),-- Animal Skin
(20762,1872,1,1,2,209196),-- Animal Bone
(20762,1875,1,1,2,10460),-- Stone of Purity
(20762,1881,1,1,2,20920),-- Coarse Bone Powder
(20762,4041,1,1,2,1365),-- Mold Hardener
(20762,8730,1,1,200,1734),-- Life Stone: level 67
(20762,8740,1,1,200,436),-- Mid-Grade Life Stone: level 67
(20762,8750,1,1,200,44),-- High-Grade Life Stone: level 67
(20762,8760,1,1,200,9),-- Top-Grade Life Stone: level 67
(20763,1873,1,1,-1,609587),-- Silver Nugget
(20763,1902,1,1,-1,154404),-- Elven Earring Beads
(20763,1941,1,1,-1,60607),-- Brigandine Temper
(20763,57,636,1270,0,700000),-- Adena
(20763,129,1,1,1,73),-- Sword of Revolution
(20763,2034,1,1,1,4162),-- Sword of Revolution Blade
(20763,1867,1,1,2,175061),-- Animal Skin
(20763,1872,1,1,2,175061),-- Animal Bone
(20763,1875,1,1,2,8753),-- Stone of Purity
(20763,1881,1,1,2,17506),-- Coarse Bone Powder
(20763,2146,1,1,2,9378),-- Recipe: Artisan\'s frame
(20763,2196,1,1,2,5381),-- Recipe: Plate Gaiters
(20764,1825,1,1,-1,97110),-- Recipe: Oriharukon
(20764,1902,1,1,-1,137744),-- Elven Earring Beads
(20764,1903,1,1,-1,226779),-- Elven Ring Piece
(20764,57,575,1146,0,700000),-- Adena
(20764,437,1,1,1,204),-- Mithril Tunic
(20764,470,1,1,1,326),-- Mithril Stockings
(20764,1944,1,1,1,8962),-- Mithril Tunic Fabric
(20764,1945,1,1,1,13955),-- Mithril Stocking Design
(20764,1867,1,1,2,156173),-- Animal Skin
(20764,1872,1,1,2,156173),-- Animal Bone
(20764,1875,1,1,2,7809),-- Stone of Purity
(20764,1881,1,1,2,15617),-- Coarse Bone Powder
(20764,2149,1,1,2,8366),-- Recipe: Metallic Fiber
(20764,5473,1,1,2,8366),-- Recipe: Durable Metal Plate(100%)
(20765,1873,1,1,-1,470534),-- Silver Nugget
(20765,1904,1,1,-1,109784),-- Elven Necklace Beads
(20765,2145,1,1,-1,84024),-- Recipe: Mithril Alloy
(20765,57,497,993,0,700000),-- Adena
(20765,850,1,1,1,282),-- Elven Earring
(20765,881,1,1,1,423),-- Elven Ring
(20765,913,1,1,1,212),-- Elven Necklace
(20765,1902,1,1,1,10268),-- Elven Earring Beads
(20765,1903,1,1,1,16905),-- Elven Ring Piece
(20765,1904,1,1,1,9458),-- Elven Necklace Beads
(20765,1868,1,1,2,202692),-- Thread
(20765,1873,1,1,2,40538),-- Silver Nugget
(20765,1876,1,1,2,20269),-- Mithril Ore
(20765,1895,1,1,2,28956),-- Metallic Fiber
(20765,2145,1,1,2,7239),-- Recipe: Mithril Alloy
(20765,2158,1,1,2,12543),-- Recipe: Mithril Ring
(20766,1869,1,3,-1,525817),-- Iron Ore
(20766,1901,1,1,-1,145253),-- Tiger\'s Eye Earring Stone
(20766,2154,1,1,-1,112595),-- Recipe: Elven Earring
(20766,57,443,889,0,700000),-- Adena
(20766,63,1,1,1,409),-- Gauntlets
(20766,553,1,1,1,409),-- Iron Boots
(20766,1940,1,1,1,11922),-- Iron Boots Design
(20766,2422,1,1,1,409),-- Reinforced Leather Boots
(20766,2423,1,1,1,409),-- Boots of Knowledge
(20766,2446,1,1,1,409),-- Reinforced Leather Gloves
(20766,2447,1,1,1,409),-- Gloves of Knowledge
(20766,1864,1,1,2,159756),-- Stem
(20766,1869,1,1,2,79878),-- Iron Ore
(20766,1878,1,1,2,31951),-- Braided Hemp
(20766,1884,1,1,2,49156),-- Cord
(20766,2155,1,1,2,12821),-- Recipe: Elven Ring
(20766,2195,1,1,2,2043),-- Recipe: Half Plate Armor
(20766,6035,1,1,2,6657),-- Magic Haste Potion
(20767,1879,1,1,-1,319728),-- Cokes
(20767,2076,1,1,-1,15046),-- Body Slasher Blade
(20767,2220,1,1,-1,39718),-- Recipe: Rind Leather Armor
(20767,57,759,1541,0,700000),-- Adena
(20767,281,1,1,1,51),-- Crystallized Ice Bow
(20767,2074,1,1,1,3211),-- Crystallized Ice Bow Shaft
(20767,1865,1,1,2,75554),-- Varnish
(20767,1870,1,1,2,75554),-- Coal
(20767,1875,1,1,2,5037),-- Stone of Purity
(20767,1879,1,1,2,12592),-- Cokes
(20767,2225,1,1,2,1642),-- Recipe: Demon\'s Stockings
(20767,2321,1,1,2,263),-- Recipe: Stiletto
(20767,2322,1,1,2,263),-- Recipe: Soulfire Dirk
(20767,4040,1,1,2,1511),-- Mold Lubricant
(20767,8723,1,1,200,3022),-- Life Stone: level 46
(20767,8733,1,1,200,756),-- Mid-Grade Life Stone: level 46
(20767,8743,1,1,200,76),-- High-Grade Life Stone: level 46 
(20767,8753,1,1,200,15),-- Top-Grade Life Stone: level 46 
(20768,1908,1,1,-1,174999),-- Moonstone Earring Wire
(20768,1909,1,1,-1,249560),-- Aquastone Ring Wire
(20768,2163,1,1,-1,94285),-- Recipe: Earring of Protection
(20768,57,727,1491,0,700000),-- Adena
(20768,631,1,1,1,285),-- Eldarake
(20768,1964,1,1,1,11762),-- Eldarake Temper
(20768,2413,1,1,1,200),-- Chain Hood
(20768,2495,1,1,1,285),-- Chain Shield
(20768,2936,1,1,1,10683),-- Chain Hood Pattern
(20768,2945,1,1,1,11762),-- Chain Shield Fragment
(20768,1832,1,1,2,80869),-- Greater Antidote
(20768,1865,1,1,2,72782),-- Varnish
(20768,1870,1,1,2,72782),-- Coal
(20768,1875,1,1,2,4852),-- Stone of Purity
(20768,1879,1,1,2,12130),-- Cokes
(20768,2163,1,1,2,3713),-- Recipe: Earring of Protection
(20768,2315,1,1,2,254),-- Recipe: Shamshir
(20768,2319,1,1,2,254),-- Recipe: Raid Sword
(20768,8723,1,1,200,2911),-- Life Stone: level 46
(20768,8733,1,1,200,728),-- Mid-Grade Life Stone: level 46
(20768,8743,1,1,200,73),-- High-Grade Life Stone: level 46 
(20768,8753,1,1,200,15),-- Top-Grade Life Stone: level 46 
(20769,1885,1,1,-1,122609),-- High Grade Suede
(20769,4469,1,1,-1,8407),-- Dye of Strength <Str+1 Con-1>
(20769,5220,1,1,-1,58852),-- Metal Hardener
(20769,57,582,1182,0,700000),-- Adena
(20769,70,1,1,1,27),-- Claymore
(20769,2047,1,1,1,1624),-- Claymore Blade
(20769,2499,1,1,1,27),-- Elven Long Sword
(20769,2967,1,1,1,1602),-- Elven Long Sword Blade
(20769,1866,1,1,2,70364),-- Suede
(20769,1871,1,1,2,105546),-- Charcoal
(20769,1885,1,1,2,8795),-- High Grade Suede
(20769,2161,1,1,2,10247),-- Recipe: Aquastone Ring
(20769,2297,1,1,2,461),-- Recipe: Flamberge
(20769,5220,1,1,2,4222),-- Metal Hardener
(20769,5269,1,1,2,352),-- Recipe: Greater Soulshot (C) Compressed Package(100%)
(20770,1805,1,1,-1,5726),-- Recipe: Soulshot: C-Grade
(20770,1905,1,1,-1,167101),-- Omen Beast\'s Eye Earring Gemstone
(20770,1906,1,1,-1,236124),-- Mithril Ring Wire
(20770,57,696,1393,0,700000),-- Adena
(20770,159,1,1,1,12),-- Bonebreaker
(20770,187,1,1,1,12),-- Atuba Hammer
(20770,188,1,1,1,12),-- Ghost Staff
(20770,189,1,1,1,12),-- Staff of Life
(20770,190,1,1,1,12),-- Atuba Mace
(20770,2048,1,1,1,713),-- Bonebreaker Head
(20770,2049,1,1,1,713),-- Atuba Hammer Head
(20770,2050,1,1,1,756),-- Ghost Staff Head
(20770,2051,1,1,1,756),-- Staff of Life Shaft
(20770,2058,1,1,1,713),-- Atuba Mace Head
(20770,1805,1,1,2,411),-- Recipe: Soulshot: C-Grade
(20770,1867,1,1,2,164305),-- Animal Skin
(20770,1872,1,1,2,164305),-- Animal Bone
(20770,1882,1,1,2,27384),-- Leather
(20770,1894,1,1,2,4324),-- Crafted Leather
(20770,2298,1,1,2,538),-- Recipe: Stormbringer
(20770,5269,1,1,2,411),-- Recipe: Greater Soulshot (C) Compressed Package(100%)
(20771,948,1,1,-1,13401),-- Scroll: Enchant Armor (Grade B)
(20771,1875,1,1,-1,357372),-- Stone of Purity
(20771,4042,1,1,-1,89343),-- Enria
(20771,57,2128,4304,0,700000),-- Adena
(20771,171,1,1,1,5),-- Deadman\'s Glory
(20771,175,1,1,1,5),-- Art of Battle Axe
(20771,210,1,1,1,5),-- Staff of Evil Spirits
(20771,4116,1,1,1,1153),-- Deadman\'s Glory Stone
(20771,4117,1,1,1,1153),-- Art of Battle Axe Blade
(20771,4118,1,1,1,1092),-- Evil Spirit Head
(20771,1895,1,1,2,45241),-- Metallic Fiber
(20771,4040,1,1,2,3167),-- Mold Lubricant
(20771,4042,1,1,2,2639),-- Enria
(20771,4043,1,1,2,5278),-- Asofe
(20771,4953,1,1,2,3051),-- Recipe: Avadon Gloves (60%)
(20771,5276,1,1,2,211),-- Recipe: Greater Spiritshot (A) Compressed Package(100%)
(20771,8729,1,1,200,2111),-- Life Stone: level 64
(20771,8739,1,1,200,528),-- Mid-Grade Life Stone: level 64
(20771,8749,1,1,200,53),-- High-Grade Life Stone: level 64
(20771,8759,1,1,200,11),-- Top-Grade Life Stone: level 64
(20772,1875,1,1,-1,344772),-- Stone of Purity
(20772,1986,1,1,-1,54648),-- Full Plate Armor Temper
(20772,4613,1,1,-1,7133),-- Greater Dye of Strength <Str+4 Con-4>
(20772,57,2049,4156,0,700000),-- Adena
(20772,300,1,1,1,23),-- Great Axe
(20772,4113,1,1,1,3930),-- Great Axe Head
(20772,1867,1,1,2,169733),-- Animal Skin
(20772,1872,1,1,2,169733),-- Animal Bone
(20772,1875,1,1,2,8487),-- Stone of Purity
(20772,1881,1,1,2,16973),-- Coarse Bone Powder
(20772,4041,1,1,2,1107),-- Mold Hardener
(20772,4163,1,1,2,843),-- Recipe: Blue Wolf Stockings
(20772,4618,1,1,2,176),-- Greater Dye of Dexterity <Dex+4 Con-4>
(20772,4999,1,1,2,1583),-- Recipe: Doom Boots (60%)
(20772,8728,1,1,200,2122),-- Life Stone: level 61
(20772,8738,1,1,200,530),-- Mid-Grade Life Stone: level 61
(20772,8748,1,1,200,53),-- High-Grade Life Stone: level 61
(20772,8758,1,1,200,11),-- Top-Grade Life Stone: level 61
(20773,1807,1,1,-1,4726),-- Recipe: Soulshot: A-Grade
(20773,5478,1,1,-1,29805),-- Sealed Dark Crystal Leather Armor Pattern
(20773,5479,1,1,-1,20973),-- Sealed Tallum Leather Armor Pattern
(20773,57,1748,3569,0,700000),-- Adena
(20773,6323,1,1,1,33),-- Sealed Phoenix Necklace
(20773,6324,1,1,1,43),-- Sealed Phoenix Earring
(20773,6325,1,1,1,65),-- Sealed Phoenix Ring
(20773,6341,1,1,1,6033),-- Sealed Phoenix Earring Gemstone
(20773,6343,1,1,1,4663),-- Sealed Phoenix Necklace Beads
(20773,6345,1,1,1,8344),-- Sealed Phoenix Ring Gemstone
(20773,730,1,1,2,99),-- Scroll: Enchant Armor (Grade A)
(20773,1868,1,1,2,237949),-- Thread
(20773,1873,1,1,2,47590),-- Silver Nugget
(20773,1889,1,1,2,7932),-- Compound Braid
(20773,4044,1,1,2,3966),-- Thons
(20773,4157,1,1,2,592),-- Recipe: Blue Wolf Gaiters
(20773,5549,1,1,2,11897),-- Metallic Thread
(20773,8730,1,1,200,1322),-- Life Stone: level 67
(20773,8740,1,1,200,330),-- Mid-Grade Life Stone: level 67
(20773,8750,1,1,200,33),-- High-Grade Life Stone: level 67
(20773,8760,1,1,200,7),-- Top-Grade Life Stone: level 67
(20774,1807,1,1,-1,6216),-- Recipe: Soulshot: A-Grade
(20774,1889,1,1,-1,310807),-- Compound Braid
(20774,5478,1,1,-1,39204),-- Sealed Dark Crystal Leather Armor Pattern
(20774,57,1844,3751,0,700000),-- Adena
(20774,5290,1,1,1,39),-- Sealed Dark Crystal Gloves
(20774,5291,1,1,1,39),-- Sealed Dark Crystal Boots
(20774,5295,1,1,1,39),-- Sealed Tallum Gloves
(20774,5296,1,1,1,39),-- Sealed Tallum Boots
(20774,5496,1,1,1,4037),-- Sealed Dark Crystal Boots Lining
(20774,5497,1,1,1,4037),-- Sealed Tallum Boots Lining
(20774,5508,1,1,1,4037),-- Sealed Dark Crystal Gloves Design
(20774,5509,1,1,1,4037),-- Sealed Tallum Gloves Design
(20774,1868,1,1,2,275423),-- Thread
(20774,1873,1,1,2,55085),-- Silver Nugget
(20774,1876,1,1,2,27543),-- Mithril Ore
(20774,1895,1,1,2,39346),-- Metallic Fiber
(20774,4042,1,1,2,2295),-- Enria
(20774,5271,1,1,2,184),-- Recipe: Greater Soulshot (A) Compressed Package(100%)
(20774,8730,1,1,200,1530),-- Life Stone: level 67
(20774,8740,1,1,200,383),-- Mid-Grade Life Stone: level 67
(20774,8750,1,1,200,38),-- High-Grade Life Stone: level 67
(20774,8760,1,1,200,7),-- Top-Grade Life Stone: level 67
(20775,1800,1,1,-1,76617),-- Recipe: Piece Bone Breastplate
(20775,1897,1,1,-1,58010),-- Necklace of Wisdom Chain
(20775,2253,1,1,-1,9985),-- Recipe: Sword Breaker
(20775,57,119,191,0,700000),-- Adena
(20775,15,1,1,1,137),-- Short Spear
(20775,2011,1,1,1,1643),-- Short Spear Edge
(20775,1868,1,1,2,95958),-- Thread
(20775,1873,1,1,2,19192),-- Silver Nugget
(20775,2144,1,1,2,9596),-- Recipe: Compound Braid
(20776,1865,1,1,-1,297237),-- Varnish
(20776,1866,1,1,-1,198158),-- Suede
(20776,1897,1,1,-1,70771),-- Necklace of Wisdom Chain
(20776,57,137,239,0,700000),-- Adena
(20776,1101,1,1,1,1126),-- Tunic of Devotion
(20776,1104,1,1,1,1797),-- Stockings of Devotion
(20776,735,1,1,2,1626),-- Potion of Alacrity
(20776,1831,1,1,2,52030),-- Antidote
(20776,1867,1,1,2,26015),-- Animal Skin
(20776,1869,1,1,2,19511),-- Iron Ore
(20776,1870,1,1,2,19511),-- Coal
(20776,1871,1,1,2,19511),-- Charcoal
(20776,1872,1,1,2,26015),-- Animal Bone
(20776,2140,1,1,2,3903),-- Recipe: High Grade Suede
(20776,5158,1,1,2,781),-- Recipe: Spiritshot (D) Compressed Package (100%)
(20777,1792,1,1,-1,16388),-- Recipe: Short Spear
(20777,1831,1,1,-1,594351),-- Antidote
(20777,1896,1,1,-1,94441),-- Necklace of Anguish Chain
(20777,57,114,168,0,700000),-- Adena
(20777,37,1,1,1,4303),-- Leather Shoes
(20777,49,1,1,1,4303),-- Gloves
(20777,1921,1,1,1,28317),-- Leather Shoes Texture
(20777,1794,1,1,2,3228),-- Recipe: Forest Bow
(20777,1868,1,1,2,87782),-- Thread
(20777,1873,1,1,2,17557),-- Silver Nugget
(20778,1902,1,1,-1,98693),-- Elven Earring Beads
(20778,1903,1,1,-1,162485),-- Elven Ring Piece
(20778,2290,1,1,-1,5412),-- Recipe: Mithril Dagger
(20778,57,412,821,0,700000),-- Adena
(20778,352,1,1,1,73),-- Brigandine Tunic
(20778,1941,1,1,1,3337),-- Brigandine Temper
(20778,2377,1,1,1,117),-- Mithril Scale Gaiters
(20778,2378,1,1,1,117),-- Brigandine Gaiters
(20778,2918,1,1,1,4979),-- Mithril Scale Gaiters Material
(20778,2919,1,1,1,4979),-- Brigandine Gaiters Material
(20778,1866,1,1,2,55948),-- Suede
(20778,1871,1,1,2,83922),-- Charcoal
(20778,1877,1,1,2,3357),-- Adamantite Nugget
(20778,2202,1,1,2,8581),-- Recipe: Assault Boots
(20778,2288,1,1,2,466),-- Recipe: Ghost Staff
(20778,2289,1,1,2,466),-- Recipe: Staff of Life
(20779,1866,1,1,-1,579821),-- Suede
(20779,1904,1,1,-1,81170),-- Elven Necklace Beads
(20779,2158,1,1,-1,107640),-- Recipe: Mithril Ring
(20779,57,368,733,0,700000),-- Adena
(20779,318,1,1,1,42),-- Crucifix of Blood
(20779,2042,1,1,1,2077),-- Crucifix of Blood Piece
(20779,1866,1,1,2,59944),-- Suede
(20779,1871,1,1,2,89917),-- Charcoal
(20779,1877,1,1,2,3597),-- Adamantite Nugget
(20779,2286,1,1,2,500),-- Recipe: Bonebreaker
(20779,2290,1,1,2,500),-- Recipe: Mithril Dagger
(20780,1877,1,1,-1,28514),-- Adamantite Nugget
(20780,1901,1,1,-1,98461),-- Tiger\'s Eye Earring Stone
(20780,2980,1,1,-1,95429),-- Recipe: Brigandine Gauntlets
(20780,57,301,601,0,700000),-- Adena
(20780,157,1,1,1,34),-- Spiked Club
(20780,186,1,1,1,34),-- Staff of Magic
(20780,2027,1,1,1,1655),-- Spiked Club Head
(20780,1866,1,1,2,63170),-- Suede
(20780,1871,1,1,2,94755),-- Charcoal
(20780,1877,1,1,2,3790),-- Adamantite Nugget
(20780,2186,1,1,2,3169),-- Recipe: Brigandine Tunic
(20781,1901,1,1,-1,97496),-- Tiger\'s Eye Earring Stone
(20781,1938,1,1,-1,47453),-- Mithril Banded Mail Material
(20781,2192,1,1,-1,90034),-- Recipe: Kite Shield
(20781,57,298,595,0,700000),-- Adena
(20781,436,1,1,1,321),-- Tunic of Knowledge
(20781,469,1,1,1,512),-- Stockings of Knowledge
(20781,1875,1,1,2,3128),-- Stone of Purity
(20781,1879,1,1,2,7819),-- Cokes
(20781,1885,1,1,2,3909),-- High Grade Suede
(20781,2187,1,1,2,2094),-- Recipe: Manticore Skin Shirt
(20781,2273,1,1,2,335),-- Recipe: Tarbar
(20781,5549,1,1,2,4691),-- Metallic Thread
(20781,5550,1,1,2,626),-- Durable Metal Plate
(20781,6667,1,1,2,29321),-- Deluxe Chest Key - Grade 3
(20782,1800,1,1,-1,78931),-- Recipe: Piece Bone Breastplate
(20782,1801,1,1,-1,126448),-- Recipe: Piece Bone Gaiters
(20782,1924,1,1,-1,80968),-- Leather Helmet Design
(20782,57,122,197,0,700000),-- Adena
(20782,256,1,1,1,282),-- Cestus
(20782,1867,1,1,2,49428),-- Animal Skin
(20782,1872,1,1,2,49428),-- Animal Bone
(20782,2150,1,1,2,17405),-- Recipe: Blue Diamond Necklace
(20782,5268,1,1,2,1483),-- Recipe: Greater Soulshot (D) Compressed Package (100%)
(20783,1900,1,1,-1,35448),-- Enchanted Necklace Chain
(20783,1935,1,1,-1,18100),-- Scale Mail Fragment
(20783,2203,1,1,-1,70587),-- Recipe: Mithril Boots
(20783,57,137,273,0,700000),-- Adena
(20783,316,1,1,1,15),-- Blood of Saints
(20783,317,1,1,1,15),-- Tome of Blood
(20783,2030,1,1,1,671),-- Tome of Blood Page
(20783,1874,1,1,2,1436),-- Oriharukon Ore
(20783,1878,1,1,2,8613),-- Braided Hemp
(20783,1884,1,1,2,13251),-- Cord
(20783,1889,1,1,2,1436),-- Compound Braid
(20783,2153,1,1,2,3349),-- Recipe: Tiger\'s Eye Earring
(20783,2977,1,1,2,2883),-- Recipe: Brigandine Boots
(20783,8307,1,1,2,154),-- Recipe: Priest Mace (100%)
(20783,5220,1,1,2,861),-- Metal Hardener
(20784,2021,1,1,-1,4623),-- Spinebone Sword Blade
(20784,2153,1,1,-1,56945),-- Recipe: Tiger\'s Eye Earring
(20784,2184,1,1,-1,38461),-- Recipe: Mithril Banded Gaiters
(20784,57,154,309,0,700000),-- Adena
(20784,83,1,1,1,12),-- Sword of Magic
(20784,124,1,1,1,9),-- Two-Handed Sword
(20784,127,1,1,1,9),-- Crimson Sword
(20784,130,1,1,1,9),-- Elven Sword
(20784,144,1,1,1,12),-- Sword of Occult
(20784,2026,1,1,1,390),-- Two-Handed Sword Edge
(20784,1875,1,1,2,2163),-- Stone of Purity
(20784,1879,1,1,2,5408),-- Cokes
(20784,1885,1,1,2,2704),-- High Grade Suede
(20784,2250,1,1,2,8112),-- Recipe: Bone Arrow
(20784,5549,1,1,2,3245),-- Metallic Thread
(20784,5550,1,1,2,433),-- Durable Metal Plate
(20785,1875,1,1,-1,23539),-- Stone of Purity
(20785,1933,1,1,-1,41540),-- Dark Stocking Fabric
(20785,2022,1,1,-1,5500),-- Mace of Judgment Head
(20785,57,149,298,0,700000),-- Adena
(20785,606,1,1,1,40),-- Rip Gauntlets
(20785,1124,1,1,1,40),-- Boots of Power
(20785,1946,1,1,1,1542),-- Rip Gauntlets Pattern
(20785,1948,1,1,1,1542),-- Boots of Power Pattern
(20785,2424,1,1,1,40),-- Manticore Skin Boots
(20785,2425,1,1,1,40),-- Brigandine Boots
(20785,2426,1,1,1,40),-- Elven Mithril Boots
(20785,2448,1,1,1,40),-- Manticore Skin Gloves
(20785,2449,1,1,1,40),-- Brigandine Gauntlets
(20785,2450,1,1,1,40),-- Elven Mithril Gloves
(20785,2923,1,1,1,1542),-- Manticore Skin Boot Lining
(20785,2924,1,1,1,1542),-- Brigandine Boots Design
(20785,2925,1,1,1,1542),-- Elven Mithril Boots Design
(20785,2926,1,1,1,1542),-- Manticore Skin Gloves Lining
(20785,2927,1,1,1,1542),-- Brigandine Gauntlets Pattern
(20785,2928,1,1,1,1542),-- Elven Mithril Gloves Design
(20785,1341,10,30,2,67601),-- Bone Arrow
(20785,1875,1,1,2,1352),-- Stone of Purity
(20785,1879,1,1,2,3380),-- Cokes
(20785,1885,1,1,2,1690),-- High Grade Suede
(20785,2185,1,1,2,3992),-- Recipe: Iron Boots
(20785,2982,1,1,2,2587),-- Recipe: Brigandine Shield
(20785,5549,1,1,2,2028),-- Metallic Thread
(20785,5550,1,1,2,270),-- Durable Metal Plate
(20785,6667,1,1,2,12675),-- Deluxe Chest Key - Grade 3
(20786,2026,1,1,-1,4711),-- Two-Handed Sword Edge
(20786,2155,1,1,-1,62822),-- Recipe: Elven Ring
(20786,5550,1,1,-1,5218),-- Durable Metal Plate
(20786,57,166,330,0,700000),-- Adena
(20786,395,1,1,1,59),-- Manticore Skin Shirt
(20786,417,1,1,1,94),-- Manticore Skin Gaiters
(20786,1942,1,1,1,2580),-- Manticore Skin Shirt Texture
(20786,1943,1,1,1,4017),-- Manticore Skin Gaiters Pattern
(20786,1875,1,1,2,1686),-- Stone of Purity
(20786,1879,1,1,2,4215),-- Cokes
(20786,1885,1,1,2,2107),-- High Grade Suede
(20786,2278,1,1,2,181),-- Recipe: Strengthened Long Bow
(20786,2286,1,1,2,141),-- Recipe: Bonebreaker
(20786,2977,1,1,2,3385),-- Recipe: Brigandine Boots
(20786,5549,1,1,2,2529),-- Metallic Thread
(20786,5550,1,1,2,337),-- Durable Metal Plate
(20787,1870,1,1,-1,476736),-- Coal
(20787,2029,1,1,-1,5687),-- Gastraphetes Shaft
(20787,5549,1,1,-1,47674),-- Metallic Thread
(20787,57,199,397,0,700000),-- Adena
(20787,850,1,1,1,114),-- Elven Earring
(20787,881,1,1,1,171),-- Elven Ring
(20787,913,1,1,1,86),-- Elven Necklace
(20787,1902,1,1,1,4161),-- Elven Earring Beads
(20787,1903,1,1,1,6851),-- Elven Ring Piece
(20787,1904,1,1,1,3833),-- Elven Necklace Beads
(20787,1341,10,30,2,91275),-- Bone Arrow
(20787,1832,1,1,2,30425),-- Greater Antidote
(20787,1875,1,1,2,1825),-- Stone of Purity
(20787,1879,1,1,2,4564),-- Cokes
(20787,1885,1,1,2,2282),-- High Grade Suede
(20787,2188,1,1,2,1956),-- Recipe: Manticore Skin Gaiters
(20787,5473,1,1,2,1956),-- Recipe: Durable Metal Plate(100%)
(20787,5549,1,1,2,2738),-- Metallic Thread
(20787,5550,1,1,2,365),-- Durable Metal Plate
(20788,1901,1,2,-1,116020),-- Tiger\'s Eye Earring Stone
(20788,2186,1,1,-1,28093),-- Recipe: Brigandine Tunic
(20788,57,355,708,0,700000),-- Adena
(20788,260,1,1,1,120),-- Triple-Edged Jamadhr
(20788,1874,1,1,2,3722),-- Oriharukon Ore
(20788,1878,1,1,2,22331),-- Braided Hemp
(20788,1884,1,1,2,34355),-- Cord
(20788,1889,1,1,2,3722),-- Compound Braid
(20788,2189,1,1,2,2492),-- Recipe: Mithril Tunic
(20788,2275,1,1,2,399),-- Recipe: Heavy Bone Club
(20788,2293,1,1,2,310),-- Recipe: Glaive
(20788,5220,1,1,2,2233),-- Metal Hardener
(20789,2030,1,1,-1,9246),-- Tome of Blood Page
(20789,2154,1,1,-1,84644),-- Recipe: Elven Earring
(20789,2188,1,1,-1,56469),-- Recipe: Manticore Skin Gaiters
(20789,57,333,668,0,700000),-- Adena
(20789,393,1,1,1,120),-- Mithril Banded Mail
(20789,394,1,1,1,120),-- Reinforced Leather Shirt
(20789,415,1,1,1,191),-- Mithril Banded Gaiters
(20789,416,1,1,1,191),-- Reinforced Leather Gaiters
(20789,1938,1,1,1,4710),-- Mithril Banded Mail Material
(20789,1939,1,1,1,6153),-- Mithril Banded Gaiters Material
(20789,1341,10,30,2,175140),-- Bone Arrow
(20789,1661,1,1,2,10509),-- Thief Key
(20789,1874,1,1,2,3503),-- Oriharukon Ore
(20789,1878,1,1,2,21017),-- Braided Hemp
(20789,1884,1,1,2,32334),-- Cord
(20789,1889,1,1,2,3503),-- Compound Braid
(20789,2275,1,1,2,375),-- Recipe: Heavy Bone Club
(20789,5220,1,1,2,2102),-- Metal Hardener
(20790,1868,1,5,-1,674568),-- Thread
(20790,1902,1,1,-1,102518),-- Elven Earring Beads
(20790,2039,1,1,-1,10243),-- Bich\'Hwa Edge
(20790,57,428,853,0,700000),-- Adena
(20790,224,1,1,1,24),-- Maingauche
(20790,1660,1,1,1,24),-- Cursed Maingauche
(20790,2038,1,1,1,1382),-- Maingauche Edge
(20790,2044,1,1,1,1382),-- Cursed Maingauche Edge
(20790,1341,10,30,2,174343),-- Bone Arrow
(20790,1874,1,1,2,3487),-- Oriharukon Ore
(20790,1878,1,1,2,20921),-- Braided Hemp
(20790,1884,1,1,2,32186),-- Cord
(20790,1889,1,1,2,3487),-- Compound Braid
(20790,2147,1,1,2,3736),-- Recipe: Blacksmith\'s frame
(20790,2289,1,1,2,291),-- Recipe: Staff of Life
(20790,2984,1,1,2,5348),-- Recipe: Salamander Skin Boots
(20790,5220,1,1,2,2092),-- Metal Hardener
(20790,6667,1,1,2,32690),-- Deluxe Chest Key - Grade 3
(20791,1825,1,1,-1,124190),-- Recipe: Oriharukon
(20791,2041,1,1,-1,19395),-- War Pick Head
(20791,2196,1,1,-1,71256),-- Recipe: Plate Gaiters
(20791,57,735,1467,0,700000),-- Adena
(20791,352,1,1,1,130),-- Brigandine Tunic
(20791,1941,1,1,1,5957),-- Brigandine Temper
(20791,2377,1,1,1,209),-- Mithril Scale Gaiters
(20791,2378,1,1,1,209),-- Brigandine Gaiters
(20791,2918,1,1,1,8887),-- Mithril Scale Gaiters Material
(20791,2919,1,1,1,8887),-- Brigandine Gaiters Material
(20791,1876,1,1,2,25679),-- Mithril Ore
(20791,1877,1,1,2,5136),-- Adamantite Nugget
(20791,1880,1,1,2,12839),-- Steel
(20791,1881,1,1,2,17119),-- Coarse Bone Powder
(20791,1882,1,1,2,28532),-- Leather
(20791,2198,1,1,2,2692),-- Recipe: Sage\'s Rag
(20791,3020,1,1,2,713),-- Recipe: Elven Long Sword
(20792,1903,1,1,-1,269842),-- Elven Ring Piece
(20792,2035,1,1,-1,16376),-- Tarbar Head
(20792,2202,1,1,-1,165409),-- Recipe: Assault Boots
(20792,57,684,1363,0,700000),-- Adena
(20792,88,1,1,1,16),-- Morning Star
(20792,90,1,1,1,16),-- Goat Head Staff
(20792,158,1,1,1,16),-- Tarbar
(20792,169,1,1,1,16),-- Skull Breaker
(20792,172,1,1,1,16),-- Heavy Bone Club
(20792,2031,1,1,1,846),-- Morning Star Head
(20792,2032,1,1,1,773),-- Goat Head Staff Head
(20792,2035,1,1,1,846),-- Tarbar Head
(20792,2036,1,1,1,846),-- Skull Breaker Head
(20792,2037,1,1,1,846),-- Heavy Bone Club Head
(20792,1876,1,1,2,23892),-- Mithril Ore
(20792,1877,1,1,2,4778),-- Adamantite Nugget
(20792,1880,1,1,2,11946),-- Steel
(20792,1881,1,1,2,15928),-- Coarse Bone Powder
(20792,1882,1,1,2,26547),-- Leather
(20792,2198,1,1,2,2504),-- Recipe: Sage\'s Rag
(20792,3020,1,1,2,664),-- Recipe: Elven Long Sword
(20793,1877,1,1,-1,70938),-- Adamantite Nugget
(20793,1881,1,1,-1,236461),-- Coarse Bone Powder
(20793,2037,1,1,-1,17953),-- Heavy Bone Club Head
(20793,57,740,1478,0,700000),-- Adena
(20793,93,1,1,1,43),-- Winged Spear
(20793,294,1,1,1,43),-- War Pick
(20793,2033,1,1,1,2556),-- Winged Spear Blade
(20793,2041,1,1,1,2556),-- War Pick Head
(20793,1341,10,30,2,381976),-- Bone Arrow
(20793,1876,1,1,2,22919),-- Mithril Ore
(20793,1877,1,1,2,4584),-- Adamantite Nugget
(20793,1880,1,1,2,11460),-- Steel
(20793,1881,1,1,2,15279),-- Coarse Bone Powder
(20793,1882,1,1,2,25465),-- Leather
(20793,2147,1,1,2,8185),-- Recipe: Blacksmith\'s frame
(20793,2205,1,1,2,3626),-- Recipe: Chain Gaiters
(20794,1866,1,3,-1,557627),-- Suede
(20794,1952,1,1,-1,53584),-- Salamander Skin Mail Texture
(20794,2991,1,1,-1,132768),-- Recipe: Karmian Boots
(20794,57,678,1356,0,700000),-- Adena
(20794,225,1,1,1,61),-- Mithril Dagger
(20794,2052,1,1,1,3642),-- Mithril Dagger Blade
(20794,1866,1,1,2,80004),-- Suede
(20794,1871,1,1,2,120006),-- Charcoal
(20794,1885,1,1,2,10000),-- High Grade Suede
(20794,2206,1,1,2,3166),-- Recipe: Mithril Shirt
(20794,4556,1,1,2,480),-- Greater Dye of Constitution <Con+1 Dex-1>
(20794,5220,1,1,2,4800),-- Metal Hardener
(20794,5274,1,1,2,400),-- Recipe: Greater Spiritshot (C) Compressed Package(100%)
(20795,2047,1,1,-1,13879),-- Claymore Blade
(20795,2161,1,1,-1,153276),-- Recipe: Aquastone Ring
(20795,4469,1,1,-1,9021),-- Dye of Strength <Str+1 Con-1>
(20795,57,636,1285,0,700000),-- Adena
(20795,851,1,1,1,283),-- Omen Beast\'s Eye Earring
(20795,882,1,1,1,425),-- Mithril Ring
(20795,914,1,1,1,212),-- Necklace of Darkness
(20795,1905,1,1,1,12853),-- Omen Beast\'s Eye Earring Gemstone
(20795,1906,1,1,1,18162),-- Mithril Ring Wire
(20795,1907,1,1,1,9191),-- Necklace of Darkness Gem
(20795,736,1,1,2,56627),-- Scroll of Escape
(20795,1867,1,1,2,151004),-- Animal Skin
(20795,1872,1,1,2,151004),-- Animal Bone
(20795,1882,1,1,2,25168),-- Leather
(20795,1894,1,1,2,3974),-- Crafted Leather
(20795,2303,1,1,2,494),-- Recipe: Skull Graver
(20795,2304,1,1,2,495),-- Recipe: Heavy Doom Hammer
(20796,1905,1,1,-1,165167),-- Omen Beast\'s Eye Earring Gemstone
(20796,2199,1,1,-1,71642),-- Recipe: Karmian Stockings
(20796,2930,1,1,-1,136873),-- Plate Helmet Design
(20796,57,671,1364,0,700000),-- Adena
(20796,396,1,1,1,233),-- Salamander Skin Mail
(20796,1952,1,1,1,13654),-- Salamander Skin Mail Texture
(20796,737,1,1,2,8526),-- Scroll of Resurrection
(20796,1868,1,1,2,170523),-- Thread
(20796,1873,1,1,2,34104),-- Silver Nugget
(20796,1889,1,1,2,5684),-- Compound Braid
(20796,2998,1,1,2,6411),-- Recipe: Chain Shield
(20796,3033,1,1,2,284),-- Recipe: Spiritshot C
(20796,3954,1,1,2,284),-- Recipe: Blessed Spiritshot C
(20796,4557,1,1,2,341),-- Greater Dye of Dexterity <Dex+1 Str-1>
(20796,5549,1,1,2,8526),-- Metallic Thread
(20796,6668,1,1,2,30450),-- Deluxe Chest Key - Grade 4
(20797,1908,1,1,-1,244093),-- Moonstone Earring Wire
(20797,2163,1,1,-1,131511),-- Recipe: Earring of Protection
(20797,4440,1,1,-1,8981),-- Recipe: Knuckle Duster
(20797,57,1015,2079,0,700000),-- Adena
(20797,397,1,1,1,209),-- Mithril Shirt
(20797,1961,1,1,1,9746),-- Mithril Shirt Fabric
(20797,2387,1,1,1,335),-- Tempered Mithril Gaiters
(20797,2935,1,1,1,16192),-- Tempered Mithril Gaiters Fragment
(20797,1864,1,1,2,221495),-- Stem
(20797,1869,1,1,2,110748),-- Iron Ore
(20797,1880,1,1,2,11075),-- Steel
(20797,2220,1,1,2,2293),-- Recipe: Rind Leather Armor
(20797,2225,1,1,2,2407),-- Recipe: Demon\'s Stockings
(20797,2321,1,1,2,386),-- Recipe: Stiletto
(20797,5550,1,1,2,1477),-- Durable Metal Plate
(20797,8723,1,1,200,4430),-- Life Stone: level 46
(20797,8733,1,1,200,1108),-- Mid-Grade Life Stone: level 46
(20797,8743,1,1,200,111),-- High-Grade Life Stone: level 46 
(20797,8753,1,1,200,22),-- Top-Grade Life Stone: level 46 
(20798,1908,1,1,-1,197690),-- Moonstone Earring Wire
(20798,4042,1,1,-1,34793),-- Enria
(20798,4043,1,1,-1,69587),-- Asofe
(20798,57,826,1677,0,700000),-- Adena
(20798,71,1,1,1,28),-- Flamberge
(20798,72,1,1,1,28),-- Stormbringer
(20798,2059,1,1,1,1832),-- Flamberge Blade
(20798,2060,1,1,1,1958),-- Stormbringer Blade
(20798,1864,1,1,2,179388),-- Stem
(20798,1869,1,1,2,89694),-- Iron Ore
(20798,1880,1,1,2,8969),-- Steel
(20798,2220,1,1,2,1857),-- Recipe: Rind Leather Armor
(20798,2225,1,1,2,1950),-- Recipe: Demon\'s Stockings
(20798,5550,1,1,2,1196),-- Durable Metal Plate
(20798,2321,1,1,2,312),-- Recipe: Stiletto
(20798,8723,1,1,200,3588),-- Life Stone: level 46
(20798,8733,1,1,200,897),-- Mid-Grade Life Stone: level 46
(20798,8743,1,1,200,90),-- High-Grade Life Stone: level 46 
(20798,8753,1,1,200,18),-- Top-Grade Life Stone: level 46 
(20799,2065,1,1,-1,16244),-- Skull Graver Head
(20799,2164,1,1,-1,161662),-- Recipe: Ring of Protection
(20799,2317,1,1,-1,7323),-- Recipe: Bec de Corbin
(20799,57,828,1693,0,700000),-- Adena
(20799,354,1,1,1,128),-- Chain Mail Shirt
(20799,381,1,1,1,204),-- Chain Gaiters
(20799,1959,1,1,1,6688),-- Chain Mail Shirt Material
(20799,1960,1,1,1,13606),-- Chain Gaiters Part
(20799,1866,1,1,2,60197),-- Suede
(20799,1871,1,1,2,90296),-- Charcoal
(20799,1877,1,1,2,3612),-- Adamantite Nugget
(20799,2230,1,1,2,1750),-- Recipe: Theca Leather Gaiters
(20799,2326,1,1,2,315),-- Recipe: Horn of Glory
(20799,4040,1,1,2,1806),-- Mold Lubricant
(20799,4041,1,1,2,785),-- Mold Hardener
(20799,8723,1,1,200,1969),-- Life Stone: level 46
(20799,8733,1,1,200,903),-- Mid-Grade Life Stone: level 46
(20799,8743,1,1,200,90),-- High-Grade Life Stone: level 46 
(20799,8753,1,1,200,18),-- Top-Grade Life Stone: level 46 
(20800,1911,1,1,-1,146379),-- Earring of Protection Gemstone
(20800,1966,1,1,-1,71854),-- Plated Leather Fragment
(20800,2223,1,1,-1,76282),-- Recipe: Tower Shield
(20800,57,777,1585,0,700000),-- Adena
(20800,355,1,1,1,88),-- Dwarven Chain Mail Shirt
(20800,382,1,1,1,141),-- Dwarven Chain Gaiters
(20800,1968,1,1,1,5253),-- Dwarven Chain Mail Shirt Material
(20800,1969,1,1,1,8332),-- Dwarven Chain Gaiters Material
(20800,1867,1,1,2,105698),-- Animal Skin
(20800,1872,1,1,2,105698),-- Animal Bone
(20800,1875,1,1,2,5285),-- Stone of Purity
(20800,1881,1,1,2,10570),-- Coarse Bone Powder
(20800,2226,1,1,2,3236),-- Recipe: Mithril Gauntlets
(20800,2333,1,1,2,184),-- Recipe: Sword of Nightmare
(20800,4041,1,1,2,689),-- Mold Hardener
(20800,8724,1,1,200,2642),-- Life Stone: level 49
(20800,8734,1,1,200,661),-- Mid-Grade Life Stone: level 49
(20800,8744,1,1,200,66),-- High-Grade Life Stone: level 49
(20800,8754,1,1,200,13),-- Top-Grade Life Stone: level 49
(20801,951,1,1,-1,4319),-- Scroll: Enchant Weapon (Grade C)
(20801,2330,1,1,-1,5524),-- Recipe: Homunkulus\'s Sword
(20801,2946,1,1,-1,132781),-- Plate Leather Gloves Design
(20801,57,939,1909,0,700000),-- Adena
(20801,4233,1,1,1,48),-- Knuckle Duster
(20801,1539,1,1,2,16706),-- Greater Healing Potion
(20801,1868,1,1,2,150358),-- Thread
(20801,1873,1,1,2,30072),-- Silver Nugget
(20801,1876,1,1,2,15036),-- Mithril Ore
(20801,1895,1,1,2,21480),-- Metallic Fiber
(20801,2347,1,1,2,175),-- Recipe: Akat Long Bow
(20801,2351,1,1,2,157),-- Recipe: Scorpion
(20801,3010,1,1,2,2043),-- Recipe: Composite Helmet
(20801,4042,1,1,2,1253),-- Enria
(20801,4438,1,1,2,3753),-- Knuckle Duster Edge
(20801,6668,1,1,2,26850),-- Deluxe Chest Key - Grade 4
(20801,8724,1,1,200,2506),-- Life Stone: level 49
(20801,8734,1,1,200,626),-- Mid-Grade Life Stone: level 49
(20801,8744,1,1,200,63),-- High-Grade Life Stone: level 49
(20801,8754,1,1,200,13),-- Top-Grade Life Stone: level 49
(20802,1975,1,1,-1,73621),-- Rind Leather Armor Design
(20802,2333,1,1,-1,5213),-- Recipe: Sword of Nightmare
(20802,4039,1,1,-1,74713),-- Mold Glue
(20802,57,885,1804,0,700000),-- Adena
(20802,325,1,1,1,45),-- Horn of Glory
(20802,2088,1,1,1,3499),-- Horn of Glory Fragment
(20802,737,1,1,2,9028),-- Scroll of Resurrection
(20802,1342,10,30,2,180563),-- Fine Steel Arrow
(20802,1894,1,1,2,3168),-- Crafted Leather
(20802,2334,1,1,2,210),-- Recipe: Sword of Whispering Death
(20802,4039,1,1,2,3009),-- Mold Glue
(20802,4041,1,1,2,785),-- Mold Hardener
(20802,4044,1,1,2,3009),-- Thons
(20802,8724,1,1,200,3009),-- Life Stone: level 49
(20802,8734,1,1,200,752),-- Mid-Grade Life Stone: level 49
(20802,8744,1,1,200,75),-- High-Grade Life Stone: level 49
(20802,8754,1,1,200,15),-- Top-Grade Life Stone: level 49
(20803,4042,1,1,-1,70147),-- Enria
(20803,4043,1,1,-1,140295),-- Asofe
(20803,4044,1,1,-1,140295),-- Thons
(20803,57,1665,3384,0,700000),-- Adena
(20803,231,1,1,1,26),-- Grace Dagger
(20803,233,1,1,1,26),-- Dark Screamer
(20803,2106,1,1,1,2372),-- Grace Dagger Edge
(20803,2107,1,1,1,2372),-- Dark Screamer Edge
(20803,1895,1,1,2,45208),-- Metallic Fiber
(20803,2356,1,1,2,258),-- Recipe: Demon\'s Staff
(20803,2360,1,1,2,258),-- Recipe: Orcish Poleaxe
(20803,3014,1,1,2,4420),-- Recipe: Full Plate Boots
(20803,4040,1,1,2,3165),-- Mold Lubricant
(20803,4042,1,1,2,2637),-- Enria
(20803,4043,1,1,2,5274),-- Asofe
(20803,8725,1,1,200,4395),-- Life Stone: level 52
(20803,8735,1,1,200,1099),-- Mid-Grade Life Stone: level 52
(20803,8745,1,1,200,110),-- High-Grade Life Stone: level 52
(20803,8755,1,1,200,22),-- Top-Grade Life Stone: level 52
(20804,1953,1,1,-1,65586),-- Sage\'s Rag Lining
(20804,2160,1,1,-1,132104),-- Recipe: Moonstone Earring
(20804,4470,1,1,-1,11701),-- Dye of Strength <Str+1 Dex-1>
(20804,57,830,1660,0,700000),-- Adena
(20804,630,1,1,1,434),-- Square Shield
(20804,1956,1,1,1,19451),-- Square Shield Fragment
(20804,2412,1,1,1,304),-- Plate Helmet
(20804,2494,1,1,1,434),-- Plate Shield
(20804,2930,1,1,1,13814),-- Plate Helmet Design
(20804,2934,1,1,1,19451),-- Plate Shield Fragment
(20804,735,1,1,2,10710),-- Potion of Alacrity
(20804,1864,1,3,2,128527),-- Stem
(20804,1869,1,1,2,128527),-- Iron Ore
(20804,1878,1,1,2,51411),-- Braided Hemp
(20804,1884,1,1,2,79094),-- Cord
(20804,2207,1,1,2,3391),-- Recipe: Karmian Tunic
(20804,2298,1,1,2,561),-- Recipe: Stormbringer
(20804,5274,1,1,2,428),-- Recipe: Greater Spiritshot (C) Compressed Package(100%)
(20805,1905,1,1,-1,215536),-- Omen Beast\'s Eye Earring Gemstone
(20805,2053,1,1,-1,18321),-- Scallop Jamadhr Edge
(20805,2162,1,1,-1,107039),-- Recipe: Aquastone Necklace
(20805,57,892,1803,0,700000),-- Adena
(20805,159,1,1,1,16),-- Bonebreaker
(20805,187,1,1,1,16),-- Atuba Hammer
(20805,188,1,1,1,16),-- Ghost Staff
(20805,189,1,1,1,16),-- Staff of Life
(20805,190,1,1,1,16),-- Atuba Mace
(20805,2048,1,1,1,920),-- Bonebreaker Head
(20805,2049,1,1,1,920),-- Atuba Hammer Head
(20805,2050,1,1,1,975),-- Ghost Staff Head
(20805,2051,1,1,1,975),-- Staff of Life Shaft
(20805,2058,1,1,1,920),-- Atuba Mace Head
(20805,1895,1,1,2,63578),-- Metallic Fiber
(20805,2205,1,1,2,7042),-- Recipe: Chain Gaiters
(20805,2305,1,1,2,972),-- Recipe: Crystal Staff
(20805,5164,1,1,2,742),-- Recipe: Blessed Spiritshot (C) Compressed Package (100%)
(20805,6668,1,1,2,79473),-- Deluxe Chest Key - Grade 4
(20806,1805,1,1,-1,7131),-- Recipe: Soulshot: C-Grade
(20806,2204,1,1,-1,42364),-- Recipe: Chain Mail Shirt
(20806,2934,1,1,-1,242834),-- Plate Shield Fragment
(20806,57,846,1718,0,700000),-- Adena
(20806,70,1,1,1,39),-- Claymore
(20806,2047,1,1,1,2361),-- Claymore Blade
(20806,2499,1,1,1,39),-- Elven Long Sword
(20806,2967,1,1,1,2329),-- Elven Long Sword Blade
(20806,1865,1,1,2,153470),-- Varnish
(20806,1870,1,1,2,153470),-- Coal
(20806,1875,1,1,2,10231),-- Stone of Purity
(20806,1879,1,1,2,25578),-- Cokes
(20806,2300,1,1,2,670),-- Recipe: Scythe
(20806,2999,1,1,2,10300),-- Recipe: Plated Leather Gloves
(20806,5159,1,1,2,512); -- Recipe: Spiritshot (C) Compressed Package (100%)

INSERT INTO `droplist` VALUES 
(20807,1908,1,1,-1,212824),-- Moonstone Earring Wire
(20807,1910,1,1,-1,169233),-- Aquastone Necklace Chain
(20807,2164,1,1,-1,172878),-- Recipe: Ring of Protection
(20807,57,885,1813,0,700000),-- Adena
(20807,439,1,1,1,183),-- Karmian Tunic
(20807,471,1,1,1,292),-- Karmian Stockings
(20807,1954,1,1,1,14118),-- Karmian Stocking Design
(20807,1962,1,1,1,8498),-- Karmian Tunic Pattern
(20807,737,1,1,2,8171),-- Scroll of Resurrection
(20807,1866,1,1,2,54470),-- Suede
(20807,1871,1,1,2,81705),-- Charcoal
(20807,1885,1,1,2,6809),-- High Grade Suede
(20807,2221,1,1,2,2705),-- Recipe: Rind Leather Gaiters
(20807,2225,1,1,2,1776),-- Recipe: Demon\'s Stockings
(20807,2316,1,1,2,285),-- Recipe: Katana
(20807,2321,1,1,2,285),-- Recipe: Stiletto
(20807,5220,1,1,2,3268),-- Metal Hardener
(20807,8723,1,1,200,3268),-- Life Stone: level 46
(20807,8733,1,1,200,817),-- Mid-Grade Life Stone: level 46
(20807,8743,1,1,200,82),-- High-Grade Life Stone: level 46
(20807,8753,1,1,200,16),-- Top-Grade Life Stone: level 46
(20808,1908,1,1,-1,263934),-- Moonstone Earring Wire
(20808,1954,1,1,-1,148174),-- Karmian Stocking Design
(20808,2163,1,1,-1,142201),-- Recipe: Earring of Protection
(20808,57,1102,2239,0,700000),-- Adena
(20808,439,1,1,1,226),-- Karmian Tunic
(20808,471,1,1,1,362),-- Karmian Stockings
(20808,1954,1,1,1,17508),-- Karmian Stocking Design
(20808,1962,1,1,1,10539),-- Karmian Tunic Pattern
(20808,1894,1,1,2,4622),-- Crafted Leather
(20808,2324,1,1,2,459),-- Recipe: Elven Bow of Nobility
(20808,4039,1,1,2,4391),-- Mold Glue
(20808,4041,1,1,2,1145),-- Mold Hardener
(20808,4044,1,1,2,4391),-- Thons
(20808,6668,1,1,2,47045),-- Deluxe Chest Key - Grade 4
(20808,8723,1,1,200,5269),-- Life Stone: level 46
(20808,8733,1,1,200,1317),-- Mid-Grade Life Stone: level 46
(20808,8743,1,1,200,132),-- High-Grade Life Stone: level 46
(20808,8753,1,1,200,26),-- Top-Grade Life Stone: level 46
(20809,4049,1,1,-1,259282),-- Adamantite Earring Gemstone
(20809,4439,1,1,-1,340912),-- Avadon Shield Fragment
(20809,4973,1,1,-1,53498),-- Recipe: Earring of Black Ore (70%)
(20809,57,1955,3974,0,700000),-- Adena
(20809,357,1,1,1,23),-- Zubei\'s Breastplate
(20809,383,1,1,1,37),-- Zubei\'s Gaiters
(20809,2376,1,1,1,23),-- Avadon Breastplate
(20809,2379,1,1,1,37),-- Avadon Gaiters
(20809,4056,1,1,1,3305),-- Zubei\'s Breastplate Part
(20809,4057,1,1,1,5107),-- Zubei\'s Gaiter Material
(20809,4064,1,1,1,3305),-- Avadon Breastplate Part
(20809,4065,1,1,1,5107),-- Avadon Gaiters Material
(20809,1868,1,1,2,243358),-- Thread
(20809,1873,1,1,2,48672),-- Silver Nugget
(20809,1889,1,1,2,8112),-- Compound Braid
(20809,4044,1,1,2,4056),-- Thons
(20809,4158,1,1,2,258),-- Recipe: Doom Plate Armor
(20809,4981,1,1,2,378),-- Recipe: Blue Wolf Breastplate (60%)
(20809,4999,1,1,2,1513),-- Recipe: Doom Boots (60%)
(20809,5549,1,1,2,12168),-- Metallic Thread
(20809,8728,1,1,200,2028),-- Life Stone: level 61
(20809,8738,1,1,200,507),-- Mid-Grade Life Stone: level 61
(20809,8748,1,1,200,51),-- High-Grade Life Stone: level 61
(20809,8758,1,1,200,10),-- Top-Grade Life Stone: level 61
(20810,947,1,1,-1,1977),-- Scroll: Enchant Weapon (Grade B)
(20810,4109,1,1,-1,27849),-- Kris Edge
(20810,4974,1,1,-1,80247),-- Recipe: Ring of Black Ore (70%)
(20810,57,1955,3974,0,700000),-- Adena
(20810,91,1,1,1,11),-- Heavy War Axe
(20810,92,1,1,1,11),-- Sprite\'s Staff
(20810,4105,1,1,1,2089),-- Heavy War Axe Head
(20810,4106,1,1,1,2054),-- Sprite\'s Staff Head
(20810,1874,1,1,2,8849),-- Oriharukon Ore
(20810,1878,1,1,2,53097),-- Braided Hemp
(20810,1884,1,1,2,81687),-- Cord
(20810,1889,1,1,2,8849),-- Compound Braid
(20810,4159,1,1,2,376),-- Recipe: Blue Wolf Leather Armor
(20810,5220,1,1,2,5310),-- Metal Hardener
(20810,8728,1,1,200,2212),-- Life Stone: level 61
(20810,8738,1,1,200,553),-- Mid-Grade Life Stone: level 61
(20810,8748,1,1,200,55),-- High-Grade Life Stone: level 61
(20810,8758,1,1,200,11),-- Top-Grade Life Stone: level 61
(20811,947,1,1,-1,2337),-- Scroll: Enchant Weapon (Grade B)
(20811,1875,1,1,-1,389481),-- Stone of Purity
(20811,4040,1,1,-1,116844),-- Mold Lubricant
(20811,57,2315,4695,0,700000),-- Adena
(20811,78,1,1,1,9),-- Great Sword
(20811,142,1,1,1,9),-- Keshanberk
(20811,148,1,1,1,9),-- Sword of Valhalla
(20811,4104,1,1,1,1646),-- Great Sword Blade
(20811,4107,1,1,1,1620),-- Keshanberk Blade
(20811,4108,1,1,1,1620),-- Sword of Valhalla Blade
(20811,1865,1,1,2,132746),-- Varnish
(20811,1870,1,1,2,132746),-- Coal
(20811,1875,1,1,2,8850),-- Stone of Purity
(20811,1879,1,1,2,22124),-- Cokes
(20811,4040,1,1,2,2655),-- Mold Lubricant
(20811,4167,1,1,2,1651),-- Recipe: Blue Wolf Boots
(20811,4401,1,1,2,266),-- Green Dimensional Stone
(20811,4619,1,1,2,183),-- Greater Dye of Intelligence <Int+4 Men-4>
(20811,6670,1,1,2,22124),-- Deluxe Chest Key - Grade 6
(20811,8728,1,1,200,2212),-- Life Stone: level 61
(20811,8738,1,1,200,553),-- Mid-Grade Life Stone: level 61
(20811,8748,1,1,200,55),-- High-Grade Life Stone: level 61
(20811,8758,1,1,200,11),-- Top-Grade Life Stone: level 61
(20812,1875,1,1,-1,384494),-- Stone of Purity
(20812,4613,1,1,-1,7955),-- Greater Dye of Strength <Str+4 Con-4>
(20812,4617,1,1,-1,7955),-- Greater Dye of Dexterity <Dex+4 Str-4>
(20812,57,2285,4635,0,700000),-- Adena
(20812,284,1,1,1,26),-- Dark Elven Long Bow
(20812,4112,1,1,1,4822),-- Dark Elven Longbow Shaft
(20812,1867,1,1,2,227147),-- Animal Skin
(20812,1872,1,1,2,227147),-- Animal Bone
(20812,1875,1,1,2,11357),-- Stone of Purity
(20812,1881,1,1,2,22715),-- Coarse Bone Powder
(20812,4041,1,1,2,1481),-- Mold Hardener
(20812,4620,1,1,2,235),-- Greater Dye of Intelligence <Int+4 Wit-4>
(20812,8728,1,1,200,2839),-- Life Stone: level 61
(20812,8738,1,1,200,710),-- Mid-Grade Life Stone: level 61
(20812,8748,1,1,200,71),-- High-Grade Life Stone: level 61
(20812,8758,1,1,200,13),-- Top-Grade Life Stone: level 61
(20813,4052,1,1,-1,185940),-- Earring of Black Ore Piece
(20813,4982,1,1,-1,26129),-- Recipe: Blue Wolf Gaiters (60%)
(20813,5230,1,1,-1,7003),-- Recipe: Mithril Arrow (100%)
(20813,57,2083,4219,0,700000),-- Adena
(20813,2398,1,1,1,21),-- Blue Wolf Tunic
(20813,2399,1,1,1,21),-- Tunic of Doom
(20813,2403,1,1,1,33),-- Blue Wolf Stockings
(20813,2404,1,1,1,33),-- Stockings of Doom
(20813,4084,1,1,1,3371),-- Blue Wolf Tunic Fabric
(20813,4085,1,1,1,3371),-- Tunic of Doom Pattern
(20813,4086,1,1,1,4552),-- Blue Wolf Stockings Pattern
(20813,4087,1,1,1,4552),-- Stockings of Doom Pattern
(20813,1867,1,1,2,206843),-- Animal Skin
(20813,1872,1,1,2,206843),-- Animal Bone
(20813,1875,1,1,2,10342),-- Stone of Purity
(20813,1881,1,1,2,20685),-- Coarse Bone Powder
(20813,4041,1,1,2,1349),-- Mold Hardener
(20813,4620,1,1,2,214),-- Greater Dye of Intelligence <Int+4 Wit-4>
(20813,8728,1,1,200,2586),-- Life Stone: level 61
(20813,8738,1,1,200,647),-- Mid-Grade Life Stone: level 61
(20813,8748,1,1,200,65),-- High-Grade Life Stone: level 61
(20813,8758,1,1,200,12),-- Top-Grade Life Stone: level 61
(20814,948,1,1,-1,15160),-- Scroll: Enchant Armor (Grade B)
(20814,4053,1,1,-1,259927),-- Ring of Black Ore Gemstone
(20814,5230,1,1,-1,8085),-- Recipe: Mithril Arrow (100%)
(20814,57,2405,4872,0,700000),-- Adena
(20814,601,1,1,1,72),-- Boots of Doom
(20814,2439,1,1,1,72),-- Blue Wolf Boots
(20814,2475,1,1,1,72),-- Doom Gloves
(20814,2487,1,1,1,72),-- Blue Wolf Gloves
(20814,4090,1,1,1,10052),-- Blue Wolf Boots Design
(20814,4091,1,1,1,10052),-- Doom Gloves Part
(20814,4096,1,1,1,10052),-- Blue Wolf Gloves Fabric
(20814,4099,1,1,1,10052),-- Doom Boots Part
(20814,1866,1,1,2,108560),-- Suede
(20814,1871,1,1,2,162840),-- Charcoal
(20814,1877,1,1,2,6514),-- Adamantite Nugget
(20814,4040,1,1,2,3257),-- Mold Lubricant
(20814,4041,1,1,2,1416),-- Mold Hardener
(20814,4975,1,1,2,1324),-- Recipe: Necklace of Black Ore (70%)
(20814,5276,1,1,2,217),-- Recipe: Greater Spiritshot (A) Compressed Package(100%)
(20814,8729,1,1,200,2171),-- Life Stone: level 64
(20814,8739,1,1,200,543),-- Mid-Grade Life Stone: level 64
(20814,8749,1,1,200,54),-- High-Grade Life Stone: level 64
(20814,8759,1,1,200,11),-- Top-Grade Life Stone: level 64
(20815,4052,1,1,-1,266388),-- Earring of Black Ore Piece
(20815,4054,1,1,-1,148200),-- Necklace of Black Ore Beads
(20815,4984,1,1,-1,21315),-- Recipe: Blue Wolf Leather Armor (60%)
(20815,57,2984,6042,0,700000),-- Adena
(20815,2391,1,1,1,37),-- Blue Wolf Leather Armor
(20815,2392,1,1,1,37),-- Leather Armor of Doom
(20815,4082,1,1,1,6279),-- Blue Wolf Leather Armor Texture
(20815,4083,1,1,1,6279),-- Leather Armor of Doom Design
(20815,1865,1,1,2,202046),-- Varnish
(20815,1870,1,1,2,202046),-- Coal
(20815,1874,1,1,2,13470),-- Oriharukon Ore
(20815,4039,1,1,2,6735),-- Mold Glue
(20815,4043,1,1,2,6735),-- Asofe
(20815,5000,1,1,2,154),-- Recipe: Sword of Damascus (60%)
(20815,6670,1,1,2,33674),-- Deluxe Chest Key - Grade 6
(20815,8729,1,1,200,2694),-- Life Stone: level 64
(20815,8739,1,1,200,673),-- Mid-Grade Life Stone: level 64
(20815,8749,1,1,200,67),-- High-Grade Life Stone: level 64
(20815,8759,1,1,200,14),-- Top-Grade Life Stone: level 64
(20816,947,1,1,-1,2511),-- Scroll: Enchant Weapon (Grade B)
(20816,4039,1,1,-1,209252),-- Mold Glue
(20816,5230,1,1,-1,8370),-- Recipe: Mithril Arrow (100%)
(20816,57,2490,5041,0,700000),-- Adena
(20816,2391,1,1,1,31),-- Blue Wolf Leather Armor
(20816,2392,1,1,1,31),-- Leather Armor of Doom
(20816,4082,1,1,1,5239),-- Blue Wolf Leather Armor Texture
(20816,4083,1,1,1,5239),-- Leather Armor of Doom Design
(20816,1864,1,3,2,154525),-- Stem
(20816,1869,1,1,2,154525),-- Iron Ore
(20816,1878,1,1,2,61810),-- Braided Hemp
(20816,1884,1,1,2,95092),-- Cord
(20816,4039,1,1,2,5151),-- Mold Glue
(20816,4402,1,1,2,309),-- Blue Dimensional Stone
(20816,5001,1,1,2,118),-- Recipe: Lance (60%)
(20816,5276,1,1,2,206),-- Recipe: Greater Spiritshot (A) Compressed Package(100%)
(20816,8729,1,1,200,2060),-- Life Stone: level 64
(20816,8739,1,1,200,515),-- Mid-Grade Life Stone: level 64
(20816,8749,1,1,200,52),-- High-Grade Life Stone: level 64
(20816,8759,1,1,200,11),-- Top-Grade Life Stone: level 64
(20817,4040,1,1,-1,121827),-- Mold Lubricant
(20817,4053,1,1,-1,261096),-- Ring of Black Ore Gemstone
(20817,5230,1,1,-1,8122),-- Recipe: Mithril Arrow (100%)
(20817,57,2418,4891,0,700000),-- Adena
(20817,268,1,1,1,18),-- Bellion Cestus
(20817,4120,1,1,1,3931),-- Bellion Cestus Edge
(20817,1865,1,1,2,163572),-- Varnish
(20817,1870,1,1,2,163572),-- Coal
(20817,1875,1,1,2,10905),-- Stone of Purity
(20817,1879,1,1,2,27262),-- Cokes
(20817,4040,1,1,2,3271),-- Mold Lubricant
(20817,4174,1,1,2,3152),-- Recipe: Zubei\'s Boots
(20817,4402,1,1,2,327),-- Blue Dimensional Stone
(20817,8729,1,1,200,2181),-- Life Stone: level 64
(20817,8739,1,1,200,545),-- Mid-Grade Life Stone: level 64
(20817,8749,1,1,200,54),-- High-Grade Life Stone: level 64
(20817,8759,1,1,200,11),-- Top-Grade Life Stone: level 64
(20818,4077,1,1,-1,273487),-- Doom Shield Fragment
(20818,4105,1,1,-1,34790),-- Heavy War Axe Head
(20818,4620,1,1,-1,8386),-- Greater Dye of Intelligence <Int+4 Wit-4>
(20818,57,2414,4882,0,700000),-- Adena
(20818,287,1,1,1,18),-- Bow of Peril
(20818,4121,1,1,1,3910),-- Bow of Peril Shaft
(20818,1866,1,1,2,92094),-- Suede
(20818,1871,1,1,2,138141),-- Charcoal
(20818,1885,1,1,2,11512),-- High Grade Suede
(20818,4041,1,1,2,1201),-- Mold Hardener
(20818,4401,1,1,2,276),-- Green Dimensional Stone
(20818,4958,1,1,2,2662),-- Recipe: Zubei\'s Boots (60%)
(20818,5416,1,1,2,298),-- Recipe: Sealed Dark Crystal Breastplate(60%)
(20818,5220,1,1,2,5526),-- Metal Hardener
(20818,5276,1,1,2,184),-- Recipe: Greater Spiritshot (A) Compressed Package(100%)
(20818,8729,1,1,200,1842),-- Life Stone: level 64
(20818,8739,1,1,200,460),-- Mid-Grade Life Stone: level 64
(20818,8749,1,1,200,46),-- High-Grade Life Stone: level 64
(20818,8759,1,1,200,9),-- Top-Grade Life Stone: level 64
(20819,4053,1,1,-1,259498),-- Ring of Black Ore Gemstone
(20819,4078,1,1,-1,88433),-- Blue Wolf Breastplate Part
(20819,5230,1,1,-1,8072),-- Recipe: Mithril Arrow (100%)
(20819,57,2399,4864,0,700000),-- Adena
(20819,171,1,1,1,6),-- Deadman\'s Glory
(20819,175,1,1,1,6),-- Art of Battle Axe
(20819,210,1,1,1,6),-- Staff of Evil Spirits
(20819,4116,1,1,1,1302),-- Deadman\'s Glory Stone
(20819,4117,1,1,1,1302),-- Art of Battle Axe Blade
(20819,4118,1,1,1,1234),-- Evil Spirit Head
(20819,730,1,1,2,124),-- Scroll: Enchant Armor (Grade A)
(20819,1874,1,1,2,9935),-- Oriharukon Ore
(20819,1878,1,1,2,5961),-- Braided Hemp
(20819,1884,1,1,2,91707),-- Cord
(20819,1889,1,1,2,9935),-- Compound Braid
(20819,4159,1,1,2,422),-- Recipe: Blue Wolf Leather Armor
(20819,4402,1,1,2,298),-- Blue Dimensional Stone
(20819,5220,1,1,2,5961),-- Metal Hardener
(20819,8729,1,1,200,1987),-- Life Stone: level 64
(20819,8739,1,1,200,497),-- Mid-Grade Life Stone: level 64
(20819,8749,1,1,200,50),-- High-Grade Life Stone: level 64
(20819,8759,1,1,200,10),-- Top-Grade Life Stone: level 64
(20820,4054,1,1,-1,205291),-- Necklace of Black Ore Beads
(20820,4080,1,1,-1,214391),-- Blue Wolf Gaiters Material
(20820,5230,1,1,-1,13897),-- Recipe: Mithril Arrow (100%)
(20820,57,4130,8374,0,700000),-- Adena
(20820,864,1,1,1,144),-- Earring of Black Ore
(20820,895,1,1,1,216),-- Ring of Black Ore
(20820,926,1,1,1,108),-- Necklace of Black Ore
(20820,4052,1,1,1,18165),-- Earring of Black Ore Piece
(20820,4053,1,1,1,21992),-- Ring of Black Ore Gemstone
(20820,4054,1,1,1,10106),-- Necklace of Black Ore Beads
(20820,1867,1,3,2,171038),-- Animal Skin
(20820,1872,1,3,2,114025),-- Animal Bone
(20820,1882,1,1,2,57013),-- Leather
(20820,1894,1,1,2,9002),-- Crafted Leather
(20820,4042,1,1,2,4276),-- Enria
(20820,4160,1,1,2,727),-- Recipe: Leather Armor of Doom
(20820,5424,1,1,2,888),-- Recipe: Sealed Dark Crystal Gaiters(60%)
(20820,5276,1,1,2,342),-- Recipe: Greater Spiritshot (A) Compressed Package(100%)
(20820,8729,1,1,200,3421),-- Life Stone: level 64
(20820,8739,1,1,200,855),-- Mid-Grade Life Stone: level 64
(20820,8749,1,1,200,85),-- High-Grade Life Stone: level 64
(20820,8759,1,1,200,17),-- Top-Grade Life Stone: level 64
(20821,1894,1,1,-1,286943),-- Crafted Leather
(20821,4080,1,1,-1,168217),-- Blue Wolf Gaiters Material
(20821,4084,1,1,-1,142125),-- Blue Wolf Tunic Fabric
(20821,57,3240,6570,0,700000),-- Adena
(20821,97,1,1,1,24),-- Lance
(20821,4115,1,1,1,5268),-- Lance Blade
(20821,1867,1,3,2,146401),-- Animal Skin
(20821,1872,1,3,2,97601),-- Animal Bone
(20821,1882,1,1,2,48801),-- Leather
(20821,1894,1,1,2,7705),-- Crafted Leather
(20821,4042,1,1,2,3660),-- Enria
(20821,4195,1,1,2,168),-- Recipe: Art of Battle Axe
(20821,5276,1,1,2,293),-- Recipe: Greater Spiritshot (A) Compressed Package(100%)
(20821,8729,1,1,200,2928),-- Life Stone: level 64
(20821,8739,1,1,200,732),-- Mid-Grade Life Stone: level 64
(20821,8749,1,1,200,73),-- High-Grade Life Stone: level 64
(20821,8759,1,1,200,14),-- Top-Grade Life Stone: level 64
(20822,1889,1,1,-1,547825),-- Compound Braid
(20822,1894,1,1,-1,288329),-- Crafted Leather
(20822,4077,1,1,-1,369652),-- Doom Shield Fragment
(20822,57,3255,6602,0,700000),-- Adena
(20822,97,1,1,1,24),-- Lance
(20822,4115,1,1,1,5294),-- Lance Blade
(20822,1868,1,3,2,202274),-- Thread
(20822,1873,1,1,2,80909),-- Silver Nugget
(20822,1889,1,1,2,13485),-- Compound Braid
(20822,4044,1,1,2,6742),-- Thons
(20822,4196,1,1,2,154),-- Recipe: Staff of Evil Spirits
(20822,4402,1,1,2,405),-- Blue Dimensional Stone
(20822,5549,1,1,2,20227),-- Metallic Thread
(20822,6670,1,1,2,33712),-- Deluxe Chest Key - Grade 6
(20822,8729,1,1,200,2697),-- Life Stone: level 64
(20822,8739,1,1,200,674),-- Mid-Grade Life Stone: level 64
(20822,8749,1,1,200,68),-- High-Grade Life Stone: level 64
(20822,8759,1,1,200,14),-- Top-Grade Life Stone: level 64
(20823,4088,1,1,-1,343233),-- Blue Wolf Helmet Design
(20823,4089,1,1,-1,343233),-- Doom Helmet Pattern
(20823,5416,1,1,-1,19615),-- Recipe: Sealed Dark Crystal Breastplate(60%)
(20823,57,3580,7317,0,700000),-- Adena
(20823,2398,1,1,1,36),-- Blue Wolf Tunic
(20823,2399,1,1,1,36),-- Tunic of Doom
(20823,2403,1,1,1,58),-- Blue Wolf Stockings
(20823,2404,1,1,1,58),-- Stockings of Doom
(20823,4084,1,1,1,5830),-- Blue Wolf Tunic Fabric
(20823,4085,1,1,1,5830),-- Tunic of Doom Pattern
(20823,4086,1,1,1,7871),-- Blue Wolf Stockings Pattern
(20823,4087,1,1,1,7871),-- Stockings of Doom Pattern
(20823,1864,1,3,2,223555),-- Stem
(20823,1869,1,1,2,223555),-- Iron Ore
(20823,1880,1,1,2,22355),-- Steel
(20823,4043,1,1,2,7452),-- Asofe
(20823,4402,1,1,2,447),-- Blue Dimensional Stone
(20823,8316,1,1,2,83),-- Recipe: Flaming Dragon Skull (60%)
(20823,4616,1,1,2,308),-- Greater Dye of Constitution <Con+4 Dex-4>
(20823,5550,1,1,2,2981),-- Durable Metal Plate
(20823,8730,1,1,200,2484),-- Life Stone: level 67
(20823,8740,1,1,200,621),-- Mid-Grade Life Stone: level 67
(20823,8750,1,1,200,62),-- High-Grade Life Stone: level 67
(20823,8760,1,1,200,13),-- Top-Grade Life Stone: level 67
(20824,4078,1,1,-1,125629),-- Blue Wolf Breastplate Part
(20824,4081,1,1,-1,84768),-- Doom Plate Armor Temper
(20824,5424,1,1,-1,29760),-- Recipe: Sealed Dark Crystal Gaiters(60%)
(20824,57,3391,6929,0,700000),-- Adena
(20824,864,1,1,1,119),-- Earring of Black Ore
(20824,895,1,1,1,179),-- Ring of Black Ore
(20824,926,1,1,1,89),-- Necklace of Black Ore
(20824,4052,1,1,1,14990),-- Earring of Black Ore Piece
(20824,4053,1,1,1,18148),-- Ring of Black Ore Gemstone
(20824,4054,1,1,1,8339),-- Necklace of Black Ore Beads
(20824,1865,1,1,2,211706),-- Varnish
(20824,1870,1,1,2,211706),-- Coal
(20824,1874,1,1,2,14114),-- Oriharukon Ore
(20824,4039,1,1,2,7057),-- Mold Glue
(20824,4043,1,1,2,7057),-- Asofe
(20824,4617,1,1,2,292),-- Greater Dye of Dexterity <Dex+4 Str-4>
(20824,5276,1,1,2,282),-- Recipe: Greater Spiritshot (A) Compressed Package(100%)
(20824,6036,1,1,2,7057),-- Greater Magic Haste Potion
(20824,8730,1,1,200,2352),-- Life Stone: level 67
(20824,8740,1,1,200,588),-- Mid-Grade Life Stone: level 67
(20824,8750,1,1,200,59),-- High-Grade Life Stone: level 67
(20824,8760,1,1,200,12),-- Top-Grade Life Stone: level 67
(20825,1807,1,1,-1,12015),-- Recipe: Soulshot: A-Grade
(20825,1876,1,3,-1,901136),-- Mithril Ore
(20825,57,3565,7246,0,700000),-- Adena
(20825,5289,1,1,1,66),-- Sealed Dark Crystal Helmet
(20825,5292,1,1,1,95),-- Sealed Dark Crystal Shield
(20825,5294,1,1,1,66),-- Sealed Tallum Helmet
(20825,5494,1,1,1,9317),-- Sealed Dark Crystal Shield Fragment
(20825,5525,1,1,1,6857),-- Sealed Dark Crystal Helmet Design
(20825,5526,1,1,1,6857),-- Sealed Tallum Helm Design
(20825,1866,1,1,2,161322),-- Suede
(20825,1871,1,1,2,241983),-- Charcoal
(20825,1877,1,1,2,9679),-- Adamantite Nugget
(20825,4040,1,1,2,4839),-- Mold Lubricant
(20825,4041,1,1,2,2104),-- Mold Hardener
(20825,4402,1,1,2,484),-- Blue Dimensional Stone
(20825,4975,1,1,2,1967),-- Recipe: Necklace of Black Ore (70%)
(20825,8730,1,1,200,2689),-- Life Stone: level 67
(20825,8740,1,1,200,672),-- Mid-Grade Life Stone: level 67
(20825,8750,1,1,200,67),-- High-Grade Life Stone: level 67
(20825,8760,1,1,200,13),-- Top-Grade Life Stone: level 67
(20826,4041,1,1,-1,71335),-- Mold Hardener
(20826,5478,1,1,-1,68984),-- Sealed Dark Crystal Leather Armor Pattern
(20826,57,3245,6597,0,700000),-- Adena
(20826,5287,1,1,1,23),-- Sealed Dark Crystal breastplate
(20826,5288,1,1,1,36),-- Sealed Dark Crystal Gaiters
(20826,5293,1,1,1,14),-- Sealed Tallum Plate Armor
(20826,5520,1,1,1,2604),-- Sealed Dark Crystal Breastplate Pattern
(20826,5521,1,1,1,1838),-- Sealed Tallum Plate Armor Pattern
(20826,5524,1,1,1,3981),-- Sealed Dark Crystal Gaiters Pattern
(20826,1867,1,1,2,269244),-- Animal Skin
(20826,1872,1,3,2,134622),-- Animal Bone
(20826,1875,1,1,2,13462),-- Stone of Purity
(20826,1881,1,1,2,26924),-- Coarse Bone Powder
(20826,3956,1,1,2,269),-- Recipe: Blessed Spiritshot A
(20826,4041,1,1,2,1756),-- Mold Hardener
(20826,4980,1,1,2,2390),-- Recipe: Doom Shield (60%)
(20826,6670,1,1,2,33656),-- Deluxe Chest Key - Grade 6
(20826,8730,1,1,200,2244),-- Life Stone: level 67
(20826,8740,1,1,200,561),-- Mid-Grade Life Stone: level 67
(20826,8750,1,1,200,56),-- High-Grade Life Stone: level 67
(20826,8760,1,1,200,11),-- Top-Grade Life Stone: level 67
(20827,3035,1,1,-1,13328),-- Recipe: Spiritshot A
(20827,4117,1,1,-1,43680),-- Art of Battle Axe Blade
(20827,4118,1,1,-1,41384),-- Evil Spirit Head
(20827,57,3956,8034,0,700000),-- Adena
(20827,5297,1,1,1,37),-- Sealed Dark Crystal Leather Armor
(20827,5298,1,1,1,59),-- Sealed Dark Crystalline Leggings
(20827,5301,1,1,1,23),-- Sealed Tallum Leather Armor
(20827,5478,1,1,1,4138),-- Sealed Dark Crystal Leather Armor Pattern
(20827,5479,1,1,1,2912),-- Sealed Tallum Leather Armor Pattern
(20827,5482,1,1,1,6495),-- Sealed Dark Crystalline Leggings Design
(20827,1868,1,3,2,246054),-- Thread
(20827,1873,1,1,2,98421),-- Silver Nugget
(20827,1876,1,1,2,49211),-- Mithril Ore
(20827,1895,1,1,2,70301),-- Metallic Fiber
(20827,4042,1,1,2,4101),-- Enria
(20827,4402,1,1,2,492),-- Blue Dimensional Stone
(20827,4990,1,1,2,492),-- Recipe: Blue Wolf Helmet (60%)
(20827,5420,1,1,2,239),-- Recipe: Sealed Armor of Nightmare(60%)
(20827,8730,1,1,200,2734),-- Life Stone: level 67
(20827,8740,1,1,200,684),-- Mid-Grade Life Stone: level 67
(20827,8750,1,1,200,68),-- High-Grade Life Stone: level 67
(20827,8760,1,1,200,14),-- Top-Grade Life Stone: level 67
(20828,4120,1,1,-1,49809),-- Bellion Cestus Edge
(20828,4121,1,1,-1,49642),-- Bow of Peril Shaft
(20828,5479,1,1,-1,67447),-- Sealed Tallum Leather Armor Pattern
(20828,57,4508,9172,0,700000),-- Adena
(20828,5304,1,1,1,42),-- Sealed Tallum Tunic
(20828,5305,1,1,1,67),-- Sealed Tallum Stockings
(20828,5308,1,1,1,26),-- Sealed Dark Crystal Robe
(20828,5485,1,1,1,4719),-- Sealed Tallum Tunic Texture
(20828,5486,1,1,1,3320),-- Sealed Dark Crystal Robe Fabric
(20828,5489,1,1,1,7406),-- Sealed Tallum Stockings Fabric
(20828,1864,3,9,2,112232),-- Stem
(20828,1869,2,6,2,84174),-- Iron Ore
(20828,1878,1,1,2,134679),-- Braided Hemp
(20828,1884,2,6,2,41440),-- Cord
(20828,4039,1,1,2,11223),-- Mold Glue
(20828,4177,1,1,2,6487),-- Recipe: Zubei\'s Gauntlets
(20828,8730,1,1,200,3741),-- Life Stone: level 67
(20828,8740,1,1,200,935),-- Mid-Grade Life Stone: level 67
(20828,8750,1,1,200,94),-- High-Grade Life Stone: level 67
(20828,8760,1,1,200,18),-- Top-Grade Life Stone: level 67
(20829,1894,1,1,-1,428952),-- Crafted Leather
(20829,5479,1,1,-1,72338),-- Sealed Tallum Leather Armor Pattern
(20829,5550,1,1,-1,163002),-- Durable Metal Plate
(20829,57,6033,12296,0,700000),-- Adena
(20829,5287,1,1,1,42),-- Sealed Dark Crystal breastplate
(20829,5288,1,1,1,68),-- Sealed Dark Crystal Gaiters
(20829,5293,1,1,1,26),-- Sealed Tallum Plate Armor
(20829,5520,1,1,1,4852),-- Sealed Dark Crystal Breastplate Pattern
(20829,5521,1,1,1,3424),-- Sealed Tallum Plate Armor Pattern
(20829,5524,1,1,1,7416),-- Sealed Dark Crystal Gaiters Pattern
(20829,1866,1,3,2,91190),-- Suede
(20829,1871,1,3,2,205177),-- Charcoal
(20829,1877,1,1,2,16414),-- Adamantite Nugget
(20829,4040,1,1,2,8207),-- Mold Lubricant
(20829,4041,1,1,2,3568),-- Mold Hardener
(20829,4129,1,1,2,4441),-- Recipe: Earrings of Black Ore
(20829,6671,1,1,2,45595),-- Deluxe Chest Key - Grade 7
(20829,8730,1,1,200,4559),-- Life Stone: level 67
(20829,8740,1,1,200,1140),-- Mid-Grade Life Stone: level 67
(20829,8750,1,1,200,114),-- High-Grade Life Stone: level 67
(20829,8760,1,1,200,23),-- Top-Grade Life Stone: level 67
(20832,1825,1,1,-1,77593),-- Recipe: Oriharukon
(20832,1902,1,1,-1,110061),-- Elven Earring Beads
(20832,5231,1,1,-1,77593),-- Recipe: Metal Hardener (100%)
(20832,57,430,872,0,700000),-- Adena
(20832,61,1,1,1,121),-- Mithril Gloves
(20832,607,1,1,1,121),-- Ogre Power Gauntlets
(20832,1125,1,1,1,121),-- Assault Boots
(20832,1949,1,1,1,5074),-- Mithril Gloves Design
(20832,1957,1,1,1,5074),-- Assault Boots Part
(20832,1963,1,1,1,5074),-- Ogre Power Gauntlets Part
(20832,2427,1,1,1,121),-- Salamander Skin Boots
(20832,2428,1,1,1,121),-- Plate Boots
(20832,2451,1,1,1,121),-- Sage\'s Worn Gloves
(20832,2931,1,1,1,5074),-- Salamander Skin Boot Lining
(20832,2932,1,1,1,5074),-- Plate Boots Design
(20832,2933,1,1,1,5074),-- Sage\'s Worn Gloves Lining
(20832,1865,1,1,2,77927),-- Varnish
(20832,1870,1,1,2,77927),-- Coal
(20832,1875,1,1,2,5195),-- Stone of Purity
(20832,1879,1,1,2,12988),-- Cokes
(20832,2162,1,1,2,3765),-- Recipe: Aquastone Necklace
(20832,2312,1,1,2,340),-- Recipe: Crystallized Ice Bow
(20832,5159,1,1,2,260),-- Recipe: Spiritshot (C) Compressed Package (100%)
(20833,1874,1,1,-1,80465),-- Oriharukon Ore
(20833,1875,1,1,-1,80465),-- Stone of Purity
(20833,1905,1,1,-1,117410),-- Omen Beast\'s Eye Earring Gemstone
(20833,57,475,974,0,700000),-- Adena
(20833,281,1,1,1,32),-- Crystallized Ice Bow
(20833,2074,1,1,1,2020),-- Crystallized Ice Bow Shaft
(20833,1867,1,1,2,69143),-- Animal Skin
(20833,1872,1,1,2,69143),-- Animal Bone
(20833,1875,1,1,2,3457),-- Stone of Purity
(20833,1881,1,1,2,6914),-- Coarse Bone Powder
(20833,2205,1,1,2,1641),-- Recipe: Chain Gaiters
(20833,2209,1,1,2,3899),-- Recipe: Eldarake
(20833,2299,1,1,2,227),-- Recipe: Big Hammer
(20833,8723,1,1,200,2074),-- Life Stone: level 46
(20833,8733,1,1,200,519),-- Mid-Grade Life Stone: level 46
(20833,8743,1,1,200,52),-- High-Grade Life Stone: level 46
(20833,8753,1,1,200,10),-- Top-Grade Life Stone: level 46
(20834,1805,1,1,-1,5958),-- Recipe: Soulshot: C-Grade
(20834,1878,1,1,-1,714983),-- Braided Hemp
(20834,1885,1,1,-1,148955),-- High Grade Suede
(20834,57,720,14552,0,700000),-- Adena
(20834,353,1,1,1,149),-- Half Plate Armor
(20834,380,1,1,1,239),-- Plate Gaiters
(20834,1950,1,1,1,7283),-- Half Plate Temper
(20834,1951,1,1,1,11328),-- Plate Gaiters Part
(20834,1864,1,3,2,112197),-- Stem
(20834,1869,1,1,2,112197),-- Iron Ore
(20834,1878,1,1,2,44879),-- Braided Hemp
(20834,1884,1,1,2,69045),-- Cord
(20834,2306,1,1,2,490),-- Recipe: Stick of Faith
(20834,2996,1,1,2,8905),-- Recipe: Chain Gloves
(20834,5274,1,1,2,374),-- Recipe: Greater Spiritshot (C) Compressed Package(100%)
(20834,6668,1,1,2,40070),-- Deluxe Chest Key - Grade 4
(20835,1871,1,3,-1,495145),-- Charcoal
(20835,1879,1,1,-1,165048),-- Cokes
(20835,1906,1,1,-1,136122),-- Mithril Ring Wire
(20835,57,392,796,0,700000),-- Adena
(20835,439,1,1,1,80),-- Karmian Tunic
(20835,471,1,1,1,129),-- Karmian Stockings
(20835,1954,1,1,1,6221),-- Karmian Stocking Design
(20835,1962,1,1,1,3744),-- Karmian Tunic Pattern
(20835,1865,1,1,2,33431),-- Varnish
(20835,1870,1,1,2,33431),-- Coal
(20835,1875,1,1,2,2229),-- Stone of Purity
(20835,1879,1,1,2,5572),-- Cokes
(20835,2303,1,1,2,146),-- Recipe: Skull Graver
(20835,2990,1,1,2,2653),-- Recipe: Chain Boots
(20835,3000,1,1,2,2143),-- Recipe: Dwarven Chain Shield
(20835,3033,1,1,2,111),-- Recipe: Spiritshot C
(20835,3954,1,1,2,111),-- Recipe: Blessed Spiritshot C
(20835,4040,1,1,2,669),-- Mold Lubricant
(20835,8723,1,1,200,1337),-- Life Stone: level 46
(20835,8733,1,1,200,334),-- Mid-Grade Life Stone: level 46
(20835,8743,1,1,200,33),-- High-Grade Life Stone: level 46
(20835,8753,1,1,200,6),-- Top-Grade Life Stone: level 46
(20836,1874,1,1,-1,139288),-- Oriharukon Ore
(20836,1875,1,2,-1,139288),-- Stone of Purity
(20836,57,822,1686,0,700000),-- Adena
(20836,96,1,1,1,19),-- Scythe
(20836,298,1,1,1,19),-- Orcish Glaive
(20836,302,1,1,1,19),-- Body Slasher
(20836,2062,1,1,1,1291),-- Scythe Edge
(20836,2075,1,1,1,1291),-- Orcish Glaive Blade
(20836,2076,1,1,1,1291),-- Body Slasher Blade
(20836,1867,1,1,2,131659),-- Animal Skin
(20836,1872,1,1,2,131659),-- Animal Bone
(20836,1875,1,1,2,6583),-- Stone of Purity
(20836,1881,1,1,2,13166),-- Coarse Bone Powder
(20836,2251,1,1,2,16457),-- Recipe: Steel Arrow
(20836,2319,1,1,2,344),-- Recipe: Raid Sword
(20836,8723,1,1,200,3950),-- Life Stone: level 46
(20836,8733,1,1,200,987),-- Mid-Grade Life Stone: level 46
(20836,8743,1,1,200,99),-- High-Grade Life Stone: level 46
(20836,8753,1,1,200,20),-- Top-Grade Life Stone: level 46
(20837,1895,1,1,-1,585827),-- Metallic Fiber
(20837,1960,1,1,-1,112350),-- Chain Gaiters Part
(20837,2214,1,1,-1,50878),-- Recipe: Dwarven Chain Gaiters
(20837,57,811,1647,0,700000),-- Adena
(20837,62,1,1,1,111),-- Mithril Boots
(20837,1958,1,1,1,4839),-- Mithril Boots Design
(20837,2429,1,1,1,111),-- Chain Boots
(20837,2430,1,1,1,111),-- Karmian Boots
(20837,2431,1,1,1,111),-- Plated Leather Boots
(20837,2432,1,1,1,111),-- Dwarven Chain Boots
(20837,2433,1,1,1,111),-- Boots of Seal
(20837,2452,1,1,1,111),-- Reinforced Mithril Gloves
(20837,2453,1,1,1,111),-- Chain Gloves
(20837,2454,1,1,1,111),-- Karmian Gloves
(20837,2937,1,1,1,4839),-- Chain Boots Part
(20837,2938,1,1,1,4839),-- Karmian Boots Fabric
(20837,2939,1,1,1,4839),-- Plate Leather Boot Lining
(20837,2940,1,1,1,4839),-- Dwarven Chain Boots Part
(20837,2941,1,1,1,4839),-- Boots of Seal Pattern
(20837,2942,1,1,1,4839),-- Reinforced Mithril Gloves Design
(20837,2943,1,1,1,4839),-- Chain Gloves Design
(20837,2944,1,1,1,4839),-- Karmian Gloves Fabric
(20837,1868,1,1,2,176191),-- Thread
(20837,1873,1,1,2,35238),-- Silver Nugget
(20837,1876,1,1,2,17619),-- Mithril Ore
(20837,1895,1,1,2,25170),-- Metallic Fiber
(20837,2225,1,1,2,1915),-- Recipe: Demon\'s Stockings
(20837,2321,1,1,2,307),-- Recipe: Stiletto
(20837,4042,1,1,2,1468),-- Enria
(20837,8723,1,1,200,3524),-- Life Stone: level 46
(20837,8733,1,1,200,881),-- Mid-Grade Life Stone: level 46
(20837,8743,1,1,200,88),-- High-Grade Life Stone: level 46
(20837,8753,1,1,200,18),-- Top-Grade Life Stone: level 46
(20838,1866,1,3,-1,640646),-- Suede
(20838,1964,1,1,-1,155308),-- Eldarake Temper
(20838,2216,1,1,-1,79419),-- Recipe: Great Helmet
(20838,57,760,1544,0,700000),-- Adena
(20838,852,1,1,1,254),-- Moonstone Earring
(20838,883,1,1,1,381),-- Aquastone Ring
(20838,915,1,1,1,190),-- Aquastone Necklace
(20838,1908,1,1,1,14337),-- Moonstone Earring Wire
(20838,1909,1,1,1,20445),-- Aquastone Ring Wire
(20838,1910,1,1,1,11400),-- Aquastone Necklace Chain
(20838,1866,1,1,2,60556),-- Suede
(20838,1871,1,1,2,90834),-- Charcoal
(20838,1885,1,1,2,7569),-- High Grade Suede
(20838,3004,1,1,2,5642),-- Recipe: Rind Leather Gloves
(20838,4041,1,1,2,790),-- Mold Hardener
(20838,5220,1,1,2,3633),-- Metal Hardener
(20838,8723,1,1,200,3633),-- Life Stone: level 46
(20838,8733,1,1,200,908),-- Mid-Grade Life Stone: level 46
(20838,8743,1,1,200,91),-- High-Grade Life Stone: level 46
(20838,8753,1,1,200,18),-- Top-Grade Life Stone: level 46
(20839,1908,1,1,-1,108867),-- Moonstone Earring Wire
(20839,2066,1,1,-1,9017),-- Heavy Doom Hammer Head
(20839,2320,1,1,-1,4006),-- Recipe: Cursed Staff
(20839,57,453,926,0,700000),-- Adena
(20839,631,1,1,1,178),-- Eldarake
(20839,1964,1,1,1,7317),-- Eldarake Temper
(20839,2413,1,1,1,124),-- Chain Hood
(20839,2495,1,1,1,178),-- Chain Shield
(20839,2936,1,1,1,6646),-- Chain Hood Pattern
(20839,2945,1,1,1,7317),-- Chain Shield Fragment
(20839,1867,1,1,2,60371),-- Animal Skin
(20839,1872,1,1,2,60371),-- Animal Bone
(20839,1882,1,1,2,10062),-- Leather
(20839,1894,1,1,2,15897),-- Crafted Leather
(20839,2230,1,1,2,878),-- Recipe: Theca Leather Gaiters
(20839,2326,1,1,2,158),-- Recipe: Horn of Glory
(20839,4042,1,1,2,755),-- Enria
(20839,6668,1,1,2,16171),-- Deluxe Chest Key - Grade 4
(20839,8723,1,1,200,1811),-- Life Stone: level 46
(20839,8733,1,1,200,453),-- Mid-Grade Life Stone: level 46
(20839,8743,1,1,200,45),-- High-Grade Life Stone: level 46
(20839,8753,1,1,200,9),-- Top-Grade Life Stone: level 46
(20840,1967,1,1,-1,64698),-- Plated Leather Gaiters Material
(20840,2166,1,1,-1,40211),-- Recipe: Earrings of Binding (100%)
(20840,2328,1,1,-1,2759),-- Recipe: Sword of Delusion
(20840,57,468,955,0,700000),-- Adena
(20840,227,1,1,1,12),-- Stiletto
(20840,242,1,1,1,12),-- Soulfire Dirk
(20840,2083,1,1,1,873),-- Stiletto Edge
(20840,2084,1,1,1,873),-- Soulfire Dirk Blade
(20840,952,1,1,2,637),-- Scroll: Enchant Armor (Grade C)
(20840,1868,1,1,2,95562),-- Thread
(20840,1873,1,1,2,19112),-- Silver Nugget
(20840,1889,1,1,2,3185),-- Compound Braid
(20840,2229,1,1,2,579),-- Recipe: Theca Leather Armor
(20840,4044,1,1,2,1593),-- Thons
(20840,5549,1,1,2,4778),-- Metallic Thread
(20840,8724,1,1,200,1593),-- Life Stone: level 49
(20840,8734,1,1,200,398),-- Mid-Grade Life Stone: level 49
(20840,8744,1,1,200,40),-- High-Grade Life Stone: level 49
(20840,8754,1,1,200,8),-- Top-Grade Life Stone: level 49
(20841,951,1,1,-1,2217),-- Scroll: Enchant Weapon (Grade C)
(20841,1911,1,1,-1,90711),-- Earring of Protection Gemstone
(20841,4438,1,1,-1,8698),-- Knuckle Duster Edge
(20841,57,482,980,0,700000),-- Adena
(20841,282,1,1,1,12),-- Elemental Bow
(20841,285,1,1,1,12),-- Noble Elven Bow
(20841,2085,1,1,1,935),-- Crossbow Shaft
(20841,2086,1,1,1,935),-- Elven Bow of Nobility Shaft
(20841,952,1,1,2,600),-- Scroll: Enchant Armor (Grade C)
(20841,1864,1,1,2,90063),-- Stem
(20841,1869,1,1,2,45032),-- Iron Ore
(20841,1880,1,1,2,4503),-- Steel
(20841,2348,1,1,2,105),-- Recipe: Heathen\'s Book
(20841,2351,1,1,2,94),-- Recipe: Scorpion
(20841,4043,1,1,2,1501),-- Asofe
(20841,5550,1,1,2,600),-- Durable Metal Plate
(20841,8724,1,1,200,1501),-- Life Stone: level 49
(20841,8734,1,1,200,375),-- Mid-Grade Life Stone: level 49
(20841,8744,1,1,200,38),-- High-Grade Life Stone: level 49
(20841,8754,1,1,200,8),-- Top-Grade Life Stone: level 49
(20842,1976,1,1,-1,70772),-- Rind Leather Gaiters Material
(20842,2167,1,1,-1,59380),-- Recipe: Ring of Ages
(20842,2335,1,1,-1,2707),-- Recipe: War Axe
(20842,57,459,937,0,700000),-- Adena
(20842,853,1,1,1,114),-- Earring of Protection
(20842,884,1,1,1,171),-- Ring of Protection
(20842,916,1,1,1,86),-- Necklace of Protection
(20842,1911,1,1,1,6393),-- Earring of Protection Gemstone
(20842,1912,1,1,1,9262),-- Ring of Protection Gemstone
(20842,1913,1,1,1,5227),-- Necklace of Protection Gemstone
(20842,952,1,1,2,688),-- Scroll: Enchant Armor (Grade C)
(20842,1865,1,1,2,51567),-- Varnish
(20842,1870,1,1,2,51567),-- Coal
(20842,1874,1,1,2,3438),-- Oriharukon Ore
(20842,4039,1,1,2,1719),-- Mold Glue
(20842,4043,1,1,2,1719),-- Asofe
(20842,8724,1,1,200,1719),-- Life Stone: level 49
(20842,8734,1,1,200,430),-- Mid-Grade Life Stone: level 49
(20842,8744,1,1,200,43),-- High-Grade Life Stone: level 49
(20842,8754,1,1,200,9),-- Top-Grade Life Stone: level 49
(20843,1539,1,1,-1,327301),-- Greater Healing Potion
(20843,1914,1,1,-1,82745),-- Earring of Binding Gemstone
(20843,4601,1,1,-1,3273),-- Greater Dye of Strength <Str+3 Con-3>
(20843,57,583,1184,0,700000),-- Adena
(20843,283,1,1,1,18),-- Akat Long Bow
(20843,2109,1,1,1,1708),-- Akat Longbow Shaft
(20843,1866,1,1,2,33838),-- Suede
(20843,1871,1,1,2,50757),-- Charcoal
(20843,1877,1,1,2,2030),-- Adamantite Nugget
(20843,2357,1,1,2,83),-- Recipe: Crystal Dagger
(20843,3014,1,1,2,1418),-- Recipe: Full Plate Boots
(20843,4040,1,1,2,1015),-- Mold Lubricant
(20843,4041,1,1,2,441),-- Mold Hardener
(20843,4188,1,1,2,58),-- Recipe: Hell Knife
(20843,8725,1,1,200,1410),-- Life Stone: level 52
(20843,8735,1,1,200,353),-- Mid-Grade Life Stone: level 52
(20843,8745,1,1,200,35),-- High-Grade Life Stone: level 52
(20843,8755,1,1,200,7),-- Top-Grade Life Stone: level 52
(20844,1539,1,1,-1,292227),-- Greater Healing Potion
(20844,4041,1,1,-1,11435),-- Mold Hardener
(20844,4603,1,1,-1,2922),-- Greater Dye of Constitution <Con+3 Str-3>
(20844,57,521,1058,0,700000),-- Adena
(20844,854,1,1,1,80),-- Earring of Binding
(20844,885,1,1,1,120),-- Ring of Ages
(20844,917,1,1,1,60),-- Necklace of Mermaid
(20844,1914,1,1,1,5091),-- Earring of Binding Gemstone
(20844,1915,1,1,1,7984),-- Ring of Ages Gemstone
(20844,1916,1,1,1,3856),-- Necklace of Mermaid Teardrop
(20844,1867,1,1,2,60423),-- Animal Skin
(20844,1872,1,1,2,60423),-- Animal Bone
(20844,1875,1,1,2,3021),-- Stone of Purity
(20844,1881,1,1,2,6042),-- Coarse Bone Powder
(20844,2355,1,1,2,74),-- Recipe: Ghoul\'s Staff
(20844,4041,1,1,2,394),-- Mold Hardener
(20844,4601,1,1,2,101),-- Greater Dye of Strength <Str+3 Con-3>
(20844,4609,1,1,2,101),-- Greater Dye of Mental Strength <Men+3 Int-3>
(20844,8725,1,1,200,1259),-- Life Stone: level 52
(20844,8735,1,1,200,315),-- Mid-Grade Life Stone: level 52
(20844,8745,1,1,200,31),-- High-Grade Life Stone: level 52
(20844,8755,1,1,200,6),-- Top-Grade Life Stone: level 52
(20845,2100,1,1,-1,10102),-- Paradia Staff Head
(20845,2354,1,1,-1,2923),-- Recipe: Deadman\'s Staff
(20845,4042,1,1,-1,29868),-- Enria
(20845,57,712,1439,0,700000),-- Adena
(20845,75,1,1,1,4),-- Caliburs
(20845,76,1,1,1,4),-- Sword of Delusion
(20845,77,1,1,1,4),-- Tsurugi
(20845,84,1,1,1,4),-- Homunkulus\'s Sword
(20845,134,1,1,1,4),-- Sword of Nightmare
(20845,145,1,1,1,4),-- Sword of Whispering Death
(20845,2089,1,1,1,337),-- Caliburs Edge
(20845,2090,1,1,1,337),-- Delusional Blade
(20845,2091,1,1,1,337),-- Tsurugi Blade
(20845,2092,1,1,1,337),-- Homunkulus\'s Sword Blade
(20845,2095,1,1,1,337),-- Sword of Nightmare Blade
(20845,2096,1,1,1,337),-- Sword of Whispering Death Blade
(20845,1868,1,1,2,105869),-- Thread
(20845,1873,1,1,2,21174),-- Silver Nugget
(20845,1876,1,1,2,10587),-- Mithril Ore
(20845,1895,1,1,2,15124),-- Metallic Fiber
(20845,3017,1,1,2,1479),-- Recipe: Divine Gloves
(20845,4042,1,1,2,882),-- Enria
(20845,4608,1,1,2,118),-- Greater Dye of Intelligence <Int+3 Wit-3>
(20845,5155,1,1,2,106),-- Recipe: Soulshot (B) Compressed Package (100%)
(20845,6669,1,1,2,12310),-- Deluxe Chest Key - Grade 5
(20845,8725,1,1,200,1470),-- Life Stone: level 52
(20845,8735,1,1,200,368),-- Mid-Grade Life Stone: level 52
(20845,8745,1,1,200,37),-- High-Grade Life Stone: level 52
(20845,8755,1,1,200,8),-- Top-Grade Life Stone: level 52
(20846,1918,1,1,-1,68453),-- Nassen\'s Earring Gemstone
(20846,2955,1,1,-1,100037),-- Theca Leather Gloves Texture
(20846,4042,1,1,-1,26343),-- Enria
(20846,57,626,1271,0,700000),-- Adena
(20846,400,1,1,1,31),-- Theca Leather Armor
(20846,401,1,1,1,15),-- Drake Leather Armor
(20846,420,1,1,1,49),-- Theca Leather Gaiters
(20846,1984,1,1,1,2085),-- Theca Leather Armor Pattern
(20846,1985,1,1,1,3354),-- Theca Leather Gaiters Pattern
(20846,1987,1,1,1,1484),-- Drake Leather Armor Texture
(20846,1865,1,1,2,48633),-- Varnish
(20846,1870,1,1,2,48633),-- Coal
(20846,1874,1,1,2,3242),-- Oriharukon Ore
(20846,4039,1,1,2,1621),-- Mold Glue
(20846,4043,1,1,2,1621),-- Asofe
(20846,4133,1,1,2,234),-- Recipe: Zubei\'s Breastplate
(20846,4941,1,1,2,374),-- Recipe: Zubei\'s Gaiters  (60%)
(20846,4959,1,1,2,937),-- Recipe: Avadon Boots (60%)
(20846,8726,1,1,200,1126),-- Life Stone: level 55
(20846,8736,1,1,200,281),-- Mid-Grade Life Stone: level 55
(20846,8746,1,1,200,28),-- High-Grade Life Stone: level 55
(20846,8756,1,1,200,5),-- Top-Grade Life Stone: level 55
(20847,1806,1,1,-1,3022),-- Recipe: Soulshot: B-Grade
(20847,1985,1,1,-1,52100),-- Theca Leather Gaiters Pattern
(20847,4937,1,1,-1,24933),-- Recipe: Adamantite Earrings (70%)
(20847,57,597,1215,0,700000),-- Adena
(20847,2436,1,1,1,38),-- Theca Leather Boots
(20847,2437,1,1,1,29),-- Drake Leather Boots
(20847,2438,1,1,1,29),-- Full Plate Boots
(20847,2460,1,1,1,38),-- Theca Leather Gloves
(20847,2461,1,1,1,29),-- Drake Leather Gloves
(20847,2462,1,1,1,29),-- Full Plate Gauntlets
(20847,2463,1,1,1,29),-- Divine Gloves
(20847,2954,1,1,1,2522),-- Theca Leather Boots Texture
(20847,2955,1,1,1,2522),-- Theca Leather Gloves Texture
(20847,2960,1,1,1,2170),-- Drake Leather Boots Design
(20847,2961,1,1,1,2170),-- Full Plate Boots Part
(20847,2962,1,1,1,2170),-- Drake Leather Gloves Design
(20847,2963,1,1,1,2170),-- Full Plate Gauntlets Part
(20847,2964,1,1,1,2170),-- Divine Gloves Pattern
(20847,1864,1,1,2,92980),-- Stem
(20847,1869,1,1,2,46490),-- Iron Ore
(20847,1878,1,1,2,18596),-- Braided Hemp
(20847,1884,1,1,2,28609),-- Cord
(20847,4039,1,1,2,1550),-- Mold Glue
(20847,4178,1,1,2,853),-- Recipe: Zubei\'s Shield (100%)
(20847,4184,1,1,2,54),-- Recipe: Sprite\'s Staff
(20847,5160,1,1,2,93),-- Recipe: Spiritshot (B) Compressed Package (100%)
(20847,8726,1,1,200,1076),-- Life Stone: level 55
(20847,8736,1,1,200,269),-- Mid-Grade Life Stone: level 55
(20847,8746,1,1,200,27),-- High-Grade Life Stone: level 55
(20847,8756,1,1,200,6),-- Top-Grade Life Stone: level 55
(20848,1871,1,5,-1,647978),-- Charcoal
(20848,1895,1,1,-1,555409),-- Metallic Fiber
(20848,1908,1,1,-1,184085),-- Moonstone Earring Wire
(20848,57,766,1566,0,700000),-- Adena
(20848,96,1,1,1,17),-- Scythe
(20848,298,1,1,1,17),-- Orcish Glaive
(20848,302,1,1,1,17),-- Body Slasher
(20848,2062,1,1,1,1201),-- Scythe Edge
(20848,2075,1,1,1,1201),-- Orcish Glaive Blade
(20848,2076,1,1,1,1201),-- Body Slasher Blade
(20848,1864,1,3,2,91873),-- Stem
(20848,1865,1,1,2,91873),-- Varnish
(20848,1866,1,1,2,61249),-- Suede
(20848,1868,1,1,2,183746),-- Thread
(20848,1873,1,1,2,36749),-- Silver Nugget
(20848,2164,1,1,2,7067),-- Recipe: Ring of Protection
(20848,8723,1,1,200,3675),-- Life Stone: level 46
(20848,8733,1,1,200,919),-- Mid-Grade Life Stone: level 46
(20848,8743,1,1,200,92),-- High-Grade Life Stone: level 46
(20848,8753,1,1,200,18),-- Top-Grade Life Stone: level 46
(20849,1805,1,1,-1,5124),-- Recipe: Soulshot: C-Grade
(20849,1956,1,1,-1,174488),-- Square Shield Fragment
(20849,4469,1,1,-1,8784),-- Dye of Strength <Str+1 Con-1>
(20849,57,623,1246,0,700000),-- Adena
(20849,438,1,1,1,211),-- Sage\'s Rag
(20849,1953,1,1,1,12362),-- Sage\'s Rag Lining
(20849,1867,1,1,2,114360),-- Animal Skin
(20849,1869,1,1,2,85770),-- Iron Ore
(20849,1870,1,1,2,85770),-- Coal
(20849,1871,1,1,2,85770),-- Charcoal
(20849,1872,1,1,2,114360),-- Animal Bone
(20849,2205,1,1,2,2714),-- Recipe: Chain Gaiters
(20849,2211,1,1,2,1923),-- Recipe: Plated Leather Armor
(20849,5274,1,1,2,286),-- Recipe: Greater Spiritshot (C) Compressed Package(100%)
(20849,5279,1,1,2,286),-- Recipe: Greater Blessed Spiritshot (C) Compressed Package(100%)
(20859,3035,1,1,-1,22327),-- Recipe: Spiritshot A
(20859,5479,1,1,-1,99083),-- Sealed Tallum Leather Armor Pattern
(20859,57,8257,16860,0,700000),-- Adena
(20859,5287,1,1,1,58),-- Sealed Dark Crystal breastplate
(20859,5288,1,1,1,93),-- Sealed Dark Crystal Gaiters
(20859,5293,1,1,1,36),-- Sealed Tallum Plate Armor
(20859,5520,1,1,1,6645),-- Sealed Dark Crystal Breastplate Pattern
(20859,5521,1,1,1,4689),-- Sealed Tallum Plate Armor Pattern
(20859,5524,1,1,1,10157),-- Sealed Dark Crystal Gaiters Pattern
(20859,1867,7,21,2,54958),-- Animal Skin
(20859,1872,4,12,2,103047),-- Animal Bone
(20859,1875,1,1,2,41219),-- Stone of Purity
(20859,1881,1,1,2,82437),-- Coarse Bone Powder
(20859,3035,1,1,2,824),-- Recipe: Spiritshot A
(20859,4041,1,1,2,5376),-- Mold Hardener
(20859,8730,1,1,200,6870),-- Life Stone: level 67
(20859,8740,1,1,200,1717),-- Mid-Grade Life Stone: level 67
(20859,8750,1,1,200,172),-- High-Grade Life Stone: level 67
(20859,8760,1,1,200,34),-- Top-Grade Life Stone: level 67
(20860,5156,1,1,-1,31381),-- Recipe: Soulshot (A) Compressed Package (100%)
(20860,5482,1,1,-1,310640),-- Sealed Dark Crystalline Leggings Design
(20860,5485,1,1,-1,197912),-- Sealed Tallum Tunic Texture
(20860,57,11622,23663,0,700000),-- Adena
(20860,5287,1,1,1,81),-- Sealed Dark Crystal breastplate
(20860,5288,1,1,1,130),-- Sealed Dark Crystal Gaiters
(20860,5293,1,1,1,50),-- Sealed Tallum Plate Armor
(20860,5520,1,1,1,9340),-- Sealed Dark Crystal Breastplate Pattern
(20860,5521,1,1,1,6591),-- Sealed Tallum Plate Armor Pattern
(20860,5524,1,1,1,14276),-- Sealed Dark Crystal Gaiters Pattern
(20860,1868,15,45,2,57934),-- Thread
(20860,1873,2,6,2,86901),-- Silver Nugget
(20860,1876,1,1,2,173802),-- Mithril Ore
(20860,1895,3,9,2,41381),-- Metallic Fiber
(20860,4042,1,1,2,14484),-- Enria
(20860,5271,1,1,2,1159),-- Recipe: Greater Soulshot (A) Compressed Package(100%)
(20860,8731,1,1,200,8046),-- Life Stone: level 70
(20860,8741,1,1,200,2012),-- Mid-Grade Life Stone: level 70
(20860,8751,1,1,200,201),-- High-Grade Life Stone: level 70
(20860,8761,1,1,200,40),-- Top-Grade Life Stone: level 70
(20919,734,1,1,-1,20266),-- Haste Potion
(20919,1865,1,1,-1,121597),-- Varnish
(20919,5220,1,1,-1,4864),-- Metal Hardener
(20919,57,56,98,0,700000),-- Adena
(20919,24,1,1,1,230),-- Bone Breastplate
(20919,31,1,1,1,368),-- Bone Gaiters
(20919,390,1,1,1,230),-- Cotton Shirt
(20919,412,1,1,1,368),-- Cotton Pants
(20919,1867,1,1,2,23946),-- Animal Skin
(20919,1872,1,1,2,23946),-- Animal Bone
(20919,1881,1,1,2,2395),-- Coarse Bone Powder
(20919,2141,1,1,2,3592),-- Recipe: Silver Mold
(20920,1898,1,1,-1,26897),-- Blue Diamond Necklace Gem
(20920,2014,1,1,-1,3010),-- Iron Hammer Head
(20920,5163,1,1,-1,10474),-- Recipe: Blessed Spiritshot (D) Compressed Package (100%)
(20920,57,119,213,0,700000),-- Adena
(20920,273,1,1,1,82),-- Composition Bow
(20920,2016,1,1,1,907),-- Composition Bow Shaft
(20920,735,1,1,2,2148),-- Potion of Alacrity
(20920,1060,1,1,2,57291),-- Lesser Healing Potion
(20920,1865,1,1,2,25781),-- Varnish
(20920,1870,1,1,2,25781),-- Coal
(20920,1879,1,1,2,4297),-- Cokes
(20921,1804,1,1,-1,7333),-- Recipe: Soulshot: D-Grade
(20921,1864,1,1,-1,366638),-- Stem
(20921,1928,1,1,-1,26703),-- Piece Bone Gaiters Fragment
(20921,57,81,150,0,700000),-- Adena
(20921,39,1,1,1,760),-- Boots
(20921,51,1,1,1,760),-- Bracer
(20921,1930,1,1,1,9256),-- Boot Lining
(20921,1880,1,1,2,2166),-- Steel
(20921,1881,1,1,2,2888),-- Coarse Bone Powder
(20921,1882,1,1,2,4813),-- Leather
(20921,3032,1,1,2,866),-- Recipe: Spiritshot D
(20921,6666,1,1,2,21660),-- Deluxe Chest Key - Grade 2
(20922,1870,1,1,-1,198933),-- Coal
(20922,1899,1,1,-1,31083),-- Necklace of Devotion Chain
(20922,1932,1,1,-1,31577),-- Bone Helmet Design
(20922,57,86,165,0,700000),-- Adena
(20922,123,1,1,1,18),-- Saber
(20922,2017,1,1,1,371),-- Saber Blade
(20922,5285,1,1,1,18),-- Heavy Sword
(20922,5531,1,1,1,469),-- Heavy Sword Edge
(20922,1060,1,1,2,49621),-- Lesser Healing Potion
(20922,1874,1,1,2,1489),-- Oriharukon Ore
(20922,1878,1,1,2,8932),-- Braided Hemp
(20922,2259,1,1,2,347),-- Recipe: Spinebone Sword
(20922,5220,1,1,2,893),-- Metal Hardener
(20923,2019,1,1,-1,6166),-- Trident Edge
(20923,2152,1,1,-1,50483),-- Recipe: Enchanted Necklace
(20923,2263,1,1,-1,4453),-- Recipe: Dwarven Trident
(20923,57,123,241,0,700000),-- Adena
(20923,432,1,1,1,334),-- Cursed Tunic
(20923,465,1,1,1,535),-- Cursed Stockings
(20923,735,1,1,2,2235),-- Potion of Alacrity
(20923,1875,1,1,2,1788),-- Stone of Purity
(20923,1879,1,1,2,4470),-- Cokes
(20923,1885,1,1,2,2235),-- High Grade Suede
(20923,5549,1,1,2,2682),-- Metallic Thread
(20923,5550,1,1,2,358),-- Durable Metal Plate
(20924,1900,1,1,-1,37924),-- Enchanted Necklace Chain
(20924,1937,1,1,-1,29779),-- Scale Gaiters Fragment
(20924,2250,1,1,-1,86656),-- Recipe: Bone Arrow
(20924,57,146,292,0,700000),-- Adena
(20924,259,1,1,1,76),-- Single-Edged Jamadhr
(20924,1876,1,1,2,4735),-- Mithril Ore
(20924,1877,1,1,2,947),-- Adamantite Nugget
(20924,1880,1,1,2,2368),-- Steel
(20924,1881,1,1,2,3157),-- Coarse Bone Powder
(20924,1882,1,1,2,5261),-- Leather
(20924,2183,1,1,2,1558),-- Recipe: Mithril Banded Mail
(20924,2274,1,1,2,169),-- Recipe: Skull Breaker
(20924,6667,1,1,2,14798),-- Deluxe Chest Key - Grade 3
(20925,1874,1,1,-1,12461),-- Oriharukon Ore
(20925,2016,1,1,-1,2190),-- Composition Bow Shaft
(20925,2258,1,1,-1,4570),-- Recipe: Temptation of Abyss
(20925,57,83,153,0,700000),-- Adena
(20925,846,1,1,1,449),-- Coral Earring
(20925,878,1,1,1,673),-- Blue Coral Ring
(20925,909,1,1,1,337),-- Blue Diamond Necklace
(20925,1898,1,1,1,2836),-- Blue Diamond Necklace Gem
(20925,1060,1,1,2,40898),-- Lesser Healing Potion
(20925,1867,1,1,2,24539),-- Animal Skin
(20925,1872,1,1,2,24539),-- Animal Bone
(20925,1881,1,1,2,2454),-- Coarse Bone Powder
(20925,8294,1,1,2,450),-- Recipe: Steel Sword (100%)
(20925,5273,1,1,2,737),-- Recipe: Greater Spiritshot (D) Compressed Package(100%)
(20926,1869,1,1,-1,214041),-- Iron Ore
(20926,1875,1,1,-1,14269),-- Stone of Purity
(20926,2018,1,1,-1,2844),-- Assassin Knife Edge
(20926,57,94,177,0,700000),-- Adena
(20926,156,1,1,1,25),-- Hand Axe
(20926,167,1,1,1,25),-- Scalpel
(20926,178,1,1,1,25),-- Bone Staff
(20926,1831,1,1,2,45762),-- Antidote
(20926,1834,1,1,2,19067),-- Emergency Dressing
(20926,1875,1,1,2,1144),-- Stone of Purity
(20926,1879,1,1,2,2860),-- Cokes
(20926,2178,1,1,2,2746),-- Recipe: Dark Stockings
(20926,5437,1,1,2,420),-- Recipe: Heavy Sword(100%)
(20926,5549,1,1,2,1716),-- Metallic Thread
(20927,1866,1,1,-1,200876),-- Suede
(20927,1899,1,1,-1,47080),-- Necklace of Devotion Chain
(20927,1932,1,1,-1,47828),-- Bone Helmet Design
(20927,57,130,251,0,700000),-- Adena
(20927,220,1,1,1,107),-- Crafted Dagger
(20927,1876,1,1,2,5637),-- Mithril Ore
(20927,1877,1,1,2,1127),-- Adamantite Nugget
(20927,1880,1,1,2,2818),-- Steel
(20927,1881,1,1,2,3758),-- Coarse Bone Powder
(20927,1882,1,1,2,6263),-- Leather
(20927,2178,1,1,2,4509),-- Recipe: Dark Stockings
(20928,2025,1,1,-1,4126),-- Dwarven Trident Edge
(20928,2153,1,1,-1,46326),-- Recipe: Tiger\'s Eye Earring
(20928,2183,1,1,-1,19597),-- Recipe: Mithril Banded Mail
(20928,57,126,251,0,700000),-- Adena
(20928,348,1,1,1,79),-- Scale Mail
(20928,377,1,1,1,127),-- Scale Gaiters
(20928,1935,1,1,1,2273),-- Scale Mail Fragment
(20928,1937,1,1,1,3496),-- Scale Gaiters Fragment
(20928,1832,1,1,2,22608),-- Greater Antidote
(20928,1867,1,1,2,27130),-- Animal Skin
(20928,1872,1,1,2,27130),-- Animal Bone
(20928,1875,1,1,2,1356),-- Stone of Purity
(20928,1881,1,1,2,2713),-- Coarse Bone Powder
(20928,2184,1,1,2,2137),-- Recipe: Mithril Banded Gaiters
(20928,2274,1,1,2,145),-- Recipe: Skull Breaker
(20928,2978,1,1,2,2724),-- Recipe: Elven Mithril Boots
(20929,956,1,1,-1,9316),-- Scroll: Enchant Armor (Grade D)
(20929,1871,1,1,-1,279467),-- Charcoal
(20929,1900,1,1,-1,30576),-- Enchanted Necklace Chain
(20929,57,118,236,0,700000),-- Adena
(20929,315,1,1,1,62),-- Divine Tome
(20929,1060,1,1,2,48482),-- Lesser Healing Potion
(20929,1865,1,1,2,21817),-- Varnish
(20929,1870,1,1,2,21817),-- Coal
(20929,1875,1,1,2,1454),-- Stone of Purity
(20929,1879,1,1,2,3636),-- Cokes
(20929,2250,1,1,2,5454),-- Recipe: Bone Arrow
(20929,6387,1,1,2,873),-- Blessed Scroll of Resurrection for Pets
(20930,2028,1,1,-1,5182),-- Shilen Knife Edge
(20930,2154,1,1,-1,46692),-- Recipe: Elven Earring
(20930,2156,1,1,-1,34888),-- Recipe: Elven Necklace
(20930,57,184,367,0,700000),-- Adena
(20930,83,1,1,1,14),-- Sword of Magic
(20930,124,1,1,1,10),-- Two-Handed Sword
(20930,127,1,1,1,10),-- Crimson Sword
(20930,130,1,1,1,10),-- Elven Sword
(20930,144,1,1,1,14),-- Sword of Occult
(20930,2026,1,1,1,465),-- Two-Handed Sword Edge
(20930,735,1,1,2,2760),-- Potion of Alacrity
(20930,1864,1,1,2,66249),-- Stem
(20930,1869,1,1,2,33125),-- Iron Ore
(20930,1880,1,1,2,3312),-- Steel
(20930,2279,1,1,2,237),-- Recipe: War Pick
(20930,8317,1,1,2,237),-- Recipe: Titan Hammer (100%)
(20930,5550,1,1,2,442),-- Durable Metal Plate
(20931,1901,1,1,-1,66909),-- Tiger\'s Eye Earring Stone
(20931,1940,1,1,-1,72301),-- Iron Boots Design
(20931,2271,1,1,-1,3460),-- Recipe: Winged Spear
(20931,57,204,409,0,700000),-- Adena
(20931,293,1,1,1,35),-- War Hammer
(20931,296,1,1,1,35),-- Dwarven Pike
(20931,1865,1,1,2,36794),-- Varnish
(20931,1870,1,1,2,36794),-- Coal
(20931,1875,1,1,2,2453),-- Stone of Purity
(20931,1879,1,1,2,6132),-- Cokes
(20931,2197,1,1,2,771),-- Recipe: Salamander Skin Mail
(20931,2276,1,1,2,263),-- Recipe: Maingauche
(20931,2286,1,1,2,204),-- Recipe: Bonebreaker
(20932,1825,1,1,-1,37742),-- Recipe: Oriharukon
(20932,2032,1,1,-1,4883),-- Goat Head Staff Head
(20932,5220,1,1,-1,21136),-- Metal Hardener
(20932,57,223,446,0,700000),-- Adena
(20932,850,1,1,1,127),-- Elven Earring
(20932,881,1,1,1,190),-- Elven Ring
(20932,913,1,1,1,95),-- Elven Necklace
(20932,1902,1,1,1,4612),-- Elven Earring Beads
(20932,1903,1,1,1,7593),-- Elven Ring Piece
(20932,1904,1,1,1,4249),-- Elven Necklace Beads
(20932,1060,1,1,2,86711),-- Lesser Healing Potion
(20932,1866,1,1,2,26013),-- Suede
(20932,1871,1,1,2,39020),-- Charcoal
(20932,1885,1,1,2,3252),-- High Grade Suede
(20932,2159,1,1,2,2409),-- Recipe: Necklace of Darkness
(20932,2201,1,1,2,3788),-- Recipe: Square Shield
(20932,5220,1,1,2,1561),-- Metal Hardener
(20933,1879,1,1,-1,101112),-- Cokes
(20933,1880,1,1,-1,60667),-- Steel
(20933,1894,1,1,-1,21287),-- Crafted Leather
(20933,57,253,505,0,700000),-- Adena
(20933,261,1,1,1,29),-- Bich\'Hwa
(20933,2039,1,1,1,1588),-- Bich\'Hwa Edge
(20933,1865,1,1,2,52267),-- Varnish
(20933,1870,1,1,2,52267),-- Coal
(20933,1875,1,1,2,3484),-- Stone of Purity
(20933,1879,1,1,2,8711),-- Cokes
(20933,2159,1,1,2,3226),-- Recipe: Necklace of Darkness
(20933,2298,1,1,2,228),-- Recipe: Stormbringer
(20934,1868,1,1,-1,654152),-- Thread
(20934,1938,1,1,-1,21988),-- Mithril Banded Mail Material
(20934,2028,1,1,-1,3886),-- Shilen Knife Edge
(20934,57,138,276,0,700000),-- Adena
(20934,436,1,1,1,149),-- Tunic of Knowledge
(20934,469,1,1,1,237),-- Stockings of Knowledge
(20934,1867,1,1,2,46374),-- Animal Skin
(20934,1872,1,1,2,46374),-- Animal Bone
(20934,1882,1,1,2,7729),-- Leather
(20934,2190,1,1,2,2484),-- Recipe: Mithril Stockings
(20934,3020,1,1,2,193),-- Recipe: Elven Long Sword
(20935,1825,1,1,-1,25471),-- Recipe: Oriharukon
(20935,1872,1,1,-1,475451),-- Animal Bone
(20935,2040,1,1,-1,4126),-- Strengthened Long Bow Shaft
(20935,57,151,301,0,700000),-- Adena
(20935,629,1,1,1,102),-- Kite Shield
(20935,1947,1,1,1,4423),-- Kite Shield Fragment
(20935,2411,1,1,1,71),-- Brigandine Helmet
(20935,2493,1,1,1,102),-- Brigandine Shield
(20935,2922,1,1,1,1183),-- Brigandine Helmet Design
(20935,2929,1,1,1,4423),-- Brigandine Shield Fragment
(20935,1868,1,1,2,52665),-- Thread
(20935,1873,1,1,2,10533),-- Silver Nugget
(20935,1889,1,1,2,1756),-- Compound Braid
(20935,2148,1,1,2,1881),-- Recipe: Crafted Leather
(20935,2288,1,1,2,146),-- Recipe: Ghost Staff
(20935,2984,1,1,2,2692),-- Recipe: Salamander Skin Boots
(20935,5549,1,1,2,2633),-- Metallic Thread
(20936,1874,1,1,-1,45199),-- Oriharukon Ore
(20936,1875,1,1,-1,45199),-- Stone of Purity
(20936,1902,1,1,-1,68692),-- Elven Earring Beads
(20936,57,283,565,0,700000),-- Adena
(20936,437,1,1,1,102),-- Mithril Tunic
(20936,470,1,1,1,163),-- Mithril Stockings
(20936,1944,1,1,1,4469),-- Mithril Tunic Fabric
(20936,1945,1,1,1,6959),-- Mithril Stocking Design
(20936,1865,1,1,2,58412),-- Varnish
(20936,1870,1,1,2,58412),-- Coal
(20936,1875,1,1,2,3894),-- Stone of Purity
(20936,1879,1,1,2,9735),-- Cokes
(20936,2159,1,1,2,3606),-- Recipe: Necklace of Darkness
(20936,2298,1,1,2,255),-- Recipe: Stormbringer
(20937,1805,1,1,-1,2977),-- Recipe: Soulshot: C-Grade
(20937,2054,1,1,-1,7601),-- Light Crossbow Shaft
(20937,4480,1,1,-1,5103),-- Dye of Wit <Wit+1 Men-1>
(20937,57,360,727,0,700000),-- Adena
(20937,61,1,1,1,99),-- Mithril Gloves
(20937,607,1,1,1,99),-- Ogre Power Gauntlets
(20937,1125,1,1,1,99),-- Assault Boots
(20937,1949,1,1,1,4171),-- Mithril Gloves Design
(20937,1957,1,1,1,4171),-- Assault Boots Part
(20937,1963,1,1,1,4171),-- Ogre Power Gauntlets Part
(20937,2427,1,1,1,99),-- Salamander Skin Boots
(20937,2428,1,1,1,99),-- Plate Boots
(20937,2451,1,1,1,99),-- Sage\'s Worn Gloves
(20937,2931,1,1,1,4171),-- Salamander Skin Boot Lining
(20937,2932,1,1,1,4171),-- Plate Boots Design
(20937,2933,1,1,1,4171),-- Sage\'s Worn Gloves Lining
(20937,1866,1,1,2,42710),-- Suede
(20937,1871,1,1,2,64065),-- Charcoal
(20937,1885,1,1,2,5339),-- High Grade Suede
(20937,2205,1,1,2,2027),-- Recipe: Chain Gaiters
(20937,2307,1,1,2,280),-- Recipe: Heavy Doom Axe
(20937,5164,1,1,2,213),-- Recipe: Blessed Spiritshot (C) Compressed Package (100%)
(20937,5220,1,1,2,2563),-- Metal Hardener
(20938,1908,1,1,-1,93255),-- Moonstone Earring Wire
(20938,2070,1,1,-1,7819),-- Cursed Dagger Blade
(20938,2323,1,1,-1,3431),-- Recipe: Elemental Bow
(20938,57,388,794,0,700000),-- Adena
(20938,281,1,1,1,26),-- Crystallized Ice Bow
(20938,2074,1,1,1,1649),-- Crystallized Ice Bow Shaft
(20938,1867,1,1,2,56415),-- Animal Skin
(20938,1872,1,1,2,56415),-- Animal Bone
(20938,1882,1,1,2,9402),-- Leather
(20938,1894,1,1,2,1485),-- Crafted Leather
(20938,2315,1,1,2,147),-- Recipe: Shamshir
(20938,2317,1,1,2,147),-- Recipe: Bec de Corbin
(20938,2321,1,1,2,147),-- Recipe: Stiletto
(20938,8723,1,1,200,1693),-- Life Stone: level 46
(20938,8733,1,1,200,423),-- Mid-Grade Life Stone: level 46
(20938,8743,1,1,200,42),-- High-Grade Life Stone: level 46
(20938,8753,1,1,200,8),-- Top-Grade Life Stone: level 46
(20939,1868,1,5,-1,733092),-- Thread
(20939,1873,1,1,-1,439855),-- Silver Nugget
(20939,2067,1,1,-1,7925),-- Crystal Staff Head
(20939,57,433,886,0,700000),-- Adena
(20939,397,1,1,1,89),-- Mithril Shirt
(20939,1961,1,1,1,4158),-- Mithril Shirt Fabric
(20939,2387,1,1,1,143),-- Tempered Mithril Gaiters
(20939,2935,1,1,1,6908),-- Tempered Mithril Gaiters Fragment
(20939,1868,1,1,2,94492),-- Thread
(20939,1873,1,1,2,18898),-- Silver Nugget
(20939,1889,1,1,2,3150),-- Compound Braid
(20939,2225,1,1,2,1027),-- Recipe: Demon\'s Stockings
(20939,2343,1,1,2,110),-- Recipe: Mace of the Underworld
(20939,4044,1,1,2,1575),-- Thons
(20939,5549,1,1,2,4725),-- Metallic Thread
(20939,8723,1,1,200,1890),-- Life Stone: level 46
(20939,8733,1,1,200,472),-- Mid-Grade Life Stone: level 46
(20939,8743,1,1,200,47),-- High-Grade Life Stone: level 46
(20939,8753,1,1,200,9),-- Top-Grade Life Stone: level 46
(20940,1970,1,1,-1,36908),-- Robe of Seal Fabric
(20940,4589,1,1,-1,5509),-- Greater Dye of Strength <Str+2 Con-2>
(20940,5550,1,1,-1,22037),-- Durable Metal Plate
(20940,57,653,1328,0,700000),-- Adena
(20940,4233,1,1,1,33),-- Knuckle Duster
(20940,4438,1,1,1,2611),-- Knuckle Duster Edge
(20940,1864,1,1,2,122050),-- Stem
(20940,1869,1,1,2,61025),-- Iron Ore
(20940,1880,1,1,2,6103),-- Steel
(20940,2350,1,1,2,128),-- Recipe: Pa\'agrian Axe
(20940,3005,1,1,2,2491),-- Recipe: Demon\'s Boots
(20940,4043,1,1,2,2034),-- Asofe
(20940,4132,1,1,2,2365),-- Recipe: Composite Shield
(20940,5550,1,1,2,814),-- Durable Metal Plate
(20940,8724,1,1,200,2034),-- Life Stone: level 49
(20940,8734,1,1,200,509),-- Mid-Grade Life Stone: level 49
(20940,8754,1,1,200,51),-- High-Grade Life Stone: level 49
(20940,8764,1,1,200,10),-- Top-Grade Life Stone: level 49
(20941,2109,1,1,-1,7302),-- Akat Longbow Shaft
(20941,2233,1,1,-1,12171),-- Recipe: Divine Tunic
(20941,4601,1,1,-1,2894),-- Greater Dye of Strength <Str+3 Con-3>
(20941,57,515,1047,0,700000),-- Adena
(20941,60,1,1,1,44),-- Composite Armor
(20941,1977,1,1,1,3983),-- Composite Armor Temper
(20941,1865,1,1,2,44877),-- Varnish
(20941,1870,1,1,2,44877),-- Coal
(20941,1874,1,1,2,2992),-- Oriharukon Ore
(20941,3013,1,1,2,1254),-- Recipe: Drake Leather Boots
(20941,3014,1,1,2,1254),-- Recipe: Full Plate Boots
(20941,4039,1,1,2,1496),-- Mold Glue
(20941,4043,1,1,2,1496),-- Asofe
(20941,8725,1,1,200,1247),-- Life Stone: level 52
(20941,8735,1,1,200,312),-- Mid-Grade Life Stone: level 52
(20941,8745,1,1,200,31),-- High-Grade Life Stone: level 52
(20941,8755,1,1,200,6),-- Top-Grade Life Stone: level 52
(20942,1905,1,1,-1,63768),-- Omen Beast\'s Eye Earring Gemstone
(20942,2301,1,1,-1,2863),-- Recipe: Battle Axe
(20942,2931,1,1,-1,73162),-- Salamander Skin Boot Lining
(20942,57,259,526,0,700000),-- Adena
(20942,225,1,1,1,24),-- Mithril Dagger
(20942,2052,1,1,1,1427),-- Mithril Dagger Blade
(20942,1866,1,1,2,27432),-- Suede
(20942,1871,1,1,2,41147),-- Charcoal
(20942,1877,1,1,2,1646),-- Adamantite Nugget
(20942,2225,1,1,2,895),-- Recipe: Demon\'s Stockings
(20942,8723,1,1,200,1646),-- Life Stone: level 46
(20942,8733,1,1,200,411),-- Mid-Grade Life Stone: level 46
(20942,8743,1,1,200,41),-- High-Grade Life Stone: level 46
(20942,8753,1,1,200,8),-- Top-Grade Life Stone: level 46
(20943,1874,1,1,-1,62887),-- Oriharukon Ore
(20943,1875,1,1,-1,62887),-- Stone of Purity
(20943,2163,1,1,-1,48128),-- Recipe: Earring of Protection
(20943,57,373,758,0,700000),-- Adena
(20943,263,1,1,1,25),-- Chakram
(20943,2073,1,1,1,1723),-- Chakram Edge
(20943,1867,1,1,2,59443),-- Animal Skin
(20943,1872,1,1,2,59443),-- Animal Bone
(20943,1875,1,1,2,2972),-- Stone of Purity
(20943,1881,1,1,2,5944),-- Coarse Bone Powder
(20943,2225,1,1,2,969),-- Recipe: Demon\'s Stockings
(20943,4041,1,1,2,388),-- Mold Hardener
(20943,8723,1,1,200,1783),-- Life Stone: level 46
(20943,8733,1,1,200,446),-- Mid-Grade Life Stone: level 46
(20943,8743,1,1,200,45),-- High-Grade Life Stone: level 46
(20943,8753,1,1,200,9),-- Top-Grade Life Stone: level 46
(20944,1911,1,1,-1,59386),-- Earring of Protection Gemstone
(20944,2329,1,1,-1,1857),-- Recipe: Tsurugi
(20944,2947,1,1,-1,57031),-- Dwarven Chain Shield Fragment
(20944,57,315,643,0,700000),-- Adena
(20944,853,1,1,1,78),-- Earring of Protection
(20944,884,1,1,1,118),-- Ring of Protection
(20944,916,1,1,1,59),-- Necklace of Protection
(20944,1911,1,1,1,4386),-- Earring of Protection Gemstone
(20944,1912,1,1,1,6354),-- Ring of Protection Gemstone
(20944,1913,1,1,1,3586),-- Necklace of Protection Gemstone
(20944,1868,1,1,2,70754),-- Thread
(20944,1873,1,1,2,14151),-- Silver Nugget
(20944,1876,1,1,2,7075),-- Mithril Ore
(20944,1895,1,1,2,10108),-- Metallic Fiber
(20944,2328,1,1,2,82),-- Recipe: Sword of Delusion
(20944,4042,1,1,2,590),-- Enria
(20944,8724,1,1,200,1179),-- Life Stone: level 49
(20944,8734,1,1,200,295),-- Mid-Grade Life Stone: level 49
(20944,8754,1,1,200,30),-- High-Grade Life Stone: level 49
(20944,8764,1,1,200,6),-- Top-Grade Life Stone: level 49
(20945,1868,1,3,-1,897692),-- Thread
(20945,1876,1,1,-1,179538),-- Mithril Ore
(20945,4601,1,1,-1,1995),-- Greater Dye of Strength <Str+3 Con-3>
(20945,57,355,722,0,700000),-- Adena
(20945,64,1,1,1,98),-- Composite Boots
(20945,608,1,1,1,98),-- Mithril Gauntlets
(20945,1981,1,1,1,5459),-- Mithril Gauntlets Design
(20945,2956,1,1,1,5459),-- Composite Boots Part
(20945,1868,1,1,2,67496),-- Thread
(20945,1873,1,1,2,13499),-- Silver Nugget
(20945,1876,1,1,2,6750),-- Mithril Ore
(20945,1895,1,1,2,9642),-- Metallic Fiber
(20945,2170,1,1,2,796),-- Recipe: Nassen\'s Earring
(20945,2970,1,1,2,1197),-- Recipe: Ring of Binding
(20945,4042,1,1,2,562),-- Enria
(20945,8725,1,1,200,937),-- Life Stone: level 52
(20945,8735,1,1,200,234),-- Mid-Grade Life Stone: level 52
(20945,8745,1,1,200,23),-- High-Grade Life Stone: level 52
(20945,8755,1,1,200,5),-- Top-Grade Life Stone: level 52
(20946,1539,1,1,-1,307481),-- Greater Healing Potion
(20946,1914,1,1,-1,77734),-- Earring of Binding Gemstone
(20946,2169,1,1,-1,24490),-- Recipe: Necklace of Binding
(20946,57,550,1111,0,700000),-- Adena
(20946,103,1,1,1,72),-- Tower Shield
(20946,107,1,1,1,72),-- Composite Shield
(20946,517,1,1,1,51),-- Composite Helmet
(20946,1149,1,1,1,51),-- Shining Circlet
(20946,1978,1,1,1,4585),-- Tower Shield Fragment
(20946,1983,1,1,1,3137),-- Shining Circlet Pattern
(20946,2957,1,1,1,3137),-- Composite Helmet Design
(20946,4055,1,1,1,4585),-- Composite Shield Fragment
(20946,1864,1,1,2,104036),-- Stem
(20946,1869,1,1,2,52018),-- Iron Ore
(20946,1878,1,1,2,20807),-- Braided Hemp
(20946,1884,1,1,2,32011),-- Cord
(20946,2233,1,1,2,486),-- Recipe: Divine Tunic
(20946,4039,1,1,2,1734),-- Mold Glue
(20946,4180,1,1,2,5780),-- Recipe: Silver Arrow
(20946,8725,1,1,200,1445),-- Life Stone: level 52
(20946,8735,1,1,200,361),-- Mid-Grade Life Stone: level 52
(20946,8745,1,1,200,36),-- High-Grade Life Stone: level 52
(20946,8755,1,1,200,7),-- Top-Grade Life Stone: level 52
(20947,1806,1,1,-1,2996),-- Recipe: Soulshot: B-Grade
(20947,4938,1,1,-1,37080),-- Recipe: Adamantite Ring (70%)
(20947,4967,1,1,-1,1726),-- Recipe: Sword of Valhalla (60%)
(20947,57,592,1205,0,700000),-- Adena
(20947,356,1,1,1,31),-- Full Plate Armor
(20947,1986,1,1,1,2922),-- Full Plate Armor Temper
(20947,1864,1,1,2,92186),-- Stem
(20947,1869,1,1,2,46093),-- Iron Ore
(20947,1880,1,1,2,4609),-- Steel
(20947,4043,1,1,2,1536),-- Asofe
(20947,4144,1,1,2,474),-- Recipe: Zubei\'s Leather Gaiters
(20947,4179,1,1,2,592),-- Recipe: Zubei\'s Helmet
(20947,4184,1,1,2,53),-- Recipe: Sprite\'s Staff
(20947,5550,1,1,2,615),-- Durable Metal Plate
(20947,8726,1,1,200,1067),-- Life Stone: level 55
(20947,8736,1,1,200,267),-- Mid-Grade Life Stone: level 55
(20947,8746,1,1,200,27),-- High-Grade Life Stone: level 55
(20947,8756,1,1,200,5),-- Top-Grade Life Stone: level 55
(20948,4049,1,1,-1,78274),-- Adamantite Earring Gemstone
(20948,4050,1,1,-1,92459),-- Adamantite Ring Wire
(20948,4129,1,1,-1,16150),-- Recipe: Earrings of Black Ore
(20948,57,589,1202,0,700000),-- Adena
(20948,11889,1,1,1,42),-- Common Item - Great Sword
(20948,11916,1,1,1,42),-- Common Item - Keshanberk
(20948,11900,1,1,1,42),-- Common Item - Sword of Valhalla
(20948,4104,1,1,1,420),-- Great Sword Blade
(20948,4107,1,1,1,414),-- Keshanberk Blade
(20948,4108,1,1,1,414),-- Sword of Valhalla Blade
(20948,948,1,1,2,92),-- Scroll: Enchant Armor (Grade B)
(20948,1865,1,1,2,36733),-- Varnish
(20948,1870,1,1,2,36733),-- Coal
(20948,1875,1,1,2,2449),-- Stone of Purity
(20948,1879,1,1,2,6122),-- Cokes
(20948,4040,1,1,2,735),-- Mold Lubricant
(20948,4158,1,1,2,78),-- Recipe: Doom Plate Armor
(20948,4176,1,1,2,457),-- Recipe: Doom Boots
(20948,8727,1,1,200,735),-- Life Stone: level 58
(20948,8737,1,1,200,184),-- Mid-Grade Life Stone: level 58
(20948,8747,1,1,200,18),-- High-Grade Life Stone: level 58
(20948,8757,1,1,200,4),-- Top-Grade Life Stone: level 58
(20949,947,1,1,-1,706),-- Scroll: Enchant Weapon (Grade B)
(20949,1866,1,3,-1,588296),-- Suede
(20949,4041,1,1,-1,15347),-- Mold Hardener
(20949,57,697,1420,0,700000),-- Adena
(20949,11918,1,1,1,75),-- Common Item - Heavy War Axe
(20949,11908,1,1,1,75),-- Common Item - Sprite\'s Staff
(20949,4105,1,1,1,746),-- Heavy War Axe Head
(20949,4106,1,1,1,734),-- Sprite\'s Staff Head
(20949,1866,1,1,2,28962),-- Suede
(20949,1871,1,1,2,43443),-- Charcoal
(20949,1885,1,1,2,3620),-- High Grade Suede
(20949,4041,1,1,2,378),-- Mold Hardener
(20949,4129,1,1,2,470),-- Recipe: Earrings of Black Ore
(20949,4165,1,1,2,359),-- Recipe: Blue Wolf Helmet
(20949,4993,1,1,2,540),-- Recipe: Doom Gloves (60%)
(20949,5220,1,1,2,1738),-- Metal Hardener
(20949,8727,1,1,200,869),-- Life Stone: level 58
(20949,8737,1,1,200,217),-- Mid-Grade Life Stone: level 58
(20949,8747,1,1,200,22),-- High-Grade Life Stone: level 58
(20949,8757,1,1,200,4),-- Top-Grade Life Stone: level 58
(20950,947,1,1,-1,763),-- Scroll: Enchant Weapon (Grade B)
(20950,4049,1,1,-1,10049),-- Adamantite Earring Gemstone
(20950,4056,1,1,-1,34524),-- Zubei\'s Breastplate Part
(20950,57,754,1534,0,700000),-- Adena
(20950,11890,1,1,1,161),-- Common Item - Great Axe
(20950,4113,1,1,1,1450),-- Great Axe Head
(20950,1864,1,1,2,102441),-- Stem
(20950,1869,1,1,2,51221),-- Iron Ore
(20950,1880,1,1,2,5122),-- Steel
(20950,4043,1,1,2,1707),-- Asofe
(20950,5550,1,1,2,683),-- Durable Metal Plate
(20950,4990,1,1,2,423),-- Recipe: Blue Wolf Helmet (60%)
(20950,4159,1,1,2,145),-- Recipe: Blue Wolf Leather Armor
(20950,8728,1,1,200,854),-- Life Stone: level 61
(20950,8738,1,1,200,213),-- Mid-Grade Life Stone: level 61
(20950,8748,1,1,200,21),-- High-Grade Life Stone: level 61
(20950,8758,1,1,200,4),-- Top-Grade Life Stone: level 61
(20951,1806,1,1,-1,2025),-- Recipe: Soulshot: B-Grade
(20951,1918,1,1,-1,43851),-- Nassen\'s Earring Gemstone
(20951,1920,1,1,-1,34646),-- Necklace of Binding Chain
(20951,57,401,814,0,700000),-- Adena
(20951,266,1,1,1,8),-- Great Pata
(20951,2120,1,1,1,898),-- Great Pata Blade
(20951,1806,1,1,2,62),-- Recipe: Soulshot: B-Grade
(20951,1867,1,1,2,41540),-- Animal Skin
(20951,1872,1,1,2,41540),-- Animal Bone
(20951,1882,1,1,2,6923),-- Leather
(20951,1894,1,1,2,1093),-- Crafted Leather
(20951,4042,1,1,2,519),-- Enria
(20951,5270,1,1,2,62),-- Recipe: Greater Soulshot (B) Compressed Package(100%)
(20951,5436,1,1,2,51),-- Recipe: Berserker Blade(100%)
(20951,8726,1,1,200,721),-- Life Stone: level 55
(20951,8736,1,1,200,180),-- Mid-Grade Life Stone: level 55
(20951,8746,1,1,200,18),-- High-Grade Life Stone: level 55
(20951,8756,1,1,200,4),-- Top-Grade Life Stone: level 55
(20952,1984,1,1,-1,39333),-- Theca Leather Armor Pattern
(20952,3034,1,1,-1,3670),-- Recipe: Spiritshot B
(20952,4044,1,1,-1,61163),-- Thons
(20952,57,725,1477,0,700000),-- Adena
(20952,286,1,1,1,14),-- Eminence Bow
(20952,2121,1,1,1,1558),-- Eminence Bow Shaft
(20952,1868,1,1,2,112917),-- Thread
(20952,1873,1,1,2,22583),-- Silver Nugget
(20952,1889,1,1,2,3764),-- Compound Braid
(20952,4044,1,1,2,1882),-- Thons
(20952,4128,1,1,2,699),-- Recipe: Adamantite Necklace
(20952,4187,1,1,2,65),-- Recipe: Kris
(20952,5275,1,1,2,113),-- Recipe: Greater Spiritshot (B) Compressed Package(100%)
(20952,5549,1,1,2,5646),-- Metallic Thread
(20952,8726,1,1,200,1307),-- Life Stone: level 55
(20952,8736,1,1,200,327),-- Mid-Grade Life Stone: level 55
(20952,8746,1,1,200,33),-- High-Grade Life Stone: level 55
(20952,8756,1,1,200,6),-- Top-Grade Life Stone: level 55
(20953,1864,1,7,-1,855888),-- Stem
(20953,2962,1,1,-1,93209),-- Drake Leather Gloves Design
(20953,4948,1,1,-1,7508),-- Recipe: Avadon Leather Armor (60%)
(20953,57,675,1379,0,700000),-- Adena
(20953,12338,1,1,1,691),-- Common Item - Adamantite Earring
(20953,12340,1,1,1,1040),-- Common Item - Adamantite Ring
(20953,12339,1,1,1,519),-- Common Item - Adamantite Necklace
(20953,4049,1,1,1,4420),-- Adamantite Earring Gemstone
(20953,4050,1,1,1,5221),-- Adamantite Ring Wire
(20953,4051,1,1,1,3268),-- Adamantite Necklace Chain
(20953,1864,1,1,2,84272),-- Stem
(20953,1869,1,1,2,42136),-- Iron Ore
(20953,1878,1,1,2,16584),-- Braided Hemp
(20953,1884,1,1,2,25930),-- Cord
(20953,4039,1,1,2,1404),-- Mold Glue
(20953,4962,1,1,2,542),-- Recipe: Zubei\'s Helmet (60%)
(20953,4999,1,1,2,524),-- Recipe: Doom Boots (60%)
(20953,8311,1,1,2,32),-- Recipe: Kaim Vanul\'s Bones (100%)
(20953,8727,1,1,200,843),-- Life Stone: level 58
(20953,8737,1,1,200,211),-- Mid-Grade Life Stone: level 58
(20953,8747,1,1,200,21),-- High-Grade Life Stone: level 58
(20953,8757,1,1,200,4),-- Top-Grade Life Stone: level 58
(20954,1869,1,5,-1,677943),-- Iron Ore
(20954,4049,1,1,-1,106679),-- Adamantite Earring Gemstone
(20954,4613,1,1,-1,2805),-- Greater Dye of Strength <Str+4 Con-4>
(20954,57,804,1635,0,700000),-- Adena
(20954,11915,1,1,1,86),-- Common Item - Kris
(20954,11919,1,1,1,86),-- Common Item - Hell Knife
(20954,4109,1,1,1,846),-- Kris Edge
(20954,4110,1,1,1,846),-- Hell Knife Edge
(20954,1864,1,1,2,109229),-- Stem
(20954,1869,1,1,2,54615),-- Iron Ore
(20954,1880,1,1,2,5461),-- Steel
(20954,4043,1,1,2,1820),-- Asofe
(20954,4159,1,1,2,155),-- Recipe: Blue Wolf Leather Armor
(20954,4990,1,1,2,451),-- Recipe: Blue Wolf Helmet (60%)
(20954,5550,1,1,2,728),-- Durable Metal Plate
(20954,8728,1,1,200,910),-- Life Stone: level 61
(20954,8738,1,1,200,228),-- Mid-Grade Life Stone: level 61
(20954,8748,1,1,200,23),-- High-Grade Life Stone: level 61
(20954,8758,1,1,200,5),-- Top-Grade Life Stone: level 61
(20955,4052,1,1,-1,84007),-- Earring of Black Ore Piece
(20955,5230,1,1,-1,3164),-- Recipe: Mithril Arrow (100%)
(20955,57,941,1906,0,700000),-- Adena
(20955,12194,1,1,1,192),-- Common Item - Blue Wolf Leather Armor
(20955,12186,1,1,1,192),-- Common Item - Leather Armor of Doom
(20955,4082,1,1,1,1980),-- Blue Wolf Leather Armor Texture
(20955,4083,1,1,1,1980),-- Leather Armor of Doom Design
(20955,1830,1,1,2,25487),-- Scroll of Escape: Castle
(20955,1865,1,1,2,63717),-- Varnish
(20955,1870,1,1,2,63717),-- Coal
(20955,1874,1,1,2,4248),-- Oriharukon Ore
(20955,4039,1,1,2,2124),-- Mold Glue
(20955,4043,1,1,2,2124),-- Asofe
(20955,5276,1,1,2,85),-- Recipe: Greater Spiritshot (A) Compressed Package(100%)
(20955,8729,1,1,200,850),-- Life Stone: level 64
(20955,8739,1,1,200,212),-- Mid-Grade Life Stone: level 64
(20955,8749,1,1,200,21),-- High-Grade Life Stone: level 64
(20955,8759,1,1,200,4),-- Top-Grade Life Stone: level 64
(20956,1884,1,3,-1,733439),-- Cord
(20956,4106,1,1,-1,13417),-- Sprite\'s Staff Head
(20956,4987,1,1,-1,9891),-- Recipe: Tunic of Doom (60%)
(20956,57,946,1914,0,700000),-- Adena
(20956,11939,1,1,1,115),-- Common Item - Demon Dagger
(20956,4119,1,1,1,1541),-- Demon Dagger Edge
(20956,1874,1,1,2,3912),-- Oriharukon Ore
(20956,1878,1,1,2,23470),-- Braided Hemp
(20956,1884,1,1,2,36108),-- Cord
(20956,1889,1,1,2,3912),-- Compound Braid
(20956,2508,1,1,2,48896),-- Cursed Bone
(20956,3956,1,1,2,78),-- Recipe: Blessed Spiritshot A
(20956,4175,1,1,2,1131),-- Recipe: Avadon Boots
(20956,5220,1,1,2,2347),-- Metal Hardener
(20956,8729,1,1,200,782),-- Life Stone: level 64
(20956,8739,1,1,200,196),-- Mid-Grade Life Stone: level 64
(20956,8749,1,1,200,20),-- High-Grade Life Stone: level 64
(20956,8759,1,1,200,4),-- Top-Grade Life Stone: level 64
(20957,1877,1,1,-1,99989),-- Adamantite Nugget
(20957,4052,1,1,-1,88502),-- Earring of Black Ore Piece
(20957,4053,1,1,-1,107147),-- Ring of Black Ore Gemstone
(20957,57,990,2008,0,700000),-- Adena
(20957,12183,1,1,1,625),-- Common Item - Doom Shield
(20957,12202,1,1,1,437),-- Common Item - Blue Wolf Helmet
(20957,12185,1,1,1,437),-- Common Item - Doom Helmet
(20957,4077,1,1,1,5536),-- Doom Shield Fragment
(20957,4088,1,1,1,4651),-- Blue Wolf Helmet Design
(20957,4089,1,1,1,4651),-- Doom Helmet Pattern
(20957,1344,10,30,2,76915),-- Mithril Arrow
(20957,1830,1,1,2,24613),-- Scroll of Escape: Castle
(20957,1866,1,1,2,41021),-- Suede
(20957,1871,1,1,2,61532),-- Charcoal
(20957,1877,1,1,2,2461),-- Adamantite Nugget
(20957,4040,1,1,2,1231),-- Mold Lubricant
(20957,4041,1,1,2,535),-- Mold Hardener
(20957,5276,1,1,2,82),-- Recipe: Greater Spiritshot (A) Compressed Package(100%)
(20957,8729,1,1,200,820),-- Life Stone: level 64
(20957,8739,1,1,200,205),-- Mid-Grade Life Stone: level 64
(20957,8749,1,1,200,21),-- High-Grade Life Stone: level 64
(20957,8759,1,1,200,4),-- Top-Grade Life Stone: level 64
(20958,1807,1,1,-1,2501),-- Recipe: Soulshot: A-Grade
(20958,5478,1,1,-1,15776),-- Sealed Dark Crystal Leather Armor Pattern
(20958,57,742,1509,0,700000),-- Adena
(20958,12226,1,1,1,268),-- Common Item - Sealed Dark Crystal Helmet
(20958,12225,1,1,1,383),-- Common Item - Sealed Dark Crystal Shield
(20958,12234,1,1,1,268),-- Common Item - Sealed Tallum Helmet
(20958,5494,1,1,1,1940),-- Sealed Dark Crystal Shield Fragment
(20958,5525,1,1,1,1428),-- Sealed Dark Crystal Helmet Design
(20958,5526,1,1,1,1428),-- Sealed Tallum Helm Design
(20958,1867,1,1,2,73888),-- Animal Skin
(20958,1872,1,1,2,73888),-- Animal Bone
(20958,1875,1,1,2,3694),-- Stone of Purity
(20958,1881,1,1,2,7389),-- Coarse Bone Powder
(20958,4041,1,1,2,482),-- Mold Hardener
(20958,5156,1,1,2,74),-- Recipe: Soulshot (A) Compressed Package (100%)
(20958,8730,1,1,200,616),-- Life Stone: level 67
(20958,8740,1,1,200,154),-- Mid-Grade Life Stone: level 67
(20958,8750,1,1,200,15),-- High-Grade Life Stone: level 67
(20958,8760,1,1,200,3),-- Top-Grade Life Stone: level 67
(20959,1807,1,1,-1,4028),-- Recipe: Soulshot: A-Grade
(20959,4054,1,1,-1,59502),-- Necklace of Black Ore Beads
(20959,5478,1,1,-1,25403),-- Sealed Dark Crystal Leather Armor Pattern
(20959,57,1195,2431,0,700000),-- Adena
(20959,12232,1,1,1,216),-- Common Item - Sealed Tallum Tunic
(20959,12235,1,1,1,346),-- Common Item - Sealed Tallum Stockings
(20959,12223,1,1,1,133),-- Common Item - Sealed Dark Crystal Robe
(20959,5485,1,1,1,1251),-- Sealed Tallum Tunic Texture
(20959,5486,1,1,1,880),-- Sealed Dark Crystal Robe Fabric
(20959,5489,1,1,1,1963),-- Sealed Tallum Stockings Fabric
(20959,1866,1,1,2,54081),-- Suede
(20959,1871,1,1,2,81121),-- Charcoal
(20959,1877,1,1,2,3245),-- Adamantite Nugget
(20959,4040,1,1,2,1622),-- Mold Lubricant
(20959,4041,1,1,2,705),-- Mold Hardener
(20959,4953,1,1,2,1563),-- Recipe: Avadon Gloves (60%)
(20959,5281,1,1,2,108),-- Recipe: Greater Blessed Spiritshot (A) Compressed Package(100%)
(20959,8730,1,1,200,901),-- Life Stone: level 67
(20959,8740,1,1,200,225),-- Mid-Grade Life Stone: level 67
(20959,8750,1,1,200,23),-- High-Grade Life Stone: level 67
(20959,8760,1,1,200,5),-- Top-Grade Life Stone: level 67
(20960,4052,1,1,-1,58175),-- Earring of Black Ore Piece
(20960,4053,1,1,-1,70431),-- Ring of Black Ore Gemstone
(20960,5230,1,1,-1,2191),-- Recipe: Mithril Arrow (100%)
(20960,57,652,1319,0,700000),-- Adena
(20960,11932,1,1,1,79),-- Common Item - Lance
(20960,4115,1,1,1,1059),-- Lance Blade
(20960,1343,10,30,2,57781),-- Silver Arrow
(20960,1868,1,1,2,80894),-- Thread
(20960,1873,1,1,2,16179),-- Silver Nugget
(20960,1876,1,1,2,8089),-- Mithril Ore
(20960,1895,1,1,2,11556),-- Metallic Fiber
(20960,4042,1,1,2,674),-- Enria
(20960,5230,1,1,2,54),-- Recipe: Mithril Arrow (100%)
(20960,5276,1,1,2,54),-- Recipe: Greater Spiritshot (A) Compressed Package(100%)
(20960,8729,1,1,200,539),-- Life Stone: level 64
(20960,8739,1,1,200,135),-- Mid-Grade Life Stone: level 64
(20960,8749,1,1,200,14),-- High-Grade Life Stone: level 64
(20960,8759,1,1,200,3),-- Top-Grade Life Stone: level 64
(20961,1884,1,3,-1,744103),-- Cord
(20961,4053,1,1,-1,103658),-- Ring of Black Ore Gemstone
(20961,5230,1,1,-1,3224),-- Recipe: Mithril Arrow (100%)
(20961,57,958,1943,0,700000),-- Adena
(20961,12188,1,1,1,475),-- Common Item - Boots of Doom
(20961,12189,1,1,1,475),-- Common Item - Blue Wolf Boots
(20961,12187,1,1,1,475),-- Common Item - Doom Gloves
(20961,12190,1,1,1,475),-- Common Item - Blue Wolf Gloves
(20961,4090,1,1,1,4009),-- Blue Wolf Boots Design
(20961,4091,1,1,1,4009),-- Doom Gloves Part
(20961,4096,1,1,1,4009),-- Blue Wolf Gloves Fabric
(20961,4099,1,1,1,4009),-- Doom Boots Part
(20961,1864,1,1,2,119057),-- Stem
(20961,1869,1,1,2,59528),-- Iron Ore
(20961,1878,1,1,2,23811),-- Braided Hemp
(20961,1884,1,1,2,36633),-- Cord
(20961,3956,1,1,2,79),-- Recipe: Blessed Spiritshot A
(20961,4039,1,1,2,1984),-- Mold Glue
(20961,8326,1,1,2,22),-- Recipe: Doom Crusher (60%)
(20961,5230,1,1,2,79),-- Recipe: Mithril Arrow (100%)
(20961,8729,1,1,200,794),-- Life Stone: level 64
(20961,8739,1,1,200,198),-- Mid-Grade Life Stone: level 64
(20961,8749,1,1,200,20),-- High-Grade Life Stone: level 64
(20961,8759,1,1,200,4),-- Top-Grade Life Stone: level 64
(20962,4054,1,1,-1,45467),-- Necklace of Black Ore Beads
(20962,4077,1,1,-1,103389),-- Doom Shield Fragment
(20962,5230,1,1,-1,3078),-- Recipe: Mithril Arrow (100%)
(20962,57,914,1854,0,700000),-- Adena
(20962,12194,1,1,1,186),-- Common Item - Blue Wolf Leather Armor
(20962,12186,1,1,1,186),-- Common Item - Leather Armor of Doom
(20962,4082,1,1,1,1926),-- Blue Wolf Leather Armor Texture
(20962,4083,1,1,1,1926),-- Leather Armor of Doom Design
(20962,1865,1,1,2,56821),-- Varnish
(20962,1870,1,1,2,56821),-- Coal
(20962,1875,1,1,2,3788),-- Stone of Purity
(20962,1879,1,1,2,9470),-- Cokes
(20962,8326,1,1,2,21),-- Recipe: Doom Crusher (60%)
(20962,3956,1,1,2,76),-- Recipe: Blessed Spiritshot A
(20962,4040,1,1,2,1136),-- Mold Lubricant
(20962,8729,1,1,200,758),-- Life Stone: level 64
(20962,8739,1,1,200,189),-- Mid-Grade Life Stone: level 64
(20962,8749,1,1,200,19),-- High-Grade Life Stone: level 64
(20962,8759,1,1,200,4),-- Top-Grade Life Stone: level 64
(20962,5230,1,1,2,76),-- Recipe: Mithril Arrow (100%)
(20963,4116,1,1,-1,9589),-- Deadman\'s Glory Stone
(20963,5478,1,1,-1,18452),-- Sealed Dark Crystal Leather Armor Pattern
(20963,5479,1,1,-1,12984),-- Sealed Tallum Leather Armor Pattern
(20963,57,868,1764,0,700000),-- Adena
(20963,12221,1,1,1,353),-- Common Item - Sealed Dark Crystal Gloves
(20963,12224,1,1,1,353),-- Common Item - Sealed Dark Crystal Boots
(20963,12229,1,1,1,353),-- Common Item - Sealed Tallum Gloves
(20963,12231,1,1,1,353),-- Common Item - Sealed Tallum Boots
(20963,5496,1,1,1,1900),-- Sealed Dark Crystal Boots Lining
(20963,5497,1,1,1,1900),-- Sealed Tallum Boots Lining
(20963,5508,1,1,1,1900),-- Sealed Dark Crystal Gloves Design
(20963,5509,1,1,1,1900),-- Sealed Tallum Gloves Design
(20963,1864,1,1,2,129632),-- Stem
(20963,1869,1,1,2,64816),-- Iron Ore
(20963,1880,1,1,2,6482),-- Steel
(20963,4043,1,1,2,2161),-- Asofe
(20963,4984,1,1,2,184),-- Recipe: Blue Wolf Leather Armor (60%)
(20963,5550,1,1,2,864),-- Durable Metal Plate
(20963,8730,1,1,200,720),-- Life Stone: level 67
(20963,8740,1,1,200,180),-- Mid-Grade Life Stone: level 67
(20963,8750,1,1,200,18),-- High-Grade Life Stone: level 67
(20963,8760,1,1,200,4),-- Top-Grade Life Stone: level 67
(20965,4043,1,1,-1,80626),-- Asofe
(20965,4089,1,1,-1,91412),-- Doom Helmet Pattern
(20965,5482,1,1,-1,31925),-- Sealed Dark Crystalline Leggings Design
(20965,57,1193,2435,0,700000),-- Adena
(20965,12344,1,1,1,431),-- Common Item - Sealed Phoenix Necklace
(20965,12345,1,1,1,575),-- Common Item - Sealed Phoenix Earring
(20965,12346,1,1,1,863),-- Common Item - Sealed Phoenix Ring
(20965,6341,1,1,1,4117),-- Sealed Phoenix Earring Gemstone
(20965,6343,1,1,1,3183),-- Sealed Phoenix Necklace Beads
(20965,6345,1,1,1,5694),-- Sealed Phoenix Ring Gemstone
(20965,1864,1,1,2,178617),-- Stem
(20965,1869,1,1,2,89309),-- Iron Ore
(20965,1880,1,1,2,8931),-- Steel
(20965,4043,1,1,2,2977),-- Asofe
(20965,4161,1,1,2,371),-- Recipe: Blue Wolf Tunic
(20965,5550,1,1,2,1191),-- Durable Metal Plate
(20965,8730,1,1,200,992),-- Life Stone: level 67
(20965,8740,1,1,200,248),-- Mid-Grade Life Stone: level 67
(20965,8750,1,1,200,25),-- High-Grade Life Stone: level 67
(20965,8760,1,1,200,5),-- Top-Grade Life Stone: level 67
(20966,1894,1,1,-1,91934),-- Crafted Leather
(20966,4044,1,1,-1,87337),-- Thons
(20966,4085,1,1,-1,45535),-- Tunic of Doom Pattern
(20966,57,1293,2635,0,700000),-- Adena
(20966,12222,1,1,1,234),-- Common Item - Sealed Dark Crystal Leather Armor
(20966,12228,1,1,1,375),-- Common Item - Sealed Dark Crystalline Leggings
(20966,12230,1,1,1,144),-- Common Item - Sealed Tallum Leather Armor
(20966,5478,1,1,1,1356),-- Sealed Dark Crystal Leather Armor Pattern
(20966,5479,1,1,1,954),-- Sealed Tallum Leather Armor Pattern
(20966,5482,1,1,1,2128),-- Sealed Dark Crystalline Leggings Design
(20966,1894,1,1,2,3394),-- Crafted Leather
(20966,4039,1,1,2,3225),-- Mold Glue
(20966,4041,1,1,2,841),-- Mold Hardener
(20966,4044,1,1,2,3225),-- Thons
(20966,4617,1,1,2,133),-- Greater Dye of Dexterity <Dex+4 Str-4>
(20966,6037,1,1,2,193487),-- Waking Scroll
(20966,8731,1,1,200,896),-- Life Stone: level 70
(20966,8741,1,1,200,224),-- Mid-Grade Life Stone: level 70
(20966,8751,1,1,200,22),-- High-Grade Life Stone: level 70
(20966,8761,1,1,200,5),-- Top-Grade Life Stone: level 70
(20967,4041,1,1,-1,19734),-- Mold Hardener
(20967,5156,1,1,-1,3026),-- Recipe: Soulshot (A) Compressed Package (100%)
(20967,5485,1,1,-1,19083),-- Sealed Tallum Tunic Texture
(20967,57,1116,2286,0,700000),-- Adena
(20967,12344,1,1,1,405),-- Common Item - Sealed Phoenix Necklace
(20967,12345,1,1,1,539),-- Common Item - Sealed Phoenix Earring
(20967,12346,1,1,1,810),-- Common Item - Sealed Phoenix Ring
(20967,6341,1,1,1,3863),-- Sealed Phoenix Earring Gemstone
(20967,6343,1,1,1,2986),-- Sealed Phoenix Necklace Beads
(20967,6345,1,1,1,5343),-- Sealed Phoenix Ring Gemstone
(20967,1867,1,1,2,124136),-- Animal Skin
(20967,1872,1,1,2,124136),-- Animal Bone
(20967,1882,1,1,2,20689),-- Leather
(20967,1894,1,1,2,3267),-- Crafted Leather
(20967,4042,1,1,2,1552),-- Enria
(20967,5001,1,1,2,71),-- Recipe: Lance (60%)
(20967,8732,1,1,200,776),-- Life Stone: level 76
(20967,8742,1,1,200,194),-- Mid-Grade Life Stone: level 76
(20967,8752,1,1,200,19),-- High-Grade Life Stone: level 76
(20968,5480,1,1,-1,9953),-- Sealed Leather Armor of Nightmare Fabric
(20968,5481,1,1,-1,9953),-- Sealed Majestic Leather Armor Fabric
(20968,5486,1,1,-1,13124),-- Sealed Dark Crystal Robe Fabric
(20968,57,1094,2233,0,700000),-- Adena
(20968,12221,1,1,1,446),-- Common Item - Sealed Dark Crystal Gloves
(20968,12224,1,1,1,446),-- Common Item - Sealed Dark Crystal Boots
(20968,12229,1,1,1,446),-- Common Item - Sealed Tallum Gloves
(20968,12231,1,1,1,446),-- Common Item - Sealed Tallum Boots
(20968,5496,1,1,1,2400),-- Sealed Dark Crystal Boots Lining
(20968,5497,1,1,1,2400),-- Sealed Tallum Boots Lining
(20968,5508,1,1,1,2400),-- Sealed Dark Crystal Gloves Design
(20968,5509,1,1,1,2400),-- Sealed Tallum Gloves Design
(20968,729,1,1,2,8),-- Scroll: Enchant Weapon (Grade A)
(20968,1868,1,1,2,148901),-- Thread
(20968,1873,1,1,2,29780),-- Silver Nugget
(20968,1889,1,1,2,4963),-- Compound Braid
(20968,4044,1,1,2,2482),-- Thons
(20968,5007,1,1,2,57),-- Recipe: Bow of Peril (60%)
(20968,5549,1,1,2,7445),-- Metallic Thread
(20968,6036,1,1,2,2482),-- Greater Magic Haste Potion
(20968,8732,1,1,200,620),-- Life Stone: level 76
(20968,8742,1,1,200,155),-- Mid-Grade Life Stone: level 76
(20968,8752,1,1,200,16),-- High-Grade Life Stone: level 76
(20969,729,1,1,-1,207),-- Scroll: Enchant Weapon (Grade A)
(20969,5161,1,1,-1,2482),-- Recipe: Spiritshot (A) Compressed Package (100%)
(20969,5487,1,1,-1,8383),-- Sealed Robe of Nightmare Fabric
(20969,57,918,1873,0,700000),-- Adena
(20969,12264,1,1,1,234),-- Common Item - Sealed Gloves of Nightmare
(20969,12267,1,1,1,234),-- Common Item - Sealed Boots of Nightmare
(20969,12257,1,1,1,234),-- Common Item - Sealed Majestic Gloves
(20969,12260,1,1,1,234),-- Common Item - Sealed Majestic Boots
(20969,5502,1,1,1,1451),-- Sealed Boots of Nightmare Lining
(20969,5503,1,1,1,1451),-- Sealed Majestic Boots Lining
(20969,5514,1,1,1,1451),-- Sealed Gloves of Nightmare Design
(20969,5515,1,1,1,1451),-- Sealed Majestic Gloves Design
(20969,1894,1,1,2,3015),-- Crafted Leather
(20969,4039,1,1,2,2864),-- Mold Glue
(20969,4041,1,1,2,747),-- Mold Hardener
(20969,4044,1,1,2,2864),-- Thons
(20969,4150,1,1,2,1655),-- Recipe: Avadon Gloves
(20969,8732,1,1,200,716),-- Life Stone: level 76
(20969,8742,1,1,200,179),-- Mid-Grade Life Stone: level 76
(20969,8752,1,1,200,18),-- High-Grade Life Stone: level 76
(20970,1895,1,1,-1,526081),-- Metallic Fiber
(20970,4042,1,1,-1,30688),-- Enria
(20970,5489,1,1,-1,24303),-- Sealed Tallum Stockings Fabric
(20970,57,909,1851,0,700000),-- Adena
(20970,12221,1,1,1,370),-- Common Item - Sealed Dark Crystal Gloves
(20970,12224,1,1,1,370),-- Common Item - Sealed Dark Crystal Boots
(20970,12229,1,1,1,370),-- Common Item - Sealed Tallum Gloves
(20970,12231,1,1,1,370),-- Common Item - Sealed Tallum Boots
(20970,5496,1,1,1,1992),-- Sealed Dark Crystal Boots Lining
(20970,5497,1,1,1,1992),-- Sealed Tallum Boots Lining
(20970,5508,1,1,1,1992),-- Sealed Dark Crystal Gloves Design
(20970,5509,1,1,1,1992),-- Sealed Tallum Gloves Design
(20970,10609,1,1,3,3523),-- Forgotten Scroll - Chant of Critical Attack
(20970,10581,1,1,3,3523),-- Forgotten Scroll - Improve Condition
(20970,10584,1,1,3,3523),-- Forgotten Scroll - Improve Movement
(20970,14217,1,1,3,3523),-- Forgotten Scroll - Condition of Paagrio
(20971,1876,1,1,-1,529145),-- Mithril Ore
(20971,1877,1,1,-1,105829),-- Adamantite Nugget
(20971,1895,1,1,-1,755921),-- Metallic Fiber
(20971,57,1305,2663,0,700000),-- Adena
(20971,12226,1,1,1,473),-- Common Item - Sealed Dark Crystal Helmet
(20971,12225,1,1,1,676),-- Common Item - Sealed Dark Crystal Shield
(20971,12234,1,1,1,473),-- Common Item - Sealed Tallum Helmet
(20971,5494,1,1,1,3419),-- Sealed Dark Crystal Shield Fragment
(20971,5525,1,1,1,2517),-- Sealed Dark Crystal Helmet Design
(20971,5526,1,1,1,2517),-- Sealed Tallum Helm Design
(20971,12769,1,1,3,7815),-- Forgotten Scroll - Evasion Chance
(20971,12768,1,1,3,7815),-- Forgotten Scroll - Evasion Counter
(20972,4077,1,1,-1,83683),-- Doom Shield Fragment
(20972,4087,1,1,-1,43653),-- Stockings of Doom Pattern
(20972,5494,1,1,-1,39069),-- Sealed Dark Crystal Shield Fragment
(20972,57,918,1872,0,700000),-- Adena
(20972,12221,1,1,1,374),-- Common Item - Sealed Dark Crystal Gloves
(20972,12224,1,1,1,374),-- Common Item - Sealed Dark Crystal Boots
(20972,12229,1,1,1,374),-- Common Item - Sealed Tallum Gloves
(20972,12231,1,1,1,374),-- Common Item - Sealed Tallum Boots
(20972,5496,1,1,1,2013),-- Sealed Dark Crystal Boots Lining
(20972,5497,1,1,1,2013),-- Sealed Tallum Boots Lining
(20972,5508,1,1,1,2013),-- Sealed Dark Crystal Gloves Design
(20972,5509,1,1,1,2013),-- Sealed Tallum Gloves Design
(20972,12771,1,1,3,5495),-- Forgotten Scroll - Shadow Step
(20972,12770,1,1,3,5495),-- Forgotten Scroll - Evasion Haste
(20973,4078,1,1,-1,35176),-- Blue Wolf Breastplate Part
(20973,5166,1,1,-1,3211),-- Recipe: Blessed Spiritshot (A) Compressed Package (100%)
(20973,5496,1,1,-1,56464),-- Sealed Dark Crystal Boots Lining
(20973,57,1187,2425,0,700000),-- Adena
(20973,12344,1,1,1,430),-- Common Item - Sealed Phoenix Necklace
(20973,12345,1,1,1,572),-- Common Item - Sealed Phoenix Earring
(20973,12346,1,1,1,859),-- Common Item - Sealed Phoenix Ring
(20973,6341,1,1,1,4099),-- Sealed Phoenix Earring Gemstone
(20973,6343,1,1,1,3169),-- Sealed Phoenix Necklace Beads
(20973,6345,1,1,1,5669),-- Sealed Phoenix Ring Gemstone
(20973,1867,1,1,2,98797),-- Animal Skin
(20973,1872,1,1,2,98797),-- Animal Bone
(20973,1875,1,1,2,4940),-- Stone of Purity
(20973,1881,1,1,2,9880),-- Coarse Bone Powder
(20973,4041,1,1,2,644),-- Mold Hardener
(20973,4982,1,1,2,369),-- Recipe: Blue Wolf Gaiters (60%)
(20973,8314,1,1,2,41),-- Recipe: Spiritual Eye (60%)
(20973,4624,1,1,2,102),-- Greater Dye of WIT
(20973,8731,1,1,200,686),-- Life Stone: level 70
(20973,8741,1,1,200,172),-- Mid-Grade Life Stone: level 70
(20973,8751,1,1,200,17),-- High-Grade Life Stone: level 70
(20973,8761,1,1,200,3),-- Top-Grade Life Stone: level 70
(20974,4052,1,1,-1,172021),-- Earring of Black Ore Piece
(20974,5230,1,1,-1,6478),-- Recipe: Mithril Arrow (100%)
(20974,57,1925,3904,0,700000),-- Adena
(20974,268,1,1,1,14),-- Bellion Cestus
(20974,1871,1,1,2,130472),-- Charcoal
(20974,1866,1,1,2,86982),-- Suede
(20974,1877,1,1,2,5219),-- Adamantite Nugget
(20974,4120,1,1,1,3136),-- Bellion Cestus Edge
(20974,4041,1,1,2,1135),-- Mold Hardener
(20974,4040,1,1,2,2609),-- Mold Lubricant
(20974,4164,1,1,2,864),-- Recipe: Stockings of Doom
(20974,730,1,1,2,109),-- Scroll: Enchant Armor (A)
(20974,8729,1,1,200,1740),-- Life Stone: level 64
(20974,8739,1,1,200,435),-- Mid-Grade Life Stone: level 64
(20974,8749,1,1,200,43),-- High-Grade Life Stone: level 64
(20974,8759,1,1,200,9),-- Top-Grade Life Stone: level 64
(20975,4053,1,1,-1,184685),-- Ring of Black Ore Gemstone
(20975,4078,1,1,-1,62938),-- Blue Wolf Breastplate Part
(20975,5230,1,1,-1,5745),-- Recipe: Mithril Arrow (100%)
(20975,57,1709,3460,0,700000),-- Adena
(20975,110,1,1,1,65),-- Doom Shield
(20975,2416,1,1,1,46),-- Blue Wolf Helmet
(20975,2417,1,1,1,46),-- Doom Helmet
(20975,4077,1,1,1,9543),-- Doom Shield Fragment
(20975,4088,1,1,1,8017),-- Blue Wolf Helmet Design
(20975,4089,1,1,1,8017),-- Doom Helmet Pattern
(20975,1830,1,1,2,46281),-- Scroll of Escape: Castle
(20975,1866,1,1,2,77135),-- Suede
(20975,1871,1,1,2,115702),-- Charcoal
(20975,1885,1,1,2,9642),-- High Grade Suede
(20975,4041,1,1,2,1006),-- Mold Hardener
(20975,5220,1,1,2,4628),-- Metal Hardener
(20975,5276,1,1,2,154),-- Recipe: Greater Spiritshot (A) Compressed Package(100%)
(20975,8729,1,1,200,1543),-- Life Stone: level 64
(20975,8739,1,1,200,386),-- Mid-Grade Life Stone: level 64
(20975,8749,1,1,200,38),-- High-Grade Life Stone: level 64
(20975,8759,1,1,200,8),-- Top-Grade Life Stone: level 64
(20976,4054,1,1,-1,71850),-- Necklace of Black Ore Beads
(20976,4080,1,1,-1,75035),-- Blue Wolf Gaiters Material
(20976,5230,1,1,-1,4864),-- Recipe: Mithril Arrow (100%)
(20976,57,1447,2930,0,700000),-- Adena
(20976,358,1,1,1,15),-- Blue Wolf Breastplate
(20976,2380,1,1,1,23),-- Blue Wolf Gaiters
(20976,2381,1,1,1,9),-- Doom Plate Armor
(20976,4078,1,1,1,2624),-- Blue Wolf Breastplate Part
(20976,4080,1,1,1,3695),-- Blue Wolf Gaiters Material
(20976,4081,1,1,1,1770),-- Doom Plate Armor Temper
(20976,1343,10,30,2,128277),-- Silver Arrow
(20976,1867,1,1,2,119724),-- Animal Skin
(20976,1872,1,1,2,119724),-- Animal Bone
(20976,1882,1,1,2,19954),-- Leather
(20976,1894,1,1,2,3151),-- Crafted Leather
(20976,4042,1,1,2,1496),-- Enria
(20976,5230,1,1,2,120),-- Recipe: Mithril Arrow (100%)
(20976,5276,1,1,2,120),-- Recipe: Greater Spiritshot (A) Compressed Package(100%)
(20976,8729,1,1,200,1197),-- Life Stone: level 64
(20976,8739,1,1,200,299),-- Mid-Grade Life Stone: level 64
(20976,8749,1,1,200,30),-- High-Grade Life Stone: level 64
(20976,8759,1,1,200,6),-- Top-Grade Life Stone: level 64
(20977,947,1,1,-1,2297),-- Scroll: Enchant Weapon (Grade B)
(20977,1876,1,3,-1,574367),-- Mithril Ore
(20977,4052,1,1,-1,203352),-- Earring of Black Ore Piece
(20977,57,2276,4615,0,700000),-- Adena
(20977,864,1,1,1,80),-- Earring of Black Ore
(20977,895,1,1,1,119),-- Ring of Black Ore
(20977,926,1,1,1,60),-- Necklace of Black Ore
(20977,4052,1,1,1,10011),-- Earring of Black Ore Piece
(20977,4053,1,1,1,12120),-- Ring of Black Ore Gemstone
(20977,4054,1,1,1,5569),-- Necklace of Black Ore Beads
(20977,730,1,1,2,129),-- Scroll: Enchant Armor (Grade A)
(20977,1866,1,1,2,102824),-- Suede
(20977,1871,1,1,2,154236),-- Charcoal
(20977,1877,1,1,2,6169),-- Adamantite Nugget
(20977,4040,1,1,2,3085),-- Mold Lubricant
(20977,4041,1,1,2,1341),-- Mold Hardener
(20977,4164,1,1,2,1021),-- Recipe: Stockings of Doom
(20977,8729,1,1,200,2056),-- Life Stone: level 64
(20977,8739,1,1,200,514),-- Mid-Grade Life Stone: level 64
(20977,8749,1,1,200,51),-- High-Grade Life Stone: level 64
(20977,8759,1,1,200,10),-- Top-Grade Life Stone: level 64
(20978,4081,1,1,-1,60581),-- Doom Plate Armor Temper
(20978,5230,1,1,-1,8195),-- Recipe: Mithril Arrow (100%)
(20978,57,2440,4935,0,700000),-- Adena
(20978,79,1,1,1,6),-- Sword of Damascus
(20978,7889,1,1,1,6),-- Wizard\'s Tear
(20978,7883,1,1,1,6),-- Guardian Sword
(20978,8330,1,1,1,1323),-- Guardian Sword Blade
(20978,4114,1,1,1,1325),-- Sword of Damascus Blade
(20978,8336,1,1,1,1325),-- Blade of the Wizard's Tear
(20978,1830,1,1,2,66022),-- Scroll of Escape: Castle
(20978,1868,1,1,2,330107),-- Thread
(20978,1873,1,1,2,66022),-- Silver Nugget
(20978,1889,1,1,2,11004),-- Compound Braid
(20978,3956,1,1,2,220),-- Recipe: Blessed Spiritshot A
(20978,4044,1,1,2,5502),-- Thons
(20978,5549,1,1,2,16505),-- Metallic Thread
(20978,8729,1,1,200,2201),-- Life Stone: level 64
(20978,8739,1,1,200,550),-- Mid-Grade Life Stone: level 64
(20978,8749,1,1,200,55),-- High-Grade Life Stone: level 64
(20978,8759,1,1,200,11),-- Top-Grade Life Stone: level 64
(20979,4082,1,1,-1,61486),-- Blue Wolf Leather Armor Texture
(20979,5550,1,1,-1,72554),-- Durable Metal Plate
(20979,57,2160,4369,0,700000),-- Adena
(20979,171,1,1,1,5),-- Deadman\'s Glory
(20979,175,1,1,1,5),-- Art of Battle Axe
(20979,210,1,1,1,5),-- Staff of Evil Spirits
(20979,4116,1,1,1,1171),-- Deadman\'s Glory Stone
(20979,4117,1,1,1,1171),-- Art of Battle Axe Blade
(20979,4118,1,1,1,1109),-- Evil Spirit Head
(20979,1343,10,30,2,191350),-- Silver Arrow
(20979,1864,1,3,2,133945),-- Stem
(20979,1869,1,1,2,133945),-- Iron Ore
(20979,1880,1,1,2,13395),-- Steel
(20979,4043,1,1,2,4465),-- Asofe
(20979,5230,1,1,2,179),-- Recipe: Mithril Arrow (100%)
(20979,5276,1,1,2,179),-- Recipe: Greater Spiritshot (A) Compressed Package(100%)
(20979,5550,1,1,2,1786),-- Durable Metal Plate
(20979,8729,1,1,200,1786),-- Life Stone: level 64
(20979,8739,1,1,200,446),-- Mid-Grade Life Stone: level 64
(20979,8749,1,1,200,45),-- High-Grade Life Stone: level 64
(20979,8759,1,1,200,9),-- Top-Grade Life Stone: level 64
(20980,4039,1,1,-1,210979),-- Mold Glue
(20980,4041,1,1,-1,55038),-- Mold Hardener
(20980,4085,1,1,-1,109999),-- Tunic of Doom Pattern
(20980,57,2504,5090,0,700000),-- Adena
(20980,5287,1,1,1,17),-- Sealed Dark Crystal breastplate
(20980,5288,1,1,1,28),-- Sealed Dark Crystal Gaiters
(20980,5293,1,1,1,11),-- Sealed Tallum Plate Armor
(20980,5520,1,1,1,2009),-- Sealed Dark Crystal Breastplate Pattern
(20980,5521,1,1,1,1418),-- Sealed Tallum Plate Armor Pattern
(20980,5524,1,1,1,3071),-- Sealed Dark Crystal Gaiters Pattern
(20980,1867,1,3,2,75539),-- Animal Skin
(20980,1869,2,6,2,42491),-- Iron Ore
(20980,1870,2,6,2,33993),-- Coal
(20980,1871,1,1,2,169963),-- Charcoal
(20980,1872,1,3,2,113309),-- Animal Bone
(20980,4985,1,1,2,482),-- Recipe: Leather Armor of Doom (60%)
(20980,8314,1,1,2,93),-- Recipe: Spiritual Eye (60%)
(20980,8730,1,1,200,1889),-- Life Stone: level 67
(20980,8740,1,1,200,472),-- Mid-Grade Life Stone: level 67
(20980,8750,1,1,200,47),-- High-Grade Life Stone: level 67
(20980,8760,1,1,200,9),-- Top-Grade Life Stone: level 67
(20981,4083,1,1,-1,67397),-- Leather Armor of Doom Design
(20981,4085,1,1,-1,103660),-- Tunic of Doom Pattern
(20981,5230,1,1,-1,7953),-- Recipe: Mithril Arrow (100%)
(20981,57,2351,4805,0,700000),-- Adena
(20981,358,1,1,1,24),-- Blue Wolf Breastplate
(20981,2380,1,1,1,38),-- Blue Wolf Gaiters
(20981,2381,1,1,1,15),-- Doom Plate Armor
(20981,4078,1,1,1,4290),-- Blue Wolf Breastplate Part
(20981,4080,1,1,1,6041),-- Blue Wolf Gaiters Material
(20981,4081,1,1,1,2894),-- Doom Plate Armor Temper
(20981,1830,1,1,2,64067),-- Scroll of Escape: Castle
(20981,1864,1,3,2,160168),-- Stem
(20981,1869,1,1,2,160168),-- Iron Ore
(20981,1880,1,1,2,16017),-- Steel
(20981,4043,1,1,2,5339),-- Asofe
(20981,5550,1,1,2,2135),-- Durable Metal Plate
(20981,8487,1,1,2,87),-- Recipe: Destroyer Hammer (60%)
(20981,8730,1,1,200,1780),-- Life Stone: level 67
(20981,8740,1,1,200,445),-- Mid-Grade Life Stone: level 67
(20981,8750,1,1,200,44),-- High-Grade Life Stone: level 67
(20981,8760,1,1,200,9),-- Top-Grade Life Stone: level 67
(20982,4084,1,1,-1,96257),-- Blue Wolf Tunic Fabric
(20982,4085,1,1,-1,96257),-- Tunic of Doom Pattern
(20982,5418,1,1,-1,8181),-- Recipe: Sealed Tallum Plate Armor(60%)
(20982,57,2184,4462,0,700000),-- Adena
(20982,2398,1,1,1,22),-- Blue Wolf Tunic
(20982,2399,1,1,1,22),-- Tunic of Doom
(20982,2403,1,1,1,35),-- Blue Wolf Stockings
(20982,2404,1,1,1,35),-- Stockings of Doom
(20982,4084,1,1,1,3555),-- Blue Wolf Tunic Fabric
(20982,4085,1,1,1,3555),-- Tunic of Doom Pattern
(20982,4086,1,1,1,4800),-- Blue Wolf Stockings Pattern
(20982,4087,1,1,1,4800),-- Stockings of Doom Pattern
(20982,1344,30,90,2,56807),-- Mithril Arrow
(20982,1830,1,1,2,54534),-- Scroll of Escape: Castle
(20982,1864,1,3,2,136336),-- Stem
(20982,1869,1,1,2,136336),-- Iron Ore
(20982,1880,1,1,2,13633),-- Steel
(20982,4043,1,1,2,4545),-- Asofe
(20982,5550,1,1,2,1818),-- Durable Metal Plate
(20982,8487,1,1,2,223),-- Recipe: Destroyer Hammer (60%)
(20982,8730,1,1,200,1515),-- Life Stone: level 67
(20982,8740,1,1,200,379),-- Mid-Grade Life Stone: level 67
(20982,8750,1,1,200,38),-- High-Grade Life Stone: level 67
(20982,8760,1,1,200,8),-- Top-Grade Life Stone: level 67
(20983,4080,1,1,-1,136641),-- Blue Wolf Gaiters Material
(20983,5478,1,1,-1,55860),-- Sealed Dark Crystal Leather Armor Pattern
(20983,5549,1,1,-1,664283),-- Metallic Thread
(20983,57,3280,6679,0,700000),-- Adena
(20983,5297,1,1,1,31),-- Sealed Dark Crystal Leather Armor
(20983,5298,1,1,1,49),-- Sealed Dark Crystalline Leggings
(20983,5301,1,1,1,19),-- Sealed Tallum Leather Armor
(20983,5478,1,1,1,3437),-- Sealed Dark Crystal Leather Armor Pattern
(20983,5479,1,1,1,2419),-- Sealed Tallum Leather Armor Pattern
(20983,5482,1,1,1,5395),-- Sealed Dark Crystalline Leggings Design
(20983,730,1,1,2,186),-- Scroll: Enchant Armor (Grade A)
(20983,1867,1,3,2,148651),-- Animal Skin
(20983,1872,1,3,2,99101),-- Animal Bone
(20983,1882,1,1,2,49550),-- Leather
(20983,1894,1,1,2,7824),-- Crafted Leather
(20983,4042,1,1,2,3716),-- Enria
(20983,4199,1,1,2,217019),-- Recipe: Bow of Peril
(20983,8731,1,1,200,2065),-- Life Stone: level 70
(20983,8741,1,1,200,516),-- Mid-Grade Life Stone: level 70
(20983,8751,1,1,200,52),-- High-Grade Life Stone: level 70
(20983,8761,1,1,200,10),-- Top-Grade Life Stone: level 70
(20984,4041,1,1,-1,53015),-- Mold Hardener
(20984,5478,1,1,-1,51267),-- Sealed Dark Crystal Leather Armor Pattern
(20984,57,3006,6139,0,700000),-- Adena
(20984,5304,1,1,1,28),-- Sealed Tallum Tunic
(20984,5305,1,1,1,45),-- Sealed Tallum Stockings
(20984,5308,1,1,1,17),-- Sealed Dark Crystal Robe
(20984,5485,1,1,1,3155),-- Sealed Tallum Tunic Texture
(20984,5486,1,1,1,2220),-- Sealed Dark Crystal Robe Fabric
(20984,5489,1,1,1,4951),-- Sealed Tallum Stockings Fabric
(20984,729,1,1,2,21),-- Scroll: Enchant Weapon (Grade A)
(20984,1865,1,1,2,187592),-- Varnish
(20984,1870,1,1,2,187592),-- Coal
(20984,1874,1,1,2,12506),-- Oriharukon Ore
(20984,4039,1,1,2,6253),-- Mold Glue
(20984,4043,1,1,2,6253),-- Asofe
(20984,5156,1,1,2,250),-- Recipe: Soulshot (A) Compressed Package (100%)
(20984,5420,1,1,2,182),-- Recipe: Sealed Armor of Nightmare(60%)
(20984,8730,1,1,200,2084),-- Life Stone: level 67
(20984,8740,1,1,200,521),-- Mid-Grade Life Stone: level 67
(20984,8750,1,1,200,52),-- High-Grade Life Stone: level 67
(20984,8760,1,1,200,10),-- Top-Grade Life Stone: level 67
(20985,1807,1,1,-1,8655),-- Recipe: Soulshot: A-Grade
(20985,3035,1,1,-1,8655),-- Recipe: Spiritshot A
(20985,5479,1,1,-1,38410),-- Sealed Tallum Leather Armor Pattern
(20985,57,3201,6536,0,700000),-- Adena
(20985,6323,1,1,1,60),-- Sealed Phoenix Necklace
(20985,6324,1,1,1,79),-- Sealed Phoenix Earring
(20985,6325,1,1,1,119),-- Sealed Phoenix Ring
(20985,6341,1,1,1,11048),-- Sealed Phoenix Earring Gemstone
(20985,6343,1,1,1,8541),-- Sealed Phoenix Necklace Beads
(20985,6345,1,1,1,15281),-- Sealed Phoenix Ring Gemstone
(20985,1344,20,60,2,136180),-- Mithril Arrow
(20985,1866,1,1,2,145258),-- Suede
(20985,1871,1,3,2,72629),-- Charcoal
(20985,1877,1,1,2,8715),-- Adamantite Nugget
(20985,4040,1,1,2,4358),-- Mold Lubricant
(20985,4041,1,1,2,1895),-- Mold Hardener
(20985,5161,1,1,2,290),-- Recipe: Spiritshot (A) Compressed Package (100%)
(20985,8730,1,1,200,2421),-- Life Stone: level 67
(20985,8740,1,1,200,605),-- Mid-Grade Life Stone: level 67
(20985,8750,1,1,200,61),-- High-Grade Life Stone: level 67
(20985,8760,1,1,200,12),-- Top-Grade Life Stone: level 67
(20986,1806,1,1,-1,8902),-- Recipe: Soulshot: B-Grade
(20986,1984,1,1,-1,95413),-- Theca Leather Armor Pattern
(20986,4043,1,1,-1,148367),-- Asofe
(20986,57,1758,3581,0,700000),-- Adena
(20986,2414,1,1,1,199),-- Full Plate Helmet
(20986,2497,1,1,1,285),-- Full Plate Shield
(20986,2959,1,1,1,14212),-- Full Plate Helmet Design
(20986,2966,1,1,1,22483),-- Full Plate Shield Fragment
(20986,1894,1,1,2,5242),-- Crafted Leather
(20986,4039,1,1,2,4980),-- Mold Glue
(20986,4041,1,1,2,1299),-- Mold Hardener
(20986,4044,1,1,2,4980),-- Thons
(20986,4180,1,1,2,16601),-- Recipe: Silver Arrow
(20986,4184,1,1,2,172),-- Recipe: Sprite\'s Staff
(20986,5436,1,1,2,244),-- Recipe: Berserker Blade(100%)
(20986,8726,1,1,200,3458),-- Life Stone: level 55
(20986,8736,1,1,200,865),-- Mid-Grade Life Stone: level 55
(20986,8746,1,1,200,86),-- High-Grade Life Stone: level 55
(20986,8756,1,1,200,17),-- Top-Grade Life Stone: level 55
(20987,1864,1,17,-1,897829),-- Stem
(20987,1918,1,1,-1,174977),-- Nassen\'s Earring Gemstone
(20987,4039,1,1,-1,134674),-- Mold Glue
(20987,57,1599,3249,0,700000),-- Adena
(20987,299,1,1,1,11),-- Orcish Poleaxe
(20987,301,1,1,1,14),-- Scorpion
(20987,303,1,1,1,14),-- Widow Maker
(20987,2113,1,1,1,1204),-- Scorpion Blade
(20987,2114,1,1,1,1204),-- Widowmaker Head
(20987,2122,1,1,1,1135),-- Orcish Poleaxe Blade
(20987,1864,1,3,2,124315),-- Stem
(20987,1869,1,1,2,124315),-- Iron Ore
(20987,1878,1,1,2,49726),-- Braided Hemp
(20987,1884,1,1,2,76501),-- Cord
(20987,3034,1,1,2,248),-- Recipe: Spiritshot B
(20987,3955,1,1,2,248),-- Recipe: Blessed Spiritshot B
(20987,4039,1,1,2,4144),-- Mold Glue
(20987,5270,1,1,2,248),-- Recipe: Greater Soulshot (B) Compressed Package(100%)
(20987,8726,1,1,200,2878),-- Life Stone: level 55
(20987,8736,1,1,200,719),-- Mid-Grade Life Stone: level 55
(20987,8746,1,1,200,72),-- High-Grade Life Stone: level 55
(20987,8756,1,1,200,15),-- Top-Grade Life Stone: level 55
(20988,1806,1,1,-1,8888),-- Recipe: Soulshot: B-Grade
(20988,1920,1,1,-1,152063),-- Necklace of Binding Chain
(20988,1984,1,1,-1,95264),-- Theca Leather Armor Pattern
(20988,57,1759,3573,0,700000),-- Adena
(20988,400,1,1,1,86),-- Theca Leather Armor
(20988,401,1,1,1,41),-- Drake Leather Armor
(20988,420,1,1,1,138),-- Theca Leather Gaiters
(20988,1984,1,1,1,5862),-- Theca Leather Armor Pattern
(20988,1985,1,1,1,9430),-- Theca Leather Gaiters Pattern
(20988,1987,1,1,1,4172),-- Drake Leather Armor Texture
(20988,1865,1,1,2,136740),-- Varnish
(20988,1870,1,1,2,136740),-- Coal
(20988,1875,1,1,2,9116),-- Stone of Purity
(20988,1879,1,1,2,22790),-- Cokes
(20988,3955,1,1,2,273),-- Recipe: Blessed Spiritshot B
(20988,4040,1,1,2,2735),-- Mold Lubricant
(20988,4127,1,1,2,3385),-- Recipe: Adamantite Ring
(20988,5270,1,1,2,273),-- Recipe: Greater Soulshot (B) Compressed Package(100%)
(20988,8726,1,1,200,3165),-- Life Stone: level 55
(20988,8736,1,1,200,791),-- Mid-Grade Life Stone: level 55
(20988,8746,1,1,200,79),-- High-Grade Life Stone: level 55
(20988,8756,1,1,200,16),-- Top-Grade Life Stone: level 55
(20989,1825,1,1,-1,77195),-- Recipe: Oriharukon
(20989,1871,1,3,-1,540365),-- Charcoal
(20989,1902,1,1,-1,109496),-- Elven Earring Beads
(20989,57,457,912,0,700000),-- Adena
(20989,352,1,1,1,81),-- Brigandine Tunic
(20989,1941,1,1,1,3703),-- Brigandine Temper
(20989,2377,1,1,1,130),-- Mithril Scale Gaiters
(20989,2378,1,1,1,130),-- Brigandine Gaiters
(20989,2918,1,1,1,5524),-- Mithril Scale Gaiters Material
(20989,2919,1,1,1,5524),-- Brigandine Gaiters Material
(20989,1866,1,1,2,62073),-- Suede
(20989,1871,1,1,2,93109),-- Charcoal
(20989,1885,1,1,2,7759),-- High Grade Suede
(20989,2146,1,1,2,6651),-- Recipe: Artisan\'s frame
(20989,5220,1,1,2,3724),-- Metal Hardener
(20989,5473,1,1,2,6650),-- Recipe: Durable Metal Plate(100%)
(20990,1882,1,1,-1,227993),-- Leather
(20990,1903,1,1,-1,171137),-- Elven Ring Piece
(20990,2145,1,1,-1,73283),-- Recipe: Mithril Alloy
(20990,57,434,866,0,700000),-- Adena
(20990,437,1,1,1,154),-- Mithril Tunic
(20990,470,1,1,1,246),-- Mithril Stockings
(20990,1944,1,1,1,6763),-- Mithril Tunic Fabric
(20990,1945,1,1,1,10531),-- Mithril Stocking Design
(20990,1341,10,30,2,252548),-- Bone Arrow
(20990,1867,1,1,2,101019),-- Animal Skin
(20990,1872,1,1,2,101019),-- Animal Bone
(20990,1882,1,1,2,16837),-- Leather
(20990,1894,1,1,2,2658),-- Crafted Leather
(20990,2147,1,1,2,5412),-- Recipe: Blacksmith\'s frame
(20990,2194,1,1,2,7747),-- Recipe: Mithril Gloves
(20991,1908,1,1,-1,388880),-- Moonstone Earring Wire
(20991,1909,1,1,-1,554567),-- Aquastone Ring Wire
(20991,2064,1,1,-1,31742),-- Silver Axe Head
(20991,57,1624,3299,0,700000),-- Adena
(20991,354,1,1,1,250),-- Chain Mail Shirt
(20991,381,1,1,1,399),-- Chain Gaiters
(20991,1959,1,1,1,13069),-- Chain Mail Shirt Material
(20991,1960,1,1,1,26586),-- Chain Gaiters Part
(20991,1875,1,1,2,11763),-- Stone of Purity
(20991,1879,1,1,2,29407),-- Cokes
(20991,1885,1,1,2,14703),-- High Grade Suede
(20991,3021,1,1,2,615),-- Recipe: Dwarven War Hammer
(20991,4556,1,1,2,706),-- Greater Dye of Constitution <Con+1 Dex-1>
(20991,5549,1,1,2,17644),-- Metallic Thread
(20991,5550,1,1,2,2353),-- Durable Metal Plate
(20991,8723,1,1,200,7058),-- Life Stone: level 46
(20991,8733,1,1,200,1764),-- Mid-Grade Life Stone: level 46
(20991,8743,1,1,200,176),-- High-Grade Life Stone: level 46
(20991,8753,1,1,200,35),-- Top-Grade Life Stone: level 46
(20992,1908,1,1,-1,347561),-- Moonstone Earring Wire
(20992,1909,1,1,-1,495644),-- Aquastone Ring Wire
(20992,2163,1,1,-1,187257),-- Recipe: Earring of Protection
(20992,57,1445,2961,0,700000),-- Adena
(20992,852,1,1,1,485),-- Moonstone Earring
(20992,883,1,1,1,727),-- Aquastone Ring
(20992,915,1,1,1,364),-- Aquastone Necklace
(20992,1908,1,1,1,27379),-- Moonstone Earring Wire
(20992,1909,1,1,1,39044),-- Aquastone Ring Wire
(20992,1910,1,1,1,21771),-- Aquastone Necklace Chain
(20992,1868,1,1,2,346923),-- Thread
(20992,1873,1,1,2,69385),-- Silver Nugget
(20992,1889,1,1,2,11564),-- Compound Braid
(20992,2164,1,1,2,13343),-- Recipe: Ring of Protection
(20992,2319,1,1,2,604),-- Recipe: Raid Sword
(20992,5549,1,1,2,17346),-- Metallic Thread
(20992,8723,1,1,200,6938),-- Life Stone: level 46
(20992,8733,1,1,200,1735),-- Mid-Grade Life Stone: level 46
(20992,8743,1,1,200,174),-- High-Grade Life Stone: level 46
(20992,8753,1,1,200,35),-- Top-Grade Life Stone: level 46
(20993,1864,1,17,-1,865485),-- Stem
(20993,1869,1,9,-1,778937),-- Iron Ore
(20993,2163,1,1,-1,198708),-- Recipe: Earring of Protection
(20993,57,1533,3142,0,700000),-- Adena
(20993,62,1,1,1,211),-- Mithril Boots
(20993,1958,1,1,1,9192),-- Mithril Boots Design
(20993,2429,1,1,1,211),-- Chain Boots
(20993,2430,1,1,1,211),-- Karmian Boots
(20993,2431,1,1,1,211),-- Plated Leather Boots
(20993,2432,1,1,1,211),-- Dwarven Chain Boots
(20993,2433,1,1,1,211),-- Boots of Seal
(20993,2452,1,1,1,211),-- Reinforced Mithril Gloves
(20993,2453,1,1,1,211),-- Chain Gloves
(20993,2454,1,1,1,211),-- Karmian Gloves
(20993,2937,1,1,1,9192),-- Chain Boots Part
(20993,2938,1,1,1,9192),-- Karmian Boots Fabric
(20993,2939,1,1,1,9192),-- Plate Leather Boot Lining
(20993,2940,1,1,1,9192),-- Dwarven Chain Boots Part
(20993,2941,1,1,1,9192),-- Boots of Seal Pattern
(20993,2942,1,1,1,9192),-- Reinforced Mithril Gloves Design
(20993,2943,1,1,1,9192),-- Chain Gloves Design
(20993,2944,1,1,1,9192),-- Karmian Gloves Fabric
(20993,1864,1,3,2,184069),-- Stem
(20993,1869,1,1,2,184069),-- Iron Ore
(20993,1880,1,1,2,18407),-- Steel
(20993,2165,1,1,2,7053),-- Recipe: Necklace of Protection
(20993,2318,1,1,2,641),-- Recipe: Spirit Sword
(20993,5550,1,1,2,2454),-- Durable Metal Plate
(20993,8723,1,1,200,7363),-- Life Stone: level 46
(20993,8733,1,1,200,1841),-- Mid-Grade Life Stone: level 46
(20993,8743,1,1,200,184),-- High-Grade Life Stone: level 46
(20993,8753,1,1,200,37),-- Top-Grade Life Stone: level 46
(20994,2169,1,1,-1,78587),-- Recipe: Necklace of Binding
(20994,4043,1,1,-1,148005),-- Asofe
(20994,4044,1,1,-1,148005),-- Thons
(20994,57,1756,3570,0,700000),-- Adena
(20994,265,1,1,1,56),-- Fist Blade
(20994,2108,1,1,1,4917),-- Fist Blade Piece
(20994,1894,1,1,2,5857),-- Crafted Leather
(20994,3015,1,1,2,4663),-- Recipe: Drake Leather Gloves
(20994,3016,1,1,2,4663),-- Recipe: Full Plate Gauntlets
(20994,4039,1,1,2,5564),-- Mold Glue
(20994,4041,1,1,2,1452),-- Mold Hardener
(20994,4044,1,1,2,5564),-- Thons
(20994,4186,1,1,2,192),-- Recipe: Sword of Valhalla
(20994,8725,1,1,200,4637),-- Life Stone: level 52
(20994,8735,1,1,200,1159),-- Mid-Grade Life Stone: level 52
(20994,8745,1,1,200,116),-- High-Grade Life Stone: level 52
(20994,8755,1,1,200,23),-- Top-Grade Life Stone: level 52
(20995,1911,1,1,-1,250980),-- Earring of Protection Gemstone
(20995,1966,1,1,-1,123199),-- Plated Leather Fragment
(20995,2166,1,1,-1,114387),-- Recipe: Earrings of Binding (100%)
(20995,57,1334,2711,0,700000),-- Adena
(20995,500,1,1,1,268),-- Great Helmet
(20995,632,1,1,1,383),-- Knight\'s Shield
(20995,1971,1,1,1,15254),-- Great Helmet Material
(20995,1972,1,1,1,19934),-- Knight\'s Shield Fragment
(20995,2496,1,1,1,415),-- Dwarven Chain Shield
(20995,2947,1,1,1,17798),-- Dwarven Chain Shield Fragment
(20995,1539,1,1,2,30205),-- Greater Healing Potion
(20995,1865,1,1,2,135921),-- Varnish
(20995,1870,1,1,2,135921),-- Coal
(20995,1874,1,1,2,9061),-- Oriharukon Ore
(20995,2222,1,1,2,849),-- Recipe: Composite Armor
(20995,4039,1,1,2,4531),-- Mold Glue
(20995,4043,1,1,2,4531),-- Asofe
(20995,8724,1,1,200,4531),-- Life Stone: level 49
(20995,8734,1,1,200,1133),-- Mid-Grade Life Stone: level 49
(20995,8744,1,1,200,113),-- High-Grade Life Stone: level 49
(20995,8754,1,1,200,23),-- Top-Grade Life Stone: level 49
(20996,1864,1,7,-1,851546),-- Stem
(20996,1869,1,3,-1,851546),-- Iron Ore
(20996,1914,1,1,-1,95679),-- Earring of Binding Gemstone
(20996,57,674,1369,0,700000),-- Adena
(20996,265,1,1,1,21),-- Fist Blade
(20996,2108,1,1,1,1887),-- Fist Blade Piece
(20996,1864,1,1,2,128053),-- Stem
(20996,1869,1,1,2,64027),-- Iron Ore
(20996,1878,1,1,2,25611),-- Braided Hemp
(20996,1884,1,1,2,39401),-- Cord
(20996,2169,1,1,2,1133),-- Recipe: Necklace of Binding
(20996,3019,1,1,2,1707),-- Recipe: Full Plate Shield
(20996,4039,1,1,2,2134),-- Mold Glue
(20996,8725,1,1,200,1778),-- Life Stone: level 52
(20996,8735,1,1,200,445),-- Mid-Grade Life Stone: level 52
(20996,8745,1,1,200,44),-- High-Grade Life Stone: level 52
(20996,8755,1,1,200,9),-- Top-Grade Life Stone: level 52
(20997,1539,1,1,-1,337056),-- Greater Healing Potion
(20997,1915,1,1,-1,133634),-- Ring of Ages Gemstone
(20997,4601,1,1,-1,3371),-- Greater Dye of Strength <Str+3 Con-3>
(20997,57,601,1220,0,700000),-- Adena
(20997,60,1,1,1,51),-- Composite Armor
(20997,1977,1,1,1,4639),-- Composite Armor Temper
(20997,1868,1,1,2,114043),-- Thread
(20997,1873,1,1,2,22809),-- Silver Nugget
(20997,1876,1,1,2,11404),-- Mithril Ore
(20997,1895,1,1,2,16292),-- Metallic Fiber
(20997,2170,1,1,2,1345),-- Recipe: Nassen\'s Earring
(20997,3012,1,1,2,1064),-- Recipe: Full Plate Helmet
(20997,4042,1,1,2,950),-- Enria
(20997,8725,1,1,200,1584),-- Life Stone: level 52
(20997,8735,1,1,200,396),-- Mid-Grade Life Stone: level 52
(20997,8745,1,1,200,40),-- High-Grade Life Stone: level 52
(20997,8755,1,1,200,8),-- Top-Grade Life Stone: level 52
(20998,1916,1,1,-1,71182),-- Necklace of Mermaid Teardrop
(20998,2169,1,1,-1,29606),-- Recipe: Necklace of Binding
(20998,2170,1,1,-1,39452),-- Recipe: Nassen\'s Earring
(20998,57,664,1343,0,700000),-- Adena
(20998,162,1,1,1,3),-- War Axe
(20998,174,1,1,1,3),-- Nirvana Axe
(20998,196,1,1,1,3),-- Stick of Eternity
(20998,197,1,1,1,3),-- Paradia Staff
(20998,199,1,1,1,3),-- Pa\'agrian Hammer
(20998,200,1,1,1,3),-- Sage\'s Staff
(20998,201,1,1,1,3),-- Club of Nature
(20998,202,1,1,1,3),-- Mace of The Underworld
(20998,2097,1,1,1,232),-- War Axe Blade
(20998,2098,1,1,1,232),-- Nirvana Axe Blade
(20998,2099,1,1,1,244),-- Stick of Eternity Shaft
(20998,2100,1,1,1,244),-- Paradia Staff Head
(20998,2102,1,1,1,235),-- Pa\'agrian Hammer Head
(20998,2103,1,1,1,244),-- Sage\'s Staff Head
(20998,2104,1,1,1,244),-- Club of Nature Head
(20998,2105,1,1,1,232),-- Mace of The Underworld Head
(20998,1832,1,1,2,59124),-- Greater Antidote
(20998,1866,1,1,2,35474),-- Suede
(20998,1871,1,1,2,53212),-- Charcoal
(20998,1877,1,1,2,2128),-- Adamantite Nugget
(20998,2231,1,1,2,229),-- Recipe: Full Plate Armor
(20998,4040,1,1,2,1064),-- Mold Lubricant
(20998,4041,1,1,2,463),-- Mold Hardener
(20998,5155,1,1,2,106),-- Recipe: Soulshot (B) Compressed Package (100%)
(20998,6669,1,1,2,12375),-- Deluxe Chest Key - Grade 5
(20998,8725,1,1,200,1478),-- Life Stone: level 52
(20998,8735,1,1,200,370),-- Mid-Grade Life Stone: level 52
(20998,8745,1,1,200,37),-- High-Grade Life Stone: level 52
(20998,8755,1,1,200,7),-- Top-Grade Life Stone: level 52
(20999,1868,1,9,-1,794915),-- Thread
(20999,1873,1,1,-1,794915),-- Silver Nugget
(20999,1918,1,1,-1,86067),-- Nassen\'s Earring Gemstone
(20999,57,787,1598,0,700000),-- Adena
(20999,228,1,1,1,16),-- Crystal Dagger
(20999,2119,1,1,1,1671),-- Crystal Dagger Blade
(20999,1806,1,1,2,122),-- Recipe: Soulshot: B-Grade
(20999,1868,1,1,2,122295),-- Thread
(20999,1873,1,1,2,24459),-- Silver Nugget
(20999,1889,1,1,2,4076),-- Compound Braid
(20999,4044,1,1,2,2038),-- Thons
(20999,5270,1,1,2,122),-- Recipe: Greater Soulshot (B) Compressed Package(100%)
(20999,5280,1,1,2,122),-- Recipe: Greater Blessed Spiritshot (B) Compressed Package(100%)
(20999,5549,1,1,2,6115),-- Metallic Thread
(20999,8726,1,1,200,1415),-- Life Stone: level 55
(20999,8736,1,1,200,354),-- Mid-Grade Life Stone: level 55
(20999,8746,1,1,200,35),-- High-Grade Life Stone: level 55
(20999,8756,1,1,200,7),-- Top-Grade Life Stone: level 55
(21000,1865,1,3,-1,871346),-- Varnish
(21000,1918,1,1,-1,75474),-- Nassen\'s Earring Gemstone
(21000,1986,1,1,-1,18415),-- Full Plate Armor Temper
(21000,57,688,1402,0,700000),-- Adena
(21000,299,1,1,1,5),-- Orcish Poleaxe
(21000,301,1,1,1,6),-- Scorpion
(21000,303,1,1,1,6),-- Widow Maker
(21000,2113,1,1,1,520),-- Scorpion Blade
(21000,2114,1,1,1,520),-- Widowmaker Head
(21000,2122,1,1,1,490),-- Orcish Poleaxe Blade
(21000,1865,1,1,2,49497),-- Varnish
(21000,1870,1,1,2,49497),-- Coal
(21000,1875,1,1,2,3300),-- Stone of Purity
(21000,1879,1,1,2,8249),-- Cokes
(21000,4040,1,1,2,990),-- Mold Lubricant
(21000,4146,1,1,2,317),-- Recipe: Tunic of Zubei
(21000,4182,1,1,2,57),-- Recipe: Great Sword
(21000,5160,1,1,2,99),-- Recipe: Spiritshot (B) Compressed Package (100%)
(21000,5436,1,1,2,81),-- Recipe: Berserker Blade(100%)
(21000,8726,1,1,200,1146),-- Life Stone: level 55
(21000,8736,1,1,200,286),-- Mid-Grade Life Stone: level 55
(21000,8746,1,1,200,29),-- High-Grade Life Stone: level 55
(21000,8756,1,1,200,6);-- Top-Grade Life Stone: level 55

INSERT INTO `droplist` VALUES 
(21001,1895,1,1,-1,674702),-- Metallic Fiber
(21001,1988,1,1,-1,45373),-- Divine Tunic Fabric
(21001,4042,1,1,-1,39358),-- Enria
(21001,57,933,1901,0,700000),-- Adena
(21001,286,1,1,1,18),-- Eminence Bow
(21001,2121,1,1,1,2005),-- Eminence Bow Shaft
(21001,1868,1,1,2,124561),-- Thread
(21001,1873,1,1,2,24912),-- Silver Nugget
(21001,1876,1,1,2,12456),-- Mithril Ore
(21001,1895,1,1,2,17794),-- Metallic Fiber
(21001,4042,1,1,2,1038),-- Enria
(21001,4180,1,1,2,6920),-- Recipe: Silver Arrow
(21001,4939,1,1,2,771),-- Recipe: Adamantite Necklace (70%)
(21001,4966,1,1,2,72),-- Recipe: Keshanberk (60%)
(21001,4971,1,1,2,72),-- Recipe: Dark Elven Long Bow (60%)
(21001,5165,1,1,2,125),-- Recipe: Blessed Spiritshot (B) Compressed Package (100%)
(21001,8726,1,1,200,1442),-- Life Stone: level 55
(21001,8736,1,1,200,360),-- Mid-Grade Life Stone: level 55
(21001,8746,1,1,200,36),-- High-Grade Life Stone: level 55
(21001,8756,1,1,200,7),-- Top-Grade Life Stone: level 55
(21002,1874,1,1,-1,139115),-- Oriharukon Ore
(21002,2960,1,1,-1,113625),-- Drake Leather Boots Design
(21002,4613,1,1,-1,2878),-- Greater Dye of Strength <Str+4 Con-4>
(21002,57,823,1681,0,700000),-- Adena
(21002,11896,1,1,1,176),-- Common Item - Dark Elven Long Bow
(21002,4112,1,1,1,1745),-- Dark Elven Longbow Shaft
(21002,1867,1,1,2,68487),-- Animal Skin
(21002,1872,1,1,2,68487),-- Animal Bone
(21002,1875,1,1,2,3424),-- Stone of Purity
(21002,1881,1,1,2,6849),-- Coarse Bone Powder
(21002,4041,1,1,2,447),-- Mold Hardener
(21002,4949,1,1,2,329),-- Recipe: Tunic of Zubei (60%)
(21002,4992,1,1,2,639),-- Recipe: Blue Wolf Boots (60%)
(21002,8311,1,1,2,39),-- Recipe: Kaim Vanul\'s Bones (100%)
(21002,8727,1,1,200,1027),-- Life Stone: level 58
(21002,8737,1,1,200,257),-- Mid-Grade Life Stone: level 58
(21002,8747,1,1,200,26),-- High-Grade Life Stone: level 58
(21002,8757,1,1,200,5),-- Top-Grade Life Stone: level 58
(21003,2963,1,1,-1,104221),-- Full Plate Gauntlets Part
(21003,4049,1,1,-1,100394),-- Adamantite Earring Gemstone
(21003,4949,1,1,-1,12269),-- Recipe: Tunic of Zubei (60%)
(21003,57,755,1542,0,700000),-- Adena
(21003,12160,1,1,1,452),-- Common Item - Zubei\'s Helmet
(21003,12159,1,1,1,645),-- Common Item - Zubei\'s Shield
(21003,12171,1,1,1,645),-- Common Item - Avadon Shield
(21003,12170,1,1,1,452),-- Common Item - Avadon Circlet
(21003,4072,1,1,1,3174),-- Avadon Circlet Pattern
(21003,4101,1,1,1,4097),-- Zubei\'s Shield Fragment
(21003,4102,1,1,1,3174),-- Zubei\'s Helmet Design
(21003,4439,1,1,1,4874),-- Avadon Shield Fragment
(21003,1832,1,1,2,48322),-- Greater Antidote
(21003,1866,1,1,2,28993),-- Suede
(21003,1871,1,1,2,43490),-- Charcoal
(21003,1885,1,1,2,3624),-- High Grade Suede
(21003,4041,1,1,2,378),-- Mold Hardener
(21003,4963,1,1,2,50),-- Recipe: Great Sword (60%)
(21003,4993,1,1,2,541),-- Recipe: Doom Gloves (60%)
(21003,4999,1,1,2,541),-- Recipe: Doom Boots (60%)
(21003,5220,1,1,2,1468),-- Metal Hardener
(21003,8727,1,1,200,870),-- Life Stone: level 58
(21003,8737,1,1,200,217),-- Mid-Grade Life Stone: level 58
(21003,8747,1,1,200,22),-- High-Grade Life Stone: level 58
(21003,8757,1,1,200,4),-- Top-Grade Life Stone: level 58
(21004,1920,1,1,-1,72742),-- Necklace of Binding Chain
(21004,4129,1,1,-1,23007),-- Recipe: Earrings of Black Ore
(21004,4951,1,1,-1,9324),-- Recipe: Avadon Robe (60%)
(21004,57,840,1710,0,700000),-- Adena
(21004,12151,1,1,1,334),-- Common Item - Zubei\'s Leather Shirt
(21004,12150,1,1,1,535),-- Common Item - Zubei\'s Leather Gaiters
(21004,12165,1,1,1,205),-- Common Item - Avadon Leather Armor
(21004,4066,1,1,1,2468),-- Zubei\'s Leather Shirt Fabric
(21004,4067,1,1,1,3747),-- Zubei\'s Leather Gaiter Texture
(21004,4068,1,1,1,1896),-- Avadon Leather Armor Lining
(21004,1868,1,1,2,104659),-- Thread
(21004,1873,1,1,2,20932),-- Silver Nugget
(21004,1876,1,1,2,10466),-- Mithril Ore
(21004,1895,1,1,2,14951),-- Metallic Fiber
(21004,4042,1,1,2,872),-- Enria
(21004,4129,1,1,2,566),-- Recipe: Earrings of Black Ore
(21004,4167,1,1,2,651),-- Recipe: Blue Wolf Boots
(21004,4197,1,1,2,40),-- Recipe: Demon Dagger
(21004,8728,1,1,200,872),-- Life Stone: level 61
(21004,8738,1,1,200,218),-- Mid-Grade Life Stone: level 61
(21004,8748,1,1,200,22),-- High-Grade Life Stone: level 61
(21004,8758,1,1,200,4),-- Top-Grade Life Stone: level 61
(21005,947,1,1,-1,932),-- Scroll: Enchant Weapon (Grade B)
(21005,1880,1,1,-1,233106),-- Steel
(21005,4050,1,1,-1,144427),-- Adamantite Ring Wire
(21005,57,920,1876,0,700000),-- Adena
(21005,11889,1,1,1,66),-- Common Item - Great Sword
(21005,11916,1,1,1,66),-- Common Item - Keshanberk
(21005,11900,1,1,1,66),-- Common Item - Sword of Valhalla
(21005,4104,1,1,1,657),-- Great Sword Blade
(21005,4107,1,1,1,647),-- Keshanberk Blade
(21005,4108,1,1,1,647),-- Sword of Valhalla Blade
(21005,1868,1,1,2,114760),-- Thread
(21005,1873,1,1,2,22952),-- Silver Nugget
(21005,1876,1,1,2,11476),-- Mithril Ore
(21005,1895,1,1,2,16394),-- Metallic Fiber
(21005,4042,1,1,2,956),-- Enria
(21005,4129,1,1,2,621),-- Recipe: Earrings of Black Ore
(21005,4167,1,1,2,714),-- Recipe: Blue Wolf Boots
(21005,4197,1,1,2,44),-- Recipe: Demon Dagger
(21005,8728,1,1,200,956),-- Life Stone: level 61
(21005,8738,1,1,200,239),-- Mid-Grade Life Stone: level 61
(21005,8748,1,1,200,24),-- High-Grade Life Stone: level 61
(21005,8758,1,1,200,5),-- Top-Grade Life Stone: level 61
(21006,948,1,1,-1,5547),-- Scroll: Enchant Armor (Grade B)
(21006,4066,1,1,-1,52315),-- Zubei\'s Leather Shirt Fabric
(21006,4130,1,1,-1,36022),-- Recipe: Ring of Black Ore
(21006,57,878,1784,0,700000),-- Adena
(21006,357,1,1,1,10),-- Zubei\'s Breastplate
(21006,383,1,1,1,16),-- Zubei\'s Gaiters
(21006,2376,1,1,1,10),-- Avadon Breastplate
(21006,2379,1,1,1,16),-- Avadon Gaiters
(21006,4056,1,1,1,1483),-- Zubei\'s Breastplate Part
(21006,4057,1,1,1,2292),-- Zubei\'s Gaiter Material
(21006,4064,1,1,1,1483),-- Avadon Breastplate Part
(21006,4065,1,1,1,2292),-- Avadon Gaiters Material
(21006,1864,1,1,2,109241),-- Stem
(21006,1869,1,1,2,54621),-- Iron Ore
(21006,1880,1,1,2,5462),-- Steel
(21006,4043,1,1,2,1821),-- Asofe
(21006,4173,1,1,2,679),-- Recipe: Blue Wolf Gloves
(21006,4193,1,1,2,42),-- Recipe: Lance
(21006,5003,1,1,2,42),-- Recipe: Art of Battle Axe (60%)
(21006,5550,1,1,2,728),-- Durable Metal Plate
(21006,8728,1,1,200,910),-- Life Stone: level 61
(21006,8738,1,1,200,228),-- Mid-Grade Life Stone: level 61
(21006,8748,1,1,200,23),-- High-Grade Life Stone: level 61
(21006,8758,1,1,200,5),-- Top-Grade Life Stone: level 61
(21007,948,1,1,-1,5966),-- Scroll: Enchant Armor (Grade B)
(21007,4051,1,1,-1,92552),-- Adamantite Necklace Chain
(21007,4981,1,1,-1,7411),-- Recipe: Blue Wolf Breastplate (60%)
(21007,57,946,1918,0,700000),-- Adena
(21007,11918,1,1,1,101),-- Common Item - Heavy War Axe
(21007,11908,1,1,1,101),-- Common Item - Sprite\'s Staff
(21007,4105,1,1,1,1008),-- Heavy War Axe Head
(21007,4106,1,1,1,992),-- Sprite\'s Staff Head
(21007,1832,1,1,2,65271),-- Greater Antidote
(21007,1894,1,1,2,2061),-- Crafted Leather
(21007,4039,1,1,2,1958),-- Mold Glue
(21007,4041,1,1,2,511),-- Mold Hardener
(21007,4044,1,1,2,1958),-- Thons
(21007,4166,1,1,2,485),-- Recipe: Doom Helmet
(21007,4621,1,1,2,81),-- Greater Dye of Mental Strength <Men+4 Int-4>
(21007,4998,1,1,2,731),-- Recipe: Blue Wolf Gloves (60%)
(21007,8728,1,1,200,979),-- Life Stone: level 61
(21007,8738,1,1,200,245),-- Mid-Grade Life Stone: level 61
(21007,8748,1,1,200,24),-- High-Grade Life Stone: level 61
(21007,8758,1,1,200,5),-- Top-Grade Life Stone: level 61
(21008,4052,1,1,-1,108272),-- Earring of Black Ore Piece
(21008,4983,1,1,-1,6493),-- Recipe: Doom Plate Armor (60%)
(21008,5230,1,1,-1,4078),-- Recipe: Mithril Arrow (100%)
(21008,57,1213,2457,0,700000),-- Adena
(21008,12188,1,1,1,601),-- Common Item - Boots of Doom
(21008,12189,1,1,1,601),-- Common Item - Blue Wolf Boots
(21008,12187,1,1,1,601),-- Common Item - Doom Gloves
(21008,12190,1,1,1,601),-- Common Item - Blue Wolf Gloves
(21008,4090,1,1,1,5069),-- Blue Wolf Boots Design
(21008,4091,1,1,1,5069),-- Doom Gloves Part
(21008,4096,1,1,1,5069),-- Blue Wolf Gloves Fabric
(21008,4099,1,1,1,5069),-- Doom Boots Part
(21008,1867,1,1,2,109494),-- Animal Skin
(21008,1872,1,1,2,109494),-- Animal Bone
(21008,1882,1,1,2,18249),-- Leather
(21008,1894,1,1,2,2881),-- Crafted Leather
(21008,4042,1,1,2,1369),-- Enria
(21008,4983,1,1,2,174),-- Recipe: Doom Plate Armor (60%)
(21008,5276,1,1,2,109),-- Recipe: Greater Spiritshot (A) Compressed Package(100%)
(21008,8729,1,1,200,1095),-- Life Stone: level 64
(21008,8739,1,1,200,274),-- Mid-Grade Life Stone: level 64
(21008,8749,1,1,200,27),-- High-Grade Life Stone: level 64
(21008,8759,1,1,200,5),-- Top-Grade Life Stone: level 64
(21009,948,1,1,-1,8173),-- Scroll: Enchant Armor (Grade B)
(21009,4052,1,1,-1,115743),-- Earring of Black Ore Piece
(21009,4104,1,1,-1,18708),-- Great Sword Blade
(21009,57,1297,2625,0,700000),-- Adena
(21009,12204,1,1,1,214),-- Common Item - Blue Wolf Breastplate
(21009,12193,1,1,1,343),-- Common Item - Blue Wolf Gaiters
(21009,12184,1,1,1,132),-- Common Item - Doom Plate Armor
(21009,4078,1,1,1,2351),-- Blue Wolf Breastplate Part
(21009,4080,1,1,1,3311),-- Blue Wolf Gaiters Material
(21009,4081,1,1,1,1586),-- Doom Plate Armor Temper
(21009,1865,1,1,2,87787),-- Varnish
(21009,1870,1,1,2,87787),-- Coal
(21009,1875,1,1,2,5852),-- Stone of Purity
(21009,1879,1,1,2,14631),-- Cokes
(21009,4040,1,1,2,1756),-- Mold Lubricant
(21009,5004,1,1,2,67),-- Recipe: Staff of Evil Spirits (60%)
(21009,5281,1,1,2,117),-- Recipe: Greater Blessed Spiritshot (A) Compressed Package(100%)
(21009,8729,1,1,200,1170),-- Life Stone: level 64
(21009,8739,1,1,200,293),-- Mid-Grade Life Stone: level 64
(21009,8749,1,1,200,29),-- High-Grade Life Stone: level 64
(21009,8759,1,1,200,6),-- Top-Grade Life Stone: level 64
(21010,4621,1,1,-1,3620),-- Greater Dye of Mental Strength <Men+4 Int-4>
(21010,5230,1,1,-1,3500),-- Recipe: Mithril Arrow (100%)
(21010,57,1042,2108,0,700000),-- Adena
(21010,11933,1,1,1,127),-- Common Item - Bellion Cestus
(21010,4120,1,1,1,1694),-- Bellion Cestus Edge
(21010,1868,1,1,2,119273),-- Thread
(21010,1873,1,1,2,23855),-- Silver Nugget
(21010,1889,1,1,2,3976),-- Compound Braid
(21010,3956,1,1,2,80),-- Recipe: Blessed Spiritshot A
(21010,4044,1,1,2,1988),-- Thons
(21010,4129,1,1,2,645),-- Recipe: Earrings of Black Ore
(21010,4624,1,1,2,82),-- Greater Dye of Wit <Wit+4 Men-4>
(21010,5549,1,1,2,5964),-- Metallic Thread
(21010,6670,1,1,2,9939),-- Deluxe Chest Key - Grade 6
(21010,8729,1,1,200,795),-- Life Stone: level 64
(21010,8739,1,1,200,199),-- Mid-Grade Life Stone: level 64
(21010,8749,1,1,200,20),-- High-Grade Life Stone: level 64
(21010,8759,1,1,200,4),-- Top-Grade Life Stone: level 64
(21011,1832,1,1,-1,589975),-- Greater Antidote
(21011,1884,1,1,-1,326755),-- Cord
(21011,1900,1,1,-1,58094),-- Enchanted Necklace Chain
(21011,57,224,448,0,700000),-- Adena
(21011,46,1,1,1,756),-- Bronze Helmet
(21011,627,1,1,1,1078),-- Aspis
(21011,1061,1,1,2,21982),-- Healing Potion
(21011,1864,1,1,2,72540),-- Stem
(21011,1865,1,1,2,36270),-- Varnish
(21011,1866,1,1,2,24180),-- Suede
(21011,1868,1,1,2,72540),-- Thread
(21011,1873,1,1,2,14508),-- Silver Nugget
(21011,2185,1,1,2,7140),-- Recipe: Iron Boots
(21011,2274,1,1,2,259),-- Recipe: Skull Breaker
(21012,1936,1,1,-1,53457),-- White Tunic Pattern
(21012,2153,1,1,-1,101594),-- Recipe: Tiger\'s Eye Earring
(21012,2185,1,1,-1,128592),-- Recipe: Iron Boots
(21012,57,276,551,0,700000),-- Adena
(21012,275,1,1,1,48),-- Long Bow
(21012,276,1,1,1,48),-- Elven Bow
(21012,2024,1,1,1,1695),-- Elven Bow Shaft
(21012,1833,1,1,2,135991),-- Bandage
(21012,1868,1,1,2,101993),-- Thread
(21012,1873,1,1,2,20399),-- Silver Nugget
(21012,1889,1,1,2,3400),-- Compound Braid
(21012,2264,1,1,2,527),-- Recipe: Two-handed Sword
(21012,2273,1,1,2,364),-- Recipe: Tarbar
(21012,5549,1,1,2,5100),-- Metallic Thread
(21013,1061,1,1,-1,466705),-- Healing Potion
(21013,1933,1,1,-1,90596),-- Dark Stocking Fabric
(21013,2023,1,1,-1,9542),-- Conjuror\'s Staff Head
(21013,57,324,651,0,700000),-- Adena
(21013,848,1,1,1,641),-- Enchanted Earring
(21013,879,1,1,1,965),-- Enchanted Ring
(21013,911,1,1,1,481),-- Enchanted Necklace
(21013,1900,1,1,1,11510),-- Enchanted Necklace Chain
(21013,737,1,1,2,7014),-- Scroll of Resurrection
(21013,1061,1,1,2,42506),-- Healing Potion
(21013,1866,1,1,2,46757),-- Suede
(21013,1871,1,1,2,70135),-- Charcoal
(21013,1877,1,1,2,2805),-- Adamantite Nugget
(21013,2187,1,1,2,3131),-- Recipe: Manticore Skin Shirt
(21014,1865,1,1,-1,794911),-- Varnish
(21014,1958,1,1,-1,71453),-- Mithril Boots Design
(21014,2977,1,1,-1,106414),-- Recipe: Brigandine Boots
(21014,57,336,672,0,700000),-- Adena
(21014,316,1,1,1,38),-- Blood of Saints
(21014,317,1,1,1,38),-- Tome of Blood
(21014,2030,1,1,1,1648),-- Tome of Blood Page
(21014,1865,1,1,2,70441),-- Varnish
(21014,1870,1,1,2,70441),-- Coal
(21014,1875,1,1,2,4696),-- Stone of Purity
(21014,1879,1,1,2,11740),-- Cokes
(21014,2189,1,1,2,3145),-- Recipe: Mithril Tunic
(21014,2286,1,1,2,391),-- Recipe: Bonebreaker
(21015,1869,1,1,-1,810885),-- Iron Ore
(21015,1873,1,1,-1,324354),-- Silver Nugget
(21015,1940,1,1,-1,121028),-- Iron Boots Design
(21015,57,342,683,0,700000),-- Adena
(21015,83,1,1,1,26),-- Sword of Magic
(21015,124,1,1,1,19),-- Two-Handed Sword
(21015,127,1,1,1,19),-- Crimson Sword
(21015,130,1,1,1,19),-- Elven Sword
(21015,144,1,1,1,26),-- Sword of Occult
(21015,2026,1,1,1,865),-- Two-Handed Sword Edge
(21015,1868,1,1,2,172456),-- Thread
(21015,1873,1,1,2,34491),-- Silver Nugget
(21015,1876,1,1,2,17246),-- Mithril Ore
(21015,2280,1,1,2,616),-- Recipe: Crucifix of Blood
(21015,2978,1,1,2,11543),-- Recipe: Elven Mithril Boots
(21016,1870,1,1,-1,868501),-- Coal
(21016,1882,1,1,-1,193000),-- Leather
(21016,1901,1,1,-1,119959),-- Tiger\'s Eye Earring Stone
(21016,57,367,732,0,700000),-- Adena
(21016,58,1,1,1,94),-- Mithril Breastplate
(21016,59,1,1,1,135),-- Mithril Gaiters
(21016,349,1,1,1,94),-- Compound Scale Mail
(21016,350,1,1,1,94),-- Dwarven Scale Mail
(21016,351,1,1,1,85),-- Blast Plate
(21016,378,1,1,1,135),-- Compound Scale Gaiters
(21016,379,1,1,1,135),-- Dwarven Scale Gaiters
(21016,1864,1,1,2,131936),-- Stem
(21016,1869,1,1,2,65958),-- Iron Ore
(21016,1880,1,1,2,6597),-- Steel
(21016,2191,1,1,2,8831),-- Recipe: RIP Gauntlets
(21016,2276,1,1,2,471),-- Recipe: Maingauche
(21016,2293,1,1,2,366),-- Recipe: Glaive
(21016,5550,1,1,2,880),-- Durable Metal Plate
(21017,1806,1,1,-1,3548),-- Recipe: Soulshot: B-Grade
(21017,1880,1,1,-1,177397),-- Steel
(21017,1989,1,1,-1,53465),-- Divine Stocking Pattern
(21017,57,701,1428,0,700000),-- Adena
(21017,400,1,1,1,34),-- Theca Leather Armor
(21017,401,1,1,1,16),-- Drake Leather Armor
(21017,420,1,1,1,55),-- Theca Leather Gaiters
(21017,1984,1,1,1,2340),-- Theca Leather Armor Pattern
(21017,1985,1,1,1,3764),-- Theca Leather Gaiters Pattern
(21017,1987,1,1,1,1665),-- Drake Leather Armor Texture
(21017,1866,1,1,2,36389),-- Suede
(21017,1871,1,1,2,54584),-- Charcoal
(21017,1885,1,1,2,4549),-- High Grade Suede
(21017,4041,1,1,2,475),-- Mold Hardener
(21017,4189,1,1,2,63),-- Recipe: Arthro Nail
(21017,4940,1,1,2,262),-- Recipe: Zubei\'s Breastplate (60%)
(21017,5220,1,1,2,2183),-- Metal Hardener
(21017,5280,1,1,2,109),-- Recipe: Greater Blessed Spiritshot (B) Compressed Package(100%)
(21017,8726,1,1,200,1264),-- Life Stone: level 55
(21017,8736,1,1,200,316),-- Mid-Grade Life Stone: level 55
(21017,8746,1,1,200,32),-- High-Grade Life Stone: level 55
(21017,8756,1,1,200,7),-- Top-Grade Life Stone: level 55
(21018,2961,1,1,-1,121815),-- Full Plate Boots Part
(21018,4049,1,1,-1,117342),-- Adamantite Earring Gemstone
(21018,4947,1,1,-1,22992),-- Recipe: Zubei\'s Leather Gaiters (60%)
(21018,57,883,1802,0,700000),-- Adena
(21018,11918,1,1,1,95),-- Common Item - Heavy War Axe
(21018,11908,1,1,1,95),-- Common Item - Sprite\'s Staff
(21018,4105,1,1,1,945),-- Heavy War Axe Head
(21018,4106,1,1,1,930),-- Sprite\'s Staff Head
(21018,1867,1,1,2,73424),-- Animal Skin
(21018,1872,1,1,2,73424),-- Animal Bone
(21018,1875,1,1,2,3671),-- Stone of Purity
(21018,1881,1,1,2,7342),-- Coarse Bone Powder
(21018,4041,1,1,2,479),-- Mold Hardener
(21018,4950,1,1,2,566),-- Recipe: Stockings of Zubei (60%)
(21018,4999,1,1,2,685),-- Recipe: Doom Boots (60%)
(21018,8309,1,1,2,63),-- Recipe: Spell Breaker (100%)
(21018,8727,1,1,200,1101),-- Life Stone: level 58
(21018,8737,1,1,200,275),-- Mid-Grade Life Stone: level 58
(21018,8747,1,1,200,28),-- High-Grade Life Stone: level 58
(21018,8757,1,1,200,5),-- Top-Grade Life Stone: level 58
(21019,2964,1,1,-1,134399),-- Divine Gloves Pattern
(21019,4129,1,1,-1,26713),-- Recipe: Earrings of Black Ore
(21019,4950,1,1,-1,25367),-- Recipe: Stockings of Zubei (60%)
(21019,57,973,1988,0,700000),-- Adena
(21019,11903,1,1,1,209),-- Common Item - Arthro Nail
(21019,4111,1,1,1,2086),-- Arthro Nail Blade
(21019,1865,1,1,2,60757),-- Varnish
(21019,1870,1,1,2,60757),-- Coal
(21019,1874,1,1,2,4051),-- Oriharukon Ore
(21019,4039,1,1,2,2025),-- Mold Glue
(21019,4043,1,1,2,2025),-- Asofe
(21019,4176,1,1,2,756),-- Recipe: Doom Boots
(21019,4964,1,1,2,70),-- Recipe: Heavy War Axe (60%)
(21019,5003,1,1,2,46),-- Recipe: Art of Battle Axe (60%)
(21019,8727,1,1,200,1215),-- Life Stone: level 58
(21019,8737,1,1,200,304),-- Mid-Grade Life Stone: level 58
(21019,8747,1,1,200,30),-- High-Grade Life Stone: level 58
(21019,8757,1,1,200,6),-- Top-Grade Life Stone: level 58
(21020,1987,1,1,-1,42700),-- Drake Leather Armor Texture
(21020,4050,1,1,-1,173407),-- Adamantite Ring Wire
(21020,4952,1,1,-1,35974),-- Recipe: Avadon Circlet (60%)
(21020,57,1105,2252,0,700000),-- Adena
(21020,78,1,1,1,4),-- Great Sword
(21020,142,1,1,1,4),-- Keshanberk
(21020,148,1,1,1,4),-- Sword of Valhalla
(21020,4104,1,1,1,788),-- Great Sword Blade
(21020,4107,1,1,1,776),-- Keshanberk Blade
(21020,4108,1,1,1,776),-- Sword of Valhalla Blade
(21020,1832,1,1,2,459294),-- Greater Antidote
(21020,4167,1,1,2,5141),-- Recipe: Blue Wolf Boots
(21021,947,1,1,-1,1034),-- Scroll: Enchant Weapon (Grade B)
(21021,4040,1,1,-1,51678),-- Mold Lubricant
(21021,4613,1,1,-1,3564),-- Greater Dye of Strength <Str+4 Con-4>
(21021,57,1020,2079,0,700000),-- Adena
(21021,11896,1,1,1,218),-- Common Item - Dark Elven Long Bow
(21021,4112,1,1,1,2161),-- Dark Elven Longbow Shaft
(21021,1867,1,1,2,84805),-- Animal Skin
(21021,1869,1,1,2,63604),-- Iron Ore
(21021,1870,1,1,2,63604),-- Coal
(21021,1871,1,1,2,63604),-- Charcoal
(21021,1872,1,1,2,84805),-- Animal Bone
(21021,4130,1,1,2,1032),-- Recipe: Ring of Black Ore
(21021,4998,1,1,2,791),-- Recipe: Blue Wolf Gloves (60%)
(21021,5001,1,1,2,49),-- Recipe: Lance (60%)
(21021,8728,1,1,200,1060),-- Life Stone: level 61
(21021,8738,1,1,200,265),-- Mid-Grade Life Stone: level 61
(21021,8748,1,1,200,27),-- High-Grade Life Stone: level 61
(21021,8758,1,1,200,5),-- Top-Grade Life Stone: level 61
(21022,947,1,1,-1,1053),-- Scroll: Enchant Weapon (Grade B)
(21022,4049,1,1,-1,138069),-- Adamantite Earring Gemstone
(21022,4613,1,1,-1,3631),-- Greater Dye of Strength <Str+4 Con-4>
(21022,57,1041,2116,0,700000),-- Adena
(21022,12175,1,1,1,414),-- Common Item - Tunic of Zubei
(21022,12176,1,1,1,663),-- Common Item - Stockings of Zubei
(21022,12166,1,1,1,254),-- Common Item - Avadon Robe
(21022,4069,1,1,1,3055),-- Tunic of Zubei Fabric
(21022,4070,1,1,1,4639),-- Stockings of Zubei Fabric
(21022,4071,1,1,1,2347),-- Avadon Robe Fabric
(21022,1867,1,1,2,86393),-- Animal Skin
(21022,1869,1,1,2,64795),-- Iron Ore
(21022,1870,1,1,2,64795),-- Coal
(21022,1871,1,1,2,64795),-- Charcoal
(21022,1872,1,1,2,86393),-- Animal Bone
(21022,4130,1,1,2,1052),-- Recipe: Ring of Black Ore
(21022,4998,1,1,2,806),-- Recipe: Blue Wolf Gloves (60%)
(21022,5001,1,1,2,50),-- Recipe: Lance (60%)
(21022,8728,1,1,200,1080),-- Life Stone: level 61
(21022,8738,1,1,200,270),-- Mid-Grade Life Stone: level 61
(21022,8748,1,1,200,27),-- High-Grade Life Stone: level 61
(21022,8758,1,1,200,5),-- Top-Grade Life Stone: level 61
(21023,1866,1,1,-1,294716),-- Suede
(21023,2019,1,1,-1,9507),-- Trident Edge
(21023,2263,1,1,-1,6865),-- Recipe: Dwarven Trident
(21023,57,1923,367,0,700000),-- Adena
(21023,156,1,1,1,53),-- Hand Axe
(21023,167,1,1,1,53),-- Scalpel
(21023,178,1,1,1,53),-- Bone Staff
(21023,1864,1,1,2,82702),-- Stem
(21023,1865,1,1,2,41351),-- Varnish
(21023,1866,1,1,2,27567),-- Suede
(21023,1868,1,1,2,82702),-- Thread
(21023,1873,1,1,2,16540),-- Silver Nugget
(21023,2260,1,1,2,642),-- Recipe: Mace of Judgment
(21024,1899,1,1,-1,72121),-- Necklace of Devotion Chain
(21024,1934,1,1,-1,60336),-- Crafted Leather Gloves Lining
(21024,2178,1,1,-1,73852),-- Recipe: Dark Stockings
(21024,57,199,384,0,700000),-- Adena
(21024,220,1,1,1,164),-- Crafted Dagger
(21024,1864,1,1,2,103619),-- Stem
(21024,1869,1,1,2,51810),-- Iron Ore
(21024,1878,1,1,2,20724),-- Braided Hemp
(21024,1884,1,1,2,31883),-- Cord
(21024,2180,1,1,2,3895),-- Recipe: Scale Mail
(21025,1868,1,3,-1,485180),-- Thread
(21025,1871,1,1,-1,485180),-- Charcoal
(21025,2152,1,1,-1,85419),-- Recipe: Enchanted Necklace
(21025,57,208,407,0,700000),-- Adena
(21025,291,1,1,1,86),-- Trident
(21025,2019,1,1,1,2928),-- Trident Edge
(21025,1864,1,1,2,90766),-- Stem
(21025,1865,1,1,2,45383),-- Varnish
(21025,1866,1,1,2,30255),-- Suede
(21025,1868,1,1,2,90766),-- Thread
(21025,1873,1,1,2,18153),-- Silver Nugget
(21025,2180,1,1,2,3412),-- Recipe: Scale Mail
(21026,1834,1,1,-1,575495),-- Emergency Dressing
(21026,1900,1,1,-1,56668),-- Enchanted Necklace Chain
(21026,2025,1,1,-1,7174),-- Dwarven Trident Edge
(21026,57,220,435,0,700000),-- Adena
(21026,275,1,1,1,38),-- Long Bow
(21026,276,1,1,1,38),-- Elven Bow
(21026,2024,1,1,1,1344),-- Elven Bow Shaft
(21026,737,1,1,2,4043),-- Scroll of Resurrection
(21026,1867,1,1,2,53912),-- Animal Skin
(21026,1872,1,1,2,53912),-- Animal Bone
(21026,1875,1,1,2,2696),-- Stone of Purity
(21026,1881,1,1,2,5391),-- Coarse Bone Powder
(21026,2191,1,1,2,5413),-- Recipe: RIP Gauntlets
(21026,2274,1,1,2,289),-- Recipe: Skull Breaker
(21034,1956,1,1,-1,80198),-- Square Shield Fragment
(21034,2154,1,1,-1,75647),-- Recipe: Elven Earring
(21034,2302,1,1,-1,3085),-- Recipe: Silver Axe
(21034,57,299,596,0,700000),-- Adena
(21034,88,1,1,1,7),-- Morning Star
(21034,90,1,1,1,7),-- Goat Head Staff
(21034,158,1,1,1,7),-- Tarbar
(21034,169,1,1,1,7),-- Skull Breaker
(21034,172,1,1,1,7),-- Heavy Bone Club
(21034,2031,1,1,1,370),-- Morning Star Head
(21034,2032,1,1,1,337),-- Goat Head Staff Head
(21034,2035,1,1,1,370),-- Tarbar Head
(21034,2036,1,1,1,370),-- Skull Breaker Head
(21034,2037,1,1,1,370),-- Heavy Bone Club Head
(21034,1341,10,30,2,152176),-- Bone Arrow
(21034,1874,1,1,2,3044),-- Oriharukon Ore
(21034,1878,1,1,2,18261),-- Braided Hemp
(21034,1884,1,1,2,28094),-- Cord
(21034,1889,1,1,2,3044),-- Compound Braid
(21034,2190,1,1,2,3261),-- Recipe: Mithril Stockings
(21034,2279,1,1,2,326),-- Recipe: War Pick
(21034,5220,1,1,2,1826),-- Metal Hardener
(21035,1873,1,1,-1,910076),-- Silver Nugget
(21035,1905,1,1,-1,221322),-- Omen Beast\'s Eye Earring Gemstone
(21035,1952,1,1,-1,72876),-- Salamander Skin Mail Texture
(21035,57,916,1852,0,700000),-- Adena
(21035,396,1,1,1,312),-- Salamander Skin Mail
(21035,1952,1,1,1,18297),-- Salamander Skin Mail Texture
(21035,1865,1,1,2,126944),-- Varnish
(21035,1870,1,1,2,126944),-- Coal
(21035,1875,1,1,2,8463),-- Stone of Purity
(21035,1879,1,1,2,21158),-- Cokes
(21035,2205,1,1,2,4017),-- Recipe: Chain Gaiters
(21035,2308,1,1,2,554),-- Recipe: Cursed Dagger
(21035,2989,1,1,2,6717),-- Recipe: Chain Hood
(21035,2997,1,1,2,10075),-- Recipe: Karmian Gloves
(21035,6668,1,1,2,45337),-- Deluxe Chest Key - Grade 4
(21036,1895,1,1,-1,765042),-- Metallic Fiber
(21036,2070,1,1,-1,21261),-- Cursed Dagger Blade
(21036,2316,1,1,-1,9330),-- Recipe: Katana
(21036,57,1054,2160,0,700000),-- Adena
(21036,354,1,1,1,163),-- Chain Mail Shirt
(21036,381,1,1,1,260),-- Chain Gaiters
(21036,1959,1,1,1,8522),-- Chain Mail Shirt Material
(21036,1960,1,1,1,17335),-- Chain Gaiters Part
(21036,1895,1,1,2,60262),-- Metallic Fiber
(21036,2318,1,1,2,735),-- Recipe: Spirit Sword
(21036,8723,1,1,200,8437),-- Life Stone: level 46
(21036,8733,1,1,200,2109),-- Mid-Grade Life Stone: level 46
(21036,8743,1,1,200,211),-- High-Grade Life Stone: level 46
(21036,8753,1,1,200,42),-- Top-Grade Life Stone: level 46
(21037,2166,1,1,-1,117557),-- Recipe: Earrings of Binding (100%)
(21037,4040,1,1,-1,69359),-- Mold Lubricant
(21037,5231,1,1,-1,247709),-- Recipe: Metal Hardener (100%)
(21037,57,1369,2792,0,700000),-- Adena
(21037,1126,1,1,1,207),-- Crimson Boots
(21037,1974,1,1,1,10769),-- Crimson Boot Fabric
(21037,2434,1,1,1,207),-- Rind Leather Boots
(21037,2455,1,1,1,224),-- Plated Leather Gloves
(21037,2456,1,1,1,207),-- Dwarven Chain Gloves
(21037,2457,1,1,1,207),-- Gloves of Seal
(21037,2458,1,1,1,207),-- Rind Leather Gloves
(21037,2946,1,1,1,7157),-- Plate Leather Gloves Design
(21037,2948,1,1,1,10769),-- Rind Leather Boot Lining
(21037,2949,1,1,1,10769),-- Dwarven Chain Gloves Design
(21037,2950,1,1,1,10769),-- Gloves of Seal Pattern
(21037,2951,1,1,1,10769),-- Rind Leather Gloves Design
(21037,1895,1,1,2,36585),-- Metallic Fiber
(21037,2225,1,1,2,2784),-- Recipe: Demon\'s Stockings
(21037,2329,1,1,2,298),-- Recipe: Tsurugi
(21037,2344,1,1,2,298),-- Recipe: Grace Dagger
(21037,2345,1,1,2,298),-- Recipe: Dark Screamer
(21037,4040,1,1,2,2561),-- Mold Lubricant
(21037,4042,1,1,2,2134),-- Enria
(21037,4043,1,1,2,4268),-- Asofe
(21037,8724,1,1,200,4268),-- Life Stone: level 49
(21037,8734,1,1,200,1067),-- Mid-Grade Life Stone: level 49
(21037,8744,1,1,200,107),-- High-Grade Life Stone: level 49
(21037,8754,1,1,200,21),-- Top-Grade Life Stone: level 49
(21038,1911,1,1,-1,195390),-- Earring of Protection Gemstone
(21038,2166,1,1,-1,89051),-- Recipe: Earrings of Binding (100%)
(21038,5231,1,1,-1,187644),-- Recipe: Metal Hardener (100%)
(21038,57,1037,2115,0,700000),-- Adena
(21038,500,1,1,1,209),-- Great Helmet
(21038,632,1,1,1,298),-- Knight\'s Shield
(21038,1971,1,1,1,11876),-- Great Helmet Material
(21038,1972,1,1,1,15519),-- Knight\'s Shield Fragment
(21038,2496,1,1,1,323),-- Dwarven Chain Shield
(21038,2947,1,1,1,13856),-- Dwarven Chain Shield Fragment
(21038,952,1,1,2,1411),-- Scroll: Enchant Armor (Grade C)
(21038,1867,1,1,2,141087),-- Animal Skin
(21038,1872,1,1,2,141087),-- Animal Bone
(21038,1875,1,1,2,7054),-- Stone of Purity
(21038,1881,1,1,2,14109),-- Coarse Bone Powder
(21038,2224,1,1,2,1438),-- Recipe: Demon\'s Tunic
(21038,4041,1,1,2,920),-- Mold Hardener
(21038,8724,1,1,200,3527),-- Life Stone: level 49
(21038,8734,1,1,200,882),-- Mid-Grade Life Stone: level 49
(21038,8744,1,1,200,88),-- High-Grade Life Stone: level 49
(21038,8754,1,1,200,17),-- Top-Grade Life Stone: level 49
(21039,1805,1,1,-1,8706),-- Recipe: Soulshot: C-Grade
(21039,1871,1,5,-1,870607),-- Charcoal
(21039,1905,1,1,-1,254068),-- Omen Beast\'s Eye Earring Gemstone
(21039,57,1033,2097,0,700000),-- Adena
(21039,70,1,1,1,47),-- Claymore
(21039,2047,1,1,1,2882),-- Claymore Blade
(21039,2499,1,1,1,47),-- Elven Long Sword
(21039,2967,1,1,1,2843),-- Elven Long Sword Blade
(21039,1866,1,1,2,145726),-- Suede
(21039,1871,1,1,2,218589),-- Charcoal
(21039,1877,1,1,2,8744),-- Adamantite Nugget
(21039,2162,1,1,2,10560),-- Recipe: Aquastone Necklace
(21039,2312,1,1,2,954),-- Recipe: Crystallized Ice Bow
(21039,5159,1,1,2,729),-- Recipe: Spiritshot (C) Compressed Package (100%)
(21040,1875,1,1,-1,277649),-- Stone of Purity
(21040,1911,1,1,-1,309761),-- Earring of Protection Gemstone
(21040,1967,1,1,-1,227147),-- Plated Leather Gaiters Material
(21040,57,1644,3353,0,700000),-- Adena
(21040,195,1,1,1,42),-- Cursed Staff
(21040,2082,1,1,1,3252),-- Cursed Staff Head
(21040,2502,1,1,1,42),-- Dwarven War Hammer
(21040,2968,1,1,1,3113),-- Dwarven Warhammer Head
(21040,952,1,1,2,2237),-- Scroll: Enchant Armor (Grade C)
(21040,1867,1,1,2,223673),-- Animal Skin
(21040,1872,1,1,2,223673),-- Animal Bone
(21040,1875,1,1,2,11184),-- Stone of Purity
(21040,1881,1,1,2,22367),-- Coarse Bone Powder
(21040,2224,1,1,2,2279),-- Recipe: Demon\'s Tunic
(21040,4041,1,1,2,1459),-- Mold Hardener
(21040,8724,1,1,200,5592),-- Life Stone: level 49
(21040,8734,1,1,200,1398),-- Mid-Grade Life Stone: level 49
(21040,8744,1,1,200,140),-- High-Grade Life Stone: level 49
(21040,8754,1,1,200,27),-- Top-Grade Life Stone: level 49
(21058,4049,1,1,-1,313879),-- Adamantite Earring Gemstone
(21058,4129,1,1,-1,64763),-- Recipe: Earrings of Black Ore
(21058,4617,1,1,-1,8254),-- Greater Dye of Dexterity <Dex+4 Str-4>
(21058,57,2367,4811,0,700000),-- Adena
(21058,78,1,1,1,9),-- Great Sword
(21058,142,1,1,1,9),-- Keshanberk
(21058,148,1,1,1,9),-- Sword of Valhalla
(21058,4104,1,1,1,1686),-- Great Sword Blade
(21058,4107,1,1,1,1659),-- Keshanberk Blade
(21058,4108,1,1,1,1659),-- Sword of Valhalla Blade
(21058,1895,1,1,2,45912),-- Metallic Fiber
(21058,4040,1,1,2,3214),-- Mold Lubricant
(21058,4042,1,1,2,2678),-- Enria
(21058,4043,1,1,2,5356),-- Asofe
(21058,4163,1,1,2,1064),-- Recipe: Blue Wolf Stockings
(21058,4195,1,1,2,123),-- Recipe: Art of Battle Axe
(21058,4999,1,1,2,1999),-- Recipe: Doom Boots (60%)
(21058,8728,1,1,200,2678),-- Life Stone: level 61
(21058,8738,1,1,200,670),-- Mid-Grade Life Stone: level 61
(21058,8748,1,1,200,67),-- High-Grade Life Stone: level 61
(21058,8758,1,1,200,13),-- Top-Grade Life Stone: level 61
(21059,4049,1,1,-1,268315),-- Adamantite Earring Gemstone
(21059,4129,1,1,-1,55362),-- Recipe: Earrings of Black Ore
(21059,4130,1,1,-1,83043),-- Recipe: Ring of Black Ore
(21059,57,2020,4116,0,700000),-- Adena
(21059,284,1,1,1,23),-- Dark Elven Long Bow
(21059,4112,1,1,1,4277),-- Dark Elven Longbow Shaft
(21059,1864,1,3,2,125918),-- Stem
(21059,1869,1,1,2,125918),-- Iron Ore
(21059,1878,1,1,2,50367),-- Braided Hemp
(21059,1884,1,1,2,77488),-- Cord
(21059,4039,1,1,2,4197),-- Mold Glue
(21059,4154,1,1,2,1490),-- Recipe: Doom Shield
(21059,4194,1,1,2,96),-- Recipe: Deadman\'s Glory
(21059,4198,1,1,2,96),-- Recipe: Bellion Cestus
(21059,8728,1,1,200,2099),-- Life Stone: level 61
(21059,8738,1,1,200,525),-- Mid-Grade Life Stone: level 61
(21059,8748,1,1,200,52),-- High-Grade Life Stone: level 61
(21059,8758,1,1,200,10),-- Top-Grade Life Stone: level 61
(21060,947,1,1,-1,2046),-- Scroll: Enchant Weapon (Grade B)
(21060,1865,1,11,-1,852572),-- Varnish
(21060,4050,1,1,-1,316941),-- Adamantite Ring Wire
(21060,57,2020,4116,0,700000),-- Adena
(21060,229,1,1,1,11),-- Kris
(21060,243,1,1,1,11),-- Hell Knife
(21060,4109,1,1,1,2128),-- Kris Edge
(21060,4110,1,1,1,2128),-- Hell Knife Edge
(21060,1343,20,60,2,98119),-- Silver Arrow
(21060,1865,1,1,2,137366),-- Varnish
(21060,1870,1,1,2,137366),-- Coal
(21060,1875,1,1,2,9158),-- Stone of Purity
(21060,1879,1,1,2,22894),-- Cokes
(21060,4040,1,1,2,2747),-- Mold Lubricant
(21060,4155,1,1,2,427),-- Recipe: Blue Wolf Breastplate
(21060,8728,1,1,200,2289),-- Life Stone: level 61
(21060,8738,1,1,200,573),-- Mid-Grade Life Stone: level 61
(21060,8748,1,1,200,57),-- High-Grade Life Stone: level 61
(21060,8758,1,1,200,12),-- Top-Grade Life Stone: level 61
(21061,1895,1,7,-1,725557),-- Metallic Fiber
(21061,5478,1,1,-1,85417),-- Sealed Dark Crystal Leather Armor Pattern
(21061,57,4020,8164,0,700000),-- Adena
(21061,5287,1,1,1,28),-- Sealed Dark Crystal breastplate
(21061,5288,1,1,1,45),-- Sealed Dark Crystal Gaiters
(21061,5293,1,1,1,17),-- Sealed Tallum Plate Armor
(21061,5520,1,1,1,3225),-- Sealed Dark Crystal Breastplate Pattern
(21061,5521,1,1,1,2276),-- Sealed Tallum Plate Armor Pattern
(21061,5524,1,1,1,4929),-- Sealed Dark Crystal Gaiters Pattern
(21061,730,1,1,2,208),-- Scroll: Enchant Armor (Grade A)
(21061,1868,1,3,2,250039),-- Thread
(21061,1873,1,1,2,100015),-- Silver Nugget
(21061,1876,1,1,2,50008),-- Mithril Ore
(21061,1895,1,1,2,71440),-- Metallic Fiber
(21061,4042,1,1,2,4167),-- Enria
(21061,5000,1,1,2,191),-- Recipe: Sword of Damascus (60%)
(21061,5422,1,1,2,243),-- Recipe: Sealed Majestic Plate Armor(60%)
(21061,8730,1,1,200,2778),-- Life Stone: level 67
(21061,8740,1,1,200,694),-- Mid-Grade Life Stone: level 67
(21061,8750,1,1,200,70),-- High-Grade Life Stone: level 67
(21061,8760,1,1,200,14),-- Top-Grade Life Stone: level 67
(21063,1807,1,1,-1,29195),-- Recipe: Soulshot: A-Grade
(21063,5220,1,1,-1,875838),-- Metal Hardener
(21063,5478,1,1,-1,184123),-- Sealed Dark Crystal Leather Armor Pattern
(21063,57,8659,17618,0,700000),-- Adena
(21063,5287,1,1,1,61),-- Sealed Dark Crystal breastplate
(21063,5288,1,1,1,97),-- Sealed Dark Crystal Gaiters
(21063,5293,1,1,1,37),-- Sealed Tallum Plate Armor
(21063,5520,1,1,1,6952),-- Sealed Dark Crystal Breastplate Pattern
(21063,5521,1,1,1,4905),-- Sealed Tallum Plate Armor Pattern
(21063,5524,1,1,1,10625),-- Sealed Dark Crystal Gaiters Pattern
(21063,729,1,1,2,60),-- Scroll: Enchant Weapon (Grade A)
(21063,1864,4,12,2,134744),-- Stem
(21063,1865,2,6,2,107796),-- Varnish
(21063,1866,3,9,2,59887),-- Suede
(21063,1868,10,30,2,51331),-- Thread
(21063,1873,4,12,2,26949),-- Silver Nugget
(21063,8314,1,1,2,294),-- Recipe: Spiritual Eye (60%)
(21063,5281,1,1,2,719),-- Recipe: Greater Blessed Spiritshot (A) Compressed Package(100%)
(21063,8730,1,1,200,5988),-- Life Stone: level 67
(21063,8740,1,1,200,1497),-- Mid-Grade Life Stone: level 67
(21063,8750,1,1,200,150),-- High-Grade Life Stone: level 67
(21063,8760,1,1,200,30),-- Top-Grade Life Stone: level 67
(21064,4119,1,1,-1,39452),-- Demon Dagger Edge
(21064,5230,1,1,-1,12018),-- Recipe: Mithril Arrow (100%)
(21064,5479,1,1,-1,53333),-- Sealed Tallum Leather Armor Pattern
(21064,57,4448,9066,0,700000),-- Adena
(21064,5287,1,1,1,31),-- Sealed Dark Crystal breastplate
(21064,5288,1,1,1,50),-- Sealed Dark Crystal Gaiters
(21064,5293,1,1,1,19),-- Sealed Tallum Plate Armor
(21064,5520,1,1,1,3577),-- Sealed Dark Crystal Breastplate Pattern
(21064,5521,1,1,1,2534),-- Sealed Tallum Plate Armor Pattern
(21064,5524,1,1,1,5467),-- Sealed Dark Crystal Gaiters Pattern
(21064,1344,40,120,2,86667),-- Mithril Arrow
(21064,1867,1,3,2,123259),-- Animal Skin
(21064,1872,1,3,2,184889),-- Animal Bone
(21064,1875,1,1,2,18489),-- Stone of Purity
(21064,1881,1,1,2,36978),-- Coarse Bone Powder
(21064,4041,1,1,2,2411),-- Mold Hardener
(21064,4130,1,1,2,4502),-- Recipe: Ring of Black Ore
(21064,4403,1,1,2,554),-- Red Dimensional Stone
(21064,8730,1,1,200,3081),-- Life Stone: level 67
(21064,8740,1,1,200,771),-- Mid-Grade Life Stone: level 67
(21064,8750,1,1,200,77),-- High-Grade Life Stone: level 67
(21064,8760,1,1,200,15),-- Top-Grade Life Stone: level 67
(21065,1807,1,1,-1,13539),-- Recipe: Soulshot: A-Grade
(21065,4120,1,1,-1,44373),-- Bellion Cestus Edge
(21065,57,5007,10224,0,700000),-- Adena
(21065,5290,1,1,1,105),-- Sealed Dark Crystal Gloves
(21065,5291,1,1,1,105),-- Sealed Dark Crystal Boots
(21065,5295,1,1,1,105),-- Sealed Tallum Gloves
(21065,5296,1,1,1,105),-- Sealed Tallum Boots
(21065,5496,1,1,1,10990),-- Sealed Dark Crystal Boots Lining
(21065,5497,1,1,1,10990),-- Sealed Tallum Boots Lining
(21065,5508,1,1,1,10990),-- Sealed Dark Crystal Gloves Design
(21065,5509,1,1,1,10990),-- Sealed Tallum Gloves Design
(21065,1867,1,3,2,151489),-- Animal Skin
(21065,1872,1,3,2,227234),-- Animal Bone
(21065,1875,1,1,2,22723),-- Stone of Purity
(21065,1881,1,1,2,45447),-- Coarse Bone Powder
(21065,4041,1,1,2,2964),-- Mold Hardener
(21065,4164,1,1,2,2257),-- Recipe: Stockings of Doom
(21065,4401,1,1,2,682),-- Green Dimensional Stone
(21065,8730,1,1,200,3787),-- Life Stone: level 67
(21065,8740,1,1,200,947),-- Mid-Grade Life Stone: level 67
(21065,8750,1,1,200,95),-- High-Grade Life Stone: level 67
(21065,8760,1,1,200,19),-- Top-Grade Life Stone: level 67
(21066,4081,1,1,-1,100730),-- Doom Plate Armor Temper
(21066,5230,1,1,-1,13627),-- Recipe: Mithril Arrow (100%)
(21066,5482,1,1,-1,134892),-- Sealed Dark Crystalline Leggings Design
(21066,57,5047,10276,0,700000),-- Adena
(21066,5289,1,1,1,94),-- Sealed Dark Crystal Helmet
(21066,5292,1,1,1,135),-- Sealed Dark Crystal Shield
(21066,5294,1,1,1,94),-- Sealed Tallum Helmet
(21066,5494,1,1,1,13208),-- Sealed Dark Crystal Shield Fragment
(21066,5525,1,1,1,9721),-- Sealed Dark Crystal Helmet Design
(21066,5526,1,1,1,9721),-- Sealed Tallum Helm Design
(21066,729,1,1,2,35),-- Scroll: Enchant Weapon (Grade A)
(21066,1868,3,9,2,104821),-- Thread
(21066,1873,1,1,2,125786),-- Silver Nugget
(21066,1889,1,1,2,20964),-- Compound Braid
(21066,4044,1,1,2,10482),-- Thons
(21066,4613,1,1,2,434),-- Greater Dye of Strength <Str+4 Con-4>
(21066,5549,1,1,2,31446),-- Metallic Thread
(21066,6671,1,1,2,34940),-- Deluxe Chest Key - Grade 7
(21066,8731,1,1,200,2912),-- Life Stone: level 70
(21066,8741,1,1,200,728),-- Mid-Grade Life Stone: level 70
(21066,8751,1,1,200,73),-- High-Grade Life Stone: level 70
(21066,8761,1,1,200,15),-- Top-Grade Life Stone: level 70
(21068,3035,1,1,-1,32034),-- Recipe: Spiritshot A
(21068,5479,1,1,-1,142264),-- Sealed Tallum Leather Armor Pattern
(21068,5485,1,1,-1,202033),-- Sealed Tallum Tunic Texture
(21068,57,11856,24167,0,700000),-- Adena
(21068,5287,1,1,1,83),-- Sealed Dark Crystal breastplate
(21068,5288,1,1,1,133),-- Sealed Dark Crystal Gaiters
(21068,5293,1,1,1,51),-- Sealed Tallum Plate Armor
(21068,5520,1,1,1,9535),-- Sealed Dark Crystal Breastplate Pattern
(21068,5521,1,1,1,6728),-- Sealed Tallum Plate Armor Pattern
(21068,5524,1,1,1,14574),-- Sealed Dark Crystal Gaiters Pattern
(21068,729,1,1,2,90),-- Scroll: Enchant Weapon (Grade A)
(21068,1867,12,36,2,44803),-- Animal Skin
(21068,1869,18,54,2,22402),-- Iron Ore
(21068,1870,2,6,2,161291),-- Coal
(21068,1871,3,9,2,134409),-- Charcoal
(21068,1872,7,21,2,76805),-- Animal Bone
(21068,4402,1,1,2,1613),-- Blue Dimensional Stone
(21068,8731,1,1,200,7467),-- Life Stone: level 70
(21068,8741,1,1,200,1867),-- Mid-Grade Life Stone: level 70
(21068,8751,1,1,200,187),-- High-Grade Life Stone: level 70
(21068,8761,1,1,200,37),-- Top-Grade Life Stone: level 70
(21069,3035,1,1,-1,17234),-- Recipe: Spiritshot A
(21069,4041,1,1,-1,112359),-- Mold Hardener
(21069,4080,1,1,-1,265874),-- Blue Wolf Gaiters Material
(21069,57,6379,13001,0,700000),-- Adena
(21069,5290,1,1,1,134),-- Sealed Dark Crystal Gloves
(21069,5291,1,1,1,134),-- Sealed Dark Crystal Boots
(21069,5295,1,1,1,134),-- Sealed Tallum Gloves
(21069,5296,1,1,1,134),-- Sealed Tallum Boots
(21069,5496,1,1,1,13989),-- Sealed Dark Crystal Boots Lining
(21069,5497,1,1,1,13989),-- Sealed Tallum Boots Lining
(21069,5508,1,1,1,13989),-- Sealed Dark Crystal Gloves Design
(21069,5509,1,1,1,13989),-- Sealed Tallum Gloves Design
(21069,729,1,1,2,44),-- Scroll: Enchant Weapon (Grade A)
(21069,1866,1,1,2,265137),-- Suede
(21069,1871,1,3,2,198853),-- Charcoal
(21069,1877,1,1,2,15908),-- Adamantite Nugget
(21069,4040,1,1,2,7954),-- Mold Lubricant
(21069,4041,1,1,2,3458),-- Mold Hardener
(21069,5422,1,1,2,386),-- Recipe: Sealed Majestic Plate Armor(60%)
(21069,4619,1,1,2,549),-- Greater Dye of Intelligence <Int+4 Men-4>
(21069,8731,1,1,200,3682),-- Life Stone: level 70
(21069,8741,1,1,200,920),-- Mid-Grade Life Stone: level 70
(21069,8751,1,1,200,92),-- High-Grade Life Stone: level 70
(21069,8761,1,1,200,19),-- Top-Grade Life Stone: level 70
(21071,5156,1,1,-1,33312),-- Recipe: Soulshot (A) Compressed Package (100%)
(21071,5486,1,1,-1,147834),-- Sealed Dark Crystal Robe Fabric
(21071,5489,1,1,-1,329765),-- Sealed Tallum Stockings Fabric
(21071,57,12324,25146,0,700000),-- Adena
(21071,5297,1,1,1,115),-- Sealed Dark Crystal Leather Armor
(21071,5298,1,1,1,184),-- Sealed Dark Crystalline Leggings
(21071,5301,1,1,1,71),-- Sealed Tallum Leather Armor
(21071,5478,1,1,1,12928),-- Sealed Dark Crystal Leather Armor Pattern
(21071,5479,1,1,1,9097),-- Sealed Tallum Leather Armor Pattern
(21071,5482,1,1,1,20291),-- Sealed Dark Crystalline Leggings Design
(21071,729,1,1,2,102),-- Scroll: Enchant Weapon (Grade A)
(21071,1894,1,1,2,32368),-- Crafted Leather
(21071,4039,1,1,2,30749),-- Mold Glue
(21071,4041,1,1,2,8022),-- Mold Hardener
(21071,4044,1,1,2,30749),-- Thons
(21071,4403,1,1,2,1845),-- Red Dimensional Stone
(21071,8731,1,1,200,8542),-- Life Stone: level 70
(21071,8741,1,1,200,2135),-- Mid-Grade Life Stone: level 70
(21071,8751,1,1,200,214),-- High-Grade Life Stone: level 70
(21071,8761,1,1,200,43),-- Top-Grade Life Stone: level 70
(21072,4083,1,1,-1,119814),-- Leather Armor of Doom Design
(21072,5161,1,1,-1,14138),-- Recipe: Spiritshot (A) Compressed Package (100%)
(21072,5230,1,1,-1,14138),-- Recipe: Mithril Arrow (100%)
(21072,57,5231,10672,0,700000),-- Adena
(21072,5289,1,1,1,98),-- Sealed Dark Crystal Helmet
(21072,5292,1,1,1,140),-- Sealed Dark Crystal Shield
(21072,5294,1,1,1,98),-- Sealed Tallum Helmet
(21072,5494,1,1,1,13703),-- Sealed Dark Crystal Shield Fragment
(21072,5525,1,1,1,10086),-- Sealed Dark Crystal Helmet Design
(21072,5526,1,1,1,10086),-- Sealed Tallum Helm Design
(21072,1868,3,9,2,118641),-- Thread
(21072,1873,1,1,2,142370),-- Silver Nugget
(21072,1889,1,1,2,23728),-- Compound Braid
(21072,4044,1,1,2,11864),-- Thons
(21072,4403,1,1,2,712),-- Red Dimensional Stone
(21072,4984,1,1,2,1008),-- Recipe: Blue Wolf Leather Armor (60%)
(21072,5549,1,1,2,35592),-- Metallic Thread
(21072,8731,1,1,200,3295),-- Life Stone: level 70
(21072,8741,1,1,200,824),-- Mid-Grade Life Stone: level 70
(21072,8751,1,1,200,83),-- High-Grade Life Stone: level 70
(21072,8761,1,1,200,16),-- Top-Grade Life Stone: level 70
(21073,4052,1,1,-1,205074),-- Earring of Black Ore Piece
(21073,5230,1,1,-1,7723),-- Recipe: Mithril Arrow (100%)
(21073,57,2300,4651,0,700000),-- Adena
(21073,287,1,1,1,17),-- Bow of Peril
(21073,4121,1,1,1,3726),-- Bow of Peril Shaft
(21073,1830,1,1,2,62217),-- Scroll of Escape: Castle
(21073,1864,1,3,2,155542),-- Stem
(21073,1869,1,1,2,155542),-- Iron Ore
(21073,1880,1,1,2,15554),-- Steel
(21073,4043,1,1,2,5185),-- Asofe
(21073,5276,1,1,2,207),-- Recipe: Greater Spiritshot (A) Compressed Package(100%)
(21073,5550,1,1,2,2074),-- Durable Metal Plate
(21073,8729,1,1,200,2074),-- Life Stone: level 64
(21073,8739,1,1,200,519),-- Mid-Grade Life Stone: level 64
(21073,8749,1,1,200,52),-- High-Grade Life Stone: level 64
(21073,8759,1,1,200,11),-- Top-Grade Life Stone: level 64
(21074,1874,1,1,-1,402961),-- Oriharukon Ore
(21074,5478,1,1,-1,50828),-- Sealed Dark Crystal Leather Armor Pattern
(21074,5482,1,1,-1,79779),-- Sealed Dark Crystalline Leggings Design
(21074,57,2981,6086,0,700000),-- Adena
(21074,5290,1,1,1,63),-- Sealed Dark Crystal Gloves
(21074,5291,1,1,1,63),-- Sealed Dark Crystal Boots
(21074,5295,1,1,1,63),-- Sealed Tallum Gloves
(21074,5296,1,1,1,63),-- Sealed Tallum Boots
(21074,5496,1,1,1,6542),-- Sealed Dark Crystal Boots Lining
(21074,5497,1,1,1,6542),-- Sealed Tallum Boots Lining
(21074,5508,1,1,1,6542),-- Sealed Dark Crystal Gloves Design
(21074,5509,1,1,1,6542),-- Sealed Tallum Gloves Design
(21074,730,1,1,2,169),-- Scroll: Enchant Armor (Grade A)
(21074,1865,1,1,2,202890),-- Varnish
(21074,1870,1,1,2,202890),-- Coal
(21074,1874,1,1,2,13526),-- Oriharukon Ore
(21074,4039,1,1,2,6763),-- Mold Glue
(21074,4043,1,1,2,6763),-- Asofe
(21074,5166,1,1,2,270),-- Recipe: Blessed Spiritshot (A) Compressed Package (100%)
(21074,8730,1,1,200,2254),-- Life Stone: level 67
(21074,8740,1,1,200,564),-- Mid-Grade Life Stone: level 67
(21074,8750,1,1,200,56),-- High-Grade Life Stone: level 67
(21074,8760,1,1,200,11),-- Top-Grade Life Stone: level 67
(21075,4041,1,1,-1,47511),-- Mold Hardener
(21075,4052,1,1,-1,193443),-- Earring of Black Ore Piece
(21075,4616,1,1,-1,7536),-- Greater Dye of Constitution <Con+4 Dex-4>
(21075,57,2167,4388,0,700000),-- Adena
(21075,601,1,1,1,65),-- Boots of Doom
(21075,2439,1,1,1,65),-- Blue Wolf Boots
(21075,2475,1,1,1,65),-- Doom Gloves
(21075,2487,1,1,1,65),-- Blue Wolf Gloves
(21075,4090,1,1,1,9057),-- Blue Wolf Boots Design
(21075,4091,1,1,1,9057),-- Doom Gloves Part
(21075,4096,1,1,1,9057),-- Blue Wolf Gloves Fabric
(21075,4099,1,1,1,9057),-- Doom Boots Part
(21075,1866,1,1,2,89662),-- Suede
(21075,1871,1,1,2,134493),-- Charcoal
(21075,1877,1,1,2,5380),-- Adamantite Nugget
(21075,4040,1,1,2,2690),-- Mold Lubricant
(21075,4041,1,1,2,1170),-- Mold Hardener
(21075,5005,1,1,2,103),-- Recipe: Demon Dagger (60%)
(21075,5418,1,1,2,199),-- Recipe: Sealed Tallum Plate Armor(60%)
(21075,5276,1,1,2,179),-- Recipe: Greater Spiritshot (A) Compressed Package(100%)
(21075,8729,1,1,200,1793),-- Life Stone: level 64
(21075,8739,1,1,200,448),-- Mid-Grade Life Stone: level 64
(21075,8749,1,1,200,45),-- High-Grade Life Stone: level 64
(21075,8759,1,1,200,9),-- Top-Grade Life Stone: level 64
(21076,4052,1,1,-1,189765),-- Earring of Black Ore Piece
(21076,4053,1,1,-1,229743),-- Ring of Black Ore Gemstone
(21076,5230,1,1,-1,7147),-- Recipe: Mithril Arrow (100%)
(21076,57,2126,4306,0,700000),-- Adena
(21076,2398,1,1,1,21),-- Blue Wolf Tunic
(21076,2399,1,1,1,21),-- Tunic of Doom
(21076,2403,1,1,1,34),-- Blue Wolf Stockings
(21076,2404,1,1,1,34),-- Stockings of Doom
(21076,4084,1,1,1,3441),-- Blue Wolf Tunic Fabric
(21076,4085,1,1,1,3441),-- Tunic of Doom Pattern
(21076,4086,1,1,1,4646),-- Blue Wolf Stockings Pattern
(21076,4087,1,1,1,4646),-- Stockings of Doom Pattern
(21076,1830,1,1,2,63330),-- Scroll of Escape: Castle
(21076,1866,1,1,2,105549),-- Suede
(21076,1871,1,1,2,158323),-- Charcoal
(21076,1877,1,1,2,6333),-- Adamantite Nugget
(21076,4040,1,1,2,3167),-- Mold Lubricant
(21076,4041,1,1,2,1377),-- Mold Hardener
(21076,8729,1,1,200,2111),-- Life Stone: level 64
(21076,8739,1,1,200,528),-- Mid-Grade Life Stone: level 64
(21076,8749,1,1,200,53),-- High-Grade Life Stone: level 64
(21076,8759,1,1,200,10),-- Top-Grade Life Stone: level 64
(21077,4041,1,1,-1,44335),-- Mold Hardener
(21077,4054,1,1,-1,100424),-- Necklace of Black Ore Beads
(21077,5230,1,1,-1,6798),-- Recipe: Mithril Arrow (100%)
(21077,57,2022,4096,0,700000),-- Adena
(21077,864,1,1,1,71),-- Earring of Black Ore
(21077,895,1,1,1,106),-- Ring of Black Ore
(21077,926,1,1,1,53),-- Necklace of Black Ore
(21077,4052,1,1,1,8886),-- Earring of Black Ore Piece
(21077,4053,1,1,1,10758),-- Ring of Black Ore Gemstone
(21077,4054,1,1,1,4944),-- Necklace of Black Ore Beads
(21077,1343,20,60,2,89645),-- Silver Arrow
(21077,1867,1,1,2,167336),-- Animal Skin
(21077,1872,1,1,2,167336),-- Animal Bone
(21077,1875,1,1,2,8367),-- Stone of Purity
(21077,1881,1,1,2,16734),-- Coarse Bone Powder
(21077,4041,1,1,2,1091),-- Mold Hardener
(21077,5230,1,1,2,167),-- Recipe: Mithril Arrow (100%)
(21077,5276,1,1,2,167),-- Recipe: Greater Spiritshot (A) Compressed Package(100%)
(21077,8729,1,1,200,1673),-- Life Stone: level 64
(21077,8739,1,1,200,419),-- Mid-Grade Life Stone: level 64
(21077,8749,1,1,200,42),-- High-Grade Life Stone: level 64
(21077,8759,1,1,200,8),-- Top-Grade Life Stone: level 64
(21078,3956,1,1,-1,9007),-- Recipe: Blessed Spiritshot A
(21078,4040,1,1,-1,135112),-- Mold Lubricant
(21078,5485,1,1,-1,56808),-- Sealed Tallum Tunic Texture
(21078,57,2672,5436,0,700000),-- Adena
(21078,5289,1,1,1,50),-- Sealed Dark Crystal Helmet
(21078,5292,1,1,1,71),-- Sealed Dark Crystal Shield
(21078,5294,1,1,1,50),-- Sealed Tallum Helmet
(21078,5494,1,1,1,6984),-- Sealed Dark Crystal Shield Fragment
(21078,5525,1,1,1,5141),-- Sealed Dark Crystal Helmet Design
(21078,5526,1,1,1,5141),-- Sealed Tallum Helm Design
(21078,1868,1,3,2,199550),-- Thread
(21078,1873,1,1,2,79820),-- Silver Nugget
(21078,1876,1,1,2,39910),-- Mithril Ore
(21078,1895,1,1,2,57014),-- Metallic Fiber
(21078,4042,1,1,2,3326),-- Enria
(21078,4175,1,1,2,3845),-- Recipe: Avadon Boots
(21078,8730,1,1,200,2217),-- Life Stone: level 67
(21078,8740,1,1,200,554),-- Mid-Grade Life Stone: level 67
(21078,8750,1,1,200,55),-- High-Grade Life Stone: level 67
(21078,8760,1,1,200,11),-- Top-Grade Life Stone: level 67
(21079,1895,1,3,-1,918483),-- Metallic Fiber
(21079,4042,1,1,-1,107156),-- Enria
(21079,5478,1,1,-1,54065),-- Sealed Dark Crystal Leather Armor Pattern
(21079,57,2545,5167,0,700000),-- Adena
(21079,5304,1,1,1,24),-- Sealed Tallum Tunic
(21079,5305,1,1,1,38),-- Sealed Tallum Stockings
(21079,5308,1,1,1,15),-- Sealed Dark Crystal Robe
(21079,5485,1,1,1,2662),-- Sealed Tallum Tunic Texture
(21079,5486,1,1,1,1873),-- Sealed Dark Crystal Robe Fabric
(21079,5489,1,1,1,4177),-- Sealed Tallum Stockings Fabric
(21079,730,1,1,2,144),-- Scroll: Enchant Armor (Grade A)
(21079,1868,1,3,2,172649),-- Thread
(21079,1873,1,1,2,69060),-- Silver Nugget
(21079,1876,1,1,2,34530),-- Mithril Ore
(21079,1895,1,1,2,49328),-- Metallic Fiber
(21079,4042,1,1,2,2877),-- Enria
(21079,5161,1,1,2,230),-- Recipe: Spiritshot (A) Compressed Package (100%)
(21079,8730,1,1,200,1918),-- Life Stone: level 67
(21079,8740,1,1,200,480),-- Mid-Grade Life Stone: level 67
(21079,8750,1,1,200,48),-- High-Grade Life Stone: level 67
(21079,8760,1,1,200,10),-- Top-Grade Life Stone: level 67
(21080,1807,1,1,-1,7923),-- Recipe: Soulshot: A-Grade
(21080,3035,1,1,-1,7923),-- Recipe: Spiritshot A
(21080,5479,1,1,-1,35162),-- Sealed Tallum Leather Armor Pattern
(21080,57,2352,4776,0,700000),-- Adena
(21080,6323,1,1,1,44),-- Sealed Phoenix Necklace
(21080,6324,1,1,1,58),-- Sealed Phoenix Earring
(21080,6325,1,1,1,87),-- Sealed Phoenix Ring
(21080,6341,1,1,1,8091),-- Sealed Phoenix Earring Gemstone
(21080,6343,1,1,1,6255),-- Sealed Phoenix Necklace Beads
(21080,6345,1,1,1,11191),-- Sealed Phoenix Ring Gemstone
(21080,1864,1,3,2,146273),-- Stem
(21080,1869,1,1,2,146273),-- Iron Ore
(21080,1878,1,1,2,58509),-- Braided Hemp
(21080,1884,1,1,2,90014),-- Cord
(21080,4039,1,1,2,4876),-- Mold Glue
(21080,5166,1,1,2,195),-- Recipe: Blessed Spiritshot (A) Compressed Package (100%)
(21080,8314,1,1,2,80),-- Recipe: Spiritual Eye (60%)
(21080,6036,1,1,2,4876),-- Greater Magic Haste Potion
(21080,8730,1,1,200,1625),-- Life Stone: level 67
(21080,8740,1,1,200,406),-- Mid-Grade Life Stone: level 67
(21080,8750,1,1,200,41),-- High-Grade Life Stone: level 67
(21080,8760,1,1,200,8),-- Top-Grade Life Stone: level 67
(21081,4119,1,1,-1,26385),-- Demon Dagger Edge
(21081,5230,1,1,-1,8037),-- Recipe: Mithril Arrow (100%)
(21081,5478,1,1,-1,50689),-- Sealed Dark Crystal Leather Armor Pattern
(21081,57,2973,6067,0,700000),-- Adena
(21081,5297,1,1,1,28),-- Sealed Dark Crystal Leather Armor
(21081,5298,1,1,1,44),-- Sealed Dark Crystalline Leggings
(21081,5301,1,1,1,17),-- Sealed Tallum Leather Armor
(21081,5478,1,1,1,3119),-- Sealed Dark Crystal Leather Armor Pattern
(21081,5479,1,1,1,2195),-- Sealed Tallum Leather Armor Pattern
(21081,5482,1,1,1,4896),-- Sealed Dark Crystalline Leggings Design
(21081,1867,1,1,2,296760),-- Animal Skin
(21081,1872,1,3,2,148380),-- Animal Bone
(21081,1875,1,1,2,14838),-- Stone of Purity
(21081,1881,1,1,2,29676),-- Coarse Bone Powder
(21081,4041,1,1,2,1935),-- Mold Hardener
(21081,4985,1,1,2,630),-- Recipe: Leather Armor of Doom (60%)
(21081,8731,1,1,200,2061),-- Life Stone: level 70
(21081,8741,1,1,200,515),-- Mid-Grade Life Stone: level 70
(21081,8751,1,1,200,51),-- High-Grade Life Stone: level 70
(21081,8761,1,1,200,11),-- Top-Grade Life Stone: level 70
(21082,5156,1,1,-1,7708),-- Recipe: Soulshot (A) Compressed Package (100%)
(21082,5482,1,1,-1,76302),-- Sealed Dark Crystalline Leggings Design
(21082,5486,1,1,-1,34207),-- Sealed Dark Crystal Robe Fabric
(21082,57,2853,5815,0,700000),-- Adena
(21082,5304,1,1,1,27),-- Sealed Tallum Tunic
(21082,5305,1,1,1,43),-- Sealed Tallum Stockings
(21082,5308,1,1,1,16),-- Sealed Dark Crystal Robe
(21082,5485,1,1,1,2991),-- Sealed Tallum Tunic Texture
(21082,5486,1,1,1,2105),-- Sealed Dark Crystal Robe Fabric
(21082,5489,1,1,1,4695),-- Sealed Tallum Stockings Fabric
(21082,1865,1,1,2,213452),-- Varnish
(21082,1870,1,1,2,213452),-- Coal
(21082,1875,1,1,2,14230),-- Stone of Purity
(21082,1879,1,1,2,35575),-- Cokes
(21082,4040,1,1,2,4269),-- Mold Lubricant
(21082,5281,1,1,2,284),-- Recipe: Greater Blessed Spiritshot (A) Compressed Package(100%)
(21082,8731,1,1,200,1976),-- Life Stone: level 70
(21082,8741,1,1,200,494),-- Mid-Grade Life Stone: level 70
(21082,8751,1,1,200,49),-- High-Grade Life Stone: level 70
(21082,8761,1,1,200,11),-- Top-Grade Life Stone: level 70
(21083,5156,1,1,-1,8052),-- Recipe: Soulshot (A) Compressed Package (100%)
(21083,5485,1,1,-1,50785),-- Sealed Tallum Tunic Texture
(21083,5486,1,1,-1,35736),-- Sealed Dark Crystal Robe Fabric
(21083,57,2980,6075,0,700000),-- Adena
(21083,6323,1,1,1,55),-- Sealed Phoenix Necklace
(21083,6324,1,1,1,74),-- Sealed Phoenix Earring
(21083,6325,1,1,1,111),-- Sealed Phoenix Ring
(21083,6341,1,1,1,10279),-- Sealed Phoenix Earring Gemstone
(21083,6343,1,1,1,7946),-- Sealed Phoenix Necklace Beads
(21083,6345,1,1,1,14217),-- Sealed Phoenix Ring Gemstone
(21083,730,1,1,2,169),-- Scroll: Enchant Armor (Grade A)
(21083,1807,1,1,2,270),-- Recipe: Soulshot: A-Grade
(21083,1866,1,1,2,135246),-- Suede
(21083,1871,1,1,2,202718),-- Charcoal
(21083,1885,1,1,2,16893),-- High Grade Suede
(21083,4041,1,1,2,1763),-- Mold Hardener
(21083,5220,1,1,2,8109),-- Metal Hardener
(21083,8731,1,1,200,1877),-- Life Stone: level 70
(21083,8741,1,1,200,469),-- Mid-Grade Life Stone: level 70
(21083,8751,1,1,200,47),-- High-Grade Life Stone: level 70
(21083,8761,1,1,200,9),-- Top-Grade Life Stone: level 70
(21084,4056,1,1,-1,90964),-- Zubei\'s Breastplate Part
(21084,4129,1,1,-1,54392),-- Recipe: Earrings of Black Ore
(21084,57,1988,4041,0,700000),-- Adena
(21084,78,1,1,1,7),-- Great Sword
(21084,142,1,1,1,7),-- Keshanberk
(21084,148,1,1,1,7),-- Sword of Valhalla
(21084,4104,1,1,1,1416),-- Great Sword Blade
(21084,4107,1,1,1,1394),-- Keshanberk Blade
(21084,4108,1,1,1,1394),-- Sword of Valhalla Blade
(21084,1832,1,1,2,126884),-- Greater Antidote
(21084,1868,1,1,2,228391),-- Thread
(21084,1873,1,1,2,45678),-- Silver Nugget
(21084,1889,1,1,2,7613),-- Compound Braid
(21084,4044,1,1,2,3806),-- Thons
(21084,4196,1,1,2,87),-- Recipe: Staff of Evil Spirits
(21084,4402,1,1,2,228),-- Blue Dimensional Stone
(21084,5002,1,1,2,87),-- Recipe: Deadman\'s Glory (60%)
(21084,5549,1,1,2,11420),-- Metallic Thread
(21084,8728,1,1,200,1903),-- Life Stone: level 61
(21084,8738,1,1,200,476),-- Mid-Grade Life Stone: level 61
(21084,8748,1,1,200,48),-- High-Grade Life Stone: level 61
(21084,8758,1,1,200,9),-- Top-Grade Life Stone: level 61
(21085,1889,1,1,-1,623779),-- Compound Braid
(21085,5479,1,1,-1,55365),-- Sealed Tallum Leather Armor Pattern
(21085,5489,1,1,-1,123496),-- Sealed Tallum Stockings Fabric
(21085,57,4617,9411,0,700000),-- Adena
(21085,5297,1,1,1,43),-- Sealed Dark Crystal Leather Armor
(21085,5298,1,1,1,69),-- Sealed Dark Crystalline Leggings
(21085,5301,1,1,1,27),-- Sealed Tallum Leather Armor
(21085,5478,1,1,1,4841),-- Sealed Dark Crystal Leather Armor Pattern
(21085,5479,1,1,1,3407),-- Sealed Tallum Leather Armor Pattern
(21085,5482,1,1,1,7599),-- Sealed Dark Crystalline Leggings Design
(21085,1868,3,9,2,104690),-- Thread
(21085,1873,1,1,2,125628),-- Silver Nugget
(21085,1889,1,1,2,20938),-- Compound Braid
(21085,4044,1,1,2,10469),-- Thons
(21085,4131,1,1,2,2553),-- Recipe: Necklace of Black Ore
(21085,5549,1,1,2,31407),-- Metallic Thread
(21085,6036,1,1,2,10470),-- Greater Magic Haste Potion
(21085,8730,1,1,200,3490),-- Life Stone: level 67
(21085,8740,1,1,200,873),-- Mid-Grade Life Stone: level 67
(21085,8750,1,1,200,87),-- High-Grade Life Stone: level 67
(21085,8760,1,1,200,17),-- Top-Grade Life Stone: level 67
(21086,1807,1,1,-1,12483),-- Recipe: Soulshot: A-Grade
(21086,1895,1,5,-1,891673),-- Metallic Fiber
(21086,5482,1,1,-1,123574),-- Sealed Dark Crystalline Leggings Design
(21086,57,4617,9427,0,700000),-- Adena
(21086,5287,1,1,1,32),-- Sealed Dark Crystal breastplate
(21086,5288,1,1,1,52),-- Sealed Dark Crystal Gaiters
(21086,5293,1,1,1,20),-- Sealed Tallum Plate Armor
(21086,5520,1,1,1,3716),-- Sealed Dark Crystal Breastplate Pattern
(21086,5521,1,1,1,2622),-- Sealed Tallum Plate Armor Pattern
(21086,5524,1,1,1,5679),-- Sealed Dark Crystal Gaiters Pattern
(21086,1895,1,1,2,98770),-- Metallic Fiber
(21086,4040,1,1,2,6914),-- Mold Lubricant
(21086,4042,1,1,2,5762),-- Enria
(21086,4043,1,1,2,11523),-- Asofe
(21086,4166,1,1,2,2857),-- Recipe: Doom Helmet
(21086,4401,1,1,2,691),-- Green Dimensional Stone
(21086,8730,1,1,200,3841),-- Life Stone: level 67
(21086,8740,1,1,200,960),-- Mid-Grade Life Stone: level 67
(21086,8750,1,1,200,96),-- High-Grade Life Stone: level 67
(21086,8760,1,1,200,19),-- Top-Grade Life Stone: level 67
(21087,1894,1,1,-1,455851),-- Crafted Leather
(21087,4082,1,1,-1,146799),-- Blue Wolf Leather Armor Texture
(21087,5494,1,1,-1,272850),-- Sealed Dark Crystal Shield Fragment
(21087,57,6416,13062,0,700000),-- Adena
(21087,5287,1,1,1,45),-- Sealed Dark Crystal breastplate
(21087,5288,1,1,1,72),-- Sealed Dark Crystal Gaiters
(21087,5293,1,1,1,28),-- Sealed Tallum Plate Armor
(21087,5520,1,1,1,5156),-- Sealed Dark Crystal Breastplate Pattern
(21087,5521,1,1,1,3638),-- Sealed Tallum Plate Armor Pattern
(21087,5524,1,1,1,7881),-- Sealed Dark Crystal Gaiters Pattern
(21087,729,1,1,2,41),-- Scroll: Enchant Weapon (Grade A)
(21087,1864,5,15,2,73799),-- Stem
(21087,1869,2,6,2,92249),-- Iron Ore
(21087,1880,1,1,2,36900),-- Steel
(21087,4043,1,1,2,12300),-- Asofe
(21087,4614,1,1,2,509),-- Greater Dye of Strength <Str+4 Dex-4>
(21087,5550,1,1,2,4920),-- Durable Metal Plate
(21087,6037,9,27,2,41000),-- Waking Scroll
(21087,6671,1,1,2,41000),-- Deluxe Chest Key - Grade 7
(21087,8731,1,1,200,3417),-- Life Stone: level 70
(21087,8741,1,1,200,854),-- Mid-Grade Life Stone: level 70
(21087,8751,1,1,200,85),-- High-Grade Life Stone: level 70
(21087,8761,1,1,200,17),-- Top-Grade Life Stone: level 70
(21088,4042,1,1,-1,165717),-- Enria
(21088,5338,1,1,-1,12863),-- Recipe: Sealed Majestic Leather Armor(60%)
(21088,5485,1,1,-1,83611),-- Sealed Tallum Tunic Texture
(21088,57,4907,10001,0,700000),-- Adena
(21088,5304,1,1,1,46),-- Sealed Tallum Tunic
(21088,5305,1,1,1,73),-- Sealed Tallum Stockings
(21088,5308,1,1,1,28),-- Sealed Dark Crystal Robe
(21088,5485,1,1,1,5145),-- Sealed Tallum Tunic Texture
(21088,5486,1,1,1,3620),-- Sealed Dark Crystal Robe Fabric
(21088,5489,1,1,1,8075),-- Sealed Tallum Stockings Fabric
(21088,1868,3,9,2,122376),-- Thread
(21088,1873,1,1,2,146851),-- Silver Nugget
(21088,1876,1,1,2,73426),-- Mithril Ore
(21088,1895,1,1,2,104894),-- Metallic Fiber
(21088,4042,1,1,2,6119),-- Enria
(21088,4986,1,1,2,1523),-- Recipe: Blue Wolf Tunic (60%)
(21088,8731,1,1,200,3399),-- Life Stone: level 70
(21088,8741,1,1,200,850),-- Mid-Grade Life Stone: level 70
(21088,8751,1,1,200,85),-- High-Grade Life Stone: level 70
(21088,8761,1,1,200,17),-- Top-Grade Life Stone: level 70
(21089,3035,1,1,-1,15413),-- Recipe: Spiritshot A
(21089,4116,1,1,-1,50514),-- Deadman\'s Glory Stone
(21089,5480,1,1,-1,51871),-- Sealed Leather Armor of Nightmare Fabric
(21089,57,5702,11635,0,700000),-- Adena
(21089,5304,1,1,1,53),-- Sealed Tallum Tunic
(21089,5305,1,1,1,85),-- Sealed Tallum Stockings
(21089,5308,1,1,1,33),-- Sealed Dark Crystal Robe
(21089,5485,1,1,1,5981),-- Sealed Tallum Tunic Texture
(21089,5486,1,1,1,4209),-- Sealed Dark Crystal Robe Fabric
(21089,5489,1,1,1,9388),-- Sealed Tallum Stockings Fabric
(21089,1868,3,9,2,142275),-- Thread
(21089,1873,2,6,2,42682),-- Silver Nugget
(21089,1876,1,1,2,85365),-- Mithril Ore
(21089,1895,1,1,2,121950),-- Metallic Fiber
(21089,4042,1,1,2,7114),-- Enria
(21089,4986,1,1,2,1771),-- Recipe: Blue Wolf Tunic (60%)
(21089,8731,1,1,200,3952),-- Life Stone: level 70
(21089,8741,1,1,200,988),-- Mid-Grade Life Stone: level 70
(21089,8751,1,1,200,99),-- High-Grade Life Stone: level 70
(21089,8761,1,1,200,20),-- Top-Grade Life Stone: level 70
(21090,5156,1,1,-1,11849),-- Recipe: Soulshot (A) Compressed Package (100%)
(21090,5230,1,1,-1,11849),-- Recipe: Mithril Arrow (100%)
(21090,5486,1,1,-1,52583),-- Sealed Dark Crystal Robe Fabric
(21090,57,4384,8944,0,700000),-- Adena
(21090,5287,1,1,1,31),-- Sealed Dark Crystal breastplate
(21090,5288,1,1,1,49),-- Sealed Dark Crystal Gaiters
(21090,5293,1,1,1,19),-- Sealed Tallum Plate Armor
(21090,5520,1,1,1,3527),-- Sealed Dark Crystal Breastplate Pattern
(21090,5521,1,1,1,2488),-- Sealed Tallum Plate Armor Pattern
(21090,5524,1,1,1,5390),-- Sealed Dark Crystal Gaiters Pattern
(21090,730,1,1,2,228),-- Scroll: Enchant Armor (Grade A)
(21090,1344,20,60,2,170894),-- Mithril Arrow
(21090,1866,1,1,2,182287),-- Suede
(21090,1871,1,3,2,91144),-- Charcoal
(21090,1877,1,1,2,10937),-- Adamantite Nugget
(21090,4040,1,1,2,5469),-- Mold Lubricant
(21090,4041,1,1,2,2378),-- Mold Hardener
(21090,4401,1,1,2,547),-- Green Dimensional Stone
(21090,8731,1,1,200,2532),-- Life Stone: level 70
(21090,8741,1,1,200,633),-- Mid-Grade Life Stone: level 70
(21090,8751,1,1,200,63),-- High-Grade Life Stone: level 70
(21090,8761,1,1,200,13),-- Top-Grade Life Stone: level 70
(21091,3035,1,1,-1,7965),-- Recipe: Spiritshot A
(21091,5479,1,1,-1,35349),-- Sealed Tallum Leather Armor Pattern
(21091,5336,1,1,-1,7728),-- Recipe: Sealed Leather Armor of Nightmare(60%)
(21091,57,2948,6009,0,700000),-- Adena
(21091,5297,1,1,1,28),-- Sealed Dark Crystal Leather Armor
(21091,5298,1,1,1,44),-- Sealed Dark Crystalline Leggings
(21091,5301,1,1,1,17),-- Sealed Tallum Leather Armor
(21091,5478,1,1,1,3091),-- Sealed Dark Crystal Leather Armor Pattern
(21091,5479,1,1,1,2175),-- Sealed Tallum Leather Armor Pattern
(21091,5482,1,1,1,4852),-- Sealed Dark Crystalline Leggings Design
(21091,1867,1,3,2,210073),-- Animal Skin
(21091,1872,1,3,2,140048),-- Animal Bone
(21091,1882,1,1,2,70024),-- Leather
(21091,1894,1,1,2,11056),-- Crafted Leather
(21091,3035,1,1,2,420),-- Recipe: Spiritshot A
(21091,4042,1,1,2,5252),-- Enria
(21091,10306,1,1,2,1261),-- Transform Sealbook - Doll Blader
(21092,5161,1,1,-1,7782),-- Recipe: Spiritshot (A) Compressed Package (100%)
(21092,5478,1,1,-1,49077),-- Sealed Dark Crystal Leather Armor Pattern
(21092,5485,1,1,-1,49077),-- Sealed Tallum Tunic Texture
(21092,57,2880,5870,0,700000),-- Adena
(21092,5289,1,1,1,54),-- Sealed Dark Crystal Helmet
(21092,5292,1,1,1,77),-- Sealed Dark Crystal Shield
(21092,5294,1,1,1,54),-- Sealed Tallum Helmet
(21092,5494,1,1,1,7542),-- Sealed Dark Crystal Shield Fragment
(21092,5525,1,1,1,5551),-- Sealed Dark Crystal Helmet Design
(21092,5526,1,1,1,5551),-- Sealed Tallum Helm Design
(21092,1344,30,90,2,112235),-- Mithril Arrow
(21092,1868,4,12,2,67341),-- Thread
(21092,1873,1,1,2,107745),-- Silver Nugget
(21092,1889,1,1,2,17958),-- Compound Braid
(21092,3956,1,1,2,359),-- Recipe: Blessed Spiritshot A
(21092,4044,1,1,2,8979),-- Thons
(21092,5549,1,1,2,26936),-- Metallic Thread
(21092,10306,1,1,2,1078),-- Transform Sealbook - Doll Blader
(21093,1800,1,1,-1,83774),-- Recipe: Piece Bone Breastplate
(21093,1864,1,1,-1,532802),-- Stem
(21093,1897,1,1,-1,63429),-- Necklace of Wisdom Chain
(21093,57,125,213,0,700000),-- Adena
(21093,2,1,1,1,75),-- Long Sword
(21093,120,1,1,1,75),-- Sword of Reflection
(21093,121,1,1,1,75),-- Sword of Watershadow
(21093,2012,1,1,1,820),-- Sword of Reflection Blade
(21093,1801,1,1,2,19822),-- Recipe: Piece Bone Gaiters
(21093,1864,1,1,2,78691),-- Stem
(21093,1869,1,1,2,39346),-- Iron Ore
(21093,1878,1,1,2,15739),-- Braided Hemp
(21094,734,1,1,-1,45036),-- Haste Potion
(21094,1870,1,1,-1,270215),-- Coal
(21094,1924,1,1,-1,87166),-- Leather Helmet Design
(21094,57,125,217,0,700000),-- Adena
(21094,176,1,1,1,152),-- Journeyman\'s Staff
(21094,2501,1,1,1,152),-- Bone Club
(21094,1865,1,1,2,39909),-- Varnish
(21094,1870,1,1,2,39909),-- Coal
(21094,1879,1,1,2,6652),-- Cokes
(21094,2141,1,1,2,7982),-- Recipe: Silver Mold
(21095,1804,1,1,-1,15036),-- Recipe: Soulshot: D-Grade
(21095,1898,1,1,-1,38613),-- Blue Diamond Necklace Gem
(21095,2151,1,1,-1,104706),-- Recipe: Necklace of Devotion
(21095,57,171,306,0,700000),-- Adena
(21095,257,1,1,1,236),-- Viper\'s Fang
(21095,1804,1,1,2,2221),-- Recipe: Soulshot: D-Grade
(21095,1831,1,1,2,148044),-- Antidote
(21095,1865,1,1,2,55517),-- Varnish
(21095,1870,1,1,2,55517),-- Coal
(21096,1866,1,1,-1,246245),-- Suede
(21096,1871,1,1,-1,369368),-- Charcoal
(21096,1926,1,1,-1,37310),-- Piece Bone Breastplate Fragment
(21096,57,168,301,0,700000),-- Adena
(21096,39,1,1,1,1531),-- Boots
(21096,51,1,1,1,1531),-- Bracer
(21096,1930,1,1,1,18650),-- Boot Lining
(21096,1866,1,1,2,48491),-- Suede
(21096,1871,1,1,2,72737),-- Charcoal
(21096,2179,1,1,2,34802),-- Recipe: Crafted Leather Gloves
(21097,1927,1,1,-1,33847),-- Hard Leather Shirt Pattern
(21097,1928,1,1,-1,61803),-- Piece Bone Gaiters Fragment
(21097,2176,1,1,-1,203004),-- Recipe: Leather Boots
(21097,57,194,343,0,700000),-- Adena
(21097,846,1,1,1,1019),-- Coral Earring
(21097,878,1,1,1,1528),-- Blue Coral Ring
(21097,909,1,1,1,764),-- Blue Diamond Necklace
(21097,1898,1,1,1,6437),-- Blue Diamond Necklace Gem
(21097,734,1,1,2,8355),-- Haste Potion
(21097,1831,1,1,2,133680),-- Antidote
(21097,1865,1,1,2,50130),-- Varnish
(21097,1870,1,1,2,50130),-- Coal
(21097,2257,1,1,2,1226),-- Recipe: Trident
(21098,1879,1,1,-1,66565),-- Cokes
(21098,1929,1,1,-1,51534),-- Hard Leather Gaiters Material
(21098,2177,1,1,-1,127600),-- Recipe: Bone Helmet
(21098,57,177,327,0,700000),-- Adena
(21098,16,1,1,1,251),-- Long Spear
(21098,1865,1,1,2,58987),-- Varnish
(21098,1870,1,1,2,58987),-- Coal
(21098,1879,1,1,2,9831),-- Cokes
(21098,5158,1,1,2,2359),-- Recipe: Spiritshot (D) Compressed Package (100%)
(21099,1875,1,1,-1,28539),-- Stone of Purity
(21099,1899,1,1,-1,66888),-- Necklace of Devotion Chain
(21099,2152,1,1,-1,75366),-- Recipe: Enchanted Necklace
(21099,57,188,353,0,700000),-- Adena
(21099,45,1,1,1,665),-- Bone Helmet
(21099,626,1,1,1,948),-- Bronze Shield
(21099,1932,1,1,1,12712),-- Bone Helmet Design
(21099,1875,1,1,2,3203),-- Stone of Purity
(21099,1879,1,1,2,8008),-- Cokes
(21099,2152,1,1,2,8460),-- Recipe: Enchanted Necklace
(21099,8294,1,1,2,1175),-- Recipe: Steel Sword (100%)
(21099,5549,1,1,2,4805),-- Metallic Thread
(21100,1800,1,1,-1,83774),-- Recipe: Piece Bone Breastplate
(21100,1897,1,1,-1,63429),-- Necklace of Wisdom Chain
(21100,1924,1,1,-1,85936),-- Leather Helmet Design
(21100,57,125,213,0,700000),-- Adena
(21100,845,1,1,1,1150),-- Cat\'s Eye Earring
(21100,877,1,1,1,1726),-- Ring of Wisdom
(21100,908,1,1,1,863),-- Necklace of Wisdom
(21100,1897,1,1,1,9369),-- Necklace of Wisdom Chain
(21100,1817,1,1,2,7870),-- Recipe: Cord
(21100,1864,1,1,2,78691),-- Stem
(21100,1869,1,1,2,39346),-- Iron Ore
(21100,1880,1,1,2,3935),-- Steel
(21101,1865,1,1,-1,399388),-- Varnish
(21101,1870,1,1,-1,399388),-- Coal
(21101,1898,1,1,-1,41026),-- Blue Diamond Necklace Gem
(21101,57,177,327,0,700000),-- Adena
(21101,39,1,1,1,1656),-- Boots
(21101,51,1,1,1,1656),-- Bracer
(21101,1930,1,1,1,20166),-- Boot Lining
(21101,1865,1,1,2,47189),-- Varnish
(21101,1870,1,1,2,47189),-- Coal
(21101,5163,1,1,2,1888),-- Recipe: Blessed Spiritshot (D) Compressed Package (100%)
(21101,6035,1,1,2,3932),-- Magic Haste Potion
(21101,6666,1,1,2,47189),-- Deluxe Chest Key - Grade 2
(21102,1900,1,1,-1,59256),-- Enchanted Necklace Chain
(21102,2153,1,1,-1,84230),-- Recipe: Tiger\'s Eye Earring
(21102,2183,1,1,-1,35631),-- Recipe: Mithril Banded Mail
(21102,57,228,457,0,700000),-- Adena
(21102,433,1,1,1,96),-- Elven Tunic
(21102,434,1,1,1,96),-- White Tunic
(21102,435,1,1,1,96),-- Mystic\'s Tunic
(21102,466,1,1,1,154),-- Elven Stockings
(21102,467,1,1,1,154),-- Dark Stockings
(21102,468,1,1,1,154),-- Mystic\'s Stockings
(21102,1933,1,1,1,4352),-- Dark Stocking Fabric
(21102,1936,1,1,1,3027),-- White Tunic Pattern
(21102,956,1,1,2,1644),-- Scroll: Enchant Armor (Grade D)
(21102,1874,1,1,2,3288),-- Oriharukon Ore
(21102,1878,1,1,2,19731),-- Braided Hemp
(21102,1884,1,1,2,30355),-- Cord
(21102,1889,1,1,2,3288),-- Compound Braid
(21102,5220,1,1,2,1973),-- Metal Hardener
(21103,955,1,1,-1,2256),-- Scroll: Enchant Weapon (Grade D)
(21103,1879,1,1,-1,94011),-- Cokes
(21103,1933,1,1,-1,66361),-- Dark Stocking Fabric
(21103,57,239,476,0,700000),-- Adena
(21103,348,1,1,1,150),-- Scale Mail
(21103,377,1,1,1,240),-- Scale Gaiters
(21103,1935,1,1,1,4305),-- Scale Mail Fragment
(21103,1937,1,1,1,6620),-- Scale Gaiters Fragment
(21103,1061,1,1,2,26687),-- Healing Potion
(21103,1875,1,1,2,2936),-- Stone of Purity
(21103,1879,1,1,2,7339),-- Cokes
(21103,1885,1,1,2,3670),-- High Grade Suede
(21103,2185,1,1,2,8668),-- Recipe: Iron Boots
(21103,5549,1,1,2,4403),-- Metallic Thread
(21103,5550,1,1,2,587),-- Durable Metal Plate
(21104,1061,1,1,-1,426409),-- Healing Potion
(21104,1876,1,1,-1,140715),-- Mithril Ore
(21104,1935,1,1,-1,39306),-- Scale Mail Fragment
(21104,57,296,595,0,700000),-- Adena
(21104,605,1,1,1,1502),-- Leather Gauntlets
(21104,1123,1,1,1,1502),-- Blue Buckskin Boots
(21104,1876,1,1,2,10985),-- Mithril Ore
(21104,1877,1,1,2,2197),-- Adamantite Nugget
(21104,1880,1,1,2,5493),-- Steel
(21104,1881,1,1,2,7323),-- Coarse Bone Powder
(21104,1882,1,1,2,12206),-- Leather
(21104,2264,1,1,2,568),-- Recipe: Two-handed Sword
(21104,6667,1,1,2,34328),-- Deluxe Chest Key - Grade 3
(21105,1901,1,1,-1,111700),-- Tiger\'s Eye Earring Stone
(21105,2154,1,1,-1,86586),-- Recipe: Elven Earring
(21105,2155,1,1,-1,129809),-- Recipe: Elven Ring
(21105,57,342,683,0,700000),-- Adena
(21105,393,1,1,1,123),-- Mithril Banded Mail
(21105,394,1,1,1,123),-- Reinforced Leather Shirt
(21105,415,1,1,1,196),-- Mithril Banded Gaiters
(21105,416,1,1,1,196),-- Reinforced Leather Gaiters
(21105,1938,1,1,1,4818),-- Mithril Banded Mail Material
(21105,1939,1,1,1,6295),-- Mithril Banded Gaiters Material
(21105,1874,1,1,2,4778),-- Oriharukon Ore
(21105,1878,1,1,2,28666),-- Braided Hemp
(21105,1884,1,1,2,44101),-- Cord
(21105,1889,1,1,2,4778),-- Compound Braid
(21105,2154,1,1,2,7673),-- Recipe: Elven Earring
(21105,5220,1,1,2,2867),-- Metal Hardener
(21106,1885,1,1,-1,56785),-- High Grade Suede
(21106,1938,1,1,-1,45809),-- Mithril Banded Mail Material
(21106,5550,1,1,-1,9086),-- Durable Metal Plate
(21106,57,288,574,0,700000),-- Adena
(21106,47,1,1,1,618),-- Helmet
(21106,628,1,1,1,884),-- Hoplon
(21106,1341,10,30,2,150957),-- Bone Arrow
(21106,1875,1,1,2,3019),-- Stone of Purity
(21106,1879,1,1,2,7548),-- Cokes
(21106,1885,1,1,2,3774),-- High Grade Suede
(21106,2186,1,1,2,1515),-- Recipe: Brigandine Tunic
(21106,8317,1,1,2,324),-- Recipe: Titan Hammer (100%)
(21106,5549,1,1,2,4529),-- Metallic Thread
(21106,5550,1,1,2,604),-- Durable Metal Plate
(21107,1939,1,1,-1,126271),-- Mithril Banded Gaiters Material
(21107,1940,1,1,-1,214567),-- Iron Boots Design
(21107,2156,1,1,-1,115008),-- Recipe: Elven Necklace
(21107,57,607,1211,0,700000),-- Adena
(21107,260,1,1,1,206),-- Triple-Edged Jamadhr
(21107,1876,1,1,2,25479),-- Mithril Ore
(21107,1877,1,1,2,5096),-- Adamantite Nugget
(21107,1880,1,1,2,12739),-- Steel
(21107,1881,1,1,2,16986),-- Coarse Bone Powder
(21107,1882,1,1,2,28309),-- Leather
(21107,2188,1,1,2,9099),-- Recipe: Manticore Skin Gaiters
(21108,4052,1,1,-1,95871),-- Earring of Black Ore Piece
(21108,5230,1,1,-1,3610),-- Recipe: Mithril Arrow (100%)
(21108,5550,1,1,-1,36105),-- Durable Metal Plate
(21108,57,1068,2182,0,700000),-- Adena
(21108,12204,1,1,1,178),-- Common Item - Blue Wolf Breastplate
(21108,12193,1,1,1,284),-- Common Item - Blue Wolf Gaiters
(21108,12184,1,1,1,109),-- Common Item - Doom Plate Armor
(21108,4078,1,1,1,1947),-- Blue Wolf Breastplate Part
(21108,4080,1,1,1,2742),-- Blue Wolf Gaiters Material
(21108,4081,1,1,1,1314),-- Doom Plate Armor Temper
(21108,1864,1,1,2,145429),-- Stem
(21108,1869,1,1,2,72715),-- Iron Ore
(21108,1880,1,1,2,7272),-- Steel
(21108,4043,1,1,2,2424),-- Asofe
(21108,5230,1,1,2,97),-- Recipe: Mithril Arrow (100%)
(21108,8487,1,1,2,40),-- Recipe: Destroyer Hammer (60%)
(21108,5550,1,1,2,970),-- Durable Metal Plate
(21108,8730,1,1,200,808),-- Life Stone: level 67
(21108,8740,1,1,200,202),-- Mid-Grade Life Stone: level 67
(21108,8750,1,1,200,20),-- High-Grade Life Stone: level 67
(21108,8760,1,1,200,4),-- Top-Grade Life Stone: level 67
(21109,1874,1,1,-1,224175),-- Oriharukon Ore
(21109,4043,1,1,-1,112087),-- Asofe
(21109,5478,1,1,-1,28276),-- Sealed Dark Crystal Leather Armor Pattern
(21109,57,1330,2704,0,700000),-- Adena
(21109,12344,1,1,1,480),-- Common Item - Sealed Phoenix Necklace
(21109,12345,1,1,1,639),-- Common Item - Sealed Phoenix Earring
(21109,12346,1,1,1,960),-- Common Item - Sealed Phoenix Ring
(21109,6341,1,1,1,4579),-- Sealed Phoenix Earring Gemstone
(21109,6343,1,1,1,3540),-- Sealed Phoenix Necklace Beads
(21109,6345,1,1,1,6333),-- Sealed Phoenix Ring Gemstone
(21109,1807,1,1,2,110),-- Recipe: Soulshot: A-Grade
(21109,1865,1,1,2,82772),-- Varnish
(21109,1870,1,1,2,82772),-- Coal
(21109,1874,1,1,2,5518),-- Oriharukon Ore
(21109,4039,1,1,2,2759),-- Mold Glue
(21109,4043,1,1,2,2759),-- Asofe
(21109,6037,1,1,2,165544),-- Waking Scroll
(21109,6670,1,1,2,13795),-- Deluxe Chest Key - Grade 6
(21109,8730,1,1,200,920),-- Life Stone: level 67
(21109,8740,1,1,200,230),-- Mid-Grade Life Stone: level 67
(21109,8750,1,1,200,23),-- High-Grade Life Stone: level 67
(21109,8760,1,1,200,4),-- Top-Grade Life Stone: level 67
(21110,1807,1,1,-1,3832),-- Recipe: Soulshot: A-Grade
(21110,3035,1,1,-1,3832),-- Recipe: Spiritshot A
(21110,5479,1,1,-1,17005),-- Sealed Tallum Leather Armor Pattern
(21110,57,1137,2310,0,700000),-- Adena
(21110,12222,1,1,1,205),-- Common Item - Sealed Dark Crystal Leather Armor
(21110,12228,1,1,1,329),-- Common Item - Sealed Dark Crystalline Leggings
(21110,12230,1,1,1,126),-- Common Item - Sealed Tallum Leather Armor
(21110,5478,1,1,1,1190),-- Sealed Dark Crystal Leather Armor Pattern
(21110,5479,1,1,1,837),-- Sealed Tallum Leather Armor Pattern
(21110,5482,1,1,1,1867),-- Sealed Dark Crystalline Leggings Design
(21110,1866,1,1,2,51449),-- Suede
(21110,1871,1,1,2,77173),-- Charcoal
(21110,1877,1,1,2,3087),-- Adamantite Nugget
(21110,3956,1,1,2,103),-- Recipe: Blessed Spiritshot A
(21110,8487,1,1,2,42),-- Recipe: Destroyer Hammer (60%)
(21110,4040,1,1,2,1543),-- Mold Lubricant
(21110,4041,1,1,2,671),-- Mold Hardener
(21110,8730,1,1,200,857),-- Life Stone: level 67
(21110,8740,1,1,200,214),-- Mid-Grade Life Stone: level 67
(21110,8750,1,1,200,21),-- High-Grade Life Stone: level 67
(21110,8760,1,1,200,4),-- Top-Grade Life Stone: level 67
(21111,4041,1,1,-1,26191),-- Mold Hardener
(21111,5479,1,1,-1,17822),-- Sealed Tallum Leather Armor Pattern
(21111,5482,1,1,-1,39755),-- Sealed Dark Crystalline Leggings Design
(21111,57,1191,2424,0,700000),-- Adena
(21111,12222,1,1,1,215),-- Common Item - Sealed Dark Crystal Leather Armor
(21111,12228,1,1,1,345),-- Common Item - Sealed Dark Crystalline Leggings
(21111,12230,1,1,1,132),-- Common Item - Sealed Tallum Leather Armor
(21111,5478,1,1,1,1247),-- Sealed Dark Crystal Leather Armor Pattern
(21111,5479,1,1,1,877),-- Sealed Tallum Leather Armor Pattern
(21111,5482,1,1,1,1957),-- Sealed Dark Crystalline Leggings Design
(21111,1344,10,30,2,92678),-- Mithril Arrow
(21111,1865,1,1,2,74142),-- Varnish
(21111,1870,1,1,2,74142),-- Coal
(21111,1875,1,1,2,4943),-- Stone of Purity
(21111,1879,1,1,2,12357),-- Cokes
(21111,4040,1,1,2,1483),-- Mold Lubricant
(21111,8487,1,1,2,40),-- Recipe: Destroyer Hammer (60%)
(21111,5166,1,1,2,99),-- Recipe: Blessed Spiritshot (A) Compressed Package (100%)
(21111,8730,1,1,200,824),-- Life Stone: level 67
(21111,8740,1,1,200,206),-- Mid-Grade Life Stone: level 67
(21111,8750,1,1,200,21),-- High-Grade Life Stone: level 67
(21111,8760,1,1,200,4),-- Top-Grade Life Stone: level 67
(21112,3956,1,1,-1,3905),-- Recipe: Blessed Spiritshot A
(21112,5485,1,1,-1,24627),-- Sealed Tallum Tunic Texture
(21112,5486,1,1,-1,17329),-- Sealed Dark Crystal Robe Fabric
(21112,57,1445,2946,0,700000),-- Adena
(21112,12221,1,1,1,589),-- Common Item - Sealed Dark Crystal Gloves
(21112,12224,1,1,1,589),-- Common Item - Sealed Dark Crystal Boots
(21112,12229,1,1,1,589),-- Common Item - Sealed Tallum Gloves
(21112,12231,1,1,1,589),-- Common Item - Sealed Tallum Boots
(21112,5496,1,1,1,3169),-- Sealed Dark Crystal Boots Lining
(21112,5497,1,1,1,3169),-- Sealed Tallum Boots Lining
(21112,5508,1,1,1,3169),-- Sealed Dark Crystal Gloves Design
(21112,5509,1,1,1,3169),-- Sealed Tallum Gloves Design
(21112,1868,1,1,2,216269),-- Thread
(21112,1873,1,1,2,43254),-- Silver Nugget
(21112,1876,1,1,2,21627),-- Mithril Ore
(21112,1895,1,1,2,30896),-- Metallic Fiber
(21112,4042,1,1,2,1802),-- Enria
(21112,5281,1,1,2,144),-- Recipe: Greater Blessed Spiritshot (A) Compressed Package(100%)
(21112,8730,1,1,200,1202),-- Life Stone: level 67
(21112,8740,1,1,200,300),-- Mid-Grade Life Stone: level 67
(21112,8750,1,1,200,30),-- High-Grade Life Stone: level 67
(21112,8760,1,1,200,6),-- Top-Grade Life Stone: level 67
(21113,5156,1,1,-1,4361),-- Recipe: Soulshot (A) Compressed Package (100%)
(21113,5166,1,1,-1,4361),-- Recipe: Blessed Spiritshot (A) Compressed Package (100%)
(21113,5489,1,1,-1,43172),-- Sealed Tallum Stockings Fabric
(21113,57,1613,3293,0,700000),-- Adena
(21113,12222,1,1,1,292),-- Common Item - Sealed Dark Crystal Leather Armor
(21113,12228,1,1,1,468),-- Common Item - Sealed Dark Crystalline Leggings
(21113,12230,1,1,1,180),-- Common Item - Sealed Tallum Leather Armor
(21113,5478,1,1,1,1693),-- Sealed Dark Crystal Leather Armor Pattern
(21113,5479,1,1,1,1191),-- Sealed Tallum Leather Armor Pattern
(21113,5482,1,1,1,2657),-- Sealed Dark Crystalline Leggings Design
(21113,1344,10,30,2,137242),-- Mithril Arrow
(21113,1864,1,3,2,109793),-- Stem
(21113,1869,1,1,2,109793),-- Iron Ore
(21113,1878,1,1,2,43917),-- Braided Hemp
(21113,1884,1,1,2,67565),-- Cord
(21113,3035,1,1,2,146),-- Recipe: Spiritshot A
(21113,4039,1,1,2,3660),-- Mold Glue
(21113,8730,1,1,200,1220),-- Life Stone: level 67
(21113,8740,1,1,200,305),-- Mid-Grade Life Stone: level 67
(21113,8750,1,1,200,30),-- High-Grade Life Stone: level 67
(21113,8760,1,1,200,6),-- Top-Grade Life Stone: level 67
(21114,1875,1,1,-1,207673),-- Stone of Purity
(21114,5161,1,1,-1,4153),-- Recipe: Spiritshot (A) Compressed Package (100%)
(21114,5494,1,1,-1,65423),-- Sealed Dark Crystal Shield Fragment
(21114,57,1538,3132,0,700000),-- Adena
(21114,12227,1,1,1,209),-- Common Item - Sealed Dark Crystal breastplate
(21114,12220,1,1,1,333),-- Common Item - Sealed Dark Crystal Gaiters
(21114,12233,1,1,1,129),-- Common Item - Sealed Tallum Plate Armor
(21114,5520,1,1,1,1236),-- Sealed Dark Crystal Breastplate Pattern
(21114,5521,1,1,1,872),-- Sealed Tallum Plate Armor Pattern
(21114,5524,1,1,1,1889),-- Sealed Dark Crystal Gaiters Pattern
(21114,1344,10,30,2,130703),-- Mithril Arrow
(21114,1865,1,1,2,104563),-- Varnish
(21114,1870,1,1,2,104563),-- Coal
(21114,1874,1,1,2,6971),-- Oriharukon Ore
(21114,4039,1,1,2,3485),-- Mold Glue
(21114,4043,1,1,2,3485),-- Asofe
(21114,5271,1,1,2,140),-- Recipe: Greater Soulshot (A) Compressed Package(100%)
(21114,8731,1,1,200,968),-- Life Stone: level 70
(21114,8741,1,1,200,242),-- Mid-Grade Life Stone: level 70
(21114,8751,1,1,200,24),-- High-Grade Life Stone: level 70
(21114,8761,1,1,200,5),-- Top-Grade Life Stone: level 70
(21115,5166,1,1,-1,3627),-- Recipe: Blessed Spiritshot (A) Compressed Package (100%)
(21115,5496,1,1,-1,63784),-- Sealed Dark Crystal Boots Lining
(21115,5497,1,1,-1,63784),-- Sealed Tallum Boots Lining
(21115,57,1342,2736,0,700000),-- Adena
(21115,12232,1,1,1,243),-- Common Item - Sealed Tallum Tunic
(21115,12235,1,1,1,389),-- Common Item - Sealed Tallum Stockings
(21115,12223,1,1,1,149),-- Common Item - Sealed Dark Crystal Robe
(21115,5485,1,1,1,1408),-- Sealed Tallum Tunic Texture
(21115,5486,1,1,1,991),-- Sealed Dark Crystal Robe Fabric
(21115,5489,1,1,1,2210),-- Sealed Tallum Stockings Fabric
(21115,1866,1,1,2,60876),-- Suede
(21115,1871,1,1,2,91314),-- Charcoal
(21115,1885,1,1,2,7609),-- High Grade Suede
(21115,4041,1,1,2,794),-- Mold Hardener
(21115,5220,1,1,2,3653),-- Metal Hardener
(21115,5281,1,1,2,122),-- Recipe: Greater Blessed Spiritshot (A) Compressed Package(100%)
(21115,6671,1,1,2,10146),-- Deluxe Chest Key - Grade 7
(21115,8731,1,1,200,845),-- Life Stone: level 70
(21115,8741,1,1,200,211),-- Mid-Grade Life Stone: level 70
(21115,8751,1,1,200,21),-- High-Grade Life Stone: level 70
(21115,8761,1,1,200,4),-- Top-Grade Life Stone: level 70
(21116,729,1,1,-1,479),-- Scroll: Enchant Weapon (Grade A)
(21116,5480,1,1,-1,19326),-- Sealed Leather Armor of Nightmare Fabric
(21116,5481,1,1,-1,19326),-- Sealed Majestic Leather Armor Fabric
(21116,57,2125,4335,0,700000),-- Adena
(21116,12344,1,1,1,768),-- Common Item - Sealed Phoenix Necklace
(21116,12345,1,1,1,1023),-- Common Item - Sealed Phoenix Earring
(21116,12346,1,1,1,1536),-- Common Item - Sealed Phoenix Ring
(21116,6341,1,1,1,7331),-- Sealed Phoenix Earring Gemstone
(21116,6343,1,1,1,5667),-- Sealed Phoenix Necklace Beads
(21116,6345,1,1,1,10139),-- Sealed Phoenix Ring Gemstone
(21116,729,1,1,2,16),-- Scroll: Enchant Weapon (Grade A)
(21116,1867,1,1,2,192759),-- Animal Skin
(21116,1872,1,1,2,192759),-- Animal Bone
(21116,1882,1,1,2,32126),-- Leather
(21116,1894,1,1,2,5073),-- Crafted Leather
(21116,4042,1,1,2,2410),-- Enria
(21116,4987,1,1,2,600),-- Recipe: Tunic of Doom (60%)
(21116,8731,1,1,200,1339),-- Life Stone: level 70
(21116,8741,1,1,200,335),-- Mid-Grade Life Stone: level 70
(21116,8751,1,1,200,33),-- High-Grade Life Stone: level 70
(21116,8761,1,1,200,6),-- Top-Grade Life Stone: level 70
(21117,734,1,1,-1,43530),-- Haste Potion
(21117,1800,1,1,-1,82131),-- Recipe: Piece Bone Breastplate
(21117,1897,1,1,-1,62185),-- Necklace of Wisdom Chain
(21117,57,122,208,0,700000),-- Adena
(21117,38,1,1,1,1974),-- Low Boots
(21117,50,1,1,1,1974),-- Leather Gloves
(21117,1925,1,1,1,33727),-- Leather Gloves Lining
(21117,1868,1,3,2,102864),-- Thread
(21117,1873,1,1,2,20573),-- Silver Nugget
(21117,2139,1,1,2,10287),-- Recipe: Steel Mold
(21118,1801,1,1,-1,138851),-- Recipe: Piece Bone Gaiters
(21118,1924,1,1,-1,88910),-- Leather Helmet Design
(21118,1925,1,1,-1,180734),-- Leather Gloves Lining
(21118,57,127,221,0,700000),-- Adena
(21118,44,1,1,1,1041),-- Leather Helmet
(21118,102,1,1,1,1488),-- Round Shield
(21118,945,1,1,1,3084),-- Skeleton Buckler
(21118,1924,1,1,1,13132),-- Leather Helmet Design
(21118,1864,1,1,2,65132),-- Stem
(21118,1869,1,1,2,32566),-- Iron Ore
(21118,1880,1,1,2,3257),-- Steel
(21118,2142,1,1,2,6514),-- Recipe: Varnish of Purity
(21118,6035,1,1,2,2714),-- Magic Haste Potion
(21119,1868,1,1,-1,683443),-- Thread
(21119,1873,1,1,-1,136689),-- Silver Nugget
(21119,1898,1,1,-1,35102),-- Blue Diamond Necklace Gem
(21119,57,156,278,0,700000),-- Adena
(21119,27,1,1,1,355),-- Hard Leather Shirt
(21119,33,1,1,1,570),-- Hard Leather Gaiters
(21119,1927,1,1,1,4026),-- Hard Leather Shirt Pattern
(21119,1929,1,1,1,6512),-- Hard Leather Gaiters Material
(21119,1868,1,1,2,201878),-- Thread
(21119,1873,1,1,2,40376),-- Silver Nugget
(21120,1804,1,1,-1,17582),-- Recipe: Soulshot: D-Grade
(21120,1926,1,1,-1,44399),-- Piece Bone Breastplate Fragment
(21120,2151,1,1,-1,122437),-- Recipe: Necklace of Devotion
(21120,57,199,358,0,700000),-- Adena
(21120,87,1,1,1,69),-- Iron Hammer
(21120,155,1,1,1,69),-- Buzdygan
(21120,177,1,1,1,69),-- Mage Staff
(21120,2014,1,1,1,746),-- Iron Hammer Head
(21120,1867,1,1,2,86557),-- Animal Skin
(21120,1872,1,1,2,86557),-- Animal Bone
(21120,1882,1,1,2,14426),-- Leather
(21120,2255,1,1,2,1587),-- Recipe: Saber
(21121,1875,1,1,-1,25714),-- Stone of Purity
(21121,1881,1,1,-1,51428),-- Coarse Bone Powder
(21121,1927,1,1,-1,30770),-- Hard Leather Shirt Pattern
(21121,57,177,312,0,700000),-- Adena
(21121,257,1,1,1,242),-- Viper\'s Fang
(21121,1867,1,1,2,75955),-- Animal Skin
(21121,1872,1,1,2,75955),-- Animal Bone
(21121,1881,1,1,2,7596),-- Coarse Bone Powder
(21121,2258,1,1,2,1393),-- Recipe: Temptation of Abyss
(21122,1928,1,1,-1,59341),-- Piece Bone Gaiters Fragment
(21122,1929,1,1,-1,52565),-- Hard Leather Gaiters Material
(21122,2176,1,1,-1,194917),-- Recipe: Leather Boots
(21122,57,181,334,0,700000),-- Adena
(21122,273,1,1,1,128),-- Composition Bow
(21122,2016,1,1,1,1410),-- Composition Bow Shaft
(21122,1868,1,1,2,160444),-- Thread
(21122,1873,1,1,2,32089),-- Silver Nugget
(21122,5268,1,1,2,3209),-- Recipe: Greater Soulshot (D) Compressed Package (100%)
(21123,1874,1,1,-1,35730),-- Oriharukon Ore
(21123,1899,1,1,-1,83743),-- Necklace of Devotion Chain
(21123,2152,1,1,-1,94359),-- Recipe: Enchanted Necklace
(21123,57,236,442,0,700000),-- Adena
(21123,220,1,1,1,191),-- Crafted Dagger
(21123,1874,1,1,2,5013),-- Oriharukon Ore
(21123,1878,1,1,2,30080),-- Braided Hemp
(21123,2178,1,1,2,12032),-- Recipe: Dark Stockings
(21123,5220,1,1,2,3008),-- Metal Hardener
(21124,735,1,1,-1,21105),-- Potion of Alacrity
(21124,1865,1,1,-1,253256),-- Varnish
(21124,1897,1,1,-1,60299),-- Necklace of Wisdom Chain
(21124,57,121,200,0,700000),-- Adena
(21124,309,1,1,1,143),-- Tears of Eva
(21124,310,1,1,1,143),-- Relic of The Saints
(21124,1800,1,1,2,11763),-- Recipe: Piece Bone Breastplate
(21124,1865,1,1,2,37404),-- Varnish
(21124,1870,1,1,2,37404),-- Coal
(21124,1879,1,1,2,6235),-- Cokes
(21125,1800,1,1,-1,82944),-- Recipe: Piece Bone Breastplate
(21125,1801,1,1,-1,132878),-- Recipe: Piece Bone Gaiters
(21125,1924,1,1,-1,85085),-- Leather Helmet Design
(21125,57,124,211,0,700000),-- Adena
(21125,15,1,1,1,148),-- Short Spear
(21125,2011,1,1,1,1778),-- Short Spear Edge
(21125,734,1,1,2,6493),-- Haste Potion
(21125,1866,1,1,2,25971),-- Suede
(21125,1871,1,1,2,38956),-- Charcoal
(21125,2140,1,1,2,7792),-- Recipe: High Grade Suede
(21126,1864,1,1,-1,540431),-- Stem
(21126,1865,1,1,-1,270215),-- Varnish
(21126,1925,1,1,-1,177190),-- Leather Gloves Lining
(21126,57,125,217,0,700000),-- Adena
(21126,24,1,1,1,512),-- Bone Breastplate
(21126,31,1,1,1,817),-- Bone Gaiters
(21126,390,1,1,1,512),-- Cotton Shirt
(21126,412,1,1,1,817),-- Cotton Pants
(21126,1864,1,1,2,53212),-- Stem
(21126,1865,1,1,2,26606),-- Varnish
(21126,1866,1,1,2,17738),-- Suede
(21126,1868,1,1,2,53212),-- Thread
(21126,1873,1,1,2,10643),-- Silver Nugget
(21126,2143,1,1,2,5322),-- Recipe: Synthetic Cokes
(21127,1804,1,1,-1,13669),-- Recipe: Soulshot: D-Grade
(21127,1898,1,1,-1,35102),-- Blue Diamond Necklace Gem
(21127,1926,1,1,-1,34517),-- Piece Bone Breastplate Fragment
(21127,57,156,278,0,700000),-- Adena
(21127,25,1,1,1,275),-- Piece Bone Breastplate
(21127,26,1,1,1,178),-- Bronze Breastplate
(21127,32,1,1,1,440),-- Piece Bone Gaiters
(21127,34,1,1,1,285),-- Bronze Gaiters
(21127,1926,1,1,1,3399),-- Piece Bone Breastplate Fragment
(21127,1928,1,1,1,4901),-- Piece Bone Gaiters Fragment
(21127,1868,1,1,2,100939),-- Thread
(21127,1873,1,1,2,20188),-- Silver Nugget
(21127,2151,1,1,2,14058),-- Recipe: Necklace of Devotion
(21127,6035,1,1,2,4206),-- Magic Haste Potion
(21128,1869,1,1,-1,362125),-- Iron Ore
(21128,1927,1,1,-1,28889),-- Hard Leather Shirt Pattern
(21128,2151,1,1,-1,100871),-- Recipe: Necklace of Devotion
(21128,57,164,295,0,700000),-- Adena
(21128,1102,1,1,1,753),-- Tunic of Magic
(21128,1105,1,1,1,1209),-- Stockings of Magic
(21128,1867,1,1,2,47541),-- Animal Skin
(21128,1869,1,1,2,35655),-- Iron Ore
(21128,1870,1,1,2,35655),-- Coal
(21128,1871,1,1,2,35655),-- Charcoal
(21128,1872,1,1,2,47541),-- Animal Bone
(21128,2256,1,1,2,872),-- Recipe: Assassin Knife
(21129,1870,1,1,-1,385707),-- Coal
(21129,1928,1,1,-1,56185),-- Piece Bone Gaiters Fragment
(21129,2176,1,1,-1,184549),-- Recipe: Leather Boots
(21129,57,177,312,0,700000),-- Adena
(21129,846,1,1,1,926),-- Coral Earring
(21129,878,1,1,1,1389),-- Blue Coral Ring
(21129,909,1,1,1,695),-- Blue Diamond Necklace
(21129,1898,1,1,1,5852),-- Blue Diamond Necklace Gem
(21129,1865,1,1,2,56966),-- Varnish
(21129,1870,1,1,2,56966),-- Coal
(21129,3032,1,1,2,2279),-- Recipe: Spiritshot D
(21129,6035,1,1,2,4747),-- Magic Haste Potion
(21130,1929,1,1,-1,52565),-- Hard Leather Gaiters Material
(21130,1930,1,1,-1,104455),-- Boot Lining
(21130,2177,1,1,-1,130152),-- Recipe: Bone Helmet
(21130,57,181,334,0,700000),-- Adena
(21130,39,1,1,1,1689),-- Boots
(21130,51,1,1,1,1689),-- Bracer
(21130,1930,1,1,1,20570),-- Boot Lining
(21130,734,1,1,2,10028),-- Haste Potion
(21130,1866,1,1,2,40111),-- Suede
(21130,1871,1,1,2,60167),-- Charcoal
(21130,5273,1,1,2,2407),-- Recipe: Greater Spiritshot (D) Compressed Package(100%)
(21131,1867,1,1,-1,559583),-- Animal Skin
(21131,1872,1,1,-1,559583),-- Animal Bone
(21131,1899,1,1,-1,65576),-- Necklace of Devotion Chain
(21131,57,185,346,0,700000),-- Adena
(21131,45,1,1,1,652),-- Bone Helmet
(21131,626,1,1,1,929),-- Bronze Shield
(21131,1932,1,1,1,12462),-- Bone Helmet Design
(21131,1867,1,1,2,62811),-- Animal Skin
(21131,1872,1,1,2,62811),-- Animal Bone
(21131,1875,1,1,2,3140),-- Stone of Purity
(21131,1881,1,1,2,6281),-- Coarse Bone Powder
(21131,2180,1,1,2,3542),-- Recipe: Scale Mail
(21132,1898,1,1,-1,34188),-- Blue Diamond Necklace Gem
(21132,2179,1,1,-1,159246),-- Recipe: Crafted Leather Gloves
(21132,2255,1,1,-1,8137),-- Recipe: Saber
(21132,57,148,273,0,700000),-- Adena
(21132,68,1,1,1,105),-- Falchion
(21132,5284,1,1,1,105),-- Zweihander
(21132,1868,1,1,2,131082),-- Thread
(21132,1873,1,1,2,26216),-- Silver Nugget
(21132,5278,1,1,2,2622),-- Recipe: Greater Blessed Spiritshot (D) Compressed Package(100%)
(21133,1864,1,1,-1,720463),-- Stem
(21133,1878,1,1,-1,144093),-- Braided Hemp
(21133,1899,1,1,-1,56286),-- Necklace of Devotion Chain
(21133,57,159,297,0,700000),-- Adena
(21133,156,1,1,1,43),-- Hand Axe
(21133,167,1,1,1,43),-- Scalpel
(21133,178,1,1,1,43),-- Bone Staff
(21133,1061,1,1,2,24506),-- Healing Potion
(21133,1864,1,1,2,80869),-- Stem
(21133,1869,1,1,2,40435),-- Iron Ore
(21133,1878,1,1,2,16174),-- Braided Hemp
(21133,2181,1,1,2,4048),-- Recipe: White Tunic
(21134,1931,1,1,-1,49119),-- Leather Boot Lining
(21134,1932,1,1,-1,59645),-- Bone Helmet Design
(21134,2152,1,1,-1,66155),-- Recipe: Enchanted Necklace
(21134,57,163,312,0,700000),-- Adena
(21134,258,1,1,1,134),-- Bagh-Nakh
(21134,1865,1,1,2,42178),-- Varnish
(21134,1870,1,1,2,42178),-- Coal
(21134,1875,1,1,2,2812),-- Stone of Purity
(21134,1879,1,1,2,7030),-- Cokes
(21134,2259,1,1,2,655),-- Recipe: Spinebone Sword
(21135,1934,1,1,-1,59833),-- Crafted Leather Gloves Lining
(21135,2178,1,1,-1,73236),-- Recipe: Dark Stockings
(21135,5220,1,1,-1,18309),-- Metal Hardener
(21135,57,198,381,0,700000),-- Adena
(21135,274,1,1,1,163),-- Strengthened Bow
(21135,1866,1,1,2,34252),-- Suede
(21135,1871,1,1,2,51378),-- Charcoal
(21135,1885,1,1,2,4282),-- High Grade Suede
(21135,2261,1,1,2,798),-- Recipe: Conjuror\'s Staff
(21135,5220,1,1,2,2055),-- Metal Hardener
(21136,1882,1,1,-1,89848),-- Leather
(21136,2017,1,1,-1,5373),-- Saber Blade
(21136,2180,1,1,-1,30400),-- Recipe: Scale Mail
(21136,57,173,339,0,700000),-- Adena
(21136,220,1,1,1,144),-- Crafted Dagger
(21136,1834,1,1,2,50426),-- Emergency Dressing
(21136,1867,1,1,2,60511),-- Animal Skin
(21136,1872,1,1,2,60511),-- Animal Bone
(21136,1882,1,1,2,10085),-- Leather
(21136,2152,1,1,2,7990),-- Recipe: Enchanted Necklace
(21137,1900,1,1,-1,47223),-- Enchanted Necklace Chain
(21137,1933,1,1,-1,50779),-- Dark Stocking Fabric
(21137,2153,1,1,-1,67126),-- Recipe: Tiger\'s Eye Earring
(21137,57,183,362,0,700000),-- Adena
(21137,315,1,1,1,95),-- Divine Tome
(21137,737,1,1,2,3931),-- Scroll of Resurrection
(21137,1868,1,1,2,78621),-- Thread
(21137,1873,1,1,2,15724),-- Silver Nugget
(21137,1889,1,1,2,2621),-- Compound Braid
(21137,5549,1,1,2,3931),-- Metallic Thread
(21137,6387,1,1,2,1572),-- Blessed Scroll of Resurrection for Pets
(21138,956,1,1,-1,15339),-- Scroll: Enchant Armor (Grade D)
(21138,1864,1,1,-1,920360),-- Stem
(21138,1869,1,1,-1,460180),-- Iron Ore
(21138,57,194,388,0,700000),-- Adena
(21138,292,1,1,1,102),-- Pike
(21138,1341,10,30,2,139706),-- Bone Arrow
(21138,1829,1,1,2,16765),-- Scroll of Escape: Clan Hall
(21138,1864,1,2,2,83824),-- Stem
(21138,1869,1,1,2,41912),-- Iron Ore
(21138,1880,1,1,2,4191),-- Steel
(21138,5550,1,1,2,559),-- Durable Metal Plate
(21139,1804,1,1,-1,37606),-- Recipe: Soulshot: D-Grade
(21139,1898,1,1,-1,96575),-- Blue Diamond Necklace Gem
(21139,1926,1,1,-1,94966),-- Piece Bone Breastplate Fragment
(21139,57,430,759,0,700000),-- Adena
(21139,27,1,1,1,978),-- Hard Leather Shirt
(21139,33,1,1,1,1569),-- Hard Leather Gaiters
(21139,1927,1,1,1,11077),-- Hard Leather Shirt Pattern
(21139,1929,1,1,1,17916),-- Hard Leather Gaiters Material
(21139,1865,1,1,2,185139),-- Varnish
(21139,1870,1,1,2,185139),-- Coal
(21139,3953,1,1,2,7406),-- Recipe: Blessed Spiritshot D
(21140,1871,1,3,-1,549553),-- Charcoal
(21140,1899,1,1,-1,171735),-- Necklace of Devotion Chain
(21140,2152,1,1,-1,193505),-- Recipe: Enchanted Necklace
(21140,57,477,911,0,700000),-- Adena
(21140,347,1,1,1,961),-- Ring Mail Breastplate
(21140,376,1,1,1,1538),-- Iron Plate Gaiters
(21140,1866,1,1,2,102809),-- Suede
(21140,1871,1,1,2,154213),-- Charcoal
(21140,1877,1,1,2,6168),-- Adamantite Nugget
(21140,2260,1,1,2,2395),-- Recipe: Mace of Judgment
(21141,1881,1,1,-1,169543),-- Coarse Bone Powder
(21141,1931,1,1,-1,166219),-- Leather Boot Lining
(21141,2178,1,1,-1,203452),-- Recipe: Dark Stockings
(21141,57,545,1067,0,700000),-- Adena
(21141,432,1,1,1,1481),-- Cursed Tunic
(21141,465,1,1,1,2371),-- Cursed Stockings
(21141,1867,1,1,2,190306),-- Animal Skin
(21141,1872,1,1,2,190306),-- Animal Bone
(21141,1875,1,1,2,9515),-- Stone of Purity
(21141,1881,1,1,2,19031),-- Coarse Bone Powder
(21141,2178,1,1,2,22836),-- Recipe: Dark Stockings
(21142,1900,1,1,-1,138128),-- Enchanted Necklace Chain
(21142,1933,1,1,-1,148528),-- Dark Stocking Fabric
(21142,2153,1,1,-1,196344),-- Recipe: Tiger\'s Eye Earring
(21142,57,535,1059,0,700000),-- Adena
(21142,848,1,1,1,1052),-- Enchanted Earring
(21142,879,1,1,1,1582),-- Enchanted Ring
(21142,911,1,1,1,789),-- Enchanted Necklace
(21142,1900,1,1,1,18871),-- Enchanted Necklace Chain
(21142,955,1,1,2,690),-- Scroll: Enchant Weapon (Grade D)
(21142,1868,1,1,2,344952),-- Thread
(21142,1873,1,1,2,68990),-- Silver Nugget
(21142,1876,1,1,2,34495),-- Mithril Ore
(21143,955,1,1,-1,5610),-- Scroll: Enchant Weapon (Grade D)
(21143,1872,1,3,-1,934937),-- Animal Bone
(21143,1875,1,1,-1,93494),-- Stone of Purity
(21143,57,593,1182,0,700000),-- Adena
(21143,605,1,1,1,2994),-- Leather Gauntlets
(21143,1123,1,1,1,2994),-- Blue Buckskin Boots
(21143,1867,1,1,2,170303),-- Animal Skin
(21143,1872,1,1,2,170303),-- Animal Bone
(21143,1875,1,1,2,8515),-- Stone of Purity
(21143,1881,1,1,2,17030),-- Coarse Bone Powder
(21143,2250,1,1,2,31932),-- Recipe: Bone Arrow
(21143,6035,1,1,2,10644),-- Magic Haste Potion
(21144,1901,1,1,-1,229413),-- Tiger\'s Eye Earring Stone
(21144,1938,1,1,-1,111661),-- Mithril Banded Mail Material
(21144,2154,1,1,-1,177832),-- Recipe: Elven Earring
(21144,57,702,1399,0,700000),-- Adena
(21144,47,1,1,1,1507),-- Helmet
(21144,628,1,1,1,2154),-- Hoplon
(21144,1865,1,1,2,126159),-- Varnish
(21144,1870,1,1,2,126159),-- Coal
(21144,1875,1,1,2,8411),-- Stone of Purity
(21144,1879,1,1,2,21026),-- Cokes
(21144,2187,1,1,2,5632),-- Recipe: Manticore Skin Shirt
(21144,6035,1,1,2,10513),-- Magic Haste Potion
(21144,8317,1,1,2,901),-- Recipe: Titan Hammer (100%)
(21145,1825,1,1,-1,150797),-- Recipe: Oriharukon
(21145,1885,1,1,-1,175930),-- High Grade Suede
(21145,1902,1,1,-1,213897),-- Elven Earring Beads
(21145,57,893,1781,0,700000),-- Adena
(21145,129,1,1,1,102),-- Sword of Revolution
(21145,2034,1,1,1,5765),-- Sword of Revolution Blade
(21145,1832,1,1,2,173223),-- Greater Antidote
(21145,1866,1,1,2,103934),-- Suede
(21145,1871,1,1,2,155902),-- Charcoal
(21145,1885,1,1,2,12992),-- High Grade Suede
(21145,2146,1,1,2,11136),-- Recipe: Artisan\'s frame
(21145,5220,1,1,2,6236),-- Metal Hardener
(21145,5473,1,1,2,11136),-- Recipe: Durable Metal Plate(100%)
(21146,1894,1,1,-1,79948),-- Crafted Leather
(21146,1903,1,1,-1,380070),-- Elven Ring Piece
(21146,2145,1,1,-1,162751),-- Recipe: Mithril Alloy
(21146,57,951,1898,0,700000),-- Adena
(21146,88,1,1,1,22),-- Morning Star
(21146,90,1,1,1,22),-- Goat Head Staff
(21146,158,1,1,1,22),-- Tarbar
(21146,169,1,1,1,22),-- Skull Breaker
(21146,172,1,1,1,22),-- Heavy Bone Club
(21146,2031,1,1,1,1192),-- Morning Star Head
(21146,2032,1,1,1,1088),-- Goat Head Staff Head
(21146,2035,1,1,1,1192),-- Tarbar Head
(21146,2036,1,1,1,1192),-- Skull Breaker Head
(21146,2037,1,1,1,1192),-- Heavy Bone Club Head
(21146,1867,1,1,2,224346),-- Animal Skin
(21146,1872,1,1,2,224346),-- Animal Bone
(21146,1875,1,1,2,11217),-- Stone of Purity
(21146,1881,1,1,2,22434),-- Coarse Bone Powder
(21146,1805,1,1,2,561),-- Recipe: Soulshot: C-Grade
(21146,5164,1,1,2,561),-- Recipe: Blessed Spiritshot (C) Compressed Package (100%)
(21146,2990,1,1,2,13354),-- Recipe: Chain Boots
(21147,1805,1,1,-1,9382),-- Recipe: Soulshot: C-Grade
(21147,1905,1,1,-1,273798),-- Omen Beast\'s Eye Earring Gemstone
(21147,1906,1,1,-1,386892),-- Mithril Ring Wire
(21147,57,1113,2260,0,700000),-- Adena
(21147,262,1,1,1,102),-- Scallop Jamadhr
(21147,2053,1,1,1,5834),-- Scallop Jamadhr Edge
(21147,1868,1,3,2,235564),-- Thread
(21147,1873,1,1,2,94225),-- Silver Nugget
(21147,1889,1,1,2,15704),-- Compound Braid
(21147,2199,1,1,2,9939),-- Recipe: Karmian Stockings
(21147,2301,1,1,2,1029),-- Recipe: Battle Axe
(21147,5549,1,1,2,23557),-- Metallic Thread
(21148,1869,1,5,-1,930808),-- Iron Ore
(21148,1880,1,1,-1,279242),-- Steel
(21148,5550,1,1,-1,37232),-- Durable Metal Plate
(21148,57,1099,2253,0,700000),-- Adena
(21148,281,1,1,1,75),-- Crystallized Ice Bow
(21148,2074,1,1,1,4674),-- Crystallized Ice Bow Shaft
(21148,1864,1,3,2,119976),-- Stem
(21148,1869,1,1,2,119976),-- Iron Ore
(21148,1880,1,1,2,11998),-- Steel
(21148,2163,1,1,2,6121),-- Recipe: Earring of Protection
(21148,2217,1,1,2,7099),-- Recipe: Knight\'s Shield
(21148,5550,1,1,2,1600),-- Durable Metal Plate
(21148,6037,1,3,2,79984),-- Waking Scroll
(21148,8723,1,1,200,4699),-- Life Stone: level 46
(21148,8733,1,1,200,1200),-- Mid-Grade Life Stone: level 46
(21148,8743,1,1,200,120),-- High-Grade Life Stone: level 46
(21148,8753,1,1,200,24),-- Top-Grade Life Stone: level 46
(21149,1908,1,1,-1,305158),-- Moonstone Earring Wire
(21149,1909,1,1,-1,435175),-- Aquastone Ring Wire
(21149,2163,1,1,-1,164412),-- Recipe: Earring of Protection
(21149,57,1269,2596,0,700000),-- Adena
(21149,226,1,1,1,43),-- Cursed Dagger
(21149,232,1,1,1,43),-- Dark Elven Dagger
(21149,2070,1,1,1,3023),-- Cursed Dagger Blade
(21149,2072,1,1,1,3023),-- Dark Elven Dagger Edge
(21149,1868,1,1,2,276907),-- Thread
(21149,1873,1,1,2,55381),-- Silver Nugget
(21149,1876,1,1,2,27691),-- Mithril Ore
(21149,1895,1,1,2,39558),-- Metallic Fiber
(21149,2215,1,1,2,1764),-- Recipe: Robe of Seal
(21149,2228,1,1,2,3762),-- Recipe: Shining Circlet
(21149,4042,1,1,2,2308),-- Enria
(21149,8723,1,1,200,5538),-- Life Stone: level 46
(21149,8733,1,1,200,1385),-- Mid-Grade Life Stone: level 46
(21149,8743,1,1,200,138),-- High-Grade Life Stone: level 46
(21149,8753,1,1,200,27),-- Top-Grade Life Stone: level 46
(21150,951,1,1,-1,6655),-- Scroll: Enchant Weapon (Grade C)
(21150,1911,1,1,-1,272241),-- Earring of Protection Gemstone
(21150,2166,1,1,-1,124078),-- Recipe: Earrings of Binding (100%)
(21150,57,1445,2946,0,700000),-- Adena
(21150,325,1,1,1,73),-- Horn of Glory
(21150,2088,1,1,1,5715),-- Horn of Glory Fragment
(21150,1342,10,30,2,249507),-- Fine Steel Arrow
(21150,1866,1,1,2,83169),-- Suede
(21150,1871,1,1,2,124753),-- Charcoal
(21150,1877,1,1,2,4990),-- Adamantite Nugget
(21150,2166,1,1,2,4229),-- Recipe: Earrings of Binding (100%)
(21150,2234,1,1,2,1859),-- Recipe: Divine Stockings
(21150,3014,1,1,2,3485),-- Recipe: Full Plate Boots
(21150,4040,1,1,2,2495),-- Mold Lubricant
(21150,4041,1,1,2,1085),-- Mold Hardener
(21150,8724,1,1,200,4158),-- Life Stone: level 49
(21150,8734,1,1,200,1040),-- Mid-Grade Life Stone: level 49
(21150,8744,1,1,200,104),-- High-Grade Life Stone: level 49
(21150,8754,1,1,200,21),-- Top-Grade Life Stone: level 49
(21151,1869,1,9,-1,763245),-- Iron Ore
(21151,4043,1,1,-1,127207),-- Asofe
(21151,4601,1,1,-1,8480),-- Greater Dye of Strength <Str+3 Con-3>
(21151,57,1509,3068,0,700000),-- Adena
(21151,231,1,1,1,24),-- Grace Dagger
(21151,233,1,1,1,24),-- Dark Screamer
(21151,2106,1,1,1,2150),-- Grace Dagger Edge
(21151,2107,1,1,1,2150),-- Dark Screamer Edge
(21151,1864,1,3,2,157815),-- Stem
(21151,1869,1,1,2,157815),-- Iron Ore
(21151,1880,1,1,2,15781),-- Steel
(21151,2169,1,1,2,2793),-- Recipe: Necklace of Binding
(21151,4043,1,1,2,5260),-- Asofe
(21151,5550,1,1,2,2104),-- Durable Metal Plate
(21151,8725,1,1,200,4384),-- Life Stone: level 52
(21151,8735,1,1,200,1096),-- Mid-Grade Life Stone: level 52
(21151,8745,1,1,200,110),-- High-Grade Life Stone: level 52
(21151,8755,1,1,200,22),-- Top-Grade Life Stone: level 52
(21152,1806,1,1,-1,8167),-- Recipe: Soulshot: B-Grade
(21152,1920,1,1,-1,139722),-- Necklace of Binding Chain
(21152,4600,1,1,-1,13611),-- Greater Dye of Wit <Wit+2 Men-2>
(21152,57,1616,3283,0,700000),-- Adena
(21152,400,1,1,1,79),-- Theca Leather Armor
(21152,401,1,1,1,37),-- Drake Leather Armor
(21152,420,1,1,1,127),-- Theca Leather Gaiters
(21152,1984,1,1,1,5386),-- Theca Leather Armor Pattern
(21152,1985,1,1,1,8665),-- Theca Leather Gaiters Pattern
(21152,1987,1,1,1,3824),-- Drake Leather Armor Texture
(21152,1806,1,1,2,251),-- Recipe: Soulshot: B-Grade
(21152,1868,1,1,2,251284),-- Thread
(21152,1873,1,1,2,50257),-- Silver Nugget
(21152,1876,1,1,2,25128),-- Mithril Ore
(21152,1895,1,1,2,35898),-- Metallic Fiber
(21152,4042,1,1,2,2094),-- Enria
(21152,4941,1,1,2,967),-- Recipe: Zubei\'s Gaiters  (60%)
(21152,4959,1,1,2,2421),-- Recipe: Avadon Boots (60%)
(21152,8726,1,1,200,2908),-- Life Stone: level 55
(21152,8736,1,1,200,727),-- Mid-Grade Life Stone: level 55
(21152,8746,1,1,200,73),-- High-Grade Life Stone: level 55
(21152,8756,1,1,200,15),-- Top-Grade Life Stone: level 55
(21153,947,1,1,-1,1932),-- Scroll: Enchant Weapon (Grade B)
(21153,4049,1,1,-1,253365),-- Adamantite Earring Gemstone
(21153,4129,1,1,-1,52277),-- Recipe: Earrings of Black Ore
(21153,57,1906,3892,0,700000),-- Adena
(21153,357,1,1,1,22),-- Zubei\'s Breastplate
(21153,383,1,1,1,36),-- Zubei\'s Gaiters
(21153,2376,1,1,1,22),-- Avadon Breastplate
(21153,2379,1,1,1,36),-- Avadon Gaiters
(21153,4056,1,1,1,3229),-- Zubei\'s Breastplate Part
(21153,4057,1,1,1,4991),-- Zubei\'s Gaiter Material
(21153,4064,1,1,1,3229),-- Avadon Breastplate Part
(21153,4065,1,1,1,4991),-- Avadon Gaiters Material
(21153,947,1,1,2,52),-- Scroll: Enchant Weapon (Grade B)
(21153,1894,1,1,2,4551),-- Crafted Leather
(21153,3955,1,1,2,259),-- Recipe: Blessed Spiritshot B
(21153,4039,1,1,2,4324),-- Mold Glue
(21153,4041,1,1,2,1128),-- Mold Hardener
(21153,4044,1,1,2,4324),-- Thons
(21153,5280,1,1,2,259),-- Recipe: Greater Blessed Spiritshot (B) Compressed Package(100%)
(21153,8727,1,1,200,2594),-- Life Stone: level 58
(21153,8737,1,1,200,649),-- Mid-Grade Life Stone: level 58
(21153,8747,1,1,200,65),-- High-Grade Life Stone: level 58
(21153,8757,1,1,200,13),-- Top-Grade Life Stone: level 58
(21154,4049,1,1,-1,266232),-- Adamantite Earring Gemstone
(21154,4613,1,1,-1,7001),-- Greater Dye of Strength <Str+4 Con-4>
(21154,4614,1,1,-1,7001),-- Greater Dye of Strength <Str+4 Dex-4>
(21154,57,2005,4083,0,700000),-- Adena
(21154,2397,1,1,1,42),-- Tunic of Zubei
(21154,2402,1,1,1,67),-- Stockings of Zubei
(21154,2406,1,1,1,26),-- Avadon Robe
(21154,4069,1,1,1,5893),-- Tunic of Zubei Fabric
(21154,4070,1,1,1,8947),-- Stockings of Zubei Fabric
(21154,4071,1,1,1,4527),-- Avadon Robe Fabric
(21154,1832,1,1,2,185097),-- Greater Antidote
(21154,1867,1,3,2,74039),-- Animal Skin
(21154,1872,1,3,2,111058),-- Animal Bone
(21154,1875,1,1,2,11106),-- Stone of Purity
(21154,1881,1,1,2,22212),-- Coarse Bone Powder
(21154,4041,1,1,2,1448),-- Mold Hardener
(21154,948,1,1,2,416),-- Scroll: Enchant Armor (Grade B)
(21154,4162,1,1,2,691),-- Recipe: Tunic of Doom
(21154,5003,1,1,2,127),-- Recipe: Art of Battle Axe (60%)
(21155,4050,1,1,-1,317155),-- Adamantite Ring Wire
(21155,4051,1,1,-1,198522),-- Adamantite Necklace Chain
(21155,4130,1,1,-1,83099),-- Recipe: Ring of Black Ore
(21155,57,2021,4119,0,700000),-- Adena
(21155,856,1,1,1,108),-- Adamantite Earring
(21155,887,1,1,1,162),-- Adamantite Ring
(21155,918,1,1,1,81),-- Adamantite Necklace
(21155,4049,1,1,1,13218),-- Adamantite Earring Gemstone
(21155,4050,1,1,1,15613),-- Adamantite Ring Wire
(21155,4051,1,1,1,9773),-- Adamantite Necklace Chain
(21155,1895,1,1,2,43201),-- Metallic Fiber
(21155,4040,1,1,2,3024),-- Mold Lubricant
(21155,4042,1,1,2,2520),-- Enria
(21155,4043,1,1,2,5040),-- Asofe
(21155,4154,1,1,2,1789),-- Recipe: Doom Shield
(21155,6037,1,1,2,302407),-- Waking Scroll
(21155,8728,1,1,200,2520),-- Life Stone: level 61
(21155,8738,1,1,200,630),-- Mid-Grade Life Stone: level 61
(21155,8748,1,1,200,63),-- High-Grade Life Stone: level 61
(21155,8758,1,1,200,12),-- Top-Grade Life Stone: level 61
(21156,948,1,1,-1,13735),-- Scroll: Enchant Armor (Grade B)
(21156,4056,1,1,-1,99436),-- Zubei\'s Breastplate Part
(21156,4131,1,1,-1,44665),-- Recipe: Necklace of Black Ore
(21156,57,2177,4415,0,700000),-- Adena
(21156,554,1,1,1,102),-- Zubei\'s Boots
(21156,600,1,1,1,102),-- Avadon Boots
(21156,612,1,1,1,102),-- Zubei\'s Gauntlets
(21156,2464,1,1,1,102),-- Avadon Gloves
(21156,4073,1,1,1,10588),-- Avadon Gloves Part
(21156,4097,1,1,1,10588),-- Zubei\'s Boots Design
(21156,4098,1,1,1,10588),-- Avadon Boots Design
(21156,4100,1,1,1,10588),-- Zubei\'s Gauntlets Part
(21156,1343,20,60,2,105375),-- Silver Arrow
(21156,1865,1,1,2,147526),-- Varnish
(21156,1870,1,1,2,147526),-- Coal
(21156,1875,1,1,2,9835),-- Stone of Purity
(21156,1879,1,1,2,24588),-- Cokes
(21156,4040,1,1,2,2951),-- Mold Lubricant
(21156,4160,1,1,2,418),-- Recipe: Leather Armor of Doom
(21156,8728,1,1,200,2459),-- Life Stone: level 61
(21156,8738,1,1,200,615),-- Mid-Grade Life Stone: level 61
(21156,8748,1,1,200,61),-- High-Grade Life Stone: level 61
(21156,8758,1,1,200,12),-- Top-Grade Life Stone: level 61
(21157,1889,1,1,-1,417768),-- Compound Braid
(21157,4052,1,1,-1,221863),-- Earring of Black Ore Piece
(21157,5549,1,1,-1,626651),-- Metallic Thread
(21157,57,2488,5032,0,700000),-- Adena
(21157,110,1,1,1,95),-- Doom Shield
(21157,2416,1,1,1,66),-- Blue Wolf Helmet
(21157,2417,1,1,1,66),-- Doom Helmet
(21157,4077,1,1,1,13879),-- Doom Shield Fragment
(21157,4088,1,1,1,11660),-- Blue Wolf Helmet Design
(21157,4089,1,1,1,11660),-- Doom Helmet Pattern
(21157,1830,1,1,2,61701),-- Scroll of Escape: Castle
(21157,1832,1,1,2,171391),-- Greater Antidote
(21157,1868,1,3,2,154253),-- Thread
(21157,1873,1,1,2,61701),-- Silver Nugget
(21157,1889,1,1,2,10284),-- Compound Braid
(21157,4044,1,1,2,5142),-- Thons
(21157,5549,1,1,2,15425),-- Metallic Thread
(21157,8487,1,1,2,84),-- Recipe: Destroyer Hammer (60%)
(21157,8729,1,1,200,2057),-- Life Stone: level 64
(21157,8739,1,1,200,514),-- Mid-Grade Life Stone: level 64
(21157,8749,1,1,200,52),-- High-Grade Life Stone: level 64
(21157,8759,1,1,200,10),-- Top-Grade Life Stone: level 64
(21158,4053,1,1,-1,304195),-- Ring of Black Ore Gemstone
(21158,5230,1,1,-1,9462),-- Recipe: Mithril Arrow (100%)
(21158,57,2798,5718,0,700000),-- Adena
(21158,2391,1,1,1,35),-- Blue Wolf Leather Armor
(21158,2392,1,1,1,35),-- Leather Armor of Doom
(21158,4082,1,1,1,5922),-- Blue Wolf Leather Armor Texture
(21158,4083,1,1,1,5922),-- Leather Armor of Doom Design
(21158,1344,30,90,2,72789),-- Mithril Arrow
(21158,1830,1,1,2,69877),-- Scroll of Escape: Castle
(21158,1864,1,3,2,174692),-- Stem
(21158,1869,2,6,2,43673),-- Iron Ore
(21158,1880,1,1,2,17469),-- Steel
(21158,4043,1,1,2,5823),-- Asofe
(21158,5550,1,1,2,2329),-- Durable Metal Plate
(21158,8487,1,1,2,95),-- Recipe: Destroyer Hammer (60%)
(21158,8730,1,1,200,1941),-- Life Stone: level 67
(21158,8740,1,1,200,485),-- Mid-Grade Life Stone: level 67
(21158,8750,1,1,200,49),-- High-Grade Life Stone: level 67
(21158,8760,1,1,200,10),-- Top-Grade Life Stone: level 67
(21159,1874,1,1,-1,488878),-- Oriharukon Ore
(21159,4043,1,1,-1,244439),-- Asofe
(21159,5478,1,1,-1,61665),-- Sealed Dark Crystal Leather Armor Pattern
(21159,57,2901,5897,0,700000),-- Adena
(21159,5304,1,1,1,27),-- Sealed Tallum Tunic
(21159,5305,1,1,1,43),-- Sealed Tallum Stockings
(21159,5308,1,1,1,17),-- Sealed Dark Crystal Robe
(21159,5485,1,1,1,3036),-- Sealed Tallum Tunic Texture
(21159,5486,1,1,1,2136),-- Sealed Dark Crystal Robe Fabric
(21159,5489,1,1,1,4765),-- Sealed Tallum Stockings Fabric
(21159,1344,20,60,2,104141),-- Mithril Arrow
(21159,1865,1,1,2,166623),-- Varnish
(21159,1870,1,1,2,166623),-- Coal
(21159,1874,1,1,2,11108),-- Oriharukon Ore
(21159,3035,1,1,2,222),-- Recipe: Spiritshot A
(21159,4039,1,1,2,5554),-- Mold Glue
(21159,4043,1,1,2,5554),-- Asofe
(21159,8326,1,1,2,62),-- Recipe: Doom Crusher (60%)
(21159,5281,1,1,2,222),-- Recipe: Greater Blessed Spiritshot (A) Compressed Package(100%)
(21159,8730,1,1,200,1851),-- Life Stone: level 67
(21159,8740,1,1,200,463),-- Mid-Grade Life Stone: level 67
(21159,8750,1,1,200,46),-- High-Grade Life Stone: level 67
(21159,8760,1,1,200,9),-- Top-Grade Life Stone: level 67
(21160,1807,1,1,-1,8158),-- Recipe: Soulshot: A-Grade
(21160,5479,1,1,-1,36206),-- Sealed Tallum Leather Armor Pattern
(21160,5482,1,1,-1,80760),-- Sealed Dark Crystalline Leggings Design
(21160,57,3019,6154,0,700000),-- Adena
(21160,5304,1,1,1,28),-- Sealed Tallum Tunic
(21160,5305,1,1,1,45),-- Sealed Tallum Stockings
(21160,5308,1,1,1,17),-- Sealed Dark Crystal Robe
(21160,5485,1,1,1,3166),-- Sealed Tallum Tunic Texture
(21160,5486,1,1,1,2228),-- Sealed Dark Crystal Robe Fabric
(21160,5489,1,1,1,4969),-- Sealed Tallum Stockings Fabric
(21160,729,1,1,2,23),-- Scroll: Enchant Weapon (Grade A)
(21160,1807,1,1,2,274),-- Recipe: Soulshot: A-Grade
(21160,1894,1,1,2,7206),-- Crafted Leather
(21160,4039,1,1,2,6846),-- Mold Glue
(21160,4041,1,1,2,1786),-- Mold Hardener
(21160,4044,1,1,2,6846),-- Thons
(21160,6037,1,1,2,410775),-- Waking Scroll
(21160,8730,1,1,200,2282),-- Life Stone: level 67
(21160,8740,1,1,200,571),-- Mid-Grade Life Stone: level 67
(21160,8750,1,1,200,57),-- High-Grade Life Stone: level 67
(21160,8760,1,1,200,11),-- Top-Grade Life Stone: level 67
(21161,3035,1,1,-1,8917),-- Recipe: Spiritshot A
(21161,4041,1,1,-1,58154),-- Mold Hardener
(21161,5485,1,1,-1,56237),-- Sealed Tallum Tunic Texture
(21161,57,3302,6724,0,700000),-- Adena
(21161,6323,1,1,1,61),-- Sealed Phoenix Necklace
(21161,6324,1,1,1,82),-- Sealed Phoenix Earring
(21161,6325,1,1,1,123),-- Sealed Phoenix Ring
(21161,6341,1,1,1,11382),-- Sealed Phoenix Earring Gemstone
(21161,6343,1,1,1,8799),-- Sealed Phoenix Necklace Beads
(21161,6345,1,1,1,15743),-- Sealed Phoenix Ring Gemstone
(21161,1866,1,1,2,149655),-- Suede
(21161,1871,1,1,2,224483),-- Charcoal
(21161,1877,1,1,2,8979),-- Adamantite Nugget
(21161,4040,1,1,2,4490),-- Mold Lubricant
(21161,4041,1,1,2,1952),-- Mold Hardener
(21161,8326,1,1,2,83),-- Recipe: Doom Crusher (60%)
(21161,5276,1,1,2,299),-- Recipe: Greater Spiritshot (A) Compressed Package(100%)
(21161,8731,1,1,200,2078),-- Life Stone: level 70
(21161,8741,1,1,200,520),-- Mid-Grade Life Stone: level 70
(21161,8751,1,1,200,52),-- High-Grade Life Stone: level 70
(21161,8761,1,1,200,11),-- Top-Grade Life Stone: level 70
(21162,3956,1,1,-1,8930),-- Recipe: Blessed Spiritshot A
(21162,5478,1,1,-1,56317),-- Sealed Dark Crystal Leather Armor Pattern
(21162,5486,1,1,-1,39629),-- Sealed Dark Crystal Robe Fabric
(21162,57,3305,6737,0,700000),-- Adena
(21162,5297,1,1,1,31),-- Sealed Dark Crystal Leather Armor
(21162,5298,1,1,1,49),-- Sealed Dark Crystalline Leggings
(21162,5301,1,1,1,19),-- Sealed Tallum Leather Armor
(21162,5478,1,1,1,3465),-- Sealed Dark Crystal Leather Armor Pattern
(21162,5479,1,1,1,2438),-- Sealed Tallum Leather Armor Pattern
(21162,5482,1,1,1,5439),-- Sealed Dark Crystalline Leggings Design
(21162,1807,1,1,2,300),-- Recipe: Soulshot: A-Grade
(21162,1868,1,3,2,224804),-- Thread
(21162,1873,1,1,2,89922),-- Silver Nugget
(21162,1876,1,1,2,44961),-- Mithril Ore
(21162,1895,1,1,2,64230),-- Metallic Fiber
(21162,4042,1,1,2,3747),-- Enria
(21162,6036,1,1,2,7493),-- Greater Magic Haste Potion
(21162,8731,1,1,200,2082),-- Life Stone: level 70
(21162,8741,1,1,200,520),-- Mid-Grade Life Stone: level 70
(21162,8751,1,1,200,52),-- High-Grade Life Stone: level 70
(21162,8761,1,1,200,11),-- Top-Grade Life Stone: level 70
(21163,729,1,1,-1,789),-- Scroll: Enchant Weapon (Grade A)
(21163,5480,1,1,-1,31860),-- Sealed Leather Armor of Nightmare Fabric
(21163,5481,1,1,-1,31860),-- Sealed Majestic Leather Armor Fabric
(21163,57,3493,7152,0,700000),-- Adena
(21163,5290,1,1,1,74),-- Sealed Dark Crystal Gloves
(21163,5291,1,1,1,74),-- Sealed Dark Crystal Boots
(21163,5295,1,1,1,74),-- Sealed Tallum Gloves
(21163,5296,1,1,1,74),-- Sealed Tallum Boots
(21163,5496,1,1,1,7684),-- Sealed Dark Crystal Boots Lining
(21163,5497,1,1,1,7684),-- Sealed Tallum Boots Lining
(21163,5508,1,1,1,7684),-- Sealed Dark Crystal Gloves Design
(21163,5509,1,1,1,7684),-- Sealed Tallum Gloves Design
(21163,1867,1,3,2,158883),-- Animal Skin
(21163,1872,1,3,2,105922),-- Animal Bone
(21163,1882,1,1,2,52961),-- Leather
(21163,1894,1,1,2,8362),-- Crafted Leather
(21163,4987,1,1,2,989),-- Recipe: Tunic of Doom (60%)
(21163,4042,1,1,2,3972),-- Enria
(21163,729,1,1,2,26),-- Scroll: Enchant Weapon (Grade A)
(21163,8731,1,1,200,2207),-- Life Stone: level 70
(21163,8741,1,1,200,552),-- Mid-Grade Life Stone: level 70
(21163,8751,1,1,200,55),-- High-Grade Life Stone: level 70
(21163,8761,1,1,200,11),-- Top-Grade Life Stone: level 70
(21164,5480,1,1,-1,36564),-- Sealed Leather Armor of Nightmare Fabric
(21164,5481,1,1,-1,36564),-- Sealed Majestic Leather Armor Fabric
(21164,5487,1,1,-1,36693),-- Sealed Robe of Nightmare Fabric
(21164,57,4018,8199,0,700000),-- Adena
(21164,6326,1,1,1,50),-- Sealed Majestic Necklace
(21164,6327,1,1,1,67),-- Sealed Majestic Earring
(21164,6328,1,1,1,100),-- Sealed Majestic Ring
(21164,6342,1,1,1,11360),-- Sealed Majestic Earring Gemstone
(21164,6344,1,1,1,7351),-- Sealed Majestic Necklace Beads
(21164,6346,1,1,1,16327),-- Sealed Majestic Ring Gemstone
(21164,729,1,1,2,37),-- Scroll: Enchant Weapon (Grade A)
(21164,1866,1,1,2,222865),-- Suede
(21164,1871,1,3,2,167148),-- Charcoal
(21164,1877,1,1,2,13372),-- Adamantite Nugget
(21164,4040,1,1,2,6686),-- Mold Lubricant
(21164,8732,1,1,200,2786),-- Life Stone: level 76
(21164,8742,1,1,200,697),-- Mid-Grade Life Stone: level 76
(21164,8752,1,1,200,70),-- High-Grade Life Stone: level 76
(21164,4041,1,1,2,2907); -- Mold Hardener

INSERT INTO `droplist` VALUES 
(21165,730,1,1,-1,7011),-- Scroll: Enchant Armor (Grade A)
(21165,5488,1,1,-1,37883),-- Sealed Majestic Robe Fabric
(21165,5495,1,1,-1,127745),-- Sealed Shield of Nightmare Fragment
(21165,57,4147,8467,0,700000),-- Adena
(21165,5320,1,1,1,24),-- Sealed Leather Armor of Nightmare
(21165,5323,1,1,1,24),-- Sealed Majestic Leather Armor
(21165,5480,1,1,1,3485),-- Sealed Leather Armor of Nightmare Fabric
(21165,5481,1,1,1,3485),-- Sealed Majestic Leather Armor Fabric
(21165,729,1,1,2,34),-- Scroll: Enchant Weapon (Grade A)
(21165,730,1,1,2,259),-- Scroll: Enchant Armor (Grade A)
(21165,1895,1,1,2,88749),-- Metallic Fiber
(21165,4040,1,1,2,6213),-- Mold Lubricant
(21165,4042,1,1,2,5177),-- Enria
(21165,4043,1,1,2,10354),-- Asofe
(21165,6037,1,3,2,310621),-- Waking Scroll
(21165,8732,1,1,200,2589),-- Life Stone: level 76
(21165,8742,1,1,200,647),-- Mid-Grade Life Stone: level 76
(21165,8752,1,1,200,65),-- High-Grade Life Stone: level 76
(21166,1868,1,3,-1,886728),-- Thread
(21166,1873,1,1,-1,354691),-- Silver Nugget
(21166,1898,1,1,-1,91087),-- Blue Diamond Necklace Gem
(21166,6360,53,109,0,700000),-- Blue Seal Stone
(21166,25,1,1,1,713),-- Piece Bone Breastplate
(21166,26,1,1,1,462),-- Bronze Breastplate
(21166,32,1,1,1,1141),-- Piece Bone Gaiters
(21166,34,1,1,1,740),-- Bronze Gaiters
(21166,1926,1,1,1,8819),-- Piece Bone Breastplate Fragment
(21166,1928,1,1,1,12718),-- Piece Bone Gaiters Fragment
(21166,1868,1,3,2,130963),-- Thread
(21166,1873,1,1,2,52385),-- Silver Nugget
(21166,2176,1,1,2,62661),-- Recipe: Leather Boots
(21166,6037,1,3,2,87309),-- Waking Scroll
(21166,6362,23,42,4,700000),-- Red Seal Stone
(21167,1804,1,1,-1,39326),-- Recipe: Soulshot: D-Grade
(21167,1926,1,1,-1,99308),-- Piece Bone Breastplate Fragment
(21167,2151,1,1,-1,273857),-- Recipe: Necklace of Devotion
(21167,6360,72,143,0,700000),-- Blue Seal Stone
(21167,1102,1,1,1,2045),-- Tunic of Magic
(21167,1105,1,1,1,3282),-- Stockings of Magic
(21167,735,1,1,2,12101),-- Potion of Alacrity
(21167,1867,1,1,2,193605),-- Animal Skin
(21167,1872,1,1,2,193605),-- Animal Bone
(21167,1882,1,1,2,32267),-- Leather
(21167,6362,21,39,4,700000),-- Red Seal Stone
(21168,1889,1,1,-1,78778),-- Compound Braid
(21168,1899,1,1,-1,184636),-- Necklace of Devotion Chain
(21168,5549,1,1,-1,118167),-- Metallic Thread
(21168,6360,97,190,0,700000),-- Blue Seal Stone
(21168,847,1,1,1,1602),-- Red Crescent Earring
(21168,890,1,1,1,2403),-- Ring of Devotion
(21168,910,1,1,1,1201),-- Necklace of Devotion
(21168,1899,1,1,1,25906),-- Necklace of Devotion Chain
(21168,1868,1,3,2,110531),-- Thread
(21168,1873,1,1,2,44213),-- Silver Nugget
(21168,1889,1,1,2,7369),-- Compound Braid
(21168,2262,1,1,2,1716),-- Recipe: Elven Bow
(21168,5549,1,1,2,11053),-- Metallic Thread
(21168,6037,1,1,2,221063),-- Waking Scroll
(21168,6362,22,41,4,700000),-- Red Seal Stone
(21169,1061,1,1,-1,881783),-- Healing Potion
(21169,1900,1,1,-1,159184),-- Enchanted Necklace Chain
(21169,2153,1,1,-1,226274),-- Recipe: Tiger\'s Eye Earring
(21169,6360,128,259,0,700000),-- Blue Seal Stone
(21169,605,1,1,1,3106),-- Leather Gauntlets
(21169,1123,1,1,1,3106),-- Blue Buckskin Boots
(21169,1864,1,3,2,159014),-- Stem
(21169,1869,1,1,2,159014),-- Iron Ore
(21169,1880,1,1,2,15901),-- Steel
(21169,2153,1,1,2,24730),-- Recipe: Tiger\'s Eye Earring
(21169,5550,1,1,2,2120),-- Durable Metal Plate
(21169,6362,24,44,4,700000),-- Red Seal Stone
(21170,1901,1,1,-1,222980),-- Tiger\'s Eye Earring Stone
(21170,1938,1,1,-1,108529),-- Mithril Banded Mail Material
(21170,2154,1,1,-1,172845),-- Recipe: Elven Earring
(21170,6360,108,211,0,700000),-- Blue Seal Stone
(21170,47,1,1,1,1465),-- Helmet
(21170,628,1,1,1,2093),-- Hoplon
(21170,1864,1,1,2,286116),-- Stem
(21170,1869,1,1,2,143058),-- Iron Ore
(21170,1880,1,1,2,14306),-- Steel
(21170,2155,1,1,2,22963),-- Recipe: Elven Ring
(21170,5550,1,1,2,1908),-- Durable Metal Plate
(21170,6035,1,1,2,11921),-- Magic Haste Potion
(21170,6361,33,63,3,700000),-- Green Seal Stone
(21170,6362,22,41,4,700000),-- Red Seal Stone
(21171,1865,1,5,-1,684631),-- Varnish
(21171,1870,1,5,-1,684631),-- Coal
(21171,1939,1,1,-1,180403),-- Mithril Banded Gaiters Material
(21171,6360,96,192,0,700000),-- Blue Seal Stone
(21171,83,1,1,1,66),-- Sword of Magic
(21171,124,1,1,1,49),-- Two-Handed Sword
(21171,127,1,1,1,49),-- Crimson Sword
(21171,130,1,1,1,49),-- Elven Sword
(21171,144,1,1,1,66),-- Sword of Occult
(21171,2026,1,1,1,2191),-- Two-Handed Sword Edge
(21171,1865,1,1,2,273010),-- Varnish
(21171,1870,1,3,2,136505),-- Coal
(21171,1874,1,1,2,18201),-- Oriharukon Ore
(21171,2191,1,1,2,36548),-- Recipe: RIP Gauntlets
(21171,6361,68,136,3,700000),-- Green Seal Stone
(21171,6362,24,44,4,700000),-- Red Seal Stone
(21172,1825,1,1,-1,172903),-- Recipe: Oriharukon
(21172,1902,1,1,-1,245252),-- Elven Earring Beads
(21172,2145,1,1,-1,172903),-- Recipe: Mithril Alloy
(21172,6360,89,178,0,700000),-- Blue Seal Stone
(21172,88,1,1,1,23),-- Morning Star
(21172,90,1,1,1,23),-- Goat Head Staff
(21172,158,1,1,1,23),-- Tarbar
(21172,169,1,1,1,23),-- Skull Breaker
(21172,172,1,1,1,23),-- Heavy Bone Club
(21172,2031,1,1,1,1267),-- Morning Star Head
(21172,2032,1,1,1,1157),-- Goat Head Staff Head
(21172,2035,1,1,1,1267),-- Tarbar Head
(21172,2036,1,1,1,1267),-- Skull Breaker Head
(21172,2037,1,1,1,1267),-- Heavy Bone Club Head
(21172,1341,60,180,2,139031),-- Bone Arrow
(21172,1866,1,1,2,166838),-- Suede
(21172,1871,2,6,2,62564),-- Charcoal
(21172,1877,1,1,2,10010),-- Adamantite Nugget
(21172,2147,1,1,2,178765),-- Recipe: Blacksmith\'s frame
(21172,6361,105,206,3,700000),-- Green Seal Stone
(21172,6362,24,45,4,700000),-- Red Seal Stone
(21173,1875,1,1,-1,173070),-- Stone of Purity
(21173,1881,1,1,-1,346140),-- Coarse Bone Powder
(21173,1905,1,1,-1,252534),-- Omen Beast\'s Eye Earring Gemstone
(21173,6360,56,111,0,700000),-- Blue Seal Stone
(21173,262,1,1,1,94),-- Scallop Jamadhr
(21173,2053,1,1,1,5390),-- Scallop Jamadhr Edge
(21173,1805,1,1,2,543),-- Recipe: Soulshot: C-Grade
(21173,1867,1,1,2,217269),-- Animal Skin
(21173,1872,1,1,2,217269),-- Animal Bone
(21173,1875,1,1,2,10863),-- Stone of Purity
(21173,1881,1,1,2,21727),-- Coarse Bone Powder
(21173,2990,1,1,2,12933),-- Recipe: Chain Boots
(21173,5164,1,1,2,543),-- Recipe: Blessed Spiritshot (C) Compressed Package (100%)
(21173,6036,1,1,2,5433),-- Greater Magic Haste Potion
(21173,6361,137,274,3,700000),-- Green Seal Stone
(21173,6362,22,41,4,700000),-- Red Seal Stone
(21174,1873,1,3,-1,667898),-- Silver Nugget
(21174,1908,1,1,-1,316239),-- Moonstone Earring Wire
(21174,2163,1,1,-1,170382),-- Recipe: Earring of Protection
(21174,6360,33,62,0,700000),-- Blue Seal Stone
(21174,281,1,1,1,90),-- Crystallized Ice Bow
(21174,2074,1,1,1,5589),-- Crystallized Ice Bow Shaft
(21174,1868,1,3,2,225471),-- Thread
(21174,1873,1,1,2,90188),-- Silver Nugget
(21174,1876,1,1,2,45094),-- Mithril Ore
(21174,1895,1,1,2,64420),-- Metallic Fiber
(21174,2164,1,1,2,17344),-- Recipe: Ring of Protection
(21174,3002,1,1,2,14005),-- Recipe: Dwarven Chain Gloves
(21174,4042,1,1,2,3758),-- Enria
(21174,6361,211,425,3,700000),-- Green Seal Stone
(21174,6362,25,45,4,700000),-- Red Seal Stone
(21175,440,1,1,-1,1258),-- Robe of Seal
(21175,1912,1,1,-1,409204),-- Ring of Protection Gemstone
(21175,4590,1,1,-1,12658),-- Greater Dye of Strength <Str+2 Dex-2>
(21175,227,1,1,1,38),-- Stiletto
(21175,242,1,1,1,38),-- Soulfire Dirk
(21175,2083,1,1,1,2795),-- Stiletto Edge
(21175,2084,1,1,1,2795),-- Soulfire Dirk Blade
(21175,951,1,1,2,437),-- Scroll: Enchant Weapon (Grade C)
(21175,1866,1,1,2,160242),-- Suede
(21175,1871,1,3,2,80121),-- Charcoal
(21175,1877,1,1,2,9615),-- Adamantite Nugget
(21175,4040,1,1,2,4807),-- Mold Lubricant
(21175,4041,1,1,2,2090),-- Mold Hardener
(21175,6037,1,3,2,240364),-- Waking Scroll
(21175,6361,268,532,3,700000),-- Green Seal Stone
(21175,6362,25,45,4,700000),-- Red Seal Stone
(21176,1872,1,11,-1,85908),-- Animal Bone
(21176,4041,1,1,-1,33616),-- Mold Hardener
(21176,4601,1,1,-1,8591),-- Greater Dye of Strength <Str+3 Con-3>
(21176,6360,133,267,0,700000),-- Blue Seal Stone
(21176,326,1,1,1,48),-- Heathen\'s Book
(21176,2110,1,1,1,4506),-- Heathen\'s Book Page
(21176,1864,4,12,2,57096),-- Stem
(21176,1865,2,6,2,45677),-- Varnish
(21176,1866,3,9,2,25376),-- Suede
(21176,1868,1,3,2,152255),-- Thread
(21176,1873,1,1,2,91953),-- Silver Nugget
(21176,2232,1,1,2,1313),-- Recipe: Drake Leather Armor
(21176,3012,1,1,2,4261),-- Recipe: Full Plate Helmet
(21176,6361,219,437,3,700000),-- Green Seal Stone
(21176,6362,11,22,4,700000),-- Red Seal Stone
(21177,1806,1,1,-1,10550),-- Recipe: Soulshot: B-Grade
(21177,1920,1,1,-1,180500),-- Necklace of Binding Chain
(21177,4594,1,1,-1,17584),-- Greater Dye of Dexterity <Dex+2 Con-2>
(21177,6360,148,301,0,700000),-- Blue Seal Stone
(21177,299,1,1,1,14),-- Orcish Poleaxe
(21177,301,1,1,1,18),-- Scorpion
(21177,303,1,1,1,18),-- Widow Maker
(21177,2113,1,1,1,1572),-- Scorpion Blade
(21177,2114,1,1,1,1572),-- Widowmaker Head
(21177,2122,1,1,1,1482),-- Orcish Poleaxe Blade
(21177,1868,1,3,2,243467),-- Thread
(21177,1873,1,1,2,97387),-- Silver Nugget
(21177,1876,1,1,2,48693),-- Mithril Ore
(21177,1895,1,1,2,69562),-- Metallic Fiber
(21177,3034,1,1,2,487),-- Recipe: Spiritshot B
(21177,4042,1,1,2,4058),-- Enria
(21177,4944,1,1,2,1171),-- Recipe: Avadon Breastplate (60%)
(21177,4968,1,1,2,280),-- Recipe: Kris (60%)
(21177,6361,314,633,3,700000),-- Green Seal Stone
(21177,6362,13,27,4,700000),-- Red Seal Stone
(21178,947,1,1,-1,2262),-- Scroll: Enchant Weapon (Grade B)
(21178,4129,1,1,-1,61196),-- Recipe: Earrings of Black Ore
(21178,4610,1,1,-1,12566),-- Greater Dye of Mental Strength <Men+3 Wit-3>
(21178,6360,73,146,0,700000),-- Blue Seal Stone
(21178,2384,1,1,1,47),-- Zubei\'s Leather Shirt
(21178,2388,1,1,1,74),-- Zubei\'s Leather Gaiters
(21178,2390,1,1,1,29),-- Avadon Leather Armor
(21178,4066,1,1,1,6565),-- Zubei\'s Leather Shirt Fabric
(21178,4067,1,1,1,9967),-- Zubei\'s Leather Gaiter Texture
(21178,4068,1,1,1,5043),-- Avadon Leather Armor Lining
(21178,948,1,1,2,522),-- Scroll: Enchant Armor (Grade B)
(21178,1867,1,1,2,278377),-- Animal Skin
(21178,1872,1,3,2,139189),-- Animal Bone
(21178,1875,1,1,2,13919),-- Stone of Purity
(21178,1881,1,1,2,27838),-- Coarse Bone Powder
(21178,4041,1,1,2,1816),-- Mold Hardener
(21178,4162,1,1,2,866),-- Recipe: Tunic of Doom
(21178,5003,1,1,2,159),-- Recipe: Art of Battle Axe (60%)
(21178,6361,391,782,3,700000),-- Green Seal Stone
(21178,6362,13,26,4,700000),-- Red Seal Stone
(21179,947,1,1,-1,2174),-- Scroll: Enchant Weapon (Grade B)
(21179,1872,1,15,-1,906001),-- Animal Bone
(21179,4613,1,1,-1,7498),-- Greater Dye of Strength <Str+4 Con-4>
(21179,6360,7,15,0,700000),-- Blue Seal Stone
(21179,357,1,1,1,25),-- Zubei\'s Breastplate
(21179,383,1,1,1,40),-- Zubei\'s Gaiters
(21179,2376,1,1,1,25),-- Avadon Breastplate
(21179,2379,1,1,1,40),-- Avadon Gaiters
(21179,4056,1,1,1,3634),-- Zubei\'s Breastplate Part
(21179,4057,1,1,1,5616),-- Zubei\'s Gaiter Material
(21179,4064,1,1,1,3634),-- Avadon Breastplate Part
(21179,4065,1,1,1,5616),-- Avadon Gaiters Material
(21179,1343,20,60,2,163848),-- Silver Arrow
(21179,1867,2,6,2,76463),-- Animal Skin
(21179,1872,1,3,2,101950),-- Animal Bone
(21179,1875,1,1,2,15293),-- Stone of Purity
(21179,1881,1,1,2,30585),-- Coarse Bone Powder
(21179,4041,1,1,2,1994),-- Mold Hardener
(21179,4155,1,1,2,713),-- Recipe: Blue Wolf Breastplate
(21179,6361,415,830,3,700000),-- Green Seal Stone
(21179,6362,11,22,4,700000),-- Red Seal Stone
(21180,4052,1,1,-1,271551),-- Earring of Black Ore Piece
(21180,4053,1,1,-1,328759),-- Ring of Black Ore Gemstone
(21180,5230,1,1,-1,10227),-- Recipe: Mithril Arrow (100%)
(21180,2398,1,1,1,31),-- Blue Wolf Tunic
(21180,2399,1,1,1,31),-- Tunic of Doom
(21180,2403,1,1,1,49),-- Blue Wolf Stockings
(21180,2404,1,1,1,49),-- Stockings of Doom
(21180,4084,1,1,1,4923),-- Blue Wolf Tunic Fabric
(21180,4085,1,1,1,4923),-- Tunic of Doom Pattern
(21180,4086,1,1,1,6648),-- Blue Wolf Stockings Pattern
(21180,4087,1,1,1,6648),-- Stockings of Doom Pattern
(21180,1830,1,1,2,151039),-- Scroll of Escape: Castle
(21180,1866,1,3,2,83910),-- Suede
(21180,1871,1,3,2,188799),-- Charcoal
(21180,1877,1,1,2,15104),-- Adamantite Nugget
(21180,4040,1,1,2,7552),-- Mold Lubricant
(21180,4041,1,1,2,3284),-- Mold Hardener
(21180,6361,574,1144,3,700000),-- Green Seal Stone
(21180,6362,14,28,4,700000),-- Red Seal Stone
(21181,4041,1,1,-1,70764),-- Mold Hardener
(21181,4054,1,1,-1,160289),-- Necklace of Black Ore Beads
(21181,5230,1,1,-1,10851),-- Recipe: Mithril Arrow (100%)
(21181,864,1,1,1,113),-- Earring of Black Ore
(21181,895,1,1,1,169),-- Ring of Black Ore
(21181,926,1,1,1,85),-- Necklace of Black Ore
(21181,4052,1,1,1,14183),-- Earring of Black Ore Piece
(21181,4053,1,1,1,17172),-- Ring of Black Ore Gemstone
(21181,4054,1,1,1,7891),-- Necklace of Black Ore Beads
(21181,1867,1,3,2,152623),-- Animal Skin
(21181,1872,1,3,2,228934),-- Animal Bone
(21181,1875,1,1,2,22894),-- Stone of Purity
(21181,1881,1,1,2,45787),-- Coarse Bone Powder
(21181,4041,1,1,2,2986),-- Mold Hardener
(21181,5230,1,1,2,458),-- Recipe: Mithril Arrow (100%)
(21181,5276,1,1,2,458),-- Recipe: Greater Spiritshot (A) Compressed Package(100%)
(21181,6361,578,1160,3,700000),-- Green Seal Stone
(21181,6362,14,27,4,700000),-- Red Seal Stone
(21182,1876,1,3,-1,736126),-- Mithril Ore
(21182,5478,1,2,-1,61902),-- Sealed Dark Crystal Leather Armor Pattern
(21182,5290,1,1,1,61),-- Sealed Dark Crystal Gloves
(21182,5291,1,1,1,61),-- Sealed Dark Crystal Boots
(21182,5295,1,1,1,61),-- Sealed Tallum Gloves
(21182,5296,1,1,1,61),-- Sealed Tallum Boots
(21182,5496,1,1,1,6374),-- Sealed Dark Crystal Boots Lining
(21182,5497,1,1,1,6374),-- Sealed Tallum Boots Lining
(21182,5508,1,1,1,6374),-- Sealed Dark Crystal Gloves Design
(21182,5509,1,1,1,6374),-- Sealed Tallum Gloves Design
(21182,1344,30,90,2,129431),-- Mithril Arrow
(21182,1868,4,12,2,77658),-- Thread
(21182,1873,1,1,2,124253),-- Silver Nugget
(21182,1876,1,1,2,62127),-- Mithril Ore
(21182,1895,1,1,2,88752),-- Metallic Fiber
(21182,4042,1,1,2,5177),-- Enria
(21182,5156,1,1,2,414),-- Recipe: Soulshot (A) Compressed Package (100%)
(21182,6361,512,1023,3,700000),-- Green Seal Stone
(21182,6362,11,22,4,700000),-- Red Seal Stone
(21183,1807,1,1,-1,10950),-- Recipe: Soulshot: A-Grade
(21183,3035,1,1,-1,10950),-- Recipe: Spiritshot A
(21183,5479,1,1,-1,48593),-- Sealed Tallum Leather Armor Pattern
(21183,5289,1,1,1,76),-- Sealed Dark Crystal Helmet
(21183,5292,1,1,1,108),-- Sealed Dark Crystal Shield
(21183,5294,1,1,1,76),-- Sealed Tallum Helmet
(21183,5494,1,1,1,10613),-- Sealed Dark Crystal Shield Fragment
(21183,5525,1,1,1,7811),-- Sealed Dark Crystal Helmet Design
(21183,5526,1,1,1,7811),-- Sealed Tallum Helm Design
(21183,1894,1,1,2,21279),-- Crafted Leather
(21183,3956,1,1,2,809),-- Recipe: Blessed Spiritshot A
(21183,4039,1,1,2,20215),-- Mold Glue
(21183,4041,1,1,2,5273),-- Mold Hardener
(21183,4044,1,1,2,20215),-- Thons
(21183,6361,687,1380,3,700000),-- Green Seal Stone
(21183,6362,14,28,4,700000),-- Red Seal Stone
(21184,729,1,1,-1,957),-- Scroll: Enchant Weapon (Grade A)
(21184,1895,1,5,-1,820300),-- Metallic Fiber
(21184,5480,1,1,-1,38649),-- Sealed Leather Armor of Nightmare Fabric
(21184,5304,1,1,1,40),-- Sealed Tallum Tunic
(21184,5305,1,1,1,63),-- Sealed Tallum Stockings
(21184,5308,1,1,1,24),-- Sealed Dark Crystal Robe
(21184,5485,1,1,1,4457),-- Sealed Tallum Tunic Texture
(21184,5486,1,1,1,3136),-- Sealed Dark Crystal Robe Fabric
(21184,5489,1,1,1,6995),-- Sealed Tallum Stockings Fabric
(21184,1867,1,3,2,192742),-- Animal Skin
(21184,1872,1,3,2,128494),-- Animal Bone
(21184,1882,1,1,2,64247),-- Leather
(21184,1894,1,1,2,10144),-- Crafted Leather
(21184,4042,1,1,2,4819),-- Enria
(21184,729,1,1,2,32),-- Scroll: Enchant Weapon (Grade A)
(21184,4987,1,1,2,1200),-- Recipe: Tunic of Doom (60%)
(21184,8731,1,1,200,2677),-- Life Stone: level 70
(21184,8741,1,1,200,669),-- Mid-Grade Life Stone: level 70
(21184,8751,1,1,200,67),-- High-Grade Life Stone: level 70
(21184,8761,1,1,200,14),-- Top-Grade Life Stone: level 70
(21184,6361,700,1400,3,700000),-- Green Seal Stone
(21184,6362,14,27,4,700000),-- Red Seal Stone
(21185,1875,1,1,-1,513582),-- Stone of Purity
(21185,5481,1,1,-1,34568),-- Sealed Majestic Leather Armor Fabric
(21185,5487,1,1,-1,34691),-- Sealed Robe of Nightmare Fabric
(21185,5304,1,1,1,35),-- Sealed Tallum Tunic
(21185,5305,1,1,1,57),-- Sealed Tallum Stockings
(21185,5308,1,1,1,22),-- Sealed Dark Crystal Robe
(21185,5485,1,1,1,3986),-- Sealed Tallum Tunic Texture
(21185,5486,1,1,1,2805),-- Sealed Dark Crystal Robe Fabric
(21185,5489,1,1,1,6257),-- Sealed Tallum Stockings Fabric
(21185,1868,3,9,2,94815),-- Thread
(21185,1873,1,1,2,113778),-- Silver Nugget
(21185,1876,1,1,2,56889),-- Mithril Ore
(21185,1895,1,1,2,81270),-- Metallic Fiber
(21185,4042,1,1,2,4741),-- Enria
(21185,6671,1,1,2,31605),-- Deluxe Chest Key - Grade 7
(21185,5282,1,1,2,126),-- Recipe: Greater Blessed Spiritshot (S) Compressed Package(100%)
(21185,8732,1,1,200,2370),-- Life Stone: level 76
(21185,8742,1,1,200,593),-- Mid-Grade Life Stone: level 76
(21185,8752,1,1,200,59),-- High-Grade Life Stone: level 76
(21185,6361,612,1227,3,700000),-- Green Seal Stone
(21185,6362,11,22,4,700000),-- Red Seal Stone
(21186,730,1,1,-1,8621),-- Scroll: Enchant Armor (Grade A)
(21186,5480,1,1,-1,46420),-- Sealed Leather Armor of Nightmare Fabric
(21186,5488,1,1,-1,46584),-- Sealed Majestic Robe Fabric
(21186,5312,1,1,1,63),-- Sealed Helm of Nightmare
(21186,5315,1,1,1,90),-- Sealed Shield of Nightmare
(21186,5317,1,1,1,63),-- Sealed Majestic Circlet
(21186,5495,1,1,1,9666),-- Sealed Shield of Nightmare Fragment
(21186,5527,1,1,1,7611),-- Sealed Helm of Nightmare Design
(21186,5528,1,1,1,7611),-- Sealed Majestic Circlet Design
(21186,729,1,1,2,70),-- Scroll: Enchant Weapon (Grade A)
(21186,1866,1,3,2,141469),-- Suede
(21186,1871,4,12,2,79577),-- Charcoal
(21186,1877,1,1,2,25464),-- Adamantite Nugget
(21186,4040,1,1,2,12732),-- Mold Lubricant
(21186,4041,1,1,2,5536),-- Mold Hardener
(21186,6361,805,1610,3,700000),-- Green Seal Stone
(21186,6362,14,28,4,700000),-- Red Seal Stone
(21187,1868,1,3,-1,886728),-- Thread
(21187,1873,1,1,-1,354691),-- Silver Nugget
(21187,1898,1,1,-1,91087),-- Blue Diamond Necklace Gem
(21187,6360,53,109,0,700000),-- Blue Seal Stone
(21187,25,1,1,1,713),-- Piece Bone Breastplate
(21187,26,1,1,1,462),-- Bronze Breastplate
(21187,32,1,1,1,1141),-- Piece Bone Gaiters
(21187,34,1,1,1,740),-- Bronze Gaiters
(21187,1926,1,1,1,8819),-- Piece Bone Breastplate Fragment
(21187,1928,1,1,1,12718),-- Piece Bone Gaiters Fragment
(21187,1868,1,1,2,261926),-- Thread
(21187,1873,1,1,2,52385),-- Silver Nugget
(21187,2176,1,1,2,62662),-- Recipe: Leather Boots
(21187,6035,1,1,2,10913),-- Magic Haste Potion
(21187,6362,23,42,4,700000),-- Red Seal Stone
(21188,1804,1,1,-1,39326),-- Recipe: Soulshot: D-Grade
(21188,1926,1,1,-1,99308),-- Piece Bone Breastplate Fragment
(21188,2151,1,1,-1,273857),-- Recipe: Necklace of Devotion
(21188,6360,72,143,0,700000),-- Blue Seal Stone
(21188,1102,1,1,1,2045),-- Tunic of Magic
(21188,1105,1,1,1,3282),-- Stockings of Magic
(21188,735,1,1,2,12101),-- Potion of Alacrity
(21188,1867,1,1,2,193605),-- Animal Skin
(21188,1872,1,1,2,193605),-- Animal Bone
(21188,1882,1,1,2,32267),-- Leather
(21188,6362,21,39,4,700000),-- Red Seal Stone
(21189,1889,1,1,-1,78778),-- Compound Braid
(21189,1899,1,1,-1,184636),-- Necklace of Devotion Chain
(21189,5549,1,1,-1,118167),-- Metallic Thread
(21189,6360,97,190,0,700000),-- Blue Seal Stone
(21189,847,1,1,1,1602),-- Red Crescent Earring
(21189,890,1,1,1,2403),-- Ring of Devotion
(21189,910,1,1,1,1201),-- Necklace of Devotion
(21189,1899,1,1,1,25906),-- Necklace of Devotion Chain
(21189,1868,1,1,2,265276),-- Thread
(21189,1873,1,1,2,53055),-- Silver Nugget
(21189,1889,1,1,2,8843),-- Compound Braid
(21189,2262,1,1,2,2059),-- Recipe: Elven Bow
(21189,5549,1,1,2,13264),-- Metallic Thread
(21189,6362,22,41,4,700000),-- Red Seal Stone
(21190,1061,1,1,-1,881783),-- Healing Potion
(21190,1900,1,1,-1,159184),-- Enchanted Necklace Chain
(21190,2153,1,1,-1,226274),-- Recipe: Tiger\'s Eye Earring
(21190,6360,128,259,0,700000),-- Blue Seal Stone
(21190,605,1,1,1,3106),-- Leather Gauntlets
(21190,1123,1,1,1,3106),-- Blue Buckskin Boots
(21190,1864,1,1,2,265023),-- Stem
(21190,1869,1,1,2,132512),-- Iron Ore
(21190,1880,1,1,2,13251),-- Steel
(21190,2153,1,1,2,20608),-- Recipe: Tiger\'s Eye Earring
(21190,5550,1,1,2,1767),-- Durable Metal Plate
(21190,6035,1,1,2,11042),-- Magic Haste Potion
(21190,6362,24,44,4,700000),-- Red Seal Stone
(21191,1901,1,1,-1,222980),-- Tiger\'s Eye Earring Stone
(21191,1938,1,1,-1,108529),-- Mithril Banded Mail Material
(21191,2154,1,1,-1,172845),-- Recipe: Elven Earring
(21191,6360,108,211,0,700000),-- Blue Seal Stone
(21191,47,1,1,1,1465),-- Helmet
(21191,628,1,1,1,2093),-- Hoplon
(21191,1864,1,3,2,171670),-- Stem
(21191,1869,1,1,2,171670),-- Iron Ore
(21191,1880,1,1,2,17167),-- Steel
(21191,2155,1,1,2,27556),-- Recipe: Elven Ring
(21191,5550,1,1,2,2289),-- Durable Metal Plate
(21191,6361,33,63,3,700000),-- Green Seal Stone
(21191,6362,22,41,4,700000),-- Red Seal Stone
(21192,1865,1,5,-1,684631),-- Varnish
(21192,1870,1,5,-1,684631),-- Coal
(21192,1939,1,1,-1,180403),-- Mithril Banded Gaiters Material
(21192,6360,96,192,0,700000),-- Blue Seal Stone
(21192,83,1,1,1,66),-- Sword of Magic
(21192,124,1,1,1,49),-- Two-Handed Sword
(21192,127,1,1,1,49),-- Crimson Sword
(21192,130,1,1,1,49),-- Elven Sword
(21192,144,1,1,1,66),-- Sword of Occult
(21192,2026,1,1,1,2191),-- Two-Handed Sword Edge
(21192,1865,1,1,2,218408),-- Varnish
(21192,1870,1,1,2,218408),-- Coal
(21192,1874,1,1,2,1456),-- Oriharukon Ore
(21192,2191,1,1,2,29238),-- Recipe: RIP Gauntlets
(21192,8317,1,1,2,1559),-- Recipe: Titan Hammer (100%)
(21192,6361,68,136,3,700000),-- Green Seal Stone
(21192,6362,24,44,4,700000),-- Red Seal Stone
(21193,1825,1,1,-1,172903),-- Recipe: Oriharukon
(21193,1902,1,1,-1,245252),-- Elven Earring Beads
(21193,2145,1,1,-1,172903),-- Recipe: Mithril Alloy
(21193,6360,89,178,0,700000),-- Blue Seal Stone
(21193,88,1,1,1,23),-- Morning Star
(21193,90,1,1,1,23),-- Goat Head Staff
(21193,158,1,1,1,23),-- Tarbar
(21193,169,1,1,1,23),-- Skull Breaker
(21193,172,1,1,1,23),-- Heavy Bone Club
(21193,2031,1,1,1,1267),-- Morning Star Head
(21193,2032,1,1,1,1156),-- Goat Head Staff Head
(21193,2035,1,1,1,1267),-- Tarbar Head
(21193,2036,1,1,1,1267),-- Skull Breaker Head
(21193,2037,1,1,1,1267),-- Heavy Bone Club Head
(21193,1866,1,1,2,208548),-- Suede
(21193,1871,1,3,2,156410),-- Charcoal
(21193,1877,1,1,2,12513),-- Adamantite Nugget
(21193,2147,1,1,2,22344),-- Recipe: Blacksmith\'s frame
(21193,6361,105,206,3,700000),-- Green Seal Stone
(21193,6362,24,45,4,700000),-- Red Seal Stone
(21194,1875,1,1,-1,173070),-- Stone of Purity
(21194,1881,1,1,-1,346140),-- Coarse Bone Powder
(21194,1905,1,1,-1,252534),-- Omen Beast\'s Eye Earring Gemstone
(21194,6360,56,111,0,700000),-- Blue Seal Stone
(21194,262,1,1,1,94),-- Scallop Jamadhr
(21194,2053,1,1,1,5390),-- Scallop Jamadhr Edge
(21194,1805,1,1,2,621),-- Recipe: Soulshot: C-Grade
(21194,1867,2,6,2,62077),-- Animal Skin
(21194,1872,1,3,2,82769),-- Animal Bone
(21194,1875,1,1,2,12415),-- Stone of Purity
(21194,1881,1,1,2,24831),-- Coarse Bone Powder
(21194,2994,1,1,2,14780),-- Recipe: Boots of Seal
(21194,6037,1,3,2,186231),-- Waking Scroll
(21194,6361,137,274,3,700000),-- Green Seal Stone
(21194,6362,22,41,4,700000),-- Red Seal Stone
(21195,440,1,1,-1,1106),-- Robe of Seal
(21195,1908,1,2,-1,316239),-- Moonstone Earring Wire
(21195,6360,33,62,0,700000),-- Blue Seal Stone
(21195,281,1,1,1,90),-- Crystallized Ice Bow
(21195,2074,1,1,1,5589),-- Crystallized Ice Bow Shaft
(21195,1868,1,3,2,197286),-- Thread
(21195,1873,1,1,2,78519),-- Silver Nugget
(21195,1876,1,1,2,39457),-- Mithril Ore
(21195,1895,1,1,2,56368),-- Metallic Fiber
(21195,2164,1,1,2,15176),-- Recipe: Ring of Protection
(21195,2228,1,1,2,5361),-- Recipe: Shining Circlet
(21195,4042,1,1,2,3288),-- Enria
(21195,6036,1,1,2,6576),-- Greater Magic Haste Potion
(21195,6361,211,425,3,700000),-- Green Seal Stone
(21195,6362,25,45,4,700000),-- Red Seal Stone
(21196,1911,1,1,-1,282441),-- Earring of Protection Gemstone
(21196,2166,1,1,-1,128726),-- Recipe: Earrings of Binding (100%)
(21196,2167,1,1,-1,193726),-- Recipe: Ring of Ages
(21196,227,1,1,1,38),-- Stiletto
(21196,242,1,1,1,38),-- Soulfire Dirk
(21196,2083,1,1,1,2795),-- Stiletto Edge
(21196,2084,1,1,1,2795),-- Soulfire Dirk Blade
(21196,951,1,1,2,510),-- Scroll: Enchant Weapon (Grade C)
(21196,1866,1,1,2,186950),-- Suede
(21196,1871,1,1,2,280424),-- Charcoal
(21196,1877,1,1,2,11217),-- Adamantite Nugget
(21196,4040,1,1,2,5609),-- Mold Lubricant
(21196,4041,1,1,2,2439),-- Mold Hardener
(21196,6361,268,532,3,700000),-- Green Seal Stone
(21196,6362,25,45,4,700000),-- Red Seal Stone
(21197,1872,1,11,-1,935364),-- Animal Bone
(21197,4041,1,1,-1,36601),-- Mold Hardener
(21197,4603,1,1,-1,9354),-- Greater Dye of Constitution <Con+3 Str-3>
(21197,6360,145,291,0,700000),-- Blue Seal Stone
(21197,326,1,1,1,53),-- Heathen\'s Book
(21197,2110,1,1,1,4906),-- Heathen\'s Book Page
(21197,1867,1,3,2,128937),-- Animal Skin
(21197,1869,2,6,2,72527),-- Iron Ore
(21197,1870,2,6,2,58022),-- Coal
(21197,1871,3,9,2,48351),-- Charcoal
(21197,1872,7,21,2,27629),-- Animal Bone
(21197,2232,1,1,2,1667),-- Recipe: Drake Leather Armor
(21197,6361,238,476,3,700000),-- Green Seal Stone
(21197,6362,12,24,4,700000),-- Red Seal Stone
(21198,1806,1,1,-1,10550),-- Recipe: Soulshot: B-Grade
(21198,1920,1,1,-1,180500),-- Necklace of Binding Chain
(21198,4593,1,1,-1,17584),-- Greater Dye of Dexterity <Dex+2 Str-2>
(21198,6360,148,301,0,700000),-- Blue Seal Stone
(21198,299,1,1,1,14),-- Orcish Poleaxe
(21198,301,1,1,1,18),-- Scorpion
(21198,303,1,1,1,18),-- Widow Maker
(21198,2113,1,1,1,1572),-- Scorpion Blade
(21198,2114,1,1,1,1572),-- Widowmaker Head
(21198,2122,1,1,1,1482),-- Orcish Poleaxe Blade
(21198,1868,1,3,2,243467),-- Thread
(21198,1873,1,1,2,97387),-- Silver Nugget
(21198,1876,1,1,2,48693),-- Mithril Ore
(21198,1895,1,1,2,69562),-- Metallic Fiber
(21198,3034,1,1,2,487),-- Recipe: Spiritshot B
(21198,4042,1,1,2,4058),-- Enria
(21198,4944,1,1,2,1171),-- Recipe: Avadon Breastplate (60%)
(21198,4968,1,1,2,280),-- Recipe: Kris (60%)
(21198,6361,314,633,3,700000),-- Green Seal Stone
(21198,6362,13,27,4,700000),-- Red Seal Stone
(21199,947,1,1,-1,2262),-- Scroll: Enchant Weapon (Grade B)
(21199,4129,1,1,-1,61196),-- Recipe: Earrings of Black Ore
(21199,4611,1,1,-1,12566),-- Greater Dye of Wit <Wit+3 Int-3>
(21199,6360,73,146,0,700000),-- Blue Seal Stone
(21199,2384,1,1,1,47),-- Zubei\'s Leather Shirt
(21199,2388,1,1,1,74),-- Zubei\'s Leather Gaiters
(21199,2390,1,1,1,29),-- Avadon Leather Armor
(21199,4066,1,1,1,6565),-- Zubei\'s Leather Shirt Fabric
(21199,4067,1,1,1,9967),-- Zubei\'s Leather Gaiter Texture
(21199,4068,1,1,1,5043),-- Avadon Leather Armor Lining
(21199,948,1,1,2,522),-- Scroll: Enchant Armor (Grade B)
(21199,1867,1,1,2,278379),-- Animal Skin
(21199,1872,1,3,2,139189),-- Animal Bone
(21199,1875,1,1,2,13919),-- Stone of Purity
(21199,1881,1,1,2,27838),-- Coarse Bone Powder
(21199,4041,1,1,2,1815),-- Mold Hardener
(21199,4163,1,1,2,1383),-- Recipe: Blue Wolf Stockings
(21199,8311,1,1,2,160),-- Recipe: Kaim Vanul\'s Bones (100%)
(21199,6361,391,782,3,700000),-- Green Seal Stone
(21199,6362,13,26,4,700000),-- Red Seal Stone
(21200,4049,1,1,-1,310449),-- Adamantite Earring Gemstone
(21200,4129,1,1,-1,64055),-- Recipe: Earrings of Black Ore
(21200,4613,1,1,-1,8164),-- Greater Dye of Strength <Str+4 Con-4>
(21200,6360,8,16,0,700000),-- Blue Seal Stone
(21200,357,1,1,1,27),-- Zubei\'s Breastplate
(21200,383,1,1,1,44),-- Zubei\'s Gaiters
(21200,2376,1,1,1,27),-- Avadon Breastplate
(21200,2379,1,1,1,44),-- Avadon Gaiters
(21200,4056,1,1,1,3957),-- Zubei\'s Breastplate Part
(21200,4057,1,1,1,6115),-- Zubei\'s Gaiter Material
(21200,4064,1,1,1,3957),-- Avadon Breastplate Part
(21200,4065,1,1,1,6115),-- Avadon Gaiters Material
(21200,1343,20,60,2,178397),-- Silver Arrow
(21200,1867,2,6,2,83252),-- Animal Skin
(21200,1872,1,3,2,111003),-- Animal Bone
(21200,1875,1,1,2,16651),-- Stone of Purity
(21200,1881,1,1,2,33301),-- Coarse Bone Powder
(21200,4041,1,1,2,2172),-- Mold Hardener
(21200,4155,1,1,2,776),-- Recipe: Blue Wolf Breastplate
(21200,6361,452,904,3,700000),-- Green Seal Stone
(21200,6362,12,24,4,700000),-- Red Seal Stone
(21201,4052,1,1,-1,271551),-- Earring of Black Ore Piece
(21201,4053,1,1,-1,328759),-- Ring of Black Ore Gemstone
(21201,5230,1,1,-1,10227),-- Recipe: Mithril Arrow (100%)
(21201,2398,1,1,1,31),-- Blue Wolf Tunic
(21201,2399,1,1,1,31),-- Tunic of Doom
(21201,2403,1,1,1,49),-- Blue Wolf Stockings
(21201,2404,1,1,1,49),-- Stockings of Doom
(21201,4084,1,1,1,4923),-- Blue Wolf Tunic Fabric
(21201,4085,1,1,1,4923),-- Tunic of Doom Pattern
(21201,4086,1,1,1,6648),-- Blue Wolf Stockings Pattern
(21201,4087,1,1,1,6648),-- Stockings of Doom Pattern
(21201,1830,1,1,2,129462),-- Scroll of Escape: Castle
(21201,1866,1,3,2,71923),-- Suede
(21201,1871,1,3,2,161828),-- Charcoal
(21201,1877,1,1,2,12946),-- Adamantite Nugget
(21201,4040,1,1,2,6473),-- Mold Lubricant
(21201,4041,1,1,2,2814),-- Mold Hardener
(21201,6036,1,1,2,10788),-- Greater Magic Haste Potion
(21201,6361,574,1144,3,700000),-- Green Seal Stone
(21201,6362,14,28,4,700000),-- Red Seal Stone
(21202,4041,1,1,-1,70764),-- Mold Hardener
(21202,4054,1,1,-1,160289),-- Necklace of Black Ore Beads
(21202,5230,1,1,-1,10851),-- Recipe: Mithril Arrow (100%)
(21202,864,1,1,1,113),-- Earring of Black Ore
(21202,895,1,1,1,169),-- Ring of Black Ore
(21202,926,1,1,1,85),-- Necklace of Black Ore
(21202,4052,1,1,1,14183),-- Earring of Black Ore Piece
(21202,4053,1,1,1,17172),-- Ring of Black Ore Gemstone
(21202,4054,1,1,1,7891),-- Necklace of Black Ore Beads
(21202,1867,1,3,2,178059),-- Animal Skin
(21202,1872,4,12,2,66772),-- Animal Bone
(21202,1875,1,1,2,26709),-- Stone of Purity
(21202,1881,1,1,2,53418),-- Coarse Bone Powder
(21202,4041,1,1,2,3484),-- Mold Hardener
(21202,5230,1,1,2,534),-- Recipe: Mithril Arrow (100%)
(21202,6361,578,1160,3,700000),-- Green Seal Stone
(21202,6362,14,27,4,700000),-- Red Seal Stone
(21203,1876,1,3,-1,801503),-- Mithril Ore
(21203,4042,1,1,-1,133584),-- Enria
(21203,5478,1,1,-1,67398),-- Sealed Dark Crystal Leather Armor Pattern
(21203,5290,1,1,1,67),-- Sealed Dark Crystal Gloves
(21203,5291,1,1,1,67),-- Sealed Dark Crystal Boots
(21203,5295,1,1,1,67),-- Sealed Tallum Gloves
(21203,5296,1,1,1,67),-- Sealed Tallum Boots
(21203,5496,1,1,1,6940),-- Sealed Dark Crystal Boots Lining
(21203,5497,1,1,1,6940),-- Sealed Tallum Boots Lining
(21203,5508,1,1,1,6940),-- Sealed Dark Crystal Gloves Design
(21203,5509,1,1,1,6940),-- Sealed Tallum Gloves Design
(21203,1344,150,450,2,28184),-- Mithril Arrow
(21203,1868,4,12,2,84554),-- Thread
(21203,1873,1,1,2,135287),-- Silver Nugget
(21203,1876,1,1,2,67643),-- Mithril Ore
(21203,1895,1,1,2,96633),-- Metallic Fiber
(21203,4042,1,1,2,5637),-- Enria
(21203,5156,1,1,2,451),-- Recipe: Soulshot (A) Compressed Package (100%)
(21203,6361,557,1114,3,700000),-- Green Seal Stone
(21203,6362,12,24,4,700000),-- Red Seal Stone
(21204,1807,1,1,-1,10950),-- Recipe: Soulshot: A-Grade
(21204,3035,1,1,-1,10950),-- Recipe: Spiritshot A
(21204,5479,1,1,-1,48593),-- Sealed Tallum Leather Armor Pattern
(21204,5289,1,1,1,76),-- Sealed Dark Crystal Helmet
(21204,5292,1,1,1,108),-- Sealed Dark Crystal Shield
(21204,5294,1,1,1,76),-- Sealed Tallum Helmet
(21204,5494,1,1,1,10613),-- Sealed Dark Crystal Shield Fragment
(21204,5525,1,1,1,7811),-- Sealed Dark Crystal Helmet Design
(21204,5526,1,1,1,7811),-- Sealed Tallum Helm Design
(21204,1894,1,1,2,21279),-- Crafted Leather
(21204,3956,1,1,2,809),-- Recipe: Blessed Spiritshot A
(21204,4039,1,1,2,20215),-- Mold Glue
(21204,4041,1,1,2,5273),-- Mold Hardener
(21204,4044,1,1,2,20215),-- Thons
(21204,6361,687,1380,3,700000),-- Green Seal Stone
(21204,6362,14,28,4,700000),-- Red Seal Stone
(21205,729,1,1,-1,957),-- Scroll: Enchant Weapon (Grade A)
(21205,1895,1,5,-1,820300),-- Metallic Fiber
(21205,5480,1,1,-1,38649),-- Sealed Leather Armor of Nightmare Fabric
(21205,5297,1,1,1,40),-- Sealed Dark Crystal Leather Armor
(21205,5298,1,1,1,63),-- Sealed Dark Crystalline Leggings
(21205,5301,1,1,1,24),-- Sealed Tallum Leather Armor
(21205,5478,1,1,1,4457),-- Sealed Dark Crystal Leather Armor Pattern
(21205,5479,1,1,1,3136),-- Sealed Tallum Leather Armor Pattern
(21205,5482,1,1,1,6995),-- Sealed Dark Crystalline Leggings Design
(21205,730,1,1,2,530),-- Scroll: Enchant Armor (Grade A)
(21205,1895,1,1,2,181728),-- Metallic Fiber
(21205,4040,1,1,2,12721),-- Mold Lubricant
(21205,4042,1,1,2,10601),-- Enria
(21205,4043,1,1,2,21202),-- Asofe
(21205,6361,700,1400,3,700000),-- Green Seal Stone
(21205,6362,14,27,4,700000),-- Red Seal Stone
(21206,1875,1,1,-1,559187),-- Stone of Purity
(21206,5481,1,1,-1,37638),-- Sealed Majestic Leather Armor Fabric
(21206,5487,1,1,-1,37771),-- Sealed Robe of Nightmare Fabric
(21206,5287,1,1,1,29),-- Sealed Dark Crystal breastplate
(21206,5288,1,1,1,46),-- Sealed Dark Crystal Gaiters
(21206,5293,1,1,1,18),-- Sealed Tallum Plate Armor
(21206,5520,1,1,1,3329),-- Sealed Dark Crystal Breastplate Pattern
(21206,5521,1,1,1,2349),-- Sealed Tallum Plate Armor Pattern
(21206,5524,1,1,1,5088),-- Sealed Dark Crystal Gaiters Pattern
(21206,1868,3,9,2,103234),-- Thread
(21206,1873,1,1,2,123881),-- Silver Nugget
(21206,1876,1,1,2,61941),-- Mithril Ore
(21206,1895,1,1,2,88487),-- Metallic Fiber
(21206,4042,1,1,2,5162),-- Enria
(21206,6671,1,1,2,34411),-- Deluxe Chest Key - Grade 7
(21206,5282,1,1,2,138),-- Recipe: Greater Blessed Spiritshot (S) Compressed Package(100%)
(21206,6361,666,1336,3,700000),-- Green Seal Stone
(21206,6362,12,24,4,700000),-- Red Seal Stone
(21206,8732,1,1,200,2581),-- Life Stone: level 76
(21206,8742,1,1,200,645),-- Mid-Grade Life Stone: level 76
(21206,8752,1,1,200,64),-- High-Grade Life Stone: level 76
(21207,730,1,1,-1,8621),-- Scroll: Enchant Armor (Grade A)
(21207,5480,1,1,-1,46420),-- Sealed Leather Armor of Nightmare Fabric
(21207,5488,1,1,-1,46584),-- Sealed Majestic Robe Fabric
(21207,5312,1,1,1,63),-- Sealed Helm of Nightmare
(21207,5315,1,1,1,90),-- Sealed Shield of Nightmare
(21207,5317,1,1,1,63),-- Sealed Majestic Circlet
(21207,5495,1,1,1,9666),-- Sealed Shield of Nightmare Fragment
(21207,5527,1,1,1,7611),-- Sealed Helm of Nightmare Design
(21207,5528,1,1,1,7611),-- Sealed Majestic Circlet Design
(21207,729,1,1,2,70),-- Scroll: Enchant Weapon (Grade A)
(21207,1866,1,3,2,141469),-- Suede
(21207,1871,4,12,2,79577),-- Charcoal
(21207,1877,1,1,2,25464),-- Adamantite Nugget
(21207,4040,1,1,2,12732),-- Mold Lubricant
(21207,4041,1,1,2,5536),-- Mold Hardener
(21207,6361,805,1610,3,700000),-- Green Seal Stone
(21207,6362,14,28,4,700000),-- Red Seal Stone
(21208,734,1,1,-1,131730),-- Haste Potion
(21208,1871,1,1,-1,790380),-- Charcoal
(21208,1897,1,1,-1,188186),-- Necklace of Wisdom Chain
(21208,57,365,635,0,700000),-- Adena
(21208,38,1,1,1,5975),-- Low Boots
(21208,50,1,1,1,5975),-- Leather Gloves
(21208,1925,1,1,1,102062),-- Leather Gloves Lining
(21208,734,1,1,2,25941),-- Haste Potion
(21208,1866,1,1,2,103762),-- Suede
(21208,1871,1,1,2,155644),-- Charcoal
(21209,1804,1,1,-1,36013),-- Recipe: Soulshot: D-Grade
(21209,1898,1,1,-1,92484),-- Blue Diamond Necklace Gem
(21209,2151,1,1,-1,250789),-- Recipe: Necklace of Devotion
(21209,57,409,734,0,700000),-- Adena
(21209,625,1,1,1,5372),-- Bone Shield
(21209,1148,1,1,1,3746),-- Hard Leather Helmet
(21209,734,1,1,2,29550),-- Haste Potion
(21209,1865,1,1,2,177297),-- Varnish
(21209,1870,1,1,2,177297),-- Coal
(21210,1866,1,1,-1,733287),-- Suede
(21210,1877,1,1,-1,43997),-- Adamantite Nugget
(21210,1899,1,1,-1,171864),-- Necklace of Devotion Chain
(21210,57,484,907,0,700000),-- Adena
(21210,123,1,1,1,98),-- Saber
(21210,2017,1,1,1,2051),-- Saber Blade
(21210,5285,1,1,1,98),-- Heavy Sword
(21210,5531,1,1,1,2592),-- Heavy Sword Edge
(21210,1866,1,1,2,102886),-- Suede
(21210,1871,1,1,2,154328),-- Charcoal
(21210,1877,1,1,2,6173),-- Adamantite Nugget
(21210,2182,1,1,2,18527),-- Recipe: Scale Gaiters
(21211,1931,1,1,-1,150011),-- Leather Boot Lining
(21211,1932,1,1,-1,182156),-- Bone Helmet Design
(21211,2152,1,1,-1,202039),-- Recipe: Enchanted Necklace
(21211,57,495,955,0,700000),-- Adena
(21211,156,1,1,1,136),-- Hand Axe
(21211,167,1,1,1,136),-- Scalpel
(21211,178,1,1,1,136),-- Bone Staff
(21211,1867,1,1,2,171749),-- Animal Skin
(21211,1872,1,1,2,171749),-- Animal Bone
(21211,1875,1,1,2,8587),-- Stone of Purity
(21211,1881,1,1,2,17175),-- Coarse Bone Powder
(21211,5437,1,1,2,3149),-- Recipe: Heavy Sword(100%)
(21213,1900,1,1,-1,162437),-- Enchanted Necklace Chain
(21213,2153,1,2,-1,230897),-- Recipe: Tiger\'s Eye Earring
(21213,57,626,1255,0,700000),-- Adena
(21213,275,1,1,1,109),-- Long Bow
(21213,276,1,1,1,109),-- Elven Bow
(21213,2024,1,1,1,3853),-- Elven Bow Shaft
(21213,1061,1,1,2,98340),-- Healing Potion
(21213,1864,3,9,2,54088),-- Stem
(21213,1869,1,1,2,162263),-- Iron Ore
(21213,1878,1,1,2,64905),-- Braided Hemp
(21213,1884,1,1,2,99854),-- Cord
(21214,1865,1,3,-1,924982),-- Varnish
(21214,1875,1,1,-1,123331),-- Stone of Purity
(21214,1901,1,1,-1,255520),-- Tiger\'s Eye Earring Stone
(21214,57,781,1559,0,700000),-- Adena
(21214,223,1,1,1,53),-- Kukuri
(21214,238,1,1,1,53),-- Dagger of Mana
(21214,239,1,1,1,53),-- Mystic Knife
(21214,241,1,1,1,53),-- Shilen Knife
(21214,2028,1,1,1,2337),-- Shilen Knife Edge
(21214,1865,1,1,2,196722),-- Varnish
(21214,1870,1,1,2,196722),-- Coal
(21214,1875,1,1,2,13115),-- Stone of Purity
(21214,1879,1,1,2,32787),-- Cokes
(21214,2189,1,1,2,8782),-- Recipe: Mithril Tunic
(21215,1825,1,1,-1,139345),-- Recipe: Oriharukon
(21215,1902,1,1,-1,197653),-- Elven Earring Beads
(21215,2145,1,1,-1,139345),-- Recipe: Mithril Alloy
(21215,57,824,1645,0,700000),-- Adena
(21215,318,1,1,1,94),-- Crucifix of Blood
(21215,2042,1,1,1,4659),-- Crucifix of Blood Piece
(21215,1825,1,1,2,12005),-- Recipe: Oriharukon
(21215,1866,1,1,2,112048),-- Suede
(21215,1871,1,1,2,168071),-- Charcoal
(21215,1885,1,1,2,14006),-- High Grade Suede
(21215,5220,1,1,2,6723),-- Metal Hardener
(21215,5473,1,1,2,12005),-- Recipe: Durable Metal Plate(100%)
(21217,1868,1,11,-1,844121),-- Thread
(21217,1889,1,1,-1,168824),-- Compound Braid
(21217,1905,1,1,-1,246339),-- Omen Beast\'s Eye Earring Gemstone
(21217,57,1020,2061,0,700000),-- Adena
(21217,396,1,1,1,347),-- Salamander Skin Mail
(21217,1952,1,1,1,20366),-- Salamander Skin Mail Texture
(21217,1868,1,3,2,211939),-- Thread
(21217,1873,1,1,2,84776),-- Silver Nugget
(21217,1889,1,1,2,14129),-- Compound Braid
(21217,2161,1,1,2,20577),-- Recipe: Aquastone Ring
(21217,2993,1,1,2,16820),-- Recipe: Dwarven Chain Boots
(21217,5549,1,1,2,21194),-- Metallic Thread
(21218,1908,1,1,-1,292039),-- Moonstone Earring Wire
(21218,1909,1,1,-1,416466),-- Aquastone Ring Wire
(21218,2163,1,1,-1,157343),-- Recipe: Earring of Protection
(21218,57,1220,2478,0,700000),-- Adena
(21218,354,1,1,1,188),-- Chain Mail Shirt
(21218,381,1,1,1,300),-- Chain Gaiters
(21218,1959,1,1,1,9814),-- Chain Mail Shirt Material
(21218,1960,1,1,1,19965),-- Chain Gaiters Part
(21218,1864,1,1,2,291503),-- Stem
(21218,1869,1,1,2,145751),-- Iron Ore
(21218,1880,1,1,2,14575),-- Steel
(21218,2213,1,1,2,2263),-- Recipe: Dwarven Chain Mail Shirt
(21218,4043,1,1,2,4858),-- Asofe
(21218,5550,1,1,2,1943),-- Durable Metal Plate
(21218,8723,1,1,200,5830),-- Life Stone: level 46
(21218,8733,1,1,200,1458),-- Mid-Grade Life Stone: level 46
(21218,8743,1,1,200,146),-- High-Grade Life Stone: level 46 
(21218,8753,1,1,200,30),-- Top-Grade Life Stone: level 46 
(21219,1911,1,1,-1,237145),-- Earring of Protection Gemstone
(21219,1912,1,1,-1,343579),-- Ring of Protection Gemstone
(21219,2166,1,1,-1,108082),-- Recipe: Earrings of Binding (100%)
(21219,57,1258,2567,0,700000),-- Adena
(21219,440,1,1,1,234),-- Robe of Seal
(21219,1970,1,1,1,15773),-- Robe of Seal Fabric
(21219,1866,1,1,2,156969),-- Suede
(21219,1871,1,1,2,235453),-- Charcoal
(21219,1877,1,1,2,9418),-- Adamantite Nugget
(21219,4040,1,1,2,4709),-- Mold Lubricant
(21219,4041,1,1,2,2048),-- Mold Hardener
(21219,951,1,1,2,428),-- Scroll: Enchant Weapon (Grade C)
(21221,1867,1,11,-1,871890),-- Animal Skin
(21221,1872,1,11,-1,871890),-- Animal Bone
(21221,4605,1,1,-1,8719),-- Greater Dye of Dexterity <Dex+3 Str-3>
(21221,57,1558,3150,0,700000),-- Adena
(21221,64,1,1,1,430),-- Composite Boots
(21221,608,1,1,1,430),-- Mithril Gauntlets
(21221,1981,1,1,1,23860),-- Mithril Gauntlets Design
(21221,2956,1,1,1,23860),-- Composite Boots Part
(21221,1342,30,90,2,77263),-- Fine Steel Arrow
(21221,1867,1,1,2,154526),-- Animal Skin
(21221,1872,2,6,2,38631),-- Animal Bone
(21221,1875,1,1,2,7726),-- Stone of Purity
(21221,1881,1,1,2,15453),-- Coarse Bone Powder
(21221,2234,1,1,2,1727),-- Recipe: Divine Stockings
(21221,3955,1,1,2,232),-- Recipe: Blessed Spiritshot B
(21221,4041,1,1,2,1008),-- Mold Hardener
(21221,5280,1,1,2,232),-- Recipe: Greater Blessed Spiritshot (B) Compressed Package(100%)
(21221,6037,1,3,2,115894),-- Waking Scroll
(21221,8725,1,1,200,3219),-- Life Stone: level 52
(21221,8735,1,1,200,805),-- Mid-Grade Life Stone: level 52
(21221,8745,1,1,200,80),-- High-Grade Life Stone: level 52
(21221,8755,1,1,200,16),-- Top-Grade Life Stone: level 52
(21222,1806,1,1,-1,9299),-- Recipe: Soulshot: B-Grade
(21222,1920,1,1,-1,159086),-- Necklace of Binding Chain
(21222,4126,1,1,-1,76721),-- Recipe: Adamantite Earrings
(21222,57,1837,3743,0,700000),-- Adena
(21222,2414,1,1,1,208),-- Full Plate Helmet
(21222,2497,1,1,1,297),-- Full Plate Shield
(21222,2959,1,1,1,14845),-- Full Plate Helmet Design
(21222,2966,1,1,1,23484),-- Full Plate Shield Fragment
(21222,1868,1,1,2,286109),-- Thread
(21222,1873,1,1,2,57222),-- Silver Nugget
(21222,1876,1,1,2,28611),-- Mithril Ore
(21222,1895,1,1,2,40873),-- Metallic Fiber
(21222,4042,1,1,2,2384),-- Enria
(21222,4126,1,1,2,2361),-- Recipe: Adamantite Earrings
(21222,4183,1,1,2,165),-- Recipe: Heavy War Axe
(21222,4965,1,1,2,165),-- Recipe: Sprite\'s Staff (60%)
(21222,8726,1,1,200,3312),-- Life Stone: level 55
(21222,8736,1,1,200,828),-- Mid-Grade Life Stone: level 55
(21222,8746,1,1,200,83),-- High-Grade Life Stone: level 55
(21222,8756,1,1,200,16),-- Top-Grade Life Stone: level 55
(21223,4049,1,1,-1,249606),-- Adamantite Earring Gemstone
(21223,4129,1,1,-1,51501),-- Recipe: Earrings of Black Ore
(21223,4603,1,1,-1,10575),-- Greater Dye of Constitution <Con+3 Str-3>
(21223,57,1877,3833,0,700000),-- Adena
(21223,78,1,1,1,7),-- Great Sword
(21223,142,1,1,1,7),-- Keshanberk
(21223,148,1,1,1,7),-- Sword of Valhalla
(21223,4104,1,1,1,1340),-- Great Sword Blade
(21223,4107,1,1,1,1320),-- Keshanberk Blade
(21223,4108,1,1,1,1320),-- Sword of Valhalla Blade
(21223,1868,1,1,2,255573),-- Thread
(21223,1873,1,1,2,51115),-- Silver Nugget
(21223,1876,1,1,2,25557),-- Mithril Ore
(21223,1895,1,1,2,36511),-- Metallic Fiber
(21223,4042,1,1,2,2130),-- Enria
(21223,4130,1,1,2,2075),-- Recipe: Ring of Black Ore
(21223,4182,1,1,2,147),-- Recipe: Great Sword
(21223,8727,1,1,200,2556),-- Life Stone: level 58
(21223,8737,1,1,200,639),-- Mid-Grade Life Stone: level 58
(21223,8747,1,1,200,64),-- High-Grade Life Stone: level 58
(21223,8757,1,1,200,12),-- Top-Grade Life Stone: level 58
(21224,1894,1,1,-1,182410),-- Crafted Leather
(21224,4039,1,1,-1,173289),-- Mold Glue
(21224,4613,1,1,-1,7171),-- Greater Dye of Strength <Str+4 Con-4>
(21224,57,2056,4180,0,700000),-- Adena
(21224,91,1,1,1,11),-- Heavy War Axe
(21224,92,1,1,1,11),-- Sprite\'s Staff
(21224,4105,1,1,1,2197),-- Heavy War Axe Head
(21224,4106,1,1,1,2160),-- Sprite\'s Staff Head
(21224,1343,10,30,2,219378),-- Silver Arrow
(21224,1894,1,1,2,5388),-- Crafted Leather
(21224,4039,1,1,2,5119),-- Mold Glue
(21224,4041,1,1,2,1335),-- Mold Hardener
(21224,4044,1,1,2,5119),-- Thons
(21224,4158,1,1,2,326),-- Recipe: Doom Plate Armor
(21224,8728,1,1,200,2559),-- Life Stone: level 61
(21224,8738,1,1,200,640),-- Mid-Grade Life Stone: level 61
(21224,8748,1,1,200,64),-- High-Grade Life Stone: level 61
(21224,8758,1,1,200,13),-- Top-Grade Life Stone: level 61
(21225,4052,1,1,-1,201435),-- Earring of Black Ore Piece
(21225,4053,1,1,-1,243872),-- Ring of Black Ore Gemstone
(21225,5230,1,1,-1,7586),-- Recipe: Mithril Arrow (100%)
(21225,57,2256,4571,0,700000),-- Adena
(21225,2391,1,1,1,28),-- Blue Wolf Leather Armor
(21225,2392,1,1,1,28),-- Leather Armor of Doom
(21225,4082,1,1,1,4748),-- Blue Wolf Leather Armor Texture
(21225,4083,1,1,1,4748),-- Leather Armor of Doom Design
(21225,1830,1,1,2,112040),-- Scroll of Escape: Castle
(21225,1866,1,1,2,186733),-- Suede
(21225,1871,1,3,2,140050),-- Charcoal
(21225,1877,1,1,2,11204),-- Adamantite Nugget
(21225,4040,1,1,2,5602),-- Mold Lubricant
(21225,4041,1,1,2,2436),-- Mold Hardener
(21226,4052,1,1,-1,235314),-- Earring of Black Ore Piece
(21226,4054,1,1,-1,130913),-- Necklace of Black Ore Beads
(21226,5230,1,1,-1,8862),-- Recipe: Mithril Arrow (100%)
(21226,57,2634,5340,0,700000),-- Adena
(21226,79,1,1,1,6),-- Sword of Damascus
(21226,7889,1,1,1,6),-- Wizard\'s Tear
(21226,7883,1,1,1,6),-- Guardian Sword
(21226,4114,1,1,1,1433),-- Sword of Damascus Blade
(21226,8336,1,1,1,1433),-- Blade of the Wizard\'s Tear
(21226,8330,1,1,1,1430),-- Guardian Sword Blade
(21226,8314,1,1,2,97),-- Recipe: Spiritual Eye (60%)
(21226,1867,1,3,2,118985),-- Animal Skin
(21226,1872,1,1,2,237970),-- Animal Bone
(21226,1882,1,1,2,39662),-- Leather
(21226,1894,1,1,2,6263),-- Crafted Leather
(21226,4042,1,1,2,3975),-- Enria
(21226,5230,1,1,2,238),-- Recipe: Mithril Arrow (100%)
(21226,8729,1,1,200,2380),-- Life Stone: level 64
(21226,8739,1,1,200,595),-- Mid-Grade Life Stone: level 64
(21226,8749,1,1,200,59),-- High-Grade Life Stone: level 64
(21226,8759,1,1,200,12),-- Top-Grade Life Stone: level 64
(21227,4077,1,1,-1,320722),-- Doom Shield Fragment
(21227,5230,1,1,-1,9506),-- Recipe: Mithril Arrow (100%)
(21227,5549,1,1,-1,712964),-- Metallic Thread
(21227,57,2811,5744,0,700000),-- Adena
(21227,287,1,1,1,21),-- Bow of Peril
(21227,4121,1,1,1,4586),-- Bow of Peril Shaft
(21227,1868,1,3,2,191453),-- Thread
(21227,1873,1,1,2,76581),-- Silver Nugget
(21227,1889,1,1,2,13764),-- Compound Braid
(21227,4044,1,1,2,6382),-- Thons
(21227,8314,1,1,2,105),-- Recipe: Spiritual Eye (60%)
(21227,5230,1,1,2,255),-- Recipe: Mithril Arrow (100%)
(21227,5549,1,1,2,19145),-- Metallic Thread
(21227,8730,1,1,200,2127),-- Life Stone: level 67
(21227,8740,1,1,200,532),-- Mid-Grade Life Stone: level 67
(21227,8750,1,1,200,53),-- High-Grade Life Stone: level 67
(21227,8760,1,1,200,11),-- Top-Grade Life Stone: level 67
(21228,1807,1,1,-1,9693),-- Recipe: Soulshot: A-Grade
(21228,3035,1,1,-1,9693),-- Recipe: Spiritshot A
(21228,5478,1,1,-1,61132),-- Sealed Dark Crystal Leather Armor Pattern
(21228,57,2875,5849,0,700000),-- Adena
(21228,5287,1,1,1,20),-- Sealed Dark Crystal breastplate
(21228,5288,1,1,1,32),-- Sealed Dark Crystal Gaiters
(21228,5293,1,1,1,12),-- Sealed Tallum Plate Armor
(21228,5520,1,1,1,2308),-- Sealed Dark Crystal Breastplate Pattern
(21228,5521,1,1,1,1629),-- Sealed Tallum Plate Armor Pattern
(21228,5524,1,1,1,3528),-- Sealed Dark Crystal Gaiters Pattern
(21228,1866,1,1,2,143159),-- Suede
(21228,1871,1,1,2,214738),-- Charcoal
(21228,1885,1,1,2,17895),-- High Grade Suede
(21228,4041,1,1,2,1867),-- Mold Hardener
(21228,5220,1,1,2,8590),-- Metal Hardener
(21228,5271,1,1,2,286),-- Recipe: Greater Soulshot (A) Compressed Package(100%)
(21228,8730,1,1,200,2386),-- Life Stone: level 67
(21228,8740,1,1,200,596),-- Mid-Grade Life Stone: level 67
(21228,8750,1,1,200,60),-- High-Grade Life Stone: level 67
(21228,8760,1,1,200,12),-- Top-Grade Life Stone: level 67
(21229,4041,1,1,-1,54837),-- Mold Hardener
(21229,4044,1,1,-1,210209),-- Thons
(21229,5479,1,1,-1,37315),-- Sealed Tallum Leather Armor Pattern
(21229,57,3110,6350,0,700000),-- Adena
(21229,6323,1,1,1,58),-- Sealed Phoenix Necklace
(21229,6324,1,1,1,77),-- Sealed Phoenix Earring
(21229,6325,1,1,1,116),-- Sealed Phoenix Ring
(21229,6341,1,1,1,10733),-- Sealed Phoenix Earring Gemstone
(21229,6343,1,1,1,8297),-- Sealed Phoenix Necklace Beads
(21229,6345,1,1,1,14846),-- Sealed Phoenix Ring Gemstone
(21229,1894,1,1,2,9078),-- Crafted Leather
(21229,4039,1,1,2,8624),-- Mold Glue
(21229,4041,1,1,2,2250),-- Mold Hardener
(21229,4044,1,1,2,8624),-- Thons
(21229,730,1,1,2,216),-- Scroll: Enchant Armor (Grade A)
(21229,8731,1,1,200,2396),-- Life Stone: level 70
(21229,8741,1,1,200,599),-- Mid-Grade Life Stone: level 70
(21229,8751,1,1,200,60),-- High-Grade Life Stone: level 70
(21229,8761,1,1,200,12),-- Top-Grade Life Stone: level 70
(21230,5480,1,1,-1,32628),-- Sealed Leather Armor of Nightmare Fabric
(21230,5481,1,1,-1,32628),-- Sealed Majestic Leather Armor Fabric
(21230,5487,1,1,-1,32744),-- Sealed Robe of Nightmare Fabric
(21230,57,3587,7319,0,700000),-- Adena
(21230,5289,1,1,1,67),-- Sealed Dark Crystal Helmet
(21230,5292,1,1,1,96),-- Sealed Dark Crystal Shield
(21230,5294,1,1,1,67),-- Sealed Tallum Helmet
(21230,5494,1,1,1,9397),-- Sealed Dark Crystal Shield Fragment
(21230,5525,1,1,1,6917),-- Sealed Dark Crystal Helmet Design
(21230,5526,1,1,1,6917),-- Sealed Tallum Helm Design
(21230,730,1,1,2,249),-- Scroll: Enchant Armor (Grade A)
(21230,1895,1,1,2,85233),-- Metallic Fiber
(21230,4040,1,1,2,5966),-- Mold Lubricant
(21230,4042,1,1,2,4972),-- Enria
(21230,4043,1,1,2,9944),-- Asofe
(21230,8730,1,1,200,2762),-- Life Stone: level 67
(21230,8740,1,1,200,690),-- Mid-Grade Life Stone: level 67
(21230,8750,1,1,200,69),-- High-Grade Life Stone: level 67
(21230,8760,1,1,200,14),-- Top-Grade Life Stone: level 67
(21231,729,1,1,-1,812),-- Scroll: Enchant Weapon (Grade A)
(21231,1875,1,1,-1,487115),-- Stone of Purity
(21231,5480,1,1,-1,32787),-- Sealed Leather Armor of Nightmare Fabric
(21231,57,3602,7359,0,700000),-- Adena
(21231,5289,1,1,1,67),-- Sealed Dark Crystal Helmet
(21231,5292,1,1,1,96),-- Sealed Dark Crystal Shield
(21231,5294,1,1,1,67),-- Sealed Tallum Helmet
(21231,5494,1,1,1,9443),-- Sealed Dark Crystal Shield Fragment
(21231,5525,1,1,1,6950),-- Sealed Dark Crystal Helmet Design
(21231,5526,1,1,1,6950),-- Sealed Tallum Helm Design
(21231,729,1,1,2,34),-- Scroll: Enchant Weapon (Grade A)
(21231,1867,1,3,2,133228),-- Animal Skin
(21231,1872,1,3,2,199842),-- Animal Bone
(21231,1875,1,1,2,19984),-- Stone of Purity
(21231,1881,1,1,2,39969),-- Coarse Bone Powder
(21231,4041,1,1,2,2606),-- Mold Hardener
(21231,8732,1,1,200,2498),-- Life Stone: level 76
(21231,8742,1,1,200,625),-- Mid-Grade Life Stone: level 76
(21231,8752,1,1,200,62),-- High-Grade Life Stone: level 76
(21236,1061,1,1,-1,784398),-- Healing Potion
(21236,1900,1,1,-1,141604),-- Enchanted Necklace Chain
(21236,2153,1,1,-1,201284),-- Recipe: Tiger\'s Eye Earring
(21236,57,546,1092,0,700000),-- Adena
(21236,69,1,1,1,57),-- Bastard Sword
(21236,125,1,1,1,57),-- Spinebone Sword
(21236,126,1,1,1,57),-- Artisan\'s Sword
(21236,128,1,1,1,57),-- Knight\'s Sword
(21236,2021,1,1,1,1786),-- Spinebone Sword Blade
(21236,1867,1,3,2,117877),-- Animal Skin
(21236,1872,1,1,2,235754),-- Animal Bone
(21236,1882,1,1,2,39292),-- Leather
(21236,2184,1,1,2,18573),-- Recipe: Mithril Banded Gaiters
(21237,1933,1,1,-1,174667),-- Dark Stocking Fabric
(21237,1935,1,1,-1,82942),-- Scale Mail Fragment
(21237,2183,1,1,-1,97676),-- Recipe: Mithril Banded Mail
(21237,57,626,1255,0,700000),-- Adena
(21237,86,1,1,1,33),-- Tomahawk
(21237,179,1,1,1,33),-- Mace of Prayer
(21237,180,1,1,1,33),-- Mace of Judgment
(21237,181,1,1,1,33),-- Mace of Miracle
(21237,182,1,1,1,33),-- Doom Hammer
(21237,183,1,1,1,33),-- Mystic Staff
(21237,184,1,1,1,33),-- Conjuror\'s Staff
(21237,185,1,1,1,33),-- Staff of Mana
(21237,2022,1,1,1,1264),-- Mace of Judgment Head
(21237,2023,1,1,1,1005),-- Conjuror\'s Staff Head
(21237,1868,1,3,2,135219),-- Thread
(21237,1873,1,1,2,54088),-- Silver Nugget
(21237,1889,1,1,2,9015),-- Compound Braid
(21237,2265,1,1,2,1398),-- Recipe: Spiked Club
(21237,5549,1,1,2,13522),-- Metallic Thread
(21237,6037,1,1,2,270439),-- Waking Scroll
(21238,1878,1,1,-1,739986),-- Braided Hemp
(21238,1884,1,3,-1,569220),-- Cord
(21238,1901,1,1,-1,255520),-- Tiger\'s Eye Earring Stone
(21238,57,781,1559,0,700000),-- Adena
(21238,260,1,1,1,265),-- Triple-Edged Jamadhr
(21238,1341,20,60,2,234192),-- Bone Arrow
(21238,1874,1,1,2,9368),-- Oriharukon Ore
(21238,1878,1,1,2,56206),-- Braided Hemp
(21238,1884,1,1,2,86471),-- Cord
(21238,1889,1,1,2,9368),-- Compound Braid
(21238,2190,1,1,2,10037),-- Recipe: Mithril Stockings
(21238,5220,1,1,2,5621),-- Metal Hardener
(21239,1825,1,1,-1,139345),-- Recipe: Oriharukon
(21239,1902,1,1,-1,197653),-- Elven Earring Beads
(21239,2145,1,1,-1,139345),-- Recipe: Mithril Alloy
(21239,57,824,1645,0,700000),-- Adena
(21239,279,1,1,1,94),-- Strengthened Long Bow
(21239,2040,1,1,1,5834),-- Strengthened Long Bow Shaft
(21239,1865,1,1,2,168072),-- Varnish
(21239,1870,1,1,2,168072),-- Coal
(21239,1874,1,1,2,11205),-- Oriharukon Ore
(21239,2145,1,1,2,12005),-- Recipe: Mithril Alloy
(21239,2208,1,1,2,17185),-- Recipe: Ogre Power Gauntlets
(21239,6036,1,1,2,5603),-- Greater Magic Haste Potion
(21240,1866,1,3,-1,744614),-- Suede
(21240,1871,1,5,-1,744614),-- Charcoal
(21240,1903,1,1,-1,372617),-- Elven Ring Piece
(21240,57,932,1861,0,700000),-- Adena
(21240,224,1,1,1,54),-- Maingauche
(21240,1660,1,1,1,54),-- Cursed Maingauche
(21240,2038,1,1,1,3050),-- Maingauche Edge
(21240,2044,1,1,1,3050),-- Cursed Maingauche Edge
(21240,1341,60,180,2,160378),-- Bone Arrow
(21240,1866,1,1,2,192453),-- Suede
(21240,1871,2,6,2,72170),-- Charcoal
(21240,1877,1,1,2,11547),-- Adamantite Nugget
(21241,1805,1,1,-1,8441),-- Recipe: Soulshot: C-Grade
(21241,1905,1,1,-1,246339),-- Omen Beast\'s Eye Earring Gemstone
(21241,4469,1,1,-1,14471),-- Dye of Strength <Str+1 Con-1>
(21241,57,1020,2061,0,700000),-- Adena
(21241,396,1,1,1,347),-- Salamander Skin Mail
(21241,1952,1,1,1,20366),-- Salamander Skin Mail Texture
(21241,1867,1,1,2,242216),-- Animal Skin
(21241,1872,1,3,2,121108),-- Animal Bone
(21241,1875,1,1,2,12111),-- Stone of Purity
(21241,1881,1,1,2,24222),-- Coarse Bone Powder
(21241,2162,1,1,2,8776),-- Recipe: Aquastone Necklace
(21241,2206,1,1,2,4793),-- Recipe: Mithril Shirt
(21241,2990,1,1,2,14418),-- Recipe: Chain Boots
(21242,1908,1,1,-1,292039),-- Moonstone Earring Wire
(21242,1909,1,1,-1,416466),-- Aquastone Ring Wire
(21242,2163,1,1,-1,157343),-- Recipe: Earring of Protection
(21242,57,1220,2478,0,700000),-- Adena
(21242,96,1,1,1,28),-- Scythe
(21242,298,1,1,1,28),-- Orcish Glaive
(21242,302,1,1,1,28),-- Body Slasher
(21242,2062,1,1,1,1905),-- Scythe Edge
(21242,2075,1,1,1,1905),-- Orcish Glaive Blade
(21242,2076,1,1,1,1905),-- Body Slasher Blade
(21242,1868,1,1,2,291501),-- Thread
(21242,1873,1,1,2,58300),-- Silver Nugget
(21242,1876,1,1,2,29150),-- Mithril Ore
(21242,1895,1,1,2,41643),-- Metallic Fiber
(21242,2214,1,1,2,3617),-- Recipe: Dwarven Chain Gaiters
(21242,4042,1,1,2,2429),-- Enria
(21242,8723,1,1,200,5830),-- Life Stone: level 46
(21242,8733,1,1,200,1458),-- Mid-Grade Life Stone: level 46
(21242,8743,1,1,200,146),-- High-Grade Life Stone: level 46
(21242,8753,1,1,200,29),-- Top-Grade Life Stone: level 46
(21243,951,1,1,-1,5797),-- Scroll: Enchant Weapon (Grade C)
(21243,1911,1,1,-1,237145),-- Earring of Protection Gemstone
(21243,2166,1,1,-1,108082),-- Recipe: Earrings of Binding (100%)
(21243,57,1258,2567,0,700000),-- Adena
(21243,398,1,1,1,103),-- Plated Leather
(21243,399,1,1,1,95),-- Rind Leather Armor
(21243,418,1,1,1,165),-- Plated Leather Gaiters
(21243,419,1,1,1,152),-- Rind Leather Gaiters
(21243,1966,1,1,1,6447),-- Plated Leather Fragment
(21243,1967,1,1,1,9631),-- Plated Leather Gaiters Material
(21243,1975,1,1,1,5800),-- Rind Leather Armor Design
(21243,1976,1,1,1,10738),-- Rind Leather Gaiters Material
(21243,951,1,1,2,257),-- Scroll: Enchant Weapon (Grade C)
(21243,1868,1,1,2,282544),-- Thread
(21243,1873,1,1,2,56509),-- Silver Nugget
(21243,1876,1,1,2,28354),-- Mithril Ore
(21243,1895,1,1,2,40363),-- Metallic Fiber
(21243,4042,1,1,2,2355),-- Enria
(21243,8724,1,1,200,4709),-- Life Stone: level 49
(21243,8734,1,1,200,1177),-- Mid-Grade Life Stone: level 49
(21243,8744,1,1,200,118),-- High-Grade Life Stone: level 49
(21243,8754,1,1,200,24),-- Top-Grade Life Stone: level 49
(21244,1539,1,1,-1,788726),-- Greater Healing Potion
(21244,1914,1,1,-1,199397),-- Earring of Binding Gemstone
(21244,4601,1,1,-1,7887),-- Greater Dye of Strength <Str+3 Con-3>
(21244,57,1404,2854,0,700000),-- Adena
(21244,60,1,1,1,120),-- Composite Armor
(21244,1977,1,1,1,10855),-- Composite Armor Temper
(21244,1865,1,1,2,133433),-- Varnish
(21244,1870,1,1,2,133433),-- Coal
(21244,1875,1,1,2,8896),-- Stone of Purity
(21244,1879,1,1,2,22239),-- Cokes
(21244,2170,1,1,2,3147),-- Recipe: Nassen\'s Earring
(21244,2970,1,1,2,4732),-- Recipe: Ring of Binding
(21244,4040,1,1,2,2669),-- Mold Lubricant
(21244,8725,1,1,200,3707),-- Life Stone: level 52
(21244,8735,1,1,200,927),-- Mid-Grade Life Stone: level 52
(21244,8745,1,1,200,93),-- High-Grade Life Stone: level 52
(21244,8755,1,1,200,18),-- Top-Grade Life Stone: level 52
(21245,1915,1,1,-1,345683),-- Ring of Ages Gemstone
(21245,2169,1,1,-1,69443),-- Recipe: Necklace of Binding
(21245,2170,1,1,-1,92536),-- Recipe: Nassen\'s Earring
(21245,57,1558,3150,0,700000),-- Adena
(21245,60,1,1,1,132),-- Composite Armor
(21245,1977,1,1,1,12001),-- Composite Armor Temper
(21245,1866,1,1,2,90140),-- Suede
(21245,1871,1,1,2,135210),-- Charcoal
(21245,1877,1,1,2,5408),-- Adamantite Nugget
(21245,2353,1,1,2,221),-- Recipe: Samurai Longsword
(21245,4040,1,1,2,2704),-- Mold Lubricant
(21245,4041,1,1,2,1176),-- Mold Hardener
(21245,4122,1,1,2,6009),-- Recipe: Maestro Holder
(21245,8309,1,1,2,156),-- Recipe: Spell Breaker (100%)
(21245,8725,1,1,200,3756),-- Life Stone: level 52
(21245,8735,1,1,200,939),-- Mid-Grade Life Stone: level 52
(21245,8745,1,1,200,94),-- High-Grade Life Stone: level 52
(21245,8755,1,1,200,19),-- Top-Grade Life Stone: level 52
(21246,1867,1,13,-1,885576),-- Animal Skin
(21246,1918,1,1,-1,201354),-- Nassen\'s Earring Gemstone
(21246,4042,1,1,-1,77488),-- Enria
(21246,57,1837,3743,0,700000),-- Adena
(21246,119,1,1,1,132),-- Necklace of Binding
(21246,855,1,1,1,176),-- Nassen\'s Earring
(21246,886,1,1,1,263),-- Ring of Binding
(21246,1918,1,1,1,12392),-- Nassen\'s Earring Gemstone
(21246,1920,1,1,1,9790),-- Necklace of Binding Chain
(21246,2917,1,1,1,16434),-- Ring of Binding Gemstone
(21246,1867,1,1,2,190739),-- Animal Skin
(21246,1872,1,1,2,190739),-- Animal Bone
(21246,1882,1,1,2,31790),-- Leather
(21246,1894,1,1,2,5019),-- Crafted Leather
(21246,4042,1,1,2,2384),-- Enria
(21246,4127,1,1,2,3541),-- Recipe: Adamantite Ring
(21246,4183,1,1,2,165),-- Recipe: Heavy War Axe
(21246,4965,1,1,2,165),-- Recipe: Sprite\'s Staff (60%)
(21246,8726,1,1,200,3311),-- Life Stone: level 55
(21246,8736,1,1,200,828),-- Mid-Grade Life Stone: level 55
(21246,8746,1,1,200,83),-- High-Grade Life Stone: level 55
(21246,8756,1,1,200,17),-- Top-Grade Life Stone: level 55
(21247,4049,1,1,-1,249606),-- Adamantite Earring Gemstone
(21247,4129,1,1,-1,51501),-- Recipe: Earrings of Black Ore
(21247,4613,1,1,-1,6564),-- Greater Dye of Strength <Str+4 Con-4>
(21247,57,1877,3833,0,700000),-- Adena
(21247,554,1,1,1,88),-- Zubei\'s Boots
(21247,600,1,1,1,88),-- Avadon Boots
(21247,612,1,1,1,88),-- Zubei\'s Gauntlets
(21247,2464,1,1,1,88),-- Avadon Gloves
(21247,4073,1,1,1,9145),-- Avadon Gloves Part
(21247,4097,1,1,1,9145),-- Zubei\'s Boots Design
(21247,4098,1,1,1,9145),-- Avadon Boots Design
(21247,4100,1,1,1,9145),-- Zubei\'s Gauntlets Part
(21247,1867,1,1,2,170382),-- Animal Skin
(21247,1872,1,1,2,170382),-- Animal Bone
(21247,1875,1,1,2,8519),-- Stone of Purity
(21247,1881,1,1,2,17038),-- Coarse Bone Powder
(21247,4041,1,1,2,1111),-- Mold Hardener
(21247,4131,1,1,2,1039),-- Recipe: Necklace of Black Ore
(21247,4173,1,1,2,1589),-- Recipe: Blue Wolf Gloves
(21247,8727,1,1,200,2556),-- Life Stone: level 58
(21247,8737,1,1,200,639),-- Mid-Grade Life Stone: level 58
(21247,8747,1,1,200,64),-- High-Grade Life Stone: level 58
(21247,8757,1,1,200,13),-- Top-Grade Life Stone: level 58
(21248,4050,1,1,-1,322099),-- Adamantite Ring Wire
(21248,4051,1,1,-1,201616),-- Adamantite Necklace Chain
(21248,4130,1,1,-1,84394),-- Recipe: Ring of Black Ore
(21248,57,2056,4180,0,700000),-- Adena
(21248,503,1,1,1,64),-- Zubei\'s Helmet
(21248,633,1,1,1,92),-- Zubei\'s Shield
(21248,673,1,1,1,92),-- Avadon Shield
(21248,2415,1,1,1,64),-- Avadon Circlet
(21248,4072,1,1,1,8620),-- Avadon Circlet Pattern
(21248,4101,1,1,1,11126),-- Zubei\'s Shield Fragment
(21248,4102,1,1,1,8620),-- Zubei\'s Helmet Design
(21248,4439,1,1,1,13236),-- Avadon Shield Fragment
(21248,1864,1,1,2,279201),-- Stem
(21248,1869,1,1,2,139601),-- Iron Ore
(21248,1880,1,1,2,13960),-- Steel
(21248,4043,1,1,2,4653),-- Asofe
(21248,4159,1,1,2,395),-- Recipe: Blue Wolf Leather Armor
(21248,5550,1,1,2,1861),-- Durable Metal Plate
(21248,6036,1,1,2,4654),-- Greater Magic Haste Potion
(21248,8728,1,1,200,2327),-- Life Stone: level 61
(21248,8738,1,1,200,581),-- Mid-Grade Life Stone: level 61
(21248,8748,1,1,200,58),-- High-Grade Life Stone: level 61
(21248,8758,1,1,200,12),-- Top-Grade Life Stone: level 61
(21249,4052,1,1,-1,201435),-- Earring of Black Ore Piece
(21249,4053,1,1,-1,243872),-- Ring of Black Ore Gemstone
(21249,5230,1,1,-1,7586),-- Recipe: Mithril Arrow (100%)
(21249,57,2256,4571,0,700000),-- Adena
(21249,358,1,1,1,23),-- Blue Wolf Breastplate
(21249,2380,1,1,1,36),-- Blue Wolf Gaiters
(21249,2381,1,1,1,14),-- Doom Plate Armor
(21249,4078,1,1,1,4092),-- Blue Wolf Breastplate Part
(21249,4080,1,1,1,5762),-- Blue Wolf Gaiters Material
(21249,4081,1,1,1,2761),-- Doom Plate Armor Temper
(21249,1866,1,1,2,112040),-- Suede
(21249,1871,1,1,2,168060),-- Charcoal
(21249,1877,1,1,2,6722),-- Adamantite Nugget
(21249,4040,1,1,2,3361),-- Mold Lubricant
(21249,4041,1,1,2,1461),-- Mold Hardener
(21249,5166,1,1,2,224),-- Recipe: Blessed Spiritshot (A) Compressed Package (100%)
(21249,8729,1,1,200,2241),-- Life Stone: level 64
(21249,8739,1,1,200,560),-- Mid-Grade Life Stone: level 64
(21249,8749,1,1,200,56),-- High-Grade Life Stone: level 64
(21249,8759,1,1,200,11),-- Top-Grade Life Stone: level 64
(21250,4052,1,1,-1,235314),-- Earring of Black Ore Piece
(21250,4053,1,1,-1,284889),-- Ring of Black Ore Gemstone
(21250,5230,1,1,-1,8862),-- Recipe: Mithril Arrow (100%)
(21250,57,2634,5340,0,700000),-- Adena
(21250,171,1,1,1,6),-- Deadman\'s Glory
(21250,175,1,1,1,6),-- Art of Battle Axe
(21250,210,1,1,1,6),-- Staff of Evil Spirits
(21250,4116,1,1,1,1430),-- Deadman\'s Glory Stone
(21250,4117,1,1,1,1430),-- Art of Battle Axe Blade
(21250,4118,1,1,1,1354),-- Evil Spirit Head
(21250,1344,20,60,2,111549),-- Mithril Arrow
(21250,1830,1,1,2,71391),-- Scroll of Escape: Castle
(21250,1866,1,1,2,118986),-- Suede
(21250,1871,1,1,2,178478),-- Charcoal
(21250,1877,1,1,2,7139),-- Adamantite Nugget
(21250,4040,1,1,2,3570),-- Mold Lubricant
(21250,4041,1,1,2,1552),-- Mold Hardener
(21250,8729,1,1,200,2380),-- Life Stone: level 64
(21250,8739,1,1,200,595),-- Mid-Grade Life Stone: level 64
(21250,8749,1,1,200,59),-- High-Grade Life Stone: level 64
(21250,8759,1,1,200,12),-- Top-Grade Life Stone: level 64
(21251,4053,1,1,-1,305600),-- Ring of Black Ore Gemstone
(21251,4054,1,1,-1,140430),-- Necklace of Black Ore Beads
(21251,5230,1,1,-1,9506),-- Recipe: Mithril Arrow (100%)
(21251,57,2811,5744,0,700000),-- Adena
(21251,2398,1,1,1,28),-- Blue Wolf Tunic
(21251,2399,1,1,1,28),-- Tunic of Doom
(21251,2403,1,1,1,45),-- Blue Wolf Stockings
(21251,2404,1,1,1,45),-- Stockings of Doom
(21251,4084,1,1,1,4576),-- Blue Wolf Tunic Fabric
(21251,4085,1,1,1,4576),-- Tunic of Doom Pattern
(21251,4086,1,1,1,6179),-- Blue Wolf Stockings Pattern
(21251,4087,1,1,1,6179),-- Stockings of Doom Pattern
(21251,1344,20,60,2,119658),-- Mithril Arrow
(21251,1830,1,1,2,76581),-- Scroll of Escape: Castle
(21251,1866,1,1,2,127636),-- Suede
(21251,1871,1,3,2,63818),-- Charcoal
(21251,1885,1,1,2,15954),-- High Grade Suede
(21251,4041,1,1,2,1665),-- Mold Hardener
(21251,5220,1,1,2,7658),-- Metal Hardener
(21251,8730,1,1,200,2127),-- Life Stone: level 67
(21251,8740,1,1,200,532),-- Mid-Grade Life Stone: level 67
(21251,8750,1,1,200,53),-- High-Grade Life Stone: level 67
(21251,8760,1,1,200,11),-- Top-Grade Life Stone: level 67
(21252,4053,1,1,-1,311606),-- Ring of Black Ore Gemstone
(21252,5230,1,1,-1,9693),-- Recipe: Mithril Arrow (100%)
(21252,5478,1,1,-1,61132),-- Sealed Dark Crystal Leather Armor Pattern
(21252,57,2875,5849,0,700000),-- Adena
(21252,5297,1,1,1,27),-- Sealed Dark Crystal Leather Armor
(21252,5298,1,1,1,43),-- Sealed Dark Crystalline Leggings
(21252,5301,1,1,1,16),-- Sealed Tallum Leather Armor
(21252,5478,1,1,1,3009),-- Sealed Dark Crystal Leather Armor Pattern
(21252,5479,1,1,1,2117),-- Sealed Tallum Leather Armor Pattern
(21252,5482,1,1,1,4723),-- Sealed Dark Crystalline Leggings Design
(21252,10608,1,1,3,11545),-- Forgotten Scroll - Chant of Combat
(21252,10579,1,1,3,11545),-- Forgotten Scroll - Improve Combat
(21252,10583,1,1,3,11545),-- Forgotten Scroll - Improve Shield Defense
(21252,14214,1,1,3,11545),-- Forgotten Scroll - Chant of Movement
(21253,1807,1,1,-1,8408),-- Recipe: Soulshot: A-Grade
(21253,3035,1,1,-1,8408),-- Recipe: Spiritshot A
(21253,5479,1,1,-1,37315),-- Sealed Tallum Leather Armor Pattern
(21253,57,3110,6350,0,700000),-- Adena
(21253,5304,1,1,1,29),-- Sealed Tallum Tunic
(21253,5305,1,1,1,46),-- Sealed Tallum Stockings
(21253,5308,1,1,1,18),-- Sealed Dark Crystal Robe
(21253,5485,1,1,1,3263),-- Sealed Tallum Tunic Texture
(21253,5486,1,1,1,2296),-- Sealed Dark Crystal Robe Fabric
(21253,5489,1,1,1,5122),-- Sealed Tallum Stockings Fabric
(21253,10610,1,1,3,11642),-- Forgotten Scroll - Chant of Blood Awakening
(21253,14215,1,1,3,12065),-- Forgotten Scroll - Combat of Paagrio
(21253,10582,1,1,3,11642),-- Forgotten Scroll - Improve Critical Attack
(21253,10580,1,1,3,11642),-- Forgotten Scroll - Improve Magic
(21254,729,1,1,-1,808),-- Scroll: Enchant Weapon (Grade A)
(21254,1877,1,1,-1,290856),-- Adamantite Nugget
(21254,5480,1,1,-1,32628),-- Sealed Leather Armor of Nightmare Fabric
(21254,57,3587,7319,0,700000),-- Adena
(21254,6323,1,1,1,67),-- Sealed Phoenix Necklace
(21254,6324,1,1,1,89),-- Sealed Phoenix Earring
(21254,6325,1,1,1,134),-- Sealed Phoenix Ring
(21254,6341,1,1,1,12376),-- Sealed Phoenix Earring Gemstone
(21254,6343,1,1,1,9567),-- Sealed Phoenix Necklace Beads
(21254,6345,1,1,1,17118),-- Sealed Phoenix Ring Gemstone
(21254,14216,1,1,3,53696),-- Forgotten Scroll - Critical of Paagrio
(21255,4041,1,1,-1,67285),-- Mold Hardener
(21255,5481,1,1,-1,34721),-- Sealed Majestic Leather Armor Fabric
(21255,5487,1,1,-1,34844),-- Sealed Robe of Nightmare Fabric
(21255,57,3814,7793,0,700000),-- Adena
(21255,5297,1,1,1,36),-- Sealed Dark Crystal Leather Armor
(21255,5298,1,1,1,57),-- Sealed Dark Crystalline Leggings
(21255,5301,1,1,1,22),-- Sealed Tallum Leather Armor
(21255,5478,1,1,1,4994),-- Sealed Dark Crystal Leather Armor Pattern
(21255,5479,1,1,1,2817),-- Sealed Tallum Leather Armor Pattern
(21255,5482,1,1,1,6284),-- Sealed Dark Crystalline Leggings Design
(21255,1868,3,9,2,95235),-- Thread
(21255,1873,1,1,2,114282),-- Silver Nugget
(21255,1876,1,1,2,57141),-- Mithril Ore
(21255,1895,1,1,2,81630),-- Metallic Fiber
(21255,4042,1,1,2,4762),-- Enria
(21255,6671,1,1,2,31745),-- Deluxe Chest Key - Grade 7
(21255,5282,1,1,2,127),-- Recipe: Greater Blessed Spiritshot (S) Compressed Package(100%)
(21255,8732,1,1,200,2381),-- Life Stone: level 76
(21255,8742,1,1,200,595),-- Mid-Grade Life Stone: level 76
(21255,8752,1,1,200,59),-- High-Grade Life Stone: level 76
(21256,1804,1,1,-1,12984),-- Recipe: Soulshot: D-Grade
(21256,1872,1,1,-1,432806),-- Animal Bone
(21256,1898,1,1,-1,33344),-- Blue Diamond Necklace Gem
(21256,57,149,262,0,700000),-- Adena
(21256,27,1,1,1,338),-- Hard Leather Shirt
(21256,33,1,1,1,542),-- Hard Leather Gaiters
(21256,1927,1,1,1,3825),-- Hard Leather Shirt Pattern
(21256,1929,1,1,1,6168),-- Hard Leather Gaiters Material
(21256,735,1,1,2,2664),-- Potion of Alacrity
(21256,1867,1,1,2,42615),-- Animal Skin
(21256,1872,1,1,2,42615),-- Animal Bone
(21256,1882,1,1,2,7103),-- Leather
(21256,8294,1,1,2,781),-- Recipe: Steel Sword (100%)
(21256,5153,1,1,2,1279),-- Recipe: Soulshot (D) Compressed Package (100%)
(21257,734,1,1,-1,42627),-- Haste Potion
(21257,1868,1,1,-1,511527),-- Thread
(21257,1897,1,1,-1,60896),-- Necklace of Wisdom Chain
(21257,57,122,202,0,700000),-- Adena
(21257,217,1,1,1,144),-- Shining Knife
(21257,218,1,1,1,144),-- Throwing Knife
(21257,735,1,1,2,4198),-- Potion of Alacrity
(21257,1868,1,1,2,100732),-- Thread
(21257,1873,1,1,2,20147),-- Silver Nugget
(21259,4049,1,1,-1,276943),-- Adamantite Earring Gemstone
(21259,4129,1,1,-1,57142),-- Recipe: Earrings of Black Ore
(21259,4613,1,1,-1,7283),-- Greater Dye of Strength <Str+4 Con-4>
(21259,57,2085,4248,0,700000),-- Adena
(21259,229,1,1,1,12),-- Kris
(21259,243,1,1,1,12),-- Hell Knife
(21259,4109,1,1,1,2197),-- Kris Edge
(21259,4110,1,1,1,2197),-- Hell Knife Edge
(21259,947,1,1,2,62),-- Scroll: Enchant Weapon (Grade B)
(21259,1868,1,1,2,311920),-- Thread
(21259,1873,1,1,2,62384),-- Silver Nugget
(21259,1876,1,1,2,31192),-- Mithril Ore
(21259,1895,1,1,2,44560),-- Metallic Fiber
(21259,4042,1,1,2,2599),-- Enria
(21259,8728,1,1,200,2599),-- Life Stone: level 61
(21259,8738,1,1,200,650),-- Mid-Grade Life Stone: level 61
(21259,8748,1,1,200,65),-- High-Grade Life Stone: level 61
(21259,8758,1,1,200,12),-- Top-Grade Life Stone: level 61
(21261,1914,1,1,-1,92873),-- Earring of Binding Gemstone
(21261,2169,1,1,-1,29259),-- Recipe: Necklace of Binding
(21261,2170,1,1,-1,38989),-- Recipe: Nassen\'s Earring
(21261,57,654,1329,0,700000),-- Adena
(21261,231,1,1,1,10),-- Grace Dagger
(21261,233,1,1,1,10),-- Dark Screamer
(21261,2106,1,1,1,932),-- Grace Dagger Edge
(21261,2107,1,1,1,932),-- Dark Screamer Edge
(21261,1539,1,1,2,13811),-- Greater Healing Potion
(21261,1864,1,1,2,124298),-- Stem
(21261,1869,1,1,2,62149),-- Iron Ore
(21261,1880,1,1,2,6215),-- Steel
(21261,2231,1,1,2,268),-- Recipe: Full Plate Armor
(21261,4043,1,1,2,2072),-- Asofe
(21261,5550,1,1,2,829),-- Durable Metal Plate
(21261,8725,1,1,200,1726),-- Life Stone: level 52
(21261,8735,1,1,200,432),-- Mid-Grade Life Stone: level 52
(21261,8745,1,1,200,43),-- High-Grade Life Stone: level 52
(21261,8755,1,1,200,9),-- Top-Grade Life Stone: level 52
(21262,1914,1,1,-1,124797),-- Earring of Binding Gemstone
(21262,2169,1,1,-1,39317),-- Recipe: Necklace of Binding
(21262,2170,1,1,-1,52391),-- Recipe: Nassen\'s Earring
(21262,57,879,1786,0,700000),-- Adena
(21262,228,1,1,1,17),-- Crystal Dagger
(21262,2119,1,1,1,1869),-- Crystal Dagger Blade
(21262,1539,1,1,2,16570),-- Greater Healing Potion
(21262,1864,1,1,2,149128),-- Stem
(21262,1869,1,1,2,74564),-- Iron Ore
(21262,1880,1,1,2,7456),-- Steel
(21262,2231,1,1,2,321),-- Recipe: Full Plate Armor
(21262,4043,1,1,2,2486),-- Asofe
(21262,5550,1,1,2,994),-- Durable Metal Plate
(21262,8726,1,1,200,1726),-- Life Stone: level 55
(21262,8736,1,1,200,432),-- Mid-Grade Life Stone: level 55
(21262,8746,1,1,200,43),-- High-Grade Life Stone: level 55
(21262,8756,1,1,200,9),-- Top-Grade Life Stone: level 55
(21263,1914,1,1,-1,175302),-- Earring of Binding Gemstone
(21263,2169,1,1,-1,55228),-- Recipe: Necklace of Binding
(21263,2170,1,1,-1,73594),-- Recipe: Nassen\'s Earring
(21263,57,1233,2512,0,700000),-- Adena
(21263,228,1,1,1,24),-- Crystal Dagger
(21263,2119,1,1,1,2625),-- Crystal Dagger Blade
(21263,1539,1,1,2,23275),-- Greater Healing Potion
(21263,1864,1,1,2,209480),-- Stem
(21263,1869,1,1,2,104740),-- Iron Ore
(21263,1880,1,1,2,10474),-- Steel
(21263,2231,1,1,2,452),-- Recipe: Full Plate Armor
(21263,4043,1,1,2,3491),-- Asofe
(21263,5550,1,1,2,1396),-- Durable Metal Plate
(21263,8726,1,1,200,2425),-- Life Stone: level 55
(21263,8736,1,1,200,606),-- Mid-Grade Life Stone: level 55
(21263,8746,1,1,200,61),-- High-Grade Life Stone: level 55
(21263,8756,1,1,200,12),-- Top-Grade Life Stone: level 55
(21264,1914,1,1,-1,242396),-- Earring of Binding Gemstone
(21264,2169,1,1,-1,76366),-- Recipe: Necklace of Binding
(21264,2170,1,1,-1,101761),-- Recipe: Nassen\'s Earring
(21264,57,1704,3471,0,700000),-- Adena
(21264,11915,1,1,1,10),-- Common Item - Kris
(21264,11919,1,1,1,10),-- Common Item - Hell Knife
(21264,4109,1,1,1,1795),-- Kris Edge
(21264,4110,1,1,1,1795),-- Hell Knife Edge
(21264,1539,1,1,2,25748),-- Greater Healing Potion
(21264,1864,1,1,2,231724),-- Stem
(21264,1869,1,1,2,115862),-- Iron Ore
(21264,1880,1,1,2,11586),-- Steel
(21264,2231,1,1,2,499),-- Recipe: Full Plate Armor
(21264,4043,1,1,2,3862),-- Asofe
(21264,5550,1,1,2,1545),-- Durable Metal Plate
(21264,8727,1,1,200,2317),-- Life Stone: level 58
(21264,8737,1,1,200,579),-- Mid-Grade Life Stone: level 58
(21264,8747,1,1,200,58),-- High-Grade Life Stone: level 58(21265,1864,1,3,-1,627198),-- Stem
(21264,8757,1,1,200,11),-- Top-Grade Life Stone: level 58(21265,1869,1,1,-1,627198),-- Iron Ore
(21265,1901,1,1,-1,86630),-- Tiger\'s Eye Earring Stone
(21265,57,264,530,0,700000),-- Adena
(21265,83,1,1,1,20),-- Sword of Magic
(21265,124,1,1,1,15),-- Two-Handed Sword
(21265,127,1,1,1,15),-- Crimson Sword
(21265,130,1,1,1,15),-- Elven Sword
(21265,144,1,1,1,20),-- Sword of Occult
(21265,2026,1,1,1,669),-- Two-Handed Sword Edge
(21265,1864,1,1,2,133390),-- Stem
(21265,1869,1,1,2,66695),-- Iron Ore
(21265,1878,1,1,2,26678),-- Braided Hemp
(21265,1884,1,1,2,41043),-- Cord
(21265,2154,1,1,2,7141),-- Recipe: Elven Earring
(21268,1940,1,1,-1,174118),-- Iron Boots Design
(21268,2026,1,1,-1,14041),-- Two-Handed Sword Edge
(21268,2156,1,1,-1,93327),-- Recipe: Elven Necklace
(21268,57,492,986,0,700000),-- Adena
(21268,278,1,1,1,83),-- Gastraphetes
(21268,2029,1,1,1,3700),-- Gastraphetes Shaft
(21268,1341,20,60,2,147682),-- Bone Arrow
(21268,1867,1,1,2,118146),-- Animal Skin
(21268,1872,1,1,2,118146),-- Animal Bone
(21268,1882,1,1,2,19691),-- Leather
(21268,1894,1,1,2,3109),-- Crafted Leather
(21268,2186,1,1,2,2963),-- Recipe: Brigandine Tunic
(21268,6037,1,3,2,59073),-- Waking Scroll
(21269,1825,1,1,-1,94807),-- Recipe: Oriharukon
(21269,1902,1,1,-1,134478),-- Elven Earring Beads
(21269,2145,1,1,-1,94807),-- Recipe: Mithril Alloy
(21269,57,561,1119,0,700000),-- Adena
(21269,129,1,1,1,64),-- Sword of Revolution
(21269,2034,1,1,1,3624),-- Sword of Revolution Blade
(21269,1825,1,1,2,9802),-- Recipe: Oriharukon
(21269,1867,1,1,2,182693),-- Animal Skin
(21269,1872,1,1,2,182693),-- Animal Bone
(21269,1875,1,1,2,9148),-- Stone of Purity
(21269,1881,1,1,2,18296),-- Coarse Bone Powder
(21270,1902,1,1,-1,155008),-- Elven Earring Beads
(21270,1903,1,1,-1,255201),-- Elven Ring Piece
(21270,6036,1,1,-1,50998),-- Greater Magic Haste Potion
(21270,57,647,1291,0,700000),-- Adena
(21270,88,1,1,1,15),-- Morning Star
(21270,90,1,1,1,15),-- Goat Head Staff
(21270,158,1,1,1,15),-- Tarbar
(21270,169,1,1,1,15),-- Skull Breaker
(21270,172,1,1,1,15),-- Heavy Bone Club
(21270,2031,1,1,1,800),-- Morning Star Head
(21270,2032,1,1,1,731),-- Goat Head Staff Head
(21270,2035,1,1,1,800),-- Tarbar Head
(21270,2036,1,1,1,800),-- Skull Breaker Head
(21270,2037,1,1,1,800),-- Heavy Bone Club Head
(21270,1868,1,1,2,316343),-- Thread
(21270,1873,1,1,2,63269),-- Silver Nugget
(21270,1889,1,1,2,10545),-- Compound Braid
(21270,2145,1,1,2,11298),-- Recipe: Mithril Alloy
(21270,5549,1,1,2,15817),-- Metallic Thread
(21271,1864,1,3,-1,905720),-- Stem
(21271,1869,1,1,-1,905720),-- Iron Ore
(21271,1901,1,1,-1,125099),-- Tiger\'s Eye Earring Stone
(21271,57,383,764,0,700000),-- Adena
(21271,129,1,1,1,44),-- Sword of Revolution
(21271,2034,1,1,1,2473),-- Sword of Revolution Blade
(21271,1864,1,1,2,187275),-- Stem
(21271,1869,1,1,2,93637),-- Iron Ore
(21271,1878,1,1,2,37455),-- Braided Hemp
(21271,1884,1,1,2,57623),-- Cord
(21271,2154,1,1,2,10026),-- Recipe: Elven Earring
(21272,1864,1,7,-1,802957),-- Stem
(21272,1869,1,3,-1,802957),-- Iron Ore
(21272,1901,1,1,-1,221811),-- Tiger\'s Eye Earring Stone
(21272,57,679,1355,0,700000),-- Adena
(21272,129,1,1,1,77),-- Sword of Revolution
(21272,2034,1,1,1,4386),-- Sword of Revolution Blade
(21272,1864,3,9,2,55342),-- Stem
(21272,1869,1,1,2,166027),-- Iron Ore
(21272,1878,1,1,2,66411),-- Braided Hemp
(21272,1884,1,1,2,102170),-- Cord
(21272,2154,1,1,2,17776),-- Recipe: Elven Earring
(21273,1864,1,19,-1,930725),-- Stem
(21273,1869,1,9,-1,930725),-- Iron Ore
(21273,1901,1,1,-1,642766),-- Tiger\'s Eye Earring Stone
(21273,57,1969,3922,0,700000),-- Adena
(21273,129,1,1,1,224),-- Sword of Revolution
(21273,2034,1,1,1,127081),-- Sword of Revolution Blade
(21273,1864,3,9,2,160371),-- Stem
(21273,1869,2,6,2,120279),-- Iron Ore
(21273,1878,3,9,2,32074),-- Braided Hemp
(21273,1884,2,6,2,59214),-- Cord
(21273,2154,1,1,2,51511),-- Recipe: Elven Earring
(21274,4087,1,1,-1,72770),-- Stockings of Doom Pattern
(21274,4088,1,1,-1,117199),-- Blue Wolf Helmet Design
(21274,6333,1,1,-1,35604),-- Recipe: Sealed Phoenix Ring(70%)
(21274,57,1223,2498,0,700000),-- Adena
(21274,12341,1,1,1,708),-- Common Item - Earring of Black Ore
(21274,12343,1,1,1,1060),-- Common Item - Ring of Black Ore
(21274,12342,1,1,1,531),-- Common Item - Necklace of Black Ore
(21274,4052,1,1,1,5405),-- Earring of Black Ore Piece
(21274,4053,1,1,1,6544),-- Ring of Black Ore Gemstone
(21274,4054,1,1,1,3007),-- Necklace of Black Ore Beads
(21274,1343,10,30,2,118692),-- Silver Arrow
(21274,1864,1,1,2,166548),-- Stem
(21274,1869,1,1,2,83274),-- Iron Ore
(21274,1878,1,1,2,33310),-- Braided Hemp
(21274,1884,1,1,2,51246),-- Cord
(21274,4039,1,1,2,2776),-- Mold Glue
(21274,5456,1,1,2,31),-- Recipe: Tallum Glaive(60%)
(21274,8730,1,1,200,925),-- Life Stone: level 67
(21274,8740,1,1,200,231),-- Mid-Grade Life Stone: level 67
(21274,8750,1,1,200,23),-- High-Grade Life Stone: level 67
(21274,8760,1,1,200,5),-- Top-Grade Life Stone: level 67
(21275,4087,1,1,-1,73242),-- Stockings of Doom Pattern
(21275,4088,1,1,-1,117959),-- Blue Wolf Helmet Design
(21275,6333,1,1,-1,35835),-- Recipe: Sealed Phoenix Ring(70%)
(21275,57,1230,2515,0,700000),-- Adena
(21275,12341,1,1,1,713),-- Common Item - Earring of Black Ore
(21275,12343,1,1,1,1067),-- Common Item - Ring of Black Ore
(21275,12342,1,1,1,534),-- Common Item - Necklace of Black Ore
(21275,4052,1,1,1,5440),-- Earring of Black Ore Piece
(21275,4053,1,1,1,6586),-- Ring of Black Ore Gemstone
(21275,4054,1,1,1,3037),-- Necklace of Black Ore Beads
(21275,1343,10,30,2,119734),-- Silver Arrow
(21275,1864,1,1,2,167628),-- Stem
(21275,1869,1,1,2,83814),-- Iron Ore
(21275,1878,1,1,2,33526),-- Braided Hemp
(21275,1884,1,1,2,51578),-- Cord
(21275,4039,1,1,2,2794),-- Mold Glue
(21275,5456,1,1,2,31),-- Recipe: Tallum Glaive(60%)
(21275,8730,1,1,200,931),-- Life Stone: level 67
(21275,8740,1,1,200,232),-- Mid-Grade Life Stone: level 67
(21275,8750,1,1,200,23),-- High-Grade Life Stone: level 67
(21275,8760,1,1,200,5),-- Top-Grade Life Stone: level 67
(21276,4087,1,1,-1,72350),-- Stockings of Doom Pattern
(21276,4088,1,1,-1,116524),-- Blue Wolf Helmet Design
(21276,6333,1,1,-1,35399),-- Recipe: Sealed Phoenix Ring(70%)
(21276,57,1216,2484,0,700000),-- Adena
(21276,12341,1,1,1,704),-- Common Item - Earring of Black Ore
(21276,12343,1,1,1,1054),-- Common Item - Ring of Black Ore
(21276,12342,1,1,1,528),-- Common Item - Necklace of Black Ore
(21276,4052,1,1,1,5374),-- Earring of Black Ore Piece
(21276,4053,1,1,1,6506),-- Ring of Black Ore Gemstone
(21276,4054,1,1,1,2990),-- Necklace of Black Ore Beads
(21276,1343,10,30,2,118277),-- Silver Arrow
(21276,1864,1,1,2,165588),-- Stem
(21276,1869,1,1,2,82794),-- Iron Ore
(21276,1878,1,1,2,33118),-- Braided Hemp
(21276,1884,1,1,2,50950),-- Cord
(21276,4039,1,1,2,2760),-- Mold Glue
(21276,5456,1,1,2,30),-- Recipe: Tallum Glaive(60%)
(21276,8730,1,1,200,920),-- Life Stone: level 67
(21276,8740,1,1,200,230),-- Mid-Grade Life Stone: level 67
(21276,8750,1,1,200,23),-- High-Grade Life Stone: level 67
(21276,8760,1,1,200,5),-- Top-Grade Life Stone: level 67
(21278,729,1,1,-1,356),-- Scroll: Enchant Weapon (Grade A)
(21278,4040,1,1,-1,64087),-- Mold Lubricant
(21278,5478,1,1,-1,26945),-- Sealed Dark Crystal Leather Armor Pattern
(21278,57,1268,2577,0,700000),-- Adena
(21278,11957,1,1,1,43),-- Common Item - Tallum Blade
(21278,11952,1,1,1,43),-- Common Item - Elemental Sword
(21278,11954,1,1,1,43),-- Common Item - Infernal Master
(21278,8331,1,1,1,538),-- Infernal Master Blade
(21278,5547,1,1,1,537),-- Elemental Sword Edge
(21278,5548,1,1,1,537),-- Tallum Blade Edge
(21278,1865,1,1,2,94651),-- Varnish
(21278,1870,1,1,2,94651),-- Coal
(21278,1875,1,1,2,6310),-- Stone of Purity
(21278,1879,1,1,2,15775),-- Cokes
(21278,4040,1,1,2,1893),-- Mold Lubricant
(21278,6339,1,1,2,728),-- Recipe: Sealed Majestic Ring(70%)
(21278,8730,1,1,200,1052),-- Life Stone: level 67
(21278,8740,1,1,200,263),-- Mid-Grade Life Stone: level 67
(21278,8750,1,1,200,26),-- High-Grade Life Stone: level 67
(21278,8760,1,1,200,5),-- Top-Grade Life Stone: level 67
(21279,729,1,1,-1,354),-- Scroll: Enchant Weapon (Grade A)
(21279,4040,1,1,-1,63717),-- Mold Lubricant
(21279,5478,1,1,-1,26790),-- Sealed Dark Crystal Leather Armor Pattern
(21279,57,1260,2562,0,700000),-- Adena
(21279,11957,1,1,1,43),-- Common Item - Tallum Blade
(21279,11952,1,1,1,43),-- Common Item - Elemental Sword
(21279,11954,1,1,1,43),-- Common Item - Infernal Master
(21279,8331,1,1,1,535),-- Infernal Master Blade
(21279,5547,1,1,1,534),-- Elemental Sword Edge
(21279,5548,1,1,1,534),-- Tallum Blade Edge
(21279,1865,1,1,2,94106),-- Varnish
(21279,1870,1,1,2,94106),-- Coal
(21279,1875,1,1,2,6274),-- Stone of Purity
(21279,1879,1,1,2,15684),-- Cokes
(21279,4040,1,1,2,1882),-- Mold Lubricant
(21279,6339,1,1,2,724),-- Recipe: Sealed Majestic Ring(70%)
(21279,8730,1,1,200,1046),-- Life Stone: level 67
(21279,8740,1,1,200,261),-- Mid-Grade Life Stone: level 67
(21279,8750,1,1,200,26),-- High-Grade Life Stone: level 67
(21279,8760,1,1,200,5),-- Top-Grade Life Stone: level 67
(21280,729,1,1,-1,358),-- Scroll: Enchant Weapon (Grade A)
(21280,4040,1,1,-1,64502),-- Mold Lubricant
(21280,5478,1,1,-1,27120),-- Sealed Dark Crystal Leather Armor Pattern
(21280,57,1276,2593,0,700000),-- Adena
(21280,11957,1,1,1,44),-- Common Item - Tallum Blade
(21280,11952,1,1,1,44),-- Common Item - Elemental Sword
(21280,11954,1,1,1,44),-- Common Item - Infernal Master
(21280,8331,1,1,1,542),-- Infernal Master Blade
(21280,5547,1,1,1,540),-- Elemental Sword Edge
(21280,5548,1,1,1,540),-- Tallum Blade Edge
(21280,1865,1,1,2,95265),-- Varnish
(21280,1870,1,1,2,95265),-- Coal
(21280,1875,1,1,2,6351),-- Stone of Purity
(21280,1879,1,1,2,15878),-- Cokes
(21280,4040,1,1,2,1905),-- Mold Lubricant
(21280,6339,1,1,2,733),-- Recipe: Sealed Majestic Ring(70%)
(21280,8730,1,1,200,1058),-- Life Stone: level 67
(21280,8740,1,1,200,265),-- Mid-Grade Life Stone: level 67
(21280,8750,1,1,200,26),-- High-Grade Life Stone: level 67
(21280,8760,1,1,200,5),-- Top-Grade Life Stone: level 67
(21282,729,1,1,-1,368),-- Scroll: Enchant Weapon (Grade A)
(21282,4040,1,1,-1,66152),-- Mold Lubricant
(21282,5536,1,1,-1,11253),-- Bloody Orchid Head
(21282,57,1309,2658,0,700000),-- Adena
(21282,11957,1,1,1,45),-- Common Item - Tallum Blade
(21282,11952,1,1,1,45),-- Common Item - Elemental Sword
(21282,11954,1,1,1,45),-- Common Item - Infernal Master
(21282,8331,1,1,1,556),-- Infernal Master Blade
(21282,5547,1,1,1,554),-- Elemental Sword Edge
(21282,5548,1,1,1,554),-- Tallum Blade Edge
(21282,1865,1,1,2,97701),-- Varnish
(21282,1870,1,1,2,97701),-- Coal
(21282,1875,1,1,2,6513),-- Stone of Purity
(21282,1879,1,1,2,16284),-- Cokes
(21282,4040,1,1,2,1954),-- Mold Lubricant
(21282,5456,1,1,2,36),-- Recipe: Tallum Glaive(60%)
(21282,8730,1,1,200,1086),-- Life Stone: level 67
(21282,8740,1,1,200,271),-- Mid-Grade Life Stone: level 67
(21282,8750,1,1,200,27),-- High-Grade Life Stone: level 67
(21282,8760,1,1,200,5),-- Top-Grade Life Stone: level 67
(21283,729,1,1,-1,370),-- Scroll: Enchant Weapon (Grade A)
(21283,4040,1,1,-1,66581),-- Mold Lubricant
(21283,5536,1,1,-1,11326),-- Bloody Orchid Head
(21283,57,1318,2676,0,700000),-- Adena
(21283,11957,1,1,1,45),-- Common Item - Tallum Blade
(21283,11952,1,1,1,45),-- Common Item - Elemental Sword
(21283,11954,1,1,1,45),-- Common Item - Infernal Master
(21283,8331,1,1,1,559),-- Infernal Master Blade
(21283,5547,1,1,1,558),-- Elemental Sword Edge
(21283,5548,1,1,1,558),-- Tallum Blade Edge
(21283,1865,1,1,2,98335),-- Varnish
(21283,1870,1,1,2,98335),-- Coal
(21283,1875,1,1,2,6556),-- Stone of Purity
(21283,1879,1,1,2,16389),-- Cokes
(21283,4040,1,1,2,1967),-- Mold Lubricant
(21283,5456,1,1,2,36),-- Recipe: Tallum Glaive(60%)
(21283,8730,1,1,200,1093),-- Life Stone: level 67
(21283,8740,1,1,200,273),-- Mid-Grade Life Stone: level 67
(21283,8750,1,1,200,27),-- High-Grade Life Stone: level 67
(21283,8760,1,1,200,5),-- Top-Grade Life Stone: level 67
(21284,729,1,1,-1,365),-- Scroll: Enchant Weapon (Grade A)
(21284,4040,1,1,-1,65771),-- Mold Lubricant
(21284,5536,1,1,-1,11188),-- Bloody Orchid Head
(21284,57,1302,2643,0,700000),-- Adena
(21284,11957,1,1,1,45),-- Common Item - Tallum Blade
(21284,11952,1,1,1,45),-- Common Item - Elemental Sword
(21284,11954,1,1,1,45),-- Common Item - Infernal Master
(21284,8331,1,1,1,552),-- Infernal Master Blade
(21284,5547,1,1,1,551),-- Elemental Sword Edge
(21284,5548,1,1,1,551),-- Tallum Blade Edge
(21284,1865,1,1,2,97138),-- Varnish
(21284,1870,1,1,2,97138),-- Coal
(21284,1875,1,1,2,6476),-- Stone of Purity
(21284,1879,1,1,2,16190),-- Cokes
(21284,4040,1,1,2,1943),-- Mold Lubricant
(21284,5456,1,1,2,36),-- Recipe: Tallum Glaive(60%)
(21284,8730,1,1,200,1079),-- Life Stone: level 67
(21284,8740,1,1,200,270),-- Mid-Grade Life Stone: level 67
(21284,8750,1,1,200,27),-- High-Grade Life Stone: level 67
(21284,8760,1,1,200,5),-- Top-Grade Life Stone: level 67
(21286,1889,1,1,-1,227705),-- Compound Braid
(21286,5549,1,1,-1,341557),-- Metallic Thread
(21286,6343,1,1,-1,73029),-- Sealed Phoenix Necklace Beads
(21286,57,1351,2748,0,700000),-- Adena
(21286,12221,1,1,1,550),-- Common Item - Sealed Dark Crystal Gloves
(21286,12224,1,1,1,550),-- Common Item - Sealed Dark Crystal Boots
(21286,12229,1,1,1,550),-- Common Item - Sealed Tallum Gloves
(21286,12231,1,1,1,559),-- Common Item - Sealed Tallum Boots
(21286,5496,1,1,1,2959),-- Sealed Dark Crystal Boots Lining
(21286,5497,1,1,1,2959),-- Sealed Tallum Boots Lining
(21286,5508,1,1,1,2959),-- Sealed Dark Crystal Gloves Design
(21286,5509,1,1,1,2959),-- Sealed Tallum Gloves Design
(21286,1868,1,1,2,201781),-- Thread
(21286,1873,1,1,2,40356),-- Silver Nugget
(21286,1889,1,1,2,6726),-- Compound Braid
(21286,4044,1,1,2,3363),-- Thons
(21286,5440,1,1,2,37),-- Recipe: Elysian(60%)
(21286,5549,1,1,2,10089),-- Metallic Thread
(21286,8730,1,1,200,1121),-- Life Stone: level 67
(21286,8740,1,1,200,280),-- Mid-Grade Life Stone: level 67
(21286,8750,1,1,200,28),-- High-Grade Life Stone: level 67
(21286,8760,1,1,200,5),-- Top-Grade Life Stone: level 67
(21287,1889,1,1,-1,226392),-- Compound Braid
(21287,5549,1,2,-1,339589),-- Metallic Thread
(21287,6343,1,1,-1,72608),-- Sealed Phoenix Necklace Beads
(21287,57,1343,2732,0,700000),-- Adena
(21287,12221,1,1,1,546),-- Common Item - Sealed Dark Crystal Gloves
(21287,12224,1,1,1,546),-- Common Item - Sealed Dark Crystal Boots
(21287,12229,1,1,1,546),-- Common Item - Sealed Tallum Gloves
(21287,12231,1,1,1,546),-- Common Item - Sealed Tallum Boots
(21287,5496,1,1,1,2940),-- Sealed Dark Crystal Boots Lining
(21287,5497,1,1,1,2940),-- Sealed Tallum Boots Lining
(21287,5508,1,1,1,2940),-- Sealed Dark Crystal Gloves Design
(21287,5509,1,1,1,2940),-- Sealed Tallum Gloves Design
(21287,1868,1,1,2,200619),-- Thread
(21287,1873,1,1,2,40124),-- Silver Nugget
(21287,1889,1,1,2,6687),-- Compound Braid
(21287,4044,1,1,2,3344),-- Thons
(21287,5440,1,1,2,37),-- Recipe: Elysian(60%)
(21287,5549,1,1,2,10031),-- Metallic Thread
(21287,8730,1,1,200,1115),-- Life Stone: level 67
(21287,8740,1,1,200,279),-- Mid-Grade Life Stone: level 67
(21287,8750,1,1,200,28),-- High-Grade Life Stone: level 67
(21287,8760,1,1,200,5),-- Top-Grade Life Stone: level 67
(21288,1889,1,1,-1,229181),-- Compound Braid
(21288,5549,1,1,-1,343772),-- Metallic Thread
(21288,6343,1,1,-1,73503),-- Sealed Phoenix Necklace Beads
(21288,57,1360,2766,0,700000),-- Adena
(21288,12221,1,1,1,553),-- Common Item - Sealed Dark Crystal Gloves
(21288,12224,1,1,1,553),-- Common Item - Sealed Dark Crystal Boots
(21288,12229,1,1,1,553),-- Common Item - Sealed Tallum Gloves
(21288,12231,1,1,1,553),-- Common Item - Sealed Tallum Boots
(21288,5496,1,1,1,2976),-- Sealed Dark Crystal Boots Lining
(21288,5497,1,1,1,2976),-- Sealed Tallum Boots Lining
(21288,5508,1,1,1,2976),-- Sealed Dark Crystal Gloves Design
(21288,5509,1,1,1,2976),-- Sealed Tallum Gloves Design
(21288,1868,1,1,2,203090),-- Thread
(21288,1873,1,1,2,40618),-- Silver Nugget
(21288,1889,1,1,2,6770),-- Compound Braid
(21288,4044,1,1,2,3385),-- Thons
(21288,5440,1,1,2,38),-- Recipe: Elysian(60%)
(21288,5549,1,1,2,10155),-- Metallic Thread
(21288,8730,1,1,200,1128),-- Life Stone: level 67
(21288,8740,1,1,200,282),-- Mid-Grade Life Stone: level 67
(21288,8750,1,1,200,28),-- High-Grade Life Stone: level 67
(21288,8760,1,1,200,5),-- Top-Grade Life Stone: level 67
(21290,730,1,1,-1,2349),-- Scroll: Enchant Armor (Grade A)
(21290,1875,1,1,-1,187895),-- Stone of Purity
(21290,4041,1,1,-1,24508),-- Mold Hardener
(21290,57,1391,2835,0,700000),-- Adena
(21290,11957,1,1,1,48),-- Common Item - Tallum Blade
(21290,11952,1,1,1,48),-- Common Item - Elemental Sword
(21290,11954,1,1,1,48),-- Common Item - Infernal Master
(21290,8331,1,1,1,592),-- Infernal Master Blade
(21290,5547,1,1,1,590),-- Elemental Sword Edge
(21290,5548,1,1,1,590),-- Tallum Blade Edge
(21290,5456,1,1,2,38),-- Recipe: Tallum Glaive(60%)
(21290,1867,1,1,2,138753),-- Animal Skin
(21290,1872,1,1,2,138753),-- Animal Bone
(21290,1875,1,1,2,6938),-- Stone of Purity
(21290,1881,1,1,2,13875),-- Coarse Bone Powder
(21290,4041,1,1,2,905),-- Mold Hardener
(21290,8730,1,1,200,1156),-- Life Stone: level 67
(21290,8740,1,1,200,299),-- Mid-Grade Life Stone: level 67
(21290,8750,1,1,200,29),-- High-Grade Life Stone: level 67
(21290,8760,1,1,200,6),-- Top-Grade Life Stone: level 67
(21291,730,1,1,-1,2335),-- Scroll: Enchant Armor (Grade A)
(21291,1875,1,1,-1,186812),-- Stone of Purity
(21291,4041,1,1,-1,24367),-- Mold Hardener
(21291,57,1383,2819,0,700000),-- Adena
(21291,11957,1,1,1,47),-- Common Item - Tallum Blade
(21291,11952,1,1,1,47),-- Common Item - Elemental Sword
(21291,11954,1,1,1,47),-- Common Item - Infernal Master
(21291,8331,1,1,1,588),-- Infernal Master Blade
(21291,5547,1,1,1,587),-- Elemental Sword Edge
(21291,5548,1,1,1,587),-- Tallum Blade Edge
(21291,5456,1,1,2,38),-- Recipe: Tallum Glaive(60%)
(21291,1867,1,1,2,137953),-- Animal Skin
(21291,1872,1,1,2,137953),-- Animal Bone
(21291,1875,1,1,2,6898),-- Stone of Purity
(21291,1881,1,1,2,13795),-- Coarse Bone Powder
(21291,4041,1,1,2,900),-- Mold Hardener
(21291,8730,1,1,200,1150),-- Life Stone: level 67
(21291,8740,1,1,200,287),-- Mid-Grade Life Stone: level 67
(21291,8750,1,1,200,29),-- High-Grade Life Stone: level 67
(21291,8760,1,1,200,6),-- Top-Grade Life Stone: level 67
(21292,730,1,1,-1,2364),-- Scroll: Enchant Armor (Grade A)
(21292,1875,1,1,-1,189113),-- Stone of Purity
(21292,4041,1,1,-1,24667),-- Mold Hardener
(21292,57,1400,2853,0,700000),-- Adena
(21292,11957,1,1,1,48),-- Common Item - Tallum Blade
(21292,11952,1,1,1,48),-- Common Item - Elemental Sword
(21292,11954,1,1,1,48),-- Common Item - Infernal Master
(21292,8331,1,1,1,596),-- Infernal Master Blade
(21292,5547,1,1,1,594),-- Elemental Sword Edge
(21292,5548,1,1,1,594),-- Tallum Blade Edge
(21292,1867,1,1,2,139652),-- Animal Skin
(21292,1872,1,1,2,139652),-- Animal Bone
(21292,1875,1,1,2,6982),-- Stone of Purity
(21292,1881,1,1,2,13965),-- Coarse Bone Powder
(21292,4041,1,1,2,911),-- Mold Hardener
(21292,5456,1,1,2,39),-- Recipe: Tallum Glaive(60%)
(21292,8730,1,1,200,1164),-- Life Stone: level 67
(21292,8740,1,1,200,291),-- Mid-Grade Life Stone: level 67
(21292,8750,1,1,200,29),-- High-Grade Life Stone: level 67
(21292,8760,1,1,200,6),-- Top-Grade Life Stone: level 67
(21294,5442,1,1,-1,2124),-- Recipe: Soul Bow(60%)
(21294,5486,1,1,-1,33941),-- Sealed Dark Crystal Robe Fabric
(21294,5489,1,1,-1,75707),-- Sealed Tallum Stockings Fabric
(21294,57,2269,4612,0,700000),-- Adena
(21294,11957,1,1,1,78),-- Common Item - Tallum Blade
(21294,11952,1,1,1,78),-- Common Item - Elemental Sword
(21294,11954,1,1,1,78),-- Common Item - Infernal Master
(21294,8331,1,1,1,963),-- Infernal Master Blade
(21294,5547,1,1,1,961),-- Elemental Sword Edge
(21294,5548,1,1,1,961),-- Tallum Blade Edge
(21294,1864,1,3,2,169431),-- Stem
(21294,1869,1,1,2,169431),-- Iron Ore
(21294,1880,1,1,2,16943),-- Steel
(21294,4043,1,1,2,5648),-- Asofe
(21294,5440,1,1,2,63),-- Recipe: Elysian(60%)
(21294,5550,1,1,2,2259),-- Durable Metal Plate
(21294,8730,1,1,200,1883),-- Life Stone: level 67
(21294,8740,1,1,200,471),-- Mid-Grade Life Stone: level 67
(21294,8750,1,1,200,47),-- High-Grade Life Stone: level 67
(21294,8760,1,1,200,10),-- Top-Grade Life Stone: level 67
(21295,5442,1,1,-1,2259),-- Recipe: Soul Bow(60%)
(21295,5547,1,1,-1,20750),-- Elemental Sword Edge
(21295,5548,1,1,-1,20750),-- Tallum Blade Edge
(21295,57,2414,4902,0,700000),-- Adena
(21295,11957,1,1,1,83),-- Common Item - Tallum Blade
(21295,11952,1,1,1,83),-- Common Item - Elemental Sword
(21295,11954,1,1,1,83),-- Common Item - Infernal Master
(21295,8331,1,1,1,1025),-- Infernal Master Blade
(21295,5547,1,1,1,1022),-- Elemental Sword Edge
(21295,5548,1,1,1,1022),-- Tallum Blade Edge
(21295,1864,1,3,2,300259),-- Stem
(21295,1869,1,3,2,100086),-- Iron Ore
(21295,1880,1,1,2,30026),-- Steel
(21295,4043,1,1,2,10009),-- Asofe
(21295,5550,1,1,2,4004),-- Durable Metal Plate
(21295,10304,1,1,1,1201),-- Transform Sealbook - Saber Tooth Tiger
(21296,5440,1,1,-1,3369),-- Recipe: Elysian(60%)
(21296,5482,1,1,-1,120055),-- Sealed Dark Crystalline Leggings Design
(21296,5485,1,1,-1,76488),-- Sealed Tallum Tunic Texture
(21296,57,3597,7319,0,700000),-- Adena
(21296,11955,1,1,1,370),-- Common Item - Carnage Bow
(21296,5535,1,1,1,4584),-- Carnage Bow Stave
(21296,1867,1,3,2,199022),-- Animal Skin
(21296,1872,4,12,2,74633),-- Animal Bone
(21296,1875,1,1,2,29853),-- Stone of Purity
(21296,1881,1,1,2,59707),-- Coarse Bone Powder
(21296,4041,1,1,2,3849),-- Mold Hardener
(21296,10304,1,1,1,1791),-- Transform Sealbook - Saber Tooth Tiger
(21297,5450,1,1,-1,2714),-- Recipe: Dragon Grinder(60%)
(21297,5456,1,1,-1,2714),-- Recipe: Tallum Glaive(60%)
(21297,6345,1,1,-1,280279),-- Sealed Phoenix Ring Gemstone
(21297,57,3615,7369,0,700000),-- Adena
(21297,11951,1,1,1,372),-- Common Item - Bloody Orchid
(21297,5536,1,1,1,4602),-- Bloody Orchid Head
(21297,1868,3,9,2,150287),-- Thread
(21297,1873,2,6,2,45086),-- Silver Nugget
(21297,1876,1,1,2,90172),-- Mithril Ore
(21297,1895,1,1,2,128818),-- Metallic Fiber
(21297,4042,1,1,2,7514),-- Enria
(21297,10304,1,1,1,1803),-- Transform Sealbook - Saber Tooth Tiger
(21298,730,1,1,-1,3929),-- Scroll: Enchant Armor (Grade A)
(21298,1895,1,3,-1,673616),-- Metallic Fiber
(21298,5478,1,1,-1,39651),-- Sealed Dark Crystal Leather Armor Pattern
(21298,57,2327,4743,0,700000),-- Adena
(21298,12221,1,1,1,948),-- Common Item - Sealed Dark Crystal Gloves
(21298,12224,1,1,1,948),-- Common Item - Sealed Dark Crystal Boots
(21298,12229,1,1,1,948),-- Common Item - Sealed Tallum Gloves
(21298,12231,1,1,1,948),-- Common Item - Sealed Tallum Boots
(21298,5496,1,1,1,5103),-- Sealed Dark Crystal Boots Lining
(21298,5497,1,1,1,5103),-- Sealed Tallum Boots Lining
(21298,5508,1,1,1,5103),-- Sealed Dark Crystal Gloves Design
(21298,5509,1,1,1,5103),-- Sealed Tallum Gloves Design
(21298,1344,10,30,2,181359),-- Mithril Arrow
(21298,1868,1,3,2,145087),-- Thread
(21298,1873,1,1,2,58035),-- Silver Nugget
(21298,1876,1,1,2,29017),-- Mithril Ore
(21298,1895,1,1,2,41453),-- Metallic Fiber
(21298,4042,1,1,2,2418),-- Enria
(21298,5380,1,1,2,824),-- Recipe: Sealed Boots of Nightmare(60%)
(21298,5167,1,1,2,64),-- Recipe: Blessed Spiritshot (S) Compressed Package (100%)
(21298,8730,1,1,200,1612),-- Life Stone: level 67
(21298,8740,1,1,200,403),-- Mid-Grade Life Stone: level 67
(21298,8750,1,1,200,41),-- High-Grade Life Stone: level 67
(21298,8760,1,1,200,8),-- Top-Grade Life Stone: level 67
(21299,729,1,1,-1,839),-- Scroll: Enchant Weapon (Grade A)
(21299,4041,1,1,-1,65661),-- Mold Hardener
(21299,5508,1,1,-1,177046),-- Sealed Dark Crystal Gloves Design
(21299,57,3724,7603,0,700000),-- Adena
(21299,11957,1,1,1,128),-- Common Item - Tallum Blade
(21299,11952,1,1,1,128),-- Common Item - Elemental Sword
(21299,11954,1,1,1,128),-- Common Item - Infernal Master
(21299,5547,1,1,1,1581),-- Elemental Sword Edge
(21299,5548,1,1,1,1581),-- Tallum Blade Edge
(21299,8331,1,1,1,1585),-- Infernal Master Blade
(21299,1344,40,120,2,726069),-- Mithril Arrow
(21299,1867,1,3,2,103262),-- Animal Skin
(21299,1872,1,3,2,154893),-- Animal Bone
(21299,1875,1,1,2,15489),-- Stone of Purity
(21299,1881,1,1,2,30978),-- Coarse Bone Powder
(21299,4041,1,1,2,2020),-- Mold Hardener
(21299,5382,1,1,2,1320),-- Recipe: Sealed Majestic Boots(60%)
(21299,5157,1,1,2,103),-- Recipe: Soulshot (S) Compressed Package (100%)
(21299,8730,1,1,200,2581),-- Life Stone: level 67
(21299,8740,1,1,200,645),-- Mid-Grade Life Stone: level 67
(21299,8750,1,1,200,65),-- High-Grade Life Stone: level 67
(21299,8760,1,1,200,13),-- Top-Grade Life Stone: level 67
(21300,1895,1,5,-1,707483),-- Metallic Fiber
(21300,5434,1,1,-1,2751),-- Recipe: Dragon Slayer(60%)
(21300,5509,1,1,-1,174175),-- Sealed Tallum Gloves Design
(21300,57,3663,7480,0,700000),-- Adena
(21300,11946,1,1,1,94),-- Common Item - Dasparion\'s Staff
(21300,11949,1,1,1,94),-- Common Item - Meteor Shower
(21300,8346,1,1,1,1156),-- Hammer Piece of Destroyer
(21300,11958,1,1,1,94),-- Common Item - Destroyer Hammer
(21300,8341,1,1,1,1155),-- Spiritual Eye Piece
(21300,11953,1,1,1,94),-- Common Item - Spiritual Eye
(21300,5532,1,1,1,1156),-- Meteor Shower Head
(21300,5543,1,1,1,1167),-- Dasparion\'s Staff Edge
(21300,1895,1,1,2,87075),-- Metallic Fiber
(21300,4040,1,1,2,6095),-- Mold Lubricant
(21300,4042,1,1,2,5079),-- Enria
(21300,4043,1,1,2,10159),-- Asofe
(21300,5162,1,1,2,135),-- Recipe: Spiritshot (S) Compressed Package (100%)
(21300,8730,1,1,200,3386),-- Life Stone: level 67
(21300,8740,1,1,200,847),-- Mid-Grade Life Stone: level 67
(21300,8750,1,1,200,85),-- High-Grade Life Stone: level 67
(21300,8760,1,1,200,17),-- Top-Grade Life Stone: level 67
(21301,5440,1,1,-1,3302),-- Recipe: Elysian(60%)
(21301,5520,1,1,-1,57484),-- Sealed Dark Crystal Breastplate Pattern
(21301,5521,1,2,-1,40563),-- Sealed Tallum Plate Armor Pattern
(21301,57,4396,8976,0,700000),-- Adena
(21301,11950,1,1,1,453),-- Common Item - Blood Tornado
(21301,5539,1,1,1,5550),-- Blood Tornado Edge
(21301,1344,30,90,2,114286),-- Mithril Arrow
(21301,1868,4,12,2,68571),-- Thread
(21301,1873,1,1,2,109714),-- Silver Nugget
(21301,1889,1,1,2,18286),-- Compound Braid
(21301,4044,1,1,2,9143),-- Thons
(21301,5404,1,1,2,1559),-- Recipe: Sealed Gloves of Nightmare(60%)
(21301,5167,1,1,2,122),-- Recipe: Blessed Spiritshot (S) Compressed Package (100%)
(21301,5549,1,1,2,27429),-- Metallic Thread
(21301,8730,1,1,200,3048),-- Life Stone: level 67
(21301,8740,1,1,200,762),-- Mid-Grade Life Stone: level 67
(21301,8750,1,1,200,76),-- High-Grade Life Stone: level 67
(21301,8760,1,1,200,15),-- Top-Grade Life Stone: level 67
(21302,729,1,1,-1,799),-- Scroll: Enchant Weapon (Grade A)
(21302,1875,1,1,-1,479548),-- Stone of Purity
(21302,4041,1,1,-1,62550),-- Mold Hardener
(21302,57,3552,7232,0,700000),-- Adena
(21302,11957,1,1,1,122),-- Common Item - Tallum Blade
(21302,11952,1,1,1,122),-- Common Item - Elemental Sword
(21302,11954,1,1,1,122),-- Common Item - Infernal Master
(21302,5547,1,1,1,1506),-- Elemental Sword Edge
(21302,5548,1,1,1,1506),-- Tallum Blade Edge
(21302,8331,1,1,1,1510),-- Infernal Master Blade
(21302,1867,1,3,2,107311),-- Animal Skin
(21302,1872,1,3,2,160967),-- Animal Bone
(21302,1875,1,1,2,16097),-- Stone of Purity
(21302,1881,1,1,2,32193),-- Coarse Bone Powder
(21302,4041,1,1,2,2100),-- Mold Hardener
(21302,5382,1,1,2,1372),-- Recipe: Sealed Majestic Boots(60%)
(21302,5162,1,1,2,107),-- Recipe: Spiritshot (S) Compressed Package (100%)
(21302,8731,1,1,200,2236),-- Life Stone: level 70
(21302,8741,1,1,200,559),-- Mid-Grade Life Stone: level 70
(21302,8750,1,1,200,56),-- High-Grade Life Stone: level 67
(21302,8760,1,1,200,12),-- Top-Grade Life Stone: level 67
(21303,5466,1,1,-1,2694),-- Recipe: Sword of Miracles(60%)
(21303,5547,1,1,-1,24748),-- Elemental Sword Edge
(21303,5548,1,1,-1,24748),-- Tallum Blade Edge
(21303,57,3592,7313,0,700000),-- Adena
(21303,11946,1,1,1,92),-- Common Item - Dasparion\'s Staff
(21303,11949,1,1,1,92),-- Common Item - Meteor Shower
(21303,5532,1,1,1,1132),-- Meteor Shower Head
(21303,5543,1,1,1,1143),-- Dasparion\'s Staff Edge
(21303,11958,1,1,1,92),-- Common Item - Destroyer Hammer
(21303,11953,1,1,1,92),-- Common Item - Spiritual Eye
(21303,8341,1,1,1,1131),-- Spiritual Eye Piece
(21303,8346,1,1,1,1132),-- Hammer Piece of Destroyer 
(21303,1344,40,120,2,69943),-- Mithril Arrow
(21303,1867,1,3,2,99474),-- Animal Skin
(21303,1872,1,3,2,149211),-- Animal Bone
(21303,1875,1,1,2,14921),-- Stone of Purity
(21303,1881,1,1,2,29842),-- Coarse Bone Powder
(21303,4041,1,1,2,1946),-- Mold Hardener
(21303,5406,1,1,2,1272),-- Recipe: Sealed Majestic Gloves(60%)
(21303,5167,1,1,2,99),-- Recipe: Blessed Spiritshot (S) Compressed Package (100%)
(21303,8731,1,1,200,2072),-- Life Stone: level 70
(21303,8741,1,1,200,518),-- Mid-Grade Life Stone: level 70
(21303,8751,1,1,200,52),-- High-Grade Life Stone: level 70
(21303,8761,1,1,200,10),-- Top-Grade Life Stone: level 70
(21304,5440,1,1,-1,3968),-- Recipe: Elysian(60%)
(21304,5542,1,1,-1,36128),-- Halberd Edge
(21304,5543,1,1,-1,36469),-- Dasparion\'s Staff Edge
(21304,57,5287,10776,0,700000),-- Adena
(21304,11946,1,1,1,136),-- Common Item - Dasparion\'s Staff
(21304,11949,1,1,1,136),-- Common Item - Meteor Shower
(21304,8346,1,1,1,1667),-- Hammer Piece of Destroyer
(21304,11958,1,1,1,136),-- Common Item - Destroyer Hammer
(21304,8341,1,1,1,1165),-- Spiritual Eye Piece
(21304,11953,1,1,1,136),-- Common Item - Spiritual Eye
(21304,5532,1,1,1,1667),-- Meteor Shower Head
(21304,5543,1,1,1,1683),-- Dasparion\'s Staff Edge
(21304,1344,20,60,2,247233),-- Mithril Arrow
(21304,1894,1,1,2,13880),-- Crafted Leather
(21304,4039,1,1,2,13186),-- Mold Glue
(21304,4041,1,1,2,3440),-- Mold Hardener
(21304,4044,1,1,2,13186),-- Thons
(21304,5277,1,1,2,176),-- Recipe: Greater Spiritshot (S) Compressed Package(100%)
(21304,8731,1,1,200,3663),-- Life Stone: level 70
(21304,8741,1,1,200,916),-- Mid-Grade Life Stone: level 70
(21304,8751,1,1,200,92),-- High-Grade Life Stone: level 70
(21304,8761,1,1,200,18),-- Top-Grade Life Stone: level 70
(21305,730,1,1,-1,6574),-- Scroll: Enchant Armor (Grade A)
(21305,1877,1,1,-1,315566),-- Adamantite Nugget
(21305,4040,1,1,-1,157783),-- Mold Lubricant
(21305,57,3893,7935,0,700000),-- Adena
(21305,11946,1,1,1,100),-- Common Item - Dasparion\'s Staff
(21305,11949,1,1,1,100),-- Common Item - Meteor Shower
(21305,8346,1,1,1,1228),-- Hammer Piece of Destroyer
(21305,11958,1,1,1,100),-- Common Item - Destroyer Hammer
(21305,8341,1,1,1,1226),-- Spiritual Eye Piece
(21305,11953,1,1,1,100),-- Common Item - Spiritual Eye
(21305,5532,1,1,1,1228),-- Meteor Shower Head
(21305,5543,1,1,1,1239),-- Dasparion\'s Staff Edge
(21305,1866,1,1,2,194194),-- Suede
(21305,1871,1,3,2,145646),-- Charcoal
(21305,1877,1,1,2,11652),-- Adamantite Nugget
(21305,4040,1,1,2,5826),-- Mold Lubricant
(21305,4041,1,1,2,2533),-- Mold Hardener
(21305,5282,1,1,2,129),-- Recipe: Greater Blessed Spiritshot (S) Compressed Package(100%)
(21305,8731,1,1,200,2697),-- Life Stone: level 70
(21305,8741,1,1,200,674),-- Mid-Grade Life Stone: level 70
(21305,8751,1,1,200,68),-- High-Grade Life Stone: level 70
(21305,8761,1,1,200,13),-- Top-Grade Life Stone: level 70
(21306,5442,1,1,-1,5287),-- Recipe: Soul Bow(60%)
(21306,5547,1,1,-1,48569),-- Elemental Sword Edge
(21306,5548,1,1,-1,48569),-- Tallum Blade Edge
(21306,57,7045,14360,0,700000),-- Adena
(21306,11950,1,1,1,726),-- Common Item - Blood Tornado
(21306,5539,1,1,1,8887),-- Blood Tornado Edge
(21306,1344,100,300,2,59898),-- Mithril Arrow
(21306,1865,1,3,2,159729),-- Varnish
(21306,1870,2,6,2,119797),-- Coal
(21306,1875,1,1,2,31946),-- Stone of Purity
(21306,1879,1,1,2,79865),-- Cokes
(21306,4040,1,1,2,9584),-- Mold Lubricant
(21306,6901,1,1,2,479),-- Recipe: Shining Arrow (100%)
(21306,8731,1,1,200,4437),-- Life Stone: level 70
(21306,8741,1,1,200,1109),-- Mid-Grade Life Stone: level 70
(21306,8751,1,1,200,111),-- High-Grade Life Stone: level 70
(21306,8761,1,1,200,22),-- Top-Grade Life Stone: level 70
(21307,1808,1,1,-1,4458),-- Recipe: Soulshot: S Grade
(21307,5480,1,1,-1,45013),-- Sealed Leather Armor of Nightmare Fabric
(21307,5481,1,1,-1,45013),-- Sealed Majestic Leather Armor Fabric
(21307,57,4948,10097,0,700000),-- Adena
(21307,11957,1,1,1,170),-- Common Item - Tallum Blade
(21307,11952,1,1,1,170),-- Common Item - Elemental Sword
(21307,11954,1,1,1,170),-- Common Item - Infernal Master
(21307,8331,1,1,1,2160),-- Infernal Master Blade
(21307,5547,1,1,1,2100),-- Elemental Sword Edge
(21307,5548,1,1,1,2100),-- Tallum Blade Edge
(21307,1868,3,9,2,123464),-- Thread
(21307,1873,1,1,2,148157),-- Silver Nugget
(21307,1889,1,1,2,24693),-- Compound Braid
(21307,4044,1,1,2,12346),-- Thons
(21307,5277,1,1,2,165),-- Recipe: Greater Spiritshot (S) Compressed Package(100%)
(21307,5549,1,1,2,37039),-- Metallic Thread
(21307,8731,1,1,200,3430),-- Life Stone: level 70
(21307,8741,1,1,200,857),-- Mid-Grade Life Stone: level 70
(21307,8751,1,1,200,86),-- High-Grade Life Stone: level 70
(21307,8761,1,1,200,16),-- Top-Grade Life Stone: level 70
(21308,1875,1,1,-1,888584),-- Stone of Purity
(21308,3036,1,1,-1,5924),-- Recipe: Spiritshot S
(21308,5487,1,1,-1,60021),-- Sealed Robe of Nightmare Fabric
(21308,57,6575,13415,0,700000),-- Adena
(21308,11946,1,1,1,169),-- Common Item - Dasparion\'s Staff
(21308,11949,1,1,1,169),-- Common Item - Meteor Shower
(21308,8346,1,1,1,2074),-- Hammer Piece of Destroyer
(21308,11958,1,1,1,169),-- Common Item - Destroyer Hammer
(21308,8341,1,1,1,2072),-- Spiritual Eye Piece
(21308,11953,1,1,1,169),-- Common Item - Spiritual Eye
(21308,5532,1,1,1,2074),-- Meteor Shower Head
(21308,5543,1,1,1,2094),-- Dasparion\'s Staff Edge
(21308,1344,40,120,2,139813),-- Mithril Arrow
(21308,1867,1,3,2,198844),-- Animal Skin
(21308,1872,5,15,2,59653),-- Animal Bone
(21308,1875,1,1,2,29826),-- Stone of Purity
(21308,1881,1,1,2,59653),-- Coarse Bone Powder
(21308,4041,1,1,2,3990),-- Mold Hardener
(21308,5282,1,1,2,199),-- Recipe: Greater Blessed Spiritshot (S) Compressed Package(100%)
(21308,8731,1,1,200,4143),-- Life Stone: level 70
(21308,8741,1,1,200,1036),-- Mid-Grade Life Stone: level 70
(21308,8751,1,1,200,103),-- High-Grade Life Stone: level 70
(21308,8761,1,1,200,21),-- Top-Grade Life Stone: level 70
(21309,1875,1,1,-1,926118),-- Stone of Purity
(21309,3036,1,1,-1,6174),-- Recipe: Spiritshot S
(21309,5487,1,1,-1,62556),-- Sealed Robe of Nightmare Fabric
(21309,57,6853,13982,0,700000),-- Adena
(21309,11946,1,1,1,177),-- Common Item - Dasparion\'s Staff
(21309,11949,1,1,1,177),-- Common Item - Meteor Shower
(21309,8346,1,1,1,2162),-- Hammer Piece of Destroyer
(21309,11958,1,1,1,177),-- Common Item - Destroyer Hammer
(21309,8341,1,1,1,2159),-- Spiritual Eye Piece
(21309,11953,1,1,1,177),-- Common Item - Spiritual Eye
(21309,5532,1,1,1,2162),-- Meteor Shower Head
(21309,5543,1,1,1,2182),-- Dasparion\'s Staff Edge
(21309,1344,40,120,2,145719),-- Mithril Arrow
(21309,1867,9,27,2,34541),-- Animal Skin
(21309,1872,5,15,2,62173),-- Animal Bone
(21309,1875,1,1,2,31087),-- Stone of Purity
(21309,1881,1,1,2,62173),-- Coarse Bone Powder
(21309,4041,1,1,2,4055),-- Mold Hardener
(21309,8731,1,1,200,4317),-- Life Stone: level 70
(21309,8741,1,1,200,1079),-- Mid-Grade Life Stone: level 70
(21309,8751,1,1,200,108),-- High-Grade Life Stone: level 70
(21309,8761,1,1,200,21),-- Top-Grade Life Stone: level 70
(21309,5282,1,1,2,207); -- Recipe: Greater Blessed Spiritshot (S) Compressed Package(100%)

INSERT INTO `droplist` VALUES 
(21310,5162,1,1,-1,5081),-- Recipe: Spiritshot (S) Compressed Package (100%)
(21310,5546,1,1,-1,34452),-- Sword of Miracles Edge
(21310,5549,1,3,-1,571636),-- Metallic Thread
(21310,57,5625,11517,0,700000),-- Adena
(21310,11957,1,1,1,194),-- Common Item - Tallum Blade
(21310,11952,1,1,1,194),-- Common Item - Elemental Sword
(21310,11954,1,1,1,194),-- Common Item - Infernal Master
(21310,8331,1,1,1,2401),-- Infernal Master Blade
(21310,5547,1,1,1,2394),-- Elemental Sword Edge
(21310,5548,1,1,1,2394),-- Tallum Blade Edge
(21310,1868,3,9,2,156345),-- Thread
(21310,1873,1,1,2,187614),-- Silver Nugget
(21310,1889,1,1,2,31269),-- Compound Braid
(21310,4044,1,1,2,15635),-- Thons
(21310,5157,1,1,2,209),-- Recipe: Soulshot (S) Compressed Package (100%)
(21310,5549,1,1,2,46903),-- Metallic Thread
(21310,8732,1,1,200,3909),-- Life Stone: level 76
(21310,8742,1,1,200,977),-- Mid-Grade Life Stone: level 76
(21310,8752,1,1,200,97),-- High-Grade Life Stone: level 76
(21311,5162,1,1,-1,4685),-- Recipe: Spiritshot (S) Compressed Package (100%)
(21311,5546,1,1,-1,31765),-- Sword of Miracles Edge
(21311,5549,1,3,-1,527054),-- Metallic Thread
(21311,57,5186,10619,0,700000),-- Adena
(21311,11957,1,1,1,179),-- Common Item - Tallum Blade
(21311,11952,1,1,1,179),-- Common Item - Elemental Sword
(21311,11954,1,1,1,179),-- Common Item - Infernal Master
(21311,8331,1,1,1,2213),-- Infernal Master Blade
(21311,5547,1,1,1,2207),-- Elemental Sword Edge
(21311,5548,1,1,1,2207),-- Tallum Blade Edge
(21311,1868,3,9,2,144152),-- Thread
(21311,1873,1,1,2,172982),-- Silver Nugget
(21311,1889,1,1,2,28830),-- Compound Braid
(21311,4044,1,1,2,14415),-- Thons
(21311,5157,1,1,2,192),-- Recipe: Soulshot (S) Compressed Package (100%)
(21311,5549,1,1,2,43245),-- Metallic Thread
(21311,8732,1,1,200,3604),-- Life Stone: level 76
(21311,8742,1,1,200,901),-- Mid-Grade Life Stone: level 76
(21311,8752,1,1,200,90),-- High-Grade Life Stone: level 76
(21312,729,1,1,-1,1212),-- Scroll: Enchant Weapon (Grade A)
(21312,5448,1,1,-1,4041),-- Recipe: Soul Separator(60%)
(21312,6341,1,1,-1,301763),-- Sealed Phoenix Earring Gemstone
(21312,57,5384,10974,0,700000),-- Adena
(21312,11955,1,1,1,554),-- Common Item - Carnage Bow
(21312,5535,1,1,1,6873),-- Carnage Bow Stave
(21312,1808,1,1,2,179),-- Recipe: Soulshot: S Grade
(21312,1866,1,3,2,89520),-- Suede
(21312,1871,1,3,2,201419),-- Charcoal
(21312,1885,1,1,2,33570),-- High Grade Suede
(21312,4041,1,1,2,3503),-- Mold Hardener
(21312,5220,1,1,2,16113),-- Metal Hardener
(21312,8731,1,1,200,3730),-- Life Stone: level 70
(21312,8741,1,1,200,932),-- Mid-Grade Life Stone: level 70
(21312,8751,1,1,200,93),-- High-Grade Life Stone: level 70
(21312,8761,1,1,200,19),-- Top-Grade Life Stone: level 70
(21313,730,1,1,-1,8658),-- Scroll: Enchant Armor (Grade A)
(21313,1895,1,7,-1,742151),-- Metallic Fiber
(21313,4042,1,1,-1,173169),-- Enria
(21313,57,5124,10462,0,700000),-- Adena
(21313,11955,1,1,1,528),-- Common Item - Carnage Bow
(21313,5535,1,1,1,6545),-- Carnage Bow Stave
(21313,1868,3,9,2,116253),-- Thread
(21313,1873,1,1,2,139504),-- Silver Nugget
(21313,1876,1,1,2,69752),-- Mithril Ore
(21313,1895,1,1,2,99646),-- Metallic Fiber
(21313,4042,1,1,2,5813),-- Enria
(21313,5380,1,1,2,1982),-- Recipe: Sealed Boots of Nightmare(60%)
(21313,5272,1,1,2,155),-- Recipe: Greater Soulshot (S) Compressed Package(100%)
(21313,8730,1,1,200,3875),-- Life Stone: level 67
(21313,8740,1,1,200,969),-- Mid-Grade Life Stone: level 67
(21313,8750,1,1,200,97),-- High-Grade Life Stone: level 67
(21313,8760,1,1,200,19),-- Top-Grade Life Stone: level 67
(21314,730,1,1,-1,4842),-- Scroll: Enchant Armor (Grade A)
(21314,6335,1,1,-1,22347),-- Recipe: Sealed Majestic Necklace(70%)
(21314,6341,1,1,-1,160703),-- Sealed Phoenix Earring Gemstone
(21314,57,2869,5842,0,700000),-- Adena
(21314,11950,1,1,1,295),-- Common Item - Blood Tornado
(21314,5539,1,1,1,3618),-- Blood Tornado Edge
(21314,1895,1,1,2,68105),-- Metallic Fiber
(21314,4040,1,1,2,4767),-- Mold Lubricant
(21314,4042,1,1,2,3973),-- Enria
(21314,4043,1,1,2,7946),-- Asofe
(21314,5272,1,1,2,106),-- Recipe: Greater Soulshot (S) Compressed Package(100%)
(21314,8731,1,1,200,2207),-- Life Stone: level 70
(21314,8741,1,1,200,552),-- Mid-Grade Life Stone: level 70
(21314,8751,1,1,200,55),-- High-Grade Life Stone: level 70
(21314,8761,1,1,200,11),-- Top-Grade Life Stone: level 70
(21315,1889,1,1,-1,403664),-- Compound Braid
(21315,5549,1,1,-1,605496),-- Metallic Thread
(21315,6343,1,1,-1,129462),-- Sealed Phoenix Necklace Beads
(21315,57,2990,6088,0,700000),-- Adena
(21315,11955,1,1,1,308),-- Common Item - Carnage Bow
(21315,5535,1,1,1,3814),-- Carnage Bow Stave
(21315,1344,30,90,2,84684),-- Mithril Arrow
(21315,1868,1,3,2,203243),-- Thread
(21315,1873,1,1,2,81297),-- Silver Nugget
(21315,1889,1,1,2,13550),-- Compound Braid
(21315,4044,1,1,2,6775),-- Thons
(21315,5549,1,1,2,20324),-- Metallic Thread
(21315,5277,1,1,2,90),-- Recipe: Greater Spiritshot (S) Compressed Package(100%)
(21315,8731,1,1,200,1882),-- Life Stone: level 70
(21315,8741,1,1,200,471),-- Mid-Grade Life Stone: level 70
(21315,8751,1,1,200,47),-- High-Grade Life Stone: level 70
(21315,8761,1,1,200,9),-- Top-Grade Life Stone: level 70
(21316,4043,1,1,-1,211044),-- Asofe
(21316,5550,1,1,-1,84418),-- Durable Metal Plate
(21316,6343,1,1,-1,135372),-- Sealed Phoenix Necklace Beads
(21316,57,3124,6369,0,700000),-- Adena
(21316,11951,1,1,1,322),-- Common Item - Bloody Orchid
(21316,5536,1,1,1,3977),-- Bloody Orchid Head
(21316,1344,30,90,2,88550),-- Mithril Arrow
(21316,1864,1,3,2,212520),-- Stem
(21316,1869,2,6,2,53130),-- Iron Ore
(21316,1880,1,1,2,21252),-- Steel
(21316,3036,1,1,2,94),-- Recipe: Spiritshot S
(21316,4043,1,1,2,7084),-- Asofe
(21316,5550,1,1,2,2833),-- Durable Metal Plate
(21316,8731,1,1,200,1968),-- Life Stone: level 70
(21316,8741,1,1,200,492),-- Mid-Grade Life Stone: level 70
(21316,8751,1,1,200,49),-- High-Grade Life Stone: level 70
(21316,8761,1,1,200,10),-- Top-Grade Life Stone: level 70
(21317,5450,1,1,-1,2216),-- Recipe: Dragon Grinder(60%)
(21317,5456,1,1,-1,2216),-- Recipe: Tallum Glaive(60%)
(21317,6345,1,1,-1,228933),-- Sealed Phoenix Ring Gemstone
(21317,57,2953,6019,0,700000),-- Adena
(21317,11950,1,1,1,304),-- Common Item - Blood Tornado
(21317,5539,1,1,1,3726),-- Blood Tornado Edge
(21317,1867,1,3,2,147306),-- Animal Skin
(21317,1872,1,3,2,98204),-- Animal Bone
(21317,1882,1,1,2,49102),-- Leather
(21317,1894,1,1,2,7753),-- Crafted Leather
(21317,3957,1,1,2,98),-- Recipe: Blessed Spiritshot S
(21317,4042,1,1,2,3683),-- Enria
(21317,8731,1,1,200,2046),-- Life Stone: level 70
(21317,8741,1,1,200,512),-- Mid-Grade Life Stone: level 70
(21317,8751,1,1,200,51),-- High-Grade Life Stone: level 70
(21317,8761,1,1,200,10),-- Top-Grade Life Stone: level 70
(21318,730,1,1,-1,5213),-- Scroll: Enchant Armor (Grade A)
(21318,5478,1,1,-1,52600),-- Sealed Dark Crystal Leather Armor Pattern
(21318,5549,1,1,-1,625522),-- Metallic Thread
(21318,57,3087,6292,0,700000),-- Adena
(21318,12221,1,1,1,1258),-- Common Item - Sealed Dark Crystal Gloves
(21318,12224,1,1,1,1258),-- Common Item - Sealed Dark Crystal Boots
(21318,12229,1,1,1,1258),-- Common Item - Sealed Tallum Gloves
(21318,12231,1,1,1,1258),-- Common Item - Sealed Tallum Boots
(21318,5496,1,1,1,6769),-- Sealed Dark Crystal Boots Lining
(21318,5497,1,1,1,6769),-- Sealed Tallum Boots Lining
(21318,5508,1,1,1,6769),-- Sealed Dark Crystal Gloves Design
(21318,5509,1,1,1,6769),-- Sealed Tallum Gloves Design
(21318,1344,30,90,2,87485),-- Mithril Arrow
(21318,1868,1,3,2,209966),-- Thread
(21318,1873,1,1,2,83986),-- Silver Nugget
(21318,1889,1,1,2,13998),-- Compound Braid
(21318,4044,1,1,2,6999),-- Thons
(21318,5157,1,1,2,93),-- Recipe: Soulshot (S) Compressed Package (100%)
(21318,5549,1,1,2,20996),-- Metallic Thread
(21318,8731,1,1,200,1944),-- Life Stone: level 70
(21318,8741,1,1,200,486),-- Mid-Grade Life Stone: level 70
(21318,8751,1,1,200,49),-- High-Grade Life Stone: level 70
(21318,8761,1,1,200,10),-- Top-Grade Life Stone: level 70
(21319,5157,1,1,-1,3137),-- Recipe: Soulshot (S) Compressed Package (100%)
(21319,5495,1,1,-1,107187),-- Sealed Shield of Nightmare Fragment
(21319,5502,1,1,-1,119216),-- Sealed Boots of Nightmare Lining
(21319,57,3482,7105,0,700000),-- Adena
(21319,11955,1,1,1,359),-- Common Item - Carnage Bow
(21319,5535,1,1,1,4446),-- Carnage Bow Stave
(21319,1344,20,60,2,271497),-- Mithril Arrow
(21319,7649,1,1,2,7489), -- Spellbook - Fire Vortex
(21319,7650,1,1,2,7489), -- Spellbook - Ice Vortex
(21319,7651,1,1,2,7489), -- Spellbook - Wind Vortex
(21319,7652,1,1,2,7489), -- Spellbook - Light Vortex
(21319,7653,1,1,2,7489), -- Spellbook - Dark Vortex
(21320,1894,1,1,-1,225378),-- Crafted Leather
(21320,4042,1,1,-1,108483),-- Enria
(21320,5503,1,1,-1,107055),-- Sealed Majestic Boots Lining
(21320,57,3168,6465,0,700000),-- Adena
(21320,11951,1,1,1,326),-- Common Item - Bloody Orchid
(21320,5536,1,1,1,4035),-- Bloody Orchid Head
(21320,1867,1,3,2,158111),-- Animal Skin
(21320,1872,1,3,2,105408),-- Animal Bone
(21320,1882,1,1,2,52704),-- Leather
(21320,1894,1,1,2,8322),-- Crafted Leather
(21320,3036,1,1,2,105),-- Recipe: Spiritshot S
(21320,4042,1,1,2,3953),-- Enria
(21320,8731,1,1,200,2196),-- Life Stone: level 70
(21320,8741,1,1,200,549),-- Mid-Grade Life Stone: level 70
(21320,8751,1,1,200,55),-- High-Grade Life Stone: level 70
(21320,8761,1,1,200,11),-- Top-Grade Life Stone: level 70
(21321,1876,1,3,-1,559345),-- Mithril Ore
(21321,1895,1,3,-1,799064),-- Metallic Fiber
(21321,6346,1,1,-1,182108),-- Sealed Majestic Ring Gemstone
(21321,57,2752,5635,0,700000),-- Adena
(21321,11950,1,1,1,284),-- Common Item - Blood Tornado
(21321,5539,1,1,1,3483),-- Blood Tornado Edge
(21321,1868,1,3,2,229475),-- Thread
(21321,1873,1,1,2,91790),-- Silver Nugget
(21321,1876,1,1,2,45895),-- Mithril Ore
(21321,1895,1,1,2,65564),-- Metallic Fiber
(21321,4042,1,1,2,3824),-- Enria
(21321,5167,1,1,2,102),-- Recipe: Blessed Spiritshot (S) Compressed Package (100%)
(21321,8732,1,1,200,1912),-- Life Stone: level 76
(21321,8742,1,1,200,478),-- Mid-Grade Life Stone: level 76
(21321,8752,1,1,200,48),-- High-Grade Life Stone: level 76
(21322,5272,1,1,-1,2486),-- Recipe: Greater Soulshot (S) Compressed Package(100%)
(21322,5277,1,1,-1,2486),-- Recipe: Greater Spiritshot (S) Compressed Package(100%)
(21322,5480,1,1,-1,25099),-- Sealed Leather Armor of Nightmare Fabric
(21322,57,2752,5635,0,700000),-- Adena
(21322,11955,1,1,1,284),-- Common Item - Carnage Bow
(21322,5535,1,1,1,3524),-- Carnage Bow Stave
(21322,1344,20,60,2,129080),-- Mithril Arrow
(21322,1866,1,1,2,137685),-- Suede
(21322,1871,1,1,2,206527),-- Charcoal
(21322,1877,1,1,2,8261),-- Adamantite Nugget
(21322,4040,1,1,2,4131),-- Mold Lubricant
(21322,4041,1,1,2,1796),-- Mold Hardener
(21322,5272,1,1,2,92),-- Recipe: Greater Soulshot (S) Compressed Package(100%)
(21322,8732,1,1,200,1721),-- Life Stone: level 76
(21322,8742,1,1,200,431),-- Mid-Grade Life Stone: level 76
(21322,8752,1,1,200,43),-- High-Grade Life Stone: level 76
(21323,1894,1,1,-1,193902),-- Crafted Leather
(21323,4042,1,1,-1,92103),-- Enria
(21323,5481,1,1,-1,24797),-- Sealed Majestic Leather Armor Fabric
(21323,57,2719,5567,0,700000),-- Adena
(21323,11951,1,1,1,281),-- Common Item - Bloody Orchid
(21323,5536,1,1,1,3471),-- Bloody Orchid Head
(21323,1867,1,3,2,151144),-- Animal Skin
(21323,1872,1,3,2,100763),-- Animal Bone
(21323,1882,1,1,2,50381),-- Leather
(21323,1894,1,1,2,7955),-- Crafted Leather
(21323,4042,1,1,2,3779),-- Enria
(21323,5277,1,1,2,101),-- Recipe: Greater Spiritshot (S) Compressed Package(100%)
(21323,8732,1,1,200,1889),-- Life Stone: level 76
(21323,8742,1,1,200,472),-- Mid-Grade Life Stone: level 76
(21323,8752,1,1,200,47),-- High-Grade Life Stone: level 76
(21324,1808,1,1,-1,2354),-- Recipe: Soulshot: S Grade
(21324,4042,1,1,-1,88264),-- Enria
(21324,5502,1,1,-1,89441),-- Sealed Boots of Nightmare Lining
(21324,57,2610,5333,0,700000),-- Adena
(21324,11957,1,1,1,90),-- Common Item - Tallum Blade
(21324,11952,1,1,1,90),-- Common Item - Elemental Sword
(21324,11954,1,1,1,90),-- Common Item - Infernal Master
(21324,8331,1,1,1,1112),-- Infernal Master Blade
(21324,5547,1,1,1,1109),-- Elemental Sword Edge
(21324,5548,1,1,1,1109),-- Tallum Blade Edge
(21324,1344,30,90,2,81474),-- Mithril Arrow
(21324,1808,1,1,2,87),-- Recipe: Soulshot: S Grade
(21324,1868,1,3,2,195538),-- Thread
(21324,1873,1,1,2,78215),-- Silver Nugget
(21324,1876,1,1,2,39108),-- Mithril Ore
(21324,1895,1,1,2,55868),-- Metallic Fiber
(21324,4042,1,1,2,3259),-- Enria
(21324,8732,1,1,200,1629),-- Life Stone: level 76
(21324,8742,1,1,200,407),-- Mid-Grade Life Stone: level 76
(21324,8752,1,1,200,41),-- High-Grade Life Stone: level 76
(21325,3036,1,1,-1,2276),-- Recipe: Spiritshot S
(21325,5503,1,1,-1,86488),-- Sealed Majestic Boots Lining
(21325,5514,1,1,-1,86488),-- Sealed Gloves of Nightmare Design
(21325,57,2524,5157,0,700000),-- Adena
(21325,11946,1,1,1,65),-- Common Item - Dasparion\'s Staff
(21325,11949,1,1,1,65),-- Common Item - Meteor Shower
(21325,8346,1,1,1,797),-- Hammer Piece of Destroyer
(21325,11958,1,1,1,65),-- Common Item - Destroyer Hammer
(21325,8341,1,1,1,796),-- Spiritual Eye Piece
(21325,11953,1,1,1,65),-- Common Item - Spiritual Eye
(21325,5532,1,1,1,797),-- Meteor Shower Head
(21325,5543,1,1,1,805),-- Dasparion\'s Staff Edge
(21325,1894,1,1,2,8293),-- Crafted Leather
(21325,3036,1,1,2,105),-- Recipe: Spiritshot S
(21325,4039,1,1,2,7878),-- Mold Glue
(21325,4041,1,1,2,2055),-- Mold Hardener
(21325,4044,1,1,2,7878),-- Thons
(21325,8732,1,1,200,1970),-- Life Stone: level 76
(21325,8742,1,1,200,492),-- Mid-Grade Life Stone: level 76
(21325,8752,1,1,200,49),-- High-Grade Life Stone: level 76
(21326,1877,1,1,-1,204838),-- Adamantite Nugget
(21326,4041,1,1,-1,44530),-- Mold Hardener
(21326,5515,1,1,-1,86488),-- Sealed Majestic Gloves Design
(21326,57,2524,5157,0,700000),-- Adena
(21326,11950,1,1,1,260),-- Common Item - Blood Tornado
(21326,5539,1,1,1,3188),-- Blood Tornado Edge
(21326,1344,20,60,2,118176),-- Mithril Arrow
(21326,1866,1,1,2,126054),-- Suede
(21326,1871,1,1,2,189081),-- Charcoal
(21326,1877,1,1,2,7563),-- Adamantite Nugget
(21326,3957,1,1,2,84),-- Recipe: Blessed Spiritshot S
(21326,4040,1,1,2,3782),-- Mold Lubricant
(21326,4041,1,1,2,1644),-- Mold Hardener
(21326,8732,1,1,200,1576),-- Life Stone: level 76
(21326,8742,1,1,200,394),-- Mid-Grade Life Stone: level 76
(21326,8752,1,1,200,39),-- High-Grade Life Stone: level 76
(21327,4039,1,1,-1,194325),-- Mold Glue
(21327,5272,1,1,-1,2591),-- Recipe: Greater Soulshot (S) Compressed Package(100%)
(21327,5533,1,1,-1,15991),-- Elysian Head
(21327,57,2875,5868,0,700000),-- Adena
(21327,11957,1,1,1,99),-- Common Item - Tallum Blade
(21327,11952,1,1,1,99),-- Common Item - Elemental Sword
(21327,11954,1,1,1,99),-- Common Item - Infernal Master
(21327,8331,1,1,1,1224),-- Infernal Master Blade
(21327,5547,1,1,1,1221),-- Elemental Sword Edge
(21327,5548,1,1,1,1221),-- Tallum Blade Edge
(21327,1894,1,1,2,9441),-- Crafted Leather
(21327,4039,1,1,2,8969),-- Mold Glue
(21327,4041,1,1,2,2340),-- Mold Hardener
(21327,4044,1,1,2,8969),-- Thons
(21327,5277,1,1,2,120),-- Recipe: Greater Spiritshot (S) Compressed Package(100%)
(21327,8732,1,1,200,2242),-- Life Stone: level 76
(21327,8742,1,1,200,561),-- Mid-Grade Life Stone: level 76
(21327,8752,1,1,200,56),-- High-Grade Life Stone: level 76
(21328,5277,1,1,-1,2484),-- Recipe: Greater Spiritshot (S) Compressed Package(100%)
(21328,5534,1,1,-1,15343),-- Soul Bow Stave
(21328,5537,1,1,-1,15333),-- Soul Separator Head
(21328,57,2756,5626,0,700000),-- Adena
(21328,11946,1,1,1,71),-- Common Item - Dasparion\'s Staff
(21328,11949,1,1,1,71),-- Common Item - Meteor Shower
(21328,8346,1,1,1,870),-- Hammer Piece of Destroyer
(21328,11958,1,1,1,71),-- Common Item - Destroyer Hammer
(21328,8341,1,1,1,869),-- Spiritual Eye Piece
(21328,11953,1,1,1,71),-- Common Item - Spiritual Eye
(21328,5532,1,1,1,870),-- Meteor Shower Head
(21328,5543,1,1,1,878),-- Dasparion\'s Staff Edge
(21328,1344,30,90,2,78166),-- Mithril Arrow
(21328,1868,1,3,2,187597),-- Thread
(21328,1873,1,1,2,75039),-- Silver Nugget
(21328,1876,1,1,2,37519),-- Mithril Ore
(21328,1895,1,1,2,53599),-- Metallic Fiber
(21328,4042,1,1,2,3127),-- Enria
(21328,5282,1,1,2,83),-- Recipe: Greater Blessed Spiritshot (S) Compressed Package(100%)
(21328,6671,1,1,2,20844),-- Deluxe Chest Key - Grade 7
(21328,8732,1,1,200,1563),-- Life Stone: level 76
(21328,8742,1,1,200,391),-- Mid-Grade Life Stone: level 76
(21328,8752,1,1,200,39),-- High-Grade Life Stone: level 76
(21329,5162,1,1,-1,2526), -- Recipe: Spiritshot (S) Compressed Package (100%)
(21329,5167,1,1,-1,2526), -- Recipe: Blessed Spiritshot (S) Compressed Package (100%)
(21329,5487,1,1,-1,25594), -- Sealed Robe of Nightmare Fabric
(21329,57,2802,5719,0,700000), -- Adena
(21329,11964,1,1,1,62), -- Common Item - Dark Legion's Edge
(21329,11971,1,1,1,62), -- Common Item - Sword of Miracles 
(21329,11968,1,1,1,62), -- Common Item - Dragon Slayer
(21329,7668,1,1,2,9046), -- Spellbook - Block Shield
(21329,7669,1,1,2,9046), -- Spellbook - Block Wind Walk
(21329,7670,1,1,2,9046), -- Spellbook - Mass Block Shield
(21329,7671,1,1,2,9046), -- Spellbook - Mass Block Wind Walk
(21329,5529,1,1,1,960), -- Dragon Slayer Edge
(21329,5545,1,1,1,960), -- Dark Legion\'s Edge Blade
(21329,5546,1,1,1,1054), -- Sword of Miracles Edge
(21330,1885,1,1,-1,451470), -- High Grade Suede
(21330,4041,1,1,-1,47110), -- Mold Hardener
(21330,5488,1,1,-1,24396), -- Sealed Majestic Robe Fabric
(21330,57,2671,5451,0,700000), -- Adena
(21330,11970,1,1,1,44), -- Common Item - Branch of The Mother Tree
(21330,11974,1,1,1,44), -- Common Item - Elysian
(21330,11969,1,1,1,44), -- Common Item - Flaming Dragon Skull
(21330,11966,1,1,1,44), -- Common Item - Doom Crusher
(21330,8342,1,1,1,686), -- Flaming Dragon Skull Piece
(21330,8349,1,1,1,686), -- Doom Crusher Head
(21330,5533,1,1,1,686), -- Elysian Head
(21330,5544,1,1,1,685), -- Branch of The Mother Tree Head
(21330,960,1,1,2,80), -- Scroll: Enchant Armor (Grade S)
(21330,1344,20,60,2,125022), -- Mithril Arrow
(21330,1866,1,1,2,133357), -- Suede
(21330,1871,1,1,2,200036), -- Charcoal
(21330,1885,1,1,2,16670), -- High Grade Suede
(21330,4041,1,1,2,1740), -- Mold Hardener
(21330,5220,1,1,2,8001), -- Metal Hardener
(21330,8732,1,1,200,1667), -- Life Stone: level 76
(21330,8742,1,1,200,417), -- Mid-Grade Life Stone: level 76
(21330,8752,1,1,200,42), -- High-Grade Life Stone: level 76
(21331,1895,1,3,-1,760448), -- Metallic Fiber
(21331,4042,1,1,-1,88719), -- Enria
(21331,5546,1,1,-1,16041), -- Sword of Miracles Edge
(21331,57,2624,5357,0,700000), -- Adena
(21331,11964,1,1,1,58), -- Common Item - Dark Legion's Edge
(21331,11971,1,1,1,58), -- Common Item - Sword of Miracles 
(21331,11968,1,1,1,58), -- Common Item - Dragon Slayer
(21331,5529,1,1,1,899), -- Dragon Slayer Edge
(21331,5545,1,1,1,899), -- Dark Legion\'s Edge Blade
(21331,5546,1,1,1,987), -- Sword of Miracles Edge
(21331,960,1,1,2,79), -- Scroll: Enchant Armor (Grade S)
(21331,1344,30,90,2,81895), -- Mithril Arrow
(21331,1868,1,3,2,196547), -- Thread
(21331,1873,1,1,2,78619), -- Silver Nugget
(21331,1876,1,1,2,39309), -- Mithril Ore
(21331,1895,1,1,2,56156), -- Metallic Fiber
(21331,4042,1,1,2,3276), -- Enria
(21331,8732,1,1,200,1638), -- Life Stone: level 76
(21331,8742,1,1,200,409), -- Mid-Grade Life Stone: level 76
(21331,8752,1,1,200,37), -- High-Grade Life Stone: level 76
(21332,5282,1,1,-1,2650), -- Recipe: Greater Blessed Spiritshot (S) Compressed Package(100%)
(21332,6342,1,1,-1,135049), -- Sealed Majestic Earring Gemstone
(21332,6344,1,1,-1,87397), -- Sealed Majestic Necklace Beads
(21332,57,2939,6000,0,700000), -- Adena
(21332,11970,1,1,1,49), -- Common Item - Branch of The Mother Tree
(21332,11974,1,1,1,49), -- Common Item - Elysian
(21332,11969,1,1,1,49), -- Common Item - Flaming Dragon Skull
(21332,11966,1,1,1,49), -- Common Item - Doom Crusher
(21332,8342,1,1,1,755), -- Flaming Dragon Skull Piece
(21332,8349,1,1,1,755), -- Doom Crusher Head
(21332,5533,1,1,1,755), -- Elysian Head
(21332,5544,1,1,1,754), -- Branch of The Mother Tree Head
(21332,959,1,1,2,11), -- Scroll: Enchant Weapon (Grade S)
(21332,1894,1,1,2,9655), -- Crafted Leather
(21332,4039,1,1,2,9172), -- Mold Glue
(21332,4041,1,1,2,2393), -- Mold Hardener
(21332,4044,1,1,2,9172), -- Thons
(21332,8732,1,1,200,2293), -- Life Stone: level 76
(21332,8742,1,1,200,573), -- Mid-Grade Life Stone: level 76
(21332,8752,1,1,200,57), -- High-Grade Life Stone: level 76
(21333,1808,1,1,-1,2541), -- Recipe: Soulshot: S Grade
(21333,3036,1,1,-1,2541), -- Recipe: Spiritshot S
(21333,5503,1,1,-1,96563), -- Sealed Majestic Boots Lining
(21333,57,2813,5760,0,700000), -- Adena
(21333,11970,1,1,1,47), -- Common Item - Branch of The Mother Tree
(21333,11974,1,1,1,47), -- Common Item - Elysian
(21333,11969,1,1,1,47), -- Common Item - Flaming Dragon Skull
(21333,11966,1,1,1,47), -- Common Item - Doom Crusher
(21333,8342,1,1,1,724), -- Flaming Dragon Skull Piece
(21333,8349,1,1,1,724), -- Doom Crusher Head
(21333,5533,1,1,1,724), -- Elysian Head
(21333,5544,1,1,1,723), -- Branch of The Mother Tree Head
(21333,959,1,1,2,9), -- Scroll: Enchant Weapon (Grade S)
(21333,1864,4,12,2,58641), -- Stem
(21333,1865,2,6,2,46913), -- Varnish
(21333,1866,3,9,2,26063), -- Suede
(21333,1868,1,3,2,156376), -- Thread
(21333,1873,1,1,2,93825), -- Silver Nugget
(21333,8732,1,1,200,1955), -- Life Stone: level 76
(21333,8742,1,1,200,489), -- Mid-Grade Life Stone: level 76
(21333,8752,1,1,200,49), -- High-Grade Life Stone: level 76
(21334,5480,1,1,-1,34714), -- Sealed Leather Armor of Nightmare Fabric
(21334,5514,1,1,-1,130657), -- Sealed Gloves of Nightmare Design
(21334,57,3806,7794,0,700000), -- Adena
(21334,11967,1,1,1,254), -- Common Item - Dragon Grinder
(21334,5538,1,1,1,3917), -- Dragon Grinder Edge
(21334,960,1,1,2,104), -- Scroll: Enchant Armor (Grade S)
(21334,1344,40,120,2,81149), -- Mithril Arrow
(21334,1867,1,3,2,115412), -- Animal Skin
(21334,1869,2,6,2,51935), -- Iron Ore
(21334,1870,3,9,2,43279), -- Coal
(21334,1871,3,9,2,37097), -- Charcoal
(21334,1872,8,24,2,21640), -- Animal Bone
(21334,6672,1,1,2,21640), -- Deluxe Chest Key - Grade 8
(21334,8732,1,1,200,2164), -- Life Stone: level 76
(21334,8742,1,1,200,541), -- Mid-Grade Life Stone: level 76
(21334,8752,1,1,200,54), -- High-Grade Life Stone: level 76
(21335,1889,1,1,-1,368264), -- Compound Braid
(21335,5272,1,1,-1,2455), -- Recipe: Greater Soulshot (S) Compressed Package(100%)
(21335,5495,1,1,-1,83881), -- Sealed Shield of Nightmare Fragment
(21335,57,2718,5566,0,700000), -- Adena
(21335,11976,1,1,1,181), -- Common Item - Tallum Glaive
(21335,5541,1,1,1,2797), -- Tallum Glaive Edge
(21335,959,1,1,2,9), -- Scroll: Enchant Weapon (Grade S)
(21335,1868,1,3,2,226625), -- Thread
(21335,1873,1,1,2,90650), -- Silver Nugget
(21335,1889,1,1,2,15108), -- Compound Braid
(21335,4044,1,1,2,7554), -- Thons
(21335,5549,1,1,2,22662), -- Metallic Thread
(21335,8732,1,1,200,1889), -- Life Stone: level 76
(21335,8742,1,1,200,472), -- Mid-Grade Life Stone: level 76
(21335,8752,1,1,200,47), -- High-Grade Life Stone: level 76
(21336,5277,1,1,-1,2887), -- Recipe: Greater Spiritshot (S) Compressed Package(100%)
(21336,5502,1,1,-1,109688), -- Sealed Boots of Nightmare Lining
(21336,5503,1,1,-1,109688), -- Sealed Majestic Boots Lining
(21336,57,3195,6545,0,700000), -- Adena
(21336,12265,1,1,1,335), -- Common Item - Sealed Leather Armor of Nightmare
(21336,12258,1,1,1,335), -- Common Item - Sealed Majestic Leather Armor
(21336,5480,1,1,1,2690), -- Sealed Leather Armor of Nightmare Fabric
(21336,5481,1,1,1,2690), -- Sealed Majestic Leather Armor Fabric
(21336,960,1,1,2,96), -- Scroll: Enchant Armor (Grade S)
(21336,1344,40,120,2,74939), -- Mithril Arrow
(21336,1864,5,15,2,47960), -- Stem
(21336,1865,3,9,2,39967), -- Varnish
(21336,1866,3,9,2,22838), -- Suede
(21336,1868,1,3,2,159868), -- Thread
(21336,1873,1,1,2,95920), -- Silver Nugget
(21336,8732,1,1,200,1998), -- Life Stone: level 76
(21336,8742,1,1,200,500), -- Mid-Grade Life Stone: level 76
(21336,8752,1,1,200,50), -- High-Grade Life Stone: level 76
(21337,959,1,1,-1,241), -- Scroll: Enchant Weapon (Grade S)
(21337,1885,1,1,-1,501446), -- High Grade Suede
(21337,5220,1,1,-1,240694), -- Metal Hardener
(21337,57,2968,6057,0,700000), -- Adena
(21337,12266,1,1,1,310), -- Common Item - Sealed Robe of Nightmare
(21337,12259,1,1,1,310), -- Common Item - Sealed Majestic Robe
(21337,5487,1,1,1,2501), -- Sealed Robe of Nightmare Fabric
(21337,5488,1,1,1,2501), -- Sealed Majestic Robe Fabric
(21337,959,1,1,2,10), -- Scroll: Enchant Weapon (Grade S)
(21337,1866,1,1,2,164577), -- Suede
(21337,1871,1,1,2,246866), -- Charcoal
(21337,1885,1,1,2,20572), -- High Grade Suede
(21337,4041,1,1,2,2147), -- Mold Hardener
(21337,5220,1,1,2,9875), -- Metal Hardener
(21337,8732,1,1,200,2057), -- Life Stone: level 76
(21337,8742,1,1,200,514), -- Mid-Grade Life Stone: level 76
(21337,8752,1,1,200,52), -- High-Grade Life Stone: level 76
(21338,6688,1,1,-1,17114), -- Forgotten Blade Edge
(21338,6689,1,1,-1,16792), -- Basalt Battlehammer Head
(21338,6690,1,1,-1,17147), -- Imperial Staff Head
(21338,57,3905,7970,0,700000), -- Adena
(21338,12350,1,1,1,900), -- Common Item - Sealed Majestic Necklace
(21338,12352,1,1,1,1199), -- Common Item - Sealed Majestic Earring
(21338,12351,1,1,1,1798), -- Common Item - Sealed Majestic Ring
(21338,6342,1,1,1,11038), -- Sealed Majestic Earring Gemstone
(21338,6344,1,1,1,7143), -- Sealed Majestic Necklace Beads
(21338,6346,1,1,1,15864), -- Sealed Majestic Ring Gemstone
(21338,960,1,1,2,117), -- Scroll: Enchant Armor (Grade S)
(21338,1344,30,90,2,121815), -- Mithril Arrow
(21338,1864,5,15,2,58471), -- Stem
(21338,1869,2,6,2,73089), -- Iron Ore
(21338,1880,1,1,2,29235), -- Steel
(21338,4043,1,1,2,9745), -- Asofe
(21338,5550,1,1,2,3898), -- Durable Metal Plate
(21338,8732,1,1,200,2436), -- Life Stone: level 76
(21338,8742,1,1,200,609), -- Mid-Grade Life Stone: level 76
(21338,8752,1,1,200,61), -- High-Grade Life Stone: level 76
(21339,6691,1,1,-1,13041), -- Angel Slayer Blade
(21339,6693,1,1,-1,13277), -- Dragon Hunter Axe Blade
(21339,6694,1,1,-1,13277), -- Saint Spear Blade
(21339,57,2975,6071,0,700000), -- Adena
(21339,11973,1,1,1,198), -- Common Item - Soul Separator
(21339,5537,1,1,1,3056), -- Soul Separator Head
(21339,960,1,1,2,89), -- Scroll: Enchant Armor (Grade S)
(21339,1344,40,120,2,69615), -- Mithril Arrow
(21339,1867,1,3,2,148511), -- Animal Skin
(21339,1872,1,3,2,99008), -- Animal Bone
(21339,1882,1,1,2,49504), -- Leather
(21339,1894,1,1,2,7816), -- Crafted Leather
(21339,4042,1,1,2,3713), -- Enria
(21339,8732,1,1,200,1856), -- Life Stone: level 76
(21339,8742,1,1,200,464), -- Mid-Grade Life Stone: level 76
(21339,8752,1,1,200,46), -- High-Grade Life Stone: level 76
(21340,960,1,1,-1,2413), -- Scroll: Enchant Armor (Grade S)
(21340,1889,1,1,-1,402219), -- Compound Braid
(21340,5549,1,1,-1,603328), -- Metallic Thread
(21340,57,2975,6071,0,700000), -- Adena
(21340,12269,1,1,1,674), -- Common Item - Sealed Helm of Nightmare
(21340,12268,1,1,1,963), -- Common Item - Sealed Shield of Nightmare
(21340,12261,1,1,1,674), -- Common Item - Sealed Majestic Circlet
(21340,5495,1,1,1,5638), -- Sealed Shield of Nightmare Fragment
(21340,5527,1,1,1,4439), -- Sealed Helm of Nightmare Design
(21340,5528,1,1,1,4439), -- Sealed Majestic Circlet Design
(21340,959,1,1,2,9), -- Scroll: Enchant Weapon (Grade S)
(21340,1868,1,3,2,222768), -- Thread
(21340,1873,1,1,2,89107), -- Silver Nugget
(21340,1889,1,1,2,14851), -- Compound Braid
(21340,4044,1,1,2,7425), -- Thons
(21340,5549,1,1,2,22277), -- Metallic Thread
(21340,6672,1,1,2,18564), -- Deluxe Chest Key - Grade 8
(21340,8732,1,1,200,1856), -- Life Stone: level 76
(21340,8742,1,1,200,464), -- Mid-Grade Life Stone: level 76
(21340,8752,1,1,200,46), -- High-Grade Life Stone: level 76
(21341,960,1,1,-1,2527), -- Scroll: Enchant Armor (Grade S)
(21341,1876,1,3,-1,631818), -- Mithril Ore
(21341,4042,1,1,-1,105303), -- Enria
(21341,57,3115,6359,0,700000), -- Adena
(21341,11968,1,1,1,69), -- Common Item - Dragon Slayer
(21341,11971,1,1,1,69), -- Common Item - Sword of Miracles 
(21341,11964,1,1,1,69), -- Common Item - Dark Legion\'s Edge
(21341,5529,1,1,1,1067), -- Dragon Slayer Edge
(21341,5545,1,1,1,1067), -- Dark Legion\'s Edge Blade
(21341,5546,1,1,1,1172), -- Sword of Miracles Edge
(21341,959,1,1,2,10), -- Scroll: Enchant Weapon (Grade S)
(21341,1868,1,3,2,259207), -- Thread
(21341,1873,1,1,2,103683), -- Silver Nugget
(21341,1876,1,1,2,51841), -- Mithril Ore
(21341,1895,1,1,2,74059), -- Metallic Fiber
(21341,4042,1,1,2,4320), -- Enria
(21341,8732,1,1,200,2160), -- Life Stone: level 76
(21341,8742,1,1,200,540), -- Mid-Grade Life Stone: level 76
(21341,8752,1,1,200,54), -- High-Grade Life Stone: level 76
(21342,6707,1,1,-1,41193),-- Sealed Draconic Leather Armor Part
(21342,6708,1,1,-1,118371),-- Sealed Draconic Leather Gloves Fabric
(21342,6709,1,1,-1,118371),-- Sealed Draconic Leather Boots Design
(21342,57,4098,8367,0,700000),-- Adena
(21342,11974,1,1,1,68),-- Common Item - Elysian
(21342,11970,1,1,1,68),-- Common Item - Branch of The Mother Tree
(21342,8342,1,1,1,1053),-- Flaming Dragon Skull Piece
(21342,11969,1,1,1,68),-- Common Item - Flaming Dragon Skull
(21342,8349,1,1,1,1052),-- Doom Crusher Head
(21342,11966,1,1,1,68),-- Common Item - Doom Crusher
(21342,5533,1,1,1,1053),-- Elysian Head
(21342,5544,1,1,1,1052),-- Branch of The Mother Tree Head
(21342,960,1,1,2,123),-- Scroll: Enchant Armor (Grade S)
(21342,1344,20,60,2,191856),-- Mithril Arrow
(21342,1866,2,6,2,51162),-- Suede
(21342,1871,1,3,2,102323),-- Charcoal
(21342,1877,1,1,2,12279),-- Adamantite Nugget
(21342,4040,1,1,2,6139),-- Mold Lubricant
(21342,4041,1,1,2,2669),-- Mold Hardener
(21342,8732,1,1,200,2558),-- Life Stone: level 76
(21342,8742,1,1,200,639),-- Mid-Grade Life Stone: level 76
(21342,8752,1,1,200,64), -- High-Grade Life Stone: level 76
(21343,3957,1,1,-1,4177),-- Recipe: Blessed Spiritshot S
(21343,5515,1,1,-1,158740),-- Sealed Majestic Gloves Design
(21343,5522,1,1,-1,32009),-- Sealed Armor of Nightmare Pattern
(21343,57,4624,9470,0,700000),-- Adena
(21343,11975,1,1,1,308),-- Common Item - Soul Bow
(21343,5534,1,1,1,4764),-- Soul Bow Stave
(21343,959,1,1,2,17),-- Scroll: Enchant Weapon (Grade S)
(21343,1894,1,1,2,15221),-- Crafted Leather
(21343,4039,1,1,2,14460),-- Mold Glue
(21343,4041,1,1,2,3772),-- Mold Hardener
(21343,4044,1,1,2,14460),-- Thons
(21343,8732,1,1,200,3615),-- Life Stone: level 76
(21343,8742,1,1,200,904),-- Mid-Grade Life Stone: level 76
(21343,8752,1,1,200,90),-- High-Grade Life Stone: level 76
(21344,4040,1,1,-1,127444),-- Mold Lubricant
(21344,6346,1,1,-1,207463),-- Sealed Majestic Ring Gemstone
(21344,6901,1,1,-1,6372),-- Recipe: Shining Arrow (100%)
(21344,57,3141,6413,0,700000),-- Adena
(21344,11967,1,1,1,209),-- Common Item - Dragon Grinder
(21344,5538,1,1,1,3227),-- Dragon Grinder Edge
(21344,960,1,1,2,94),-- Scroll: Enchant Armor (Grade S)
(21344,1344,20,60,2,147052),-- Mithril Arrow
(21344,1866,1,1,2,156855),-- Suede
(21344,1871,1,3,2,78427),-- Charcoal
(21344,1877,1,1,2,9411),-- Adamantite Nugget
(21344,4040,1,1,2,4706),-- Mold Lubricant
(21344,4041,1,1,2,2046),-- Mold Hardener
(21344,8732,1,1,200,1961),-- Life Stone: level 76
(21344,8742,1,1,200,490),-- Mid-Grade Life Stone: level 76
(21344,8752,1,1,200,49),-- High-Grade Life Stone: level 76
(21345,959,1,1,-1,284),-- Scroll: Enchant Weapon (Grade S)
(21345,1894,1,1,-1,249418),-- Crafted Leather
(21345,4042,1,1,-1,118474),-- Enria
(21345,57,3504,7154,0,700000),-- Adena
(21345,11967,1,1,1,233),-- Common Item - Dragon Grinder
(21345,5538,1,1,1,3600),-- Dragon Grinder Edge
(21345,959,1,1,2,12),-- Scroll: Enchant Weapon (Grade S)
(21345,1867,1,3,2,194418),-- Animal Skin
(21345,1872,1,3,2,129612),-- Animal Bone
(21345,1882,1,1,2,64806),-- Leather
(21345,1894,1,1,2,10233),-- Crafted Leather
(21345,4042,1,1,2,4860),-- Enria
(21345,8732,1,1,200,2430),-- Life Stone: level 76
(21345,8742,1,1,200,608),-- Mid-Grade Life Stone: level 76
(21345,8752,1,1,200,61),-- High-Grade Life Stone: level 76
(21346,6695,1,1,-1,14972),-- Demon Splinter Blade
(21346,6696,1,1,-1,15502),-- Heavens Divider Edge
(21346,6697,1,1,-1,14972),-- Arcana Mace Head
(21346,57,3481,7103,0,700000),-- Adena
(21346,11976,1,1,1,232),-- Common Item - Tallum Glaive
(21346,5541,1,1,1,3574),-- Tallum Glaive Edge
(21346,960,1,1,2,104),-- Scroll: Enchant Armor (Grade S)
(21346,1344,40,120,2,81459),-- Mithril Arrow
(21346,1864,5,15,2,52133),-- Stem
(21346,1865,3,9,2,43444),-- Varnish
(21346,1866,3,9,2,24825),-- Suede
(21346,1868,1,3,2,173777),-- Thread
(21346,1873,1,1,2,104266),-- Silver Nugget
(21346,8732,1,1,200,2172),-- Life Stone: level 76
(21346,8742,1,1,200,543),-- Mid-Grade Life Stone: level 76
(21346,8752,1,1,200,54),-- High-Grade Life Stone: level 76
(21347,6710,1,1,-1,175170),-- Sealed Draconic Leather Helmet Pattern
(21347,6711,1,1,-1,53504),-- Sealed Major Arcana Robe Part
(21347,6712,1,1,-1,153746),-- Sealed Major Arcana Gloves fabric
(21347,57,5309,10884,0,700000),-- Adena
(21347,12263,1,1,1,418),-- Common Item - Sealed Armor of Nightmare
(21347,12262,1,1,1,418),-- Common Item - Sealed Majestic Plate Armor
(21347,5522,1,1,1,3395),-- Sealed Armor of Nightmare Pattern
(21347,5523,1,1,1,3395),-- Sealed Majestic Plate Armor Pattern
(21347,960,1,1,2,177),-- Scroll: Enchant Armor (Grade S)
(21347,1867,4,12,2,73835),-- Animal Skin
(21347,1872,1,3,2,196892),-- Animal Bone
(21347,1882,1,1,2,98446),-- Leather
(21347,1894,1,1,2,15544),-- Crafted Leather
(21347,4042,1,1,2,7384),-- Enria
(21347,8732,1,1,200,3692),-- Life Stone: level 76
(21347,8742,1,1,200,923),-- Mid-Grade Life Stone: level 76
(21347,8752,1,1,200,92),-- High-Grade Life Stone: level 76
(21348,6704,1,1,-1,105402),-- Sealed Imperial Crusader Boots Design
(21348,6705,1,1,-1,103241),-- Sealed Imperial Crusader Shield Part
(21348,6706,1,1,-1,120089),-- Sealed Imperial Crusader Helmet Pattern
(21348,57,3643,7457,0,700000),-- Adena
(21348,11973,1,1,1,243),-- Common Item - Soul Separator
(21348,5537,1,1,1,3749),-- Soul Separator Head
(21348,960,1,1,2,121),-- Scroll: Enchant Armor (Grade S)
(21348,1868,1,3,2,303709),-- Thread
(21348,1873,1,1,2,121484),-- Silver Nugget
(21348,1889,1,1,2,20248),-- Compound Braid
(21348,4044,1,1,2,10124),-- Thons
(21348,5549,1,1,2,30371),-- Metallic Thread
(21348,8732,1,1,200,2531),-- Life Stone: level 76
(21348,8742,1,1,200,633),-- Mid-Grade Life Stone: level 76
(21348,8752,1,1,200,63),-- High-Grade Life Stone: level 76
(21349,959,1,1,-1,301),-- Scroll: Enchant Weapon (Grade S)
(21349,1875,1,1,-1,501199),-- Stone of Purity
(21349,4041,1,1,-1,65374),-- Mold Hardener
(21349,57,3700,7573,0,700000),-- Adena
(21349,11967,1,1,1,247),-- Common Item - Dragon Grinder
(21349,5538,1,1,1,3807),-- Dragon Grinder Edge
(21349,959,1,1,2,12),-- Scroll: Enchant Weapon (Grade S)
(21349,1867,1,3,2,137080),-- Animal Skin
(21349,1872,1,3,2,205620),-- Animal Bone
(21349,1875,1,1,2,20562),-- Stone of Purity
(21349,1881,1,1,2,41124),-- Coarse Bone Powder
(21349,4041,1,1,2,2682),-- Mold Hardener
(21349,8732,1,1,200,2570),-- Life Stone: level 76
(21349,8742,1,1,200,643),-- Mid-Grade Life Stone: level 76
(21349,8752,1,1,200,64),-- High-Grade Life Stone: level 76
(21350,3957,1,1,-1,2627),-- Recipe: Blessed Spiritshot S
(21350,5157,1,1,-1,2627),-- Recipe: Soulshot (S) Compressed Package (100%)
(21350,5522,1,1,-1,20132),-- Sealed Armor of Nightmare Pattern
(21350,57,2914,5954,0,700000),-- Adena
(21350,11955,1,1,1,300),-- Common Item - Carnage Bow
(21350,5535,1,1,1,3724),-- Carnage Bow Stave
(21350,1865,1,3,2,121265),-- Varnish
(21350,1870,1,1,2,242530),-- Coal
(21350,1875,1,1,2,16169),-- Stone of Purity
(21350,1879,1,1,2,40422),-- Cokes
(21350,4040,1,1,2,4850),-- Mold Lubricant
(21350,5157,1,1,2,108),-- Recipe: Soulshot (S) Compressed Package (100%)
(21350,8732,1,1,200,2021),-- Life Stone: level 76
(21350,8742,1,1,200,505),-- Mid-Grade Life Stone: level 76
(21350,8752,1,1,200,50),-- High-Grade Life Stone: level 76
(21351,4041,1,1,-1,44975),-- Mold Hardener
(21351,5220,1,1,-1,206884),-- Metal Hardener
(21351,5523,1,1,-1,17614),-- Sealed Majestic Plate Armor Pattern
(21351,57,2549,5209,0,700000),-- Adena
(21351,11951,1,1,1,263),-- Common Item - Bloody Orchid
(21351,5536,1,1,1,3248),-- Bloody Orchid Head
(21351,1344,20,60,2,119356),-- Mithril Arrow
(21351,1866,1,1,2,127313),-- Suede
(21351,1871,1,1,2,190970),-- Charcoal
(21351,1885,1,1,2,15914),-- High Grade Suede
(21351,4041,1,1,2,1660),-- Mold Hardener
(21351,5162,1,1,2,85),-- Recipe: Spiritshot (S) Compressed Package (100%)
(21351,5220,1,1,2,7639),-- Metal Hardener
(21351,8732,1,1,200,1592),-- Life Stone: level 76
(21351,8742,1,1,200,398),-- Mid-Grade Life Stone: level 76
(21351,8752,1,1,200,40),-- High-Grade Life Stone: level 76
(21352,5162,1,1,-1,1400),-- Recipe: Spiritshot (S) Compressed Package (100%)
(21352,5527,1,1,-1,37659),-- Sealed Helm of Nightmare Design
(21352,5528,1,1,-1,37659),-- Sealed Majestic Circlet Design
(21352,57,1553,3172,0,700000),-- Adena
(21352,12222,1,1,1,282),-- Common Item - Sealed Dark Crystal Leather Armor
(21352,12228,1,1,1,451),-- Common Item - Sealed Dark Crystalline Leggings
(21352,12230,1,1,1,173),-- Common Item - Sealed Tallum Leather Armor
(21352,5478,1,1,1,1630),-- Sealed Dark Crystal Leather Armor Pattern
(21352,5479,1,1,1,1147),-- Sealed Tallum Leather Armor Pattern
(21352,5482,1,1,1,2559),-- Sealed Dark Crystalline Leggings Design
(21352,1864,1,1,2,258446),-- Stem
(21352,1869,1,1,2,129223),-- Iron Ore
(21352,1880,1,1,2,12922),-- Steel
(21352,4043,1,1,2,4307),-- Asofe
(21352,5167,1,1,2,58),-- Recipe: Blessed Spiritshot (S) Compressed Package (100%)
(21352,5550,1,1,2,1723),-- Durable Metal Plate
(21352,8732,1,1,200,1077),-- Life Stone: level 76
(21352,8742,1,1,200,269),-- Mid-Grade Life Stone: level 76
(21352,8752,1,1,200,27),-- High-Grade Life Stone: level 76
(21353,1875,1,1,-1,470004),-- Stone of Purity
(21353,4041,1,1,-1,61305),-- Mold Hardener
(21353,5538,1,1,-1,19338),-- Dragon Grinder Edge
(21353,57,3477,7097,0,700000),-- Adena
(21353,11950,1,1,1,358),-- Common Item - Blood Tornado
(21353,5539,1,1,1,4389),-- Blood Tornado Edge
(21353,1867,1,3,2,128548),-- Animal Skin
(21353,1872,1,3,2,192822),-- Animal Bone
(21353,1875,1,1,2,19282),-- Stone of Purity
(21353,1881,1,1,2,38564),-- Coarse Bone Powder
(21353,4041,1,1,2,2515),-- Mold Hardener
(21353,6901,1,1,2,289),-- Recipe: Shining Arrow (100%)
(21353,8732,1,1,200,2410),-- Life Stone: level 76
(21353,8742,1,1,200,603),-- Mid-Grade Life Stone: level 76
(21353,8752,1,1,200,60),-- High-Grade Life Stone: level 76
(21354,5282,1,1,-1,3106),-- Recipe: Greater Blessed Spiritshot (S) Compressed Package(100%)
(21354,5541,1,1,-1,19163),-- Tallum Glaive Edge
(21354,6901,1,1,-1,6988),-- Recipe: Shining Arrow (100%)
(21354,57,3446,7034,0,700000),-- Adena
(21354,11955,1,1,1,355),-- Common Item - Carnage Bow
(21354,5535,1,1,1,4402),-- Carnage Bow Stave
(21354,1344,30,90,2,97731),-- Mithril Arrow
(21354,1808,1,1,2,104),-- Recipe: Soulshot: S Grade
(21354,1868,4,12,2,58638),-- Thread
(21354,1873,1,1,2,93821),-- Silver Nugget
(21354,1889,1,1,2,15637),-- Compound Braid
(21354,4044,1,1,2,7819),-- Thons
(21354,5549,1,1,2,23455),-- Metallic Thread
(21354,6671,1,1,2,26061),-- Deluxe Chest Key - Grade 7
(21354,8732,1,1,200,1955),-- Life Stone: level 76
(21354,8742,1,1,200,489),-- Mid-Grade Life Stone: level 76
(21354,8752,1,1,200,49),-- High-Grade Life Stone: level 76
(21355,5272,1,1,-1,3157),-- Recipe: Greater Soulshot (S) Compressed Package(100%)
(21355,5495,1,1,-1,107862),-- Sealed Shield of Nightmare Fragment
(21355,5502,1,1,-1,119967),-- Sealed Boots of Nightmare Lining
(21355,57,3502,7147,0,700000),-- Adena
(21355,11967,1,1,1,233),-- Common Item - Dragon Grinder
(21355,5538,1,1,1,3597),-- Dragon Grinder Edge
(21355,959,1,1,2,12),-- Scroll: Enchant Weapon (Grade S)
(21355,1864,1,3,2,291416),-- Stem
(21355,1869,1,3,2,97139),-- Iron Ore
(21355,1880,1,1,2,29141),-- Steel
(21355,4043,1,1,2,9714),-- Asofe
(21355,5550,1,1,2,3886),-- Durable Metal Plate
(21355,8732,1,1,200,2428),-- Life Stone: level 76
(21355,8742,1,1,200,607),-- Mid-Grade Life Stone: level 76
(21355,8752,1,1,200,60),-- High-Grade Life Stone: level 76
(21356,4042,1,1,-1,76189),-- Enria
(21356,5277,1,1,-1,2032),-- Recipe: Greater Spiritshot (S) Compressed Package(100%)
(21356,5503,1,1,-1,77205),-- Sealed Majestic Boots Lining
(21356,57,2254,4600,0,700000),-- Adena
(21356,11975,1,1,1,150),-- Common Item - Soul Bow
(21356,5534,1,1,1,2317),-- Soul Bow Stave
(21356,960,1,1,2,67),-- Scroll: Enchant Armor (Grade S)
(21356,1344,10,30,2,210984),-- Mithril Arrow
(21356,1867,1,3,2,112525),-- Animal Skin
(21356,1872,1,3,2,75016),-- Animal Bone
(21356,1882,1,1,2,37508),-- Leather
(21356,1894,1,1,2,5922),-- Crafted Leather
(21356,4042,1,1,2,2813),-- Enria
(21356,8732,1,1,200,1406),-- Life Stone: level 76
(21356,8742,1,1,200,351),-- Mid-Grade Life Stone: level 76
(21356,8752,1,1,200,35),-- High-Grade Life Stone: level 76
(21357,1808,1,1,-1,3360),-- Recipe: Soulshot: S Grade
(21357,4040,1,1,-1,151216),-- Mold Lubricant
(21357,5480,1,1,-1,33927),-- Sealed Leather Armor of Nightmare Fabric
(21357,57,3727,7609,0,700000),-- Adena
(21357,11975,1,1,1,248),-- Common Item - Soul Bow
(21357,5534,1,1,1,3832),-- Soul Bow Stave
(21357,959,1,1,2,12),-- Scroll: Enchant Weapon (Grade S)
(21357,1865,1,3,2,155094),-- Varnish
(21357,1870,1,3,2,103396),-- Coal
(21357,1875,1,1,2,20679),-- Stone of Purity
(21357,1879,1,1,2,51698),-- Cokes
(21357,4040,1,1,2,6204),-- Mold Lubricant
(21357,8732,1,1,200,2585),-- Life Stone: level 76
(21357,8742,1,1,200,646),-- Mid-Grade Life Stone: level 76
(21357,8752,1,1,200,65),-- High-Grade Life Stone: level 76
(21358,3036,1,1,-1,3379),-- Recipe: Spiritshot S
(21358,5481,1,1,-1,34116),-- Sealed Majestic Leather Armor Fabric
(21358,5487,1,1,-1,34237),-- Sealed Robe of Nightmare Fabric
(21358,57,3748,7652,0,700000),-- Adena
(21358,11973,1,1,1,250),-- Common Item - Soul Separator
(21358,5537,1,1,1,3850),-- Soul Separator Head
(21358,960,1,1,2,112),-- Scroll: Enchant Armor (Grade S)
(21358,1344,20,60,2,175455),-- Mithril Arrow
(21358,1866,1,1,2,187151),-- Suede
(21358,1871,1,3,2,93575),-- Charcoal
(21358,1885,1,1,2,23394),-- High Grade Suede
(21358,4041,1,1,2,2441),-- Mold Hardener
(21358,5220,1,1,2,11229),-- Metal Hardener
(21358,8732,1,1,200,2339),-- Life Stone: level 76
(21358,8742,1,1,200,585),-- Mid-Grade Life Stone: level 76
(21358,8752,1,1,200,59),-- High-Grade Life Stone: level 76
(21359,4042,1,1,-1,81173),-- Enria
(21359,5157,1,1,-1,2165),-- Recipe: Soulshot (S) Compressed Package (100%)
(21359,5523,1,1,-1,16586),-- Sealed Majestic Plate Armor Pattern
(21359,57,2396,4907,0,700000),-- Adena
(21359,11973,1,1,1,160),-- Common Item - Soul Separator
(21359,5537,1,1,1,2467),-- Soul Separator Head
(21359,960,1,1,2,72),-- Scroll: Enchant Armor (Grade S)
(21359,1344,30,90,2,74930),-- Mithril Arrow
(21359,1868,1,3,2,179830),-- Thread
(21359,1873,1,1,2,71932),-- Silver Nugget
(21359,1876,1,1,2,35966),-- Mithril Ore
(21359,1895,1,1,2,51380),-- Metallic Fiber
(21359,4042,1,1,2,2997),-- Enria
(21359,8732,1,1,200,1498),-- Life Stone: level 76
(21359,8742,1,1,200,375),-- Mid-Grade Life Stone: level 76
(21359,8752,1,1,200,37),-- High-Grade Life Stone: level 76
(21360,1875,1,1,-1,673928),-- Stone of Purity
(21360,5162,1,1,-1,4493),-- Recipe: Spiritshot (S) Compressed Package (100%)
(21360,5527,1,1,-1,120862),-- Sealed Helm of Nightmare Design
(21360,57,4974,10185,0,700000),-- Adena
(21360,11973,1,1,1,332),-- Common Item - Soul Separator
(21360,5537,1,1,1,5120),-- Soul Separator Head
(21360,959,1,1,2,17),-- Scroll: Enchant Weapon (Grade S)
(21360,1867,1,3,2,184323),-- Animal Skin
(21360,1872,4,12,2,69121),-- Animal Bone
(21360,1875,1,1,2,27648),-- Stone of Purity
(21360,1881,1,1,2,55297),-- Coarse Bone Powder
(21360,4041,1,1,2,3606),-- Mold Hardener
(21360,8732,1,1,200,3456),-- Life Stone: level 76
(21360,8742,1,1,200,864),-- Mid-Grade Life Stone: level 76
(21360,8752,1,1,200,86),-- High-Grade Life Stone: level 76
(21361,5481,1,1,-1,32762),-- Sealed Majestic Leather Armor Fabric
(21361,5514,1,1,-1,123311),-- Sealed Gloves of Nightmare Design
(21361,6901,1,1,-1,7301),-- Recipe: Shining Arrow (100%)
(21361,57,3592,7357,0,700000),-- Adena
(21361,12263,1,1,1,283),-- Common Item - Sealed Armor of Nightmare
(21361,12262,1,1,1,283),-- Common Item - Sealed Majestic Plate Armor
(21361,5522,1,1,1,2295),-- Sealed Armor of Nightmare Pattern
(21361,5523,1,1,1,2295),-- Sealed Majestic Plate Armor Pattern
(21361,959,1,1,2,11),-- Scroll: Enchant Weapon (Grade S)
(21361,1867,1,3,2,119815),-- Animal Skin
(21361,1869,2,6,2,67396),-- Iron Ore
(21361,1870,2,6,2,53917),-- Coal
(21361,1871,3,9,2,44931),-- Charcoal
(21361,1872,1,3,2,179723),-- Animal Bone
(21361,6672,1,1,2,22465),-- Deluxe Chest Key - Grade 8
(21361,8732,1,1,200,2246),-- Life Stone: level 76
(21361,8742,1,1,200,562),-- Mid-Grade Life Stone: level 76
(21361,8752,1,1,200,56),-- High-Grade Life Stone: level 76
(21362,5282,1,1,-1,3561),-- Recipe: Greater Blessed Spiritshot (S) Compressed Package(100%)
(21362,5515,1,1,-1,135323),-- Sealed Majestic Gloves Design
(21362,6901,1,1,-1,8012),-- Recipe: Shining Arrow (100%)
(21362,57,3942,8074,0,700000),-- Adena
(21362,12266,1,1,1,413),-- Common Item - Sealed Robe of Nightmare
(21362,12259,1,1,1,413),-- Common Item - Sealed Majestic Robe
(21362,5487,1,1,1,3331),-- Sealed Robe of Nightmare Fabric
(21362,5488,1,1,1,3331),-- Sealed Majestic Robe Fabric
(21362,960,1,1,2,132),-- Scroll: Enchant Armor (Grade S)
(21362,1344,10,30,2,410896),-- Mithril Arrow
(21362,1894,1,1,2,11534),-- Crafted Leather
(21362,4039,1,1,2,10957),-- Mold Glue
(21362,4041,1,1,2,2858),-- Mold Hardener
(21362,4044,1,1,2,10957),-- Thons
(21362,8732,1,1,200,2739),-- Life Stone: level 76
(21362,8742,1,1,200,685),-- Mid-Grade Life Stone: level 76
(21362,8752,1,1,200,69),-- High-Grade Life Stone: level 76
(21363,960,1,1,-1,3078),-- Scroll: Enchant Armor (Grade S)
(21363,1894,1,1,-1,270029),-- Crafted Leather
(21363,4042,1,1,-1,128264),-- Enria
(21363,57,3795,7746,0,700000),-- Adena
(21363,12264,1,1,1,966),-- Common Item - Sealed Gloves of Nightmare
(21363,12267,1,1,1,966),-- Common Item - Sealed Boots of Nightmare
(21363,12257,1,1,1,966),-- Common Item - Sealed Majestic Gloves
(21363,12260,1,1,1,966),-- Common Item - Sealed Majestic Boots
(21363,5502,1,1,1,5999),-- Sealed Boots of Nightmare Lining
(21363,5503,1,1,1,5999),-- Sealed Majestic Boots Lining
(21363,5514,1,1,1,5999),-- Sealed Gloves of Nightmare Design
(21363,5515,1,1,1,5999),-- Sealed Majestic Gloves Design
(21363,959,1,1,2,13),-- Scroll: Enchant Weapon (Grade S)
(21363,1867,1,3,2,210484),-- Animal Skin
(21363,1872,1,3,2,140322),-- Animal Bone
(21363,1882,1,1,2,70161),-- Leather
(21363,1894,1,1,2,11078),-- Crafted Leather
(21363,4042,1,1,2,5262),-- Enria
(21363,8732,1,1,200,2631),-- Life Stone: level 76
(21363,8742,1,1,200,658),-- Mid-Grade Life Stone: level 76
(21363,8752,1,1,200,66),-- High-Grade Life Stone: level 76
(21364,6691,1,1,-1,12779),-- Angel Slayer Blade
(21364,6693,1,1,-1,13011),-- Dragon Hunter Axe Blade
(21364,6694,1,1,-1,13011),-- Saint Spear Blade
(21364,57,2916,5951,0,700000),-- Adena
(21364,12269,1,1,1,660),-- Common Item - Sealed Helm of Nightmare
(21364,12268,1,1,1,944),-- Common Item - Sealed Shield of Nightmare
(21364,12261,1,1,1,660),-- Common Item - Sealed Majestic Circlet
(21364,5495,1,1,1,5525),-- Sealed Shield of Nightmare Fragment
(21364,5527,1,1,1,4350),-- Sealed Helm of Nightmare Design
(21364,5528,1,1,1,4350),-- Sealed Majestic Circlet Design
(21364,960,1,1,2,87),-- Scroll: Enchant Armor (Grade S)
(21364,1344,30,90,2,90957),-- Mithril Arrow
(21364,1868,1,3,2,218296),-- Thread
(21364,1873,1,1,2,87319),-- Silver Nugget
(21364,1889,1,1,2,14553),-- Compound Braid
(21364,4044,1,1,2,7277),-- Thons
(21364,5549,1,1,2,21830),-- Metallic Thread
(21364,8732,1,1,200,1819),-- Life Stone: level 76
(21364,8742,1,1,200,455),-- Mid-Grade Life Stone: level 76
(21364,8752,1,1,200,46),-- High-Grade Life Stone: level 76
(21365,959,1,1,-1,330),-- Scroll: Enchant Weapon (Grade S)
(21365,6688,1,1,-1,17857),-- Forgotten Blade Edge
(21365,6689,1,1,-1,17511),-- Basalt Battlehammer Head
(21365,57,4071,8308,0,700000),-- Adena
(21365,12265,1,1,1,426),-- Common Item - Sealed Leather Armor of Nightmare
(21365,12258,1,1,1,426),-- Common Item - Sealed Majestic Leather Armor
(21365,5480,1,1,1,3420),-- Sealed Leather Armor of Nightmare Fabric
(21365,5481,1,1,1,3420),-- Sealed Majestic Leather Armor Fabric
(21365,959,1,1,2,13),-- Scroll: Enchant Weapon (Grade S)
(21365,1867,1,3,2,150551),-- Animal Skin
(21365,1869,2,6,2,84685),-- Iron Ore
(21365,1870,2,6,2,67748),-- Coal
(21365,1871,3,9,2,56457),-- Charcoal
(21365,1872,7,21,2,32261),-- Animal Bone
(21365,8732,1,1,200,2823),-- Life Stone: level 76
(21365,8742,1,1,200,706),-- Mid-Grade Life Stone: level 76
(21365,8752,1,1,200,70),-- High-Grade Life Stone: level 76
(21366,6698,1,1,-1,175150),-- Sealed Tateossian Earring  Part
(21366,6699,1,1,-1,194352),-- Sealed Tateossian Ring Gem
(21366,6700,1,1,-1,106751),-- Sealed Tateossian Ring Wire
(21366,57,4396,8972,0,700000),-- Adena
(21366,12263,1,1,1,345),-- Common Item - Sealed Armor of Nightmare
(21366,12262,1,1,1,345),-- Common Item - Sealed Majestic Plate Armor
(21366,5522,1,1,1,2803),-- Sealed Armor of Nightmare Pattern
(21366,5523,1,1,1,2803),-- Sealed Majestic Plate Armor Pattern
(21366,960,1,1,2,146),-- Scroll: Enchant Armor (Grade S)
(21366,1344,20,60,2,228636),-- Mithril Arrow
(21366,1894,1,1,2,12836),-- Crafted Leather
(21366,4039,1,1,2,12194),-- Mold Glue
(21366,4041,1,1,2,3181),-- Mold Hardener
(21366,4044,1,1,2,12194),-- Thons
(21366,8732,1,1,200,3049),-- Life Stone: level 76
(21366,8742,1,1,200,762),-- Mid-Grade Life Stone: level 76
(21366,8752,1,1,200,76),-- High-Grade Life Stone: level 76
(21367,6710,1,1,-1,87307),-- Sealed Draconic Leather Helmet Pattern
(21367,6711,1,1,-1,26667),-- Sealed Major Arcana Robe Part
(21367,6712,1,1,-1,76629),-- Sealed Major Arcana Gloves fabric
(21367,57,2653,5416,0,700000),-- Adena
(21367,11975,1,1,1,177),-- Common Item - Soul Bow
(21367,5534,1,1,1,2727),-- Soul Bow Stave
(21367,960,1,1,2,88),-- Scroll: Enchant Armor (Grade S)
(21367,1344,10,30,2,276001),-- Mithril Arrow
(21367,1895,1,1,2,63086),-- Metallic Fiber
(21367,4040,1,1,2,4416),-- Mold Lubricant
(21367,4042,1,1,2,3680),-- Enria
(21367,4043,1,1,2,7360),-- Asofe
(21367,8732,1,1,200,1840),-- Life Stone: level 76
(21367,8742,1,1,200,460),-- Mid-Grade Life Stone: level 76
(21367,8752,1,1,200,46),-- High-Grade Life Stone: level 76
(21368,960,1,1,-1,4349),-- Scroll: Enchant Armor (Grade S)
(21368,1895,1,7,-1,776557),-- Metallic Fiber
(21368,4042,1,1,-1,181197),-- Enria
(21368,57,5359,10941,0,700000),-- Adena
(21368,11973,1,1,1,357),-- Common Item - Soul Separator
(21368,5537,1,1,1,5506),-- Soul Separator Head
(21368,959,1,1,2,16),-- Scroll: Enchant Weapon (Grade S)
(21368,1868,3,9,2,133808),-- Thread
(21368,1873,2,6,2,40142),-- Silver Nugget
(21368,1876,1,1,2,80285),-- Mithril Ore
(21368,1895,1,1,2,114692),-- Metallic Fiber
(21368,4042,1,1,2,6690),-- Enria
(21368,6672,1,1,2,33452),-- Deluxe Chest Key - Grade 8
(21368,8732,1,1,200,3345),-- Life Stone: level 76
(21368,8742,1,1,200,836),-- Mid-Grade Life Stone: level 76
(21368,8752,1,1,200,83),-- High-Grade Life Stone: level 76
(21369,5167,1,1,-1,4268),-- Recipe: Blessed Spiritshot (S) Compressed Package (100%)
(21369,5528,1,1,-1,114809),-- Sealed Majestic Circlet Design
(21369,5529,1,1,-1,26345),-- Dragon Slayer Edge
(21369,57,4725,9675,0,700000),-- Adena
(21369,11976,1,1,1,315),-- Common Item - Tallum Glaive
(21369,5541,1,1,1,4862),-- Tallum Glaive Edge
(21369,960,1,1,2,142),-- Scroll: Enchant Armor (Grade S)
(21369,1344,30,90,2,147734),-- Mithril Arrow
(21369,1868,4,12,2,88640),-- Thread
(21369,1873,1,1,2,141824),-- Silver Nugget
(21369,1889,1,1,2,23637),-- Compound Braid
(21369,4044,1,1,2,11819),-- Thons
(21369,5549,1,1,2,35456),-- Metallic Thread
(21369,8732,1,1,200,2955),-- Life Stone: level 76
(21369,8742,1,1,200,739),-- Mid-Grade Life Stone: level 76
(21369,8752,1,1,200,74),-- High-Grade Life Stone: level 76
(21370,4043,1,1,-1,259321),-- Asofe
(21370,5488,1,1,-1,35032),-- Sealed Majestic Robe Fabric
(21370,5550,1,1,-1,103728),-- Durable Metal Plate
(21370,57,3835,7830,0,700000),-- Adena
(21370,12266,1,1,1,401),-- Common Item - Sealed Robe of Nightmare
(21370,12259,1,1,1,401),-- Common Item - Sealed Majestic Robe
(21370,5487,1,1,1,3234),-- Sealed Robe of Nightmare Fabric
(21370,5488,1,1,1,3234),-- Sealed Majestic Robe Fabric
(21370,959,1,1,2,13),-- Scroll: Enchant Weapon (Grade S)
(21370,1864,1,3,2,319164),-- Stem
(21370,1869,1,3,2,106388),-- Iron Ore
(21370,1880,1,1,2,31916),-- Steel
(21370,4043,1,1,2,10639),-- Asofe
(21370,5550,1,1,2,4256),-- Durable Metal Plate
(21370,8732,1,1,200,2660),-- Life Stone: level 76
(21370,8742,1,1,200,665),-- Mid-Grade Life Stone: level 76
(21370,8752,1,1,200,66),-- High-Grade Life Stone: level 76
(21371,6713,1,1,-1,119352),-- Sealed Major Arcana Boots Design
(21371,6714,1,1,-1,135984),-- Sealed Major Arcana Circlet Pattern
(21371,7579,1,1,-1,18329),-- Draconic Bow Shaft
(21371,57,4132,8436,0,700000),-- Adena
(21371,11973,1,1,1,275),-- Common Item - Soul Separator
(21371,5537,1,1,1,4246),-- Soul Separator Head
(21371,960,1,1,2,138),-- Scroll: Enchant Armor (Grade S)
(21371,1344,10,30,2,429882),-- Mithril Arrow
(21371,1894,1,1,2,12067),-- Crafted Leather
(21371,4039,1,1,2,11464),-- Mold Glue
(21371,4041,1,1,2,2990),-- Mold Hardener
(21371,4044,1,1,2,11464),-- Thons
(21371,8732,1,1,200,2866),-- Life Stone: level 76
(21371,8742,1,1,200,716),-- Mid-Grade Life Stone: level 76
(21371,8752,1,1,200,72),-- High-Grade Life Stone: level 76
(21372,960,1,1,-1,2242),-- Scroll: Enchant Armor (Grade S)
(21372,1876,1,3,-1,560482),-- Mithril Ore
(21372,1895,1,3,-1,800688),-- Metallic Fiber
(21372,57,2763,5640,0,700000),-- Adena
(21372,12266,1,1,1,289),-- Common Item - Sealed Robe of Nightmare
(21372,12259,1,1,1,289),-- Common Item - Sealed Majestic Robe
(21372,5487,1,1,1,2330),-- Sealed Robe of Nightmare Fabric
(21372,5488,1,1,1,2330),-- Sealed Majestic Robe Fabric
(21372,959,1,1,2,9),-- Scroll: Enchant Weapon (Grade S)
(21372,1868,1,3,2,229941),-- Thread
(21372,1873,1,1,2,91976),-- Silver Nugget
(21372,1876,1,1,2,45988),-- Mithril Ore
(21372,1895,1,1,2,65697),-- Metallic Fiber
(21372,4042,1,1,2,3832),-- Enria
(21372,8732,1,1,200,1916),-- Life Stone: level 76
(21372,8742,1,1,200,479),-- Mid-Grade Life Stone: level 76
(21372,8752,1,1,200,48),-- High-Grade Life Stone: level 76
(21373,959,1,1,-1,453),-- Scroll: Enchant Weapon (Grade S)
(21373,1895,1,7,-1,808936),-- Metallic Fiber
(21373,4040,1,1,-1,226502),-- Mold Lubricant
(21373,57,5568,11414,0,700000),-- Adena
(21373,12266,1,1,1,584),-- Common Item - Sealed Robe of Nightmare
(21373,12259,1,1,1,584),-- Common Item - Sealed Majestic Robe
(21373,5487,1,1,1,4707),-- Sealed Robe of Nightmare Fabric
(21373,5488,1,1,1,4707),-- Sealed Majestic Robe Fabric
(21373,959,1,1,2,21),-- Scroll: Enchant Weapon (Grade S)
(21373,1895,1,1,2,149342),-- Metallic Fiber
(21373,4040,1,1,2,10454),-- Mold Lubricant
(21373,4042,1,1,2,8712),-- Enria
(21373,4043,1,1,2,17423),-- Asofe
(21373,8732,1,1,200,4356),-- Life Stone: level 76
(21373,8742,1,1,200,1089),-- Mid-Grade Life Stone: level 76
(21373,8752,1,1,200,109),-- High-Grade Life Stone: level 76
(21374,6707,1,1,-1,29364),-- Sealed Draconic Leather Armor Part
(21374,6708,1,1,-1,84378),-- Sealed Draconic Leather Gloves Fabric
(21374,6709,1,1,-1,84378),-- Sealed Draconic Leather Boots Design
(21374,57,2916,5970,0,700000),-- Adena
(21374,11976,1,1,1,195),-- Common Item - Tallum Glaive
(21374,5541,1,1,1,3000),-- Tallum Glaive Edge
(21374,960,1,1,2,97),-- Scroll: Enchant Armor (Grade S)
(21374,1868,1,3,2,243130),-- Thread
(21374,1873,1,1,2,97252),-- Silver Nugget
(21374,1876,1,1,2,48626),-- Mithril Ore
(21374,1895,1,1,2,69466),-- Metallic Fiber
(21374,4042,1,1,2,4052),-- Enria
(21374,8732,1,1,200,2026),-- Life Stone: level 76
(21374,8742,1,1,200,507),-- Mid-Grade Life Stone: level 76
(21374,8752,1,1,200,51),-- High-Grade Life Stone: level 76
(21375,960,1,1,-1,2285),-- Scroll: Enchant Armor (Grade S)
(21375,1877,1,1,-1,228476),-- Adamantite Nugget
(21375,4040,1,1,-1,114238),-- Mold Lubricant
(21375,57,2811,5754,0,700000),-- Adena
(21375,12265,1,1,1,295),-- Common Item - Sealed Leather Armor of Nightmare
(21375,12258,1,1,1,295),-- Common Item - Sealed Majestic Leather Armor
(21375,5480,1,1,1,2366),-- Sealed Leather Armor of Nightmare Fabric
(21375,5481,1,1,1,2366),-- Sealed Majestic Leather Armor Fabric
(21375,959,1,1,2,9),-- Scroll: Enchant Weapon (Grade S)
(21375,1866,1,1,2,156223),-- Suede
(21375,1871,1,1,2,234334),-- Charcoal
(21375,1877,1,1,2,9373),-- Adamantite Nugget
(21375,4040,1,1,2,4687),-- Mold Lubricant
(21375,4041,1,1,2,2038),-- Mold Hardener
(21375,8732,1,1,200,1953),-- Life Stone: level 76
(21375,8742,1,1,200,488),-- Mid-Grade Life Stone: level 76
(21375,8752,1,1,200,49),-- High-Grade Life Stone: level 76
(21376,1875,1,1,-1,669404),-- Stone of Purity
(21376,4041,1,1,-1,87314),-- Mold Hardener
(21376,5544,1,1,-1,27515),-- Branch of The Mother Tree Head
(21376,57,4952,10108,0,700000),-- Adena
(21376,11951,1,1,1,510),-- Common Item - Bloody Orchid
(21376,5536,1,1,1,6307),-- Bloody Orchid Head
(21376,1867,1,3,2,183086),-- Animal Skin
(21376,1872,4,12,2,68657),-- Animal Bone
(21376,1875,1,1,2,27463),-- Stone of Purity
(21376,1881,1,1,2,54926),-- Coarse Bone Powder
(21376,3036,1,1,2,183),-- Recipe: Spiritshot S
(21376,4041,1,1,2,3582),-- Mold Hardener
(21376,8732,1,1,200,3433),-- Life Stone: level 76
(21376,8742,1,1,200,858),-- Mid-Grade Life Stone: level 76
(21376,8752,1,1,200,86),-- High-Grade Life Stone: level 76
(21377,1808,1,1,-1,4368),-- Recipe: Soulshot: S Grade
(21377,5545,1,1,-1,26960),-- Dark Legion\'s Edge Blade
(21377,5546,1,1,-1,29613),-- Sword of Miracles Edge
(21377,57,4847,9892,0,700000),-- Adena
(21377,12227,1,1,1,659),-- Common Item - Sealed Dark Crystal breastplate
(21377,12220,1,1,1,1052),-- Common Item - Sealed Dark Crystal Gaiters
(21377,12233,1,1,1,406),-- Common Item - Sealed Tallum Plate Armor
(21377,5520,1,1,1,3900),-- Sealed Dark Crystal Breastplate Pattern
(21377,5521,1,1,1,2752),-- Sealed Tallum Plate Armor Pattern
(21377,5524,1,1,1,5960),-- Sealed Dark Crystal Gaiters Pattern
(21377,1344,150,450,2,30237),-- Mithril Arrow
(21377,1868,4,12,2,90711),-- Thread
(21377,1873,1,1,2,145137),-- Silver Nugget
(21377,1876,1,1,2,72569),-- Mithril Ore
(21377,1895,1,1,2,103669),-- Metallic Fiber
(21377,3957,1,1,2,161),-- Recipe: Blessed Spiritshot S
(21377,4042,1,1,2,6047),-- Enria
(21377,8732,1,1,200,3024),-- Life Stone: level 76
(21377,8742,1,1,200,756),-- Mid-Grade Life Stone: level 76
(21377,8752,1,1,200,76),-- High-Grade Life Stone: level 76
(21378,1889,1,1,-1,804585),-- Compound Braid
(21378,5282,1,1,-1,5364),-- Recipe: Greater Blessed Spiritshot (S) Compressed Package(100%)
(21378,5514,1,1,-1,203830),-- Sealed Gloves of Nightmare Design
(21378,57,5950,12144,0,700000),-- Adena
(21378,11973,1,1,1,396),-- Common Item - Soul Separator
(21378,5537,1,1,1,6113),-- Soul Separator Head
(21378,959,1,1,2,20),-- Scroll: Enchant Weapon (Grade S)
(21378,1868,3,9,2,165043),-- Thread
(21378,1873,1,1,2,198052),-- Silver Nugget
(21378,1889,1,1,2,33009),-- Compound Braid
(21378,4044,1,1,2,16504),-- Thons
(21378,5549,1,1,2,49513),-- Metallic Thread
(21378,8732,1,1,200,4126),-- Life Stone: level 76
(21378,8742,1,1,200,1032),-- Mid-Grade Life Stone: level 76
(21378,8752,1,1,200,103),-- High-Grade Life Stone: level 76
(21379,5515,1,1,-1,171095),-- Sealed Majestic Gloves Design
(21379,5522,1,1,-1,34500),-- Sealed Armor of Nightmare Pattern
(21379,6901,1,1,-1,10131),-- Recipe: Shining Arrow (100%)
(21379,57,4995,10193,0,700000),-- Adena
(21379,12263,1,1,1,392),-- Common Item - Sealed Armor of Nightmare
(21379,12262,1,1,1,392),-- Common Item - Sealed Majestic Plate Armor
(21379,5522,1,1,1,3184),-- Sealed Armor of Nightmare Pattern
(21379,5523,1,1,1,3184),-- Sealed Majestic Plate Armor Pattern
(21379,960,1,1,2,149),-- Scroll: Enchant Armor (Grade S)
(21379,1344,40,120,2,116890),-- Mithril Arrow
(21379,1864,5,15,2,74810),-- Stem
(21379,1865,3,9,2,62342),-- Varnish
(21379,1866,3,9,2,35624),-- Suede
(21379,1868,12,36,2,31171),-- Thread
(21379,1873,1,1,2,149620),-- Silver Nugget
(21379,8732,1,1,200,3117),-- Life Stone: level 76
(21379,8742,1,1,200,779),-- Mid-Grade Life Stone: level 76
(21379,8752,1,1,200,78),-- High-Grade Life Stone: level 76
(21380,1808,1,1,-1,4591),-- Recipe: Soulshot: S Grade
(21380,5481,1,1,-1,46347),-- Sealed Majestic Leather Armor Fabric
(21380,5523,1,1,-1,35175),-- Sealed Majestic Plate Armor Pattern
(21380,57,5093,10393,0,700000),-- Adena
(21380,11974,1,1,1,85),-- Common Item - Elysian
(21380,11970,1,1,1,85),-- Common Item - Branch of The Mother Tree
(21380,8342,1,1,1,1308),-- Flaming Dragon Skull Piece
(21380,11969,1,1,1,85),-- Common Item - Flaming Dragon Skull
(21380,8349,1,1,1,1307),-- Doom Crusher Head
(21380,11966,1,1,1,85),-- Common Item - Doom Crusher
(21380,5533,1,1,1,1308),-- Elysian Head
(21380,5544,1,1,1,1306),-- Branch of The Mother Tree Head
(21380,959,1,1,2,17),-- Scroll: Enchant Weapon (Grade S)
(21380,1867,1,3,2,188330),-- Animal Skin
(21380,1869,2,6,2,105936),-- Iron Ore
(21380,1870,2,6,2,84749),-- Coal
(21380,1871,3,9,2,70624),-- Charcoal
(21380,1872,7,21,2,40356),-- Animal Bone
(21380,8732,1,1,200,3531),-- Life Stone: level 76
(21380,8742,1,1,200,883),-- Mid-Grade Life Stone: level 76
(21380,8752,1,1,200,88),-- High-Grade Life Stone: level 76
(21381,3957,1,1,-1,5018),-- Recipe: Blessed Spiritshot S
(21381,5157,1,1,-1,5018),-- Recipe: Soulshot (S) Compressed Package (100%)
(21381,5495,1,1,-1,171455),-- Sealed Shield of Nightmare Fragment
(21381,57,5566,11364,0,700000),-- Adena
(21381,11976,1,1,1,371),-- Common Item - Tallum Glaive
(21381,5541,1,1,1,5716),-- Tallum Glaive Edge
(21381,960,1,1,2,167),-- Scroll: Enchant Armor (Grade S)
(21381,1344,40,120,2,130283),-- Mithril Arrow
(21381,1867,5,15,2,55587),-- Animal Skin
(21381,1872,1,3,2,185292),-- Animal Bone
(21381,1882,1,1,2,92646),-- Leather
(21381,1894,1,1,2,14628),-- Crafted Leather
(21381,4042,1,1,2,6948),-- Enria
(21381,8732,1,1,200,3474),-- Life Stone: level 76
(21381,8742,1,1,200,869),-- Mid-Grade Life Stone: level 76
(21381,8752,1,1,200,87),-- High-Grade Life Stone: level 76
(21382,1889,1,1,-1,801799),-- Compound Braid
(21382,5502,1,1,-1,203124),-- Sealed Boots of Nightmare Lining
(21382,5549,1,3,-1,601349),-- Metallic Thread
(21382,57,5929,12104,0,700000),-- Adena
(21382,12265,1,1,1,620),-- Common Item - Sealed Leather Armor of Nightmare
(21382,12258,1,1,1,620),-- Common Item - Sealed Majestic Leather Armor
(21382,5480,1,1,1,4982),-- Sealed Leather Armor of Nightmare Fabric
(21382,5481,1,1,1,4982),-- Sealed Majestic Leather Armor Fabric
(21382,959,1,1,2,20),-- Scroll: Enchant Weapon (Grade S)
(21382,1868,3,9,2,164472),-- Thread
(21382,1873,1,1,2,197366),-- Silver Nugget
(21382,1889,1,1,2,32895),-- Compound Braid
(21382,4044,1,1,2,16447),-- Thons
(21382,5549,1,1,2,49341),-- Metallic Thread
(21382,8732,1,1,200,4112),-- Life Stone: level 76
(21382,8742,1,1,200,1028),-- Mid-Grade Life Stone: level 76
(21382,8752,1,1,200,102),-- High-Grade Life Stone: level 76
(21383,5162,1,1,-1,5714),-- Recipe: Spiritshot (S) Compressed Package (100%)
(21383,5503,1,1,-1,217116),-- Sealed Majestic Boots Lining
(21383,5514,1,1,-1,217116),-- Sealed Gloves of Nightmare Design
(21383,57,6337,12938,0,700000),-- Adena
(21383,12263,1,1,1,498),-- Common Item - Sealed Armor of Nightmare
(21383,12262,1,1,1,498),-- Common Item - Sealed Majestic Plate Armor
(21383,5522,1,1,1,4041),-- Sealed Armor of Nightmare Pattern
(21383,5523,1,1,1,4041),-- Sealed Majestic Plate Armor Pattern
(21383,960,1,1,2,190),-- Scroll: Enchant Armor (Grade S)
(21383,1344,40,120,2,148332),-- Mithril Arrow
(21383,1864,5,15,2,94932),-- Stem
(21383,1865,3,9,2,79110),-- Varnish
(21383,1866,3,9,2,45206),-- Suede
(21383,1868,12,36,2,39555),-- Thread
(21383,1873,4,12,2,21096),-- Silver Nugget
(21383,8732,1,1,200,3955),-- Life Stone: level 76
(21383,8742,1,1,200,989),-- Mid-Grade Life Stone: level 76
(21383,8752,1,1,200,99),-- High-Grade Life Stone: level 76
(21384,1875,1,1,-1,798032),-- Stone of Purity
(21384,4041,1,1,-1,104091),-- Mold Hardener
(21384,5533,1,1,-1,32835),-- Elysian Head
(21384,57,5890,12060,0,700000),-- Adena
(21384,12265,1,1,1,617),-- Common Item - Sealed Leather Armor of Nightmare
(21384,12258,1,1,1,617),-- Common Item - Sealed Majestic Leather Armor
(21384,5480,1,1,1,4958),-- Sealed Leather Armor of Nightmare Fabric
(21384,5481,1,1,1,4958),-- Sealed Majestic Leather Armor Fabric
(21384,959,1,1,2,20),-- Scroll: Enchant Weapon (Grade S)
(21384,1867,1,3,2,218265),-- Animal Skin
(21384,1872,4,12,2,81849),-- Animal Bone
(21384,1875,1,1,2,32740),-- Stone of Purity
(21384,1881,1,1,2,65479),-- Coarse Bone Powder
(21384,4041,1,1,2,4271),-- Mold Hardener
(21384,8732,1,1,200,4092),-- Life Stone: level 76
(21384,8742,1,1,200,1023),-- Mid-Grade Life Stone: level 76
(21384,8752,1,1,200,102),-- High-Grade Life Stone: level 76
(21385,5272,1,1,-1,5032),-- Recipe: Greater Soulshot (S) Compressed Package(100%)
(21385,5277,1,1,-1,5032),-- Recipe: Greater Spiritshot (S) Compressed Package(100%)
(21385,5534,1,1,-1,31083),-- Soul Bow Stave
(21385,57,5571,11407,0,700000),-- Adena
(21385,12263,1,1,1,438),-- Common Item - Sealed Armor of Nightmare
(21385,12262,1,1,1,438),-- Common Item - Sealed Majestic Plate Armor
(21385,5522,1,1,1,3559),-- Sealed Armor of Nightmare Pattern
(21385,5523,1,1,1,3559),-- Sealed Majestic Plate Armor Pattern
(21385,960,1,1,2,167),-- Scroll: Enchant Armor (Grade S)
(21385,1344,150,450,2,34837),-- Mithril Arrow
(21385,1868,4,12,2,104511),-- Thread
(21385,1873,3,9,2,27870),-- Silver Nugget
(21385,1876,1,1,2,83609),-- Mithril Ore
(21385,1895,1,1,2,119441),-- Metallic Fiber
(21385,4042,1,1,2,6968),-- Enria
(21385,8732,1,1,200,3484),-- Life Stone: level 76
(21385,8742,1,1,200,871),-- Mid-Grade Life Stone: level 76
(21385,8752,1,1,200,87),-- High-Grade Life Stone: level 76
(21386,1877,1,1,-1,467422),-- Adamantite Nugget
(21386,4041,1,1,-1,101613),-- Mold Hardener
(21386,5537,1,1,-1,32059),-- Soul Separator Head
(21386,57,5749,11773,0,700000),-- Adena
(21386,12266,1,1,1,603),-- Common Item - Sealed Robe of Nightmare
(21386,12259,1,1,1,603),-- Common Item - Sealed Majestic Robe
(21386,5487,1,1,1,4857),-- Sealed Robe of Nightmare Fabric
(21386,5488,1,1,1,4857),-- Sealed Majestic Robe Fabric
(21386,959,1,1,2,19),-- Scroll: Enchant Weapon (Grade S)
(21386,1866,1,3,2,106535),-- Suede
(21386,1871,1,3,2,239703),-- Charcoal
(21386,1877,1,1,2,19176),-- Adamantite Nugget
(21386,4040,1,1,2,9588),-- Mold Lubricant
(21386,4041,1,1,2,4169),-- Mold Hardener
(21386,8732,1,1,200,3995),-- Life Stone: level 76
(21386,8742,1,1,200,999),-- Mid-Grade Life Stone: level 76
(21386,8752,1,1,200,100),-- High-Grade Life Stone: level 76
(21387,1895,1,7,-1,749613),-- Metallic Fiber
(21387,4042,1,1,-1,174910),-- Enria
(21387,5522,1,1,-1,35740),-- Sealed Armor of Nightmare Pattern
(21387,57,5163,10575,0,700000),-- Adena
(21387,12350,1,1,1,1193),-- Common Item - Sealed Majestic Necklace
(21387,12352,1,1,1,1589),-- Common Item - Sealed Majestic Earring
(21387,12351,1,1,1,2383),-- Common Item - Sealed Majestic Ring
(21387,6342,1,1,1,14630),-- Sealed Majestic Earring Gemstone
(21387,6344,1,1,1,9467),-- Sealed Majestic Necklace Beads
(21387,6346,1,1,1,21026),-- Sealed Majestic Ring Gemstone
(21387,959,1,1,2,17),-- Scroll: Enchant Weapon (Grade S)
(21387,1868,3,9,2,143516),-- Thread
(21387,1873,2,6,2,43055),-- Silver Nugget
(21387,1876,1,1,2,86109),-- Mithril Ore
(21387,1895,1,1,2,123013),-- Metallic Fiber
(21387,4042,1,1,2,7176),-- Enria
(21387,8732,1,1,200,3588),-- Life Stone: level 76
(21387,8742,1,1,200,897),-- Mid-Grade Life Stone: level 76
(21387,8752,1,1,200,90),-- High-Grade Life Stone: level 76
(21388,1808,1,1,-1,7056),-- Recipe: Soulshot: S Grade
(21388,5523,1,1,-1,54064),-- Sealed Majestic Plate Armor Pattern
(21388,5527,1,1,-1,189805),-- Sealed Helm of Nightmare Design
(21388,57,7810,15997,0,700000),-- Adena
(21388,12264,1,1,1,1994),-- Common Item - Sealed Gloves of Nightmare
(21388,12267,1,1,1,1994),-- Common Item - Sealed Boots of Nightmare
(21388,12257,1,1,1,1994),-- Common Item - Sealed Majestic Gloves
(21388,12260,1,1,1,1994),-- Common Item - Sealed Majestic Boots
(21388,5502,1,1,1,12375),-- Sealed Boots of Nightmare Lining
(21388,5503,1,1,1,12375),-- Sealed Majestic Boots Lining
(21388,5514,1,1,1,12375),-- Sealed Gloves of Nightmare Design
(21388,5515,1,1,1,12375),-- Sealed Majestic Gloves Design
(21388,960,1,1,2,235),-- Scroll: Enchant Armor (Grade S)
(21388,1344,40,120,2,183175),-- Mithril Arrow
(21388,1867,9,27,2,43419),-- Animal Skin
(21388,1872,5,15,2,78155),-- Animal Bone
(21388,1875,1,1,2,39077),-- Stone of Purity
(21388,1881,1,1,2,78155),-- Coarse Bone Powder
(21388,4041,1,1,2,5097),-- Mold Hardener
(21388,8732,1,1,200,4885),-- Life Stone: level 76
(21388,8742,1,1,200,1221),-- Mid-Grade Life Stone: level 76
(21388,8752,1,1,200,122),-- High-Grade Life Stone: level 76
(21389,959,1,1,-1,580),-- Scroll: Enchant Weapon (Grade S)
(21389,6690,1,1,-1,31391),-- Imperial Staff Head
(21389,6691,1,1,-1,31331),-- Angel Slayer Blade
(21389,57,7149,14591,0,700000),-- Adena
(21389,11964,1,1,1,159),-- Common Item - Dark Legion's Edge
(21389,11971,1,1,1,159),-- Common Item - Sword of Miracles 
(21389,11968,1,1,1,159),-- Common Item - Dragon Slayer
(21389,5529,1,1,1,2447),-- Dragon Slayer Edge
(21389,5545,1,1,1,2447),-- Dark Legion\'s Edge Blade
(21389,5546,1,1,1,2688),-- Sword of Miracles Edge
(21389,959,1,1,2,24),-- Scroll: Enchant Weapon (Grade S)
(21389,1864,4,12,2,148669),-- Stem
(21389,1865,2,6,2,118935),-- Varnish
(21389,1866,3,9,2,66075),-- Suede
(21389,1868,10,30,2,56636),-- Thread
(21389,1873,4,12,2,29734),-- Silver Nugget
(21389,8732,1,1,200,4956),-- Life Stone: level 76
(21389,8742,1,1,200,1239),-- Mid-Grade Life Stone: level 76
(21389,8752,1,1,200,123),-- High-Grade Life Stone: level 76
(21390,6701,1,1,-1,89988),-- Sealed Imperial Crusader Breastplate Part
(21390,6702,1,1,-1,115839),-- Sealed Imperial Crusader Gaiters Pattern
(21390,6703,1,1,-1,240650),-- Sealed Imperial Crusader Gauntlets Design
(21390,57,8333,17007,0,700000),-- Adena
(21390,12350,1,1,1,1921),-- Common Item - Sealed Majestic Necklace
(21390,12352,1,1,1,2559),-- Common Item - Sealed Majestic Earring
(21390,12351,1,1,1,3838),-- Common Item - Sealed Majestic Ring
(21390,6342,1,1,1,23562),-- Sealed Majestic Earring Gemstone
(21390,6344,1,1,1,15248),-- Sealed Majestic Necklace Beads
(21390,6346,1,1,1,33864),-- Sealed Majestic Ring Gemstone
(21390,960,1,1,2,250),-- Scroll: Enchant Armor (Grade S)
(21390,1344,40,120,2,195023),-- Mithril Arrow
(21390,1867,9,27,2,46228),-- Animal Skin
(21390,1872,5,15,2,83210),-- Animal Bone
(21390,1875,1,1,2,41605),-- Stone of Purity
(21390,1881,1,1,2,83210),-- Coarse Bone Powder
(21390,4041,1,1,2,5427),-- Mold Hardener
(21390,8732,1,1,200,5201),-- Life Stone: level 76
(21390,8742,1,1,200,1300),-- Mid-Grade Life Stone: level 76
(21390,8752,1,1,200,130),-- High-Grade Life Stone: level 76
(21391,6695,1,1,-1,28824),-- Demon Splinter Blade
(21391,6696,1,1,-1,29845),-- Heavens Divider Edge
(21391,6697,1,1,-1,28824),-- Arcana Mace Head
(21391,57,6703,13681,0,700000),-- Adena
(21391,11970,1,1,1,112),-- Common Item - Branch of The Mother Tree
(21391,11974,1,1,1,112),-- Common Item - Elysian
(21391,11969,1,1,1,112),-- Common Item - Flaming Dragon Skull
(21391,11966,1,1,1,112),-- Common Item - Doom Crusher
(21391,8342,1,1,1,1721),-- Flaming Dragon Skull Piece
(21391,8349,1,1,1,1720),-- Doom Crusher Head
(21391,5533,1,1,1,1721),-- Elysian Head
(21391,5544,1,1,1,1719),-- Branch of The Mother Tree Head
(21391,960,1,1,2,201),-- Scroll: Enchant Armor (Grade S)
(21391,1344,40,120,2,156826),-- Mithril Arrow
(21391,1867,13,39,2,24782),-- Animal Skin
(21391,1869,2,6,2,100369),-- Iron Ore
(21391,1870,3,9,2,83641),-- Coal
(21391,1871,3,9,2,71692),-- Charcoal
(21391,1872,8,24,2,41820),-- Animal Bone
(21391,8732,1,1,200,4182),-- Life Stone: level 76
(21391,8742,1,1,200,1045),-- Mid-Grade Life Stone: level 76
(21391,8752,1,1,200,105),-- High-Grade Life Stone: level 76
(21392,959,1,1,-1,671),-- Scroll: Enchant Weapon (Grade S)
(21392,4044,1,1,-1,558789),-- Thons
(21392,5549,1,3,-1,838184),-- Metallic Thread
(21392,57,8265,16868,0,700000),-- Adena
(21392,12264,1,1,1,2105),-- Common Item - Sealed Gloves of Nightmare
(21392,12267,1,1,1,2105),-- Common Item - Sealed Boots of Nightmare
(21392,12257,1,1,1,2105),-- Common Item - Sealed Majestic Gloves
(21392,12260,1,1,1,2105),-- Common Item - Sealed Majestic Boots
(21392,5502,1,1,1,13067),-- Sealed Boots of Nightmare Lining
(21392,5503,1,1,1,13067),-- Sealed Majestic Boots Lining
(21392,5514,1,1,1,13067),-- Sealed Gloves of Nightmare Design
(21392,5515,1,1,1,13067),-- Sealed Majestic Gloves Design
(21392,959,1,1,2,27),-- Scroll: Enchant Weapon (Grade S)
(21392,1868,3,9,2,229247),-- Thread
(21392,1873,2,6,2,68774),-- Silver Nugget
(21392,1889,1,1,2,48849),-- Compound Braid
(21392,4044,1,1,2,22925),-- Thons
(21392,5549,1,1,2,68774),-- Metallic Thread
(21392,8732,1,1,200,5731),-- Life Stone: level 76
(21392,8742,1,1,200,1433),-- Mid-Grade Life Stone: level 76
(21392,8752,1,1,200,143),-- High-Grade Life Stone: level 76
(21393,959,1,1,-1,604),-- Scroll: Enchant Weapon (Grade S)
(21393,1877,1,1,-1,603958),-- Adamantite Nugget
(21393,4041,1,1,-1,131295),-- Mold Hardener
(21393,57,7443,15195,0,700000),-- Adena
(21393,11976,1,1,1,496),-- Common Item - Tallum Glaive
(21393,5541,1,1,1,7644),-- Tallum Glaive Edge
(21393,959,1,1,2,25),-- Scroll: Enchant Weapon (Grade S)
(21393,1866,1,3,2,137654),-- Suede
(21393,1871,1,3,2,309722),-- Charcoal
(21393,1877,1,1,2,24778),-- Adamantite Nugget
(21393,4040,1,1,2,12389),-- Mold Lubricant
(21393,4041,1,1,2,5386),-- Mold Hardener
(21393,8732,1,1,200,5162),-- Life Stone: level 76
(21393,8742,1,1,200,1290),-- Mid-Grade Life Stone: level 76
(21393,8752,1,1,200,129),-- High-Grade Life Stone: level 76
(21394,1808,1,1,-1,5069),-- Recipe: Soulshot: S Grade
(21394,3036,1,1,-1,5069),-- Recipe: Spiritshot S
(21394,5527,1,1,-1,136356),-- Sealed Helm of Nightmare Design
(21394,57,5623,11476,0,700000),-- Adena
(21394,11967,1,1,1,374),-- Common Item - Dragon Grinder
(21394,5538,1,1,1,5776),-- Dragon Grinder Edge
(21394,960,1,1,2,187),-- Scroll: Enchant Armor (Grade S)
(21394,1344,20,60,2,292429),-- Mithril Arrow
(21394,1894,1,1,2,16417),-- Crafted Leather
(21394,4039,1,1,2,15596),-- Mold Glue
(21394,4041,1,1,2,4069),-- Mold Hardener
(21394,4044,1,1,2,15596),-- Thons
(21394,8732,1,1,200,3899),-- Life Stone: level 76
(21394,8742,1,1,200,975),-- Mid-Grade Life Stone: level 76
(21394,8752,1,1,200,97),-- High-Grade Life Stone: level 76
(21395,960,1,1,-1,5679),-- Scroll: Enchant Armor (Grade S)
(21395,1894,1,1,-1,524503),-- Crafted Leather
(21395,4039,1,1,-1,498278),-- Mold Glue
(21395,57,7372,15047,0,700000),-- Adena
(21395,11967,1,1,1,491),-- Common Item - Dragon Grinder
(21395,5538,1,1,1,7569),-- Dragon Grinder Edge
(21395,959,1,1,2,28),-- Scroll: Enchant Weapon (Grade S)
(21395,1894,1,1,2,24208),-- Crafted Leather
(21395,4039,1,1,2,22997),-- Mold Glue
(21395,4041,1,1,2,5999),-- Mold Hardener
(21395,4044,1,1,2,22997),-- Thons
(21395,8732,1,1,200,5749),-- Life Stone: level 76
(21395,8742,1,1,200,1437),-- Mid-Grade Life Stone: level 76
(21395,8752,1,1,200,144),-- High-Grade Life Stone: level 76
(21396,3036,1,1,-1,2766),-- Recipe: Spiritshot S
(21396,4040,1,1,-1,124452),-- Mold Lubricant
(21396,6342,1,1,-1,140959),-- Sealed Majestic Earring Gemstone
(21396,57,3069,6264,0,700000),-- Adena
(21396,11946,1,1,1,79),-- Common Item - Dasparion\'s Staff
(21396,11949,1,1,1,79),-- Common Item - Meteor Shower
(21396,11958,1,1,1,79),-- Common Item - Destroyer Hammer
(21396,11953,1,1,1,79),-- Common Item - Spiritual Eye
(21396,5532,1,1,1,968),-- Meteor Shower Head
(21396,5543,1,1,1,978),-- Dasparion\'s Staff Edge
(21396,8346,1,1,1,968),-- Hammer Piece of Destroyer
(21396,8341,1,1,1,967),-- Spiritual Eye Piece
(21396,1866,1,1,2,170191),-- Suede
(21396,1871,1,3,2,255287),-- Charcoal
(21396,1877,1,1,2,10212),-- Adamantite Nugget
(21396,4040,1,1,2,5106),-- Mold Lubricant
(21396,4041,1,1,2,2220),-- Mold Hardener
(21396,5157,1,1,2,53),-- Recipe: Soulshot (S) Compressed Package (100%)
(21396,8732,1,1,200,2128),-- Life Stone: level 76
(21396,8742,1,1,200,532),-- Mid-Grade Life Stone: level 76
(21396,8752,1,1,200,144),-- High-Grade Life Stone: level 76
(21397,3036,1,1,-1,2696),-- Recipe: Spiritshot S
(21397,4040,1,1,-1,121321),-- Mold Lubricant
(21397,6342,1,1,-1,137412),-- Sealed Majestic Earring Gemstone
(21397,57,2992,6106,0,700000),-- Adena
(21397,11946,1,1,1,77),-- Common Item - Dasparion\'s Staff
(21397,11949,1,1,1,77),-- Common Item - Meteor Shower
(21397,8341,1,1,1,943),-- Spiritual Eye Piece
(21397,11958,1,1,1,77),-- Common Item - Destroyer Hammer
(21397,11953,1,1,1,77),-- Common Item - Spiritual Eye
(21397,5532,1,1,1,944),-- Meteor Shower Head
(21397,5543,1,1,1,953),-- Dasparion\'s Staff Edge
(21397,8346,1,1,1,944),-- Hammer Piece of Destroyer
(21397,1866,1,1,2,165909),-- Suede
(21397,1871,1,1,2,248863),-- Charcoal
(21397,1877,1,1,2,9955),-- Adamantite Nugget
(21397,4040,1,1,2,4977),-- Mold Lubricant
(21397,4041,1,1,2,2164),-- Mold Hardener
(21397,5157,1,1,2,110),-- Recipe: Soulshot (S) Compressed Package (100%)
(21397,8732,1,1,200,2074),-- Life Stone: level 76
(21397,8742,1,1,200,519),-- Mid-Grade Life Stone: level 76
(21397,8752,1,1,200,52),-- High-Grade Life Stone: level 76
(21398,5157,1,1,-1,5119),-- Recipe: Soulshot (S) Compressed Package (100%)
(21398,5480,1,1,-1,51685),-- Sealed Leather Armor of Nightmare Fabric
(21398,6346,1,2,-1,375006),-- Sealed Majestic Ring Gemstone
(21398,57,5681,11595,0,700000),-- Adena
(21398,11960,1,1,1,585),-- Common Item - Halberd
(21398,5542,1,1,1,7171),-- Halberd Edge
(21398,1895,1,1,2,151890),-- Metallic Fiber
(21398,4040,1,1,2,10632),-- Mold Lubricant
(21398,4042,1,1,2,8860),-- Enria
(21398,4043,1,1,2,17721),-- Asofe
(21398,5167,1,1,2,236),-- Recipe: Blessed Spiritshot (S) Compressed Package (100%)
(21398,8732,1,1,200,4430),-- Life Stone: level 76
(21398,8742,1,1,200,1108),-- Mid-Grade Life Stone: level 76
(21398,8752,1,1,200,111),-- High-Grade Life Stone: level 76
(21399,5157,1,1,-1,4493),-- Recipe: Soulshot (S) Compressed Package (100%)
(21399,5480,1,1,-1,45358),-- Sealed Leather Armor of Nightmare Fabric
(21399,6346,1,1,-1,329100),-- Sealed Majestic Ring Gemstone
(21399,57,4986,10175,0,700000),-- Adena
(21399,11960,1,1,1,514),-- Common Item - Halberd
(21399,5542,1,1,1,6293),-- Halberd Edge
(21399,1895,1,1,2,133296),-- Metallic Fiber
(21399,4040,1,1,2,9331),-- Mold Lubricant
(21399,4042,1,1,2,7776),-- Enria
(21399,4043,1,1,2,15551),-- Asofe
(21399,5167,1,1,2,207),-- Recipe: Blessed Spiritshot (S) Compressed Package (100%)
(21399,8732,1,1,200,3888),-- Life Stone: level 76
(21399,8742,1,1,200,972),-- Mid-Grade Life Stone: level 76
(21399,8752,1,1,200,97),-- High-Grade Life Stone: level 76
(21400,1876,1,3,-1,943530),-- Mithril Ore
(21400,4042,1,1,-1,157255),-- Enria
(21400,5528,1,1,-1,112808),-- Sealed Majestic Circlet Design
(21400,57,4652,9494,0,700000),-- Adena
(21400,11976,1,1,1,310),-- Common Item - Tallum Glaive
(21400,5541,1,1,1,4777),-- Tallum Glaive Edge
(21400,959,1,1,2,15),-- Scroll: Enchant Weapon (Grade S)
(21400,1868,3,9,2,129030),-- Thread
(21400,1873,1,1,2,154836),-- Silver Nugget
(21400,1876,1,1,2,77418),-- Mithril Ore
(21400,1895,1,1,2,110597),-- Metallic Fiber
(21400,4042,1,1,2,6451),-- Enria
(21400,8732,1,1,200,3226),-- Life Stone: level 76
(21400,8742,1,1,200,807),-- Mid-Grade Life Stone: level 76
(21400,8752,1,1,200,81),-- High-Grade Life Stone: level 76
(21401,1876,1,3,-1,830263),-- Mithril Ore
(21401,4042,1,1,-1,138377),-- Enria
(21401,5528,1,1,-1,99266),-- Sealed Majestic Circlet Design
(21401,57,4094,8354,0,700000),-- Adena
(21401,11976,1,1,1,272),-- Common Item - Tallum Glaive
(21401,5541,1,1,1,4204),-- Tallum Glaive Edge
(21401,959,1,1,2,14),-- Scroll: Enchant Weapon (Grade S)
(21401,1868,3,9,2,113540),-- Thread
(21401,1873,1,1,2,136248),-- Silver Nugget
(21401,1876,1,1,2,68124),-- Mithril Ore
(21401,1895,1,1,2,97320),-- Metallic Fiber
(21401,4042,1,1,2,5677),-- Enria
(21401,8732,1,1,200,2838),-- Life Stone: level 76
(21401,8742,1,1,200,710),-- Mid-Grade Life Stone: level 76
(21401,8752,1,1,200,71),-- High-Grade Life Stone: level 76
(21402,4044,1,1,-1,285564),-- Thons
(21402,5157,1,1,-1,3808),-- Recipe: Soulshot (S) Compressed Package (100%)
(21402,5534,1,1,-1,23519),-- Soul Bow Stave
(21402,57,4224,8620,0,700000),-- Adena
(21402,11975,1,1,1,281),-- Common Item - Soul Bow
(21402,5534,1,1,1,4342),-- Soul Bow Stave
(21402,959,1,1,2,14),-- Scroll: Enchant Weapon (Grade S)
(21402,1868,3,9,2,117154),-- Thread
(21402,1873,1,1,2,140585),-- Silver Nugget
(21402,1889,1,1,2,23431),-- Compound Braid
(21402,4044,1,1,2,11715),-- Thons
(21402,5549,1,1,2,35146),-- Metallic Thread
(21402,8732,1,1,200,2929),-- Life Stone: level 76
(21402,8742,1,1,200,732),-- Mid-Grade Life Stone: level 76
(21402,8752,1,1,200,73),-- High-Grade Life Stone: level 76
(21403,4044,1,1,-1,329609),-- Thons
(21403,5157,1,1,-1,4395),-- Recipe: Soulshot (S) Compressed Package (100%)
(21403,5534,1,1,-1,27147),-- Soul Bow Stave
(21403,57,4875,9950,0,700000),-- Adena
(21403,11975,1,1,1,325),-- Common Item - Soul Bow
(21403,5534,1,1,1,5011),-- Soul Bow Stave
(21403,959,1,1,2,16),-- Scroll: Enchant Weapon (Grade S)
(21403,1868,3,9,2,135224),-- Thread
(21403,1873,1,1,2,162270),-- Silver Nugget
(21403,1889,1,1,2,27045),-- Compound Braid
(21403,4044,1,1,2,13523),-- Thons
(21403,5549,1,1,2,40567),-- Metallic Thread
(21403,8732,1,1,200,3381),-- Life Stone: level 76
(21403,8742,1,1,200,845),-- Mid-Grade Life Stone: level 76
(21403,8752,1,1,200,84),-- High-Grade Life Stone: level 76
(21404,5167,1,1,-1,5086),-- Recipe: Blessed Spiritshot (S) Compressed Package (100%)
(21404,5515,1,1,-1,193288),-- Sealed Majestic Gloves Design
(21404,6901,1,1,-1,11445),-- Recipe: Shining Arrow (100%)
(21404,57,5642,11518,0,700000),-- Adena
(21404,12266,1,1,1,590),-- Common Item - Sealed Robe of Nightmare
(21404,12259,1,1,1,590),-- Common Item - Sealed Majestic Robe
(21404,5487,1,1,1,4757),-- Sealed Robe of Nightmare Fabric
(21404,5488,1,1,1,4757),-- Sealed Majestic Robe Fabric
(21404,959,1,1,2,19),-- Scroll: Enchant Weapon (Grade S)
(21404,1867,12,36,2,26085),-- Animal Skin
(21404,1869,2,6,2,117381),-- Iron Ore
(21404,1870,2,6,2,93904),-- Coal
(21404,1871,3,9,2,78254),-- Charcoal
(21404,1872,7,21,2,44716),-- Animal Bone
(21404,8732,1,1,200,3913),-- Life Stone: level 76
(21404,8742,1,1,200,978),-- Mid-Grade Life Stone: level 76
(21404,8752,1,1,200,98),-- High-Grade Life Stone: level 76
(21405,5167,1,1,-1,3634),-- Recipe: Blessed Spiritshot (S) Compressed Package (100%)
(21405,5515,1,1,-1,138112),-- Sealed Majestic Gloves Design
(21405,6901,1,1,-1,8178),-- Recipe: Shining Arrow (100%)
(21405,57,4031,8230,0,700000),-- Adena
(21405,12266,1,1,1,422),-- Common Item - Sealed Robe of Nightmare
(21405,12259,1,1,1,422),-- Common Item - Sealed Majestic Robe
(21405,5487,1,1,1,3399),-- Sealed Robe of Nightmare Fabric
(21405,5488,1,1,1,3399),-- Sealed Majestic Robe Fabric
(21405,959,1,1,2,13),-- Scroll: Enchant Weapon (Grade S)
(21405,1867,1,3,2,149107),-- Animal Skin
(21405,1869,2,6,2,83873),-- Iron Ore
(21405,1870,2,6,2,67098),-- Coal
(21405,1871,3,9,2,55915),-- Charcoal
(21405,1872,7,21,2,31951),-- Animal Bone
(21405,8732,1,1,200,2796),-- Life Stone: level 76
(21405,8742,1,1,200,699),-- Mid-Grade Life Stone: level 76
(21405,8752,1,1,200,70),-- High-Grade Life Stone: level 76
(21406,5277,1,1,-1,4950),-- Recipe: Greater Spiritshot (S) Compressed Package(100%)
(21406,5523,1,1,-1,37932),-- Sealed Majestic Plate Armor Pattern
(21406,5527,1,1,-1,133170),-- Sealed Helm of Nightmare Design
(21406,57,5491,11210,0,700000),-- Adena
(21406,12264,1,1,1,1399),-- Common Item - Sealed Gloves of Nightmare
(21406,12267,1,1,1,1399),-- Common Item - Sealed Boots of Nightmare
(21406,12257,1,1,1,1399),-- Common Item - Sealed Majestic Gloves
(21406,12260,1,1,1,1399),-- Common Item - Sealed Majestic Boots
(21406,5502,1,1,1,8682),-- Sealed Boots of Nightmare Lining
(21406,5503,1,1,1,8682),-- Sealed Majestic Boots Lining
(21406,5514,1,1,1,8682),-- Sealed Gloves of Nightmare Design
(21406,5515,1,1,1,8682),-- Sealed Majestic Gloves Design
(21406,959,1,1,2,18),-- Scroll: Enchant Weapon (Grade S)
(21406,1868,3,9,2,152319),-- Thread
(21406,1873,2,6,2,45696),-- Silver Nugget
(21406,1876,1,1,2,91391),-- Mithril Ore
(21406,1895,1,1,2,130559),-- Metallic Fiber
(21406,4042,1,1,2,7616),-- Enria
(21406,8732,1,1,200,3808),-- Life Stone: level 76
(21406,8742,1,1,200,952),-- Mid-Grade Life Stone: level 76
(21406,8752,1,1,200,95),-- High-Grade Life Stone: level 76
(21407,5277,1,1,-1,3173),-- Recipe: Greater Spiritshot (S) Compressed Package(100%)
(21407,5523,1,1,-1,24314),-- Sealed Majestic Plate Armor Pattern
(21407,5527,1,1,-1,85361),-- Sealed Helm of Nightmare Design
(21407,57,3520,7185,0,700000),-- Adena
(21407,12264,1,1,1,897),-- Common Item - Sealed Gloves of Nightmare
(21407,12267,1,1,1,897),-- Common Item - Sealed Boots of Nightmare
(21407,12257,1,1,1,897),-- Common Item - Sealed Majestic Gloves
(21407,12260,1,1,1,897),-- Common Item - Sealed Majestic Boots
(21407,5502,1,1,1,5565),-- Sealed Boots of Nightmare Lining
(21407,5503,1,1,1,5565),-- Sealed Majestic Boots Lining
(21407,5514,1,1,1,5565),-- Sealed Gloves of Nightmare Design
(21407,5515,1,1,1,5565),-- Sealed Majestic Gloves Design
(21407,959,1,1,2,12),-- Scroll: Enchant Weapon (Grade S)
(21407,1868,3,9,2,97635),-- Thread
(21407,1873,1,1,2,117163),-- Silver Nugget
(21407,1876,1,1,2,58581),-- Mithril Ore
(21407,1895,1,1,2,83688),-- Metallic Fiber
(21407,4042,1,1,2,4882),-- Enria
(21407,8732,1,1,200,2441),-- Life Stone: level 76
(21407,8742,1,1,200,610),-- Mid-Grade Life Stone: level 76
(21407,8752,1,1,200,61),-- High-Grade Life Stone: level 76
(21408,5282,1,1,-1,4677),-- Recipe: Greater Blessed Spiritshot (S) Compressed Package(100%)
(21408,5529,1,1,-1,28873),-- Dragon Slayer Edge
(21408,6901,1,1,-1,10524),-- Recipe: Shining Arrow (100%)
(21408,57,5188,10592,0,700000),-- Adena
(21408,11964,1,1,1,115),-- Common Item - Dark Legion's Edge
(21408,11971,1,1,1,115),-- Common Item - Sword of Miracles 
(21408,11968,1,1,1,115),-- Common Item - Dragon Slayer
(21408,5529,1,1,1,1777),-- Dragon Slayer Edge
(21408,5545,1,1,1,1777),-- Dark Legion\'s Edge Blade
(21408,5546,1,1,1,1952),-- Sword of Miracles Edge
(21408,959,1,1,2,17),-- Scroll: Enchant Weapon (Grade S)
(21408,1868,3,9,2,143919),-- Thread
(21408,1873,1,1,2,172703),-- Silver Nugget
(21408,1889,1,1,2,28784),-- Compound Braid
(21408,4044,1,1,2,14392),-- Thons
(21408,5549,1,1,2,43175),-- Metallic Thread
(21408,8732,1,1,200,3598),-- Life Stone: level 76
(21408,8742,1,1,200,900),-- Mid-Grade Life Stone: level 76
(21408,8752,1,1,200,90),-- High-Grade Life Stone: level 76
(21409,5282,1,1,-1,5231),-- Recipe: Greater Blessed Spiritshot (S) Compressed Package(100%)
(21409,5529,1,1,-1,32288),-- Dragon Slayer Edge
(21409,6901,1,1,-1,11769),-- Recipe: Shining Arrow (100%)
(21409,57,5802,11844,0,700000),-- Adena
(21409,11964,1,1,1,129),-- Common Item - Dark Legion's Edge
(21409,11971,1,1,1,129),-- Common Item - Sword of Miracles 
(21409,11968,1,1,1,129),-- Common Item - Dragon Slayer
(21409,5529,1,1,1,1987),-- Dragon Slayer Edge
(21409,5545,1,1,1,1987),-- Dark Legion\'s Edge Blade
(21409,5546,1,1,1,2183),-- Sword of Miracles Edge
(21409,959,1,1,2,19),-- Scroll: Enchant Weapon (Grade S)
(21409,1868,3,9,2,160941),-- Thread
(21409,1873,1,1,2,193130),-- Silver Nugget
(21409,1889,1,1,2,32188),-- Compound Braid
(21409,4044,1,1,2,16094),-- Thons
(21409,5549,1,1,2,48282),-- Metallic Thread
(21409,8732,1,1,200,4024),-- Life Stone: level 76
(21409,8742,1,1,200,1006),-- Mid-Grade Life Stone: level 76
(21409,8752,1,1,200,100),-- High-Grade Life Stone: level 76
(21410,5282,1,1,-1,4740),-- Recipe: Greater Blessed Spiritshot (S) Compressed Package(100%)
(21410,5538,1,1,-1,29251),-- Dragon Grinder Edge
(21410,5541,1,1,-1,29245),-- Tallum Glaive Edge
(21410,57,5247,10744,0,700000),-- Adena
(21410,12350,1,1,1,1212),-- Common Item - Sealed Majestic Necklace
(21410,12352,1,1,1,1614),-- Common Item - Sealed Majestic Earring
(21410,12351,1,1,1,2422),-- Common Item - Sealed Majestic Ring
(21410,6342,1,1,1,14866),-- Sealed Majestic Earring Gemstone
(21410,6344,1,1,1,9620),-- Sealed Majestic Necklace Beads
(21410,6346,1,1,1,21365),-- Sealed Majestic Ring Gemstone
(21410,960,1,1,2,157),-- Scroll: Enchant Armor (Grade S)
(21410,1344,40,120,2,123045),-- Mithril Arrow
(21410,1867,5,15,2,52499),-- Animal Skin
(21410,1872,1,3,2,174998),-- Animal Bone
(21410,1882,1,1,2,87499),-- Leather
(21410,1894,1,1,2,13816),-- Crafted Leather
(21410,4042,1,1,2,6562),-- Enria
(21410,8732,1,1,200,3281),-- Life Stone: level 76
(21410,8742,1,1,200,820),-- Mid-Grade Life Stone: level 76
(21410,8752,1,1,200,82),-- High-Grade Life Stone: level 76
(21411,5282,1,1,-1,3864),-- Recipe: Greater Blessed Spiritshot (S) Compressed Package(100%)
(21411,5538,1,1,-1,23844),-- Dragon Grinder Edge
(21411,5541,1,1,-1,23839),-- Tallum Glaive Edge
(21411,57,4277,8758,0,700000),-- Adena
(21411,12350,1,1,1,988),-- Common Item - Sealed Majestic Necklace
(21411,12352,1,1,1,1316),-- Common Item - Sealed Majestic Earring
(21411,12351,1,1,1,1974),-- Common Item - Sealed Majestic Ring
(21411,6342,1,1,1,12118),-- Sealed Majestic Earring Gemstone
(21411,6344,1,1,1,7842),-- Sealed Majestic Necklace Beads
(21411,6346,1,1,1,17416),-- Sealed Majestic Ring Gemstone
(21411,960,1,1,2,128),-- Scroll: Enchant Armor (Grade S)
(21411,1344,40,120,2,100303),-- Mithril Arrow
(21411,1867,5,15,2,42796),-- Animal Skin
(21411,1872,1,3,2,142653),-- Animal Bone
(21411,1882,1,1,2,71326),-- Leather
(21411,1894,1,1,2,11262),-- Crafted Leather
(21411,4042,1,1,2,5349),-- Enria
(21411,8732,1,1,200,2675),-- Life Stone: level 76
(21411,8742,1,1,200,669),-- Mid-Grade Life Stone: level 76
(21411,8752,1,1,200,67),-- High-Grade Life Stone: level 76
(21412,1808,1,1,-1,6166),-- Recipe: Soulshot: S Grade
(21412,1876,1,5,-1,924871),-- Mithril Ore
(21412,5545,1,1,-1,38061),-- Dark Legion\'s Edge Blade
(21412,57,6826,13977,0,700000),-- Adena
(21412,12269,1,1,1,1549),-- Common Item - Sealed Helm of Nightmare
(21412,12268,1,1,1,1549),-- Common Item - Sealed Shield of Nightmare
(21412,12261,1,1,1,2215),-- Common Item - Sealed Majestic Circlet
(21412,5495,1,1,1,12964),-- Sealed Shield of Nightmare Fragment
(21412,5527,1,1,1,10207),-- Sealed Helm of Nightmare Design
(21412,5528,1,1,1,10207),-- Sealed Majestic Circlet Design
(21412,960,1,1,2,205),-- Scroll: Enchant Armor (Grade S)
(21412,1344,150,450,2,42686),-- Mithril Arrow
(21412,1868,4,12,2,128059),-- Thread
(21412,1873,3,9,2,34149),-- Silver Nugget
(21412,1876,1,1,2,102447),-- Mithril Ore
(21412,1895,1,1,2,146353),-- Metallic Fiber
(21412,4042,1,1,2,8537),-- Enria
(21412,8732,1,1,200,4268),-- Life Stone: level 76
(21412,8742,1,1,200,1067),-- Mid-Grade Life Stone: level 76
(21412,8752,1,1,200,107),-- High-Grade Life Stone: level 76
(21413,1808,1,1,-1,4742),-- Recipe: Soulshot: S Grade
(21413,1876,1,5,-1,711201),-- Mithril Ore
(21413,5545,1,1,-1,29268),-- Dark Legion\'s Edge Blade
(21413,57,5249,10748,0,700000),-- Adena
(21413,12269,1,1,1,1191),-- Common Item - Sealed Helm of Nightmare
(21413,12268,1,1,1,1703),-- Common Item - Sealed Shield of Nightmare
(21413,12261,1,1,1,1191),-- Common Item - Sealed Majestic Circlet
(21413,5495,1,1,1,9969),-- Sealed Shield of Nightmare Fragment
(21413,5527,1,1,1,7849),-- Sealed Helm of Nightmare Design
(21413,5528,1,1,1,7849),-- Sealed Majestic Circlet Design
(21413,960,1,1,2,158),-- Scroll: Enchant Armor (Grade S)
(21413,1344,150,450,2,32825),-- Mithril Arrow
(21413,1868,4,12,2,98474),-- Thread
(21413,1873,1,1,2,157558),-- Silver Nugget
(21413,1876,1,1,2,78779),-- Mithril Ore
(21413,1895,1,1,2,112541),-- Metallic Fiber
(21413,4042,1,1,2,6565),-- Enria
(21413,8732,1,1,200,3283),-- Life Stone: level 76
(21413,8742,1,1,200,821),-- Mid-Grade Life Stone: level 76
(21413,8752,1,1,200,82),-- High-Grade Life Stone: level 76
(21414,1877,1,1,-1,414708),-- Adamantite Nugget
(21414,4040,1,1,-1,207354),-- Mold Lubricant
(21414,6344,1,1,-1,151985),-- Sealed Majestic Necklace Beads
(21414,57,5101,10446,0,700000),-- Adena
(21414,11970,1,1,1,85),-- Common Item - Branch of The Mother Tree
(21414,11974,1,1,1,85),-- Common Item - Elysian
(21414,11969,1,1,1,85),-- Common Item - Flaming Dragon Skull
(21414,11966,1,1,1,85),-- Common Item - Doom Crusher
(21414,5533,1,1,1,1313),-- Elysian Head
(21414,5544,1,1,1,1311),-- Branch of The Mother Tree Head
(21414,8349,1,1,1,1312),-- Doom Crusher Head
(21414,8342,1,1,1,1313),-- Flaming Dragon Skull Piece
(21414,960,1,1,2,153),-- Scroll: Enchant Armor (Grade S)
(21414,1344,20,60,2,239255),-- Mithril Arrow
(21414,1866,2,6,2,63801),-- Suede
(21414,1871,1,3,2,127602),-- Charcoal
(21414,1877,1,1,2,15312),-- Adamantite Nugget
(21414,4040,1,1,2,7656),-- Mold Lubricant
(21414,4041,1,1,2,3329),-- Mold Hardener
(21414,8732,1,1,200,3190),-- Life Stone: level 76
(21414,8742,1,1,200,797),-- Mid-Grade Life Stone: level 76
(21414,8752,1,1,200,80),-- High-Grade Life Stone: level 76
(21415,1877,1,1,-1,418353),-- Adamantite Nugget
(21415,4040,1,1,-1,209177),-- Mold Lubricant
(21415,6344,1,1,-1,153322),-- Sealed Majestic Necklace Beads
(21415,57,5146,10537,0,700000),-- Adena
(21415,11970,1,1,1,86),-- Common Item - Branch of The Mother Tree
(21415,11974,1,1,1,86),-- Common Item - Elysian
(21415,11969,1,1,1,86),-- Common Item - Flaming Dragon Skull
(21415,11966,1,1,1,86),-- Common Item - Doom Crusher
(21415,8342,1,1,1,1324),-- Flaming Dragon Skull Piece
(21415,8349,1,1,1,1324),-- Doom Crusher Head
(21415,5533,1,1,1,1324),-- Elysian Head
(21415,5544,1,1,1,1323),-- Branch of The Mother Tree Head
(21415,960,1,1,2,154),-- Scroll: Enchant Armor (Grade S)
(21415,1344,20,60,2,241358),-- Mithril Arrow
(21415,1866,2,6,2,64362),-- Suede
(21415,1871,1,3,2,128724),-- Charcoal
(21415,1877,1,1,2,15447),-- Adamantite Nugget
(21415,4040,1,1,2,7723),-- Mold Lubricant
(21415,4041,1,1,2,3358),-- Mold Hardener
(21415,8732,1,1,200,3218),-- Life Stone: level 76
(21415,8742,1,1,200,804),-- Mid-Grade Life Stone: level 76
(21415,8752,1,1,200,80),-- High-Grade Life Stone: level 76
(21416,1885,1,1,-1,893618),-- High Grade Suede
(21416,4041,1,1,-1,93247),-- Mold Hardener
(21416,5480,1,1,-1,48118),-- Sealed Leather Armor of Nightmare Fabric
(21416,57,5276,10804,0,700000),-- Adena
(21416,11975,1,1,1,352),-- Common Item - Soul Bow
(21416,5534,1,1,1,5435),-- Soul Bow Stave
(21416,960,1,1,2,158),-- Scroll: Enchant Armor (Grade S)
(21416,1344,100,300,2,49493),-- Mithril Arrow
(21416,1866,2,6,2,65990),-- Suede
(21416,1871,1,3,2,131980),-- Charcoal
(21416,1885,1,1,2,32995),-- High Grade Suede
(21416,4041,1,1,2,3443),-- Mold Hardener
(21416,5220,1,1,2,15838),-- Metal Hardener
(21416,8732,1,1,200,3300),-- Life Stone: level 76
(21416,8742,1,1,200,825),-- Mid-Grade Life Stone: level 76
(21416,8752,1,1,200,82),-- High-Grade Life Stone: level 76
(21417,1885,1,3,-1,696251),-- High Grade Suede
(21417,4041,1,1,-1,145305),-- Mold Hardener
(21417,5480,1,1,-1,74982),-- Sealed Leather Armor of Nightmare Fabric
(21417,57,8221,16836,0,700000),-- Adena
(21417,11975,1,1,1,548),-- Common Item - Soul Bow
(21417,5534,1,1,1,8470),-- Soul Bow Stave
(21417,960,1,1,2,247),-- Scroll: Enchant Armor (Grade S)
(21417,1344,100,300,2,77123),-- Mithril Arrow
(21417,1866,2,6,2,102831),-- Suede
(21417,1871,1,3,2,205661),-- Charcoal
(21417,1885,1,1,2,51415),-- High Grade Suede
(21417,4041,1,1,2,5365),-- Mold Hardener
(21417,5220,1,1,2,24680),-- Metal Hardener
(21417,8732,1,1,200,5142),-- Life Stone: level 76
(21417,8742,1,1,200,1285),-- Mid-Grade Life Stone: level 76
(21417,8752,1,1,200,128),-- High-Grade Life Stone: level 76
(21418,3036,1,1,-1,3947),-- Recipe: Spiritshot S
(21418,4044,1,1,-1,296030),-- Thons
(21418,5528,1,1,-1,106180),-- Sealed Majestic Circlet Design
(21418,57,4369,8949,0,700000),-- Adena
(21418,12269,1,1,1,992),-- Common Item - Sealed Helm of Nightmare
(21418,12268,1,1,1,1418),-- Common Item - Sealed Shield of Nightmare
(21418,12261,1,1,1,992),-- Common Item - Sealed Majestic Circlet
(21418,5495,1,1,1,8299),-- Sealed Shield of Nightmare Fragment
(21418,5527,1,1,1,6534),-- Sealed Helm of Nightmare Design
(21418,5528,1,1,1,6534),-- Sealed Majestic Circlet Design
(21418,959,1,1,2,14),-- Scroll: Enchant Weapon (Grade S)
(21418,1868,3,9,2,121448),-- Thread
(21418,1873,1,1,2,145738),-- Silver Nugget
(21418,1889,1,1,2,24290),-- Compound Braid
(21418,4044,1,1,2,12145),-- Thons
(21418,5549,1,1,2,36434),-- Metallic Thread
(21418,8732,1,1,200,3036),-- Life Stone: level 76
(21418,8742,1,1,200,759),-- Mid-Grade Life Stone: level 76
(21418,8752,1,1,200,76),-- High-Grade Life Stone: level 76
(21419,3036,1,1,-1,4020),-- Recipe: Spiritshot S
(21419,4044,1,1,-1,301486),-- Thons
(21419,5528,1,1,-1,108137),-- Sealed Majestic Circlet Design
(21419,57,4450,9114,0,700000),-- Adena
(21419,12269,1,1,1,1010),-- Common Item - Sealed Helm of Nightmare
(21419,12268,1,1,1,1444),-- Common Item - Sealed Shield of Nightmare
(21419,12261,1,1,1,1010),-- Common Item - Sealed Majestic Circlet
(21419,5495,1,1,1,8452),-- Sealed Shield of Nightmare Fragment
(21419,5527,1,1,1,6655),-- Sealed Helm of Nightmare Design
(21419,5528,1,1,1,6655),-- Sealed Majestic Circlet Design
(21419,959,1,1,2,15),-- Scroll: Enchant Weapon (Grade S)
(21419,1868,3,9,2,123687),-- Thread
(21419,1873,1,1,2,148323),-- Silver Nugget
(21419,1889,1,1,2,24737),-- Compound Braid
(21419,4044,1,1,2,12369),-- Thons
(21419,5549,1,1,2,37106),-- Metallic Thread
(21419,8732,1,1,200,3092),-- Life Stone: level 76
(21419,8742,1,1,200,773),-- Mid-Grade Life Stone: level 76
(21419,8752,1,1,200,77),-- High-Grade Life Stone: level 76
(21420,5157,1,1,-1,4912),-- Recipe: Soulshot (S) Compressed Package (100%)
(21420,5533,1,1,-1,30317),-- Elysian Head
(21420,5534,1,1,-1,30244),-- Soul Bow Stave
(21420,57,5438,11138,0,700000),-- Adena
(21420,11970,1,1,1,91),-- Common Item - Branch of The Mother Tree
(21420,11974,1,1,1,91),-- Common Item - Elysian
(21420,11969,1,1,1,91),-- Common Item - Flaming Dragon Skull
(21420,11966,1,1,1,91),-- Common Item - Doom Crushe
(21420,8342,1,1,1,1399),-- Flaming Dragon Skull Piece
(21420,8349,1,1,1,1399),-- Doom Crusher Head
(21420,5533,1,1,1,1399),-- Elysian Head
(21420,5544,1,1,1,1398),-- Branch of The Mother Tree Head
(21420,959,1,1,2,18),-- Scroll: Enchant Weapon (Grade S)
(21420,1868,3,9,2,151148),-- Thread
(21420,1873,2,6,2,45344),-- Silver Nugget
(21420,1876,1,1,2,90689),-- Mithril Ore
(21420,1895,1,1,2,129556),-- Metallic Fiber
(21420,4042,1,1,2,7557),-- Enria
(21420,8732,1,1,200,3778),-- Life Stone: level 76
(21420,8742,1,1,200,945),-- Mid-Grade Life Stone: level 76
(21420,8752,1,1,200,94),-- High-Grade Life Stone: level 76
(21421,5157,1,1,-1,4611),-- Recipe: Soulshot (S) Compressed Package (100%)
(21421,5533,1,1,-1,28459),-- Elysian Head
(21421,5534,1,1,-1,28484),-- Soul Bow Stave
(21421,57,5104,10455,0,700000),-- Adena
(21421,11970,1,1,1,85),-- Common Item - Branch of The Mother Tree
(21421,11974,1,1,1,85),-- Common Item - Elysian
(21421,11969,1,1,1,85),-- Common Item - Flaming Dragon Skull
(21421,11966,1,1,1,85),-- Common Item - Doom Crushe
(21421,8342,1,1,1,1314),-- Flaming Dragon Skull Piece
(21421,8349,1,1,1,1313),-- Doom Crusher Head
(21421,5533,1,1,1,1314),-- Elysian Head
(21421,5544,1,1,1,1312),-- Branch of The Mother Tree Head
(21421,959,1,1,2,17),-- Scroll: Enchant Weapon (Grade S)
(21421,1868,3,9,2,141885),-- Thread
(21421,1873,2,6,2,42565),-- Silver Nugget
(21421,1876,1,1,2,85131),-- Mithril Ore
(21421,1895,1,1,2,121616),-- Metallic Fiber
(21421,4042,1,1,2,7094),-- Enria
(21421,8732,1,1,200,3547),-- Life Stone: level 76
(21421,8742,1,1,200,887),-- Mid-Grade Life Stone: level 76
(21421,8752,1,1,200,89),-- High-Grade Life Stone: level 76
(21422,5162,1,1,-1,5290),-- Recipe: Spiritshot (S) Compressed Package (100%)
(21422,5167,1,1,-1,5290),-- Recipe: Blessed Spiritshot (S) Compressed Package (100%)
(21422,5538,1,1,-1,32647),-- Dragon Grinder Edge
(21422,57,5855,11994,0,700000),-- Adena
(21422,11975,1,1,1,391),-- Common Item - Soul Bow
(21422,5534,1,1,1,6032),-- Soul Bow Stave
(21422,959,1,1,2,20),-- Scroll: Enchant Weapon (Grade S)
(21422,1867,4,12,2,81383),-- Animal Skin
(21422,1872,1,3,2,217022),-- Animal Bone
(21422,1882,1,1,2,108511),-- Leather
(21422,1894,1,1,2,17133),-- Crafted Leather
(21422,4042,1,1,2,8138),-- Enria
(21422,8732,1,1,200,4069),-- Life Stone: level 76
(21422,8742,1,1,200,1017),-- Mid-Grade Life Stone: level 76
(21422,8752,1,1,200,102),-- High-Grade Life Stone: level 76
(21423,5162,1,1,-1,5608),-- Recipe: Spiritshot (S) Compressed Package (100%)
(21423,5167,1,1,-1,5608),-- Recipe: Blessed Spiritshot (S) Compressed Package (100%)
(21423,5538,1,1,-1,34609),-- Dragon Grinder Edge
(21423,57,6207,12714,0,700000),-- Adena
(21423,11975,1,1,1,414),-- Common Item - Soul Bow
(21423,5534,1,1,1,6395),-- Soul Bow Stave
(21423,959,1,1,2,21),-- Scroll: Enchant Weapon (Grade S)
(21423,1867,4,12,2,86273),-- Animal Skin
(21423,1872,1,3,2,230061),-- Animal Bone
(21423,1882,1,1,2,115030),-- Leather
(21423,1894,1,1,2,18163),-- Crafted Leather
(21423,4042,1,1,2,8627),-- Enria
(21423,8732,1,1,200,4314),-- Life Stone: level 76
(21423,8742,1,1,200,1079),-- Mid-Grade Life Stone: level 76
(21423,8752,1,1,200,108),-- High-Grade Life Stone: level 76
(21424,5272,1,1,-1,7107),-- Recipe: Greater Soulshot (S) Compressed Package(100%)
(21424,5544,1,1,-1,43821),-- Branch of The Mother Tree Head
(21424,5545,1,1,-1,43872),-- Dark Legion\'s Edge Blade
(21424,57,7867,16114,0,700000),-- Adena
(21424,11976,1,1,1,525),-- Common Item - Tallum Glaive
(21424,5541,1,1,1,8096),-- Tallum Glaive Edge
(21424,959,1,1,2,23),-- Scroll: Enchant Weapon (Grade S)
(21424,1868,15,45,2,39364),-- Thread
(21424,1873,2,6,2,59046),-- Silver Nugget
(21424,1876,1,1,2,118091),-- Mithril Ore
(21424,1895,1,1,2,168701),-- Metallic Fiber
(21424,4042,1,1,2,9841),-- Enria
(21424,6672,1,1,2,49204),-- Deluxe Chest Key - Grade 8
(21424,8732,1,1,200,4920),-- Life Stone: level 76
(21424,8742,1,1,200,1230),-- Mid-Grade Life Stone: level 76
(21424,8752,1,1,200,124),-- High-Grade Life Stone: level 76
(21425,5272,1,1,-1,7227),-- Recipe: Greater Soulshot (S) Compressed Package(100%)
(21425,5544,1,1,-1,44556),-- Branch of The Mother Tree Head
(21425,5545,1,1,-1,44609),-- Dark Legion\'s Edge Blade
(21425,57,7999,16385,0,700000),-- Adena
(21425,11976,1,1,1,534),-- Common Item - Tallum Glaive
(21425,5541,1,1,1,8232),-- Tallum Glaive Edge
(21425,959,1,1,2,27),-- Scroll: Enchant Weapon (Grade S)
(21425,1868,15,45,2,44472),-- Thread
(21425,1873,2,6,2,66707),-- Silver Nugget
(21425,1876,1,1,2,133414),-- Mithril Ore
(21425,1895,1,1,2,190592),-- Metallic Fiber
(21425,4042,1,1,2,11118),-- Enria
(21425,8732,1,1,200,5559),-- Life Stone: level 76
(21425,8742,1,1,200,1390),-- Mid-Grade Life Stone: level 76
(21425,8752,1,1,200,139),-- High-Grade Life Stone: level 76
(21426,6698,1,1,-1,293497),-- Sealed Tateossian Earring  Part
(21426,6699,1,1,-1,325674),-- Sealed Tateossian Ring Gem
(21426,6700,1,1,-1,178881),-- Sealed Tateossian Ring Wire
(21426,57,7369,15040,0,700000),-- Adena
(21426,11975,1,1,1,490),-- Common Item - Soul Bow
(21426,5534,1,1,1,7574),-- Soul Bow Stave
(21426,960,1,1,2,221),-- Scroll: Enchant Armor (Grade S)
(21426,1344,150,450,2,45975),-- Mithril Arrow
(21426,1868,4,12,2,137925),-- Thread
(21426,1873,3,9,2,36780),-- Silver Nugget
(21426,1876,1,1,2,110340),-- Mithril Ore
(21426,1895,3,9,2,22518),-- Metallic Fiber
(21426,4042,1,1,2,9195),-- Enria
(21426,8732,1,1,200,4598),-- Life Stone: level 76
(21426,8742,1,1,200,1149),-- Mid-Grade Life Stone: level 76
(21426,8752,1,1,200,115),-- High-Grade Life Stone: level 76
(21427,6698,1,1,-1,199827),-- Sealed Tateossian Earring  Part
(21427,6699,1,1,-1,221735),-- Sealed Tateossian Ring Gem
(21427,6700,1,1,-1,121791),-- Sealed Tateossian Ring Wire
(21427,57,5017,10240,0,700000),-- Adena
(21427,11975,1,1,1,334),-- Common Item - Soul Bow
(21427,5534,1,1,1,5156),-- Soul Bow Stave
(21427,960,1,1,2,150),-- Scroll: Enchant Armor (Grade S)
(21427,1344,150,450,2,31303),-- Mithril Arrow
(21427,1868,4,12,2,93906),-- Thread
(21427,1873,1,1,2,150250),-- Silver Nugget
(21427,1876,1,1,2,75125),-- Mithril Ore
(21427,1895,1,1,2,107321),-- Metallic Fiber
(21427,4042,1,1,2,6260),-- Enria
(21427,8732,1,1,200,3130),-- Life Stone: level 76
(21427,8742,1,1,200,783),-- Mid-Grade Life Stone: level 76
(21427,8752,1,1,200,78),-- High-Grade Life Stone: level 76
(21428,6701,1,1,-1,56000),-- Sealed Imperial Crusader Breastplate Part
(21428,6702,1,1,-1,72087),-- Sealed Imperial Crusader Gaiters Pattern
(21428,6703,1,1,-1,149756),-- Sealed Imperial Crusader Gauntlets Design
(21428,57,5187,10587,0,700000),-- Adena
(21428,11973,1,1,1,345),-- Common Item - Soul Separator
(21428,5537,1,1,1,5328),-- Soul Separator Head
(21428,960,1,1,2,155),-- Scroll: Enchant Armor (Grade S)
(21428,1344,30,90,2,161818),-- Mithril Arrow
(21428,1868,4,12,2,97091),-- Thread
(21428,1873,1,1,2,155345),-- Silver Nugget
(21428,1889,1,1,2,25891),-- Compound Braid
(21428,4044,1,1,2,12946),-- Thons
(21428,5549,1,1,2,38836),-- Metallic Thread
(21428,8732,1,1,200,3236),-- Life Stone: level 76
(21428,8742,1,1,200,809),-- Mid-Grade Life Stone: level 76
(21428,8752,1,1,200,81),-- High-Grade Life Stone: level 76
(21429,6701,1,1,-1,58474),-- Sealed Imperial Crusader Breastplate Part
(21429,6702,1,1,-1,75272),-- Sealed Imperial Crusader Gaiters Pattern
(21429,6703,1,1,-1,156374),-- Sealed Imperial Crusader Gauntlets Design
(21429,57,5417,11055,0,700000),-- Adena
(21429,11973,1,1,1,360),-- Common Item - Soul Separator
(21429,5537,1,1,1,5563),-- Soul Separator Head
(21429,960,1,1,2,162),-- Scroll: Enchant Armor (Grade S)
(21429,1344,150,450,2,33793),-- Mithril Arrow
(21429,1868,4,12,2,101381),-- Thread
(21429,1873,1,1,2,162209),-- Silver Nugget
(21429,1889,1,1,2,27035),-- Compound Braid
(21429,4044,1,1,2,13517),-- Thons
(21429,5549,1,1,2,40552),-- Metallic Thread
(21429,8732,1,1,200,3379),-- Life Stone: level 76
(21429,8742,1,1,200,845),-- Mid-Grade Life Stone: level 76
(21429,8752,1,1,200,85),-- High-Grade Life Stone: level 76
(21430,6704,1,1,-1,215960),-- Sealed Imperial Crusader Boots Design
(21430,6705,1,1,-1,211533),-- Sealed Imperial Crusader Shield Part
(21430,6706,1,1,-1,246054),-- Sealed Imperial Crusader Helmet Pattern
(21430,57,7481,15268,0,700000),-- Adena
(21430,12265,1,1,1,782),-- Common Item - Sealed Leather Armor of Nightmare
(21430,12258,1,1,1,782),-- Common Item - Sealed Majestic Leather Armor
(21430,5480,1,1,1,6283),-- Sealed Leather Armor of Nightmare Fabric
(21430,5481,1,1,1,6283),-- Sealed Majestic Leather Armor Fabric
(21430,960,1,1,2,224),-- Scroll: Enchant Armor (Grade S)
(21430,1344,150,450,2,46670),-- Mithril Arrow
(21430,1868,4,12,2,140011),-- Thread
(21430,1873,3,9,2,37337),-- Silver Nugget
(21430,1876,1,1,2,112009),-- Mithril Ore
(21430,1895,3,9,2,22859),-- Metallic Fiber
(21430,4042,1,1,2,9334),-- Enria
(21430,8732,1,1,200,4667),-- Life Stone: level 76
(21430,8742,1,1,200,1167),-- Mid-Grade Life Stone: level 76
(21430,8752,1,1,200,117),-- High-Grade Life Stone: level 76
(21431,6704,1,1,-1,184208),-- Sealed Imperial Crusader Boots Design
(21431,6705,1,1,-1,180432),-- Sealed Imperial Crusader Shield Part
(21431,6706,1,1,-1,209877),-- Sealed Imperial Crusader Helmet Pattern
(21431,57,6381,13023,0,700000),-- Adena
(21431,12265,1,1,1,667),-- Common Item - Sealed Leather Armor of Nightmare
(21431,12258,1,1,1,667),-- Common Item - Sealed Majestic Leather Armor
(21431,5480,1,1,1,5359),-- Sealed Leather Armor of Nightmare Fabric
(21431,5481,1,1,1,53595),-- Sealed Majestic Leather Armor Fabric
(21431,960,1,1,2,191),-- Scroll: Enchant Armor (Grade S)
(21431,1344,150,450,2,39808),-- Mithril Arrow
(21431,1868,4,12,2,119426),-- Thread
(21431,1873,3,9,2,318473),-- Silver Nugget
(21431,1876,1,1,2,95541),-- Mithril Ore
(21431,1895,1,1,2,136487),-- Metallic Fiber
(21431,4042,1,1,2,7962),-- Enria
(21431,8732,1,1,200,3981),-- Life Stone: level 76
(21431,8742,1,1,200,995),-- Mid-Grade Life Stone: level 76
(21431,8752,1,1,200,99),-- High-Grade Life Stone: level 76
(21432,1808,1,1,-1,7616),-- Recipe: Soulshot: S Grade
(21432,5534,1,1,-1,47043),-- Soul Bow Stave
(21432,5537,1,1,-1,47011),-- Soul Separator Head
(21432,57,8447,17245,0,700000),-- Adena
(21432,11967,1,1,1,562),-- Common Item - Dragon Grinder
(21432,5538,1,1,1,8678),-- Dragon Grinder Edge
(21432,959,1,1,2,28),-- Scroll: Enchant Weapon (Grade S)
(21432,1868,15,45,2,46866),-- Thread
(21432,1873,2,6,2,70299),-- Silver Nugget
(21432,1876,1,1,2,140598),-- Mithril Ore
(21432,1895,1,1,2,200854),-- Metallic Fiber
(21432,4042,1,1,2,11716),-- Enria
(21432,8732,1,1,200,5858),-- Life Stone: level 76
(21432,8742,1,1,200,1465),-- Mid-Grade Life Stone: level 76
(21432,8752,1,1,200,146),-- High-Grade Life Stone: level 76
(21433,5167,1,1,-1,7377),-- Recipe: Blessed Spiritshot (S) Compressed Package (100%)
(21433,5538,1,1,-1,45528),-- Dragon Grinder Edge
(21433,5541,1,1,-1,45519),-- Tallum Glaive Edge
(21433,57,8184,16701,0,700000),-- Adena
(21433,12263,1,1,1,642),-- Common Item - Sealed Armor of Nightmare
(21433,12262,1,1,1,642),-- Common Item - Sealed Majestic Plate Armor
(21433,5522,1,1,1,5218),-- Sealed Armor of Nightmare Pattern
(21433,5523,1,1,1,5218),-- Sealed Majestic Plate Armor Pattern
(21433,959,1,1,2,27),-- Scroll: Enchant Weapon (Grade S)
(21433,1868,15,45,2,45397),-- Thread
(21433,1873,2,6,2,68095),-- Silver Nugget
(21433,1876,1,1,2,136190),-- Mithril Ore
(21433,1895,1,1,2,194558),-- Metallic Fiber
(21433,4042,1,1,2,11349),-- Enria
(21433,8732,1,1,200,5675),-- Life Stone: level 76
(21433,8742,1,1,200,1419),-- Mid-Grade Life Stone: level 76
(21433,8752,1,1,200,142),-- High-Grade Life Stone: level 76
(21434,1877,1,3,-1,631579),-- Adamantite Nugget
(21434,5282,1,1,-1,14035),-- Recipe: Greater Blessed Spiritshot (S) Compressed Package(100%)
(21434,6342,1,1,-1,715346),-- Sealed Majestic Earring Gemstone
(21434,57,15536,31822,0,700000),-- Adena
(21434,12265,1,1,1,1628),-- Common Item - Sealed Leather Armor of Nightmare
(21434,12258,1,1,1,1628),-- Common Item - Sealed Majestic Leather Armor
(21434,5480,1,1,1,13080),-- Sealed Leather Armor of Nightmare Fabric
(21434,5481,1,1,1,13080),-- Sealed Majestic Leather Armor Fabric
(21434,959,1,1,2,52),-- Scroll: Enchant Weapon (Grade S)
(21434,1866,7,21,2,57580),-- Suede
(21434,1871,4,12,2,161943),-- Charcoal
(21434,1877,1,1,2,51822),-- Adamantite Nugget
(21434,4040,1,1,2,25911),-- Mold Lubricant
(21434,4041,1,1,2,11266),-- Mold Hardener
(21434,8732,1,1,200,10796),-- Life Stone: level 76
(21434,8742,1,1,200,2699),-- Mid-Grade Life Stone: level 76
(21434,8752,1,1,200,270),-- High-Grade Life Stone: level 76
(21435,1877,1,1,-1,818535),-- Adamantite Nugget
(21435,3036,1,1,-1,9095),-- Recipe: Spiritshot S
(21435,5538,1,1,-1,56130),-- Dragon Grinder Edge
(21435,57,10088,20595,0,700000),-- Adena
(21435,11975,1,1,1,672),-- Common Item - Soul Bow
(21435,5534,1,1,1,10371),-- Soul Bow Stave
(21435,960,1,1,2,302),-- Scroll: Enchant Armor (Grade S)
(21435,1344,100,300,2,94446),-- Mithril Arrow
(21435,1866,2,6,2,125929),-- Suede
(21435,1871,9,27,2,41976),-- Charcoal
(21435,1877,1,1,1,30223),-- Adamantite Nugget
(21435,4040,1,1,2,15112),-- Mold Lubricant
(21435,4041,1,1,2,6570),-- Mold Hardener
(21435,8732,1,1,200,6297),-- Life Stone: level 76
(21435,8742,1,1,200,1574),-- Mid-Grade Life Stone: level 76
(21435,8752,1,1,200,157),-- High-Grade Life Stone: level 76
(21436,1894,1,1,-1,744816),-- Crafted Leather
(21436,3957,1,1,-1,9434),-- Recipe: Blessed Spiritshot S
(21436,5541,1,1,-1,58213),-- Tallum Glaive Edge
(21436,57,10464,21364,0,700000),-- Adena
(21436,11973,1,1,1,697),-- Common Item - Soul Separator
(21436,5537,1,1,1,10751),-- Soul Separator Head
(21436,959,1,1,2,35),-- Scroll: Enchant Weapon (Grade S)
(21436,1867,4,12,2,145143),-- Animal Skin
(21436,1872,7,21,2,77410),-- Animal Bone
(21436,1882,1,1,2,193525),-- Leather
(21436,1894,1,1,2,30557),-- Crafted Leather
(21436,4042,1,1,2,14514),-- Enria
(21436,8732,1,1,200,7257),-- Life Stone: level 76
(21436,8742,1,1,200,1814),-- Mid-Grade Life Stone: level 76
(21436,8752,1,1,200,182),-- High-Grade Life Stone: level 76
(21437,1877,1,1,-1,419120),-- Adamantite Nugget
(21437,4041,1,1,-1,91113),-- Mold Hardener
(21437,5544,1,1,-1,28712),-- Branch of The Mother Tree Head
(21437,57,4216,8604,0,700000),-- Adena
(21437,11970,1,1,1,6),-- Common Item - Branch of The Mother Tree (no drop info, no spawn)
(21437,11974,1,1,1,6),-- Common Item - Elysian
(21437,5533,1,1,1,2123),-- Elysian Head
(21437,5544,1,1,1,2121),-- Branch of The Mother Tree Head
(21437,960,1,1,2,177),-- Scroll: Enchant Armor (Grade S)
(21437,1344,100,300,2,55269),-- Mithril Arrow
(21437,1866,2,6,2,73692),-- Suede
(21437,1871,1,3,2,147384),-- Charcoal
(21437,1877,1,1,2,17686),-- Adamantite Nugget
(21437,4040,1,1,2,8843),-- Mold Lubricant
(21437,4041,1,1,2,3845),-- Mold Hardener
(21438,4077,1,1,-1,27694),-- Doom Shield Fragment
(21438,4078,1,1,-1,8993),-- Blue Wolf Breastplate Part
(21438,6333,1,1,-1,7068),-- Recipe: Sealed Phoenix Ring(70%)
(21438,57,244,495,0,700000),-- Adena
(21438,11930,1,1,1,10),-- Common Item - Sword of Damascus
(21438,11943,1,1,1,10),-- Common Item - Wizard\'s Tear
(21438,11929,1,1,1,10),-- Common Item - Guardian Sword
(21438,4114,1,1,1,133),-- Sword of Damascus Blade
(21438,8336,1,1,1,133),-- Blade of the Wizard\'s Tear
(21438,8330,1,1,1,132),-- Guardian Sword Blade
(21438,729,1,1,2,2),-- Scroll: Enchant Weapon (Grade A)
(21438,1868,1,1,2,36370),-- Thread
(21438,1873,1,1,2,7274),-- Silver Nugget
(21438,1876,1,1,2,3637),-- Mithril Ore
(21438,1895,1,1,2,5196),-- Metallic Fiber
(21438,4042,1,1,2,303),-- Enria
(21438,8729,1,1,200,242),-- Life Stone: level 64
(21438,8739,1,1,200,61),-- Mid-Grade Life Stone: level 64
(21438,8749,1,1,200,6),-- High-Grade Life Stone: level 64
(21438,8759,1,1,200,1),-- Top-Grade Life Stone: level 64
(21439,4116,1,1,-1,2781),-- Deadman\'s Glory Stone
(21439,4117,1,1,-1,2781),-- Art of Battle Axe Blade
(21439,5276,1,1,-1,848),-- Recipe: Greater Spiritshot (A) Compressed Package(100%)
(21439,57,252,511,0,700000),-- Adena
(21439,11932,1,1,1,31),-- Common Item - Lance
(21439,4115,1,1,1,410),-- Lance Blade
(21439,1343,10,30,2,24412),-- Silver Arrow
(21439,1864,1,1,2,34177),-- Stem
(21439,1865,1,1,2,17088),-- Varnish
(21439,1866,1,1,2,11392),-- Suede
(21439,1868,1,1,2,34177),-- Thread
(21439,1873,1,1,2,6835),-- Silver Nugget
(21439,5456,1,1,2,6),-- Recipe: Tallum Glaive(60%)
(21439,8729,1,1,200,228),-- Life Stone: level 64
(21439,8739,1,1,200,57),-- Mid-Grade Life Stone: level 64
(21439,8749,1,1,200,6),-- High-Grade Life Stone: level 64
(21439,8759,1,1,200,1),-- Top-Grade Life Stone: level 64
(21440,1875,1,1,-1,46559),-- Stone of Purity
(21440,4040,1,1,-1,13968),-- Mold Lubricant
(21440,4099,1,1,-1,31353),-- Doom Boots Part
(21440,57,283,529,0,700000),-- Adena
(21440,12201,1,1,1,46),-- Common Item - Blue Wolf Tunic
(21440,12192,1,1,1,46),-- Common Item - Tunic of Doom
(21440,12203,1,1,1,73),-- Common Item - Blue Wolf Stockings
(21440,12205,1,1,1,73),-- Common Item - Stockings of Doom
(21440,4084,1,1,1,448),-- Blue Wolf Tunic Fabric
(21440,4085,1,1,1,448),-- Tunic of Doom Pattern
(21440,4086,1,1,1,605),-- Blue Wolf Stockings Pattern
(21440,4087,1,1,1,605),-- Stockings of Doom Pattern
(21440,1343,10,30,2,26791),-- Silver Arrow
(21440,1865,1,1,2,18754),-- Varnish
(21440,1870,1,1,2,18754),-- Coal
(21440,1875,1,1,2,1250),-- Stone of Purity
(21440,1879,1,1,2,3126),-- Cokes
(21440,4040,1,1,2,375),-- Mold Lubricant
(21440,6335,1,1,2,72),-- Recipe: Sealed Majestic Necklace(70%)
(21440,8730,1,1,200,208),-- Life Stone: level 67
(21440,8740,1,1,200,52),-- Mid-Grade Life Stone: level 67
(21440,8750,1,1,200,5),-- High-Grade Life Stone: level 67
(21440,8760,1,1,200,1),-- Top-Grade Life Stone: level 67
(21441,729,1,1,-1,75),-- Scroll: Enchant Weapon (Grade A)
(21441,5448,1,1,-1,252),-- Recipe: Soul Separator(60%)
(21441,5494,1,1,-1,14265),-- Sealed Dark Crystal Shield Fragment
(21441,57,269,546,0,700000),-- Adena
(21441,11946,1,1,1,7),-- Common Item - Dasparion\'s Staff
(21441,11949,1,1,1,7),-- Common Item - Meteor Shower
(21441,5532,1,1,1,85),-- Meteor Shower Head
(21441,5543,1,1,1,85),-- Dasparion\'s Staff Edge
(21441,8346,1,1,1,85),-- Hammer Piece of Destroyer
(21441,11958,1,1,1,7),-- Common Item - Destroyer Hammer
(21441,8341,1,1,1,85),-- Spiritual Eye Piece
(21441,11953,1,1,1,7),-- Common Item - Spiritual Eye
(21441,1343,10,30,2,26057),-- Silver Arrow
(21441,1865,1,1,2,18240),-- Varnish
(21441,1870,1,1,2,18240),-- Coal
(21441,1874,1,1,2,1216),-- Oriharukon Ore
(21441,4039,1,1,2,608),-- Mold Glue
(21441,4043,1,1,2,608),-- Asofe
(21441,5442,1,1,2,7),-- Recipe: Soul Bow(60%)
(21441,8730,1,1,200,203),-- Life Stone: level 67
(21441,8740,1,1,200,51),-- Mid-Grade Life Stone: level 67
(21441,8750,1,1,200,5),-- High-Grade Life Stone: level 67
(21441,8760,1,1,200,1),-- Top-Grade Life Stone: level 67
(21442,729,1,1,-1,78),-- Scroll: Enchant Weapon (Grade A)
(21442,5448,1,1,-1,260),-- Recipe: Soul Separator(60%)
(21442,6341,1,1,-1,19393),-- Sealed Phoenix Earring Gemstone
(21442,57,278,563,0,700000),-- Adena
(21442,11946,1,1,1,7),-- Common Item - Dasparion\'s Staff (no drop info, no material info)
(21442,11949,1,1,1,7),-- Common Item - Meteor Shower
(21442,5532,1,1,1,87),-- Meteor Shower Head
(21442,5543,1,1,1,88),-- Dasparion\'s Staff Edge
(21442,8346,1,1,1,87),-- Hammer Piece of Destroyer
(21442,11958,1,1,1,7),-- Common Item - Destroyer Hammer
(21442,8341,1,1,1,87),-- Spiritual Eye Piece
(21442,11953,1,1,1,7),-- Common Item - Spiritual Eye
(21442,1343,10,30,2,24655),-- Silver Arrow
(21442,1865,1,1,2,17259),-- Varnish
(21442,1870,1,1,2,17259),-- Coal
(21442,1874,1,1,2,1151),-- Oriharukon Ore
(21442,4039,1,1,2,575),-- Mold Glue
(21442,4043,1,1,2,575),-- Asofe
(21442,8487,1,1,2,9),-- Recipe: Destroyer Hammer (60%)
(21442,5450,1,1,2,6),-- Recipe: Dragon Grinder(60%)
(21442,8730,1,1,200,192),-- Life Stone: level 67
(21442,8740,1,1,200,48),-- Mid-Grade Life Stone: level 67
(21442,8750,1,1,200,5),-- High-Grade Life Stone: level 67
(21442,8760,1,1,200,1),-- Top-Grade Life Stone: level 67
(21443,3956,1,1,-1,3834),-- Recipe: Blessed Spiritshot A
(21443,4077,1,1,-1,129349),-- Doom Shield Fragment
(21443,4078,1,1,-1,42002),-- Blue Wolf Breastplate Part
(21443,57,1140,2309,0,700000),-- Adena
(21443,12204,1,1,1,189),-- Common Item - Blue Wolf Breastplate
(21443,12193,1,1,1,302),-- Common Item - Blue Wolf Gaiters
(21443,12184,1,1,1,116),-- Common Item - Doom Plate Armor
(21443,4078,1,1,1,2068),-- Blue Wolf Breastplate Part
(21443,4080,1,1,1,2912),-- Blue Wolf Gaiters Material
(21443,4081,1,1,1,1395),-- Doom Plate Armor Temper
(21443,1343,10,30,2,110307),-- Silver Arrow
(21443,1867,1,1,2,102953),-- Animal Skin
(21443,1872,1,1,2,102953),-- Animal Bone
(21443,1875,1,1,2,5148),-- Stone of Purity
(21443,1881,1,1,2,10295),-- Coarse Bone Powder
(21443,4041,1,1,2,671),-- Mold Hardener
(21443,5156,1,1,2,103),-- Recipe: Soulshot (A) Compressed Package (100%)
(21443,8729,1,1,200,1030),-- Life Stone: level 64
(21443,8739,1,1,200,257),-- Mid-Grade Life Stone: level 64
(21443,8749,1,1,200,26),-- High-Grade Life Stone: level 64
(21443,8759,1,1,200,5),-- Top-Grade Life Stone: level 64
(21444,3956,1,1,-1,3222),-- Recipe: Blessed Spiritshot A
(21444,4077,1,1,-1,108697),-- Doom Shield Fragment
(21444,4078,1,1,-1,35296),-- Blue Wolf Breastplate Part
(21444,57,958,1940,0,700000),-- Adena
(21444,12204,1,1,1,158),-- Common Item - Blue Wolf Breastplate
(21444,12193,1,1,1,253),-- Common Item - Blue Wolf Gaiters
(21444,12184,1,1,1,97),-- Common Item - Doom Plate Armor
(21444,4078,1,1,1,1738),-- Blue Wolf Breastplate Part
(21444,4080,1,1,1,2447),-- Blue Wolf Gaiters Material
(21444,4081,1,1,1,1172),-- Doom Plate Armor Temper
(21444,1343,10,30,2,92695),-- Silver Arrow
(21444,1867,1,1,2,86515),-- Animal Skin
(21444,1872,1,1,2,86515),-- Animal Bone
(21444,1875,1,1,2,4326),-- Stone of Purity
(21444,1881,1,1,2,8652),-- Coarse Bone Powder
(21444,4041,1,1,2,564),-- Mold Hardener
(21444,5156,1,1,2,86),-- Recipe: Soulshot (A) Compressed Package (100%)
(21444,8729,1,1,200,865),-- Life Stone: level 64
(21444,8739,1,1,200,216),-- Mid-Grade Life Stone: level 64
(21444,8749,1,1,200,22),-- High-Grade Life Stone: level 64
(21444,8759,1,1,200,4),-- Top-Grade Life Stone: level 64
(21445,1875,1,1,-1,166644),-- Stone of Purity
(21445,4118,1,1,-1,10349),-- Evil Spirit Head
(21445,5460,1,1,-1,1366),-- Recipe: Dasparion\'s Staff(60%)
(21445,57,992,2007,0,700000),-- Adena
(21445,11930,1,1,1,40),-- Common Item - Sword of Damascus
(21445,11943,1,1,1,40),-- Common Item - Wizard\'s Tear
(21445,11929,1,1,1,40),-- Common Item - Guardian Sword
(21445,4114,1,1,1,539),-- Sword of Damascus Blade
(21445,8336,1,1,1,539),-- Blade of the Wizard\'s Tear
(21445,8330,1,1,1,538),-- Guardian Sword Blade
(21445,1865,1,1,2,73836),-- Varnish
(21445,1870,1,1,2,73836),-- Coal
(21445,1875,1,1,2,4922),-- Stone of Purity
(21445,1879,1,1,2,12306),-- Cokes
(21445,4040,1,1,2,1477),-- Mold Lubricant
(21445,6329,1,1,2,424),-- Recipe: Sealed Phoenix Necklace(70%)
(21445,8729,1,1,200,985),-- Life Stone: level 64
(21445,8739,1,1,200,246),-- Mid-Grade Life Stone: level 64
(21445,8749,1,1,200,25),-- High-Grade Life Stone: level 64
(21445,8759,1,1,200,5),-- Top-Grade Life Stone: level 64
(21446,1885,1,1,-1,256299),-- High Grade Suede
(21446,4119,1,1,-1,13462),-- Demon Dagger Edge
(21446,5468,1,1,-1,1681),-- Recipe: Elemental Sword(60%)
(21446,57,1221,2470,0,700000),-- Adena
(21446,11935,1,1,1,49),-- Common Item - Deadman\'s Glory
(21446,11938,1,1,1,49),-- Common Item - Art of Battle Axe
(21446,11934,1,1,1,49),-- Common Item - Staff of Evil Spirits
(21446,4116,1,1,1,661),-- Deadman\'s Glory Stone
(21446,4117,1,1,1,661),-- Art of Battle Axe Blade
(21446,4118,1,1,1,627),-- Evil Spirit Head
(21446,1343,10,30,2,117984),-- Silver Arrow
(21446,1866,1,1,2,55059),-- Suede
(21446,1871,1,1,2,82589),-- Charcoal
(21446,1885,1,1,2,6883),-- High Grade Suede
(21446,4041,1,1,2,718),-- Mold Hardener
(21446,5220,1,1,2,3303),-- Metal Hardener
(21446,6331,1,1,2,630),-- Recipe: Sealed Phoenix Earring(70%)
(21446,8729,1,1,200,1101),-- Life Stone: level 64
(21446,8739,1,1,200,275),-- Mid-Grade Life Stone: level 64
(21446,8749,1,1,200,28),-- High-Grade Life Stone: level 64
(21446,8759,1,1,200,6),-- Top-Grade Life Stone: level 64
(21447,4052,1,1,-1,112651),-- Earring of Black Ore Piece
(21447,4118,1,1,-1,13173),-- Evil Spirit Head
(21447,5281,1,1,-1,4242),-- Recipe: Greater Blessed Spiritshot (A) Compressed Package(100%)
(21447,57,1260,2556,0,700000),-- Adena
(21447,12183,1,1,1,795),-- Common Item - Doom Shield
(21447,12202,1,1,1,556),-- Common Item - Blue Wolf Helmet
(21447,12185,1,1,1,556),-- Common Item - Doom Helmet
(21447,4077,1,1,1,7047),-- Doom Shield Fragment
(21447,4088,1,1,1,5920),-- Blue Wolf Helmet Design
(21447,4089,1,1,1,5920),-- Doom Helmet Pattern
(21447,1867,1,1,2,125314),-- Animal Skin
(21447,1869,1,1,2,93986),-- Iron Ore
(21447,1870,1,1,2,93986),-- Coal
(21447,1871,1,1,2,93986),-- Charcoal
(21447,1872,1,3,2,62657),-- Animal Bone
(21447,5462,1,1,2,35),-- Recipe: Branch of The Mother Tree(60%)
(21447,8729,1,1,200,1253),-- Life Stone: level 64
(21447,8739,1,1,200,313),-- Mid-Grade Life Stone: level 64
(21447,8749,1,1,200,31),-- High-Grade Life Stone: level 64
(21447,8759,1,1,200,7),-- Top-Grade Life Stone: level 64
(21448,4118,1,1,-1,16605),-- Evil Spirit Head
(21448,5281,1,1,-1,5348),-- Recipe: Greater Blessed Spiritshot (A) Compressed Package(100%)
(21448,57,1059,2148,0,700000),-- Adena
(21448,12183,1,1,1,668),-- Common Item - Doom Shield
(21448,12202,1,1,1,468),-- Common Item - Blue Wolf Helmet
(21448,12185,1,1,1,468),-- Common Item - Doom Helmet
(21448,4077,1,1,1,5921),-- Doom Shield Fragment
(21448,4088,1,1,1,4975),-- Blue Wolf Helmet Design
(21448,4089,1,1,1,4975),-- Doom Helmet Pattern
(21448,1867,1,1,2,105306),-- Animal Skin
(21448,1869,1,1,2,78980),-- Iron Ore
(21448,1870,1,1,2,78980),-- Coal
(21448,1871,1,1,2,78980),-- Charcoal
(21448,1872,1,1,2,105306),-- Animal Bone
(21448,5462,1,1,2,29),-- Recipe: Branch of The Mother Tree(60%)
(21448,8729,1,1,200,1053),-- Life Stone: level 64
(21448,8739,1,1,200,263),-- Mid-Grade Life Stone: level 64
(21448,8749,1,1,200,26),-- High-Grade Life Stone: level 64
(21448,8759,1,1,200,6),-- Top-Grade Life Stone: level 64
(21449,4040,1,1,-1,70231),-- Mold Lubricant
(21449,4041,1,1,-1,30535),-- Mold Hardener
(21449,5496,1,1,-1,82334),-- Sealed Dark Crystal Boots Lining
(21449,57,1389,2824,0,700000),-- Adena
(21449,11950,1,1,1,143),-- Common Item - Blood Tornado
(21449,5539,1,1,1,1749),-- Blood Tornado Edge
(21449,1866,1,1,2,69151),-- Suede
(21449,1871,1,1,2,103726),-- Charcoal
(21449,1877,1,1,2,4149),-- Adamantite Nugget
(21449,4040,1,1,2,2075),-- Mold Lubricant
(21449,4041,1,1,2,902),-- Mold Hardener
(21449,5448,1,1,2,38),-- Recipe: Soul Separator(60%)
(21449,8730,1,1,200,1152),-- Life Stone: level 67
(21449,8740,1,1,200,288),-- Mid-Grade Life Stone: level 67
(21449,8750,1,1,200,29),-- High-Grade Life Stone: level 67
(21449,8760,1,1,200,6),-- Top-Grade Life Stone: level 67
(21450,5450,1,1,-1,1258),-- Recipe: Dragon Grinder(60%)
(21450,5456,1,1,-1,1258),-- Recipe: Tallum Glaive(60%)
(21450,5497,1,1,-1,79631),-- Sealed Tallum Boots Lining
(21450,57,1343,2731,0,700000),-- Adena
(21450,11955,1,1,1,138),-- Common Item - Carnage Bow
(21450,5535,1,1,1,1712),-- Carnage Bow Stave
(21450,1343,10,30,2,130286),-- Silver Arrow
(21450,1867,1,1,2,121600),-- Animal Skin
(21450,1872,1,1,2,121600),-- Animal Bone
(21450,1875,1,1,2,6080),-- Stone of Purity
(21450,1881,1,1,2,12160),-- Coarse Bone Powder
(21450,4041,1,1,2,793),-- Mold Hardener
(21450,5450,1,1,2,34),-- Recipe: Dragon Grinder(60%)
(21450,8730,1,1,200,1013),-- Life Stone: level 67
(21450,8740,1,1,200,253),-- Mid-Grade Life Stone: level 67
(21450,8750,1,1,200,25),-- High-Grade Life Stone: level 67
(21450,8760,1,1,200,5),-- Top-Grade Life Stone: level 67
(21451,1807,1,1,-1,1522),-- Recipe: Soulshot: A-Grade
(21451,4041,1,1,-1,9924),-- Mold Hardener
(21451,4080,1,1,-1,23474),-- Blue Wolf Gaiters Material
(21451,57,452,917,0,700000),-- Adena
(21451,11935,1,1,1,18),-- Common Item - Deadman\'s Glory
(21451,11938,1,1,1,18),-- Common Item - Art of Battle Axe
(21451,11934,1,1,1,18),-- Common Item - Staff of Evil Spirits
(21451,4116,1,1,1,246),-- Deadman\'s Glory Stone
(21451,4117,1,1,1,246),-- Art of Battle Axe Blade
(21451,4118,1,1,1,233),-- Evil Spirit Head
(21451,730,1,1,2,26),-- Scroll: Enchant Armor (Grade A)
(21451,1343,10,30,2,43778),-- Silver Arrow
(21451,1866,1,1,2,20430),-- Suede
(21451,1871,1,1,2,30645),-- Charcoal
(21451,1885,1,1,2,2554),-- High Grade Suede
(21451,4041,1,1,2,267),-- Mold Hardener
(21451,5220,1,1,2,1226),-- Metal Hardener
(21451,8729,1,1,200,409),-- Life Stone: level 64
(21451,8739,1,1,200,102),-- Mid-Grade Life Stone: level 64
(21451,8749,1,1,200,10),-- High-Grade Life Stone: level 64
(21451,8759,1,1,200,2),-- Top-Grade Life Stone: level 64
(21452,1875,1,1,-1,164372),-- Stone of Purity
(21452,3035,1,1,-1,3287),-- Recipe: Spiritshot A
(21452,4081,1,1,-1,24301),-- Doom Plate Armor Temper
(21452,57,981,1985,0,700000); -- Adena

INSERT INTO `droplist` VALUES 
(21453,3956,1,1,-1,2763),-- Recipe: Blessed Spiritshot A
(21453,4082,1,1,-1,23411),-- Blue Wolf Leather Armor Texture
(21453,4083,1,1,-1,23411),-- Leather Armor of Doom Design
(21453,57,824,1668,0,700000),-- Adena
(21454,1884,1,3,-1,758639),-- Cord
(21454,1889,1,1,-1,164372),-- Compound Braid
(21454,4084,1,1,-1,42850),-- Blue Wolf Tunic Fabric
(21454,57,981,1985,0,700000),-- Adena
(21455,4085,1,1,-1,36008),-- Tunic of Doom Pattern
(21455,5156,1,1,-1,2763),-- Recipe: Soulshot (A) Compressed Package (100%)
(21455,5161,1,1,-1,2763),-- Recipe: Spiritshot (A) Compressed Package (100%)
(21455,57,824,1668,0,700000),-- Adena
(21456,1884,1,3,-1,928569),-- Cord
(21456,4039,1,1,-1,100595),-- Mold Glue
(21456,4086,1,1,-1,70817),-- Blue Wolf Stockings Pattern
(21456,11935,1,1,1,49),-- Common Item - Deadman\'s Glory
(21456,11938,1,1,1,49),-- Common Item - Art of Battle Axe
(21456,11934,1,1,1,49),-- Common Item - Staff of Evil Spirits
(21456,4116,1,1,1,649),-- Deadman\'s Glory Stone
(21456,4117,1,1,1,649),-- Art of Battle Axe Blade
(21456,4118,1,1,1,615),-- Evil Spirit Head
(21456,1864,1,1,2,178285),-- Stem
(21456,1869,1,1,2,89143),-- Iron Ore
(21456,1878,1,1,2,35657),-- Braided Hemp
(21456,1884,1,1,2,54857),-- Cord
(21456,4039,1,1,2,2972),-- Mold Glue
(21456,5450,1,1,2,33),-- Recipe: Dragon Grinder(60%)
(21456,8729,1,1,200,1189),-- Life Stone: level 64
(21456,8739,1,1,200,297),-- Mid-Grade Life Stone: level 64
(21456,8749,1,1,200,30),-- High-Grade Life Stone: level 64
(21456,8759,1,1,200,6),-- Top-Grade Life Stone: level 64
(21457,4087,1,1,-1,59510),-- Stockings of Doom Pattern
(21457,4088,1,1,-1,95843),-- Blue Wolf Helmet Design
(21457,5166,1,1,-1,3381),-- Recipe: Blessed Spiritshot (A) Compressed Package (100%)
(21457,12341,1,1,1,579),-- Common Item - Earring of Black Ore
(21457,12343,1,1,1,867),-- Common Item - Ring of Black Ore
(21457,12342,1,1,1,434),-- Common Item - Necklace of Black Ore
(21457,4052,1,1,1,4420),-- Earring of Black Ore Piece
(21457,4053,1,1,1,5352),-- Ring of Black Ore Gemstone
(21457,4054,1,1,1,2459),-- Necklace of Black Ore Beads
(21457,1343,10,30,2,97285),-- Silver Arrow
(21457,1866,1,1,2,45400),-- Suede
(21457,1871,1,1,2,68100),-- Charcoal
(21457,1885,1,1,2,5675),-- High Grade Suede
(21457,4041,1,1,2,592),-- Mold Hardener
(21457,5220,1,1,2,2724),-- Metal Hardener
(21457,5456,1,1,2,25),-- Recipe: Tallum Glaive(60%)
(21457,8729,1,1,200,908),-- Life Stone: level 64
(21457,8739,1,1,200,227),-- Mid-Grade Life Stone: level 64
(21457,8749,1,1,200,23),-- High-Grade Life Stone: level 64
(21457,8759,1,1,200,5),-- Top-Grade Life Stone: level 64
(21458,4041,1,1,-1,26242),-- Mold Hardener
(21458,4089,1,1,-1,114053),-- Doom Helmet Pattern
(21458,5230,1,1,-1,4024),-- Recipe: Mithril Arrow (100%)
(21458,12188,1,1,1,593),-- Common Item - Boots of Doom
(21458,12189,1,1,1,593),-- Common Item - Blue Wolf Boots
(21458,12187,1,1,1,593),-- Common Item - Doom Gloves
(21458,12190,1,1,1,593),-- Common Item - Blue Wolf Gloves
(21458,4090,1,1,1,5003),-- Blue Wolf Boots Design
(21458,4091,1,1,1,5003),-- Doom Gloves Part
(21458,4096,1,1,1,5003),-- Blue Wolf Gloves Fabric
(21458,4099,1,1,1,5003),-- Doom Boots Part
(21458,1866,1,1,2,54026),-- Suede
(21458,1871,1,1,2,81039),-- Charcoal
(21458,1877,1,1,2,3242),-- Adamantite Nugget
(21458,4040,1,1,2,1621),-- Mold Lubricant
(21458,4041,1,1,2,705),-- Mold Hardener
(21458,5370,1,1,2,699),-- Recipe: Sealed Tallum Boots(60%)
(21458,5462,1,1,2,30),-- Recipe: Branch of The Mother Tree(60%)
(21458,8729,1,1,200,1081),-- Life Stone: level 64
(21458,8739,1,1,200,270),-- Mid-Grade Life Stone: level 64
(21458,8749,1,1,200,27),-- High-Grade Life Stone: level 64
(21458,8759,1,1,200,5),-- Top-Grade Life Stone: level 64
(21459,1894,1,1,-1,88983),-- Crafted Leather
(21459,4090,1,1,-1,113850),-- Blue Wolf Boots Design
(21459,5271,1,1,-1,3381),-- Recipe: Greater Soulshot (A) Compressed Package(100%)
(21459,11933,1,1,1,122),-- Common Item - Bellion Cestus
(21459,4120,1,1,1,1637),-- Bellion Cestus Edge
(21459,1343,10,30,2,89178),-- Silver Arrow
(21459,1867,1,1,2,83233),-- Animal Skin
(21459,1872,1,1,2,83233),-- Animal Bone
(21459,1882,1,1,2,13872),-- Leather
(21459,1894,1,1,2,2190),-- Crafted Leather
(21459,4042,1,1,2,1040),-- Enria
(21459,5364,1,1,2,512),-- Recipe: Sealed Dark Crystal Shield(60%)
(21459,5464,1,1,2,23),-- Recipe: Dark Legion\'s Edge(60%)
(21459,8729,1,1,200,832),-- Life Stone: level 64
(21459,8739,1,1,200,208),-- Mid-Grade Life Stone: level 64
(21459,8749,1,1,200,21),-- High-Grade Life Stone: level 64
(21459,8759,1,1,200,4),-- Top-Grade Life Stone: level 64
(21460,4091,1,2,-1,231933),-- Doom Gloves Part
(21460,4096,1,1,-1,231933),-- Blue Wolf Gloves Fabric
(21460,5276,1,1,-1,6888),-- Recipe: Greater Spiritshot (A) Compressed Package(100%)
(21460,57,2055,4158,0,700000),-- Adena
(21461,1876,1,3,-1,537011),-- Mithril Ore
(21461,4042,1,1,-1,89502),-- Enria
(21461,4099,1,1,-1,241083),-- Doom Boots Part
(21461,57,2136,4322,0,700000),-- Adena
(21462,4114,1,1,-1,22614),-- Sword of Damascus Blade
(21462,5281,1,1,-1,6888),-- Recipe: Greater Blessed Spiritshot (A) Compressed Package(100%)
(21462,5438,1,1,-1,2823),-- Recipe: Meteor Shower(60%)
(21462,57,2055,4158,0,700000),-- Adena
(21463,1875,1,1,-1,331238),-- Stone of Purity
(21463,4041,1,1,-1,43205),-- Mold Hardener
(21463,4115,1,1,-1,21675),-- Lance Blade
(21463,57,1976,3999,0,700000),-- Adena
(21464,4116,1,1,-1,27632),-- Deadman\'s Glory Stone
(21464,4117,1,1,-1,27632),-- Art of Battle Axe Blade
(21464,5444,1,1,-1,3455),-- Recipe: Carnage Bow(60%)
(21464,11935,1,1,1,102),-- Common Item - Deadman\'s Glory
(21464,11938,1,1,1,102),-- Common Item - Art of Battle Axe
(21464,11934,1,1,1,102),-- Common Item - Staff of Evil Spirits
(21464,4116,1,1,1,1360),-- Deadman\'s Glory Stone
(21464,4117,1,1,1,1360),-- Art of Battle Axe Blade
(21464,4118,1,1,1,1289),-- Evil Spirit Head
(21464,729,1,1,2,21),-- Scroll: Enchant Weapon (Grade A)
(21464,1867,1,3,2,124525),-- Animal Skin
(21464,1872,1,1,2,249049),-- Animal Bone
(21464,1882,1,1,2,41508),-- Leather
(21464,1894,1,1,2,6554),-- Crafted Leather
(21464,4042,1,1,2,3113),-- Enria
(21464,8729,1,1,200,2490),-- Life Stone: level 64
(21464,8739,1,1,200,623),-- Mid-Grade Life Stone: level 64
(21464,8749,1,1,200,62),-- High-Grade Life Stone: level 64
(21464,8759,1,1,200,14),-- Top-Grade Life Stone: level 64
(21465,4118,1,1,-1,27213),-- Evil Spirit Head
(21465,5220,1,1,-1,262919),-- Metal Hardener
(21465,5446,1,1,-1,3592),-- Recipe: Bloody Orchid(60%)
(21465,12341,1,1,1,1502),-- Common Item - Earring of Black Ore
(21465,12343,1,1,1,2247),-- Common Item - Ring of Black Ore
(21465,12342,1,1,1,1126),-- Common Item - Necklace of Black Ore
(21465,4052,1,1,1,11457),-- Earring of Black Ore Piece
(21465,4053,1,1,1,13870),-- Ring of Black Ore Gemstone
(21465,4054,1,1,1,6374),-- Necklace of Black Ore Beads
(21465,730,1,1,2,135),-- Scroll: Enchant Armor (Grade A)
(21465,1343,10,30,2,231139),-- Silver Arrow
(21465,1874,1,1,2,10786),-- Oriharukon Ore
(21465,1878,1,1,2,64719),-- Braided Hemp
(21465,1884,1,1,2,99567),-- Cord
(21465,1889,1,1,2,10786),-- Compound Braid
(21465,5220,1,1,2,6472),-- Metal Hardener
(21465,5370,1,1,2,1395),-- Recipe: Sealed Tallum Boots(60%)
(21465,8729,1,1,200,2157),-- Life Stone: level 64
(21465,8739,1,1,200,539),-- Mid-Grade Life Stone: level 64
(21465,8749,1,1,200,54),-- High-Grade Life Stone: level 64
(21465,8759,1,1,200,11),-- Top-Grade Life Stone: level 64
(21466,4042,1,1,-1,105392),-- Enria
(21466,4119,1,1,-1,27679),-- Demon Dagger Edge
(21466,5452,1,1,-1,3455),-- Recipe: Blood Tornado(60%)
(21466,12188,1,1,1,1242),-- Common Item - Boots of Doom
(21466,12189,1,1,1,1242),-- Common Item - Blue Wolf Boots
(21466,12187,1,1,1,1242),-- Common Item - Doom Gloves
(21466,12190,1,1,1,1242),-- Common Item - Blue Wolf Gloves
(21466,4090,1,1,1,10482),-- Blue Wolf Boots Design
(21466,4091,1,1,1,10482),-- Doom Gloves Part
(21466,4096,1,1,1,10482),-- Blue Wolf Gloves Fabric
(21466,4099,1,1,1,10482),-- Doom Boots Part
(21466,1867,1,3,2,113204),-- Animal Skin
(21466,1872,1,1,2,226408),-- Animal Bone
(21466,1882,1,1,2,37735),-- Leather
(21466,1894,1,1,2,5958),-- Crafted Leather
(21466,4042,1,1,2,2830),-- Enria
(21466,5368,1,1,2,1464),-- Recipe: Sealed Dark Crystal Boots(60%)
(21466,5434,1,1,2,63),-- Recipe: Dragon Slayer(60%)
(21466,8729,1,1,200,2264),-- Life Stone: level 64
(21466,8739,1,1,200,566),-- Mid-Grade Life Stone: level 64
(21466,8749,1,1,200,57),-- High-Grade Life Stone: level 64
(21466,8759,1,1,200,12),-- Top-Grade Life Stone: level 64
(21467,4120,1,1,-1,26575),-- Bellion Cestus Edge
(21467,4121,1,1,-1,26486),-- Bow of Peril Shaft
(21467,5458,1,1,-1,3323),-- Recipe: Halberd(60%)
(21467,11933,1,1,1,293),-- Common Item - Bellion Cestus
(21467,4120,1,1,1,3925),-- Bellion Cestus Edge
(21467,1343,30,90,2,71285),-- Silver Arrow
(21467,1864,4,12,2,37425),-- Stem
(21467,1869,1,1,2,149698),-- Iron Ore
(21467,1878,1,1,2,59879),-- Braided Hemp
(21467,1884,1,1,2,92122),-- Cord
(21467,4039,1,1,2,4990),-- Mold Glue
(21467,5440,1,1,2,55),-- Recipe: Elysian(60%)
(21467,5368,1,1,2,1291),-- Recipe: Sealed Dark Crystal Boots(60%)
(21467,8729,1,1,200,1996),-- Life Stone: level 64
(21467,8739,1,1,200,499),-- Mid-Grade Life Stone: level 64
(21467,8749,1,1,200,50),-- High-Grade Life Stone: level 64
(21467,8759,1,1,200,10),-- Top-Grade Life Stone: level 64
(21468,4052,1,1,-1,308357),-- Earring of Black Ore Piece
(21468,5220,1,1,-1,348382),-- Metal Hardener
(21468,5370,1,1,-1,37541),-- Recipe: Sealed Tallum Boots(60%)
(21468,57,3464,7010,0,700000),-- Adena
(21469,4053,1,1,-1,356108),-- Ring of Black Ore Gemstone
(21469,5460,1,1,-1,4540),-- Recipe: Dasparion\'s Staff(60%)
(21469,5468,1,1,-1,4540),-- Recipe: Elemental Sword(60%)
(21469,57,3305,6687,0,700000),-- Adena
(21470,4114,1,1,-1,5334),-- Sword of Damascus Blade
(21470,5156,1,1,-1,1625),-- Recipe: Soulshot (A) Compressed Package (100%)
(21470,5161,1,1,-1,1625),-- Recipe: Spiritshot (A) Compressed Package (100%)
(21470,57,480,982,0,700000),-- Adena
(21470,12188,1,1,1,239),-- Common Item - Boots of Doom
(21470,12189,1,1,1,239),-- Common Item - Blue Wolf Boots
(21470,12187,1,1,1,239),-- Common Item - Doom Gloves
(21470,12190,1,1,1,239),-- Common Item - Blue Wolf Gloves
(21470,4090,1,1,1,2020),-- Blue Wolf Boots Design
(21470,4091,1,1,1,2020),-- Doom Gloves Part
(21470,4096,1,1,1,2020),-- Blue Wolf Gloves Fabric
(21470,4099,1,1,1,2020),-- Doom Boots Part
(21470,1866,1,1,2,21815),-- Suede
(21470,1871,1,1,2,32722),-- Charcoal
(21470,1885,1,1,2,2727),-- High Grade Suede
(21470,4041,1,1,2,285),-- Mold Hardener
(21470,5220,1,1,2,1309),-- Metal Hardener
(21470,6337,1,1,2,168),-- Recipe: Sealed Majestic Earring(70%)
(21470,5364,1,1,2,268),-- Recipe: Sealed Dark Crystal Shield(60%)
(21470,8730,1,1,200,364),-- Life Stone: level 67
(21470,8740,1,1,200,91),-- Mid-Grade Life Stone: level 67
(21470,8750,1,1,200,9),-- High-Grade Life Stone: level 67
(21470,8760,1,1,200,2),-- Top-Grade Life Stone: level 67
(21471,1894,1,1,-1,92378),-- Crafted Leather
(21471,4042,1,1,-1,43879),-- Enria
(21471,4115,1,1,-1,11485),-- Lance Blade
(21471,57,1047,2119,0,700000),-- Adena
(21472,4116,1,1,-1,9668),-- Deadman\'s Glory Stone
(21472,4117,1,1,-1,9668),-- Art of Battle Axe Blade
(21472,5166,1,1,-1,2950),-- Recipe: Blessed Spiritshot (A) Compressed Package (100%)
(21472,57,880,1780,0,700000),-- Adena
(21473,4043,1,1,-1,87759),-- Asofe
(21473,4118,1,1,-1,10900),-- Evil Spirit Head
(21473,5230,1,1,-1,3510),-- Recipe: Mithril Arrow (100%)
(21473,57,1047,2119,0,700000),-- Adena
(21474,4039,1,1,-1,73747),-- Mold Glue
(21474,4119,1,1,-1,9684),-- Demon Dagger Edge
(21474,5271,1,1,-1,2950),-- Recipe: Greater Soulshot (A) Compressed Package(100%)
(21474,57,880,1780,0,700000),-- Adena
(21475,4120,1,1,-1,14081),-- Bellion Cestus Edge
(21475,4121,1,1,-1,14034),-- Bow of Peril Shaft
(21475,5276,1,1,-1,4296),-- Recipe: Greater Spiritshot (A) Compressed Package(100%)
(21475,12201,1,1,1,211),-- Common Item - Blue Wolf Tunic
(21475,12192,1,1,1,211),-- Common Item - Tunic of Doom
(21475,12203,1,1,1,338),-- Common Item - Blue Wolf Stockings
(21475,12205,1,1,1,338),-- Common Item - Stockings of Doom
(21475,4084,1,1,1,2068),-- Blue Wolf Tunic Fabric
(21475,4085,1,1,1,2068),-- Tunic of Doom Pattern
(21475,4086,1,1,1,2792),-- Blue Wolf Stockings Pattern
(21475,4087,1,1,1,2792),-- Stockings of Doom Pattern
(21475,1343,10,30,2,123615),-- Silver Arrow
(21475,1866,1,1,2,57687),-- Suede
(21475,1871,1,1,2,86531),-- Charcoal
(21475,1877,1,1,2,3461),-- Adamantite Nugget
(21475,4040,1,1,2,1731),-- Mold Lubricant
(21475,4041,1,1,2,753),-- Mold Hardener
(21475,5440,1,1,2,32),-- Recipe: Elysian(60%)
(21475,8730,1,1,200,962),-- Life Stone: level 67
(21475,8740,1,1,200,240),-- Mid-Grade Life Stone: level 67
(21475,8750,1,1,200,24),-- High-Grade Life Stone: level 67
(21475,8760,1,1,200,5),-- Top-Grade Life Stone: level 67
(21476,1875,1,1,-1,180534),-- Stone of Purity
(21476,4041,1,1,-1,23547),-- Mold Hardener
(21476,4052,1,1,-1,95871),-- Earring of Black Ore Piece
(21476,12204,1,1,1,178),-- Common Item - Blue Wolf Breastplate
(21476,12193,1,1,1,284),-- Common Item - Blue Wolf Gaiters
(21476,12184,1,1,1,109),-- Common Item - Doom Plate Armor
(21476,4078,1,1,1,1947),-- Blue Wolf Breastplate Part
(21476,4080,1,1,1,2742),-- Blue Wolf Gaiters Material
(21476,4081,1,1,1,1314),-- Doom Plate Armor Temper
(21476,1867,1,1,2,106648),-- Animal Skin
(21476,1872,1,1,2,106648),-- Animal Bone
(21476,1875,1,1,2,5332),-- Stone of Purity
(21476,1881,1,1,2,10665),-- Coarse Bone Powder
(21476,4041,1,1,2,696),-- Mold Hardener
(21476,5442,1,1,2,30),-- Recipe: Soul Bow(60%)
(21476,8730,1,1,200,889),-- Life Stone: level 67
(21476,8740,1,1,200,222),-- Mid-Grade Life Stone: level 67
(21476,8750,1,1,200,22),-- High-Grade Life Stone: level 67
(21476,8760,1,1,200,5),-- Top-Grade Life Stone: level 67
(21477,4053,1,1,-1,138121),-- Ring of Black Ore Gemstone
(21477,5281,1,1,-1,4296),-- Recipe: Greater Blessed Spiritshot (A) Compressed Package(100%)
(21477,5438,1,1,-1,1761),-- Recipe: Meteor Shower(60%)
(21477,12201,1,1,1,211),-- Common Item - Blue Wolf Tunic
(21477,12192,1,1,1,211),-- Common Item - Tunic of Doom
(21477,12203,1,1,1,338),-- Common Item - Blue Wolf Stockings
(21477,12205,1,1,1,338),-- Common Item - Stockings of Doom
(21477,4084,1,1,1,2068),-- Blue Wolf Tunic Fabric
(21477,4085,1,1,1,2068),-- Tunic of Doom Pattern
(21477,4086,1,1,1,2792),-- Blue Wolf Stockings Pattern
(21477,4087,1,1,1,2792),-- Stockings of Doom Pattern
(21477,1343,10,30,2,123615),-- Silver Arrow
(21477,1865,1,1,2,86530),-- Varnish
(21477,1870,1,1,2,86530),-- Coal
(21477,1875,1,1,2,5769),-- Stone of Purity
(21477,1879,1,1,2,14422),-- Cokes
(21477,4040,1,1,2,17731),-- Mold Lubricant
(21477,5448,1,1,2,32),-- Recipe: Soul Separator(60%)
(21477,8730,1,1,200,961),-- Life Stone: level 67
(21477,8740,1,1,200,240),-- Mid-Grade Life Stone: level 67
(21477,8750,1,1,200,24),-- High-Grade Life Stone: level 67
(21477,8760,1,1,200,5),-- Top-Grade Life Stone: level 67
(21478,1885,1,1,-1,225655),-- High Grade Suede
(21478,4041,1,1,-1,23547),-- Mold Hardener
(21478,4054,1,1,-1,53336),-- Necklace of Black Ore Beads
(21478,12341,1,1,1,619),-- Common Item - Earring of Black Ore
(21478,12343,1,1,1,926),-- Common Item - Ring of Black Ore
(21478,12342,1,1,1,464),-- Common Item - Necklace of Black Ore
(21478,4052,1,1,1,4720),-- Earring of Black Ore Piece
(21478,4053,1,1,1,5714),-- Ring of Black Ore Gemstone
(21478,4054,1,1,1,2626),-- Necklace of Black Ore Beads
(21478,1866,1,1,2,53324),-- Suede
(21478,1871,1,1,2,79986),-- Charcoal
(21478,1885,1,1,2,6666),-- High Grade Suede
(21478,4041,1,1,2,696),-- Mold Hardener
(21478,5220,1,1,2,3199),-- Metal Hardener
(21478,5450,1,1,2,30),-- Recipe: Dragon Grinder(60%)
(21478,8730,1,1,200,889),-- Life Stone: level 67
(21478,8740,1,1,200,222),-- Mid-Grade Life Stone: level 67
(21478,8750,1,1,200,22),-- High-Grade Life Stone: level 67
(21478,8760,1,1,200,4),-- Top-Grade Life Stone: level 67
(21479,4077,1,1,-1,248161),-- Doom Shield Fragment
(21479,4078,1,1,-1,80582),-- Blue Wolf Breastplate Part
(21479,5444,1,1,-1,3015),-- Recipe: Carnage Bow(60%)
(21479,57,2194,4439,0,700000),-- Adena
(21480,1889,1,1,-1,382283),-- Compound Braid
(21480,4080,1,1,-1,117952),-- Blue Wolf Gaiters Material
(21480,5446,1,1,-1,3133),-- Recipe: Bloody Orchid(60%)
(21480,57,2281,4615,0,700000),-- Adena
(21481,4081,1,1,-1,54372),-- Doom Plate Armor Temper
(21481,5452,1,1,-1,3015),-- Recipe: Blood Tornado(60%)
(21481,5550,1,1,-1,73555),-- Durable Metal Plate
(21481,57,2194,4439,0,700000),-- Adena
(21482,4082,1,1,-1,59949),-- Blue Wolf Leather Armor Texture
(21482,4083,1,1,-1,59949),-- Leather Armor of Doom Design
(21482,5458,1,1,-1,2899),-- Recipe: Halberd(60%)
(21482,57,2110,4270,0,700000),-- Adena
(21483,1877,1,1,-1,270082),-- Adamantite Nugget
(21483,4040,1,1,-1,135041),-- Mold Lubricant
(21483,5364,1,1,-1,55345),-- Recipe: Sealed Dark Crystal Shield(60%)
(21483,11944,1,1,1,326),-- Common Item - Bow of Peril
(21483,4121,1,1,1,4343),-- Bow of Peril Shaft
(21483,1343,20,60,2,129509),-- Silver Arrow
(21483,1866,1,1,2,120875),-- Suede
(21483,1871,1,1,2,181313),-- Charcoal
(21483,1877,1,1,2,7252),-- Adamantite Nugget
(21483,4040,1,1,2,3626),-- Mold Lubricant
(21483,4041,1,1,2,1577),-- Mold Hardener
(21483,6335,1,1,2,698),-- Recipe: Sealed Majestic Necklace(70%)
(21483,8730,1,1,200,2015),-- Life Stone: level 67
(21483,8740,1,1,200,504),-- Mid-Grade Life Stone: level 67
(21483,8750,1,1,200,51),-- High-Grade Life Stone: level 67
(21483,8760,1,1,200,10),-- Top-Grade Life Stone: level 67
(21484,4085,1,1,-1,121974),-- Tunic of Doom Pattern
(21484,5460,1,1,-1,3835),-- Recipe: Dasparion\'s Staff(60%)
(21484,5468,1,1,-1,3835),-- Recipe: Elemental Sword(60%)
(21484,12201,1,1,1,460),-- Common Item - Blue Wolf Tunic
(21484,12192,1,1,1,460),-- Common Item - Tunic of Doom
(21484,12203,1,1,1,736),-- Common Item - Blue Wolf Stockings
(21484,12205,1,1,1,736),-- Common Item - Stockings of Doom
(21484,4084,1,1,1,4504),-- Blue Wolf Tunic Fabric
(21484,4085,1,1,1,4504),-- Tunic of Doom Pattern
(21484,4086,1,1,1,6081),-- Blue Wolf Stockings Pattern
(21484,4087,1,1,1,6081),-- Stockings of Doom Pattern
(21484,1867,1,1,2,276418),-- Animal Skin
(21484,1872,1,3,2,138209),-- Animal Bone
(21484,1875,1,1,2,13821),-- Stone of Purity
(21484,1881,1,1,2,27642),-- Coarse Bone Powder
(21484,4041,1,1,2,1803),-- Mold Hardener
(21484,6337,1,1,2,1063),-- Recipe: Sealed Majestic Earring(70%)
(21484,8730,1,1,200,2304),-- Life Stone: level 67
(21484,8740,1,1,200,576),-- Mid-Grade Life Stone: level 67
(21484,8750,1,1,200,58),-- High-Grade Life Stone: level 67
(21484,8760,1,1,200,11),-- Top-Grade Life Stone: level 67
(21485,4040,1,1,-1,135041),-- Mold Lubricant
(21485,4086,1,1,-1,158443),-- Blue Wolf Stockings Pattern
(21485,5368,1,1,-1,58207),-- Recipe: Sealed Dark Crystal Boots(60%)
(21485,12341,1,1,1,1542),-- Common Item - Earring of Black Ore
(21485,12343,1,1,1,2308),-- Common Item - Ring of Black Ore
(21485,12342,1,1,1,1156),-- Common Item - Necklace of Black Ore
(21485,4052,1,1,1,11769),-- Earring of Black Ore Piece
(21485,4053,1,1,1,14248),-- Ring of Black Ore Gemstone
(21485,4054,1,1,1,6547),-- Necklace of Black Ore Beads
(21485,1343,20,60,2,129510),-- Silver Arrow
(21485,1865,1,3,2,60438),-- Varnish
(21485,1870,1,1,2,181313),-- Coal
(21485,1875,1,1,2,12087),-- Stone of Purity
(21485,1879,1,1,2,30219),-- Cokes
(21485,4040,1,1,2,3626),-- Mold Lubricant
(21485,6339,1,1,2,1395),-- Recipe: Sealed Majestic Ring(70%)
(21485,8730,1,1,200,2014),-- Life Stone: level 67
(21485,8740,1,1,200,504),-- Mid-Grade Life Stone: level 67
(21485,8750,1,1,200,51),-- High-Grade Life Stone: level 67
(21485,8760,1,1,200,10),-- Top-Grade Life Stone: level 67
(21486,4087,1,1,-1,152379),-- Stockings of Doom Pattern
(21486,4088,1,1,-1,245413),-- Blue Wolf Helmet Design
(21486,5470,1,1,-1,3548),-- Recipe: Tallum Blade(60%)
(21486,12204,1,1,1,426),-- Common Item - Blue Wolf Breastplate
(21486,12193,1,1,1,681),-- Common Item - Blue Wolf Gaiters
(21486,12184,1,1,1,262),-- Common Item - Doom Plate Armor
(21486,4078,1,1,1,4670),-- Blue Wolf Breastplate Part
(21486,4080,1,1,1,6576),-- Blue Wolf Gaiters Material
(21486,4081,1,1,1,3151),-- Doom Plate Armor Temper
(21486,729,1,1,2,21),-- Scroll: Enchant Weapon (Grade A)
(21486,1866,1,1,2,127874),-- Suede
(21486,1871,1,1,2,191812),-- Charcoal
(21486,1885,1,1,2,15984),-- High Grade Suede
(21486,4041,1,1,2,1668),-- Mold Hardener
(21486,5220,1,1,2,7673),-- Metal Hardener
(21486,8730,1,1,200,2131),-- Life Stone: level 67
(21486,8740,1,1,200,533),-- Mid-Grade Life Stone: level 67
(21486,8750,1,1,200,53),-- High-Grade Life Stone: level 67
(21486,8760,1,1,200,11),-- Top-Grade Life Stone: level 67
(21487,1894,1,1,-1,326320),-- Crafted Leather
(21487,4089,1,1,-1,351478),-- Doom Helmet Pattern
(21487,5428,1,1,-1,7816),-- Recipe: Sealed Tallum Helmet(60%)
(21487,57,3699,7484,0,700000),-- Adena
(21488,4044,1,1,-1,295712),-- Thons
(21488,4090,1,1,-1,398265),-- Blue Wolf Boots Design
(21488,5426,1,1,-1,6995),-- Recipe: Sealed Dark Crystal Helmet(60%)
(21488,57,3528,7139,0,700000),-- Adena
(21489,1877,1,1,-1,51987),-- Adamantite Nugget
(21489,4040,1,1,-1,25994),-- Mold Lubricant
(21489,6343,1,1,-1,27789),-- Sealed Phoenix Necklace Beads
(21489,57,514,1045,0,700000),-- Adena
(21489,11950,1,1,1,53),-- Common Item - Blood Tornado
(21489,5539,1,1,1,647),-- Blood Tornado Edge
(21489,1866,1,1,2,25594),-- Suede
(21489,1871,1,1,2,38391),-- Charcoal
(21489,1877,1,1,2,1536),-- Adamantite Nugget
(21489,4040,1,1,2,768),-- Mold Lubricant
(21489,4041,1,1,2,334),-- Mold Hardener
(21489,5456,1,1,2,14),-- Recipe: Tallum Glaive(60%)
(21489,8730,1,1,200,427),-- Life Stone: level 67
(21489,8740,1,1,200,107),-- Mid-Grade Life Stone: level 67
(21489,8750,1,1,200,11),-- High-Grade Life Stone: level 67
(21489,8760,1,1,200,2),-- Top-Grade Life Stone: level 67
(21490,5450,1,1,-1,1040),-- Recipe: Dragon Grinder(60%)
(21490,5456,1,1,-1,1040),-- Recipe: Tallum Glaive(60%)
(21490,6345,1,1,-1,107412),-- Sealed Phoenix Ring Gemstone
(21490,57,1116,2260,0,700000),-- Adena
(21491,730,1,1,-1,1966),-- Scroll: Enchant Armor (Grade A)
(21491,4041,1,1,-1,20517),-- Mold Hardener
(21491,5478,1,1,-1,19841),-- Sealed Dark Crystal Leather Armor Pattern
(21491,57,938,1899,0,700000),-- Adena
(21492,4040,1,1,-1,56155),-- Mold Lubricant
(21492,5462,1,1,-1,1040),-- Recipe: Branch of The Mother Tree(60%)
(21492,5479,1,1,-1,16614),-- Sealed Tallum Leather Armor Pattern
(21492,57,1116,2260,0,700000),-- Adena
(21493,5464,1,1,-1,874),-- Recipe: Dark Legion\'s Edge(60%)
(21493,5482,1,1,-1,31142),-- Sealed Dark Crystalline Leggings Design
(21493,5485,1,1,-1,19841),-- Sealed Tallum Tunic Texture
(21493,57,938,1899,0,700000),-- Adena
(21494,729,1,1,-1,382),-- Scroll: Enchant Weapon (Grade A)
(21494,1876,1,1,-1,687390),-- Mithril Ore
(21494,4042,1,1,-1,57282),-- Enria
(21494,11955,1,1,1,140),-- Common Item - Carnage Bow
(21494,5535,1,1,1,1732),-- Carnage Bow Stave
(21494,1343,10,30,2,131846),-- Silver Arrow
(21494,1868,1,1,2,184585),-- Thread
(21494,1873,1,1,2,36917),-- Silver Nugget
(21494,1876,1,1,2,18459),-- Mithril Ore
(21494,1895,1,1,2,26369),-- Metallic Fiber
(21494,4042,1,1,2,1538),-- Enria
(21494,6337,1,1,2,473),-- Recipe: Sealed Majestic Earring(70%)
(21494,8730,1,1,200,1025),-- Life Stone: level 67
(21494,8740,1,1,200,257),-- Mid-Grade Life Stone: level 67
(21494,8750,1,1,200,46),-- High-Grade Life Stone: level 67
(21494,8760,1,1,200,5),-- Top-Grade Life Stone: level 67
(21495,5466,1,1,-1,1070),-- Recipe: Sword of Miracles(60%)
(21495,5486,1,1,-1,17090),-- Sealed Dark Crystal Robe Fabric
(21495,5489,1,1,-1,38120),-- Sealed Tallum Stockings Fabric
(21495,11951,1,1,1,117),-- Common Item - Bloody Orchid
(21495,5536,1,1,1,1452),-- Bloody Orchid Head
(21495,1868,1,1,2,170626),-- Thread
(21495,1873,1,1,2,34125),-- Silver Nugget
(21495,1876,1,1,2,17063),-- Mithril Ore
(21495,1895,1,1,2,24375),-- Metallic Fiber
(21495,4042,1,1,2,1422),-- Enria
(21495,6339,1,1,2,656),-- Recipe: Sealed Majestic Ring(70%)
(21495,8730,1,1,200,948),-- Life Stone: level 67
(21495,8740,1,1,200,237),-- Mid-Grade Life Stone: level 67
(21495,8750,1,1,200,24),-- High-Grade Life Stone: level 67
(21495,8760,1,1,200,5),-- Top-Grade Life Stone: level 67
(21496,730,1,1,-1,2864),-- Scroll: Enchant Armor (Grade A)
(21496,5494,1,1,-1,72182),-- Sealed Dark Crystal Shield Fragment
(21496,6335,1,1,-1,13219),-- Recipe: Sealed Majestic Necklace(70%)
(21496,11946,1,1,1,35),-- Common Item - Dasparion\'s Staff
(21496,11949,1,1,1,35),-- Common Item - Meteor Shower
(21496,11958,1,1,1,35),-- Common Item - Destroyer Hammer
(21496,11953,1,1,1,35),-- Common Item - Spiritual Eye
(21496,5532,1,1,1,428),-- Meteor Shower Head
(21496,5543,1,1,1,432),-- Dasparion\'s Staff Edge
(21496,8346,1,1,1,428),-- Hammer Piece of Destroyer
(21496,8341,1,1,1,427),-- Spiritual Eye Piece
(21496,729,1,1,2,10),-- Scroll: Enchant Weapon (Grade A)
(21496,1343,10,30,2,131846),-- Silver Arrow
(21496,1868,1,1,2,184585),-- Thread
(21496,1873,1,1,2,36917),-- Silver Nugget
(21496,1876,1,1,2,18459),-- Mithril Ore
(21496,1895,1,1,2,26369),-- Metallic Fiber
(21496,4042,1,1,2,1538),-- Enria
(21496,8730,1,1,200,1025),-- Life Stone: level 67
(21496,8740,1,1,200,256),-- Mid-Grade Life Stone: level 67
(21496,8750,1,1,200,26),-- High-Grade Life Stone: level 67
(21496,8760,1,1,200,5),-- Top-Grade Life Stone: level 67
(21497,1884,1,3,-1,888675),-- Cord
(21497,4039,1,1,-1,96273),-- Mold Glue
(21497,5496,1,1,-1,67718),-- Sealed Dark Crystal Boots Lining
(21497,11957,1,1,1,39),-- Common Item - Tallum Blade
(21497,11952,1,1,1,39),-- Common Item - Elemental Sword
(21497,11954,1,1,1,39),-- Common Item - Infernal Master
(21497,5547,1,1,1,484),-- Elemental Sword Edge
(21497,5548,1,1,1,484),-- Tallum Blade Edge
(21497,8331,1,1,1,485),-- Infernal Master Blade
(21497,730,1,1,2,65),-- Scroll: Enchant Armor (Grade A)
(21497,1864,1,1,2,155114),-- Stem
(21497,1869,1,1,2,77557),-- Iron Ore
(21497,1878,1,1,2,31023),-- Braided Hemp
(21497,1884,1,1,2,47727),-- Cord
(21497,4039,1,1,2,2585),-- Mold Glue
(21497,5366,1,1,2,419),-- Recipe: Sealed Shield of Nightmare(60%)
(21497,8730,1,1,200,862),-- Life Stone: level 67
(21497,8740,1,1,200,216),-- Mid-Grade Life Stone: level 67
(21497,8750,1,1,200,21),-- High-Grade Life Stone: level 67
(21497,8760,1,1,200,4),-- Top-Grade Life Stone: level 67
(21498,5497,1,1,-1,137944),-- Sealed Tallum Boots Lining
(21498,6337,1,1,-1,30171),-- Recipe: Sealed Majestic Earring(70%)
(21498,6339,1,1,-1,45256),-- Recipe: Sealed Majestic Ring(70%)
(21498,57,2339,4736,0,700000),-- Adena
(21499,729,1,1,-1,679),-- Scroll: Enchant Weapon (Grade A)
(21499,1895,1,3,-1,873628),-- Metallic Fiber
(21499,5508,1,1,-1,143386),-- Sealed Dark Crystal Gloves Design
(21499,57,2431,4922,0,700000),-- Adena
(21500,4042,1,1,-1,98055),-- Enria
(21500,5434,1,1,-1,2179),-- Recipe: Dragon Slayer(60%)
(21500,5509,1,1,-1,137944),-- Sealed Tallum Gloves Design
(21500,57,2339,4736,0,700000),-- Adena
(21501,5440,1,1,-1,2096),-- Recipe: Elysian(60%)
(21501,5520,1,1,-1,36486),-- Sealed Dark Crystal Breastplate Pattern
(21501,5521,1,1,-1,25746),-- Sealed Tallum Plate Armor Pattern
(21501,57,2250,4554,0,700000),-- Adena
(21502,730,1,1,-1,6001),-- Scroll: Enchant Armor (Grade A)
(21502,1885,1,1,-1,600140),-- High Grade Suede
(21502,5432,1,1,-1,27279),-- Recipe: Sealed Majestic Circlet(60%)
(21502,1343,560,1680,2,61667),-- Silver Arrow
(21502,1866,20,60,2,40289),-- Suede
(21502,1871,9,27,2,134297),-- Charcoal
(21502,1885,4,12,2,22383),-- High Grade Suede
(21502,4041,1,1,2,21021),-- Mold Hardener
(21502,5220,1,1,2,96694),-- Metal Hardener
(21502,5450,1,1,2,895),-- Recipe: Dragon Grinder(60%)
(21502,8730,1,1,200,26859),-- Life Stone: level 67
(21502,8740,1,1,200,6715),-- Mid-Grade Life Stone: level 67
(21502,8750,1,1,200,671),-- High-Grade Life Stone: level 67
(21502,8760,1,1,200,134),-- Top-Grade Life Stone: level 67
(21503,5442,1,1,-1,2773),-- Recipe: Soul Bow(60%)
(21503,5524,1,1,-1,73781),-- Sealed Dark Crystal Gaiters Pattern
(21503,5525,1,1,-1,115718),-- Sealed Dark Crystal Helmet Design
(21503,11960,1,1,1,304),-- Common Item - Halberd
(21503,5542,1,1,1,3729),-- Halberd Edge
(21503,1867,1,3,2,147413),-- Animal Skin
(21503,1872,1,3,2,98275),-- Animal Bone
(21503,1882,1,1,2,49137),-- Leather
(21503,1894,1,1,2,7758),-- Crafted Leather
(21503,4042,1,1,2,3685),-- Enria
(21503,5456,1,1,2,82),-- Recipe: Tallum Glaive(60%)
(21503,8730,1,1,200,2457),-- Life Stone: level 67
(21503,8740,1,1,200,614),-- Mid-Grade Life Stone: level 67
(21503,8750,1,1,200,61),-- High-Grade Life Stone: level 67
(21503,8760,1,1,200,13),-- Top-Grade Life Stone: level 67
(21504,729,1,1,-1,800),-- Scroll: Enchant Weapon (Grade A)
(21504,5448,1,1,-1,2667),-- Recipe: Soul Separator(60%)
(21504,5526,1,1,-1,111326),-- Sealed Tallum Helm Design
(21504,11955,1,1,1,293),-- Common Item - Carnage Bow
(21504,5535,1,1,1,3629),-- Carnage Bow Stave
(21504,1343,30,90,2,84415),-- Silver Arrow
(21504,1868,1,3,2,177272),-- Thread
(21504,1873,1,1,2,70909),-- Silver Nugget
(21504,1889,1,1,2,11818),-- Compound Braid
(21504,4044,1,1,2,5909),-- Thons
(21504,5462,1,1,2,66),-- Recipe: Branch of The Mother Tree(60%)
(21504,5432,1,1,2,671),-- Recipe: Sealed Majestic Circlet(60%)
(21504,5549,1,1,2,17727),-- Metallic Thread
(21504,8730,1,1,200,1970),-- Life Stone: level 67
(21504,8740,1,1,200,492),-- Mid-Grade Life Stone: level 67
(21504,8750,1,1,200,49),-- High-Grade Life Stone: level 67
(21504,8760,1,1,200,10),-- Top-Grade Life Stone: level 67
(21505,4043,1,1,-1,230869),-- Asofe
(21505,5532,1,1,-1,23356),-- Meteor Shower Head
(21505,5366,1,1,-1,37438),-- Recipe: Sealed Shield of Nightmare(60%)
(21505,11951,1,1,1,282),-- Common Item - Bloody Orchid
(21505,5536,1,1,1,3480),-- Bloody Orchid Head
(21505,1864,1,3,2,185986),-- Stem
(21505,1869,1,1,2,185986),-- Iron Ore
(21505,1880,1,1,2,18598),-- Steel
(21505,4043,1,1,2,6199),-- Asofe
(21505,5464,1,1,2,69),-- Recipe: Dark Legion\'s Edge(60%)
(21505,5430,1,1,2,705),-- Recipe: Sealed Helm of Nightmare(60%)
(21505,5550,1,1,2,2480),-- Durable Metal Plate
(21505,8730,1,1,200,2066),-- Life Stone: level 67
(21505,8740,1,1,200,517),-- Mid-Grade Life Stone: level 67
(21505,8750,1,1,200,52),-- High-Grade Life Stone: level 67
(21505,8760,1,1,200,10),-- Top-Grade Life Stone: level 67
(21506,5450,1,1,-1,3673),-- Recipe: Dragon Grinder(60%)
(21506,5456,1,1,-1,3673),-- Recipe: Tallum Glaive(60%)
(21506,5535,1,1,-1,33842),-- Carnage Bow Stave
(21506,57,3943,7984,0,700000),-- Adena
(21507,4041,1,1,-1,82270),-- Mold Hardener
(21507,5536,1,1,-1,32189),-- Bloody Orchid Head
(21507,5430,1,1,-1,1946),-- Recipe: Sealed Helm of Nightmare(60%)
(21507,57,3762,7615,0,700000),-- Adena
(21508,4120,1,1,-1,14317),-- Bellion Cestus Edge
(21508,4121,1,1,-1,14269),-- Bow of Peril Shaft
(21508,5444,1,1,-1,1790),-- Recipe: Carnage Bow(60%)
(21508,57,1298,2632,0,700000),-- Adena
(21508,12341,1,1,1,749),-- Common Item - Earring of Black Ore
(21508,12343,1,1,1,1120),-- Common Item - Ring of Black Ore
(21508,12342,1,1,1,561),-- Common Item - Necklace of Black Ore
(21508,4052,1,1,1,5711),-- Earring of Black Ore Piece
(21508,4053,1,1,1,6914),-- Ring of Black Ore Gemstone
(21508,4054,1,1,1,3177),-- Necklace of Black Ore Beads
(21508,1875,1,1,2,5866),-- Stone of Purity
(21508,1879,1,1,2,14664),-- Cokes
(21508,1885,1,1,2,7332),-- High Grade Suede
(21508,5466,1,1,2,33),-- Recipe: Sword of Miracles(60%)
(21508,5549,1,1,2,8798),-- Metallic Thread
(21508,5550,1,1,2,1173),-- Durable Metal Plate
(21508,6670,1,1,2,14664),-- Deluxe Chest Key - Grade 6
(21508,8729,1,1,200,1173),-- Life Stone: level 64
(21508,8739,1,1,200,293),-- Mid-Grade Life Stone: level 64
(21508,8749,1,1,200,29),-- High-Grade Life Stone: level 64
(21508,8759,1,1,200,6),-- Top-Grade Life Stone: level 64
(21509,4091,1,1,-1,128386),-- Doom Gloves Part
(21509,4096,1,1,-1,128386),-- Blue Wolf Gloves Fabric
(21509,6333,1,1,-1,32834),-- Recipe: Sealed Phoenix Ring(70%)
(21509,57,1127,2304,0,700000),-- Adena
(21509,12194,1,1,1,231),-- Common Item - Blue Wolf Leather Armor
(21509,12186,1,1,1,231),-- Common Item - Leather Armor of Doom
(21509,4082,1,1,1,2386),-- Blue Wolf Leather Armor Texture
(21509,4083,1,1,1,2386),-- Leather Armor of Doom Design
(21509,1343,10,30,2,109706),-- Silver Arrow
(21509,1864,1,1,2,153589),-- Stem
(21509,1869,1,1,2,76795),-- Iron Ore
(21509,1880,1,1,2,7679),-- Steel
(21509,4043,1,1,2,2560),-- Asofe
(21509,5440,1,1,2,29),-- Recipe: Elysian(60%)
(21509,5550,1,1,2,1024),-- Durable Metal Plate
(21509,8730,1,1,200,853),-- Life Stone: level 67
(21509,8740,1,1,200,213),-- Mid-Grade Life Stone: level 67
(21509,8750,1,1,200,22),-- High-Grade Life Stone: level 67
(21509,8760,1,1,200,4),-- Top-Grade Life Stone: level 67
(21510,730,1,1,-1,2914),-- Scroll: Enchant Armor (Grade A)
(21510,1875,1,1,-1,233152),-- Stone of Purity
(21510,5508,1,1,-1,81999),-- Sealed Dark Crystal Gloves Design
(21510,57,1383,2812,0,700000),-- Adena
(21510,11951,1,1,1,142),-- Common Item - Bloody Orchid
(21510,5536,1,1,1,1758),-- Bloody Orchid Head
(21510,1865,1,1,2,103304),-- Varnish
(21510,1870,1,1,2,103304),-- Coal
(21510,1875,1,1,2,6887),-- Stone of Purity
(21510,1879,1,1,2,17217),-- Cokes
(21510,4040,1,1,2,2066),-- Mold Lubricant
(21510,5456,1,1,2,38),-- Recipe: Tallum Glaive(60%)
(21510,8730,1,1,200,1148),-- Life Stone: level 67
(21510,8740,1,1,200,287),-- Mid-Grade Life Stone: level 67
(21510,8750,1,1,200,29),-- High-Grade Life Stone: level 67
(21510,8760,1,1,200,6),-- Top-Grade Life Stone: level 67
(21511,1875,1,1,-1,301961),-- Stone of Purity
(21511,5462,1,1,-1,1678),-- Recipe: Branch of The Mother Tree(60%)
(21511,5539,1,1,-1,15274),-- Blood Tornado Edge
(21511,57,1793,3640,0,700000),-- Adena
(21511,11946,1,1,1,46),-- Common Item - Dasparion\'s Staff
(21511,11949,1,1,1,46),-- Common Item - Meteor Shower
(21511,8346,1,1,1,564),-- Hammer Piece of Destroyer
(21511,11958,1,1,1,46),-- Common Item - Destroyer Hammer
(21511,8341,1,1,1,563),-- Spiritual Eye Piece
(21511,11953,1,1,1,46),-- Common Item - Spiritual Eye
(21511,5532,1,1,1,564),-- Meteor Shower Head
(21511,5543,1,1,1,569),-- Dasparion\'s Staff Edge
(21511,1343,20,60,2,86878),-- Silver Arrow
(21511,1867,1,1,2,162172),-- Animal Skin
(21511,1872,1,1,2,162172),-- Animal Bone
(21511,1875,1,1,2,8108),-- Stone of Purity
(21511,1881,1,1,2,16217),-- Coarse Bone Powder
(21511,4041,1,1,2,1057),-- Mold Hardener
(21511,6337,1,1,2,624),-- Recipe: Sealed Majestic Earring(70%)
(21511,8730,1,1,200,1352),-- Life Stone: level 67
(21511,8740,1,1,200,338),-- Mid-Grade Life Stone: level 67
(21511,8750,1,1,200,34),-- High-Grade Life Stone: level 67
(21511,8760,1,1,200,7),-- Top-Grade Life Stone: level 67
(21512,730,1,1,-1,4407),-- Scroll: Enchant Armor (Grade A)
(21512,1875,1,1,-1,352548),-- Stone of Purity
(21512,4041,1,1,-1,45985),-- Mold Hardener
(21512,57,2091,4255,0,700000),-- Adena
(21512,11951,1,1,1,215),-- Common Item - Bloody Orchid
(21512,5536,1,1,1,2657),-- Bloody Orchid Head
(21512,1343,20,60,2,101433),-- Silver Arrow
(21512,1867,1,1,2,189341),-- Animal Skin
(21512,1872,1,3,2,63114),-- Animal Bone
(21512,1875,1,1,2,9467),-- Stone of Purity
(21512,1881,1,1,2,18934),-- Coarse Bone Powder
(21512,4041,1,1,2,1235),-- Mold Hardener
(21512,5462,1,1,2,52),-- Recipe: Branch of The Mother Tree(60%)
(21512,8730,1,1,200,1578),-- Life Stone: level 67
(21512,8740,1,1,200,394),-- Mid-Grade Life Stone: level 67
(21512,8750,1,1,200,39),-- High-Grade Life Stone: level 67
(21512,8760,1,1,200,8),-- Top-Grade Life Stone: level 67
(21513,5442,1,1,-1,1381),-- Recipe: Soul Bow(60%)
(21513,5486,1,1,-1,22058),-- Sealed Dark Crystal Robe Fabric
(21513,5489,1,1,-1,49202),-- Sealed Tallum Stockings Fabric
(21513,57,1474,2999,0,700000),-- Adena
(21513,12221,1,1,1,600),-- Common Item - Sealed Dark Crystal Gloves
(21513,12224,1,1,1,600),-- Common Item - Sealed Dark Crystal Boots
(21513,12229,1,1,1,600),-- Common Item - Sealed Tallum Gloves
(21513,12231,1,1,1,600),-- Common Item - Sealed Tallum Boots
(21513,5496,1,1,1,3227),-- Sealed Dark Crystal Boots Lining
(21513,5497,1,1,1,3227),-- Sealed Tallum Boots Lining
(21513,5508,1,1,1,3227),-- Sealed Dark Crystal Gloves Design
(21513,5509,1,1,1,3227),-- Sealed Tallum Gloves Design
(21513,1895,1,1,2,34957),-- Metallic Fiber
(21513,4040,1,1,2,2447),-- Mold Lubricant
(21513,4042,1,1,2,2039),-- Enria
(21513,4043,1,1,2,4078),-- Asofe
(21513,5464,1,1,2,45),-- Recipe: Dark Legion\'s Edge(60%)
(21513,8730,1,1,200,1359),-- Life Stone: level 67
(21513,8740,1,1,200,340),-- Mid-Grade Life Stone: level 67
(21513,8750,1,1,200,34),-- High-Grade Life Stone: level 67
(21513,8760,1,1,200,7),-- Top-Grade Life Stone: level 67
(21514,4039,1,1,-1,86637),-- Mold Glue
(21514,5462,1,1,-1,963),-- Recipe: Branch of The Mother Tree(60%)
(21514,5479,1,1,-1,15379),-- Sealed Tallum Leather Armor Pattern
(21514,57,1283,2614,0,700000),-- Adena
(21514,11946,1,1,1,33),-- Common Item - Dasparion\'s Staff
(21514,11949,1,1,1,33),-- Common Item - Meteor Shower
(21514,8341,1,1,1,404),-- Spiritual Eye Piece
(21514,8346,1,1,1,405),-- Hammer Piece of Destroyer
(21514,11953,1,1,1,33),-- Common Item - Spiritual Eye
(21514,11958,1,1,1,33),-- Common Item - Destroyer Hammer
(21514,5532,1,1,1,405),-- Meteor Shower Head
(21514,5543,1,1,1,408),-- Dasparion\'s Staff Edge
(21514,1864,1,1,2,191935),-- Stem
(21514,1869,1,1,2,95967),-- Iron Ore
(21514,1878,1,1,2,38387),-- Braided Hemp
(21514,1884,1,1,2,59057),-- Cord
(21514,4039,1,1,2,3199),-- Mold Glue
(21514,5272,1,1,2,43),-- Recipe: Greater Soulshot (S) Compressed Package(100%)
(21514,8730,1,1,200,1066),-- Life Stone: level 67
(21514,8740,1,1,200,267),-- Mid-Grade Life Stone: level 67
(21514,8750,1,1,200,27),-- High-Grade Life Stone: level 67
(21514,8760,1,1,200,6),-- Top-Grade Life Stone: level 67
(21515,5442,1,1,-1,1174),-- Recipe: Soul Bow(60%)
(21515,5524,1,1,-1,31247),-- Sealed Dark Crystal Gaiters Pattern
(21515,5525,1,1,-1,49008),-- Sealed Dark Crystal Helmet Design
(21515,57,1563,3192,0,700000),-- Adena
(21515,11951,1,1,1,161),-- Common Item - Bloody Orchid
(21515,5536,1,1,1,1991),-- Bloody Orchid Head
(21515,1344,10,30,2,121935),-- Mithril Arrow
(21515,1868,1,1,2,195097),-- Thread
(21515,1873,1,1,2,39020),-- Silver Nugget
(21515,1876,1,1,2,19510),-- Mithril Ore
(21515,1895,1,1,2,27871),-- Metallic Fiber
(21515,4042,1,1,2,1626),-- Enria
(21515,5277,1,1,2,44),-- Recipe: Greater Spiritshot (S) Compressed Package(100%)
(21515,6670,1,1,2,16258),-- Deluxe Chest Key - Grade 6
(21515,8730,1,1,200,1084),-- Life Stone: level 67
(21515,8740,1,1,200,271),-- Mid-Grade Life Stone: level 67
(21515,8750,1,1,200,27),-- High-Grade Life Stone: level 67
(21515,8760,1,1,200,5),-- Top-Grade Life Stone: level 67
(21516,6337,1,1,-1,19666),-- Recipe: Sealed Majestic Earring(70%)
(21516,6339,1,1,-1,29498),-- Recipe: Sealed Majestic Ring(70%)
(21516,6345,1,1,-1,146702),-- Sealed Phoenix Ring Gemstone
(21516,57,1894,3856,0,700000),-- Adena
(21516,11951,1,1,1,195),-- Common Item - Bloody Orchid
(21516,5536,1,1,1,2409),-- Bloody Orchid Head
(21516,1868,1,1,2,283185),-- Thread
(21516,1873,1,1,2,56637),-- Silver Nugget
(21516,1876,1,1,2,28318),-- Mithril Ore
(21516,1895,1,1,2,40455),-- Metallic Fiber
(21516,4042,1,1,2,2260),-- Enria
(21516,5282,1,1,2,63),-- Recipe: Greater Blessed Spiritshot (S) Compressed Package(100%)
(21516,8731,1,1,200,1311),-- Life Stone: level 70
(21516,8741,1,1,200,328),-- Mid-Grade Life Stone: level 70
(21516,8751,1,1,200,33),-- High-Grade Life Stone: level 70
(21516,8761,1,1,200,7),-- Top-Grade Life Stone: level 70
(21517,5462,1,1,-1,1769),-- Recipe: Branch of The Mother Tree(60%)
(21517,5478,1,1,-1,40163),-- Sealed Dark Crystal Leather Armor Pattern
(21517,5479,1,1,-1,28262),-- Sealed Tallum Leather Armor Pattern
(21517,57,2357,4804,0,700000),-- Adena
(21517,12222,1,1,1,427),-- Common Item - Sealed Dark Crystal Leather Armor
(21517,12228,1,1,1,684),-- Common Item - Sealed Dark Crystalline Leggings
(21517,12230,1,1,1,262),-- Common Item - Sealed Tallum Leather Armor
(21517,5478,1,1,1,2472),-- Sealed Dark Crystal Leather Armor Pattern
(21517,5479,1,1,1,1739),-- Sealed Tallum Leather Armor Pattern
(21517,5482,1,1,1,3879),-- Sealed Dark Crystalline Leggings Design
(21517,1864,4,12,2,44088),-- Stem
(21517,1865,2,6,2,35271),-- Varnish
(21517,1866,1,1,2,117569),-- Suede
(21517,1868,1,3,2,117569),-- Thread
(21517,1873,1,1,2,70541),-- Silver Nugget
(21517,5162,1,1,2,78),-- Recipe: Spiritshot (S) Compressed Package (100%)
(21517,8731,1,1,200,1633),-- Life Stone: level 70
(21517,8741,1,1,200,408),-- Mid-Grade Life Stone: level 70
(21517,8751,1,1,200,41),-- High-Grade Life Stone: level 70
(21517,8761,1,1,200,9),-- Top-Grade Life Stone: level 70
(21518,4041,1,1,-1,28954),-- Mold Hardener
(21518,5462,1,1,-1,1233),-- Recipe: Branch of The Mother Tree(60%)
(21518,5509,1,1,-1,78069),-- Sealed Tallum Gloves Design
(21518,57,1317,2677,0,700000),-- Adena
(21518,11955,1,1,1,135),-- Common Item - Carnage Bow
(21518,5535,1,1,1,1678),-- Carnage Bow Stave
(21518,1343,10,30,2,127732),-- Silver Arrow
(21518,1866,1,1,2,59608),-- Suede
(21518,1871,1,1,2,89412),-- Charcoal
(21518,1885,1,1,2,7451),-- High Grade Suede
(21518,4041,1,1,2,777),-- Mold Hardener
(21518,5220,1,1,2,3577),-- Metal Hardener
(21518,5462,1,1,2,33),-- Recipe: Branch of The Mother Tree(60%)
(21518,8730,1,1,200,993),-- Life Stone: level 67
(21518,8740,1,1,200,248),-- Mid-Grade Life Stone: level 67
(21518,8750,1,1,200,25),-- High-Grade Life Stone: level 67
(21518,8760,1,1,200,5),-- Top-Grade Life Stone: level 67
(21519,729,1,1,-1,335),-- Scroll: Enchant Weapon (Grade A)
(21519,5448,1,1,-1,1118),-- Recipe: Soul Separator(60%)
(21519,5526,1,1,-1,46659),-- Sealed Tallum Helm Design
(21519,57,1488,3039,0,700000),-- Adena
(21519,12229,1,1,1,607),-- Common Item - Sealed Tallum Gloves
(21519,12231,1,1,1,607),-- Common Item - Sealed Tallum Boots
(21519,12221,1,1,1,607),-- Common Item - Sealed Dark Crystal Gloves
(21519,12224,1,1,1,607),-- Common Item - Sealed Dark Crystal Boots
(21519,5496,1,1,1,3266),-- Sealed Dark Crystal Boots Lining
(21519,5497,1,1,1,3266),-- Sealed Tallum Boots Lining
(21519,5508,1,1,1,3266),-- Sealed Dark Crystal Gloves Design
(21519,5509,1,1,1,3266),-- Sealed Tallum Gloves Design
(21519,1868,1,1,2,222897),-- Thread
(21519,1873,1,1,2,44579),-- Silver Nugget
(21519,1876,1,1,2,22290),-- Mithril Ore
(21519,1895,1,1,2,31842),-- Metallic Fiber
(21519,4042,1,1,2,1858),-- Enria
(21519,5282,1,1,2,49),-- Recipe: Greater Blessed Spiritshot (S) Compressed Package(100%)
(21519,8730,1,1,200,1238),-- Life Stone: level 67
(21519,8740,1,1,200,309),-- Mid-Grade Life Stone: level 67
(21519,8750,1,1,200,31),-- High-Grade Life Stone: level 67
(21519,8760,1,1,200,7),-- Top-Grade Life Stone: level 67
(21520,4049,1,1,-1,159526),-- Adamantite Earring Gemstone
(21520,4050,1,1,-1,188436),-- Adamantite Ring Wire
(21520,4129,1,1,-1,32915),-- Recipe: Earrings of Black Ore
(21520,57,1203,2445,0,700000),-- Adena
(21520,12338,1,1,1,1227),-- Common Item - Adamantite Earring
(21520,12340,1,1,1,1848),-- Common Item - Adamantite Ring
(21520,12339,1,1,1,921),-- Common Item - Adamantite Necklace
(21520,4049,1,1,1,7853),-- Adamantite Earring Gemstone
(21520,4050,1,1,1,9277),-- Adamantite Ring Wire
(21520,4051,1,1,1,5807),-- Adamantite Necklace Chain
(21520,947,1,1,2,36),-- Scroll: Enchant Weapon (Grade B)
(21520,1832,1,1,2,99819),-- Greater Antidote
(21520,1895,1,1,2,25668),-- Metallic Fiber
(21520,4040,1,1,2,1797),-- Mold Lubricant
(21520,4042,1,1,2,1497),-- Enria
(21520,4043,1,1,2,2995),-- Asofe
(21520,8728,1,1,200,1497),-- Life Stone: level 61
(21520,8738,1,1,200,374),-- Mid-Grade Life Stone: level 61
(21520,8748,1,1,200,37),-- High-Grade Life Stone: level 61
(21520,8758,1,1,200,7),-- Top-Grade Life Stone: level 61
(21521,947,1,1,-1,1196),-- Scroll: Enchant Weapon (Grade B)
(21521,4051,1,1,-1,115966),-- Adamantite Necklace Chain
(21521,4130,1,1,-1,48542),-- Recipe: Ring of Black Ore
(21521,57,1183,2404,0,700000),-- Adena
(21521,78,1,1,1,4),-- Great Sword
(21521,142,1,1,1,4),-- Keshanberk
(21521,148,1,1,1,4),-- Sword of Valhalla
(21521,4104,1,1,1,842),-- Great Sword Blade
(21521,4107,1,1,1,829),-- Keshanberk Blade
(21521,4108,1,1,1,829),-- Sword of Valhalla Blade
(21521,948,1,1,2,201),-- Scroll: Enchant Armor (Grade B)
(21521,1832,1,1,2,89218),-- Greater Antidote
(21521,1868,1,1,2,160591),-- Thread
(21521,1873,1,1,2,32118),-- Silver Nugget
(21521,1889,1,1,2,5353),-- Compound Braid
(21521,4044,1,1,2,2677),-- Thons
(21521,5549,1,1,2,8030),-- Metallic Thread
(21521,8728,1,1,200,1338),-- Life Stone: level 61
(21521,8738,1,1,200,335),-- Mid-Grade Life Stone: level 61
(21521,8748,1,1,200,34),-- High-Grade Life Stone: level 61
(21521,8758,1,1,200,7),-- Top-Grade Life Stone: level 61
(21522,947,1,1,-1,1425),-- Scroll: Enchant Weapon (Grade B)
(21522,4051,1,1,-1,138206),-- Adamantite Necklace Chain
(21522,4130,1,1,-1,57851),-- Recipe: Ring of Black Ore
(21522,57,1409,2865,0,700000),-- Adena
(21522,78,1,1,1,5),-- Great Sword
(21522,142,1,1,1,5),-- Keshanberk
(21522,148,1,1,1,5),-- Sword of Valhalla
(21522,4104,1,1,1,1004),-- Great Sword Blade
(21522,4107,1,1,1,988),-- Keshanberk Blade
(21522,4108,1,1,1,988),-- Sword of Valhalla Blade
(21522,948,1,1,2,239),-- Scroll: Enchant Armor (Grade B)
(21522,1832,1,1,2,106328),-- Greater Antidote
(21522,1868,1,1,2,191390),-- Thread
(21522,1873,1,1,2,38278),-- Silver Nugget
(21522,1889,1,1,2,6380),-- Compound Braid
(21522,4044,1,1,2,3190),-- Thons
(21522,5549,1,1,2,9569),-- Metallic Thread
(21522,8728,1,1,200,1596),-- Life Stone: level 61
(21522,8738,1,1,200,399),-- Mid-Grade Life Stone: level 61
(21522,8748,1,1,200,40),-- High-Grade Life Stone: level 61
(21522,8758,1,1,200,8),-- Top-Grade Life Stone: level 61
(21523,948,1,1,-1,7686),-- Scroll: Enchant Armor (Grade B)
(21523,4070,1,1,-1,110051),-- Stockings of Zubei Fabric
(21523,4159,1,1,-1,8709),-- Recipe: Blue Wolf Leather Armor
(21523,57,1218,2471,0,700000),-- Adena
(21523,357,1,1,1,14),-- Zubei\'s Breastplate
(21523,383,1,1,1,23),-- Zubei\'s Gaiters
(21523,2376,1,1,1,14),-- Avadon Breastplate
(21523,2379,1,1,1,23),-- Avadon Gaiters
(21523,4056,1,1,1,2055),-- Zubei\'s Breastplate Part
(21523,4057,1,1,1,3176),-- Zubei\'s Gaiter Material
(21523,4064,1,1,1,2055),-- Avadon Breastplate Part
(21523,4065,1,1,1,3176),-- Avadon Gaiters Material
(21523,1832,1,1,2,84084),-- Greater Antidote
(21523,1864,1,3,2,75675),-- Stem
(21523,1865,1,1,2,75675),-- Varnish
(21523,1866,1,1,2,50450),-- Suede
(21523,1868,1,1,2,151349),-- Thread
(21523,1873,1,1,2,30270),-- Silver Nugget
(21523,4160,1,1,2,214),-- Recipe: Leather Armor of Doom
(21523,6670,1,1,2,12612),-- Deluxe Chest Key - Grade 6
(21523,8728,1,1,200,1261),-- Life Stone: level 61
(21523,8738,1,1,200,315),-- Mid-Grade Life Stone: level 61
(21523,8748,1,1,200,31),-- High-Grade Life Stone: level 61
(21523,8758,1,1,200,6),-- Top-Grade Life Stone: level 61
(21524,948,1,1,-1,8195),-- Scroll: Enchant Armor (Grade B)
(21524,4070,1,1,-1,117344),-- Stockings of Zubei Fabric
(21524,4159,1,1,-1,9286),-- Recipe: Blue Wolf Leather Armor
(21524,57,1299,2634,0,700000),-- Adena
(21524,12151,1,1,1,516),-- Common Item - Zubei\'s Leather Shirt
(21524,12150,1,1,1,825),-- Common Item - Zubei\'s Leather Gaiters
(21524,12165,1,1,1,316),-- Common Item - Avadon Leather Armor
(21524,4066,1,1,1,3805),-- Zubei\'s Leather Shirt Fabric
(21524,4067,1,1,1,5777),-- Zubei\'s Leather Gaiter Texture
(21524,4068,1,1,1,2923),-- Avadon Leather Armor Lining
(21524,1343,20,60,2,62875),-- Silver Arrow
(21524,1867,1,1,2,117367),-- Animal Skin
(21524,1869,1,1,2,88025),-- Iron Ore
(21524,1870,1,1,2,88025),-- Coal
(21524,1871,1,1,2,88025),-- Charcoal
(21524,1872,1,3,2,39122),-- Animal Bone
(21524,4161,1,1,2,365),-- Recipe: Blue Wolf Tunic
(21524,8728,1,1,200,1467),-- Life Stone: level 61
(21524,8738,1,1,200,367),-- Mid-Grade Life Stone: level 61
(21524,8748,1,1,200,37),-- High-Grade Life Stone: level 61
(21524,8758,1,1,200,7),-- Top-Grade Life Stone: level 61
(21525,4049,1,1,-1,171939),-- Adamantite Earring Gemstone
(21525,4050,1,1,-1,203099),-- Adamantite Ring Wire
(21525,4129,1,1,-1,35476),-- Recipe: Earrings of Black Ore
(21525,57,1299,2634,0,700000),-- Adena
(21525,11915,1,1,1,139),-- Common Item - Kris
(21525,11919,1,1,1,139),-- Common Item - Hell Knife
(21525,4109,1,1,1,1364),-- Kris Edge
(21525,4110,1,1,1,1364),-- Hell Knife Edge
(21525,947,1,1,2,39),-- Scroll: Enchant Weapon (Grade B)
(21525,1343,10,30,2,138327),-- Silver Arrow
(21525,1894,1,1,2,3397),-- Crafted Leather
(21525,4039,1,1,2,3228),-- Mold Glue
(21525,4041,1,1,2,842),-- Mold Hardener
(21525,4044,1,1,2,3228),-- Thons
(21525,8728,1,1,200,1614),-- Life Stone: level 61
(21525,8738,1,1,200,404),-- Mid-Grade Life Stone: level 61
(21525,8748,1,1,200,40),-- High-Grade Life Stone: level 61
(21525,8758,1,1,200,8),-- Top-Grade Life Stone: level 61
(21526,1889,1,1,-1,243532),-- Compound Braid
(21526,4052,1,1,-1,129332),-- Earring of Black Ore Piece
(21526,5549,1,1,-1,365298),-- Metallic Thread
(21526,57,1449,2935,0,700000),-- Adena
(21526,11930,1,1,1,59),-- Common Item - Sword of Damascus
(21526,11943,1,1,1,59),-- Common Item - Wizard\'s Tear
(21526,11929,1,1,1,59),-- Common Item - Guardian Sword
(21526,8336,1,1,1,787),-- Blade of the Wizard\'s Tear
(21526,8330,1,1,1,786),-- Guardian Sword Blade
(21526,4114,1,1,1,787),-- Sword of Damascus Blade
(21526,1807,1,1,2,144),-- Recipe: Soulshot: A-Grade
(21526,1868,1,1,2,215807),-- Thread
(21526,1873,1,1,2,43161),-- Silver Nugget
(21526,1889,1,1,2,7194),-- Compound Braid
(21526,4044,1,1,2,3597),-- Thons
(21526,5549,1,1,2,10790),-- Metallic Thread
(21526,8729,1,1,200,1439),-- Life Stone: level 64
(21526,8739,1,1,200,360),-- Mid-Grade Life Stone: level 64
(21526,8749,1,1,200,36),-- High-Grade Life Stone: level 64
(21526,8759,1,1,200,8),-- Top-Grade Life Stone: level 64
(21527,4040,1,1,-1,64217),-- Mold Lubricant
(21527,4081,1,1,-1,31646),-- Doom Plate Armor Temper
(21527,5161,1,1,-1,4281),-- Recipe: Spiritshot (A) Compressed Package (100%)
(21527,57,1273,2578,0,700000),-- Adena
(21527,12183,1,1,1,802),-- Common Item - Doom Shield
(21527,12202,1,1,1,562),-- Common Item - Blue Wolf Helmet
(21527,12185,1,1,1,562),-- Common Item - Doom Helmet
(21527,4077,1,1,1,7111),-- Doom Shield Fragment
(21527,4088,1,1,1,5974),-- Blue Wolf Helmet Design
(21527,4089,1,1,1,5974),-- Doom Helmet Pattern
(21527,1343,10,30,2,123173),-- Silver Arrow
(21527,1866,1,1,2,57481),-- Suede
(21527,1871,1,1,2,86221),-- Charcoal
(21527,1877,1,1,2,3449),-- Adamantite Nugget
(21527,4040,1,1,2,1725),-- Mold Lubricant
(21527,4041,1,1,2,750),-- Mold Hardener
(21527,5166,1,1,2,115),-- Recipe: Blessed Spiritshot (A) Compressed Package (100%)
(21527,8729,1,1,200,1150),-- Life Stone: level 64
(21527,8739,1,1,200,287),-- Mid-Grade Life Stone: level 64
(21527,8749,1,1,200,29),-- High-Grade Life Stone: level 64
(21527,8759,1,1,200,6),-- Top-Grade Life Stone: level 64
(21528,4040,1,1,-1,79165),-- Mold Lubricant
(21528,4081,1,1,-1,39013),-- Doom Plate Armor Temper
(21528,5161,1,1,-1,5278),-- Recipe: Spiritshot (A) Compressed Package (100%)
(21528,57,1570,3179,0,700000),-- Adena
(21528,12183,1,1,1,989),-- Common Item - Doom Shield
(21528,12202,1,1,1,692),-- Common Item - Blue Wolf Helmet
(21528,12185,1,1,1,692),-- Common Item - Doom Helmet
(21528,4077,1,1,1,8766),-- Doom Shield Fragment
(21528,4088,1,1,1,7365),-- Blue Wolf Helmet Design
(21528,4089,1,1,1,7365),-- Doom Helmet Pattern
(21528,1343,10,30,2,151845),-- Silver Arrow
(21528,1866,1,1,2,70861),-- Suede
(21528,1871,1,1,2,106291),-- Charcoal
(21528,1877,1,1,2,4252),-- Adamantite Nugget
(21528,4040,1,1,2,2126),-- Mold Lubricant
(21528,4041,1,1,2,924),-- Mold Hardener
(21528,5166,1,1,2,142),-- Recipe: Blessed Spiritshot (A) Compressed Package (100%)
(21528,8729,1,1,200,1417),-- Life Stone: level 64
(21528,8739,1,1,200,354),-- Mid-Grade Life Stone: level 64
(21528,8749,1,1,200,36),-- High-Grade Life Stone: level 64
(21528,8759,1,1,200,7),-- Top-Grade Life Stone: level 64
(21529,4082,1,1,-1,34211),-- Blue Wolf Leather Armor Texture
(21529,4083,1,1,-1,34211),-- Leather Armor of Doom Design
(21529,5166,1,1,-1,4037),-- Recipe: Blessed Spiritshot (A) Compressed Package (100%)
(21529,57,1201,2431,0,700000),-- Adena
(21529,12201,1,1,1,198),-- Common Item - Blue Wolf Tunic
(21529,12192,1,1,1,198),-- Common Item - Tunic of Doom
(21529,12203,1,1,1,318),-- Common Item - Blue Wolf Stockings
(21529,12205,1,1,1,318),-- Common Item - Stockings of Doom
(21529,4084,1,1,1,1943),-- Blue Wolf Tunic Fabric
(21529,4085,1,1,1,1943),-- Tunic of Doom Pattern
(21529,4086,1,1,1,2623),-- Blue Wolf Stockings Pattern
(21529,4087,1,1,1,2623),-- Stockings of Doom Pattern
(21529,1832,1,1,2,90336),-- Greater Antidote
(21529,1867,1,1,2,108403),-- Animal Skin
(21529,1872,1,1,2,108403),-- Animal Bone
(21529,1882,1,1,2,18067),-- Leather
(21529,1894,1,1,2,2853),-- Crafted Leather
(21529,4042,1,1,2,1355),-- Enria
(21529,5230,1,1,2,109),-- Recipe: Mithril Arrow (100%)
(21529,8729,1,1,200,1084),-- Life Stone: level 64
(21529,8739,1,1,200,271),-- Mid-Grade Life Stone: level 64
(21529,8749,1,1,200,27),-- High-Grade Life Stone: level 64
(21529,8759,1,1,200,5),-- Top-Grade Life Stone: level 64
(21530,4120,1,1,-1,14136),-- Bellion Cestus Edge
(21530,4121,1,1,-1,14088),-- Bow of Peril Shaft
(21530,5470,1,1,-1,1768),-- Recipe: Tallum Blade(60%)
(21530,57,1284,2598,0,700000),-- Adena
(21530,11933,1,1,1,156),-- Common Item - Bellion Cestus
(21530,4120,1,1,1,2088),-- Bellion Cestus Edge
(21530,1874,1,1,2,5791),-- Oriharukon Ore
(21530,1878,1,1,2,34746),-- Braided Hemp
(21530,1884,1,1,2,53456),-- Cord
(21530,1889,1,1,2,5791),-- Compound Braid
(21530,5220,1,1,2,3475),-- Metal Hardener
(21530,6333,1,1,2,997),-- Recipe: Sealed Phoenix Ring(70%)
(21530,6670,1,1,2,14478),-- Deluxe Chest Key - Grade 6
(21530,8729,1,1,200,1158),-- Life Stone: level 64
(21530,8739,1,1,200,290),-- Mid-Grade Life Stone: level 64
(21530,8749,1,1,200,29),-- High-Grade Life Stone: level 64
(21530,8759,1,1,200,6),-- Top-Grade Life Stone: level 64
(21531,1876,1,1,-1,727098),-- Mithril Ore
(21531,1895,1,3,-1,519356),-- Metallic Fiber
(21531,4052,1,1,-1,128713),-- Earring of Black Ore Piece
(21531,57,1443,2919,0,700000),-- Adena
(21531,11944,1,1,1,175),-- Common Item - Bow of Peril
(21531,4121,1,1,1,2339),-- Bow of Peril Shaft
(21531,1343,10,30,2,139462),-- Silver Arrow
(21531,1807,1,1,2,130),-- Recipe: Soulshot: A-Grade
(21531,1868,1,1,2,195248),-- Thread
(21531,1873,1,1,2,39050),-- Silver Nugget
(21531,1876,1,1,2,19525),-- Mithril Ore
(21531,1895,1,1,2,27892),-- Metallic Fiber
(21531,4042,1,1,2,1627),-- Enria
(21531,8729,1,1,200,1302),-- Life Stone: level 64
(21531,8739,1,1,200,325),-- Mid-Grade Life Stone: level 64
(21531,8749,1,1,200,33),-- High-Grade Life Stone: level 64
(21531,8759,1,1,200,6),-- Top-Grade Life Stone: level 64
(21532,1894,1,1,-1,132094),-- Crafted Leather
(21532,4042,1,1,-1,62745),-- Enria
(21532,4054,1,1,-1,74152),-- Necklace of Black Ore Beads
(21532,57,1492,3025,0,700000),-- Adena
(21532,11935,1,1,1,61),-- Common Item - Deadman\'s Glory
(21532,11938,1,1,1,61),-- Common Item - Art of Battle Axe
(21532,11934,1,1,1,61),-- Common Item - Staff of Evil Spirits
(21532,4116,1,1,1,810),-- Deadman\'s Glory Stone
(21532,4117,1,1,1,810),-- Art of Battle Axe Blade
(21532,4118,1,1,1,767),-- Evil Spirit Head
(21532,1867,1,1,2,148271),-- Animal Skin
(21532,1872,1,1,2,148271),-- Animal Bone
(21532,1882,1,1,2,24712),-- Leather
(21532,1894,1,1,2,3902),-- Crafted Leather
(21532,4042,1,1,2,1853),-- Enria
(21532,5450,1,1,2,41),-- Recipe: Dragon Grinder(60%)
(21532,8729,1,1,200,1483),-- Life Stone: level 64
(21532,8739,1,1,200,371),-- Mid-Grade Life Stone: level 64
(21532,8749,1,1,200,37),-- High-Grade Life Stone: level 64
(21532,8759,1,1,200,7),-- Top-Grade Life Stone: level 64
(21533,4077,1,1,-1,144198),-- Doom Shield Fragment
(21533,5470,1,1,-1,1752),-- Recipe: Tallum Blade(60%)
(21533,5348,1,1,-1,6310),-- Recipe: Sealed Dark Crystal Robe(60%)
(21533,57,1270,2576,0,700000),-- Adena
(21533,12341,1,1,1,732),-- Common Item - Earring of Black Ore
(21533,12343,1,1,1,1096),-- Common Item - Ring of Black Ore
(21533,12342,1,1,1,549),-- Common Item - Necklace of Black Ore
(21533,4052,1,1,1,5587),-- Earring of Black Ore Piece
(21533,4053,1,1,1,6764),-- Ring of Black Ore Gemstone
(21533,4054,1,1,1,3108),-- Necklace of Black Ore Beads
(21533,1343,10,30,2,122969),-- Silver Arrow
(21533,1866,1,1,2,57385),-- Suede
(21533,1871,1,1,2,86078),-- Charcoal
(21533,1877,1,1,2,3443),-- Adamantite Nugget
(21533,4040,1,1,2,1722),-- Mold Lubricant
(21533,4041,1,1,2,748),-- Mold Hardener
(21533,5456,1,1,2,32),-- Recipe: Tallum Glaive(60%)
(21533,8729,1,1,200,1148),-- Life Stone: level 64
(21533,8739,1,1,200,287),-- Mid-Grade Life Stone: level 64
(21533,8749,1,1,200,29),-- High-Grade Life Stone: level 64
(21533,8759,1,1,200,6),-- Top-Grade Life Stone: level 64
(21534,4077,1,1,-1,190615),-- Doom Shield Fragment
(21534,5470,1,1,-1,2316),-- Recipe: Tallum Blade(60%)
(21534,5348,1,1,-1,8341),-- Recipe: Sealed Dark Crystal Robe(60%)
(21534,57,1679,3405,0,700000),-- Adena
(21534,12341,1,1,1,968),-- Common Item - Earring of Black Ore
(21534,12343,1,1,1,1449),-- Common Item - Ring of Black Ore
(21534,12342,1,1,1,726),-- Common Item - Necklace of Black Ore
(21534,4052,1,1,1,7386),-- Earring of Black Ore Piece
(21534,4053,1,1,1,8942),-- Ring of Black Ore Gemstone
(21534,4054,1,1,1,4109),-- Necklace of Black Ore Beads
(21534,1343,10,30,2,162553),-- Silver Arrow
(21534,1866,1,1,2,75858),-- Suede
(21534,1871,1,1,2,113787),-- Charcoal
(21534,1877,1,1,2,4551),-- Adamantite Nugget
(21534,4040,1,1,2,2276),-- Mold Lubricant
(21534,4041,1,1,2,989),-- Mold Hardener
(21534,5456,1,1,2,42),-- Recipe: Tallum Glaive(60%)
(21534,8729,1,1,200,1517),-- Life Stone: level 64
(21534,8739,1,1,200,379),-- Mid-Grade Life Stone: level 64
(21534,8749,1,1,200,38),-- High-Grade Life Stone: level 64
(21534,8759,1,1,200,8),-- Top-Grade Life Stone: level 64
(21535,1876,1,1,-1,759357),-- Mithril Ore
(21535,1877,1,1,-1,151871),-- Adamantite Nugget
(21535,4052,1,1,-1,134423),-- Earring of Black Ore Piece
(21535,57,1504,3050,0,700000),-- Adena
(21535,11930,1,1,1,61),-- Common Item - Sword of Damascus
(21535,11943,1,1,1,61),-- Common Item - Wizard\'s Tear
(21535,11929,1,1,1,61),-- Common Item - Guardian Sword
(21535,8336,1,1,1,818),-- Blade of the Wizard\'s Tear
(21535,8330,1,1,1,817),-- Guardian Sword Blade
(21535,4114,1,1,1,818),-- Sword of Damascus Blade
(21535,1343,10,30,2,145652),-- Silver Arrow
(21535,1876,1,1,2,20391),-- Mithril Ore
(21535,1877,1,1,2,4078),-- Adamantite Nugget
(21535,1880,1,1,2,10196),-- Steel
(21535,1881,1,1,2,13594),-- Coarse Bone Powder
(21535,1882,1,1,2,22657),-- Leather
(21535,6335,1,1,2,392),-- Recipe: Sealed Majestic Necklace(70%)
(21535,8729,1,1,200,1359),-- Life Stone: level 64
(21535,8739,1,1,200,340),-- Mid-Grade Life Stone: level 64
(21535,8749,1,1,200,34),-- High-Grade Life Stone: level 64
(21535,8759,1,1,200,7),-- Top-Grade Life Stone: level 64
(21536,4053,1,1,-1,157335),-- Ring of Black Ore Gemstone
(21536,5446,1,1,-1,2006),-- Recipe: Bloody Orchid(60%)
(21536,5452,1,1,-1,2006),-- Recipe: Blood Tornado(60%)
(21536,57,1454,2949,0,700000),-- Adena
(21536,11939,1,1,1,177),-- Common Item - Demon Dagger
(21536,4119,1,1,1,2373),-- Demon Dagger Edge
(21536,1894,1,1,2,3804),-- Crafted Leather
(21536,4039,1,1,2,3614),-- Mold Glue
(21536,4041,1,1,2,943),-- Mold Hardener
(21536,4044,1,1,2,3614),-- Thons
(21536,6337,1,1,2,556),-- Recipe: Sealed Majestic Earring(70%)
(21536,6670,1,1,2,18071),-- Deluxe Chest Key - Grade 6
(21536,8729,1,1,200,1446),-- Life Stone: level 64
(21536,8739,1,1,200,361),-- Mid-Grade Life Stone: level 64
(21536,8749,1,1,200,36),-- High-Grade Life Stone: level 64
(21536,8759,1,1,200,7),-- Top-Grade Life Stone: level 64
(21537,1874,1,1,-1,246235),-- Oriharukon Ore
(21537,4043,1,1,-1,123118),-- Asofe
(21537,4099,1,1,-1,165815),-- Doom Boots Part
(21537,57,1456,2976,0,700000),-- Adena
(21537,11944,1,1,1,178),-- Common Item - Bow of Peril
(21537,4121,1,1,1,2376),-- Bow of Peril Shaft
(21537,1865,1,1,2,99183),-- Varnish
(21537,1870,1,1,2,99183),-- Coal
(21537,1874,1,1,2,6612),-- Oriharukon Ore
(21537,4039,1,1,2,3306),-- Mold Glue
(21537,4043,1,1,2,3306),-- Asofe
(21537,8300,1,1,2,54),-- Recipe: Infernal Master (60%)
(21537,5442,1,1,2,37),-- Recipe: Soul Bow(60%)
(21537,8730,1,1,200,1102),-- Life Stone: level 67
(21537,8740,1,1,200,276),-- Mid-Grade Life Stone: level 67
(21537,8750,1,1,200,27),-- High-Grade Life Stone: level 67
(21537,8760,1,1,200,6),-- Top-Grade Life Stone: level 67
(21538,1874,1,1,-1,301635),-- Oriharukon Ore
(21538,4043,1,1,-1,150818),-- Asofe
(21538,4099,1,1,-1,203121),-- Doom Boots Part
(21538,57,1784,3645,0,700000),-- Adena
(21538,11944,1,1,1,218),-- Common Item - Bow of Peril
(21538,4121,1,1,1,2911),-- Bow of Peril Shaft
(21538,1865,1,1,2,133647),-- Varnish
(21538,1870,1,1,2,133647),-- Coal
(21538,1874,1,1,2,8910),-- Oriharukon Ore
(21538,4039,1,1,2,4455),-- Mold Glue
(21538,4043,1,1,2,4455),-- Asofe
(21538,5442,1,1,2,49),-- Recipe: Soul Bow(60%)
(21538,8730,1,1,200,1485),-- Life Stone: level 67
(21538,8740,1,1,200,371),-- Mid-Grade Life Stone: level 67
(21538,8750,1,1,200,37),-- High-Grade Life Stone: level 67
(21538,8760,1,1,200,8),-- Top-Grade Life Stone: level 67
(21539,1807,1,1,-1,5356),-- Recipe: Soulshot: A-Grade
(21539,3035,1,1,-1,5356),-- Recipe: Spiritshot A
(21539,4114,1,1,-1,17583),-- Sword of Damascus Blade
(21539,57,1584,3236,0,700000),-- Adena
(21539,12201,1,1,1,263),-- Common Item - Blue Wolf Tunic
(21539,12192,1,1,1,263),-- Common Item - Tunic of Doom
(21539,12203,1,1,1,421),-- Common Item - Blue Wolf Stockings
(21539,12205,1,1,1,421),-- Common Item - Stockings of Doom
(21539,4084,1,1,1,2578),-- Blue Wolf Tunic Fabric
(21539,4085,1,1,1,2578),-- Tunic of Doom Pattern
(21539,4086,1,1,1,3481),-- Blue Wolf Stockings Pattern
(21539,4087,1,1,1,3481),-- Stockings of Doom Pattern
(21539,1343,10,30,2,154102),-- Silver Arrow
(21539,1866,1,1,2,71914),-- Suede
(21539,1871,1,1,2,107871),-- Charcoal
(21539,1877,1,1,2,4315),-- Adamantite Nugget
(21539,4040,1,1,2,2157),-- Mold Lubricant
(21539,4041,1,1,2,928),-- Mold Hardener
(21539,5448,1,1,2,40),-- Recipe: Soul Separator(60%)
(21539,8730,1,1,200,1199),-- Life Stone: level 67
(21539,8740,1,1,200,300),-- Mid-Grade Life Stone: level 67
(21539,8750,1,1,200,30),-- High-Grade Life Stone: level 67
(21539,8760,1,1,200,6),-- Top-Grade Life Stone: level 67
(21540,1807,1,1,-1,5356),-- Recipe: Soulshot: A-Grade
(21540,3035,1,1,-1,5356),-- Recipe: Spiritshot A
(21540,4053,1,1,-1,172185),-- Ring of Black Ore Gemstone
(21540,57,1584,3236,0,700000),-- Adena
(21540,11935,1,1,1,65),-- Common Item - Deadman\'s Glory
(21540,11938,1,1,1,65),-- Common Item - Art of Battle Axe
(21540,11934,1,1,1,65),-- Common Item - Staff of Evil Spirits
(21540,4116,1,1,1,864),-- Deadman\'s Glory Stone
(21540,4117,1,1,1,864),-- Art of Battle Axe Blade
(21540,4118,1,1,1,819),-- Evil Spirit Head
(21540,729,1,1,2,12),-- Scroll: Enchant Weapon (Grade A)
(21540,1343,10,30,2,154099),-- Silver Arrow
(21540,1894,1,1,2,3785),-- Crafted Leather
(21540,4039,1,1,2,3596),-- Mold Glue
(21540,4041,1,1,2,938),-- Mold Hardener
(21540,4044,1,1,2,3596),-- Thons
(21540,5394,1,1,2,930),-- Recipe: Sealed Tallum Gloves(60%)
(21540,8730,1,1,200,1198),-- Life Stone: level 67
(21540,8740,1,1,200,300),-- Mid-Grade Life Stone: level 67
(21540,8750,1,1,200,30),-- High-Grade Life Stone: level 67
(21540,8760,1,1,200,6),-- Top-Grade Life Stone: level 67
(21541,1874,1,1,-1,272060),-- Oriharukon Ore
(21541,4043,1,1,-1,136030),-- Asofe
(21541,4084,1,1,-1,70923),-- Blue Wolf Tunic Fabric
(21541,57,1619,3277,0,700000),-- Adena
(21541,11930,1,1,1,66),-- Common Item - Sword of Damascus
(21541,11943,1,1,1,66),-- Common Item - Wizard\'s Tear
(21541,11929,1,1,1,66),-- Common Item - Guardian Sword
(21541,8336,1,1,1,880),-- Blade of the Wizard\'s Tear
(21541,8330,1,1,1,878),-- Guardian Sword Blade
(21541,4114,1,1,1,880),-- Sword of Damascus Blade
(21541,1343,10,30,2,143503),-- Silver Arrow
(21541,1865,1,1,2,100453),-- Varnish
(21541,1870,1,1,2,100453),-- Coal
(21541,1874,1,1,2,6697),-- Oriharukon Ore
(21541,4039,1,1,2,3348),-- Mold Glue
(21541,4043,1,1,2,3348),-- Asofe
(21541,5392,1,1,2,866),-- Recipe: Sealed Dark Crystal Gloves(60%)
(21541,5271,1,1,2,134),-- Recipe: Greater Soulshot (A) Compressed Package(100%)
(21541,8729,1,1,200,1339),-- Life Stone: level 64
(21541,8739,1,1,200,335),-- Mid-Grade Life Stone: level 64
(21541,8749,1,1,200,34),-- High-Grade Life Stone: level 64
(21541,8759,1,1,200,7),-- Top-Grade Life Stone: level 64
(21542,1807,1,1,-1,3783),-- Recipe: Soulshot: A-Grade
(21542,3035,1,1,-1,3783),-- Recipe: Spiritshot A
(21542,4053,1,1,-1,121630),-- Ring of Black Ore Gemstone
(21542,57,1125,2280,0,700000),-- Adena
(21542,11939,1,1,1,137),-- Common Item - Demon Dagger
(21542,4119,1,1,1,1834),-- Demon Dagger Edge
(21542,1343,10,30,2,108855),-- Silver Arrow
(21542,1864,1,1,2,153398),-- Stem
(21542,1869,1,1,2,76199),-- Iron Ore
(21542,1880,1,1,2,7620),-- Steel
(21542,3035,1,1,2,102),-- Recipe: Spiritshot A
(21542,4043,1,1,2,2540),-- Asofe
(21542,5550,1,1,2,1016),-- Durable Metal Plate
(21542,8729,1,1,200,1016),-- Life Stone: level 64
(21542,8739,1,1,200,254),-- Mid-Grade Life Stone: level 64
(21542,8749,1,1,200,26),-- High-Grade Life Stone: level 64
(21542,8759,1,1,200,5),-- Top-Grade Life Stone: level 64
(21543,1877,1,1,-1,129509),-- Adamantite Nugget
(21543,4041,1,1,-1,28154),-- Mold Hardener
(21543,4054,1,1,-1,63772),-- Necklace of Black Ore Beads
(21543,57,1284,2601,0,700000),-- Adena
(21543,11935,1,1,1,31),-- Common Item - Deadman\'s Glory
(21543,11938,1,1,1,31),-- Common Item - Art of Battle Axe
(21543,11934,1,1,1,31),-- Common Item - Staff of Evil Spirits
(21543,11941,1,1,1,31),-- Common Item - Kaim Vanul's Bones
(21543,11936,1,1,1,31),-- Common Item - Star Buster
(21543,4116,1,1,1,418),-- Deadman\'s Glory Stone
(21543,4117,1,1,1,418),-- Art of Battle Axe Blade
(21543,4118,1,1,1,396),-- Evil Spirit Head
(21543,8340,1,1,1,418),-- Bones Head of Kaim Vanul
(21543,8348,1,1,1,417),-- Star Buster Head
(21543,1866,1,1,2,63758),-- Suede
(21543,1871,1,1,2,95637),-- Charcoal
(21543,1877,1,1,2,3825),-- Adamantite Nugget
(21543,3956,1,1,2,127),-- Recipe: Blessed Spiritshot A
(21543,4040,1,1,2,1913),-- Mold Lubricant
(21543,4041,1,1,2,832),-- Mold Hardener
(21543,8729,1,1,200,1275),-- Life Stone: level 64
(21543,8739,1,1,200,319),-- Mid-Grade Life Stone: level 64
(21543,8749,1,1,200,32),-- High-Grade Life Stone: level 64
(21543,8759,1,1,200,6),-- Top-Grade Life Stone: level 64
(21544,1875,1,1,-1,301461),-- Stone of Purity
(21544,4041,1,1,-1,39321),-- Mold Hardener
(21544,4115,1,1,-1,19727),-- Lance Blade
(21544,57,1783,3643,0,700000),-- Adena
(21544,12341,1,1,1,1033),-- Common Item - Earring of Black Ore
(21544,12343,1,1,1,1546),-- Common Item - Ring of Black Ore
(21544,12342,1,1,1,774),-- Common Item - Necklace of Black Ore
(21544,4052,1,1,1,7882),-- Earring of Black Ore Piece
(21544,4053,1,1,1,9542),-- Ring of Black Ore Gemstone
(21544,4054,1,1,1,4385),-- Necklace of Black Ore Beads
(21544,1867,1,1,2,161903),-- Animal Skin
(21544,1872,1,1,2,161903),-- Animal Bone
(21544,1875,1,1,2,8095),-- Stone of Purity
(21544,1881,1,1,2,16190),-- Coarse Bone Powder
(21544,4041,1,1,2,1056),-- Mold Hardener
(21544,5450,1,1,2,45),-- Recipe: Dragon Grinder(60%)
(21544,5392,1,1,2,1047),-- Recipe: Sealed Dark Crystal Gloves(60%)
(21544,8730,1,1,200,1349),-- Life Stone: level 67
(21544,8740,1,1,200,337),-- Mid-Grade Life Stone: level 67
(21544,8750,1,1,200,34),-- High-Grade Life Stone: level 67
(21544,8760,1,1,200,7),-- Top-Grade Life Stone: level 67
(21545,4052,1,1,-1,115082),-- Earring of Black Ore Piece
(21545,4054,1,1,-1,64024),-- Necklace of Black Ore Beads
(21545,5230,1,1,-1,4334),-- Recipe: Mithril Arrow (100%)
(21545,57,1288,2611,0,700000),-- Adena
(21545,12204,1,1,1,213),-- Common Item - Blue Wolf Breastplate
(21545,12193,1,1,1,341),-- Common Item - Blue Wolf Gaiters
(21545,12184,1,1,1,131),-- Common Item - Doom Plate Armor
(21545,4078,1,1,1,2337),-- Blue Wolf Breastplate Part
(21545,4080,1,1,1,3291),-- Blue Wolf Gaiters Material
(21545,4081,1,1,1,1577),-- Doom Plate Armor Temper
(21545,1343,10,30,2,124694),-- Silver Arrow
(21545,1864,1,3,2,87286),-- Stem
(21545,1865,1,1,2,87286),-- Varnish
(21545,1866,1,1,2,58191),-- Suede
(21545,1868,1,3,2,58191),-- Thread
(21545,1873,1,1,2,34914),-- Silver Nugget
(21545,6339,1,1,2,671),-- Recipe: Sealed Majestic Ring(70%)
(21545,8729,1,1,200,1164),-- Life Stone: level 64
(21545,8739,1,1,200,291),-- Mid-Grade Life Stone: level 64
(21545,8749,1,1,200,29),-- High-Grade Life Stone: level 64
(21545,8759,1,1,200,6),-- Top-Grade Life Stone: level 64
(21546,4077,1,1,-1,166838),-- Doom Shield Fragment
(21546,4078,1,1,-1,54175),-- Blue Wolf Breastplate Part
(21546,5458,1,1,-1,2027),-- Recipe: Halberd(60%)
(21546,57,1469,2980,0,700000),-- Adena
(21546,12201,1,1,1,243),-- Common Item - Blue Wolf Tunic
(21546,12192,1,1,1,243),-- Common Item - Tunic of Doom
(21546,12203,1,1,1,389),-- Common Item - Blue Wolf Stockings
(21546,12205,1,1,1,389),-- Common Item - Stockings of Doom
(21546,4084,1,1,1,2380),-- Blue Wolf Tunic Fabric
(21546,4085,1,1,1,2380),-- Tunic of Doom Pattern
(21546,4086,1,1,1,3213),-- Blue Wolf Stockings Pattern
(21546,4087,1,1,1,3213),-- Stockings of Doom Pattern
(21546,729,1,1,2,11),-- Scroll: Enchant Weapon (Grade A)
(21546,1867,1,3,2,44264),-- Animal Skin
(21546,1869,1,1,2,99593),-- Iron Ore
(21546,1870,1,1,2,99593),-- Coal
(21546,1871,1,1,2,99593),-- Charcoal
(21546,1872,1,3,2,66396),-- Animal Bone
(21546,5394,1,1,2,859),-- Recipe: Sealed Tallum Gloves(60%)
(21546,8729,1,1,200,1328),-- Life Stone: level 64
(21546,8739,1,1,200,332),-- Mid-Grade Life Stone: level 64
(21546,8749,1,1,200,33),-- High-Grade Life Stone: level 64
(21546,8759,1,1,200,7),-- Top-Grade Life Stone: level 64
(21547,4085,1,1,-1,53851),-- Tunic of Doom Pattern
(21547,5230,1,1,-1,4131),-- Recipe: Mithril Arrow (100%)
(21547,5271,1,1,-1,4131),-- Recipe: Greater Soulshot (A) Compressed Package(100%)
(21547,57,1229,2488,0,700000),-- Adena
(21547,11935,1,1,1,50),-- Common Item - Deadman\'s Glory
(21547,11938,1,1,1,50),-- Common Item - Art of Battle Axe
(21547,11934,1,1,1,50),-- Common Item - Staff of Evil Spirits
(21547,4116,1,1,1,667),-- Deadman\'s Glory Stone
(21547,4117,1,1,1,667),-- Art of Battle Axe Blade
(21547,4118,1,1,1,631),-- Evil Spirit Head
(21547,1895,1,1,2,26151),-- Metallic Fiber
(21547,4040,1,1,2,1831),-- Mold Lubricant
(21547,4042,1,1,2,1525),-- Enria
(21547,4043,1,1,2,3051),-- Asofe
(21547,5346,1,1,2,264),-- Recipe: Sealed Tallum Tunic(60%)
(21547,5276,1,1,2,122),-- Recipe: Greater Spiritshot (A) Compressed Package(100%)
(21547,8729,1,1,200,1220),-- Life Stone: level 64
(21547,8739,1,1,200,305),-- Mid-Grade Life Stone: level 64
(21547,8749,1,1,200,31),-- High-Grade Life Stone: level 64
(21547,8759,1,1,200,6),-- Top-Grade Life Stone: level 64
(21548,4044,1,1,-1,88283),-- Thons
(21548,4086,1,1,-1,62149),-- Blue Wolf Stockings Pattern
(21548,5549,1,1,-1,264849),-- Metallic Thread
(21548,57,1050,2127,0,700000),-- Adena
(21548,11933,1,1,1,128),-- Common Item - Bellion Cestus
(21548,4120,1,1,1,1709),-- Bellion Cestus Edge
(21548,1343,10,30,2,85970),-- Silver Arrow
(21548,1868,1,1,2,120358),-- Thread
(21548,1873,1,1,2,24072),-- Silver Nugget
(21548,1889,1,1,2,4012),-- Compound Braid
(21548,4044,1,1,2,2006),-- Thons
(21548,5346,1,1,2,1731),-- Recipe: Sealed Tallum Tunic(60%)
(21548,5281,1,1,2,80),-- Recipe: Greater Blessed Spiritshot (A) Compressed Package(100%)
(21548,5549,1,1,2,6018),-- Metallic Thread
(21548,6670,1,1,2,10030),-- Deluxe Chest Key - Grade 6
(21548,8729,1,1,200,902),-- Life Stone: level 64
(21548,8739,1,1,200,201),-- Mid-Grade Life Stone: level 64
(21548,8749,1,1,200,20),-- High-Grade Life Stone: level 64
(21548,8759,1,1,200,4),-- Top-Grade Life Stone: level 64
(21549,4053,1,1,-1,137396),-- Ring of Black Ore Gemstone
(21549,6329,1,1,-1,18422),-- Recipe: Sealed Phoenix Necklace(70%)
(21549,6331,1,1,-1,24469),-- Recipe: Sealed Phoenix Earring(70%)
(21549,57,1273,2574,0,700000),-- Adena
(21549,12183,1,1,1,801),-- Common Item - Doom Shield
(21549,12202,1,1,1,561),-- Common Item - Blue Wolf Helmet
(21549,12185,1,1,1,561),-- Common Item - Doom Helmet
(21549,4077,1,1,1,7099),-- Doom Shield Fragment
(21549,4088,1,1,1,5964),-- Blue Wolf Helmet Design
(21549,4089,1,1,1,5964),-- Doom Helmet Pattern
(21549,1864,1,3,2,86076),-- Stem
(21549,1865,1,1,2,86076),-- Varnish
(21549,1866,1,1,2,57384),-- Suede
(21549,1868,1,1,2,172153),-- Thread
(21549,1873,1,1,2,34430),-- Silver Nugget
(21549,5354,1,1,2,396),-- Recipe: Sealed Tallum Stockings(60%)
(21549,3035,1,1,2,115),-- Recipe: Spiritshot A
(21549,8729,1,1,200,1148),-- Life Stone: level 64
(21549,8739,1,1,200,287),-- Mid-Grade Life Stone: level 64
(21549,8749,1,1,200,28),-- High-Grade Life Stone: level 64
(21549,8759,1,1,200,7),-- Top-Grade Life Stone: level 64
(21550,4053,1,1,-1,140144),-- Ring of Black Ore Gemstone
(21550,6329,1,1,-1,18791),-- Recipe: Sealed Phoenix Necklace(70%)
(21550,6331,1,1,-1,24958),-- Recipe: Sealed Phoenix Earring(70%)
(21550,57,1298,2625,0,700000),-- Adena
(21550,12183,1,1,1,817),-- Common Item - Doom Shield
(21550,12202,1,1,1,572),-- Common Item - Blue Wolf Helmet
(21550,12185,1,1,1,572),-- Common Item - Doom Helmet
(21550,4077,1,1,1,7241),-- Doom Shield Fragment
(21550,4088,1,1,1,6083),-- Blue Wolf Helmet Design
(21550,4089,1,1,1,6083),-- Doom Helmet Pattern
(21550,1864,1,3,2,87798),-- Stem
(21550,1865,1,1,2,87798),-- Varnish
(21550,1866,1,1,2,58532),-- Suede
(21550,1868,1,1,2,175596),-- Thread
(21550,1873,1,1,2,35119),-- Silver Nugget
(21550,3035,1,1,2,117),-- Recipe: Spiritshot A
(21550,5354,1,1,2,404),-- Recipe: Sealed Tallum Stockings(60%)
(21550,8729,1,1,200,1171),-- Life Stone: level 64
(21550,8739,1,1,200,293),-- Mid-Grade Life Stone: level 64
(21550,8749,1,1,200,29),-- High-Grade Life Stone: level 64
(21550,8759,1,1,200,7),-- Top-Grade Life Stone: level 64
(21551,1884,1,5,-1,757104),-- Cord
(21551,4080,1,1,-1,75921),-- Blue Wolf Gaiters Material
(21551,5460,1,1,-1,2017),-- Recipe: Dasparion\'s Staff(60%)
(21551,57,1462,2965,0,700000),-- Adena
(21551,12188,1,1,1,725),-- Common Item - Boots of Doom
(21551,12189,1,1,1,725),-- Common Item - Blue Wolf Boots
(21551,12187,1,1,1,725),-- Common Item - Doom Gloves
(21551,12190,1,1,1,725),-- Common Item - Blue Wolf Gloves
(21551,4090,1,1,1,6118),-- Blue Wolf Boots Design
(21551,4091,1,1,1,6118),-- Doom Gloves Part
(21551,4096,1,1,1,6118),-- Blue Wolf Gloves Fabric
(21551,4099,1,1,1,6118),-- Doom Boots Part
(21551,730,1,1,2,83),-- Scroll: Enchant Armor (Grade A)
(21551,1343,10,30,2,141586),-- Silver Arrow
(21551,1874,1,1,2,6607),-- Oriharukon Ore
(21551,1878,1,1,2,39644),-- Braided Hemp
(21551,1884,1,1,2,60991),-- Cord
(21551,1889,1,1,2,6607),-- Compound Braid
(21551,5220,1,1,2,3964),-- Metal Hardener
(21551,8729,1,1,200,1322),-- Life Stone: level 64
(21551,8739,1,1,200,330),-- Mid-Grade Life Stone: level 64
(21551,8749,1,1,200,33),-- High-Grade Life Stone: level 64
(21551,8759,1,1,200,7),-- Top-Grade Life Stone: level 64
(21552,1884,1,5,-1,717399),-- Cord
(21552,4080,1,1,-1,71939),-- Blue Wolf Gaiters Material
(21552,5460,1,1,-1,1911),-- Recipe: Dasparion\'s Staff(60%)
(21552,57,1385,2810,0,700000),-- Adena
(21552,12188,1,1,1,687),-- Common Item - Boots of Doom
(21552,12189,1,1,1,687),-- Common Item - Blue Wolf Boots
(21552,12187,1,1,1,687),-- Common Item - Doom Gloves
(21552,12190,1,1,1,687),-- Common Item - Blue Wolf Gloves
(21552,4090,1,1,1,5797),-- Blue Wolf Boots Design
(21552,4091,1,1,1,5797),-- Doom Gloves Part
(21552,4096,1,1,1,5797),-- Blue Wolf Gloves Fabric
(21552,4099,1,1,1,5797),-- Doom Boots Part
(21552,730,1,1,2,78),-- Scroll: Enchant Armor (Grade A)
(21552,1343,10,30,2,134161),-- Silver Arrow
(21552,1874,1,1,2,6261),-- Oriharukon Ore
(21552,1878,1,1,2,37565),-- Braided Hemp
(21552,1884,1,1,2,57793),-- Cord
(21552,1889,1,1,2,6261),-- Compound Braid
(21552,5220,1,1,2,3756),-- Metal Hardener
(21552,8729,1,1,200,1252),-- Life Stone: level 64
(21552,8739,1,1,200,313),-- Mid-Grade Life Stone: level 64
(21552,8749,1,1,200,31),-- High-Grade Life Stone: level 64
(21552,8759,1,1,200,6),-- Top-Grade Life Stone: level 64
(21553,1895,1,1,-1,739065),-- Metallic Fiber
(21553,4080,1,1,-1,53208),-- Blue Wolf Gaiters Material
(21553,5346,1,1,-1,7455),-- Recipe: Sealed Tallum Tunic(60%)
(21553,57,1025,2078,0,700000),-- Adena
(21553,12188,1,1,1,508),-- Common Item - Boots of Doom
(21553,12189,1,1,1,508),-- Common Item - Blue Wolf Boots
(21553,12187,1,1,1,508),-- Common Item - Doom Gloves
(21553,12190,1,1,1,508),-- Common Item - Blue Wolf Gloves
(21553,4090,1,1,1,4288),-- Blue Wolf Boots Design
(21553,4091,1,1,1,4288),-- Doom Gloves Part
(21553,4096,1,1,1,4288),-- Blue Wolf Gloves Fabric
(21553,4099,1,1,1,4288),-- Doom Boots Part
(21553,1868,1,1,2,138923),-- Thread
(21553,1873,1,1,2,27785),-- Silver Nugget
(21553,1876,1,1,2,13892),-- Mithril Ore
(21553,1895,1,1,2,19846),-- Metallic Fiber
(21553,4042,1,1,2,1158),-- Enria
(21553,5348,1,1,2,137),-- Recipe: Sealed Dark Crystal Robe(60%)
(21553,5462,1,1,2,26),-- Recipe: Branch of The Mother Tree(60%)
(21553,8729,1,1,200,926),-- Life Stone: level 64
(21553,8739,1,1,200,232),-- Mid-Grade Life Stone: level 64
(21553,8749,1,1,200,23),-- High-Grade Life Stone: level 64
(21553,8759,1,1,200,4),-- Top-Grade Life Stone: level 64
(21554,1895,1,1,-1,739065),-- Metallic Fiber
(21554,4080,1,1,-1,53208),-- Blue Wolf Gaiters Material
(21554,5346,1,1,-1,7455),-- Recipe: Sealed Tallum Tunic(60%)
(21554,57,1025,2078,0,700000),-- Adena
(21554,12188,1,1,1,508),-- Common Item - Boots of Doom
(21554,12189,1,1,1,508),-- Common Item - Blue Wolf Boots
(21554,12187,1,1,1,508),-- Common Item - Doom Gloves
(21554,12190,1,1,1,508),-- Common Item - Blue Wolf Gloves
(21554,4090,1,1,1,4288),-- Blue Wolf Boots Design
(21554,4091,1,1,1,4288),-- Doom Gloves Part
(21554,4096,1,1,1,4288),-- Blue Wolf Gloves Fabric
(21554,4099,1,1,1,4288),-- Doom Boots Part
(21554,1868,1,1,2,138923),-- Thread
(21554,1873,1,1,2,27785),-- Silver Nugget
(21554,1876,1,1,2,13892),-- Mithril Ore
(21554,1895,1,1,2,19846),-- Metallic Fiber
(21554,4042,1,1,2,1158),-- Enria
(21554,5348,1,1,2,137),-- Recipe: Sealed Dark Crystal Robe(60%)
(21554,5462,1,1,2,26),-- Recipe: Branch of The Mother Tree(60%)
(21554,8729,1,1,200,926),-- Life Stone: level 64
(21554,8739,1,1,200,232),-- Mid-Grade Life Stone: level 64
(21554,8749,1,1,200,23),-- High-Grade Life Stone: level 64
(21554,8759,1,1,200,4),-- Top-Grade Life Stone: level 64
(21555,4082,1,1,-1,35533),-- Blue Wolf Leather Armor Texture
(21555,4083,1,1,-1,35533),-- Leather Armor of Doom Design
(21555,5354,1,1,-1,14491),-- Recipe: Sealed Tallum Stockings(60%)
(21555,57,1246,2527,0,700000),-- Adena
(21555,11933,1,1,1,152),-- Common Item - Bellion Cestus
(21555,4120,1,1,1,2029),-- Bellion Cestus Edge
(21555,1867,1,1,2,112592),-- Animal Skin
(21555,1872,1,1,2,112592),-- Animal Bone
(21555,1875,1,1,2,5629),-- Stone of Purity
(21555,1881,1,1,2,11259),-- Coarse Bone Powder
(21555,4041,1,1,2,734),-- Mold Hardener
(21555,8300,1,1,2,46),-- Recipe: Infernal Master (60%)
(21555,5466,1,1,2,31),-- Recipe: Sword of Miracles(60%)
(21555,8729,1,1,200,1126),-- Life Stone: level 64
(21555,8739,1,1,200,281),-- Mid-Grade Life Stone: level 64
(21555,8749,1,1,200,28),-- High-Grade Life Stone: level 64
(21555,8759,1,1,200,6),-- Top-Grade Life Stone: level 64
(21556,4082,1,1,-1,34673),-- Blue Wolf Leather Armor Texture
(21556,4083,1,1,-1,34673),-- Leather Armor of Doom Design
(21556,5354,1,1,-1,14141),-- Recipe: Sealed Tallum Stockings(60%)
(21556,57,1216,2466,0,700000),-- Adena
(21556,11933,1,1,1,148),-- Common Item - Bellion Cestus
(21556,4120,1,1,1,1980),-- Bellion Cestus Edge
(21556,1867,1,1,2,109868),-- Animal Skin
(21556,1872,1,1,2,109868),-- Animal Bone
(21556,1875,1,1,2,5493),-- Stone of Purity
(21556,1881,1,1,2,10987),-- Coarse Bone Powder
(21556,4041,1,1,2,716),-- Mold Hardener
(21556,8300,1,1,2,45),-- Recipe: Infernal Master (60%)
(21556,5466,1,1,2,31),-- Recipe: Sword of Miracles(60%)
(21556,8729,1,1,200,1099),-- Life Stone: level 64
(21556,8739,1,1,200,275),-- Mid-Grade Life Stone: level 64
(21556,8749,1,1,200,27),-- High-Grade Life Stone: level 64
(21556,8759,1,1,200,5),-- Top-Grade Life Stone: level 64
(21557,4082,1,1,-1,41024),-- Blue Wolf Leather Armor Texture
(21557,4083,1,1,-1,41024),-- Leather Armor of Doom Design
(21557,5470,1,1,-1,1984),-- Recipe: Tallum Blade(60%)
(21557,57,1438,2917,0,700000),-- Adena
(21557,12204,1,1,1,238),-- Common Item - Blue Wolf Breastplate
(21557,12193,1,1,1,381),-- Common Item - Blue Wolf Gaiters
(21557,12184,1,1,1,146),-- Common Item - Doom Plate Armor
(21557,4078,1,1,1,2611),-- Blue Wolf Breastplate Part
(21557,4080,1,1,1,3676),-- Blue Wolf Gaiters Material
(21557,4081,1,1,1,1762),-- Doom Plate Armor Temper
(21557,1343,10,30,2,139275),-- Silver Arrow
(21557,1876,1,1,2,19499),-- Mithril Ore
(21557,1877,1,1,2,3900),-- Adamantite Nugget
(21557,1880,1,1,2,9749),-- Steel
(21557,1881,1,1,2,12999),-- Coarse Bone Powder
(21557,1882,1,1,2,21665),-- Leather
(21557,5440,1,1,2,36),-- Recipe: Elysian(60%)
(21557,8729,1,1,200,1300),-- Life Stone: level 64
(21557,8739,1,1,200,325),-- Mid-Grade Life Stone: level 64
(21557,8749,1,1,200,33),-- High-Grade Life Stone: level 64
(21557,8759,1,1,200,6),-- Top-Grade Life Stone: level 64
(21558,4082,1,1,-1,41024),-- Blue Wolf Leather Armor Texture
(21558,4083,1,1,-1,41024),-- Leather Armor of Doom Design
(21558,5470,1,1,-1,1984),-- Recipe: Tallum Blade(60%)
(21558,57,1438,2917,0,700000),-- Adena
(21558,12204,1,1,1,238),-- Common Item - Blue Wolf Breastplate
(21558,12193,1,1,1,381),-- Common Item - Blue Wolf Gaiters
(21558,12184,1,1,1,146),-- Common Item - Doom Plate Armor
(21558,4078,1,1,1,2611),-- Blue Wolf Breastplate Part
(21558,4080,1,1,1,3676),-- Blue Wolf Gaiters Material
(21558,4081,1,1,1,1762),-- Doom Plate Armor Temper
(21558,1343,10,30,2,139275),-- Silver Arrow
(21558,1876,1,1,2,19499),-- Mithril Ore
(21558,1877,1,1,2,3900),-- Adamantite Nugget
(21558,1880,1,1,2,9749),-- Steel
(21558,1881,1,1,2,12999),-- Coarse Bone Powder
(21558,1882,1,1,2,21665),-- Leather
(21558,5440,1,1,2,36),-- Recipe: Elysian(60%)
(21558,8729,1,1,200,1300),-- Life Stone: level 64
(21558,8739,1,1,200,325),-- Mid-Grade Life Stone: level 64
(21558,8749,1,1,200,33),-- High-Grade Life Stone: level 64
(21558,8759,1,1,200,6),-- Top-Grade Life Stone: level 64
(21559,4085,1,1,-1,69006),-- Tunic of Doom Pattern
(21559,6329,1,1,-1,22819),-- Recipe: Sealed Phoenix Necklace(70%)
(21559,6331,1,1,-1,30310),-- Recipe: Sealed Phoenix Earring(70%)
(21559,57,1573,3190,0,700000),-- Adena
(21559,12188,1,1,1,780),-- Common Item - Boots of Doom
(21559,12189,1,1,1,780),-- Common Item - Blue Wolf Boots
(21559,12187,1,1,1,780),-- Common Item - Doom Gloves
(21559,12190,1,1,1,780),-- Common Item - Blue Wolf Gloves
(21559,4090,1,1,1,6582),-- Blue Wolf Boots Design
(21559,4091,1,1,1,6582),-- Doom Gloves Part
(21559,4096,1,1,1,6582),-- Blue Wolf Gloves Fabric
(21559,4099,1,1,1,6582),-- Doom Boots Part
(21559,1343,10,30,2,152318),-- Silver Arrow
(21559,1864,1,3,2,106623),-- Stem
(21559,1869,1,1,2,106623),-- Iron Ore
(21559,1878,1,1,2,42649),-- Braided Hemp
(21559,1884,1,1,2,65614),-- Cord
(21559,4039,1,1,2,3554),-- Mold Glue
(21559,5448,1,1,2,39),-- Recipe: Soul Separator(60%)
(21559,8729,1,1,200,1421),-- Life Stone: level 64
(21559,8739,1,1,200,356),-- Mid-Grade Life Stone: level 64
(21559,8749,1,1,200,35),-- High-Grade Life Stone: level 64
(21559,8759,1,1,200,7),-- Top-Grade Life Stone: level 64
(21560,1875,1,1,-1,264705),-- Stone of Purity
(21560,4040,1,1,-1,79412),-- Mold Lubricant
(21560,4086,1,1,-1,93173),-- Blue Wolf Stockings Pattern
(21560,57,1573,3190,0,700000),-- Adena
(21560,12201,1,1,1,260),-- Common Item - Blue Wolf Tunic
(21560,12192,1,1,1,260),-- Common Item - Tunic of Doom
(21560,12203,1,1,1,417),-- Common Item - Blue Wolf Stockings
(21560,12205,1,1,1,417),-- Common Item - Stockings of Doom
(21560,4084,1,1,1,2548),-- Blue Wolf Tunic Fabric
(21560,4085,1,1,1,2548),-- Tunic of Doom Pattern
(21560,4086,1,1,1,3440),-- Blue Wolf Stockings Pattern
(21560,4087,1,1,1,3440),-- Stockings of Doom Pattern
(21560,1865,1,1,2,117285),-- Varnish
(21560,1870,1,1,2,117285),-- Coal
(21560,1875,1,1,2,7819),-- Stone of Purity
(21560,1879,1,1,2,19548),-- Cokes
(21560,4040,1,1,2,2346),-- Mold Lubricant
(21560,5450,1,1,2,43),-- Recipe: Dragon Grinder(60%)
(21560,8729,1,1,200,1564),-- Life Stone: level 64
(21560,8739,1,1,200,391),-- Mid-Grade Life Stone: level 64
(21560,8749,1,1,200,39),-- High-Grade Life Stone: level 64
(21560,8759,1,1,200,7),-- Top-Grade Life Stone: level 64
(21561,3956,1,1,-1,4456),-- Recipe: Blessed Spiritshot A
(21561,4116,1,1,-1,14604),-- Deadman\'s Glory Stone
(21561,4117,1,1,-1,14604),-- Art of Battle Axe Blade
(21561,57,1318,2693,0,700000),-- Adena
(21561,12204,1,1,1,219),-- Common Item - Blue Wolf Breastplate
(21561,12193,1,1,1,350),-- Common Item - Blue Wolf Gaiters
(21561,12184,1,1,1,135),-- Common Item - Doom Plate Armor
(21561,4078,1,1,1,2403),-- Blue Wolf Breastplate Part
(21561,4080,1,1,1,3384),-- Blue Wolf Gaiters Material
(21561,4081,1,1,1,1622),-- Doom Plate Armor Temper
(21561,1343,10,30,2,117522),-- Silver Arrow
(21561,1865,1,1,2,82266),-- Varnish
(21561,1870,1,1,2,82266),-- Coal
(21561,1875,1,1,2,5484),-- Stone of Purity
(21561,1879,1,1,2,13711),-- Cokes
(21561,4040,1,1,2,1645),-- Mold Lubricant
(21561,5456,1,1,2,31),-- Recipe: Tallum Glaive(60%)
(21561,6670,1,1,2,13711),-- Deluxe Chest Key - Grade 6
(21561,8730,1,1,200,914),-- Life Stone: level 67
(21561,8740,1,1,200,229),-- Mid-Grade Life Stone: level 67
(21561,8750,1,1,200,23),-- High-Grade Life Stone: level 67
(21561,8760,1,1,200,4),-- Top-Grade Life Stone: level 67
(21562,4118,1,1,-1,14328),-- Evil Spirit Head
(21562,5156,1,1,-1,4614),-- Recipe: Soulshot (A) Compressed Package (100%)
(21562,5220,1,1,-1,138433),-- Metal Hardener
(21562,57,1364,2788,0,700000),-- Adena
(21562,12201,1,1,1,227),-- Common Item - Blue Wolf Tunic
(21562,12192,1,1,1,227),-- Common Item - Tunic of Doom
(21562,12203,1,1,1,363),-- Common Item - Blue Wolf Stockings
(21562,12205,1,1,1,363),-- Common Item - Stockings of Doom
(21562,4084,1,1,1,2221),-- Blue Wolf Tunic Fabric
(21562,4085,1,1,1,2221),-- Tunic of Doom Pattern
(21562,4086,1,1,1,2998),-- Blue Wolf Stockings Pattern
(21562,4087,1,1,1,2998),-- Stockings of Doom Pattern
(21562,1866,1,1,2,68151),-- Suede
(21562,1871,1,1,2,102227),-- Charcoal
(21562,1885,1,1,2,8519),-- High Grade Suede
(21562,4041,1,1,2,889),-- Mold Hardener
(21562,5220,1,1,2,4089),-- Metal Hardener
(21562,5462,1,1,2,38),-- Recipe: Branch of The Mother Tree(60%)
(21562,8730,1,1,200,1136),-- Life Stone: level 67
(21562,8740,1,1,200,284),-- Mid-Grade Life Stone: level 67
(21562,8750,1,1,200,28),-- High-Grade Life Stone: level 67
(21562,8760,1,1,200,6),-- Top-Grade Life Stone: level 67
(21563,4042,1,1,-1,67020),-- Enria
(21563,4119,1,1,-1,17601),-- Demon Dagger Edge
(21563,5161,1,1,-1,5362),-- Recipe: Spiritshot (A) Compressed Package (100%)
(21563,57,1585,3240,0,700000),-- Adena
(21563,12204,1,1,1,264),-- Common Item - Blue Wolf Breastplate
(21563,12193,1,1,1,422),-- Common Item - Blue Wolf Gaiters
(21563,12184,1,1,1,162),-- Common Item - Doom Plate Armor
(21563,4078,1,1,1,2892),-- Blue Wolf Breastplate Part
(21563,4080,1,1,1,4072),-- Blue Wolf Gaiters Material
(21563,4081,1,1,1,1951),-- Doom Plate Armor Temper
(21563,1343,10,30,2,154258),-- Silver Arrow
(21563,1867,1,1,2,143975),-- Animal Skin
(21563,1872,1,1,2,143975),-- Animal Bone
(21563,1882,1,1,2,23996),-- Leather
(21563,1894,1,1,2,3789),-- Crafted Leather
(21563,4042,1,1,2,1800),-- Enria
(21563,5464,1,1,2,40),-- Recipe: Dark Legion\'s Edge(60%)
(21563,8730,1,1,200,1200),-- Life Stone: level 67
(21563,8740,1,1,200,300),-- Mid-Grade Life Stone: level 67
(21563,8750,1,1,200,30),-- High-Grade Life Stone: level 67
(21563,8760,1,1,200,6),-- Top-Grade Life Stone: level 67
(21564,4120,1,1,-1,16716),-- Bellion Cestus Edge
(21564,4121,1,1,-1,16660),-- Bow of Peril Shaft
(21564,5166,1,1,-1,5101),-- Recipe: Blessed Spiritshot (A) Compressed Package (100%)
(21564,57,1508,3082,0,700000),-- Adena
(21564,12194,1,1,1,309),-- Common Item - Blue Wolf Leather Armor
(21564,12186,1,1,1,309),-- Common Item - Leather Armor of Doom
(21564,4082,1,1,1,3192),-- Blue Wolf Leather Armor Texture
(21564,4083,1,1,1,3192),-- Leather Armor of Doom Design
(21564,1868,1,1,2,225993),-- Thread
(21564,1873,1,1,2,45199),-- Silver Nugget
(21564,1889,1,1,2,7533),-- Compound Braid
(21564,4044,1,1,2,3767),-- Thons
(21564,5466,1,1,2,42),-- Recipe: Sword of Miracles(60%)
(21564,5549,1,1,2,11300),-- Metallic Thread
(21564,8730,1,1,200,1256),-- Life Stone: level 67
(21564,8740,1,1,200,314),-- Mid-Grade Life Stone: level 67
(21564,8750,1,1,200,31),-- High-Grade Life Stone: level 67
(21564,8760,1,1,200,6),-- Top-Grade Life Stone: level 67
(21565,5464,1,1,-1,1435),-- Recipe: Dark Legion\'s Edge(60%)
(21565,5520,1,1,-1,24990),-- Sealed Dark Crystal Breastplate Pattern
(21565,5521,1,1,-1,17634),-- Sealed Tallum Plate Armor Pattern
(21565,57,1533,3116,0,700000),-- Adena
(21565,11960,1,1,1,158),-- Common Item - Halberd
(21565,5542,1,1,1,1930),-- Halberd Edge
(21565,1867,1,1,2,152626),-- Animal Skin
(21565,1872,1,1,2,152626),-- Animal Bone
(21565,1882,1,1,2,25438),-- Leather
(21565,1894,1,1,2,4016),-- Crafted Leather
(21565,4042,1,1,2,1908),-- Enria
(21565,5464,1,1,2,42),-- Recipe: Dark Legion\'s Edge(60%)
(21565,8730,1,1,200,1272),-- Life Stone: level 67
(21565,8740,1,1,200,318),-- Mid-Grade Life Stone: level 67
(21565,8750,1,1,200,32),-- High-Grade Life Stone: level 67
(21565,8760,1,1,200,6),-- Top-Grade Life Stone: level 67
(21566,729,1,1,-1,471),-- Scroll: Enchant Weapon (Grade A)
(21566,4044,1,1,-1,141272),-- Thons
(21566,5549,1,1,-1,423817),-- Metallic Thread
(21566,57,1676,3408,0,700000),-- Adena
(21566,11955,1,1,1,172),-- Common Item - Carnage Bow
(21566,5535,1,1,1,2136),-- Carnage Bow Stave
(21566,1343,10,30,2,162583),-- Silver Arrow
(21566,1868,1,1,2,227617),-- Thread
(21566,1873,1,1,2,45523),-- Silver Nugget
(21566,1889,1,1,2,7587),-- Compound Braid
(21566,4044,1,1,2,3793),-- Thons
(21566,5466,1,1,2,42),-- Recipe: Sword of Miracles(60%)
(21566,5549,1,1,2,11381),-- Metallic Thread
(21566,8730,1,1,200,1264),-- Life Stone: level 67
(21566,8740,1,1,200,316),-- Mid-Grade Life Stone: level 67
(21566,8750,1,1,200,32),-- High-Grade Life Stone: level 67
(21566,8760,1,1,200,6),-- Top-Grade Life Stone: level 67
(21567,5466,1,1,-1,1876),-- Recipe: Sword of Miracles(60%)
(21567,5524,1,1,-1,49929),-- Sealed Dark Crystal Gaiters Pattern
(21567,5525,1,1,-1,78309),-- Sealed Dark Crystal Helmet Design
(21567,57,2004,4074,0,700000),-- Adena
(21567,11951,1,1,1,206),-- Common Item - Bloody Orchid
(21567,5536,1,1,1,2545),-- Bloody Orchid Head
(21567,1864,1,1,2,299274),-- Stem
(21567,1869,1,1,2,149637),-- Iron Ore
(21567,1880,1,1,2,14964),-- Steel
(21567,4043,1,1,2,4988),-- Asofe
(21567,5550,1,1,2,1995),-- Durable Metal Plate
(21567,6335,1,1,2,575),-- Recipe: Sealed Majestic Necklace(70%)
(21567,8730,1,1,200,1663),-- Life Stone: level 67
(21567,8740,1,1,200,416),-- Mid-Grade Life Stone: level 67
(21567,8750,1,1,200,42),-- High-Grade Life Stone: level 67
(21567,8760,1,1,200,9),-- Top-Grade Life Stone: level 67
(21568,730,1,1,-1,3332),-- Scroll: Enchant Armor (Grade A)
(21568,5526,1,1,-1,61809),-- Sealed Tallum Helm Design
(21568,6335,1,1,-1,15379),-- Recipe: Sealed Majestic Necklace(70%)
(21568,57,1582,3215,0,700000),-- Adena
(21568,11951,1,1,1,163),-- Common Item - Bloody Orchid
(21568,5536,1,1,1,2009),-- Bloody Orchid Head
(21568,1343,10,30,2,153385),-- Silver Arrow
(21568,1865,1,1,2,107371),-- Varnish
(21568,1870,1,1,2,107371),-- Coal
(21568,1874,1,1,2,7158),-- Oriharukon Ore
(21568,4039,1,1,2,3579),-- Mold Glue
(21568,4043,1,1,2,3579),-- Asofe
(21568,6337,1,1,2,551),-- Recipe: Sealed Majestic Earring(70%)
(21568,8730,1,1,200,1193),-- Life Stone: level 67
(21568,8740,1,1,200,298),-- Mid-Grade Life Stone: level 67
(21568,8750,1,1,200,30),-- High-Grade Life Stone: level 67
(21568,8760,1,1,200,6),-- Top-Grade Life Stone: level 67
(21569,730,1,1,-1,2523),-- Scroll: Enchant Armor (Grade A)
(21569,5526,1,1,-1,46809),-- Sealed Tallum Helm Design
(21569,6335,1,1,-1,11646),-- Recipe: Sealed Majestic Necklace(70%)
(21569,57,1198,2435,0,700000),-- Adena
(21569,11951,1,1,1,123),-- Common Item - Bloody Orchid
(21569,5536,1,1,1,1522),-- Bloody Orchid Head
(21569,1343,10,30,2,116161),-- Silver Arrow
(21569,1865,1,1,2,81313),-- Varnish
(21569,1870,1,1,2,81313),-- Coal
(21569,1874,1,1,2,5421),-- Oriharukon Ore
(21569,4039,1,1,2,2711),-- Mold Glue
(21569,4043,1,1,2,2711),-- Asofe
(21569,6337,1,1,2,417),-- Recipe: Sealed Majestic Earring(70%)
(21569,8730,1,1,200,904),-- Life Stone: level 67
(21569,8740,1,1,200,226),-- Mid-Grade Life Stone: level 67
(21569,8750,1,1,200,23),-- High-Grade Life Stone: level 67
(21569,8760,1,1,200,5),-- Top-Grade Life Stone: level 67
(21570,5464,1,1,-1,1167),-- Recipe: Dark Legion\'s Edge(60%)
(21570,5542,1,1,-1,10630),-- Halberd Edge
(21570,5543,1,1,-1,10730),-- Dasparion\'s Staff Edge
(21570,57,1248,2533,0,700000),-- Adena
(21570,11950,1,1,1,128),-- Common Item - Blood Tornado
(21570,5539,1,1,1,1570),-- Blood Tornado Edge
(21570,1867,1,1,2,124147),-- Animal Skin
(21570,1872,1,1,2,124147),-- Animal Bone
(21570,1875,1,1,2,6207),-- Stone of Purity
(21570,1881,1,1,2,12415),-- Coarse Bone Powder
(21570,4041,1,1,2,810),-- Mold Hardener
(21570,6339,1,1,2,716),-- Recipe: Sealed Majestic Ring(70%)
(21570,8730,1,1,200,1035),-- Life Stone: level 67
(21570,8740,1,1,200,259),-- Mid-Grade Life Stone: level 67
(21570,8750,1,1,200,26),-- High-Grade Life Stone: level 67
(21570,8760,1,1,200,5),-- Top-Grade Life Stone: level 67
(21571,729,1,1,-1,461),-- Scroll: Enchant Weapon (Grade A)
(21571,4042,1,1,-1,69170),-- Enria
(21571,4043,1,1,-1,138340),-- Asofe
(21571,57,1643,3335,0,700000),-- Adena
(21571,11955,1,1,1,169),-- Common Item - Carnage Bow
(21571,5535,1,1,1,2091),-- Carnage Bow Stave
(21571,729,1,1,2,12),-- Scroll: Enchant Weapon (Grade A)
(21571,1343,10,30,2,159209),-- Silver Arrow
(21571,1895,1,1,2,31842),-- Metallic Fiber
(21571,4040,1,1,2,2229),-- Mold Lubricant
(21571,4042,1,1,2,1858),-- Enria
(21571,4043,1,1,2,3715),-- Asofe
(21571,8487,1,1,2,61),-- Recipe: Destroyer Hammer (60%)
(21571,8730,1,1,200,1238),-- Life Stone: level 67
(21571,8740,1,1,200,310),-- Mid-Grade Life Stone: level 67
(21571,8750,1,1,200,31),-- High-Grade Life Stone: level 67
(21571,8760,1,1,200,6),-- Top-Grade Life Stone: level 67
(21572,5466,1,1,-1,1589),-- Recipe: Sword of Miracles(60%)
(21572,5547,1,1,-1,14592),-- Elemental Sword Edge
(21572,5548,1,1,-1,14592),-- Tallum Blade Edge
(21572,57,1698,3447,0,700000),-- Adena
(21572,11951,1,1,1,174),-- Common Item - Bloody Orchid
(21572,5536,1,1,1,2156),-- Bloody Orchid Head
(21572,730,1,1,2,96),-- Scroll: Enchant Armor (Grade A)
(21572,1868,1,1,2,230345),-- Thread
(21572,1873,1,1,2,46069),-- Silver Nugget
(21572,1889,1,1,2,7678),-- Compound Braid
(21572,4044,1,1,2,3839),-- Thons
(21572,5549,1,1,2,11517),-- Metallic Thread
(21572,5352,1,1,2,149),-- Recipe: Sealed Majestic Robe(60%)
(21572,8730,1,1,200,1280),-- Life Stone: level 67
(21572,8740,1,1,200,320),-- Mid-Grade Life Stone: level 67
(21572,8750,1,1,200,32),-- High-Grade Life Stone: level 67
(21572,8760,1,1,200,6),-- Top-Grade Life Stone: level 67
(21573,730,1,1,-1,3685),-- Scroll: Enchant Armor (Grade A)
(21573,6335,1,1,-1,17007),-- Recipe: Sealed Majestic Necklace(70%)
(21573,6341,1,1,-1,122303),-- Sealed Phoenix Earring Gemstone
(21573,57,1750,3554,0,700000),-- Adena
(21573,12226,1,1,1,633),-- Common Item - Sealed Dark Crystal Helmet
(21573,12225,1,1,1,903),-- Common Item - Sealed Dark Crystal Shield
(21573,12234,1,1,1,633),-- Common Item - Sealed Tallum Helmet
(21573,5494,1,1,1,4572),-- Sealed Dark Crystal Shield Fragment
(21573,5525,1,1,1,3365),-- Sealed Dark Crystal Helmet Design
(21573,5526,1,1,1,3365),-- Sealed Tallum Helm Design
(21573,1343,10,30,2,169631),-- Silver Arrow
(21573,1868,1,3,2,118742),-- Thread
(21573,1873,1,1,2,47497),-- Silver Nugget
(21573,1876,1,1,2,23748),-- Mithril Ore
(21573,1895,1,1,2,33926),-- Metallic Fiber
(21573,4042,1,1,2,1979),-- Enria
(21573,5434,1,1,2,44),-- Recipe: Dragon Slayer(60%)
(21573,8730,1,1,200,1319),-- Life Stone: level 67
(21573,8740,1,1,200,330),-- Mid-Grade Life Stone: level 67
(21573,8750,1,1,200,33),-- High-Grade Life Stone: level 67
(21573,8760,1,1,200,7),-- Top-Grade Life Stone: level 67
(21574,729,1,1,-1,600),-- Scroll: Enchant Weapon (Grade A)
(21574,5448,1,1,-1,2000),-- Recipe: Soul Separator(60%)
(21574,5494,1,1,-1,113405),-- Sealed Dark Crystal Shield Fragment
(21574,57,2136,4345,0,700000),-- Adena
(21574,11960,1,1,1,220),-- Common Item - Halberd
(21574,5542,1,1,1,2689),-- Halberd Edge
(21574,1343,30,90,2,94941),-- Silver Arrow
(21574,1868,1,3,2,199376),-- Thread
(21574,1873,1,1,2,79750),-- Silver Nugget
(21574,1889,1,1,2,13292),-- Compound Braid
(21574,4044,1,1,2,6646),-- Thons
(21574,5466,1,1,2,74),-- Recipe: Sword of Miracles(60%)
(21574,5549,1,1,2,19938),-- Metallic Thread
(21574,10305,1,1,1,798),-- Transform Sealbook - Oel Mahum
(21575,729,1,1,-1,338),-- Scroll: Enchant Weapon (Grade A)
(21575,5448,1,1,-1,1127),-- Recipe: Soul Separator(60%)
(21575,5494,1,1,-1,63890),-- Sealed Dark Crystal Shield Fragment
(21575,57,1203,2448,0,700000),-- Adena
(21575,11960,1,1,1,124),-- Common Item - Halberd
(21575,5542,1,1,1,1515),-- Halberd Edge
(21575,1343,10,30,2,160463),-- Silver Arrow
(21575,1868,1,1,2,224649),-- Thread
(21575,1873,1,1,2,44930),-- Silver Nugget
(21575,1889,1,1,2,7489),-- Compound Braid
(21575,4044,1,1,2,37443),-- Thons
(21575,5466,1,1,2,42),-- Recipe: Sword of Miracles(60%)
(21575,5549,1,1,2,11233),-- Metallic Thread
(21575,10305,1,1,1,449),-- Transform Sealbook - Oel Mahum
(21576,5450,1,1,-1,1316),-- Recipe: Dragon Grinder(60%)
(21576,5456,1,1,-1,1316),-- Recipe: Tallum Glaive(60%)
(21576,5497,1,1,-1,83285),-- Sealed Tallum Boots Lining
(21576,57,1405,2858,0,700000),-- Adena
(21576,11951,1,1,1,144),-- Common Item - Bloody Orchid
(21576,5536,1,1,1,1785),-- Bloody Orchid Head
(21576,1343,10,30,2,136264),-- Silver Arrow
(21576,1868,1,1,2,190771),-- Thread
(21576,1873,1,1,2,38154),-- Silver Nugget
(21576,1876,1,1,2,19077),-- Mithril Ore
(21576,1895,1,1,2,27253),-- Metallic Fiber
(21576,4042,1,1,2,1590),-- Enria
(21576,6337,1,1,2,489),-- Recipe: Sealed Majestic Earring(70%)
(21576,8730,1,1,200,1060),-- Life Stone: level 67
(21576,8740,1,1,200,265),-- Mid-Grade Life Stone: level 67
(21576,8750,1,1,200,27),-- High-Grade Life Stone: level 67
(21576,8760,1,1,200,5),-- Top-Grade Life Stone: level 67
(21577,5450,1,1,-1,1270),-- Recipe: Dragon Grinder(60%)
(21577,5456,1,1,-1,1270),-- Recipe: Tallum Glaive(60%)
(21577,5497,1,1,-1,80418),-- Sealed Tallum Boots Lining
(21577,57,1356,2760,0,700000),-- Adena
(21577,11951,1,1,1,139),-- Common Item - Bloody Orchid
(21577,5536,1,1,1,1724),-- Bloody Orchid Head
(21577,1343,10,30,2,131573),-- Silver Arrow
(21577,1868,1,1,2,184203),-- Thread
(21577,1873,1,1,2,36841),-- Silver Nugget
(21577,1876,1,1,2,184208),-- Mithril Ore
(21577,1895,1,1,2,26315),-- Metallic Fiber
(21577,4042,1,1,2,1535),-- Enria
(21577,6337,1,1,2,472),-- Recipe: Sealed Majestic Earring(70%)
(21577,8730,1,1,200,1023),-- Life Stone: level 67
(21577,8740,1,1,200,256),-- Mid-Grade Life Stone: level 67
(21577,8750,1,1,200,26),-- High-Grade Life Stone: level 67
(21577,8760,1,1,200,5),-- Top-Grade Life Stone: level 67
(21578,5464,1,1,-1,1192),-- Recipe: Dark Legion\'s Edge(60%)
(21578,5482,1,1,-1,42487),-- Sealed Dark Crystalline Leggings Design
(21578,5485,1,1,-1,27069),-- Sealed Tallum Tunic Texture
(21578,57,1588,3238,0,700000),-- Adena
(21578,11950,1,1,1,164),-- Common Item - Blood Tornado
(21578,5539,1,1,1,2004),-- Blood Tornado Edge
(21578,1344,10,30,2,135064),-- Mithril Arrow
(21578,1866,1,1,2,72034),-- Suede
(21578,1871,1,1,2,108052),-- Charcoal
(21578,1877,1,1,2,4322),-- Adamantite Nugget
(21578,4040,1,1,2,2161),-- Mold Lubricant
(21578,4041,1,1,2,940),-- Mold Hardener
(21578,5277,1,1,2,48),-- Recipe: Greater Spiritshot (S) Compressed Package(100%)
(21578,8730,1,1,200,1201),-- Life Stone: level 67
(21578,8740,1,1,200,300),-- Mid-Grade Life Stone: level 67
(21578,8750,1,1,200,30),-- High-Grade Life Stone: level 67
(21578,8760,1,1,200,5),-- Top-Grade Life Stone: level 67
(21579,729,1,1,-1,374),-- Scroll: Enchant Weapon (Grade A)
(21579,1876,1,1,-1,672353),-- Mithril Ore
(21579,4042,1,1,-1,56029),-- Enria
(21579,57,1659,3381,0,700000),-- Adena
(21579,11955,1,1,1,171),-- Common Item - Carnage Bow
(21579,5535,1,1,1,2118),-- Carnage Bow Stave
(21579,1868,1,1,2,248254),-- Thread
(21579,1873,1,1,2,49651),-- Silver Nugget
(21579,1876,1,1,2,24825),-- Mithril Ore
(21579,1895,1,1,2,35465),-- Metallic Fiber
(21579,4042,1,1,2,2069),-- Enria
(21579,5282,1,1,2,55),-- Recipe: Greater Blessed Spiritshot (S) Compressed Package(100%)
(21579,8730,1,1,200,1379),-- Life Stone: level 67
(21579,8740,1,1,200,345),-- Mid-Grade Life Stone: level 67
(21579,8750,1,1,200,34),-- High-Grade Life Stone: level 67
(21579,8760,1,1,200,7),-- Top-Grade Life Stone: level 67
(21580,5466,1,1,-1,1262),-- Recipe: Sword of Miracles(60%)
(21580,5486,1,1,-1,20169),-- Sealed Dark Crystal Robe Fabric
(21580,5489,1,1,-1,44988),-- Sealed Tallum Stockings Fabric
(21580,57,1682,3428,0,700000),-- Adena
(21580,11951,1,1,1,173),-- Common Item - Bloody Orchid
(21580,5536,1,1,1,2141),-- Bloody Orchid Head
(21580,1344,10,30,2,143016),-- Mithril Arrow
(21580,1868,1,1,2,228826),-- Thread
(21580,1873,1,1,2,45765),-- Silver Nugget
(21580,1876,1,1,2,22883),-- Mithril Ore
(21580,1895,1,1,2,32689),-- Metallic Fiber
(21580,4042,1,1,2,1907),-- Enria
(21580,5282,1,1,2,51),-- Recipe: Greater Blessed Spiritshot (S) Compressed Package(100%)
(21580,8730,1,1,200,1271),-- Life Stone: level 67
(21580,8740,1,1,200,318),-- Mid-Grade Life Stone: level 67
(21580,8750,1,1,200,32),-- High-Grade Life Stone: level 67
(21580,8760,1,1,200,6),-- Top-Grade Life Stone: level 67
(21581,730,1,1,-1,3106),-- Scroll: Enchant Armor (Grade A)
(21581,5494,1,1,-1,78289),-- Sealed Dark Crystal Shield Fragment
(21581,6335,1,1,-1,14337),-- Recipe: Sealed Majestic Necklace(70%)
(21581,57,1839,3749,0,700000),-- Adena
(21581,11950,1,1,1,189),-- Common Item - Blood Tornado
(21581,5539,1,1,1,2321),-- Blood Tornado Edge
(21581,1808,1,1,2,61),-- Recipe: Soulshot: S Grade
(21581,1865,1,1,2,137639),-- Varnish
(21581,1870,1,1,2,137639),-- Coal
(21581,1875,1,1,2,9176),-- Stone of Purity
(21581,1879,1,1,2,22940),-- Cokes
(21581,4040,1,1,2,2753),-- Mold Lubricant
(21581,8730,1,1,200,1529),-- Life Stone: level 67
(21581,8740,1,1,200,382),-- Mid-Grade Life Stone: level 67
(21581,8750,1,1,200,38),-- High-Grade Life Stone: level 67
(21581,8760,1,1,200,8),-- Top-Grade Life Stone: level 67
(21582,4041,1,1,-1,32122),-- Mold Hardener
(21582,5220,1,1,-1,147761),-- Metal Hardener
(21582,5496,1,1,-1,86612),-- Sealed Dark Crystal Boots Lining
(21582,57,1823,3716,0,700000),-- Adena
(21582,11955,1,1,1,188),-- Common Item - Carnage Bow
(21582,5535,1,1,1,2327),-- Carnage Bow Stave
(21582,1344,10,30,2,154993),-- Mithril Arrow
(21582,1866,1,1,2,82663),-- Suede
(21582,1871,1,1,2,123995),-- Charcoal
(21582,1885,1,1,2,10333),-- High Grade Suede
(21582,3036,1,1,2,55),-- Recipe: Spiritshot S
(21582,4041,1,1,2,1078),-- Mold Hardener
(21582,5220,1,1,2,4960),-- Metal Hardener
(21582,8730,1,1,200,1378),-- Life Stone: level 67
(21582,8740,1,1,200,345),-- Mid-Grade Life Stone: level 67
(21582,8750,1,1,200,35),-- High-Grade Life Stone: level 67
(21582,8760,1,1,200,7),-- Top-Grade Life Stone: level 67
(21583,1884,1,5,-1,772646),-- Cord
(21583,4039,1,1,-1,125555),-- Mold Glue
(21583,5532,1,1,-1,12702),-- Meteor Shower Head
(21583,57,1857,3793,0,700000),-- Adena
(21583,11946,1,1,1,48),-- Common Item - Dasparion\'s Staff
(21583,11949,1,1,1,48),-- Common Item - Meteor Shower
(21583,8346,1,1,1,586),-- Hammer Piece of Destroyer
(21583,11958,1,1,1,48),-- Common Item - Destroyer Hammer
(21583,8341,1,1,1,585),-- Spiritual Eye Piece
(21583,11953,1,1,1,48),-- Common Item - Spiritual Eye
(21583,5532,1,1,1,586),-- Meteor Shower Head
(21583,5543,1,1,1,592),-- Dasparion\'s Staff Edge
(21583,3036,1,1,2,77),-- Recipe: Spiritshot S
(21583,1344,30,90,2,72435),-- Mithril Arrow
(21583,1864,4,12,2,43461),-- Stem
(21583,1869,1,1,2,173844),-- Iron Ore
(21583,1878,1,1,2,69538),-- Braided Hemp
(21583,1884,1,1,2,106981),-- Cord
(21583,4039,1,1,2,5795),-- Mold Glue
(21583,10305,1,1,1,696),-- Transform Sealbook - Oel Mahum
(21584,1884,1,5,-1,720616),-- Cord
(21584,4039,1,1,-1,117100),-- Mold Glue
(21584,5532,1,1,-1,11847),-- Meteor Shower Head
(21584,57,1732,3537,0,700000),-- Adena
(21584,11946,1,1,1,45),-- Common Item - Dasparion\'s Staff
(21584,11949,1,1,1,45),-- Common Item - Meteor Shower
(21584,8346,1,1,1,547),-- Hammer Piece of Destroyer
(21584,11958,1,1,1,45),-- Common Item - Destroyer Hammer
(21584,8341,1,1,1,546),-- Spiritual Eye Piece
(21584,11953,1,1,1,45),-- Common Item - Spiritual Eye
(21584,5532,1,1,1,547),-- Meteor Shower Head
(21584,5543,1,1,1,552),-- Dasparion\'s Staff Edge
(21584,3036,1,1,2,72),-- Recipe: Spiritshot S
(21584,1344,30,90,2,67557),-- Mithril Arrow
(21584,1864,4,12,2,40535),-- Stem
(21584,1869,1,1,2,162138),-- Iron Ore
(21584,1878,1,1,2,64855),-- Braided Hemp
(21584,1884,1,1,2,99777),-- Cord
(21584,4039,1,1,2,5405),-- Mold Glue
(21584,10305,1,1,1,649),-- Transform Sealbook - Oel Mahum
(21585,730,1,1,-1,2438),-- Scroll: Enchant Armor (Grade A)
(21585,5352,1,1,-1,3785),-- Recipe: Sealed Majestic Robe(60%)
(21585,5536,1,1,-1,9955),-- Bloody Orchid Head
(21585,57,1443,2946,0,700000),-- Adena
(21585,11955,1,1,1,149),-- Common Item - Carnage Bow
(21585,5535,1,1,1,1843),-- Carnage Bow Stave
(21585,1344,10,30,2,122774),-- Mithril Arrow
(21585,1868,1,1,2,196439),-- Thread
(21585,1873,1,1,2,39288),-- Silver Nugget
(21585,1876,1,1,2,19644),-- Mithril Ore
(21585,1895,1,1,2,28063),-- Metallic Fiber
(21585,3036,1,1,2,44),-- Recipe: Spiritshot S
(21585,4042,1,1,2,1637),-- Enria
(21585,8730,1,1,200,1091),-- Life Stone: level 67
(21585,8740,1,1,200,273),-- Mid-Grade Life Stone: level 67
(21585,8750,1,1,200,27),-- High-Grade Life Stone: level 67
(21585,8760,1,1,200,5),-- Top-Grade Life Stone: level 67
(21586,1895,1,3,-1,501916),-- Metallic Fiber
(21586,5462,1,1,-1,1301),-- Recipe: Branch of The Mother Tree(60%)
(21586,5539,1,1,-1,11848),-- Blood Tornado Edge
(21586,57,1733,3538,0,700000),-- Adena
(21586,11951,1,1,1,179),-- Common Item - Bloody Orchid
(21586,5536,1,1,1,2206),-- Bloody Orchid Head
(21586,1868,1,1,2,259451),-- Thread
(21586,1873,1,1,2,51890),-- Silver Nugget
(21586,1876,1,1,2,25945),-- Mithril Ore
(21586,1895,1,1,2,37064),-- Metallic Fiber
(21586,3957,1,1,2,58),-- Recipe: Blessed Spiritshot S
(21586,4042,1,1,2,2162),-- Enria
(21586,8730,1,1,200,1441),-- Life Stone: level 67
(21586,8740,1,1,200,360),-- Mid-Grade Life Stone: level 67
(21586,8750,1,1,200,36),-- High-Grade Life Stone: level 67
(21586,8760,1,1,200,8),-- Top-Grade Life Stone: level 67
(21587,5464,1,1,-1,1363),-- Recipe: Dark Legion\'s Edge(60%)
(21587,5542,1,1,-1,12411),-- Halberd Edge
(21587,5543,1,1,-1,12528),-- Dasparion\'s Staff Edge
(21587,57,1815,3706,0,700000),-- Adena
(21587,11950,1,1,1,187),-- Common Item - Blood Tornado
(21587,5539,1,1,1,2291),-- Blood Tornado Edge
(21587,1344,10,30,2,154424),-- Mithril Arrow
(21587,1865,1,1,2,123538),-- Varnish
(21587,1870,1,1,2,123538),-- Coal
(21587,1875,1,1,2,8236),-- Stone of Purity
(21587,1879,1,1,2,20590),-- Cokes
(21587,4040,1,1,2,2471),-- Mold Lubricant
(21587,5157,1,1,2,55),-- Recipe: Soulshot (S) Compressed Package (100%)
(21587,8730,1,1,200,1372),-- Life Stone: level 67
(21587,8740,1,1,200,343),-- Mid-Grade Life Stone: level 67
(21587,8750,1,1,200,34),-- High-Grade Life Stone: level 67
(21587,8760,1,1,200,7),-- Top-Grade Life Stone: level 67
(21588,729,1,1,-1,337),-- Scroll: Enchant Weapon (Grade A)
(21588,5350,1,1,-1,3928),-- Recipe: Sealed Nightmare Robe(60%)
(21588,5478,1,1,-1,25534),-- Sealed Dark Crystal Leather Armor Pattern
(21588,57,1499,3053,0,700000),-- Adena
(21588,11957,1,1,1,51),-- Common Item - Tallum Blade
(21588,11952,1,1,1,51),-- Common Item - Elemental Sword
(21588,11954,1,1,1,51),-- Common Item - Infernal Master
(21588,8331,1,1,1,637),-- Infernal Master Blade
(21588,5547,1,1,1,636),-- Elemental Sword Edge
(21588,5548,1,1,1,636),-- Tallum Blade Edge
(21588,1344,10,30,2,127403),-- Mithril Arrow
(21588,1868,1,1,2,203845),-- Thread
(21588,1873,1,1,2,40769),-- Silver Nugget
(21588,1876,1,1,2,20385),-- Mithril Ore
(21588,1895,1,1,2,29121),-- Metallic Fiber
(21588,4042,1,1,2,1699),-- Enria
(21588,6901,1,1,2,102),-- Recipe: Shining Arrow (100%)
(21588,8731,1,1,200,944),-- Life Stone: level 70
(21588,8741,1,1,200,236),-- Mid-Grade Life Stone: level 70
(21588,8751,1,1,200,24),-- High-Grade Life Stone: level 70
(21588,8761,1,1,200,5),-- Top-Grade Life Stone: level 70
(21589,729,1,1,-1,346),-- Scroll: Enchant Weapon (Grade A)
(21589,5350,1,1,-1,4030),-- Recipe: Sealed Nightmare Robe(60%)
(21589,5478,1,1,-1,26193),-- Sealed Dark Crystal Leather Armor Pattern
(21589,57,1538,3132,0,700000),-- Adena
(21589,11957,1,1,1,53),-- Common Item - Tallum Blade
(21589,11952,1,1,1,53),-- Common Item - Elemental Sword
(21589,11954,1,1,1,53),-- Common Item - Infernal Master
(21589,8331,1,1,1,654),-- Infernal Master Blade
(21589,5547,1,1,1,652),-- Elemental Sword Edge
(21589,5548,1,1,1,652),-- Tallum Blade Edge
(21589,1344,10,30,2,130695),-- Mithril Arrow
(21589,1868,1,1,2,209112),-- Thread
(21589,1873,1,1,2,41822),-- Silver Nugget
(21589,1876,1,1,2,20911),-- Mithril Ore
(21589,1895,1,1,2,29873),-- Metallic Fiber
(21589,4042,1,1,2,1742),-- Enria
(21589,6901,1,1,2,105),-- Recipe: Shining Arrow (100%)
(21589,8731,1,1,200,968),-- Life Stone: level 70
(21589,8741,1,1,200,242),-- Mid-Grade Life Stone: level 70
(21589,8751,1,1,200,24),-- High-Grade Life Stone: level 70
(21589,8761,1,1,200,5),-- Top-Grade Life Stone: level 70
(21590,5440,1,1,-1,1125),-- Recipe: Elysian(60%)
(21590,5482,1,1,-1,40077),-- Sealed Dark Crystalline Leggings Design
(21590,5485,1,1,-1,25534),-- Sealed Tallum Tunic Texture
(21590,57,1499,3053,0,700000),-- Adena
(21590,11950,1,1,1,154),-- Common Item - Blood Tornado
(21590,5539,1,1,1,1891),-- Blood Tornado Edge
(21590,1344,10,30,2,127403),-- Mithril Arrow
(21590,1864,1,3,2,101923),-- Stem
(21590,1869,1,1,2,101923),-- Iron Ore
(21590,1878,1,1,2,40769),-- Braided Hemp
(21590,1884,1,1,2,62722),-- Cord
(21590,3036,1,1,2,45),-- Recipe: Spiritshot S
(21590,4039,1,1,2,3397),-- Mold Glue
(21590,8731,1,1,200,944),-- Life Stone: level 70
(21590,8741,1,1,200,236),-- Mid-Grade Life Stone: level 70
(21590,8751,1,1,200,24),-- High-Grade Life Stone: level 70
(21590,8761,1,1,200,5),-- Top-Grade Life Stone: level 70
(21591,5440,1,1,-1,1315),-- Recipe: Elysian(60%)
(21591,5482,1,1,-1,46877),-- Sealed Dark Crystalline Leggings Design
(21591,5485,1,1,-1,29866),-- Sealed Tallum Tunic Texture
(21591,57,1754,3571,0,700000),-- Adena
(21591,11950,1,1,1,181),-- Common Item - Blood Tornado
(21591,5539,1,1,1,2211),-- Blood Tornado Edge
(21591,1344,30,90,2,49674),-- Mithril Arrow
(21591,1864,1,3,2,119217),-- Stem
(21591,1869,1,1,2,119217),-- Iron Ore
(21591,1878,1,1,2,47687),-- Braided Hemp
(21591,1884,1,1,2,73365),-- Cord
(21591,3036,1,1,2,53),-- Recipe: Spiritshot S
(21591,4039,1,1,2,3974),-- Mold Glue
(21591,8731,1,1,200,1104),-- Life Stone: level 70
(21591,8741,1,1,200,276),-- Mid-Grade Life Stone: level 70
(21591,8751,1,1,200,28),-- High-Grade Life Stone: level 70
(21591,8761,1,1,200,5),-- Top-Grade Life Stone: level 70
(21592,5440,1,1,-1,969),-- Recipe: Elysian(60%)
(21592,5482,1,1,-1,34520),-- Sealed Dark Crystalline Leggings Design
(21592,5485,1,1,-1,21993),-- Sealed Tallum Tunic Texture
(21592,57,1292,2630,0,700000),-- Adena
(21592,11950,1,1,1,133),-- Common Item - Blood Tornado
(21592,5539,1,1,1,1628),-- Blood Tornado Edge
(21592,1344,10,30,2,109735),-- Mithril Arrow
(21592,1864,1,1,2,175577),-- Stem
(21592,1869,1,1,2,87789),-- Iron Ore
(21592,1878,1,1,2,35115),-- Braided Hemp
(21592,1884,1,1,2,54024),-- Cord
(21592,3036,1,1,2,39),-- Recipe: Spiritshot S
(21592,4039,1,1,2,2926),-- Mold Glue
(21592,8731,1,1,200,813),-- Life Stone: level 70
(21592,8741,1,1,200,203),-- Mid-Grade Life Stone: level 70
(21592,8751,1,1,200,21),-- High-Grade Life Stone: level 70
(21592,8761,1,1,200,4),-- Top-Grade Life Stone: level 70
(21593,729,1,1,-1,465),-- Scroll: Enchant Weapon (Grade A)
(21593,5448,1,1,-1,1551),-- Recipe: Soul Separator(60%)
(21593,5494,1,1,-1,87939),-- Sealed Dark Crystal Shield Fragment
(21593,57,2068,4210,0,700000),-- Adena
(21593,11950,1,1,1,213),-- Common Item - Blood Tornado
(21593,5539,1,1,1,2607),-- Blood Tornado Edge
(21593,1868,1,1,2,309210),-- Thread
(21593,1873,1,1,2,61842),-- Silver Nugget
(21593,1876,1,1,2,30921),-- Mithril Ore
(21593,1895,1,1,2,44173),-- Metallic Fiber
(21593,4042,1,1,2,2577),-- Enria
(21593,5162,1,1,2,68),-- Recipe: Spiritshot (S) Compressed Package (100%)
(21593,8731,1,1,200,1432),-- Life Stone: level 70
(21593,8741,1,1,200,358),-- Mid-Grade Life Stone: level 70
(21593,8751,1,1,200,36),-- High-Grade Life Stone: level 70
(21593,8761,1,1,200,8),-- Top-Grade Life Stone: level 70
(21594,729,1,1,-1,436),-- Scroll: Enchant Weapon (Grade A)
(21594,5448,1,1,-1,1454),-- Recipe: Soul Separator(60%)
(21594,5494,1,1,-1,82446),-- Sealed Dark Crystal Shield Fragment
(21594,57,1939,3947,0,700000),-- Adena
(21594,11950,1,1,1,199),-- Common Item - Blood Tornado
(21594,5539,1,1,1,2444),-- Blood Tornado Edge
(21594,1868,1,1,2,289897),-- Thread
(21594,1873,1,1,2,57979),-- Silver Nugget
(21594,1876,1,1,2,28990),-- Mithril Ore
(21594,1895,1,1,2,41414),-- Metallic Fiber
(21594,4042,1,1,2,2416),-- Enria
(21594,5162,1,1,2,64),-- Recipe: Spiritshot (S) Compressed Package (100%)
(21594,8731,1,1,200,1342),-- Life Stone: level 70
(21594,8741,1,1,200,335),-- Mid-Grade Life Stone: level 70
(21594,8751,1,1,200,33),-- High-Grade Life Stone: level 70
(21594,8761,1,1,200,8),-- Top-Grade Life Stone: level 70
(21595,729,1,1,-1,308),-- Scroll: Enchant Weapon (Grade A)
(21595,5448,1,1,-1,1028),-- Recipe: Soul Separator(60%)
(21595,5494,1,1,-1,58278),-- Sealed Dark Crystal Shield Fragment
(21595,57,1370,2790,0,700000),-- Adena
(21595,11950,1,1,1,141),-- Common Item - Blood Tornado
(21595,5539,1,1,1,1728),-- Blood Tornado Edge
(21595,1868,1,1,2,204917),-- Thread
(21595,1873,1,1,2,40983),-- Silver Nugget
(21595,1876,1,1,2,20492),-- Mithril Ore
(21595,1895,1,1,2,29274),-- Metallic Fiber
(21595,4042,1,1,2,1708),-- Enria
(21595,5162,1,1,2,45),-- Recipe: Spiritshot (S) Compressed Package (100%)
(21595,8731,1,1,200,949),-- Life Stone: level 70
(21595,8741,1,1,200,237),-- Mid-Grade Life Stone: level 70
(21595,8751,1,1,200,24),-- High-Grade Life Stone: level 70
(21595,8761,1,1,200,5),-- Top-Grade Life Stone: level 70
(21596,5535,1,1,-1,17090),-- Carnage Bow Stave
(21596,6337,1,1,-1,25686),-- Recipe: Sealed Majestic Earring(70%)
(21596,6339,1,1,-1,38529),-- Recipe: Sealed Majestic Ring(70%)
(21596,57,1981,4028,0,700000),-- Adena
(21596,11960,1,1,1,204),-- Common Item - Halberd
(21596,5542,1,1,1,2494),-- Halberd Edge
(21596,729,1,1,2,14),-- Scroll: Enchant Weapon (Grade A)
(21596,1343,20,60,2,88067),-- Silver Arrow
(21596,1867,1,1,2,164390),-- Animal Skin
(21596,1872,1,1,2,164390),-- Animal Bone
(21596,1875,1,1,2,8219),-- Stone of Purity
(21596,1881,1,1,2,16439),-- Coarse Bone Powder
(21596,4041,1,1,2,1072),-- Mold Hardener
(21596,5350,1,1,2,160),-- Recipe: Sealed Robe of Nightmare(60%) 
(21596,8730,1,1,200,1370),-- Life Stone: level 67
(21596,8740,1,1,200,342),-- Mid-Grade Life Stone: level 67
(21596,8750,1,1,200,34),-- High-Grade Life Stone: level 67
(21596,8760,1,1,200,7),-- Top-Grade Life Stone: level 67
(21597,4043,1,1,-1,105426),-- Asofe
(21597,4052,1,1,-1,111977),-- Earring of Black Ore Piece
(21597,5550,1,1,-1,42170),-- Durable Metal Plate
(21597,57,1247,2548,0,700000),-- Adena
(21597,11944,1,1,1,153),-- Common Item - Bow of Peril
(21597,4121,1,1,1,2034),-- Bow of Peril Shaft
(21597,1343,10,30,2,121330),-- Silver Arrow
(21597,1864,1,1,2,169861),-- Stem
(21597,1869,1,1,2,84931),-- Iron Ore
(21597,1880,1,1,2,8493),-- Steel
(21597,4043,1,1,2,2831),-- Asofe
(21597,5550,1,1,2,1132),-- Durable Metal Plate
(21597,6335,1,1,2,327),-- Recipe: Sealed Majestic Necklace(70%)
(21597,8730,1,1,200,944),-- Life Stone: level 67
(21597,8740,1,1,200,236),-- Mid-Grade Life Stone: level 67
(21597,8750,1,1,200,23),-- High-Grade Life Stone: level 67
(21597,8760,1,1,200,5),-- Top-Grade Life Stone: level 67
(21598,4053,1,1,-1,151817),-- Ring of Black Ore Gemstone
(21598,5230,1,1,-1,4723),-- Recipe: Mithril Arrow (100%)
(21598,5271,1,1,-1,4723),-- Recipe: Greater Soulshot (A) Compressed Package(100%)
(21598,57,1396,2854,0,700000),-- Adena
(21598,12201,1,1,1,232),-- Common Item - Blue Wolf Tunic
(21598,12192,1,1,1,232),-- Common Item - Tunic of Doom
(21598,12203,1,1,1,372),-- Common Item - Blue Wolf Stockings
(21598,12205,1,1,1,372),-- Common Item - Stockings of Doom
(21598,4084,1,1,1,2273),-- Blue Wolf Tunic Fabric
(21598,4085,1,1,1,2273),-- Tunic of Doom Pattern
(21598,4086,1,1,1,3069),-- Blue Wolf Stockings Pattern
(21598,4087,1,1,1,3069),-- Stockings of Doom Pattern
(21598,1865,1,1,2,104622),-- Varnish
(21598,1870,1,1,2,104622),-- Coal
(21598,1874,1,1,2,6975),-- Oriharukon Ore
(21598,4039,1,1,2,3488),-- Mold Glue
(21598,4043,1,1,2,3488),-- Asofe
(21598,6337,1,1,2,536),-- Recipe: Sealed Majestic Earring(70%)
(21598,8730,1,1,200,1163),-- Life Stone: level 67
(21598,8740,1,1,200,291),-- Mid-Grade Life Stone: level 67
(21598,8750,1,1,200,29),-- High-Grade Life Stone: level 67
(21598,8760,1,1,200,6),-- Top-Grade Life Stone: level 67
(21599,5497,1,1,-1,100352),-- Sealed Tallum Boots Lining
(21599,6337,1,1,-1,21949),-- Recipe: Sealed Majestic Earring(70%)
(21599,6339,1,1,-1,32923),-- Recipe: Sealed Majestic Ring(70%)
(21599,57,2112,4305,0,700000),-- Adena
(21599,11951,1,1,1,218),-- Common Item - Bloody Orchid
(21599,5536,1,1,1,2688),-- Bloody Orchid Head
(21599,1867,1,1,2,210708),-- Animal Skin
(21599,1872,1,1,2,210708),-- Animal Bone
(21599,1882,1,1,2,35118),-- Leather
(21599,1894,1,1,2,5545),-- Crafted Leather
(21599,3957,1,1,2,70),-- Recipe: Blessed Spiritshot S
(21599,4042,1,1,2,2634),-- Enria
(21599,8730,1,1,200,1756),-- Life Stone: level 67
(21599,8740,1,1,200,439),-- Mid-Grade Life Stone: level 67
(21599,8750,1,1,200,44),-- High-Grade Life Stone: level 67
(21599,8760,1,1,200,9),-- Top-Grade Life Stone: level 67
(21600,1884,1,5,-1,714570),-- Cord
(21600,5462,1,1,-1,1290),-- Recipe: Branch of The Mother Tree(60%)
(21600,5509,1,1,-1,81677),-- Sealed Tallum Gloves Design
(21600,57,1378,2803,0,700000),-- Adena
(21600,11957,1,1,1,47),-- Common Item - Tallum Blade
(21600,11952,1,1,1,47),-- Common Item - Elemental Sword
(21600,11954,1,1,1,47),-- Common Item - Infernal Master
(21600,8331,1,1,1,585),-- Infernal Master Blade
(21600,5547,1,1,1,584),-- Elemental Sword Edge
(21600,5548,1,1,1,584),-- Tallum Blade Edge
(21600,729,1,1,2,11),-- Scroll: Enchant Weapon (Grade A)
(21600,1343,10,30,2,133633),-- Silver Arrow
(21600,1864,1,3,2,93544),-- Stem
(21600,1869,1,1,2,93544),-- Iron Ore
(21600,1878,1,1,2,37418),-- Braided Hemp
(21600,1884,1,1,2,57565),-- Cord
(21600,4039,1,1,2,3118),-- Mold Glue
(21600,8730,1,1,200,1039),-- Life Stone: level 67
(21600,8740,1,1,200,260),-- Mid-Grade Life Stone: level 67
(21600,8750,1,1,200,26),-- High-Grade Life Stone: level 67
(21600,8760,1,1,200,5),-- Top-Grade Life Stone: level 67
(21601,5464,1,1,-1,1555),-- Recipe: Dark Legion\'s Edge(60%)
(21601,5520,1,1,-1,27079),-- Sealed Dark Crystal Breastplate Pattern
(21601,5521,1,1,-1,19108),-- Sealed Tallum Plate Armor Pattern
(21601,57,1661,3379,0,700000),-- Adena
(21601,11946,1,1,1,43),-- Common Item - Dasparion\'s Staff
(21601,11949,1,1,1,43),-- Common Item - Meteor Shower
(21601,11958,1,1,1,43),-- Common Item - Destroyer Hammer
(21601,11953,1,1,1,43),-- Common Item - Spiritual Eye
(21601,8346,1,1,1,523),-- Hammer Piece of Destroyer
(21601,8341,1,1,1,522),-- Spiritual Eye Piece
(21601,5532,1,1,1,523),-- Meteor Shower Head
(21601,5543,1,1,1,528),-- Dasparion\'s Staff Edge
(21601,730,1,1,2,103),-- Scroll: Enchant Armor (Grade A)
(21601,1866,1,1,2,82694),-- Suede
(21601,1871,1,1,2,124042),-- Charcoal
(21601,1877,1,1,2,4962),-- Adamantite Nugget
(21601,4040,1,1,2,2481),-- Mold Lubricant
(21601,4041,1,1,2,1079),-- Mold Hardener
(21601,8730,1,1,200,1378),-- Life Stone: level 67
(21601,8740,1,1,200,345),-- Mid-Grade Life Stone: level 67
(21601,8750,1,1,200,35),-- High-Grade Life Stone: level 67
(21601,8760,1,1,200,7),-- Top-Grade Life Stone: level 67
(21602,1825,1,1,-1,105371),-- Recipe: Oriharukon
(21602,1902,1,1,-1,149462),-- Elven Earring Beads
(21602,5231,1,1,-1,105371),-- Recipe: Metal Hardener (100%)
(21602,57,583,1185,0,700000),-- Adena
(21602,61,1,1,1,164),-- Mithril Gloves
(21602,607,1,1,1,164),-- Ogre Power Gauntlets
(21602,1125,1,1,1,164),-- Assault Boots
(21602,1949,1,1,1,6890),-- Mithril Gloves Design
(21602,1957,1,1,1,6890),-- Assault Boots Part
(21602,1963,1,1,1,6890),-- Ogre Power Gauntlets Part
(21602,2427,1,1,1,164),-- Salamander Skin Boots
(21602,2428,1,1,1,164),-- Plate Boots
(21602,2451,1,1,1,164),-- Sage\'s Worn Gloves
(21602,2931,1,1,1,6890),-- Salamander Skin Boot Lining
(21602,2932,1,1,1,6890),-- Plate Boots Design
(21602,2933,1,1,1,6890),-- Sage\'s Worn Gloves Lining
(21602,1865,1,1,2,105825),-- Varnish
(21602,1870,1,1,2,105825),-- Coal
(21602,1875,1,1,2,7055),-- Stone of Purity
(21602,1879,1,1,2,17637),-- Cokes
(21602,2162,1,1,2,5112),-- Recipe: Aquastone Necklace
(21602,2312,1,1,2,462),-- Recipe: Crystallized Ice Bow
(21602,5159,1,1,2,353),-- Recipe: Spiritshot (C) Compressed Package (100%)
(21603,1825,1,1,-1,149211),-- Recipe: Oriharukon
(21603,1902,1,1,-1,211647),-- Elven Earring Beads
(21603,5231,1,1,-1,149211),-- Recipe: Metal Hardener (100%)
(21603,57,826,1678,0,700000),-- Adena
(21603,61,1,1,1,232),-- Mithril Gloves
(21603,607,1,1,1,232),-- Ogre Power Gauntlets
(21603,1125,1,1,1,232),-- Assault Boots
(21603,1949,1,1,1,9756),-- Mithril Gloves Design
(21603,1957,1,1,1,9756),-- Assault Boots Part
(21603,1963,1,1,1,9756),-- Ogre Power Gauntlets Part
(21603,2427,1,1,1,232),-- Salamander Skin Boots
(21603,2428,1,1,1,232),-- Plate Boots
(21603,2451,1,1,1,232),-- Sage\'s Worn Gloves
(21603,2931,1,1,1,9756),-- Salamander Skin Boot Lining
(21603,2932,1,1,1,9756),-- Plate Boots Design
(21603,2933,1,1,1,9757),-- Sage\'s Worn Gloves Lining
(21603,1865,1,1,2,149854),-- Varnish
(21603,1870,1,1,2,149854),-- Coal
(21603,1875,1,1,2,9990),-- Stone of Purity
(21603,1879,1,1,2,24976),-- Cokes
(21603,2162,1,1,2,7239),-- Recipe: Aquastone Necklace
(21603,2312,1,1,2,654),-- Recipe: Crystallized Ice Bow
(21603,5159,1,1,2,500),-- Recipe: Spiritshot (C) Compressed Package (100%)
(21604,1805,1,1,-1,11259),-- Recipe: Soulshot: C-Grade
(21604,1905,1,1,-1,328557),-- Omen Beast\'s Eye Earring Gemstone
(21604,4469,1,1,-1,19300),-- Dye of Strength <Str+1 Con-1>
(21604,57,1337,2712,0,700000),-- Adena
(21604,353,1,1,1,282),-- Half Plate Armor
(21604,380,1,1,1,451),-- Plate Gaiters
(21604,1950,1,1,1,13763),-- Half Plate Temper
(21604,1951,1,1,1,21404),-- Plate Gaiters Part
(21604,1805,1,1,2,1130),-- Recipe: Soulshot: C-Grade
(21604,1867,1,3,2,226141),-- Animal Skin
(21604,1872,1,3,2,150761),-- Animal Bone
(21604,1882,1,1,2,75381),-- Leather
(21604,1894,1,1,2,11902),-- Crafted Leather
(21605,1874,1,1,-1,109271),-- Oriharukon Ore
(21605,1875,1,1,-1,109271),-- Stone of Purity
(21605,1905,1,1,-1,159442),-- Omen Beast\'s Eye Earring Gemstone
(21605,57,645,1322,0,700000),-- Adena
(21605,281,1,1,1,44),-- Crystallized Ice Bow
(21605,2074,1,1,1,2743),-- Crystallized Ice Bow Shaft
(21605,1867,1,1,2,93897),-- Animal Skin
(21605,1872,1,1,2,93897),-- Animal Bone
(21605,1875,1,1,2,4695),-- Stone of Purity
(21605,1881,1,1,2,9390),-- Coarse Bone Powder
(21605,2205,1,1,2,2228),-- Recipe: Chain Gaiters
(21605,2209,1,1,2,5395),-- Recipe: Eldarake
(21605,2299,1,1,2,308),-- Recipe: Big Hammer
(21605,8723,1,1,200,2817),-- Life Stone: level 46
(21605,8733,1,1,200,704),-- Mid-Grade Life Stone: level 46
(21605,8743,1,1,200,70),-- High-Grade Life Stone: level 46
(21605,8753,1,1,200,14),-- Top-Grade Life Stone: level 46
(21606,1874,1,1,-1,154734),-- Oriharukon Ore
(21606,1875,1,1,-1,154734),-- Stone of Purity
(21606,1905,1,1,-1,225779),-- Omen Beast\'s Eye Earring Gemstone
(21606,57,9143,1872,0,700000),-- Adena
(21606,281,1,1,1,62),-- Crystallized Ice Bow
(21606,2074,1,1,1,3885),-- Crystallized Ice Bow Shaft
(21606,1867,1,1,2,132963),-- Animal Skin
(21606,1872,1,1,2,132963),-- Animal Bone
(21606,1875,1,1,2,6648),-- Stone of Purity
(21606,1881,1,1,2,13296),-- Coarse Bone Powder
(21606,2205,1,1,2,3156),-- Recipe: Chain Gaiters
(21606,2209,1,1,2,7498),-- Recipe: Eldarake
(21606,2299,1,1,2,436),-- Recipe: Big Hammer
(21606,8723,1,1,200,3989),-- Life Stone: level 46
(21606,8733,1,1,200,997),-- Mid-Grade Life Stone: level 46
(21606,8743,1,1,200,100),-- High-Grade Life Stone: level 46
(21606,8753,1,1,200,20),-- Top-Grade Life Stone: level 46
(21607,1908,1,1,-1,343437),-- Moonstone Earring Wire
(21607,1909,1,1,-1,489763),-- Aquastone Ring Wire
(21607,2163,1,1,-1,185036),-- Recipe: Earring of Protection
(21607,57,1428,2926,0,700000),-- Adena
(21607,354,1,1,1,221),-- Chain Mail Shirt
(21607,381,1,1,1,353),-- Chain Gaiters
(21607,1959,1,1,1,11542),-- Chain Mail Shirt Material
(21607,1960,1,1,1,23479),-- Chain Gaiters Part
(21607,1875,1,1,2,11427),-- Stone of Purity
(21607,1879,1,1,2,28567),-- Cokes
(21607,1885,1,1,2,14284),-- High Grade Suede
(21607,2163,1,1,2,8745),-- Recipe: Earring of Protection
(21607,5549,1,1,2,17140),-- Metallic Thread
(21607,5550,1,1,2,2285),-- Durable Metal Plate
(21607,8723,1,1,200,6856),-- Life Stone: level 46
(21607,8733,1,1,200,1714),-- Mid-Grade Life Stone: level 46
(21607,8743,1,1,200,171),-- High-Grade Life Stone: level 46
(21607,8753,1,1,200,34),-- Top-Grade Life Stone: level 46
(21608,1871,1,3,-1,672407),-- Charcoal
(21608,1879,1,1,-1,224136),-- Cokes
(21608,1906,1,1,-1,184854),-- Mithril Ring Wire
(21608,57,532,1080,0,700000),-- Adena
(21608,439,1,1,1,109),-- Karmian Tunic
(21608,471,1,1,1,175),-- Karmian Stockings
(21608,1954,1,1,1,8448),-- Karmian Stocking Design
(21608,1962,1,1,1,5085),-- Karmian Tunic Pattern
(21608,1865,1,1,2,45399),-- Varnish
(21608,1870,1,1,2,45399),-- Coal
(21608,1875,1,1,2,3027),-- Stone of Purity
(21608,1879,1,1,2,7566),-- Cokes
(21608,2303,1,1,2,198),-- Recipe: Skull Graver
(21608,2990,1,1,2,2910),-- Recipe: Chain Boots
(21608,3000,1,1,2,2910),-- Recipe: Dwarven Chain Shield
(21608,3033,1,1,2,151),-- Recipe: Spiritshot C
(21608,3954,1,1,2,151),-- Recipe: Blessed Spiritshot C
(21608,4040,1,1,2,908),-- Mold Lubricant
(21608,8723,1,1,200,1816),-- Life Stone: level 46
(21608,8733,1,1,200,454),-- Mid-Grade Life Stone: level 46
(21608,8743,1,1,200,45),-- High-Grade Life Stone: level 46
(21608,8753,1,1,200,9),-- Top-Grade Life Stone: level 46
(21609,1871,1,5,-1,634776),-- Charcoal
(21609,1879,1,1,-1,317388),-- Cokes
(21609,1906,1,1,-1,261763),-- Mithril Ring Wire
(21609,57,753,1530,0,700000),-- Adena
(21609,439,1,1,1,155),-- Karmian Tunic
(21609,471,1,1,1,247),-- Karmian Stockings
(21609,1954,1,1,1,11963),-- Karmian Stocking Design
(21609,1962,1,1,1,7201),-- Karmian Tunic Pattern
(21609,1865,1,1,2,64287),-- Varnish
(21609,1870,1,1,2,64287),-- Coal
(21609,1875,1,1,2,4286),-- Stone of Purity
(21609,1879,1,1,2,10714),-- Cokes
(21609,2303,1,1,2,281),-- Recipe: Skull Graver
(21609,2990,1,1,2,5102),-- Recipe: Chain Boots
(21609,3000,1,1,2,4121),-- Recipe: Dwarven Chain Shield
(21609,3033,1,1,2,214),-- Recipe: Spiritshot C
(21609,3954,1,1,2,214),-- Recipe: Blessed Spiritshot C
(21609,4040,1,1,2,1286), -- Mold Lubricant
(21609,8723,1,1,200,2572),-- Life Stone: level 46
(21609,8733,1,1,200,643),-- Mid-Grade Life Stone: level 46
(21609,8743,1,1,200,64),-- High-Grade Life Stone: level 46
(21609,8753,1,1,200,12);-- Top-Grade Life Stone: level 46

INSERT INTO `droplist` VALUES 
(21610,1869,1,7,-1,868979),-- Iron Ore
(21610,2163,1,1,-1,177343),-- Recipe: Earring of Protection
(21610,4043,1,1,-1,115864),-- Asofe
(21610,57,1375,2793,0,700000),-- Adena
(21610,397,1,1,1,282),-- Mithril Shirt
(21610,1961,1,1,1,13143),-- Mithril Shirt Fabric
(21610,2387,1,1,1,452),-- Tempered Mithril Gaiters
(21610,2935,1,1,1,21835),-- Tempered Mithril Gaiters Fragment
(21610,1864,1,3,2,164277),-- Stem
(21610,1869,1,1,2,164277),-- Iron Ore
(21610,1880,1,1,2,16428),-- Steel
(21610,2164,1,1,2,12637),-- Recipe: Ring of Protection
(21610,4043,1,1,2,5476),-- Asofe
(21610,5550,1,1,2,2190),-- Durable Metal Plate
(21610,8723,1,1,200,6571),-- Life Stone: level 46
(21610,8733,1,1,200,1643),-- Mid-Grade Life Stone: level 46
(21610,8743,1,1,200,164),-- High-Grade Life Stone: level 46
(21610,8753,1,1,200,33),-- Top-Grade Life Stone: level 46
(21611,1908,1,1,-1,147842),-- Moonstone Earring Wire
(21611,2066,1,1,-1,12245),-- Heavy Doom Hammer Head
(21611,2320,1,1,-1,5440),-- Recipe: Cursed Staff
(21611,57,615,1258,0,700000),-- Adena
(21611,631,1,1,1,241),-- Eldarake
(21611,1964,1,1,1,9937),-- Eldarake Temper
(21611,2413,1,1,1,169),-- Chain Hood
(21611,2495,1,1,1,241),-- Chain Shield
(21611,2936,1,1,1,9025),-- Chain Hood Pattern
(21611,2945,1,1,1,9937),-- Chain Shield Fragment
(21611,1867,1,1,2,81984),-- Animal Skin
(21611,1872,1,1,2,81984),-- Animal Bone
(21611,1882,1,1,2,13664),-- Leather
(21611,1894,1,1,2,2157),-- Crafted Leather
(21611,2230,1,1,2,1192),-- Recipe: Theca Leather Gaiters
(21611,2326,1,1,2,214),-- Recipe: Horn of Glory
(21611,4042,1,1,2,10256),-- Enria
(21611,6668,1,1,2,21960),-- Deluxe Chest Key - Grade 4
(21611,8723,1,1,200,2460),-- Life Stone: level 46
(21611,8733,1,1,200,615),-- Mid-Grade Life Stone: level 46
(21611,8743,1,1,200,62),-- High-Grade Life Stone: level 46
(21611,8753,1,1,200,12),-- Top-Grade Life Stone: level 46
(21612,1908,1,1,-1,209352),-- Moonstone Earring Wire
(21612,2066,1,1,-1,17339),-- Heavy Doom Hammer Head
(21612,2320,1,1,-1,7703),-- Recipe: Cursed Staff
(21612,57,871,1781,0,700000),-- Adena
(21612,631,1,1,1,341),-- Eldarake
(21612,1964,1,1,1,14071),-- Eldarake Temper
(21612,2413,1,1,1,239),-- Chain Hood
(21612,2495,1,1,1,341),-- Chain Shield
(21612,2936,1,1,1,12780),-- Chain Hood Pattern
(21612,2945,1,1,1,14071),-- Chain Shield Fragment
(21612,1867,1,1,2,116093),-- Animal Skin
(21612,1872,1,1,2,116093),-- Animal Bone
(21612,1882,1,1,2,19349),-- Leather
(21612,1894,1,1,2,3055),-- Crafted Leather
(21612,2230,1,1,2,1688),-- Recipe: Theca Leather Gaiters
(21612,2326,1,1,2,303),-- Recipe: Horn of Glory
(21612,4042,1,1,2,1451),-- Enria
(21612,6668,1,1,2,31096),-- Deluxe Chest Key - Grade 4
(21612,8723,1,1,200,3483),-- Life Stone: level 46
(21612,8733,1,1,200,871),-- Mid-Grade Life Stone: level 46
(21612,8743,1,1,200,87),-- High-Grade Life Stone: level 46
(21612,8753,1,1,200,17),-- Top-Grade Life Stone: level 46
(21