/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver;

import com.l2jserver.Config;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.L2GameServerPacket;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import java.util.logging.Logger;
import javolution.util.FastList;
import javolution.util.FastMap;

public class GmListTable {
    private static Logger _log = Logger.getLogger(GmListTable.class.getName());
    private FastMap<L2PcInstance, Boolean> _gmList = new FastMap().shared();

    public static GmListTable getInstance() {
        return SingletonHolder._instance;
    }

    public FastList<L2PcInstance> getAllGms(boolean includeHidden) {
        FastList tmpGmList = new FastList();
        FastMap.Entry n = this._gmList.head();
        FastMap.Entry end = this._gmList.tail();
        while ((n = n.getNext()) != end) {
            if (!includeHidden && ((Boolean)n.getValue()).booleanValue()) continue;
            tmpGmList.add(n.getKey());
        }
        return tmpGmList;
    }

    public FastList<String> getAllGmNames(boolean includeHidden) {
        FastList tmpGmList = new FastList();
        FastMap.Entry n = this._gmList.head();
        FastMap.Entry end = this._gmList.tail();
        while ((n = n.getNext()) != end) {
            if (!((Boolean)n.getValue()).booleanValue()) {
                tmpGmList.add((Object)((L2PcInstance)n.getKey()).getName());
                continue;
            }
            if (!includeHidden) continue;
            tmpGmList.add((Object)(((L2PcInstance)n.getKey()).getName() + " (invis)"));
        }
        return tmpGmList;
    }

    private GmListTable() {
    }

    public void addGm(L2PcInstance player, boolean hidden) {
        if (Config.DEBUG) {
            _log.fine("added gm: " + player.getName());
        }
        this._gmList.put((Object)player, (Object)hidden);
    }

    public void deleteGm(L2PcInstance player) {
        if (Config.DEBUG) {
            _log.fine("deleted gm: " + player.getName());
        }
        this._gmList.remove((Object)player);
    }

    public void showGm(L2PcInstance player) {
        FastMap.Entry gm = this._gmList.getEntry((Object)player);
        if (gm != null) {
            gm.setValue((Object)false);
        }
    }

    public void hideGm(L2PcInstance player) {
        FastMap.Entry gm = this._gmList.getEntry((Object)player);
        if (gm != null) {
            gm.setValue((Object)true);
        }
    }

    public boolean isGmOnline(boolean includeHidden) {
        FastMap.Entry n = this._gmList.head();
        FastMap.Entry end = this._gmList.tail();
        while ((n = n.getNext()) != end) {
            if (!includeHidden && ((Boolean)n.getValue()).booleanValue()) continue;
            return true;
        }
        return false;
    }

    public void sendListToPlayer(L2PcInstance player) {
        if (this.isGmOnline(player.isGM())) {
            player.sendPacket(new SystemMessage(SystemMessageId.GM_LIST));
            for (String name : this.getAllGmNames(player.isGM())) {
                SystemMessage sm = new SystemMessage(SystemMessageId.GM_C1);
                sm.addString(name);
                player.sendPacket(sm);
            }
        } else {
            player.sendPacket(new SystemMessage(SystemMessageId.NO_GM_PROVIDING_SERVICE_NOW));
        }
    }

    public static void broadcastToGMs(L2GameServerPacket packet) {
        for (L2PcInstance gm : GmListTable.getInstance().getAllGms(true)) {
            gm.sendPacket(packet);
        }
    }

    public static void broadcastMessageToGMs(String message) {
        for (L2PcInstance gm : GmListTable.getInstance().getAllGms(true)) {
            gm.sendMessage(message);
        }
    }

    private static class SingletonHolder {
        protected static final GmListTable _instance = new GmListTable();

        private SingletonHolder() {
        }
    }
}

