/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.cache;

import com.l2jserver.Config;
import com.l2jserver.gameserver.GameTimeController;
import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.util.Util;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javolution.util.FastMap;

public class HtmCache {
    static Logger _log = Logger.getLogger(HtmCache.class.getName());
    private static HtmFilter filter = HtmCache.getInstance().new HtmFilter();
    static final boolean TIMED_CACHE = true;
    private static final int EXPIRE_TIME = 60;
    FastMap<Integer, TimedCache> _timedCache = new FastMap().shared();
    private FastMap<Integer, String> _cache;
    int _loadedFiles;
    long _bytesBuffLen;

    public static HtmCache getInstance() {
        return SingletonHolder._instance;
    }

    private HtmCache() {
        ThreadPoolManager.getInstance().scheduleAiAtFixedRate(new CacheScheduler(), 3600000L, 3600000L);
        this.reload();
    }

    public void reload() {
        this.reload(Config.DATAPACK_ROOT);
    }

    private void reload(File f) {
        if (this.getLoadedFiles() > 0) {
            _log.info("Cache[HTML]: " + String.format("%.3f", this.getMemoryUsage()) + " megabytes on " + this.getLoadedFiles() + " files loaded");
        }
        this._timedCache.clear();
        this._loadedFiles = 0;
        this._bytesBuffLen = 0L;
        _log.info("Cache[HTML]: Running timed cache");
    }

    public void reloadPath(File f) {
        this.parseDir(f);
        _log.info("Cache[HTML]: Reloaded specified path.");
    }

    public double getMemoryUsage() {
        return (float)this._bytesBuffLen / 1048576.0f;
    }

    public int getLoadedFiles() {
        return this._loadedFiles;
    }

    private void parseDir(File dir) {
        File[] files;
        for (File file : files = dir.listFiles(filter)) {
            if (!file.isDirectory()) {
                this.loadFile(file);
                continue;
            }
            this.parseDir(file);
        }
    }

    public String loadFile(File file) {
        return this.loadFile(file, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String loadFile(File file, boolean checked) {
        String relpath = Util.getRelativePath(Config.DATAPACK_ROOT, file);
        int hashcode = relpath.hashCode();
        if (file.exists() && filter.accept(file) && !file.isDirectory()) {
            FileInputStream fis = null;
            try {
                String oldContent;
                fis = new FileInputStream(file);
                byte[] raw = new byte[fis.available()];
                fis.read(raw);
                String content = new String(raw, "UTF-8");
                content = content.replaceAll("[\ufeff\r\n]", "");
                String string = oldContent = checked ? null : this._cache_get(hashcode);
                if (oldContent == null) {
                    this._bytesBuffLen += (long)(content.length() * 2);
                    ++this._loadedFiles;
                } else {
                    this._bytesBuffLen = this._bytesBuffLen - (long)(oldContent.length() * 2) + (long)(content.length() * 2);
                }
                this._cache_put(hashcode, content);
                String string2 = content;
                return string2;
            }
            catch (Exception e) {
                _log.log(Level.WARNING, "Problem with htm file " + e.getMessage(), e);
                e.printStackTrace();
            }
            finally {
                try {
                    fis.close();
                }
                catch (Exception e1) {}
            }
        }
        return null;
    }

    public String getHtmForce(String prefix, String path) {
        String content = this.getHtm(prefix, path);
        if (content == null) {
            content = "<html><body>My text is missing:<br>" + path + "</body></html>";
            _log.warning("Cache[HTML]: Missing HTML page: " + path);
        }
        return content;
    }

    public String getHtm(String prefix, String path) {
        if (prefix != null && !prefix.isEmpty()) {
            String newPath = prefix + path;
            String content = this.getHtm(newPath);
            if (content != null) {
                return content;
            }
            content = this.getHtm(path);
            if (content != null) {
                this._cache_put(newPath.hashCode(), content);
            }
            return content;
        }
        return this.getHtm(path);
    }

    private String getHtm(String path) {
        if (path == null || path.isEmpty()) {
            return "";
        }
        int hashCode = path.hashCode();
        String content = this._cache_get(hashCode);
        if (content == null) {
            content = this.loadFile(new File(Config.DATAPACK_ROOT, path), true);
        }
        return content;
    }

    private String _cache_get(int hashcode) {
        TimedCache item = (TimedCache)this._timedCache.get((Object)hashcode);
        if (item == null) {
            return null;
        }
        item.lastAccessTime = GameTimeController.getInstance().getGameTime();
        return item.content;
    }

    private void _cache_put(int hashcode, String content) {
        TimedCache item = new TimedCache();
        item.lastAccessTime = GameTimeController.getInstance().getGameTime();
        item.content = content;
        this._timedCache.put((Object)hashcode, (Object)item);
    }

    private static class SingletonHolder {
        protected static final HtmCache _instance = new HtmCache();

        private SingletonHolder() {
        }
    }

    class CacheScheduler
    implements Runnable {
        CacheScheduler() {
        }

        @Override
        public void run() {
            boolean update = false;
            int cTime = GameTimeController.getInstance().getGameTime();
            for (Map.Entry e : HtmCache.this._timedCache.entrySet()) {
                Integer hashcode = (Integer)e.getKey();
                TimedCache item = (TimedCache)e.getValue();
                if ((long)cTime - item.lastAccessTime <= 60L) continue;
                --HtmCache.this._loadedFiles;
                HtmCache.this._bytesBuffLen -= (long)(item.content.length() * 2);
                HtmCache.this._timedCache.remove((Object)hashcode);
                update = true;
            }
            if (update) {
                _log.info("Cache[HTML]: " + String.format("%.3f", HtmCache.this.getMemoryUsage()) + " megabytes on " + HtmCache.this.getLoadedFiles() + " files loaded");
            }
        }
    }

    class TimedCache {
        long lastAccessTime;
        String content;

        TimedCache() {
        }
    }

    class HtmFilter
    implements FileFilter {
        HtmFilter() {
        }

        @Override
        public boolean accept(File file) {
            if (!file.isDirectory()) {
                return file.getName().endsWith(".htm") || file.getName().endsWith(".html");
            }
            return true;
        }
    }
}

