/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.handler;

import com.l2jserver.gameserver.handler.IActionHandler;
import com.l2jserver.gameserver.model.L2Object;
import java.util.Map;
import javolution.util.FastMap;

public class ActionHandler {
    private Map<L2Object.InstanceType, IActionHandler> _actions = new FastMap();
    private Map<L2Object.InstanceType, IActionHandler> _actionsShift = new FastMap();

    public static ActionHandler getInstance() {
        return SingletonHolder._instance;
    }

    private ActionHandler() {
    }

    public void registerActionHandler(IActionHandler handler) {
        this._actions.put(handler.getInstanceType(), handler);
    }

    public void registerActionShiftHandler(IActionHandler handler) {
        this._actionsShift.put(handler.getInstanceType(), handler);
    }

    public IActionHandler getActionHandler(L2Object.InstanceType iType) {
        IActionHandler result = null;
        for (L2Object.InstanceType t = iType; t != null && (result = this._actions.get((Object)t)) == null; t = t.getParent()) {
        }
        return result;
    }

    public IActionHandler getActionShiftHandler(L2Object.InstanceType iType) {
        IActionHandler result = null;
        for (L2Object.InstanceType t = iType; t != null && (result = this._actionsShift.get((Object)t)) == null; t = t.getParent()) {
        }
        return result;
    }

    public int size() {
        return this._actions.size();
    }

    public int sizeShift() {
        return this._actionsShift.size();
    }

    private static class SingletonHolder {
        protected static final ActionHandler _instance = new ActionHandler();

        private SingletonHolder() {
        }
    }
}

