/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.instancemanager.grandbosses;

import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.datatables.NpcTable;
import com.l2jserver.gameserver.model.L2Spawn;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.entity.BossEntity;
import com.l2jserver.gameserver.model.entity.GrandBossState;

public abstract class BossLair
extends BossEntity {
    protected GrandBossState _state;

    public abstract void init();

    public abstract void setUnspawn();

    public int getState() {
        return this._state.getState();
    }

    public boolean isEnableEnterToLair() {
        return this._state.getState() == 0;
    }

    public synchronized boolean isPlayersAnnihilated() {
        return this.getZone().isPlayersAnnihilated();
    }

    @Override
    public void checkAnnihilated() {
        if (this.isPlayersAnnihilated()) {
            ThreadPoolManager.getInstance().scheduleGeneral(new Runnable(){

                @Override
                public void run() {
                    BossLair.this.setUnspawn();
                }
            }, 10000L);
        }
    }

    public L2Npc addSpawn(int npcId, int x, int y, int z, int heading) {
        L2Npc result = null;
        try {
            L2Spawn spawn = new L2Spawn(NpcTable.getInstance().getTemplate(npcId));
            spawn.setHeading(heading);
            spawn.setLocx(x);
            spawn.setLocy(y);
            spawn.setLocz(z);
            spawn.stopRespawn();
            result = spawn.doSpawn();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }
}

