/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.instancemanager.grandbosses;

import com.l2jserver.Config;
import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.ai.CtrlIntention;
import com.l2jserver.gameserver.datatables.NpcTable;
import com.l2jserver.gameserver.instancemanager.grandbosses.BossLair;
import com.l2jserver.gameserver.model.L2CharPosition;
import com.l2jserver.gameserver.model.L2Party;
import com.l2jserver.gameserver.model.L2Spawn;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.entity.BossEntity;
import com.l2jserver.gameserver.model.entity.GrandBossState;
import com.l2jserver.gameserver.network.serverpackets.SocialAction;
import com.l2jserver.gameserver.templates.chars.L2NpcTemplate;
import com.l2jserver.gameserver.util.Util;
import com.l2jserver.util.Rnd;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ScheduledFuture;
import javolution.util.FastList;

public class SailrenManager
extends BossLair {
    private static final int VELOCIRAPTOR = 22218;
    private static final int PTEROSAUR = 22199;
    private static final int TYRANNOSAURUS = 22217;
    private static final int SAILREN = 29065;
    private static final int _bossId = 29065;
    private final int[][] _sailrenCubeLocation = new int[][]{{27734, -6838, -1982, 0}};
    protected List<L2Spawn> _sailrenCubeSpawn = new FastList();
    protected List<L2Npc> _sailrenCube = new FastList();
    protected L2Spawn _velociraptorSpawn;
    protected L2Spawn _pterosaurSpawn;
    protected L2Spawn _tyrannoSpawn;
    protected L2Spawn _sailrenSapwn;
    protected L2Npc _velociraptor;
    protected L2Npc _pterosaur;
    protected L2Npc _tyranno;
    protected L2Npc _sailren;
    protected ScheduledFuture<?> _cubeSpawnTask = null;
    protected ScheduledFuture<?> _sailrenSpawnTask = null;
    protected ScheduledFuture<?> _intervalEndTask = null;
    protected ScheduledFuture<?> _activityTimeEndTask = null;
    protected ScheduledFuture<?> _onPartyAnnihilatedTask = null;
    protected ScheduledFuture<?> _socialTask = null;
    protected boolean _isAlreadyEnteredOtherParty = false;

    public static SailrenManager getInstance() {
        return SingletonHolder.INSTANCE;
    }

    private SailrenManager() {
        this._state = new GrandBossState(29065);
        if (this.registerZone(27734, -6938, -1982) == null) {
            _log.warning("SailrenManager : Failed to load zone 'Lair of Sailren'");
        }
    }

    @Override
    public void init() {
        this._isAlreadyEnteredOtherParty = false;
        try {
            L2NpcTemplate template1 = NpcTable.getInstance().getTemplate(22218);
            this._velociraptorSpawn = new L2Spawn(template1);
            this._velociraptorSpawn.setLocx(27852);
            this._velociraptorSpawn.setLocy(-5536);
            this._velociraptorSpawn.setLocz(-1983);
            this._velociraptorSpawn.setHeading(44732);
            this._velociraptorSpawn.setAmount(1);
            this._velociraptorSpawn.stopRespawn();
            template1 = NpcTable.getInstance().getTemplate(22199);
            this._pterosaurSpawn = new L2Spawn(template1);
            this._pterosaurSpawn.setLocx(27852);
            this._pterosaurSpawn.setLocy(-5536);
            this._pterosaurSpawn.setLocz(-1983);
            this._pterosaurSpawn.setHeading(44732);
            this._pterosaurSpawn.setAmount(1);
            this._pterosaurSpawn.stopRespawn();
            template1 = NpcTable.getInstance().getTemplate(22217);
            this._tyrannoSpawn = new L2Spawn(template1);
            this._tyrannoSpawn.setLocx(27852);
            this._tyrannoSpawn.setLocy(-5536);
            this._tyrannoSpawn.setLocz(-1983);
            this._tyrannoSpawn.setHeading(44732);
            this._tyrannoSpawn.setAmount(1);
            this._tyrannoSpawn.stopRespawn();
            template1 = NpcTable.getInstance().getTemplate(29065);
            this._sailrenSapwn = new L2Spawn(template1);
            this._sailrenSapwn.setLocx(27810);
            this._sailrenSapwn.setLocy(-5655);
            this._sailrenSapwn.setLocz(-1983);
            this._sailrenSapwn.setHeading(44732);
            this._sailrenSapwn.setAmount(1);
            this._sailrenSapwn.stopRespawn();
        }
        catch (Exception e) {
            _log.warning(e.getMessage());
        }
        try {
            L2NpcTemplate cube = NpcTable.getInstance().getTemplate(32107);
            for (int[] element : this._sailrenCubeLocation) {
                L2Spawn spawnDat = new L2Spawn(cube);
                spawnDat.setAmount(1);
                spawnDat.setLocx(element[0]);
                spawnDat.setLocy(element[1]);
                spawnDat.setLocz(element[2]);
                spawnDat.setHeading(element[3]);
                spawnDat.stopRespawn();
                spawnDat.setLocation(0);
                this._sailrenCubeSpawn.add(spawnDat);
            }
        }
        catch (Exception e) {
            _log.warning(e.getMessage());
        }
        _log.info("SailrenManager : State of Sailren is " + this._state.getStateName() + ".");
        if (this._state.getState() != 0) {
            this.setIntervalEndTask();
        }
        _log.info("SailrenManager : Next spawn date of Sailren is " + this._state.respawnTimeFormat() + ".");
        _log.info("SailrenManager : Init SailrenManager.");
    }

    public int canIntoSailrenLair(L2PcInstance pc) {
        if (!Config.FWS_ENABLESINGLEPLAYER && pc.getParty() == null) {
            return -4;
        }
        int alive = this._state.getState();
        if (alive == 1 || alive == 2 || alive == 3) {
            return alive;
        }
        if (this._isAlreadyEnteredOtherParty) {
            return 1;
        }
        return alive;
    }

    public void setSailrenSpawnTask(int npcId) {
        if (npcId == 22218 && this.getPlayersInside().size() != 0) {
            return;
        }
        if (this._sailrenSpawnTask == null) {
            this._sailrenSpawnTask = ThreadPoolManager.getInstance().scheduleGeneral(new SailrenSpawn(npcId), Config.FWS_INTERVALOFNEXTMONSTER);
        }
    }

    public void entryToSailrenLair(L2PcInstance pc) {
        if (this.canIntoSailrenLair(pc) != 0) {
            pc.sendMessage("\u6761\u4ef6\u3092\u6e80\u305f\u3057\u3066\u3044\u306a\u3044\u305f\u3081\u3001\u5165\u5834\u304c\u62d2\u5426\u3055\u308c\u307e\u3057\u305f\u3002");
            this._isAlreadyEnteredOtherParty = false;
            return;
        }
        for (L2PcInstance mem : this.getPartyMembers(pc)) {
            if (mem.isDead() || !Util.checkIfInRange(700, pc, mem, true)) continue;
            int driftx = Rnd.get(-80, 80);
            int drifty = Rnd.get(-80, 80);
            this.getZone().allowPlayerEntry(mem, 30);
            mem.teleToLocation(27734 + driftx, -6938 + drifty, -1982);
        }
        this._isAlreadyEnteredOtherParty = true;
    }

    @Override
    public void banishForeigners() {
        super.banishForeigners();
        this._isAlreadyEnteredOtherParty = false;
    }

    @Override
    public void setUnspawn() {
        this.banishForeigners();
        for (L2Npc cube : this._sailrenCube) {
            cube.deleteMe();
        }
        this._sailrenCube.clear();
        if (this._cubeSpawnTask != null) {
            this._cubeSpawnTask.cancel(true);
            this._cubeSpawnTask = null;
        }
        if (this._sailrenSpawnTask != null) {
            this._sailrenSpawnTask.cancel(true);
            this._sailrenSpawnTask = null;
        }
        if (this._intervalEndTask != null) {
            this._intervalEndTask.cancel(true);
            this._intervalEndTask = null;
        }
        if (this._activityTimeEndTask != null) {
            this._activityTimeEndTask.cancel(true);
            this._activityTimeEndTask = null;
        }
        if (this._velociraptor != null) {
            this._velociraptor.deleteMe();
            this._velociraptor = null;
        }
        if (this._pterosaur != null) {
            this._pterosaur.deleteMe();
            this._pterosaur = null;
        }
        if (this._tyranno != null) {
            this._tyranno.deleteMe();
            this._tyranno = null;
        }
        if (this._sailren != null) {
            this._sailren.deleteMe();
            this._sailren = null;
        }
        this.setIntervalEndTask();
    }

    public void spawnCube() {
        for (L2Spawn spawnDat : this._sailrenCubeSpawn) {
            this._sailrenCube.add(spawnDat.doSpawn());
        }
    }

    public void setCubeSpawn() {
        this._state.setState(2);
        this._state.update();
        this._cubeSpawnTask = ThreadPoolManager.getInstance().scheduleGeneral(new CubeSpawn(), 10000L);
        if (this._activityTimeEndTask != null) {
            this._activityTimeEndTask.cancel(false);
        }
        this._activityTimeEndTask = ThreadPoolManager.getInstance().scheduleGeneral(new ActivityTimeEnd(this._sailren), 900000L);
    }

    public void setIntervalEndTask() {
        if (this._state.getState() != 3) {
            this._state.setRespawnDate(Config.FWS_FIXINTERVALOFSAILRENSPAWN + Rnd.get(Config.FWS_RANDOMINTERVALOFSAILRENSPAWN));
            this._state.setState(3);
            this._state.update();
        }
        this._intervalEndTask = ThreadPoolManager.getInstance().scheduleGeneral(new IntervalEnd(), this._state.getInterval());
        _log.info("SailrenManager : Interval START.");
        _log.info("SailrenManager : Next spawn date of Sailren is " + this._state.respawnTimeFormat() + ".");
    }

    List<L2PcInstance> getPartyMembers(L2PcInstance player) {
        L2Party party = player.getParty();
        if (party != null) {
            return party.getPartyMembers();
        }
        ArrayList<L2PcInstance> m = new ArrayList<L2PcInstance>(1);
        m.add(player);
        return m;
    }

    private class Social
    implements Runnable {
        private final int _action;
        private final L2Npc _npc;

        public Social(L2Npc npc, int actionId) {
            this._npc = npc;
            this._action = actionId;
        }

        @Override
        public void run() {
            SailrenManager.this.getZone().updateKnownList(this._npc);
            SocialAction sa = new SocialAction(this._npc.getObjectId(), this._action);
            this._npc.broadcastPacket(sa);
        }
    }

    class IntervalEnd
    implements Runnable {
        IntervalEnd() {
        }

        @Override
        public void run() {
            SailrenManager.this._state.setState(0);
            SailrenManager.this._state.update();
            BossEntity._log.info("SailrenManager : Interval END.");
        }
    }

    private class ActivityTimeEnd
    implements Runnable {
        public ActivityTimeEnd(L2Npc npc) {
        }

        @Override
        public void run() {
            SailrenManager.this.setUnspawn();
        }
    }

    class CubeSpawn
    implements Runnable {
        CubeSpawn() {
        }

        @Override
        public void run() {
            SailrenManager.this.spawnCube();
        }
    }

    private class SailrenSpawn
    implements Runnable {
        private final int _npcId;
        private final L2CharPosition _pos = new L2CharPosition(27628, -6109, -1982, 44732);

        public SailrenSpawn(int npcId) {
            this._npcId = npcId;
        }

        @Override
        public void run() {
            switch (this._npcId) {
                case 22218: {
                    SailrenManager.this._velociraptor = SailrenManager.this._velociraptorSpawn.doSpawn();
                    SailrenManager.this._velociraptor.setIsRaid(true);
                    SailrenManager.this._velociraptor.getAI().setIntention(CtrlIntention.AI_INTENTION_MOVE_TO, this._pos);
                    if (SailrenManager.this._socialTask != null) {
                        SailrenManager.this._socialTask.cancel(true);
                        SailrenManager.this._socialTask = null;
                    }
                    SailrenManager.this._socialTask = ThreadPoolManager.getInstance().scheduleGeneral(new Social(SailrenManager.this._velociraptor, 2), 6000L);
                    if (SailrenManager.this._activityTimeEndTask != null) {
                        SailrenManager.this._activityTimeEndTask.cancel(true);
                        SailrenManager.this._activityTimeEndTask = null;
                    }
                    SailrenManager.this._activityTimeEndTask = ThreadPoolManager.getInstance().scheduleGeneral(new ActivityTimeEnd(SailrenManager.this._velociraptor), Config.FWS_ACTIVITYTIMEOFMOBS);
                    break;
                }
                case 22199: {
                    SailrenManager.this._pterosaur = SailrenManager.this._pterosaurSpawn.doSpawn();
                    SailrenManager.this._pterosaur.getAI().setIntention(CtrlIntention.AI_INTENTION_MOVE_TO, this._pos);
                    if (SailrenManager.this._socialTask != null) {
                        SailrenManager.this._socialTask.cancel(true);
                        SailrenManager.this._socialTask = null;
                    }
                    SailrenManager.this._socialTask = ThreadPoolManager.getInstance().scheduleGeneral(new Social(SailrenManager.this._pterosaur, 2), 6000L);
                    if (SailrenManager.this._activityTimeEndTask != null) {
                        SailrenManager.this._activityTimeEndTask.cancel(true);
                        SailrenManager.this._activityTimeEndTask = null;
                    }
                    SailrenManager.this._activityTimeEndTask = ThreadPoolManager.getInstance().scheduleGeneral(new ActivityTimeEnd(SailrenManager.this._pterosaur), Config.FWS_ACTIVITYTIMEOFMOBS);
                    break;
                }
                case 22217: {
                    SailrenManager.this._tyranno = SailrenManager.this._tyrannoSpawn.doSpawn();
                    SailrenManager.this._tyranno.getAI().setIntention(CtrlIntention.AI_INTENTION_MOVE_TO, this._pos);
                    if (SailrenManager.this._socialTask != null) {
                        SailrenManager.this._socialTask.cancel(true);
                        SailrenManager.this._socialTask = null;
                    }
                    SailrenManager.this._socialTask = ThreadPoolManager.getInstance().scheduleGeneral(new Social(SailrenManager.this._tyranno, 2), 6000L);
                    if (SailrenManager.this._activityTimeEndTask != null) {
                        SailrenManager.this._activityTimeEndTask.cancel(true);
                        SailrenManager.this._activityTimeEndTask = null;
                    }
                    SailrenManager.this._activityTimeEndTask = ThreadPoolManager.getInstance().scheduleGeneral(new ActivityTimeEnd(SailrenManager.this._tyranno), Config.FWS_ACTIVITYTIMEOFMOBS);
                    break;
                }
                case 29065: {
                    SailrenManager.this._sailren = SailrenManager.this._sailrenSapwn.doSpawn();
                    SailrenManager.this._state.setRespawnDate(Config.FWS_FIXINTERVALOFSAILRENSPAWN + Rnd.get(Config.FWS_RANDOMINTERVALOFSAILRENSPAWN) + Config.FWS_ACTIVITYTIMEOFMOBS);
                    SailrenManager.this._state.setState(1);
                    SailrenManager.this._state.update();
                    SailrenManager.this._sailren.getAI().setIntention(CtrlIntention.AI_INTENTION_MOVE_TO, this._pos);
                    if (SailrenManager.this._socialTask != null) {
                        SailrenManager.this._socialTask.cancel(true);
                        SailrenManager.this._socialTask = null;
                    }
                    SailrenManager.this._socialTask = ThreadPoolManager.getInstance().scheduleGeneral(new Social(SailrenManager.this._sailren, 2), 6000L);
                    if (SailrenManager.this._activityTimeEndTask != null) {
                        SailrenManager.this._activityTimeEndTask.cancel(true);
                        SailrenManager.this._activityTimeEndTask = null;
                    }
                    SailrenManager.this._activityTimeEndTask = ThreadPoolManager.getInstance().scheduleGeneral(new ActivityTimeEnd(SailrenManager.this._sailren), Config.FWS_ACTIVITYTIMEOFMOBS);
                }
            }
            if (SailrenManager.this._sailrenSpawnTask != null) {
                SailrenManager.this._sailrenSpawnTask.cancel(true);
                SailrenManager.this._sailrenSpawnTask = null;
            }
        }
    }

    private static final class SingletonHolder {
        protected static final SailrenManager INSTANCE = new SailrenManager();

        private SingletonHolder() {
        }
    }
}

