/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model;

import com.l2jserver.Config;
import com.l2jserver.gameserver.Territory;
import com.l2jserver.gameserver.idfactory.IdFactory;
import com.l2jserver.gameserver.model.L2Spawn;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.templates.chars.L2NpcTemplate;
import com.l2jserver.util.Rnd;
import java.lang.reflect.Constructor;
import java.util.logging.Level;

public class L2GroupSpawn
extends L2Spawn {
    private Constructor<?> _constructor = Class.forName("com.l2jserver.gameserver.model.actor.instance.L2ControllableMobInstance").getConstructors()[0];
    private L2NpcTemplate _template;

    public L2GroupSpawn(L2NpcTemplate mobTemplate) throws SecurityException, ClassNotFoundException, NoSuchMethodException {
        super(mobTemplate);
        this._template = mobTemplate;
        this.setAmount(1);
    }

    public L2Npc doGroupSpawn() {
        L2Npc mob = null;
        try {
            int newlocz;
            int newlocy;
            int newlocx;
            if (this._template.type.equalsIgnoreCase("L2Pet") || this._template.type.equalsIgnoreCase("L2Minion")) {
                return null;
            }
            Object[] parameters = new Object[]{IdFactory.getInstance().getNextId(), this._template};
            Object tmp = this._constructor.newInstance(parameters);
            if (!(tmp instanceof L2Npc)) {
                return null;
            }
            mob = (L2Npc)tmp;
            if (this.getLocx() == 0 && this.getLocy() == 0) {
                if (this.getLocation() == 0) {
                    return null;
                }
                int[] p = Territory.getInstance().getRandomPoint(this.getLocation());
                newlocx = p[0];
                newlocy = p[1];
                newlocz = p[2];
            } else {
                newlocx = this.getLocx();
                newlocy = this.getLocy();
                newlocz = this.getLocz();
            }
            mob.setCurrentHpMp(mob.getMaxHp(), mob.getMaxMp());
            if (this.getHeading() == -1) {
                mob.setHeading(Rnd.nextInt(61794));
            } else {
                mob.setHeading(this.getHeading());
            }
            mob.setSpawn(this);
            mob.spawnMe(newlocx, newlocy, newlocz);
            mob.onSpawn();
            if (Config.DEBUG) {
                _log.finest("spawned Mob ID: " + this._template.npcId + " ,at: " + mob.getX() + " x, " + mob.getY() + " y, " + mob.getZ() + " z");
            }
            return mob;
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "NPC class not found: " + e.getMessage(), e);
            return null;
        }
    }
}

