/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor;

import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.model.L2ItemInstance;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.L2Skill;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.knownlist.TrapKnownList;
import com.l2jserver.gameserver.network.serverpackets.AbstractNpcInfo;
import com.l2jserver.gameserver.network.serverpackets.L2GameServerPacket;
import com.l2jserver.gameserver.network.serverpackets.SocialAction;
import com.l2jserver.gameserver.taskmanager.DecayTaskManager;
import com.l2jserver.gameserver.templates.chars.L2NpcTemplate;
import com.l2jserver.gameserver.templates.item.L2Weapon;
import java.util.Collection;
import java.util.logging.Level;

public class L2Trap
extends L2Character {
    protected static final int TICK = 1000;
    private boolean _isTriggered;
    private final L2Skill _skill;
    private final int _lifeTime;
    private int _timeRemaining;

    public L2Trap(int objectId, L2NpcTemplate template, int lifeTime, L2Skill skill) {
        super(objectId, template);
        this.setInstanceType(L2Object.InstanceType.L2Trap);
        this.setName(template.name);
        this.setIsInvul(false);
        this._isTriggered = false;
        this._skill = skill;
        this._lifeTime = lifeTime != 0 ? lifeTime : 30000;
        this._timeRemaining = this._lifeTime;
        ThreadPoolManager.getInstance().scheduleGeneral(new TrapTask(), 1000L);
    }

    @Override
    public TrapKnownList getKnownList() {
        return (TrapKnownList)super.getKnownList();
    }

    @Override
    public void initKnownList() {
        this.setKnownList(new TrapKnownList(this));
    }

    @Override
    public boolean isAutoAttackable(L2Character attacker) {
        return !this.canSee(attacker);
    }

    public void stopDecay() {
        DecayTaskManager.getInstance().cancelDecayTask(this);
    }

    @Override
    public void onDecay() {
        this.deleteMe();
    }

    public final int getNpcId() {
        return this.getTemplate().npcId;
    }

    @Override
    public boolean doDie(L2Character killer) {
        if (!super.doDie(killer)) {
            return false;
        }
        DecayTaskManager.getInstance().addDecayTask(this);
        return true;
    }

    @Override
    public void deleteMe() {
        this.decayMe();
        this.getKnownList().removeAllKnownObjects();
        super.deleteMe();
    }

    public synchronized void unSummon() {
        if (this.isVisible() && !this.isDead()) {
            if (this.getWorldRegion() != null) {
                this.getWorldRegion().removeFromZones(this);
            }
            this.deleteMe();
        }
    }

    @Override
    public L2ItemInstance getActiveWeaponInstance() {
        return null;
    }

    @Override
    public L2Weapon getActiveWeaponItem() {
        return null;
    }

    @Override
    public int getLevel() {
        return this.getTemplate().level;
    }

    @Override
    public L2NpcTemplate getTemplate() {
        return (L2NpcTemplate)super.getTemplate();
    }

    @Override
    public L2ItemInstance getSecondaryWeaponInstance() {
        return null;
    }

    @Override
    public L2Weapon getSecondaryWeaponItem() {
        return null;
    }

    @Override
    public void updateAbnormalEffect() {
    }

    public L2Skill getSkill() {
        return this._skill;
    }

    public L2PcInstance getOwner() {
        return null;
    }

    public int getKarma() {
        return 0;
    }

    public byte getPvpFlag() {
        return 0;
    }

    public boolean isTriggered() {
        return this._isTriggered;
    }

    public boolean canSee(L2Character cha) {
        return false;
    }

    public void setDetected(L2Character detector) {
        detector.sendPacket(new AbstractNpcInfo.TrapInfo(this, detector));
    }

    protected boolean checkTarget(L2Character target) {
        return L2Skill.checkForAreaOffensiveSkills(this, target, this._skill, false);
    }

    public void trigger(L2Character target) {
        this._isTriggered = true;
        this.broadcastPacket(new AbstractNpcInfo.TrapInfo(this, null));
        this.setTarget(target);
        ThreadPoolManager.getInstance().scheduleGeneral(new TriggerTask(), 300L);
    }

    @Override
    public void sendInfo(L2PcInstance activeChar) {
        if (this._isTriggered || this.canSee(activeChar)) {
            activeChar.sendPacket(new AbstractNpcInfo.TrapInfo(this, activeChar));
        }
    }

    @Override
    public void broadcastPacket(L2GameServerPacket mov) {
        Collection<L2PcInstance> plrs = this.getKnownList().getKnownPlayers().values();
        for (L2PcInstance player : plrs) {
            if (player == null || !this._isTriggered && !this.canSee(player)) continue;
            player.sendPacket(mov);
        }
    }

    @Override
    public void broadcastPacket(L2GameServerPacket mov, int radiusInKnownlist) {
        Collection<L2PcInstance> plrs = this.getKnownList().getKnownPlayers().values();
        for (L2PcInstance player : plrs) {
            if (player == null || !this.isInsideRadius(player, radiusInKnownlist, false, false) || !this._isTriggered && !this.canSee(player)) continue;
            player.sendPacket(mov);
        }
    }

    private class UnsummonTask
    implements Runnable {
        private UnsummonTask() {
        }

        @Override
        public void run() {
            L2Trap.this.unSummon();
        }
    }

    private class TriggerTask
    implements Runnable {
        private TriggerTask() {
        }

        @Override
        public void run() {
            try {
                L2Trap.this.doCast(L2Trap.this._skill);
                ThreadPoolManager.getInstance().scheduleGeneral(new UnsummonTask(), L2Trap.this._skill.getHitTime() + 300);
            }
            catch (Exception e) {
                L2Trap.this.unSummon();
            }
        }
    }

    private class TrapTask
    implements Runnable {
        private TrapTask() {
        }

        @Override
        public void run() {
            try {
                if (!L2Trap.this._isTriggered) {
                    L2Trap.this._timeRemaining -= 1000;
                    if (L2Trap.this._timeRemaining < L2Trap.this._lifeTime - 15000) {
                        SocialAction sa = new SocialAction(L2Trap.this.getObjectId(), 2);
                        L2Trap.this.broadcastPacket(sa);
                    }
                    if (L2Trap.this._timeRemaining < 0) {
                        switch (L2Trap.this.getSkill().getTargetType()) {
                            case TARGET_AURA: 
                            case TARGET_FRONT_AURA: 
                            case TARGET_BEHIND_AURA: {
                                L2Trap.this.trigger(L2Trap.this);
                                break;
                            }
                            default: {
                                L2Trap.this.unSummon();
                            }
                        }
                        return;
                    }
                    for (L2Character target : L2Trap.this.getKnownList().getKnownCharactersInRadius(L2Trap.this._skill.getSkillRadius())) {
                        if (!L2Trap.this.checkTarget(target)) continue;
                        L2Trap.this.trigger(target);
                        return;
                    }
                    ThreadPoolManager.getInstance().scheduleGeneral(new TrapTask(), 1000L);
                }
            }
            catch (Exception e) {
                L2Character._log.log(Level.SEVERE, "", e);
                L2Trap.this.unSummon();
            }
        }
    }
}

