/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor.instance;

import com.l2jserver.Config;
import com.l2jserver.gameserver.TradeController;
import com.l2jserver.gameserver.datatables.MerchantPriceConfigTable;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.L2TradeList;
import com.l2jserver.gameserver.model.actor.instance.L2NpcInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.serverpackets.ActionFailed;
import com.l2jserver.gameserver.network.serverpackets.ExBuySellListPacket;
import com.l2jserver.gameserver.templates.chars.L2NpcTemplate;

public class L2MerchantInstance
extends L2NpcInstance {
    private MerchantPriceConfigTable.MerchantPriceConfig _mpc;

    public L2MerchantInstance(int objectId, L2NpcTemplate template) {
        super(objectId, template);
        this.setInstanceType(L2Object.InstanceType.L2MerchantInstance);
    }

    @Override
    public void onSpawn() {
        super.onSpawn();
        this._mpc = MerchantPriceConfigTable.getInstance().getMerchantPriceConfig(this);
    }

    @Override
    public String getHtmlPath(int npcId, int val) {
        return this.getHtmlPath("data/html/merchant/", npcId, val);
    }

    public MerchantPriceConfigTable.MerchantPriceConfig getMpc() {
        return this._mpc;
    }

    public final void showBuyWindow(L2PcInstance player, int val) {
        L2TradeList list;
        double taxRate = 0.0;
        taxRate = this.getMpc().getTotalTaxRate();
        player.tempInventoryDisable();
        if (Config.DEBUG) {
            _log.fine("Showing buylist");
        }
        if ((list = TradeController.getInstance().getBuyList(val)) != null && list.getNpcId().equals(String.valueOf(this.getNpcId()))) {
            player.sendPacket(new ExBuySellListPacket(player, list, taxRate, false));
        } else {
            _log.warning("possible client hacker: " + player.getName() + " attempting to buy from GM shop! < Ban him!");
            _log.warning("buylist id:" + val);
        }
        player.sendPacket(ActionFailed.STATIC_PACKET);
    }
}

