/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.Config;
import com.l2jserver.gameserver.TaskPriority;
import com.l2jserver.gameserver.ai.CtrlIntention;
import com.l2jserver.gameserver.model.L2CharPosition;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import com.l2jserver.gameserver.network.serverpackets.ActionFailed;
import com.l2jserver.gameserver.network.serverpackets.PartyMemberPosition;
import com.l2jserver.gameserver.util.Util;
import java.nio.BufferUnderflowException;

public class MoveBackwardToLocation
extends L2GameClientPacket {
    private int _targetX;
    private int _targetY;
    private int _targetZ;
    private int _originX;
    private int _originY;
    private int _originZ;
    private int _moveMovement;
    private int _curX;
    private int _curY;
    private int _curZ;
    private static final String _C__01_MOVEBACKWARDTOLOC = "[C] 01 MoveBackwardToLoc";

    public TaskPriority getPriority() {
        return TaskPriority.PR_HIGH;
    }

    @Override
    protected void readImpl() {
        block2: {
            this._targetX = this.readD();
            this._targetY = this.readD();
            this._targetZ = this.readD();
            this._originX = this.readD();
            this._originY = this.readD();
            this._originZ = this.readD();
            try {
                this._moveMovement = this.readD();
            }
            catch (BufferUnderflowException e) {
                if (!Config.L2WALKER_PROTECTION) break block2;
                L2PcInstance activeChar = ((L2GameClient)this.getClient()).getActiveChar();
                Util.handleIllegalPlayerAction(activeChar, "Player " + activeChar.getName() + " is trying to use L2Walker and got kicked.", Config.DEFAULT_PUNISH);
            }
        }
    }

    @Override
    protected void runImpl() {
        L2PcInstance activeChar = ((L2GameClient)this.getClient()).getActiveChar();
        if (activeChar == null) {
            return;
        }
        this._targetZ += activeChar.getTemplate().collisionHeight;
        this._curX = activeChar.getX();
        this._curY = activeChar.getY();
        this._curZ = activeChar.getZ();
        if (activeChar.getTeleMode() > 0) {
            if (activeChar.getTeleMode() == 1) {
                activeChar.setTeleMode(0);
            }
            activeChar.sendPacket(ActionFailed.STATIC_PACKET);
            activeChar.teleToLocation(this._targetX, this._targetY, this._targetZ, false);
            return;
        }
        if (this._moveMovement == 0 && Config.GEODATA < 1) {
            activeChar.sendPacket(ActionFailed.STATIC_PACKET);
        } else {
            double dx = this._targetX - this._curX;
            double dy = this._targetY - this._curY;
            if (activeChar.isOutOfControl() || dx * dx + dy * dy > 9.801E7) {
                activeChar.sendPacket(ActionFailed.STATIC_PACKET);
                return;
            }
            activeChar.getAI().setIntention(CtrlIntention.AI_INTENTION_MOVE_TO, new L2CharPosition(this._targetX, this._targetY, this._targetZ, 0));
            if (activeChar.getParty() != null) {
                activeChar.getParty().broadcastToPartyMembers(activeChar, new PartyMemberPosition(activeChar));
            }
        }
    }

    @Override
    public String getType() {
        return _C__01_MOVEBACKWARDTOLOC;
    }

    @Override
    protected boolean triggersOnActionRequest() {
        return true;
    }
}

