/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.Config;
import com.l2jserver.gameserver.datatables.AccessLevels;
import com.l2jserver.gameserver.datatables.CharNameTable;
import com.l2jserver.gameserver.instancemanager.MailManager;
import com.l2jserver.gameserver.model.BlockList;
import com.l2jserver.gameserver.model.L2AccessLevel;
import com.l2jserver.gameserver.model.L2ItemInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.entity.Message;
import com.l2jserver.gameserver.model.itemcontainer.Mail;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import com.l2jserver.gameserver.network.serverpackets.ExNoticePostSent;
import com.l2jserver.gameserver.network.serverpackets.InventoryUpdate;
import com.l2jserver.gameserver.network.serverpackets.ItemList;
import com.l2jserver.gameserver.network.serverpackets.StatusUpdate;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import java.util.logging.Logger;

public final class RequestSendPost
extends L2GameClientPacket {
    private static final String _C__D0_66_REQUESTSENDPOST = "[C] D0:66 RequestSendPost";
    private static final Logger _log = Logger.getLogger(RequestSendPost.class.getName());
    private static final int BATCH_LENGTH = 12;
    private static final int MAX_RECV_LENGTH = 16;
    private static final int MAX_SUBJ_LENGTH = 128;
    private static final int MAX_TEXT_LENGTH = 512;
    private static final int MAX_ATTACHMENTS = 8;
    private static final int INBOX_SIZE = 240;
    private static final int OUTBOX_SIZE = 240;
    private static final int MESSAGE_FEE = 100;
    private static final int MESSAGE_FEE_PER_SLOT = 1000;
    private String _receiver;
    private boolean _isCod;
    private String _subject;
    private String _text;
    private AttachmentItem[] _items = null;
    private long _reqAdena;

    @Override
    protected void readImpl() {
        this._receiver = this.readS();
        this._isCod = this.readD() != 0;
        this._subject = this.readS();
        this._text = this.readS();
        int attachCount = this.readD();
        if (attachCount < 0 || attachCount > Config.MAX_ITEM_IN_PACKET || attachCount * 12 + 8 != this._buf.remaining()) {
            return;
        }
        if (attachCount > 0) {
            this._items = new AttachmentItem[attachCount];
            for (int i = 0; i < attachCount; ++i) {
                int objectId = this.readD();
                long count = this.readQ();
                if (objectId < 1 || count < 0L) {
                    this._items = null;
                    return;
                }
                this._items[i] = new AttachmentItem(objectId, count);
            }
        }
        this._reqAdena = this.readQ();
    }

    @Override
    public void runImpl() {
        L2AccessLevel accessLevel;
        int receiverId;
        if (!Config.ALLOW_MAIL) {
            return;
        }
        L2PcInstance activeChar = ((L2GameClient)this.getClient()).getActiveChar();
        if (activeChar == null) {
            return;
        }
        if (!Config.ALLOW_ATTACHMENTS) {
            this._items = null;
            this._isCod = false;
            this._reqAdena = 0L;
        }
        if (!activeChar.getAccessLevel().allowTransaction()) {
            activeChar.sendMessage("Transactions are disable for your Access Level.");
            return;
        }
        if (!activeChar.isInsideZone((byte)1)) {
            activeChar.sendPacket(new SystemMessage(SystemMessageId.CANT_FORWARD_NOT_IN_PEACE_ZONE));
            return;
        }
        if (activeChar.getActiveTradeList() != null) {
            activeChar.sendPacket(new SystemMessage(SystemMessageId.CANT_FORWARD_DURING_EXCHANGE));
            return;
        }
        if (activeChar.isEnchanting()) {
            activeChar.sendPacket(new SystemMessage(SystemMessageId.CANT_FORWARD_DURING_ENCHANT));
            return;
        }
        if (activeChar.getPrivateStoreType() > 0) {
            activeChar.sendPacket(new SystemMessage(SystemMessageId.CANT_FORWARD_PRIVATE_STORE));
            return;
        }
        if (this._receiver.length() > 16) {
            activeChar.sendPacket(new SystemMessage(SystemMessageId.ALLOWED_LENGTH_FOR_RECIPIENT_EXCEEDED));
            return;
        }
        if (this._subject.length() > 128) {
            activeChar.sendPacket(new SystemMessage(SystemMessageId.ALLOWED_LENGTH_FOR_TITLE_EXCEEDED));
            return;
        }
        if (this._text.length() > 512) {
            activeChar.sendPacket(new SystemMessage(SystemMessageId.ALLOWED_LENGTH_FOR_TITLE_EXCEEDED));
            return;
        }
        if (this._items != null && this._items.length > 8) {
            activeChar.sendPacket(new SystemMessage(SystemMessageId.ITEM_SELECTION_POSSIBLE_UP_TO_8));
            return;
        }
        if (this._reqAdena < 0L || this._reqAdena > 99900000000L) {
            return;
        }
        if (this._isCod) {
            if (this._reqAdena == 0L) {
                activeChar.sendPacket(new SystemMessage(SystemMessageId.PAYMENT_AMOUNT_NOT_ENTERED));
                return;
            }
            if (this._items == null || this._items.length == 0) {
                activeChar.sendPacket(new SystemMessage(SystemMessageId.PAYMENT_REQUEST_NO_ITEM));
                return;
            }
        }
        if ((receiverId = CharNameTable.getInstance().getIdByName(this._receiver)) <= 0) {
            activeChar.sendPacket(new SystemMessage(SystemMessageId.RECIPIENT_NOT_EXIST));
            return;
        }
        if (receiverId == activeChar.getObjectId()) {
            activeChar.sendPacket(new SystemMessage(SystemMessageId.YOU_CANT_SEND_MAIL_TO_YOURSELF));
            return;
        }
        int level = CharNameTable.getInstance().getAccessLevelById(receiverId);
        if (level == AccessLevels._masterAccessLevelNum) {
            accessLevel = AccessLevels._masterAccessLevel;
        } else if (level == 0) {
            accessLevel = AccessLevels._userAccessLevel;
        } else {
            accessLevel = AccessLevels.getInstance().getAccessLevel(level);
            if (accessLevel == null) {
                accessLevel = AccessLevels._userAccessLevel;
            }
        }
        if (accessLevel.isGm() && !activeChar.getAccessLevel().isGm()) {
            SystemMessage sm = new SystemMessage(SystemMessageId.CANNOT_MAIL_GM_C1);
            sm.addString(this._receiver);
            activeChar.sendPacket(sm);
            return;
        }
        if (activeChar.isInJail() && (Config.JAIL_DISABLE_TRANSACTION && this._items != null || Config.JAIL_DISABLE_CHAT)) {
            activeChar.sendPacket(new SystemMessage(SystemMessageId.CANT_FORWARD_NOT_IN_PEACE_ZONE));
            return;
        }
        if (BlockList.isInBlockList(receiverId, activeChar.getObjectId())) {
            activeChar.sendPacket(new SystemMessage(SystemMessageId.C1_BLOCKED_YOU_CANNOT_MAIL).addString(this._receiver));
            return;
        }
        if (MailManager.getInstance().getOutboxSize(activeChar.getObjectId()) >= 240) {
            activeChar.sendPacket(new SystemMessage(SystemMessageId.CANT_FORWARD_MAIL_LIMIT_EXCEEDED));
            return;
        }
        if (MailManager.getInstance().getInboxSize(receiverId) >= 240) {
            activeChar.sendPacket(new SystemMessage(SystemMessageId.CANT_FORWARD_MAIL_LIMIT_EXCEEDED));
            return;
        }
        if (!activeChar.getFloodProtectors().getSendMail().tryPerformAction("sendmail")) {
            activeChar.sendPacket(new SystemMessage(SystemMessageId.CANT_FORWARD_LESS_THAN_MINUTE));
            return;
        }
        Message msg = new Message(activeChar.getObjectId(), receiverId, this._isCod, this._subject, this._text, this._reqAdena);
        if (this.removeItems(activeChar, msg)) {
            MailManager.getInstance().sendMessage(msg);
            activeChar.sendPacket(ExNoticePostSent.valueOf(true));
            activeChar.sendPacket(new SystemMessage(SystemMessageId.MAIL_SUCCESSFULLY_SENT));
        }
    }

    private final boolean removeItems(L2PcInstance player, Message msg) {
        long currentAdena = player.getAdena();
        long fee = 100L;
        if (this._items != null) {
            for (AttachmentItem i : this._items) {
                L2ItemInstance item = player.checkItemManipulation(i.getObjectId(), i.getCount(), "attach");
                if (item == null || !item.isTradeable() || item.isEquipped()) {
                    player.sendPacket(new SystemMessage(SystemMessageId.CANT_FORWARD_BAD_ITEM));
                    return false;
                }
                fee += 1000L;
                if (item.getItemId() != 57) continue;
                currentAdena -= i.getCount();
            }
        }
        if (currentAdena < fee || !player.reduceAdena("MailFee", fee, null, false)) {
            player.sendPacket(new SystemMessage(SystemMessageId.CANT_FORWARD_NO_ADENA));
            return false;
        }
        if (this._items == null) {
            return true;
        }
        Mail attachments = msg.createAttachments();
        if (attachments == null) {
            return false;
        }
        InventoryUpdate playerIU = Config.FORCE_INVENTORY_UPDATE ? null : new InventoryUpdate();
        for (AttachmentItem i : this._items) {
            L2ItemInstance oldItem = player.checkItemManipulation(i.getObjectId(), i.getCount(), "attach");
            if (oldItem == null || !oldItem.isTradeable() || oldItem.isEquipped()) {
                _log.warning("Error adding attachment for char " + player.getName() + " (olditem == null)");
                return false;
            }
            L2ItemInstance newItem = player.getInventory().transferItem("SendMail", i.getObjectId(), i.getCount(), attachments, player, null);
            if (newItem == null) {
                _log.warning("Error adding attachment for char " + player.getName() + " (newitem == null)");
                continue;
            }
            newItem.setLocation(newItem.getLocation(), msg.getId());
            if (playerIU == null) continue;
            if (oldItem.getCount() > 0L && oldItem != newItem) {
                playerIU.addModifiedItem(oldItem);
                continue;
            }
            playerIU.addRemovedItem(oldItem);
        }
        if (playerIU != null) {
            player.sendPacket(playerIU);
        } else {
            player.sendPacket(new ItemList(player, false));
        }
        StatusUpdate su = new StatusUpdate(player.getObjectId());
        su.addAttribute(14, player.getCurrentLoad());
        player.sendPacket(su);
        return true;
    }

    @Override
    public String getType() {
        return _C__D0_66_REQUESTSENDPOST;
    }

    private class AttachmentItem {
        private final int _objectId;
        private final long _count;

        public AttachmentItem(int id, long num) {
            this._objectId = id;
            this._count = num;
        }

        public int getObjectId() {
            return this._objectId;
        }

        public long getCount() {
            return this._count;
        }
    }
}

