/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.communityserver.readpackets;

import com.l2jserver.gameserver.network.communityserver.CommunityServerThread;
import com.l2jserver.gameserver.network.communityserver.writepackets.BlowFishKey;
import com.l2jserver.gameserver.network.communityserver.writepackets.GameServerAuth;
import com.l2jserver.util.Rnd;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.RSAKeyGenParameterSpec;
import java.security.spec.RSAPublicKeySpec;
import javax.crypto.Cipher;
import org.netcon.BaseReadPacket;
import org.netcon.crypt.NewCrypt;

public final class InitCS
extends BaseReadPacket {
    private final CommunityServerThread _cst;

    public InitCS(byte[] data, CommunityServerThread cst) {
        super(data);
        this._cst = cst;
    }

    public final void run() {
        int length = super.readD();
        byte[] key = super.readB(length);
        try {
            KeyFactory kfac = KeyFactory.getInstance("RSA");
            RSAPublicKeySpec kspec1 = new RSAPublicKeySpec(new BigInteger(key), RSAKeyGenParameterSpec.F4);
            RSAPublicKey publicKey = (RSAPublicKey)kfac.generatePublic(kspec1);
            byte[] privateKey = new byte[40];
            Rnd.nextBytes(privateKey);
            Cipher rsaCipher = Cipher.getInstance("RSA/ECB/nopadding");
            rsaCipher.init(1, publicKey);
            byte[] tempKey = rsaCipher.doFinal(privateKey);
            this._cst.sendPacket(new BlowFishKey(tempKey), false);
            this._cst.setCrypt(new NewCrypt(privateKey));
            this._cst.sendPacket(new GameServerAuth(), false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

