/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.serverpackets;

import com.l2jserver.Config;
import com.l2jserver.gameserver.model.L2ItemInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.serverpackets.L2GameServerPacket;
import java.util.logging.Logger;

public final class WareHouseWithdrawalList
extends L2GameServerPacket {
    public static final int PRIVATE = 1;
    public static final int CLAN = 4;
    public static final int CASTLE = 3;
    public static final int FREIGHT = 1;
    private static Logger _log = Logger.getLogger(WareHouseWithdrawalList.class.getName());
    private static final String _S__54_WAREHOUSEWITHDRAWALLIST = "[S] 42 WareHouseWithdrawalList";
    private L2PcInstance _activeChar;
    private long _playerAdena;
    private L2ItemInstance[] _items;
    private int _whType;

    public WareHouseWithdrawalList(L2PcInstance player, int type) {
        this._activeChar = player;
        this._whType = type;
        this._playerAdena = this._activeChar.getAdena();
        if (this._activeChar.getActiveWarehouse() == null) {
            _log.warning("error while sending withdraw request to: " + this._activeChar.getName());
            return;
        }
        this._items = this._activeChar.getActiveWarehouse().getItems();
        if (Config.DEBUG) {
            for (L2ItemInstance item : this._items) {
                _log.fine("item:" + item.getItem().getName() + " type1:" + item.getItem().getType1() + " type2:" + item.getItem().getType2());
            }
        }
    }

    @Override
    protected final void writeImpl() {
        this.writeC(66);
        this.writeH(this._whType);
        this.writeQ(this._playerAdena);
        this.writeH(this._items.length);
        for (L2ItemInstance item : this._items) {
            this.writeH(item.getItem().getType1());
            this.writeD(item.getObjectId());
            this.writeD(item.getItemId());
            this.writeQ(item.getCount());
            this.writeH(item.getItem().getType2());
            this.writeH(item.getCustomType1());
            this.writeD(item.getItem().getBodyPart());
            this.writeH(item.getEnchantLevel());
            this.writeH(0);
            this.writeH(item.getCustomType2());
            this.writeD(item.getObjectId());
            if (item.isAugmented()) {
                this.writeD(0xFFFF & item.getAugmentation().getAugmentationId());
                this.writeD(item.getAugmentation().getAugmentationId() >> 16);
            } else {
                this.writeQ(0L);
            }
            this.writeH(item.getAttackElementType());
            this.writeH(item.getAttackElementPower());
            for (byte i = 0; i < 6; i = (byte)(i + 1)) {
                this.writeH(item.getElementDefAttr(i));
            }
            this.writeD(item.getMana());
            this.writeD(item.isTimeLimitedItem() ? (int)(item.getRemainingTime() / 1000L) : -1);
            this.writeH(0);
            this.writeH(0);
            this.writeH(0);
        }
    }

    @Override
    public String getType() {
        return _S__54_WAREHOUSEWITHDRAWALLIST;
    }
}

