/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.skills.effects;

import com.l2jserver.Config;
import com.l2jserver.gameserver.GeoData;
import com.l2jserver.gameserver.ai.CtrlIntention;
import com.l2jserver.gameserver.model.L2CharPosition;
import com.l2jserver.gameserver.model.L2Effect;
import com.l2jserver.gameserver.model.Location;
import com.l2jserver.gameserver.model.actor.instance.L2DefenderInstance;
import com.l2jserver.gameserver.model.actor.instance.L2FortCommanderInstance;
import com.l2jserver.gameserver.model.actor.instance.L2NpcInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PetInstance;
import com.l2jserver.gameserver.model.actor.instance.L2SiegeFlagInstance;
import com.l2jserver.gameserver.model.actor.instance.L2SiegeSummonInstance;
import com.l2jserver.gameserver.skills.Env;
import com.l2jserver.gameserver.templates.effects.EffectTemplate;
import com.l2jserver.gameserver.templates.skills.L2EffectType;

public class EffectFear
extends L2Effect {
    public static final int FEAR_RANGE = 500;
    private int _dX = -1;
    private int _dY = -1;

    public EffectFear(Env env, EffectTemplate template) {
        super(env, template);
    }

    @Override
    public L2EffectType getEffectType() {
        return L2EffectType.FEAR;
    }

    @Override
    public boolean onStart() {
        if (this.getEffected() instanceof L2PcInstance && this.getEffector() instanceof L2PcInstance && this.getSkill().getId() != 1376 && this.getSkill().getId() != 1169 && this.getSkill().getId() != 65 && this.getSkill().getId() != 1092 && this.getSkill().getId() != 98 && this.getSkill().getId() != 1272 && this.getSkill().getId() != 1381) {
            return false;
        }
        if (this.getEffected() instanceof L2NpcInstance || this.getEffected() instanceof L2DefenderInstance || this.getEffected() instanceof L2FortCommanderInstance || this.getEffected() instanceof L2SiegeFlagInstance || this.getEffected() instanceof L2SiegeSummonInstance) {
            return false;
        }
        if (!this.getEffected().isAfraid()) {
            if (this.getEffected().getX() > this.getEffector().getX()) {
                this._dX = 1;
            }
            if (this.getEffected().getY() > this.getEffector().getY()) {
                this._dY = 1;
            }
            this.getEffected().startFear();
            this.onActionTime();
            return true;
        }
        return false;
    }

    @Override
    public void onExit() {
        this.getEffected().stopFear(this);
    }

    @Override
    public boolean onActionTime() {
        int posX = this.getEffected().getX();
        int posY = this.getEffected().getY();
        int posZ = this.getEffected().getZ();
        posX += this._dX * 500;
        posY += this._dY * 500;
        if (Config.GEODATA > 0) {
            Location destiny = GeoData.getInstance().moveCheck(this.getEffected().getX(), this.getEffected().getY(), this.getEffected().getZ(), posX, posY, posZ, this.getEffected().getInstanceId());
            posX = destiny.getX();
            posY = destiny.getY();
        }
        if (!(this.getEffected() instanceof L2PetInstance)) {
            this.getEffected().setRunning();
        }
        this.getEffected().getAI().setIntention(CtrlIntention.AI_INTENTION_MOVE_TO, new L2CharPosition(posX, posY, posZ, 0));
        return true;
    }
}

