DROP TABLE IF EXISTS `weapon`;
CREATE TABLE `weapon` (
  `item_id` decimal(11,0) NOT NULL default '0',
  `name` varchar(120) NOT NULL default '0',
  `additionalname` varchar(120) NOT NULL default '',
  `bodypart` varchar(15) NOT NULL default 'none',
  `crystallizable` varchar(5) NOT NULL default 'false',
  `weight` decimal(4,0) NOT NULL default '0',
  `soulshots` decimal(2,0) NOT NULL default '0',
  `spiritshots` decimal(1,0) NOT NULL default '0',
  `material` varchar(11) NOT NULL default 'wood',
  `crystal_type` varchar(4) NOT NULL default 'none',
  `p_dam` decimal(5,0) NOT NULL default '0',
  `rnd_dam` decimal(2,0) NOT NULL default '0',
  `weaponType` varchar(10) NOT NULL default 'none',
  `critical` decimal(2,0) NOT NULL default '0',
  `hit_modify` decimal(6,5) NOT NULL default '0',
  `avoid_modify` decimal(2,0) NOT NULL default '0',
  `shield_def` decimal(3,0) NOT NULL default '0',
  `shield_def_rate` decimal(2,0) NOT NULL default '0',
  `atk_speed` decimal(3,0) NOT NULL default '0',
  `mp_consume` decimal(2,0) NOT NULL default '0',
  `m_dam` decimal(3,0) NOT NULL default '0',
  `duration` int(3) NOT NULL default '-1', -- duration in minutes for shadow items
  `time` int(4) NOT NULL default '-1',     -- duration in minutes for time limited items
  `price` decimal(11,0) NOT NULL default '0',
  `crystal_count` int(4) NOT NULL default '0',
  `sellable` varchar(5) NOT NULL default 'false',
  `dropable` varchar(5) NOT NULL default 'false',
  `destroyable` varchar(5) NOT NULL default 'false',
  `tradeable` varchar(5) NOT NULL default 'false',
  `depositable` varchar(5) NOT NULL default 'false',
  `enchant4_skill_id` decimal(11,0) NOT NULL default '0',
  `enchant4_skill_lvl` decimal(11,0) NOT NULL default '0',
  `onCast_skill_id` decimal(11,0) NOT NULL default '0',
  `onCast_skill_lvl` decimal(11,0) NOT NULL default '0',
  `onCast_skill_chance` decimal(11,0) NOT NULL default '0',
  `onCrit_skill_id` decimal(11,0) NOT NULL default '0',
  `onCrit_skill_lvl` decimal(11,0) NOT NULL default '0',
  `onCrit_skill_chance` decimal(11,0) NOT NULL default '0',
  `change_weaponId` decimal(11,0) NOT NULL default '0',
  `skill` varchar(70) NOT NULL default '0-0;',
  PRIMARY KEY (`item_id`)
) DEFAULT CHARSET=utf8;

INSERT INTO `weapon` VALUES
(1,'Short Sword','','rhand','false',1600,1,1,'steel','none',8,10,'sword',8,0.00000,0,0,0,379,0,6,-1,-1,590,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(2,'Long Sword','','rhand','false',1560,2,2,'fine_steel','none',24,10,'sword',8,0.00000,0,0,0,379,0,17,-1,-1,105000,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(3,'Broadsword','','rhand','false',1590,1,1,'steel','none',11,10,'sword',8,0.00000,0,0,0,379,0,9,-1,-1,9600,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(4,'Club','','rhand','false',1870,1,1,'wood','none',8,20,'blunt',4,4.00000,0,0,0,379,0,6,-1,-1,590,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(5,'Mace','','rhand','false',1880,1,1,'steel','none',11,20,'blunt',4,4.00000,0,0,0,379,0,9,-1,-1,9600,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(6,'Apprentice\'s Wand','','rhand','false',1350,1,1,'steel','none',5,20,'blunt',4,4.00000,0,0,0,379,0,7,-1,-1,106,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(7,'Apprentice\'s Rod','','rhand','false',1330,1,1,'wood','none',6,20,'blunt',4,4.00000,0,0,0,379,0,8,-1,-1,590,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(8,'Willow Staff','','lrhand','false',1080,1,1,'wood','none',11,20,'bigblunt',4,4.00000,0,0,0,325,0,13,-1,-1,9600,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(9,'Cedar Staff','','lrhand','false',1090,2,2,'wood','none',16,20,'bigblunt',4,4.00000,0,0,0,325,0,18,-1,-1,41600,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(10,'Dagger','','rhand','false',1160,1,1,'steel','none',5,5,'dagger',12,-3.00000,0,0,0,433,0,5,-1,-1,106,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11,'Bone Dagger','','rhand','false',1150,1,1,'bone','none',7,5,'dagger',12,-3.00000,0,0,0,433,0,6,-1,-1,590,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(12,'Knife','','rhand','false',1140,1,1,'bronze','none',10,5,'dagger',12,-3.00000,0,0,0,433,0,9,-1,-1,9600,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(13,'Short Bow','','lrhand','false',1950,1,1,'wood','none',16,5,'bow',12,-3.00000,0,0,0,293,1,6,-1,-1,590,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(14,'Bow','','lrhand','false',1930,1,1,'wood','none',23,5,'bow',12,-3.00000,0,0,0,293,1,9,-1,-1,9600,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(15,'Short Spear','','lrhand','false',2140,2,2,'steel','none',24,10,'pole',8,-3.00000,0,0,0,325,0,17,-1,-1,105000,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3599-1;'),
(16,'Great Spear','','lrhand','false',2120,2,2,'bronze','none',31,10,'pole',8,-3.00000,0,0,0,325,0,21,-1,-1,188000,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3599-1;'),
(18,'Leather Shield','','lhand','false',1430,0,0,'leather','none',0,0,'none',0,0.00000,-8,47,20,0,0,0,-1,-1,30,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(19,'Small Shield','','lhand','false',1420,0,0,'steel','none',0,0,'none',0,0.00000,-8,56,20,0,0,0,-1,-1,490,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(20,'Buckler','','lhand','false',1410,0,0,'wood','none',0,0,'none',0,0.00000,-8,67,20,0,0,0,-1,-1,2140,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(52,'Vesper Dual Sword','','lrhand','true',1520,1,1,'fine_steel','s84',482,10,'dual',8,0.00000,0,0,0,325,0,176,-1,-1,146873000,7050,'true','true','true','true','true',3411,1,0,0,0,0,0,0,0,'0-0;'),
(66,'Gladius','','rhand','false',1570,2,2,'steel','none',17,10,'sword',8,0.00000,0,0,0,379,0,12,-1,-1,41600,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(67,'Orcish Sword','','rhand','false',1570,2,2,'steel','none',17,10,'sword',8,0.00000,0,0,0,379,0,12,-1,-1,41600,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(68,'Falchion','','rhand','false',1530,2,2,'bronze','none',31,10,'sword',8,0.00000,0,0,0,379,0,21,-1,-1,188000,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(69,'Bastard Sword','','rhand','true',1510,2,2,'fine_steel','d',51,10,'sword',8,0.00000,0,0,0,379,0,32,-1,-1,495500,915,'true','true','true','true','true',0,0,0,0,0,0,0,0,9213,'0-0;'),
(70,'Claymore','','lrhand','true',2090,3,3,'fine_steel','d',112,10,'bigsword',8,0.00000,0,0,0,325,0,54,-1,-1,1387000,2561,'true','true','true','true','true',0,0,0,0,0,0,0,0,9226,'0-0;'),
(71,'Flamberge','','lrhand','true',2010,2,2,'bronze','c',130,10,'bigsword',8,0.00000,0,0,0,325,0,61,-1,-1,1762900,705,'true','true','true','true','true',0,0,0,0,0,0,0,0,9232,'0-0;'),
(72,'Stormbringer','','rhand','true',1430,2,2,'fine_steel','c',107,10,'sword',8,0.00000,0,0,0,379,0,61,-1,-1,1762900,705,'true','true','true','true','true',0,0,0,0,0,0,0,0,9228,'0-0;'),
(73,'Shamshir','','rhand','true',1420,2,2,'fine_steel','c',122,10,'sword',8,0.00000,0,0,0,379,0,68,-1,-1,2209700,884,'true','true','true','true','true',0,0,0,0,0,0,0,0,9240,'0-0;'),
(74,'Katana','','rhand','true',1420,2,2,'fine_steel','c',122,10,'sword',8,0.00000,0,0,0,379,0,68,-1,-1,2209700,884,'true','true','true','true','true',0,0,0,0,0,0,0,0,9244,'0-0;'),
(75,'Caliburs','','rhand','true',1400,3,3,'oriharukon','c',139,10,'sword',8,0.00000,0,0,0,379,0,76,-1,-1,3304300,1322,'true','true','true','true','true',0,0,0,0,0,0,0,0,9264,'0-0;'),
(76,'Sword of Delusion','','rhand','true',1400,3,3,'mithril','c',139,10,'sword',8,0.00000,0,0,0,379,0,76,-1,-1,3304300,1322,'true','true','true','true','true',0,0,0,0,0,0,0,0,9268,'0-0;'),
(77,'Tsurugi','','rhand','true',1400,3,3,'fine_steel','c',139,10,'sword',8,0.00000,0,0,0,379,0,76,-1,-1,3304300,1322,'true','true','true','true','true',0,0,0,0,0,0,0,0,9272,'0-0;'),
(78,'Great Sword','','lrhand','true',1930,1,1,'steel','b',213,10,'bigsword',8,0.00000,0,0,0,325,0,91,-1,-1,6680500,891,'true','true','true','true','true',0,0,0,0,0,0,0,0,9308,'0-0;'),
(79,'Sword of Damascus','','rhand','true',1350,1,1,'damascus','b',194,10,'sword',8,0.00000,0,0,0,379,0,99,-1,-1,10091400,1346,'true','true','true','true','true',0,0,0,0,0,0,0,0,9316,'0-0;'),
(80,'Tallum Blade','','rhand','true',1330,1,1,'adamantaite','a',213,10,'sword',8,0.00000,0,0,0,379,0,107,-1,-1,14098000,1128,'true','true','true','true','true',0,0,0,0,0,0,0,0,9328,'0-0;'),
(81,'Dragon Slayer','','lrhand','true',1840,1,1,'bone','a',282,10,'bigsword',8,0.00000,0,0,0,325,0,114,-1,-1,20741000,1659,'true','true','true','true','true',0,0,0,0,0,0,0,0,9344,'0-0;'),
(82,'God\'s Blade','','rhand','true',1300,1,1,'adamantaite','s',257,10,'sword',8,0.00000,0,0,0,379,0,124,-1,-1,38000000,1900,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(83,'Sword of Magic','','rhand','true',970,2,2,'bronze','d',43,10,'sword',8,0.00000,0,0,0,379,0,45,-1,-1,550800,1017,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(84,'Homunkulus\'s Sword','','rhand','true',950,3,3,'blood_steel','c',111,10,'sword',8,0.00000,0,0,0,379,0,101,-1,-1,3304300,1322,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(85,'Phantom Sword','','rhand','true',860,1,1,'oriharukon','a',170,10,'sword',8,0.00000,0,0,0,379,0,143,-1,-1,18300000,1464,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(86,'Tomahawk','','rhand','true',1780,2,2,'bronze','d',51,20,'blunt',4,4.00000,0,0,0,379,0,32,-1,-1,495500,915,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(87,'Iron Hammer','','rhand','false',1850,2,2,'steel','none',31,20,'blunt',4,4.00000,0,0,0,379,0,21,-1,-1,188000,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(88,'Morning Star','','rhand','true',1720,3,3,'steel','d',79,20,'blunt',4,4.00000,0,0,0,379,0,47,-1,-1,1074000,1983,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(89,'Big Hammer','','rhand','true',1710,2,2,'fine_steel','c',107,20,'blunt',4,4.00000,0,0,0,379,0,61,-1,-1,1762900,705,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(90,'Goat Head Staff','','lrhand','true',1000,3,3,'wood','d',77,20,'bigblunt',4,4.00000,0,0,0,325,0,69,-1,-1,1074000,1983,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(91,'Heavy War Axe','','rhand','true',1620,1,1,'fine_steel','b',175,20,'blunt',4,4.00000,0,0,0,379,0,91,-1,-1,6680500,891,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(92,'Sprite\'s Staff','','lrhand','true',960,1,1,'wood','b',170,20,'bigblunt',4,4.00000,0,0,0,325,0,134,-1,-1,6680500,891,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(93,'Winged Spear','','lrhand','true',2060,3,3,'fine_steel','d',79,10,'pole',8,-3.00000,0,0,0,325,0,47,-1,-1,1074000,1983,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3599-1;'),
(94,'Bec de Corbin','','lrhand','true',2020,2,2,'fine_steel','c',122,10,'pole',8,-3.00000,0,0,0,325,0,68,-1,-1,2209700,884,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3599-1;'),
(95,'Poleaxe','','lrhand','true',2010,3,3,'bronze','c',139,10,'pole',8,-3.00000,0,0,0,325,0,76,-1,-1,3304300,1322,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3599-1;'),
(96,'Scythe','','lrhand','true',2040,2,2,'fine_steel','c',107,10,'pole',8,-3.00000,0,0,0,325,0,61,-1,-1,1762900,705,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3599-1;'),
(97,'Lance','','lrhand','true',1920,1,1,'blood_steel','b',194,10,'pole',8,-3.00000,0,0,0,325,0,99,-1,-1,10091400,1346,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3599-1;'),
(98,'Halberd','','lrhand','true',1900,1,1,'oriharukon','a',213,10,'pole',8,-3.00000,0,0,0,325,0,107,-1,-1,14098000,1128,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3599-1;'),
(99,'Apprentice\'s Spellbook','','rhand','false',650,1,1,'paper','none',9,10,'etc',8,0.00000,0,0,0,379,0,12,-1,-1,9600,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(100,'Voodoo Doll','','rhand','false',630,2,2,'wood','none',25,10,'etc',8,0.00000,0,0,0,379,0,28,-1,-1,188000,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(101,'Scroll of Wisdom','','rhand','true',610,2,2,'paper','d',32,10,'etc',8,0.00000,0,0,0,379,0,35,-1,-1,315000,582,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(102,'Round Shield','','lhand','false',1390,0,0,'steel','none',0,0,'none',0,0.00000,-8,79,20,0,0,0,-1,-1,5470,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(103,'Tower Shield','','lhand','true',1240,0,0,'fine_steel','c',0,0,'none',0,0.00000,-8,190,20,0,0,0,-1,-1,198300,79,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(104,'Shield of Victory','','lhand','true',6400,0,0,'oriharukon','b',0,0,'none',0,0.00000,-8,216,20,0,0,0,-1,-1,419000,72,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(105,'Implosion Shield','','lhand','true',4800,0,0,'damascus','b',0,0,'none',0,0.00000,-8,216,20,0,0,0,-1,-1,419000,72,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(106,'Dark Dragon Shield','','lhand','true',4800,0,0,'damascus','b',0,0,'none',0,0.00000,-8,230,20,0,0,0,-1,-1,649800,112,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(107,'Composite Shield','','lhand','true',1230,0,0,'fine_steel','c',0,0,'none',0,0.00000,-8,190,20,0,0,0,-1,-1,198300,79,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(108,'Masterpiece Shield','','lhand','true',5600,0,0,'oriharukon','b',0,0,'none',0,0.00000,-8,230,20,0,0,0,-1,-1,649800,112,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(109,'Shield of Solar Eclipse','','lhand','true',4800,0,0,'blood_steel','b',0,0,'none',0,0.00000,-8,216,20,0,0,0,-1,-1,419000,72,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(110,'Doom Shield','','lhand','true',1200,0,0,'fine_steel','b',0,0,'none',0,0.00000,-8,230,20,0,0,0,-1,-1,649800,87,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(111,'Shield of Pledge','','lhand','true',4800,0,0,'fine_steel','b',0,0,'none',0,0.00000,-8,216,20,0,0,0,-1,-1,419000,72,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(120,'Sword of Reflection','','rhand','false',1550,2,2,'bronze','none',24,10,'sword',8,0.00000,0,0,0,379,0,17,-1,-1,105000,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(121,'Sword of Watershadow','','rhand','false',1540,2,2,'bronze','none',24,10,'sword',8,0.00000,0,0,0,379,0,17,-1,-1,105000,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(122,'Handmade Sword','','rhand','false',1570,2,2,'bronze','none',17,10,'sword',8,0.00000,0,0,0,379,0,12,-1,-1,41600,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(123,'Saber','','rhand','true',1520,2,2,'steel','d',40,10,'sword',8,0.00000,0,0,0,379,0,26,-1,-1,315000,582,'true','true','true','true','true',0,0,0,0,0,0,0,0,9216,'0-0;'),
(124,'Two-Handed Sword','','lrhand','true',2180,2,2,'fine_steel','d',78,10,'bigsword',8,0.00000,0,0,0,325,0,39,-1,-1,743500,1373,'true','true','true','true','true',0,0,0,0,0,0,0,0,9220,'0-0;'),
(125,'Spinebone Sword','','rhand','true',1510,2,2,'bone','d',51,10,'sword',8,0.00000,0,0,0,379,0,32,-1,-1,495500,915,'true','true','true','true','true',0,0,0,0,0,0,0,0,9214,'0-0;'),
(126,'Artisan\'s Sword','','rhand','true',1500,2,2,'steel','d',51,10,'sword',8,0.00000,0,0,0,379,0,32,-1,-1,495500,915,'true','true','true','true','true',0,0,0,0,0,0,0,0,9215,'0-0;'),
(127,'Crimson Sword','','rhand','true',1490,2,2,'fine_steel','d',64,10,'sword',8,0.00000,0,0,0,379,0,39,-1,-1,743500,1373,'true','true','true','true','true',0,0,0,0,0,0,0,0,9218,'0-0;'),
(128,'Knight\'s Sword','','rhand','true',1500,2,2,'steel','d',51,10,'sword',8,0.00000,0,0,0,379,0,32,-1,-1,495500,915,'true','true','true','true','true',0,0,0,0,0,0,0,0,10003,'0-0;'),
(129,'Sword of Revolution','','rhand','true',1450,3,3,'fine_steel','d',79,10,'sword',8,0.00000,0,0,0,379,0,47,-1,-1,1074000,1983,'true','true','true','true','true',0,0,0,0,0,0,0,0,9222,'0-0;'),
(130,'Elven Sword','','rhand','true',1470,2,2,'mithril','d',64,10,'sword',8,0.00000,0,0,0,379,0,39,-1,-1,743500,1373,'true','true','true','true','true',0,0,0,0,0,0,0,0,9219,'0-0;'),
(131,'Spirit Sword','','rhand','true',1420,2,2,'fine_steel','c',122,10,'sword',8,0.00000,0,0,0,379,0,68,-1,-1,2209700,884,'true','true','true','true','true',0,0,0,0,0,0,0,0,9248,'0-0;'),
(132,'Sword of Limit','','rhand','true',1400,3,3,'fine_steel','c',139,10,'sword',8,0.00000,0,0,0,379,0,76,-1,-1,3304300,1322,'true','true','true','true','true',0,0,0,0,0,0,0,0,9280,'0-0;'),
(133,'Raid Sword','','rhand','true',1420,2,2,'fine_steel','c',122,10,'sword',8,0.00000,0,0,0,379,0,68,-1,-1,2209700,884,'true','true','true','true','true',0,0,0,0,0,0,0,0,9252,'0-0;'),
(134,'Sword of Nightmare','','rhand','true',1400,3,3,'blood_steel','c',139,10,'sword',8,0.00000,0,0,0,379,0,76,-1,-1,3304300,1322,'true','true','true','true','true',0,0,0,0,0,0,0,0,9276,'0-0;'),
(135,'Samurai Longsword','','rhand','true',1380,3,3,'oriharukon','c',156,10,'sword',8,0.00000,0,0,0,379,0,83,-1,-1,4713500,1885,'true','true','true','true','true',0,0,0,0,0,0,0,0,9292,'0-0;'),
(142,'Keshanberk','','rhand','true',1370,1,1,'oriharukon','b',175,10,'sword',8,0.00000,0,0,0,379,0,91,-1,-1,6680500,891,'true','true','true','true','true',0,0,0,0,0,0,0,0,9304,'0-0;'),
(143,'Sword of Mystic','','rhand','true',980,2,2,'fine_steel','d',43,10,'sword',8,0.00000,0,0,0,379,0,45,-1,-1,550800,1017,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(144,'Sword of Occult','','rhand','true',970,2,2,'fine_steel','d',43,10,'sword',8,0.00000,0,0,0,379,0,45,-1,-1,550800,1017,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(145,'Sword of Whispering Death','','rhand','true',920,3,3,'fine_steel','c',111,10,'sword',8,0.00000,0,0,0,379,0,101,-1,-1,3304300,1322,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(146,'Ghoulbane','','rhand','true',910,1,1,'damascus','b',140,10,'sword',8,0.00000,0,0,0,379,0,122,-1,-1,8680000,1157,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(147,'Tear of Darkness','','rhand','true',830,1,1,'blood_steel','a',170,10,'sword',8,0.00000,0,0,0,379,0,143,-1,-1,18300000,1464,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(148,'Sword of Valhalla','','rhand','true',900,1,1,'oriharukon','b',140,10,'sword',8,0.00000,0,0,0,379,0,122,-1,-1,6680500,891,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(149,'Sword of Life','','rhand','true',840,1,1,'mithril','a',170,10,'sword',8,0.00000,0,0,0,379,0,143,-1,-1,18300000,1464,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(150,'Elemental Sword','','rhand','true',830,1,1,'mithril','a',170,10,'sword',8,0.00000,0,0,0,379,0,143,-1,-1,14098000,1128,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(151,'Sword of Miracles','','rhand','true',840,1,1,'adamantaite','a',186,10,'sword',8,0.00000,0,0,0,379,0,152,-1,-1,20741000,1659,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(152,'Heavy Chisel','','rhand','false',1890,1,1,'steel','none',10,20,'blunt',4,4.00000,0,0,0,379,0,8,-1,-1,6200,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(153,'Sickle','','rhand','false',1850,1,1,'steel','none',12,20,'blunt',4,4.00000,0,0,0,379,0,9,-1,-1,14200,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(154,'Dwarven Mace','','rhand','false',1860,2,2,'bronze','none',17,20,'blunt',4,4.00000,0,0,0,379,0,12,-1,-1,41600,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(155,'Flanged Mace','','rhand','false',1800,2,2,'steel','none',31,20,'blunt',4,4.00000,0,0,0,379,0,21,-1,-1,188000,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(156,'Hand Axe','','rhand','true',1820,2,2,'steel','d',40,20,'blunt',4,4.00000,0,0,0,379,0,26,-1,-1,315000,582,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(157,'Spiked Club','','rhand','true',1750,2,2,'steel','d',64,20,'blunt',4,4.00000,0,0,0,379,0,39,-1,-1,743500,1373,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(158,'Tarbar','','rhand','true',1730,3,3,'fine_steel','d',79,20,'blunt',4,4.00000,0,0,0,379,0,47,-1,-1,1074000,1983,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(159,'Bonebreaker','','rhand','true',1720,3,3,'fine_steel','d',92,20,'blunt',4,4.00000,0,0,0,379,0,54,-1,-1,1387000,2561,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(160,'Battle Axe','','rhand','true',1720,2,2,'fine_steel','c',107,20,'blunt',4,4.00000,0,0,0,379,0,61,-1,-1,1762900,705,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(161,'Silver Axe','','rhand','true',1690,2,2,'fine_steel','c',107,20,'blunt',4,4.00000,0,0,0,379,0,61,-1,-1,1762900,705,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(162,'War Axe','','rhand','true',1660,3,3,'fine_steel','c',139,20,'blunt',4,4.00000,0,0,0,379,0,76,-1,-1,3304300,1322,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(164,'Elysian','','rhand','true',1580,1,1,'oriharukon','a',232,20,'blunt',4,4.00000,0,0,0,379,0,114,-1,-1,20741000,1659,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(165,'Yablonski\'s Hammer','','rhand','true',1570,1,1,'adamantaite','s',251,20,'blunt',4,4.00000,0,0,0,379,0,121,-1,-1,35300000,1765,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(166,'Heavy Mace','','rhand','true',1800,2,2,'steel','d',40,20,'blunt',4,4.00000,0,0,0,379,0,26,-1,-1,315000,582,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(167,'Scalpel','','rhand','true',1810,2,2,'steel','d',40,20,'blunt',4,4.00000,0,0,0,379,0,26,-1,-1,315000,582,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(168,'Work Hammer','','rhand','true',1790,2,2,'steel','d',40,20,'blunt',4,4.00000,0,0,0,379,0,26,-1,-1,315000,582,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(169,'Skull Breaker','','rhand','true',1740,3,3,'fine_steel','d',79,20,'blunt',4,4.00000,0,0,0,379,0,47,-1,-1,1074000,1983,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(171,'Deadman\'s Glory','','rhand','true',1600,1,1,'bone','b',194,20,'blunt',4,4.00000,0,0,0,379,0,99,-1,-1,10091400,1346,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(172,'Heavy Bone Club','','rhand','true',1730,3,3,'bone','d',79,20,'blunt',4,4.00000,0,0,0,379,0,47,-1,-1,1074000,1983,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(173,'Skull Graver','','rhand','true',1640,2,2,'fine_steel','c',107,20,'blunt',4,4.00000,0,0,0,379,0,61,-1,-1,1762900,705,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(174,'Nirvana Axe','','rhand','true',1150,3,3,'fine_steel','c',111,20,'blunt',4,4.00000,0,0,0,379,0,101,-1,-1,3304300,1322,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(175,'Art of Battle Axe','','rhand','true',1570,1,1,'chrysolite','b',194,20,'blunt',4,4.00000,0,0,0,379,0,99,-1,-1,10091400,1346,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(176,'Journeyman\'s Staff','','lrhand','false',1070,2,2,'wood','none',23,20,'bigblunt',4,4.00000,0,0,0,325,0,24,-1,-1,105000,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(177,'Mage Staff','','lrhand','false',1050,2,2,'wood','none',30,20,'bigblunt',4,4.00000,0,0,0,325,0,31,-1,-1,188000,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(178,'Bone Staff','','lrhand','true',1060,2,2,'bone','d',39,20,'bigblunt',4,4.00000,0,0,0,325,0,39,-1,-1,315000,582,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(179,'Mace of Prayer','','rhand','true',1300,2,2,'steel','d',41,20,'blunt',4,4.00000,0,0,0,379,0,43,-1,-1,495500,915,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(180,'Mace of Judgment','','rhand','true',1280,2,2,'steel','d',41,20,'blunt',4,4.00000,0,0,0,379,0,43,-1,-1,495500,915,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(181,'Mace of Miracle','','rhand','true',1250,2,2,'steel','d',41,20,'blunt',4,4.00000,0,0,0,379,0,43,-1,-1,495500,915,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(182,'Doom Hammer','','rhand','true',1200,2,2,'steel','d',41,20,'blunt',4,4.00000,0,0,0,379,0,43,-1,-1,495500,915,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(183,'Mystic Staff','','lrhand','true',1040,2,2,'wood','d',50,20,'bigblunt',4,4.00000,0,0,0,325,0,47,-1,-1,495500,915,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(184,'Conjuror\'s Staff','','lrhand','true',1030,2,2,'oriharukon','d',50,20,'bigblunt',4,4.00000,0,0,0,325,0,47,-1,-1,495500,915,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(185,'Staff of Mana','','lrhand','true',1040,2,2,'wood','d',50,20,'bigblunt',4,4.00000,0,0,0,325,0,47,-1,-1,495500,915,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(186,'Staff of Magic','','lrhand','true',1020,2,2,'wood','d',62,20,'bigblunt',4,4.00000,0,0,0,325,0,57,-1,-1,743500,1373,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(187,'Atuba Hammer','','lrhand','true',1010,3,3,'fine_steel','d',90,20,'bigblunt',4,4.00000,0,0,0,325,0,79,-1,-1,1387000,2561,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(188,'Ghost Staff','','lrhand','true',1000,3,3,'wood','d',90,20,'bigblunt',4,4.00000,0,0,0,325,0,79,-1,-1,1387000,2561,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(189,'Staff of Life','','rhand','true',1180,3,3,'wood','d',74,20,'blunt',4,4.00000,0,0,0,379,0,72,-1,-1,1387000,2561,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(190,'Atuba Mace','','lrhand','true',1010,3,3,'fine_steel','d',90,20,'bigblunt',4,4.00000,0,0,0,325,0,79,-1,-1,1387000,2561,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(191,'Heavy Doom Hammer','','lrhand','true',1020,2,2,'fine_steel','c',103,20,'bigblunt',4,4.00000,0,0,0,325,0,89,-1,-1,1762900,705,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(192,'Crystal Staff','','lrhand','true',1020,2,2,'crystal','c',103,20,'bigblunt',4,4.00000,0,0,0,325,0,89,-1,-1,1762900,705,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(193,'Stick of Faith','','rhand','true',1160,2,2,'wood','c',85,20,'blunt',4,4.00000,0,0,0,379,0,81,-1,-1,1762900,705,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(194,'Heavy Doom Axe','','lrhand','true',1010,2,2,'fine_steel','c',103,20,'bigblunt',4,4.00000,0,0,0,325,0,89,-1,-1,1762900,705,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(195,'Cursed Staff','','lrhand','true',1000,2,2,'wood','c',119,20,'bigblunt',4,4.00000,0,0,0,325,0,100,-1,-1,2209700,884,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(196,'Stick of Eternity','','rhand','true',1130,3,3,'wood','c',111,20,'blunt',4,4.00000,0,0,0,379,0,101,-1,-1,3304300,1322,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(197,'Paradia Staff','','lrhand','true',1010,3,3,'wood','c',135,20,'bigblunt',4,4.00000,0,0,0,325,0,111,-1,-1,3304300,1322,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(198,'Inferno Staff','','lrhand','true',1000,3,3,'wood','c',135,20,'bigblunt',4,4.00000,0,0,0,325,0,111,-1,-1,3304300,1322,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(199,'Pa\'agrian Hammer','','lrhand','true',1010,3,3,'blood_steel','c',135,20,'bigblunt',4,4.00000,0,0,0,325,0,111,-1,-1,3304300,1322,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(200,'Sage\'s Staff','','lrhand','true',1000,3,3,'wood','c',135,20,'bigblunt',4,4.00000,0,0,0,325,0,111,-1,-1,3304300,1322,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(201,'Club of Nature','','rhand','true',1100,3,3,'wood','c',111,20,'blunt',4,4.00000,0,0,0,379,0,101,-1,-1,3304300,1322,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(202,'Mace of the Underworld','','rhand','true',1090,3,3,'fine_steel','c',111,20,'blunt',4,4.00000,0,0,0,379,0,101,-1,-1,3304300,1322,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(203,'Pa\'agrian Axe','','lrhand','true',990,3,3,'blood_steel','c',141,20,'bigblunt',4,4.00000,0,0,0,325,0,114,-1,-1,3677700,1471,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(204,'Deadman\'s Staff','','lrhand','true',1010,3,3,'bone','c',152,20,'bigblunt',4,4.00000,0,0,0,325,0,122,-1,-1,4713500,1885,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(205,'Ghoul\'s Staff','','lrhand','true',1000,3,3,'bone','c',152,20,'bigblunt',4,4.00000,0,0,0,325,0,122,-1,-1,4713500,1885,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(206,'Demon\'s Staff','','lrhand','true',990,3,3,'wood','c',152,20,'bigblunt',4,4.00000,0,0,0,325,0,122,-1,-1,4713500,1885,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(207,'Staff of Phantom','','lrhand','true',980,1,1,'oriharukon','b',170,20,'bigblunt',4,4.00000,0,0,0,325,0,122,-1,-1,8680000,1157,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(208,'Staff of Seal','','lrhand','true',970,1,1,'wood','b',170,20,'bigblunt',4,4.00000,0,0,0,325,0,122,-1,-1,8680000,1157,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(209,'Divine Staff','','lrhand','true',960,1,1,'wood','b',189,20,'bigblunt',4,4.00000,0,0,0,325,0,132,-1,-1,13100000,1746,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(210,'Staff of Evil Spirits','','lrhand','true',930,1,1,'wood','b',189,20,'bigblunt',4,4.00000,0,0,0,325,0,145,-1,-1,10091400,1346,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(211,'Staff of Nobility','','lrhand','true',910,1,1,'wood','b',189,20,'bigblunt',4,4.00000,0,0,0,325,0,132,-1,-1,13100000,1746,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(212,'Dasparion\'s Staff','','lrhand','true',920,1,1,'adamantaite','a',207,20,'bigblunt',4,4.00000,0,0,0,325,0,157,-1,-1,14098000,1128,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(213,'Branch of the Mother Tree','','lrhand','true',900,1,1,'wood','a',226,20,'bigblunt',4,4.00000,0,0,0,325,0,167,-1,-1,20741000,1659,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(214,'The Staff','','lrhand','true',910,1,1,'wood','s',245,20,'bigblunt',4,4.00000,0,0,0,325,0,162,-1,-1,35300000,1765,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(215,'Doom Dagger','','rhand','false',1130,1,1,'steel','none',10,5,'dagger',12,-3.00000,0,0,0,433,0,9,-1,-1,9600,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(216,'Dirk','','rhand','false',1130,2,2,'steel','none',15,5,'dagger',12,-3.00000,0,0,0,433,0,12,-1,-1,41600,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(217,'Shining Knife','','rhand','false',1120,2,2,'mithril','none',21,5,'dagger',12,-3.00000,0,0,0,433,0,17,-1,-1,105000,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(218,'Throwing Knife','','rhand','false',1120,2,2,'fine_steel','none',21,5,'dagger',12,-3.00000,0,0,0,433,0,17,-1,-1,105000,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(219,'Sword Breaker','','rhand','false',1110,2,2,'steel','none',27,5,'dagger',12,-3.00000,0,0,0,433,0,21,-1,-1,188000,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(220,'Crafted Dagger','','rhand','true',1100,2,2,'chrysolite','d',35,5,'dagger',12,-3.00000,0,0,0,433,0,26,-1,-1,315000,582,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(221,'Assassin Knife','','rhand','true',1100,2,2,'steel','d',35,5,'dagger',12,-3.00000,0,0,0,433,0,26,-1,-1,315000,582,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(222,'Poniard Dagger','','rhand','true',1090,2,2,'steel','d',45,5,'dagger',12,-3.00000,0,0,0,433,0,32,-1,-1,495500,915,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(223,'Kukuri','','rhand','true',1080,2,2,'fine_steel','d',56,5,'dagger',12,-3.00000,0,0,0,433,0,39,-1,-1,743500,1373,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(224,'Maingauche','','rhand','true',1070,3,3,'fine_steel','d',69,5,'dagger',12,-3.00000,0,0,0,433,0,47,-1,-1,1074000,1983,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(225,'Mithril Dagger','','rhand','true',1060,3,3,'mithril','d',80,5,'dagger',12,-3.00000,0,0,0,433,0,54,-1,-1,1387000,2561,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(226,'Cursed Dagger','','rhand','true',1040,2,2,'mithril','c',94,5,'dagger',12,-3.00000,0,0,0,433,0,61,-1,-1,1762900,705,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(227,'Stiletto','','rhand','true',1030,2,2,'fine_steel','c',107,5,'dagger',12,-3.00000,0,0,0,433,0,68,-1,-1,2209700,884,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(228,'Crystal Dagger','','rhand','true',1000,3,3,'crystal','c',136,5,'dagger',12,-3.00000,0,0,0,433,0,83,-1,-1,4713500,1885,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(229,'Kris','','rhand','true',980,1,1,'mithril','b',153,5,'dagger',12,-3.00000,0,0,0,433,0,91,-1,-1,6680500,891,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(230,'Wolverine Needle','','rhand','true',1040,2,2,'fine_steel','c',94,5,'dagger',12,-3.00000,0,0,0,433,0,61,-1,-1,2290000,916,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(231,'Grace Dagger','','rhand','true',1020,3,3,'fine_steel','c',122,5,'dagger',12,-3.00000,0,0,0,433,0,76,-1,-1,3304300,1322,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(232,'Dark Elven Dagger','','rhand','true',1050,2,2,'fine_steel','c',94,5,'dagger',12,-3.00000,0,0,0,433,0,61,-1,-1,1762900,705,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(233,'Dark Screamer','','rhand','true',1010,3,3,'fine_steel','c',122,5,'dagger',12,-3.00000,0,0,0,433,0,76,-1,-1,3304300,1322,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(234,'Demon Dagger','','rhand','true',970,1,1,'blood_steel','b',170,5,'dagger',12,-3.00000,0,0,0,433,0,99,-1,-1,10091400,1346,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(235,'Bloody Orchid','','rhand','true',960,1,1,'blood_steel','a',186,5,'dagger',12,-3.00000,0,0,0,433,0,107,-1,-1,14098000,1128,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(236,'Soul Separator','','rhand','true',950,1,1,'oriharukon','a',203,5,'dagger',12,-3.00000,0,0,0,433,0,114,-1,-1,20741000,1659,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(237,'Dragon\'s Tooth','','rhand','true',950,1,1,'bone','s',220,5,'dagger',12,-3.00000,0,0,0,433,0,121,-1,-1,35300000,1765,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(238,'Dagger of Mana','','rhand','true',750,2,2,'fine_steel','d',45,5,'dagger',12,-3.00000,0,0,0,433,0,52,-1,-1,743500,1373,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(239,'Mystic Knife','','rhand','true',760,2,2,'fine_steel','d',45,5,'dagger',12,-3.00000,0,0,0,433,0,52,-1,-1,743500,1373,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(240,'Conjurer\'s Knife','','rhand','true',750,2,2,'fine_steel','d',45,5,'dagger',12,-3.00000,0,0,0,433,0,52,-1,-1,743500,1373,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(241,'Shilen Knife','','rhand','true',750,2,2,'bronze','d',45,5,'dagger',12,-3.00000,0,0,0,433,0,52,-1,-1,743500,1373,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(242,'Soulfire Dirk','','rhand','true',750,2,2,'fine_steel','c',86,5,'dagger',12,-3.00000,0,0,0,433,0,91,-1,-1,2209700,884,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(243,'Hell Knife','','rhand','true',740,1,1,'blood_steel','b',122,5,'dagger',12,-3.00000,0,0,0,433,0,122,-1,-1,6680500,891,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(244,'Elven Fighter Fist','','rhand','false',0,0,0,'leather','none',0,5,'fist',4,4.00000,0,0,0,325,0,0,-1,-1,22,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(245,'Dark Fighter Fist','','rhand','false',0,0,0,'leather','none',0,5,'fist',4,4.00000,0,0,0,325,0,0,-1,-1,33,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(246,'Human Fighter Fist','','rhand','false',0,0,0,'leather','none',0,5,'fist',4,4.00000,0,0,0,325,0,0,-1,-1,44,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(247,'Dwarven Fighter Fist','','rhand','false',0,0,0,'leather','none',0,5,'fist',4,4.00000,0,0,0,325,0,0,-1,-1,56,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(248,'Orc Fighter Fist','','rhand','false',0,0,0,'leather','none',0,5,'fist',4,4.00000,0,0,0,325,0,0,-1,-1,67,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(249,'Elven Mystic Fist','','rhand','false',0,0,0,'leather','none',0,5,'fist',4,4.00000,0,0,0,325,0,0,-1,-1,11,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(250,'Dark Mystic Fist','','rhand','false',0,0,0,'leather','none',0,5,'fist',4,4.00000,0,0,0,325,0,0,-1,-1,22,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(251,'Human Mystic Fist','','rhand','false',0,0,0,'leather','none',0,5,'fist',4,4.00000,0,0,0,325,0,0,-1,-1,33,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(252,'Orc Shaman Fist','','rhand','false',0,0,0,'leather','none',0,10,'fist',8,0.00000,0,0,0,379,0,0,-1,-1,44,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(253,'Spiked Gloves','','lrhand','false',1590,1,1,'leather','none',10,5,'dualfist',4,4.00000,0,0,0,325,0,6,-1,-1,590,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(254,'Iron Gloves','','lrhand','false',1580,1,1,'steel','none',13,5,'dualfist',4,4.00000,0,0,0,325,0,9,-1,-1,9600,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(255,'Fox Claw Gloves','','lrhand','false',1560,2,2,'steel','none',21,5,'dualfist',4,4.00000,0,0,0,325,0,12,-1,-1,41600,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(256,'Cestus','','lrhand','false',1570,2,2,'steel','none',29,5,'dualfist',4,4.00000,0,0,0,325,0,17,-1,-1,105000,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(257,'Viper Fang','','lrhand','false',1560,2,2,'steel','none',38,5,'dualfist',4,4.00000,0,0,0,325,0,21,-1,-1,188000,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(258,'Bagh-Nakh','','lrhand','true',1540,2,2,'steel','d',49,5,'dualfist',4,4.00000,0,0,0,325,0,26,-1,-1,315000,582,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(259,'Single-Edged Jamadhr','','lrhand','true',1550,2,2,'steel','d',62,5,'dualfist',4,4.00000,0,0,0,325,0,32,-1,-1,495500,915,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(260,'Triple-Edged Jamadhr','','lrhand','true',1540,2,2,'fine_steel','d',78,5,'dualfist',4,4.00000,0,0,0,325,0,39,-1,-1,743500,1373,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(261,'Bich\'Hwa','','lrhand','true',1510,3,3,'fine_steel','d',96,5,'dualfist',4,4.00000,0,0,0,325,0,47,-1,-1,1074000,1983,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(262,'Scallop Jamadhr','','lrhand','true',1520,3,3,'fine_steel','d',112,5,'dualfist',4,4.00000,0,0,0,325,0,54,-1,-1,1387000,2561,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(263,'Chakram','','lrhand','true',1490,2,2,'fine_steel','c',130,5,'dualfist',4,4.00000,0,0,0,325,0,61,-1,-1,1762900,705,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(264,'Pata','','lrhand','true',1440,1,1,'fine_steel','b',204,5,'dualfist',4,4.00000,0,0,0,325,0,89,-1,-1,7830000,1044,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(265,'Fisted Blade','','lrhand','true',1480,3,3,'fine_steel','c',169,5,'dualfist',4,4.00000,0,0,0,325,0,76,-1,-1,3304300,1322,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(266,'Great Pata','','lrhand','true',1460,3,3,'chrysolite','c',190,5,'dualfist',4,4.00000,0,0,0,325,0,83,-1,-1,4713500,1885,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(267,'Arthro Nail','','lrhand','true',1420,1,1,'blood_steel','b',213,5,'dualfist',4,4.00000,0,0,0,325,0,91,-1,-1,6680500,891,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(268,'Bellion Cestus','','lrhand','true',1390,1,1,'mithril','b',236,5,'dualfist',4,4.00000,0,0,0,325,0,99,-1,-1,10091400,1346,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(269,'Blood Tornado','','lrhand','true',1370,1,1,'blood_steel','a',259,5,'dualfist',4,4.00000,0,0,0,325,0,107,-1,-1,14098000,1128,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(270,'Dragon Grinder','','lrhand','true',1350,1,1,'adamantaite','a',282,5,'dualfist',4,4.00000,0,0,0,325,0,114,-1,-1,20741000,1659,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(271,'Hunting Bow','','lrhand','false',1910,6,2,'wood','none',34,5,'bow',12,-3.00000,0,0,0,293,2,12,-1,-1,41600,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(272,'Forest Bow','','lrhand','false',1900,7,2,'wood','none',49,5,'bow',12,-3.00000,0,0,0,293,3,17,-1,-1,105000,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(273,'Composite Bow','','lrhand','false',1880,7,2,'steel','none',64,5,'bow',12,-3.00000,0,0,0,293,3,21,-1,-1,188000,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(274,'Strengthened Bow','','lrhand','true',1870,6,2,'steel','d',82,5,'bow',12,-3.00000,0,0,0,293,3,26,-1,-1,315000,582,'true','true','true','true','true',0,0,0,0,0,0,0,0,9212,'0-0;'),
(275,'Long Bow','','lrhand','true',1830,6,2,'steel','d',114,5,'bow',12,-3.00000,0,0,0,227,4,35,-1,-1,495500,915,'true','true','true','true','true',0,0,0,0,0,0,0,0,9217,'0-0;'),
(276,'Elven Bow','','lrhand','true',1850,6,2,'mithril','d',105,5,'bow',12,-3.00000,0,0,0,293,4,32,-1,-1,495500,915,'true','true','true','true','true',0,0,0,0,0,0,0,0,9995,'0-0;'),
(277,'Dark Elven Bow','','lrhand','true',1830,6,2,'steel','d',105,5,'bow',12,-3.00000,0,0,0,293,4,32,-1,-1,495500,915,'true','true','true','true','true',0,0,0,0,0,0,0,0,9996,'0-0;'),
(278,'Gastraphetes','','lrhand','true',1840,8,2,'fine_steel','d',132,5,'bow',12,-3.00000,0,0,0,293,4,39,-1,-1,743500,1373,'true','true','true','true','true',0,0,0,0,0,0,0,0,9221,'0-0;'),
(279,'Strengthened Long Bow','','lrhand','true',1820,10,3,'fine_steel','d',179,5,'bow',12,-3.00000,0,0,0,227,5,51,-1,-1,1074000,1983,'true','true','true','true','true',0,0,0,0,0,0,0,0,9224,'0-0;'),
(280,'Light Crossbow','','lrhand','true',1810,10,3,'fine_steel','d',191,5,'bow',12,-3.00000,0,0,0,293,6,54,-1,-1,1387000,2561,'true','true','true','true','true',0,0,0,0,0,0,0,0,9227,'0-0;'),
(281,'Crystallized Ice Bow','','lrhand','true',1790,8,2,'crystal','c',220,5,'bow',12,-3.00000,0,0,0,293,6,61,-1,-1,1762900,705,'true','true','true','true','true',0,0,0,0,0,0,0,0,9236,'0-0;'),
(282,'Elemental Bow','','lrhand','true',1770,8,2,'fine_steel','c',277,5,'bow',12,-3.00000,0,0,0,227,7,75,-1,-1,2209700,884,'true','true','true','true','true',0,0,0,0,0,0,0,0,9256,'0-0;'),
(283,'Akat Long Bow','','lrhand','true',1740,9,3,'horn','c',316,5,'bow',12,-3.00000,0,0,0,227,7,84,-1,-1,3304300,1322,'true','true','true','true','true',0,0,0,0,0,0,0,0,9288,'0-0;'),
(284,'Dark Elven Long Bow','','lrhand','true',1720,3,1,'oriharukon','b',397,5,'bow',12,-3.00000,0,0,0,227,8,100,-1,-1,6680500,891,'true','true','true','true','true',0,0,0,0,0,0,0,0,9312,'0-0;'),
(285,'Noble Elven Bow','','lrhand','true',1760,8,2,'mithril','c',252,5,'bow',12,-3.00000,0,0,0,293,7,68,-1,-1,2209700,884,'true','true','true','true','true',0,0,0,0,0,0,0,0,9260,'0-0;'),
(286,'Eminence Bow','','lrhand','true',1720,10,3,'chrysolite','c',323,5,'bow',12,-3.00000,0,0,0,293,8,83,-1,-1,4713500,1885,'true','true','true','true','true',0,0,0,0,0,0,0,0,9300,'0-0;'),
(287,'Bow of Peril','','lrhand','true',1700,3,1,'blood_steel','b',400,5,'bow',12,-3.00000,0,0,0,293,9,99,-1,-1,10091400,1346,'true','true','true','true','true',0,0,0,0,0,0,0,0,9324,'0-0;'),
(288,'Carnage Bow','','lrhand','true',1670,2,1,'damascus','a',440,5,'bow',12,-3.00000,0,0,0,293,9,107,-1,-1,14098000,1128,'true','true','true','true','true',0,0,0,0,0,0,0,0,9336,'0-0;'),
(289,'Soul Bow','','lrhand','true',1660,2,1,'oriharukon','a',528,5,'bow',12,-3.00000,0,0,0,227,10,125,-1,-1,20741000,1659,'true','true','true','true','true',0,0,0,0,0,0,0,0,9348,'0-0;'),
(290,'The Bow','','lrhand','true',1650,1,1,'adamantaite','s',519,5,'bow',12,-3.00000,0,0,0,293,10,121,-1,-1,35300000,1765,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(291,'Trident','','lrhand','true',2100,2,2,'bronze','d',40,10,'pole',8,-3.00000,0,0,0,325,0,26,-1,-1,315000,582,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3599-1;'),
(292,'Pike','','lrhand','true',2090,2,2,'steel','d',51,10,'pole',8,-3.00000,0,0,0,325,0,32,-1,-1,495500,915,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3599-1;'),
(293,'War Hammer','','lrhand','true',2080,2,2,'fine_steel','d',64,10,'pole',8,-3.00000,0,0,0,325,0,39,-1,-1,743500,1373,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3599-1;'),
(294,'War Pick','','lrhand','true',2050,3,3,'fine_steel','d',79,10,'pole',8,-3.00000,0,0,0,325,0,47,-1,-1,1074000,1983,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3599-1;'),
(295,'Dwarven Trident','','lrhand','true',2090,2,2,'steel','d',51,10,'pole',8,-3.00000,0,0,0,325,0,32,-1,-1,495500,915,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3599-1;'),
(296,'Dwarven Pike','','lrhand','true',2070,2,2,'fine_steel','d',64,10,'pole',8,-3.00000,0,0,0,325,0,39,-1,-1,743500,1373,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3599-1;'),
(297,'Glaive','','lrhand','true',2050,3,3,'fine_steel','d',92,10,'pole',8,-3.00000,0,0,0,325,0,54,-1,-1,1387000,2561,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3599-1;'),
(298,'Orcish Glaive','','lrhand','true',2030,2,2,'fine_steel','c',107,10,'pole',8,-3.00000,0,0,0,325,0,61,-1,-1,1762900,705,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3599-1;'),
(299,'Orcish Poleaxe','','lrhand','true',1950,3,3,'blood_steel','c',156,10,'pole',8,-3.00000,0,0,0,325,0,83,-1,-1,4713500,1885,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3599-1;'),
(300,'Great Axe','','lrhand','true',1940,1,1,'damascus','b',175,10,'pole',8,-3.00000,0,0,0,325,0,91,-1,-1,6680500,891,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3599-1;'),
(301,'Scorpion','','lrhand','true',1990,3,3,'fine_steel','c',144,10,'pole',8,-3.00000,0,0,0,325,0,78,-1,-1,3677700,1471,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3599-1;'),
(302,'Body Slasher','','lrhand','true',2030,2,2,'fine_steel','c',107,10,'pole',8,-3.00000,0,0,0,325,0,61,-1,-1,1762900,705,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3599-1;'),
(303,'Widow Maker','','lrhand','true',1980,3,3,'fine_steel','c',144,10,'pole',8,-3.00000,0,0,0,325,0,78,-1,-1,3677700,1471,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3599-1;'),
(304,'Orcish Halberd','','lrhand','true',1880,1,1,'blood_steel','a',219,10,'pole',8,-3.00000,0,0,0,325,0,109,-1,-1,21300000,1704,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3599-1;'),
(305,'Tallum Glaive','','lrhand','true',1840,1,1,'chrysolite','a',232,10,'pole',8,-3.00000,0,0,0,325,0,114,-1,-1,20741000,1659,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3599-1;'),
(306,'Dragon Claw Axe','','lrhand','true',1820,1,1,'bone','s',251,10,'pole',8,-3.00000,0,0,0,325,0,121,-1,-1,35300000,1765,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3599-1;'),
(307,'Aurakyria Lance','','lrhand','true',1800,1,1,'adamantaite','s',269,10,'pole',8,-3.00000,0,0,0,325,0,128,-1,-1,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3599-1;'),
(308,'Buffalo\'s Horn','','rhand','false',660,1,1,'steel','none',6,10,'etc',8,0.00000,0,0,0,379,0,8,-1,-1,590,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(309,'Tears of Eva','','rhand','false',630,2,2,'steel','none',19,10,'etc',8,0.00000,0,0,0,379,0,22,-1,-1,105000,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(310,'Relic of the Saints','','rhand','false',610,2,2,'steel','none',19,10,'etc',8,0.00000,0,0,0,379,0,22,-1,-1,105000,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(311,'Crucifix of Blessing','','rhand','false',620,2,2,'steel','none',25,10,'etc',8,0.00000,0,0,0,379,0,28,-1,-1,188000,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(312,'Branch of Life','','rhand','true',620,2,2,'steel','d',32,10,'etc',8,0.00000,0,0,0,379,0,35,-1,-1,315000,582,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(313,'Temptation of Abyss','','rhand','true',610,2,2,'steel','d',32,10,'etc',8,0.00000,0,0,0,379,0,35,-1,-1,315000,582,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(314,'Proof of Revenge','','rhand','true',600,2,2,'steel','d',32,10,'etc',8,0.00000,0,0,0,379,0,35,-1,-1,315000,582,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(315,'Divine Tome','','rhand','true',570,2,2,'steel','d',41,10,'etc',8,0.00000,0,0,0,379,0,43,-1,-1,495500,915,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(316,'Blood of Saints','','rhand','true',580,2,2,'steel','d',51,10,'etc',8,0.00000,0,0,0,379,0,52,-1,-1,743500,1373,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(317,'Tome of Blood','','rhand','true',570,2,2,'steel','d',51,10,'etc',8,0.00000,0,0,0,379,0,52,-1,-1,743500,1373,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(318,'Crucifix of Blood','','rhand','true',540,3,3,'steel','d',63,10,'etc',8,0.00000,0,0,0,379,0,63,-1,-1,1074000,1983,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(319,'Eye of Infinity','','rhand','true',1600,3,3,'steel','d',63,10,'etc',8,0.00000,0,0,0,379,0,63,-1,-1,1400000,2545,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(320,'Blue Crystal Skull','','rhand','true',1600,3,3,'steel','d',67,10,'etc',8,0.00000,0,0,0,379,0,66,-1,-1,1520000,2763,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(321,'Demon Fangs','','rhand','true',1600,3,3,'steel','d',67,10,'etc',8,0.00000,0,0,0,379,0,66,-1,-1,1171900,2164,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(322,'Vajra Wands','','rhand','true',1600,3,3,'steel','d',74,10,'etc',8,0.00000,0,0,0,379,0,72,-1,-1,1800000,3272,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(323,'Ancient Reagent','','rhand','true',1600,3,3,'steel','d',74,10,'etc',8,0.00000,0,0,0,379,0,72,-1,-1,1800000,3272,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(324,'Tears of Fairy','','rhand','true',1600,2,2,'steel','c',98,10,'etc',8,0.00000,0,0,0,379,0,91,-1,-1,2870000,1148,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(325,'Horn of Glory','','rhand','true',540,2,2,'steel','c',98,10,'etc',8,0.00000,0,0,0,379,0,91,-1,-1,2209700,884,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(326,'Heathen\'s Book','','rhand','true',560,3,3,'steel','c',111,10,'etc',8,0.00000,0,0,0,379,0,101,-1,-1,3304300,1322,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(327,'Hex Doll','','rhand','true',1600,3,3,'steel','c',111,10,'etc',8,0.00000,0,0,0,379,0,101,-1,-1,4300000,1720,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(328,'Candle of Wisdom','','rhand','true',1600,3,3,'steel','c',125,10,'etc',8,0.00000,0,0,0,379,0,111,-1,-1,6130000,2452,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(329,'Blessed Branch','','rhand','true',800,3,3,'steel','c',125,10,'etc',8,0.00000,0,0,0,379,0,111,-1,-1,6130000,2452,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(330,'Phoenix Feather','','rhand','true',800,3,3,'steel','c',125,10,'etc',8,0.00000,0,0,0,379,0,111,-1,-1,6130000,2452,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(331,'Cerberus Eye','','rhand','true',1600,3,3,'steel','c',125,10,'etc',8,0.00000,0,0,0,379,0,111,-1,-1,6130000,2452,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(332,'Scroll of Destruction','','rhand','true',1600,3,3,'steel','c',125,10,'etc',8,0.00000,0,0,0,379,0,111,-1,-1,6130000,2452,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(333,'Claws of Black Dragon','','rhand','true',1600,3,3,'steel','c',125,10,'etc',8,0.00000,0,0,0,379,0,111,-1,-1,6130000,2452,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(334,'Three Eyed Crow\'s Feather','','rhand','true',1600,3,3,'steel','c',125,10,'etc',8,0.00000,0,0,0,379,0,111,-1,-1,6130000,2452,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(335,'Soul Crystal','','rhand','true',1600,1,1,'steel','b',155,10,'etc',8,0.00000,0,0,0,379,0,132,-1,-1,13100000,1746,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(336,'Scroll of Mana','','rhand','true',1600,1,1,'steel','b',170,10,'etc',8,0.00000,0,0,0,379,0,143,-1,-1,18300000,2440,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(337,'Scroll of Massacre','','rhand','true',1600,1,1,'steel','b',170,10,'etc',8,0.00000,0,0,0,379,0,143,-1,-1,18300000,2440,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(338,'Wyvern\'s Skull','','rhand','true',4800,1,1,'steel','b',170,10,'etc',8,0.00000,0,0,0,379,0,143,-1,-1,18300000,2440,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(339,'Blood Crystal','','rhand','true',1600,1,1,'steel','b',170,10,'etc',8,0.00000,0,0,0,379,0,143,-1,-1,18300000,2440,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(340,'Unicorn\'s Horn','','rhand','true',1600,1,1,'steel','b',170,10,'etc',8,0.00000,0,0,0,379,0,143,-1,-1,18300000,2440,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(341,'Forgotten Tome','','rhand','true',1600,1,1,'steel','a',186,10,'etc',8,0.00000,0,0,0,379,0,152,-1,-1,20741000,2160,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(342,'Enchanted Flute','','rhand','true',1600,1,1,'steel','a',186,10,'etc',8,0.00000,0,0,0,379,0,152,-1,-1,20741000,2160,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(343,'Headless Arrow','','rhand','true',1600,1,1,'steel','a',186,10,'etc',8,0.00000,0,0,0,379,0,152,-1,-1,20741000,2160,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(344,'Proof of Overlord','','rhand','true',1600,1,1,'steel','a',186,10,'etc',8,0.00000,0,0,0,379,0,152,-1,-1,20741000,2160,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(345,'Deathbringer Sword','','rhand','true',4800,1,1,'steel','a',186,10,'etc',8,0.00000,0,0,0,379,0,152,-1,-1,20741000,2160,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(346,'Tears of Fallen Angel','','rhand','true',1600,1,1,'steel','s',201,10,'etc',8,0.00000,0,0,0,379,0,162,-1,-1,35300000,1765,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(625,'Bone Shield','','lhand','false',1380,0,0,'bone','none',0,0,'none',0,0.00000,-8,90,20,0,0,0,-1,-1,9900,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(626,'Bronze Shield','','lhand','true',1370,0,0,'bronze','d',0,0,'none',0,0.00000,-8,101,20,0,0,0,-1,-1,16900,31,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(627,'Aspis','','lhand','true',1350,0,0,'steel','d',0,0,'none',0,0.00000,-8,114,20,0,0,0,-1,-1,26900,50,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(628,'Hoplon','','lhand','true',1340,0,0,'fine_steel','d',0,0,'none',0,0.00000,-8,128,20,0,0,0,-1,-1,41000,76,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(629,'Kite Shield','','lhand','true',1320,0,0,'fine_steel','d',0,0,'none',0,0.00000,-8,142,20,0,0,0,-1,-1,60300,111,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(630,'Square Shield','','lhand','true',1310,0,0,'fine_steel','d',0,0,'none',0,0.00000,-8,154,20,0,0,0,-1,-1,79000,146,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(631,'Eldarake','','lhand','true',1290,0,0,'fine_steel','c',0,0,'none',0,0.00000,-8,166,20,0,0,0,-1,-1,102000,41,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(632,'Knight\'s Shield','','lhand','true',1260,0,0,'fine_steel','c',0,0,'none',0,0.00000,-8,178,20,0,0,0,-1,-1,130100,52,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(633,'Zubei\'s Shield','','lhand','true',1210,0,0,'mithril','b',0,0,'none',0,0.00000,-8,216,20,0,0,0,-1,-1,419000,56,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(634,'Dragon Shield','','lhand','true',1170,0,0,'bone','s',0,0,'none',0,0.00000,-8,269,20,0,0,0,-1,-1,1949000,125,'true','false','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(635,'Wolf Shield','','lhand','true',640,0,0,'oriharukon','b',0,0,'none',0,0.00000,-8,216,20,0,0,0,-1,-1,419000,72,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(636,'Shining Dragon Shield','','lhand','true',720,0,0,'mithril','b',0,0,'none',0,0.00000,-8,230,20,0,0,0,-1,-1,649800,112,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(637,'Shield of Valor','','lhand','true',720,0,0,'blood_steel','b',0,0,'none',0,0.00000,-8,230,20,0,0,0,-1,-1,649800,112,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(638,'Glorious Shield','','lhand','true',800,0,0,'fine_steel','b',0,0,'none',0,0.00000,-8,216,20,0,0,0,-1,-1,419000,72,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(639,'Red Flame Shield','','lhand','true',960,0,0,'blood_steel','b',0,0,'none',0,0.00000,-8,230,20,0,0,0,-1,-1,649800,111,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(640,'Elven Crystal Shield','','lhand','true',720,0,0,'crystal','b',0,0,'none',0,0.00000,-8,216,20,0,0,0,-1,-1,419000,72,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(641,'Dark Crystal Shield','','lhand','true',1190,0,0,'crystal','a',0,0,'none',0,0.00000,-8,243,20,0,0,0,-1,-1,935000,75,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(642,'Elven Vagian Shield','','lhand','true',560,0,0,'mithril','b',0,0,'none',0,0.00000,-8,216,20,0,0,0,-1,-1,419000,72,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(643,'Dark Vagian Shield','','lhand','true',560,0,0,'mithril','b',0,0,'none',0,0.00000,-8,230,20,0,0,0,-1,-1,649800,112,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(644,'Hell Shield','','lhand','true',640,0,0,'blood_steel','b',0,0,'none',0,0.00000,-8,230,20,0,0,0,-1,-1,649800,112,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(645,'Art of Shield','','lhand','true',560,0,0,'chrysolite','b',0,0,'none',0,0.00000,-8,216,20,0,0,0,-1,-1,419000,72,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(646,'Shield of Silence','','lhand','true',640,0,0,'damascus','b',0,0,'none',0,0.00000,-8,216,20,0,0,0,-1,-1,419000,72,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(647,'Gust Shield','','lhand','true',720,0,0,'blood_steel','b',0,0,'none',0,0.00000,-8,230,20,0,0,0,-1,-1,649800,112,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(648,'Prairie Shield','','lhand','true',800,0,0,'chrysolite','b',0,0,'none',0,0.00000,-8,216,20,0,0,0,-1,-1,419000,72,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(649,'Shield of the Underworld','','lhand','true',880,0,0,'damascus','b',0,0,'none',0,0.00000,-8,230,20,0,0,0,-1,-1,649800,112,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(650,'Shield of Concentration','','lhand','true',960,0,0,'oriharukon','b',0,0,'none',0,0.00000,-8,216,20,0,0,0,-1,-1,419000,72,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(651,'Ace\'s Shield','','lhand','true',1040,0,0,'oriharukon','b',0,0,'none',0,0.00000,-8,230,20,0,0,0,-1,-1,649800,112,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(652,'Guardian\'s Shield','','lhand','true',1120,0,0,'mithril','b',0,0,'none',0,0.00000,-8,216,20,0,0,0,-1,-1,419000,72,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(653,'Marksman Shield','','lhand','true',1200,0,0,'leather','b',0,0,'none',0,0.00000,-8,230,20,0,0,0,-1,-1,649800,112,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(654,'Shield of Mana','','lhand','true',480,0,0,'mithril','b',0,0,'none',0,0.00000,-8,216,20,0,0,0,-1,-1,419000,72,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(655,'Sage\'s Shield','','lhand','true',560,0,0,'steel','b',0,0,'none',0,0.00000,-8,230,20,0,0,0,-1,-1,649800,112,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(656,'Paradia Shield','','lhand','true',480,0,0,'chrysolite','b',0,0,'none',0,0.00000,-8,216,20,0,0,0,-1,-1,419000,72,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(657,'Inferno Shield','','lhand','true',560,0,0,'blood_steel','b',0,0,'none',0,0.00000,-8,230,20,0,0,0,-1,-1,649800,112,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(658,'Shield of Black Ore','','lhand','true',560,0,0,'damascus','b',0,0,'none',0,0.00000,-8,230,20,0,0,0,-1,-1,649800,112,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(659,'Shield of Summoning','','lhand','true',480,0,0,'leather','b',0,0,'none',0,0.00000,-8,216,20,0,0,0,-1,-1,419000,72,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(660,'Otherworldly Shield','','lhand','true',560,0,0,'adamantaite','b',0,0,'none',0,0.00000,-8,230,20,0,0,0,-1,-1,649800,112,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(661,'Elemental Shield','','lhand','true',480,0,0,'mithril','b',0,0,'none',0,0.00000,-8,216,20,0,0,0,-1,-1,419000,72,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(662,'Shield of Phantom','','lhand','true',560,0,0,'oriharukon','b',0,0,'none',0,0.00000,-8,230,20,0,0,0,-1,-1,649800,112,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(663,'Shield of Grace','','lhand','true',480,0,0,'mithril','b',0,0,'none',0,0.00000,-8,216,20,0,0,0,-1,-1,419000,72,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(664,'Shield of Holy Spirit','','lhand','true',560,0,0,'chrysolite','b',0,0,'none',0,0.00000,-8,230,20,0,0,0,-1,-1,649800,112,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(665,'Phoenix Shield','','lhand','true',480,0,0,'blood_steel','b',0,0,'none',0,0.00000,-8,216,20,0,0,0,-1,-1,419000,72,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(666,'Cerberus Shield','','lhand','true',560,0,0,'damascus','b',0,0,'none',0,0.00000,-8,230,20,0,0,0,-1,-1,649800,112,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(667,'Shield of Aid','','lhand','true',480,0,0,'fine_steel','b',0,0,'none',0,0.00000,-8,216,20,0,0,0,-1,-1,419000,72,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(668,'Shield of Blessing','','lhand','true',560,0,0,'adamantaite','b',0,0,'none',0,0.00000,-8,230,20,0,0,0,-1,-1,649800,112,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(669,'Flame Shield','','lhand','true',480,0,0,'blood_steel','b',0,0,'none',0,0.00000,-8,216,20,0,0,0,-1,-1,419000,72,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(670,'Shield of Bravery','','lhand','true',560,0,0,'chrysolite','b',0,0,'none',0,0.00000,-8,230,20,0,0,0,-1,-1,649800,112,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(671,'Blood Shield','','lhand','true',480,0,0,'blood_steel','b',0,0,'none',0,0.00000,-8,216,20,0,0,0,-1,-1,419000,72,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(672,'Absolute Shield','','lhand','true',560,0,0,'mithril','b',0,0,'none',0,0.00000,-8,230,20,0,0,0,-1,-1,649800,112,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(673,'Avadon Shield','','lhand','true',1210,0,0,'damascus','b',0,0,'none',0,0.00000,-8,216,20,0,0,0,-1,-1,419000,56,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(674,'Divine Shield','','lhand','true',560,0,0,'adamantaite','b',0,0,'none',0,0.00000,-8,230,20,0,0,0,-1,-1,649800,112,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(738,'Sword of Solidarity','','rhand','false',1300,1,1,'bronze','none',12,10,'sword',8,0.00000,0,0,0,379,0,9,-1,-1,14200,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(743,'Sword of Sentinel','','rhand','false',1300,1,1,'steel','none',14,10,'sword',8,0.00000,0,0,0,379,0,11,-1,-1,33600,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(744,'Staff of Sentinel','','lrhand','false',1800,1,1,'wood','none',13,20,'bigblunt',4,4.00000,0,0,0,325,0,15,-1,-1,33600,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(747,'Wand of Adept','','rhand','false',1300,1,1,'wood','none',11,20,'blunt',4,4.00000,0,0,0,379,0,13,-1,-1,19500,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(748,'Gallint\'s Oak Wand','','lrhand','false',1350,1,1,'wood','none',10,20,'bigblunt',4,4.00000,0,0,0,325,0,11,-1,-1,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(749,'0','','lrhand','true',100,0,0,'wood','d',21,20,'bigblunt',4,4.00000,0,0,0,325,0,32,-1,-1,35800,5,'true','false','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(754,'Red Sunset Staff','','lrhand','false',1700,1,1,'wood','none',13,20,'bigblunt',4,4.00000,0,0,0,325,0,14,-1,-1,19500,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(945,'Skeleton Buckler','','lhand','false',1400,0,0,'wood','none',0,0,'none',0,0.00000,-8,69,20,0,0,0,-1,-1,3440,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(946,'Skeleton Dagger','','rhand','false',1100,2,2,'steel','none',16,5,'dagger',12,-3.00000,0,0,0,433,0,13,-1,-1,66600,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(975,'Blood Saber','','rhand','false',1450,1,1,'oriharukon','none',14,10,'sword',8,0.00000,0,0,0,379,0,11,-1,-1,25800,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(981,'Red Sunset Sword','','lrhand','false',1300,1,1,'steel','none',16,10,'bigsword',8,0.00000,0,0,0,325,0,10,-1,-1,19500,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(989,'Eldritch Dagger','','rhand','false',1130,1,1,'steel','none',11,5,'dagger',12,-3.00000,0,0,0,433,0,10,-1,-1,19500,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(1142,'Rusted Bronze Sword','','rhand','false',1400,2,2,'steel','none',18,10,'sword',8,0.00000,0,0,0,379,0,21,-1,-1,116000,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(1181,'Neti\'s Bow','','lrhand','false',1850,7,2,'wood','none',45,5,'bow',12,-3.00000,0,0,0,293,2,16,-1,-1,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(1182,'Neti\'s Dagger','','rhand','false',1000,2,2,'steel','none',19,5,'dagger',12,-3.00000,0,0,0,433,0,16,-1,-1,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(1213,'Guard\'s Bow','','lrhand','false',1800,7,2,'steel','none',49,5,'bow',12,-3.00000,0,0,0,293,3,17,-1,-1,105000,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(1295,'Long Sword','','rhand','false',200,2,2,'fine_steel','none',22,10,'sword',8,0.00000,0,0,0,379,0,6,-1,-1,66600,0,'false','true','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(1296,'Gladius','','rhand','false',300,2,2,'steel','none',22,10,'sword',8,0.00000,0,0,0,379,0,6,-1,-1,66600,0,'false','true','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(1297,'Bastard Sword','','rhand','false',400,2,2,'fine_steel','none',22,10,'sword',8,0.00000,0,0,0,379,0,6,-1,-1,66600,0,'false','true','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(1298,'Caliburs','','rhand','false',500,2,2,'oriharukon','none',22,10,'sword',8,0.00000,0,0,0,379,0,6,-1,-1,66600,0,'false','true','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(1299,'Great Sword','','lrhand','false',500,3,3,'steel','none',200,10,'dual',8,0.00000,0,0,0,325,0,6,-1,-1,3340000,0,'false','true','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(1300,'Apprentice\'s Rod','','rhand','false',80,2,2,'wood','none',22,20,'blunt',4,4.00000,0,0,0,379,0,6,-1,-1,66600,0,'false','true','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(1301,'Big Hammer','','rhand','false',300,2,2,'fine_steel','none',22,20,'blunt',4,4.00000,0,0,0,379,0,6,-1,-1,66600,0,'false','true','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(1302,'Bec de Corbin','','lrhand','false',750,2,2,'fine_steel','none',22,10,'pole',8,-3.00000,0,0,0,325,0,6,-1,-1,66600,0,'false','true','true','false','true',0,0,0,0,0,0,0,0,0,'3599-1;'),
(1303,'Lance','','lrhand','false',750,2,2,'fine_steel','none',30000,10,'pole',8,-3.00000,0,0,0,325,0,6,-1,-1,66600,0,'false','true','true','false','true',0,0,0,0,0,0,0,0,0,'3599-1;'),
(1304,'Conjuror\'s Staff','','lrhand','false',150,2,2,'oriharukon','none',15,20,'bigblunt',4,4.00000,0,0,0,325,0,17,-1,-1,66600,0,'false','true','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(1305,'Knife','','rhand','false',120,2,2,'bronze','none',30000,5,'dagger',12,-3.00000,0,0,0,433,0,6,-1,-1,66600,0,'false','true','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(1306,'Crafted Dagger','','rhand','false',100,2,2,'chrysolite','none',22,5,'dagger',12,-3.00000,0,0,0,433,0,6,-1,-1,66600,0,'false','true','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(1307,'Bow','','lrhand','false',150,9,3,'wood','none',120,5,'bow',12,-3.00000,0,0,0,293,7,6,-1,-1,3340000,0,'false','true','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(1328,'Shield of Grace','','lhand','false',300,0,0,'mithril','none',0,0,'none',0,0.00000,-8,71,20,0,0,0,-1,-1,83800,0,'false','true','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(1329,'Shield of Victory','','lhand','false',350,0,0,'adamantaite','none',0,0,'none',0,0.00000,-8,71,20,0,0,0,-1,-1,1096000,0,'false','true','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(1330,'Zubei\'s Shield','','lhand','false',500,0,0,'mithril','none',0,0,'none',0,0.00000,-8,71,20,0,0,0,-1,-1,1422000,0,'false','true','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(1331,'Otherworldly Shield','','lhand','false',350,0,0,'adamantaite','none',0,0,'none',0,0.00000,-8,71,20,0,0,0,-1,-1,1096000,0,'false','true','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(1332,'Knight\'s Shield','','lhand','false',500,0,0,'fine_steel','none',0,0,'none',0,0.00000,-8,71,20,0,0,0,-1,-1,246900,0,'false','true','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(1333,'Brandish','','lrhand','false',2250,2,2,'steel','none',21,10,'bigsword',8,0.00000,0,0,0,325,0,12,-1,-1,41600,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(1376,'Guard Spear','','lrhand','true',300,2,2,'bronze','d',50,10,'pole',8,-3.00000,0,0,0,325,0,26,-1,-1,409000,743,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3599-1;'),
(1471,'Silenos Blowgun','','rhand','true',300,2,2,'steel','d',5,5,'dagger',12,-3.00000,0,0,0,433,0,5,-1,-1,409000,743,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(1472,'Dreadbane','','lrhand','true',300,2,2,'bronze','d',50,10,'pole',8,-3.00000,0,0,0,325,0,26,-1,-1,409000,743,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3599-1;'),
(1510,'Butcher\'s Sword','','rhand','false',1450,1,1,'steel','none',13,10,'sword',8,0.00000,0,0,0,379,0,10,-1,-1,19500,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(1511,'Silversmith Hammer','','rhand','false',1860,1,1,'steel','none',13,20,'blunt',4,4.00000,0,0,0,379,0,10,-1,-1,19500,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(1660,'Cursed Maingauche','','rhand','true',1070,3,3,'fine_steel','d',62,5,'dagger',12,-3.00000,0,0,0,433,0,42,-1,-1,1074000,1983,'true','true','true','true','true',0,0,0,0,0,3005,1,50,0,'0-0;'),
(2368,'Training Gloves','','lrhand','false',1580,1,1,'cloth','none',7,5,'dualfist',4,4.00000,0,0,0,325,0,5,-1,-1,106,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(2369,'Squire\'s Sword','','rhand','false',1600,1,1,'steel','none',6,10,'sword',8,0.00000,0,0,0,379,0,5,-1,-1,106,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(2370,'Guild Member\'s Club','','rhand','false',1910,1,1,'wood','none',6,20,'blunt',4,4.00000,0,0,0,379,0,5,-1,-1,106,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(2371,'Fist of Butcher','','lrhand','false',1400,1,1,'steel','none',16,5,'dualfist',4,4.00000,0,0,0,325,0,10,-1,-1,19500,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(2372,'Dagger of Adept','','rhand','false',1050,1,1,'steel','none',11,5,'dagger',12,-3.00000,0,0,0,433,0,10,-1,-1,19500,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(2373,'Eldritch Staff','','lrhand','false',1050,1,1,'wood','none',13,20,'bigblunt',4,4.00000,0,0,0,325,0,13,-1,-1,19500,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(2374,'Red Sunset Dagger','','rhand','false',1100,1,1,'steel','none',11,5,'dagger',12,-3.00000,0,0,0,433,0,10,-1,-1,19500,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(2493,'Brigandine Shield','','lhand','true',1320,0,0,'leather','d',0,0,'none',0,0.00000,-8,142,20,0,0,0,-1,-1,60300,111,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(2494,'Plate Shield','','lhand','true',1310,0,0,'leather','d',0,0,'none',0,0.00000,-8,154,20,0,0,0,-1,-1,79000,146,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(2495,'Chain Shield','','lhand','true',1280,0,0,'leather','c',0,0,'none',0,0.00000,-8,166,20,0,0,0,-1,-1,102000,41,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(2496,'Dwarven Chain Shield','','lhand','true',1280,0,0,'leather','c',0,0,'none',0,0.00000,-8,174,20,0,0,0,-1,-1,120100,48,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(2497,'Full Plate Shield','','lhand','true',1220,0,0,'leather','c',0,0,'none',0,0.00000,-8,203,20,0,0,0,-1,-1,288800,116,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(2498,'Shield of Nightmare','','lhand','true',1180,0,0,'leather','a',0,0,'none',0,0.00000,-8,256,20,0,0,0,-1,-1,1422000,114,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(2499,'Elven Long Sword','','rhand','true',1440,3,3,'fine_steel','d',92,10,'sword',8,0.00000,0,0,0,379,0,54,-1,-1,1387000,2561,'true','true','true','true','true',0,0,0,0,0,0,0,0,9225,'0-0;'),
(2500,'Dark Legion\'s Edge','','rhand','true',1320,1,1,'fine_steel','a',232,10,'sword',8,0.00000,0,0,0,379,0,114,-1,-1,20741000,1659,'true','true','true','true','true',0,0,0,0,0,0,0,0,9340,'0-0;'),
(2501,'Bone Club','','rhand','false',1850,2,2,'fine_steel','none',24,20,'blunt',4,4.00000,0,0,0,379,0,17,-1,-1,105000,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(2502,'Dwarven War Hammer','','rhand','true',1670,2,2,'fine_steel','c',122,20,'blunt',4,4.00000,0,0,0,379,0,68,-1,-1,2209700,884,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(2503,'Yaksa Mace','','rhand','true',1640,3,3,'fine_steel','c',156,20,'blunt',4,4.00000,0,0,0,379,0,83,-1,-1,4713500,1885,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(2504,'Meteor Shower','','rhand','true',1600,1,1,'fine_steel','a',213,20,'blunt',4,4.00000,0,0,0,379,0,107,-1,-1,14098000,1128,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(2505,'Iron Canine','','wolf','false',100,0,0,'steel','none',4,10,'pet',8,0.00000,0,0,0,277,0,5,-1,-1,15166,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(2507,'Lizardspear','','rhand','false',300,2,2,'steel','d',5,5,'dagger',12,-3.00000,0,0,0,433,0,5,-1,-1,409000,743,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(2516,'Saber*Saber','','lrhand','true',2530,2,2,'fine_steel','d',73,10,'dual',8,0.00000,0,0,0,325,0,37,-1,-1,674400,1245,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(2517,'Saber*Bastard Sword','','lrhand','true',2520,3,3,'fine_steel','d',83,10,'dual',8,0.00000,0,0,0,325,0,41,-1,-1,817800,1510,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(2518,'Saber*Spinebone Sword','','lrhand','true',2530,3,3,'fine_steel','d',83,10,'dual',8,0.00000,0,0,0,325,0,41,-1,-1,817800,1510,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(2519,'Saber*Artisan\'s Sword','','lrhand','true',2520,3,3,'fine_steel','d',83,10,'dual',8,0.00000,0,0,0,325,0,41,-1,-1,817800,1510,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(2520,'Saber*Knight\'s Sword','','lrhand','true',2510,3,3,'fine_steel','d',83,10,'dual',8,0.00000,0,0,0,325,0,41,-1,-1,817800,1510,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(2521,'Saber*Crimson Sword','','lrhand','true',2530,3,3,'fine_steel','d',96,10,'dual',8,0.00000,0,0,0,325,0,47,-1,-1,1074000,1983,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(2522,'Saber*Elven Sword','','lrhand','true',2510,3,3,'fine_steel','d',96,10,'dual',8,0.00000,0,0,0,325,0,47,-1,-1,1074000,1983,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(2523,'Saber*Sword of Revolution','','lrhand','true',2420,2,2,'fine_steel','c',118,10,'dual',8,0.00000,0,0,0,325,0,56,-1,-1,1504400,602,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(2524,'Saber*Elven Long Sword','','lrhand','true',2420,2,2,'fine_steel','c',130,10,'dual',8,0.00000,0,0,0,325,0,61,-1,-1,1762900,705,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(2525,'Bastard Sword*Bastard Sword','','lrhand','true',2470,3,3,'fine_steel','d',96,10,'dual',8,0.00000,0,0,0,325,0,47,-1,-1,1074000,1983,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(2526,'Bastard Sword*Spinebone Sword','','lrhand','true',2470,3,3,'fine_steel','d',96,10,'dual',8,0.00000,0,0,0,325,0,47,-1,-1,1074000,1983,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(2527,'Bastard Sword*Artisan\'s Sword','','lrhand','true',2480,3,3,'fine_steel','d',96,10,'dual',8,0.00000,0,0,0,325,0,47,-1,-1,1074000,1983,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(2528,'Bastard Sword*Knight\'s Sword','','lrhand','true',2500,3,3,'fine_steel','d',96,10,'dual',8,0.00000,0,0,0,325,0,47,-1,-1,1074000,1983,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(2529,'Bastard Sword*Crimson Sword','','lrhand','true',2470,3,3,'fine_steel','d',107,10,'dual',8,0.00000,0,0,0,325,0,51,-1,-1,1275700,2355,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(2530,'Bastard Sword*Elven Sword','','lrhand','true',2460,3,3,'fine_steel','d',107,10,'dual',8,0.00000,0,0,0,325,0,51,-1,-1,1275700,2355,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(2531,'Bastard Sword*Sword of Revolution','','lrhand','true',2450,2,2,'fine_steel','c',124,10,'dual',8,0.00000,0,0,0,325,0,58,-1,-1,1630000,652,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(2532,'Bastard Sword*Elven Long Sword','','lrhand','true',2430,2,2,'fine_steel','c',136,10,'dual',8,0.00000,0,0,0,325,0,63,-1,-1,1903500,761,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(2533,'Spinebone Sword*Spinebone Sword','','lrhand','true',2520,3,3,'fine_steel','d',96,10,'dual',8,0.00000,0,0,0,325,0,47,-1,-1,1074000,1983,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(2534,'Spinebone Sword*Artisan\'s Sword','','lrhand','true',2460,3,3,'fine_steel','d',96,10,'dual',8,0.00000,0,0,0,325,0,47,-1,-1,1074000,1983,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(2535,'Spinebone Sword*Knight\'s Sword','','lrhand','true',2470,3,3,'fine_steel','d',96,10,'dual',8,0.00000,0,0,0,325,0,47,-1,-1,1074000,1983,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(2536,'Spinebone Sword*Crimson Sword','','lrhand','true',2520,3,3,'fine_steel','d',107,10,'dual',8,0.00000,0,0,0,325,0,51,-1,-1,1275700,2355,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(2537,'Spinebone Sword*Elven Sword','','lrhand','true',2460,3,3,'fine_steel','d',107,10,'dual',8,0.00000,0,0,0,325,0,51,-1,-1,1275700,2355,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(2538,'Spinebone Sword*Sword of Revolution','','lrhand','true',2460,2,2,'fine_steel','c',124,10,'dual',8,0.00000,0,0,0,325,0,58,-1,-1,1630000,652,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(2539,'Spinebone Sword*Elven Long Sword','','lrhand','true',2390,2,2,'fine_steel','c',136,10,'dual',8,0.00000,0,0,0,325,0,63,-1,-1,1903500,761,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(2540,'Artisan\'s Sword*Artisan\'s Sword','','lrhand','true',2480,3,3,'fine_steel','d',96,10,'dual',8,0.00000,0,0,0,325,0,47,-1,-1,1074000,1983,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(2541,'Artisan\'s Sword*Knight\'s Sword','','lrhand','true',2470,3,3,'fine_steel','d',96,10,'dual',8,0.00000,0,0,0,325,0,47,-1,-1,1074000,1983,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(2542,'Artisan\'s Sword*Crimson Sword','','lrhand','true',2450,3,3,'fine_steel','d',107,10,'dual',8,0.00000,0,0,0,325,0,51,-1,-1,1275700,2355,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(2543,'Artisan\'s Sword*Elven Sword','','lrhand','true',2470,3,3,'fine_steel','d',107,10,'dual',8,0.00000,0,0,0,325,0,51,-1,-1,1275700,2355,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(2544,'Artisan\'s Sword*Sword of Revolution','','lrhand','true',2420,2,2,'fine_steel','c',124,10,'dual',8,0.00000,0,0,0,325,0,58,-1,-1,1630000,652,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(2545,'Artisan\'s Sword*Elven Long Sword','','lrhand','true',2410,2,2,'fine_steel','c',136,10,'dual',8,0.00000,0,0,0,325,0,63,-1,-1,1903500,761,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(2546,'Knight\'s Sword*Knight\'s Sword','','lrhand','true',2460,3,3,'fine_steel','d',96,10,'dual',8,0.00000,0,0,0,325,0,47,-1,-1,1074000,1983,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(2547,'Knight\'s Sword*Crimson Sword','','lrhand','true',2460,3,3,'fine_steel','d',107,10,'dual',8,0.00000,0,0,0,325,0,51,-1,-1,1275700,2355,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(2548,'Knight\'s Sword*Elven Sword','','lrhand','true',2450,3,3,'fine_steel','d',107,10,'dual',8,0.00000,0,0,0,325,0,51,-1,-1,1275700,2355,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(2549,'Knight\'s Sword*Sword of Revolution','','lrhand','true',2430,2,2,'fine_steel','c',124,10,'dual',8,0.00000,0,0,0,325,0,58,-1,-1,1630000,652,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(2550,'Knight\'s Sword*Elven Long Sword','','lrhand','true',2370,2,2,'fine_steel','c',136,10,'dual',8,0.00000,0,0,0,325,0,63,-1,-1,1903500,761,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(2551,'Crimson Sword*Crimson Sword','','lrhand','true',2440,2,2,'fine_steel','c',118,10,'dual',8,0.00000,0,0,0,325,0,56,-1,-1,1504400,602,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(2552,'Crimson Sword*Elven Sword','','lrhand','true',2450,2,2,'fine_steel','c',118,10,'dual',8,0.00000,0,0,0,325,0,56,-1,-1,1504400,602,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(2553,'Crimson Sword*Sword of Revolution','','lrhand','true',2390,2,2,'fine_steel','c',136,10,'dual',8,0.00000,0,0,0,325,0,63,-1,-1,1903500,761,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(2554,'Crimson Sword*Elven Long Sword','','lrhand','true',2360,2,2,'fine_steel','c',148,10,'dual',8,0.00000,0,0,0,325,0,68,-1,-1,2209700,884,'true','true','true','true','true',3046,2,0,0,0,0,0,0,0,'0-0;'),
(2555,'Elven Sword*Elven Sword','','lrhand','true',2440,2,2,'fine_steel','c',118,10,'dual',8,0.00000,0,0,0,325,0,56,-1,-1,1504400,602,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(2556,'Elven Sword*Sword of Revolution','','lrhand','true',2410,2,2,'fine_steel','c',136,10,'dual',8,0.00000,0,0,0,325,0,63,-1,-1,1903500,761,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(2557,'Elven Sword*Elven Long Sword','','lrhand','true',2410,2,2,'fine_steel','c',148,10,'dual',8,0.00000,0,0,0,325,0,68,-1,-1,2209700,884,'true','true','true','true','true',3042,2,0,0,0,0,0,0,0,'0-0;'),
(2558,'Sword of Revolution*Sword of Revolution','','lrhand','true',2360,2,2,'fine_steel','c',148,10,'dual',8,0.00000,0,0,0,325,0,68,-1,-1,2209700,884,'true','true','true','true','true',3013,1,0,0,0,0,0,0,0,'0-0;'),
(2559,'Sword of Revolution*Elven Long Sword','','lrhand','true',2340,3,3,'fine_steel','c',155,10,'dual',8,0.00000,0,0,0,325,0,70,-1,-1,2571900,1029,'true','true','true','true','true',3044,3,0,0,0,0,0,0,0,'0-0;'),
(2560,'Elven Long Sword*Elven Long Sword','','lrhand','true',2340,3,3,'fine_steel','c',162,10,'dual',8,0.00000,0,0,0,325,0,73,-1,-1,2936500,1175,'true','true','true','true','true',3045,4,0,0,0,0,0,0,0,'0-0;'),
(2561,'Stormbringer*Stormbringer','','lrhand','true',2330,3,3,'fine_steel','c',175,10,'dual',8,0.00000,0,0,0,325,0,78,-1,-1,3677700,1471,'true','true','true','true','true',3046,6,0,0,0,0,0,0,0,'0-0;'),
(2562,'Stormbringer*Shamshir','','lrhand','true',2300,3,3,'fine_steel','c',183,10,'dual',8,0.00000,0,0,0,325,0,81,-1,-1,4058000,1623,'true','true','true','true','true',3042,7,0,0,0,0,0,0,0,'0-0;'),
(2563,'Stormbringer*Katana','','lrhand','true',2320,3,3,'fine_steel','c',183,10,'dual',8,0.00000,0,0,0,325,0,81,-1,-1,4058000,1623,'true','true','true','true','true',3013,1,0,0,0,0,0,0,0,'0-0;'),
(2564,'Stormbringer*Spirit Sword','','lrhand','true',2310,3,3,'fine_steel','c',183,10,'dual',8,0.00000,0,0,0,325,0,81,-1,-1,4058000,1623,'true','true','true','true','true',3044,7,0,0,0,0,0,0,0,'0-0;'),
(2565,'Stormbringer*Raid Sword','','lrhand','true',2340,3,3,'fine_steel','c',183,10,'dual',8,0.00000,0,0,0,325,0,81,-1,-1,4058000,1623,'true','true','true','true','true',3045,7,0,0,0,0,0,0,0,'0-0;'),
(2566,'Stormbringer*Caliburs','','lrhand','true',2260,1,1,'fine_steel','b',197,10,'dual',8,0.00000,0,0,0,325,0,86,-1,-1,5367500,716,'true','true','true','true','true',3046,9,0,0,0,0,0,0,0,'0-0;'),
(2567,'Stormbringer*Sword of Limit','','lrhand','true',2240,1,1,'fine_steel','b',197,10,'dual',8,0.00000,0,0,0,325,0,86,-1,-1,5367500,716,'true','true','true','true','true',3042,9,0,0,0,0,0,0,0,'0-0;'),
(2568,'Stormbringer*Sword of Delusion','','lrhand','true',2230,1,1,'fine_steel','b',197,10,'dual',8,0.00000,0,0,0,325,0,86,-1,-1,5367500,716,'true','true','true','true','true',3013,1,0,0,0,0,0,0,0,'0-0;'),
(2569,'Stormbringer*Sword of Nightmare','','lrhand','true',2250,1,1,'fine_steel','b',197,10,'dual',8,0.00000,0,0,0,325,0,86,-1,-1,5367500,716,'true','true','true','true','true',3044,9,0,0,0,0,0,0,0,'0-0;'),
(2570,'Stormbringer*Tsurugi','','lrhand','true',2220,1,1,'fine_steel','b',197,10,'dual',8,0.00000,0,0,0,325,0,86,-1,-1,5367500,716,'true','true','true','true','true',3045,9,0,0,0,0,0,0,0,'0-0;'),
(2571,'Stormbringer*Samurai Long sword','','lrhand','true',2150,1,1,'fine_steel','b',213,10,'dual',8,0.00000,0,0,0,325,0,91,-1,-1,6680500,891,'true','true','true','true','true',3046,11,0,0,0,0,0,0,0,'0-0;'),
(2572,'Shamshir*Shamshir','','lrhand','true',2330,3,3,'fine_steel','c',190,10,'dual',8,0.00000,0,0,0,325,0,83,-1,-1,4713500,1885,'true','true','true','true','true',3046,8,0,0,0,0,0,0,0,'0-0;'),
(2573,'Shamshir*Katana','','lrhand','true',2310,3,3,'fine_steel','c',190,10,'dual',8,0.00000,0,0,0,325,0,83,-1,-1,4713500,1885,'true','true','true','true','true',3042,8,0,0,0,0,0,0,0,'0-0;'),
(2574,'Shamshir*Spirit Sword','','lrhand','true',2280,3,3,'fine_steel','c',190,10,'dual',8,0.00000,0,0,0,325,0,83,-1,-1,4713500,1885,'true','true','true','true','true',3013,1,0,0,0,0,0,0,0,'0-0;'),
(2575,'Shamshir*Raid Sword','','lrhand','true',2280,3,3,'fine_steel','c',190,10,'dual',8,0.00000,0,0,0,325,0,83,-1,-1,4713500,1885,'true','true','true','true','true',3044,8,0,0,0,0,0,0,0,'0-0;'),
(2576,'Shamshir*Caliburs','','lrhand','true',2230,1,1,'fine_steel','b',204,10,'dual',8,0.00000,0,0,0,325,0,89,-1,-1,6022600,803,'true','true','true','true','true',3046,10,0,0,0,0,0,0,0,'0-0;'),
(2577,'Shamshir*Sword of Limit','','lrhand','true',2240,1,1,'fine_steel','b',204,10,'dual',8,0.00000,0,0,0,325,0,89,-1,-1,6022600,803,'true','true','true','true','true',3042,10,0,0,0,0,0,0,0,'0-0;'),
(2578,'Shamshir*Sword of Delusion','','lrhand','true',2200,1,1,'fine_steel','b',204,10,'dual',8,0.00000,0,0,0,325,0,89,-1,-1,6022600,803,'true','true','true','true','true',3013,1,0,0,0,0,0,0,0,'0-0;'),
(2579,'Shamshir*Sword of Nightmare','','lrhand','true',2210,1,1,'fine_steel','b',204,10,'dual',8,0.00000,0,0,0,325,0,89,-1,-1,6022600,803,'true','true','true','true','true',3044,10,0,0,0,0,0,0,0,'0-0;'),
(2580,'Shamshir*Tsurugi','','lrhand','true',2220,1,1,'fine_steel','b',204,10,'dual',8,0.00000,0,0,0,325,0,89,-1,-1,6022600,803,'true','true','true','true','true',3045,10,0,0,0,0,0,0,0,'0-0;'),
(2581,'Shamshir*Samurai Long Sword','','lrhand','true',2110,1,1,'fine_steel','b',220,10,'dual',8,0.00000,0,0,0,325,0,94,-1,-1,7344400,979,'true','true','true','true','true',3046,12,0,0,0,0,0,0,0,'0-0;'),
(2582,'Katana*Katana','','lrhand','true',2270,3,3,'fine_steel','c',190,10,'dual',8,0.00000,0,0,0,325,0,83,-1,-1,4713500,1885,'true','true','true','true','true',3045,8,0,0,0,0,0,0,0,'0-0;'),
(2583,'Katana*Spirit Sword','','lrhand','true',2250,3,3,'fine_steel','c',190,10,'dual',8,0.00000,0,0,0,325,0,83,-1,-1,4713500,1885,'true','true','true','true','true',3046,8,0,0,0,0,0,0,0,'0-0;'),
(2584,'Katana*Raid Sword','','lrhand','true',2270,3,3,'fine_steel','c',190,10,'dual',8,0.00000,0,0,0,325,0,83,-1,-1,4713500,1885,'true','true','true','true','true',3042,8,0,0,0,0,0,0,0,'0-0;'),
(2585,'Katana*Caliburs','','lrhand','true',2220,1,1,'fine_steel','b',204,10,'dual',8,0.00000,0,0,0,325,0,89,-1,-1,6022600,803,'true','true','true','true','true',3046,10,0,0,0,0,0,0,0,'0-0;'),
(2586,'Katana*Sword of Limit','','lrhand','true',2180,1,1,'fine_steel','b',204,10,'dual',8,0.00000,0,0,0,325,0,89,-1,-1,6022600,803,'true','true','true','true','true',3042,10,0,0,0,0,0,0,0,'0-0;'),
(2587,'Katana*Sword of Delusion','','lrhand','true',2190,1,1,'fine_steel','b',204,10,'dual',8,0.00000,0,0,0,325,0,89,-1,-1,6022600,803,'true','true','true','true','true',3013,1,0,0,0,0,0,0,0,'0-0;'),
(2588,'Katana*Sword of Nightmare','','lrhand','true',2170,1,1,'fine_steel','b',204,10,'dual',8,0.00000,0,0,0,325,0,89,-1,-1,6022600,803,'true','true','true','true','true',3044,10,0,0,0,0,0,0,0,'0-0;'),
(2589,'Katana*Tsurugi','','lrhand','true',2210,1,1,'fine_steel','b',204,10,'dual',8,0.00000,0,0,0,325,0,89,-1,-1,6022600,803,'true','true','true','true','true',3045,10,0,0,0,0,0,0,0,'0-0;'),
(2590,'Katana*Samurai Long Sword','','lrhand','true',2130,1,1,'fine_steel','b',220,10,'dual',8,0.00000,0,0,0,325,0,94,-1,-1,7344400,979,'true','true','true','true','true',3042,12,0,0,0,0,0,0,0,'0-0;'),
(2591,'Spirit Sword*Spirit Sword','','lrhand','true',2240,3,3,'fine_steel','c',190,10,'dual',8,0.00000,0,0,0,325,0,83,-1,-1,4713500,1885,'true','true','true','true','true',3013,1,0,0,0,0,0,0,0,'0-0;'),
(2592,'Spirit Sword*Raid Sword','','lrhand','true',2260,3,3,'fine_steel','c',190,10,'dual',8,0.00000,0,0,0,325,0,83,-1,-1,4713500,1885,'true','true','true','true','true',3044,8,0,0,0,0,0,0,0,'0-0;'),
(2593,'Spirit Sword*Caliburs','','lrhand','true',2240,1,1,'fine_steel','b',204,10,'dual',8,0.00000,0,0,0,325,0,89,-1,-1,6022600,803,'true','true','true','true','true',3046,10,0,0,0,0,0,0,0,'0-0;'),
(2594,'Spirit Sword*Sword of Limit','','lrhand','true',2240,1,1,'fine_steel','b',204,10,'dual',8,0.00000,0,0,0,325,0,89,-1,-1,6022600,803,'true','true','true','true','true',3042,10,0,0,0,0,0,0,0,'0-0;'),
(2595,'Spirit Sword*Sword of Delusion','','lrhand','true',2250,1,1,'fine_steel','b',204,10,'dual',8,0.00000,0,0,0,325,0,89,-1,-1,6022600,803,'true','true','true','true','true',3013,1,0,0,0,0,0,0,0,'0-0;'),
(2596,'Spirit Sword*Sword of Nightmare','','lrhand','true',2250,1,1,'fine_steel','b',204,10,'dual',8,0.00000,0,0,0,325,0,89,-1,-1,6022600,803,'true','true','true','true','true',3044,10,0,0,0,0,0,0,0,'0-0;'),
(2597,'Spirit Sword*Tsurugi','','lrhand','true',2220,1,1,'fine_steel','b',204,10,'dual',8,0.00000,0,0,0,325,0,89,-1,-1,6022600,803,'true','true','true','true','true',3045,10,0,0,0,0,0,0,0,'0-0;'),
(2598,'Spirit Sword*Samurai Long Sword','','lrhand','true',2110,1,1,'fine_steel','b',220,10,'dual',8,0.00000,0,0,0,325,0,94,-1,-1,7344400,979,'true','true','true','true','true',3013,1,0,0,0,0,0,0,0,'0-0;'),
(2599,'Raid Sword*Raid Sword','','lrhand','true',2250,3,3,'fine_steel','c',190,10,'dual',8,0.00000,0,0,0,325,0,83,-1,-1,4713500,1885,'true','true','true','true','true',3045,8,0,0,0,0,0,0,0,'0-0;'),
(2600,'Raid Sword*Caliburs','','lrhand','true',2190,1,1,'fine_steel','b',204,10,'dual',8,0.00000,0,0,0,325,0,89,-1,-1,6022600,803,'true','true','true','true','true',3046,10,0,0,0,0,0,0,0,'0-0;'),
(2601,'Raid Sword*Sword of Limit','','lrhand','true',2170,1,1,'fine_steel','b',204,10,'dual',8,0.00000,0,0,0,325,0,89,-1,-1,6022600,803,'true','true','true','true','true',3042,10,0,0,0,0,0,0,0,'0-0;'),
(2602,'Raid Sword*Sword of Delusion','','lrhand','true',2180,1,1,'fine_steel','b',204,10,'dual',8,0.00000,0,0,0,325,0,89,-1,-1,6022600,803,'true','true','true','true','true',3013,1,0,0,0,0,0,0,0,'0-0;'),
(2603,'Raid Sword*Sword of Nightmare','','lrhand','true',2170,1,1,'fine_steel','b',204,10,'dual',8,0.00000,0,0,0,325,0,89,-1,-1,6022600,803,'true','true','true','true','true',3044,10,0,0,0,0,0,0,0,'0-0;'),
(2604,'Raid Sword*Tsurugi','','lrhand','true',2170,1,1,'fine_steel','b',204,10,'dual',8,0.00000,0,0,0,325,0,89,-1,-1,6022600,803,'true','true','true','true','true',3045,10,0,0,0,0,0,0,0,'0-0;'),
(2605,'Raid Sword*Samurai Long Sword','','lrhand','true',2130,1,1,'fine_steel','b',220,10,'dual',8,0.00000,0,0,0,325,0,94,-1,-1,7344400,979,'true','true','true','true','true',3044,12,0,0,0,0,0,0,0,'0-0;'),
(2606,'Caliburs*Caliburs','','lrhand','true',2140,1,1,'fine_steel','b',213,10,'dual',8,0.00000,0,0,0,325,0,91,-1,-1,6680500,891,'true','true','true','true','true',3042,11,0,0,0,0,0,0,0,'0-0;'),
(2607,'Caliburs*Sword of Limit','','lrhand','true',2150,1,1,'fine_steel','b',213,10,'dual',8,0.00000,0,0,0,325,0,91,-1,-1,6680500,891,'true','true','true','true','true',3013,1,0,0,0,0,0,0,0,'0-0;'),
(2608,'Caliburs*Sword of Delusion','','lrhand','true',2140,1,1,'fine_steel','b',213,10,'dual',8,0.00000,0,0,0,325,0,91,-1,-1,6680500,891,'true','true','true','true','true',3044,11,0,0,0,0,0,0,0,'0-0;'),
(2609,'Caliburs*Sword of Nightmare','','lrhand','true',2170,1,1,'fine_steel','b',213,10,'dual',8,0.00000,0,0,0,325,0,91,-1,-1,6680500,891,'true','true','true','true','true',3045,11,0,0,0,0,0,0,0,'0-0;'),
(2610,'Caliburs*Tsurugi','','lrhand','true',2150,1,1,'fine_steel','b',213,10,'dual',8,0.00000,0,0,0,325,0,91,-1,-1,6680500,891,'true','true','true','true','true',3046,11,0,0,0,0,0,0,0,'0-0;'),
(2611,'Caliburs*Samurai Long Sword','','lrhand','true',2120,1,1,'fine_steel','b',228,10,'dual',8,0.00000,0,0,0,325,0,97,-1,-1,8729600,1164,'true','true','true','true','true',3045,13,0,0,0,0,0,0,0,'0-0;'),
(2612,'Sword of Limit*Sword of Limit','','lrhand','true',2140,1,1,'fine_steel','b',213,10,'dual',8,0.00000,0,0,0,325,0,91,-1,-1,6680500,891,'true','true','true','true','true',3042,11,0,0,0,0,0,0,0,'0-0;'),
(2613,'Sword of Limit*Sword of Delusion','','lrhand','true',2140,1,1,'fine_steel','b',213,10,'dual',8,0.00000,0,0,0,325,0,91,-1,-1,6680500,891,'true','true','true','true','true',3013,1,0,0,0,0,0,0,0,'0-0;'),
(2614,'Sword of Limit*Sword of Nightmare','','lrhand','true',2130,1,1,'fine_steel','b',213,10,'dual',8,0.00000,0,0,0,325,0,91,-1,-1,6680500,891,'true','true','true','true','true',3044,11,0,0,0,0,0,0,0,'0-0;'),
(2615,'Sword of Limit*Tsurugi','','lrhand','true',2120,1,1,'fine_steel','b',213,10,'dual',8,0.00000,0,0,0,325,0,91,-1,-1,6680500,891,'true','true','true','true','true',3045,11,0,0,0,0,0,0,0,'0-0;'),
(2616,'Sword of Limit*Samurai Long Sword','','lrhand','true',2100,1,1,'fine_steel','b',228,10,'dual',8,0.00000,0,0,0,325,0,97,-1,-1,8729600,1164,'true','true','true','true','true',3046,13,0,0,0,0,0,0,0,'0-0;'),
(2617,'Sword of Delusion*Sword of Delusion','','lrhand','true',2150,1,1,'fine_steel','b',213,10,'dual',8,0.00000,0,0,0,325,0,91,-1,-1,6680500,891,'true','true','true','true','true',3046,11,0,0,0,0,0,0,0,'0-0;'),
(2618,'Sword of Delusion*Sword of Nightmare','','lrhand','true',2130,1,1,'fine_steel','b',213,10,'dual',8,0.00000,0,0,0,325,0,91,-1,-1,6680500,891,'true','true','true','true','true',3042,11,0,0,0,0,0,0,0,'0-0;'),
(2619,'Sword of Delusion*Tsurugi','','lrhand','true',2140,1,1,'fine_steel','b',213,10,'dual',8,0.00000,0,0,0,325,0,91,-1,-1,6680500,891,'true','true','true','true','true',3013,1,0,0,0,0,0,0,0,'0-0;'),
(2620,'Sword of Delusion*Samurai Long Sword','','lrhand','true',2110,1,1,'fine_steel','b',228,10,'dual',8,0.00000,0,0,0,325,0,97,-1,-1,8729600,1164,'true','true','true','true','true',3042,13,0,0,0,0,0,0,0,'0-0;'),
(2621,'Sword of Nightmare*Sword of Nightmare','','lrhand','true',2130,1,1,'fine_steel','b',213,10,'dual',8,0.00000,0,0,0,325,0,91,-1,-1,6680500,891,'true','true','true','true','true',3044,11,0,0,0,0,0,0,0,'0-0;'),
(2622,'Sword of Nightmare*Tsurugi','','lrhand','true',2140,1,1,'fine_steel','b',213,10,'dual',8,0.00000,0,0,0,325,0,91,-1,-1,6680500,891,'true','true','true','true','true',3045,11,0,0,0,0,0,0,0,'0-0;'),
(2623,'Sword of Nightmare*Samurai Long Sword','','lrhand','true',2080,1,1,'fine_steel','b',228,10,'dual',8,0.00000,0,0,0,325,0,97,-1,-1,8729600,1164,'true','true','true','true','true',3013,1,0,0,0,0,0,0,0,'0-0;'),
(2624,'Tsurugi*Tsurugi','','lrhand','true',2120,1,1,'fine_steel','b',213,10,'dual',8,0.00000,0,0,0,325,0,91,-1,-1,6680500,891,'true','true','true','true','true',3044,11,0,0,0,0,0,0,0,'0-0;'),
(2625,'Tsurugi*Samurai Long Sword','','lrhand','true',2090,1,1,'fine_steel','b',228,10,'dual',8,0.00000,0,0,0,325,0,97,-1,-1,8729600,1164,'true','true','true','true','true',3044,13,0,0,0,0,0,0,0,'0-0;'),
(2626,'Samurai Long Sword*Samurai Long Sword','','lrhand','true',2080,1,1,'fine_steel','b',236,10,'dual',8,0.00000,0,0,0,325,0,99,-1,-1,10091400,1346,'true','true','true','true','true',3045,14,0,0,0,0,0,0,0,'0-0;'),
(2915,'Old Knight Sword','','rhand','false',3200,2,2,'fine_steel','none',24,10,'sword',8,0.00000,0,0,0,379,0,17,-1,-1,136000,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(3026,'Talins Spear','','lrhand','false',800,2,2,'steel','none',24,10,'pole',8,-3.00000,0,0,0,325,0,17,-1,-1,105000,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3599-1;'),
(3027,'Old Knight\'s Sword','','lrhand','false',2100,2,2,'steel','none',29,10,'bigsword',8,0.00000,0,0,0,325,0,17,-1,-1,105000,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(3028,'Crescent Moon Bow','','lrhand','false',600,6,2,'wood','none',34,5,'bow',12,-3.00000,0,0,0,293,2,12,-1,-1,41600,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(3029,'Sword of Binding','','rhand','false',1200,2,2,'steel','none',17,10,'sword',8,0.00000,0,0,0,379,0,12,-1,-1,41600,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(3439,'Shining Canine','','wolf','false',100,0,0,'steel','none',7,10,'pet',8,0.00000,0,0,0,277,0,8,-1,-1,34000,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(3471,'Cybellin\'s Dagger','','rhand','false',400,1,1,'steel','none',10,5,'dagger',12,-3.00000,0,0,0,433,0,9,-1,-1,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(3902,'Ghost Canine','','wolf','false',100,0,0,'steel','none',11,10,'pet',8,0.00000,0,0,0,277,0,10,-1,-1,61000,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(3903,'Mithril Canine','','wolf','false',100,0,0,'steel','none',16,10,'pet',8,0.00000,0,0,0,277,0,14,-1,-1,100000,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(3904,'Sylvan Canine','','wolf','false',100,0,0,'steel','none',23,10,'pet',8,0.00000,0,0,0,277,0,18,-1,-1,160000,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(3905,'Orikarukon Canine','','wolf','false',100,0,0,'steel','none',31,10,'pet',8,0.00000,0,0,0,277,0,24,-1,-1,240000,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(3906,'Fang of Saltydog','','wolf','false',100,0,0,'steel','none',40,10,'pet',8,0.00000,0,0,0,277,0,30,-1,-1,350000,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(3907,'Fang of Cerberus','','wolf','false',100,0,0,'steel','none',49,10,'pet',8,0.00000,0,0,0,277,0,36,-1,-1,450000,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(3908,'Fang of Coyote','','wolf','false',100,0,0,'steel','none',58,10,'pet',8,0.00000,0,0,0,277,0,42,-1,-1,570000,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(3909,'Crystalized Ice Canine','','wolf','false',100,0,0,'steel','none',69,10,'pet',8,0.00000,0,0,0,277,0,50,-1,-1,720000,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(3910,'Fang of the Blue Wolf','','wolf','false',100,0,0,'steel','none',80,10,'pet',8,0.00000,0,0,0,277,0,58,-1,-1,1100000,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(3911,'Fang of Fenril','','wolf','false',100,0,0,'steel','none',93,10,'pet',8,0.00000,0,0,0,277,0,66,-1,-1,1500000,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(3919,'Serpent Fang','','hatchling','false',100,0,0,'steel','none',8,10,'pet',8,0.00000,0,0,0,277,0,7,-1,-1,200000,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(3920,'Viperbite','','hatchling','false',100,0,0,'steel','none',9,10,'pet',8,0.00000,0,0,0,277,0,10,-1,-1,310000,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(3921,'Shadow Fang','','hatchling','false',100,0,0,'steel','none',10,10,'pet',8,0.00000,0,0,0,277,0,11,-1,-1,420000,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(3922,'Alya Fang','','hatchling','false',100,0,0,'steel','none',12,10,'pet',8,0.00000,0,0,0,277,0,13,-1,-1,570000,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(3923,'Torturer','','hatchling','false',100,0,0,'steel','none',13,10,'pet',8,0.00000,0,0,0,277,0,16,-1,-1,760000,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(3924,'Unuk Alhay Fang','','hatchling','false',100,0,0,'steel','none',15,10,'pet',8,0.00000,0,0,0,277,0,18,-1,-1,1100000,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(3925,'Antiplague','','hatchling','false',100,0,0,'steel','none',17,10,'pet',8,0.00000,0,0,0,277,0,21,-1,-1,1600000,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(3937,'Giant Bar','','lrhand','true',300,2,2,'bronze','d',50,10,'pole',8,-3.00000,0,0,0,325,0,26,-1,-1,409000,743,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3599-1;'),
(3938,'Giant Rod','','lrhand','true',300,2,2,'bronze','d',50,10,'pole',8,-3.00000,0,0,0,325,0,26,-1,-1,409000,743,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3599-1;'),
(3939,'Lady\'s Fan','','lrhand','true',300,2,2,'bronze','d',50,10,'pole',8,-3.00000,0,0,0,325,0,26,-1,-1,409000,743,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3599-1;'),
(4027,'Bouquet','','rhand','false',0,0,0,'paper','none',8,10,'sword',8,0.00000,0,0,0,379,0,6,-1,-1,0,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(4028,'Giant Cannon','','rhand','true',300,2,2,'steel','d',5,5,'dagger',12,-3.00000,0,0,0,433,0,5,-1,-1,409000,743,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(4202,'Chrono Cithara','','rhand','false',0,0,0,'steel','none',1,10,'sword',8,0.00000,0,0,0,379,0,1,-1,-1,0,0,'true','false','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(4219,'Dream Sword','','rhand','true',1530,2,2,'bronze','none',31,10,'sword',8,0.00000,0,0,0,379,0,21,-1,-1,244000,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(4220,'Dream Knife','','rhand','true',1110,2,2,'steel','none',27,5,'dagger',12,-3.00000,0,0,0,433,0,21,-1,-1,244000,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(4221,'Ubiquitous Axe','','rhand','true',1850,2,2,'steel','none',31,20,'blunt',4,4.00000,0,0,0,379,0,21,-1,-1,244000,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(4222,'Dream Shield','','lhand','true',1380,0,0,'bone','none',0,0,'none',0,0.00000,-8,90,20,0,0,0,-1,-1,9900,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(4223,'Ubiquitous Shield','','lhand','true',1380,0,0,'bone','none',0,0,'none',0,0.00000,-8,90,20,0,0,0,-1,-1,9900,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(4233,'Knuckle Duster','','lrhand','true',1490,2,2,'fine_steel','c',148,5,'dualfist',4,4.00000,0,0,0,325,0,68,-1,-1,2209700,884,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(4237,'Hatchling\'s Level 65 Weapon','','hatchling','false',100,0,0,'steel','none',24,10,'pet',8,0.00000,0,0,0,277,0,32,-1,-1,5628000,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(4238,'Hatchling\'s Level 75 Weapon','','hatchling','false',100,0,0,'steel','none',31,10,'pet',8,0.00000,0,0,0,277,0,43,-1,-1,19073000,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(4665,'Pipette Knife','','rhand','false',1140,1,1,'bronze','none',10,5,'dagger',12,-3.00000,0,0,0,433,0,9,-1,-1,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(4681,'Stormbringer','Critical Anger','rhand','true',1430,2,2,'fine_steel','c',107,10,'sword',8,0.00000,0,0,0,379,0,61,-1,-1,1762900,705,'true','true','true','true','true',0,0,0,0,0,3025,1,100,9229,'3026-1;'),
(4682,'Stormbringer','Focus','rhand','true',1430,2,2,'fine_steel','c',107,10,'sword',8,0.00000,0,0,0,379,0,61,-1,-1,1762900,705,'true','true','true','true','true',0,0,0,0,0,0,0,0,9230,'3010-1;'),
(4683,'Stormbringer','Light','rhand','true',1430,2,2,'fine_steel','c',107,10,'sword',8,0.00000,0,0,0,379,0,61,-1,-1,1762900,705,'true','true','true','true','true',0,0,0,0,0,0,0,0,9231,'3498-1;'),
(4684,'Shamshir','Guidance','rhand','true',1420,2,2,'fine_steel','c',122,10,'sword',8,0.00000,0,0,0,379,0,68,-1,-1,2209700,884,'true','true','true','true','true',0,0,0,0,0,0,0,0,9241,'3007-2;'),
(4685,'Shamshir','Back Blow','rhand','true',1420,2,2,'fine_steel','c',122,10,'sword',8,0.00000,0,0,0,379,0,68,-1,-1,2209700,884,'true','true','true','true','true',0,0,0,0,0,0,0,0,9242,'3018-2;'),
(4686,'Shamshir','Rsk. Evasion','rhand','true',1420,2,2,'fine_steel','c',122,10,'sword',8,0.00000,0,0,0,379,0,68,-1,-1,2209700,884,'true','true','true','true','true',0,0,0,0,0,0,0,0,9243,'3028-5;'),
(4687,'Katana','Focus','rhand','true',1420,2,2,'fine_steel','c',122,10,'sword',8,0.00000,0,0,0,379,0,68,-1,-1,2209700,884,'true','true','true','true','true',0,0,0,0,0,0,0,0,9245,'3010-2;'),
(4688,'Katana','Critical Damage','rhand','true',1420,2,2,'fine_steel','c',122,10,'sword',8,0.00000,0,0,0,379,0,68,-1,-1,2209700,884,'true','true','true','true','true',0,0,0,0,0,0,0,0,9246,'3023-2;'),
(4689,'Katana','Haste','rhand','true',1420,2,2,'fine_steel','c',122,10,'sword',8,0.00000,0,0,0,379,0,68,-1,-1,2209700,884,'true','true','true','true','true',0,0,0,0,0,0,0,0,9247,'3036-2;'),
(4690,'Spirit Sword','Critical Damage','rhand','true',1420,2,2,'fine_steel','c',122,10,'sword',8,0.00000,0,0,0,379,0,68,-1,-1,2209700,884,'true','true','true','true','true',0,0,0,0,0,0,0,0,9249,'3023-2;'),
(4691,'Spirit Sword','Critical Poison','rhand','true',1420,2,2,'fine_steel','c',122,10,'sword',8,0.00000,0,0,0,379,0,68,-1,-1,2209700,884,'true','true','true','true','true',0,0,0,0,0,3024,2,15,9250,'0-0;'),
(4692,'Spirit Sword','Haste','rhand','true',1420,2,2,'fine_steel','c',122,10,'sword',8,0.00000,0,0,0,379,0,68,-1,-1,2209700,884,'true','true','true','true','true',0,0,0,0,0,0,0,0,9251,'3036-2;'),
(4693,'Raid Sword','Focus','rhand','true',1420,2,2,'fine_steel','c',122,10,'sword',8,0.00000,0,0,0,379,0,68,-1,-1,2209700,884,'true','true','true','true','true',0,0,0,0,0,0,0,0,9253,'3010-2;'),
(4694,'Raid Sword','Critical Drain','rhand','true',1420,2,2,'fine_steel','c',122,10,'sword',8,0.00000,0,0,0,379,0,68,-1,-1,2209700,884,'true','true','true','true','true',0,0,0,0,0,3022,2,33,9254,'0-0;'),
(4695,'Raid Sword','Critical Poison','rhand','true',1420,2,2,'fine_steel','c',122,10,'sword',8,0.00000,0,0,0,379,0,68,-1,-1,2209700,884,'true','true','true','true','true',0,0,0,0,0,3024,2,15,9255,'0-0;'),
(4696,'Caliburs','Guidance','rhand','true',1400,3,3,'oriharukon','c',139,10,'sword',8,0.00000,0,0,0,379,0,76,-1,-1,3304300,1322,'true','true','true','true','true',0,0,0,0,0,0,0,0,9265,'3007-3;'),
(4697,'Caliburs','Focus','rhand','true',1400,3,3,'oriharukon','c',139,10,'sword',8,0.00000,0,0,0,379,0,76,-1,-1,3304300,1322,'true','true','true','true','true',0,0,0,0,0,0,0,0,9266,'3010-3;'),
(4698,'Caliburs','Critical Damage','rhand','true',1400,3,3,'oriharukon','c',139,10,'sword',8,0.00000,0,0,0,379,0,76,-1,-1,3304300,1322,'true','true','true','true','true',0,0,0,0,0,0,0,0,9267,'3023-3;'),
(4699,'Sword of Delusion','Focus','rhand','true',1400,3,3,'mithril','c',139,10,'sword',8,0.00000,0,0,0,379,0,76,-1,-1,3304300,1322,'true','true','true','true','true',0,0,0,0,0,0,0,0,9269,'3010-3;'),
(4700,'Sword of Delusion','Health','rhand','true',1400,3,3,'mithril','c',139,10,'sword',8,0.00000,0,0,0,379,0,76,-1,-1,3304300,1322,'true','true','true','true','true',0,0,0,0,0,0,0,0,9270,'3013-1;'),
(4701,'Sword of Delusion','Rsk. Haste','rhand','true',1400,3,3,'mithril','c',139,10,'sword',8,0.00000,0,0,0,379,0,76,-1,-1,3304300,1322,'true','true','true','true','true',0,0,0,0,0,0,0,0,9271,'3032-3;'),
(4702,'Tsurugi','Focus','rhand','true',1400,3,3,'fine_steel','c',139,10,'sword',8,0.00000,0,0,0,379,0,76,-1,-1,3304300,1322,'true','true','true','true','true',0,0,0,0,0,0,0,0,9273,'3010-3;'),
(4703,'Tsurugi','Critical Damage','rhand','true',1400,3,3,'fine_steel','c',139,10,'sword',8,0.00000,0,0,0,379,0,76,-1,-1,3304300,1322,'true','true','true','true','true',0,0,0,0,0,0,0,0,9274,'3023-3;'),
(4704,'Tsurugi','Haste','rhand','true',1400,3,3,'fine_steel','c',139,10,'sword',8,0.00000,0,0,0,379,0,76,-1,-1,3304300,1322,'true','true','true','true','true',0,0,0,0,0,0,0,0,9275,'3036-3;'),
(4705,'Sword of Nightmare','Health','rhand','true',1400,3,3,'blood_steel','c',139,10,'sword',8,0.00000,0,0,0,379,0,76,-1,-1,3304300,1322,'true','true','true','true','true',0,0,0,0,0,0,0,0,9277,'3013-1;'),
(4706,'Sword of Nightmare','Focus','rhand','true',1400,3,3,'blood_steel','c',139,10,'sword',8,0.00000,0,0,0,379,0,76,-1,-1,3304300,1322,'true','true','true','true','true',0,0,0,0,0,0,0,0,9278,'3010-3;'),
(4707,'Sword of Nightmare','Light','rhand','true',1400,3,3,'blood_steel','c',139,10,'sword',8,0.00000,0,0,0,379,0,76,-1,-1,3304300,1322,'true','true','true','true','true',0,0,0,0,0,0,0,0,9279,'3498-1;'),
(4708,'Samurai Longsword','Focus','rhand','true',1380,3,3,'oriharukon','c',156,10,'sword',8,0.00000,0,0,0,379,0,83,-1,-1,4713500,1885,'true','true','true','true','true',0,0,0,0,0,0,0,0,9293,'3010-4;'),
(4709,'Samurai Longsword','Critical Damage','rhand','true',1380,3,3,'oriharukon','c',156,10,'sword',8,0.00000,0,0,0,379,0,83,-1,-1,4713500,1885,'true','true','true','true','true',0,0,0,0,0,0,0,0,9294,'3023-4;'),
(4710,'Samurai Longsword','Haste','rhand','true',1380,3,3,'oriharukon','c',156,10,'sword',8,0.00000,0,0,0,379,0,83,-1,-1,4713500,1885,'true','true','true','true','true',0,0,0,0,0,0,0,0,9295,'3036-4;'),
(4711,'Flamberge','Critical Damage','lrhand','true',2010,2,2,'bronze','c',130,10,'bigsword',8,0.00000,0,0,0,325,0,61,-1,-1,1762900,705,'true','true','true','true','true',0,0,0,0,0,0,0,0,9233,'3023-1;'),
(4712,'Flamberge','Focus','lrhand','true',2010,2,2,'bronze','c',130,10,'bigsword',8,0.00000,0,0,0,325,0,61,-1,-1,1762900,705,'true','true','true','true','true',0,0,0,0,0,0,0,0,9234,'3010-1;'),
(4713,'Flamberge','Light','lrhand','true',2010,2,2,'bronze','c',130,10,'bigsword',8,0.00000,0,0,0,325,0,61,-1,-1,1762900,705,'true','true','true','true','true',0,0,0,0,0,0,0,0,9235,'3498-1;'),
(4714,'Keshanberk','Guidance','rhand','true',1370,1,1,'oriharukon','b',175,10,'sword',8,0.00000,0,0,0,379,0,91,-1,-1,6680500,891,'true','true','true','true','true',0,0,0,0,0,0,0,0,9305,'3007-5;'),
(4715,'Keshanberk','Focus','rhand','true',1370,1,1,'oriharukon','b',175,10,'sword',8,0.00000,0,0,0,379,0,91,-1,-1,6680500,891,'true','true','true','true','true',0,0,0,0,0,0,0,0,9306,'3010-5;'),
(4716,'Keshanberk','Back Blow','rhand','true',1370,1,1,'oriharukon','b',175,10,'sword',8,0.00000,0,0,0,379,0,91,-1,-1,6680500,891,'true','true','true','true','true',0,0,0,0,0,0,0,0,9307,'3018-5;'),
(4717,'Sword of Damascus','Focus','rhand','true',1350,1,1,'damascus','b',194,10,'sword',8,0.00000,0,0,0,379,0,99,-1,-1,10091400,1346,'true','true','true','true','true',0,0,0,0,0,0,0,0,9317,'3010-6;'),
(4718,'Sword of Damascus','Critical Damage','rhand','true',1350,1,1,'damascus','b',194,10,'sword',8,0.00000,0,0,0,379,0,99,-1,-1,10091400,1346,'true','true','true','true','true',0,0,0,0,0,0,0,0,9318,'3023-6;'),
(4719,'Sword of Damascus','Haste','rhand','true',1350,1,1,'damascus','b',194,10,'sword',8,0.00000,0,0,0,379,0,99,-1,-1,10091400,1346,'true','true','true','true','true',0,0,0,0,0,0,0,0,9319,'3036-6;'),
(4720,'Tallum Blade','Health','rhand','true',1330,1,1,'adamantaite','a',213,10,'sword',8,0.00000,0,0,0,379,0,107,-1,-1,14098000,1128,'true','true','true','true','true',0,0,0,0,0,0,0,0,9329,'3013-1;'),
(4721,'Tallum Blade','Rsk. Evasion','rhand','true',1330,1,1,'adamantaite','a',213,10,'sword',8,0.00000,0,0,0,379,0,107,-1,-1,14098000,1128,'true','true','true','true','true',0,0,0,0,0,0,0,0,9330,'3028-1;'),
(4722,'Tallum Blade','Rsk. Haste','rhand','true',1330,1,1,'adamantaite','a',213,10,'sword',8,0.00000,0,0,0,379,0,107,-1,-1,14098000,1128,'true','true','true','true','true',0,0,0,0,0,0,0,0,9331,'3032-4;'),
(4723,'Great Sword','Health','lrhand','true',1930,1,1,'steel','b',213,10,'bigsword',8,0.00000,0,0,0,325,0,91,-1,-1,6680500,891,'true','true','true','true','true',0,0,0,0,0,0,0,0,9309,'3013-1;'),
(4724,'Great Sword','Critical Damage','lrhand','true',1930,1,1,'steel','b',213,10,'bigsword',8,0.00000,0,0,0,325,0,91,-1,-1,6680500,891,'true','true','true','true','true',0,0,0,0,0,0,0,0,9310,'3023-5;'),
(4725,'Great Sword','Focus','lrhand','true',1930,1,1,'steel','b',213,10,'bigsword',8,0.00000,0,0,0,325,0,91,-1,-1,6680500,891,'true','true','true','true','true',0,0,0,0,0,0,0,0,9311,'3010-5;'),
(4726,'Big Hammer','Health','rhand','true',1710,2,2,'fine_steel','c',107,20,'blunt',4,4.00000,0,0,0,379,0,61,-1,-1,1762900,705,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3013-1;'),
(4727,'Big Hammer','Rsk.Focus','rhand','true',1710,2,2,'fine_steel','c',107,20,'blunt',4,4.00000,0,0,0,379,0,61,-1,-1,1762900,705,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3027-1;'),
(4728,'Big Hammer','Haste','rhand','true',1710,2,2,'fine_steel','c',107,20,'blunt',4,4.00000,0,0,0,379,0,61,-1,-1,1762900,705,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3036-1;'),
(4729,'Battle Axe','Anger','rhand','true',1720,2,2,'fine_steel','c',107,20,'blunt',4,4.00000,0,0,0,379,0,61,-1,-1,1762900,705,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3012-1;'),
(4730,'Battle Axe','Rsk.Focus','rhand','true',1720,2,2,'fine_steel','c',107,20,'blunt',4,4.00000,0,0,0,379,0,61,-1,-1,1762900,705,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3027-1;'),
(4731,'Battle Axe','Haste','rhand','true',1720,2,2,'fine_steel','c',107,20,'blunt',4,4.00000,0,0,0,379,0,61,-1,-1,1762900,705,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3036-1;'),
(4732,'Silver Axe','Anger','rhand','true',1690,2,2,'fine_steel','c',107,20,'blunt',4,4.00000,0,0,0,379,0,61,-1,-1,1762900,705,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3012-1;'),
(4733,'Silver Axe','Rsk.Focus','rhand','true',1690,2,2,'fine_steel','c',107,20,'blunt',4,4.00000,0,0,0,379,0,61,-1,-1,1762900,705,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3027-1;'),
(4734,'Silver Axe','Haste','rhand','true',1690,2,2,'fine_steel','c',107,20,'blunt',4,4.00000,0,0,0,379,0,61,-1,-1,1762900,705,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3036-1;'),
(4735,'Skull Graver','Anger','rhand','true',1640,2,2,'fine_steel','c',107,20,'blunt',4,4.00000,0,0,0,379,0,61,-1,-1,1762900,705,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3012-1;'),
(4736,'Skull Graver','Health','rhand','true',1640,2,2,'fine_steel','c',107,20,'blunt',4,4.00000,0,0,0,379,0,61,-1,-1,1762900,705,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3013-1;'),
(4737,'Skull Graver','Rsk.Focus','rhand','true',1640,2,2,'fine_steel','c',107,20,'blunt',4,4.00000,0,0,0,379,0,61,-1,-1,1762900,705,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3027-1;'),
(4738,'Dwarven War Hammer','Anger','rhand','true',1670,2,2,'fine_steel','c',122,20,'blunt',4,4.00000,0,0,0,379,0,68,-1,-1,2209700,884,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3012-2;'),
(4739,'Dwarven War Hammer','Health','rhand','true',1670,2,2,'fine_steel','c',122,20,'blunt',4,4.00000,0,0,0,379,0,68,-1,-1,2209700,884,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3013-1;'),
(4740,'Dwarven War Hammer','Haste','rhand','true',1670,2,2,'fine_steel','c',122,20,'blunt',4,4.00000,0,0,0,379,0,68,-1,-1,2209700,884,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3037-2;'),
(4741,'War Axe','Anger','rhand','true',1660,3,3,'fine_steel','c',139,20,'blunt',4,4.00000,0,0,0,379,0,76,-1,-1,3304300,1322,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3012-3;'),
(4742,'War Axe','Health','rhand','true',1660,3,3,'fine_steel','c',139,20,'blunt',4,4.00000,0,0,0,379,0,76,-1,-1,3304300,1322,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3013-1;'),
(4743,'War Axe','Haste','rhand','true',1660,3,3,'fine_steel','c',139,20,'blunt',4,4.00000,0,0,0,379,0,76,-1,-1,3304300,1322,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3036-3;'),
(4744,'Yaksa Mace','Anger','rhand','true',1640,3,3,'fine_steel','c',156,20,'blunt',4,4.00000,0,0,0,379,0,83,-1,-1,4713500,1885,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3012-4;'),
(4745,'Yaksa Mace','Health','rhand','true',1640,3,3,'fine_steel','c',156,20,'blunt',4,4.00000,0,0,0,379,0,83,-1,-1,4713500,1885,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3013-1;'),
(4746,'Yaksa Mace','Rsk. Focus','rhand','true',1640,3,3,'fine_steel','c',156,20,'blunt',4,4.00000,0,0,0,379,0,83,-1,-1,4713500,1885,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3027-4;'),
(4747,'Heavy War Axe','Anger','rhand','true',1620,1,1,'fine_steel','b',175,20,'blunt',4,4.00000,0,0,0,379,0,91,-1,-1,6680500,891,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3012-5;'),
(4748,'Heavy War Axe','Health','rhand','true',1620,1,1,'fine_steel','b',175,20,'blunt',4,4.00000,0,0,0,379,0,91,-1,-1,6680500,891,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3013-1;'),
(4749,'Heavy War Axe','Rsk. Focus','rhand','true',1620,1,1,'fine_steel','b',175,20,'blunt',4,4.00000,0,0,0,379,0,91,-1,-1,6680500,891,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3027-5;'),
(4750,'Deadman\'s Glory','Anger','rhand','true',1600,1,1,'bone','b',194,20,'blunt',4,4.00000,0,0,0,379,0,99,-1,-1,10091400,1346,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3012-6;'),
(4751,'Deadman\'s Glory','Health','rhand','true',1600,1,1,'bone','b',194,20,'blunt',4,4.00000,0,0,0,379,0,99,-1,-1,10091400,1346,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3013-1;'),
(4752,'Deadman\'s Glory','Haste','rhand','true',1600,1,1,'bone','b',194,20,'blunt',4,4.00000,0,0,0,379,0,99,-1,-1,10091400,1346,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3036-6;'),
(4753,'Art of Battle Axe','Health','rhand','true',1570,1,1,'chrysolite','b',194,20,'blunt',4,4.00000,0,0,0,379,0,99,-1,-1,10091400,1346,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3013-1;'),
(4754,'Art of Battle Axe','Rsk. Focus','rhand','true',1570,1,1,'chrysolite','b',194,20,'blunt',4,4.00000,0,0,0,379,0,99,-1,-1,10091400,1346,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3027-6;'),
(4755,'Art of Battle Axe','Haste','rhand','true',1570,1,1,'chrysolite','b',194,20,'blunt',4,4.00000,0,0,0,379,0,99,-1,-1,10091400,1346,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3036-6;'),
(4756,'Meteor Shower','Health','rhand','true',1600,1,1,'fine_steel','a',213,20,'blunt',4,4.00000,0,0,0,379,0,107,-1,-1,14098000,1128,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3013-1;'),
(4757,'Meteor Shower','Focus','rhand','true',1600,1,1,'fine_steel','a',213,20,'blunt',4,4.00000,0,0,0,379,0,107,-1,-1,14098000,1128,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3050-2;'),
(4758,'Meteor Shower','P.Focus','rhand','true',1600,1,1,'fine_steel','a',213,20,'blunt',4,4.00000,0,0,0,379,0,107,-1,-1,14098000,1128,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3010-1;'),
(4759,'Cursed Dagger','Critical Bleed','rhand','true',1040,2,2,'mithril','c',94,5,'dagger',12,-3.00000,0,0,0,433,0,61,-1,-1,1762900,705,'true','true','true','true','true',0,0,0,0,0,3020,1,17,0,'0-0;'),
(4760,'Cursed Dagger','Critical Poison','rhand','true',1040,2,2,'mithril','c',94,5,'dagger',12,-3.00000,0,0,0,433,0,61,-1,-1,1762900,705,'true','true','true','true','true',0,0,0,0,0,3041,1,4,0,'0-0;'),
(4761,'Cursed Dagger','Rsk. Haste','rhand','true',1040,2,2,'mithril','c',94,5,'dagger',12,-3.00000,0,0,0,433,0,61,-1,-1,1762900,705,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3033-1;'),
(4762,'Dark Elven Dagger','Focus','rhand','true',1050,2,2,'fine_steel','c',94,5,'dagger',12,-3.00000,0,0,0,433,0,61,-1,-1,1762900,705,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3011-1;'),
(4763,'Dark Elven Dagger','Back Blow','rhand','true',1050,2,2,'fine_steel','c',94,5,'dagger',12,-3.00000,0,0,0,433,0,61,-1,-1,1762900,705,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3019-1;'),
(4764,'Dark Elven Dagger','Mortal Strike','rhand','true',1050,2,2,'fine_steel','c',94,5,'dagger',12,-3.00000,0,0,0,433,0,61,-1,-1,1762900,705,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3035-1;'),
(4765,'Stiletto','Critical Bleed','rhand','true',1030,2,2,'fine_steel','c',107,5,'dagger',12,-3.00000,0,0,0,433,0,68,-1,-1,2209700,884,'true','true','true','true','true',0,0,0,0,0,3020,2,17,0,'0-0;'),
(4766,'Stiletto','Critical Poison','rhand','true',1030,2,2,'fine_steel','c',107,5,'dagger',12,-3.00000,0,0,0,433,0,68,-1,-1,2209700,884,'true','true','true','true','true',0,0,0,0,0,3041,2,4,0,'0-0;'),
(4767,'Stiletto','Mortal Strike','rhand','true',1030,2,2,'fine_steel','c',107,5,'dagger',12,-3.00000,0,0,0,433,0,68,-1,-1,2209700,884,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3035-2;'),
(4768,'Grace Dagger','Evasion','rhand','true',1020,3,3,'fine_steel','c',122,5,'dagger',12,-3.00000,0,0,0,433,0,76,-1,-1,3304300,1322,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3009-3;'),
(4769,'Grace Dagger','Focus','rhand','true',1020,3,3,'fine_steel','c',122,5,'dagger',12,-3.00000,0,0,0,433,0,76,-1,-1,3304300,1322,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3011-3;'),
(4770,'Grace Dagger','Back Blow','rhand','true',1020,3,3,'fine_steel','c',122,5,'dagger',12,-3.00000,0,0,0,433,0,76,-1,-1,3304300,1322,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3019-3;'),
(4771,'Dark Screamer','Evasion','rhand','true',1010,3,3,'fine_steel','c',122,5,'dagger',12,-3.00000,0,0,0,433,0,76,-1,-1,3304300,1322,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3009-3;'),
(4772,'Dark Screamer','Focus','rhand','true',1010,3,3,'fine_steel','c',122,5,'dagger',12,-3.00000,0,0,0,433,0,76,-1,-1,3304300,1322,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3011-3;'),
(4773,'Dark Screamer','Critical Bleed','rhand','true',1010,3,3,'fine_steel','c',122,5,'dagger',12,-3.00000,0,0,0,433,0,76,-1,-1,3304300,1322,'true','true','true','true','true',0,0,0,0,0,3020,3,14,0,'0-0;'),
(4774,'Crystal Dagger','Critical Bleed','rhand','true',1000,3,3,'crystal','c',136,5,'dagger',12,-3.00000,0,0,0,433,0,83,-1,-1,4713500,1885,'true','true','true','true','true',0,0,0,0,0,3020,4,14,0,'0-0;'),
(4775,'Crystal Dagger','Critical Poison','rhand','true',1000,3,3,'crystal','c',136,5,'dagger',12,-3.00000,0,0,0,433,0,83,-1,-1,4713500,1885,'true','true','true','true','true',0,0,0,0,0,3041,4,3,0,'0-0;'),
(4776,'Crystal Dagger','Mortal Strike','rhand','true',1000,3,3,'crystal','c',136,5,'dagger',12,-3.00000,0,0,0,433,0,83,-1,-1,4713500,1885,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3035-4;'),
(4777,'Kris','Evasion','rhand','true',980,1,1,'mithril','b',153,5,'dagger',12,-3.00000,0,0,0,433,0,91,-1,-1,6680500,891,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3009-5;'),
(4778,'Kris','Focus','rhand','true',980,1,1,'mithril','b',153,5,'dagger',12,-3.00000,0,0,0,433,0,91,-1,-1,6680500,891,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3011-5;'),
(4779,'Kris','Back Blow','rhand','true',980,1,1,'mithril','b',153,5,'dagger',12,-3.00000,0,0,0,433,0,91,-1,-1,6680500,891,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3019-5;'),
(4780,'Demon Dagger','Critical Bleed','rhand','true',970,1,1,'blood_steel','b',170,5,'dagger',12,-3.00000,0,0,0,433,0,99,-1,-1,10091400,1346,'true','true','true','true','true',0,0,0,0,0,3020,6,12,0,'0-0;'),
(4781,'Demon Dagger','Critical Poison','rhand','true',970,1,1,'blood_steel','b',170,5,'dagger',12,-3.00000,0,0,0,433,0,99,-1,-1,10091400,1346,'true','true','true','true','true',0,0,0,0,0,3041,6,3,0,'0-0;'),
(4782,'Demon Dagger','Mortal Strike','rhand','true',970,1,1,'blood_steel','b',170,5,'dagger',12,-3.00000,0,0,0,433,0,99,-1,-1,10091400,1346,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3035-6;'),
(4783,'Bloody Orchid','Evasion','rhand','true',960,1,1,'blood_steel','a',186,5,'dagger',12,-3.00000,0,0,0,433,0,107,-1,-1,14098000,1128,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3009-5;'),
(4784,'Bloody Orchid','Focus','rhand','true',960,1,1,'blood_steel','a',186,5,'dagger',12,-3.00000,0,0,0,433,0,107,-1,-1,14098000,1128,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3011-2;'),
(4785,'Bloody Orchid','Back Blow','rhand','true',960,1,1,'blood_steel','a',186,5,'dagger',12,-3.00000,0,0,0,433,0,107,-1,-1,14098000,1128,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3063-1;'),
(4786,'Hell Knife','Focus','rhand','true',740,1,1,'blood_steel','b',122,5,'dagger',12,-3.00000,0,0,0,433,0,122,-1,-1,6680500,891,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3011-5;'),
(4787,'Hell Knife','Back Blow','rhand','true',740,1,1,'blood_steel','b',122,5,'dagger',12,-3.00000,0,0,0,433,0,122,-1,-1,6680500,891,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3019-5;'),
(4788,'Hell Knife','Mortal Strike','rhand','true',740,1,1,'blood_steel','b',122,5,'dagger',12,-3.00000,0,0,0,433,0,122,-1,-1,6680500,891,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3035-5;'),
(4789,'Chakram','Critical Drain','lrhand','true',1490,2,2,'fine_steel','c',130,5,'dualfist',4,4.00000,0,0,0,325,0,61,-1,-1,1762900,705,'true','true','true','true','true',0,0,0,0,0,3039,1,33,0,'0-0;'),
(4790,'Chakram','Critical Poison','lrhand','true',1490,2,2,'fine_steel','c',130,5,'dualfist',4,4.00000,0,0,0,325,0,61,-1,-1,1762900,705,'true','true','true','true','true',0,0,0,0,0,3040,1,8,0,'0-0;'),
(4791,'Chakram','Rsk. Haste','lrhand','true',1490,2,2,'fine_steel','c',130,5,'dualfist',4,4.00000,0,0,0,325,0,61,-1,-1,1762900,705,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3034-1;'),
(4792,'Fisted Blade','Rsk. Evasion','lrhand','true',1480,3,3,'fine_steel','c',169,5,'dualfist',4,4.00000,0,0,0,325,0,76,-1,-1,3304300,1322,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3030-3;'),
(4793,'Fisted Blade','Rsk. Haste','lrhand','true',1480,3,3,'fine_steel','c',169,5,'dualfist',4,4.00000,0,0,0,325,0,76,-1,-1,3304300,1322,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3034-3;'),
(4794,'Fisted Blade','Haste','lrhand','true',1480,3,3,'fine_steel','c',169,5,'dualfist',4,4.00000,0,0,0,325,0,76,-1,-1,3304300,1322,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3037-3;'),
(4795,'Great Pata','Critical Drain','lrhand','true',1460,3,3,'chrysolite','c',190,5,'dualfist',4,4.00000,0,0,0,325,0,83,-1,-1,4713500,1885,'true','true','true','true','true',0,0,0,0,0,3039,4,33,0,'0-0;'),
(4796,'Great Pata','Critical Poison','lrhand','true',1460,3,3,'chrysolite','c',190,5,'dualfist',4,4.00000,0,0,0,325,0,83,-1,-1,4713500,1885,'true','true','true','true','true',0,0,0,0,0,3040,4,7,0,'0-0;'),
(4797,'Great Pata','Rsk. Haste','lrhand','true',1460,3,3,'chrysolite','c',190,5,'dualfist',4,4.00000,0,0,0,325,0,83,-1,-1,4713500,1885,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3034-4;'),
(4798,'Knuckle Duster','Rsk. Evasion','lrhand','true',1490,2,2,'fine_steel','c',148,5,'dualfist',4,4.00000,0,0,0,325,0,68,-1,-1,2209700,884,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3030-2;'),
(4799,'Knuckle Duster','Rsk. Haste','lrhand','true',1490,2,2,'fine_steel','c',148,5,'dualfist',4,4.00000,0,0,0,325,0,68,-1,-1,2209700,884,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3034-2;'),
(4800,'Knuckle Duster','Haste','lrhand','true',1490,2,2,'fine_steel','c',148,5,'dualfist',4,4.00000,0,0,0,325,0,68,-1,-1,2209700,884,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3037-2;'),
(4801,'Arthro Nail','Critical Poison','lrhand','true',1420,1,1,'blood_steel','b',213,5,'dualfist',4,4.00000,0,0,0,325,0,91,-1,-1,6680500,891,'true','true','true','true','true',0,0,0,0,0,3040,5,7,0,'0-0;'),
(4802,'Arthro Nail','Rsk. Evasion','lrhand','true',1420,1,1,'blood_steel','b',213,5,'dualfist',4,4.00000,0,0,0,325,0,91,-1,-1,6680500,891,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3030-5;'),
(4803,'Arthro Nail','Rsk. Haste','lrhand','true',1420,1,1,'blood_steel','b',213,5,'dualfist',4,4.00000,0,0,0,325,0,91,-1,-1,6680500,891,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3034-5;'),
(4804,'Bellion Cestus','Critical Drain','lrhand','true',1390,1,1,'mithril','b',236,5,'dualfist',4,4.00000,0,0,0,325,0,99,-1,-1,10091400,1346,'true','true','true','true','true',0,0,0,0,0,3039,6,10,0,'0-0;'),
(4805,'Bellion Cestus','Critical Poison','lrhand','true',1390,1,1,'mithril','b',236,5,'dualfist',4,4.00000,0,0,0,325,0,99,-1,-1,10091400,1346,'true','true','true','true','true',0,0,0,0,0,3040,6,6,0,'0-0;'),
(4806,'Bellion Cestus','Rsk. Haste','lrhand','true',1390,1,1,'mithril','b',236,5,'dualfist',4,4.00000,0,0,0,325,0,99,-1,-1,10091400,1346,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3034-6;'),
(4807,'Blood Tornado','Critical Drain','lrhand','true',1370,1,1,'blood_steel','a',259,5,'dualfist',4,4.00000,0,0,0,325,0,107,-1,-1,14098000,1128,'true','true','true','true','true',0,0,0,0,0,3039,6,33,0,'0-0;'),
(4808,'Blood Tornado','Rsk. Evasion','lrhand','true',1370,1,1,'blood_steel','a',259,5,'dualfist',4,4.00000,0,0,0,325,0,107,-1,-1,14098000,1128,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3030-1;'),
(4809,'Blood Tornado','Haste','lrhand','true',1370,1,1,'blood_steel','a',259,5,'dualfist',4,4.00000,0,0,0,325,0,107,-1,-1,14098000,1128,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3068-2;'),
(4810,'Crystallized Ice Bow','Guidance','lrhand','true',1790,8,2,'crystal','c',220,5,'bow',12,-3.00000,0,0,0,293,6,61,-1,-1,1762900,705,'true','true','true','true','true',0,0,0,0,0,0,0,0,9237,'3008-1;'),
(4811,'Crystallized Ice Bow','Evasion','lrhand','true',1790,8,2,'crystal','c',220,5,'bow',12,-3.00000,0,0,0,293,6,61,-1,-1,1762900,705,'true','true','true','true','true',0,0,0,0,0,0,0,0,9238,'3009-1;'),
(4812,'Crystallized Ice Bow','Quick Recovery','lrhand','true',1790,8,2,'crystal','c',220,5,'bow',12,-3.00000,0,0,0,293,6,61,-1,-1,1762900,705,'true','true','true','true','true',0,0,0,0,0,0,0,0,9239,'0-0;'),
(4813,'Elemental Bow','Guidance','lrhand','true',1770,8,2,'fine_steel','c',277,5,'bow',12,-3.00000,0,0,0,227,7,75,-1,-1,2209700,884,'true','true','true','true','true',0,0,0,0,0,0,0,0,9257,'3008-2;'),
(4814,'Elemental Bow','Miser','lrhand','true',1770,8,2,'fine_steel','c',277,5,'bow',12,-3.00000,0,0,0,227,7,75,-1,-1,2209700,884,'true','true','true','true','true',0,0,0,0,0,0,0,0,9258,'0-0;'),
(4815,'Elemental Bow','Quick Recovery','lrhand','true',1770,8,2,'fine_steel','c',277,5,'bow',12,-3.00000,0,0,0,227,7,75,-1,-1,2209700,884,'true','true','true','true','true',0,0,0,0,0,0,0,0,9259,'0-0;'),
(4816,'Elven Bow of Nobility','Evasion','lrhand','true',1760,8,2,'mithril','c',252,5,'bow',12,-3.00000,0,0,0,293,7,68,-1,-1,2209700,884,'true','true','true','true','true',0,0,0,0,0,0,0,0,9261,'3009-2;'),
(4817,'Elven Bow of Nobility','Miser','lrhand','true',1760,8,2,'mithril','c',252,5,'bow',12,-3.00000,0,0,0,293,7,68,-1,-1,2209700,884,'true','true','true','true','true',0,0,0,0,0,0,0,0,9262,'0-0;'),
(4818,'Elven Bow of Nobility','Cheap Shot','lrhand','true',1760,8,2,'mithril','c',252,5,'bow',12,-3.00000,0,0,0,293,7,68,-1,-1,2209700,884,'true','true','true','true','true',0,0,0,0,0,0,0,0,9263,'0-0;'),
(4819,'Akat Long Bow','Guidance','lrhand','true',1740,9,3,'horn','c',316,5,'bow',12,-3.00000,0,0,0,227,7,84,-1,-1,3304300,1322,'true','true','true','true','true',0,0,0,0,0,0,0,0,9289,'3008-3;'),
(4820,'Akat Long Bow','Evasion','lrhand','true',1740,9,3,'horn','c',316,5,'bow',12,-3.00000,0,0,0,227,7,84,-1,-1,3304300,1322,'true','true','true','true','true',0,0,0,0,0,0,0,0,9290,'3009-3;'),
(4821,'Akat Long Bow','Miser','lrhand','true',1740,9,3,'horn','c',316,5,'bow',12,-3.00000,0,0,0,227,7,84,-1,-1,3304300,1322,'true','true','true','true','true',0,0,0,0,0,0,0,0,9291,'0-0;'),
(4822,'Eminence Bow','Guidance','lrhand','true',1720,10,3,'chrysolite','c',323,5,'bow',12,-3.00000,0,0,0,293,8,83,-1,-1,4713500,1885,'true','true','true','true','true',0,0,0,0,0,0,0,0,9301,'3008-4;'),
(4823,'Eminence Bow','Miser','lrhand','true',1720,10,3,'chrysolite','c',323,5,'bow',12,-3.00000,0,0,0,293,8,83,-1,-1,4713500,1885,'true','true','true','true','true',0,0,0,0,0,0,0,0,9302,'0-0;'),
(4824,'Eminence Bow','Cheap Shot','lrhand','true',1720,10,3,'chrysolite','c',323,5,'bow',12,-3.00000,0,0,0,293,8,83,-1,-1,4713500,1885,'true','true','true','true','true',0,0,0,0,0,0,0,0,9303,'0-0;'),
(4825,'Dark Elven Long Bow','Evasion','lrhand','true',1720,3,1,'oriharukon','b',397,5,'bow',12,-3.00000,0,0,0,227,8,100,-1,-1,6680500,891,'true','true','true','true','true',0,0,0,0,0,0,0,0,9313,'3009-5;'),
(4826,'Dark Elven Long Bow','Critical Bleed','lrhand','true',1720,3,1,'oriharukon','b',397,5,'bow',12,-3.00000,0,0,0,227,8,100,-1,-1,6680500,891,'true','true','true','true','true',0,0,0,0,0,3021,5,41,9314,'0-0;'),
(4827,'Dark Elven Long Bow','Miser','lrhand','true',1720,3,1,'oriharukon','b',397,5,'bow',12,-3.00000,0,0,0,227,8,100,-1,-1,6680500,891,'true','true','true','true','true',0,0,0,0,0,0,0,0,9315,'0-0;'),
(4828,'Bow of Peril','Guidance','lrhand','true',1700,3,1,'blood_steel','b',400,5,'bow',12,-3.00000,0,0,0,293,9,99,-1,-1,10091400,1346,'true','true','true','true','true',0,0,0,0,0,0,0,0,9325,'3008-6;'),
(4829,'Bow of Peril','Quick Recovery','lrhand','true',1700,3,1,'blood_steel','b',400,5,'bow',12,-3.00000,0,0,0,293,9,99,-1,-1,10091400,1346,'true','true','true','true','true',0,0,0,0,0,0,0,0,9326,'0-0;'),
(4830,'Bow of Peril','Cheap Shot','lrhand','true',1700,3,1,'blood_steel','b',400,5,'bow',12,-3.00000,0,0,0,293,9,99,-1,-1,10091400,1346,'true','true','true','true','true',0,0,0,0,0,0,0,0,9327,'0-0;'),
(4831,'Carnage Bow','Critical Bleed','lrhand','true',1670,2,1,'damascus','a',440,5,'bow',12,-3.00000,0,0,0,293,9,107,-1,-1,14098000,1128,'true','true','true','true','true',0,0,0,0,0,3053,1,35,0,'0-0;'),
(4832,'Carnage Bow','Mana Up','lrhand','true',1670,2,1,'damascus','a',440,5,'bow',12,-3.00000,0,0,0,293,9,107,-1,-1,14098000,1128,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3014-2;'),
(4833,'Carnage Bow','Quick Recovery','lrhand','true',1670,2,1,'damascus','a',440,5,'bow',12,-3.00000,0,0,0,293,9,107,-1,-1,14098000,1128,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(4834,'Scythe','Anger','lrhand','true',2040,2,2,'fine_steel','c',107,10,'pole',8,-3.00000,0,0,0,325,0,61,-1,-1,1762900,705,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3600-1;'),
(4835,'Scythe','Critical Stun','lrhand','true',2040,2,2,'fine_steel','c',107,10,'pole',8,-3.00000,0,0,0,325,0,61,-1,-1,1762900,705,'true','true','true','true','true',0,0,0,0,0,3016,1,18,0,'3599-1;'),
(4836,'Scythe','Light','lrhand','true',2040,2,2,'fine_steel','c',107,10,'pole',8,-3.00000,0,0,0,325,0,61,-1,-1,1762900,705,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3599-1;3498-1;'),
(4837,'Orcish Glaive','Anger','lrhand','true',2030,2,2,'fine_steel','c',107,10,'pole',8,-3.00000,0,0,0,325,0,61,-1,-1,1762900,705,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3600-1;'),
(4838,'Orcish Glaive','Critical Stun','lrhand','true',2030,2,2,'fine_steel','c',107,10,'pole',8,-3.00000,0,0,0,325,0,61,-1,-1,1762900,705,'true','true','true','true','true',0,0,0,0,0,3016,1,18,0,'3599-1;'),
(4839,'Orcish Glaive','Towering Blow','lrhand','true',2030,2,2,'fine_steel','c',107,10,'pole',8,-3.00000,0,0,0,325,0,61,-1,-1,1762900,705,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3599-1;'),
(4840,'Body Slasher','Critical Stun','lrhand','true',2030,2,2,'fine_steel','c',107,10,'pole',8,-3.00000,0,0,0,325,0,61,-1,-1,1762900,705,'true','true','true','true','true',0,0,0,0,0,3016,1,18,0,'3599-1;'),
(4841,'Body Slasher','Towering Blow','lrhand','true',2030,2,2,'fine_steel','c',107,10,'pole',8,-3.00000,0,0,0,325,0,61,-1,-1,1762900,705,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3599-1;'),
(4842,'Body Slasher','Wide Blow','lrhand','true',2030,2,2,'fine_steel','c',107,10,'pole',8,-3.00000,0,0,0,325,0,61,-1,-1,1762900,705,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3599-1;'),
(4843,'Bec de Corbin','Critical Stun','lrhand','true',2020,2,2,'fine_steel','c',122,10,'pole',8,-3.00000,0,0,0,325,0,68,-1,-1,2209700,884,'true','true','true','true','true',0,0,0,0,0,3016,2,17,0,'3599-1;'),
(4844,'Bec de Corbin','Towering Blow','lrhand','true',2020,2,2,'fine_steel','c',122,10,'pole',8,-3.00000,0,0,0,325,0,68,-1,-1,2209700,884,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3599-1;'),
(4845,'Bec de Corbin','Light','lrhand','true',2020,2,2,'fine_steel','c',122,10,'pole',8,-3.00000,0,0,0,325,0,68,-1,-1,2209700,884,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3599-1;3498-1;'),
(4846,'Scorpion','Anger','lrhand','true',1990,3,3,'fine_steel','c',144,10,'pole',8,-3.00000,0,0,0,325,0,78,-1,-1,3677700,1471,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3600-3;'),
(4847,'Scorpion','Critical Stun','lrhand','true',1990,3,3,'fine_steel','c',144,10,'pole',8,-3.00000,0,0,0,325,0,78,-1,-1,3677700,1471,'true','true','true','true','true',0,0,0,0,0,3016,3,16,0,'3599-1;'),
(4848,'Scorpion','Towering Blow','lrhand','true',1990,3,3,'fine_steel','c',144,10,'pole',8,-3.00000,0,0,0,325,0,78,-1,-1,3677700,1471,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3599-1;'),
(4849,'Widow Maker','Critical Stun','lrhand','true',1980,3,3,'fine_steel','c',144,10,'pole',8,-3.00000,0,0,0,325,0,78,-1,-1,3677700,1471,'true','true','true','true','true',0,0,0,0,0,3016,3,16,0,'3599-1;'),
(4850,'Widow Maker','Towering Blow','lrhand','true',1980,3,3,'fine_steel','c',144,10,'pole',8,-3.00000,0,0,0,325,0,78,-1,-1,3677700,1471,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3599-1;'),
(4851,'Widow Maker','Wide Blow','lrhand','true',1980,3,3,'fine_steel','c',144,10,'pole',8,-3.00000,0,0,0,325,0,78,-1,-1,3677700,1471,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3599-1;'),
(4852,'Orcish Poleaxe','Critical Stun','lrhand','true',1950,3,3,'blood_steel','c',156,10,'pole',8,-3.00000,0,0,0,325,0,83,-1,-1,4713500,1885,'true','true','true','true','true',0,0,0,0,0,3016,4,15,0,'3599-1;'),
(4853,'Orcish Poleaxe','Towering Blow','lrhand','true',1950,3,3,'blood_steel','c',156,10,'pole',8,-3.00000,0,0,0,325,0,83,-1,-1,4713500,1885,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3599-1;'),
(4854,'Orcish Poleaxe','Wide Blow','lrhand','true',1950,3,3,'blood_steel','c',156,10,'pole',8,-3.00000,0,0,0,325,0,83,-1,-1,4713500,1885,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3599-1;'),
(4855,'Great Axe','Anger','lrhand','true',1940,1,1,'damascus','b',175,10,'pole',8,-3.00000,0,0,0,325,0,91,-1,-1,6680500,891,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3600-5;'),
(4856,'Great Axe','Critical Stun','lrhand','true',1940,1,1,'damascus','b',175,10,'pole',8,-3.00000,0,0,0,325,0,91,-1,-1,6680500,891,'true','true','true','true','true',0,0,0,0,0,3016,5,14,0,'3599-1;'),
(4857,'Great Axe','Light','lrhand','true',1940,1,1,'damascus','b',175,10,'pole',8,-3.00000,0,0,0,325,0,91,-1,-1,6680500,891,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3599-1;3498-1;'),
(4858,'Lance','Anger','lrhand','true',1920,1,1,'blood_steel','b',194,10,'pole',8,-3.00000,0,0,0,325,0,99,-1,-1,10091400,1346,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3600-6;'),
(4859,'Lance','Critical Stun','lrhand','true',1920,1,1,'blood_steel','b',194,10,'pole',8,-3.00000,0,0,0,325,0,99,-1,-1,10091400,1346,'true','true','true','true','true',0,0,0,0,0,3016,6,13,0,'3599-1;'),
(4860,'Lance','Towering Blow','lrhand','true',1920,1,1,'blood_steel','b',194,10,'pole',8,-3.00000,0,0,0,325,0,99,-1,-1,10091400,1346,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3599-1;'),
(4861,'Halberd','Critical Stun','lrhand','true',1900,1,1,'oriharukon','a',213,10,'pole',8,-3.00000,0,0,0,325,0,107,-1,-1,14098000,1128,'true','true','true','true','true',0,0,0,0,0,3016,4,15,0,'3599-1;'),
(4862,'Halberd','Towering Blow','lrhand','true',1900,1,1,'oriharukon','a',213,10,'pole',8,-3.00000,0,0,0,325,0,107,-1,-1,14098000,1128,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3599-1;'),
(4863,'Halberd','Wide Blow','lrhand','true',1900,1,1,'oriharukon','a',213,10,'pole',8,-3.00000,0,0,0,325,0,107,-1,-1,14098000,1128,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3599-1;'),
(4864,'Heavy Doom Hammer','Magic Regeneration','lrhand','true',1020,2,2,'fine_steel','c',103,20,'bigblunt',4,4.00000,0,0,0,325,0,89,-1,-1,1762900,705,'true','true','true','true','true',0,0,1044,1,30,0,0,0,0,'0-0;'),
(4865,'Heavy Doom Hammer','Mental Shield','lrhand','true',1020,2,2,'fine_steel','c',103,20,'bigblunt',4,4.00000,0,0,0,325,0,89,-1,-1,1762900,705,'true','true','true','true','true',0,0,1035,2,30,0,0,0,0,'0-0;'),
(4866,'Heavy Doom Hammer','Magic Hold','lrhand','true',1020,2,2,'fine_steel','c',103,20,'bigblunt',4,4.00000,0,0,0,325,0,89,-1,-1,1762900,705,'true','true','true','true','true',0,0,3577,1,10,0,0,0,0,'0-0;'),
(4867,'Crystal Staff','Rsk. Evasion','lrhand','true',1020,2,2,'crystal','c',103,20,'bigblunt',4,4.00000,0,0,0,325,0,89,-1,-1,1762900,705,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3031-1;'),
(4868,'Crystal Staff','Mana Up','lrhand','true',1020,2,2,'crystal','c',103,20,'bigblunt',4,4.00000,0,0,0,325,0,89,-1,-1,1762900,705,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3014-1;'),
(4869,'Crystal Staff','Blessed Body','lrhand','true',1020,2,2,'crystal','c',103,20,'bigblunt',4,4.00000,0,0,0,325,0,89,-1,-1,1762900,705,'true','true','true','true','true',0,0,1045,2,20,0,0,0,0,'0-0;'),
(4870,'Heavy Doom Axe','Magic Poison','lrhand','true',1010,2,2,'fine_steel','c',103,20,'bigblunt',4,4.00000,0,0,0,325,0,89,-1,-1,1762900,705,'true','true','true','true','true',0,0,1168,6,8,0,0,0,0,'0-0;'),
(4871,'Heavy Doom Axe','Magic Weakness','lrhand','true',1010,2,2,'fine_steel','c',103,20,'bigblunt',4,4.00000,0,0,0,325,0,89,-1,-1,1762900,705,'true','true','true','true','true',0,0,1164,7,8,0,0,0,0,'0-0;'),
(4872,'Heavy Doom Axe','Magic Chaos','lrhand','true',1010,2,2,'fine_steel','c',103,20,'bigblunt',4,4.00000,0,0,0,325,0,89,-1,-1,1762900,705,'true','true','true','true','true',0,0,1222,4,8,0,0,0,0,'0-0;'),
(4873,'Cursed Staff','Magic Hold','lrhand','true',1000,2,2,'wood','c',119,20,'bigblunt',4,4.00000,0,0,0,325,0,100,-1,-1,2209700,884,'true','true','true','true','true',0,0,3577,1,10,0,0,0,0,'0-0;'),
(4874,'Cursed Staff','Magic Poison','lrhand','true',1000,2,2,'wood','c',119,20,'bigblunt',4,4.00000,0,0,0,325,0,100,-1,-1,2209700,884,'true','true','true','true','true',0,0,1168,6,8,0,0,0,0,'0-0;'),
(4875,'Cursed Staff','Magic Weakness','lrhand','true',1000,2,2,'wood','c',119,20,'bigblunt',4,4.00000,0,0,0,325,0,100,-1,-1,2209700,884,'true','true','true','true','true',0,0,1164,8,8,0,0,0,0,'0-0;'),
(4876,'Paradia Staff','Magic Regeneration','lrhand','true',1010,3,3,'wood','c',135,20,'bigblunt',4,4.00000,0,0,0,325,0,111,-1,-1,3304300,1322,'true','true','true','true','true',0,0,1044,2,30,0,0,0,0,'0-0;'),
(4877,'Paradia Staff','Mental Shield','lrhand','true',1010,3,3,'wood','c',135,20,'bigblunt',4,4.00000,0,0,0,325,0,111,-1,-1,3304300,1322,'true','true','true','true','true',0,0,1035,3,30,0,0,0,0,'0-0;'),
(4878,'Paradia Staff','Magic Hold','lrhand','true',1010,3,3,'wood','c',135,20,'bigblunt',4,4.00000,0,0,0,325,0,111,-1,-1,3304300,1322,'true','true','true','true','true',0,0,3577,1,10,0,0,0,0,'0-0;'),
(4879,'Pa\'agrian Hammer','Rsk. Evasion','lrhand','true',1010,3,3,'blood_steel','c',135,20,'bigblunt',4,4.00000,0,0,0,325,0,111,-1,-1,3304300,1322,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3031-3;'),
(4880,'Pa\'agrian Hammer','Magic Poison','lrhand','true',1010,3,3,'blood_steel','c',135,20,'bigblunt',4,4.00000,0,0,0,325,0,111,-1,-1,3304300,1322,'true','true','true','true','true',0,0,1168,6,7,0,0,0,0,'0-0;'),
(4881,'Pa\'agrian Hammer','Magic Weakness','lrhand','true',1010,3,3,'blood_steel','c',135,20,'bigblunt',4,4.00000,0,0,0,325,0,111,-1,-1,3304300,1322,'true','true','true','true','true',0,0,1164,9,7,0,0,0,0,'0-0;'),
(4882,'Sage\'s Staff','Magic Hold','lrhand','true',1000,3,3,'wood','c',135,20,'bigblunt',4,4.00000,0,0,0,325,0,111,-1,-1,3304300,1322,'true','true','true','true','true',0,0,3577,1,10,0,0,0,0,'0-0;'),
(4883,'Sage\'s Staff','Magic Poison','lrhand','true',1000,3,3,'wood','c',135,20,'bigblunt',4,4.00000,0,0,0,325,0,111,-1,-1,3304300,1322,'true','true','true','true','true',0,0,1168,6,7,0,0,0,0,'0-0;'),
(4884,'Sage\'s Staff','Magic Weakness','lrhand','true',1000,3,3,'wood','c',135,20,'bigblunt',4,4.00000,0,0,0,325,0,111,-1,-1,3304300,1322,'true','true','true','true','true',0,0,1164,9,7,0,0,0,0,'0-0;'),
(4885,'Pa\'agrian Axe','Mana Up','lrhand','true',990,3,3,'blood_steel','c',141,20,'bigblunt',4,4.00000,0,0,0,325,0,114,-1,-1,3677700,1471,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3014-1;'),
(4886,'Pa\'agrian Axe','Magic Weakness','lrhand','true',990,3,3,'blood_steel','c',141,20,'bigblunt',4,4.00000,0,0,0,325,0,114,-1,-1,3677700,1471,'true','true','true','true','true',0,0,1164,9,7,0,0,0,0,'0-0;'),
(4887,'Pa\'agrian Axe','Magic Chaos','lrhand','true',990,3,3,'blood_steel','c',141,20,'bigblunt',4,4.00000,0,0,0,325,0,114,-1,-1,3677700,1471,'true','true','true','true','true',0,0,1222,5,7,0,0,0,0,'0-0;'),
(4888,'Deadman\'s Staff','Magic Regeneration','lrhand','true',1010,3,3,'bone','c',152,20,'bigblunt',4,4.00000,0,0,0,325,0,122,-1,-1,4713500,1885,'true','true','true','true','true',0,0,1044,2,30,0,0,0,0,'0-0;'),
(4889,'Deadman\'s Staff','Mental Shield','lrhand','true',1010,3,3,'bone','c',152,20,'bigblunt',4,4.00000,0,0,0,325,0,122,-1,-1,4713500,1885,'true','true','true','true','true',0,0,1035,3,30,0,0,0,0,'0-0;'),
(4890,'Deadman\'s Staff','Magic Hold','lrhand','true',1010,3,3,'bone','c',152,20,'bigblunt',4,4.00000,0,0,0,325,0,122,-1,-1,4713500,1885,'true','true','true','true','true',0,0,3577,1,10,0,0,0,0,'0-0;'),
(4891,'Ghoul\'s Staff','Rsk. Evasion','lrhand','true',1000,3,3,'bone','c',152,20,'bigblunt',4,4.00000,0,0,0,325,0,122,-1,-1,4713500,1885,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3031-4;'),
(4892,'Ghoul\'s Staff','Mana Up','lrhand','true',1000,3,3,'bone','c',152,20,'bigblunt',4,4.00000,0,0,0,325,0,122,-1,-1,4713500,1885,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3014-1;'),
(4893,'Ghoul\'s Staff','Blessed Body','lrhand','true',1000,3,3,'bone','c',152,20,'bigblunt',4,4.00000,0,0,0,325,0,122,-1,-1,4713500,1885,'true','true','true','true','true',0,0,1045,4,20,0,0,0,0,'0-0;'),
(4894,'Demon\'s Staff','Magic Poison','lrhand','true',990,3,3,'wood','c',152,20,'bigblunt',4,4.00000,0,0,0,325,0,122,-1,-1,4713500,1885,'true','true','true','true','true',0,0,1168,6,7,0,0,0,0,'0-0;'),
(4895,'Demon\'s Staff','Magic Weakness','lrhand','true',990,3,3,'wood','c',152,20,'bigblunt',4,4.00000,0,0,0,325,0,122,-1,-1,4713500,1885,'true','true','true','true','true',0,0,1164,10,7,0,0,0,0,'0-0;'),
(4896,'Demon\'s Staff','Magic Chaos','lrhand','true',990,3,3,'wood','c',152,20,'bigblunt',4,4.00000,0,0,0,325,0,122,-1,-1,4713500,1885,'true','true','true','true','true',0,0,1222,5,7,0,0,0,0,'0-0;'),
(4897,'Sprite\'s Staff','Magic Regeneration','lrhand','true',960,1,1,'wood','b',170,20,'bigblunt',4,4.00000,0,0,0,325,0,134,-1,-1,6680500,891,'true','true','true','true','true',0,0,1044,3,30,0,0,0,0,'0-0;'),
(4898,'Sprite\'s Staff','Mental Shield','lrhand','true',960,1,1,'wood','b',170,20,'bigblunt',4,4.00000,0,0,0,325,0,134,-1,-1,6680500,891,'true','true','true','true','true',0,0,1035,4,30,0,0,0,0,'0-0;'),
(4899,'Sprite\'s Staff','Magic Hold','lrhand','true',960,1,1,'wood','b',170,20,'bigblunt',4,4.00000,0,0,0,325,0,134,-1,-1,6680500,891,'true','true','true','true','true',0,0,3577,1,10,0,0,0,0,'0-0;'),
(4900,'Staff of Evil Spirits','Magic Focus','lrhand','true',930,1,1,'wood','b',189,20,'bigblunt',4,4.00000,0,0,0,325,0,145,-1,-1,10091400,1346,'true','true','true','true','true',0,0,1077,3,20,0,0,0,0,'0-0;'),
(4901,'Staff of Evil Spirits','Blessed Body','lrhand','true',930,1,1,'wood','b',189,20,'bigblunt',4,4.00000,0,0,0,325,0,145,-1,-1,10091400,1346,'true','true','true','true','true',0,0,1045,5,20,0,0,0,0,'0-0;'),
(4902,'Staff of Evil Spirits','Magic Poison','lrhand','true',930,1,1,'wood','b',189,20,'bigblunt',4,4.00000,0,0,0,325,0,145,-1,-1,10091400,1346,'true','true','true','true','true',0,0,1168,6,6,0,0,0,0,'0-0;'),
(4903,'Dasparion\'s Staff','','lrhand','true',920,1,1,'adamantaite','a',207,20,'bigblunt',4,4.00000,0,0,0,325,0,143,-1,-1,14098000,1128,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(4904,'Dasparion\'s Staff','','lrhand','true',920,1,1,'adamantaite','a',207,20,'bigblunt',4,4.00000,0,0,0,325,0,143,-1,-1,14098000,1128,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(4905,'Dasparion\'s Staff','','lrhand','true',920,1,1,'adamantaite','a',207,20,'bigblunt',4,4.00000,0,0,0,325,0,143,-1,-1,14098000,1128,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(5127,'Dailaon Knife','','rhand','false',300,2,2,'steel','d',5,5,'dagger',12,-3.00000,0,0,0,433,0,5,-1,-1,409000,743,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(5128,'Crokian Blade','','rhand','true',300,2,2,'steel','d',5,5,'dagger',12,-3.00000,0,0,0,433,0,5,-1,-1,409000,743,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(5129,'Doll Knife','','lrhand','false',300,2,2,'steel','d',200,10,'dual',8,0.00000,0,0,0,325,0,6,-1,-1,409000,743,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(5130,'Nos Sword','','rhand','true',300,2,2,'steel','d',5,5,'dagger',12,-3.00000,0,0,0,433,0,5,-1,-1,409000,743,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(5131,'Parhit Staff','','rhand','true',300,2,2,'steel','d',5,5,'dagger',12,-3.00000,0,0,0,433,0,5,-1,-1,409000,743,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(5132,'Giant Trident','','rhand','true',300,2,2,'steel','d',5,5,'dagger',12,-3.00000,0,0,0,433,0,5,-1,-1,409000,743,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(5133,'Chrono Unitus','','lrhand','false',0,0,0,'steel','none',1,5,'dualfist',4,4.00000,0,0,0,325,0,1,-1,-1,0,0,'true','false','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(5176,'Serpentine Spike','','strider','false',100,0,0,'steel','none',17,10,'pet',8,0.00000,0,0,0,277,0,21,-1,-1,1600000,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(5177,'Drake Horn','','strider','false',100,0,0,'steel','none',19,10,'pet',8,0.00000,0,0,0,277,0,24,-1,-1,2300000,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(5178,'Assault Alicorn','','strider','false',100,0,0,'steel','none',21,10,'pet',8,0.00000,0,0,0,277,0,27,-1,-1,3400000,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(5179,'Draconic Slicer','','strider','false',100,0,0,'steel','none',23,10,'pet',8,0.00000,0,0,0,277,0,30,-1,-1,4900000,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(5180,'Ohpdian Lance','','strider','false',100,0,0,'steel','none',25,10,'pet',8,0.00000,0,0,0,277,0,34,-1,-1,7300000,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(5181,'Diamond Drill','','strider','false',100,0,0,'steel','none',27,10,'pet',8,0.00000,0,0,0,277,0,37,-1,-1,10000000,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(5187,'Serpentine Grinder','','hatchling','false',100,0,0,'steel','none',19,10,'pet',8,0.00000,0,0,0,277,0,24,-1,-1,2300000,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(5188,'Fang of Dahak','','hatchling','false',100,0,0,'steel','none',21,10,'pet',8,0.00000,0,0,0,277,0,27,-1,-1,3400000,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(5189,'Crimson Blood Fang','','hatchling','false',100,0,0,'steel','none',23,10,'pet',8,0.00000,0,0,0,277,0,30,-1,-1,4900000,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(5190,'Draconic Chopper','','hatchling','false',100,0,0,'steel','none',25,10,'pet',8,0.00000,0,0,0,277,0,34,-1,-1,7300000,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(5191,'Diabolic Grinder','','hatchling','false',100,0,0,'steel','none',27,10,'pet',8,0.00000,0,0,0,277,0,37,-1,-1,10000000,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(5217,'Wolf Level 75 Weapon','','wolf','false',100,0,0,'steel','none',194,10,'pet',8,0.00000,0,0,0,277,0,136,-1,-1,61084,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(5233,'Keshanberk*Keshanberk','','lrhand','true',2080,1,1,'fine_steel','a',259,10,'dual',8,0.00000,0,0,0,325,0,107,-1,-1,14098000,1128,'true','true','true','true','true',3045,17,0,0,0,0,0,0,0,'0-0;'),
(5284,'Zweihander','','lrhand','false',1530,2,2,'bronze','none',38,10,'bigsword',8,0.00000,0,0,0,325,0,21,-1,-1,188000,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(5285,'Heavy Sword','','lrhand','true',1520,2,2,'steel','d',49,10,'bigsword',8,0.00000,0,0,0,325,0,26,-1,-1,315000,582,'true','true','true','true','true',0,0,0,0,0,0,0,0,9210,'0-0;'),
(5286,'Berserker Blade','','lrhand','true',1380,3,3,'oriharukon','c',190,10,'bigsword',8,0.00000,0,0,0,325,0,83,-1,-1,4713500,1885,'true','true','true','true','true',0,0,0,0,0,0,0,0,9296,'0-0;'),
(5292,'Sealed Dark Crystal Shield','','lhand','true',1190,0,0,'crystal','a',0,0,'none',0,0.00000,-8,243,20,0,0,0,-1,-1,935000,75,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(5315,'Sealed Shield of Nightmare','','lhand','true',1180,0,0,'leather','a',0,0,'none',0,0.00000,-8,256,20,0,0,0,-1,-1,1422000,114,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(5596,'Dasparion\'s Staff','Mana Up','lrhand','true',920,1,1,'adamantaite','a',207,20,'bigblunt',4,4.00000,0,0,0,325,0,157,-1,-1,14098000,1128,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3014-2;'),
(5597,'Dasparion\'s Staff','Conversion','lrhand','true',920,1,1,'adamantaite','a',207,20,'bigblunt',4,4.00000,0,0,0,325,0,157,-1,-1,14098000,1128,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3048-2;'),
(5598,'Dasparion\'s Staff','Acumen','lrhand','true',920,1,1,'adamantaite','a',207,20,'bigblunt',4,4.00000,0,0,0,325,0,157,-1,-1,14098000,1128,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3047-2;'),
(5599,'Meteor Shower','Focus','rhand','true',1600,1,1,'fine_steel','a',213,20,'blunt',4,4.00000,0,0,0,379,0,107,-1,-1,14098000,1128,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3050-1;'),
(5600,'Meteor Shower','Critical Bleed','rhand','true',1600,1,1,'fine_steel','a',213,20,'blunt',4,4.00000,0,0,0,379,0,107,-1,-1,14098000,1128,'true','true','true','true','true',0,0,0,0,0,3052,1,42,0,'3552-1;'),
(5601,'Meteor Shower','Rsk. Haste','rhand','true',1600,1,1,'fine_steel','a',213,20,'blunt',4,4.00000,0,0,0,379,0,107,-1,-1,14098000,1128,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3056-2;'),
(5602,'Elysian','Health','rhand','true',1580,1,1,'oriharukon','a',232,20,'blunt',4,4.00000,0,0,0,379,0,114,-1,-1,20741000,1659,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3013-3;'),
(5603,'Elysian','Anger','rhand','true',1580,1,1,'oriharukon','a',232,20,'blunt',4,4.00000,0,0,0,379,0,114,-1,-1,20741000,1659,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3057-2;'),
(5604,'Elysian','Critical Drain','rhand','true',1580,1,1,'oriharukon','a',232,20,'blunt',4,4.00000,0,0,0,379,0,114,-1,-1,20741000,1659,'true','true','true','true','true',0,0,0,0,0,3059,2,33,0,'3552-1;'),
(5605,'Branch of the Mother Tree','Conversion','lrhand','true',900,1,1,'wood','a',226,20,'bigblunt',4,4.00000,0,0,0,325,0,167,-1,-1,20741000,1659,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3048-2;'),
(5606,'Branch of the Mother Tree','Magic Damage','lrhand','true',900,1,1,'wood','a',226,20,'bigblunt',4,4.00000,0,0,0,325,0,167,-1,-1,20741000,1659,'true','true','true','true','true',0,0,3049,2,30,0,0,0,0,'3552-1;'),
(5607,'Branch of the Mother Tree','Acumen','lrhand','true',900,1,1,'wood','a',226,20,'bigblunt',4,4.00000,0,0,0,325,0,167,-1,-1,20741000,1659,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3047-2;');

INSERT INTO `weapon` VALUES
(5608,'Carnage Bow','Light','lrhand','true',900,2,1,'damascus','a',440,5,'bow',12,-3.00000,0,0,0,293,9,107,-1,-1,14098000,1128,'true','true','true','true','true',0,0,0,0,0,0,0,0,9337,'3498-1;'),
(5609,'Carnage Bow','Critical Bleed','lrhand','true',1670,2,1,'damascus','a',440,5,'bow',12,-3.00000,0,0,0,293,9,107,-1,-1,14098000,1128,'true','true','true','true','true',0,0,0,0,0,3053,1,35,9338,'3552-1;'),
(5610,'Carnage Bow','Mana Up','lrhand','true',1670,2,1,'damascus','a',440,5,'bow',12,-3.00000,0,0,0,293,9,107,-1,-1,14098000,1128,'true','true','true','true','true',0,0,0,0,0,0,0,0,9339,'3014-2;'),
(5611,'Soul Bow','Cheap Shot','lrhand','true',1660,2,1,'oriharukon','a',528,5,'bow',12,-3.00000,0,0,0,227,10,125,-1,-1,20741000,1659,'true','true','true','true','true',0,0,0,0,0,0,0,0,9349,'3552-1;'),
(5612,'Soul Bow','Quick Recovery','lrhand','true',1660,2,1,'oriharukon','a',528,5,'bow',12,-3.00000,0,0,0,227,10,125,-1,-1,20741000,1659,'true','true','true','true','true',0,0,0,0,0,0,0,0,9350,'3552-1;'),
(5613,'Soul Bow','Critical Poison','lrhand','true',1660,2,1,'oriharukon','a',528,5,'bow',12,-3.00000,0,0,0,227,10,125,-1,-1,20741000,1659,'true','true','true','true','true',0,0,0,0,0,3062,2,18,9351,'3552-1;'),
(5614,'Bloody Orchid','Focus','rhand','true',960,1,1,'blood_steel','a',186,5,'dagger',12,-3.00000,0,0,0,433,0,107,-1,-1,14098000,1128,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3051-1;'),
(5615,'Bloody Orchid','Back Blow','rhand','true',960,1,1,'blood_steel','a',186,5,'dagger',12,-3.00000,0,0,0,433,0,107,-1,-1,14098000,1128,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3063-1;'),
(5616,'Bloody Orchid','Critical Bleed','rhand','true',960,1,1,'blood_steel','a',186,5,'dagger',12,-3.00000,0,0,0,433,0,107,-1,-1,14098000,1128,'true','true','true','true','true',0,0,0,0,0,3054,1,12,0,'3552-1;'),
(5617,'Soul Separator','Guidance','rhand','true',950,1,1,'oriharukon','a',203,5,'dagger',12,-3.00000,0,0,0,433,0,114,-1,-1,20741000,1659,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3064-1;'),
(5618,'Soul Separator','Critical Damage','rhand','true',950,1,1,'oriharukon','a',203,5,'dagger',12,-3.00000,0,0,0,433,0,114,-1,-1,20741000,1659,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3066-2;'),
(5619,'Soul Separator','Rsk. Haste','rhand','true',950,1,1,'oriharukon','a',203,5,'dagger',12,-3.00000,0,0,0,433,0,114,-1,-1,20741000,1659,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3056-2;'),
(5620,'Blood Tornado','Haste','lrhand','true',1370,1,1,'blood_steel','a',259,5,'dualfist',4,4.00000,0,0,0,325,0,107,-1,-1,14098000,1128,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3068-2;'),
(5621,'Blood Tornado','Focus','lrhand','true',1370,1,1,'blood_steel','a',259,5,'dualfist',4,4.00000,0,0,0,325,0,107,-1,-1,14098000,1128,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3050-1;'),
(5622,'Blood Tornado','Anger','lrhand','true',1370,1,1,'blood_steel','a',259,5,'dualfist',4,4.00000,0,0,0,325,0,107,-1,-1,14098000,1128,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3058-1;'),
(5623,'Dragon Grinder','Rsk. Evasion','lrhand','true',1350,1,1,'adamantaite','a',282,5,'dualfist',4,4.00000,0,0,0,325,0,114,-1,-1,20741000,1659,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3069-1;'),
(5624,'Dragon Grinder','Guidance','lrhand','true',1350,1,1,'adamantaite','a',282,5,'dualfist',4,4.00000,0,0,0,325,0,114,-1,-1,20741000,1659,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3065-1;'),
(5625,'Dragon Grinder','Health','lrhand','true',1350,1,1,'adamantaite','a',282,5,'dualfist',4,4.00000,0,0,0,325,0,114,-1,-1,20741000,1659,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3013-3;'),
(5626,'Halberd','Haste','lrhand','true',1900,1,1,'oriharukon','a',213,10,'pole',8,-3.00000,0,0,0,325,0,107,-1,-1,14098000,1128,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3601-7;'),
(5627,'Halberd','Critical Stun','lrhand','true',1900,1,1,'oriharukon','a',213,10,'pole',8,-3.00000,0,0,0,325,0,107,-1,-1,14098000,1128,'true','true','true','true','true',0,0,0,0,0,3070,1,25,0,'3552-2;'),
(5628,'Halberd','Wide Blow','lrhand','true',1900,1,1,'oriharukon','a',213,10,'pole',8,-3.00000,0,0,0,325,0,107,-1,-1,14098000,1128,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3552-2;'),
(5629,'Orcish Halberd','','lrhand','true',1880,1,1,'blood_steel','a',219,10,'pole',8,-3.00000,0,0,0,325,0,109,-1,-1,21300000,1704,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3599-1;'),
(5630,'Orcish Halberd','','lrhand','true',1880,1,1,'blood_steel','a',219,10,'pole',8,-3.00000,0,0,0,325,0,109,-1,-1,21300000,1704,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3599-1;'),
(5631,'Orcish Halberd','','lrhand','true',1880,1,1,'blood_steel','a',219,10,'pole',8,-3.00000,0,0,0,325,0,109,-1,-1,21300000,1704,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3599-1;'),
(5632,'Tallum Glaive','Guidance','lrhand','true',1840,1,1,'chrysolite','a',232,10,'pole',8,-3.00000,0,0,0,325,0,114,-1,-1,20741000,1659,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3602-8;'),
(5633,'Tallum Glaive','Health','lrhand','true',1840,1,1,'chrysolite','a',232,10,'pole',8,-3.00000,0,0,0,325,0,114,-1,-1,20741000,1659,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3013-4;'),
(5634,'Tallum Glaive','Wide Blow','lrhand','true',1840,1,1,'chrysolite','a',232,10,'pole',8,-3.00000,0,0,0,325,0,114,-1,-1,20741000,1659,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3552-2;'),
(5635,'Tallum Blade','Critical Poison','rhand','true',1330,1,1,'adamantaite','a',213,10,'sword',8,0.00000,0,0,0,379,0,107,-1,-1,14098000,1128,'true','true','true','true','true',0,0,0,0,0,3061,1,10,9329,'3552-1;'),
(5636,'Tallum Blade','Haste','rhand','true',1330,1,1,'adamantaite','a',213,10,'sword',8,0.00000,0,0,0,379,0,107,-1,-1,14098000,1128,'true','true','true','true','true',0,0,0,0,0,0,0,0,9330,'3068-2;'),
(5637,'Tallum Blade','Anger','rhand','true',1330,1,1,'adamantaite','a',213,10,'sword',8,0.00000,0,0,0,379,0,107,-1,-1,14098000,1128,'true','true','true','true','true',0,0,0,0,0,0,0,0,9331,'3057-1;'),
(5638,'Elemental Sword','Magic Power','rhand','true',830,1,1,'mithril','a',170,10,'sword',8,0.00000,0,0,0,379,0,143,-1,-1,14098000,1128,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3073-1;'),
(5639,'Elemental Sword','Magic Paralyze','rhand','true',830,1,1,'mithril','a',170,10,'sword',8,0.00000,0,0,0,379,0,143,-1,-1,14098000,1128,'true','true','true','true','true',0,0,3075,1,5,0,0,0,0,'3552-1;'),
(5640,'Elemental Sword','Empower','rhand','true',830,1,1,'mithril','a',170,10,'sword',8,0.00000,0,0,0,379,0,143,-1,-1,14098000,1128,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3072-1;'),
(5641,'Sword of Miracles','Magic Power','rhand','true',840,1,1,'adamantaite','a',186,10,'sword',8,0.00000,0,0,0,379,0,152,-1,-1,20741000,1659,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3073-2;'),
(5642,'Sword of Miracles','Magic Silence','rhand','true',840,1,1,'adamantaite','a',186,10,'sword',8,0.00000,0,0,0,379,0,152,-1,-1,20741000,1659,'true','true','true','true','true',0,0,3074,2,10,0,0,0,0,'3552-1;'),
(5643,'Sword of Miracles','Acumen','rhand','true',840,1,1,'adamantaite','a',186,10,'sword',8,0.00000,0,0,0,379,0,152,-1,-1,20741000,1659,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3047-2;'),
(5644,'Dragon Slayer','Health','lrhand','true',1840,1,1,'bone','a',282,10,'bigsword',8,0.00000,0,0,0,325,0,114,-1,-1,20741000,1659,'true','true','true','true','true',0,0,0,0,0,0,0,0,9345,'3013-3;'),
(5645,'Dragon Slayer','Critical Bleed','lrhand','true',1840,1,1,'bone','a',282,10,'bigsword',8,0.00000,0,0,0,325,0,114,-1,-1,20741000,1659,'true','true','true','true','true',0,0,0,0,0,3055,2,24,9346,'3552-1;'),
(5646,'Dragon Slayer','Critical Drain','lrhand','true',1840,1,1,'bone','a',282,10,'bigsword',8,0.00000,0,0,0,325,0,114,-1,-1,20741000,1659,'true','true','true','true','true',0,0,0,0,0,3060,2,33,9347,'3552-1;'),
(5647,'Dark Legion\'s Edge','Critical Damage','rhand','true',1320,1,1,'fine_steel','a',232,10,'sword',8,0.00000,0,0,0,379,0,114,-1,-1,20741000,1659,'true','true','true','true','true',0,0,0,0,0,0,0,0,9341,'3067-2;'),
(5648,'Dark Legion\'s Edge','Health','rhand','true',1320,1,1,'fine_steel','a',232,10,'sword',8,0.00000,0,0,0,379,0,114,-1,-1,20741000,1659,'true','true','true','true','true',0,0,0,0,0,0,0,0,9342,'3013-3;'),
(5649,'Dark Legion\'s Edge','Rsk. Focus','rhand','true',1320,1,1,'fine_steel','a',232,10,'sword',8,0.00000,0,0,0,379,0,114,-1,-1,20741000,1659,'true','true','true','true','true',0,0,0,0,0,0,0,0,9343,'3071-2;'),
(5704,'Keshanberk*Keshanberk','','lrhand','true',2080,1,1,'fine_steel','a',259,10,'dual',8,0.00000,0,0,0,325,0,107,-1,-1,14098000,1128,'true','true','true','true','true',3045,17,0,0,0,0,0,0,0,'0-0;'),
(5705,'Keshanberk*Damascus','','lrhand','true',2080,1,1,'fine_steel','a',275,10,'dual',8,0.00000,0,0,0,325,0,112,-1,-1,18567400,1485,'true','true','true','true','true',3013,5,0,0,0,0,0,0,0,'0-0;'),
(5706,'Damascus*Damascus','','lrhand','true',2080,1,1,'fine_steel','a',282,10,'dual',8,0.00000,0,0,0,325,0,114,-1,-1,20741000,1659,'true','true','true','true','true',3046,20,0,0,0,0,0,0,0,'0-0;'),
(5791,'Tomb Guard A','','lrhand','true',2180,2,2,'fine_steel','d',78,10,'bigsword',8,0.00000,0,0,0,325,0,39,-1,-1,967000,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(5792,'Tomb Guard B','','lrhand','true',2180,2,2,'fine_steel','d',78,10,'bigsword',8,0.00000,0,0,0,325,0,39,-1,-1,967000,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(5793,'Tomb Savant A','','rhand','true',1380,3,3,'oriharukon','c',156,10,'sword',8,0.00000,0,0,0,379,0,83,-1,-1,6130000,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(5794,'Tomb Savant B','','rhand','true',1380,3,3,'oriharukon','c',156,10,'sword',8,0.00000,0,0,0,379,0,83,-1,-1,6130000,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(5795,'Tomb Guard A','','lrhand','true',2180,2,2,'fine_steel','d',78,10,'bigsword',8,0.00000,0,0,0,325,0,39,-1,-1,967000,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(5796,'Tomb Guard B','','lrhand','true',2180,2,2,'fine_steel','d',78,10,'bigsword',8,0.00000,0,0,0,325,0,39,-1,-1,967000,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(5797,'Tomb Savant A','','rhand','true',1380,3,3,'oriharukon','c',156,10,'sword',8,0.00000,0,0,0,379,0,83,-1,-1,6130000,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(5798,'Tomb Savant B','','rhand','true',1380,3,3,'oriharukon','c',156,10,'sword',8,0.00000,0,0,0,379,0,83,-1,-1,6130000,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(5799,'Nephilim Lord','','lhand','true',1320,0,0,'leather','d',0,0,'none',0,0.00000,-8,142,20,0,0,0,-1,-1,78400,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(5800,'Nephilim Lord','','rhand','true',1380,3,3,'oriharukon','c',156,10,'sword',8,0.00000,0,0,0,379,0,83,-1,-1,6130000,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(5801,'Dusk','','rhand','true',1380,3,3,'oriharukon','c',156,10,'sword',8,0.00000,0,0,0,379,0,83,-1,-1,6130000,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(5802,'Dawn','','rhand','true',1380,3,3,'oriharukon','c',156,10,'sword',8,0.00000,0,0,0,379,0,83,-1,-1,6130000,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(5817,'Chrono Campana','','lrhand','false',0,0,0,'steel','none',1,10,'pole',8,-3.00000,0,0,0,325,0,1,-1,-1,0,0,'true','false','true','true','true',0,0,0,0,0,0,0,0,0,'3599-1;'),
(6307,'Sword of Limit','Guidance','rhand','true',1400,3,3,'fine_steel','c',139,10,'sword',8,0.00000,0,0,0,379,0,76,-1,-1,3304300,1322,'true','true','true','true','true',0,0,0,0,0,0,0,0,9281,'3007-3;'),
(6308,'Sword of Limit','Critical Drain','rhand','true',1400,3,3,'fine_steel','c',139,10,'sword',8,0.00000,0,0,0,379,0,76,-1,-1,3304300,1322,'true','true','true','true','true',0,0,0,0,0,3022,3,33,9282,'0-0;'),
(6309,'Sword of Limit','Health','rhand','true',1400,3,3,'fine_steel','c',139,10,'sword',8,0.00000,0,0,0,379,0,76,-1,-1,3304300,1322,'true','true','true','true','true',0,0,0,0,0,0,0,0,9283,'3013-1;'),
(6310,'Sword of Whispering Death','Empower','rhand','true',920,3,3,'fine_steel','c',111,10,'sword',8,0.00000,0,0,0,379,0,101,-1,-1,3304300,1322,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3076-3;'),
(6311,'Sword of Whispering Death','Magic Power','rhand','true',920,3,3,'fine_steel','c',111,10,'sword',8,0.00000,0,0,0,379,0,101,-1,-1,3304300,1322,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3077-3;'),
(6312,'Sword of Whispering Death','Magic Silence','rhand','true',920,3,3,'fine_steel','c',111,10,'sword',8,0.00000,0,0,0,379,0,101,-1,-1,3304300,1322,'true','true','true','true','true',0,0,3078,3,10,0,0,0,0,'0-0;'),
(6313,'Homunkulus\'s Sword','Acumen','rhand','true',950,3,3,'blood_steel','c',111,10,'sword',8,0.00000,0,0,0,379,0,101,-1,-1,3304300,1322,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3047-1;'),
(6314,'Homunkulus\'s Sword','Conversion','rhand','true',950,3,3,'blood_steel','c',111,10,'sword',8,0.00000,0,0,0,379,0,101,-1,-1,3304300,1322,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3048-1;'),
(6315,'Homunkulus\'s Sword','Magic Paralyze','rhand','true',950,3,3,'blood_steel','c',111,10,'sword',8,0.00000,0,0,0,379,0,101,-1,-1,3304300,1322,'true','true','true','true','true',0,0,3079,3,5,0,0,0,0,'0-0;'),
(6347,'Berserker Blade','Focus','lrhand','true',1380,3,3,'oriharukon','c',190,10,'bigsword',8,0.00000,0,0,0,325,0,83,-1,-1,4713500,1885,'true','true','true','true','true',0,0,0,0,0,0,0,0,9297,'3010-4;'),
(6348,'Berserker Blade','Critical Damage','lrhand','true',1380,3,3,'oriharukon','c',190,10,'bigsword',8,0.00000,0,0,0,325,0,83,-1,-1,4713500,1885,'true','true','true','true','true',0,0,0,0,0,0,0,0,9298,'3542-4;'),
(6349,'Berserker Blade','Haste','lrhand','true',1380,3,3,'oriharukon','c',190,10,'bigsword',8,0.00000,0,0,0,325,0,83,-1,-1,4713500,1885,'true','true','true','true','true',0,0,0,0,0,0,0,0,9299,'3037-4;'),
(6354,'Falchion - for Beginners','','rhand','false',1530,2,2,'bronze','none',31,10,'sword',8,0.00000,0,0,0,379,0,21,-1,-1,0,0,'false','false','false','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(6355,'Mage Staff - for Beginners','','lrhand','false',1050,2,2,'wood','none',30,20,'bigblunt',4,4.00000,0,0,0,325,0,31,-1,-1,0,0,'false','false','false','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(6356,'Dark Elven Dagger','Rsk. Haste','rhand','true',1050,2,2,'fine_steel','c',94,5,'dagger',12,-3.00000,0,0,0,433,0,61,-1,-1,1762900,705,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3033-1;'),
(6357,'Stiletto','Rsk. Haste','rhand','true',1030,2,2,'fine_steel','c',107,5,'dagger',12,-3.00000,0,0,0,433,0,68,-1,-1,2209700,884,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3033-2;'),
(6358,'Crystal Dagger','Critical Damage','rhand','true',1000,3,3,'crystal','c',136,5,'dagger',12,-3.00000,0,0,0,433,0,83,-1,-1,4713500,1885,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3043-4;'),
(6359,'Demon Dagger','Critical Damage','rhand','true',970,1,1,'blood_steel','b',170,5,'dagger',12,-3.00000,0,0,0,433,0,99,-1,-1,10091400,1346,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3043-6;'),
(6364,'Forgotten Blade','','rhand','true',1300,1,1,'adamantaite','s',281,10,'sword',8,0.00000,0,0,0,379,0,132,-1,-1,42759400,2052,'true','true','true','true','true',0,0,0,0,0,0,0,0,9364,'0-0;'),
(6365,'Basalt Battlehammer','','rhand','true',1570,1,1,'adamantaite','s',281,20,'blunt',4,4.00000,0,0,0,379,0,132,-1,-1,42759400,2052,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(6366,'Imperial Staff','','lrhand','true',910,1,1,'adamantaite','s',274,20,'bigblunt',4,4.00000,0,0,0,325,0,193,-1,-1,42759400,2052,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(6367,'Angel Slayer','','rhand','true',950,1,1,'adamantaite','s',246,5,'dagger',12,-3.00000,0,0,0,433,0,132,-1,-1,42759400,2052,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(6368,'Shining Bow','','lrhand','true',1650,1,1,'adamantaite','s',581,5,'bow',12,-3.00000,0,0,0,293,11,132,-1,-1,48800000,2440,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(6369,'Dragon Hunter Axe','','lrhand','true',1820,1,1,'adamantaite','s',342,20,'bigblunt',4,4.00000,0,0,0,325,0,132,-1,-1,42759400,2052,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(6370,'Saint Spear','','lrhand','true',1800,1,1,'adamantaite','s',281,10,'pole',8,-3.00000,0,0,0,325,0,132,-1,-1,42759400,2052,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3599-1;'),
(6371,'Demon Splinter','','lrhand','true',1350,1,1,'adamantaite','s',342,5,'dualfist',4,4.00000,0,0,0,325,0,132,-1,-1,42759400,2052,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(6372,'Heaven\'s Divider','','lrhand','true',1380,1,1,'adamantaite','s',342,10,'bigsword',8,0.00000,0,0,0,325,0,132,-1,-1,42759400,2052,'true','true','true','true','true',0,0,0,0,0,0,0,0,9368,'0-0;'),
(6377,'Imperial Crusader Shield','','lhand','true',1170,0,0,'bone','s',0,0,'none',0,0.00000,-8,290,20,0,0,0,-1,-1,3355000,161,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(6529,'Baby Duck Rod','','lrhand','false',1000,0,0,'bone','none',1,1,'rod',0,-3.00000,0,0,0,325,0,1,-1,-1,30000,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(6530,'Albatross Rod','','lrhand','false',1000,0,0,'bone','d',1,1,'rod',0,-3.00000,0,0,0,325,0,1,-1,-1,100000,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(6531,'Pelican Rod','','lrhand','false',1000,0,0,'bone','c',1,1,'rod',0,-3.00000,0,0,0,325,0,1,-1,-1,400000,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(6532,'KingFisher Rod','','lrhand','false',1000,0,0,'bone','b',1,1,'rod',0,-3.00000,0,0,0,325,0,1,-1,-1,1200000,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(6533,'Cygnus Pole','','lrhand','false',1000,0,0,'bone','a',1,1,'rod',0,-3.00000,0,0,0,325,0,1,-1,-1,4000000,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(6534,'Triton Pole','','lrhand','false',1000,0,0,'bone','s',1,1,'rod',0,-3.00000,0,0,0,325,0,1,-1,-1,10000000,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(6579,'Arcana Mace','','rhand','true',1300,1,1,'adamantaite','s',225,20,'blunt',4,4.00000,0,0,0,379,0,175,-1,-1,42759400,2052,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(6580,'Tallum Blade*Dark Legion\'s Edge','','lrhand','true',2080,1,1,'adamantaite','s',342,10,'dual',8,0.00000,0,0,0,325,0,132,-1,-1,42759400,2052,'true','true','true','true','true',3570,1,0,0,0,0,0,0,0,'0-0;'),
(6581,'Forgotten Blade','Haste','rhand','true',1300,1,1,'adamantaite','s',281,10,'sword',8,0.00000,0,0,0,379,0,132,-1,-1,42759400,2052,'true','true','true','true','true',0,0,0,0,0,0,0,0,9365,'3564-1;'),
(6582,'Forgotten Blade','Health','rhand','true',1300,1,1,'adamantaite','s',281,10,'sword',8,0.00000,0,0,0,379,0,132,-1,-1,42759400,2052,'true','true','true','true','true',0,0,0,0,0,0,0,0,9366,'3013-3;'),
(6583,'Forgotten Blade','Focus','rhand','true',1300,1,1,'adamantaite','s',281,10,'sword',8,0.00000,0,0,0,379,0,132,-1,-1,42759400,2052,'true','true','true','true','true',0,0,0,0,0,0,0,0,9367,'3566-1;'),
(6584,'Basalt Battlehammer','HP Drain','rhand','true',1570,1,1,'adamantaite','s',281,20,'blunt',4,4.00000,0,0,0,379,0,132,-1,-1,42759400,2052,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3568-1;'),
(6585,'Basalt Battlehammer','Health','rhand','true',1570,1,1,'adamantaite','s',281,20,'blunt',4,4.00000,0,0,0,379,0,132,-1,-1,42759400,2052,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3013-3;'),
(6586,'Basalt Battlehammer','HP Regeneration','rhand','true',1570,1,1,'adamantaite','s',281,20,'blunt',4,4.00000,0,0,0,379,0,132,-1,-1,42759400,2052,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3569-1;'),
(6587,'Imperial Staff','Empower','lrhand','true',910,1,1,'adamantaite','s',274,20,'bigblunt',4,4.00000,0,0,0,325,0,193,-1,-1,42759400,2052,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3575-1;'),
(6588,'Imperial Staff','MP Regeneration','lrhand','true',910,1,1,'adamantaite','s',274,20,'bigblunt',4,4.00000,0,0,0,325,0,193,-1,-1,42759400,2052,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3576-1;'),
(6589,'Imperial Staff','Magic Hold','lrhand','true',910,1,1,'adamantaite','s',274,20,'bigblunt',4,4.00000,0,0,0,325,0,193,-1,-1,42759400,2052,'true','true','true','true','true',0,0,3577,1,20,0,0,0,0,'3552-1;'),
(6590,'Angel Slayer','Critical Damage','rhand','true',950,1,1,'adamantaite','s',246,5,'dagger',12,-3.00000,0,0,0,433,0,132,-1,-1,42759400,2052,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3572-1;'),
(6591,'Angel Slayer','HP Drain','rhand','true',950,1,1,'adamantaite','s',246,5,'dagger',12,-3.00000,0,0,0,433,0,132,-1,-1,42759400,2052,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3568-1;'),
(6592,'Angel Slayer','Haste','rhand','true',950,1,1,'adamantaite','s',246,5,'dagger',12,-3.00000,0,0,0,433,0,132,-1,-1,42759400,2052,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3564-1;'),
(6593,'Shining Bow','Cheap Shot','lrhand','true',1650,1,1,'adamantaite','s',581,5,'bow',12,-3.00000,0,0,0,293,11,132,-1,-1,48800000,2440,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3552-1;'),
(6594,'Shining Bow','Focus','lrhand','true',1650,1,1,'adamantaite','s',581,5,'bow',12,-3.00000,0,0,0,293,11,132,-1,-1,48800000,2440,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3567-1;'),
(6595,'Shining Bow','Critical Slow','lrhand','true',1650,1,1,'adamantaite','s',581,5,'bow',12,-3.00000,0,0,0,293,11,132,-1,-1,48800000,2440,'true','true','true','true','true',0,0,0,0,0,3574,1,16,0,'0-0;'),
(6596,'Dragon Hunter Axe','HP Regeneration','lrhand','true',1820,1,1,'adamantaite','s',342,20,'bigblunt',4,4.00000,0,0,0,325,0,132,-1,-1,42759400,2052,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3569-1;'),
(6597,'Dragon Hunter Axe','Health','lrhand','true',1820,1,1,'adamantaite','s',342,20,'bigblunt',4,4.00000,0,0,0,325,0,132,-1,-1,42759400,2052,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3013-3;'),
(6598,'Dragon Hunter Axe','HP Drain','lrhand','true',1820,1,1,'adamantaite','s',342,20,'bigblunt',4,4.00000,0,0,0,325,0,132,-1,-1,42759400,2052,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3568-1;'),
(6599,'Saint Spear','Health','lrhand','true',1800,1,1,'adamantaite','s',281,10,'pole',8,-3.00000,0,0,0,325,0,132,-1,-1,42759400,2052,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3013-4;'),
(6600,'Saint Spear','Guidance','lrhand','true',1800,1,1,'adamantaite','s',281,10,'pole',8,-3.00000,0,0,0,325,0,132,-1,-1,42759400,2052,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3602-9;'),
(6601,'Saint Spear','Haste','lrhand','true',1800,1,1,'adamantaite','s',281,10,'pole',8,-3.00000,0,0,0,325,0,132,-1,-1,42759400,2052,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3601-9;'),
(6602,'Demon Splinter','Focus','lrhand','true',1350,1,1,'adamantaite','s',342,5,'dualfist',4,4.00000,0,0,0,325,0,132,-1,-1,42759400,2052,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3565-1;'),
(6603,'Demon Splinter','Health','lrhand','true',1350,1,1,'adamantaite','s',342,5,'dualfist',4,4.00000,0,0,0,325,0,132,-1,-1,42759400,2052,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3013-3;'),
(6604,'Demon Splinter','Critical Stun','lrhand','true',1350,1,1,'adamantaite','s',342,5,'dualfist',4,4.00000,0,0,0,325,0,132,-1,-1,42759400,2052,'true','true','true','true','true',0,0,0,0,0,3571,1,27,0,'3552-1;'),
(6605,'Heavens Divider','Haste','lrhand','true',1380,1,1,'adamantaite','s',342,10,'bigsword',8,0.00000,0,0,0,325,0,132,-1,-1,42759400,2052,'true','true','true','true','true',0,0,0,0,0,0,0,0,9369,'3564-1;'),
(6606,'Heavens Divider','Health','lrhand','true',1380,1,1,'adamantaite','s',342,10,'bigsword',8,0.00000,0,0,0,325,0,132,-1,-1,42759400,2052,'true','true','true','true','true',0,0,0,0,0,0,0,0,9370,'3013-3;'),
(6607,'Heavens Divider','Focus','lrhand','true',1380,1,1,'adamantaite','s',342,10,'bigsword',8,0.00000,0,0,0,325,0,132,-1,-1,42759400,2052,'true','true','true','true','true',0,0,0,0,0,0,0,0,9371,'3566-1;'),
(6608,'Arcana Mace','Acumen','rhand','true',1300,1,1,'adamantaite','s',225,20,'blunt',4,4.00000,0,0,0,379,0,175,-1,-1,42759400,2052,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3047-2;'),
(6609,'Arcana Mace','MP Regeneration','rhand','true',1300,1,1,'adamantaite','s',225,20,'blunt',4,4.00000,0,0,0,379,0,175,-1,-1,42759400,2052,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3576-1;'),
(6610,'Arcana Mace','Mana Up','rhand','true',1300,1,1,'adamantaite','s',225,20,'blunt',4,4.00000,0,0,0,379,0,175,-1,-1,42759400,2052,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3014-2;'),
(6611,'Infinity Blade','','rhand','false',1300,1,1,'adamantaite','s',379,10,'sword',8,0.00000,0,0,0,379,0,169,-1,-1,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'3578-1;'),
(6612,'Infinity Cleaver','','lrhand','false',1300,1,1,'adamantaite','s',461,10,'bigsword',8,0.00000,0,0,0,325,0,169,-1,-1,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'3582-1;'),
(6613,'Infinity Axe','','rhand','false',1300,1,1,'adamantaite','s',379,20,'blunt',4,4.00000,0,0,0,379,0,169,-1,-1,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'3580-1;'),
(6614,'Infinity Rod','','rhand','false',1300,1,1,'adamantaite','s',303,20,'blunt',4,4.00000,0,0,0,379,0,226,-1,-1,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'3597-1;'),
(6615,'Infinity Crusher','','lrhand','false',1300,1,1,'adamantaite','s',461,20,'bigblunt',4,4.00000,0,0,0,325,0,169,-1,-1,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'3583-1;'),
(6616,'Infinity Scepter','','lrhand','false',1300,1,1,'adamantaite','s',369,20,'bigblunt',4,4.00000,0,0,0,325,0,249,-1,-1,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'3595-1;'),
(6617,'Infinity Stinger','','rhand','false',1300,1,1,'adamantaite','s',332,5,'dagger',12,-3.00000,0,0,0,433,0,169,-1,-1,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'3589-1;'),
(6618,'Infinity Fang','','lrhand','false',1300,1,1,'adamantaite','s',461,5,'dualfist',4,4.00000,0,0,0,325,0,169,-1,-1,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'3587-1;'),
(6619,'Infinity Bow','','lrhand','false',1300,1,1,'adamantaite','s',707,5,'bow',12,-3.00000,0,0,0,293,11,169,-1,-1,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'3593-1;'),
(6620,'Infinity Wing','','lrhand','false',1300,1,1,'adamantaite','s',461,10,'dual',8,0.00000,0,0,0,325,0,169,-1,-1,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'3585-1;'),
(6621,'Infinity Spear','','lrhand','false',1300,1,1,'adamantaite','s',379,10,'pole',8,-3.00000,0,0,0,325,0,169,-1,-1,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'3591-1;'),
(6678,'Sealed Imperial Crusader Shield','','lhand','true',1170,0,0,'bone','s',0,0,'none',0,0.00000,-8,276,20,0,0,0,-1,-1,3355000,161,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(6715,'Monster Only(Silenos Archer)','','lrhand','false',1950,1,1,'wood','none',16,5,'bow',12,-3.00000,0,0,0,293,1,6,-1,-1,768,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(6716,'Monster Only(Silenos Shaman)','','lrhand','false',1080,1,1,'wood','none',11,20,'bigblunt',4,4.00000,0,0,0,325,0,12,-1,-1,12500,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(6717,'Monster Only(Einhasad Warrior)','','rhand','false',1560,2,2,'fine_steel','none',24,10,'sword',8,0.00000,0,0,0,379,0,17,-1,-1,136000,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(6718,'Monster Only(Einhasad Shaman)','','lrhand','false',1560,2,2,'adamantaite','none',24,20,'bigblunt',4,4.00000,0,0,0,325,0,17,-1,-1,136000,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(6719,'Monster Only(Ketra Orc Chieftain)','','lrhand','false',990,3,3,'blood_steel','c',141,20,'bigblunt',4,4.00000,0,0,0,325,0,104,-1,-1,4780000,1912,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(6720,'Monster Only(Shadow of Halisha)','','lrhand','false',1950,1,1,'wood','none',16,5,'bow',12,-3.00000,0,0,0,293,1,6,-1,-1,768,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(6721,'Monster Only(Shield of Imperial Warlord Zombie)','','lhand','false',1430,0,0,'leather','none',0,0,'none',0,0.00000,-8,47,20,0,0,0,-1,-1,39,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(6722,'Monster Only(Ahrimanes)','','lrhand','false',2080,1,1,'fine_steel','b',236,10,'dual',8,0.00000,0,0,0,325,0,99,-1,-1,13100000,1746,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(6723,'Monster Only(Vampire Warrior)','','lrhand','false',2090,3,3,'fine_steel','d',112,10,'bigsword',8,0.00000,0,0,0,325,0,54,-1,-1,1800000,3272,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(6902,'Pledge Shield','','lhand','false',1380,0,0,'bone','none',0,0,'none',0,0.00000,-8,90,20,0,0,0,-1,-1,9900,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(6917,'Monster Only (Poison Sting)','','lrhand','false',6,0,0,'wood','none',0,0,'dualfist',0,0.00000,0,0,0,0,0,0,-1,-1,2,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(6918,'Monster Only (Shield of Silenos)','','lhand','false',1380,0,0,'bone','none',0,0,'none',0,0.00000,-8,90,20,0,0,0,-1,-1,12900,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(6919,'Monster Only (Shield of Ketra Orc)','','lhand','false',1320,0,0,'fine_steel','none',0,0,'none',0,0.00000,-8,142,20,0,0,0,-1,-1,78400,142,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(7014,'Monster Only (Shield of Dark Dragon)','','lhand','false',4800,0,0,'damascus','none',0,0,'none',0,0.00000,-8,230,20,0,0,0,-1,-1,845000,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(7015,'Shield of Castle Pledge','','lhand','false',1380,0,0,'bone','none',0,0,'none',0,0.00000,-8,90,20,0,0,0,-1,-1,9900,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(7058,'Chrono Darbuka','','lrhand','false',0,0,0,'steel','none',1,20,'bigblunt',4,4.00000,0,0,0,325,0,1,-1,-1,0,0,'true','false','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(7560,'Monster Only (Fishing Rod)','','lrhand','false',1000,0,0,'bone','none',1,1,'rod',0,-3.00000,0,0,0,325,0,1,-1,-1,30000,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(7575,'Draconic Bow','','lrhand','true',1650,1,1,'adamantaite','s',581,5,'bow',12,-3.00000,0,0,0,293,11,132,-1,-1,42759400,2052,'true','true','true','true','true',0,0,0,0,0,0,0,0,9372,'0-0;'),
(7576,'Draconic Bow','Cheap Shot','lrhand','true',1650,1,1,'adamantaite','s',581,5,'bow',12,-3.00000,0,0,0,293,11,132,-1,-1,42759400,2052,'true','true','true','true','true',0,0,0,0,0,0,0,0,9373,'3552-1;'),
(7577,'Draconic Bow','Focus','lrhand','true',1650,1,1,'adamantaite','s',581,5,'bow',12,-3.00000,0,0,0,293,11,132,-1,-1,42759400,2052,'true','true','true','true','true',0,0,0,0,0,0,0,0,9374,'3567-1;'),
(7578,'Draconic Bow','Critical Slow','lrhand','true',1650,1,1,'adamantaite','s',581,5,'bow',12,-3.00000,0,0,0,293,11,132,-1,-1,42759400,2052,'true','true','true','true','true',0,0,0,0,0,3574,1,16,9375,'3552-1;'),
(7701,'Stick of Faith','Mana Up','rhand','true',1160,2,2,'wood','c',85,20,'blunt',4,4.00000,0,0,0,379,0,81,-1,-1,1762900,705,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3014-1;'),
(7702,'Stick of Faith','Magic Hold','rhand','true',1160,2,2,'wood','c',85,20,'blunt',4,4.00000,0,0,0,379,0,81,-1,-1,1762900,705,'true','true','true','true','true',0,0,3577,1,10,0,0,0,0,'0-0;'),
(7703,'Stick of Faith','Magic Shield','rhand','true',1160,2,2,'wood','c',85,20,'blunt',4,4.00000,0,0,0,379,0,81,-1,-1,1762900,705,'true','true','true','true','true',0,0,1035,2,50,0,0,0,0,'0-0;'),
(7704,'Stick of Eternity','Empower','rhand','true',1130,3,3,'wood','c',111,20,'blunt',4,4.00000,0,0,0,379,0,101,-1,-1,3304300,1322,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3076-3;'),
(7705,'Stick of Eternity','Rsk.,Evasion','rhand','true',1130,3,3,'wood','c',111,20,'blunt',4,4.00000,0,0,0,379,0,101,-1,-1,3304300,1322,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3030-3;'),
(7706,'Stick of Eternity','Blessed Body','rhand','true',1130,3,3,'wood','c',111,20,'blunt',4,4.00000,0,0,0,379,0,101,-1,-1,3304300,1322,'true','true','true','true','true',0,0,1045,3,20,0,0,0,0,'0-0;'),
(7707,'Nirvana Axe','Magic Power','rhand','true',1150,3,3,'fine_steel','c',111,20,'blunt',4,4.00000,0,0,0,379,0,101,-1,-1,3304300,1322,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3077-3;'),
(7708,'Nirvana Axe','Magic Poison','rhand','true',1150,3,3,'fine_steel','c',111,20,'blunt',4,4.00000,0,0,0,379,0,101,-1,-1,3304300,1322,'true','true','true','true','true',0,0,1168,6,7,0,0,0,0,'0-0;'),
(7709,'Nirvana Axe','Magic Weakness','rhand','true',1150,3,3,'fine_steel','c',111,20,'blunt',4,4.00000,0,0,0,379,0,101,-1,-1,3304300,1322,'true','true','true','true','true',0,0,1164,9,7,0,0,0,0,'0-0;'),
(7710,'Club of Nature','Acumen','rhand','true',1100,3,3,'wood','c',111,20,'blunt',4,4.00000,0,0,0,379,0,101,-1,-1,3304300,1322,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3047-1;'),
(7711,'Club of Nature','Magic Mental Shield','rhand','true',1100,3,3,'wood','c',111,20,'blunt',4,4.00000,0,0,0,379,0,101,-1,-1,3304300,1322,'true','true','true','true','true',0,0,1035,3,50,0,0,0,0,'0-0;'),
(7712,'Club of Nature','Magic Hold','rhand','true',1100,3,3,'wood','c',111,20,'blunt',4,4.00000,0,0,0,379,0,101,-1,-1,3304300,1322,'true','true','true','true','true',0,0,3577,1,10,0,0,0,0,'0-0;'),
(7713,'Mace of the Underworld','Mana Up','rhand','true',1090,3,3,'fine_steel','c',111,20,'blunt',4,4.00000,0,0,0,379,0,101,-1,-1,3304300,1322,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3014-1;'),
(7714,'Mace of the Underworld','Magic Silence','rhand','true',1090,3,3,'fine_steel','c',111,20,'blunt',4,4.00000,0,0,0,379,0,101,-1,-1,3304300,1322,'true','true','true','true','true',0,0,3078,3,10,0,0,0,0,'0-0;'),
(7715,'Mace of the Underworld','Conversion','rhand','true',1090,3,3,'fine_steel','c',111,20,'blunt',4,4.00000,0,0,0,379,0,101,-1,-1,3304300,1322,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3048-1;'),
(7716,'Inferno Staff','Acumen','lrhand','true',1000,3,3,'wood','c',135,20,'bigblunt',4,4.00000,0,0,0,325,0,111,-1,-1,3304300,1322,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3047-1;'),
(7717,'Inferno Staff','Magic Silence','lrhand','true',1000,3,3,'wood','c',135,20,'bigblunt',4,4.00000,0,0,0,325,0,111,-1,-1,3304300,1322,'true','true','true','true','true',0,0,3078,3,10,0,0,0,0,'0-0;'),
(7718,'Inferno Staff','Magic Paralyze','lrhand','true',1000,3,3,'wood','c',135,20,'bigblunt',4,4.00000,0,0,0,325,0,111,-1,-1,3304300,1322,'true','true','true','true','true',0,0,3079,3,5,0,0,0,0,'0-0;'),
(7719,'Poleaxe','Critical Stun','lrhand','true',2010,3,3,'bronze','c',139,10,'pole',8,-3.00000,0,0,0,325,0,76,-1,-1,3304300,1322,'true','true','true','true','true',0,0,0,0,0,3070,1,25,0,'3599-1;'),
(7720,'Poleaxe','Towering Blow','lrhand','true',2010,3,3,'bronze','c',139,10,'pole',8,-3.00000,0,0,0,325,0,76,-1,-1,3304300,1322,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3599-1;'),
(7721,'Poleaxe','Wide Blow','lrhand','true',2010,3,3,'bronze','c',139,10,'pole',8,-3.00000,0,0,0,325,0,76,-1,-1,3304300,1322,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3599-1;'),
(7722,'Sword of Valhalla','Acumen','rhand','true',900,1,1,'oriharukon','b',140,10,'sword',8,0.00000,0,0,0,379,0,122,-1,-1,6680500,891,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3047-1;'),
(7723,'Sword of Valhalla','Magic Weakness','rhand','true',900,1,1,'oriharukon','b',140,10,'sword',8,0.00000,0,0,0,379,0,122,-1,-1,6680500,891,'true','true','true','true','true',0,0,1164,11,7,0,0,0,0,'0-0;'),
(7724,'Sword of Valhalla','Magic Regeneration','rhand','true',900,1,1,'oriharukon','b',140,10,'sword',8,0.00000,0,0,0,379,0,122,-1,-1,6680500,891,'true','true','true','true','true',0,0,1044,3,30,0,0,0,0,'0-0;'),
(7810,'Soulfire Dirk','Mana Up','rhand','true',750,2,2,'fine_steel','c',86,5,'dagger',12,-3.00000,0,0,0,433,0,91,-1,-1,2209700,884,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3014-1;'),
(7811,'Soulfire Dirk','Magic Hold','rhand','true',750,2,2,'fine_steel','c',86,5,'dagger',12,-3.00000,0,0,0,433,0,91,-1,-1,2209700,884,'true','true','true','true','true',0,0,3577,1,10,0,0,0,0,'0-0;'),
(7812,'Soulfire Dirk','Magic Silence','rhand','true',750,2,2,'fine_steel','c',86,5,'dagger',12,-3.00000,0,0,0,433,0,91,-1,-1,2209700,884,'true','true','true','true','true',0,0,3074,2,10,0,0,0,0,'3552-1;'),
(7813,'Hell Knife','Magic Regeneration','rhand','true',740,1,1,'blood_steel','b',122,5,'dagger',12,-3.00000,0,0,0,433,0,122,-1,-1,6680500,891,'true','true','true','true','true',0,0,1044,3,30,0,0,0,0,'0-0;'),
(7814,'Hell Knife','Mental Shield','rhand','true',740,1,1,'blood_steel','b',122,5,'dagger',12,-3.00000,0,0,0,433,0,122,-1,-1,6680500,891,'true','true','true','true','true',0,0,1035,4,50,0,0,0,0,'0-0;'),
(7815,'Hell Knife','Magic Weakness','rhand','true',740,1,1,'blood_steel','b',122,5,'dagger',12,-3.00000,0,0,0,433,0,122,-1,-1,6680500,891,'true','true','true','true','true',0,0,1164,11,7,0,0,0,0,'0-0;'),
(7816,'Apprentice Adventurer\'s Staff','','lrhand','false',1070,2,2,'wood','none',23,20,'bigblunt',4,4.00000,0,0,0,325,0,24,-1,-1,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(7817,'Apprentice Adventurer\'s Bone Club','','rhand','false',1850,2,2,'fine_steel','none',24,20,'blunt',4,4.00000,0,0,0,379,0,17,-1,-1,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(7818,'Apprentice Adventurer\'s Knife','','rhand','false',1120,2,2,'mithril','none',21,5,'dagger',12,-3.00000,0,0,0,433,0,17,-1,-1,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(7819,'Apprentice Adventurer\'s Cestus','','lrhand','false',1570,2,2,'steel','none',29,5,'dualfist',4,4.00000,0,0,0,325,0,17,-1,-1,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(7820,'Apprentice Adventurer\'s Bow','','lrhand','false',1900,7,2,'wood','none',49,5,'bow',12,-3.00000,0,0,0,293,3,17,-1,-1,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(7821,'Apprentice Adventurer\'s Long Sword','','rhand','false',1560,2,2,'fine_steel','none',24,10,'sword',8,0.00000,0,0,0,379,0,17,-1,-1,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(7822,'Traveler\'s Mace','','rhand','false',1300,2,2,'steel','d',41,20,'blunt',4,4.00000,0,0,0,379,0,43,-1,-1,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(7823,'Traveler\'s Dark Elven Bow','','lrhand','false',1830,6,2,'steel','d',105,5,'bow',12,-3.00000,0,0,0,293,4,32,-1,-1,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(7824,'Traveler\'s Long Bow','','lrhand','false',1830,6,2,'steel','d',105,5,'bow',12,-3.00000,0,0,0,293,4,32,-1,-1,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(7825,'Traveler\'s Staff','','lrhand','false',1040,2,2,'wood','d',50,20,'bigblunt',4,4.00000,0,0,0,325,0,47,-1,-1,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(7826,'Traveler\'s Bastard Sword','','rhand','false',1510,2,2,'fine_steel','d',51,10,'sword',8,0.00000,0,0,0,379,0,32,-1,-1,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(7827,'Traveler\'s Wand','','rhand','false',570,2,2,'steel','d',41,10,'etc',8,0.00000,0,0,0,379,0,43,-1,-1,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(7828,'Traveler\'s Jamadhr','','lrhand','false',1550,2,2,'steel','d',62,5,'dualfist',4,4.00000,0,0,0,325,0,32,-1,-1,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(7829,'Traveler\'s Tomahawk','','rhand','false',1780,2,2,'bronze','d',51,20,'blunt',4,4.00000,0,0,0,379,0,32,-1,-1,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(7830,'Traveler\'s Poniard Dagger','','rhand','false',1090,2,2,'steel','d',45,5,'dagger',12,-3.00000,0,0,0,433,0,32,-1,-1,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(7831,'Traveler\'s Pike','','lrhand','false',2090,2,2,'steel','d',51,10,'pole',8,-3.00000,0,0,0,325,0,32,-1,-1,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3599-1;'),
(7834,'Art of Battle Axe','','rhand','true',1570,1,1,'chrysolite','b',194,20,'blunt',4,4.00000,0,0,0,379,0,99,-1,-1,13100000,1746,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(7880,'Steel Sword','','lrhand','true',2100,2,2,'fine_steel','d',49,10,'bigsword',8,0.00000,0,0,0,325,0,26,-1,-1,315000,582,'true','true','true','true','true',0,0,0,0,0,0,0,0,9211,'0-0;'),
(7881,'Titan Sword','','lrhand','true',2020,3,3,'fine_steel','d',96,10,'bigsword',8,0.00000,0,0,0,325,0,47,-1,-1,1074000,1983,'true','true','true','true','true',0,0,0,0,0,0,0,0,9223,'0-0;'),
(7882,'Pa\'agrian Sword','','lrhand','true',1980,3,3,'steel','c',169,10,'bigsword',8,0.00000,0,0,0,325,0,76,-1,-1,3304300,1322,'true','true','true','true','true',0,0,0,0,0,0,0,0,9284,'0-0;'),
(7883,'Guardian Sword','','lrhand','true',1930,1,1,'steel','b',236,10,'bigsword',8,0.00000,0,0,0,325,0,99,-1,-1,10091400,1346,'true','true','true','true','true',0,0,0,0,0,0,0,0,9320,'0-0;'),
(7884,'Infernal Master','','lrhand','true',1900,1,1,'fine_steel','a',259,10,'bigsword',8,0.00000,0,0,0,325,0,107,-1,-1,14098000,1128,'true','true','true','true','true',0,0,0,0,0,0,0,0,9332,'0-0;'),
(7885,'Priest Sword','','rhand','true',1520,2,2,'fine_steel','d',32,10,'sword',8,0.00000,0,0,0,379,0,35,-1,-1,315000,582,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(7886,'Sword of Magic Fog','','rhand','true',1450,3,3,'fine_steel','d',63,10,'sword',8,0.00000,0,0,0,379,0,63,-1,-1,1074000,1953,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(7887,'Mysterious Sword','','rhand','true',1430,2,2,'fine_steel','c',85,10,'sword',8,0.00000,0,0,0,379,0,81,-1,-1,1762900,705,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(7888,'Ecliptic Sword','','rhand','true',1380,3,3,'oriharukon','c',125,10,'sword',8,0.00000,0,0,0,379,0,111,-1,-1,4713500,1885,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(7889,'Wizard\'s Tear','','rhand','true',1350,1,1,'oriharukon','b',155,10,'sword',8,0.00000,0,0,0,379,0,132,-1,-1,10091400,1346,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(7890,'Priest Mace','','rhand','true',1720,3,3,'steel','d',63,20,'blunt',4,4.00000,0,0,0,379,0,63,-1,-1,1074000,1983,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(7891,'Ecliptic Axe','','rhand','true',1640,3,3,'fine_steel','c',125,20,'blunt',4,4.00000,0,0,0,379,0,111,-1,-1,4713500,1885,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(7892,'Spell Breaker','','rhand','true',1620,1,1,'fine_steel','b',140,20,'blunt',4,4.00000,0,0,0,379,0,122,-1,-1,6680500,891,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(7893,'Kaim Vanul\'s Bones','','rhand','true',1570,1,1,'bone','b',155,20,'blunt',4,4.00000,0,0,0,379,0,132,-1,-1,10091400,1346,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(7894,'Spiritual Eye','','rhand','true',1550,1,1,'bone','a',170,20,'blunt',4,4.00000,0,0,0,379,0,143,-1,-1,14098000,1128,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(7895,'Flaming Dragon Skull','','rhand','true',1530,1,1,'fine_steel','a',186,20,'blunt',4,4.00000,0,0,0,379,0,152,-1,-1,20741000,1659,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(7896,'Titan Hammer','','lrhand','true',2100,3,3,'steel','d',96,20,'bigblunt',4,4.00000,0,0,0,325,0,47,-1,-1,1074000,1983,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(7897,'Dwarven Hammer','','lrhand','true',2010,3,3,'steel','c',190,20,'bigblunt',4,4.00000,0,0,0,325,0,83,-1,-1,4713500,1885,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(7898,'Karik Horn','','lrhand','true',2020,3,3,'oriharukon','c',169,20,'bigblunt',4,4.00000,0,0,0,325,0,76,-1,-1,3304300,1322,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(7899,'Destroyer Hammer','','lrhand','true',1910,1,1,'fine_steel','a',259,20,'bigblunt',4,4.00000,0,0,0,325,0,107,-1,-1,14098000,1128,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(7900,'Ice Storm Hammer','','lrhand','true',1950,1,1,'fine_steel','b',213,20,'bigblunt',4,4.00000,0,0,0,325,0,91,-1,-1,6680500,891,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(7901,'Star Buster','','lrhand','true',1930,1,1,'fine_steel','b',236,20,'bigblunt',4,4.00000,0,0,0,325,0,99,-1,-1,10091400,1346,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(7902,'Doom Crusher','','lrhand','true',1900,1,1,'fine_steel','a',282,20,'bigblunt',4,4.00000,0,0,0,325,0,114,-1,-1,20741000,1659,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(7903,'Frintezza\'s Sword','','lrhand','true',2180,2,2,'fine_steel','none',78,10,'bigsword',8,0.00000,0,0,0,325,0,39,-1,-1,967000,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(8102,'Pa\'agrian Sword','Focus','lrhand','true',1980,3,3,'steel','c',169,10,'bigsword',8,0.00000,0,0,0,325,0,76,-1,-1,3304300,1322,'true','true','true','true','true',0,0,0,0,0,0,0,0,9285,'3010-3;'),
(8103,'Pa\'agrian Sword','Health','lrhand','true',1980,3,3,'steel','c',169,10,'bigsword',8,0.00000,0,0,0,325,0,76,-1,-1,3304300,1322,'true','true','true','true','true',0,0,0,0,0,0,0,0,9286,'3013-1;'),
(8104,'Pa\'agrian Sword','Critical Drain','lrhand','true',1980,3,3,'steel','c',169,10,'bigsword',8,0.00000,0,0,0,325,0,76,-1,-1,3304300,1322,'true','true','true','true','true',0,0,0,0,0,3022,2,33,9287,'0-0;'),
(8105,'Guardian Sword','Critical Drain','lrhand','true',1930,1,1,'steel','b',236,10,'bigsword',8,0.00000,0,0,0,325,0,99,-1,-1,10091400,1346,'true','true','true','true','true',0,0,0,0,0,3022,6,33,9321,'0-0;'),
(8106,'Guardian Sword','Health','lrhand','true',1930,1,1,'steel','b',236,10,'bigsword',8,0.00000,0,0,0,325,0,99,-1,-1,10091400,1346,'true','true','true','true','true',0,0,0,0,0,0,0,0,9322,'3013-1;'),
(8107,'Guardian Sword','Critical Bleed','lrhand','true',1930,1,1,'steel','b',236,10,'bigsword',8,0.00000,0,0,0,325,0,99,-1,-1,10091400,1346,'true','true','true','true','true',0,0,0,0,0,3055,2,24,9323,'0-0;'),
(8108,'Infernal Master','Haste','lrhand','true',1900,1,1,'fine_steel','a',259,10,'bigsword',8,0.00000,0,0,0,325,0,107,-1,-1,14098000,1128,'true','true','true','true','true',0,0,0,0,0,0,0,0,9333,'3564-2;'),
(8109,'Infernal Master','Critical Damage','lrhand','true',1900,1,1,'fine_steel','a',259,10,'bigsword',8,0.00000,0,0,0,325,0,107,-1,-1,14098000,1128,'true','true','true','true','true',0,0,0,0,0,0,0,0,9334,'3067-1;'),
(8110,'Infernal Master','Focus','lrhand','true',1900,1,1,'fine_steel','a',259,10,'bigsword',8,0.00000,0,0,0,325,0,107,-1,-1,14098000,1128,'true','true','true','true','true',0,0,0,0,0,0,0,0,9335,'3050-2;'),
(8111,'Mysterious Sword','Acumen','rhand','true',1430,2,2,'fine_steel','c',85,10,'sword',8,0.00000,0,0,0,379,0,81,-1,-1,1762900,705,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3047-1;'),
(8112,'Mysterious Sword','Magic Power','rhand','true',1430,2,2,'fine_steel','c',85,10,'sword',8,0.00000,0,0,0,379,0,81,-1,-1,1762900,705,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3077-1;'),
(8113,'Mysterious Sword','Magic Weakness','rhand','true',1430,2,2,'fine_steel','c',85,10,'sword',8,0.00000,0,0,0,379,0,81,-1,-1,1762900,705,'true','true','true','true','true',0,0,1164,11,8,0,0,0,0,'0-0;'),
(8114,'Ecliptic Sword','Empower','rhand','true',1380,3,3,'oriharukon','c',125,10,'sword',8,0.00000,0,0,0,379,0,111,-1,-1,4713500,1885,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3076-4;'),
(8115,'Ecliptic Sword','Magic Power','rhand','true',1380,3,3,'oriharukon','c',125,10,'sword',8,0.00000,0,0,0,379,0,111,-1,-1,4713500,1885,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3077-4;'),
(8116,'Ecliptic Sword','Magic Silence','rhand','true',1380,3,3,'oriharukon','c',125,10,'sword',8,0.00000,0,0,0,379,0,111,-1,-1,4713500,1885,'true','true','true','true','true',0,0,3078,3,10,0,0,0,0,'0-0;'),
(8117,'Wizard\'s Tear','Acumen','rhand','true',1350,1,1,'oriharukon','b',155,10,'sword',8,0.00000,0,0,0,379,0,132,-1,-1,10091400,1346,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3047-1;'),
(8118,'Wizard\'s Tear','Magic Power','rhand','true',1350,1,1,'oriharukon','b',155,10,'sword',8,0.00000,0,0,0,379,0,132,-1,-1,10091400,1346,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3077-6;'),
(8119,'Wizard\'s Tear','Conversion','rhand','true',1350,1,1,'oriharukon','b',155,10,'sword',8,0.00000,0,0,0,379,0,132,-1,-1,10091400,1346,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3048-1;'),
(8120,'Dwarven Hammer','Health','lrhand','true',2010,3,3,'steel','c',190,20,'bigblunt',4,4.00000,0,0,0,325,0,83,-1,-1,4713500,1885,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3013-1;'),
(8121,'Dwarven Hammer','Anger','lrhand','true',2010,3,3,'steel','c',190,20,'bigblunt',4,4.00000,0,0,0,325,0,83,-1,-1,4713500,1885,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3012-4;'),
(8122,'Dwarven Hammer','Critical Bleed','lrhand','true',2010,3,3,'steel','c',190,20,'bigblunt',4,4.00000,0,0,0,325,0,83,-1,-1,4713500,1885,'true','true','true','true','true',0,0,0,0,0,3052,1,42,0,'0-0;'),
(8123,'Karik Horn','Focus','lrhand','true',2020,3,3,'oriharukon','c',169,20,'bigblunt',4,4.00000,0,0,0,325,0,76,-1,-1,3304300,1322,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3010-3;'),
(8124,'Karik Horn','Haste','lrhand','true',2020,3,3,'oriharukon','c',169,20,'bigblunt',4,4.00000,0,0,0,325,0,76,-1,-1,3304300,1322,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3036-2;'),
(8125,'Karik Horn','Critical Drain','lrhand','true',2020,3,3,'oriharukon','c',169,20,'bigblunt',4,4.00000,0,0,0,325,0,76,-1,-1,3304300,1322,'true','true','true','true','true',0,0,0,0,0,3022,2,33,0,'0-0;'),
(8126,'Destroyer Hammer','Health','lrhand','true',1910,1,1,'fine_steel','a',259,20,'bigblunt',4,4.00000,0,0,0,325,0,107,-1,-1,14098000,1128,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3013-3;'),
(8127,'Destroyer Hammer','Haste','lrhand','true',1910,1,1,'fine_steel','a',259,20,'bigblunt',4,4.00000,0,0,0,325,0,107,-1,-1,14098000,1128,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3564-2;'),
(8128,'Destroyer Hammer','Critical Drain','lrhand','true',1910,1,1,'fine_steel','a',259,20,'bigblunt',4,4.00000,0,0,0,325,0,107,-1,-1,14098000,1128,'true','true','true','true','true',0,0,0,0,0,3059,1,0,0,'3552-1;'),
(8129,'Ice Storm Hammer','Focus','lrhand','true',1950,1,1,'fine_steel','b',213,20,'bigblunt',4,4.00000,0,0,0,325,0,91,-1,-1,6680500,891,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3010-5;'),
(8130,'Ice Storm Hammer','Anger','lrhand','true',1950,1,1,'fine_steel','b',213,20,'bigblunt',4,4.00000,0,0,0,325,0,91,-1,-1,6680500,891,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3012-5;'),
(8131,'Ice Storm Hammer','Critical Bleed','lrhand','true',1950,1,1,'fine_steel','b',213,20,'bigblunt',4,4.00000,0,0,0,325,0,91,-1,-1,6680500,891,'true','true','true','true','true',0,0,0,0,0,3052,1,42,0,'0-0;'),
(8132,'Star Buster','Health','lrhand','true',1930,1,1,'fine_steel','b',236,20,'bigblunt',4,4.00000,0,0,0,325,0,99,-1,-1,10091400,1346,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3013-1;'),
(8133,'Star Buster','Haste','lrhand','true',1930,1,1,'fine_steel','b',236,20,'bigblunt',4,4.00000,0,0,0,325,0,99,-1,-1,10091400,1346,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3036-5;'),
(8134,'Star Buster','Rsk. Focus','lrhand','true',1930,1,1,'fine_steel','b',236,20,'bigblunt',4,4.00000,0,0,0,325,0,99,-1,-1,10091400,1346,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3027-6;'),
(8135,'Doom Crusher','Health','lrhand','true',1900,1,1,'fine_steel','a',282,20,'bigblunt',4,4.00000,0,0,0,325,0,114,-1,-1,20741000,1659,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3013-3;'),
(8136,'Doom Crusher','Anger','lrhand','true',1900,1,1,'fine_steel','a',282,20,'bigblunt',4,4.00000,0,0,0,325,0,114,-1,-1,20741000,1659,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3057-2;'),
(8137,'Doom Crusher','Rsk. Haste','lrhand','true',1900,1,1,'fine_steel','a',282,20,'bigblunt',4,4.00000,0,0,0,325,0,114,-1,-1,20741000,1659,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3056-2;'),
(8138,'Ecliptic Axe','Conversion','rhand','true',1640,3,3,'fine_steel','c',125,20,'blunt',4,4.00000,0,0,0,379,0,111,-1,-1,4713500,1885,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3048-1;'),
(8139,'Ecliptic Axe','Magic Power','rhand','true',1640,3,3,'fine_steel','c',125,20,'blunt',4,4.00000,0,0,0,379,0,111,-1,-1,4713500,1885,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3077-4;'),
(8140,'Ecliptic Axe','Magic Hold','rhand','true',1640,3,3,'fine_steel','c',125,20,'blunt',4,4.00000,0,0,0,379,0,111,-1,-1,4713500,1885,'true','true','true','true','true',0,0,3577,1,10,0,0,0,0,'0-0;'),
(8141,'Spell Breaker','Acumen','rhand','true',1620,1,1,'fine_steel','b',140,20,'blunt',4,4.00000,0,0,0,379,0,122,-1,-1,6680500,891,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3047-1;'),
(8142,'Spell Breaker','Magic Mental Shield','rhand','true',1620,1,1,'fine_steel','b',140,20,'blunt',4,4.00000,0,0,0,379,0,122,-1,-1,6680500,891,'true','true','true','true','true',0,0,1035,4,50,0,0,0,0,'0-0;'),
(8143,'Spell Breaker','Magic Hold','rhand','true',1620,1,1,'fine_steel','b',140,20,'blunt',4,4.00000,0,0,0,379,0,122,-1,-1,6680500,891,'true','true','true','true','true',0,0,3577,1,10,0,0,0,0,'0-0;'),
(8144,'Kaim Vanul\'s Bones','Mana Up','rhand','true',1570,1,1,'bone','b',155,20,'blunt',4,4.00000,0,0,0,379,0,132,-1,-1,10091400,1346,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3014-2;'),
(8145,'Kaim Vanul\'s Bones','Magic Silence','rhand','true',1570,1,1,'bone','b',155,20,'blunt',4,4.00000,0,0,0,379,0,132,-1,-1,10091400,1346,'true','true','true','true','true',0,0,3078,3,10,0,0,0,0,'0-0;'),
(8146,'Kaim Vanul\'s Bones','Conversion','rhand','true',1570,1,1,'bone','b',155,20,'blunt',4,4.00000,0,0,0,379,0,132,-1,-1,10091400,1346,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3048-1;'),
(8147,'Spiritual Eye','Mana Up','rhand','true',1550,1,1,'bone','a',170,20,'blunt',4,4.00000,0,0,0,379,0,143,-1,-1,14098000,1128,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3014-2;'),
(8148,'Spiritual Eye','Magic Poison','rhand','true',1550,1,1,'bone','a',170,20,'blunt',4,4.00000,0,0,0,379,0,143,-1,-1,14098000,1128,'true','true','true','true','true',0,0,1168,7,8,0,0,0,0,'3552-1;'),
(8149,'Spiritual Eye','Acumen','rhand','true',1550,1,1,'bone','a',170,20,'blunt',4,4.00000,0,0,0,379,0,143,-1,-1,14098000,1128,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3047-3;'),
(8150,'Flaming Dragon Skull','Acumen','rhand','true',1530,1,1,'fine_steel','a',186,20,'blunt',4,4.00000,0,0,0,379,0,152,-1,-1,20741000,1659,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3047-3;'),
(8151,'Flaming Dragon Skull','Magic Power','rhand','true',1530,1,1,'fine_steel','a',186,20,'blunt',4,4.00000,0,0,0,379,0,152,-1,-1,20741000,1659,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3073-1;'),
(8152,'Flaming Dragon Skull','Magic Silence','rhand','true',1530,1,1,'fine_steel','a',186,20,'blunt',4,4.00000,0,0,0,379,0,152,-1,-1,20741000,1659,'true','true','true','true','true',0,0,3074,2,10,0,0,0,0,'3552-1;'),
(8190,'Demonic Sword Zariche','','lrhand','true',1840,0,0,'bone','none',361,10,'bigsword',8,0.00000,0,0,0,325,0,137,-1,-1,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'3329-1;'),
(8203,'Monster Only (Venom Sword)','','lrhand','true',1560,1,1,'fine_steel','none',0,10,'dual',8,0.00000,0,0,0,325,0,0,-1,-1,0,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(8204,'Monster Only (Follower of Frintezza Calibur)','','rhand','false',1560,2,2,'fine_steel','none',0,10,'sword',8,0.00000,0,0,0,379,0,0,-1,-1,0,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(8205,'Monster Only (Heretic Priest Sigil)','','lrhand','true',1920,1,1,'blood_steel','none',0,10,'pole',8,-3.00000,0,0,0,325,0,0,-1,-1,0,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(8206,'Monster Only (Heretic Priest Sword)','','lrhand','true',2080,1,1,'fine_steel','none',0,10,'dual',8,0.00000,0,0,0,325,0,0,-1,-1,0,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(8207,'Monster Only (Heretic Private Axe)','','lrhand','true',1560,1,1,'fine_steel','none',0,10,'dual',8,0.00000,0,0,0,325,0,0,-1,-1,0,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(8208,'Monster Only (Heretic Private Staff)','','lrhand','true',1560,1,1,'fine_steel','none',0,10,'pole',8,-3.00000,0,0,0,325,0,0,-1,-1,0,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(8209,'Monster Only (Lidia Von Helmann Sword)','','rhand','false',1560,2,2,'fine_steel','none',0,10,'sword',8,0.00000,0,0,0,379,0,0,-1,-1,0,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(8210,'Monster Only (Monk Warrior Shield)','','lhand','false',4800,0,0,'damascus','none',0,0,'none',0,0.00000,-8,230,20,0,0,0,-1,-1,0,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(8211,'Monster Only (Monk Warrior Sword)','','rhand','false',1560,2,2,'fine_steel','none',0,10,'sword',8,0.00000,0,0,0,379,0,0,-1,-1,0,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(8212,'Monster Only (Solina Brother Mace)','','rhand','true',1570,1,1,'chrysolite','none',0,20,'blunt',4,4.00000,0,0,0,379,0,0,-1,-1,0,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(8213,'Monster Only (Solina Father Mace)','','rhand','true',1570,1,1,'chrysolite','none',0,20,'blunt',4,4.00000,0,0,0,379,0,0,-1,-1,0,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(8214,'Monster Only (Solina Priest Pole)','','lrhand','false',1920,1,1,'blood_steel','none',0,10,'pole',8,-3.00000,0,0,0,325,0,0,-1,-1,0,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(8215,'Monster Only (Zombie Enlisted Man Sword)','','lrhand','true',2090,3,3,'fine_steel','none',0,10,'bigsword',8,0.00000,0,0,0,325,0,0,-1,-1,0,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(8216,'Monster Only (Zombie Enlisted Man Claw)','','lrhand','false',1350,1,1,'adamantaite','none',0,5,'dualfist',4,4.00000,0,0,0,325,0,0,-1,-1,0,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(8217,'Monster Only (Zombie Gateguard Spear)','','rhand','true',1560,2,2,'fine_steel','none',0,10,'sword',8,0.00000,0,0,0,379,0,0,-1,-1,0,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(8218,'Monster Only (Zombie Laborer Axe)','','rhand','true',1570,1,1,'chrysolite','none',0,20,'blunt',4,4.00000,0,0,0,379,0,0,-1,-1,0,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(8219,'Monster Only (Zombie Laborer Sword)','','rhand','true',1560,2,2,'fine_steel','none',0,10,'sword',8,0.00000,0,0,0,379,0,0,-1,-1,0,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(8220,'Monster Only (Grail Apostle Bow)','','lrhand','true',1950,1,1,'wood','none',0,5,'bow',12,-3.00000,0,0,0,293,1,0,-1,-1,0,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(8221,'Monster Only (Grail Apostle Spear)','','lrhand','false',1920,1,1,'blood_steel','none',0,10,'pole',8,-3.00000,0,0,0,325,0,0,-1,-1,0,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(8222,'Monster Only (Follower of Frintezza Tran Calibur)','','rhand','true',1560,2,2,'fine_steel','none',0,10,'sword',8,0.00000,0,0,0,379,0,0,-1,-1,0,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(8350,'Chrono Maracas','','lrhand','true',0,0,0,'fine_steel','none',1,5,'dual',8,0.00000,0,0,0,325,0,1,-1,-1,0,0,'true','false','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(8527,'For Monsters Only (Strengthened Bow)','','lrhand','true',1870,6,2,'steel','d',82,5,'bow',12,-3.00000,0,0,0,293,3,26,-1,-1,0,743,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(8528,'For Monsters Only (Doom Hammer)','','rhand','true',1200,2,2,'steel','d',41,20,'blunt',4,4.00000,0,0,0,379,0,43,-1,-1,0,1170,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(8529,'For Monsters Only (Knife)','','rhand','false',1140,1,1,'bronze','none',10,5,'dagger',12,-3.00000,0,0,0,433,0,9,-1,-1,0,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(8530,'For Monsters Only (Squire\'s Sword)','','rhand','false',1600,1,1,'steel','none',6,10,'sword',8,0.00000,0,0,0,379,0,5,-1,-1,0,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(8531,'For Monsters Only (Bone Staff)','','lrhand','true',1060,2,2,'bone','d',39,20,'bigblunt',4,4.00000,0,0,0,325,0,35,-1,-1,0,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(8532,'For Monsters Only (Spinebone Sword)','','rhand','true',1510,2,2,'bone','d',51,10,'sword',8,0.00000,0,0,0,379,0,32,-1,-1,0,1170,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(8533,'For Monsters Only (Crimson Sword)','','rhand','true',1490,2,2,'fine_steel','d',64,10,'sword',8,0.00000,0,0,0,379,0,39,-1,-1,0,1758,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(8576,'Apprentice\'s Staff (Event)','','lrhand','false',1070,2,2,'wood','none',23,20,'bigblunt',4,4.00000,0,0,0,325,0,24,-1,-1,0,0,'false','false','false','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(8577,'Bone Club (Event)','','rhand','false',1850,2,2,'fine_steel','none',24,20,'blunt',4,4.00000,0,0,0,379,0,17,-1,-1,0,0,'false','false','false','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(8578,'Shining Knife (Event)','','rhand','false',1120,2,2,'mithril','none',21,5,'dagger',12,-3.00000,0,0,0,433,0,17,-1,-1,0,0,'false','false','false','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(8579,'Cestus (Event)','','lrhand','false',1570,2,2,'steel','none',29,5,'dualfist',4,4.00000,0,0,0,325,0,17,-1,-1,0,0,'false','false','false','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(8580,'Forest Bow (Event)','','lrhand','false',1900,7,2,'wood','none',49,5,'bow',12,-3.00000,0,0,0,293,3,17,-1,-1,0,0,'false','false','false','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(8581,'Long Sword (Event)','','rhand','false',1560,2,2,'fine_steel','none',24,10,'sword',8,0.00000,0,0,0,379,0,17,-1,-1,0,0,'false','false','false','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(8582,'Mace of Prayer (Event)','','rhand','false',1300,2,2,'steel','d',41,20,'blunt',4,4.00000,0,0,0,379,0,43,-1,-1,0,0,'false','false','false','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(8583,'Dark Elven Bow (Event)','','lrhand','false',1830,6,2,'steel','d',105,5,'bow',12,-3.00000,0,0,0,293,4,32,-1,-1,0,0,'false','false','false','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(8584,'Long Bow (Event)','','lrhand','false',1830,6,2,'steel','d',114,5,'bow',12,-3.00000,0,0,0,227,4,35,-1,-1,0,0,'false','false','false','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(8585,'Staff of Mana (Event)','','lrhand','false',1040,2,2,'wood','d',50,20,'bigblunt',4,4.00000,0,0,0,325,0,47,-1,-1,0,0,'false','false','false','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(8586,'Bastard Sword (Event)','','rhand','false',1510,2,2,'fine_steel','d',51,10,'sword',8,0.00000,0,0,0,379,0,32,-1,-1,0,0,'false','false','false','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(8587,'Divine Tomb (Event)','','rhand','false',570,2,2,'steel','d',41,10,'etc',8,0.00000,0,0,0,379,0,43,-1,-1,0,0,'false','false','false','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(8588,'Single-Edged Jamadhr (Event)','','lrhand','false',1550,2,2,'steel','d',62,5,'dualfist',4,4.00000,0,0,0,325,0,32,-1,-1,0,0,'false','false','false','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(8589,'Tomahawk (Event)','','rhand','false',1780,2,2,'bronze','d',51,20,'blunt',4,4.00000,0,0,0,379,0,32,-1,-1,0,0,'false','false','false','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(8590,'Poniard Daggar (Event)','','rhand','false',1090,2,2,'steel','d',45,5,'dagger',12,-3.00000,0,0,0,433,0,32,-1,-1,0,0,'false','false','false','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(8591,'Pike (Event)','','lrhand','false',2090,2,2,'steel','d',51,10,'pole',8,-3.00000,0,0,0,325,0,32,-1,-1,0,0,'false','false','false','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(8678,'Sirra\'s Blade','','rhand','true',1300,1,1,'fine_steel','a',251,10,'sword',8,0.00000,0,0,0,379,0,121,-1,-1,26968400,2157,'true','true','true','true','true',0,0,0,0,0,0,0,0,9352,'0-0;'),
(8679,'Sword of Ipos','','lrhand','true',1820,1,1,'bone','a',305,10,'bigsword',8,0.00000,0,0,0,325,0,121,-1,-1,26968400,2157,'true','true','true','true','true',0,0,0,0,0,0,0,0,9356,'0-0;'),
(8680,'Barakiel\'s Axe','','rhand','true',1550,1,1,'oriharukon','a',251,20,'blunt',4,4.00000,0,0,0,379,0,121,-1,-1,26968400,2157,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(8681,'Behemoth\'s Tuning Fork','','lrhand','true',1890,1,1,'fine_steel','a',305,20,'bigblunt',4,4.00000,0,0,0,325,0,121,-1,-1,26968400,2157,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(8682,'Naga Storm','','rhand','true',930,1,1,'oriharukon','a',220,5,'dagger',12,-3.00000,0,0,0,433,0,121,-1,-1,26968400,2157,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(8683,'Tiphon\'s Spear','','lrhand','true',1820,1,1,'chrysolite','a',251,10,'pole',8,-3.00000,0,0,0,325,0,121,-1,-1,26968400,2157,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3599-1;'),
(8684,'Shyeed\'s Bow','','lrhand','true',1640,2,1,'oriharukon','a',570,5,'bow',12,-3.00000,0,0,0,227,10,133,-1,-1,26968400,2157,'true','true','true','true','true',0,0,0,0,0,0,0,0,9360,'0-0;'),
(8685,'Sobekk\'s Hurricane','','lrhand','true',1330,1,1,'adamantaite','a',305,5,'dualfist',4,4.00000,0,0,0,325,0,121,-1,-1,26968400,2157,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(8686,'Themis\' Tongue','','rhand','true',820,1,1,'adamantaite','a',202,10,'sword',8,0.00000,0,0,0,379,0,161,-1,-1,26968400,2157,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(8687,'Cabrio\'s Hand','','rhand','true',1510,1,1,'fine_steel','a',202,20,'blunt',4,4.00000,0,0,0,379,0,161,-1,-1,26968400,2157,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(8688,'Daimon Crystal','','lrhand','true',880,1,1,'wood','a',245,20,'bigblunt',4,4.00000,0,0,0,325,0,177,-1,-1,26968400,2157,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(8689,'Blood Sword Akamanah','','lrhand','true',1840,0,0,'bone','none',361,10,'dual',8,0.00000,0,0,0,325,0,137,-1,-1,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'3328-1;'),
(8763,'Elrokian Trap','','rhand','false',500,0,0,'oriharukon','a',0,0,'blunt',0,0.00000,0,0,0,379,0,0,-1,-1,26968400,2157,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3626-1;3627-1;3628-1;'),
(8788,'Sirra\'s Blade','Haste','rhand','true',1300,1,1,'fine_steel','a',251,10,'sword',8,0.00000,0,0,0,379,0,121,-1,-1,26968400,2157,'true','true','true','true','true',0,0,0,0,0,0,0,0,9353,'3564-2;'),
(8789,'Sirra\'s Blade','Health','rhand','true',1300,1,1,'fine_steel','a',251,10,'sword',8,0.00000,0,0,0,379,0,121,-1,-1,26968400,2157,'true','true','true','true','true',0,0,0,0,0,0,0,0,9354,'3013-3;'),
(8790,'Sirra\'s Blade','Critical Poison','rhand','true',1300,1,1,'fine_steel','a',251,10,'sword',8,0.00000,0,0,0,379,0,121,-1,-1,26968400,2157,'true','true','true','true','true',0,0,0,0,0,3061,3,15,9355,'3552-1;'),
(8791,'Sword of Ipos','Focus','lrhand','true',1820,1,1,'bone','a',305,10,'bigsword',8,0.00000,0,0,0,325,0,121,-1,-1,26968400,2157,'true','true','true','true','true',0,0,0,0,0,0,0,0,9357,'3050-2;'),
(8792,'Sword of Ipos','Haste','lrhand','true',1820,1,1,'bone','a',305,10,'bigsword',8,0.00000,0,0,0,325,0,121,-1,-1,26968400,2157,'true','true','true','true','true',0,0,0,0,0,0,0,0,9358,'3564-2;'),
(8793,'Sword of Ipos','Health','lrhand','true',1820,1,1,'bone','a',305,10,'bigsword',8,0.00000,0,0,0,325,0,121,-1,-1,26968400,2157,'true','true','true','true','true',0,0,0,0,0,0,0,0,9359,'3013-3;'),
(8794,'Barakiel\'s Axe','Health','rhand','true',1550,1,1,'oriharukon','a',251,20,'blunt',4,4.00000,0,0,0,379,0,121,-1,-1,26968400,2157,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3013-3;'),
(8795,'Barakiel\'s Axe','Haste','rhand','true',1550,1,1,'oriharukon','a',251,20,'blunt',4,4.00000,0,0,0,379,0,121,-1,-1,26968400,2157,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3564-2;'),
(8796,'Barakiel\'s Axe','Focus','rhand','true',1550,1,1,'oriharukon','a',251,20,'blunt',4,4.00000,0,0,0,379,0,121,-1,-1,26968400,2157,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3050-2;'),
(8797,'Behemoth\'s Tuning Fork','Focus','lrhand','true',1890,1,1,'fine_steel','a',305,20,'bigblunt',4,4.00000,0,0,0,325,0,121,-1,-1,26968400,2157,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3050-2;'),
(8798,'Behemoth\'s Tuning Fork','Health','lrhand','true',1890,1,1,'fine_steel','a',305,20,'bigblunt',4,4.00000,0,0,0,325,0,121,-1,-1,26968400,2157,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3013-3;'),
(8799,'Behemoth\'s Tuning Fork','Anger','lrhand','true',1890,1,1,'fine_steel','a',305,20,'bigblunt',4,4.00000,0,0,0,325,0,121,-1,-1,26968400,2157,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3057-2;'),
(8800,'Naga Storm','Focus','rhand','true',930,1,1,'oriharukon','a',220,5,'dagger',12,-3.00000,0,0,0,433,0,121,-1,-1,26968400,2157,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3051-1;'),
(8801,'Naga Storm','Critical Damage','rhand','true',930,1,1,'oriharukon','a',220,5,'dagger',12,-3.00000,0,0,0,433,0,121,-1,-1,26968400,2157,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3066-2;'),
(8802,'Naga Storm','Back Blow','rhand','true',930,1,1,'oriharukon','a',220,5,'dagger',12,-3.00000,0,0,0,433,0,121,-1,-1,26968400,2157,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3019-6;'),
(8803,'Tiphon\'s Spear','Critical Stun','lrhand','true',1820,1,1,'chrysolite','a',251,10,'pole',8,-3.00000,0,0,0,325,0,121,-1,-1,26968400,2157,'true','true','true','true','true',0,0,0,0,0,3070,2,25,0,'3552-2;'),
(8804,'Tiphon\'s Spear','Towering Blow','lrhand','true',1820,1,1,'chrysolite','a',251,10,'pole',8,-3.00000,0,0,0,325,0,121,-1,-1,26968400,2157,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3552-2;'),
(8805,'Tiphon\'s Spear','Wild Blow','lrhand','true',1820,1,1,'chrysolite','a',251,10,'pole',8,-3.00000,0,0,0,325,0,121,-1,-1,26968400,2157,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3552-2;'),
(8806,'Shyeed\'s Bow','Cheap Shot','lrhand','true',1640,2,1,'oriharukon','a',570,5,'bow',12,-3.00000,0,0,0,227,10,133,-1,-1,26968400,2157,'true','true','true','true','true',0,0,0,0,0,0,0,0,9361,'3552-1;'),
(8807,'Shyeed\'s Bow','Focus','lrhand','true',1640,2,1,'oriharukon','a',570,5,'bow',12,-3.00000,0,0,0,227,10,133,-1,-1,26968400,2157,'true','true','true','true','true',0,0,0,0,0,0,0,0,9362,'3050-2;'),
(8808,'Shyeed\'s Bow','Quick Recovery','lrhand','true',1640,2,1,'oriharukon','a',570,5,'bow',12,-3.00000,0,0,0,227,10,133,-1,-1,26968400,2157,'true','true','true','true','true',0,0,0,0,0,0,0,0,9363,'3552-1;'),
(8809,'Sobekk\'s Hurricane','Rsk. Haste','lrhand','true',1330,1,1,'adamantaite','a',305,5,'dualfist',4,4.00000,0,0,0,325,0,121,-1,-1,26968400,2157,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3056-2;'),
(8810,'Sobekk\'s Hurricane','Haste','lrhand','true',1330,1,1,'adamantaite','a',305,5,'dualfist',4,4.00000,0,0,0,325,0,121,-1,-1,26968400,2157,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3564-2;'),
(8811,'Sobekk\'s Hurricane','Critical Drain','lrhand','true',1330,1,1,'adamantaite','a',305,5,'dualfist',4,4.00000,0,0,0,325,0,121,-1,-1,26968400,2157,'true','true','true','true','true',0,0,0,0,0,3039,6,33,0,'3552-1;'),
(8812,'Themis\' Tongue','Mana Up','rhand','true',820,1,1,'adamantaite','a',202,10,'sword',8,0.00000,0,0,0,379,0,161,-1,-1,26968400,2157,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3014-2;'),
(8813,'Themis\' Tongue','Magic Mental Shield','rhand','true',820,1,1,'adamantaite','a',202,10,'sword',8,0.00000,0,0,0,379,0,161,-1,-1,26968400,2157,'true','true','true','true','true',0,0,1035,2,50,0,0,0,0,'3552-1;'),
(8814,'Themis\' Tongue','Magic Focus','rhand','true',820,1,1,'adamantaite','a',202,10,'sword',8,0.00000,0,0,0,379,0,161,-1,-1,26968400,2157,'true','true','true','true','true',0,0,1077,3,20,0,0,0,0,'3552-1;'),
(8815,'Cabrio\'s Hand','Conversion','rhand','true',1510,1,1,'fine_steel','a',202,20,'blunt',4,4.00000,0,0,0,379,0,161,-1,-1,26968400,2157,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3048-3;'),
(8816,'Cabrio\'s Hand','Mana Up','rhand','true',1510,1,1,'fine_steel','a',202,20,'blunt',4,4.00000,0,0,0,379,0,161,-1,-1,26968400,2157,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3014-2;'),
(8817,'Cabrio\'s Hand','Magic Silence','rhand','true',1510,1,1,'fine_steel','a',202,20,'blunt',4,4.00000,0,0,0,379,0,161,-1,-1,26968400,2157,'true','true','true','true','true',0,0,3074,2,10,0,0,0,0,'3552-1;'),
(8818,'Daimon Crystal','Mana Up','lrhand','true',880,1,1,'wood','a',245,20,'bigblunt',4,4.00000,0,0,0,325,0,177,-1,-1,26968400,2157,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3014-2;'),
(8819,'Daimon Crystal','Acumen','lrhand','true',880,1,1,'wood','a',245,20,'bigblunt',4,4.00000,0,0,0,325,0,177,-1,-1,26968400,2157,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3047-3;'),
(8820,'Daimon Crystal','Magic Mental Shield','lrhand','true',880,1,1,'wood','a',245,20,'bigblunt',4,4.00000,0,0,0,325,0,177,-1,-1,26968400,2157,'true','true','true','true','true',0,0,1035,2,50,0,0,0,0,'3552-1;'),
(8821,'Shadow Item: Two Handed Sword','','lrhand','false',730,2,2,'fine_steel','d',78,10,'bigsword',8,0.00000,0,0,0,325,0,39,90,-1,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(8822,'Shadow Item: Crimson Sword','','rhand','false',500,2,2,'fine_steel','d',64,10,'sword',8,0.00000,0,0,0,379,0,39,90,-1,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(8823,'Shadow Item: Spiked Club','','rhand','false',590,2,2,'steel','d',64,20,'blunt',4,4.00000,0,0,0,379,0,39,90,-1,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(8824,'Shadow Item: Staff of Magic','','lrhand','false',340,2,2,'wood','d',62,20,'bigblunt',4,4.00000,0,0,0,325,0,57,90,-1,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(8825,'Shadow Item: Kukuri','','rhand','false',360,2,2,'fine_steel','d',56,5,'dagger',12,-3.00000,0,0,0,433,0,39,90,-1,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(8826,'Shadow Item: Dagger of Mana','','rhand','false',250,2,2,'fine_steel','d',45,5,'dagger',12,-3.00000,0,0,0,433,0,52,90,-1,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(8827,'Shadow Item: Triple-Edged Jamadhr','','lrhand','false',520,2,2,'fine_steel','d',78,5,'dualfist',4,4.00000,0,0,0,325,0,39,90,-1,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(8828,'Shadow Item: Gastraphetes','','lrhand','false',620,8,2,'fine_steel','d',132,5,'bow',12,-3.00000,0,0,0,293,4,39,90,-1,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(8829,'Shadow Item: War Hammer','','lrhand','false',700,2,2,'fine_steel','d',64,10,'pole',8,-3.00000,0,0,0,325,0,39,90,-1,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3599-1;'),
(8830,'Shadow Item: Katana','','rhand','false',480,2,2,'fine_steel','c',122,10,'sword',8,0.00000,0,0,0,379,0,68,300,-1,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(8831,'Shadow Item: Bec de Corbin','','lrhand','false',680,2,2,'fine_steel','c',122,10,'pole',8,-3.00000,0,0,0,325,0,68,300,-1,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3599-1;'),
(8832,'Shadow Item: Cursed Staff','','lrhand','false',340,2,2,'wood','c',119,20,'bigblunt',4,4.00000,0,0,0,325,0,100,300,-1,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(8833,'Shadow Item: Stiletto','','rhand','false',350,2,2,'fine_steel','c',107,5,'dagger',12,-3.00000,0,0,0,433,0,68,300,-1,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(8834,'Shadow Item: Soulfire Dirk','','rhand','false',250,2,2,'fine_steel','c',86,5,'dagger',12,-3.00000,0,0,0,433,0,91,300,-1,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(8835,'Shadow Item: Elemental Bow','','lrhand','false',590,8,2,'fine_steel','c',277,5,'bow',12,-3.00000,0,0,0,227,7,75,300,-1,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(8836,'Shadow Item: Dwarven War Hammer','','rhand','false',560,2,2,'fine_steel','c',122,20,'blunt',4,4.00000,0,0,0,379,0,68,300,-1,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(8837,'Shadow Item: Sword of Revolution','','lrhand','false',790,2,2,'fine_steel','c',148,10,'dual',8,0.00000,0,0,0,325,0,68,300,-1,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(8838,'Shadow Item: Knuckle Duster','','lrhand','false',500,2,2,'fine_steel','c',148,5,'dualfist',4,4.00000,0,0,0,325,0,68,300,-1,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(8839,'Shadow Item: Sword of Delusion','','rhand','false',470,3,3,'mithril','c',139,10,'sword',8,0.00000,0,0,0,379,0,76,300,-1,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(8840,'Shadow Item: Poleaxe','','lrhand','false',670,3,3,'bronze','c',139,10,'pole',8,-3.00000,0,0,0,325,0,76,300,-1,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3599-1;'),
(8841,'Shadow Item: Stick of Eternity','','rhand','false',380,3,3,'wood','c',111,20,'blunt',4,4.00000,0,0,0,379,0,101,300,-1,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(8842,'Shadow Item: Inferno Staff','','lrhand','false',340,3,3,'wood','c',135,20,'bigblunt',4,4.00000,0,0,0,325,0,111,300,-1,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(8843,'Shadow Item: Pa\'agrian Hammer','','lrhand','false',340,3,3,'blood_steel','c',135,20,'bigblunt',4,4.00000,0,0,0,325,0,111,300,-1,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(8844,'Shadow Item: Dark Screamer','','rhand','false',340,3,3,'fine_steel','c',122,5,'dagger',12,-3.00000,0,0,0,433,0,76,300,-1,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(8845,'Shadow Item: Akat Long Bow','','lrhand','false',580,9,3,'horn','c',316,5,'bow',12,-3.00000,0,0,0,227,7,84,300,-1,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(8846,'Shadow Item: Pa\'agrian Sword','','lrhand','false',660,3,3,'steel','c',169,10,'bigsword',8,0.00000,0,0,0,325,0,76,300,-1,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(8847,'Shadow Item: Fisted Blade','','lrhand','false',500,3,3,'fine_steel','c',169,5,'dualfist',4,4.00000,0,0,0,325,0,76,300,-1,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(8848,'Shadow Item: Stormbringer','','lrhand','false',780,3,3,'fine_steel','c',175,10,'dual',8,0.00000,0,0,0,325,0,78,300,-1,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(8849,'Shadow Item: Great Sword','','lrhand','false',650,1,1,'steel','b',213,10,'bigsword',8,0.00000,0,0,0,325,0,91,300,-1,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(8850,'Shadow Item: Heavy War Axe','','rhand','false',540,1,1,'fine_steel','b',175,20,'blunt',4,4.00000,0,0,0,379,0,91,300,-1,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(8851,'Shadow Item: Sprite\'s Staff','','lrhand','false',320,1,1,'wood','b',170,20,'bigblunt',4,4.00000,0,0,0,325,0,134,300,-1,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(8852,'Shadow Item: Keshanberk','','rhand','false',460,1,1,'oriharukon','b',175,10,'sword',8,0.00000,0,0,0,379,0,91,300,-1,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(8853,'Shadow Item: Sword of Valhalla','','rhand','false',300,1,1,'oriharukon','b',140,10,'sword',8,0.00000,0,0,0,379,0,122,300,-1,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(8854,'Shadow Item: Kris','','rhand','false',330,1,1,'mithril','b',153,5,'dagger',12,-3.00000,0,0,0,433,0,91,300,-1,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(8855,'Shadow Item: Arthro Nail','','lrhand','false',480,1,1,'blood_steel','b',213,5,'dualfist',4,4.00000,0,0,0,325,0,91,300,-1,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(8856,'Shadow Item: Dark Elven Long Bow','','lrhand','false',580,3,1,'oriharukon','b',397,5,'bow',12,-3.00000,0,0,0,227,8,100,300,-1,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(8857,'Shadow Item: Swords of Delusion','','lrhand','false',720,1,1,'fine_steel','b',213,10,'dual',8,0.00000,0,0,0,325,0,91,300,-1,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(8858,'Shadow Item: Great Axe','','lrhand','false',650,1,1,'damascus','b',175,10,'pole',8,-3.00000,0,0,0,325,0,91,300,-1,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3599-1;'),
(8859,'Shadow Item: Tallum Blade','','rhand','false',450,1,1,'adamantaite','a',213,10,'sword',8,0.00000,0,0,0,379,0,107,300,-1,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(8860,'Shadow Item: Halberd','','lrhand','false',640,1,1,'oriharukon','a',213,10,'pole',8,-3.00000,0,0,0,325,0,107,300,-1,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3599-1;'),
(8861,'Shadow Item: Dasparion\'s Staff','','lrhand','false',310,1,1,'adamantaite','a',207,20,'bigblunt',4,4.00000,0,0,0,325,0,157,300,-1,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(8862,'Shadow Item: Bloody Orchid','','rhand','false',320,1,1,'blood_steel','a',186,5,'dagger',12,-3.00000,0,0,0,433,0,107,300,-1,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(8863,'Shadow Item: Blood Tornado','','lrhand','false',460,1,1,'blood_steel','a',259,5,'dualfist',4,4.00000,0,0,0,325,0,107,300,-1,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(8864,'Shadow Item: Carnage Bow','','lrhand','false',560,2,1,'damascus','a',440,5,'bow',12,-3.00000,0,0,0,293,9,107,300,-1,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(8865,'Shadow Item: Dual Keshanberk','','lrhand','false',700,1,1,'fine_steel','a',259,10,'dual',8,0.00000,0,0,0,325,0,107,300,-1,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(8866,'Shadow Item: Meteor Shower','','rhand','false',540,1,1,'fine_steel','a',213,20,'blunt',4,4.00000,0,0,0,379,0,107,300,-1,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(8867,'Shadow Item: Inferno Master','','lrhand','false',640,1,1,'fine_steel','a',259,10,'bigsword',8,0.00000,0,0,0,325,0,107,300,-1,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(8926,'Shadow Item: Sword of Delusion','','rhand','false',470,3,3,'mithril','c',139,10,'sword',8,0.00000,0,0,0,379,0,76,120,-1,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(8927,'Shadow Item: Poleaxe','','lrhand','false',670,3,3,'bronze','c',139,10,'pole',8,-3.00000,0,0,0,325,0,76,120,-1,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3599-1;'),
(8928,'Shadow Item: Stick of Eternity','','rhand','false',380,3,3,'wood','c',111,20,'blunt',4,4.00000,0,0,0,379,0,101,120,-1,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(8929,'Shadow Item: Inferno Staff','','lrhand','false',340,3,3,'wood','c',135,20,'bigblunt',4,4.00000,0,0,0,325,0,111,120,-1,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(8930,'Shadow Item: Pa\'agrian Hammer','','lrhand','false',340,3,3,'blood_steel','c',135,20,'bigblunt',4,4.00000,0,0,0,325,0,111,120,-1,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(8931,'Shadow Item: Dark Screamer','','rhand','false',340,3,3,'fine_steel','c',122,5,'dagger',12,-3.00000,0,0,0,433,0,76,120,-1,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(8932,'Shadow Item: Akat Long Bow','','lrhand','false',580,9,3,'horn','c',316,5,'bow',12,-3.00000,0,0,0,227,7,84,120,-1,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(8933,'Shadow Item: Pa\'agrian Sword','','lrhand','false',660,3,3,'steel','c',169,10,'bigsword',8,0.00000,0,0,0,325,0,76,120,-1,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(8934,'Shadow Item: Fisted Blade','','lrhand','false',500,3,3,'fine_steel','c',169,5,'dualfist',4,4.00000,0,0,0,325,0,76,120,-1,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(8935,'Test Rapier','','rhand','false',1380,3,3,'oriharukon','c',156,10,'sword',8,0.00000,0,0,0,379,0,83,-1,-1,0,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(8937,'Shadow Item: Stormbringer','','lrhand','false',780,3,3,'fine_steel','c',175,10,'dual',8,0.00000,0,0,0,325,0,78,120,-1,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(8938,'Damascus * Tallum Blade','','lrhand','true',1890,1,1,'fine_steel','a',305,10,'dual',8,0.00000,0,0,0,325,0,121,-1,-1,26968400,2157,'true','true','true','true','true',3045,17,0,0,0,0,0,0,0,'0-0;'),
(8972,'Shadow Item: Great Spear','','lrhand','false',707,2,2,'bronze','none',31,10,'pole',8,-3.00000,0,0,0,325,0,21,600,-1,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3599-1;'),
(8973,'Shadow Item: Falchion','','rhand','false',510,2,2,'bronze','none',31,10,'sword',8,0.00000,0,0,0,379,0,21,600,-1,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(8974,'Shadow Item: Iron Hammer','','rhand','false',617,2,2,'steel','none',31,20,'blunt',4,4.00000,0,0,0,379,0,21,600,-1,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(8975,'Shadow Item: Voodoo Doll','','rhand','false',210,2,2,'wood','none',25,10,'etc',8,0.00000,0,0,0,379,0,28,600,-1,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(8976,'Shadow Item: Flanged Mace','','rhand','false',600,2,2,'steel','none',31,20,'blunt',4,4.00000,0,0,0,379,0,21,600,-1,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(8977,'Shadow Item: Mage Staff','','lrhand','false',350,2,2,'wood','none',30,20,'bigblunt',4,4.00000,0,0,0,325,0,31,600,-1,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(8978,'Shadow Item: Sword Breaker','','rhand','false',370,2,2,'steel','none',27,5,'dagger',12,-3.00000,0,0,0,433,0,21,600,-1,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(8979,'Shadow Item: Viper Fang','','lrhand','false',520,2,2,'steel','none',38,5,'dualfist',4,4.00000,0,0,0,325,0,21,600,-1,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(8980,'Shadow Item: Composite Bow','','lrhand','false',627,7,2,'steel','none',64,5,'bow',12,-3.00000,0,0,0,293,3,21,600,-1,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(8981,'Shadow Item: Crucifix of Blessing','','rhand','false',207,2,2,'steel','none',25,10,'etc',8,0.00000,0,0,0,379,0,28,600,-1,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(8982,'Shadow Item: Two Handed Sword','','lrhand','false',730,2,2,'fine_steel','d',78,10,'bigsword',8,0.00000,0,0,0,325,0,39,600,-1,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(8983,'Shadow Item: Crimson Sword','','rhand','false',500,2,2,'fine_steel','d',64,10,'sword',8,0.00000,0,0,0,379,0,39,600,-1,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(8984,'Shadow Item: Spiked Club','','rhand','false',590,2,2,'steel','d',64,20,'blunt',4,4.00000,0,0,0,379,0,39,600,-1,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(8985,'Shadow Item: Staff of Magic','','lrhand','false',340,2,2,'wood','d',62,20,'bigblunt',4,4.00000,0,0,0,325,0,57,600,-1,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(8986,'Shadow Item: Kukuri','','rhand','false',360,2,2,'fine_steel','d',56,5,'dagger',12,-3.00000,0,0,0,433,0,39,600,-1,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(8987,'Shadow Item: Dagger of Mana','','rhand','false',250,2,2,'fine_steel','d',45,5,'dagger',12,-3.00000,0,0,0,433,0,52,600,-1,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(8988,'Shadow Item: Triple-Edged Jamadhr','','lrhand','false',520,2,2,'fine_steel','d',78,5,'dualfist',4,4.00000,0,0,0,325,0,39,600,-1,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(8989,'Shadow Item: Gastraphetes','','lrhand','false',620,8,2,'fine_steel','d',132,5,'bow',12,-3.00000,0,0,0,293,4,39,600,-1,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(8990,'Shadow Item: War Hammer','','lrhand','false',700,2,2,'fine_steel','d',64,10,'pole',8,-3.00000,0,0,0,325,0,39,600,-1,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3599-1;'),
(8991,'Shadow Item: Sword of Delusion','','rhand','false',470,3,3,'mithril','c',139,10,'sword',8,0.00000,0,0,0,379,0,76,600,-1,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(8992,'Shadow Item: Poleaxe','','lrhand','false',670,3,3,'bronze','c',139,10,'pole',8,-3.00000,0,0,0,325,0,76,600,-1,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3599-1;'),
(8993,'Shadow Item: Stick of Eternity','','rhand','false',380,3,3,'wood','c',111,20,'blunt',4,4.00000,0,0,0,379,0,101,600,-1,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(8994,'Shadow Item: Inferno Staff','','lrhand','false',340,3,3,'wood','c',135,20,'bigblunt',4,4.00000,0,0,0,325,0,111,600,-1,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(8995,'Shadow Item: Pa\'agrian Hammer','','lrhand','false',340,3,3,'blood_steel','c',135,20,'bigblunt',4,4.00000,0,0,0,325,0,111,600,-1,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(8996,'Shadow Item: Dark Screamer','','rhand','false',340,3,3,'fine_steel','c',122,5,'dagger',12,-3.00000,0,0,0,433,0,76,600,-1,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(8997,'Shadow Item: Akat Long Bow','','lrhand','false',580,9,3,'horn','c',316,5,'bow',12,-3.00000,0,0,0,227,7,84,600,-1,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(8998,'Shadow Item: Pa\'agrian Sword','','lrhand','false',660,3,3,'steel','c',169,10,'bigsword',8,0.00000,0,0,0,325,0,76,600,-1,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(8999,'Shadow Item: Fisted Blade','','lrhand','false',500,3,3,'fine_steel','c',169,5,'dualfist',4,4.00000,0,0,0,325,0,76,600,-1,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(9000,'Shadow Item: Stormbringer*Stormbringer','','lrhand','false',780,3,3,'fine_steel','c',175,10,'dual',8,0.00000,0,0,0,325,0,78,600,-1,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(9001,'Shadow Item: Great Sword','','lrhand','false',650,1,1,'steel','b',213,10,'bigsword',8,0.00000,0,0,0,325,0,91,600,-1,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(9002,'Shadow Item: Heavy War Axe','','rhand','false',540,1,1,'fine_steel','b',175,20,'blunt',4,4.00000,0,0,0,379,0,91,600,-1,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(9003,'Shadow Item: Sprite\'s Staff','','lrhand','false',320,1,1,'wood','b',170,20,'bigblunt',4,4.00000,0,0,0,325,0,134,600,-1,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(9004,'Shadow Item: Keshanberk','','rhand','false',460,1,1,'oriharukon','b',175,10,'sword',8,0.00000,0,0,0,379,0,91,600,-1,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(9005,'Shadow Item: Sword of Valhalla','','rhand','false',300,1,1,'oriharukon','b',140,10,'sword',8,0.00000,0,0,0,379,0,122,600,-1,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(9006,'Shadow Item: Kris','','rhand','false',330,1,1,'mithril','b',153,5,'dagger',12,-3.00000,0,0,0,433,0,91,600,-1,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(9007,'Shadow Item: Arthro Nail','','lrhand','false',480,1,1,'blood_steel','b',213,5,'dualfist',4,4.00000,0,0,0,325,0,91,600,-1,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(9008,'Shadow Item: Dark Elven Long Bow','','lrhand','false',580,3,1,'oriharukon','b',397,5,'bow',12,-3.00000,0,0,0,227,8,100,600,-1,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(9009,'Shadow Item: Sword of Delusion*Sword of Delusion','','lrhand','false',720,1,1,'fine_steel','b',213,10,'dual',8,0.00000,0,0,0,325,0,91,600,-1,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(9010,'Shadow Item: Great Axe','','lrhand','false',650,1,1,'damascus','b',175,10,'pole',8,-3.00000,0,0,0,325,0,91,600,-1,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3599-1;'),
(9011,'Shadow Item: Tallum Blade','','rhand','false',450,1,1,'adamantaite','a',213,10,'sword',8,0.00000,0,0,0,379,0,107,600,-1,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(9012,'Shadow Item: Halberd','','lrhand','false',640,1,1,'oriharukon','a',213,10,'pole',8,-3.00000,0,0,0,325,0,107,600,-1,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3599-1;'),
(9013,'Shadow Item: Dasparion\'s Staff','','lrhand','false',310,1,1,'adamantaite','a',207,20,'bigblunt',4,4.00000,0,0,0,325,0,157,600,-1,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(9014,'Shadow Item: Bloody Orchid','','rhand','false',320,1,1,'blood_steel','a',186,5,'dagger',12,-3.00000,0,0,0,433,0,107,600,-1,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(9015,'Shadow Item: Blood Tornado','','lrhand','false',460,1,1,'blood_steel','a',259,5,'dualfist',4,4.00000,0,0,0,325,0,107,600,-1,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(9016,'Shadow Item: Carnage Bow','','lrhand','false',560,2,1,'damascus','a',440,5,'bow',12,-3.00000,0,0,0,293,9,107,600,-1,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(9017,'Shadow Item: Keshanberk*Keshanberk','','lrhand','false',700,1,1,'fine_steel','a',259,10,'dual',8,0.00000,0,0,0,325,0,107,600,-1,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(9018,'Shadow Item: Meteor Shower','','rhand','false',540,1,1,'fine_steel','a',213,20,'blunt',4,4.00000,0,0,0,379,0,107,600,-1,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(9019,'Shadow Item: Inferno Master','','lrhand','false',640,1,1,'fine_steel','a',259,10,'bigsword',8,0.00000,0,0,0,325,0,107,600,-1,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(9020,'Shadow Item: Keshanberk*Damascus','','lrhand','false',693,1,1,'fine_steel','a',275,10,'dual',8,0.00000,0,0,0,325,0,112,600,-1,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(9021,'Shadow Item: Dragon Slayer','','lrhand','false',613,1,1,'bone','a',282,10,'bigsword',8,0.00000,0,0,0,325,0,114,600,-1,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(9022,'Shadow Item: Sword of Miracles','','rhand','false',280,1,1,'adamantaite','a',186,10,'sword',8,0.00000,0,0,0,379,0,152,600,-1,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(9023,'Shadow Item: Elysian','','rhand','false',527,1,1,'oriharukon','a',232,20,'blunt',4,4.00000,0,0,0,379,0,114,600,-1,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(9024,'Shadow Item: Branch of the Mother Tree','','lrhand','false',300,1,1,'wood','a',226,20,'bigblunt',4,4.00000,0,0,0,325,0,167,600,-1,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(9025,'Shadow Item: Soul Separator','','rhand','false',317,1,1,'oriharukon','a',203,5,'dagger',12,-3.00000,0,0,0,433,0,114,600,-1,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(9026,'Shadow Item: Dragon Grinder','','lrhand','false',450,1,1,'adamantaite','a',282,5,'dualfist',4,4.00000,0,0,0,325,0,114,600,-1,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(9027,'Shadow Item: Soul Bow','','lrhand','false',553,2,1,'oriharukon','a',528,5,'bow',12,-3.00000,0,0,0,227,10,125,600,-1,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(9028,'Shadow Item: Tallum Glaive','','lrhand','false',613,1,1,'chrysolite','a',232,10,'pole',8,-3.00000,0,0,0,325,0,114,600,-1,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3599-1;'),
(9029,'Shadow Item: Dark Legion','','rhand','false',440,1,1,'fine_steel','a',232,10,'sword',8,0.00000,0,0,0,379,0,114,600,-1,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(9036,'Shadow Item: Bone Shield','','lhand','false',460,0,0,'bone','none',0,0,'none',0,0.00000,-8,90,20,0,0,0,600,-1,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(9044,'Shadow Item: Hoplon','','lhand','false',447,0,0,'fine_steel','d',0,0,'none',0,0.00000,-8,128,20,0,0,0,600,-1,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(9056,'Shadow Item: Composite Shield','','lhand','false',410,0,0,'fine_steel','c',0,0,'none',0,0.00000,-8,190,20,0,0,0,600,-1,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(9070,'Shadow Item: Zubei\'s Shield','','lhand','false',403,0,0,'mithril','b',0,0,'none',0,0.00000,-8,216,20,0,0,0,600,-1,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(9084,'Shadow Item: Dark Crystal Shield','','lhand','false',397,0,0,'crystal','a',0,0,'none',0,0.00000,-8,243,20,0,0,0,600,-1,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(9129,'Shadow Item: Shield of Nightmare','','lhand','false',400,0,0,'leather','a',0,0,'none',0,0.00000,-8,256,20,0,0,0,600,-1,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(9136,'Sword of Valakas (1-Handed)','','rhand','true',1380,3,3,'oriharukon','c',156,10,'sword',8,0.00000,0,0,0,379,0,83,-1,-1,0,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(9137,'Sword of Valakas (2-Handed)','','lrhand','true',2180,2,2,'fine_steel','d',78,10,'bigsword',8,0.00000,0,0,0,325,0,39,-1,-1,0,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(9140,'Salvation Bow','','lrhand','false',900,1,1,'wood','none',1,1,'bow',12,-3.00000,0,0,0,293,1,1,-1,-1,0,0,'false','false','false','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(9141,'Redemption Bow','','lrhand','false',300,1,1,'wood','none',1,1,'bow',12,-3.00000,0,0,0,293,1,1,230,-1,0,0,'false','false','false','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(9209,'Rapier','','rhand','true',1520,2,2,'wood','d',36,40,'rapier',10,-1.00000,0,0,0,406,0,26,-1,-1,315000,582,'true','true','true','true','true',3426,1,0,0,0,0,0,0,123,'0-0;'),
(9210,'Talwar','','lrhand','true',2100,2,2,'wood','d',43,15,'ancient',8,2.00000,0,0,0,350,0,26,-1,-1,315000,582,'true','true','true','true','true',0,0,0,0,0,0,0,0,5285,'0-0;'),
(9211,'Talwar','','lrhand','true',2100,2,2,'wood','d',43,15,'ancient',8,2.00000,0,0,0,350,0,26,-1,-1,315000,582,'true','true','true','true','true',0,0,0,0,0,0,0,0,7880,'0-0;'),
(9212,'Field Gun','','rhand','true',1870,3,2,'wood','d',51,10,'crossbow',10,-1.00000,0,0,0,303,0,26,-1,-1,315000,582,'true','true','true','true','true',0,0,0,0,0,0,0,0,274,'0-0;'),
(9213,'Fleuret','','rhand','true',1500,2,2,'wood','d',46,40,'rapier',10,-1.00000,0,0,0,406,0,32,-1,-1,495500,915,'true','true','true','true','true',3426,1,0,0,0,0,0,0,69,'0-0;'),
(9214,'Fleuret','','rhand','true',1500,2,2,'wood','d',46,40,'rapier',10,-1.00000,0,0,0,406,0,32,-1,-1,495500,915,'true','true','true','true','true',3426,1,0,0,0,0,0,0,125,'0-0;'),
(9215,'Fleuret','','rhand','true',1500,2,2,'wood','d',46,40,'rapier',10,-1.00000,0,0,0,406,0,32,-1,-1,495500,915,'true','true','true','true','true',3426,1,0,0,0,0,0,0,126,'0-0;'),
(9216,'Military Talwar','','lrhand','true',2080,2,2,'wood','d',55,15,'ancient',8,2.00000,0,0,0,350,0,32,-1,-1,495500,915,'true','true','true','true','true',0,0,0,0,0,0,0,0,123,'0-0;'),
(9217,'Hand Crossbow','','rhand','true',1850,4,2,'wood','d',64,10,'crossbow',10,-1.00000,0,0,0,303,0,32,-1,-1,495500,915,'true','true','true','true','true',0,0,0,0,0,0,0,0,275,'0-0;'),
(9218,'Estoc','','rhand','true',1470,2,2,'wood','d',58,40,'rapier',10,-1.00000,0,0,0,406,0,39,-1,-1,743500,1373,'true','true','true','true','true',3426,1,0,0,0,0,0,0,127,'0-0;'),
(9219,'Estoc','','rhand','true',1470,2,2,'wood','d',58,40,'rapier',10,-1.00000,0,0,0,406,0,39,-1,-1,743500,1373,'true','true','true','true','true',3426,1,0,0,0,0,0,0,130,'0-0;'),
(9220,'Field Sword','','lrhand','true',2060,2,2,'wood','d',69,15,'ancient',8,2.00000,0,0,0,350,0,39,-1,-1,743500,1373,'true','true','true','true','true',0,0,0,0,0,0,0,0,124,'0-0;'),
(9221,'Crossbow','','rhand','true',1840,4,2,'wood','d',81,10,'crossbow',10,-1.00000,0,0,0,303,0,39,-1,-1,743500,1373,'true','true','true','true','true',0,0,0,0,0,0,0,0,278,'0-0;'),
(9222,'Epee','','rhand','true',1450,3,3,'wood','d',72,40,'rapier',10,-1.00000,0,0,0,406,0,47,-1,-1,1074000,1983,'true','true','true','true','true',3426,1,0,0,0,0,0,0,129,'0-0;'),
(9223,'Katzbalger','','lrhand','true',2020,3,3,'wood','d',86,15,'ancient',8,2.00000,0,0,0,350,0,47,-1,-1,1070000,1983,'true','true','true','true','true',0,0,0,0,0,0,0,0,7881,'0-0;'),
(9224,'Arm Breaker','','rhand','true',1820,6,3,'wood','d',100,10,'crossbow',10,-1.00000,0,0,0,303,0,47,-1,-1,1074000,1983,'true','true','true','true','true',0,0,0,0,0,0,0,0,279,'0-0;'),
(9225,'Grand Epee','','rhand','true',1440,3,3,'wood','d',83,40,'rapier',10,-1.00000,0,0,0,406,0,54,-1,-1,1387000,2561,'true','true','true','true','true',3426,1,0,0,0,0,0,0,2499,'0-0;'),
(9226,'General\'s Katzbalger','','lrhand','true',2010,3,3,'wood','d',100,15,'ancient',8,2.00000,0,0,0,350,0,54,-1,-1,1387000,2561,'true','true','true','true','true',0,0,0,0,0,0,0,0,70,'0-0;'),
(9227,'Cranequin','','rhand','true',1810,6,3,'wood','d',117,10,'crossbow',10,-1.00000,0,0,0,303,0,54,-1,-1,1387000,2561,'true','true','true','true','true',0,0,0,0,0,0,0,0,280,'0-0;'),
(9228,'Soldat Estoc','','rhand','true',1430,2,2,'wood','c',97,40,'rapier',10,-1.00000,0,0,0,406,0,61,-1,-1,1762900,705,'true','true','true','true','true',3426,1,0,0,0,0,0,0,72,'0-0;'),
(9229,'Soldat Estoc','Critical Anger','rhand','true',1430,2,2,'wood','c',97,40,'rapier',10,-1.00000,0,0,0,406,0,61,-1,-1,1762900,705,'true','true','true','true','true',3426,1,0,0,0,3025,1,100,4681,'3026-1;'),
(9230,'Soldat Estoc','Focus','rhand','true',1430,2,2,'wood','c',97,40,'rapier',10,-1.00000,0,0,0,406,0,61,-1,-1,1762900,705,'true','true','true','true','true',3426,1,0,0,0,0,0,0,4682,'3010-1;'),
(9231,'Soldat Estoc','Light','rhand','true',1430,2,2,'wood','c',97,40,'rapier',10,-1.00000,0,0,0,406,0,61,-1,-1,1762900,705,'true','true','true','true','true',3426,1,0,0,0,0,0,0,4683,'3498-1;'),
(9232,'Schlager','','lrhand','true',1980,2,2,'wood','c',116,15,'ancient',8,2.00000,0,0,0,350,0,61,-1,-1,1762900,705,'true','true','true','true','true',0,0,0,0,0,0,0,0,71,'0-0;'),
(9233,'Schlager','Critical Damage','lrhand','true',1980,2,2,'wood','c',116,15,'ancient',8,2.00000,0,0,0,350,0,61,-1,-1,1762900,705,'true','true','true','true','true',0,0,0,0,0,0,0,0,4711,'3023-1;'),
(9234,'Schlager','Focus','lrhand','true',1980,2,2,'wood','c',116,15,'ancient',8,2.00000,0,0,0,350,0,61,-1,-1,1762900,705,'true','true','true','true','true',0,0,0,0,0,0,0,0,4712,'3010-1;'),
(9235,'Schlager','Light','lrhand','true',1980,2,2,'wood','c',116,15,'ancient',8,2.00000,0,0,0,350,0,61,-1,-1,1762900,705,'true','true','true','true','true',0,0,0,0,0,0,0,0,4713,'3498-1;'),
(9236,'Arbalest','','rhand','true',1790,4,2,'wood','c',135,10,'crossbow',10,-1.00000,0,0,0,303,0,61,-1,-1,1762900,705,'true','true','true','true','true',0,0,0,0,0,0,0,0,281,'0-0;'),
(9237,'Arbalest','Guidance','rhand','true',1790,4,2,'wood','c',135,10,'crossbow',10,-1.00000,0,0,0,303,0,61,-1,-1,1762900,705,'true','true','true','true','true',0,0,0,0,0,0,0,0,4810,'3008-1;'),
(9238,'Arbalest','Evasion','rhand','true',1790,4,2,'wood','c',135,10,'crossbow',10,-1.00000,0,0,0,303,0,61,-1,-1,1762900,705,'true','true','true','true','true',0,0,0,0,0,0,0,0,4811,'3009-1;'),
(9239,'Arbalest','Quick Recovery','rhand','true',1790,4,2,'wood','c',135,10,'crossbow',10,-1.00000,0,0,0,303,0,61,-1,-1,1762900,705,'true','true','true','true','true',0,0,0,0,0,0,0,0,4812,'0-0;'),
(9240,'Chevalier Rapier','','rhand','true',1420,2,2,'wood','c',111,40,'rapier',10,-1.00000,0,0,0,406,0,68,-1,-1,2209700,884,'true','true','true','true','true',3426,1,0,0,0,0,0,0,73,'0-0;'),
(9241,'Chevalier Rapier','Guidance','rhand','true',1420,2,2,'wood','c',111,40,'rapier',10,-1.00000,0,0,0,406,0,68,-1,-1,2209700,884,'true','true','true','true','true',3426,1,0,0,0,0,0,0,4684,'3007-2;'),
(9242,'Chevalier Rapier','Back Blow','rhand','true',1420,2,2,'wood','c',111,40,'rapier',10,-1.00000,0,0,0,406,0,68,-1,-1,2209700,884,'true','true','true','true','true',3426,1,0,0,0,0,0,0,4685,'3018-2;'),
(9243,'Chevalier Rapier','Rsk. Evasion','rhand','true',1420,2,2,'wood','c',111,40,'rapier',10,-1.00000,0,0,0,406,0,68,-1,-1,2209700,884,'true','true','true','true','true',3426,1,0,0,0,0,0,0,4686,'3028-5;'),
(9244,'Chevalier Rapier','','rhand','true',1420,2,2,'wood','c',111,40,'rapier',10,-1.00000,0,0,0,406,0,68,-1,-1,2209700,884,'true','true','true','true','true',3426,1,0,0,0,0,0,0,74,'0-0;'),
(9245,'Chevalier Rapier','Focus','rhand','true',1420,2,2,'wood','c',111,40,'rapier',10,-1.00000,0,0,0,406,0,68,-1,-1,2209700,884,'true','true','true','true','true',3426,1,0,0,0,0,0,0,4687,'3010-2;'),
(9246,'Chevalier Rapier','Critical Damage','rhand','true',1420,2,2,'wood','c',111,40,'rapier',10,-1.00000,0,0,0,406,0,68,-1,-1,2209700,884,'true','true','true','true','true',3426,1,0,0,0,0,0,0,4688,'3023-2;'),
(9247,'Chevalier Rapier','Haste','rhand','true',1420,2,2,'wood','c',111,40,'rapier',10,-1.00000,0,0,0,406,0,68,-1,-1,2209700,884,'true','true','true','true','true',3426,1,0,0,0,0,0,0,4689,'3036-2;'),
(9248,'Chevalier Rapier','','rhand','true',1420,2,2,'wood','c',111,40,'rapier',10,-1.00000,0,0,0,406,0,68,-1,-1,2209700,884,'true','true','true','true','true',3426,1,0,0,0,0,0,0,131,'0-0;'),
(9249,'Chevalier Rapier','Critical Damage','rhand','true',1420,2,2,'wood','c',111,40,'rapier',10,-1.00000,0,0,0,406,0,68,-1,-1,2209700,884,'true','true','true','true','true',3426,1,0,0,0,0,0,0,4690,'3023-2;'),
(9250,'Chevalier Rapier','Critical Poison','rhand','true',1420,2,2,'wood','c',111,40,'rapier',10,-1.00000,0,0,0,406,0,68,-1,-1,2209700,884,'true','true','true','true','true',3426,1,0,0,0,3024,2,15,4691,'0-0;'),
(9251,'Chevalier Rapier','Haste','rhand','true',1420,2,2,'wood','c',111,40,'rapier',10,-1.00000,0,0,0,406,0,68,-1,-1,2209700,884,'true','true','true','true','true',3426,1,0,0,0,0,0,0,4692,'3036-2;'),
(9252,'Chevalier Rapier','','rhand','true',1420,2,2,'wood','c',111,40,'rapier',10,-1.00000,0,0,0,406,0,68,-1,-1,2209700,884,'true','true','true','true','true',3426,1,0,0,0,0,0,0,133,'0-0;'),
(9253,'Chevalier Rapier','Focus','rhand','true',1420,2,2,'wood','c',111,40,'rapier',10,-1.00000,0,0,0,406,0,68,-1,-1,2209700,884,'true','true','true','true','true',3426,1,0,0,0,0,0,0,4693,'3010-2;'),
(9254,'Chevalier Rapier','Critical Drain','rhand','true',1420,2,2,'wood','c',111,40,'rapier',10,-1.00000,0,0,0,406,0,68,-1,-1,2209700,884,'true','true','true','true','true',3426,1,0,0,0,3022,2,33,4694,'0-0;'),
(9255,'Chevalier Rapier','Critical Poison','rhand','true',1420,2,2,'wood','c',111,40,'rapier',10,-1.00000,0,0,0,406,0,68,-1,-1,2209700,884,'true','true','true','true','true',3426,1,0,0,0,3024,2,15,4695,'0-0;'),
(9256,'Ballista','','rhand','true',1770,5,2,'wood','c',155,10,'crossbow',10,-1.00000,0,0,0,303,0,68,-1,-1,2209700,884,'true','true','true','true','true',0,0,0,0,0,0,0,0,282,'0-0;'),
(9257,'Ballista','Guidance','rhand','true',1770,5,2,'wood','c',155,10,'crossbow',10,-1.00000,0,0,0,303,0,68,-1,-1,2209700,884,'true','true','true','true','true',0,0,0,0,0,0,0,0,4813,'3008-2;'),
(9258,'Ballista','Miser','rhand','true',1770,5,2,'wood','c',155,10,'crossbow',10,-1.00000,0,0,0,303,0,68,-1,-1,2209700,884,'true','true','true','true','true',0,0,0,0,0,0,0,0,4814,'0-0;'),
(9259,'Ballista','Quick Recovery','rhand','true',1770,5,2,'wood','c',155,10,'crossbow',10,-1.00000,0,0,0,303,0,68,-1,-1,2209700,884,'true','true','true','true','true',0,0,0,0,0,0,0,0,4815,'0-0;'),
(9260,'Ballista','','rhand','true',1770,5,2,'wood','c',155,10,'crossbow',10,-1.00000,0,0,0,303,0,68,-1,-1,2209700,884,'true','true','true','true','true',0,0,0,0,0,0,0,0,285,'0-0;'),
(9261,'Ballista','Evasion','rhand','true',1770,5,2,'wood','c',155,10,'crossbow',10,-1.00000,0,0,0,303,0,68,-1,-1,2209700,884,'true','true','true','true','true',0,0,0,0,0,0,0,0,4816,'3009-2;'),
(9262,'Ballista','Miser','rhand','true',1770,5,2,'wood','c',155,10,'crossbow',10,-1.00000,0,0,0,303,0,68,-1,-1,2209700,884,'true','true','true','true','true',0,0,0,0,0,0,0,0,4817,'0-0;'),
(9263,'Ballista','Cheap Shot','rhand','true',1770,5,2,'wood','c',155,10,'crossbow',10,-1.00000,0,0,0,303,0,68,-1,-1,2209700,884,'true','true','true','true','true',0,0,0,0,0,0,0,0,4818,'0-0;'),
(9264,'Blinzlasher','','rhand','true',1400,3,3,'wood','c',126,40,'rapier',10,-1.00000,0,0,0,406,0,76,-1,-1,3304300,1322,'true','true','true','true','true',3426,1,0,0,0,0,0,0,75,'0-0;'),
(9265,'Blinzlasher','Guidance','rhand','true',1400,3,3,'wood','c',126,40,'rapier',10,-1.00000,0,0,0,406,0,76,-1,-1,3304300,1322,'true','true','true','true','true',3426,1,0,0,0,0,0,0,4696,'3007-3;'),
(9266,'Blinzlasher','Focus','rhand','true',1400,3,3,'wood','c',126,40,'rapier',10,-1.00000,0,0,0,406,0,76,-1,-1,3304300,1322,'true','true','true','true','true',3426,1,0,0,0,0,0,0,4697,'3010-3;'),
(9267,'Blinzlasher','Critical Damage','rhand','true',1400,3,3,'wood','c',126,40,'rapier',10,-1.00000,0,0,0,406,0,76,-1,-1,3304300,1322,'true','true','true','true','true',3426,1,0,0,0,0,0,0,4698,'3023-3;'),
(9268,'Blinzlasher','','rhand','true',1400,3,3,'wood','c',126,40,'rapier',10,-1.00000,0,0,0,406,0,76,-1,-1,3304300,1322,'true','true','true','true','true',3426,1,0,0,0,0,0,0,76,'0-0;'),
(9269,'Blinzlasher','Focus','rhand','true',1400,3,3,'wood','c',126,40,'rapier',10,-1.00000,0,0,0,406,0,76,-1,-1,3304300,1322,'true','true','true','true','true',3426,1,0,0,0,0,0,0,4699,'3010-3;'),
(9270,'Blinzlasher','Health','rhand','true',1400,3,3,'wood','c',126,40,'rapier',10,-1.00000,0,0,0,406,0,76,-1,-1,3304300,1322,'true','true','true','true','true',3426,1,0,0,0,0,0,0,4700,'3013-1;'),
(9271,'Blinzlasher','Rsk. Haste','rhand','true',1400,3,3,'wood','c',126,40,'rapier',10,-1.00000,0,0,0,406,0,76,-1,-1,3304300,1322,'true','true','true','true','true',3426,1,0,0,0,0,0,0,4701,'3032-3;'),
(9272,'Blinzlasher','','rhand','true',1400,3,3,'wood','c',126,40,'rapier',10,-1.00000,0,0,0,406,0,76,-1,-1,3304300,1322,'true','true','true','true','true',3426,1,0,0,0,0,0,0,77,'0-0;'),
(9273,'Blinzlasher','Focus','rhand','true',1400,3,3,'wood','c',126,40,'rapier',10,-1.00000,0,0,0,406,0,76,-1,-1,3304300,1322,'true','true','true','true','true',3426,1,0,0,0,0,0,0,4702,'3010-3;'),
(9274,'Blinzlasher','Critical Damage','rhand','true',1400,3,3,'wood','c',126,40,'rapier',10,-1.00000,0,0,0,406,0,76,-1,-1,3304300,1322,'true','true','true','true','true',3426,1,0,0,0,0,0,0,4703,'3023-3;'),
(9275,'Blinzlasher','Haste','rhand','true',1400,3,3,'wood','c',126,40,'rapier',10,-1.00000,0,0,0,406,0,76,-1,-1,3304300,1322,'true','true','true','true','true',3426,1,0,0,0,0,0,0,4704,'3036-3;'),
(9276,'Blinzlasher','','rhand','true',1400,3,3,'wood','c',126,40,'rapier',10,-1.00000,0,0,0,406,0,76,-1,-1,3304300,1322,'true','true','true','true','true',3426,1,0,0,0,0,0,0,134,'0-0;'),
(9277,'Blinzlasher','Health','rhand','true',1400,3,3,'wood','c',126,40,'rapier',10,-1.00000,0,0,0,406,0,76,-1,-1,3304300,1322,'true','true','true','true','true',3426,1,0,0,0,0,0,0,4705,'3013-1;'),
(9278,'Blinzlasher','Focus','rhand','true',1400,3,3,'wood','c',126,40,'rapier',10,-1.00000,0,0,0,406,0,76,-1,-1,3304300,1322,'true','true','true','true','true',3426,1,0,0,0,0,0,0,4706,'3010-3;'),
(9279,'Blinzlasher','Light','rhand','true',1400,3,3,'wood','c',126,40,'rapier',10,-1.00000,0,0,0,406,0,76,-1,-1,3304300,1322,'true','true','true','true','true',3426,1,0,0,0,0,0,0,4707,'3498-1;'),
(9280,'Blinzlasher','','rhand','true',1400,3,3,'wood','c',126,40,'rapier',10,-1.00000,0,0,0,406,0,76,-1,-1,3304300,1322,'true','true','true','true','true',3426,1,0,0,0,0,0,0,132,'0-0;'),
(9281,'Blinzlasher','Guidance','rhand','true',1400,3,3,'wood','c',126,40,'rapier',10,-1.00000,0,0,0,406,0,76,-1,-1,3304300,1322,'true','true','true','true','true',3426,1,0,0,0,0,0,0,6307,'3007-3;'),
(9282,'Blinzlasher','Critical Drain','rhand','true',1400,3,3,'wood','c',126,40,'rapier',10,-1.00000,0,0,0,406,0,76,-1,-1,3304300,1322,'true','true','true','true','true',3426,1,0,0,0,3022,3,33,6308,'0-0;'),
(9283,'Blinzlasher','Health','rhand','true',1400,3,3,'wood','c',126,40,'rapier',10,-1.00000,0,0,0,406,0,76,-1,-1,3304300,1322,'true','true','true','true','true',3426,1,0,0,0,0,0,0,6309,'3013-1;'),
(9284,'Immortal Edge','','lrhand','true',1980,3,3,'wood','c',151,15,'ancient',8,2.00000,0,0,0,350,0,76,-1,-1,3304300,1322,'true','true','true','true','true',0,0,0,0,0,0,0,0,7882,'0-0;'),
(9285,'Immortal Edge','Focus','lrhand','true',1980,3,3,'wood','c',151,15,'ancient',8,2.00000,0,0,0,350,0,76,-1,-1,3304300,1322,'true','true','true','true','true',0,0,0,0,0,0,0,0,8102,'3010-3;'),
(9286,'Immortal Edge','Health','lrhand','true',1980,3,3,'wood','c',151,15,'ancient',8,2.00000,0,0,0,350,0,76,-1,-1,3304300,1322,'true','true','true','true','true',0,0,0,0,0,0,0,0,8103,'3013-1;'),
(9287,'Immortal Edge','Critical Drain','lrhand','true',1980,3,3,'wood','c',151,15,'ancient',8,2.00000,0,0,0,350,0,76,-1,-1,3304300,1322,'true','true','true','true','true',0,0,0,0,0,3022,2,33,8104,'0-0;'),
(9288,'Tathlum','','rhand','true',1760,5,3,'wood','c',176,10,'crossbow',10,-1.00000,0,0,0,303,0,76,-1,-1,3304300,1322,'true','true','true','true','true',0,0,0,0,0,0,0,0,283,'0-0;'),
(9289,'Tathlum','Guidance','rhand','true',1760,5,3,'wood','c',176,10,'crossbow',10,-1.00000,0,0,0,303,0,76,-1,-1,3304300,1322,'true','true','true','true','true',0,0,0,0,0,0,0,0,4819,'3008-3;'),
(9290,'Tathlum','Evasion','rhand','true',1760,5,3,'wood','c',176,10,'crossbow',10,-1.00000,0,0,0,303,0,76,-1,-1,3304300,1322,'true','true','true','true','true',0,0,0,0,0,0,0,0,4820,'3009-3;'),
(9291,'Tathlum','Miser','rhand','true',1760,5,3,'wood','c',176,10,'crossbow',10,-1.00000,0,0,0,303,0,76,-1,-1,3304300,1322,'true','true','true','true','true',0,0,0,0,0,0,0,0,4821,'0-0;'),
(9292,'Admiral\'s Estoc','','rhand','true',1380,3,3,'wood','c',141,40,'rapier',10,-1.00000,0,0,0,406,0,83,-1,-1,4713500,1885,'true','true','true','true','true',3426,1,0,0,0,0,0,0,135,'0-0;'),
(9293,'Admiral\'s Estoc','Focus','rhand','true',1380,3,3,'wood','c',141,40,'rapier',10,-1.00000,0,0,0,406,0,83,-1,-1,4713500,1885,'true','true','true','true','true',3426,1,0,0,0,0,0,0,4708,'3010-4;'),
(9294,'Admiral\'s Estoc','Critical Damage','rhand','true',1380,3,3,'wood','c',141,40,'rapier',10,-1.00000,0,0,0,406,0,83,-1,-1,4713500,1885,'true','true','true','true','true',3426,1,0,0,0,0,0,0,4709,'3023-4;'),
(9295,'Admiral\'s Estoc','Haste','rhand','true',1380,3,3,'wood','c',141,40,'rapier',10,-1.00000,0,0,0,406,0,83,-1,-1,4713500,1885,'true','true','true','true','true',3426,1,0,0,0,0,0,0,4710,'3036-4;'),
(9296,'Saber Tooth','','lrhand','true',1950,3,3,'wood','c',169,15,'ancient',8,2.00000,0,0,0,350,0,83,-1,-1,4713500,1885,'true','true','true','true','true',0,0,0,0,0,0,0,0,5286,'0-0;'),
(9297,'Saber Tooth','Focus','lrhand','true',1950,3,3,'wood','c',169,15,'ancient',8,2.00000,0,0,0,350,0,83,-1,-1,4713500,1885,'true','true','true','true','true',0,0,0,0,0,0,0,0,6347,'3010-4;'),
(9298,'Saber Tooth','Critical Damage','lrhand','true',1950,3,3,'wood','c',169,15,'ancient',8,2.00000,0,0,0,350,0,83,-1,-1,4713500,1885,'true','true','true','true','true',0,0,0,0,0,0,0,0,6348,'3542-4;'),
(9299,'Saber Tooth','Haste','lrhand','true',1950,3,3,'wood','c',169,15,'ancient',8,2.00000,0,0,0,350,0,83,-1,-1,4713500,1885,'true','true','true','true','true',0,0,0,0,0,0,0,0,6349,'3037-4;'),
(9300,'Sharpshooter','','rhand','true',1740,6,3,'wood','c',198,10,'crossbow',10,-1.00000,0,0,0,303,0,83,-1,-1,4713500,1885,'true','true','true','true','true',0,0,0,0,0,0,0,0,286,'0-0;'),
(9301,'Sharpshooter','Guidance','rhand','true',1740,6,3,'wood','c',198,10,'crossbow',10,-1.00000,0,0,0,303,0,83,-1,-1,4713500,1885,'true','true','true','true','true',0,0,0,0,0,0,0,0,4822,'3008-4;'),
(9302,'Sharpshooter','Miser','rhand','true',1740,6,3,'wood','c',198,10,'crossbow',10,-1.00000,0,0,0,303,0,83,-1,-1,4713500,1885,'true','true','true','true','true',0,0,0,0,0,0,0,0,4823,'0-0;'),
(9303,'Sharpshooter','Cheap Shot','rhand','true',1740,6,3,'wood','c',198,10,'crossbow',10,-1.00000,0,0,0,303,0,83,-1,-1,4713500,1885,'true','true','true','true','true',0,0,0,0,0,0,0,0,4824,'0-0;'),
(9304,'Military Fleuret','','rhand','true',1370,1,1,'wood','b',159,40,'rapier',10,-1.00000,0,0,0,406,0,91,-1,-1,6680500,891,'true','true','true','true','true',3426,1,0,0,0,0,0,0,142,'0-0;'),
(9305,'Military Fleuret','Guidance','rhand','true',1370,1,1,'wood','b',159,40,'rapier',10,-1.00000,0,0,0,406,0,91,-1,-1,6680500,891,'true','true','true','true','true',3426,1,0,0,0,0,0,0,4714,'3007-5;'),
(9306,'Military Fleuret','Focus','rhand','true',1370,1,1,'wood','b',159,40,'rapier',10,-1.00000,0,0,0,406,0,91,-1,-1,6680500,891,'true','true','true','true','true',3426,1,0,0,0,0,0,0,4715,'3010-5;'),
(9307,'Military Fleuret','Back Blow','rhand','true',1370,1,1,'wood','b',159,40,'rapier',10,-1.00000,0,0,0,406,0,91,-1,-1,6680500,891,'true','true','true','true','true',3426,1,0,0,0,0,0,0,4716,'3018-5;'),
(9308,'Innominate Victory','','lrhand','true',1930,1,1,'wood','b',190,15,'ancient',8,2.00000,0,0,0,350,0,91,-1,-1,6680500,891,'true','true','true','true','true',0,0,0,0,0,0,0,0,78,'0-0;'),
(9309,'Innominate Victory','Health','lrhand','true',1930,1,1,'wood','b',190,15,'ancient',8,2.00000,0,0,0,350,0,91,-1,-1,6680500,891,'true','true','true','true','true',0,0,0,0,0,0,0,0,4723,'3013-1;'),
(9310,'Innominate Victory','Critical Damage','lrhand','true',1930,1,1,'wood','b',190,15,'ancient',8,2.00000,0,0,0,350,0,91,-1,-1,6680500,891,'true','true','true','true','true',0,0,0,0,0,0,0,0,4724,'3023-5;'),
(9311,'Innominate Victory','Focus','lrhand','true',1930,1,1,'wood','b',190,15,'ancient',8,2.00000,0,0,0,350,0,91,-1,-1,6680500,891,'true','true','true','true','true',0,0,0,0,0,0,0,0,4725,'3010-5;'),
(9312,'Peacemaker','','rhand','true',1720,2,1,'wood','b',221,10,'crossbow',10,-1.00000,0,0,0,303,0,91,-1,-1,6680500,891,'true','true','true','true','true',0,0,0,0,0,0,0,0,284,'0-0;'),
(9313,'Peacemaker','Evasion','rhand','true',1720,2,1,'wood','b',221,10,'crossbow',10,-1.00000,0,0,0,303,0,91,-1,-1,6680500,891,'true','true','true','true','true',0,0,0,0,0,0,0,0,4825,'3009-5;'),
(9314,'Peacemaker','Critical Bleed','rhand','true',1720,2,1,'wood','b',221,10,'crossbow',10,-1.00000,0,0,0,303,0,91,-1,-1,6680500,891,'true','true','true','true','true',0,0,0,0,0,3021,5,41,4826,'0-0;'),
(9315,'Peacemaker','Miser','rhand','true',1720,2,1,'wood','b',221,10,'crossbow',10,-1.00000,0,0,0,303,0,91,-1,-1,6680500,891,'true','true','true','true','true',0,0,0,0,0,0,0,0,4827,'0-0;'),
(9316,'Colichemarde','','rhand','true',1350,1,1,'wood','b',176,40,'rapier',10,-1.00000,0,0,0,406,0,99,-1,-1,10091400,1346,'true','true','true','true','true',3426,1,0,0,0,0,0,0,79,'0-0;'),
(9317,'Colichemarde','Focus','rhand','true',1350,1,1,'wood','b',176,40,'rapier',10,-1.00000,0,0,0,406,0,99,-1,-1,10091400,1346,'true','true','true','true','true',3426,1,0,0,0,0,0,0,4717,'3010-6;'),
(9318,'Colichemarde','Critical Damage','rhand','true',1350,1,1,'wood','b',176,40,'rapier',10,-1.00000,0,0,0,406,0,99,-1,-1,10091400,1346,'true','true','true','true','true',3426,1,0,0,0,0,0,0,4718,'3023-6;'),
(9319,'Colichemarde','Haste','rhand','true',1350,1,1,'wood','b',176,40,'rapier',10,-1.00000,0,0,0,406,0,99,-1,-1,10091400,1346,'true','true','true','true','true',3426,1,0,0,0,0,0,0,4719,'3036-6;'),
(9320,'Dismantler','','lrhand','true',1930,1,1,'wood','b',210,15,'ancient',8,2.00000,0,0,0,350,0,99,-1,-1,10091400,1346,'true','true','true','true','true',0,0,0,0,0,0,0,0,7883,'0-0;'),
(9321,'Dismantler','Critical Drain','lrhand','true',1930,1,1,'wood','b',210,15,'ancient',8,2.00000,0,0,0,350,0,99,-1,-1,10091400,1346,'true','true','true','true','true',0,0,0,0,0,3022,6,33,8105,'0-0;'),
(9322,'Dismantler','Health','lrhand','true',1930,1,1,'wood','b',210,15,'ancient',8,2.00000,0,0,0,350,0,99,-1,-1,10091400,1346,'true','true','true','true','true',0,0,0,0,0,0,0,0,8106,'3013-1;'),
(9323,'Dismantler','Critical Bleed','lrhand','true',1930,1,1,'wood','b',210,15,'ancient',8,2.00000,0,0,0,350,0,99,-1,-1,10091400,1346,'true','true','true','true','true',0,0,0,0,0,3055,2,24,8107,'0-0;'),
(9324,'Hell Hound','','rhand','true',1700,2,1,'wood','b',245,10,'crossbow',10,-1.00000,0,0,0,303,0,99,-1,-1,10091400,1346,'true','true','true','true','true',0,0,0,0,0,0,0,0,287,'0-0;'),
(9325,'Hell Hound','Guidance','rhand','true',1700,2,1,'wood','b',245,10,'crossbow',10,-1.00000,0,0,0,303,0,99,-1,-1,10091400,1346,'true','true','true','true','true',0,0,0,0,0,0,0,0,4828,'3008-6;'),
(9326,'Hell Hound','Quick Recovery','rhand','true',1700,2,1,'wood','b',245,10,'crossbow',10,-1.00000,0,0,0,303,0,99,-1,-1,10091400,1346,'true','true','true','true','true',0,0,0,0,0,0,0,0,4829,'0-0;'),
(9327,'Hell Hound','Cheap Shot','rhand','true',1700,2,1,'wood','b',245,10,'crossbow',10,-1.00000,0,0,0,303,0,99,-1,-1,10091400,1346,'true','true','true','true','true',0,0,0,0,0,0,0,0,4830,'0-0;'),
(9328,'White Lightning','','rhand','true',1330,1,1,'wood','a',193,40,'rapier',10,-1.00000,0,0,0,406,0,107,-1,-1,14100000,1128,'true','true','true','true','true',3426,1,0,0,0,0,0,0,80,'0-0;'),
(9329,'White Lightning','Critical Poison','rhand','true',1330,1,1,'wood','a',193,40,'rapier',10,-1.00000,0,0,0,406,0,107,-1,-1,14100000,1128,'true','true','true','true','true',3426,1,0,0,0,3061,1,10,4720,'3552-1;'),
(9330,'White Lightning','Haste','rhand','true',1330,1,1,'wood','a',193,40,'rapier',10,-1.00000,0,0,0,406,0,107,-1,-1,14100000,1128,'true','true','true','true','true',3426,1,0,0,0,0,0,0,4721,'3068-2;'),
(9331,'White Lightning','Anger','rhand','true',1330,1,1,'wood','a',193,40,'rapier',10,-1.00000,0,0,0,406,0,107,-1,-1,14100000,1128,'true','true','true','true','true',3426,1,0,0,0,0,0,0,4722,'3057-1;'),
(9332,'Divine Pain','','lrhand','true',1900,1,1,'wood','a',231,15,'ancient',8,2.00000,0,0,0,350,0,107,-1,-1,14100000,1128,'true','true','true','true','true',0,0,0,0,0,0,0,0,7884,'0-0;'),
(9333,'Divine Pain','Haste','lrhand','true',1900,1,1,'wood','a',231,15,'ancient',8,2.00000,0,0,0,350,0,107,-1,-1,14100000,1128,'true','true','true','true','true',0,0,0,0,0,0,0,0,8108,'3564-2;'),
(9334,'Divine Pain','Critical Damage','lrhand','true',1900,1,1,'wood','a',231,15,'ancient',8,2.00000,0,0,0,350,0,107,-1,-1,14100000,1128,'true','true','true','true','true',0,0,0,0,0,0,0,0,8109,'3067-1;'),
(9335,'Divine Pain','Focus','lrhand','true',1900,1,1,'wood','a',231,15,'ancient',8,2.00000,0,0,0,350,0,107,-1,-1,14100000,1128,'true','true','true','true','true',0,0,0,0,0,0,0,0,8110,'3050-2;'),
(9336,'Doomchanter','','rhand','true',1670,1,1,'wood','a',270,10,'crossbow',10,-1.00000,0,0,0,303,0,107,-1,-1,14100000,1128,'true','true','true','true','true',0,0,0,0,0,0,0,0,288,'0-0;'),
(9337,'Doomchanter','Light','rhand','true',1670,1,1,'wood','a',270,10,'crossbow',10,-1.00000,0,0,0,303,0,107,-1,-1,14100000,1128,'true','true','true','true','true',0,0,0,0,0,0,0,0,5608,'3498-1;'),
(9338,'Doomchanter','Critical Bleed','rhand','true',1670,1,1,'wood','a',270,10,'crossbow',10,-1.00000,0,0,0,303,0,107,-1,-1,14100000,1128,'true','true','true','true','true',0,0,0,0,0,3053,1,35,5609,'3552-1;'),
(9339,'Doomchanter','Mana Up','rhand','true',1670,1,1,'wood','a',270,10,'crossbow',10,-1.00000,0,0,0,303,0,107,-1,-1,14100000,1128,'true','true','true','true','true',0,0,0,0,0,0,0,0,5610,'3014-2;'),
(9340,'Lacerator','','rhand','true',1320,1,1,'wood','a',210,40,'rapier',10,-1.00000,0,0,0,406,0,114,-1,-1,20740000,1659,'true','true','true','true','true',3426,1,0,0,0,0,0,0,2500,'0-0;'),
(9341,'Lacerator','Critical Damage','rhand','true',1320,1,1,'wood','a',210,40,'rapier',10,-1.00000,0,0,0,406,0,114,-1,-1,20740000,1659,'true','true','true','true','true',3426,1,0,0,0,0,0,0,5647,'3067-2;'),
(9342,'Lacerator','Health','rhand','true',1320,1,1,'wood','a',210,40,'rapier',10,-1.00000,0,0,0,406,0,114,-1,-1,20740000,1659,'true','true','true','true','true',3426,1,0,0,0,0,0,0,5648,'3013-3;'),
(9343,'Lacerator','Rsk. Focus','rhand','true',1320,1,1,'wood','a',210,40,'rapier',10,-1.00000,0,0,0,406,0,114,-1,-1,20740000,1659,'true','true','true','true','true',3426,1,0,0,0,0,0,0,5649,'3071-2;'),
(9344,'Undertaker','','lrhand','true',1840,1,1,'wood','a',251,15,'ancient',8,2.00000,0,0,0,350,0,114,-1,-1,20740000,1659,'true','true','true','true','true',0,0,0,0,0,0,0,0,81,'0-0;'),
(9345,'Undertaker','Health','lrhand','true',1840,1,1,'wood','a',251,15,'ancient',8,2.00000,0,0,0,350,0,114,-1,-1,20740000,1659,'true','true','true','true','true',0,0,0,0,0,0,0,0,5644,'3013-3;'),
(9346,'Undertaker','Critical Bleed','lrhand','true',1840,1,1,'wood','a',251,15,'ancient',8,2.00000,0,0,0,350,0,114,-1,-1,20740000,1659,'true','true','true','true','true',0,0,0,0,0,3055,2,24,5645,'3552-1;'),
(9347,'Undertaker','Critical Drain','lrhand','true',1840,1,1,'wood','a',251,15,'ancient',8,2.00000,0,0,0,350,0,114,-1,-1,20740000,1659,'true','true','true','true','true',0,0,0,0,0,3060,2,33,5646,'3552-1;'),
(9348,'Reaper','','rhand','true',1660,1,1,'wood','a',294,10,'crossbow',10,-1.00000,0,0,0,303,0,114,-1,-1,20740000,1659,'true','true','true','true','true',0,0,0,0,0,0,0,0,289,'0-0;'),
(9349,'Reaper','Cheap Shot','rhand','true',1660,1,1,'wood','a',294,10,'crossbow',10,-1.00000,0,0,0,303,0,114,-1,-1,20740000,1659,'true','true','true','true','true',0,0,0,0,0,0,0,0,5611,'3552-1;'),
(9350,'Reaper','Quick Recovery','rhand','true',1660,1,1,'wood','a',294,10,'crossbow',10,-1.00000,0,0,0,303,0,114,-1,-1,20740000,1659,'true','true','true','true','true',0,0,0,0,0,0,0,0,5612,'3552-1;'),
(9351,'Reaper','Critical Poison','rhand','true',1660,1,1,'wood','a',294,10,'crossbow',10,-1.00000,0,0,0,303,0,114,-1,-1,20740000,1659,'true','true','true','true','true',0,0,0,0,0,3062,2,18,5613,'3552-1;'),
(9352,'Eclair Bijou','','rhand','true',1300,1,1,'wood','a',228,40,'rapier',10,-1.00000,0,0,0,406,0,121,-1,-1,26968400,2157,'true','true','true','true','true',3426,1,0,0,0,0,0,0,8678,'0-0;'),
(9353,'Eclair Bijou','Haste','rhand','true',1300,1,1,'wood','a',228,40,'rapier',10,-1.00000,0,0,0,406,0,121,-1,-1,26968400,2157,'true','true','true','true','true',3426,1,0,0,0,0,0,0,8788,'3564-2;'),
(9354,'Eclair Bijou','Health','rhand','true',1300,1,1,'wood','a',228,40,'rapier',10,-1.00000,0,0,0,406,0,121,-1,-1,26968400,2157,'true','true','true','true','true',3426,1,0,0,0,0,0,0,8789,'3013-3;'),
(9355,'Eclair Bijou','Critical Poison','rhand','true',1300,1,1,'wood','a',228,40,'rapier',10,-1.00000,0,0,0,406,0,121,-1,-1,26968400,2157,'true','true','true','true','true',3426,1,0,0,0,3061,3,15,8790,'3552-1;'),
(9356,'Durendal','','lrhand','true',1820,1,1,'wood','a',272,15,'ancient',8,2.00000,0,0,0,350,0,121,-1,-1,26968400,2157,'true','true','true','true','true',0,0,0,0,0,0,0,0,8679,'0-0;'),
(9357,'Durendal','Focus','lrhand','true',1820,1,1,'wood','a',272,15,'ancient',8,2.00000,0,0,0,350,0,121,-1,-1,26968400,2157,'true','true','true','true','true',0,0,0,0,0,0,0,0,8791,'3050-2;'),
(9358,'Durendal','Haste','lrhand','true',1820,1,1,'wood','a',272,15,'ancient',8,2.00000,0,0,0,350,0,121,-1,-1,26968400,2157,'true','true','true','true','true',0,0,0,0,0,0,0,0,8792,'3564-2;'),
(9359,'Durendal','Health','lrhand','true',1820,1,1,'wood','a',272,15,'ancient',8,2.00000,0,0,0,350,0,121,-1,-1,26968400,2157,'true','true','true','true','true',0,0,0,0,0,0,0,0,8793,'3013-3;'),
(9360,'Screaming Vengeance','','rhand','true',1640,1,1,'wood','a',318,10,'crossbow',10,-1.00000,0,0,0,303,0,121,-1,-1,26968400,2157,'true','true','true','true','true',0,0,0,0,0,0,0,0,8684,'0-0;'),
(9361,'Screaming Vengeance','Cheap Shot','rhand','true',1640,1,1,'wood','a',318,10,'crossbow',10,-1.00000,0,0,0,303,0,121,-1,-1,26968400,2157,'true','true','true','true','true',0,0,0,0,0,0,0,0,8806,'3552-1;'),
(9362,'Screaming Vengeance','Focus','rhand','true',1640,1,1,'wood','a',318,10,'crossbow',10,-1.00000,0,0,0,303,0,121,-1,-1,26968400,2157,'true','true','true','true','true',0,0,0,0,0,0,0,0,8807,'3050-2;'),
(9363,'Screaming Vengeance','Quick Recovery','rhand','true',1640,1,1,'wood','a',318,10,'crossbow',10,-1.00000,0,0,0,303,0,121,-1,-1,26968400,2157,'true','true','true','true','true',0,0,0,0,0,0,0,0,8808,'3552-1;'),
(9364,'Laevateinn','','rhand','true',1300,1,1,'wood','s',255,40,'rapier',10,-1.00000,0,0,0,406,0,132,-1,-1,42759400,2052,'true','true','true','true','true',3426,1,0,0,0,0,0,0,6364,'0-0;'),
(9365,'Laevateinn','Haste','rhand','true',1300,1,1,'wood','s',255,40,'rapier',10,-1.00000,0,0,0,406,0,132,-1,-1,42759400,2052,'true','true','true','true','true',3426,1,0,0,0,0,0,0,6581,'3564-1;'),
(9366,'Laevateinn','Health','rhand','true',1300,1,1,'wood','s',255,40,'rapier',10,-1.00000,0,0,0,406,0,132,-1,-1,42759400,2052,'true','true','true','true','true',3426,1,0,0,0,0,0,0,6582,'3013-3;'),
(9367,'Laevateinn','Focus','rhand','true',1300,1,1,'wood','s',255,40,'rapier',10,-1.00000,0,0,0,406,0,132,-1,-1,42759400,2052,'true','true','true','true','true',3426,1,0,0,0,0,0,0,6583,'3566-1;'),
(9368,'Gram','','lrhand','true',1800,1,1,'wood','s',304,15,'ancient',8,2.00000,0,0,0,350,0,132,-1,-1,42759400,2052,'true','true','true','true','true',0,0,0,0,0,0,0,0,6372,'0-0;'),
(9369,'Gram','Haste','lrhand','true',1800,1,1,'wood','s',304,15,'ancient',8,2.00000,0,0,0,350,0,132,-1,-1,42759400,2052,'true','true','true','true','true',0,0,0,0,0,0,0,0,6605,'3564-1;'),
(9370,'Gram','Health','lrhand','true',1800,1,1,'wood','s',304,15,'ancient',8,2.00000,0,0,0,350,0,132,-1,-1,42759400,2052,'true','true','true','true','true',0,0,0,0,0,0,0,0,6606,'3013-3;'),
(9371,'Gram','Focus','lrhand','true',1800,1,1,'wood','s',304,15,'ancient',8,2.00000,0,0,0,350,0,132,-1,-1,42759400,2052,'true','true','true','true','true',0,0,0,0,0,0,0,0,6607,'3566-1;'),
(9372,'Sarnga','','rhand','true',1600,1,1,'wood','s',356,10,'crossbow',10,-1.00000,0,0,0,303,0,132,-1,-1,42759400,2052,'true','true','true','true','true',0,0,0,0,0,0,0,0,7575,'0-0;'),
(9373,'Sarnga','Cheap Shot','rhand','true',1600,1,1,'wood','s',356,10,'crossbow',10,-1.00000,0,0,0,303,0,132,-1,-1,42759400,2052,'true','true','true','true','true',0,0,0,0,0,0,0,0,7576,'3552-1;'),
(9374,'Sarnga','Focus','rhand','true',1600,1,1,'wood','s',356,10,'crossbow',10,-1.00000,0,0,0,303,0,132,-1,-1,42759400,2052,'true','true','true','true','true',0,0,0,0,0,0,0,0,7577,'3567-1;'),
(9375,'Sarnga','Critical Slow','rhand','true',1600,1,1,'wood','s',356,10,'crossbow',10,-1.00000,0,0,0,303,0,132,-1,-1,42759400,2052,'true','true','true','true','true',0,0,0,0,0,3574,1,16,7578,'3552-1;'),
(9376,'Dynasty Rapier','','rhand','true',1280,1,1,'wood','s80',302,40,'rapier',10,-1.00000,0,0,0,406,0,151,-1,-1,74946000,3597,'true','true','true','true','true',3426,1,0,0,0,0,0,0,9442,'0-0;'),
(9377,'Dynasty Rapier','Focus','rhand','true',1280,1,1,'wood','s80',302,40,'rapier',10,-1.00000,0,0,0,406,0,151,-1,-1,74946000,3597,'true','true','true','true','true',3426,1,0,0,0,0,0,0,9854,'3566-2;'),
(9378,'Dynasty Rapier','Health','rhand','true',1280,1,1,'wood','s80',302,40,'rapier',10,-1.00000,0,0,0,406,0,151,-1,-1,74946000,3597,'true','true','true','true','true',3426,1,0,0,0,0,0,0,9855,'3013-5;'),
(9379,'Dynasty Rapier','Light','rhand','true',1280,1,1,'wood','s80',302,40,'rapier',10,-1.00000,0,0,0,406,0,151,-1,-1,74946000,3597,'true','true','true','true','true',3426,1,0,0,0,0,0,0,9856,'3498-1;'),
(9380,'Dynasty Ancient Sword','','lrhand','true',1800,1,1,'wood','s80',361,15,'ancient',8,2.00000,0,0,0,350,0,151,-1,-1,74946000,3597,'true','true','true','true','true',0,0,0,0,0,0,0,0,9443,'0-0;'),
(9381,'Dynasty Ancient Sword','Focus','lrhand','true',1800,1,1,'wood','s80',361,15,'ancient',8,2.00000,0,0,0,350,0,151,-1,-1,74946000,3597,'true','true','true','true','true',0,0,0,0,0,0,0,0,9857,'3566-2;'),
(9382,'Dynasty Ancient Sword','Health','lrhand','true',1800,1,1,'wood','s80',361,15,'ancient',8,2.00000,0,0,0,350,0,151,-1,-1,74946000,3597,'true','true','true','true','true',0,0,0,0,0,0,0,0,9858,'3013-5;'),
(9383,'Dynasty Ancient Sword','Light','lrhand','true',1800,1,1,'wood','s80',361,15,'ancient',8,2.00000,0,0,0,350,0,151,-1,-1,74946000,3597,'true','true','true','true','true',0,0,0,0,0,0,0,0,9859,'3498-1;'),
(9384,'Dynasty Crossbow','','rhand','true',1580,1,1,'wood','s80',401,10,'crossbow',10,-1.00000,0,0,0,303,0,151,-1,-1,74946000,3597,'true','true','true','true','true',0,0,0,0,0,0,0,0,9445,'0-0;'),
(9385,'Dynasty Crossbow','Cheap Shot','rhand','true',1580,1,1,'wood','s80',401,10,'crossbow',10,-1.00000,0,0,0,303,0,151,-1,-1,74946000,3597,'true','true','true','true','true',0,0,0,0,0,0,0,0,9863,'3552-1;'),
(9386,'Dynasty Crossbow','Guidance','rhand','true',1580,1,1,'wood','s80',401,10,'crossbow',10,-1.00000,0,0,0,303,0,151,-1,-1,74946000,3597,'true','true','true','true','true',0,0,0,0,0,0,0,0,9864,'3573-1;'),
(9387,'Dynasty Crossbow','Focus','rhand','true',1580,1,1,'wood','s80',401,10,'crossbow',10,-1.00000,0,0,0,303,0,151,-1,-1,74946000,3597,'true','true','true','true','true',0,0,0,0,0,0,0,0,9865,'3567-2;'),
(9388,'Infinity Rapier','','rhand','false',1280,1,1,'wood','s',344,40,'rapier',10,-1.00000,0,0,0,406,0,169,-1,-1,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'3426-1;3427-1;'),
(9389,'Infinity Sword','','lrhand','false',1800,1,1,'wood','s',410,15,'ancient',8,2.00000,0,0,0,350,0,169,-1,-1,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'3634-1;'),
(9390,'Infinity Shooter','','rhand','false',1580,1,1,'wood','s',405,10,'crossbow',10,-1.00000,0,0,0,303,0,169,-1,-1,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'3635-1;'),
(9441,'Dynasty Shield','','lhand','true',1150,0,0,'wood','s80',0,0,'none',0,0.00000,-8,321,20,0,0,0,-1,-1,6404000,307,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(9442,'Dynasty Sword','','rhand','true',1520,1,1,'wood','s80',333,10,'sword',8,0.00000,0,0,0,379,0,151,-1,-1,74946000,3597,'true','true','true','true','true',0,0,0,0,0,0,0,0,9376,'0-0;'),
(9443,'Dynasty Blade','','lrhand','true',1740,1,1,'wood','s80',405,10,'bigsword',8,0.00000,0,0,0,325,0,151,-1,-1,74946000,3597,'true','true','true','true','true',0,0,0,0,0,0,0,0,9380,'0-0;'),
(9444,'Dynasty Phantom','','rhand','true',1520,1,1,'wood','s80',267,10,'sword',8,0.00000,0,0,0,379,0,202,-1,-1,74946000,3597,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(9445,'Dynasty Bow','','lrhand','true',1520,1,1,'wood','s80',654,5,'bow',12,-3.00000,0,0,0,293,11,151,-1,-1,74946000,3597,'true','true','true','true','true',0,0,0,0,0,0,0,0,9384,'0-0;'),
(9446,'Dynasty Knife','','rhand','true',1520,1,1,'wood','s80',291,5,'dagger',12,-3.00000,0,0,0,433,0,151,-1,-1,74946000,3597,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(9447,'Dynasty Halberd','','lrhand','true',2010,1,1,'wood','s80',333,10,'pole',8,-3.00000,0,0,0,325,0,151,-1,-1,74946000,3597,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3599-1;'),
(9448,'Dynasty Cudgel','','rhand','true',1740,1,1,'wood','s80',333,20,'blunt',4,4.00000,0,0,0,379,0,151,-1,-1,74946000,3597,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(9449,'Dynasty Mace','','rhand','true',1080,1,1,'wood','s80',267,20,'blunt',4,4.00000,0,0,0,379,0,202,-1,-1,74946000,3597,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(9450,'Dynasty Bagh-Nakh','','lrhand','true',1550,1,1,'wood','s80',405,5,'dualfist',4,4.00000,0,0,0,325,0,151,-1,-1,74946000,3597,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(9529,'Sealed Dynasty Shield','','lhand','true',1150,0,0,'wood','s80',0,0,'none',0,0.00000,-8,305,20,0,0,0,-1,-1,6404000,307,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(9638,'Tears r1','','lrhand','true',300,2,2,'wood','d',5,5,'dual',12,-3.00000,0,0,0,433,0,5,-1,-1,0,743,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(9639,'Tears r2','','lrhand','true',300,2,2,'wood','d',5,5,'dual',12,-3.00000,0,0,0,433,0,5,-1,-1,0,743,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(9640,'Tears r3','','lrhand','true',300,2,2,'wood','d',5,5,'dual',12,-3.00000,0,0,0,433,0,5,-1,-1,0,743,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(9641,'Tears l1','','rhand','true',300,2,2,'wood','d',5,5,'dagger',12,-3.00000,0,0,0,433,0,5,-1,-1,0,743,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(9642,'Tears l2','','rhand','true',300,2,2,'wood','d',5,5,'dagger',12,-3.00000,0,0,0,433,0,5,-1,-1,0,743,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(9643,'Tears l3','','rhand','true',300,2,2,'wood','d',5,5,'dagger',12,-3.00000,0,0,0,433,0,5,-1,-1,0,743,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(9644,'npc Only (Crossbow)','','rhand','true',1530,2,2,'wood','none',31,10,'crossbow',8,0.00000,0,0,0,379,0,21,-1,-1,0,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(9645,'npc Only (Sword)','','lrhand','true',1530,2,2,'wood','none',31,10,'ancient',8,0.00000,0,0,0,379,0,21,-1,-1,0,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(9646,'npc Only (Rapier)','','rhand','true',1530,2,2,'wood','none',31,10,'rapier',8,0.00000,0,0,0,379,0,21,-1,-1,0,0,'true','true','true','true','true',3426,1,0,0,0,0,0,0,0,'0-0;'),
(9656,'Enchanted Wolf Fang','','greatwolf','false',100,0,0,'steel','none',233,10,'pet',8,0.00000,0,0,0,277,0,5,-1,-1,3676000,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(9657,'Enchanted Coyote Fang','','greatwolf','false',100,0,0,'steel','none',289,10,'pet',8,0.00000,0,0,0,277,0,5,-1,-1,6809000,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(9658,'Enchanted Saltydog Fang','','greatwolf','false',100,0,0,'steel','none',350,10,'pet',8,0.00000,0,0,0,277,0,5,-1,-1,12758000,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(9659,'Enchanted Cerberus Fang','','greatwolf','false',100,0,0,'steel','none',413,10,'pet',8,0.00000,0,0,0,277,0,5,-1,-1,21159000,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(9660,'Orichalcum Fang','','greatwolf','false',100,0,0,'steel','none',477,10,'pet',8,0.00000,0,0,0,277,0,5,-1,-1,37752000,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(9661,'Enchanted Fenril Fang','','greatwolf','false',100,0,0,'steel','none',537,10,'pet',8,0.00000,0,0,0,277,0,5,-1,-1,68638000,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(9720,'Warrior\'s Sword','','rhand','false',1300,1,1,'wood','none',12,40,'rapier',10,-1.00000,0,0,0,406,0,10,-1,-1,25500,0,'true','true','true','true','true',3426,1,0,0,0,0,0,0,0,'0-0;'),
(9813,'Orc Officer','','lrhand','true',2150,1,1,'wood','b',213,10,'dual',8,0.00000,0,0,0,325,0,91,-1,-1,0,1157,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(9819,'Combat flag','','lrhand','false',500,1,1,'wood','none',0,0,'none',0,0.00000,0,0,0,325,0,0,-1,-1,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'3318-1;3358-1;'),
(9840,'Shadow Item: Chevalier Rapier','','rhand','false',473,2,2,'wood','c',111,40,'rapier',10,-1.00000,0,0,0,406,0,68,300,-1,0,0,'false','false','true','false','true',3426,1,0,0,0,0,0,0,0,'0-0;'),
(9841,'Shadow Item: Riter Schlager','','lrhand','false',667,2,2,'wood','c',132,15,'ancient',8,2.00000,0,0,0,350,0,68,300,-1,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(9842,'Shadow Item: Ballista','','rhand','true',590,5,2,'wood','c',155,10,'crossbow',10,-1.00000,0,0,0,303,0,68,300,-1,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(9843,'Shadow Item: Blinzlasher','','rhand','false',467,3,3,'wood','c',126,40,'rapier',10,-1.00000,0,0,0,406,0,76,300,-1,0,0,'false','false','true','false','true',3426,1,0,0,0,0,0,0,0,'0-0;'),
(9844,'Shadow Item: Immortal Edge','','lrhand','true',660,3,3,'wood','c',151,15,'ancient',8,2.00000,0,0,0,350,0,76,300,-1,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(9845,'Shadow Item: Tathlum','','rhand','true',587,5,3,'wood','c',176,10,'crossbow',10,-1.00000,0,0,0,303,0,76,300,-1,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(9846,'Shadow Item: Military Fleuret','','rhand','false',457,1,1,'wood','b',159,40,'rapier',10,-1.00000,0,0,0,406,0,91,300,-1,0,0,'false','false','true','false','true',3426,1,0,0,0,0,0,0,0,'0-0;'),
(9847,'Shadow Item: Innominate Victory','','lrhand','false',643,1,1,'wood','b',190,15,'ancient',8,2.00000,0,0,0,350,0,91,300,-1,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(9848,'Shadow Item: Peacemaker','','rhand','true',573,2,1,'wood','b',221,10,'crossbow',10,-1.00000,0,0,0,303,0,91,300,-1,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(9854,'Dynasty Sword','Focus','rhand','true',1520,1,1,'wood','s80',333,10,'sword',8,0.00000,0,0,0,379,0,151,-1,-1,74946000,3597,'true','true','true','true','true',0,0,0,0,0,0,0,0,9377,'3566-2;'),
(9855,'Dynasty Sword','Health','rhand','true',1520,1,1,'wood','s80',333,10,'sword',8,0.00000,0,0,0,379,0,151,-1,-1,74946000,3597,'true','true','true','true','true',0,0,0,0,0,0,0,0,9378,'3013-5;'),
(9856,'Dynasty Sword','Light','rhand','true',1520,1,1,'wood','s80',333,10,'sword',8,0.00000,0,0,0,379,0,151,-1,-1,74946000,3597,'true','true','true','true','true',0,0,0,0,0,0,0,0,9379,'3498-1;'),
(9857,'Dynasty Blade','Focus','lrhand','true',1740,1,1,'wood','s80',405,10,'bigsword',8,0.00000,0,0,0,325,0,151,-1,-1,74946000,3597,'true','true','true','true','true',0,0,0,0,0,0,0,0,9381,'3566-2;'),
(9858,'Dynasty Blade','Health','lrhand','true',1740,1,1,'wood','s80',405,10,'bigsword',8,0.00000,0,0,0,325,0,151,-1,-1,74946000,3597,'true','true','true','true','true',0,0,0,0,0,0,0,0,9382,'3013-5;'),
(9859,'Dynasty Blade','Light','lrhand','true',1740,1,1,'wood','s80',405,10,'bigsword',8,0.00000,0,0,0,325,0,151,-1,-1,74946000,3597,'true','true','true','true','true',0,0,0,0,0,0,0,0,9383,'3498-1;'),
(9860,'Dynasty Phantom','Acumen','rhand','true',1520,1,1,'wood','s80',267,10,'sword',8,0.00000,0,0,0,379,0,202,-1,-1,74946000,3597,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3047-3;'),
(9861,'Dynasty Phantom','Mana Up','rhand','true',1520,1,1,'wood','s80',267,10,'sword',8,0.00000,0,0,0,379,0,202,-1,-1,74946000,3597,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3014-3;'),
(9862,'Dynasty Phantom','Conversion','rhand','true',1520,1,1,'wood','s80',267,10,'sword',8,0.00000,0,0,0,379,0,202,-1,-1,74946000,3597,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3048-3;'),
(9863,'Dynasty Bow','Cheap Shot','lrhand','true',1520,1,1,'wood','s80',654,5,'bow',12,-3.00000,0,0,0,293,11,151,-1,-1,74946000,3597,'true','true','true','true','true',0,0,0,0,0,0,0,0,9385,'3552-1;'),
(9864,'Dynasty Bow','Guidance','lrhand','true',1520,1,1,'wood','s80',654,5,'bow',12,-3.00000,0,0,0,293,11,151,-1,-1,74946000,3597,'true','true','true','true','true',0,0,0,0,0,0,0,0,9386,'3573-1;'),
(9865,'Dynasty Bow','Focus','lrhand','true',1520,1,1,'wood','s80',654,5,'bow',12,-3.00000,0,0,0,293,11,151,-1,-1,74946000,3597,'true','true','true','true','true',0,0,0,0,0,0,0,0,9387,'3567-2;'),
(9866,'Dynasty Knife','Focus','rhand','true',1520,1,1,'wood','s80',291,5,'dagger',12,-3.00000,0,0,0,433,0,151,-1,-1,74946000,3597,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3567-2;'),
(9867,'Dynasty Knife','Evasion','rhand','true',1520,1,1,'wood','s80',291,5,'dagger',12,-3.00000,0,0,0,433,0,151,-1,-1,74946000,3597,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3009-7;'),
(9868,'Dynasty Knife','Critical Damage','rhand','true',1520,1,1,'wood','s80',291,5,'dagger',12,-3.00000,0,0,0,433,0,151,-1,-1,74946000,3597,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3066-4;'),
(9869,'Dynasty Halberd','Anger','lrhand','true',2010,1,1,'wood','s80',333,10,'pole',8,-3.00000,0,0,0,325,0,151,-1,-1,74946000,3597,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3600-10;'),
(9870,'Dynasty Halberd','Critical Stun','lrhand','true',2010,1,1,'wood','s80',333,10,'pole',8,-3.00000,0,0,0,325,0,151,-1,-1,74946000,3597,'true','true','true','true','true',0,0,0,0,0,3070,3,48,0,'3552-2;'),
(9871,'Dynasty Halberd','Light','lrhand','true',2010,1,1,'wood','s80',333,10,'pole',8,-3.00000,0,0,0,325,0,151,-1,-1,74946000,3597,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3599-1;3498-1;'),
(9872,'Dynasty Cudgel','Anger','rhand','true',1740,1,1,'wood','s80',333,20,'blunt',4,4.00000,0,0,0,379,0,151,-1,-1,74946000,3597,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3057-3;'),
(9873,'Dynasty Cudgel','Health','rhand','true',1740,1,1,'wood','s80',333,20,'blunt',4,4.00000,0,0,0,379,0,151,-1,-1,74946000,3597,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3013-5;'),
(9874,'Dynasty Cudgel','Rsk. Focus','rhand','true',1740,1,1,'wood','s80',333,20,'blunt',4,4.00000,0,0,0,379,0,151,-1,-1,74946000,3597,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3027-7;'),
(9875,'Dynasty Mace','Mana Up','rhand','true',1080,1,1,'wood','s80',267,20,'blunt',4,4.00000,0,0,0,379,0,202,-1,-1,74946000,3597,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3014-3;'),
(9876,'Dynasty Mace','Conversion','rhand','true',1080,1,1,'wood','s80',267,20,'blunt',4,4.00000,0,0,0,379,0,202,-1,-1,74946000,3597,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3048-3;'),
(9877,'Dynasty Mace','Acumen','rhand','true',1080,1,1,'wood','s80',267,20,'blunt',4,4.00000,0,0,0,379,0,202,-1,-1,74946000,3597,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3047-3;'),
(9878,'Dynasty Bagh-Nakh','Rsk. Evasion','lrhand','true',1550,1,1,'wood','s80',405,5,'dualfist',4,4.00000,0,0,0,325,0,151,-1,-1,74946000,3597,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3069-1;'),
(9879,'Dynasty Bagh-Nakh','Focus','lrhand','true',1550,1,1,'wood','s80',405,5,'dualfist',4,4.00000,0,0,0,325,0,151,-1,-1,74946000,3597,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3565-2;'),
(9880,'Dynasty Bagh-Nakh','Haste','lrhand','true',1550,1,1,'wood','s80',405,5,'dualfist',4,4.00000,0,0,0,325,0,151,-1,-1,74946000,3597,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3068-3;'),
(9901,'Improved Falchion','','rhand','false',1530,2,2,'wood','none',31,10,'sword',8,0.00000,0,0,0,379,0,21,-1,-1,0,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(9902,'Improved Great Spear','','lrhand','false',2120,2,2,'wood','none',31,10,'pole',8,-3.00000,0,0,0,325,0,21,-1,-1,0,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3599-1;'),
(9903,'Improved Iron Hammer','','rhand','false',1850,2,2,'wood','none',31,20,'blunt',4,4.00000,0,0,0,379,0,21,-1,-1,0,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(9904,'Improved Sword Breaker','','rhand','false',1110,2,2,'wood','none',27,5,'dagger',12,-3.00000,0,0,0,433,0,21,-1,-1,0,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(9905,'Improved Viper Fang','','lrhand','false',1560,2,2,'wood','none',38,5,'dualfist',4,4.00000,0,0,0,325,0,21,-1,-1,0,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(9906,'Improved Composite Bow','','lrhand','false',1880,7,2,'wood','none',64,5,'bow',12,-3.00000,0,0,0,293,3,21,-1,-1,0,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(9907,'Improved Flanged Mace','','rhand','false',1800,2,2,'wood','none',31,20,'blunt',4,4.00000,0,0,0,379,0,21,-1,-1,0,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(9908,'Improved Mage Staff','','lrhand','false',1050,2,2,'wood','none',30,20,'bigblunt',4,4.00000,0,0,0,325,0,31,-1,-1,0,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(9995,'Hand Crossbow','','rhand','true',1850,4,2,'wood','d',64,10,'crossbow',10,-1.00000,0,0,0,303,0,32,-1,-1,495500,915,'true','true','true','true','true',0,0,0,0,0,0,0,0,276,'0-0;'),
(9996,'Hand Crossbow','','rhand','true',1850,4,2,'wood','d',64,10,'crossbow',10,-1.00000,0,0,0,303,0,32,-1,-1,495500,915,'true','true','true','true','true',0,0,0,0,0,0,0,0,277,'0-0;'),
(10003,'Fleuret','','rhand','true',1500,2,2,'wood','d',46,40,'rapier',10,-1.00000,0,0,0,406,0,32,-1,-1,495500,915,'true','true','true','true','true',3426,1,0,0,0,0,0,0,128,'0-0;'),
(10004,'Dynasty Dual Sword','','lrhand','true',1520,1,1,'wood','s80',405,10,'dual',8,0.00000,0,0,0,325,0,151,-1,-1,74946000,3597,'true','true','true','true','true',3411,1,0,0,0,0,0,0,0,'0-0;'),
(10005,'Shadow Item: Fleuret','','rhand','false',500,2,2,'wood','d',46,40,'rapier',10,-1.00000,0,0,0,406,0,32,90,-1,0,0,'false','false','true','false','true',3426,1,0,0,0,0,0,0,0,'0-0;'),
(10006,'Shadow Item: Military Talwar','','lrhand','false',693,2,2,'wood','d',55,15,'ancient',8,2.00000,0,0,0,350,0,32,90,-1,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(10007,'Shadow Item: Hand Crossbow','','rhand','false',693,4,2,'wood','d',64,10,'crossbow',10,-1.00000,0,0,0,303,0,32,90,-1,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(10008,'Shadow Item: Blinzlasher','','rhand','false',467,3,3,'wood','c',126,40,'rapier',10,-1.00000,0,0,0,406,0,76,120,-1,0,0,'false','false','true','false','true',3426,1,0,0,0,0,0,0,0,'0-0;'),
(10009,'Shadow Item: Immortal Edge','','lrhand','false',660,3,3,'wood','c',151,15,'ancient',8,2.00000,0,0,0,350,0,76,120,-1,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(10010,'Shadow Item: Tathlum','','rhand','false',587,5,3,'wood','c',176,10,'crossbow',10,-1.00000,0,0,0,303,0,76,120,-1,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(10011,'Shadow Item - War Axe','','rhand','false',533,3,3,'wood','c',139,20,'blunt',4,4.00000,0,0,0,379,0,76,120,-1,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(10125,'Shadow Item - War Axe','','rhand','false',533,3,3,'wood','c',139,20,'blunt',4,4.00000,0,0,0,379,0,76,300,-1,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(10128,'For Monster only (Crossbow)','','rhand','true',1530,2,2,'wood','none',31,10,'crossbow',8,0.00000,0,0,0,379,0,21,-1,-1,0,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(10167,'Pig Lollipop','','rhand','false',0,0,0,'steel','none',1,10,'sword',8,0.00000,0,0,0,379,0,1,-1,-1,0,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3418-1;'),
(10212,'npc Only (Bow)','','lrhand','true',1530,2,2,'steel','none',31,10,'bow',8,0.00000,0,0,0,379,0,21,-1,-1,0,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(10215,'Icarus Sawsword','','rhand','true',1520,1,1,'steel','s80',363,10,'sword',8,0.00000,0,0,0,379,0,163,-1,-1,103439000,4965,'true','true','true','true','true',0,0,0,0,0,0,0,0,10224,'0-0;'),
(10216,'Icarus Disperser','','rhand','true',1520,1,1,'steel','s80',318,5,'dagger',12,-3.00000,0,0,0,433,0,163,-1,-1,103439000,4965,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(10217,'Icarus Spirit','','rhand','true',1520,1,1,'steel','s80',290,10,'sword',8,0.00000,0,0,0,379,0,217,-1,-1,103439000,4965,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(10218,'Icarus Heavy Arms','','lrhand','true',1740,1,1,'steel','s80',442,10,'bigsword',8,0.00000,0,0,0,325,0,163,-1,-1,103439000,4965,'true','true','true','true','true',0,0,0,0,0,0,0,0,10225,'0-0;'),
(10219,'Icarus Trident','','lrhand','true',2010,1,1,'bronze','s80',363,10,'pole',8,-3.00000,0,0,0,325,0,163,-1,-1,103439000,4965,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3599-1;'),
(10220,'Icarus Hammer','','rhand','true',1740,1,1,'fine_steel','s80',363,20,'blunt',4,4.00000,0,0,0,379,0,163,-1,-1,103439000,4965,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(10221,'Icarus Hand','','lrhand','true',1550,1,1,'steel','s80',442,5,'dualfist',4,4.00000,0,0,0,325,0,163,-1,-1,103439000,4965,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(10222,'Icarus Hall','','rhand','true',1080,1,1,'wood','s80',290,20,'blunt',4,4.00000,0,0,0,379,0,217,-1,-1,103439000,4965,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(10223,'Icarus Spitter','','lrhand','true',1520,1,1,'steel','s80',689,5,'bow',12,-3.00000,0,0,0,293,11,163,-1,-1,103439000,4965,'true','true','true','true','true',0,0,0,0,0,0,0,0,10226,'0-0;'),
(10224,'Icarus Stinger','','rhand','true',1280,1,1,'steel','s80',329,40,'rapier',10,-1.00000,0,0,0,406,0,163,-1,-1,103439000,4965,'true','true','true','true','true',3426,1,0,0,0,0,0,0,10215,'0-0;'),
(10225,'Icarus Wingblade','','lrhand','true',1800,1,1,'steel','s80',393,15,'ancient',8,2.00000,0,0,0,350,0,163,-1,-1,103439000,4965,'true','true','true','true','true',0,0,0,0,0,0,0,0,10218,'0-0;'),
(10226,'Icarus Shooter','','rhand','true',1580,1,1,'steel','s80',422,10,'crossbow',10,-1.00000,0,0,0,303,0,163,-1,-1,103439000,4965,'true','true','true','true','true',0,0,0,0,0,0,0,0,10223,'0-0;'),
(10252,'Dynasty Staff','','lrhand','true',1080,1,1,'wood','s80',325,20,'bigblunt',4,4.00000,0,0,0,325,0,222,-1,-1,74946000,3597,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(10253,'Dynasty Crusher','','lrhand','true',1740,1,1,'fine_steel','s80',405,20,'bigblunt',4,4.00000,0,0,0,325,0,151,-1,-1,74946000,3597,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(10277,'Monster Only (Behamah Pole)','','lrhand','false',2140,2,2,'steel','none',24,10,'pole',8,-3.00000,0,0,0,325,0,17,-1,-1,0,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(10278,'Monster Only (Behamah Dual)','','lrhand','true',2530,2,2,'fine_steel','d',73,10,'dual',8,0.00000,0,0,0,325,0,37,-1,-1,0,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(10415,'Icarus Dual Sword','','lrhand','true',1520,1,1,'steel','s80',442,10,'dual',8,0.00000,0,0,0,325,0,163,-1,-1,103439000,4965,'true','true','true','true','true',3411,1,0,0,0,0,0,0,0,'0-0;'),
(10434,'Icarus Sawsword','Focus','rhand','true',1520,1,1,'steel','s80',363,10,'sword',8,0.00000,0,0,0,379,0,163,-1,-1,103439000,4965,'true','true','true','true','true',0,0,0,0,0,0,0,0,10461,'3566-2;'),
(10435,'Icarus Sawsword','Health','rhand','true',1520,1,1,'steel','s80',363,10,'sword',8,0.00000,0,0,0,379,0,163,-1,-1,103439000,4965,'true','true','true','true','true',0,0,0,0,0,0,0,0,10462,'3013-5;'),
(10436,'Icarus Sawsword','Light','rhand','true',1520,1,1,'steel','s80',363,10,'sword',8,0.00000,0,0,0,379,0,163,-1,-1,103439000,4965,'true','true','true','true','true',0,0,0,0,0,0,0,0,10463,'3498-1;'),
(10437,'Icarus Heavy Arms','Focus','lrhand','true',1740,1,1,'steel','s80',442,10,'bigsword',8,0.00000,0,0,0,325,0,163,-1,-1,103439000,4965,'true','true','true','true','true',0,0,0,0,0,0,0,0,10464,'3566-2;'),
(10438,'Icarus Heavy Arms','Health','lrhand','true',1740,1,1,'steel','s80',442,10,'bigsword',8,0.00000,0,0,0,325,0,163,-1,-1,103439000,4965,'true','true','true','true','true',0,0,0,0,0,0,0,0,10465,'3013-5;'),
(10439,'Icarus Heavy Arms','Light','lrhand','true',1740,1,1,'steel','s80',442,10,'bigsword',8,0.00000,0,0,0,325,0,163,-1,-1,103439000,4965,'true','true','true','true','true',0,0,0,0,0,0,0,0,10466,'3498-1;'),
(10440,'Icarus Spirit','Acumen','rhand','true',1520,1,1,'steel','s80',290,10,'sword',8,0.00000,0,0,0,379,0,217,-1,-1,103439000,4965,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3047-3;'),
(10441,'Icarus Spirit','Mana Up','rhand','true',1520,1,1,'steel','s80',290,10,'sword',8,0.00000,0,0,0,379,0,217,-1,-1,103439000,4965,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3014-3;'),
(10442,'Icarus Spirit','Conversion','rhand','true',1520,1,1,'steel','s80',290,10,'sword',8,0.00000,0,0,0,379,0,217,-1,-1,103439000,4965,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3048-3;'),
(10443,'Icarus Spitter','Cheap Shot','lrhand','true',1520,1,1,'steel','s80',689,5,'bow',12,-3.00000,0,0,0,293,11,163,-1,-1,103439000,4965,'true','true','true','true','true',0,0,0,0,0,0,0,0,10467,'3552-1;'),
(10444,'Icarus Spitter','Guidance','lrhand','true',1520,1,1,'steel','s80',689,5,'bow',12,-3.00000,0,0,0,293,11,163,-1,-1,103439000,4965,'true','true','true','true','true',0,0,0,0,0,0,0,0,10468,'3573-1;'),
(10445,'Icarus Spitter','Focus','lrhand','true',1520,1,1,'steel','s80',689,5,'bow',12,-3.00000,0,0,0,293,11,163,-1,-1,103439000,4965,'true','true','true','true','true',0,0,0,0,0,0,0,0,10469,'3567-2;'),
(10446,'Icarus Disperser','Focus','rhand','true',1520,1,1,'steel','s80',318,5,'dagger',12,-3.00000,0,0,0,433,0,163,-1,-1,103439000,4965,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3567-2;'),
(10447,'Icarus Disperser','Evasion','rhand','true',1520,1,1,'steel','s80',318,5,'dagger',12,-3.00000,0,0,0,433,0,163,-1,-1,103439000,4965,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3009-8;'),
(10448,'Icarus Disperser','Critical Damage','rhand','true',1520,1,1,'steel','s80',318,5,'dagger',12,-3.00000,0,0,0,433,0,163,-1,-1,103439000,4965,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3066-4;'),
(10449,'Icarus Trident','Anger','lrhand','true',2010,1,1,'bronze','s80',363,10,'pole',8,-3.00000,0,0,0,325,0,163,-1,-1,103439000,4965,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3600-10;'),
(10450,'Icarus Trident','Critical Stun','lrhand','true',2010,1,1,'bronze','s80',363,10,'pole',8,-3.00000,0,0,0,325,0,163,-1,-1,103439000,4965,'true','true','true','true','true',0,0,0,0,0,3070,3,48,0,'3552-2;'),
(10451,'Icarus Trident','Light','lrhand','true',2010,1,1,'bronze','s80',363,10,'pole',8,-3.00000,0,0,0,325,0,163,-1,-1,103439000,4965,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3599-1;3498-1;'),
(10452,'Icarus Hammer','Anger','rhand','true',1740,1,1,'fine_steel','s80',363,20,'blunt',4,4.00000,0,0,0,379,0,163,-1,-1,103439000,4965,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3057-3;'),
(10453,'Icarus Hammer','Health','rhand','true',1740,1,1,'fine_steel','s80',363,20,'blunt',4,4.00000,0,0,0,379,0,163,-1,-1,103439000,4965,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3013-5;'),
(10454,'Icarus Hammer','Rsk. Focus','rhand','true',1740,1,1,'fine_steel','s80',363,20,'blunt',4,4.00000,0,0,0,379,0,163,-1,-1,103439000,4965,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3027-7;'),
(10455,'Icarus Hall','Mana Up','rhand','true',1080,1,1,'wood','s80',290,20,'blunt',4,4.00000,0,0,0,379,0,217,-1,-1,103439000,4965,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3014-3;'),
(10456,'Icarus Hall','Conversion','rhand','true',1080,1,1,'wood','s80',290,20,'blunt',4,4.00000,0,0,0,379,0,217,-1,-1,103439000,4965,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3048-3;'),
(10457,'Icarus Hall','Acumen','rhand','true',1080,1,1,'wood','s80',290,20,'blunt',4,4.00000,0,0,0,379,0,217,-1,-1,103439000,4965,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3047-3;'),
(10458,'Icarus Hand','Rsk. Evasion','lrhand','true',1550,1,1,'steel','s80',442,5,'dualfist',4,4.00000,0,0,0,325,0,163,-1,-1,103439000,4965,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3069-1;'),
(10459,'Icarus Hand','Focus','lrhand','true',1550,1,1,'steel','s80',442,5,'dualfist',4,4.00000,0,0,0,325,0,163,-1,-1,103439000,4965,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3565-2;'),
(10460,'Icarus Hand','Haste','lrhand','true',1550,1,1,'steel','s80',442,5,'dualfist',4,4.00000,0,0,0,325,0,163,-1,-1,103439000,4965,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3068-3;'),
(10461,'Icarus Stinger','Focus','rhand','true',1280,1,1,'steel','s80',329,40,'rapier',10,-1.00000,0,0,0,406,0,163,-1,-1,103439000,4965,'true','true','true','true','true',3426,1,0,0,0,0,0,0,10434,'3566-2;'),
(10462,'Icarus Stinger','Health','rhand','true',1280,1,1,'steel','s80',329,40,'rapier',10,-1.00000,0,0,0,406,0,163,-1,-1,103439000,4965,'true','true','true','true','true',3426,1,0,0,0,0,0,0,10435,'3013-5;'),
(10463,'Icarus Stinger','Light','rhand','true',1280,1,1,'steel','s80',329,40,'rapier',10,-1.00000,0,0,0,406,0,163,-1,-1,103439000,4965,'true','true','true','true','true',3426,1,0,0,0,0,0,0,10436,'3498-1;'),
(10464,'Icarus Wingblade','Focus','lrhand','true',1800,1,1,'steel','s80',393,15,'ancient',8,2.00000,0,0,0,350,0,163,-1,-1,103439000,4965,'true','true','true','true','true',0,0,0,0,0,0,0,0,10437,'3566-2;'),
(10465,'Icarus Wingblade','Health','lrhand','true',1800,1,1,'steel','s80',393,15,'ancient',8,2.00000,0,0,0,350,0,163,-1,-1,103439000,4965,'true','true','true','true','true',0,0,0,0,0,0,0,0,10438,'3013-5;'),
(10466,'Icarus Wingblade','Light','lrhand','true',1800,1,1,'steel','s80',393,15,'ancient',8,2.00000,0,0,0,350,0,163,-1,-1,103439000,4965,'true','true','true','true','true',0,0,0,0,0,0,0,0,10439,'3498-1;'),
(10467,'Icarus Shooter','Cheap Shot','rhand','true',1580,1,1,'steel','s80',422,10,'crossbow',10,-1.00000,0,0,0,303,0,163,-1,-1,103439000,4965,'true','true','true','true','true',0,0,0,0,0,0,0,0,10443,'3552-1;'),
(10468,'Icarus Shooter','Guidance','rhand','true',1580,1,1,'steel','s80',422,10,'crossbow',10,-1.00000,0,0,0,303,0,163,-1,-1,103439000,4965,'true','true','true','true','true',0,0,0,0,0,0,0,0,10444,'3573-1;'),
(10469,'Icarus Shooter','Focus','rhand','true',1580,1,1,'steel','s80',422,10,'crossbow',10,-1.00000,0,0,0,303,0,163,-1,-1,103439000,4965,'true','true','true','true','true',0,0,0,0,0,0,0,0,10445,'3567-2;'),
(10474,'Shadow Item - Apprentice\'s Staff','','lrhand','false',1070,2,2,'wood','none',23,20,'bigblunt',4,4.00000,0,0,0,325,0,24,180,-1,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(10475,'Shadow Item - Bone Club','','rhand','false',1850,2,2,'bone','none',24,20,'blunt',4,4.00000,0,0,0,379,0,17,180,-1,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(10476,'Shadow Item - Shining Knife','','rhand','false',1120,2,2,'mithril','none',21,5,'dagger',12,-3.00000,0,0,0,433,0,17,180,-1,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(10477,'Shadow Item - Cestus','','lrhand','false',1570,2,2,'steel','none',29,5,'dualfist',4,4.00000,0,0,0,325,0,17,180,-1,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(10478,'Shadow Item - Forest Bow','','lrhand','false',1900,7,2,'wood','none',49,5,'bow',12,-3.00000,0,0,0,293,3,17,180,-1,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(10479,'Shadow Item - Long Sword','','rhand','false',1560,2,2,'fine_steel','none',24,10,'sword',8,0.00000,0,0,0,379,0,17,180,-1,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(10527,'Dynasty Staff','Mana Up','lrhand','true',1080,1,1,'wood','s80',325,20,'bigblunt',4,4.00000,0,0,0,325,0,222,-1,-1,74946000,3597,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3014-3;'),
(10528,'Dynasty Staff','Conversion','lrhand','true',1080,1,1,'wood','s80',325,20,'bigblunt',4,4.00000,0,0,0,325,0,222,-1,-1,74946000,3597,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3048-3;'),
(10529,'Dynasty Staff','Acumen','lrhand','true',1080,1,1,'wood','s80',325,20,'bigblunt',4,4.00000,0,0,0,325,0,222,-1,-1,74946000,3597,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3047-3;'),
(10530,'Dynasty Crusher','Anger','lrhand','true',1740,1,1,'fine_steel','s80',405,20,'bigblunt',4,4.00000,0,0,0,325,0,151,-1,-1,74946000,3597,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3057-3;'),
(10531,'Dynasty Crusher','Health','lrhand','true',1740,1,1,'fine_steel','s80',405,20,'bigblunt',4,4.00000,0,0,0,325,0,151,-1,-1,74946000,3597,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3013-5;'),
(10532,'Dynasty Crusher','Rsk. Focus','lrhand','true',1740,1,1,'fine_steel','s80',405,20,'bigblunt',4,4.00000,0,0,0,325,0,151,-1,-1,74946000,3597,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3027-7;'),
(10548,'Monster Only (Transparent Shield)','','lhand','false',1430,0,0,'steel','none',0,0,'none',0,0.00000,-8,47,20,0,0,0,-1,-1,39,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;');

INSERT INTO `weapon` VALUES
(10667,'Sirra\'s Blade {PvP}','Haste','rhand','true',1300,1,1,'fine_steel','a',251,10,'sword',8,0.00000,0,0,0,379,0,121,-1,-1,26968400,2157,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3068-2;3650-1;'),
(10668,'Sirra\'s Blade {PvP}','Health','rhand','true',1300,1,1,'fine_steel','a',251,10,'sword',8,0.00000,0,0,0,379,0,121,-1,-1,26968400,2157,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3013-3;3650-1;'),
(10669,'Sirra\'s Blade {PvP}','Critical Poison','rhand','true',1300,1,1,'fine_steel','a',251,10,'sword',8,0.00000,0,0,0,379,0,121,-1,-1,26968400,2157,'false','false','true','false','true',0,0,0,0,0,3061,3,15,0,'3552-1;3650-1;'),
(10670,'Sword of Ipos {PvP}','Focus','lrhand','true',1820,1,1,'fine_steel','a',305,10,'bigsword',8,0.00000,0,0,0,325,0,121,-1,-1,26968400,2157,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3050-2;3653-1;'),
(10671,'Sword of Ipos {PvP}','Haste','lrhand','true',1820,1,1,'fine_steel','a',305,10,'bigsword',8,0.00000,0,0,0,325,0,121,-1,-1,26968400,2157,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3068-2;3653-1;'),
(10672,'Sword of Ipos {PvP}','Health','lrhand','true',1820,1,1,'fine_steel','a',305,10,'bigsword',8,0.00000,0,0,0,325,0,121,-1,-1,26968400,2157,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3013-3;3653-1;'),
(10673,'Barakiel\'s Axe {PvP}','Health','rhand','true',1550,1,1,'fine_steel','a',251,20,'blunt',4,4.00000,0,0,0,379,0,121,-1,-1,26968400,2157,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3013-3;3650-1;'),
(10674,'Barakiel\'s Axe {PvP}','Haste','rhand','true',1550,1,1,'fine_steel','a',251,20,'blunt',4,4.00000,0,0,0,379,0,121,-1,-1,26968400,2157,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3068-2;3650-1;'),
(10675,'Barakiel\'s Axe {PvP}','Focus','rhand','true',1550,1,1,'fine_steel','a',251,20,'blunt',4,4.00000,0,0,0,379,0,121,-1,-1,26968400,2157,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3050-2;3650-1;'),
(10676,'Behemoth\'s Tuning Fork {PvP}','Focus','lrhand','true',1890,1,1,'fine_steel','a',305,20,'bigblunt',4,4.00000,0,0,0,325,0,121,-1,-1,26968400,2157,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3050-2;3653-1;'),
(10677,'Behemoth\'s Tuning Fork {PvP}','Health','lrhand','true',1890,1,1,'fine_steel','a',305,20,'bigblunt',4,4.00000,0,0,0,325,0,121,-1,-1,26968400,2157,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3013-3;3653-1;'),
(10678,'Behemoth\'s Tuning Fork {PvP}','Anger','lrhand','true',1890,1,1,'fine_steel','a',305,20,'bigblunt',4,4.00000,0,0,0,325,0,121,-1,-1,26968400,2157,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3057-2;3653-1;'),
(10679,'Naga Storm {PvP}','Focus','rhand','true',930,1,1,'fine_steel','a',220,5,'dagger',12,-3.00000,0,0,0,433,0,121,-1,-1,26968400,2157,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3051-1;3651-1;3652-1;'),
(10680,'Naga Storm {PvP}','Critical Damage','rhand','true',930,1,1,'fine_steel','a',220,5,'dagger',12,-3.00000,0,0,0,433,0,121,-1,-1,26968400,2157,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3066-2;3651-1;3652-1;'),
(10681,'Naga Storm {PvP}','Back Blow','rhand','true',930,1,1,'fine_steel','a',220,5,'dagger',12,-3.00000,0,0,0,433,0,121,-1,-1,26968400,2157,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3019-5;3651-1;3652-1;'),
(10682,'Tiphon\'s Spear {PvP}','Critical Stun','lrhand','true',1820,1,1,'fine_steel','a',251,10,'pole',8,-3.00000,0,0,0,325,0,121,-1,-1,26968400,2157,'false','false','true','false','true',0,0,0,0,0,3070,2,25,0,'3552-2;3653-1;'),
(10683,'Tiphon\'s Spear {PvP}','Long Blow','lrhand','true',1820,1,1,'fine_steel','a',251,10,'pole',8,-3.00000,0,0,0,325,0,121,-1,-1,26968400,2157,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3552-2;3653-1;'),
(10684,'Tiphon\'s Spear {PvP}','Wild Blow','lrhand','true',1820,1,1,'fine_steel','a',251,10,'pole',8,-3.00000,0,0,0,325,0,121,-1,-1,26968400,2157,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3552-2;3653-1;'),
(10685,'Shyeed\'s Bow {PvP}','Cheap Shot','lrhand','true',1640,2,1,'fine_steel','a',571,5,'bow',12,-3.00000,0,0,0,227,10,133,-1,-1,26968400,2157,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3552-1;3655-1;'),
(10686,'Shyeed\'s Bow {PvP}','Focus','lrhand','true',1640,2,1,'fine_steel','a',571,5,'bow',12,-3.00000,0,0,0,227,10,133,-1,-1,26968400,2157,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3050-2;3655-1;'),
(10687,'Shyeed\'s Bow {PvP}','Quick Recovery','lrhand','true',1640,2,1,'fine_steel','a',571,5,'bow',12,-3.00000,0,0,0,227,10,133,-1,-1,26968400,2157,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3552-1;3655-1;'),
(10688,'Sobekk\'s Hurricane {PvP}','Rsk. Haste','lrhand','true',1330,1,1,'fine_steel','a',305,5,'dualfist',4,4.00000,0,0,0,325,0,121,-1,-1,26968400,2157,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3056-2;3651-1;3652-1;'),
(10689,'Sobekk\'s Hurricane {PvP}','Haste','lrhand','true',1330,1,1,'fine_steel','a',305,5,'dualfist',4,4.00000,0,0,0,325,0,121,-1,-1,26968400,2157,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3068-2;3651-1;3652-1;'),
(10690,'Sobekk\'s Hurricane {PvP}','Critical Drain','lrhand','true',1330,1,1,'fine_steel','a',305,5,'dualfist',4,4.00000,0,0,0,325,0,121,-1,-1,26968400,2157,'false','false','true','false','true',0,0,0,0,0,3039,6,33,0,'3552-1;3651-1;3652-1;'),
(10691,'Themis\' Tongue {PvP}','Mana Up','rhand','true',820,1,1,'fine_steel','a',201,10,'sword',8,0.00000,0,0,0,379,0,162,-1,-1,26968400,2157,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3014-2;3654-1;'),
(10692,'Themis\' Tongue {PvP}','Magic Mental Shield','rhand','true',820,1,1,'fine_steel','a',201,10,'sword',8,0.00000,0,0,0,379,0,162,-1,-1,26968400,2157,'false','false','true','false','true',0,0,1035,2,50,0,0,0,0,'3552-1;3654-1;'),
(10693,'Themis\' Tongue {PvP}','Magic Focus','rhand','true',820,1,1,'fine_steel','a',201,10,'sword',8,0.00000,0,0,0,379,0,162,-1,-1,26968400,2157,'false','false','true','false','true',0,0,1077,3,20,0,0,0,0,'3552-1;3654-1;'),
(10694,'Cabrio\'s Hand {PvP}','Conversion','rhand','true',1510,1,1,'fine_steel','a',201,20,'blunt',4,4.00000,0,0,0,379,0,162,-1,-1,26968400,2157,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3048-3;3654-1;'),
(10695,'Cabrio\'s Hand {PvP}','Mana Up','rhand','true',1510,1,1,'fine_steel','a',201,20,'blunt',4,4.00000,0,0,0,379,0,162,-1,-1,26968400,2157,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3014-2;3654-1;'),
(10696,'Cabrio\'s Hand {PvP}','Magic Silence','rhand','true',1510,1,1,'fine_steel','a',201,20,'blunt',4,4.00000,0,0,0,379,0,162,-1,-1,26968400,2157,'false','false','true','false','true',0,0,3074,2,10,0,0,0,0,'3552-1;3654-1;'),
(10697,'Daimon Crystal {PvP}','Mana Up','lrhand','true',880,1,1,'fine_steel','a',245,20,'bigblunt',4,4.00000,0,0,0,325,0,177,-1,-1,26968400,2157,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3014-2;3654-1;'),
(10698,'Daimon Crystal {PvP}','Acumen','lrhand','true',880,1,1,'fine_steel','a',245,20,'bigblunt',4,4.00000,0,0,0,325,0,177,-1,-1,26968400,2157,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3047-3;3654-1;'),
(10699,'Daimon Crystal {PvP}','Magic Mental Shield','lrhand','true',880,1,1,'fine_steel','a',245,20,'bigblunt',4,4.00000,0,0,0,325,0,177,-1,-1,26968400,2157,'false','false','true','false','true',0,0,1035,2,50,0,0,0,0,'3552-1;3654-1;'),
(10700,'Eclair Bijou {PvP}','Haste','rhand','true',1300,1,1,'fine_steel','a',228,40,'rapier',10,-1.00000,0,0,0,406,0,121,-1,-1,26968400,2157,'false','false','true','false','true',3426,1,0,0,0,0,0,0,0,'3068-2;3650-1;'),
(10701,'Eclair Bijou - PvP','Health','rhand','true',1300,1,1,'fine_steel','a',228,40,'rapier',10,-1.00000,0,0,0,406,0,121,-1,-1,26968400,2157,'false','false','true','false','true',3426,1,0,0,0,0,0,0,0,'3013-3;3650-1;'),
(10702,'Eclair Bijou - PvP','Critical Poison','rhand','true',1300,1,1,'fine_steel','a',228,40,'rapier',10,-1.00000,0,0,0,406,0,121,-1,-1,26968400,2157,'false','false','true','false','true',3426,1,0,0,0,3061,3,15,0,'3552-1;3650-1;'),
(10703,'Durendal {PvP}','Focus','lrhand','true',1820,1,1,'fine_steel','a',272,15,'ancient',8,2.00000,0,0,0,350,0,121,-1,-1,26968400,2157,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3050-2;3653-1;'),
(10704,'Durendal {PvP}','Haste','lrhand','true',1820,1,1,'fine_steel','a',272,15,'ancient',8,2.00000,0,0,0,350,0,121,-1,-1,26968400,2157,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3068-2;3653-1;'),
(10705,'Durendal {PvP}','Health','lrhand','true',1820,1,1,'fine_steel','a',272,15,'ancient',8,2.00000,0,0,0,350,0,121,-1,-1,26968400,2157,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3013-3;3653-1;'),
(10706,'Screaming Vengeance {PvP}','Cheap Shot','rhand','true',1640,1,1,'fine_steel','a',318,10,'crossbow',10,-1.00000,0,0,0,303,0,121,-1,-1,26968400,2157,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3552-1;3655-1;'),
(10707,'Screaming Vengeance {PvP}','Focus','rhand','true',1640,1,1,'fine_steel','a',318,10,'crossbow',10,-1.00000,0,0,0,303,0,121,-1,-1,26968400,2157,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3050-2;3655-1;'),
(10708,'Screaming Vengeance {PvP}','Quick Recovery','rhand','true',1640,1,1,'fine_steel','a',318,10,'crossbow',10,-1.00000,0,0,0,303,0,121,-1,-1,26968400,2157,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3552-1;3655-1;'),
(10709,'Tallum Blade*Damascus {PvP}','','lrhand','true',1890,1,1,'fine_steel','a',305,10,'dual',8,0.00000,0,0,0,325,0,121,-1,-1,26968400,2157,'false','false','true','false','true',3045,17,0,0,0,0,0,0,0,'3656-1;'),
(10710,'Forgotten Blade {PvP}','Haste','rhand','true',1300,1,1,'fine_steel','s',281,10,'sword',8,0.00000,0,0,0,379,0,132,-1,-1,42759400,2052,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3564-1;3650-1;'),
(10711,'Forgotten Blade {PvP}','Health','rhand','true',1300,1,1,'fine_steel','s',281,10,'sword',8,0.00000,0,0,0,379,0,132,-1,-1,42759400,2052,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3013-3;3650-1;'),
(10712,'Forgotten Blade {PvP}','Focus','rhand','true',1300,1,1,'fine_steel','s',281,10,'sword',8,0.00000,0,0,0,379,0,132,-1,-1,42759400,2052,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3566-1;3650-1;'),
(10713,'Heavens Divider {PvP}','Haste','lrhand','true',1380,1,1,'fine_steel','s',342,10,'bigsword',8,0.00000,0,0,0,325,0,132,-1,-1,42759400,2052,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3564-1;3653-1;'),
(10714,'Heavens Divider {PvP}','Health','lrhand','true',1380,1,1,'fine_steel','s',342,10,'bigsword',8,0.00000,0,0,0,325,0,132,-1,-1,42759400,2052,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3013-3;3653-1;'),
(10715,'Heavens Divider {PvP}','Focus','lrhand','true',1380,1,1,'fine_steel','s',342,10,'bigsword',8,0.00000,0,0,0,325,0,132,-1,-1,42759400,2052,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3566-1;3653-1;'),
(10716,'Basalt Battlehammer {PvP}','HP Drain','rhand','true',1570,1,1,'fine_steel','s',281,20,'blunt',4,4.00000,0,0,0,379,0,132,-1,-1,42759400,2052,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3568-1;3650-1;'),
(10717,'Basalt Battlehammer {PvP}','Health','rhand','true',1570,1,1,'fine_steel','s',281,20,'blunt',4,4.00000,0,0,0,379,0,132,-1,-1,42759400,2052,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3013-3;3650-1;'),
(10718,'Basalt Battlehammer {PvP}','HP Regeneration','rhand','true',1570,1,1,'fine_steel','s',281,20,'blunt',4,4.00000,0,0,0,379,0,132,-1,-1,42759400,2052,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3569-1;3650-1;'),
(10719,'Dragon Hunter Axe {PvP}','HP Regeneration','lrhand','true',1820,1,1,'fine_steel','s',342,20,'bigblunt',4,4.00000,0,0,0,325,0,132,-1,-1,42759400,2052,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3569-1;3653-1;'),
(10720,'Dragon Hunter Axe {PvP}','Health','lrhand','true',1820,1,1,'fine_steel','s',342,20,'bigblunt',4,4.00000,0,0,0,325,0,132,-1,-1,42759400,2052,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3013-3;3653-1;'),
(10721,'Dragon Hunter Axe {PvP}','HP Drain','lrhand','true',1820,1,1,'fine_steel','s',342,20,'bigblunt',4,4.00000,0,0,0,325,0,132,-1,-1,42759400,2052,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3568-1;3653-1;'),
(10722,'Angel Slayer {PvP}','Critical Damage','rhand','true',950,1,1,'fine_steel','s',246,5,'dagger',12,-3.00000,0,0,0,433,0,132,-1,-1,42759400,2052,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3572-1;3651-1;3652-1;'),
(10723,'Angel Slayer {PvP}','HP Drain','rhand','true',950,1,1,'fine_steel','s',246,5,'dagger',12,-3.00000,0,0,0,433,0,132,-1,-1,42759400,2052,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3568-1;3651-1;3652-1;'),
(10724,'Angel Slayer {PvP}','Haste','rhand','true',950,1,1,'fine_steel','s',246,5,'dagger',12,-3.00000,0,0,0,433,0,132,-1,-1,42759400,2052,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3564-1;3651-1;3652-1;'),
(10725,'Saint Spear {PvP}','Health','lrhand','true',1800,1,1,'fine_steel','s',281,10,'pole',8,-3.00000,0,0,0,325,0,132,-1,-1,42759400,2052,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3013-4;3651-1;3652-1;'),
(10726,'Saint Spear {PvP}','Guidance','lrhand','true',1800,1,1,'fine_steel','s',281,10,'pole',8,-3.00000,0,0,0,325,0,132,-1,-1,42759400,2052,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3602-9;3651-1;3652-1;'),
(10727,'Saint Spear {PvP}','Haste','lrhand','true',1800,1,1,'fine_steel','s',281,10,'pole',8,-3.00000,0,0,0,325,0,132,-1,-1,42759400,2052,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3601-9;3651-1;3652-1;'),
(10728,'Demon Splinter {PvP}','Focus','lrhand','true',1350,1,1,'fine_steel','s',342,5,'dualfist',4,4.00000,0,0,0,325,0,132,-1,-1,42759400,2052,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3565-1;3651-1;3652-1;'),
(10729,'Demon Splinter {PvP}','Health','lrhand','true',1350,1,1,'fine_steel','s',342,5,'dualfist',4,4.00000,0,0,0,325,0,132,-1,-1,42759400,2052,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3013-3;3651-1;3652-1;'),
(10730,'Demon Splinter {PvP}','Critical Stun','lrhand','true',1350,1,1,'fine_steel','s',342,5,'dualfist',4,4.00000,0,0,0,325,0,132,-1,-1,42759400,2052,'false','false','true','false','true',0,0,0,0,0,3571,1,27,0,'3552-1;3651-1;3652-1;'),
(10731,'Arcana Mace {PvP}','Acumen','rhand','true',1300,1,1,'fine_steel','s',225,20,'blunt',4,4.00000,0,0,0,379,0,175,-1,-1,42759400,2052,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3047-3;3654-1;'),
(10732,'Arcana Mace {PvP}','MP Regeneration','rhand','true',1300,1,1,'fine_steel','s',225,20,'blunt',4,4.00000,0,0,0,379,0,175,-1,-1,42759400,2052,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3576-1;3654-1;'),
(10733,'Arcana Mace {PvP}','Mana Up','rhand','true',1300,1,1,'fine_steel','s',225,20,'blunt',4,4.00000,0,0,0,379,0,175,-1,-1,42759400,2052,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3014-2;3654-1;'),
(10734,'Imperial Staff {PvP}','Empower','lrhand','true',910,1,1,'fine_steel','s',274,20,'bigblunt',4,4.00000,0,0,0,325,0,193,-1,-1,42759400,2052,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3575-1;3654-1;'),
(10735,'Imperial Staff {PvP}','MP Regeneration','lrhand','true',910,1,1,'fine_steel','s',274,20,'bigblunt',4,4.00000,0,0,0,325,0,193,-1,-1,42759400,2052,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3576-1;3654-1;'),
(10736,'Imperial Staff {PvP}','Magic Hold','lrhand','true',910,1,1,'fine_steel','s',274,20,'bigblunt',4,4.00000,0,0,0,325,0,193,-1,-1,42759400,2052,'false','false','true','false','true',0,0,3577,1,20,0,0,0,0,'3552-1;3654-1;'),
(10737,'Draconic Bow {PvP}','Cheap Shot','lrhand','true',1650,1,1,'fine_steel','s',581,5,'bow',12,-3.00000,0,0,0,293,11,132,-1,-1,42759400,2052,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3552-1;3655-1;'),
(10738,'Draconic Bow {PvP}','Focus','lrhand','true',1650,1,1,'fine_steel','s',581,5,'bow',12,-3.00000,0,0,0,293,11,132,-1,-1,42759400,2052,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3567-1;3655-1;'),
(10739,'Draconic Bow {PvP}','Critical Slow','lrhand','true',1650,1,1,'fine_steel','s',581,5,'bow',12,-3.00000,0,0,0,293,11,132,-1,-1,42759400,2052,'false','false','true','false','true',0,0,0,0,0,3574,1,16,0,'3552-1;3655-1;'),
(10740,'Laevateinn {PvP}','Haste','rhand','true',1300,1,1,'fine_steel','s',255,40,'rapier',10,-1.00000,0,0,0,406,0,132,-1,-1,42759400,2052,'false','false','true','false','true',3426,1,0,0,0,0,0,0,0,'3564-1;3650-1;'),
(10741,'Laevateinn {PvP}','Health','rhand','true',1300,1,1,'fine_steel','s',255,40,'rapier',10,-1.00000,0,0,0,406,0,132,-1,-1,42759400,2052,'false','false','true','false','true',3426,1,0,0,0,0,0,0,0,'3013-3;3650-1;'),
(10742,'Laevateinn {PvP}','Focus','rhand','true',1300,1,1,'fine_steel','s',255,40,'rapier',10,-1.00000,0,0,0,406,0,132,-1,-1,42759400,2052,'false','false','true','false','true',3426,1,0,0,0,0,0,0,0,'3566-1;3650-1;'),
(10743,'Gram {PvP}','Haste','lrhand','true',1800,1,1,'fine_steel','s',304,15,'ancient',8,2.00000,0,0,0,350,0,132,-1,-1,42759400,2052,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3564-1;3653-1;'),
(10744,'Gram {PvP}','Health','lrhand','true',1800,1,1,'fine_steel','s',304,15,'ancient',8,2.00000,0,0,0,350,0,132,-1,-1,42759400,2052,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3013-3;3653-1;'),
(10745,'Gram {PvP}','Focus','lrhand','true',1800,1,1,'fine_steel','s',304,15,'ancient',8,2.00000,0,0,0,350,0,132,-1,-1,42759400,2052,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3566-1;3653-1;'),
(10746,'Sarunga {PvP}','Cheap Shot','rhand','true',1600,1,1,'fine_steel','s',356,10,'crossbow',10,-1.00000,0,0,0,303,0,132,-1,-1,42759400,2052,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3552-1;3655-1;'),
(10747,'Sarunga - PvP','Focus','rhand','true',1600,1,1,'fine_steel','s',356,10,'crossbow',10,-1.00000,0,0,0,303,0,132,-1,-1,42759400,2052,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3567-1;3655-1;'),
(10748,'Sarunga - PvP','Critical Slow','rhand','true',1600,1,1,'fine_steel','s',356,10,'crossbow',10,-1.00000,0,0,0,303,0,132,-1,-1,42759400,2052,'false','false','true','false','true',0,0,0,0,0,3574,1,16,0,'3552-1;3655-1;'),
(10749,'Tallum Blade*Dark Legion {PvP}','','lrhand','true',2080,1,1,'fine_steel','s',342,10,'dual',8,0.00000,0,0,0,325,0,132,-1,-1,42759400,2052,'false','false','true','false','true',3570,1,0,0,0,0,0,0,0,'3656-1;'),
(10750,'Dynasty Sword {PvP}','Focus','rhand','true',1520,1,1,'fine_steel','s80',333,10,'sword',8,0.00000,0,0,0,379,0,151,-1,-1,74946000,3597,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3566-2;3650-1;'),
(10751,'Dynasty Sword - PvP','Health','rhand','true',1520,1,1,'fine_steel','s80',333,10,'sword',8,0.00000,0,0,0,379,0,151,-1,-1,74946000,3597,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3013-5;3650-1;'),
(10752,'Dynasty Sword - PvP','Light','rhand','true',1520,1,1,'fine_steel','s80',333,10,'sword',8,0.00000,0,0,0,379,0,151,-1,-1,74946000,3597,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3498-1;3650-1;'),
(10753,'Dynasty Blade {PvP}','Focus','lrhand','true',1740,1,1,'fine_steel','s80',405,10,'bigsword',8,0.00000,0,0,0,325,0,151,-1,-1,74946000,3597,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3566-2;3653-1;'),
(10754,'Dynasty Blade - PvP','Health','lrhand','true',1740,1,1,'fine_steel','s80',405,10,'bigsword',8,0.00000,0,0,0,325,0,151,-1,-1,74946000,3597,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3013-5;3653-1;'),
(10755,'Dynasty Blade - PvP','Light','lrhand','true',1740,1,1,'fine_steel','s80',405,10,'bigsword',8,0.00000,0,0,0,325,0,151,-1,-1,74946000,3597,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3498-1;3653-1;'),
(10756,'Dynasty Cudgel {PvP}','Anger','rhand','true',1740,1,1,'fine_steel','s80',333,20,'blunt',4,4.00000,0,0,0,379,0,151,-1,-1,74946000,3597,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3057-3;3650-1;'),
(10757,'Dynasty Cudgel {PvP}','Health','rhand','true',1740,1,1,'fine_steel','s80',333,20,'blunt',4,4.00000,0,0,0,379,0,151,-1,-1,74946000,3597,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3013-5;3650-1;'),
(10758,'Dynasty Cudgel {PvP}','Rsk. Focus','rhand','true',1740,1,1,'fine_steel','s80',333,20,'blunt',4,4.00000,0,0,0,379,0,151,-1,-1,74946000,3597,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3027-7;3650-1;'),
(10759,'Dynasty Crusher {PvP}','Anger','lrhand','true',1740,1,1,'fine_steel','s80',405,20,'bigblunt',4,4.00000,0,0,0,325,0,151,-1,-1,74946000,3597,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3057-3;3653-1;'),
(10760,'Dynasty Crusher {PvP}','Health','lrhand','true',1740,1,1,'fine_steel','s80',405,20,'bigblunt',4,4.00000,0,0,0,325,0,151,-1,-1,74946000,3597,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3013-5;3653-1;'),
(10761,'Dynasty Crusher {PvP}','Rsk. Focus','lrhand','true',1740,1,1,'fine_steel','s80',405,20,'bigblunt',4,4.00000,0,0,0,325,0,151,-1,-1,74946000,3597,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3027-7;3653-1;'),
(10762,'Dynasty Knife {PvP}','Focus','rhand','true',1520,1,1,'fine_steel','s80',291,5,'dagger',12,-3.00000,0,0,0,433,0,151,-1,-1,74946000,3597,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3567-2;3651-1;3652-1;'),
(10763,'Dynasty Knife {PvP}','Evasion','rhand','true',1520,1,1,'fine_steel','s80',291,5,'dagger',12,-3.00000,0,0,0,433,0,151,-1,-1,74946000,3597,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3009-7;3651-1;3652-1;'),
(10764,'Dynasty Knife {PvP}','Critical Damage','rhand','true',1520,1,1,'fine_steel','s80',291,5,'dagger',12,-3.00000,0,0,0,433,0,151,-1,-1,74946000,3597,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3066-4;3651-1;3652-1;'),
(10765,'Dynasty Halberd {PvP}','Anger','lrhand','true',2010,1,1,'fine_steel','s80',333,10,'pole',8,-3.00000,0,0,0,325,0,151,-1,-1,74946000,3597,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3600-10;3651-1;3652-1;'),
(10766,'Dynasty Halberd {PvP}','Critical Stun','lrhand','true',2010,1,1,'fine_steel','s80',333,10,'pole',8,-3.00000,0,0,0,325,0,151,-1,-1,74946000,3597,'false','false','true','false','true',0,0,0,0,0,3070,3,48,0,'3552-2;3651-1;3652-1;'),
(10767,'Dynasty Halberd {PvP}','Light','lrhand','true',2010,1,1,'fine_steel','s80',333,10,'pole',8,-3.00000,0,0,0,325,0,151,-1,-1,74946000,3597,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3599-1;3498-1;3651-1;3652-1;'),
(10768,'Dynasty Bagh-Nakh {PvP}','Rsk. Evasion','lrhand','true',1550,1,1,'fine_steel','s80',405,5,'dualfist',4,4.00000,0,0,0,325,0,151,-1,-1,74946000,3597,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3069-1;3651-1;3652-1;'),
(10769,'Dynasty Bagh-Nakh {PvP}','Focus','lrhand','true',1550,1,1,'fine_steel','s80',405,5,'dualfist',4,4.00000,0,0,0,325,0,151,-1,-1,74946000,3597,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3565-2;3651-1;3652-1;'),
(10770,'Dynasty Bagh-Nakh {PvP}','Haste','lrhand','true',1550,1,1,'fine_steel','s80',405,5,'dualfist',4,4.00000,0,0,0,325,0,151,-1,-1,74946000,3597,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3037-2;3651-1;3652-1;'),
(10771,'Dynasty Phantom {PvP}','Acumen','rhand','true',1520,1,1,'fine_steel','s80',267,10,'sword',8,0.00000,0,0,0,379,0,202,-1,-1,74946000,3597,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3047-3;3654-1;'),
(10772,'Dynasty Phantom {PvP}','Mana Up','rhand','true',1520,1,1,'fine_steel','s80',267,10,'sword',8,0.00000,0,0,0,379,0,202,-1,-1,74946000,3597,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3014-3;3654-1;'),
(10773,'Dynasty Phantom {PvP}','Conversion','rhand','true',1520,1,1,'fine_steel','s80',267,10,'sword',8,0.00000,0,0,0,379,0,202,-1,-1,74946000,3597,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3048-3;3654-1;'),
(10774,'Dynasty Mace {PvP}','Mana Up','rhand','true',1080,1,1,'fine_steel','s80',267,20,'blunt',4,4.00000,0,0,0,379,0,202,-1,-1,74946000,3597,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3014-3;3654-1;'),
(10775,'Dynasty Mace {PvP}','Conversion','rhand','true',1080,1,1,'fine_steel','s80',267,20,'blunt',4,4.00000,0,0,0,379,0,202,-1,-1,74946000,3597,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3048-3;3654-1;'),
(10776,'Dynasty Mace {PvP}','Acumen','rhand','true',1080,1,1,'fine_steel','s80',267,20,'blunt',4,4.00000,0,0,0,379,0,202,-1,-1,74946000,3597,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3047-3;3654-1;'),
(10777,'Dynasty Staff {PvP}','Mana Up','lrhand','true',1080,1,1,'fine_steel','s80',325,20,'bigblunt',4,4.00000,0,0,0,325,0,222,-1,-1,74946000,3597,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3014-3;3654-1;'),
(10778,'Dynasty Staff {PvP}','Conversion','lrhand','true',1080,1,1,'fine_steel','s80',325,20,'bigblunt',4,4.00000,0,0,0,325,0,222,-1,-1,74946000,3597,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3048-3;3654-1;'),
(10779,'Dynasty Staff {PvP}','Acumen','lrhand','true',1080,1,1,'fine_steel','s80',325,20,'bigblunt',4,4.00000,0,0,0,325,0,222,-1,-1,74946000,3597,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3047-3;3654-1;'),
(10780,'Dynasty Bow {PvP}','Cheap Shot','lrhand','true',1520,1,1,'fine_steel','s80',654,5,'bow',12,-3.00000,0,0,0,293,11,151,-1,-1,74946000,3597,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3552-1;3655-1;'),
(10781,'Dynasty Bow {PvP}','Guidance','lrhand','true',1520,1,1,'fine_steel','s80',654,5,'bow',12,-3.00000,0,0,0,293,11,151,-1,-1,74946000,3597,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3573-1;3655-1;'),
(10782,'Dynasty Bow {PvP}','Focus','lrhand','true',1520,1,1,'fine_steel','s80',654,5,'bow',12,-3.00000,0,0,0,293,11,151,-1,-1,74946000,3597,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3567-2;3655-1;'),
(10783,'Dynasty Rapier {PvP}','Focus','rhand','true',1280,1,1,'fine_steel','s80',302,40,'rapier',10,-1.00000,0,0,0,406,0,151,-1,-1,74946000,3597,'false','false','true','false','true',3426,1,0,0,0,0,0,0,0,'3566-2;3650-1;'),
(10784,'Dynasty Rapier {PvP}','Health','rhand','true',1280,1,1,'fine_steel','s80',302,40,'rapier',10,-1.00000,0,0,0,406,0,151,-1,-1,74946000,3597,'false','false','true','false','true',3426,1,0,0,0,0,0,0,0,'3013-5;3650-1;'),
(10785,'Dynasty Rapier {PvP}','Light','rhand','true',1280,1,1,'fine_steel','s80',302,40,'rapier',10,-1.00000,0,0,0,406,0,151,-1,-1,74946000,3597,'false','false','true','false','true',3426,1,0,0,0,0,0,0,0,'3498-1;3650-1;'),
(10786,'Dynasty Ancient Sword {PvP}','Focus','lrhand','true',1800,1,1,'fine_steel','s80',361,15,'ancient',8,2.00000,0,0,0,350,0,151,-1,-1,74946000,3597,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3566-2;3653-1;'),
(10787,'Dynasty Ancient Sword {PvP}','Health','lrhand','true',1800,1,1,'fine_steel','s80',361,15,'ancient',8,2.00000,0,0,0,350,0,151,-1,-1,74946000,3597,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3013-5;3653-1;'),
(10788,'Dynasty Ancient Sword {PvP}','Light','lrhand','true',1800,1,1,'fine_steel','s80',361,15,'ancient',8,2.00000,0,0,0,350,0,151,-1,-1,74946000,3597,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3498-1;3653-1;'),
(10789,'Dynasty Crossbow {PvP}','Cheap Shot','rhand','true',1580,1,1,'fine_steel','s80',401,10,'crossbow',10,-1.00000,0,0,0,303,0,151,-1,-1,74946000,3597,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3552-1;3655-1;'),
(10790,'Dynasty Crossbow - PvP','Guidance','rhand','true',1580,1,1,'fine_steel','s80',401,10,'crossbow',10,-1.00000,0,0,0,303,0,151,-1,-1,74946000,3597,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3008-6;3655-1;'),
(10791,'Dynasty Crossbow - PvP','Focus','rhand','true',1580,1,1,'fine_steel','s80',401,10,'crossbow',10,-1.00000,0,0,0,303,0,151,-1,-1,74946000,3597,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3567-2;3655-1;'),
(10792,'Dynasty Dual Sword {PvP}','','lrhand','true',1520,1,1,'fine_steel','s80',405,10,'dual',8,0.00000,0,0,0,325,0,151,-1,-1,74946000,3597,'false','false','true','false','true',3411,1,0,0,0,0,0,0,0,'3656-1;'),
(10870,'Great Sword - Lightning','','lrhand','true',1930,1,1,'fine_steel','b',213,10,'bigsword',8,0.00000,0,0,0,325,0,91,-1,-1,6680500,891,'true','true','true','true','true',0,0,0,0,0,0,0,0,10882,'0-0;'),
(10871,'Great Sword - Lightning','Health','lrhand','true',1930,1,1,'fine_steel','b',213,10,'bigsword',8,0.00000,0,0,0,325,0,91,-1,-1,6680500,891,'true','true','true','true','true',0,0,0,0,0,0,0,0,10883,'3013-1;'),
(10872,'Great Sword - Lightning','Critical Damage','lrhand','true',1930,1,1,'fine_steel','b',213,10,'bigsword',8,0.00000,0,0,0,325,0,91,-1,-1,6680500,891,'true','true','true','true','true',0,0,0,0,0,0,0,0,10884,'3023-5;'),
(10873,'Great Sword - Lightning','Focus','lrhand','true',1930,1,1,'fine_steel','b',213,10,'bigsword',8,0.00000,0,0,0,325,0,91,-1,-1,6680500,891,'true','true','true','true','true',0,0,0,0,0,0,0,0,10885,'3010-5;'),
(10874,'Great Axe - Thunder','','lrhand','true',1940,1,1,'fine_steel','b',175,10,'pole',8,-3.00000,0,0,0,325,0,91,-1,-1,6680500,891,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3599-1;'),
(10875,'Great Axe - Thunder','Anger','lrhand','true',1940,1,1,'fine_steel','b',175,10,'pole',8,-3.00000,0,0,0,325,0,91,-1,-1,6680500,891,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3600-5;'),
(10876,'Great Axe - Thunder','Critical Stun','lrhand','true',1940,1,1,'fine_steel','b',175,10,'pole',8,-3.00000,0,0,0,325,0,91,-1,-1,6680500,891,'true','true','true','true','true',0,0,0,0,0,3016,5,27,0,'3599-1;'),
(10877,'Great Axe - Thunder','Light','lrhand','true',1940,1,1,'fine_steel','b',175,10,'pole',8,-3.00000,0,0,0,325,0,91,-1,-1,6680500,891,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3599-1;3498-1;'),
(10878,'Sword of Limit*Sword of Limit - Destruction','','lrhand','true',2140,1,1,'fine_steel','b',213,10,'dual',8,0.00000,0,0,0,325,0,91,-1,-1,6680500,891,'true','true','true','true','true',3042,11,0,0,0,0,0,0,0,'0-0;'),
(10879,'Sword of Limit*Sword of Delusion - Destruction','','lrhand','true',2140,1,1,'fine_steel','b',213,10,'dual',8,0.00000,0,0,0,325,0,91,-1,-1,6680500,891,'true','true','true','true','true',3013,1,0,0,0,0,0,0,0,'0-0;'),
(10880,'Sword of Limit*Sword of Nightmare - Destruction','','lrhand','true',2130,1,1,'fine_steel','b',213,10,'dual',8,0.00000,0,0,0,325,0,91,-1,-1,6680500,891,'true','true','true','true','true',3044,11,0,0,0,0,0,0,0,'0-0;'),
(10881,'Sword of Limit*Tsurugi - Destruction','','lrhand','true',2120,1,1,'fine_steel','b',213,10,'dual',8,0.00000,0,0,0,325,0,91,-1,-1,6680500,891,'true','true','true','true','true',3045,1,0,0,0,0,0,0,0,'0-0;'),
(10882,'Innominate Victory - Lightning','','lrhand','true',1930,1,1,'fine_steel','b',190,15,'ancient',8,2.00000,0,0,0,350,0,91,-1,-1,6680500,891,'true','true','true','true','true',0,0,0,0,0,0,0,0,10870,'0-0;'),
(10883,'Innominate Victory - Lightning','Health','lrhand','true',1930,1,1,'fine_steel','b',190,15,'ancient',8,2.00000,0,0,0,350,0,91,-1,-1,6680500,891,'true','true','true','true','true',0,0,0,0,0,0,0,0,10871,'3013-1;'),
(10884,'Innominate Victory - Lightning','Critical Damage','lrhand','true',1930,1,1,'fine_steel','b',190,15,'ancient',8,2.00000,0,0,0,350,0,91,-1,-1,6680500,891,'true','true','true','true','true',0,0,0,0,0,0,0,0,10872,'3023-5;'),
(10885,'Innominate Victory - Lightning','Focus','lrhand','true',1930,1,1,'fine_steel','b',190,15,'ancient',8,2.00000,0,0,0,350,0,91,-1,-1,6680500,891,'true','true','true','true','true',0,0,0,0,0,0,0,0,10873,'3010-5;'),
(10886,'Dark Elven Long Bow - Concentration','','lrhand','true',1720,3,1,'fine_steel','b',397,5,'bow',12,-3.00000,0,0,0,227,8,100,-1,-1,6680500,891,'true','true','true','true','true',0,0,0,0,0,0,0,0,10934,'0-0;'),
(10887,'Dark Elven Long Bow - Concentration','Evasion','lrhand','true',1720,3,1,'fine_steel','b',397,5,'bow',12,-3.00000,0,0,0,227,8,100,-1,-1,6680500,891,'true','true','true','true','true',0,0,0,0,0,0,0,0,10935,'3009-5;'),
(10888,'Dark Elven Long Bow - Concentration','Critical Bleed','lrhand','true',1720,3,1,'fine_steel','b',397,5,'bow',12,-3.00000,0,0,0,227,8,100,-1,-1,6680500,891,'true','true','true','true','true',0,0,0,0,0,3055,2,24,10936,'3552-1;'),
(10889,'Dark Elven Long Bow - Concentration','Miser','lrhand','true',1720,3,1,'fine_steel','b',397,5,'bow',12,-3.00000,0,0,0,227,8,100,-1,-1,6680500,891,'true','true','true','true','true',0,0,0,0,0,0,0,0,10937,'0-0;'),
(10890,'Sword of Delusion*Sword of Delusion - Destruction','','lrhand','true',2150,1,1,'fine_steel','b',213,10,'dual',8,0.00000,0,0,0,325,0,91,-1,-1,6680500,891,'true','true','true','true','true',3046,10,0,0,0,0,0,0,0,'0-0;'),
(10891,'Sword of Delusion*Sword of Nightmare - Destruction','','lrhand','true',2130,1,1,'fine_steel','b',213,10,'dual',8,0.00000,0,0,0,325,0,91,-1,-1,6680500,891,'true','true','true','true','true',3042,11,0,0,0,0,0,0,0,'0-0;'),
(10892,'Sword of Delusion*Tsurugi - Destruction','','lrhand','true',2140,1,1,'fine_steel','b',213,10,'dual',8,0.00000,0,0,0,325,0,91,-1,-1,6680500,891,'true','true','true','true','true',3013,1,0,0,0,0,0,0,0,'0-0;'),
(10893,'Sword of Valhalla - Nature','','rhand','true',900,1,1,'fine_steel','b',140,10,'sword',8,0.00000,0,0,0,379,0,122,-1,-1,6680500,891,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3852-1;'),
(10894,'Sword of Valhalla - Nature','Acumen','rhand','true',900,1,1,'fine_steel','b',140,10,'sword',8,0.00000,0,0,0,379,0,122,-1,-1,6680500,891,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3047-1;3852-1;'),
(10895,'Sword of Valhalla - Nature','Magic Weakness','rhand','true',900,1,1,'fine_steel','b',140,10,'sword',8,0.00000,0,0,0,379,0,122,-1,-1,6680500,891,'true','true','true','true','true',0,0,1164,11,8,0,0,0,0,'3852-1;'),
(10896,'Sword of Valhalla - Nature','Magic Regeneration','rhand','true',900,1,1,'fine_steel','b',140,10,'sword',8,0.00000,0,0,0,379,0,122,-1,-1,6680500,891,'true','true','true','true','true',0,0,1044,3,30,0,0,0,0,'3852-1;'),
(10897,'Stormbringer*Samurai Long Sword - Destruction','','lrhand','true',2150,1,1,'fine_steel','b',213,10,'dual',8,0.00000,0,0,0,325,0,91,-1,-1,6680500,891,'true','true','true','true','true',3046,10,0,0,0,0,0,0,0,'0-0;'),
(10898,'Spell Breaker - Hail','','rhand','true',1620,1,1,'fine_steel','b',140,20,'blunt',4,4.00000,0,0,0,379,0,122,-1,-1,6680500,891,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(10899,'Spell Breaker - Hail','Acumen','rhand','true',1620,1,1,'fine_steel','b',140,20,'blunt',4,4.00000,0,0,0,379,0,122,-1,-1,6680500,891,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3047-1;'),
(10900,'Spell Breaker - Hail','Magic Mental Shield','rhand','true',1620,1,1,'fine_steel','b',140,20,'blunt',4,4.00000,0,0,0,379,0,122,-1,-1,6680500,891,'true','true','true','true','true',0,0,1035,4,50,0,0,0,0,'0-0;'),
(10901,'Spell Breaker - Hail','Magic Hold','rhand','true',1620,1,1,'fine_steel','b',140,20,'blunt',4,4.00000,0,0,0,379,0,122,-1,-1,6680500,891,'true','true','true','true','true',0,0,3577,1,10,0,0,0,0,'3552-1;'),
(10902,'Arthro Nail - Destruction','','lrhand','true',1420,1,1,'fine_steel','b',213,5,'dualfist',4,4.00000,0,0,0,325,0,91,-1,-1,6680500,891,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(10903,'Arthro Nail - Destruction','Critical Poison','lrhand','true',1420,1,1,'fine_steel','b',213,5,'dualfist',4,4.00000,0,0,0,325,0,91,-1,-1,6680500,891,'true','true','true','true','true',0,0,0,0,0,3040,5,7,0,'0-0;'),
(10904,'Arthro Nail - Destruction','Rsk. Evasion','lrhand','true',1420,1,1,'fine_steel','b',213,5,'dualfist',4,4.00000,0,0,0,325,0,91,-1,-1,6680500,891,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3030-5;'),
(10905,'Arthro Nail - Destruction','Rsk. Haste','lrhand','true',1420,1,1,'fine_steel','b',213,5,'dualfist',4,4.00000,0,0,0,325,0,91,-1,-1,6680500,891,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3034-5;'),
(10906,'Ice Storm Hammer - Lightning','','lrhand','true',1950,1,1,'fine_steel','b',213,20,'bigblunt',4,4.00000,0,0,0,325,0,91,-1,-1,6680500,891,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(10907,'Ice Storm Hammer - Lightning','Focus','lrhand','true',1950,1,1,'fine_steel','b',213,20,'bigblunt',4,4.00000,0,0,0,325,0,91,-1,-1,6680500,891,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3010-5;'),
(10908,'Ice Storm Hammer - Lightning','Anger','lrhand','true',1950,1,1,'fine_steel','b',213,20,'bigblunt',4,4.00000,0,0,0,325,0,91,-1,-1,6680500,891,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3012-5;'),
(10909,'Ice Storm Hammer - Lightning','Critical Bleed','lrhand','true',1950,1,1,'fine_steel','b',213,20,'bigblunt',4,4.00000,0,0,0,325,0,91,-1,-1,6680500,891,'true','true','true','true','true',0,0,0,0,0,3052,2,42,0,'0-0;'),
(10910,'Sword of Nightmare*Sword of Nightmare - Destruction','','lrhand','true',2130,1,1,'fine_steel','b',213,10,'dual',8,0.00000,0,0,0,325,0,91,-1,-1,6680500,891,'true','true','true','true','true',3044,11,0,0,0,0,0,0,0,'0-0;'),
(10911,'Sword of Nightmare*Tsurugi - Destruction','','lrhand','true',2140,1,1,'fine_steel','b',213,10,'dual',8,0.00000,0,0,0,325,0,91,-1,-1,6680500,891,'true','true','true','true','true',3045,1,0,0,0,0,0,0,0,'0-0;'),
(10912,'Military Fleuret - Destruction','','rhand','true',1370,1,1,'fine_steel','b',159,40,'rapier',10,-1.00000,0,0,0,406,0,91,-1,-1,6680500,891,'true','true','true','true','true',3426,1,0,0,0,0,0,0,10930,'0-0;'),
(10913,'Military Fleuret - Destruction','Guidance','rhand','true',1370,1,1,'fine_steel','b',159,40,'rapier',10,-1.00000,0,0,0,406,0,91,-1,-1,6680500,891,'true','true','true','true','true',3426,1,0,0,0,0,0,0,10931,'3007-5;'),
(10914,'Military Fleuret - Destruction','Focus','rhand','true',1370,1,1,'fine_steel','b',159,40,'rapier',10,-1.00000,0,0,0,406,0,91,-1,-1,6680500,891,'true','true','true','true','true',3426,1,0,0,0,0,0,0,10932,'3010-5;'),
(10915,'Military Fleuret - Destruction','Back Blow','rhand','true',1370,1,1,'fine_steel','b',159,40,'rapier',10,-1.00000,0,0,0,406,0,91,-1,-1,6680500,891,'true','true','true','true','true',3426,1,0,0,0,0,0,0,10933,'3018-5;'),
(10916,'Sprite\'s Staff - Hail','','lrhand','true',960,1,1,'fine_steel','b',170,20,'bigblunt',4,4.00000,0,0,0,325,0,134,-1,-1,6680500,891,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(10917,'Sprite\'s Staff - Hail','Magic Regeneration','lrhand','true',960,1,1,'fine_steel','b',170,20,'bigblunt',4,4.00000,0,0,0,325,0,134,-1,-1,6680500,891,'true','true','true','true','true',0,0,1044,3,30,0,0,0,0,'0-0;'),
(10918,'Sprite\'s Staff - Hail','Magic Mental Shield','lrhand','true',960,1,1,'fine_steel','b',170,20,'bigblunt',4,4.00000,0,0,0,325,0,134,-1,-1,6680500,891,'true','true','true','true','true',0,0,1035,4,50,0,0,0,0,'0-0;'),
(10919,'Sprite\'s Staff - Hail','Magic Hold','lrhand','true',960,1,1,'fine_steel','b',170,20,'bigblunt',4,4.00000,0,0,0,325,0,134,-1,-1,6680500,891,'true','true','true','true','true',0,0,3577,1,10,0,0,0,0,'0-0;'),
(10920,'Tsurugi*Tsurugi - Destruction','','lrhand','true',2120,1,1,'fine_steel','b',213,10,'dual',8,0.00000,0,0,0,325,0,91,-1,-1,6680500,891,'true','true','true','true','true',3044,11,0,0,0,0,0,0,0,'0-0;'),
(10921,'Caliburs*Sword of Limit - Destruction','','lrhand','true',2150,1,1,'fine_steel','b',213,10,'dual',8,0.00000,0,0,0,325,0,91,-1,-1,6680500,891,'true','true','true','true','true',3013,1,0,0,0,0,0,0,0,'0-0;'),
(10922,'Caliburs*Sword of Delusion - Destruction','','lrhand','true',2140,1,1,'fine_steel','b',213,10,'dual',8,0.00000,0,0,0,325,0,91,-1,-1,6680500,891,'true','true','true','true','true',3044,11,0,0,0,0,0,0,0,'0-0;'),
(10923,'Caliburs*Sword of Nightmare - Destruction','','lrhand','true',2170,1,1,'fine_steel','b',213,10,'dual',8,0.00000,0,0,0,325,0,91,-1,-1,6680500,891,'true','true','true','true','true',3045,1,0,0,0,0,0,0,0,'0-0;'),
(10924,'Caliburs*Tsurugi - Destruction','','lrhand','true',2150,1,1,'fine_steel','b',213,10,'dual',8,0.00000,0,0,0,325,0,91,-1,-1,6680500,891,'true','true','true','true','true',3046,10,0,0,0,0,0,0,0,'0-0;'),
(10925,'Caliburs*Caliburs - Destruction','','lrhand','true',2140,1,1,'fine_steel','b',213,10,'dual',8,0.00000,0,0,0,325,0,91,-1,-1,6680500,891,'true','true','true','true','true',3042,11,0,0,0,0,0,0,0,'0-0;'),
(10926,'Kris - Confusion','','rhand','true',980,1,1,'fine_steel','b',153,5,'dagger',12,-3.00000,0,0,0,433,0,91,-1,-1,6680500,891,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(10927,'Kris - Confusion','Evasion','rhand','true',980,1,1,'fine_steel','b',153,5,'dagger',12,-3.00000,0,0,0,433,0,91,-1,-1,6680500,891,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3009-5;'),
(10928,'Kris - Confusion','Focus','rhand','true',980,1,1,'fine_steel','b',153,5,'dagger',12,-3.00000,0,0,0,433,0,91,-1,-1,6680500,891,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3011-5;'),
(10929,'Kris - Confusion','Back Blow','rhand','true',980,1,1,'fine_steel','b',153,5,'dagger',12,-3.00000,0,0,0,433,0,91,-1,-1,6680500,891,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3019-5;'),
(10930,'Keshanberk - Destruction','','rhand','true',1370,1,1,'fine_steel','b',175,10,'sword',8,0.00000,0,0,0,379,0,91,-1,-1,6680500,891,'true','true','true','true','true',0,0,0,0,0,0,0,0,10912,'0-0;'),
(10931,'Keshanberk - Destruction','Guidance','rhand','true',1370,1,1,'fine_steel','b',175,10,'sword',8,0.00000,0,0,0,379,0,91,-1,-1,6680500,891,'true','true','true','true','true',0,0,0,0,0,0,0,0,10913,'3007-5;'),
(10932,'Keshanberk - Destruction','Focus','rhand','true',1370,1,1,'fine_steel','b',175,10,'sword',8,0.00000,0,0,0,379,0,91,-1,-1,6680500,891,'true','true','true','true','true',0,0,0,0,0,0,0,0,10914,'3010-5;'),
(10933,'Keshanberk - Destruction','Back Blow','rhand','true',1370,1,1,'fine_steel','b',175,10,'sword',8,0.00000,0,0,0,379,0,91,-1,-1,6680500,891,'true','true','true','true','true',0,0,0,0,0,0,0,0,10915,'3018-5;'),
(10934,'Peacemaker - Concentration','','rhand','true',1720,2,1,'fine_steel','b',221,10,'crossbow',10,-1.00000,0,0,0,303,0,91,-1,-1,6680500,891,'true','true','true','true','true',0,0,0,0,0,0,0,0,10886,'0-0;'),
(10935,'Peacemaker - Concentration','Evasion','rhand','true',1720,2,1,'fine_steel','b',221,10,'crossbow',10,-1.00000,0,0,0,303,0,91,-1,-1,6680500,891,'true','true','true','true','true',0,0,0,0,0,0,0,0,10887,'3009-5;'),
(10936,'Peacemaker - Concentration','Critical Bleed','rhand','true',1720,2,1,'fine_steel','b',221,10,'crossbow',10,-1.00000,0,0,0,303,0,91,-1,-1,6680500,891,'true','true','true','true','true',0,0,0,0,0,3021,5,41,10888,'0-0;'),
(10937,'Peacemaker - Concentration','Miser','rhand','true',1720,2,1,'fine_steel','b',221,10,'crossbow',10,-1.00000,0,0,0,303,0,91,-1,-1,6680500,891,'true','true','true','true','true',0,0,0,0,0,0,0,0,10889,'0-0;'),
(10938,'Heavy War Axe - Earth','','rhand','true',1620,1,1,'fine_steel','b',175,20,'blunt',4,4.00000,0,0,0,379,0,91,-1,-1,6680500,891,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3884-1;'),
(10939,'Heavy War Axe - Earth','Anger','rhand','true',1620,1,1,'fine_steel','b',175,20,'blunt',4,4.00000,0,0,0,379,0,91,-1,-1,6680500,891,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3884-1;3012-5;'),
(10940,'Heavy War Axe - Earth','Health','rhand','true',1620,1,1,'fine_steel','b',175,20,'blunt',4,4.00000,0,0,0,379,0,91,-1,-1,6680500,891,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3884-1;3013-1;'),
(10941,'Heavy War Axe - Earth','Rsk. Focus','rhand','true',1620,1,1,'fine_steel','b',175,20,'blunt',4,4.00000,0,0,0,379,0,91,-1,-1,6680500,891,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3884-1;3027-5;'),
(10942,'Hell Knife - Confusion','','rhand','true',740,1,1,'fine_steel','b',122,5,'dagger',12,-3.00000,0,0,0,433,0,122,-1,-1,6680500,891,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(10943,'Hell Knife - Confusion','Magic Regeneration','rhand','true',740,1,1,'fine_steel','b',122,5,'dagger',12,-3.00000,0,0,0,433,0,122,-1,-1,6680500,891,'true','true','true','true','true',0,0,1044,3,30,0,0,0,0,'0-0;'),
(10944,'Hell Knife - Confusion','Magic Mental Shield','rhand','true',740,1,1,'fine_steel','b',122,5,'dagger',12,-3.00000,0,0,0,433,0,122,-1,-1,6680500,891,'true','true','true','true','true',0,0,1035,4,50,0,0,0,0,'0-0;'),
(10945,'Hell Knife - Confusion','Magic Weakness','rhand','true',740,1,1,'fine_steel','b',122,5,'dagger',12,-3.00000,0,0,0,433,0,122,-1,-1,6680500,891,'true','true','true','true','true',0,0,1164,11,8,0,0,0,0,'0-0;'),
(10946,'Raid Sword*Samurai Long Sword - Destruction','','lrhand','true',2130,1,1,'fine_steel','b',220,10,'dual',8,0.00000,0,0,0,325,0,94,-1,-1,7340000,979,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(10947,'Shamshir*Samurai Long Sword - Destruction','','lrhand','true',2110,1,1,'fine_steel','b',220,10,'dual',8,0.00000,0,0,0,325,0,94,-1,-1,7340000,979,'true','true','true','true','true',3046,4,0,0,0,0,0,0,0,'0-0;'),
(10948,'Spirit Sword*Samurai Long Sword - Destruction','','lrhand','true',2110,1,1,'fine_steel','b',220,10,'dual',8,0.00000,0,0,0,325,0,94,-1,-1,7340000,979,'true','true','true','true','true',3013,1,0,0,0,0,0,0,0,'0-0;'),
(10949,'Katana*Samurai Long Sword - Destruction','','lrhand','true',2130,1,1,'fine_steel','b',220,10,'dual',8,0.00000,0,0,0,325,0,94,-1,-1,7340000,979,'true','true','true','true','true',3042,12,0,0,0,0,0,0,0,'0-0;'),
(10950,'Sword of Limit*Samurai Long Sword - Destruction','','lrhand','true',2100,1,1,'fine_steel','b',228,10,'dual',8,0.00000,0,0,0,325,0,97,-1,-1,8729600,1164,'true','true','true','true','true',3046,4,0,0,0,0,0,0,0,'0-0;'),
(10951,'Sword of Delusion*Samurai Long Sword - Destruction','','lrhand','true',2110,1,1,'fine_steel','b',228,10,'dual',8,0.00000,0,0,0,325,0,97,-1,-1,8729600,1164,'true','true','true','true','true',3042,13,0,0,0,0,0,0,0,'0-0;'),
(10952,'Sword of Nightmare*Samurai Long Sword - Destruction','','lrhand','true',2080,1,1,'fine_steel','b',228,10,'dual',8,0.00000,0,0,0,325,0,97,-1,-1,8729600,1164,'true','true','true','true','true',3013,1,0,0,0,0,0,0,0,'0-0;'),
(10953,'Tsurugi*Samurai Long Sword - Destruction','','lrhand','true',2090,1,1,'fine_steel','b',228,10,'dual',8,0.00000,0,0,0,325,0,97,-1,-1,8729600,1164,'true','true','true','true','true',3044,13,0,0,0,0,0,0,0,'0-0;'),
(10954,'Caliburs*Samurai Long Sword - Destruction','','lrhand','true',2120,1,1,'fine_steel','b',228,10,'dual',8,0.00000,0,0,0,325,0,97,-1,-1,8729600,1164,'true','true','true','true','true',3045,1,0,0,0,0,0,0,0,'0-0;'),
(10955,'Guardian Sword - Great Gale','','lrhand','true',1930,1,1,'fine_steel','b',236,10,'bigsword',8,0.00000,0,0,0,325,0,99,-1,-1,10091400,1346,'true','true','true','true','true',0,0,0,0,0,0,0,0,10963,'3840-1;'),
(10956,'Guardian Sword - Great Gale','Critical Drain','lrhand','true',1930,1,1,'fine_steel','b',236,10,'bigsword',8,0.00000,0,0,0,325,0,99,-1,-1,10091400,1346,'true','true','true','true','true',0,0,0,0,0,3022,6,33,10964,'3840-1;'),
(10957,'Guardian Sword - Great Gale','Health','lrhand','true',1930,1,1,'fine_steel','b',236,10,'bigsword',8,0.00000,0,0,0,325,0,99,-1,-1,10091400,1346,'true','true','true','true','true',0,0,0,0,0,0,0,0,10965,'3840-1;3013-1;'),
(10958,'Guardian Sword - Great Gale','Critical Bleed','lrhand','true',1930,1,1,'fine_steel','b',236,10,'bigsword',8,0.00000,0,0,0,325,0,99,-1,-1,10091400,1346,'true','true','true','true','true',0,0,0,0,0,3055,2,24,10966,'3840-1;'),
(10959,'Sword of Damascus - Earth','','rhand','true',1350,1,1,'fine_steel','b',194,10,'sword',8,0.00000,0,0,0,379,0,99,-1,-1,10091400,1346,'true','true','true','true','true',0,0,0,0,0,0,0,0,11001,'3826-1;'),
(10960,'Sword of Damascus - Earth','Focus','rhand','true',1350,1,1,'fine_steel','b',194,10,'sword',8,0.00000,0,0,0,379,0,99,-1,-1,10091400,1346,'true','true','true','true','true',0,0,0,0,0,0,0,0,11002,'3826-1;3010-6;'),
(10961,'Sword of Damascus - Earth','Critical Damage','rhand','true',1350,1,1,'fine_steel','b',194,10,'sword',8,0.00000,0,0,0,379,0,99,-1,-1,10091400,1346,'true','true','true','true','true',0,0,0,0,0,0,0,0,11003,'3826-1;3023-3;'),
(10962,'Sword of Damascus - Earth','Haste','rhand','true',1350,1,1,'fine_steel','b',194,10,'sword',8,0.00000,0,0,0,379,0,99,-1,-1,10091400,1346,'true','true','true','true','true',0,0,0,0,0,0,0,0,11004,'3826-1;3036-5;'),
(10963,'Dismantler - Great Gale','','lrhand','true',1930,1,1,'fine_steel','b',210,15,'ancient',8,2.00000,0,0,0,350,0,99,-1,-1,10091400,1346,'true','true','true','true','true',0,0,0,0,0,0,0,0,10955,'3846-1;'),
(10964,'Dismantler - Great Gale','Critical Drain','lrhand','true',1930,1,1,'fine_steel','b',210,15,'ancient',8,2.00000,0,0,0,350,0,99,-1,-1,10091400,1346,'true','true','true','true','true',0,0,0,0,0,3022,6,33,10956,'3846-1;'),
(10965,'Dismantler - Great Gale','Health','lrhand','true',1930,1,1,'fine_steel','b',210,15,'ancient',8,2.00000,0,0,0,350,0,99,-1,-1,10091400,1346,'true','true','true','true','true',0,0,0,0,0,0,0,0,10957,'3846-1;3013-1;'),
(10966,'Dismantler - Great Gale','Critical Bleed','lrhand','true',1930,1,1,'fine_steel','b',210,15,'ancient',8,2.00000,0,0,0,350,0,99,-1,-1,10091400,1346,'true','true','true','true','true',0,0,0,0,0,3055,2,24,10958,'3846-1;'),
(10967,'Lance - Earth','','lrhand','true',1920,1,1,'fine_steel','b',194,10,'pole',8,-3.00000,0,0,0,325,0,99,-1,-1,10091400,1346,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3877-1;3599-1;'),
(10968,'Lance - Earth','Anger','lrhand','true',1920,1,1,'fine_steel','b',194,10,'pole',8,-3.00000,0,0,0,325,0,99,-1,-1,10091400,1346,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3877-1;3600-6;'),
(10969,'Lance - Earth','Critical Stun','lrhand','true',1920,1,1,'fine_steel','b',194,10,'pole',8,-3.00000,0,0,0,325,0,99,-1,-1,10091400,1346,'true','true','true','true','true',0,0,0,0,0,3070,1,25,0,'3877-1;3599-1;'),
(10970,'Lance - Earth','Long Blow','lrhand','true',1920,1,1,'fine_steel','b',194,10,'pole',8,-3.00000,0,0,0,325,0,99,-1,-1,10091400,1346,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3877-1;3599-1;'),
(10971,'Bellion Cestus - Great Gale','','lrhand','true',1390,1,1,'fine_steel','b',236,5,'dualfist',4,4.00000,0,0,0,325,0,99,-1,-1,10091400,1346,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3880-1;'),
(10972,'Bellion Cestus - Great Gale','Critical Drain','lrhand','true',1390,1,1,'fine_steel','b',236,5,'dualfist',4,4.00000,0,0,0,325,0,99,-1,-1,10091400,1346,'true','true','true','true','true',0,0,0,0,0,3039,6,33,0,'3880-1;3552-1;'),
(10973,'Bellion Cestus - Great Gale','Critical Poison','lrhand','true',1390,1,1,'fine_steel','b',236,5,'dualfist',4,4.00000,0,0,0,325,0,99,-1,-1,10090000,1346,'true','true','true','true','true',0,0,0,0,0,3040,6,6,0,'3880-1;'),
(10974,'Bellion Cestus - Great Gale','Rsk. Haste','lrhand','true',1390,1,1,'fine_steel','b',236,5,'dualfist',4,4.00000,0,0,0,325,0,99,-1,-1,10091400,1346,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3880-1;3034-6;'),
(10975,'Staff of Evil Spirits - Holy Spirit','','lrhand','true',930,1,1,'fine_steel','b',189,20,'bigblunt',4,4.00000,0,0,0,325,0,145,-1,-1,10091400,1346,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(10976,'Staff of Evil Spirits - Holy Spirit','Magic Focus','lrhand','true',930,1,1,'fine_steel','b',189,20,'bigblunt',4,4.00000,0,0,0,325,0,145,-1,-1,10091400,1346,'true','true','true','true','true',0,0,1077,3,20,0,0,0,0,'3552-1;'),
(10977,'Staff of Evil Spirits - Holy Spirit','Blessed Body','lrhand','true',930,1,1,'fine_steel','b',189,20,'bigblunt',4,4.00000,0,0,0,325,0,145,-1,-1,10091400,1346,'true','true','true','true','true',0,0,1045,5,20,0,0,0,0,'0-0;'),
(10978,'Staff of Evil Spirits - Holy Spirit','Magic Poison','lrhand','true',930,1,1,'fine_steel','b',189,20,'bigblunt',4,4.00000,0,0,0,325,0,145,-1,-1,10091400,1346,'true','true','true','true','true',0,0,1168,6,6,0,0,0,0,'0-0;'),
(10979,'Deadman\'s Glory - Landslide','','rhand','true',1600,1,1,'fine_steel','b',194,20,'blunt',4,4.00000,0,0,0,379,0,99,-1,-1,10091400,1346,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3885-1;'),
(10980,'Deadman\'s Glory - Landslide','Anger','rhand','true',1600,1,1,'fine_steel','b',194,20,'blunt',4,4.00000,0,0,0,379,0,99,-1,-1,10091400,1346,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3012-6;3885-1;'),
(10981,'Deadman\'s Glory - Landslide','Health','rhand','true',1600,1,1,'fine_steel','b',194,20,'blunt',4,4.00000,0,0,0,379,0,99,-1,-1,10090000,1346,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3013-1;3885-1;'),
(10982,'Deadman\'s Glory - Landslide','Haste','rhand','true',1600,1,1,'fine_steel','b',194,20,'blunt',4,4.00000,0,0,0,379,0,99,-1,-1,10091400,1346,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3036-5;3885-1;'),
(10983,'Star Buster - Great Gale','','lrhand','true',1930,1,1,'fine_steel','b',236,20,'bigblunt',4,4.00000,0,0,0,325,0,99,-1,-1,10091400,1346,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3896-1;'),
(10984,'Star Buster - Great Gale','Health','lrhand','true',1930,1,1,'fine_steel','b',236,20,'bigblunt',4,4.00000,0,0,0,325,0,99,-1,-1,10091400,1346,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3896-1;3013-1;'),
(10985,'Star Buster - Great Gale','Haste','lrhand','true',1930,1,1,'fine_steel','b',236,20,'bigblunt',4,4.00000,0,0,0,325,0,99,-1,-1,10091400,1346,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3896-1;3036-5;'),
(10986,'Star Buster - Great Gale','Rsk. Focus','lrhand','true',1930,1,1,'fine_steel','b',236,20,'bigblunt',4,4.00000,0,0,0,325,0,99,-1,-1,10091400,1346,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3896-1;3027-6;'),
(10987,'Samurai Long Sword*Samurai Long Sword - Landslide','','lrhand','true',2080,1,1,'fine_steel','b',236,10,'dual',8,0.00000,0,0,0,325,0,99,-1,-1,10091400,1346,'true','true','true','true','true',3045,12,0,0,0,0,0,0,0,'3836-1;'),
(10988,'Art of Battle Axe - Landslide','','rhand','true',1570,1,1,'fine_steel','b',194,20,'blunt',4,4.00000,0,0,0,379,0,99,-1,-1,10091400,1346,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3885-1;'),
(10989,'Art of Battle Axe - Landslide','Health','rhand','true',1570,1,1,'fine_steel','b',194,20,'blunt',4,4.00000,0,0,0,379,0,99,-1,-1,10091400,1346,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3013-1;3885-1;'),
(10990,'Art of Battle Axe - Landslide','Rsk. Focus','rhand','true',1570,1,1,'fine_steel','b',194,20,'blunt',4,4.00000,0,0,0,379,0,99,-1,-1,10091400,1346,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3027-6;3885-1;'),
(10991,'Art of Battle Axe - Landslide','Haste','rhand','true',1570,1,1,'fine_steel','b',194,20,'blunt',4,4.00000,0,0,0,379,0,99,-1,-1,10091400,1346,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3036-5;3885-1;'),
(10992,'Demon Dagger - Great Gale','','rhand','true',970,1,1,'fine_steel','b',170,5,'dagger',12,-3.00000,0,0,0,433,0,99,-1,-1,10091400,1346,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3859-1;'),
(10993,'Demon Dagger - Great Gale','Critical Bleed','rhand','true',970,1,1,'fine_steel','b',170,5,'dagger',12,-3.00000,0,0,0,433,0,99,-1,-1,10091400,1346,'true','true','true','true','true',0,0,0,0,0,3020,6,12,0,'3859-1;'),
(10994,'Demon Dagger - Great Gale','Critical Poison','rhand','true',970,1,1,'fine_steel','b',170,5,'dagger',12,-3.00000,0,0,0,433,0,99,-1,-1,10091400,1346,'true','true','true','true','true',0,0,0,0,0,3041,6,3,0,'3859-1;'),
(10995,'Demon Dagger - Great Gale','Mortal Strike','rhand','true',970,1,1,'fine_steel','b',170,5,'dagger',12,-3.00000,0,0,0,433,0,99,-1,-1,10091400,1346,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3859-1;3035-6;'),
(10996,'Demon Dagger - Great Gale','Critical Damage','rhand','true',970,1,1,'fine_steel','b',170,5,'dagger',12,-3.00000,0,0,0,433,0,99,-1,-1,10091400,1346,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3859-1;3043-6;'),
(10997,'Kaim Vanul\'s Bones - Earth','','rhand','true',1570,1,1,'fine_steel','b',155,20,'blunt',4,4.00000,0,0,0,379,0,132,-1,-1,10091400,1346,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3884-1;'),
(10998,'Kaim Vanul\'s Bones - Earth','Mana Up','rhand','true',1570,1,1,'fine_steel','b',155,20,'blunt',4,4.00000,0,0,0,379,0,132,-1,-1,10091400,1346,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3884-1;3014-2;'),
(10999,'Kaim Vanul\'s Bones - Earth','Magic Silence','rhand','true',1570,1,1,'fine_steel','b',155,20,'blunt',4,4.00000,0,0,0,379,0,132,-1,-1,10091400,1346,'true','true','true','true','true',0,0,3078,3,10,0,0,0,0,'3884-1;'),
(11000,'Kaim Vanul\'s Bones - Earth','Conversion','rhand','true',1570,1,1,'fine_steel','b',155,20,'blunt',4,4.00000,0,0,0,379,0,132,-1,-1,10091400,1346,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3884-1;3048-1;'),
(11001,'Colichemarde - Earth','','rhand','true',1350,1,1,'fine_steel','b',176,40,'rapier',10,-1.00000,0,0,0,406,0,99,-1,-1,10091400,1346,'true','true','true','true','true',3426,1,0,0,0,0,0,0,10959,'3831-1;'),
(11002,'Colichemarde - Earth','Focus','rhand','true',1350,1,1,'fine_steel','b',176,40,'rapier',10,-1.00000,0,0,0,406,0,99,-1,-1,10091400,1346,'true','true','true','true','true',3426,1,0,0,0,0,0,0,10960,'3010-6;3831-1;'),
(11003,'Colichemarde - Earth','Critical Damage','rhand','true',1350,1,1,'fine_steel','b',176,40,'rapier',10,-1.00000,0,0,0,406,0,99,-1,-1,10091400,1346,'true','true','true','true','true',3426,1,0,0,0,0,0,0,10961,'3023-3;3831-1;'),
(11004,'Colichemarde - Earth','Haste','rhand','true',1350,1,1,'fine_steel','b',176,40,'rapier',10,-1.00000,0,0,0,406,0,99,-1,-1,10091400,1346,'true','true','true','true','true',3426,1,0,0,0,0,0,0,10962,'3037-6;3831-1;'),
(11005,'Wizard\'s Tear - Cleverness','','rhand','true',1350,1,1,'fine_steel','b',155,10,'sword',8,0.00000,0,0,0,379,0,132,-1,-1,10091400,1346,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3853-1;'),
(11006,'Wizard\'s Tear - Cleverness','Acumen','rhand','true',1350,1,1,'fine_steel','b',155,10,'sword',8,0.00000,0,0,0,379,0,132,-1,-1,10091400,1346,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3853-1;3047-1;'),
(11007,'Wizard\'s Tear - Cleverness','Magic Power','rhand','true',1350,1,1,'fine_steel','b',155,10,'sword',8,0.00000,0,0,0,379,0,132,-1,-1,10091400,1346,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3853-1;3077-6;'),
(11008,'Wizard\'s Tear - Cleverness','Conversion','rhand','true',1350,1,1,'fine_steel','b',155,10,'sword',8,0.00000,0,0,0,379,0,132,-1,-1,10091400,1346,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3853-1;3048-1;'),
(11009,'Bow of Peril - Earth','','lrhand','true',1700,3,1,'fine_steel','b',400,5,'bow',12,-3.00000,0,0,0,293,9,99,-1,-1,10091400,1346,'true','true','true','true','true',0,0,0,0,0,0,0,0,11013,'3867-1;'),
(11010,'Bow of Peril - Earth','Guidance','lrhand','true',1700,3,1,'fine_steel','b',400,5,'bow',12,-3.00000,0,0,0,293,9,99,-1,-1,10091400,1346,'true','true','true','true','true',0,0,0,0,0,0,0,0,11014,'3008-6;3867-1;'),
(11011,'Bow of Peril - Earth','Quick Recovery','lrhand','true',1700,3,1,'fine_steel','b',400,5,'bow',12,-3.00000,0,0,0,293,9,99,-1,-1,10091400,1346,'true','true','true','true','true',0,0,0,0,0,0,0,0,11015,'3867-1;'),
(11012,'Bow of Peril - Earth','Cheap Shot','lrhand','true',1700,3,1,'fine_steel','b',400,5,'bow',12,-3.00000,0,0,0,293,9,99,-1,-1,10091400,1346,'true','true','true','true','true',0,0,0,0,0,0,0,0,11016,'3867-1;'),
(11013,'Hell Hound - Earth','','rhand','true',1700,2,1,'fine_steel','b',245,10,'crossbow',10,-1.00000,0,0,0,303,0,99,-1,-1,10091400,1346,'true','true','true','true','true',0,0,0,0,0,0,0,0,11009,'3872-1;'),
(11014,'Hell Hound - Earth','Guidance','rhand','true',1700,2,1,'fine_steel','b',245,10,'crossbow',10,-1.00000,0,0,0,303,0,99,-1,-1,10091400,1346,'true','true','true','true','true',0,0,0,0,0,0,0,0,11010,'3008-6;3872-1;'),
(11015,'Hell Hound - Earth','Quick Recovery','rhand','true',1700,2,1,'fine_steel','b',245,10,'crossbow',10,-1.00000,0,0,0,303,0,99,-1,-1,10091400,1346,'true','true','true','true','true',0,0,0,0,0,0,0,0,11011,'3872-1;'),
(11016,'Hell Hound - Earth','Cheap Shot','rhand','true',1700,2,1,'fine_steel','b',245,10,'crossbow',10,-1.00000,0,0,0,303,0,99,-1,-1,10091400,1346,'true','true','true','true','true',0,0,0,0,0,0,0,0,11012,'3872-1;'),
(11017,'Dasparion\'s Staff - Hail','','lrhand','true',920,1,1,'fine_steel','a',207,20,'bigblunt',4,4.00000,0,0,0,325,0,157,-1,-1,14098000,1128,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3899-2;'),
(11018,'Dasparion\'s Staff - Hail','Mana Up','lrhand','true',920,1,1,'fine_steel','a',207,20,'bigblunt',4,4.00000,0,0,0,325,0,157,-1,-1,14098000,1128,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3014-2;3899-2;'),
(11019,'Dasparion\'s Staff - Hail','Conversion','lrhand','true',920,1,1,'fine_steel','a',207,20,'bigblunt',4,4.00000,0,0,0,325,0,157,-1,-1,14098000,1128,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3048-2;3899-2;'),
(11020,'Dasparion\'s Staff - Hail','Acumen','lrhand','true',920,1,1,'fine_steel','a',207,20,'bigblunt',4,4.00000,0,0,0,325,0,157,-1,-1,14098000,1128,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3047-2;3899-2;'),
(11021,'Doomchanter - Concentration','','rhand','true',1670,1,1,'fine_steel','a',270,10,'crossbow',10,-1.00000,0,0,0,303,0,107,-1,-1,14098000,1128,'true','true','true','true','true',0,0,0,0,0,0,0,0,11053,'3868-2;'),
(11022,'Doomchanter - Concentration','Light','rhand','true',1670,1,1,'fine_steel','a',270,10,'crossbow',10,-1.00000,0,0,0,303,0,107,-1,-1,14098000,1128,'true','true','true','true','true',0,0,0,0,0,0,0,0,11054,'3498-1;3868-2;'),
(11023,'Doomchanter - Concentration','Critical Bleed','rhand','true',1670,1,1,'fine_steel','a',270,10,'crossbow',10,-1.00000,0,0,0,303,0,107,-1,-1,14098000,1128,'true','true','true','true','true',0,0,0,0,0,3053,1,35,11055,'3552-1;3868-2;'),
(11024,'Doomchanter - Concentration','Mana Up','rhand','true',1670,1,1,'fine_steel','a',270,10,'crossbow',10,-1.00000,0,0,0,303,0,107,-1,-1,14098000,1128,'true','true','true','true','true',0,0,0,0,0,0,0,0,11056,'3014-2;3868-2;'),
(11025,'White Lightning - Destruction','','rhand','true',1330,1,1,'fine_steel','a',193,40,'rapier',10,-1.00000,0,0,0,406,0,107,-1,-1,14098000,1128,'true','true','true','true','true',3426,1,0,0,0,0,0,0,11058,'3830-2;'),
(11026,'White Lightning - Destruction','Critical Poison','rhand','true',1330,1,1,'fine_steel','a',193,40,'rapier',10,-1.00000,0,0,0,406,0,107,-1,-1,14098000,1128,'true','true','true','true','true',3426,1,0,0,0,3061,1,10,11059,'3552-1;3830-2;'),
(11027,'White Lightning - Destruction','Haste','rhand','true',1330,1,1,'fine_steel','a',193,40,'rapier',10,-1.00000,0,0,0,406,0,107,-1,-1,14098000,1128,'true','true','true','true','true',3426,1,0,0,0,0,0,0,11060,'3068-2;3830-2;'),
(11028,'White Lightning - Destruction','Anger','rhand','true',1330,1,1,'fine_steel','a',193,40,'rapier',10,-1.00000,0,0,0,406,0,107,-1,-1,14098000,1128,'true','true','true','true','true',3426,1,0,0,0,0,0,0,11061,'3057-2;3830-2;'),
(11029,'Meteor Shower - Earth','','rhand','true',1600,1,1,'fine_steel','a',213,20,'blunt',4,4.00000,0,0,0,379,0,107,-1,-1,14098000,1128,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3884-1;'),
(11030,'Meteor Shower - Earth','Focus','rhand','true',1600,1,1,'fine_steel','a',213,20,'blunt',4,4.00000,0,0,0,379,0,107,-1,-1,14098000,1128,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3050-1;3884-1;'),
(11031,'Meteor Shower - Earth','Critical Bleed','rhand','true',1600,1,1,'fine_steel','a',213,20,'blunt',4,4.00000,0,0,0,379,0,107,-1,-1,14098000,1128,'true','true','true','true','true',0,0,0,0,0,3052,1,42,0,'3552-1;3884-1;'),
(11032,'Meteor Shower - Earth','Rsk. Haste','rhand','true',1600,1,1,'fine_steel','a',213,20,'blunt',4,4.00000,0,0,0,379,0,107,-1,-1,14098000,1128,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3056-2;3884-1;'),
(11033,'Blood Tornado - Destruction','','lrhand','true',1370,1,1,'fine_steel','a',259,5,'dualfist',4,4.00000,0,0,0,325,0,107,-1,-1,14098000,1128,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3879-2;'),
(11034,'Blood Tornado - Destruction','Haste','lrhand','true',1370,1,1,'fine_steel','a',259,5,'dualfist',4,4.00000,0,0,0,325,0,107,-1,-1,14098000,1128,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3068-2;3879-2;'),
(11035,'Blood Tornado - Destruction','Focus','lrhand','true',1370,1,1,'fine_steel','a',259,5,'dualfist',4,4.00000,0,0,0,325,0,107,-1,-1,14098000,1128,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3050-1;3879-2;'),
(11036,'Blood Tornado - Destruction','Anger','lrhand','true',1370,1,1,'fine_steel','a',259,5,'dualfist',4,4.00000,0,0,0,325,0,107,-1,-1,14098000,1128,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3058-1;3879-2;'),
(11037,'Bloody Orchid - Confusion','','rhand','true',960,1,1,'fine_steel','a',186,5,'dagger',12,-3.00000,0,0,0,433,0,107,-1,-1,14098000,1128,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3858-2;'),
(11038,'Bloody Orchid - Confusion','Focus','rhand','true',960,1,1,'fine_steel','a',186,5,'dagger',12,-3.00000,0,0,0,433,0,107,-1,-1,14098000,1128,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3051-1;3858-2;'),
(11039,'Bloody Orchid - Confusion','Back Blow','rhand','true',960,1,1,'fine_steel','a',186,5,'dagger',12,-3.00000,0,0,0,433,0,107,-1,-1,14098000,1128,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3063-1;3858-2;'),
(11040,'Bloody Orchid - Confusion','Critical Bleed','rhand','true',960,1,1,'fine_steel','a',186,5,'dagger',12,-3.00000,0,0,0,433,0,107,-1,-1,14098000,1128,'true','true','true','true','true',0,0,0,0,0,3054,1,12,0,'3552-1;3858-2;'),
(11041,'Elemental Sword - Hail','','rhand','true',830,1,1,'fine_steel','a',170,10,'sword',8,0.00000,0,0,0,379,0,143,-1,-1,14098000,1128,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3854-1;'),
(11042,'Elemental Sword - Hail','Magic Power','rhand','true',830,1,1,'fine_steel','a',170,10,'sword',8,0.00000,0,0,0,379,0,143,-1,-1,14098000,1128,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3073-1;3854-1;'),
(11043,'Elemental Sword - Hail','Magic Paralyze','rhand','true',830,1,1,'fine_steel','a',170,10,'sword',8,0.00000,0,0,0,379,0,143,-1,-1,14098000,1128,'true','true','true','true','true',0,0,3075,1,5,0,0,0,0,'0-0;3854-1;'),
(11044,'Elemental Sword - Hail','Empower','rhand','true',830,1,1,'fine_steel','a',170,10,'sword',8,0.00000,0,0,0,379,0,143,-1,-1,14098000,1128,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3072-1;3854-1;'),
(11045,'Spiritual Eye - Hail','','rhand','true',1550,1,1,'fine_steel','a',170,20,'blunt',4,4.00000,0,0,0,379,0,143,-1,-1,14098000,1128,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3889-1;'),
(11046,'Spiritual Eye - Hail','Mana Up','rhand','true',1550,1,1,'fine_steel','a',170,20,'blunt',4,4.00000,0,0,0,379,0,143,-1,-1,14098000,1128,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3014-2;3889-1;'),
(11047,'Spiritual Eye - Hail','Magic Poison','rhand','true',1550,1,1,'fine_steel','a',170,20,'blunt',4,4.00000,0,0,0,379,0,143,-1,-1,14098000,1128,'true','true','true','true','true',0,0,1168,7,8,0,0,0,0,'3552-1;3889-1;'),
(11048,'Spiritual Eye - Hail','Acumen','rhand','true',1550,1,1,'fine_steel','a',170,20,'blunt',4,4.00000,0,0,0,379,0,143,-1,-1,14098000,1128,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3047-2;3889-1;'),
(11049,'Infernal Master - Concentration','','lrhand','true',1900,1,1,'fine_steel','a',259,10,'bigsword',8,0.00000,0,0,0,325,0,107,-1,-1,14098000,1128,'true','true','true','true','true',0,0,0,0,0,0,0,0,11066,'3841-1;'),
(11050,'Infernal Master - Concentration','Haste','lrhand','true',1900,1,1,'fine_steel','a',259,10,'bigsword',8,0.00000,0,0,0,325,0,107,-1,-1,14098000,1128,'true','true','true','true','true',0,0,0,0,0,0,0,0,11067,'3068-2;3841-1;'),
(11051,'Infernal Master - Concentration','Critical Damage','lrhand','true',1900,1,1,'fine_steel','a',259,10,'bigsword',8,0.00000,0,0,0,325,0,107,-1,-1,14098000,1128,'true','true','true','true','true',0,0,0,0,0,0,0,0,11068,'3067-1;3841-1;'),
(11052,'Infernal Master - Concentration','Focus','lrhand','true',1900,1,1,'fine_steel','a',259,10,'bigsword',8,0.00000,0,0,0,325,0,107,-1,-1,14098000,1128,'true','true','true','true','true',0,0,0,0,0,0,0,0,11069,'3050-2;3841-1;'),
(11053,'Carnage Bow - Concentration','','lrhand','true',1670,2,1,'fine_steel','a',440,5,'bow',12,-3.00000,0,0,0,293,9,107,-1,-1,14098000,1128,'true','true','true','true','true',0,0,0,0,0,0,0,0,11021,'3863-2;'),
(11054,'Carnage Bow - Concentration','Light','lrhand','true',900,2,1,'fine_steel','a',440,5,'bow',12,-3.00000,0,0,0,293,9,107,-1,-1,14098000,1128,'true','true','true','true','true',0,0,0,0,0,0,0,0,11022,'3498-1;3863-2;'),
(11055,'Carnage Bow - Concentration','Critical Bleed','lrhand','true',1670,2,1,'fine_steel','a',440,5,'bow',12,-3.00000,0,0,0,293,9,107,-1,-1,14098000,1128,'true','true','true','true','true',0,0,0,0,0,3053,1,35,11023,'3552-1;3863-2;'),
(11056,'Carnage Bow - Concentration','Mana Up','lrhand','true',1670,2,1,'fine_steel','a',440,5,'bow',12,-3.00000,0,0,0,293,9,107,-1,-1,14098000,1128,'true','true','true','true','true',0,0,0,0,0,0,0,0,11024,'3014-2;3863-2;'),
(11057,'Keshanberk*Keshanberk - Destruction','','lrhand','true',2080,1,1,'fine_steel','a',259,10,'dual',8,0.00000,0,0,0,325,0,107,-1,-1,14098000,1128,'true','true','true','true','true',3045,17,0,0,0,0,0,0,0,'3835-2;'),
(11058,'Tallum Blade - Destruction','','rhand','true',1330,1,1,'fine_steel','a',213,10,'sword',8,0.00000,0,0,0,379,0,107,-1,-1,14098000,1128,'true','true','true','true','true',0,0,0,0,0,0,0,0,11025,'3825-2;'),
(11059,'Tallum Blade - Destruction','Critical Poison','rhand','true',1330,1,1,'fine_steel','a',213,10,'sword',8,0.00000,0,0,0,379,0,107,-1,-1,14098000,1128,'true','true','true','true','true',0,0,0,0,0,3061,1,10,11026,'3552-1;3825-2;'),
(11060,'Tallum Blade - Destruction','Haste','rhand','true',1330,1,1,'fine_steel','a',213,10,'sword',8,0.00000,0,0,0,379,0,107,-1,-1,14098000,1128,'true','true','true','true','true',0,0,0,0,0,0,0,0,11027,'3068-2;3825-2;'),
(11061,'Tallum Blade - Destruction','Anger','rhand','true',1330,1,1,'fine_steel','a',213,10,'sword',8,0.00000,0,0,0,379,0,107,-1,-1,14098000,1128,'true','true','true','true','true',0,0,0,0,0,0,0,0,11028,'3057-1;3825-2;'),
(11062,'Destroyer Hammer - Lightning','','lrhand','true',1910,1,1,'fine_steel','a',259,20,'bigblunt',4,4.00000,0,0,0,325,0,107,-1,-1,14098000,1128,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3895-2;'),
(11063,'Destroyer Hammer - Lightning','Health','lrhand','true',1910,1,1,'fine_steel','a',259,20,'bigblunt',4,4.00000,0,0,0,325,0,107,-1,-1,14098000,1128,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3013-3;3895-2;'),
(11064,'Destroyer Hammer - Lightning','Haste','lrhand','true',1910,1,1,'fine_steel','a',259,20,'bigblunt',4,4.00000,0,0,0,325,0,107,-1,-1,14098000,1128,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3068-2;3895-2;'),
(11065,'Destroyer Hammer - Lightning','Critical Drain','lrhand','true',1910,1,1,'fine_steel','a',259,20,'bigblunt',4,4.00000,0,0,0,325,0,107,-1,-1,14098000,1128,'true','true','true','true','true',0,0,0,0,0,3059,1,0,0,'3552-1;3895-2;'),
(11066,'Divine Pain - Concentration','','lrhand','true',1900,1,1,'fine_steel','a',231,15,'ancient',8,2.00000,0,0,0,350,0,107,-1,-1,14098000,1128,'true','true','true','true','true',0,0,0,0,0,0,0,0,11049,'3847-1;'),
(11067,'Divine Pain - Concentration','Haste','lrhand','true',1900,1,1,'fine_steel','a',231,15,'ancient',8,2.00000,0,0,0,350,0,107,-1,-1,14098000,1128,'true','true','true','true','true',0,0,0,0,0,0,0,0,11050,'3068-2;3847-1;'),
(11068,'Divine Pain - Concentration','Critical Damage','lrhand','true',1900,1,1,'fine_steel','a',231,15,'ancient',8,2.00000,0,0,0,350,0,107,-1,-1,14098000,1128,'true','true','true','true','true',0,0,0,0,0,0,0,0,11051,'3067-1;3847-1;'),
(11069,'Divine Pain - Concentration','Focus','lrhand','true',1900,1,1,'fine_steel','a',231,15,'ancient',8,2.00000,0,0,0,350,0,107,-1,-1,14098000,1128,'true','true','true','true','true',0,0,0,0,0,0,0,0,11052,'3050-2;3847-1;'),
(11070,'Halberd - Lightning','','lrhand','true',1900,1,1,'fine_steel','a',213,10,'pole',8,-3.00000,0,0,0,325,0,107,-1,-1,14098000,1128,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3599-1;3874-1;'),
(11071,'Halberd - Lightning','Haste','lrhand','true',1900,1,1,'fine_steel','a',213,10,'pole',8,-3.00000,0,0,0,325,0,107,-1,-1,14098000,1128,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3601-8;3874-1;'),
(11072,'Halberd - Lightning','Critical Stun','lrhand','true',1900,1,1,'fine_steel','a',213,10,'pole',8,-3.00000,0,0,0,325,0,107,-1,-1,14098000,1128,'true','true','true','true','true',0,0,0,0,0,3070,1,25,0,'3552-2;3874-1;'),
(11073,'Halberd - Lightning','Wide Blow','lrhand','true',1900,1,1,'fine_steel','a',213,10,'pole',8,-3.00000,0,0,0,325,0,107,-1,-1,14098000,1128,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3552-2;3874-1;'),
(11074,'Keshanberk*Damascus - Destruction','','lrhand','true',2080,1,1,'fine_steel','a',275,10,'dual',8,0.00000,0,0,0,325,0,112,-1,-1,18567400,1485,'true','true','true','true','true',3013,3,0,0,0,0,0,0,0,'3835-2;'),
(11075,'Lacerator - Thunder','','rhand','true',1320,1,1,'fine_steel','a',210,40,'rapier',10,-1.00000,0,0,0,406,0,114,-1,-1,20741000,1659,'true','true','true','true','true',3426,1,0,0,0,0,0,0,11080,'3832-1;'),
(11076,'Lacerator - Thunder','Critical Damage','rhand','true',1320,1,1,'fine_steel','a',210,40,'rapier',10,-1.00000,0,0,0,406,0,114,-1,-1,20741000,1659,'true','true','true','true','true',3426,1,0,0,0,0,0,0,11081,'3067-2;3832-1;'),
(11077,'Lacerator - Thunder','Health','rhand','true',1320,1,1,'fine_steel','a',210,40,'rapier',10,-1.00000,0,0,0,406,0,114,-1,-1,20741000,1659,'true','true','true','true','true',3426,1,0,0,0,0,0,0,11082,'3013-3;3832-1;'),
(11078,'Lacerator - Thunder','Rsk. Focus','rhand','true',1320,1,1,'fine_steel','a',210,40,'rapier',10,-1.00000,0,0,0,406,0,114,-1,-1,20741000,1659,'true','true','true','true','true',3426,1,0,0,0,0,0,0,11083,'3071-2;3832-1;'),
(11079,'Damascus*Damascus - Thunder','','lrhand','true',2080,1,1,'fine_steel','a',282,10,'dual',8,0.00000,0,0,0,325,0,114,-1,-1,20741000,1659,'true','true','true','true','true',3046,17,0,0,0,0,0,0,0,'3837-1;'),
(11080,'Dark Legion - Thunder','','rhand','true',1320,1,1,'fine_steel','a',232,10,'sword',8,0.00000,0,0,0,379,0,114,-1,-1,20741000,1659,'true','true','true','true','true',0,0,0,0,0,0,0,0,11075,'3827-1;'),
(11081,'Dark Legion - Thunder','Critical Damage','rhand','true',1320,1,1,'fine_steel','a',232,10,'sword',8,0.00000,0,0,0,379,0,114,-1,-1,20741000,1659,'true','true','true','true','true',0,0,0,0,0,0,0,0,11076,'3067-2;3827-1;'),
(11082,'Dark Legion - Thunder','Health','rhand','true',1320,1,1,'fine_steel','a',232,10,'sword',8,0.00000,0,0,0,379,0,114,-1,-1,20741000,1659,'true','true','true','true','true',0,0,0,0,0,0,0,0,11077,'3013-3;3827-1;'),
(11083,'Dark Legion - Thunder','Rsk. Focus','rhand','true',1320,1,1,'fine_steel','a',232,10,'sword',8,0.00000,0,0,0,379,0,114,-1,-1,20741000,1659,'true','true','true','true','true',0,0,0,0,0,0,0,0,11078,'3071-2;3827-1;'),
(11084,'Undertaker - Evil Spirit','','lrhand','true',1840,1,1,'fine_steel','a',251,15,'ancient',8,2.00000,0,0,0,350,0,114,-1,-1,20741000,1659,'true','true','true','true','true',0,0,0,0,0,0,0,0,11096,'3848-1;'),
(11085,'Undertaker - Evil Spirit','Health','lrhand','true',1840,1,1,'fine_steel','a',251,15,'ancient',8,2.00000,0,0,0,350,0,114,-1,-1,20741000,1659,'true','true','true','true','true',0,0,0,0,0,0,0,0,11097,'3013-3;3848-1;'),
(11086,'Undertaker - Evil Spirit','Critical Bleed','lrhand','true',1840,1,1,'fine_steel','a',251,15,'ancient',8,2.00000,0,0,0,350,0,114,-1,-1,20741000,1659,'true','true','true','true','true',0,0,0,0,0,3055,2,24,11098,'3552-1;3848-1;'),
(11087,'Undertaker - Evil Spirit','Critical Drain','lrhand','true',1840,1,1,'fine_steel','a',251,15,'ancient',8,2.00000,0,0,0,350,0,114,-1,-1,20741000,1659,'true','true','true','true','true',0,0,0,0,0,3060,2,33,11099,'3552-1;3848-1;'),
(11088,'Doom Crusher - Thunder','','lrhand','true',1900,1,1,'fine_steel','a',282,20,'bigblunt',4,4.00000,0,0,0,325,0,114,-1,-1,20741000,1659,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3894-1;'),
(11089,'Doom Crusher - Thunder','Health','lrhand','true',1900,1,1,'fine_steel','a',282,20,'bigblunt',4,4.00000,0,0,0,325,0,114,-1,-1,20741000,1659,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3013-3;3894-1;'),
(11090,'Doom Crusher - Thunder','Anger','lrhand','true',1900,1,1,'fine_steel','a',282,20,'bigblunt',4,4.00000,0,0,0,325,0,114,-1,-1,20741000,1659,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3057-2;3894-1;'),
(11091,'Doom Crusher - Thunder','Rsk. Haste','lrhand','true',1900,1,1,'fine_steel','a',282,20,'bigblunt',4,4.00000,0,0,0,325,0,114,-1,-1,20741000,1659,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3056-2;3894-1;'),
(11092,'Dragon Grinder - Earth','','lrhand','true',1350,1,1,'fine_steel','a',282,5,'dualfist',4,4.00000,0,0,0,325,0,114,-1,-1,20741000,1659,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3881-1;'),
(11093,'Dragon Grinder - Earth','Rsk. Evasion','lrhand','true',1350,1,1,'fine_steel','a',282,5,'dualfist',4,4.00000,0,0,0,325,0,114,-1,-1,20741000,1659,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3069-1;3881-1;'),
(11094,'Dragon Grinder - Earth','Guidance','lrhand','true',1350,1,1,'fine_steel','a',282,5,'dualfist',4,4.00000,0,0,0,325,0,114,-1,-1,20741000,1659,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3065-1;3881-1;'),
(11095,'Dragon Grinder - Earth','Health','lrhand','true',1350,1,1,'fine_steel','a',282,5,'dualfist',4,4.00000,0,0,0,325,0,114,-1,-1,20741000,1659,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3013-3;3881-1;'),
(11096,'Dragon Slayer - Evil Spirit','','lrhand','true',1840,1,1,'fine_steel','a',282,10,'bigsword',8,0.00000,0,0,0,325,0,114,-1,-1,20741000,1659,'true','true','true','true','true',0,0,0,0,0,0,0,0,11084,'3842-1;'),
(11097,'Dragon Slayer - Evil Spirit','Health','lrhand','true',1840,1,1,'fine_steel','a',282,10,'bigsword',8,0.00000,0,0,0,325,0,114,-1,-1,20741000,1659,'true','true','true','true','true',0,0,0,0,0,0,0,0,11085,'3013-3;3842-1;'),
(11098,'Dragon Slayer - Evil Spirit','Critical Bleed','lrhand','true',1840,1,1,'fine_steel','a',282,10,'bigsword',8,0.00000,0,0,0,325,0,114,-1,-1,20741000,1659,'true','true','true','true','true',0,0,0,0,0,3055,2,24,11086,'3552-1;3842-1;'),
(11099,'Dragon Slayer - Evil Spirit','Critical Drain','lrhand','true',1840,1,1,'fine_steel','a',282,10,'bigsword',8,0.00000,0,0,0,325,0,114,-1,-1,20741000,1659,'true','true','true','true','true',0,0,0,0,0,3060,2,33,11087,'3552-1;3842-1;'),
(11100,'Flaming Dragon Skull - Wisdom','','rhand','true',1530,1,1,'fine_steel','a',186,20,'blunt',4,4.00000,0,0,0,379,0,152,-1,-1,20741000,1659,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3892-1;'),
(11101,'Flaming Dragon Skull - Wisdom','Acumen','rhand','true',1530,1,1,'fine_steel','a',186,20,'blunt',4,4.00000,0,0,0,379,0,152,-1,-1,20741000,1659,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3047-2;3892-1;'),
(11102,'Flaming Dragon Skull - Wisdom','Magic Power','rhand','true',1530,1,1,'fine_steel','a',186,20,'blunt',4,4.00000,0,0,0,379,0,152,-1,-1,20741000,1659,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3073-1;3892-1;'),
(11103,'Flaming Dragon Skull - Wisdom','Magic Silence','rhand','true',1530,1,1,'fine_steel','a',186,20,'blunt',4,4.00000,0,0,0,379,0,152,-1,-1,20741000,1659,'true','true','true','true','true',0,0,3074,2,10,0,0,0,0,'3552-1;3892-1;'),
(11104,'Branch of the Mother Tree - Nature','','lrhand','true',900,1,1,'fine_steel','a',226,20,'bigblunt',4,4.00000,0,0,0,325,0,167,-1,-1,20741000,1659,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3901-1;'),
(11105,'Branch of the Mother Tree - Nature','Conversion','lrhand','true',900,1,1,'fine_steel','a',226,20,'bigblunt',4,4.00000,0,0,0,325,0,167,-1,-1,20741000,1659,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3048-2;3901-1;'),
(11106,'Branch of the Mother Tree - Nature','Magic Damage','lrhand','true',900,1,1,'fine_steel','a',226,20,'bigblunt',4,4.00000,0,0,0,325,0,167,-1,-1,20741000,1659,'true','true','true','true','true',0,0,3049,2,30,0,0,0,0,'3552-1;3901-1;'),
(11107,'Branch of the Mother Tree - Nature','Acumen','lrhand','true',900,1,1,'fine_steel','a',226,20,'bigblunt',4,4.00000,0,0,0,325,0,167,-1,-1,20741000,1659,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3047-2;3901-1;'),
(11108,'Sword of Miracles - Holy Spirit','','rhand','true',840,1,1,'fine_steel','a',186,10,'sword',8,0.00000,0,0,0,379,0,152,-1,-1,20741000,1659,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3856-1;'),
(11109,'Sword of Miracles - Holy Spirit','Magic Power','rhand','true',840,1,1,'fine_steel','a',186,10,'sword',8,0.00000,0,0,0,379,0,152,-1,-1,20741000,1659,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3073-2;3856-1;'),
(11110,'Sword of Miracles - Holy Spirit','Magic Silence','rhand','true',840,1,1,'fine_steel','a',186,10,'sword',8,0.00000,0,0,0,379,0,152,-1,-1,20741000,1659,'true','true','true','true','true',0,0,3074,2,10,0,0,0,0,'3552-1;3856-1;'),
(11111,'Sword of Miracles - Holy Spirit','Acumen','rhand','true',840,1,1,'fine_steel','a',186,10,'sword',8,0.00000,0,0,0,379,0,152,-1,-1,20741000,1659,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3047-2;3856-1;'),
(11112,'Reaper - Clairvoyance','','rhand','true',1660,1,1,'fine_steel','a',294,10,'crossbow',10,-1.00000,0,0,0,303,0,114,-1,-1,20741000,1659,'true','true','true','true','true',0,0,0,0,0,0,0,0,11124,'3870-1;'),
(11113,'Reaper - Clairvoyance','Cheap Shot','rhand','true',1660,1,1,'fine_steel','a',294,10,'crossbow',10,-1.00000,0,0,0,303,0,114,-1,-1,20741000,1659,'true','true','true','true','true',0,0,0,0,0,0,0,0,11125,'3552-1;3870-1;'),
(11114,'Reaper - Clairvoyance','Quick Recovery','rhand','true',1660,1,1,'fine_steel','a',294,10,'crossbow',10,-1.00000,0,0,0,303,0,114,-1,-1,20741000,1659,'true','true','true','true','true',0,0,0,0,0,0,0,0,11126,'3552-1;3870-1;'),
(11115,'Reaper - Clairvoyance','Critical Poison','rhand','true',1660,1,1,'fine_steel','a',294,10,'crossbow',10,-1.00000,0,0,0,303,0,114,-1,-1,20741000,1659,'true','true','true','true','true',0,0,0,0,0,3062,2,18,11127,'3552-1;3870-1;'),
(11116,'Soul Separator - On Fire','','rhand','true',950,1,1,'fine_steel','a',203,5,'dagger',12,-3.00000,0,0,0,433,0,114,-1,-1,20741000,1659,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3860-1;'),
(11117,'Soul Separator - On Fire','Guidance','rhand','true',950,1,1,'fine_steel','a',203,5,'dagger',12,-3.00000,0,0,0,433,0,114,-1,-1,20741000,1659,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3064-1;3860-1;'),
(11118,'Soul Separator - On Fire','Critical Damage','rhand','true',950,1,1,'fine_steel','a',203,5,'dagger',12,-3.00000,0,0,0,433,0,114,-1,-1,20741000,1659,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3066-1;3860-1;'),
(11119,'Soul Separator - On Fire','Rsk. Haste','rhand','true',950,1,1,'fine_steel','a',203,5,'dagger',12,-3.00000,0,0,0,433,0,114,-1,-1,20741000,1659,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3056-2;3860-1;'),
(11120,'Elysian - Great Gale','','rhand','true',1580,1,1,'fine_steel','a',232,20,'blunt',4,4.00000,0,0,0,379,0,114,-1,-1,20741000,1659,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3886-1;'),
(11121,'Elysian - Great Gale','Health','rhand','true',1580,1,1,'fine_steel','a',232,20,'blunt',4,4.00000,0,0,0,379,0,114,-1,-1,20741000,1659,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3013-3;3886-1;'),
(11122,'Elysian - Great Gale','Anger','rhand','true',1580,1,1,'fine_steel','a',232,20,'blunt',4,4.00000,0,0,0,379,0,114,-1,-1,20741000,1659,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3057-2;3886-1;'),
(11123,'Elysian - Great Gale','Critical Drain','rhand','true',1580,1,1,'fine_steel','a',232,20,'blunt',4,4.00000,0,0,0,379,0,114,-1,-1,20741000,1659,'true','true','true','true','true',0,0,0,0,0,3059,2,33,0,'3552-1;3886-1;'),
(11124,'Soul Bow - Clairvoyance','','lrhand','true',1660,2,1,'fine_steel','a',528,5,'bow',12,-3.00000,0,0,0,227,10,125,-1,-1,20741000,1659,'true','true','true','true','true',0,0,0,0,0,0,0,0,11112,'3865-1;'),
(11125,'Soul Bow - Clairvoyance','Cheap Shot','lrhand','true',1660,2,1,'fine_steel','a',528,5,'bow',12,-3.00000,0,0,0,227,10,125,-1,-1,20741000,1659,'true','true','true','true','true',0,0,0,0,0,0,0,0,11113,'3552-1;3865-1;'),
(11126,'Soul Bow - Clairvoyance','Quick Recovery','lrhand','true',1660,2,1,'fine_steel','a',528,5,'bow',12,-3.00000,0,0,0,227,10,125,-1,-1,20741000,1659,'true','true','true','true','true',0,0,0,0,0,0,0,0,11114,'3552-1;3865-1;'),
(11127,'Soul Bow - Clairvoyance','Critical Poison','lrhand','true',1660,2,1,'fine_steel','a',528,5,'bow',12,-3.00000,0,0,0,227,10,125,-1,-1,20741000,1659,'true','true','true','true','true',0,0,0,0,0,3062,2,18,11115,'3552-1;3865-1;'),
(11128,'Tallum Glaive - On Fire','','lrhand','true',1840,1,1,'fine_steel','a',232,10,'pole',8,-3.00000,0,0,0,325,0,114,-1,-1,20741000,1659,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3599-1;3877-1;'),
(11129,'Tallum Glaive - On Fire','Guidance','lrhand','true',1840,1,1,'fine_steel','a',232,10,'pole',8,-3.00000,0,0,0,325,0,114,-1,-1,20741000,1659,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3602-8;3877-1;'),
(11130,'Tallum Glaive - On Fire','Health','lrhand','true',1840,1,1,'fine_steel','a',232,10,'pole',8,-3.00000,0,0,0,325,0,114,-1,-1,20741000,1659,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3013-4;3877-1;'),
(11131,'Tallum Glaive - On Fire','Wide Blow','lrhand','true',1840,1,1,'fine_steel','a',232,10,'pole',8,-3.00000,0,0,0,325,0,114,-1,-1,20741000,1659,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3552-2;3877-1;'),
(11132,'Enchanted Cerberus Fang','','greatwolf','false',100,0,0,'wood','none',413,10,'pet',8,0.00000,0,0,0,277,0,5,-1,-1,21159000,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11133,'Naga Storm - Molar','','rhand','true',930,1,1,'fine_steel','a',220,5,'dagger',12,-3.00000,0,0,0,433,0,121,-1,-1,26968400,2157,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3861-1;'),
(11134,'Naga Storm - Molar','Focus','rhand','true',930,1,1,'fine_steel','a',220,5,'dagger',12,-3.00000,0,0,0,433,0,121,-1,-1,26968400,2157,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3051-1;3861-1;'),
(11135,'Naga Storm - Molar','Critical Damage','rhand','true',930,1,1,'fine_steel','a',220,5,'dagger',12,-3.00000,0,0,0,433,0,121,-1,-1,26968400,2157,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3066-1;3861-1;'),
(11136,'Naga Storm - Molar','Back Blow','rhand','true',930,1,1,'fine_steel','a',220,5,'dagger',12,-3.00000,0,0,0,433,0,121,-1,-1,26968400,2157,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3019-6;3861-1;'),
(11137,'Daimon Crystal - Wisdom','','lrhand','true',880,1,1,'fine_steel','a',245,20,'bigblunt',4,4.00000,0,0,0,325,0,177,-1,-1,26968400,2157,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3902-1;'),
(11138,'Daimon Crystal - Wisdom','Mana Up','lrhand','true',880,1,1,'fine_steel','a',245,20,'bigblunt',4,4.00000,0,0,0,325,0,177,-1,-1,26968400,2157,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3014-2;3902-1;'),
(11139,'Daimon Crystal - Wisdom','Acumen','lrhand','true',880,1,1,'fine_steel','a',245,20,'bigblunt',4,4.00000,0,0,0,325,0,177,-1,-1,26968400,2157,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3047-2;3902-1;'),
(11140,'Daimon Crystal - Wisdom','Magic Mental Shield','lrhand','true',880,1,1,'fine_steel','a',245,20,'bigblunt',4,4.00000,0,0,0,325,0,177,-1,-1,26968400,2157,'true','true','true','true','true',0,0,1035,2,50,0,0,0,0,'3552-1;3902-1;'),
(11141,'Barakiel\'s Axe - On Fire','','rhand','true',1550,1,1,'fine_steel','a',251,20,'blunt',4,4.00000,0,0,0,379,0,121,-1,-1,26968400,2157,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3887-1;'),
(11142,'Barakiel\'s Axe - On Fire','Health','rhand','true',1550,1,1,'fine_steel','a',251,20,'blunt',4,4.00000,0,0,0,379,0,121,-1,-1,26968400,2157,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3013-3;3887-1;'),
(11143,'Barakiel\'s Axe - On Fire','Haste','rhand','true',1550,1,1,'fine_steel','a',251,20,'blunt',4,4.00000,0,0,0,379,0,121,-1,-1,26968400,2157,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3068-2;3887-1;'),
(11144,'Barakiel\'s Axe - On Fire','Focus','rhand','true',1550,1,1,'fine_steel','a',251,20,'blunt',4,4.00000,0,0,0,379,0,121,-1,-1,26968400,2157,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3050-2;3887-1;'),
(11145,'Screaming Vengeance - Concentration','','rhand','true',1640,1,1,'fine_steel','a',318,10,'crossbow',10,-1.00000,0,0,0,303,0,121,-1,-1,26968400,2157,'true','true','true','true','true',0,0,0,0,0,0,0,0,11157,'3868-2;'),
(11146,'Screaming Vengeance - Concentration','Cheap Shot','rhand','true',1640,1,1,'fine_steel','a',318,10,'crossbow',10,-1.00000,0,0,0,303,0,121,-1,-1,26968400,2157,'true','true','true','true','true',0,0,0,0,0,0,0,0,11158,'3552-1;3868-2;'),
(11147,'Screaming Vengeance - Concentration','Focus','rhand','true',1640,1,1,'fine_steel','a',318,10,'crossbow',10,-1.00000,0,0,0,303,0,121,-1,-1,26968400,2157,'true','true','true','true','true',0,0,0,0,0,0,0,0,11159,'3050-2;3868-2;'),
(11148,'Screaming Vengeance - Concentration','Quick Recovery','rhand','true',1640,1,1,'fine_steel','a',318,10,'crossbow',10,-1.00000,0,0,0,303,0,121,-1,-1,26968400,2157,'true','true','true','true','true',0,0,0,0,0,0,0,0,11160,'3552-1;3868-2;'),
(11149,'Behemoth\'s Tuning Fork - Destruction','','lrhand','true',1890,1,1,'fine_steel','a',305,20,'bigblunt',4,4.00000,0,0,0,325,0,121,-1,-1,26968400,2157,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3897-1;'),
(11150,'Behemoth\'s Tuning Fork - Destruction','Focus','lrhand','true',1890,1,1,'fine_steel','a',305,20,'bigblunt',4,4.00000,0,0,0,325,0,121,-1,-1,26968400,2157,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3050-2;3897-1;'),
(11151,'Behemoth\'s Tuning Fork - Destruction','Health','lrhand','true',1890,1,1,'fine_steel','a',305,20,'bigblunt',4,4.00000,0,0,0,325,0,121,-1,-1,26968400,2157,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3013-3;3897-1;'),
(11152,'Behemoth\'s Tuning Fork - Destruction','Anger','lrhand','true',1890,1,1,'fine_steel','a',305,20,'bigblunt',4,4.00000,0,0,0,325,0,121,-1,-1,26968400,2157,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3057-2;3897-1;'),
(11153,'Bultgang - Earth','','lrhand','true',1820,1,1,'fine_steel','a',272,15,'ancient',8,2.00000,0,0,0,350,0,121,-1,-1,26968400,2157,'true','true','true','true','true',0,0,0,0,0,0,0,0,11161,'3849-1;'),
(11154,'Bultgang - Earth','Focus','lrhand','true',1820,1,1,'fine_steel','a',272,15,'ancient',8,2.00000,0,0,0,350,0,121,-1,-1,26968400,2157,'true','true','true','true','true',0,0,0,0,0,0,0,0,11162,'3050-2;3849-1;'),
(11155,'Bultgang - Earth','Haste','lrhand','true',1820,1,1,'fine_steel','a',272,15,'ancient',8,2.00000,0,0,0,350,0,121,-1,-1,26968400,2157,'true','true','true','true','true',0,0,0,0,0,0,0,0,11163,'3068-2;3849-1;'),
(11156,'Bultgang - Earth','Health','lrhand','true',1820,1,1,'fine_steel','a',272,15,'ancient',8,2.00000,0,0,0,350,0,121,-1,-1,26968400,2157,'true','true','true','true','true',0,0,0,0,0,0,0,0,11164,'3013-3;3849-1;'),
(11157,'Shyeed\'s Bow - Concentration','','lrhand','true',1640,2,1,'fine_steel','a',570,5,'bow',12,-3.00000,0,0,0,227,10,133,-1,-1,26968400,2157,'true','true','true','true','true',0,0,0,0,0,0,0,0,11145,'3863-2;'),
(11158,'Shyeed\'s Bow - Concentration','Cheap Shot','lrhand','true',1640,2,1,'fine_steel','a',570,5,'bow',12,-3.00000,0,0,0,227,10,133,-1,-1,26968400,2157,'true','true','true','true','true',0,0,0,0,0,0,0,0,11146,'3552-1;3863-2;'),
(11159,'Shyeed\'s Bow - Concentration','Focus','lrhand','true',1640,2,1,'fine_steel','a',570,5,'bow',12,-3.00000,0,0,0,227,10,133,-1,-1,26968400,2157,'true','true','true','true','true',0,0,0,0,0,0,0,0,11147,'3050-2;3863-2;'),
(11160,'Shyeed\'s Bow - Concentration','Quick Recovery','lrhand','true',1640,2,1,'fine_steel','a',570,5,'bow',12,-3.00000,0,0,0,227,10,133,-1,-1,26968400,2157,'true','true','true','true','true',0,0,0,0,0,0,0,0,11148,'3552-1;3863-2;'),
(11161,'Sword of Ipos - Earth','','lrhand','true',1820,1,1,'fine_steel','a',305,10,'bigsword',8,0.00000,0,0,0,325,0,121,-1,-1,26968400,2157,'true','true','true','true','true',0,0,0,0,0,0,0,0,11153,'3843-1;'),
(11162,'Sword of Ipos - Earth','Focus','lrhand','true',1820,1,1,'fine_steel','a',305,10,'bigsword',8,0.00000,0,0,0,325,0,121,-1,-1,26968400,2157,'true','true','true','true','true',0,0,0,0,0,0,0,0,11154,'3050-2;3843-1;'),
(11163,'Sword of Ipos - Earth','Haste','lrhand','true',1820,1,1,'fine_steel','a',305,10,'bigsword',8,0.00000,0,0,0,325,0,121,-1,-1,26968400,2157,'true','true','true','true','true',0,0,0,0,0,0,0,0,11155,'3068-2;3843-1;'),
(11164,'Sword of Ipos - Earth','Health','lrhand','true',1820,1,1,'fine_steel','a',305,10,'bigsword',8,0.00000,0,0,0,325,0,121,-1,-1,26968400,2157,'true','true','true','true','true',0,0,0,0,0,0,0,0,11156,'3013-3;3843-1;'),
(11165,'Sobekk\'s Hurricane - Landslide','','lrhand','true',1330,1,1,'fine_steel','a',305,5,'dualfist',4,4.00000,0,0,0,325,0,121,-1,-1,26968400,2157,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3882-1;'),
(11166,'Sobekk\'s Hurricane - Landslide','Rsk. Haste','lrhand','true',1330,1,1,'fine_steel','a',305,5,'dualfist',4,4.00000,0,0,0,325,0,121,-1,-1,26968400,2157,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3056-2;3882-1;'),
(11167,'Sobekk\'s Hurricane - Landslide','Haste','lrhand','true',1330,1,1,'fine_steel','a',305,5,'dualfist',4,4.00000,0,0,0,325,0,121,-1,-1,26968400,2157,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3068-2;3882-1;'),
(11168,'Sobekk\'s Hurricane - Landslide','Critical Drain','lrhand','true',1330,1,1,'fine_steel','a',305,5,'dualfist',4,4.00000,0,0,0,325,0,121,-1,-1,26968400,2157,'true','true','true','true','true',0,0,0,0,0,3039,6,33,0,'3552-1;3882-1;'),
(11169,'Sirra\'s Blade - Landslide','','rhand','true',1300,1,1,'fine_steel','a',251,10,'sword',8,0.00000,0,0,0,379,0,121,-1,-1,26968400,2157,'true','true','true','true','true',0,0,0,0,0,0,0,0,11173,'3829-1;'),
(11170,'Sirra\'s Blade - Landslide','Haste','rhand','true',1300,1,1,'fine_steel','a',251,10,'sword',8,0.00000,0,0,0,379,0,121,-1,-1,26968400,2157,'true','true','true','true','true',0,0,0,0,0,0,0,0,11174,'3068-2;3829-1;'),
(11171,'Sirra\'s Blade - Landslide','Health','rhand','true',1300,1,1,'fine_steel','a',251,10,'sword',8,0.00000,0,0,0,379,0,121,-1,-1,26968400,2157,'true','true','true','true','true',0,0,0,0,0,0,0,0,11175,'3013-3;3829-1;'),
(11172,'Sirra\'s Blade - Landslide','Critical Poison','rhand','true',1300,1,1,'fine_steel','a',251,10,'sword',8,0.00000,0,0,0,379,0,121,-1,-1,26968400,2157,'true','true','true','true','true',0,0,0,0,0,3061,3,15,11176,'3552-1;3829-1;'),
(11173,'Eclair Bijou - Landslide','','rhand','true',1300,1,1,'fine_steel','a',228,40,'rapier',10,-1.00000,0,0,0,406,0,121,-1,-1,26968400,2157,'true','true','true','true','true',3426,1,0,0,0,0,0,0,11169,'3834-1;'),
(11174,'Eclair Bijou - Landslide','Haste','rhand','true',1300,1,1,'fine_steel','a',228,40,'rapier',10,-1.00000,0,0,0,406,0,121,-1,-1,26968400,2157,'true','true','true','true','true',3426,1,0,0,0,0,0,0,11170,'3068-2;3834-1;'),
(11175,'Eclair Bijou - Landslide','Health','rhand','true',1300,1,1,'fine_steel','a',228,40,'rapier',10,-1.00000,0,0,0,406,0,121,-1,-1,26968400,2157,'true','true','true','true','true',3426,1,0,0,0,0,0,0,11171,'3013-3;3834-1;'),
(11176,'Eclair Bijou - Landslide','Critical Poison','rhand','true',1300,1,1,'fine_steel','a',228,40,'rapier',10,-1.00000,0,0,0,406,0,121,-1,-1,26968400,2157,'true','true','true','true','true',3426,1,0,0,0,3061,3,15,11172,'3552-1;3834-1;'),
(11177,'Tiphon\'s Spear - Landslide','','lrhand','true',1820,1,1,'fine_steel','a',251,10,'pole',8,-3.00000,0,0,0,325,0,121,-1,-1,26968400,2157,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3599-1;3876-1;'),
(11178,'Tiphon\'s Spear - Landslide','Critical Stun','lrhand','true',1820,1,1,'fine_steel','a',251,10,'pole',8,-3.00000,0,0,0,325,0,121,-1,-1,26968400,2157,'true','true','true','true','true',0,0,0,0,0,3070,2,25,0,'3552-2;3876-1;'),
(11179,'Tiphon\'s Spear - Landslide','Long Blow','lrhand','true',1820,1,1,'fine_steel','a',251,10,'pole',8,-3.00000,0,0,0,325,0,121,-1,-1,26968400,2157,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3552-2;3876-1;'),
(11180,'Tiphon\'s Spear - Landslide','Wild Blow','lrhand','true',1820,1,1,'fine_steel','a',251,10,'pole',8,-3.00000,0,0,0,325,0,121,-1,-1,26968400,2157,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3552-2;3876-1;'),
(11181,'Tallum Blade*Damascus - Landslide','','lrhand','true',1890,1,1,'fine_steel','a',305,10,'dual',8,0.00000,0,0,0,325,0,121,-1,-1,26968400,2157,'true','true','true','true','true',3045,17,0,0,0,0,0,0,0,'3839-1;'),
(11182,'Themis\' Tongue - Cleverness','','rhand','true',820,1,1,'fine_steel','a',202,10,'sword',8,0.00000,0,0,0,379,0,161,-1,-1,26968400,2157,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3853-1;'),
(11183,'Themis\' Tongue - Cleverness','Mana Up','rhand','true',820,1,1,'fine_steel','a',202,10,'sword',8,0.00000,0,0,0,379,0,161,-1,-1,26968400,2157,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3014-2;3853-1;'),
(11184,'Themis\' Tongue - Cleverness','Magic Mental Shield','rhand','true',820,1,1,'fine_steel','a',202,10,'sword',8,0.00000,0,0,0,379,0,161,-1,-1,26968400,2157,'true','true','true','true','true',0,0,1035,2,50,0,0,0,0,'3552-1;3853-1;'),
(11185,'Themis\' Tongue - Cleverness','Magic Focus','rhand','true',820,1,1,'fine_steel','a',202,10,'sword',8,0.00000,0,0,0,379,0,161,-1,-1,26968400,2157,'true','true','true','true','true',0,0,1077,3,20,0,0,0,0,'3552-1;3853-1;'),
(11186,'Cabrio\'s Hand - Cleverness','','rhand','true',1510,1,1,'fine_steel','a',202,20,'blunt',4,4.00000,0,0,0,379,0,161,-1,-1,26968400,2157,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3893-1;'),
(11187,'Cabrio\'s Hand - Cleverness','Conversion','rhand','true',1510,1,1,'fine_steel','a',202,20,'blunt',4,4.00000,0,0,0,379,0,161,-1,-1,26968400,2157,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3048-3;3893-1;'),
(11188,'Cabrio\'s Hand - Cleverness','Mana Up','rhand','true',1510,1,1,'fine_steel','a',202,20,'blunt',4,4.00000,0,0,0,379,0,161,-1,-1,26968400,2157,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3014-2;3893-1;'),
(11189,'Cabrio\'s Hand - Cleverness','Magic Silence','rhand','true',1510,1,1,'fine_steel','a',202,20,'blunt',4,4.00000,0,0,0,379,0,161,-1,-1,26968400,2157,'true','true','true','true','true',0,0,3074,2,10,0,0,0,0,'3552-1;3893-1;'),
(11190,'Gram - Thunder','','lrhand','true',1800,1,1,'fine_steel','s',304,15,'ancient',8,2.00000,0,0,0,350,0,132,-1,-1,42759400,2052,'true','true','true','true','true',0,0,0,0,0,0,0,0,11239,'3850-1;'),
(11191,'Gram - Thunder','Haste','lrhand','true',1800,1,1,'fine_steel','s',304,15,'ancient',8,2.00000,0,0,0,350,0,132,-1,-1,42759400,2052,'true','true','true','true','true',0,0,0,0,0,0,0,0,11240,'3564-1;3850-1;'),
(11192,'Gram - Thunder','Health','lrhand','true',1800,1,1,'fine_steel','s',304,15,'ancient',8,2.00000,0,0,0,350,0,132,-1,-1,42759400,2052,'true','true','true','true','true',0,0,0,0,0,0,0,0,11241,'3013-3;3850-1;'),
(11193,'Gram - Thunder','Focus','lrhand','true',1800,1,1,'fine_steel','s',304,15,'ancient',8,2.00000,0,0,0,350,0,132,-1,-1,42759400,2052,'true','true','true','true','true',0,0,0,0,0,0,0,0,11242,'3566-1;3850-1;'),
(11194,'Demon Splinter - Thunder','','lrhand','true',1350,1,1,'fine_steel','s',342,5,'dualfist',4,4.00000,0,0,0,325,0,132,-1,-1,42759400,2052,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3883-1;'),
(11195,'Demon Splinter - Thunder','Focus','lrhand','true',1350,1,1,'fine_steel','s',342,5,'dualfist',4,4.00000,0,0,0,325,0,132,-1,-1,42759400,2052,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3565-1;3883-1;'),
(11196,'Demon Splinter - Thunder','Health','lrhand','true',1350,1,1,'fine_steel','s',342,5,'dualfist',4,4.00000,0,0,0,325,0,132,-1,-1,42759400,2052,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3013-3;3883-1;'),
(11197,'Demon Splinter - Thunder','Critical Stun','lrhand','true',1350,1,1,'fine_steel','s',342,5,'dualfist',4,4.00000,0,0,0,325,0,132,-1,-1,42759400,2052,'true','true','true','true','true',0,0,0,0,0,3571,1,27,0,'3552-1;3883-1;'),
(11198,'Draconic Bow - Earth','','lrhand','true',1650,1,1,'fine_steel','s',581,5,'bow',12,-3.00000,0,0,0,293,11,132,-1,-1,42759400,2052,'true','true','true','true','true',0,0,0,0,0,0,0,0,11214,'3867-1;'),
(11199,'Draconic Bow - Earth','Cheap Shot','lrhand','true',1650,1,1,'fine_steel','s',581,5,'bow',12,-3.00000,0,0,0,293,11,132,-1,-1,42759400,2052,'true','true','true','true','true',0,0,0,0,0,0,0,0,11215,'3552-1;3867-1;'),
(11200,'Draconic Bow - Earth','Focus','lrhand','true',1650,1,1,'fine_steel','s',581,5,'bow',12,-3.00000,0,0,0,293,11,132,-1,-1,42759400,2052,'true','true','true','true','true',0,0,0,0,0,0,0,0,11216,'3567-1;3867-1;'),
(11201,'Draconic Bow - Earth','Critical Slow','lrhand','true',1650,1,1,'fine_steel','s',581,5,'bow',12,-3.00000,0,0,0,293,11,132,-1,-1,42759400,2052,'true','true','true','true','true',0,0,0,0,0,3574,1,16,11217,'3552-1;3867-1;'),
(11202,'Dragon Hunter Axe - Thunder','','lrhand','true',1820,1,1,'fine_steel','s',342,20,'bigblunt',4,4.00000,0,0,0,325,0,132,-1,-1,42759400,2052,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3894-1;'),
(11203,'Dragon Hunter Axe - Thunder','HP Regeneration','lrhand','true',1820,1,1,'fine_steel','s',342,20,'bigblunt',4,4.00000,0,0,0,325,0,132,-1,-1,42759400,2052,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3569-1;3894-1;'),
(11204,'Dragon Hunter Axe - Thunder','Health','lrhand','true',1820,1,1,'fine_steel','s',342,20,'bigblunt',4,4.00000,0,0,0,325,0,132,-1,-1,42759400,2052,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3013-3;3894-1;'),
(11205,'Dragon Hunter Axe - Thunder','HP Drain','lrhand','true',1820,1,1,'fine_steel','s',342,20,'bigblunt',4,4.00000,0,0,0,325,0,132,-1,-1,42759400,2052,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3568-1;3894-1;'),
(11206,'Laevateinn - Lightning','','rhand','true',1300,1,1,'fine_steel','s',255,40,'rapier',10,-1.00000,0,0,0,406,0,132,-1,-1,42759400,2052,'true','true','true','true','true',3426,1,0,0,0,0,0,0,11235,'3833-1;'),
(11207,'Laevateinn - Lightning','Haste','rhand','true',1300,1,1,'fine_steel','s',255,40,'rapier',10,-1.00000,0,0,0,406,0,132,-1,-1,42759400,2052,'true','true','true','true','true',3426,1,0,0,0,0,0,0,11236,'3564-1;3833-1;'),
(11208,'Laevateinn - Lightning','Health','rhand','true',1300,1,1,'fine_steel','s',255,40,'rapier',10,-1.00000,0,0,0,406,0,132,-1,-1,42759400,2052,'true','true','true','true','true',3426,1,0,0,0,0,0,0,11237,'3013-3;3833-1;'),
(11209,'Laevateinn - Lightning','Focus','rhand','true',1300,1,1,'fine_steel','s',255,40,'rapier',10,-1.00000,0,0,0,406,0,132,-1,-1,42759400,2052,'true','true','true','true','true',3426,1,0,0,0,0,0,0,11238,'3566-1;3833-1;'),
(11210,'Basalt Battlehammer - Concentration','','rhand','true',1570,1,1,'fine_steel','s',281,20,'blunt',4,4.00000,0,0,0,379,0,132,-1,-1,42759400,2052,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3888-1;'),
(11211,'Basalt Battlehammer - Concentration','HP Drain','rhand','true',1570,1,1,'fine_steel','s',281,20,'blunt',4,4.00000,0,0,0,379,0,132,-1,-1,42759400,2052,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3568-1;3888-1;'),
(11212,'Basalt Battlehammer - Concentration','Health','rhand','true',1570,1,1,'fine_steel','s',281,20,'blunt',4,4.00000,0,0,0,379,0,132,-1,-1,42759400,2052,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3013-3;3888-1;'),
(11213,'Basalt Battlehammer - Concentration','HP Regeneration','rhand','true',1570,1,1,'fine_steel','s',281,20,'blunt',4,4.00000,0,0,0,379,0,132,-1,-1,42759400,2052,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3569-1;3888-1;'),
(11214,'Sarunga - Earth','','rhand','true',1600,1,1,'fine_steel','s',356,10,'crossbow',10,-1.00000,0,0,0,303,0,132,-1,-1,42759400,2052,'true','true','true','true','true',0,0,0,0,0,0,0,0,11198,'3872-1;'),
(11215,'Sarunga - Earth','Cheap Shot','rhand','true',1600,1,1,'fine_steel','s',356,10,'crossbow',10,-1.00000,0,0,0,303,0,132,-1,-1,42759400,2052,'true','true','true','true','true',0,0,0,0,0,0,0,0,11199,'3552-1;3872-1;'),
(11216,'Sarunga - Earth','Focus','rhand','true',1600,1,1,'fine_steel','s',356,10,'crossbow',10,-1.00000,0,0,0,303,0,132,-1,-1,42759400,2052,'true','true','true','true','true',0,0,0,0,0,0,0,0,11200,'3567-1;3872-1;'),
(11217,'Sarunga - Earth','Critical Slow','rhand','true',1600,1,1,'fine_steel','s',356,10,'crossbow',10,-1.00000,0,0,0,303,0,132,-1,-1,42759400,2052,'true','true','true','true','true',0,0,0,0,0,3574,1,16,11201,'3552-1;3872-1;'),
(11218,'Saint Spear - Destruction','','lrhand','true',1800,1,1,'fine_steel','s',281,10,'pole',8,-3.00000,0,0,0,325,0,132,-1,-1,42759400,2052,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3599-1;3878-1;'),
(11219,'Saint Spear - Destruction','Health','lrhand','true',1800,1,1,'fine_steel','s',281,10,'pole',8,-3.00000,0,0,0,325,0,132,-1,-1,42759400,2052,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3013-4;3878-1;'),
(11220,'Saint Spear - Destruction','Guidance','lrhand','true',1800,1,1,'fine_steel','s',281,10,'pole',8,-3.00000,0,0,0,325,0,132,-1,-1,42759400,2052,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3602-9;3878-1;'),
(11221,'Saint Spear - Destruction','Haste','lrhand','true',1800,1,1,'fine_steel','s',281,10,'pole',8,-3.00000,0,0,0,325,0,132,-1,-1,42759400,2052,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3601-9;3878-1;'),
(11222,'Arcana Mace - Nature','','rhand','true',1300,1,1,'fine_steel','s',225,20,'blunt',4,4.00000,0,0,0,379,0,175,-1,-1,42759400,2052,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3890-1;'),
(11223,'Arcana Mace - Nature','Acumen','rhand','true',1300,1,1,'fine_steel','s',225,20,'blunt',4,4.00000,0,0,0,379,0,175,-1,-1,42759400,2052,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3047-2;3890-1;'),
(11224,'Arcana Mace - Nature','MP Regeneration','rhand','true',1300,1,1,'fine_steel','s',225,20,'blunt',4,4.00000,0,0,0,379,0,175,-1,-1,42759400,2052,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3576-1;3890-1;'),
(11225,'Arcana Mace - Nature','Mana Up','rhand','true',1300,1,1,'fine_steel','s',225,20,'blunt',4,4.00000,0,0,0,379,0,175,-1,-1,42759400,2052,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3014-2;3890-1;'),
(11226,'Angel Slayer - Concentration','','rhand','true',950,1,1,'fine_steel','s',246,5,'dagger',12,-3.00000,0,0,0,433,0,132,-1,-1,42759400,2052,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3862-1;'),
(11227,'Angel Slayer - Concentration','Critical Damage','rhand','true',950,1,1,'fine_steel','s',246,5,'dagger',12,-3.00000,0,0,0,433,0,132,-1,-1,42759400,2052,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3572-1;3862-1;'),
(11228,'Angel Slayer - Concentration','HP Drain','rhand','true',950,1,1,'fine_steel','s',246,5,'dagger',12,-3.00000,0,0,0,433,0,132,-1,-1,42759400,2052,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3568-1;3862-1;'),
(11229,'Angel Slayer - Concentration','Haste','rhand','true',950,1,1,'fine_steel','s',246,5,'dagger',12,-3.00000,0,0,0,433,0,132,-1,-1,42759400,2052,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3564-1;3862-1;'),
(11230,'Imperial Staff - Nature','','lrhand','true',910,1,1,'fine_steel','s',274,20,'bigblunt',4,4.00000,0,0,0,325,0,193,-1,-1,42759400,2052,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3901-2;'),
(11231,'Imperial Staff - Nature','Empower','lrhand','true',910,1,1,'fine_steel','s',274,20,'bigblunt',4,4.00000,0,0,0,325,0,193,-1,-1,42759400,2052,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3575-1;3901-2;'),
(11232,'Imperial Staff - Nature','MP Regeneration','lrhand','true',910,1,1,'fine_steel','s',274,20,'bigblunt',4,4.00000,0,0,0,325,0,193,-1,-1,42759400,2052,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3576-1;3901-2;'),
(11233,'Imperial Staff - Nature','Magic Hold','lrhand','true',910,1,1,'fine_steel','s',274,20,'bigblunt',4,4.00000,0,0,0,325,0,193,-1,-1,42759400,2052,'true','true','true','true','true',0,0,3577,1,20,0,0,0,0,'3552-1;3901-2;'),
(11234,'Tallum Blade*Dark Legion\'s Edge - Lightning','','lrhand','true',2080,1,1,'fine_steel','s',342,10,'dual',8,0.00000,0,0,0,325,0,132,-1,-1,42759400,2052,'true','true','true','true','true',3570,1,0,0,0,0,0,0,0,'3838-1;'),
(11235,'Forgotten Blade - Lightning','','rhand','true',1300,1,1,'fine_steel','s',281,10,'sword',8,0.00000,0,0,0,379,0,132,-1,-1,42759400,2052,'true','true','true','true','true',0,0,0,0,0,0,0,0,11206,'3828-1;'),
(11236,'Forgotten Blade - Lightning','Haste','rhand','true',1300,1,1,'fine_steel','s',281,10,'sword',8,0.00000,0,0,0,379,0,132,-1,-1,42759400,2052,'true','true','true','true','true',0,0,0,0,0,0,0,0,11207,'3564-1;3828-1;'),
(11237,'Forgotten Blade - Lightning','Health','rhand','true',1300,1,1,'fine_steel','s',281,10,'sword',8,0.00000,0,0,0,379,0,132,-1,-1,42759400,2052,'true','true','true','true','true',0,0,0,0,0,0,0,0,11208,'3013-3;3828-1;'),
(11238,'Forgotten Blade - Lightning','Focus','rhand','true',1300,1,1,'fine_steel','s',281,10,'sword',8,0.00000,0,0,0,379,0,132,-1,-1,42759400,2052,'true','true','true','true','true',0,0,0,0,0,0,0,0,11209,'3566-1;3828-1;'),
(11239,'Heaven\'s Divider - Thunder','','lrhand','true',1380,1,1,'fine_steel','s',342,10,'bigsword',8,0.00000,0,0,0,325,0,132,-1,-1,42759400,2052,'true','true','true','true','true',0,0,0,0,0,0,0,0,11190,'3844-1;'),
(11240,'Heaven\'s Divider - Thunder','Haste','lrhand','true',1380,1,1,'fine_steel','s',342,10,'bigsword',8,0.00000,0,0,0,325,0,132,-1,-1,42759400,2052,'true','true','true','true','true',0,0,0,0,0,0,0,0,11191,'3564-1;3844-1;'),
(11241,'Heaven\'s Divider - Thunder','Health','lrhand','true',1380,1,1,'fine_steel','s',342,10,'bigsword',8,0.00000,0,0,0,325,0,132,-1,-1,42759400,2052,'true','true','true','true','true',0,0,0,0,0,0,0,0,11192,'3013-3;3844-1;'),
(11242,'Heaven\'s Divider - Thunder','Focus','lrhand','true',1380,1,1,'fine_steel','s',342,10,'bigsword',8,0.00000,0,0,0,325,0,132,-1,-1,42759400,2052,'true','true','true','true','true',0,0,0,0,0,0,0,0,11193,'3566-1;3844-1;'),
(11243,'Dynasty Ancient Sword - Great Gale','','lrhand','true',1800,1,1,'fine_steel','s80',361,15,'ancient',8,2.00000,0,0,0,350,0,151,-1,-1,74946000,3597,'true','true','true','true','true',0,0,0,0,0,0,0,0,11268,'3846-2;'),
(11244,'Dynasty Ancient Sword - Great Gale','Focus','lrhand','true',1800,1,1,'fine_steel','s80',361,15,'ancient',8,2.00000,0,0,0,350,0,151,-1,-1,74946000,3597,'true','true','true','true','true',0,0,0,0,0,0,0,0,11269,'3846-2;3566-2;'),
(11245,'Dynasty Ancient Sword - Great Gale','Health','lrhand','true',1800,1,1,'fine_steel','s80',361,15,'ancient',8,2.00000,0,0,0,350,0,151,-1,-1,74946000,3597,'true','true','true','true','true',0,0,0,0,0,0,0,0,11270,'3846-2;3013-5;'),
(11246,'Dynasty Ancient Sword - Great Gale','Light','lrhand','true',1800,1,1,'fine_steel','s80',361,15,'ancient',8,2.00000,0,0,0,350,0,151,-1,-1,74946000,3597,'true','true','true','true','true',0,0,0,0,0,0,0,0,11271,'3846-2;3498-1;'),
(11247,'Dynasty Knife - Great Gale','','rhand','true',1520,1,1,'fine_steel','s80',291,5,'dagger',12,-3.00000,0,0,0,433,0,151,-1,-1,74946000,3597,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3859-2;'),
(11248,'Dynasty Knife - Great Gale','Focus','rhand','true',1520,1,1,'fine_steel','s80',291,5,'dagger',12,-3.00000,0,0,0,433,0,151,-1,-1,74946000,3597,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3859-2;3567-2;'),
(11249,'Dynasty Knife - Great Gale','Evasion','rhand','true',1520,1,1,'fine_steel','s80',291,5,'dagger',12,-3.00000,0,0,0,433,0,151,-1,-1,74946000,3597,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3859-2;3009-7;'),
(11250,'Dynasty Knife - Great Gale','Critical Damage','rhand','true',1520,1,1,'fine_steel','s80',291,5,'dagger',12,-3.00000,0,0,0,433,0,151,-1,-1,74946000,3597,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3859-2;3066-4;'),
(11251,'Dynasty Dual Sword - Earth','','lrhand','true',1520,1,1,'fine_steel','s80',405,10,'dual',8,0.00000,0,0,0,325,0,151,-1,-1,74946000,3597,'true','true','true','true','true',3411,1,0,0,0,0,0,0,0,'3836-2;'),
(11252,'Dynasty Rapier - Earth','','rhand','true',1280,1,1,'fine_steel','s80',302,40,'rapier',10,-1.00000,0,0,0,406,0,151,-1,-1,74946000,3597,'true','true','true','true','true',3426,1,0,0,0,0,0,0,11272,'3831-2;'),
(11253,'Dynasty Rapier - Earth','Focus','rhand','true',1280,1,1,'fine_steel','s80',302,40,'rapier',10,-1.00000,0,0,0,406,0,151,-1,-1,74946000,3597,'true','true','true','true','true',3426,1,0,0,0,0,0,0,11273,'3831-2;3566-2;'),
(11254,'Dynasty Rapier - Earth','Health','rhand','true',1280,1,1,'fine_steel','s80',302,40,'rapier',10,-1.00000,0,0,0,406,0,151,-1,-1,74946000,3597,'true','true','true','true','true',3426,1,0,0,0,0,0,0,11274,'3831-2;3013-5;'),
(11255,'Dynasty Rapier - Earth','Light','rhand','true',1280,1,1,'fine_steel','s80',302,40,'rapier',10,-1.00000,0,0,0,406,0,151,-1,-1,74946000,3597,'true','true','true','true','true',3426,1,0,0,0,0,0,0,11275,'3831-2;3498-1;'),
(11256,'Dynasty Mace - Earth','','rhand','true',1080,1,1,'fine_steel','s80',267,20,'blunt',4,4.00000,0,0,0,379,0,202,-1,-1,74946000,3597,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3884-2;'),
(11257,'Dynasty Mace - Earth','Mana Up','rhand','true',1080,1,1,'fine_steel','s80',267,20,'blunt',4,4.00000,0,0,0,379,0,202,-1,-1,74946000,3597,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3884-2;3014-3;'),
(11258,'Dynasty Mace - Earth','Conversion','rhand','true',1080,1,1,'fine_steel','s80',267,20,'blunt',4,4.00000,0,0,0,379,0,202,-1,-1,74946000,3597,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3884-2;3048-3;'),
(11259,'Dynasty Mace - Earth','Acumen','rhand','true',1080,1,1,'fine_steel','s80',267,20,'blunt',4,4.00000,0,0,0,379,0,202,-1,-1,74946000,3597,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3884-2;3047-2;'),
(11260,'Dynasty Bagh-Nakh - Great Gale','','lrhand','true',1550,1,1,'fine_steel','s80',405,5,'dualfist',4,4.00000,0,0,0,325,0,151,-1,-1,74946000,3597,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3880-2;'),
(11261,'Dynasty Bagh-Nakh - Great Gale','Rsk. Evasion','lrhand','true',1550,1,1,'fine_steel','s80',405,5,'dualfist',4,4.00000,0,0,0,325,0,151,-1,-1,74946000,3597,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3880-2;3069-1;'),
(11262,'Dynasty Bagh-Nakh - Great Gale','Focus','lrhand','true',1550,1,1,'fine_steel','s80',405,5,'dualfist',4,4.00000,0,0,0,325,0,151,-1,-1,74946000,3597,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3880-2;3565-2;'),
(11263,'Dynasty Bagh-Nakh - Great Gale','Haste','lrhand','true',1550,1,1,'fine_steel','s80',405,5,'dualfist',4,4.00000,0,0,0,325,0,151,-1,-1,74946000,3597,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3880-2;3037-2;'),
(11264,'Dynasty Bow - Great Gale','','lrhand','true',1520,1,1,'fine_steel','s80',654,5,'bow',12,-3.00000,0,0,0,293,11,151,-1,-1,74946000,3597,'true','true','true','true','true',0,0,0,0,0,0,0,0,11288,'3864-2;'),
(11265,'Dynasty Bow - Great Gale','Cheap Shot','lrhand','true',1520,1,1,'fine_steel','s80',654,5,'bow',12,-3.00000,0,0,0,293,11,151,-1,-1,74946000,3597,'true','true','true','true','true',0,0,0,0,0,0,0,0,11289,'3864-2;3552-1;'),
(11266,'Dynasty Bow - Great Gale','Guidance','lrhand','true',1520,1,1,'fine_steel','s80',654,5,'bow',12,-3.00000,0,0,0,293,11,151,-1,-1,74946000,3597,'true','true','true','true','true',0,0,0,0,0,0,0,0,11290,'3864-2;3573-1;'),
(11267,'Dynasty Bow - Great Gale','Focus','lrhand','true',1520,1,1,'fine_steel','s80',654,5,'bow',12,-3.00000,0,0,0,293,11,151,-1,-1,74946000,3597,'true','true','true','true','true',0,0,0,0,0,0,0,0,11291,'3864-2;3567-2;'),
(11268,'Dynasty Blade - Great Gale','','lrhand','true',1740,1,1,'fine_steel','s80',405,10,'bigsword',8,0.00000,0,0,0,325,0,151,-1,-1,74946000,3597,'true','true','true','true','true',0,0,0,0,0,0,0,0,11243,'3840-2;'),
(11269,'Dynasty Blade - Great Gale','Focus','lrhand','true',1740,1,1,'fine_steel','s80',405,10,'bigsword',8,0.00000,0,0,0,325,0,151,-1,-1,74946000,3597,'true','true','true','true','true',0,0,0,0,0,0,0,0,11244,'3840-2;3566-2;'),
(11270,'Dynasty Blade - Great Gale','Health','lrhand','true',1740,1,1,'fine_steel','s80',405,10,'bigsword',8,0.00000,0,0,0,325,0,151,-1,-1,74946000,3597,'true','true','true','true','true',0,0,0,0,0,0,0,0,11245,'3840-2;3013-5;'),
(11271,'Dynasty Blade - Great Gale','Light','lrhand','true',1740,1,1,'fine_steel','s80',405,10,'bigsword',8,0.00000,0,0,0,325,0,151,-1,-1,74946000,3597,'true','true','true','true','true',0,0,0,0,0,0,0,0,11246,'3840-2;3498-1;'),
(11272,'Dynasty Sword - Earth','','rhand','true',1520,1,1,'fine_steel','s80',333,10,'sword',8,0.00000,0,0,0,379,0,151,-1,-1,74946000,3597,'true','true','true','true','true',0,0,0,0,0,0,0,0,11252,'3826-2;'),
(11273,'Dynasty Sword - Earth','Focus','rhand','true',1520,1,1,'fine_steel','s80',333,10,'sword',8,0.00000,0,0,0,379,0,151,-1,-1,74946000,3597,'true','true','true','true','true',0,0,0,0,0,0,0,0,11253,'3826-2;3566-2;'),
(11274,'Dynasty Sword - Earth','Health','rhand','true',1520,1,1,'fine_steel','s80',333,10,'sword',8,0.00000,0,0,0,379,0,151,-1,-1,74946000,3597,'true','true','true','true','true',0,0,0,0,0,0,0,0,11254,'3826-2;3013-5;'),
(11275,'Dynasty Sword - Earth','Light','rhand','true',1520,1,1,'fine_steel','s80',333,10,'sword',8,0.00000,0,0,0,379,0,151,-1,-1,74946000,3597,'true','true','true','true','true',0,0,0,0,0,0,0,0,11255,'3826-2;3498-1;'),
(11276,'Dynasty Staff - Holy Spirit','','lrhand','true',1080,1,1,'fine_steel','s80',325,20,'bigblunt',4,4.00000,0,0,0,325,0,222,-1,-1,74946000,3597,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11277,'Dynasty Staff - Holy Spirit','Mana Up','lrhand','true',1080,1,1,'fine_steel','s80',325,20,'bigblunt',4,4.00000,0,0,0,325,0,222,-1,-1,74946000,3597,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3014-3;'),
(11278,'Dynasty Staff - Holy Spirit','Conversion','lrhand','true',1080,1,1,'fine_steel','s80',325,20,'bigblunt',4,4.00000,0,0,0,325,0,222,-1,-1,74946000,3597,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3048-3;'),
(11279,'Dynasty Staff - Holy Spirit','Acumen','lrhand','true',1080,1,1,'fine_steel','s80',325,20,'bigblunt',4,4.00000,0,0,0,325,0,222,-1,-1,74946000,3597,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3047-2;'),
(11280,'Dynasty Cudgel - Landslide','','rhand','true',1740,1,1,'fine_steel','s80',333,20,'blunt',4,4.00000,0,0,0,379,0,151,-1,-1,74946000,3597,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3885-1;'),
(11281,'Dynasty Cudgel - Landslide','Anger','rhand','true',1740,1,1,'fine_steel','s80',333,20,'blunt',4,4.00000,0,0,0,379,0,151,-1,-1,74946000,3597,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3057-3;3885-1;'),
(11282,'Dynasty Cudgel - Landslide','Health','rhand','true',1740,1,1,'fine_steel','s80',333,20,'blunt',4,4.00000,0,0,0,379,0,151,-1,-1,74946000,3597,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3013-5;3885-1;'),
(11283,'Dynasty Cudgel - Landslide','Rsk. Focus','rhand','true',1740,1,1,'fine_steel','s80',333,20,'blunt',4,4.00000,0,0,0,379,0,151,-1,-1,74946000,3597,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3027-7;3885-1;'),
(11284,'Dynasty Crusher - Great Gale','','lrhand','true',1740,1,1,'fine_steel','s80',405,20,'bigblunt',4,4.00000,0,0,0,325,0,151,-1,-1,74946000,3597,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3896-2;'),
(11285,'Dynasty Crusher - Great Gale','Anger','lrhand','true',1740,1,1,'fine_steel','s80',405,20,'bigblunt',4,4.00000,0,0,0,325,0,151,-1,-1,74946000,3597,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3896-2;3057-3;'),
(11286,'Dynasty Crusher - Great Gale','Health','lrhand','true',1740,1,1,'fine_steel','s80',405,20,'bigblunt',4,4.00000,0,0,0,325,0,151,-1,-1,74946000,3597,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3896-2;3013-5;'),
(11287,'Dynasty Crusher - Great Gale','Rsk. Focus','lrhand','true',1740,1,1,'fine_steel','s80',405,20,'bigblunt',4,4.00000,0,0,0,325,0,151,-1,-1,74946000,3597,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3896-2;3027-7;'),
(11288,'Dynasty Crossbow - Great Gale','','rhand','true',1580,1,1,'fine_steel','s80',401,10,'crossbow',10,-1.00000,0,0,0,303,0,151,-1,-1,74946000,3597,'true','true','true','true','true',0,0,0,0,0,0,0,0,11264,'3869-2;'),
(11289,'Dynasty Crossbow - Great Gale','Cheap Shot','rhand','true',1580,1,1,'fine_steel','s80',401,10,'crossbow',10,-1.00000,0,0,0,303,0,151,-1,-1,74946000,3597,'true','true','true','true','true',0,0,0,0,0,0,0,0,11265,'3869-2;3552-1;'),
(11290,'Dynasty Crossbow - Great Gale','Guidance','rhand','true',1580,1,1,'fine_steel','s80',401,10,'crossbow',10,-1.00000,0,0,0,303,0,151,-1,-1,74946000,3597,'true','true','true','true','true',0,0,0,0,0,0,0,0,11266,'3869-2;3573-1;'),
(11291,'Dynasty Crossbow - Great Gale','Focus','rhand','true',1580,1,1,'fine_steel','s80',401,10,'crossbow',10,-1.00000,0,0,0,303,0,151,-1,-1,74946000,3597,'true','true','true','true','true',0,0,0,0,0,0,0,0,11267,'3869-2;3567-2;'),
(11292,'Dynasty Phantom - Nature','','rhand','true',1520,1,1,'fine_steel','s80',267,10,'sword',8,0.00000,0,0,0,379,0,202,-1,-1,74946000,3597,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3852-3;'),
(11293,'Dynasty Phantom - Nature','Acumen','rhand','true',1520,1,1,'fine_steel','s80',267,10,'sword',8,0.00000,0,0,0,379,0,202,-1,-1,74946000,3597,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3047-2;3852-3;'),
(11294,'Dynasty Phantom - Nature','Mana Up','rhand','true',1520,1,1,'fine_steel','s80',267,10,'sword',8,0.00000,0,0,0,379,0,202,-1,-1,74946000,3597,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3014-3;3852-3;'),
(11295,'Dynasty Phantom - Nature','Conversion','rhand','true',1520,1,1,'fine_steel','s80',267,10,'sword',8,0.00000,0,0,0,379,0,202,-1,-1,74946000,3597,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3048-3;3852-3;'),
(11296,'Dynasty Halberd - Earth','','lrhand','true',2010,1,1,'fine_steel','s80',333,10,'pole',8,-3.00000,0,0,0,325,0,151,-1,-1,74946000,3597,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3877-2;3599-1;'),
(11297,'Dynasty Halberd - Earth','Anger','lrhand','true',2010,1,1,'fine_steel','s80',333,10,'pole',8,-3.00000,0,0,0,325,0,151,-1,-1,74946000,3597,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3877-2;3600-10;'),
(11298,'Dynasty Halberd - Earth','Critical Stun','lrhand','true',2010,1,1,'fine_steel','s80',333,10,'pole',8,-3.00000,0,0,0,325,0,151,-1,-1,74946000,3597,'true','true','true','true','true',0,0,0,0,0,3070,3,48,0,'3877-2;3599-1;3552-2;'),
(11299,'Dynasty Halberd - Earth','Light','lrhand','true',2010,1,1,'fine_steel','s80',333,10,'pole',8,-3.00000,0,0,0,325,0,151,-1,-1,74946000,3597,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3877-2;3599-1;3498-1;'),
(11300,'Icarus Dual Sword - Destruction','','lrhand','true',1520,1,1,'fine_steel','s80',442,10,'dual',8,0.00000,0,0,0,325,0,163,-1,-1,103439000,4965,'true','true','true','true','true',3411,1,0,0,0,0,0,0,0,'0-0;'),
(11301,'Icarus Disperser - Confusion','','rhand','true',1520,1,1,'fine_steel','s80',318,5,'dagger',12,-3.00000,0,0,0,433,0,163,-1,-1,103439000,4965,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11302,'Icarus Disperser - Confusion','Focus','rhand','true',1520,1,1,'fine_steel','s80',318,5,'dagger',12,-3.00000,0,0,0,433,0,163,-1,-1,103439000,4965,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3567-2;'),
(11303,'Icarus Disperser - Confusion','Evasion','rhand','true',1520,1,1,'fine_steel','s80',318,5,'dagger',12,-3.00000,0,0,0,433,0,163,-1,-1,103439000,4965,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3009-8;'),
(11304,'Icarus Disperser - Confusion','Critical Damage','rhand','true',1520,1,1,'fine_steel','s80',318,5,'dagger',12,-3.00000,0,0,0,433,0,163,-1,-1,103439000,4965,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3066-4;'),
(11305,'Icarus Sawsword - Destruction','','rhand','true',1520,1,1,'fine_steel','s80',363,10,'sword',8,0.00000,0,0,0,379,0,163,-1,-1,103439000,4965,'true','true','true','true','true',0,0,0,0,0,0,0,0,11313,'0-0;'),
(11306,'Icarus Sawsword - Destruction','Focus','rhand','true',1520,1,1,'fine_steel','s80',363,10,'sword',8,0.00000,0,0,0,379,0,163,-1,-1,103439000,4965,'true','true','true','true','true',0,0,0,0,0,0,0,0,11314,'3566-2;'),
(11307,'Icarus Sawsword - Destruction','Health','rhand','true',1520,1,1,'fine_steel','s80',363,10,'sword',8,0.00000,0,0,0,379,0,163,-1,-1,103439000,4965,'true','true','true','true','true',0,0,0,0,0,0,0,0,11315,'3013-5;'),
(11308,'Icarus Sawsword - Destruction','Light','rhand','true',1520,1,1,'fine_steel','s80',363,10,'sword',8,0.00000,0,0,0,379,0,163,-1,-1,103439000,4965,'true','true','true','true','true',0,0,0,0,0,0,0,0,11316,'3498-1;'),
(11309,'Icarus Shooter - Concentration','','rhand','true',1580,1,1,'fine_steel','s80',422,10,'crossbow',10,-1.00000,0,0,0,303,0,163,-1,-1,103439000,4965,'true','true','true','true','true',0,0,0,0,0,0,0,0,11321,'0-0;'),
(11310,'Icarus Shooter - Concentration','Cheap Shot','rhand','true',1580,1,1,'fine_steel','s80',422,10,'crossbow',10,-1.00000,0,0,0,303,0,163,-1,-1,103439000,4965,'true','true','true','true','true',0,0,0,0,0,0,0,0,11322,'3552-1;'),
(11311,'Icarus Shooter - Concentration','Guidance','rhand','true',1580,1,1,'fine_steel','s80',422,10,'crossbow',10,-1.00000,0,0,0,303,0,163,-1,-1,103439000,4965,'true','true','true','true','true',0,0,0,0,0,0,0,0,11323,'3573-1;'),
(11312,'Icarus Shooter - Concentration','Focus','rhand','true',1580,1,1,'fine_steel','s80',422,10,'crossbow',10,-1.00000,0,0,0,303,0,163,-1,-1,103439000,4965,'true','true','true','true','true',0,0,0,0,0,0,0,0,11324,'3567-2;'),
(11313,'Icarus Stinger - Destruction','','rhand','true',1280,1,1,'fine_steel','s80',329,40,'rapier',10,-1.00000,0,0,0,406,0,163,-1,-1,103439000,4965,'true','true','true','true','true',3426,1,0,0,0,0,0,0,11305,'0-0;'),
(11314,'Icarus Stinger - Destruction','Focus','rhand','true',1280,1,1,'fine_steel','s80',329,40,'rapier',10,-1.00000,0,0,0,406,0,163,-1,-1,103439000,4965,'true','true','true','true','true',3426,1,0,0,0,0,0,0,11306,'3566-2;'),
(11315,'Icarus Stinger - Destruction','Health','rhand','true',1280,1,1,'fine_steel','s80',329,40,'rapier',10,-1.00000,0,0,0,406,0,163,-1,-1,103439000,4965,'true','true','true','true','true',3426,1,0,0,0,0,0,0,11307,'3013-5;'),
(11316,'Icarus Stinger - Destruction','Light','rhand','true',1280,1,1,'fine_steel','s80',329,40,'rapier',10,-1.00000,0,0,0,406,0,163,-1,-1,103439000,4965,'true','true','true','true','true',3426,1,0,0,0,0,0,0,11308,'3498-1;'),
(11317,'Icarus Spirit - Nature','','rhand','true',1520,1,1,'fine_steel','s80',290,10,'sword',8,0.00000,0,0,0,379,0,217,-1,-1,103439000,4965,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3852-3;'),
(11318,'Icarus Spirit - Nature','Acumen','rhand','true',1520,1,1,'fine_steel','s80',290,10,'sword',8,0.00000,0,0,0,379,0,217,-1,-1,103439000,4965,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3047-3;3852-3;'),
(11319,'Icarus Spirit - Nature','Mana Up','rhand','true',1520,1,1,'fine_steel','s80',290,10,'sword',8,0.00000,0,0,0,379,0,217,-1,-1,103439000,4965,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3014-3;3852-3;'),
(11320,'Icarus Spirit - Nature','Conversion','rhand','true',1520,1,1,'fine_steel','s80',290,10,'sword',8,0.00000,0,0,0,379,0,217,-1,-1,103439000,4965,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3048-3;3852-3;'),
(11321,'Icarus Spitter - Concentration','','lrhand','true',1520,1,1,'fine_steel','s80',689,5,'bow',12,-3.00000,0,0,0,293,11,163,-1,-1,103439000,4965,'true','true','true','true','true',0,0,0,0,0,0,0,0,11309,'0-0;'),
(11322,'Icarus Spitter - Concentration','Cheap Shot','lrhand','true',1520,1,1,'fine_steel','s80',689,5,'bow',12,-3.00000,0,0,0,293,11,163,-1,-1,103439000,4965,'true','true','true','true','true',0,0,0,0,0,0,0,0,11310,'3552-1;'),
(11323,'Icarus Spitter - Concentration','Guidance','lrhand','true',1520,1,1,'fine_steel','s80',689,5,'bow',12,-3.00000,0,0,0,293,11,163,-1,-1,103439000,4965,'true','true','true','true','true',0,0,0,0,0,0,0,0,11311,'3573-1;'),
(11324,'Icarus Spitter - Concentration','Focus','lrhand','true',1520,1,1,'fine_steel','s80',689,5,'bow',12,-3.00000,0,0,0,293,11,163,-1,-1,103439000,4965,'true','true','true','true','true',0,0,0,0,0,0,0,0,11312,'3567-2;'),
(11325,'Icarus Wingblade - Lightning','','lrhand','true',1800,1,1,'fine_steel','s80',393,15,'ancient',8,2.00000,0,0,0,350,0,163,-1,-1,103439000,4965,'true','true','true','true','true',0,0,0,0,0,0,0,0,11341,'0-0;'),
(11326,'Icarus Wingblade - Lightning','Focus','lrhand','true',1800,1,1,'fine_steel','s80',393,15,'ancient',8,2.00000,0,0,0,350,0,163,-1,-1,103439000,4965,'true','true','true','true','true',0,0,0,0,0,0,0,0,11342,'3566-2;'),
(11327,'Icarus Wingblade - Lightning','Health','lrhand','true',1800,1,1,'fine_steel','s80',393,15,'ancient',8,2.00000,0,0,0,350,0,163,-1,-1,103439000,4965,'true','true','true','true','true',0,0,0,0,0,0,0,0,11343,'3013-5;'),
(11328,'Icarus Wingblade - Lightning','Light','lrhand','true',1800,1,1,'fine_steel','s80',393,15,'ancient',8,2.00000,0,0,0,350,0,163,-1,-1,103439000,4965,'true','true','true','true','true',0,0,0,0,0,0,0,0,11344,'3498-1;'),
(11329,'Icarus Trident - Thunder','','lrhand','true',2010,1,1,'fine_steel','s80',363,10,'pole',8,-3.00000,0,0,0,325,0,163,-1,-1,103439000,4965,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3599-1;'),
(11330,'Icarus Trident - Thunder','Anger','lrhand','true',2010,1,1,'fine_steel','s80',363,10,'pole',8,-3.00000,0,0,0,325,0,163,-1,-1,103439000,4965,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3600-10;'),
(11331,'Icarus Trident - Thunder','Critical Stun','lrhand','true',2010,1,1,'fine_steel','s80',363,10,'pole',8,-3.00000,0,0,0,325,0,163,-1,-1,103439000,4965,'true','true','true','true','true',0,0,0,0,0,3070,3,48,0,'3552-2;'),
(11332,'Icarus Trident - Thunder','Light','lrhand','true',2010,1,1,'fine_steel','s80',363,10,'pole',8,-3.00000,0,0,0,325,0,163,-1,-1,103439000,4965,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3599-1;3498-1;'),
(11333,'Icarus Hammer - Earth','','rhand','true',1740,1,1,'fine_steel','s80',363,20,'blunt',4,4.00000,0,0,0,379,0,163,-1,-1,103439000,4965,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3884-2;'),
(11334,'Icarus Hammer - Earth','Anger','rhand','true',1740,1,1,'fine_steel','s80',363,20,'blunt',4,4.00000,0,0,0,379,0,163,-1,-1,103439000,4965,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3884-2;3057-3;'),
(11335,'Icarus Hammer - Earth','Health','rhand','true',1740,1,1,'fine_steel','s80',363,20,'blunt',4,4.00000,0,0,0,379,0,163,-1,-1,103439000,4965,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3884-2;3013-5;'),
(11336,'Icarus Hammer - Earth','Rsk. Focus','rhand','true',1740,1,1,'fine_steel','s80',363,20,'blunt',4,4.00000,0,0,0,379,0,163,-1,-1,103439000,4965,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3884-2;3027-7;'),
(11337,'Icarus Hand - Destruction','','lrhand','true',1550,1,1,'fine_steel','s80',442,5,'dualfist',4,4.00000,0,0,0,325,0,163,-1,-1,103439000,4965,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11338,'Icarus Hand - Destruction','Rsk. Evasion','lrhand','true',1550,1,1,'fine_steel','s80',442,5,'dualfist',4,4.00000,0,0,0,325,0,163,-1,-1,103439000,4965,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3069-1;'),
(11339,'Icarus Hand - Destruction','Focus','lrhand','true',1550,1,1,'fine_steel','s80',442,5,'dualfist',4,4.00000,0,0,0,325,0,163,-1,-1,103439000,4965,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3565-2;'),
(11340,'Icarus Hand - Destruction','Haste','lrhand','true',1550,1,1,'fine_steel','s80',442,5,'dualfist',4,4.00000,0,0,0,325,0,163,-1,-1,103439000,4965,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3564-2;'),
(11341,'Icarus Heavy Arms - Lightning','','lrhand','true',1740,1,1,'fine_steel','s80',442,10,'bigsword',8,0.00000,0,0,0,325,0,163,-1,-1,103439000,4965,'true','true','true','true','true',0,0,0,0,0,0,0,0,11325,'0-0;'),
(11342,'Icarus Heavy Arms - Lightning','Focus','lrhand','true',1740,1,1,'fine_steel','s80',442,10,'bigsword',8,0.00000,0,0,0,325,0,163,-1,-1,103439000,4965,'true','true','true','true','true',0,0,0,0,0,0,0,0,11326,'3566-2;'),
(11343,'Icarus Heavy Arms - Lightning','Health','lrhand','true',1740,1,1,'fine_steel','s80',442,10,'bigsword',8,0.00000,0,0,0,325,0,163,-1,-1,103439000,4965,'true','true','true','true','true',0,0,0,0,0,0,0,0,11327,'3013-5;');

INSERT INTO `weapon` VALUES
(11344,'Icarus Heavy Arms - Lightning','Light','lrhand','true',1740,1,1,'fine_steel','s80',442,10,'bigsword',8,0.00000,0,0,0,325,0,163,-1,-1,103439000,4965,'true','true','true','true','true',0,0,0,0,0,0,0,0,11328,'3498-1;'),
(11345,'Icarus Hall - Hail','','rhand','true',1080,1,1,'fine_steel','s80',290,20,'blunt',4,4.00000,0,0,0,379,0,217,-1,-1,103439000,4965,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11346,'Icarus Hall - Hail','Mana Up','rhand','true',1080,1,1,'fine_steel','s80',290,20,'blunt',4,4.00000,0,0,0,379,0,217,-1,-1,103439000,4965,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3014-3;'),
(11347,'Icarus Hall - Hail','Conversion','rhand','true',1080,1,1,'fine_steel','s80',290,20,'blunt',4,4.00000,0,0,0,379,0,217,-1,-1,103439000,4965,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3048-3;'),
(11348,'Icarus Hall - Hail','Acumen','rhand','true',1080,1,1,'fine_steel','s80',290,20,'blunt',4,4.00000,0,0,0,379,0,217,-1,-1,103439000,4965,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3047-3;'),
(11362,'Zubei\'s Shield','','lhand','true',1210,0,0,'fine_steel','b',0,0,'none',0,0.00000,-8,216,20,0,0,0,-1,-1,419000,56,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3681-1;'),
(11374,'Avadon Shield','','lhand','true',1210,0,0,'fine_steel','b',0,0,'none',0,0.00000,-8,216,20,0,0,0,-1,-1,419000,56,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3687-1;'),
(11385,'Doom Shield','','lhand','true',1200,0,0,'fine_steel','b',0,0,'none',0,0.00000,-8,230,20,0,0,0,-1,-1,649800,87,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3700-1;'),
(11416,'Dark Crystal Shield','','lhand','true',1190,0,0,'fine_steel','a',0,0,'none',0,0.00000,-8,243,20,0,0,0,-1,-1,935000,75,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3729-1;'),
(11425,'Sealed Dark Crystal Shield','','lhand','true',1190,0,0,'fine_steel','a',0,0,'none',0,0.00000,-8,243,20,0,0,0,-1,-1,935000,75,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11469,'Sealed Shield of Nightmare','','lhand','true',1180,0,0,'fine_steel','a',0,0,'none',0,0.00000,-8,256,20,0,0,0,-1,-1,1420000,114,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11480,'Shield of Nightmare','','lhand','true',1180,0,0,'fine_steel','a',0,0,'none',0,0.00000,-8,256,20,0,0,0,-1,-1,1420000,114,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3774-1;'),
(11502,'Sealed Imperial Crusader Shield','','lhand','true',1170,0,0,'fine_steel','s',0,0,'none',0,0.00000,-8,276,20,0,0,0,-1,-1,3355000,161,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11508,'Imperial Crusader Shield','','lhand','true',1170,0,0,'fine_steel','s',0,0,'none',0,0.00000,-8,290,20,0,0,0,-1,-1,3355000,161,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3786-1;'),
(11532,'Dynasty Shield','','lhand','true',1390,0,0,'fine_steel','s80',0,0,'none',0,0.00000,-8,321,20,0,0,0,-1,-1,6404000,307,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3793-1;'),
(11569,'Sealed Dynasty Shield','','lhand','true',1370,0,0,'fine_steel','s80',0,0,'none',0,0.00000,-8,305,20,0,0,0,-1,-1,6404000,307,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11605,'Common Item - Steel Sword','','lrhand','true',700,2,2,'fine_steel','d',49,10,'bigsword',8,0.00000,0,0,0,325,0,26,-1,-1,17460,32,'true','true','true','true','true',0,0,0,0,0,0,0,0,11620,'0-0;'),
(11606,'Common Item - Strengthened Bow','','lrhand','true',623,6,2,'fine_steel','d',82,5,'bow',12,-3.00000,0,0,0,293,3,26,-1,-1,17460,32,'true','true','true','true','true',0,0,0,0,0,0,0,0,11624,'0-0;'),
(11607,'Common Item - Rapier','','rhand','true',507,2,2,'fine_steel','d',36,40,'rapier',10,-1.00000,0,0,0,406,0,26,-1,-1,17460,32,'true','true','true','true','true',3426,1,0,0,0,0,0,0,11614,'0-0;'),
(11608,'Common Item - Bagh-Nakh','','lrhand','true',513,2,2,'fine_steel','d',49,5,'dualfist',4,4.00000,0,0,0,325,0,26,-1,-1,17460,32,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11609,'Common Item - Proof of Revenge','','rhand','true',200,2,2,'fine_steel','d',32,10,'etc',8,0.00000,0,0,0,379,0,35,-1,-1,17460,32,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11610,'Common Item - Bone Staff','','lrhand','true',353,2,2,'fine_steel','d',39,20,'bigblunt',4,4.00000,0,0,0,325,0,39,-1,-1,17460,39,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11611,'Common Item - Priest Sword','','rhand','true',507,2,2,'fine_steel','d',32,10,'sword',8,0.00000,0,0,0,379,0,35,-1,-1,17460,32,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11612,'Common Item - Branch of Life','','rhand','true',207,2,2,'fine_steel','d',32,10,'etc',8,0.00000,0,0,0,379,0,35,-1,-1,17460,32,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11613,'Common Item - Crafted Dagger','','rhand','true',367,2,2,'fine_steel','d',35,5,'dagger',12,-3.00000,0,0,0,433,0,26,-1,-1,17460,32,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11614,'Common Item - Saber','','rhand','true',507,2,2,'fine_steel','d',40,10,'sword',8,0.00000,0,0,0,379,0,26,-1,-1,17460,32,'true','true','true','true','true',0,0,0,0,0,0,0,0,11607,'0-0;'),
(11615,'Common Item - Scalpel','','rhand','true',603,2,2,'fine_steel','d',40,20,'blunt',4,4.00000,0,0,0,379,0,26,-1,-1,17460,32,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11616,'Common Item - Temptation of Abyss','','rhand','true',203,2,2,'fine_steel','d',32,10,'etc',8,0.00000,0,0,0,379,0,35,-1,-1,17460,32,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11617,'Common Item - Assassin Knife','','rhand','true',367,2,2,'fine_steel','d',35,5,'dagger',12,-3.00000,0,0,0,433,0,26,-1,-1,17460,32,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11618,'Common Item - Work Hammer','','rhand','true',597,2,2,'fine_steel','d',40,20,'blunt',4,4.00000,0,0,0,379,0,26,-1,-1,17460,32,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11619,'Common Item - Scroll of Wisdom','','rhand','true',203,2,2,'fine_steel','d',32,10,'etc',8,0.00000,0,0,0,379,0,35,-1,-1,17460,32,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11620,'Common Item - Talwar','','lrhand','true',700,2,2,'fine_steel','d',43,15,'ancient',8,2.00000,0,0,0,350,0,26,-1,-1,17460,32,'true','true','true','true','true',0,0,0,0,0,0,0,0,11605,'0-0;'),
(11621,'Common Item - Talwar','','lrhand','true',700,2,2,'fine_steel','d',43,15,'ancient',8,2.00000,0,0,0,350,0,26,-1,-1,17460,32,'true','true','true','true','true',0,0,0,0,0,0,0,0,11625,'0-0;'),
(11622,'Common Item - Trident','','lrhand','true',700,2,2,'fine_steel','d',40,10,'pole',8,-3.00000,0,0,0,325,0,26,-1,-1,17460,32,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3599-1;'),
(11623,'Common Item - Hand Axe','','rhand','true',607,2,2,'fine_steel','d',40,20,'blunt',4,4.00000,0,0,0,379,0,26,-1,-1,17460,32,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11624,'Common Item - Field Gun','','rhand','true',623,3,2,'fine_steel','d',51,10,'crossbow',10,-1.00000,0,0,0,303,0,26,-1,-1,17460,32,'true','true','true','true','true',0,0,0,0,0,0,0,0,11606,'0-0;'),
(11625,'Common Item - Heavy Sword','','lrhand','true',507,2,2,'fine_steel','d',49,10,'bigsword',8,0.00000,0,0,0,325,0,26,-1,-1,17460,32,'true','true','true','true','true',0,0,0,0,0,0,0,0,11621,'0-0;'),
(11626,'Common Item - Heavy Mace','','rhand','true',600,2,2,'fine_steel','d',40,20,'blunt',4,4.00000,0,0,0,379,0,26,-1,-1,17460,32,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11627,'Common Item - Mace of Prayer','','rhand','true',433,2,2,'fine_steel','d',41,20,'blunt',4,4.00000,0,0,0,379,0,43,-1,-1,26020,48,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11628,'Common Item - Knight\'s Sword','','rhand','true',500,2,2,'fine_steel','d',51,10,'sword',8,0.00000,0,0,0,379,0,32,-1,-1,26020,48,'true','true','true','true','true',0,0,0,0,0,0,0,0,11651,'0-0;'),
(11629,'Common Item - Dark Elven Bow','','lrhand','true',610,6,2,'fine_steel','d',105,5,'bow',12,-3.00000,0,0,0,293,4,32,-1,-1,26020,48,'true','true','true','true','true',0,0,0,0,0,0,0,0,11654,'0-0;'),
(11630,'Common Item - Doom Hammer','','rhand','true',400,2,2,'fine_steel','d',41,20,'blunt',4,4.00000,0,0,0,379,0,43,-1,-1,26020,48,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11631,'Common Item - Dwarven Trident','','lrhand','true',697,2,2,'fine_steel','d',51,10,'pole',8,-3.00000,0,0,0,325,0,32,-1,-1,26020,48,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3599-1;'),
(11632,'Common Item - Long Bow','','lrhand','true',610,6,2,'fine_steel','d',114,5,'bow',12,-3.00000,0,0,0,227,4,35,-1,-1,26020,48,'true','true','true','true','true',0,0,0,0,0,0,0,0,11652,'0-0;'),
(11633,'Common Item - Staff of Mana','','lrhand','true',347,2,2,'fine_steel','d',50,20,'bigblunt',4,4.00000,0,0,0,325,0,47,-1,-1,26020,48,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11634,'Common Item - Mystic Staff','','lrhand','true',347,2,2,'fine_steel','d',50,20,'bigblunt',4,4.00000,0,0,0,325,0,47,-1,-1,26020,48,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11635,'Common Item - Bastard Sword','','rhand','true',503,2,2,'fine_steel','d',51,10,'sword',8,0.00000,0,0,0,379,0,32,-1,-1,26020,48,'true','true','true','true','true',0,0,0,0,0,0,0,0,11648,'0-0;'),
(11636,'Common Item - Spinebone Sword','','rhand','true',503,2,2,'fine_steel','d',51,10,'sword',8,0.00000,0,0,0,379,0,32,-1,-1,26020,48,'true','true','true','true','true',0,0,0,0,0,0,0,0,11649,'0-0;'),
(11637,'Common Item - Divine Tome','','rhand','true',190,2,2,'fine_steel','d',41,10,'etc',8,0.00000,0,0,0,379,0,43,-1,-1,26020,48,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11638,'Common Item - Mace of Judgement','','rhand','true',427,2,2,'fine_steel','d',41,20,'blunt',4,4.00000,0,0,0,379,0,43,-1,-1,26020,48,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11639,'Common Item - Military Talwar','','lrhand','true',693,2,2,'fine_steel','d',55,15,'ancient',8,2.00000,0,0,0,350,0,32,-1,-1,26020,48,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11640,'Common Item - Elven Bow','','lrhand','true',617,6,2,'fine_steel','d',105,5,'bow',12,-3.00000,0,0,0,293,4,32,-1,-1,26020,48,'true','true','true','true','true',0,0,0,0,0,0,0,0,11653,'0-0;'),
(11641,'Common Item - Mace of Miracle','','rhand','true',417,2,2,'fine_steel','d',41,20,'blunt',4,4.00000,0,0,0,379,0,43,-1,-1,26020,48,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11642,'Common Item - Single-Edged Jamadhr','','lrhand','true',517,2,2,'fine_steel','d',62,5,'dualfist',4,4.00000,0,0,0,325,0,32,-1,-1,26020,48,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11643,'Common Item - Artisan\'s Sword','','rhand','true',500,2,2,'fine_steel','d',51,10,'sword',8,0.00000,0,0,0,379,0,32,-1,-1,26020,48,'true','true','true','true','true',0,0,0,0,0,0,0,0,11650,'0-0;'),
(11644,'Common Item - Conjuror\'s Staff','','lrhand','true',343,2,2,'fine_steel','d',50,20,'bigblunt',4,4.00000,0,0,0,325,0,47,-1,-1,26020,48,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11645,'Common Item - Tomahawk','','rhand','true',593,2,2,'fine_steel','d',51,20,'blunt',4,4.00000,0,0,0,379,0,32,-1,-1,26020,48,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11646,'Common Item - Poniard Dagger','','rhand','true',363,2,2,'fine_steel','d',45,5,'dagger',12,-3.00000,0,0,0,433,0,32,-1,-1,26020,48,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11647,'Common Item - Pike','','lrhand','true',697,2,2,'fine_steel','d',51,10,'pole',8,-3.00000,0,0,0,325,0,32,-1,-1,26020,48,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3599-1;'),
(11648,'Common Item - Fleuret','','rhand','true',500,2,2,'fine_steel','d',46,40,'rapier',10,-1.00000,0,0,0,406,0,32,-1,-1,26020,48,'true','true','true','true','true',3426,1,0,0,0,0,0,0,11635,'0-0;'),
(11649,'Common Item - Fleuret','','rhand','true',500,2,2,'fine_steel','d',46,40,'rapier',10,-1.00000,0,0,0,406,0,32,-1,-1,26020,48,'true','true','true','true','true',3426,1,0,0,0,0,0,0,11636,'0-0;'),
(11650,'Common Item - Fleuret','','rhand','true',500,2,2,'fine_steel','d',46,40,'rapier',10,-1.00000,0,0,0,406,0,32,-1,-1,26020,48,'true','true','true','true','true',3426,1,0,0,0,0,0,0,11643,'0-0;'),
(11651,'Common Item - Fleuret','','rhand','true',500,2,2,'fine_steel','d',46,40,'rapier',10,-1.00000,0,0,0,406,0,32,-1,-1,26020,48,'true','true','true','true','true',3426,1,0,0,0,0,0,0,11628,'0-0;'),
(11652,'Common Item - Hand Crossbow','','rhand','true',617,4,2,'fine_steel','d',64,10,'crossbow',10,-1.00000,0,0,0,303,0,32,-1,-1,26020,48,'true','true','true','true','true',0,0,0,0,0,0,0,0,11632,'0-0;'),
(11653,'Common Item - Hand Crossbow','','rhand','true',617,4,2,'fine_steel','d',64,10,'crossbow',10,-1.00000,0,0,0,303,0,32,-1,-1,26020,48,'true','true','true','true','true',0,0,0,0,0,0,0,0,11640,'0-0;'),
(11654,'Common Item - Hand Crossbow','','rhand','true',617,4,2,'fine_steel','d',64,10,'crossbow',10,-1.00000,0,0,0,303,0,32,-1,-1,26020,48,'true','true','true','true','true',0,0,0,0,0,0,0,0,11629,'0-0;'),
(11655,'Common Item - Sword of Magic','','rhand','true',323,2,2,'fine_steel','d',43,10,'sword',8,0.00000,0,0,0,379,0,45,-1,-1,28620,53,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11656,'Common Item - Sword of Mystic','','rhand','true',327,2,2,'fine_steel','d',43,10,'sword',8,0.00000,0,0,0,379,0,45,-1,-1,28620,53,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11657,'Common Item - Sword of Occult','','rhand','true',323,2,2,'fine_steel','d',43,10,'sword',8,0.00000,0,0,0,379,0,45,-1,-1,28620,53,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11658,'Common Item - Saber*Saber','','lrhand','true',843,2,2,'fine_steel','d',73,10,'dual',8,0.00000,0,0,0,325,0,37,-1,-1,34020,63,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11659,'Common Item - Gastraphetes','','lrhand','true',613,8,2,'fine_steel','d',132,5,'bow',12,-3.00000,0,0,0,293,4,39,-1,-1,37400,69,'true','true','true','true','true',0,0,0,0,0,0,0,0,11674,'0-0;'),
(11660,'Common Item - Shilen Knife','','rhand','true',250,2,2,'fine_steel','d',45,5,'dagger',12,-3.00000,0,0,0,433,0,52,-1,-1,37400,69,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11661,'Common Item - Dwarven Pike','','lrhand','true',690,2,2,'fine_steel','d',64,10,'pole',8,-3.00000,0,0,0,325,0,39,-1,-1,37400,69,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3599-1;'),
(11662,'Common Item - Dagger of Mana','','rhand','true',250,2,2,'fine_steel','d',45,5,'dagger',12,-3.00000,0,0,0,433,0,52,-1,-1,37400,69,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11663,'Common Item - Staff of Magic','','lrhand','true',340,2,2,'fine_steel','d',62,20,'bigblunt',4,4.00000,0,0,0,325,0,57,-1,-1,37400,69,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11664,'Common Item - Mystic Knife','','rhand','true',253,2,2,'fine_steel','d',45,5,'dagger',12,-3.00000,0,0,0,433,0,52,-1,-1,37400,69,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11665,'Common Item - Triple-Edged Jamadhr','','lrhand','true',513,2,2,'fine_steel','d',78,5,'dualfist',4,4.00000,0,0,0,325,0,39,-1,-1,37400,69,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11666,'Common Item - Spiked Club','','rhand','true',583,2,2,'fine_steel','d',64,20,'blunt',4,4.00000,0,0,0,379,0,39,-1,-1,37400,69,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11667,'Common Item - Two-Handed Sword','','lrhand','true',727,2,2,'fine_steel','d',78,10,'bigsword',8,0.00000,0,0,0,325,0,39,-1,-1,37400,69,'true','true','true','true','true',0,0,0,0,0,0,0,0,11677,'0-0;'),
(11668,'Common Item - Estoc','','rhand','true',490,2,2,'fine_steel','d',58,40,'rapier',10,-1.00000,0,0,0,406,0,39,-1,-1,37400,69,'true','true','true','true','true',3426,1,0,0,0,0,0,0,11675,'0-0;'),
(11669,'Common Item - Estoc','','rhand','true',490,2,2,'fine_steel','d',58,40,'rapier',10,-1.00000,0,0,0,406,0,39,-1,-1,37400,69,'true','true','true','true','true',3426,1,0,0,0,0,0,0,11670,'0-0;'),
(11670,'Common Item - Elven Sword','','rhand','true',490,2,2,'fine_steel','d',64,10,'sword',8,0.00000,0,0,0,379,0,39,-1,-1,37400,69,'true','true','true','true','true',0,0,0,0,0,0,0,0,11669,'0-0;'),
(11671,'Common Item - War Hammer','','lrhand','true',693,2,2,'fine_steel','d',64,10,'pole',8,-3.00000,0,0,0,325,0,39,-1,-1,37400,69,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3599-1;'),
(11672,'Common Item - Conjuror\'s Knife','','rhand','true',250,2,2,'fine_steel','d',45,5,'dagger',12,-3.00000,0,0,0,433,0,52,-1,-1,37400,69,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11673,'Common Item - Kukuri','','rhand','true',360,2,2,'fine_steel','d',56,5,'dagger',12,-3.00000,0,0,0,433,0,39,-1,-1,37400,69,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11674,'Common Item - Crossbow','','rhand','true',613,4,2,'fine_steel','d',81,10,'crossbow',10,-1.00000,0,0,0,303,0,39,-1,-1,37400,69,'true','true','true','true','true',0,0,0,0,0,0,0,0,11659,'0-0;'),
(11675,'Common Item - Crimson Sword','','rhand','true',497,2,2,'fine_steel','d',64,10,'sword',8,0.00000,0,0,0,379,0,39,-1,-1,37400,69,'true','true','true','true','true',0,0,0,0,0,0,0,0,11668,'0-0;'),
(11676,'Common Item - Tome of Blood','','rhand','true',190,2,2,'fine_steel','d',51,10,'etc',8,0.00000,0,0,0,379,0,52,-1,-1,37400,69,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11677,'Common Item - Field Sword','','lrhand','true',687,2,2,'fine_steel','d',69,15,'ancient',8,2.00000,0,0,0,350,0,39,-1,-1,37400,69,'true','true','true','true','true',0,0,0,0,0,0,0,0,11667,'0-0;'),
(11678,'Common Item - Blood of Saints','','rhand','true',193,2,2,'fine_steel','d',51,10,'etc',8,0.00000,0,0,0,379,0,52,-1,-1,37400,69,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11679,'Common Item - Saber*Knight\'s Sword','','lrhand','true',837,3,3,'fine_steel','d',83,10,'dual',8,0.00000,0,0,0,325,0,41,-1,-1,40710,75,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11680,'Common Item - Saber*Bastard Sword','','lrhand','true',840,3,3,'fine_steel','d',83,10,'dual',8,0.00000,0,0,0,325,0,41,-1,-1,40710,75,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11681,'Common Item - Saber*Spinebone Sword','','lrhand','true',843,3,3,'fine_steel','d',83,10,'dual',8,0.00000,0,0,0,325,0,41,-1,-1,40710,75,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11682,'Common Item - Saber*Artisan\'s Sword','','lrhand','true',840,3,3,'fine_steel','d',83,10,'dual',8,0.00000,0,0,0,325,0,41,-1,-1,40710,75,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11683,'Common Item - Strengthened Long Bow','','lrhand','true',607,10,3,'fine_steel','d',179,5,'bow',12,-3.00000,0,0,0,227,5,51,-1,-1,52050,96,'true','true','true','true','true',0,0,0,0,0,0,0,0,11701,'0-0;'),
(11684,'Common Item - Knight\'s Sword*Knight\'s Sword','','lrhand','true',820,3,3,'fine_steel','d',96,10,'dual',8,0.00000,0,0,0,325,0,47,-1,-1,52050,96,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11685,'Common Item - Maingauche','','rhand','true',357,3,3,'fine_steel','d',69,5,'dagger',12,-3.00000,0,0,0,433,0,47,-1,-1,52050,96,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11686,'Common Item - Morning Star','','rhand','true',573,3,3,'fine_steel','d',79,20,'blunt',4,4.00000,0,0,0,379,0,47,-1,-1,52050,96,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11687,'Common Item - Bastard Sword*Knight\'s Sword','','lrhand','true',833,3,3,'fine_steel','d',96,10,'dual',8,0.00000,0,0,0,325,0,47,-1,-1,52050,96,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11688,'Common Item - Bastard Sword*Bastard Sword','','lrhand','true',823,3,3,'fine_steel','d',96,10,'dual',8,0.00000,0,0,0,325,0,47,-1,-1,52050,96,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11689,'Common Item - Bastard Sword*Spinebone Sword','','lrhand','true',823,3,3,'fine_steel','d',96,10,'dual',8,0.00000,0,0,0,325,0,47,-1,-1,52050,96,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11690,'Common Item - Bastard Sword*Artisan\'s Sword','','lrhand','true',827,3,3,'fine_steel','d',96,10,'dual',8,0.00000,0,0,0,325,0,47,-1,-1,52050,96,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11691,'Common Item - Bich\'Hwa','','lrhand','true',503,3,3,'fine_steel','d',96,5,'dualfist',4,4.00000,0,0,0,325,0,47,-1,-1,52050,96,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11692,'Common Item - Priest Mace','','rhand','true',573,3,3,'fine_steel','d',63,20,'blunt',4,4.00000,0,0,0,379,0,63,-1,-1,52050,96,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11693,'Common Item - Goat Head Staff','','lrhand','true',333,3,3,'fine_steel','d',77,20,'bigblunt',4,4.00000,0,0,0,325,0,69,-1,-1,52050,96,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11694,'Common Item - Saber*Elven Sword','','lrhand','true',837,3,3,'fine_steel','d',96,10,'dual',8,0.00000,0,0,0,325,0,47,-1,-1,52050,96,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11695,'Common Item - Saber*Crimson Sword','','lrhand','true',843,3,3,'fine_steel','d',96,10,'dual',8,0.00000,0,0,0,325,0,47,-1,-1,52050,96,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11696,'Common Item - Sword of Magic Fog','','rhand','true',483,3,3,'fine_steel','d',63,10,'sword',8,0.00000,0,0,0,379,0,63,-1,-1,52050,96,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11697,'Common Item - Skull Breaker','','rhand','true',580,3,3,'fine_steel','d',79,20,'blunt',4,4.00000,0,0,0,379,0,47,-1,-1,52050,96,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11698,'Common Item - Spinebone Sword*Knight\'s Sword','','lrhand','true',823,3,3,'fine_steel','d',96,10,'dual',8,0.00000,0,0,0,325,0,47,-1,-1,52050,96,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11699,'Common Item - Spinebone Sword*Spinebone Sword','','lrhand','true',840,3,3,'fine_steel','d',96,10,'dual',8,0.00000,0,0,0,325,0,47,-1,-1,52050,96,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11700,'Common Item - Spinebone Sword*Artisan\'s Sword','','lrhand','true',820,3,3,'fine_steel','d',96,10,'dual',8,0.00000,0,0,0,325,0,47,-1,-1,52050,96,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11701,'Common Item - Arm Breaker','','rhand','true',607,6,3,'fine_steel','d',100,10,'crossbow',10,-1.00000,0,0,0,303,0,47,-1,-1,52050,96,'true','true','true','true','true',0,0,0,0,0,0,0,0,11683,'0-0;'),
(11702,'Common Item - Epee','','rhand','true',483,3,3,'fine_steel','d',72,40,'rapier',10,-1.00000,0,0,0,406,0,47,-1,-1,52050,96,'true','true','true','true','true',3426,1,0,0,0,0,0,0,11714,'0-0;'),
(11703,'Common Item - Winged Spear','','lrhand','true',687,3,3,'fine_steel','d',79,10,'pole',8,-3.00000,0,0,0,325,0,47,-1,-1,52050,96,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3599-1;'),
(11704,'Common Item - Artisan\'s Sword*Knight\'s Sword','','lrhand','true',823,3,3,'fine_steel','d',96,10,'dual',8,0.00000,0,0,0,325,0,47,-1,-1,52050,96,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11705,'Common Item - Artisan\'s Sword*Artisan\'s Sword','','lrhand','true',827,3,3,'fine_steel','d',96,10,'dual',8,0.00000,0,0,0,325,0,47,-1,-1,52050,96,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11706,'Common Item - Cursed Maingauche','','rhand','true',357,3,3,'fine_steel','d',62,5,'dagger',12,-3.00000,0,0,0,433,0,42,-1,-1,52050,96,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11707,'Common Item - Katzbalger','','lrhand','true',673,3,3,'fine_steel','d',86,15,'ancient',8,2.00000,0,0,0,350,0,47,-1,-1,52050,96,'true','true','true','true','true',0,0,0,0,0,0,0,0,11710,'0-0;'),
(11708,'Common Item - Tarbar','','rhand','true',577,3,3,'fine_steel','d',79,20,'blunt',4,4.00000,0,0,0,379,0,47,-1,-1,52050,96,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11709,'Common Item - Crucifix of Blood','','rhand','true',180,3,3,'fine_steel','d',63,10,'etc',8,0.00000,0,0,0,379,0,63,-1,-1,52050,96,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11710,'Common Item - Titan Sword','','lrhand','true',673,3,3,'fine_steel','d',96,10,'bigsword',8,0.00000,0,0,0,325,0,47,-1,-1,52050,96,'true','true','true','true','true',0,0,0,0,0,0,0,0,11707,'0-0;'),
(11711,'Common Item - Titan Hammer','','lrhand','true',700,3,3,'fine_steel','d',96,20,'bigblunt',4,4.00000,0,0,0,325,0,47,-1,-1,52050,96,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11712,'Common Item - War Pick','','lrhand','true',683,3,3,'fine_steel','d',79,10,'pole',8,-3.00000,0,0,0,325,0,47,-1,-1,52050,96,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3599-1;'),
(11713,'Common Item - Heavy Bone Club','','rhand','true',577,3,3,'fine_steel','d',79,20,'blunt',4,4.00000,0,0,0,379,0,47,-1,-1,52050,96,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11714,'Common Item - Sword of Revolution','','rhand','true',483,3,3,'fine_steel','d',79,10,'sword',8,0.00000,0,0,0,379,0,47,-1,-1,52050,96,'true','true','true','true','true',0,0,0,0,0,0,0,0,11702,'0-0;'),
(11715,'Common Item - Demon Fangs','','rhand','true',533,3,3,'fine_steel','d',67,10,'etc',8,0.00000,0,0,0,379,0,66,-1,-1,56310,104,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11716,'Common Item - Knight\'s Sword*Elven Sword','','lrhand','true',817,3,3,'fine_steel','d',107,10,'dual',8,0.00000,0,0,0,325,0,51,-1,-1,60780,112,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11717,'Common Item - Knight\'s Sword*Crimson Sword','','lrhand','true',820,3,3,'fine_steel','d',107,10,'dual',8,0.00000,0,0,0,325,0,51,-1,-1,60780,112,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11718,'Common Item - Bastard Sword*Elven Sword','','lrhand','true',820,3,3,'fine_steel','d',107,10,'dual',8,0.00000,0,0,0,325,0,51,-1,-1,60780,112,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11719,'Common Item - Bastard Sword*Crimson Sword','','lrhand','true',823,3,3,'fine_steel','d',107,10,'dual',8,0.00000,0,0,0,325,0,51,-1,-1,60780,112,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11720,'Common Item - Spinebone Sword*Elven Sword','','lrhand','true',820,3,3,'fine_steel','d',107,10,'dual',8,0.00000,0,0,0,325,0,51,-1,-1,60780,112,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11721,'Common Item - Spinebone Sword*Crimson Sword','','lrhand','true',840,3,3,'fine_steel','d',107,10,'dual',8,0.00000,0,0,0,325,0,51,-1,-1,60780,112,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11722,'Common Item - Artisan\'s Sword*Elven Sword','','lrhand','true',823,3,3,'fine_steel','d',107,10,'dual',8,0.00000,0,0,0,325,0,51,-1,-1,60780,112,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11723,'Common Item - Artisan\'s Sword*Crimson Sword','','lrhand','true',817,3,3,'fine_steel','d',107,10,'dual',8,0.00000,0,0,0,325,0,51,-1,-1,60780,112,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11724,'Common Item - Grand Epee','','rhand','true',480,3,3,'fine_steel','d',83,40,'rapier',10,-1.00000,0,0,0,406,0,54,-1,-1,65580,121,'true','true','true','true','true',3426,1,0,0,0,0,0,0,11733,'0-0;'),
(11725,'Common Item - Glaive','','lrhand','true',683,3,3,'fine_steel','d',92,10,'pole',8,-3.00000,0,0,0,325,0,54,-1,-1,65580,121,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3599-1;'),
(11726,'Common Item - Mithril Dagger','','rhand','true',353,3,3,'fine_steel','d',80,5,'dagger',12,-3.00000,0,0,0,433,0,54,-1,-1,65580,121,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11727,'Common Item - Bonebreaker','','rhand','true',573,3,3,'fine_steel','d',92,20,'blunt',4,4.00000,0,0,0,379,0,54,-1,-1,65580,121,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11728,'Common Item - Light Crossbow','','lrhand','true',603,10,3,'fine_steel','d',191,5,'bow',12,-3.00000,0,0,0,293,6,54,-1,-1,65580,121,'true','true','true','true','true',0,0,0,0,0,0,0,0,11735,'0-0;'),
(11729,'Common Item - Staff of Life','','rhand','true',393,3,3,'fine_steel','d',74,20,'blunt',4,4.00000,0,0,0,379,0,72,-1,-1,65580,121,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11730,'Common Item - Scallop Jamadhr','','lrhand','true',507,3,3,'fine_steel','d',112,5,'dualfist',4,4.00000,0,0,0,325,0,54,-1,-1,65580,121,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11731,'Common Item - Atuba Mace','','lrhand','true',337,3,3,'fine_steel','d',90,20,'bigblunt',4,4.00000,0,0,0,325,0,79,-1,-1,65580,121,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11732,'Common Item - Atuba Hammer','','lrhand','true',337,3,3,'fine_steel','d',90,20,'bigblunt',4,4.00000,0,0,0,325,0,79,-1,-1,65580,121,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11733,'Common Item - Elven Long Sword','','rhand','true',480,3,3,'fine_steel','d',92,10,'sword',8,0.00000,0,0,0,379,0,54,-1,-1,65580,121,'true','true','true','true','true',0,0,0,0,0,0,0,0,11724,'0-0;'),
(11734,'Common Item - General\'s Katzbalger','','lrhand','true',670,3,3,'fine_steel','d',100,15,'ancient',8,2.00000,0,0,0,350,0,54,-1,-1,65580,121,'true','true','true','true','true',0,0,0,0,0,0,0,0,11736,'0-0;'),
(11735,'Common Item - Cranequin','','rhand','true',603,6,3,'fine_steel','d',117,10,'crossbow',10,-1.00000,0,0,0,303,0,54,-1,-1,65580,121,'true','true','true','true','true',0,0,0,0,0,0,0,0,11728,'0-0;'),
(11736,'Common Item - Claymore','','lrhand','true',697,3,3,'fine_steel','d',112,10,'bigsword',8,0.00000,0,0,0,325,0,54,-1,-1,65580,121,'true','true','true','true','true',0,0,0,0,0,0,0,0,11734,'0-0;'),
(11737,'Common Item - Ghost Staff','','lrhand','true',333,3,3,'fine_steel','d',90,20,'bigblunt',4,4.00000,0,0,0,325,0,79,-1,-1,65580,121,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11738,'Common Item - Saber*Sword of Revolution','','lrhand','true',807,2,2,'fine_steel','c',118,10,'dual',8,0.00000,0,0,0,325,0,56,-1,-1,70600,28,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11739,'Common Item - Elven Sword*Elven Sword','','lrhand','true',813,2,2,'fine_steel','c',118,10,'dual',8,0.00000,0,0,0,325,0,56,-1,-1,70600,28,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11740,'Common Item - Crimson Sword*Elven Sword','','lrhand','true',817,2,2,'fine_steel','c',118,10,'dual',8,0.00000,0,0,0,325,0,56,-1,-1,70600,28,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11741,'Common Item - Crimson Sword*Crimson Sword','','lrhand','true',813,2,2,'fine_steel','c',118,10,'dual',8,0.00000,0,0,0,325,0,56,-1,-1,70600,28,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11742,'Common Item - Knight\'s Sword*Sword of Revolution','','lrhand','true',810,2,2,'fine_steel','c',124,10,'dual',8,0.00000,0,0,0,325,0,58,-1,-1,75980,30,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11743,'Common Item - Bastard Sword*Sword of Revolution','','lrhand','true',817,2,2,'fine_steel','c',124,10,'dual',8,0.00000,0,0,0,325,0,58,-1,-1,75980,30,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11744,'Common Item - Spinebone Sword*Sword of Revolution','','lrhand','true',820,2,2,'fine_steel','c',124,10,'dual',8,0.00000,0,0,0,325,0,58,-1,-1,75980,30,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11745,'Common Item - Artisan\'s Sword*Sword of Revolution','','lrhand','true',807,2,2,'fine_steel','c',124,10,'dual',8,0.00000,0,0,0,325,0,58,-1,-1,75980,30,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11746,'Common Item - Wolverine Needle','','rhand','true',347,2,2,'fine_steel','c',94,5,'dagger',12,-3.00000,0,0,0,433,0,61,-1,-1,81600,33,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11747,'Common Item - Dark Elven Dagger','','rhand','true',350,2,2,'fine_steel','c',94,5,'dagger',12,-3.00000,0,0,0,433,0,61,-1,-1,81600,33,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11748,'Common Item - Mysterious Sword','','rhand','true',477,2,2,'fine_steel','c',85,10,'sword',8,0.00000,0,0,0,379,0,81,-1,-1,81600,33,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11749,'Common Item - Body Slasher','','lrhand','true',677,2,2,'fine_steel','c',107,10,'pole',8,-3.00000,0,0,0,325,0,61,-1,-1,81600,33,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3599-1;'),
(11750,'Common Item - Battle Axe','','rhand','true',573,2,2,'fine_steel','c',107,20,'blunt',4,4.00000,0,0,0,379,0,61,-1,-1,81600,33,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11751,'Common Item - Scythe','','lrhand','true',680,2,2,'fine_steel','c',107,10,'pole',8,-3.00000,0,0,0,325,0,61,-1,-1,81600,33,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3599-1;'),
(11752,'Common Item - Saber*Elven Long Sword','','lrhand','true',807,2,2,'fine_steel','c',130,10,'dual',8,0.00000,0,0,0,325,0,61,-1,-1,81600,33,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11753,'Common Item - Soldat Estoc','','rhand','true',477,2,2,'fine_steel','c',97,40,'rapier',10,-1.00000,0,0,0,406,0,61,-1,-1,81600,33,'true','true','true','true','true',3426,1,0,0,0,0,0,0,11756,'0-0;'),
(11754,'Common Item - Schlager','','lrhand','true',660,2,2,'fine_steel','c',116,15,'ancient',8,2.00000,0,0,0,350,0,61,-1,-1,81600,33,'true','true','true','true','true',0,0,0,0,0,0,0,0,11766,'0-0;'),
(11755,'Common Item - Skull Graver','','rhand','true',547,2,2,'fine_steel','c',107,20,'blunt',4,4.00000,0,0,0,379,0,61,-1,-1,81600,33,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11756,'Common Item - Stormbringer','','rhand','true',477,2,2,'fine_steel','c',107,10,'sword',8,0.00000,0,0,0,379,0,61,-1,-1,81600,33,'true','true','true','true','true',0,0,0,0,0,0,0,0,11753,'0-0;'),
(11757,'Common Item - Stick of Faith','','rhand','true',387,2,2,'fine_steel','c',85,20,'blunt',4,4.00000,0,0,0,379,0,81,-1,-1,81600,33,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11758,'Common Item - Arbalest','','rhand','true',597,4,2,'fine_steel','c',135,10,'crossbow',10,-1.00000,0,0,0,303,0,61,-1,-1,81600,33,'true','true','true','true','true',0,0,0,0,0,0,0,0,11759,'0-0;'),
(11759,'Common Item - Crystallized Ice Bow','','lrhand','true',597,8,2,'fine_steel','c',220,5,'bow',12,-3.00000,0,0,0,293,6,61,-1,-1,81600,33,'true','true','true','true','true',0,0,0,0,0,0,0,0,11758,'0-0;'),
(11760,'Common Item - Orcish Glaive','','lrhand','true',677,2,2,'fine_steel','c',107,10,'pole',8,-3.00000,0,0,0,325,0,61,-1,-1,81600,33,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3599-1;'),
(11761,'Common Item - Silver Axe','','rhand','true',563,2,2,'fine_steel','c',107,20,'blunt',4,4.00000,0,0,0,379,0,61,-1,-1,81600,33,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11762,'Common Item - Cursed Dagger','','rhand','true',347,2,2,'fine_steel','c',94,5,'dagger',12,-3.00000,0,0,0,433,0,61,-1,-1,81600,33,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11763,'Common Item - Chakram','','lrhand','true',497,2,2,'fine_steel','c',130,5,'dualfist',4,4.00000,0,0,0,325,0,61,-1,-1,81600,33,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11764,'Common Item - Crystal Staff','','lrhand','true',340,2,2,'fine_steel','c',103,20,'bigblunt',4,4.00000,0,0,0,325,0,89,-1,-1,81600,33,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11765,'Common Item - Big Hammer','','rhand','true',570,2,2,'fine_steel','c',107,20,'blunt',4,4.00000,0,0,0,379,0,61,-1,-1,81600,33,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11766,'Common Item - Flamberge','','lrhand','true',670,2,2,'fine_steel','c',130,10,'bigsword',8,0.00000,0,0,0,325,0,61,-1,-1,81600,33,'true','true','true','true','true',0,0,0,0,0,0,0,0,11754,'0-0;'),
(11767,'Common Item - Heavy Doom Axe','','lrhand','true',337,2,2,'fine_steel','c',103,20,'bigblunt',4,4.00000,0,0,0,325,0,89,-1,-1,81600,33,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11768,'Common Item - Heavy Doom Hammer','','lrhand','true',340,2,2,'fine_steel','c',103,20,'bigblunt',4,4.00000,0,0,0,325,0,89,-1,-1,81600,33,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11769,'Common Item - Knight\'s Sword*Elven Long Sword','','lrhand','true',790,2,2,'fine_steel','c',136,10,'dual',8,0.00000,0,0,0,325,0,63,-1,-1,87420,35,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11770,'Common Item - Bastard Sword*Elven Long Sword','','lrhand','true',810,2,2,'fine_steel','c',136,10,'dual',8,0.00000,0,0,0,325,0,63,-1,-1,87420,35,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11771,'Common Item - Spinebone Sword*Elven Long Sword','','lrhand','true',797,2,2,'fine_steel','c',136,10,'dual',8,0.00000,0,0,0,325,0,63,-1,-1,87420,35,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11772,'Common Item - Elven Sword*Sword of Revolution','','lrhand','true',803,2,2,'fine_steel','c',136,10,'dual',8,0.00000,0,0,0,325,0,63,-1,-1,87420,35,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11773,'Common Item - Artisan\'s Sword*Elven Long Sword','','lrhand','true',803,2,2,'fine_steel','c',136,10,'dual',8,0.00000,0,0,0,325,0,63,-1,-1,87420,35,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11774,'Common Item - Crimson Sword*Sword of Revolution','','lrhand','true',797,2,2,'fine_steel','c',136,10,'dual',8,0.00000,0,0,0,325,0,63,-1,-1,87420,35,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11775,'Common Item - Elven Bow of Nobility','','lrhand','true',587,8,2,'fine_steel','c',252,5,'bow',12,-3.00000,0,0,0,293,7,68,-1,-1,100200,40,'true','true','true','true','true',0,0,0,0,0,0,0,0,11781,'0-0;'),
(11776,'Common Item - Knuckle Duster','','lrhand','true',497,2,2,'fine_steel','c',148,5,'dualfist',4,4.00000,0,0,0,325,0,68,-1,-1,100200,40,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11777,'Common Item - Dwarven War Hammer','','rhand','true',557,2,2,'fine_steel','c',122,20,'blunt',4,4.00000,0,0,0,379,0,68,-1,-1,100200,40,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11778,'Common Item - Raid Sword','','rhand','true',473,2,2,'fine_steel','c',122,10,'sword',8,0.00000,0,0,0,379,0,68,-1,-1,100200,40,'true','true','true','true','true',0,0,0,0,0,0,0,0,11784,'0-0;'),
(11779,'Common Item - Soulfire Dirk','','rhand','true',250,2,2,'fine_steel','c',86,5,'dagger',12,-3.00000,0,0,0,433,0,91,-1,-1,100200,40,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11780,'Common Item - Ballista','','rhand','true',590,5,2,'fine_steel','c',155,10,'crossbow',10,-1.00000,0,0,0,303,0,68,-1,-1,100200,40,'true','true','true','true','true',0,0,0,0,0,0,0,0,11790,'0-0;'),
(11781,'Common Item - Ballista','','rhand','true',590,5,2,'fine_steel','c',155,10,'crossbow',10,-1.00000,0,0,0,303,0,68,-1,-1,100200,40,'true','true','true','true','true',0,0,0,0,0,0,0,0,11775,'0-0;'),
(11782,'Common Item - Bec de Corbin','','lrhand','true',673,2,2,'fine_steel','c',122,10,'pole',8,-3.00000,0,0,0,325,0,68,-1,-1,100200,40,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3599-1;'),
(11783,'Common Item - Shamshir','','rhand','true',473,2,2,'fine_steel','c',122,10,'sword',8,0.00000,0,0,0,379,0,68,-1,-1,100200,40,'true','true','true','true','true',0,0,0,0,0,0,0,0,11785,'0-0;'),
(11784,'Common Item - Chevalier Rapier','','rhand','true',473,2,2,'fine_steel','c',111,40,'rapier',10,-1.00000,0,0,0,406,0,68,-1,-1,100200,40,'true','true','true','true','true',3426,1,0,0,0,0,0,0,11778,'0-0;'),
(11785,'Common Item - Chevalier Rapier','','rhand','true',473,2,2,'fine_steel','c',111,40,'rapier',10,-1.00000,0,0,0,406,0,68,-1,-1,100200,40,'true','true','true','true','true',3426,1,0,0,0,0,0,0,11783,'0-0;'),
(11786,'Common Item - Chevalier Rapier','','rhand','true',473,2,2,'fine_steel','c',111,40,'rapier',10,-1.00000,0,0,0,406,0,68,-1,-1,100200,40,'true','true','true','true','true',3426,1,0,0,0,0,0,0,11794,'0-0;'),
(11787,'Common Item - Chevalier Rapier','','rhand','true',473,2,2,'fine_steel','c',111,40,'rapier',10,-1.00000,0,0,0,406,0,68,-1,-1,100200,40,'true','true','true','true','true',3426,1,0,0,0,0,0,0,11789,'0-0;'),
(11788,'Common Item - Stiletto','','rhand','true',343,2,2,'fine_steel','c',107,5,'dagger',12,-3.00000,0,0,0,433,0,68,-1,-1,100200,40,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11789,'Common Item - Spirit Sword','','rhand','true',473,2,2,'fine_steel','c',122,10,'sword',8,0.00000,0,0,0,379,0,68,-1,-1,100200,40,'true','true','true','true','true',0,0,0,0,0,0,0,0,11787,'0-0;'),
(11790,'Common Item - Elemental Bow','','lrhand','true',590,8,2,'fine_steel','c',277,5,'bow',12,-3.00000,0,0,0,227,7,75,-1,-1,100200,40,'true','true','true','true','true',0,0,0,0,0,0,0,0,11780,'0-0;'),
(11791,'Common Item - Elven Sword*Elven Long Sword','','lrhand','true',803,2,2,'fine_steel','c',148,10,'dual',8,0.00000,0,0,0,325,0,68,-1,-1,100200,40,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11792,'Common Item - Horn of Glory','','rhand','true',180,2,2,'fine_steel','c',98,10,'etc',8,0.00000,0,0,0,379,0,91,-1,-1,100200,40,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11793,'Common Item - Cursed Staff','','lrhand','true',333,2,2,'fine_steel','c',119,20,'bigblunt',4,4.00000,0,0,0,325,0,100,-1,-1,100200,40,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11794,'Common Item - Katana','','rhand','true',473,2,2,'fine_steel','c',122,10,'sword',8,0.00000,0,0,0,379,0,68,-1,-1,100200,40,'true','true','true','true','true',0,0,0,0,0,0,0,0,11786,'0-0;'),
(11795,'Common Item - Crimson Sword*Elven Long Sword','','lrhand','true',787,2,2,'fine_steel','c',148,10,'dual',8,0.00000,0,0,0,325,0,68,-1,-1,100200,40,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11796,'Common Item - Sword of Revolution*Sword of Revolution','','lrhand','true',787,2,2,'fine_steel','c',148,10,'dual',8,0.00000,0,0,0,325,0,68,-1,-1,100200,40,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11797,'Common Item - Sword of Revolution*Elven Long Sword','','lrhand','true',780,3,3,'fine_steel','c',155,10,'dual',8,0.00000,0,0,0,325,0,70,-1,-1,150600,60,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11798,'Common Item - Elven Long Sword*Elven Long Sword','','lrhand','true',780,3,3,'fine_steel','c',162,10,'dual',8,0.00000,0,0,0,325,0,73,-1,-1,169400,68,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11799,'Common Item - Stick of Eternity','','rhand','true',377,3,3,'fine_steel','c',111,20,'blunt',4,4.00000,0,0,0,379,0,101,-1,-1,182200,73,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11800,'Common Item - Grace Dagger','','rhand','true',340,3,3,'fine_steel','c',122,5,'dagger',12,-3.00000,0,0,0,433,0,76,-1,-1,182200,73,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11801,'Common Item - Sword of Limit','','rhand','true',467,3,3,'fine_steel','c',139,10,'sword',8,0.00000,0,0,0,379,0,76,-1,-1,182200,73,'true','true','true','true','true',0,0,0,0,0,0,0,0,11808,'0-0;'),
(11802,'Common Item - Nirvana Axe','','rhand','true',383,3,3,'fine_steel','c',111,20,'blunt',4,4.00000,0,0,0,379,0,101,-1,-1,182200,73,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11803,'Common Item - Dark Screamer','','rhand','true',337,3,3,'fine_steel','c',122,5,'dagger',12,-3.00000,0,0,0,433,0,76,-1,-1,182200,73,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11804,'Common Item - Club of Nature','','rhand','true',367,3,3,'fine_steel','c',111,20,'blunt',4,4.00000,0,0,0,379,0,101,-1,-1,182200,73,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11805,'Common Item - Sword of Whispering Death','','rhand','true',307,3,3,'fine_steel','c',111,10,'sword',8,0.00000,0,0,0,379,0,101,-1,-1,182200,73,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11806,'Common Item - Mace of the Underworld','','rhand','true',363,3,3,'fine_steel','c',111,20,'blunt',4,4.00000,0,0,0,379,0,101,-1,-1,182200,73,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11807,'Common Item - Sword of Delusion','','rhand','true',467,3,3,'fine_steel','c',139,10,'sword',8,0.00000,0,0,0,379,0,76,-1,-1,182200,73,'true','true','true','true','true',0,0,0,0,0,0,0,0,11810,'0-0;'),
(11808,'Common Item - Blinzlasher','','rhand','true',467,3,3,'fine_steel','c',126,40,'rapier',10,-1.00000,0,0,0,406,0,76,-1,-1,182200,73,'true','true','true','true','true',3426,1,0,0,0,0,0,0,11801,'0-0;'),
(11809,'Common Item - Blinzlasher','','rhand','true',467,3,3,'fine_steel','c',126,40,'rapier',10,-1.00000,0,0,0,406,0,76,-1,-1,182200,73,'true','true','true','true','true',3426,1,0,0,0,0,0,0,11821,'0-0;'),
(11810,'Common Item - Blinzlasher','','rhand','true',467,3,3,'fine_steel','c',126,40,'rapier',10,-1.00000,0,0,0,406,0,76,-1,-1,182200,73,'true','true','true','true','true',3426,1,0,0,0,0,0,0,11807,'0-0;'),
(11811,'Common Item - Blinzlasher','','rhand','true',467,3,3,'fine_steel','c',126,40,'rapier',10,-1.00000,0,0,0,406,0,76,-1,-1,182200,73,'true','true','true','true','true',3426,1,0,0,0,0,0,0,11820,'0-0;'),
(11812,'Common Item - Blinzlasher','','rhand','true',467,3,3,'fine_steel','c',126,40,'rapier',10,-1.00000,0,0,0,406,0,76,-1,-1,182200,73,'true','true','true','true','true',3426,1,0,0,0,0,0,0,11815,'0-0;'),
(11813,'Common Item - Pa\'agrian Sword','','lrhand','true',660,3,3,'fine_steel','c',169,10,'bigsword',8,0.00000,0,0,0,325,0,76,-1,-1,182200,73,'true','true','true','true','true',0,0,0,0,0,0,0,0,11818,'0-0;'),
(11814,'Common Item - Akat Long Bow','','lrhand','true',580,9,3,'fine_steel','c',316,5,'bow',12,-3.00000,0,0,0,227,7,84,-1,-1,182200,73,'true','true','true','true','true',0,0,0,0,0,0,0,0,11823,'0-0;'),
(11815,'Common Item - Sword of Nightmare','','rhand','true',467,3,3,'fine_steel','c',139,10,'sword',8,0.00000,0,0,0,379,0,76,-1,-1,182200,73,'true','true','true','true','true',0,0,0,0,0,0,0,0,11812,'0-0;'),
(11816,'Common Item - War Axe','','rhand','true',553,3,3,'fine_steel','c',139,20,'blunt',4,4.00000,0,0,0,379,0,76,-1,-1,182200,73,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11817,'Common Item - Heathen\'s Book','','rhand','true',187,3,3,'fine_steel','c',111,10,'etc',8,0.00000,0,0,0,379,0,101,-1,-1,182200,73,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11818,'Common Item - Immortal Edge','','lrhand','true',660,3,3,'fine_steel','c',151,15,'ancient',8,2.00000,0,0,0,350,0,76,-1,-1,182200,73,'true','true','true','true','true',0,0,0,0,0,0,0,0,11813,'0-0;'),
(11819,'Common Item - Inferno Staff','','lrhand','true',333,3,3,'fine_steel','c',135,20,'bigblunt',4,4.00000,0,0,0,325,0,111,-1,-1,182200,73,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11820,'Common Item - Tsurugi','','rhand','true',467,3,3,'fine_steel','c',139,10,'sword',8,0.00000,0,0,0,379,0,76,-1,-1,182200,73,'true','true','true','true','true',0,0,0,0,0,0,0,0,11811,'0-0;'),
(11821,'Common Item - Caliburs','','rhand','true',467,3,3,'fine_steel','c',139,10,'sword',8,0.00000,0,0,0,379,0,76,-1,-1,182200,73,'true','true','true','true','true',0,0,0,0,0,0,0,0,11809,'0-0;'),
(11822,'Common Item - Karik Horn','','lrhand','true',673,3,3,'fine_steel','c',169,20,'bigblunt',4,4.00000,0,0,0,325,0,76,-1,-1,182200,73,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11823,'Common Item - Tathlum','','rhand','true',587,5,3,'fine_steel','c',176,10,'crossbow',10,-1.00000,0,0,0,303,0,76,-1,-1,182200,73,'true','true','true','true','true',0,0,0,0,0,0,0,0,11814,'0-0;'),
(11824,'Common Item - Pa\'agrian Hammer','','lrhand','true',337,3,3,'fine_steel','c',135,20,'bigblunt',4,4.00000,0,0,0,325,0,111,-1,-1,182200,73,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11825,'Common Item - Paradia Staff','','lrhand','true',337,3,3,'fine_steel','c',135,20,'bigblunt',4,4.00000,0,0,0,325,0,111,-1,-1,182200,73,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11826,'Common Item - Poleaxe','','lrhand','true',670,3,3,'fine_steel','c',139,10,'pole',8,-3.00000,0,0,0,325,0,76,-1,-1,182200,73,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3599-1;'),
(11827,'Common Item - Fisted Blade','','lrhand','true',493,3,3,'fine_steel','c',169,5,'dualfist',4,4.00000,0,0,0,325,0,76,-1,-1,182200,73,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11828,'Common Item - Sage\'s Staff','','lrhand','true',333,3,3,'fine_steel','c',135,20,'bigblunt',4,4.00000,0,0,0,325,0,111,-1,-1,182200,73,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11829,'Common Item - Homunkulus\'s Sword','','rhand','true',317,3,3,'fine_steel','c',111,10,'sword',8,0.00000,0,0,0,379,0,101,-1,-1,182200,73,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11830,'Common Item - Scorpion','','lrhand','true',663,3,3,'fine_steel','c',144,10,'pole',8,-3.00000,0,0,0,325,0,78,-1,-1,194400,78,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3599-1;'),
(11831,'Common Item - Stormbringer*Stormbringer','','lrhand','true',777,3,3,'fine_steel','c',175,10,'dual',8,0.00000,0,0,0,325,0,78,-1,-1,194400,78,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11832,'Common Item - Widow Maker','','lrhand','true',660,3,3,'fine_steel','c',144,10,'pole',8,-3.00000,0,0,0,325,0,78,-1,-1,194400,78,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3599-1;'),
(11833,'Common Item - Pa\'agrian Axe','','lrhand','true',330,3,3,'fine_steel','c',141,20,'bigblunt',4,4.00000,0,0,0,325,0,114,-1,-1,194400,78,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11834,'Common Item - Stormbringer*Raid Sword','','lrhand','true',780,3,3,'fine_steel','c',183,10,'dual',8,0.00000,0,0,0,325,0,81,-1,-1,207000,83,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11835,'Common Item - Stormbringer*Shamshir','','lrhand','true',767,3,3,'fine_steel','c',183,10,'dual',8,0.00000,0,0,0,325,0,81,-1,-1,207000,83,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11836,'Common Item - Stormbringer*Spirit Sword','','lrhand','true',770,3,3,'fine_steel','c',183,10,'dual',8,0.00000,0,0,0,325,0,81,-1,-1,207000,83,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11837,'Common Item - Stormbringer*Katana','','lrhand','true',773,3,3,'fine_steel','c',183,10,'dual',8,0.00000,0,0,0,325,0,81,-1,-1,207000,83,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11838,'Common Item - Ghoul\'s Staff','','lrhand','true',333,3,3,'fine_steel','c',152,20,'bigblunt',4,4.00000,0,0,0,325,0,122,-1,-1,279400,112,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11839,'Common Item - Great Pata','','lrhand','true',487,3,3,'fine_steel','c',190,5,'dualfist',4,4.00000,0,0,0,325,0,83,-1,-1,279400,112,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11840,'Common Item - Dwarven Hammer','','lrhand','true',670,3,3,'fine_steel','c',190,20,'bigblunt',4,4.00000,0,0,0,325,0,83,-1,-1,279400,112,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11841,'Common Item - Raid Sword*Raid Sword','','lrhand','true',750,3,3,'fine_steel','c',190,10,'dual',8,0.00000,0,0,0,325,0,83,-1,-1,279400,112,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11842,'Common Item - Deadman\'s Staff','','lrhand','true',337,3,3,'fine_steel','c',152,20,'bigblunt',4,4.00000,0,0,0,325,0,122,-1,-1,279400,112,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11843,'Common Item - Berserker Blade','','lrhand','true',460,3,3,'fine_steel','c',190,10,'bigsword',8,0.00000,0,0,0,325,0,83,-1,-1,279400,112,'true','true','true','true','true',0,0,0,0,0,0,0,0,11849,'0-0;'),
(11844,'Common Item - Sharpshooter','','rhand','true',580,6,3,'fine_steel','c',198,10,'crossbow',10,-1.00000,0,0,0,303,0,83,-1,-1,279400,112,'true','true','true','true','true',0,0,0,0,0,0,0,0,11857,'0-0;'),
(11845,'Common Item - Shamshir*Raid Sword','','lrhand','true',760,3,3,'fine_steel','c',190,10,'dual',8,0.00000,0,0,0,325,0,83,-1,-1,279400,112,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11846,'Common Item - Shamshir*Shamshir','','lrhand','true',777,3,3,'fine_steel','c',190,10,'dual',8,0.00000,0,0,0,325,0,83,-1,-1,279400,112,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11847,'Common Item - Shamshir*Spirit Sword','','lrhand','true',760,3,3,'fine_steel','c',190,10,'dual',8,0.00000,0,0,0,325,0,83,-1,-1,279400,112,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11848,'Common Item - Shamshir*Katana','','lrhand','true',770,3,3,'fine_steel','c',190,10,'dual',8,0.00000,0,0,0,325,0,83,-1,-1,279400,112,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11849,'Common Item - Saber Tooth','','lrhand','true',650,3,3,'fine_steel','c',169,15,'ancient',8,2.00000,0,0,0,350,0,83,-1,-1,279400,112,'true','true','true','true','true',0,0,0,0,0,0,0,0,11843,'0-0;'),
(11850,'Common Item - Ecliptic Sword','','rhand','true',460,3,3,'fine_steel','c',125,10,'sword',8,0.00000,0,0,0,379,0,111,-1,-1,279400,112,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11851,'Common Item - Spirit Sword*Raid Sword','','lrhand','true',753,3,3,'fine_steel','c',190,10,'dual',8,0.00000,0,0,0,325,0,83,-1,-1,279400,112,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11852,'Common Item - Spirit Sword*Spirit Sword','','lrhand','true',747,3,3,'fine_steel','c',190,10,'dual',8,0.00000,0,0,0,325,0,83,-1,-1,279400,112,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11853,'Common Item - Samurai Long Sword','','rhand','true',460,3,3,'fine_steel','c',156,10,'sword',8,0.00000,0,0,0,379,0,83,-1,-1,279400,112,'true','true','true','true','true',0,0,0,0,0,0,0,0,11854,'0-0;'),
(11854,'Common Item - Admiral\'s Estoc','','rhand','true',460,3,3,'fine_steel','c',141,40,'rapier',10,-1.00000,0,0,0,406,0,83,-1,-1,279400,112,'true','true','true','true','true',3426,1,0,0,0,0,0,0,11853,'0-0;'),
(11855,'Common Item - Demon\'s Staff','','lrhand','true',330,3,3,'fine_steel','c',152,20,'bigblunt',4,4.00000,0,0,0,325,0,122,-1,-1,279400,112,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11856,'Common Item - Yaksa Mace','','rhand','true',547,3,3,'fine_steel','c',156,20,'blunt',4,4.00000,0,0,0,379,0,83,-1,-1,279400,112,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11857,'Common Item - Eminence Bow','','lrhand','true',573,10,3,'fine_steel','c',323,5,'bow',12,-3.00000,0,0,0,293,8,83,-1,-1,279400,112,'true','true','true','true','true',0,0,0,0,0,0,0,0,11844,'0-0;'),
(11858,'Common Item - Orcish Poleaxe','','lrhand','true',650,3,3,'fine_steel','c',156,10,'pole',8,-3.00000,0,0,0,325,0,83,-1,-1,279400,112,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3599-1;'),
(11859,'Common Item - Ecliptic Axe','','rhand','true',547,3,3,'fine_steel','c',125,20,'blunt',4,4.00000,0,0,0,379,0,111,-1,-1,279400,112,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11860,'Common Item - Katana*Raid Sword','','lrhand','true',757,3,3,'fine_steel','c',190,10,'dual',8,0.00000,0,0,0,325,0,83,-1,-1,279400,112,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11861,'Common Item - Katana*Spirit Sword','','lrhand','true',750,3,3,'fine_steel','c',190,10,'dual',8,0.00000,0,0,0,325,0,83,-1,-1,279400,112,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11862,'Common Item - Katana*Katana','','lrhand','true',757,3,3,'fine_steel','c',190,10,'dual',8,0.00000,0,0,0,325,0,83,-1,-1,279400,112,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11863,'Common Item - Crystal Dagger','','rhand','true',333,3,3,'fine_steel','c',136,5,'dagger',12,-3.00000,0,0,0,433,0,83,-1,-1,279400,112,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11864,'Common Item - Stormbringer*Sword of Limit','','lrhand','true',747,1,1,'fine_steel','b',197,10,'dual',8,0.00000,0,0,0,325,0,86,-1,-1,308500,41,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11865,'Common Item - Stormbringer*Sword of Delusion','','lrhand','true',743,1,1,'fine_steel','b',197,10,'dual',8,0.00000,0,0,0,325,0,86,-1,-1,308500,41,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11866,'Common Item - Stormbringer*Sword of Nightmare','','lrhand','true',750,1,1,'fine_steel','b',197,10,'dual',8,0.00000,0,0,0,325,0,86,-1,-1,308500,41,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11867,'Common Item - Stormbringer*Tsurugi','','lrhand','true',740,1,1,'fine_steel','b',197,10,'dual',8,0.00000,0,0,0,325,0,86,-1,-1,308500,41,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11868,'Common Item - Stormbringer*Caliburs','','lrhand','true',753,1,1,'fine_steel','b',197,10,'dual',8,0.00000,0,0,0,325,0,86,-1,-1,308500,41,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11869,'Common Item - Raid Sword*Sword of Limit','','lrhand','true',723,1,1,'fine_steel','b',204,10,'dual',8,0.00000,0,0,0,325,0,89,-1,-1,329600,44,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11870,'Common Item - Raid Sword*Sword of Delusion','','lrhand','true',727,1,1,'fine_steel','b',204,10,'dual',8,0.00000,0,0,0,325,0,89,-1,-1,329600,44,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11871,'Common Item - Raid Sword*Sword of Nightmare','','lrhand','true',723,1,1,'fine_steel','b',204,10,'dual',8,0.00000,0,0,0,325,0,89,-1,-1,329600,44,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11872,'Common Item - Raid Sword*Tsurugi','','lrhand','true',723,1,1,'fine_steel','b',204,10,'dual',8,0.00000,0,0,0,325,0,89,-1,-1,329600,44,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11873,'Common Item - Raid Sword*Caliburs','','lrhand','true',730,1,1,'fine_steel','b',204,10,'dual',8,0.00000,0,0,0,325,0,89,-1,-1,329600,44,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11874,'Common Item - Shamshir*Sword of Limit','','lrhand','true',747,1,1,'fine_steel','b',204,10,'dual',8,0.00000,0,0,0,325,0,89,-1,-1,329600,44,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11875,'Common Item - Shamshir*Sword of Delusion','','lrhand','true',733,1,1,'fine_steel','b',204,10,'dual',8,0.00000,0,0,0,325,0,89,-1,-1,329600,44,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11876,'Common Item - Shamshir*Sword of Nightmare','','lrhand','true',737,1,1,'fine_steel','b',204,10,'dual',8,0.00000,0,0,0,325,0,89,-1,-1,329600,44,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11877,'Common Item - Shamshir*Tsurugi','','lrhand','true',740,1,1,'fine_steel','b',204,10,'dual',8,0.00000,0,0,0,325,0,89,-1,-1,329600,44,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11878,'Common Item - Shamshir*Caliburs','','lrhand','true',743,1,1,'fine_steel','b',204,10,'dual',8,0.00000,0,0,0,325,0,89,-1,-1,329600,44,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11879,'Common Item - Spirit Sword*Sword of Limit','','lrhand','true',747,1,1,'fine_steel','b',204,10,'dual',8,0.00000,0,0,0,325,0,89,-1,-1,329600,44,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11880,'Common Item - Spirit Sword*Sword of Delusion','','lrhand','true',750,1,1,'fine_steel','b',204,10,'dual',8,0.00000,0,0,0,325,0,89,-1,-1,329600,44,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11881,'Common Item - Spirit Sword*Sword of Nightmare','','lrhand','true',750,1,1,'fine_steel','b',204,10,'dual',8,0.00000,0,0,0,325,0,89,-1,-1,329600,44,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11882,'Common Item - Spirit Sword*Tsurugi','','lrhand','true',740,1,1,'fine_steel','b',204,10,'dual',8,0.00000,0,0,0,325,0,89,-1,-1,329600,44,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11883,'Common Item - Spirit Sword*Caliburs','','lrhand','true',747,1,1,'fine_steel','b',204,10,'dual',8,0.00000,0,0,0,325,0,89,-1,-1,329600,44,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11884,'Common Item - Katana*Sword of Limit','','lrhand','true',727,1,1,'fine_steel','b',204,10,'dual',8,0.00000,0,0,0,325,0,89,-1,-1,329600,44,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11885,'Common Item - Katana*Sword of Delusion','','lrhand','true',730,1,1,'fine_steel','b',204,10,'dual',8,0.00000,0,0,0,325,0,89,-1,-1,329600,44,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11886,'Common Item - Katana*Sword of Nightmare','','lrhand','true',723,1,1,'fine_steel','b',204,10,'dual',8,0.00000,0,0,0,325,0,89,-1,-1,329600,44,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11887,'Common Item - Katana*Tsurugi','','lrhand','true',737,1,1,'fine_steel','b',204,10,'dual',8,0.00000,0,0,0,325,0,89,-1,-1,329600,44,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11888,'Common Item - Katana*Caliburs','','lrhand','true',740,1,1,'fine_steel','b',204,10,'dual',8,0.00000,0,0,0,325,0,89,-1,-1,329600,44,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11889,'Common Item - Great Sword','','lrhand','true',643,1,1,'fine_steel','b',213,10,'bigsword',8,0.00000,0,0,0,325,0,91,-1,-1,349500,47,'true','true','true','true','true',0,0,0,0,0,0,0,0,11895,'0-0;'),
(11890,'Common Item - Great Axe','','lrhand','true',647,1,1,'fine_steel','b',175,10,'pole',8,-3.00000,0,0,0,325,0,91,-1,-1,349500,47,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3599-1;'),
(11891,'Common Item - Sword of Limit*Sword of Limit','','lrhand','true',713,1,1,'fine_steel','b',213,10,'dual',8,0.00000,0,0,0,325,0,91,-1,-1,349500,47,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11892,'Common Item - Sword of Limit*Sword of Delusion','','lrhand','true',713,1,1,'fine_steel','b',213,10,'dual',8,0.00000,0,0,0,325,0,91,-1,-1,349500,47,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11893,'Common Item - Sword of Limit*Sword of Nightmare','','lrhand','true',710,1,1,'fine_steel','b',213,10,'dual',8,0.00000,0,0,0,325,0,91,-1,-1,349500,47,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11894,'Common Item - Sword of Limit*Tsurugi','','lrhand','true',707,1,1,'fine_steel','b',213,10,'dual',8,0.00000,0,0,0,325,0,91,-1,-1,349500,47,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11895,'Common Item - Innominate Victory','','lrhand','true',643,1,1,'fine_steel','b',190,15,'ancient',8,2.00000,0,0,0,350,0,91,-1,-1,349500,47,'true','true','true','true','true',0,0,0,0,0,0,0,0,11889,'0-0;'),
(11896,'Common Item - Dark Elven Long Bow','','lrhand','true',573,3,1,'fine_steel','b',397,5,'bow',12,-3.00000,0,0,0,227,8,100,-1,-1,349500,47,'true','true','true','true','true',0,0,0,0,0,0,0,0,11917,'0-0;'),
(11897,'Common Item - Sword of Delusion*Sword of Delusion','','lrhand','true',717,1,1,'fine_steel','b',213,10,'dual',8,0.00000,0,0,0,325,0,91,-1,-1,349500,47,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11898,'Common Item - Sword of Delusion*Sword of Nightmare','','lrhand','true',710,1,1,'fine_steel','b',213,10,'dual',8,0.00000,0,0,0,325,0,91,-1,-1,349500,47,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11899,'Common Item - Sword of Delusion*Tsurugi','','lrhand','true',713,1,1,'fine_steel','b',213,10,'dual',8,0.00000,0,0,0,325,0,91,-1,-1,349500,47,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11900,'Common Item - Sword of Valhalla','','rhand','true',300,1,1,'fine_steel','b',140,10,'sword',8,0.00000,0,0,0,379,0,122,-1,-1,349500,47,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11901,'Common Item - Stormbringer*Samurai Long Sword','','lrhand','true',717,1,1,'fine_steel','b',213,10,'dual',8,0.00000,0,0,0,325,0,91,-1,-1,349500,47,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11902,'Common Item - Spell Breaker','','rhand','true',540,1,1,'fine_steel','b',140,20,'blunt',4,4.00000,0,0,0,379,0,122,-1,-1,349500,47,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11903,'Common Item - Arthro Nail','','lrhand','true',473,1,1,'fine_steel','b',213,5,'dualfist',4,4.00000,0,0,0,325,0,91,-1,-1,349500,47,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11904,'Common Item - Ice Storm Hammer','','lrhand','true',650,1,1,'fine_steel','b',213,20,'bigblunt',4,4.00000,0,0,0,325,0,91,-1,-1,349500,47,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11905,'Common Item - Sword of Nightmare*Sword of Nightmare','','lrhand','true',710,1,1,'fine_steel','b',213,10,'dual',8,0.00000,0,0,0,325,0,91,-1,-1,349500,47,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11906,'Common Item - Sword of Nightmare*Tsurugi','','lrhand','true',713,1,1,'fine_steel','b',213,10,'dual',8,0.00000,0,0,0,325,0,91,-1,-1,349500,47,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11907,'Common Item - Military Fleuret','','rhand','true',457,1,1,'fine_steel','b',159,40,'rapier',10,-1.00000,0,0,0,406,0,91,-1,-1,349500,47,'true','true','true','true','true',3426,1,0,0,0,0,0,0,11916,'0-0;'),
(11908,'Common Item - Sprite\'s Staff','','lrhand','true',320,1,1,'fine_steel','b',170,20,'bigblunt',4,4.00000,0,0,0,325,0,134,-1,-1,349500,47,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11909,'Common Item - Tsurugi*Tsurugi','','lrhand','true',707,1,1,'fine_steel','b',213,10,'dual',8,0.00000,0,0,0,325,0,91,-1,-1,349500,47,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11910,'Common Item - Caliburs*Sword of Limit','','lrhand','true',717,1,1,'fine_steel','b',213,10,'dual',8,0.00000,0,0,0,325,0,91,-1,-1,349500,47,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11911,'Common Item - Caliburs*Sword of Delusion','','lrhand','true',713,1,1,'fine_steel','b',213,10,'dual',8,0.00000,0,0,0,325,0,91,-1,-1,349500,47,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11912,'Common Item - Caliburs*Sword of Nightmare','','lrhand','true',723,1,1,'fine_steel','b',213,10,'dual',8,0.00000,0,0,0,325,0,91,-1,-1,349500,47,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11913,'Common Item - Caliburs*Tsurugi','','lrhand','true',717,1,1,'fine_steel','b',213,10,'dual',8,0.00000,0,0,0,325,0,91,-1,-1,349500,47,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11914,'Common Item - Caliburs*Caliburs','','lrhand','true',713,1,1,'fine_steel','b',213,10,'dual',8,0.00000,0,0,0,325,0,91,-1,-1,349500,47,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11915,'Common Item - Kris','','rhand','true',327,1,1,'fine_steel','b',153,5,'dagger',12,-3.00000,0,0,0,433,0,91,-1,-1,349500,47,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11916,'Common Item - Keshanberk','','rhand','true',457,1,1,'fine_steel','b',175,10,'sword',8,0.00000,0,0,0,379,0,91,-1,-1,349500,47,'true','true','true','true','true',0,0,0,0,0,0,0,0,11907,'0-0;'),
(11917,'Common Item - Peacemaker','','rhand','true',573,2,1,'fine_steel','b',221,10,'crossbow',10,-1.00000,0,0,0,303,0,91,-1,-1,349500,47,'true','true','true','true','true',0,0,0,0,0,0,0,0,11896,'0-0;'),
(11918,'Common Item - Heavy War Axe','','rhand','true',540,1,1,'fine_steel','b',175,20,'blunt',4,4.00000,0,0,0,379,0,91,-1,-1,349500,47,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11919,'Common Item - Hell Knife','','rhand','true',247,1,1,'fine_steel','b',122,5,'dagger',12,-3.00000,0,0,0,433,0,122,-1,-1,349500,47,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11920,'Common Item - Raid Sword*Samurai Long Sword','','lrhand','true',710,1,1,'fine_steel','b',220,10,'dual',8,0.00000,0,0,0,325,0,94,-1,-1,364400,49,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11921,'Common Item - Shamshir*Samurai Long Sword','','lrhand','true',703,1,1,'fine_steel','b',220,10,'dual',8,0.00000,0,0,0,325,0,94,-1,-1,364400,49,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11922,'Common Item - Spirit Sword*Samurai Long Sword','','lrhand','true',703,1,1,'fine_steel','b',220,10,'dual',8,0.00000,0,0,0,325,0,94,-1,-1,364400,49,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11923,'Common Item - Katana*Samurai Long Sword','','lrhand','true',710,1,1,'fine_steel','b',220,10,'dual',8,0.00000,0,0,0,325,0,94,-1,-1,364400,49,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11924,'Common Item - Sword of Limit*Samurai Long Sword','','lrhand','true',700,1,1,'fine_steel','b',228,10,'dual',8,0.00000,0,0,0,325,0,97,-1,-1,542840,73,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11925,'Common Item - Sword of Delusion*Samurai Long Sword','','lrhand','true',703,1,1,'fine_steel','b',228,10,'dual',8,0.00000,0,0,0,325,0,97,-1,-1,542840,73,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11926,'Common Item - Sword of Nightmare*Samurai Long Sword','','lrhand','true',693,1,1,'fine_steel','b',228,10,'dual',8,0.00000,0,0,0,325,0,97,-1,-1,542840,73,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11927,'Common Item - Tsurugi*Samurai Long Sword','','lrhand','true',697,1,1,'fine_steel','b',228,10,'dual',8,0.00000,0,0,0,325,0,97,-1,-1,542840,73,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11928,'Common Item - Caliburs*Samurai Long Sword','','lrhand','true',707,1,1,'fine_steel','b',228,10,'dual',8,0.00000,0,0,0,325,0,97,-1,-1,542840,73,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11929,'Common Item - Guardian Sword','','lrhand','true',643,1,1,'fine_steel','b',236,10,'bigsword',8,0.00000,0,0,0,325,0,99,-1,-1,612300,82,'true','true','true','true','true',0,0,0,0,0,0,0,0,11931,'0-0;'),
(11930,'Common Item - Sword of Damascus','','rhand','true',450,1,1,'fine_steel','b',194,10,'sword',8,0.00000,0,0,0,379,0,99,-1,-1,612300,82,'true','true','true','true','true',0,0,0,0,0,0,0,0,11942,'0-0;'),
(11931,'Common Item - Dismantler','','lrhand','true',643,1,1,'fine_steel','b',210,15,'ancient',8,2.00000,0,0,0,350,0,99,-1,-1,612300,82,'true','true','true','true','true',0,0,0,0,0,0,0,0,11929,'0-0;'),
(11932,'Common Item - Lance','','lrhand','true',640,1,1,'fine_steel','b',194,10,'pole',8,-3.00000,0,0,0,325,0,99,-1,-1,612300,82,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3599-1;'),
(11933,'Common Item - Bellion Cestus','','lrhand','true',463,1,1,'fine_steel','b',236,5,'dualfist',4,4.00000,0,0,0,325,0,99,-1,-1,612300,82,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11934,'Common Item - Staff of Evil Spirits','','lrhand','true',310,1,1,'fine_steel','b',189,20,'bigblunt',4,4.00000,0,0,0,325,0,145,-1,-1,612300,82,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11935,'Common Item - Deadman\'s Glory','','rhand','true',533,1,1,'fine_steel','b',194,20,'blunt',4,4.00000,0,0,0,379,0,99,-1,-1,612300,82,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11936,'Common Item - Star Buster','','lrhand','true',643,1,1,'fine_steel','b',236,20,'bigblunt',4,4.00000,0,0,0,325,0,99,-1,-1,612300,82,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11937,'Common Item - Samurai Long Sword*Samurai Long Sword','','lrhand','true',693,1,1,'fine_steel','b',236,10,'dual',8,0.00000,0,0,0,325,0,99,-1,-1,612300,82,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11938,'Common Item - Art of Battle Axe','','rhand','true',523,1,1,'fine_steel','b',194,20,'blunt',4,4.00000,0,0,0,379,0,99,-1,-1,612300,82,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11939,'Common Item - Demon Dagger','','rhand','true',323,1,1,'fine_steel','b',170,5,'dagger',12,-3.00000,0,0,0,433,0,99,-1,-1,612300,82,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11940,'Common Item - Demon Dagger','','rhand','true',323,1,1,'fine_steel','b',170,5,'dagger',12,-3.00000,0,0,0,433,0,99,-1,-1,612300,82,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11941,'Common Item - Kaim Vanul\'s Bones','','rhand','true',523,1,1,'fine_steel','b',155,20,'blunt',4,4.00000,0,0,0,379,0,132,-1,-1,612300,82,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11942,'Common Item - Colichemarde','','rhand','true',450,1,1,'fine_steel','b',176,40,'rapier',10,-1.00000,0,0,0,406,0,99,-1,-1,612300,82,'true','true','true','true','true',3426,1,0,0,0,0,0,0,11930,'0-0;'),
(11943,'Common Item - Wizard\'s Tear','','rhand','true',450,1,1,'fine_steel','b',155,10,'sword',8,0.00000,0,0,0,379,0,132,-1,-1,612300,82,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11944,'Common Item - Bow of Peril','','lrhand','true',567,3,1,'fine_steel','b',400,5,'bow',12,-3.00000,0,0,0,293,9,99,-1,-1,612300,82,'true','true','true','true','true',0,0,0,0,0,0,0,0,11945,'0-0;'),
(11945,'Common Item - Hellbound','','rhand','true',567,2,1,'fine_steel','b',245,10,'crossbow',10,-1.00000,0,0,0,303,0,99,-1,-1,612300,82,'true','true','true','true','true',0,0,0,0,0,0,0,0,11944,'0-0;'),
(11946,'Common Item - Dasparion\'s Staff','','lrhand','true',307,1,1,'fine_steel','a',207,20,'bigblunt',4,4.00000,0,0,0,325,0,157,-1,-1,726500,58,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11947,'Common Item - Doomchanter','','rhand','true',557,1,1,'fine_steel','a',270,10,'crossbow',10,-1.00000,0,0,0,303,0,107,-1,-1,726500,58,'true','true','true','true','true',0,0,0,0,0,0,0,0,11955,'0-0;'),
(11948,'Common Item - White Lightning','','rhand','true',443,1,1,'fine_steel','a',193,40,'rapier',10,-1.00000,0,0,0,406,0,107,-1,-1,726500,58,'true','true','true','true','true',3426,1,0,0,0,0,0,0,11957,'0-0;'),
(11949,'Common Item - Meteor Shower','','rhand','true',533,1,1,'fine_steel','a',213,20,'blunt',4,4.00000,0,0,0,379,0,107,-1,-1,726500,58,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11950,'Common Item - Blood Tornado','','lrhand','true',457,1,1,'fine_steel','a',259,5,'dualfist',4,4.00000,0,0,0,325,0,107,-1,-1,726500,58,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11951,'Common Item - Bloody Orchid','','rhand','true',320,1,1,'fine_steel','a',186,5,'dagger',12,-3.00000,0,0,0,433,0,107,-1,-1,726500,58,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11952,'Common Item - Elemental Sword','','rhand','true',277,1,1,'fine_steel','a',170,10,'sword',8,0.00000,0,0,0,379,0,143,-1,-1,726500,58,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11953,'Common Item - Spiritual Eye','','rhand','true',517,1,1,'fine_steel','a',170,20,'blunt',4,4.00000,0,0,0,379,0,143,-1,-1,726500,58,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11954,'Common Item - Inferno Master','','lrhand','true',633,1,1,'fine_steel','a',259,10,'bigsword',8,0.00000,0,0,0,325,0,107,-1,-1,726500,58,'true','true','true','true','true',0,0,0,0,0,0,0,0,11959,'0-0;'),
(11955,'Common Item - Carnage Bow','','lrhand','true',557,2,1,'fine_steel','a',440,5,'bow',12,-3.00000,0,0,0,293,9,107,-1,-1,726500,58,'true','true','true','true','true',0,0,0,0,0,0,0,0,11947,'0-0;'),
(11956,'Common Item - Keshanberk*Keshanberk','','lrhand','true',693,1,1,'fine_steel','a',259,10,'dual',8,0.00000,0,0,0,325,0,107,-1,-1,726500,58,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11957,'Common Item - Tallum Blade','','rhand','true',443,1,1,'fine_steel','a',213,10,'sword',8,0.00000,0,0,0,379,0,107,-1,-1,726500,58,'true','true','true','true','true',0,0,0,0,0,0,0,0,11948,'0-0;'),
(11958,'Common Item - Destroyer Hammer','','lrhand','true',637,1,1,'fine_steel','a',259,20,'bigblunt',4,4.00000,0,0,0,325,0,107,-1,-1,726500,58,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11959,'Common Item - Divine Pain','','lrhand','true',633,1,1,'fine_steel','a',231,15,'ancient',8,2.00000,0,0,0,350,0,107,-1,-1,726500,58,'true','true','true','true','true',0,0,0,0,0,0,0,0,11954,'0-0;'),
(11960,'Common Item - Halberd','','lrhand','true',633,1,1,'fine_steel','a',213,10,'pole',8,-3.00000,0,0,0,325,0,107,-1,-1,726500,58,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3599-1;'),
(11961,'Common Item - Keshanberk*Damascus','','lrhand','true',693,1,1,'fine_steel','a',275,10,'dual',8,0.00000,0,0,0,325,0,112,-1,-1,1067200,85,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11962,'Common Item - Lacerator','','rhand','true',440,1,1,'fine_steel','a',210,40,'rapier',10,-1.00000,0,0,0,406,0,114,-1,-1,1130000,90,'true','true','true','true','true',3426,1,0,0,0,0,0,0,11964,'0-0;'),
(11963,'Common Item - Damascus*Damascus','','lrhand','true',693,1,1,'fine_steel','a',282,10,'dual',8,0.00000,0,0,0,325,0,114,-1,-1,1130000,90,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11964,'Common Item - Dark Legion','','rhand','true',440,1,1,'fine_steel','a',232,10,'sword',8,0.00000,0,0,0,379,0,114,-1,-1,1130000,90,'true','true','true','true','true',0,0,0,0,0,0,0,0,11962,'0-0;'),
(11965,'Common Item - Undertaker','','lrhand','true',613,1,1,'fine_steel','a',251,15,'ancient',8,2.00000,0,0,0,350,0,114,-1,-1,1130000,90,'true','true','true','true','true',0,0,0,0,0,0,0,0,11968,'0-0;'),
(11966,'Common Item - Doom Crusher','','lrhand','true',633,1,1,'fine_steel','a',282,20,'bigblunt',4,4.00000,0,0,0,325,0,114,-1,-1,1130000,90,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11967,'Common Item - Dragon Grinder','','lrhand','true',450,1,1,'fine_steel','a',282,5,'dualfist',4,4.00000,0,0,0,325,0,114,-1,-1,1130000,90,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11968,'Common Item - Dragon Slayer','','lrhand','true',613,1,1,'fine_steel','a',282,10,'bigsword',8,0.00000,0,0,0,325,0,114,-1,-1,1130000,90,'true','true','true','true','true',0,0,0,0,0,0,0,0,11965,'0-0;'),
(11969,'Common Item - Flaming Dragon Skull','','rhand','true',510,1,1,'fine_steel','a',186,20,'blunt',4,4.00000,0,0,0,379,0,152,-1,-1,1130000,90,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11970,'Common Item - Branch of the Mother Tree','','lrhand','true',300,1,1,'fine_steel','a',226,20,'bigblunt',4,4.00000,0,0,0,325,0,167,-1,-1,1130000,90,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11971,'Common Item - Sword of Miracles','','rhand','true',280,1,1,'fine_steel','a',186,10,'sword',8,0.00000,0,0,0,379,0,152,-1,-1,1130000,90,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11972,'Common Item - Reaper','','rhand','true',553,1,1,'fine_steel','a',294,10,'crossbow',10,-1.00000,0,0,0,303,0,114,-1,-1,1130000,90,'true','true','true','true','true',0,0,0,0,0,0,0,0,11975,'0-0;'),
(11973,'Common Item - Soul Separator','','rhand','true',317,1,1,'fine_steel','a',203,5,'dagger',12,-3.00000,0,0,0,433,0,114,-1,-1,1130000,90,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11974,'Common Item - Elysian','','rhand','true',527,1,1,'fine_steel','a',232,20,'blunt',4,4.00000,0,0,0,379,0,114,-1,-1,1130000,90,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11975,'Common Item - Soul Bow','','lrhand','true',553,2,1,'fine_steel','a',528,5,'bow',12,-3.00000,0,0,0,227,10,125,-1,-1,1130000,90,'true','true','true','true','true',0,0,0,0,0,0,0,0,11972,'0-0;'),
(11976,'Common Item - Tallum Glaive','','lrhand','true',613,1,1,'fine_steel','a',232,10,'pole',8,-3.00000,0,0,0,325,0,114,-1,-1,1130000,90,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3599-1;'),
(11977,'Common Item - Naga Storm','','rhand','true',310,1,1,'fine_steel','a',220,5,'dagger',12,-3.00000,0,0,0,433,0,121,-1,-1,1293200,103,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11978,'Common Item - Daimon Crystal','','lrhand','true',293,1,1,'fine_steel','a',245,20,'bigblunt',4,4.00000,0,0,0,325,0,177,-1,-1,1293200,103,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11979,'Common Item - Barakiel\'s Axe','','rhand','true',517,1,1,'fine_steel','a',251,20,'blunt',4,4.00000,0,0,0,379,0,121,-1,-1,1293200,103,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11980,'Common Item - Screaming Vengeance','','rhand','true',547,1,1,'fine_steel','a',318,10,'crossbow',10,-1.00000,0,0,0,303,0,121,-1,-1,1293200,103,'true','true','true','true','true',0,0,0,0,0,0,0,0,11983,'0-0;'),
(11981,'Common Item - Behemoth\'s Tuning Fork','','lrhand','true',630,1,1,'fine_steel','a',305,20,'bigblunt',4,4.00000,0,0,0,325,0,121,-1,-1,1293200,103,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11982,'Common Item - Durendal','','lrhand','true',607,1,1,'fine_steel','a',272,15,'ancient',8,2.00000,0,0,0,350,0,121,-1,-1,1293200,103,'true','true','true','true','true',0,0,0,0,0,0,0,0,11984,'0-0;'),
(11983,'Common Item - Shyeed\'s Bow','','lrhand','true',547,2,1,'fine_steel','a',570,5,'bow',12,-3.00000,0,0,0,227,10,133,-1,-1,1293200,103,'true','true','true','true','true',0,0,0,0,0,0,0,0,11980,'0-0;'),
(11984,'Common Item - Sword of Ipos','','lrhand','true',607,1,1,'fine_steel','a',305,10,'bigsword',8,0.00000,0,0,0,325,0,121,-1,-1,1293200,103,'true','true','true','true','true',0,0,0,0,0,0,0,0,11982,'0-0;'),
(11985,'Common Item - Sobekk\'s Hurricane','','lrhand','true',443,1,1,'fine_steel','a',305,5,'dualfist',4,4.00000,0,0,0,325,0,121,-1,-1,1293200,103,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11986,'Common Item - Sirra\'s Blade','','rhand','true',433,1,1,'fine_steel','a',251,10,'sword',8,0.00000,0,0,0,379,0,121,-1,-1,1293200,103,'true','true','true','true','true',0,0,0,0,0,0,0,0,11987,'0-0;'),
(11987,'Common Item - Eclair Bijou','','rhand','true',433,1,1,'fine_steel','a',228,40,'rapier',10,-1.00000,0,0,0,406,0,121,-1,-1,1293200,103,'true','true','true','true','true',3426,1,0,0,0,0,0,0,11986,'0-0;'),
(11988,'Common Item - Tiphon\'s Spear','','lrhand','true',607,1,1,'fine_steel','a',251,10,'pole',8,-3.00000,0,0,0,325,0,121,-1,-1,1293200,103,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3599-1;'),
(11989,'Common Item - Tallum Blade*Damascus','','lrhand','true',630,1,1,'fine_steel','a',305,10,'dual',8,0.00000,0,0,0,325,0,121,-1,-1,1293200,103,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11990,'Common Item - Themis\' Tongue','','rhand','true',273,1,1,'fine_steel','a',202,10,'sword',8,0.00000,0,0,0,379,0,162,-1,-1,1293200,103,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11991,'Common Item - Cabrio\'s Hand','','rhand','true',503,1,1,'fine_steel','a',202,20,'blunt',4,4.00000,0,0,0,379,0,162,-1,-1,1293200,103,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11992,'Common Item - Gram','','lrhand','true',600,1,1,'fine_steel','s',304,15,'ancient',8,2.00000,0,0,0,350,0,132,-1,-1,3477000,174,'true','true','true','true','true',0,0,0,0,0,0,0,0,12005,'0-0;'),
(11993,'Common Item - Demon Splinter','','lrhand','true',450,1,1,'fine_steel','s',342,5,'dualfist',4,4.00000,0,0,0,325,0,132,-1,-1,3477000,174,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11994,'Common Item - Draconic Bow','','lrhand','true',550,1,1,'fine_steel','s',581,5,'bow',12,-3.00000,0,0,0,293,11,132,-1,-1,3477000,174,'true','true','true','true','true',0,0,0,0,0,0,0,0,11998,'0-0;'),
(11995,'Common Item - Dragon Hunter Axe','','lrhand','true',607,1,1,'fine_steel','s',342,20,'bigblunt',4,4.00000,0,0,0,325,0,132,-1,-1,3477000,174,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11996,'Common Item - Laevateinn','','rhand','true',433,1,1,'fine_steel','s',255,40,'rapier',10,-1.00000,0,0,0,406,0,132,-1,-1,3477000,174,'true','true','true','true','true',3426,1,0,0,0,0,0,0,12004,'0-0;'),
(11997,'Common Item - Basalt Battlehammer','','rhand','true',523,1,1,'fine_steel','s',281,20,'blunt',4,4.00000,0,0,0,379,0,132,-1,-1,3477000,174,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(11998,'Common Item - Sarnga','','rhand','true',533,1,1,'fine_steel','s',356,10,'crossbow',10,-1.00000,0,0,0,303,0,132,-1,-1,3477000,174,'true','true','true','true','true',0,0,0,0,0,0,0,0,11994,'0-0;'),
(11999,'Common Item - Saint Spear','','lrhand','true',600,1,1,'fine_steel','s',281,10,'pole',8,-3.00000,0,0,0,325,0,132,-1,-1,3477000,174,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3599-1;'),
(12000,'Common Item - Arcana Mace','','rhand','true',433,1,1,'fine_steel','s',225,20,'blunt',4,4.00000,0,0,0,379,0,175,-1,-1,3477000,174,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(12001,'Common Item - Angel Slayer','','rhand','true',317,1,1,'fine_steel','s',246,5,'dagger',12,-3.00000,0,0,0,433,0,132,-1,-1,3477000,174,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(12002,'Common Item - Imperial Staff','','lrhand','true',303,1,1,'fine_steel','s',274,20,'bigblunt',4,4.00000,0,0,0,325,0,193,-1,-1,3477000,174,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(12003,'Common Item - Tallum Blade*Dark Legion','','lrhand','true',693,1,1,'fine_steel','s',342,10,'dual',8,0.00000,0,0,0,325,0,132,-1,-1,3477000,174,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(12004,'Common Item - Forgotten Blade','','rhand','true',433,1,1,'fine_steel','s',281,10,'sword',8,0.00000,0,0,0,379,0,132,-1,-1,3477000,174,'true','true','true','true','true',0,0,0,0,0,0,0,0,11996,'0-0;'),
(12005,'Common Item - Heaven\'s Divider','','lrhand','true',460,1,1,'fine_steel','s',342,10,'bigsword',8,0.00000,0,0,0,325,0,132,-1,-1,3477000,174,'true','true','true','true','true',0,0,0,0,0,0,0,0,11992,'0-0;'),
(12013,'Common Item - Bronze Shield','','lhand','true',457,0,0,'fine_steel','d',0,0,'none',0,0.00000,-8,101,20,0,0,0,-1,-1,935,2,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(12025,'Common Item - Aspis','','lhand','true',450,0,0,'fine_steel','d',0,0,'none',0,0.00000,-8,114,20,0,0,0,-1,-1,1410,3,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(12051,'Common Item - Hoplon','','lhand','true',447,0,0,'fine_steel','d',0,0,'none',0,0.00000,-8,128,20,0,0,0,-1,-1,2060,4,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(12063,'Common Item - Brigandine Shield','','lhand','true',440,0,0,'fine_steel','d',0,0,'none',0,0.00000,-8,142,20,0,0,0,-1,-1,2920,5,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(12069,'Common Item - Kite Shield','','lhand','true',440,0,0,'fine_steel','d',0,0,'none',0,0.00000,-8,142,20,0,0,0,-1,-1,2920,5,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(12073,'Common Item - Square Shield','','lhand','true',437,0,0,'fine_steel','d',0,0,'none',0,0.00000,-8,154,20,0,0,0,-1,-1,3730,7,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(12078,'Common Item - Plate Shield','','lhand','true',437,0,0,'fine_steel','d',0,0,'none',0,0.00000,-8,154,20,0,0,0,-1,-1,3730,7,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(12091,'Common Item - Eldarake','','lhand','true',430,0,0,'fine_steel','c',0,0,'none',0,0.00000,-8,166,20,0,0,0,-1,-1,4720,2,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(12096,'Common Item - Chain Shield','','lhand','true',427,0,0,'fine_steel','c',0,0,'none',0,0.00000,-8,166,20,0,0,0,-1,-1,4720,2,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(12102,'Common Item - Dwarven Chain Shield','','lhand','true',427,0,0,'fine_steel','c',0,0,'none',0,0.00000,-8,174,20,0,0,0,-1,-1,5480,2,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(12107,'Common Item - Knight\'s Shield','','lhand','true',420,0,0,'fine_steel','c',0,0,'none',0,0.00000,-8,178,20,0,0,0,-1,-1,5900,2,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(12126,'Common Item - Composite Shield','','lhand','true',410,0,0,'fine_steel','c',0,0,'none',0,0.00000,-8,190,20,0,0,0,-1,-1,10900,4,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(12129,'Common Item - Tower Shield','','lhand','true',413,0,0,'fine_steel','c',0,0,'none',0,0.00000,-8,190,20,0,0,0,-1,-1,10900,4,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(12143,'Common Item - Full Plate Shield','','lhand','true',407,0,0,'fine_steel','c',0,0,'none',0,0.00000,-8,203,20,0,0,0,-1,-1,17100,7,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(12159,'Common Item - Zubei\'s Shield','','lhand','true',403,0,0,'fine_steel','b',0,0,'none',0,0.00000,-8,216,20,0,0,0,-1,-1,21900,3,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(12171,'Common Item - Avadon Shield','','lhand','true',403,0,0,'fine_steel','b',0,0,'none',0,0.00000,-8,216,20,0,0,0,-1,-1,21900,3,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(12183,'Common Item - Doom Shield','','lhand','true',400,0,0,'fine_steel','b',0,0,'none',0,0.00000,-8,230,20,0,0,0,-1,-1,39400,5,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(12215,'Common Item - Dark Crystal Shield','','lhand','true',397,0,0,'fine_steel','a',0,0,'none',0,0.00000,-8,243,20,0,0,0,-1,-1,48200,4,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(12225,'Common Item - Sealed Dark Crystal Shield','','lhand','true',397,0,0,'fine_steel','a',0,0,'none',0,0.00000,-8,243,20,0,0,0,-1,-1,48200,4,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(12268,'Common Item - Sealed Shield of Nightmare','','lhand','true',393,0,0,'fine_steel','a',0,0,'none',0,0.00000,-8,256,20,0,0,0,-1,-1,77100,6,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(12279,'Common Item - Shield of Nightmare','','lhand','true',393,0,0,'fine_steel','a',0,0,'none',0,0.00000,-8,256,20,0,0,0,-1,-1,77100,6,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(12302,'Common Item - Sealed Imperial Crusader Shield','','lhand','true',390,0,0,'fine_steel','s',0,0,'none',0,0.00000,-8,0,20,0,0,0,-1,-1,272800,13,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(12308,'Common Item - Imperial Crusader Shield','','lhand','true',390,0,0,'fine_steel','s',0,0,'none',0,0.00000,-8,290,20,0,0,0,-1,-1,272800,13,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(12793,'O Stick','30 day limited period','rhand','false',0,0,0,'fine_steel','none',1,10,'sword',8,0.00000,0,0,0,379,0,1,-1,43200,0,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(12794,'X Stick','30 day limited period','rhand','false',0,0,0,'fine_steel','none',1,10,'sword',8,0.00000,0,0,0,379,0,1,-1,43200,0,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(12795,'Scissors Stick','30 day limited period','rhand','false',0,0,0,'fine_steel','none',1,10,'sword',8,0.00000,0,0,0,379,0,1,-1,43200,0,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(12796,'Rock Stick','30 day limited period','rhand','false',0,0,0,'fine_steel','none',1,10,'sword',8,0.00000,0,0,0,379,0,1,-1,43200,0,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(12797,'Paper Stick','30 day limited period','rhand','false',0,0,0,'fine_steel','none',1,10,'sword',8,0.00000,0,0,0,379,0,1,-1,43200,0,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(12798,'Snowman Transformation Stick','','rhand','false',0,0,0,'fine_steel','none',1,10,'sword',8,0.00000,0,0,0,379,0,1,-1,-1,0,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(12799,'Scarecrow Transformation Stick','','rhand','false',0,0,0,'fine_steel','none',1,10,'sword',8,0.00000,0,0,0,379,0,1,-1,-1,0,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(12800,'Pumpkin Transformation Stick','30 day limited period','rhand','false',0,0,0,'fine_steel','none',1,10,'sword',8,0.00000,0,0,0,379,0,1,-1,43200,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'8246-1;'),
(12801,'Condolence Flowerpot A','','rhand','false',0,0,0,'fine_steel','none',1,10,'sword',8,0.00000,0,0,0,379,0,1,-1,-1,0,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(12802,'Condolence Flowerpot B','','rhand','false',0,0,0,'fine_steel','none',1,10,'sword',8,0.00000,0,0,0,379,0,1,-1,-1,0,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(12803,'Congratulatory Flowerpot A','','rhand','false',0,0,0,'fine_steel','none',1,10,'sword',8,0.00000,0,0,0,379,0,1,-1,-1,0,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(12804,'Congratulatory Flowerpot B','','rhand','false',0,0,0,'fine_steel','none',1,10,'sword',8,0.00000,0,0,0,379,0,1,-1,-1,0,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(12805,'Flower Arrangement','','rhand','false',0,0,0,'fine_steel','none',1,10,'sword',8,0.00000,0,0,0,379,0,1,-1,-1,0,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(12806,'Bomb','','rhand','false',0,0,0,'fine_steel','none',1,10,'sword',8,0.00000,0,0,0,379,0,1,-1,-1,0,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(12807,'Direction Board','','rhand','false',0,0,0,'fine_steel','none',1,10,'sword',8,0.00000,0,0,0,379,0,1,-1,-1,0,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(12808,'Fruit Basket','','rhand','false',0,0,0,'fine_steel','none',1,10,'sword',8,0.00000,0,0,0,379,0,1,-1,-1,0,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(12809,'Arranged Clams','','rhand','false',0,0,0,'fine_steel','none',1,10,'sword',8,0.00000,0,0,0,379,0,1,-1,-1,0,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(12810,'Halloween Pumpkin','','rhand','false',0,0,0,'fine_steel','none',1,10,'sword',8,0.00000,0,0,0,379,0,1,-1,-1,0,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(12814,'Shadow Item - Gatekeeper Transformation Stick','','rhand','false',0,0,0,'fine_steel','none',1,10,'sword',8,0.00000,0,0,0,379,0,1,60,-1,0,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'8244-1;'),
(12852,'Naga Storm - Molar {PvP}','Focus','rhand','true',930,1,1,'fine_steel','a',220,5,'dagger',12,-3.00000,0,0,0,433,0,121,-1,-1,26968400,2157,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3051-1;3651-1;3652-1;3861-1;'),
(12853,'Naga Storm - Molar {PvP}','Crt. Damage','rhand','true',930,1,1,'fine_steel','a',220,5,'dagger',12,-3.00000,0,0,0,433,0,121,-1,-1,26968400,2157,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3066-2;3651-1;3652-1;3861-1;'),
(12854,'Naga Storm - Molar {PvP}','Backblow','rhand','true',930,1,1,'fine_steel','a',220,5,'dagger',12,-3.00000,0,0,0,433,0,121,-1,-1,26968400,2157,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3019-6;3651-1;3652-1;3861-1;'),
(12855,'Daimon Crystal - Wisdom {PvP}','Mana Up','lrhand','true',880,1,1,'fine_steel','a',245,20,'bigblunt',4,4.00000,0,0,0,325,0,177,-1,-1,26968400,2157,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3014-2;3654-1;3902-1;'),
(12856,'Daimon Crystal - Wisdom {PvP}','Acumen','lrhand','true',880,1,1,'fine_steel','a',245,20,'bigblunt',4,4.00000,0,0,0,325,0,177,-1,-1,26968400,2157,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3047-2;3654-1;3902-1;'),
(12857,'Daimon Crystal - Wisdom {PvP}','Magic Mental Shield','lrhand','true',880,1,1,'fine_steel','a',245,20,'bigblunt',4,4.00000,0,0,0,325,0,177,-1,-1,26968400,2157,'false','false','true','false','true',0,0,1035,2,50,0,0,0,0,'3552-1;3654-1;3902-1;'),
(12858,'Barakiel\'s Axe - On Fire {PvP}','Health','rhand','true',1550,1,1,'fine_steel','a',251,20,'blunt',4,4.00000,0,0,0,379,0,121,-1,-1,26968400,2157,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3013-3;3887-1;'),
(12859,'Barakiel\'s Axe - On Fire {PvP}','Haste','rhand','true',1550,1,1,'fine_steel','a',251,20,'blunt',4,4.00000,0,0,0,379,0,121,-1,-1,26968400,2157,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3068-2;3887-1;'),
(12860,'Barakiel\'s Axe - On Fire {PvP}','Focus','rhand','true',1550,1,1,'fine_steel','a',251,20,'blunt',4,4.00000,0,0,0,379,0,121,-1,-1,26968400,2157,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3050-2;3887-1;'),
(12861,'Screaming Vengeance - Concentration {PvP}','Cheap Shot','rhand','true',1640,1,1,'fine_steel','a',318,10,'crossbow',10,-1.00000,0,0,0,303,0,121,-1,-1,26968400,2157,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3552-1;3655-1;3868-2;'),
(12862,'Screaming Vengeance - Concentration {PvP}','Focus','rhand','true',1640,1,1,'fine_steel','a',318,10,'crossbow',10,-1.00000,0,0,0,303,0,121,-1,-1,26968400,2157,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3050-2;3655-1;3868-2;'),
(12863,'Screaming Vengeance - Concentration {PvP}','Quick Recovery','rhand','true',1640,1,1,'fine_steel','a',318,10,'crossbow',10,-1.00000,0,0,0,303,0,121,-1,-1,26968400,2157,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3552-1;3655-1;3868-2;'),
(12864,'Behemoth\'s Tuning Fork - Destruction {PvP}','Focus','lrhand','true',1890,1,1,'fine_steel','a',305,20,'bigblunt',4,4.00000,0,0,0,325,0,121,-1,-1,26968400,2157,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3050-2;3897-1;'),
(12865,'Behemoth\'s Tuning Fork - Destruction {PvP}','Health','lrhand','true',1890,1,1,'fine_steel','a',305,20,'bigblunt',4,4.00000,0,0,0,325,0,121,-1,-1,26968400,2157,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3013-3;3897-1;'),
(12866,'Behemoth\'s Tuning Fork - Destruction {PvP}','Anger','lrhand','true',1890,1,1,'fine_steel','a',305,20,'bigblunt',4,4.00000,0,0,0,325,0,121,-1,-1,26968400,2157,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3057-2;3897-1;'),
(12867,'Durendal - Earth {PvP}','Focus','lrhand','true',1820,1,1,'fine_steel','a',272,15,'ancient',8,2.00000,0,0,0,350,0,121,-1,-1,26968400,2157,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3050-2;3653-1;3849-1;'),
(12868,'Durendal - Earth {PvP}','Haste','lrhand','true',1820,1,1,'fine_steel','a',272,15,'ancient',8,2.00000,0,0,0,350,0,121,-1,-1,26968400,2157,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3068-2;3653-1;3849-1;'),
(12869,'Durendal - Earth {PvP}','Health','lrhand','true',1820,1,1,'fine_steel','a',272,15,'ancient',8,2.00000,0,0,0,350,0,121,-1,-1,26968400,2157,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3013-3;3653-1;3849-1;'),
(12870,'Shyeed\'s Bow - Concentration {PvP}','Cheap Shot','lrhand','true',1640,2,1,'fine_steel','a',571,5,'bow',12,-3.00000,0,0,0,227,10,133,-1,-1,26968400,2157,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3552-1;3863-2;'),
(12871,'Shyeed\'s Bow - Concentration {PvP}','Focus','lrhand','true',1640,2,1,'fine_steel','a',571,5,'bow',12,-3.00000,0,0,0,227,10,133,-1,-1,26968400,2157,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3050-2;3863-2;'),
(12872,'Shyeed\'s Bow - Concentration {PvP}','Quick Recovery','lrhand','true',1640,2,1,'fine_steel','a',571,5,'bow',12,-3.00000,0,0,0,227,10,133,-1,-1,26968400,2157,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3552-1;3863-2;'),
(12873,'Sword of Ipos - Earth {PvP}','Focus','lrhand','true',1820,1,1,'fine_steel','a',305,10,'bigsword',8,0.00000,0,0,0,325,0,121,-1,-1,26968400,2157,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3050-2;3653-1;3826-1;'),
(12874,'Sword of Ipos - Earth {PvP}','Haste','lrhand','true',1820,1,1,'fine_steel','a',305,10,'bigsword',8,0.00000,0,0,0,325,0,121,-1,-1,26968400,2157,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3068-2;3653-1;3826-1;'),
(12875,'Sword of Ipos - Earth {PvP}','Health','lrhand','true',1820,1,1,'fine_steel','a',305,10,'bigsword',8,0.00000,0,0,0,325,0,121,-1,-1,26968400,2157,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3013-3;3653-1;3826-1;'),
(12876,'Sobekk\'s Hurricane - Landslide {PvP}','Rsk. Haste','lrhand','true',1330,1,1,'fine_steel','a',305,5,'dualfist',4,4.00000,0,0,0,325,0,121,-1,-1,26968400,2157,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3056-2;3882-1;'),
(12877,'Sobekk\'s Hurricane - Landslide {PvP}','Haste','lrhand','true',1330,1,1,'fine_steel','a',305,5,'dualfist',4,4.00000,0,0,0,325,0,121,-1,-1,26968400,2157,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3068-2;3882-1;'),
(12878,'Sobekk\'s Hurricane - Landslide {PvP}','Crt. Drain','lrhand','true',1330,1,1,'fine_steel','a',305,5,'dualfist',4,4.00000,0,0,0,325,0,121,-1,-1,26968400,2157,'false','false','true','false','true',0,0,0,0,0,3039,6,33,0,'3552-1;3882-1;'),
(12879,'Sirra\'s Blade - Landslide {PvP}','Haste','rhand','true',1300,1,1,'fine_steel','a',251,10,'sword',8,0.00000,0,0,0,379,0,121,-1,-1,26968400,2157,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3068-2;3829-1;'),
(12880,'Sirra\'s Blade - Landslide {PvP}','Health','rhand','true',1300,1,1,'fine_steel','a',251,10,'sword',8,0.00000,0,0,0,379,0,121,-1,-1,26968400,2157,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3013-3;3829-1;'),
(12881,'Sirra\'s Blade - Landslide {PvP}','Critical Poison','rhand','true',1300,1,1,'fine_steel','a',251,10,'sword',8,0.00000,0,0,0,379,0,121,-1,-1,26968400,2157,'false','false','true','false','true',0,0,0,0,0,3061,3,15,0,'3552-1;3829-1;'),
(12882,'Eclair Bijou - Landslide {PvP}','Haste','rhand','true',1300,1,1,'fine_steel','a',228,40,'rapier',10,-1.00000,0,0,0,406,0,121,-1,-1,26968400,2157,'false','false','true','false','true',3426,1,0,0,0,0,0,0,0,'3068-2;3650-1;3834-1;'),
(12883,'Eclair Bijou - Landslide {PvP}','Health','rhand','true',1300,1,1,'fine_steel','a',228,40,'rapier',10,-1.00000,0,0,0,406,0,121,-1,-1,26968400,2157,'false','false','true','false','true',3426,1,0,0,0,0,0,0,0,'3013-3;3650-1;3834-1;'),
(12884,'Eclair Bijou - Landslide {PvP}','Critical Poison','rhand','true',1300,1,1,'fine_steel','a',228,40,'rapier',10,-1.00000,0,0,0,406,0,121,-1,-1,26968400,2157,'false','false','true','false','true',3426,1,0,0,0,3061,3,15,0,'3552-1;3650-1;3834-1;'),
(12885,'Tiphon\'s Spear - Landslide {PvP}','Critical Stun','lrhand','true',1820,1,1,'fine_steel','a',251,10,'pole',8,-3.00000,0,0,0,325,0,121,-1,-1,26968400,2157,'false','false','true','false','true',0,0,0,0,0,3070,2,25,0,'3552-2;3876-1;'),
(12886,'Tiphon\'s Spear - Landslide {PvP}','Longblow','lrhand','true',1820,1,1,'fine_steel','a',251,10,'pole',8,-3.00000,0,0,0,325,0,121,-1,-1,26968400,2157,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3552-2;3876-1;'),
(12887,'Tiphon\'s Spear - Landslide {PvP}','Wild Blow','lrhand','true',1820,1,1,'fine_steel','a',251,10,'pole',8,-3.00000,0,0,0,325,0,121,-1,-1,26968400,2157,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3552-2;3876-1;'),
(12888,'Tallum Blade*Damascus - Landslide {PvP}','','lrhand','true',1890,1,1,'fine_steel','a',305,10,'dual',8,0.00000,0,0,0,325,0,121,-1,-1,26968400,2157,'false','false','true','false','true',3045,17,0,0,0,0,0,0,0,'3656-1;3839-1;'),
(12889,'Themis\' Tongue - Cleverness {PvP}','Mana Up','rhand','true',820,1,1,'fine_steel','a',202,10,'sword',8,0.00000,0,0,0,379,0,161,-1,-1,26968400,2157,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3014-2;3853-1;'),
(12890,'Themis\' Tongue - Cleverness {PvP}','Magic Mental Shield','rhand','true',820,1,1,'fine_steel','a',202,10,'sword',8,0.00000,0,0,0,379,0,161,-1,-1,26968400,2157,'false','false','true','false','true',0,0,1035,2,50,0,0,0,0,'3552-1;3853-1;'),
(12891,'Themis\' Tongue - Cleverness {PvP}','Magic Focus','rhand','true',820,1,1,'fine_steel','a',202,10,'sword',8,0.00000,0,0,0,379,0,161,-1,-1,26968400,2157,'false','false','true','false','true',0,0,1077,3,20,0,0,0,0,'3552-1;3853-1;'),
(12892,'Cabrio\'s Hand - Cleverness {PvP}','Conversion','rhand','true',1510,1,1,'fine_steel','a',202,20,'blunt',4,4.00000,0,0,0,379,0,161,-1,-1,26968400,2157,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3048-3;3893-1;'),
(12893,'Cabrio\'s Hand - Cleverness {PvP}','Mana Up','rhand','true',1510,1,1,'fine_steel','a',202,20,'blunt',4,4.00000,0,0,0,379,0,161,-1,-1,26968400,2157,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3014-2;3893-1;'),
(12894,'Cabrio\'s Hand - Cleverness {PvP}','Magic Silence','rhand','true',1510,1,1,'fine_steel','a',202,20,'blunt',4,4.00000,0,0,0,379,0,161,-1,-1,26968400,2157,'false','false','true','false','true',0,0,3074,2,10,0,0,0,0,'3552-1;3893-1;'),
(12895,'Gram - Thunder {PvP}','Haste','lrhand','true',1800,1,1,'fine_steel','s',304,15,'ancient',8,2.00000,0,0,0,350,0,132,-1,-1,42759400,2052,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3564-1;3653-1;3850-1;'),
(12896,'Gram - Thunder {PvP}','Health','lrhand','true',1800,1,1,'fine_steel','s',304,15,'ancient',8,2.00000,0,0,0,350,0,132,-1,-1,42759400,2052,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3013-3;3653-1;3850-1;'),
(12897,'Gram - Thunder {PvP}','Focus','lrhand','true',1800,1,1,'fine_steel','s',304,15,'ancient',8,2.00000,0,0,0,350,0,132,-1,-1,42759400,2052,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3566-1;3653-1;3850-1;'),
(12898,'Demon Splinter - Thunder {PvP}','Focus','lrhand','true',1350,1,1,'fine_steel','s',342,5,'dualfist',4,4.00000,0,0,0,325,0,132,-1,-1,42759400,2052,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3565-1;3651-1;3652-1;3883-1;'),
(12899,'Demon Splinter - Thunder {PvP}','Health','lrhand','true',1350,1,1,'fine_steel','s',342,5,'dualfist',4,4.00000,0,0,0,325,0,132,-1,-1,42759400,2052,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3013-3;3651-1;3652-1;3883-1;'),
(12900,'Demon Splinter - Thunder {PvP}','Critical Stun','lrhand','true',1350,1,1,'fine_steel','s',342,5,'dualfist',4,4.00000,0,0,0,325,0,132,-1,-1,42759400,2052,'false','false','true','false','true',0,0,0,0,0,3571,1,27,0,'3552-1;3651-1;3652-1;3883-1;'),
(12901,'Draconic Bow - Earth {PvP}','Cheap Shot','lrhand','true',1650,1,1,'fine_steel','s',581,5,'bow',12,-3.00000,0,0,0,293,11,132,-1,-1,42759400,2052,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3552-1;3655-1;3867-1;'),
(12902,'Draconic Bow - Earth {PvP}','Focus','lrhand','true',1650,1,1,'fine_steel','s',581,5,'bow',12,-3.00000,0,0,0,293,11,132,-1,-1,42759400,2052,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3567-1;3655-1;3867-1;'),
(12903,'Draconic Bow - Earth {PvP}','Crt. Slow','lrhand','true',1650,1,1,'fine_steel','s',581,5,'bow',12,-3.00000,0,0,0,293,11,132,-1,-1,42759400,2052,'false','false','true','false','true',0,0,0,0,0,3574,1,16,0,'3552-1;3655-1;3867-1;'),
(12904,'Dragon Hunter Axe - Thunder {PvP}','HP Regeneration','lrhand','true',1820,1,1,'fine_steel','s',342,20,'bigblunt',4,4.00000,0,0,0,325,0,132,-1,-1,42759400,2052,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3569-1;3653-1;3894-1;'),
(12905,'Dragon Hunter Axe - Thunder {PvP}','Health','lrhand','true',1820,1,1,'fine_steel','s',342,20,'bigblunt',4,4.00000,0,0,0,325,0,132,-1,-1,42759400,2052,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3013-3;3653-1;3894-1;'),
(12906,'Dragon Hunter Axe - Thunder {PvP}','HP Drain','lrhand','true',1820,1,1,'fine_steel','s',342,20,'bigblunt',4,4.00000,0,0,0,325,0,132,-1,-1,42759400,2052,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3568-1;3653-1;3894-1;'),
(12907,'Laevateinn - Lightning {PvP}','Haste','rhand','true',1300,1,1,'fine_steel','s',255,40,'rapier',10,-1.00000,0,0,0,406,0,132,-1,-1,42759400,2052,'false','false','true','false','true',3426,1,0,0,0,0,0,0,0,'3564-1;3650-1;3833-1;'),
(12908,'Laevateinn - Lightning {PvP}','Health','rhand','true',1300,1,1,'fine_steel','s',255,40,'rapier',10,-1.00000,0,0,0,406,0,132,-1,-1,42759400,2052,'false','false','true','false','true',3426,1,0,0,0,0,0,0,0,'3013-3;3650-1;3833-1;'),
(12909,'Laevateinn - Lightning {PvP}','Focus','rhand','true',1300,1,1,'fine_steel','s',255,40,'rapier',10,-1.00000,0,0,0,406,0,132,-1,-1,42759400,2052,'false','false','true','false','true',3426,1,0,0,0,0,0,0,0,'3566-1;3650-1;3833-1;'),
(12910,'Basalt Battlehammer - Concentration {PvP}','HP Drain','rhand','true',1570,1,1,'fine_steel','s',281,20,'blunt',4,4.00000,0,0,0,379,0,132,-1,-1,42759400,2052,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3568-1;3650-1;3888-1;'),
(12911,'Basalt Battlehammer - Concentration {PvP}','Health','rhand','true',1570,1,1,'fine_steel','s',281,20,'blunt',4,4.00000,0,0,0,379,0,132,-1,-1,42759400,2052,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3013-3;3650-1;3888-1;'),
(12912,'Basalt Battlehammer - Concentration {PvP}','HP Regeneration','rhand','true',1570,1,1,'fine_steel','s',281,20,'blunt',4,4.00000,0,0,0,379,0,132,-1,-1,42759400,2052,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3569-1;3650-1;3888-1;'),
(12913,'Sarunga - Earth {PvP}','Cheap Shot','rhand','true',1600,1,1,'fine_steel','s',356,10,'crossbow',10,-1.00000,0,0,0,303,0,132,-1,-1,42759400,2052,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3552-1;3655-1;3872-1;'),
(12914,'Sarunga - Earth {PvP}','Focus','rhand','true',1600,1,1,'fine_steel','s',356,10,'crossbow',10,-1.00000,0,0,0,303,0,132,-1,-1,42759400,2052,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3567-1;3655-1;3872-1;'),
(12915,'Sarunga - Earth {PvP}','Crt. Slow','rhand','true',1600,1,1,'fine_steel','s',356,10,'crossbow',10,-1.00000,0,0,0,303,0,132,-1,-1,42759400,2052,'false','false','true','false','true',0,0,0,0,0,3574,1,16,0,'3552-1;3655-1;3872-1;'),
(12916,'Saint Spear - Destruction {PvP}','Health','lrhand','true',1800,1,1,'fine_steel','s',281,10,'pole',8,-3.00000,0,0,0,325,0,132,-1,-1,42759400,2052,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3013-4;3653-1;3878-1;'),
(12917,'Saint Spear - Destruction {PvP}','Guidance','lrhand','true',1800,1,1,'fine_steel','s',281,10,'pole',8,-3.00000,0,0,0,325,0,132,-1,-1,42759400,2052,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3602-9;3653-1;3878-1;'),
(12918,'Saint Spear - Destruction {PvP}','Haste','lrhand','true',1800,1,1,'fine_steel','s',281,10,'pole',8,-3.00000,0,0,0,325,0,132,-1,-1,42759400,2052,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3601-9;3653-1;3878-1;'),
(12919,'Arcana Mace - Nature {PvP}','Acumen','rhand','true',1300,1,1,'fine_steel','s',225,20,'blunt',4,4.00000,0,0,0,379,0,175,-1,-1,42759400,2052,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3047-2;3654-1;3890-1;'),
(12920,'Arcana Mace - Nature {PvP}','MP Regeneration','rhand','true',1300,1,1,'fine_steel','s',225,20,'blunt',4,4.00000,0,0,0,379,0,175,-1,-1,42759400,2052,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3576-1;3654-1;3890-1;'),
(12921,'Arcana Mace - Nature {PvP}','Mana Up','rhand','true',1300,1,1,'fine_steel','s',225,20,'blunt',4,4.00000,0,0,0,379,0,175,-1,-1,42759400,2052,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3014-2;3654-1;3890-1;'),
(12922,'Angel Slayer - Concentration {PvP}','Crt. Damage','rhand','true',950,1,1,'fine_steel','s',246,5,'dagger',12,-3.00000,0,0,0,433,0,132,-1,-1,42759400,2052,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3066-4;3651-1;3652-1;3862-1;'),
(12923,'Angel Slayer - Concentration {PvP}','HP Drain','rhand','true',950,1,1,'fine_steel','s',246,5,'dagger',12,-3.00000,0,0,0,433,0,132,-1,-1,42759400,2052,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3568-1;3651-1;3652-1;3862-1;'),
(12924,'Angel Slayer - Concentration {PvP}','Haste','rhand','true',950,1,1,'fine_steel','s',246,5,'dagger',12,-3.00000,0,0,0,433,0,132,-1,-1,42759400,2052,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3564-1;3651-1;3652-1;3862-1;'),
(12925,'Imperial Staff - Nature {PvP}','Empower','lrhand','true',910,1,1,'fine_steel','s',274,20,'bigblunt',4,4.00000,0,0,0,325,0,193,-1,-1,42759400,2052,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3575-1;3654-1;3901-2;'),
(12926,'Imperial Staff - Nature {PvP}','MP Regeneration','lrhand','true',910,1,1,'fine_steel','s',274,20,'bigblunt',4,4.00000,0,0,0,325,0,193,-1,-1,42759400,2052,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3576-1;3654-1;3901-2;'),
(12927,'Imperial Staff - Nature {PvP}','Magic Hold','lrhand','true',910,1,1,'fine_steel','s',274,20,'bigblunt',4,4.00000,0,0,0,325,0,193,-1,-1,42759400,2052,'false','false','true','false','true',0,0,3577,1,20,0,0,0,0,'3552-1;3654-1;3901-2;'),
(12928,'Tallum Blade*Dark Legion - Lightning {PvP}','','lrhand','true',2080,1,1,'fine_steel','s',342,10,'dual',8,0.00000,0,0,0,325,0,132,-1,-1,42759400,2052,'false','false','true','false','true',3570,1,0,0,0,0,0,0,0,'3656-1;3838-1;'),
(12929,'Forgotten Blade - Lightning {PvP}','Haste','rhand','true',1300,1,1,'fine_steel','s',281,10,'sword',8,0.00000,0,0,0,379,0,132,-1,-1,42759400,2052,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3564-1;3650-1;3828-1;'),
(12930,'Forgotten Blade - Lightning {PvP}','Health','rhand','true',1300,1,1,'fine_steel','s',281,10,'sword',8,0.00000,0,0,0,379,0,132,-1,-1,42759400,2052,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3013-3;3650-1;3828-1;'),
(12931,'Forgotten Blade - Lightning {PvP}','Focus','rhand','true',1300,1,1,'fine_steel','s',281,10,'sword',8,0.00000,0,0,0,379,0,132,-1,-1,42759400,2052,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3566-1;3650-1;3828-1;'),
(12932,'Heavens Divider - Thunder {PvP}','Haste','lrhand','true',1380,1,1,'fine_steel','s',342,10,'bigsword',8,0.00000,0,0,0,325,0,132,-1,-1,42759400,2052,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3564-1;3653-1;3844-1;'),
(12933,'Heavens Divider - Thunder {PvP}','Health','lrhand','true',1380,1,1,'fine_steel','s',342,10,'bigsword',8,0.00000,0,0,0,325,0,132,-1,-1,42759400,2052,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3013-3;3653-1;3844-1;'),
(12934,'Heavens Divider - Thunder {PvP}','Focus','lrhand','true',1380,1,1,'fine_steel','s',342,10,'bigsword',8,0.00000,0,0,0,325,0,132,-1,-1,42759400,2052,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3566-1;3653-1;3844-1;'),
(12935,'Dynasty Ancient Sword - Great Gale {PvP}','Focus','lrhand','true',1800,1,1,'fine_steel','s80',361,15,'ancient',8,2.00000,0,0,0,350,0,151,-1,-1,74946000,3597,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3566-2;3653-1;3846-2;'),
(12936,'Dynasty Ancient Sword - Great Gale {PvP}','Health','lrhand','true',1800,1,1,'fine_steel','s80',361,15,'ancient',8,2.00000,0,0,0,350,0,151,-1,-1,74946000,3597,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3013-5;3653-1;3846-2;'),
(12937,'Dynasty Ancient Sword - Great Gale {PvP}','Light','lrhand','true',1800,1,1,'fine_steel','s80',361,15,'ancient',8,2.00000,0,0,0,350,0,151,-1,-1,74946000,3597,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3498-1;3653-1;3846-2;'),
(12938,'Dynasty Knife - Great Gale {PvP}','Focus','rhand','true',1520,1,1,'fine_steel','s80',291,5,'dagger',12,-3.00000,0,0,0,433,0,151,-1,-1,74946000,3597,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3567-2;3651-1;3652-1;3859-2;'),
(12939,'Dynasty Knife - Great Gale {PvP}','Evasion','rhand','true',1520,1,1,'fine_steel','s80',291,5,'dagger',12,-3.00000,0,0,0,433,0,151,-1,-1,74946000,3597,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3009-7;3651-1;3652-1;3859-2;'),
(12940,'Dynasty Knife - Great Gale {PvP}','Critical Damage','rhand','true',1520,1,1,'fine_steel','s80',291,5,'dagger',12,-3.00000,0,0,0,433,0,151,-1,-1,74946000,3597,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3066-4;3651-1;3652-1;3859-2;'),
(12941,'Dynasty Dual Sword - Earth {PvP}','','lrhand','true',1520,1,1,'fine_steel','s80',405,10,'dual',8,0.00000,0,0,0,325,0,151,-1,-1,74946000,3597,'false','false','true','false','true',3411,1,0,0,0,0,0,0,0,'3836-2;3656-1;'),
(12942,'Dynasty Rapier - Earth {PvP}','Focus','rhand','true',1280,1,1,'fine_steel','s80',302,40,'rapier',10,-1.00000,0,0,0,406,0,151,-1,-1,74946000,3597,'false','false','true','false','true',3426,1,0,0,0,0,0,0,0,'3566-2;3650-1;3831-2;'),
(12943,'Dynasty Rapier - Earth {PvP}','Health','rhand','true',1280,1,1,'fine_steel','s80',302,40,'rapier',10,-1.00000,0,0,0,406,0,151,-1,-1,74946000,3597,'false','false','true','false','true',3426,1,0,0,0,0,0,0,0,'3013-5;3650-1;3831-2;'),
(12944,'Dynasty Rapier - Earth {PvP}','Light','rhand','true',1280,1,1,'fine_steel','s80',302,40,'rapier',10,-1.00000,0,0,0,406,0,151,-1,-1,74946000,3597,'false','false','true','false','true',3426,1,0,0,0,0,0,0,0,'3498-1;3650-1;3831-2;'),
(12945,'Dynasty Mace - Earth {PvP}','Mana Up','rhand','true',1080,1,1,'fine_steel','s80',267,20,'blunt',4,4.00000,0,0,0,379,0,202,-1,-1,74946000,3597,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3014-3;3654-1;3884-2;'),
(12946,'Dynasty Mace - Earth {PvP}','Conversion','rhand','true',1080,1,1,'fine_steel','s80',267,20,'blunt',4,4.00000,0,0,0,379,0,202,-1,-1,74946000,3597,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3048-3;3654-1;3884-2;'),
(12947,'Dynasty Mace - Earth {PvP}','Acumen','rhand','true',1080,1,1,'fine_steel','s80',267,20,'blunt',4,4.00000,0,0,0,379,0,202,-1,-1,74946000,3597,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3047-2;3654-1;3884-2;'),
(12948,'Dynasty Bagh-Nakh - Great Gale {PvP}','Rsk. Evasion','lrhand','true',1550,1,1,'fine_steel','s80',405,5,'dualfist',4,4.00000,0,0,0,325,0,151,-1,-1,74946000,3597,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3069-1;3651-1;3652-1;3880-2;'),
(12949,'Dynasty Bagh-Nakh - Great Gale {PvP}','Focus','lrhand','true',1550,1,1,'fine_steel','s80',405,5,'dualfist',4,4.00000,0,0,0,325,0,151,-1,-1,74946000,3597,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3565-2;3651-1;3652-1;3880-2;'),
(12950,'Dynasty Bagh-Nakh - Great Gale {PvP}','Haste','lrhand','true',1550,1,1,'fine_steel','s80',405,5,'dualfist',4,4.00000,0,0,0,325,0,151,-1,-1,74946000,3597,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3068-3;3651-1;3652-1;3880-2;'),
(12951,'Dynasty Bow - Great Gale {PvP}','Cheap Shot','lrhand','true',1520,1,1,'fine_steel','s80',654,5,'bow',12,-3.00000,0,0,0,293,11,151,-1,-1,74946000,3597,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3552-1;3655-1;3864-2;'),
(12952,'Dynasty Bow - Great Gale {PvP}','Guidance','lrhand','true',1520,1,1,'fine_steel','s80',654,5,'bow',12,-3.00000,0,0,0,293,11,151,-1,-1,74946000,3597,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3573-1;3655-1;3864-2;'),
(12953,'Dynasty Bow - Great Gale {PvP}','Focus','lrhand','true',1520,1,1,'fine_steel','s80',654,5,'bow',12,-3.00000,0,0,0,293,11,151,-1,-1,74946000,3597,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3567-2;3655-1;3864-2;'),
(12954,'Dynasty Blade - Great Gale {PvP}','Focus','lrhand','true',1740,1,1,'fine_steel','s80',405,10,'bigsword',8,0.00000,0,0,0,325,0,151,-1,-1,74946000,3597,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3566-2;3653-1;3840-2;'),
(12955,'Dynasty Blade - Great Gale {PvP}','Health','lrhand','true',1740,1,1,'fine_steel','s80',405,10,'bigsword',8,0.00000,0,0,0,325,0,151,-1,-1,74946000,3597,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3013-5;3653-1;3840-2;'),
(12956,'Dynasty Blade - Great Gale {PvP}','Light','lrhand','true',1740,1,1,'fine_steel','s80',405,10,'bigsword',8,0.00000,0,0,0,325,0,151,-1,-1,74946000,3597,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3498-1;3653-1;3840-2;'),
(12957,'Dynasty Sword - Earth {PvP}','Focus','rhand','true',1520,1,1,'fine_steel','s80',333,10,'sword',8,0.00000,0,0,0,379,0,151,-1,-1,74946000,3597,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3566-2;3650-1;3826-2;'),
(12958,'Dynasty Sword - Earth {PvP}','Health','rhand','true',1520,1,1,'fine_steel','s80',333,10,'sword',8,0.00000,0,0,0,379,0,151,-1,-1,74946000,3597,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3013-5;3650-1;3826-2;'),
(12959,'Dynasty Sword - Earth {PvP}','Light','rhand','true',1520,1,1,'fine_steel','s80',333,10,'sword',8,0.00000,0,0,0,379,0,151,-1,-1,74946000,3597,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3498-1;3650-1;3826-2;'),
(12960,'Dynasty Staff - Holy Spirit {PvP}','Mana Up','lrhand','true',1080,1,1,'fine_steel','s80',325,20,'bigblunt',4,4.00000,0,0,0,325,0,222,-1,-1,74946000,3597,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3014-3;3654-1;'),
(12961,'Dynasty Staff - Holy Spirit {PvP}','Conversion','lrhand','true',1080,1,1,'fine_steel','s80',325,20,'bigblunt',4,4.00000,0,0,0,325,0,222,-1,-1,74946000,3597,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3048-3;3654-1;'),
(12962,'Dynasty Staff - Holy Spirit {PvP}','Acumen','lrhand','true',1080,1,1,'fine_steel','s80',325,20,'bigblunt',4,4.00000,0,0,0,325,0,222,-1,-1,74946000,3597,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3047-2;3654-1;'),
(12963,'Dynasty Cudgel - Landslide {PvP}','Anger','rhand','true',1740,1,1,'fine_steel','s80',333,20,'blunt',4,4.00000,0,0,0,379,0,151,-1,-1,74946000,3597,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3057-3;3650-1;3885-1;'),
(12964,'Dynasty Cudgel - Landslide {PvP}','Health','rhand','true',1740,1,1,'fine_steel','s80',333,20,'blunt',4,4.00000,0,0,0,379,0,151,-1,-1,74946000,3597,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3013-5;3650-1;3885-1;'),
(12965,'Dynasty Cudgel - Landslide {PvP}','Rsk. Focus','rhand','true',1740,1,1,'fine_steel','s80',333,20,'blunt',4,4.00000,0,0,0,379,0,151,-1,-1,74946000,3597,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3027-7;3650-1;3885-1;'),
(12966,'Dynasty Crusher - Great Gale {PvP}','Anger','lrhand','true',1740,1,1,'fine_steel','s80',405,20,'bigblunt',4,4.00000,0,0,0,325,0,151,-1,-1,74946000,3597,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3057-3;3653-1;3896-2;'),
(12967,'Dynasty Crusher - Great Gale {PvP}','Health','lrhand','true',1740,1,1,'fine_steel','s80',405,20,'bigblunt',4,4.00000,0,0,0,325,0,151,-1,-1,74946000,3597,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3013-5;3653-1;3896-2;'),
(12968,'Dynasty Crusher - Great Gale {PvP}','Rsk. Focus','lrhand','true',1740,1,1,'fine_steel','s80',405,20,'bigblunt',4,4.00000,0,0,0,325,0,151,-1,-1,74946000,3597,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3027-7;3653-1;3896-2;'),
(12969,'Dynasty Crossbow - Great Gale {PvP}','Cheap Shot','rhand','true',1580,1,1,'fine_steel','s80',401,10,'crossbow',10,-1.00000,0,0,0,303,0,151,-1,-1,74946000,3597,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3552-1;3655-1;3869-2;'),
(12970,'Dynasty Crossbow - Great Gale {PvP}','Guidance','rhand','true',1580,1,1,'fine_steel','s80',401,10,'crossbow',10,-1.00000,0,0,0,303,0,151,-1,-1,74946000,3597,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3573-1;3655-1;3869-2;'),
(12971,'Dynasty Crossbow - Great Gale {PvP}','Focus','rhand','true',1580,1,1,'fine_steel','s80',401,10,'crossbow',10,-1.00000,0,0,0,303,0,151,-1,-1,74946000,3597,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3567-2;3655-1;3869-2;'),
(12972,'Dynasty Phantom - Nature {PvP}','Acumen','rhand','true',1520,1,1,'fine_steel','s80',267,10,'sword',8,0.00000,0,0,0,379,0,202,-1,-1,74946000,3597,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3047-2;3654-1;3852-3;'),
(12973,'Dynasty Phantom - Nature {PvP}','Mana Up','rhand','true',1520,1,1,'fine_steel','s80',267,10,'sword',8,0.00000,0,0,0,379,0,202,-1,-1,74946000,3597,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3014-3;3654-1;3852-3;'),
(12974,'Dynasty Phantom - Nature {PvP}','Conversion','rhand','true',1520,1,1,'fine_steel','s80',267,10,'sword',8,0.00000,0,0,0,379,0,202,-1,-1,74946000,3597,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3048-3;3654-1;3852-3;'),
(12975,'Dynasty Halberd - Earth {PvP}','Anger','lrhand','true',2010,1,1,'fine_steel','s80',333,10,'pole',8,-3.00000,0,0,0,325,0,151,-1,-1,74946000,3597,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3600-10;3653-1;3877-2;'),
(12976,'Dynasty Halberd - Earth {PvP}','Critical Stun','lrhand','true',2010,1,1,'fine_steel','s80',333,10,'pole',8,-3.00000,0,0,0,325,0,151,-1,-1,74946000,3597,'false','false','true','false','true',0,0,0,0,0,3070,3,48,0,'3552-2;3653-1;3877-2;'),
(12977,'Dynasty Halberd - Earth {PvP}','Light','lrhand','true',2010,1,1,'fine_steel','s80',333,10,'pole',8,-3.00000,0,0,0,325,0,151,-1,-1,74946000,3597,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3599-1;3498-1;3653-1;3877-2;'),
(13034,'Sprite\'s Sword','','lrhand','false',817,3,3,'fine_steel','d',107,10,'dual',8,0.00000,0,0,0,325,0,72,-1,-1,0,0,'false','false','true','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(13035,'Enhanced Sprite\'s Sword','','lrhand','false',817,3,3,'fine_steel','d',127,10,'dual',8,0.00000,0,0,0,325,0,82,-1,-1,0,0,'false','false','true','false','false',0,0,0,0,0,0,0,0,0,'8237-1;'),
(13036,'Sword of Ice and Fire','','lrhand','false',817,3,3,'fine_steel','d',147,10,'dual',8,0.00000,0,0,0,325,0,92,-1,-1,0,0,'false','false','true','false','false',0,0,0,0,0,0,0,0,0,'8237-1;8238-1;'),
(13042,'Ancient Legacy Sword','','lrhand','false',643,1,1,'fine_steel','a',259,10,'bigsword',8,0.00000,0,0,0,325,0,143,-1,-1,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'8250-1;'),
(13043,'Enhanced Ancient Legacy Sword','','lrhand','false',643,1,1,'fine_steel','a',279,10,'bigsword',8,0.00000,0,0,0,325,0,153,-1,-1,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'8250-1;8242-1;'),
(13044,'Complete Ancient Legacy Sword','','lrhand','false',643,1,1,'fine_steel','a',299,10,'bigsword',8,0.00000,0,0,0,325,0,163,-1,-1,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'8250-2;8242-1;8243-1;'),
(13052,'Spear of Silenos','','lrhand','false',607,1,1,'fine_steel','a',251,10,'pole',8,-3.00000,0,0,0,325,0,161,-1,-1,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'3599-1;8239-1;8240-1;8241-1;'),
(13053,'Enhanced Spear of Silenos','','lrhand','false',607,1,1,'fine_steel','a',271,10,'pole',8,-3.00000,0,0,0,325,0,171,-1,-1,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'3599-1;8239-1;8240-2;8241-1;'),
(13054,'Complete Spear of Silenos','','lrhand','false',607,1,1,'fine_steel','a',291,10,'pole',8,-3.00000,0,0,0,325,0,181,-1,-1,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'3599-1;8239-1;8240-3;8241-1;'),
(13061,'Exclusive to Monsters (Baroness\' Employee)','','rhand','true',1080,1,1,'fine_steel','none',267,20,'blunt',4,4.00000,0,0,0,379,0,202,-1,-1,0,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(13062,'Exclusive to Monsters (Employee\'s Friend)','','rhand','false',1740,1,1,'fine_steel','none',442,10,'sword',8,0.00000,0,0,0,325,0,163,-1,-1,0,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(13153,'For PC cafe use - Great Spear','Weapons for PC Cafe Use','lrhand','false',2120,2,2,'fine_steel','none',31,10,'pole',8,-3.00000,0,0,0,325,0,21,-1,60,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3599-1;'),
(13154,'For PC cafe use - Falchion','Weapons for PC Cafe Use','rhand','false',1530,2,2,'fine_steel','none',31,10,'sword',8,0.00000,0,0,0,379,0,21,-1,60,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(13155,'For PC cafe use - Iron Hammer','Weapons for PC Cafe Use','rhand','false',1850,2,2,'fine_steel','none',31,20,'blunt',4,4.00000,0,0,0,379,0,21,-1,60,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(13156,'For PC cafe use - Voodoo Doll','Weapons for PC Cafe Use','rhand','false',630,2,2,'fine_steel','none',25,10,'etc',8,0.00000,0,0,0,379,0,28,-1,60,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(13157,'For PC cafe use - Flanged Mace','Weapons for PC Cafe Use','rhand','false',1800,2,2,'fine_steel','none',31,20,'blunt',4,4.00000,0,0,0,379,0,21,-1,60,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(13158,'For PC Cafe Use - Mage\'s Wand','Weapons for PC Cafe Use','lrhand','false',1050,2,2,'fine_steel','none',30,20,'bigblunt',4,4.00000,0,0,0,325,0,31,-1,60,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(13159,'For PC Cafe Use - Sword Breaker','Weapons for PC Cafe Use','rhand','false',1110,2,2,'fine_steel','none',27,5,'dagger',12,-3.00000,0,0,0,433,0,21,-1,60,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(13160,'For PC Cafe Use - Viper Fang','Weapons for PC Cafe Use','lrhand','false',1560,2,2,'fine_steel','none',38,5,'dualfist',4,4.00000,0,0,0,325,0,21,-1,60,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(13161,'For PC Cafe Use - Compound Bow','Weapons for PC Cafe Use','lrhand','false',1880,7,2,'fine_steel','none',64,5,'bow',12,-3.00000,0,0,0,293,3,21,-1,60,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(13162,'For PC Cafe Use - Crucifix of Blessing','Weapons for PC Cafe Use','rhand','false',620,2,2,'fine_steel','none',25,10,'etc',8,0.00000,0,0,0,379,0,28,-1,60,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(13163,'For PC Cafe Use - Bastard*Crimson Sword','Weapons for PC Cafe Use','lrhand','true',2470,3,3,'fine_steel','d',107,10,'dual',8,0.00000,0,0,0,325,0,51,-1,60,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(13164,'For PC cafe use - Claymore','Weapons for PC Cafe Use','lrhand','true',2090,3,3,'fine_steel','d',112,10,'bigsword',8,0.00000,0,0,0,325,0,54,-1,60,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(13165,'For PC cafe use - Bonebreaker','Weapons for PC Cafe Use','rhand','true',1720,3,3,'fine_steel','d',92,20,'blunt',4,4.00000,0,0,0,379,0,54,-1,60,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(13166,'For PC Cafe Use - Atuba Hammer','Weapons for PC Cafe Use','lrhand','true',1010,3,3,'fine_steel','d',90,20,'bigblunt',4,4.00000,0,0,0,325,0,79,-1,60,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(13167,'For PC Cafe Use - Ghost\'s Wand','Weapons for PC Cafe Use','lrhand','true',1000,3,3,'fine_steel','d',90,20,'bigblunt',4,4.00000,0,0,0,325,0,79,-1,60,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(13168,'For PC Cafe Use - Hall of Life','Weapons for PC Cafe Use','rhand','true',1180,3,3,'fine_steel','d',74,20,'blunt',4,4.00000,0,0,0,379,0,79,-1,60,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(13169,'For PC cafe use - Atuba Mace','Weapons for PC Cafe Use','lrhand','true',1010,3,3,'fine_steel','d',90,20,'bigblunt',4,4.00000,0,0,0,325,0,79,-1,60,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(13170,'For PC Cafe USE - Mithril Dagger','Weapons for PC Cafe Use','rhand','true',1060,3,3,'fine_steel','d',80,5,'dagger',12,-3.00000,0,0,0,433,0,54,-1,60,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(13171,'For PC Cafe Use - Scallop Jamadhr','Weapons for PC Cafe Use','lrhand','true',1520,3,3,'fine_steel','d',112,5,'dualfist',4,4.00000,0,0,0,325,0,54,-1,60,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(13172,'For PC cafe use - Crossbow','Weapons for PC Cafe Use','lrhand','true',1810,10,3,'fine_steel','d',191,5,'bow',12,-3.00000,0,0,0,293,6,54,-1,60,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(13173,'For PC cafe use - Glaive','Weapons for PC Cafe Use','lrhand','true',2050,3,3,'fine_steel','d',92,10,'pole',8,-3.00000,0,0,0,325,0,54,-1,60,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3599-1;'),
(13174,'For PC Cafe Use - Elven Long Sword','Weapons for PC Cafe Use','rhand','true',1440,3,3,'fine_steel','d',92,10,'sword',8,0.00000,0,0,0,379,0,54,-1,60,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(13175,'For PC Cafe Use - Grand Epee','Weapons for PC Cafe Use','rhand','true',1440,3,3,'fine_steel','d',83,40,'rapier',10,-1.00000,0,0,0,406,0,54,-1,60,0,0,'false','false','true','false','true',3426,1,0,0,0,0,0,0,0,'0-0;'),
(13176,'For PC Cafe Use - General  Katzbalger','Weapons for PC Cafe Use','lrhand','true',2010,3,3,'fine_steel','d',100,15,'ancient',8,2.00000,0,0,0,350,0,54,-1,60,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(13177,'For PC Cafe Use - Cranequin','Weapons for PC Cafe Use','rhand','true',1810,6,3,'fine_steel','d',117,10,'crossbow',10,-1.00000,0,0,0,303,0,54,-1,60,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(13178,'For PC Cafe Use - Samurai Long Sword','Weapons for PC Cafe Use','rhand','true',1380,3,3,'fine_steel','c',156,10,'sword',8,0.00000,0,0,0,379,0,83,-1,60,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(13179,'For PC Cafe Use - Ghost\'s Wand','Weapons for PC Cafe Use','lrhand','true',1010,3,3,'fine_steel','c',152,20,'bigblunt',4,4.00000,0,0,0,325,0,122,-1,60,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(13180,'For PC Cafe Use - Ghoul\'s Wand','Weapons for PC Cafe Use','lrhand','true',1000,3,3,'fine_steel','c',152,20,'bigblunt',4,4.00000,0,0,0,325,0,122,-1,60,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(13181,'For PC Cafe Use - Devil\'s Wand','Weapons for PC Cafe Use','lrhand','true',990,3,3,'fine_steel','c',152,20,'bigblunt',4,4.00000,0,0,0,325,0,122,-1,60,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(13182,'For PC Cafe USE - Crystal Dagger','Weapons for PC Cafe Use','rhand','true',1000,3,3,'fine_steel','c',136,5,'dagger',12,-3.00000,0,0,0,433,0,83,-1,60,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(13183,'For PC cafe use - Great Pata','Weapons for PC Cafe Use','lrhand','true',1460,3,3,'fine_steel','c',190,5,'dualfist',4,4.00000,0,0,0,325,0,83,-1,60,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(13184,'For PC cafe use - Eminence Bow','Weapons for PC Cafe Use','lrhand','true',1720,10,3,'fine_steel','c',323,5,'bow',12,-3.00000,0,0,0,293,8,83,-1,60,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(13185,'For PC Cafe Use - Orcish Poleaxe','Weapons for PC Cafe Use','lrhand','true',1950,3,3,'fine_steel','c',156,10,'pole',8,-3.00000,0,0,0,325,0,83,-1,60,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3599-1;'),
(13186,'For PC cafe use - Yaksa Mace','Weapons for PC Cafe Use','rhand','true',1640,3,3,'fine_steel','c',156,20,'blunt',4,4.00000,0,0,0,379,0,83,-1,60,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(13187,'For PC Cafe Use - Shamshir*Shamshir','Weapons for PC Cafe Use','lrhand','true',2330,3,3,'fine_steel','c',190,10,'dual',8,0.00000,0,0,0,325,0,83,-1,60,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(13188,'PC Cafe Use - Admiral\'s Estoc','Weapons for PC Cafe Use','rhand','true',1380,3,3,'fine_steel','c',141,40,'rapier',10,-1.00000,0,0,0,406,0,83,-1,60,0,0,'false','false','true','false','true',3426,1,0,0,0,0,0,0,0,'0-0;'),
(13189,'For PC cafe use - Saber Tooth','Weapons for PC Cafe Use','lrhand','true',1950,3,3,'fine_steel','c',169,15,'ancient',8,2.00000,0,0,0,350,0,83,-1,60,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(13190,'For PC Cafe Use - Sharpshooter','Weapons for PC Cafe Use','rhand','true',1740,6,3,'fine_steel','c',198,10,'crossbow',10,-1.00000,0,0,0,303,0,83,-1,60,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(13191,'For PC Cafe Use - Ecliptic Sword','Weapons for PC Cafe Use','rhand','true',1380,3,3,'fine_steel','c',125,10,'sword',8,0.00000,0,0,0,379,0,111,-1,60,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(13192,'For PC Cafe Use - Ecliptic Axe','Weapons for PC Cafe Use','rhand','true',1640,3,3,'fine_steel','c',125,20,'blunt',4,4.00000,0,0,0,379,0,111,-1,60,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(13193,'For PC Cafe Use - Dwarven Hammer','Weapons for PC Cafe Use','lrhand','true',2010,3,3,'fine_steel','c',190,20,'bigblunt',4,4.00000,0,0,0,325,0,83,-1,60,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(13194,'For PC Cafe Use - Damascus Sword','Weapons for PC Cafe Use','rhand','true',1350,1,1,'fine_steel','b',194,10,'sword',8,0.00000,0,0,0,379,0,99,-1,60,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(13195,'For PC cafe use - Lance','Weapons for PC Cafe Use','lrhand','true',1920,1,1,'fine_steel','b',194,10,'pole',8,-3.00000,0,0,0,325,0,99,-1,60,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3599-1;'),
(13196,'For PC Cafe Use - Deadman\'s Glory','Weapons for PC Cafe Use','rhand','true',1600,1,1,'fine_steel','b',194,20,'blunt',4,4.00000,0,0,0,379,0,99,-1,60,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(13197,'For PC Cafe Use - Art of Battle Axe','Weapons for PC Cafe Use','rhand','true',1570,1,1,'fine_steel','b',194,20,'blunt',4,4.00000,0,0,0,379,0,99,-1,60,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(13198,'For PC Cafe Use - Staff of Evil Spirits','Weapons for PC Cafe Use','lrhand','true',930,1,1,'fine_steel','b',189,20,'bigblunt',4,4.00000,0,0,0,325,0,145,-1,60,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(13199,'For PC Cafe USE - Devil\'s Dagger','Weapons for PC Cafe Use','rhand','true',970,1,1,'fine_steel','b',170,5,'dagger',12,-3.00000,0,0,0,433,0,99,-1,60,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(13200,'For PC Cafe Use - Bellion Cestus','Weapons for PC Cafe Use','lrhand','true',1390,1,1,'fine_steel','b',236,5,'dualfist',4,4.00000,0,0,0,325,0,99,-1,60,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(13201,'For PC cafe use - Hazard Bow','Weapons for PC Cafe Use','lrhand','true',1700,3,1,'fine_steel','b',400,5,'bow',12,-3.00000,0,0,0,293,9,99,-1,60,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(13202,'For PC Cafe Use - Samurai*Samurai','Weapons for PC Cafe Use','lrhand','true',2080,1,1,'fine_steel','b',236,10,'dual',8,0.00000,0,0,0,325,0,99,-1,60,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(13203,'For PC Cafe Use - Guardian\'s Sword','Weapons for PC Cafe Use','lrhand','true',1930,1,1,'fine_steel','b',236,10,'bigsword',8,0.00000,0,0,0,325,0,99,-1,60,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(13204,'For PC Cafe Use - Wizard\'s Tear','Weapons for PC Cafe Use','rhand','true',1350,1,1,'fine_steel','b',155,10,'sword',8,0.00000,0,0,0,379,0,132,-1,60,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(13205,'For PC Cafe Use - Kaim Vanul\'s Bones','Weapons for PC Cafe Use','rhand','true',1570,1,1,'fine_steel','b',155,20,'blunt',4,4.00000,0,0,0,379,0,132,-1,60,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(13206,'For PC Cafe Use - Star Buster','Weapons for PC Cafe Use','lrhand','true',1930,1,1,'fine_steel','b',236,20,'bigblunt',4,4.00000,0,0,0,325,0,99,-1,60,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(13207,'For PC cafe use - Colichemarde','Weapons for PC Cafe Use','rhand','true',1350,1,1,'fine_steel','b',176,40,'rapier',10,-1.00000,0,0,0,406,0,99,-1,60,0,0,'false','false','true','false','true',3426,1,0,0,0,0,0,0,0,'0-0;'),
(13208,'For PC cafe use - Dismantler','Weapons for PC Cafe Use','lrhand','true',1930,1,1,'fine_steel','b',210,15,'ancient',8,2.00000,0,0,0,350,0,99,-1,60,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(13209,'For PC Cafe Use - Hell Hound','Weapons for PC Cafe Use','rhand','true',1700,2,1,'fine_steel','b',245,10,'crossbow',10,-1.00000,0,0,0,303,0,99,-1,60,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(13210,'PC cafe\' exclusive - Sirra\'s Blade','Weapons for PC Cafe Use','rhand','true',1300,1,1,'fine_steel','a',251,10,'sword',8,0.00000,0,0,0,379,0,121,-1,60,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(13211,'For PC Cafe Use - Sword of Ipos','Weapons for PC Cafe Use','lrhand','true',1820,1,1,'fine_steel','a',305,10,'bigsword',8,0.00000,0,0,0,325,0,121,-1,60,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(13212,'For PC Cafe Use - Barakiel\'s Axe','Weapons for PC Cafe Use','rhand','true',1550,1,1,'fine_steel','a',251,20,'blunt',4,4.00000,0,0,0,379,0,121,-1,60,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(13213,'For PC Cafe Use - Behemoth Tuning Fork','Weapons for PC Cafe Use','lrhand','true',1890,1,1,'fine_steel','a',305,20,'bigblunt',4,4.00000,0,0,0,325,0,121,-1,60,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(13214,'For PC Cafe Use - Naga Storm','Weapons for PC Cafe Use','rhand','true',930,1,1,'fine_steel','a',220,5,'dagger',12,-3.00000,0,0,0,433,0,121,-1,60,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(13215,'For PC cafe use - Tiphon\'s Spear','Weapons for PC Cafe Use','lrhand','true',1820,1,1,'fine_steel','a',251,10,'pole',8,-3.00000,0,0,0,325,0,121,-1,60,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3599-1;'),
(13216,'For PC cafe use - Shyeed\'s Bow','Weapons for PC Cafe Use','lrhand','true',1640,2,1,'fine_steel','a',570,5,'bow',12,-3.00000,0,0,0,227,10,133,-1,60,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(13217,'For PC Cafe Use - Sobekk\'s Hurricane','Weapons for PC Cafe Use','lrhand','true',1330,1,1,'fine_steel','a',305,5,'dualfist',4,4.00000,0,0,0,325,0,121,-1,60,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(13218,'For PC Cafe Use - Themis\' Tongue','Weapons for PC Cafe Use','rhand','true',820,1,1,'fine_steel','a',202,10,'sword',8,0.00000,0,0,0,379,0,161,-1,60,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(13219,'For PC Cafe Use - Cabrio\'s Hand','Weapons for PC Cafe Use','rhand','true',1510,1,1,'fine_steel','a',202,20,'blunt',4,4.00000,0,0,0,379,0,161,-1,60,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(13220,'For PC Cafe Use - Daimon Crystal','Weapons for PC Cafe Use','lrhand','true',880,1,1,'fine_steel','a',245,20,'bigblunt',4,4.00000,0,0,0,325,0,177,-1,60,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(13221,'For PC cafe use - Tallum Blade*Damascus','Weapons for PC Cafe Use','lrhand','true',1890,1,1,'fine_steel','a',305,10,'dual',8,0.00000,0,0,0,325,0,121,-1,60,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(13222,'For PC Cafe Use - Eclair Bijou','Weapons for PC Cafe Use','rhand','true',1300,1,1,'fine_steel','a',228,40,'rapier',10,-1.00000,0,0,0,406,0,121,-1,60,0,0,'false','false','true','false','true',3426,1,0,0,0,0,0,0,0,'0-0;'),
(13223,'For PC cafe use - Durendal','Weapons for PC Cafe Use','lrhand','true',1820,1,1,'fine_steel','a',272,15,'ancient',8,2.00000,0,0,0,350,0,121,-1,60,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(13224,'For PC Cafe Use - Screaming Vengeance','Weapons for PC Cafe Use','rhand','true',1640,1,1,'fine_steel','a',318,10,'crossbow',10,-1.00000,0,0,0,303,0,121,-1,60,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(13248,'O-type Stick','7-day Limited Period','rhand','false',0,0,0,'fine_steel','none',1,10,'sword',8,0.00000,0,0,0,379,0,1,-1,10080,0,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(13249,'X-type Stick','7-day Limited Period','rhand','false',0,0,0,'fine_steel','none',1,10,'sword',8,0.00000,0,0,0,379,0,1,-1,10080,0,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(13250,'Scissors-type Stick','7-day Limited Period','rhand','false',0,0,0,'fine_steel','none',1,10,'sword',8,0.00000,0,0,0,379,0,1,-1,10080,0,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(13251,'Rock-type Stick','7-day Limited Period','rhand','false',0,0,0,'fine_steel','none',1,10,'sword',8,0.00000,0,0,0,379,0,1,-1,10080,0,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(13252,'Paper-type Stick','7-day Limited Period','rhand','false',0,0,0,'fine_steel','none',1,10,'sword',8,0.00000,0,0,0,379,0,1,-1,10080,0,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(13253,'Pumpkin Transformation Stick','7-day Limited Period','rhand','false',0,0,0,'fine_steel','none',1,10,'sword',8,0.00000,0,0,0,379,0,1,-1,10080,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'8246-1;'),
(13319,'O-type Stick (Event)','30-day limited period','rhand','false',0,0,0,'fine_steel','none',1,10,'sword',8,0.00000,0,0,0,379,0,1,-1,43200,0,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(13320,'X-type Stick (Event)','30-day limited period','rhand','false',0,0,0,'fine_steel','none',1,10,'sword',8,0.00000,0,0,0,379,0,1,-1,43200,0,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(13321,'Scissors-type Stick (Event)','30-day limited period','rhand','false',0,0,0,'fine_steel','none',1,10,'sword',8,0.00000,0,0,0,379,0,1,-1,43200,0,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(13322,'Rock-type Stick (Event)','30-day limited period','rhand','false',0,0,0,'fine_steel','none',1,10,'sword',8,0.00000,0,0,0,379,0,1,-1,43200,0,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(13323,'Paper-type Stick (Event)','30-day limited period','rhand','false',0,0,0,'fine_steel','none',1,10,'sword',8,0.00000,0,0,0,379,0,1,-1,43200,0,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(13324,'Pumpkin Transformation Stick (Event)','30-day limited period','rhand','false',0,0,0,'fine_steel','none',1,10,'sword',8,0.00000,0,0,0,379,0,1,-1,43200,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'8246-1;'),
(13334,'O-type Stick (Event)','7-day Limited Period','rhand','false',0,0,0,'fine_steel','none',1,10,'sword',8,0.00000,0,0,0,379,0,1,-1,10080,0,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(13335,'X-type Stick (Event)','7-day Limited Period','rhand','false',0,0,0,'fine_steel','none',1,10,'sword',8,0.00000,0,0,0,379,0,1,-1,10080,0,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(13336,'Scissors-type Stick (Event)','7-day Limited Period','rhand','false',0,0,0,'fine_steel','none',1,10,'sword',8,0.00000,0,0,0,379,0,1,-1,10080,0,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(13337,'Rock-type Stick (Event)','7-day Limited Period','rhand','false',0,0,0,'fine_steel','none',1,10,'sword',8,0.00000,0,0,0,379,0,1,-1,10080,0,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(13338,'Paper-type Stick (Event)','7-day Limited Period','rhand','false',0,0,0,'fine_steel','none',1,10,'sword',8,0.00000,0,0,0,379,0,1,-1,10080,0,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(13339,'Pumpkin Transformation Stick (Event)','7-day Limited Period','rhand','false',0,0,0,'fine_steel','none',1,10,'sword',8,0.00000,0,0,0,379,0,1,-1,10080,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'8246-1;');

INSERT INTO `weapon` VALUES
(13447,'(not used) Vesper Shield','','lhand','true',1370,0,0,'fine_steel','s84',0,0,'none',0,0.00000,-8,230,20,0,0,0,-1,-1,850000,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(13457,'Vesper Cutter','','rhand','true',1520,1,1,'fine_steel','s84',396,10,'sword',8,0.00000,0,0,0,379,0,176,-1,-1,146873000,7050,'true','true','true','true','true',0,0,0,0,0,0,0,0,13468,'0-0;'),
(13458,'Vesper Slasher','','lrhand','true',1740,1,1,'fine_steel','s84',482,10,'bigsword',8,0.00000,0,0,0,325,0,176,-1,-1,146873000,7050,'true','true','true','true','true',0,0,0,0,0,0,0,0,13470,'0-0;'),
(13459,'Vesper Buster','','rhand','true',1520,1,1,'fine_steel','s84',317,10,'sword',8,0.00000,0,0,0,379,0,234,-1,-1,146873000,7050,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(13460,'Vesper Shaper','','rhand','true',1520,1,1,'fine_steel','s84',346,5,'dagger',12,-3.00000,0,0,0,433,0,176,-1,-1,146873000,7050,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(13461,'Vesper Fighter','','lrhand','true',1550,1,1,'fine_steel','s84',482,5,'dualfist',4,4.00000,0,0,0,325,0,176,-1,-1,146873000,7050,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(13462,'Vesper Stormer','','lrhand','true',2010,1,1,'fine_steel','s84',396,10,'pole',8,-3.00000,0,0,0,325,0,176,-1,-1,146873000,7050,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3599-1;'),
(13463,'Vesper Avenger','','rhand','true',1740,1,1,'fine_steel','s84',396,20,'blunt',4,4.00000,0,0,0,379,0,176,-1,-1,146873000,7050,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(13464,'Vesper Retributer','','lrhand','true',1740,1,1,'fine_steel','s84',482,20,'bigblunt',4,4.00000,0,0,0,325,0,176,-1,-1,146873000,7050,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(13465,'Vesper Caster','','rhand','true',1080,1,1,'fine_steel','s84',317,20,'blunt',4,4.00000,0,0,0,379,0,234,-1,-1,146873000,7050,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(13466,'Vesper Singer','','lrhand','true',1080,1,1,'fine_steel','s84',386,20,'bigblunt',4,4.00000,0,0,0,325,0,257,-1,-1,146873000,7050,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(13467,'Vesper Thrower','','lrhand','true',1520,1,1,'fine_steel','s84',724,5,'bow',12,-3.00000,0,0,0,293,12,176,-1,-1,146873000,7050,'true','true','true','true','true',0,0,0,0,0,0,0,0,13469,'0-0;'),
(13468,'Vesper Pincer','','rhand','true',1280,1,1,'fine_steel','s84',359,40,'rapier',10,-1.00000,0,0,0,406,0,176,-1,-1,146873000,7050,'true','true','true','true','true',3426,1,0,0,0,0,0,0,13457,'0-0;'),
(13469,'Vesper Sheutjeh','','rhand','true',1580,1,1,'fine_steel','s84',444,10,'crossbow',10,-1.00000,0,0,0,303,0,176,-1,-1,146873000,7050,'true','true','true','true','true',0,0,0,0,0,0,0,0,13467,'0-0;'),
(13470,'Vesper Nagan','','lrhand','true',1800,1,1,'fine_steel','s84',429,15,'ancient',8,2.00000,0,0,0,350,0,176,-1,-1,146873000,7050,'true','true','true','true','true',0,0,0,0,0,0,0,0,13458,'0-0;'),
(13471,'Vesper Shield','','lhand','true',1130,0,0,'fine_steel','s84',0,0,'none',0,0.00000,-8,371,20,0,0,0,-1,-1,12250000,588,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(13524,'Gracia Soldier One-handed Sword','','rhand','false',1500,2,2,'fine_steel','none',24,10,'sword',8,0.00000,0,0,0,379,0,17,-1,-1,105000,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(13525,'Gracia Soldier Shield','','rhand','false',1300,0,0,'fine_steel','none',0,0,'sword',0,0.00000,-8,101,20,0,0,0,-1,-1,16900,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(13528,'Test Dual Daggers','','lrhand','false',500,3,3,'fine_steel','none',200,10,'dualdagger',8,0.00000,0,0,0,325,0,6,-1,-1,3340000,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(13530,'Flag of Gludio','','rhand','false',500,1,1,'fine_steel','none',0,0,'sword',0,0.00000,0,0,0,325,0,0,-1,-1,0,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(13531,'Flag of Dion','','rhand','false',500,1,1,'fine_steel','none',0,0,'sword',0,0.00000,0,0,0,325,0,0,-1,-1,0,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(13532,'Flag of Giran','','rhand','false',500,1,1,'fine_steel','none',0,0,'sword',0,0.00000,0,0,0,325,0,0,-1,-1,0,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(13533,'Flag of Oren','','rhand','false',500,1,1,'fine_steel','none',0,0,'sword',0,0.00000,0,0,0,325,0,0,-1,-1,0,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(13534,'Flag of Aden','','rhand','false',500,1,1,'fine_steel','none',0,0,'sword',0,0.00000,0,0,0,325,0,0,-1,-1,0,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(13535,'Flag of Innadril','','rhand','false',500,1,1,'fine_steel','none',0,0,'sword',0,0.00000,0,0,0,325,0,0,-1,-1,0,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(13536,'Flag of Goddard','','rhand','false',500,1,1,'fine_steel','none',0,0,'sword',0,0.00000,0,0,0,325,0,0,-1,-1,0,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(13537,'Flag of Rune','','rhand','false',500,1,1,'fine_steel','none',0,0,'sword',0,0.00000,0,0,0,325,0,0,-1,-1,0,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(13538,'Flag of Schuttgart','','rhand','false',500,1,1,'fine_steel','none',0,0,'sword',0,0.00000,0,0,0,325,0,0,-1,-1,0,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(13539,'Staff of Master Yogi','','lrhand','false',10,0,0,'fine_steel','none',11,20,'blunt',4,4.00000,0,0,0,325,0,12,-1,-1,0,0,'false','false','true','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(13556,'Airship Helm','','rhand','false',0,0,0,'fine_steel','none',1,10,'sword',8,0.00000,0,0,0,379,0,1,-1,-1,0,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(13557,'Airship Cannon','','rhand','false',0,0,0,'fine_steel','none',1,10,'sword',8,0.00000,0,0,0,379,0,1,-1,-1,0,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(13558,'Airship Cannon Briquet','','rhand','false',0,0,0,'fine_steel','none',1,10,'sword',8,0.00000,0,0,0,379,0,1,-1,-1,0,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(13560,'Gludio Ward','','lrhand','false',500,1,1,'wood','none',0,0,'none',0,0.00000,0,0,0,325,0,0,-1,-1,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'846-1;847-1;'),
(13561,'Dion Ward','','lrhand','false',500,1,1,'wood','none',0,0,'none',0,0.00000,0,0,0,325,0,0,-1,-1,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'846-1;847-1;'),
(13562,'Giran Ward','','lrhand','false',500,1,1,'wood','none',0,0,'none',0,0.00000,0,0,0,325,0,0,-1,-1,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'846-1;847-1;'),
(13563,'Oren Ward','','lrhand','false',500,1,1,'wood','none',0,0,'none',0,0.00000,0,0,0,325,0,0,-1,-1,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'846-1;847-1;'),
(13564,'Aden Ward','','lrhand','false',500,1,1,'wood','none',0,0,'none',0,0.00000,0,0,0,325,0,0,-1,-1,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'846-1;847-1;'),
(13565,'Innadril Ward','','lrhand','false',500,1,1,'wood','none',0,0,'none',0,0.00000,0,0,0,325,0,0,-1,-1,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'846-1;847-1;'),
(13566,'Goddard Ward','','lrhand','false',500,1,1,'wood','none',0,0,'none',0,0.00000,0,0,0,325,0,0,-1,-1,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'846-1;847-1;'),
(13567,'Rune Ward','','lrhand','false',500,1,1,'wood','none',0,0,'none',0,0.00000,0,0,0,325,0,0,-1,-1,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'846-1;847-1;'),
(13568,'Schuttgart Ward','','lrhand','false',500,1,1,'wood','none',0,0,'none',0,0.00000,0,0,0,325,0,0,-1,-1,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'846-1;847-1;'),
(13755,'Olympiad Warrior\'s Weapon (undetermined)','','rhand','false',1500,2,2,'fine_steel','none',24,10,'sword',8,0.00000,0,0,0,379,0,17,-1,-1,0,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(13770,'Shadow Item - Shield of Yehan Miakesh','','lhand','false',1300,0,0,'fine_steel','none',0,0,'none',0,0.00000,-8,101,20,0,0,0,60,-1,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(13789,'Red Boing Hammer','','rhand','true',1710,2,2,'fine_steel','c',107,20,'blunt',4,4.00000,0,0,0,379,0,61,-1,-1,0,705,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(13790,'Blue Boing Hammer','','rhand','true',1710,2,2,'fine_steel','c',107,20,'blunt',4,4.00000,0,0,0,379,0,61,-1,-1,0,705,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(13791,'Small Red Boing Hammer','','rhand','true',1710,2,2,'fine_steel','c',107,20,'blunt',4,4.00000,0,0,0,379,0,61,-1,-1,0,705,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(13792,'Small Blue Boing Hammer','','rhand','true',1710,2,2,'fine_steel','c',107,20,'blunt',4,4.00000,0,0,0,379,0,61,-1,-1,0,705,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(13809,'Court Magician\'s Magic Staff','','rhand','false',0,0,0,'fine_steel','none',0,0,'sword',0,0.00000,0,0,0,0,0,0,-1,-1,0,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(13842,'Tiat Two-Handed Weapon','','lrhand','true',2180,2,2,'fine_steel','d',78,10,'bigsword',8,0.00000,0,0,0,325,0,39,-1,-1,0,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(13843,'Draconic Peltast Weapon','','rhand','false',300,2,2,'fine_steel','d',5,5,'dagger',12,-3.00000,0,0,0,433,0,5,-1,-1,0,743,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(13845,'Attribute Master Yin\'s Sword','','rhand','false',1560,2,2,'fine_steel','a',140,10,'sword',8,0.00000,0,0,0,379,0,120,-1,10,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(13881,'Attribute Master Yang\'s Sword','','rhand','false',1560,2,2,'fine_steel','a',140,10,'sword',8,0.00000,0,0,0,379,0,120,-1,10,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(13882,'Dynasty Dual Daggers','','lrhand','true',2150,1,1,'fine_steel','s80',304,10,'dualdagger',12,-3.00000,0,0,0,433,0,157,-1,-1,87901000,4219,'true','true','true','true','true',3044,20,0,0,0,0,0,0,0,'0-0;'),
(13883,'Icarus Dual Daggers','','lrhand','true',2100,1,1,'fine_steel','s80',332,10,'dualdagger',12,-3.00000,0,0,0,433,0,169,-1,-1,121780000,5845,'true','true','true','true','true',3044,20,0,0,0,0,0,0,0,'0-0;'),
(13884,'Vesper Dual Daggers','','lrhand','true',2050,1,1,'fine_steel','s84',360,10,'dualdagger',12,-3.00000,0,0,0,433,0,181,-1,-1,171530000,8233,'true','true','true','true','true',3044,20,0,0,0,0,0,0,0,'0-0;'),
(13971,'Red Boing Fantasy Hammer','','rhand','true',1710,2,2,'fine_steel','c',1,1,'blunt',4,4.00000,0,0,0,379,0,61,-1,-1,0,705,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(13972,'Blue Boing Fantasy Hammer','','rhand','true',1710,2,2,'fine_steel','c',1,1,'blunt',4,4.00000,0,0,0,379,0,61,-1,-1,0,705,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(13973,'Small Red Boing Fantasy Hammer','','rhand','true',1710,2,2,'fine_steel','c',1,1,'blunt',4,4.00000,0,0,0,379,0,61,-1,-1,0,705,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(13974,'Small Blue Boing Fantasy Hammer','','rhand','true',1710,2,2,'fine_steel','c',1,1,'blunt',4,4.00000,0,0,0,379,0,61,-1,-1,0,705,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(13978,'Exclusive to Monsters (Mounted Troops High Level Leader)','','lrhand','false',2120,2,2,'fine_steel','none',31,10,'pole',8,-3.00000,0,0,0,325,0,21,-1,-1,188000,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(13979,'Exclusive to Monsters (Dragon Steed Troop Battle Infantry Sword)','','rhand','false',1560,2,2,'fine_steel','none',24,10,'sword',8,0.00000,0,0,0,379,0,17,-1,-1,30,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(13980,'Exclusive to Monsters (Dragon Steed Troop Battle Infantry Shield)','','lhand','false',1430,0,0,'fine_steel','none',0,0,'none',0,0.00000,-8,47,20,0,0,0,-1,-1,30,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(13981,'Exclusive to Monsters (Mounted Troops Tactics)','','rhand','false',1080,1,1,'fine_steel','none',11,20,'blunt',4,4.00000,0,0,0,325,0,12,-1,-1,9600,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(13982,'Exclusive to Monsters (Death Knight_pole)','','lrhand','false',2140,2,2,'fine_steel','none',24,10,'pole',8,-3.00000,0,0,0,325,0,17,-1,-1,0,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(13983,'Exclusive to Monsters (Death Knight_2hs)','','lrhand','true',2180,2,2,'fine_steel','d',78,10,'bigsword',8,0.00000,0,0,0,325,0,39,-1,-1,0,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(13984,'Exclusive to Monsters (Death Slayer_1hs)','','rhand','false',1560,2,2,'fine_steel','none',24,10,'sword',8,0.00000,0,0,0,379,0,17,-1,-1,0,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(13985,'Exclusive to Monsters (Death Slayer_r)','','lrhand','true',2150,1,1,'fine_steel','b',213,10,'dual',8,0.00000,0,0,0,325,0,91,-1,-1,6680500,891,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(13986,'Exclusive to Monsters (Death Slayer_l)','','lrhand','true',2150,1,1,'fine_steel','b',213,10,'dual',8,0.00000,0,0,0,325,0,91,-1,-1,6680500,891,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(13987,'Exclusive to Monsters (Savage Warrior)','','rhand','true',1620,1,1,'fine_steel','b',175,20,'blunt',4,4.00000,0,0,0,379,0,91,-1,-1,6680500,891,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(14056,'Snow Kung Transformation Stick','30-day limited period','rhand','false',0,0,0,'fine_steel','none',1,10,'sword',8,0.00000,0,0,0,379,0,1,-1,43200,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'8263-1;'),
(14057,'Scarecrow Jack Transformation Stick','30-day limited period','rhand','false',0,0,0,'fine_steel','none',1,10,'sword',8,0.00000,0,0,0,379,0,1,-1,43200,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'8264-1;'),
(14058,'Tin Golem Transformation Stick','30-day limited period','rhand','false',0,0,0,'fine_steel','none',1,10,'sword',8,0.00000,0,0,0,379,0,1,-1,43200,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'8265-1;'),
(14069,'Snow Kung Transformation Stick (event)','30-day limited period','rhand','false',0,0,0,'fine_steel','none',1,10,'sword',8,0.00000,0,0,0,379,0,1,-1,43200,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'8263-1;'),
(14070,'Scarecrow Jack Transformation Stick (Event)','30-day limited period','rhand','false',0,0,0,'fine_steel','none',1,10,'sword',8,0.00000,0,0,0,379,0,1,-1,43200,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'8264-1;'),
(14071,'Tin Golem Transformation Stick (event)','30-day limited period','rhand','false',0,0,0,'fine_steel','none',1,10,'sword',8,0.00000,0,0,0,379,0,1,-1,43200,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'8265-1;'),
(14088,'Snow Kung Transformation Stick','7-day Limited Period','rhand','false',0,0,0,'fine_steel','none',1,10,'sword',8,0.00000,0,0,0,379,0,1,-1,10080,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'8263-1;'),
(14089,'Scarecrow Jack Transformation Stick','7-day Limited Period','rhand','false',0,0,0,'fine_steel','none',1,10,'sword',8,0.00000,0,0,0,379,0,1,-1,10080,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'8264-1;'),
(14090,'Tin Golem Transformation Stick','7-day Limited Period','rhand','false',0,0,0,'fine_steel','none',1,10,'sword',8,0.00000,0,0,0,379,0,1,-1,10080,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'8265-1;'),
(14096,'Snow Kung Transformation Stick (event)','7-day Limited Period','rhand','false',0,0,0,'fine_steel','none',1,10,'sword',8,0.00000,0,0,0,379,0,1,-1,10080,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'8263-1;'),
(14097,'Scarecrow Jack Transformation Stick (Event)','7-day Limited Period','rhand','false',0,0,0,'fine_steel','none',1,10,'sword',8,0.00000,0,0,0,379,0,1,-1,10080,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'8264-1;'),
(14098,'Tin Golem Transformation Stick (event)','7-day Limited Period','rhand','false',0,0,0,'fine_steel','none',1,10,'sword',8,0.00000,0,0,0,379,0,1,-1,10080,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'8265-1;'),
(14111,'Sealed Vesper Shield','','lhand','true',1130,0,0,'fine_steel','s84',0,0,'none',0,0.00000,-8,352,20,0,0,0,-1,-1,12250000,588,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(14118,'Vesper Cutter','Haste','rhand','true',1520,1,1,'fine_steel','s84',396,10,'sword',8,0.00000,0,0,0,379,0,176,-1,-1,146873000,7050,'true','true','true','true','true',0,0,0,0,0,0,0,0,14151,'8297-1;'),
(14119,'Vesper Cutter','Health','rhand','true',1520,1,1,'fine_steel','s84',396,10,'sword',8,0.00000,0,0,0,379,0,176,-1,-1,146873000,7050,'true','true','true','true','true',0,0,0,0,0,0,0,0,14152,'3013-5;'),
(14120,'Vesper Cutter','Focus','rhand','true',1520,1,1,'fine_steel','s84',396,10,'sword',8,0.00000,0,0,0,379,0,176,-1,-1,146873000,7050,'true','true','true','true','true',0,0,0,0,0,0,0,0,14153,'8295-1;'),
(14121,'Vesper Slasher','Haste','lrhand','true',1740,1,1,'fine_steel','s84',482,10,'bigsword',8,0.00000,0,0,0,325,0,176,-1,-1,146873000,7050,'true','true','true','true','true',0,0,0,0,0,0,0,0,14157,'8297-1;'),
(14122,'Vesper Slasher','Health','lrhand','true',1740,1,1,'fine_steel','s84',482,10,'bigsword',8,0.00000,0,0,0,325,0,176,-1,-1,146873000,7050,'true','true','true','true','true',0,0,0,0,0,0,0,0,14158,'3013-5;'),
(14123,'Vesper Slasher','Focus','lrhand','true',1740,1,1,'fine_steel','s84',482,10,'bigsword',8,0.00000,0,0,0,325,0,176,-1,-1,146873000,7050,'true','true','true','true','true',0,0,0,0,0,0,0,0,14159,'8295-1;'),
(14124,'Vesper Buster','Mana Up','rhand','true',1520,1,1,'fine_steel','s84',317,10,'sword',8,0.00000,0,0,0,379,0,234,-1,-1,146873000,7050,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3014-3;'),
(14125,'Vesper Buster','Acumen','rhand','true',1520,1,1,'fine_steel','s84',317,10,'sword',8,0.00000,0,0,0,379,0,234,-1,-1,146873000,7050,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3047-3;'),
(14126,'Vesper Buster','Magic Hold','rhand','true',1520,1,1,'fine_steel','s84',317,10,'sword',8,0.00000,0,0,0,379,0,234,-1,-1,146873000,7050,'true','true','true','true','true',0,0,3577,1,20,0,0,0,0,'3552-1;'),
(14127,'Vesper Shaper','Critical Damage','rhand','true',1520,1,1,'fine_steel','s84',346,5,'dagger',12,-3.00000,0,0,0,433,0,176,-1,-1,146873000,7050,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3572-2;'),
(14128,'Vesper Shaper','HP Drain','rhand','true',1520,1,1,'fine_steel','s84',346,5,'dagger',12,-3.00000,0,0,0,433,0,176,-1,-1,146873000,7050,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3568-1;'),
(14129,'Vesper Shaper','Haste','rhand','true',1520,1,1,'fine_steel','s84',346,5,'dagger',12,-3.00000,0,0,0,433,0,176,-1,-1,146873000,7050,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'8297-1;'),
(14130,'Vesper Fighter','Focus','lrhand','true',1550,1,1,'fine_steel','s84',482,5,'dualfist',4,4.00000,0,0,0,325,0,176,-1,-1,146873000,7050,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'8289-1;'),
(14131,'Vesper Fighter','Health','lrhand','true',1550,1,1,'fine_steel','s84',482,5,'dualfist',4,4.00000,0,0,0,325,0,176,-1,-1,146873000,7050,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3013-5;'),
(14132,'Vesper Fighter','Critical Stun','lrhand','true',1550,1,1,'fine_steel','s84',482,5,'dualfist',4,4.00000,0,0,0,325,0,176,-1,-1,146873000,7050,'true','true','true','true','true',0,0,0,0,0,3571,1,43,0,'3552-1;'),
(14133,'Vesper Stormer','Health','lrhand','true',2010,1,1,'fine_steel','s84',396,10,'pole',8,-3.00000,0,0,0,325,0,176,-1,-1,146873000,7050,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3013-4;'),
(14134,'Vesper Stormer','Guidance','lrhand','true',2010,1,1,'fine_steel','s84',396,10,'pole',8,-3.00000,0,0,0,325,0,176,-1,-1,146873000,7050,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3602-10;'),
(14135,'Vesper Stormer','Haste','lrhand','true',2010,1,1,'fine_steel','s84',396,10,'pole',8,-3.00000,0,0,0,325,0,176,-1,-1,146873000,7050,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3599-1;8297-1;'),
(14136,'Vesper Avenger','HP Drain','rhand','true',1740,1,1,'fine_steel','s84',396,20,'blunt',4,4.00000,0,0,0,379,0,176,-1,-1,146873000,7050,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3599-1;3568-1;'),
(14137,'Vesper Avenger','Health','rhand','true',1740,1,1,'fine_steel','s84',396,20,'blunt',4,4.00000,0,0,0,379,0,176,-1,-1,146873000,7050,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3013-4;'),
(14138,'Vesper Avenger','HP Regeneration','rhand','true',1740,1,1,'fine_steel','s84',396,20,'blunt',4,4.00000,0,0,0,379,0,176,-1,-1,146873000,7050,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3569-1;'),
(14139,'Vesper Retributer','HP Regeneration','lrhand','true',1740,1,1,'fine_steel','s84',482,20,'bigblunt',4,4.00000,0,0,0,325,0,176,-1,-1,146873000,7050,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3569-1;'),
(14140,'Vesper Retributer','Health','lrhand','true',1740,1,1,'fine_steel','s84',482,20,'bigblunt',4,4.00000,0,0,0,325,0,176,-1,-1,146873000,7050,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3013-5;'),
(14141,'Vesper Retributer','HP Drain','lrhand','true',1740,1,1,'fine_steel','s84',482,20,'bigblunt',4,4.00000,0,0,0,325,0,176,-1,-1,146873000,7050,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3568-1;'),
(14142,'Vesper Caster','Acumen','rhand','true',1080,1,1,'fine_steel','s84',317,20,'blunt',4,4.00000,0,0,0,379,0,234,-1,-1,146873000,7050,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3047-3;'),
(14143,'Vesper Caster','MP Regeneration','rhand','true',1080,1,1,'fine_steel','s84',317,20,'blunt',4,4.00000,0,0,0,379,0,234,-1,-1,146873000,7050,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3576-2;'),
(14144,'Vesper Caster','Mana Up','rhand','true',1080,1,1,'fine_steel','s84',317,20,'blunt',4,4.00000,0,0,0,379,0,234,-1,-1,146873000,7050,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3014-3;'),
(14145,'Vesper Singer','Empower','lrhand','true',1080,1,1,'fine_steel','s84',386,20,'bigblunt',4,4.00000,0,0,0,325,0,257,-1,-1,146873000,7050,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3575-2;'),
(14146,'Vesper Singer','MP Regeneration','lrhand','true',1080,1,1,'fine_steel','s84',386,20,'bigblunt',4,4.00000,0,0,0,325,0,257,-1,-1,146873000,7050,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3576-2;'),
(14147,'Vesper Singer','Magic Hold','lrhand','true',1080,1,1,'fine_steel','s84',386,20,'bigblunt',4,4.00000,0,0,0,325,0,257,-1,-1,146873000,7050,'true','true','true','true','true',0,0,3577,1,20,0,0,0,0,'3552-1;'),
(14148,'Vesper Thrower','Cheap Shot','lrhand','true',1520,1,1,'fine_steel','s84',724,5,'bow',12,-3.00000,0,0,0,293,12,176,-1,-1,146873000,7050,'true','true','true','true','true',0,0,0,0,0,0,0,0,14154,'3552-1;'),
(14149,'Vesper Thrower','Focus','lrhand','true',1520,1,1,'fine_steel','s84',724,5,'bow',12,-3.00000,0,0,0,293,12,176,-1,-1,146873000,7050,'true','true','true','true','true',0,0,0,0,0,0,0,0,14155,'8298-1;'),
(14150,'Vesper Thrower','Critical Slow','lrhand','true',1520,1,1,'fine_steel','s84',724,5,'bow',12,-3.00000,0,0,0,293,12,176,-1,-1,146873000,7050,'true','true','true','true','true',0,0,0,0,0,3574,3,20,14156,'3552-1;'),
(14151,'Vesper Pincer','Haste','rhand','true',1280,1,1,'fine_steel','s84',359,40,'rapier',10,-1.00000,0,0,0,406,0,176,-1,-1,146873000,7050,'true','true','true','true','true',3426,1,0,0,0,0,0,0,14118,'8297-1;'),
(14152,'Vesper Pincer','Health','rhand','true',1280,1,1,'fine_steel','s84',359,40,'rapier',10,-1.00000,0,0,0,406,0,176,-1,-1,146873000,7050,'true','true','true','true','true',3426,1,0,0,0,0,0,0,14119,'3013-5;'),
(14153,'Vesper Pincer','Focus','rhand','true',1280,1,1,'fine_steel','s84',359,40,'rapier',10,-1.00000,0,0,0,406,0,176,-1,-1,146873000,7050,'true','true','true','true','true',3426,1,0,0,0,0,0,0,14120,'8296-1;'),
(14154,'Vesper Sheutjeh','Cheap Shot','rhand','true',1580,1,1,'fine_steel','s84',444,10,'crossbow',10,-1.00000,0,0,0,303,0,176,-1,-1,146873000,7050,'true','true','true','true','true',0,0,0,0,0,0,0,0,14148,'3552-1;'),
(14155,'Vesper Sheutjeh','Focus','rhand','true',1580,1,1,'fine_steel','s84',444,10,'crossbow',10,-1.00000,0,0,0,303,0,176,-1,-1,146873000,7050,'true','true','true','true','true',0,0,0,0,0,0,0,0,14149,'8296-1;'),
(14156,'Vesper Sheutjeh','Critical Slow','rhand','true',1580,1,1,'fine_steel','s84',444,10,'crossbow',10,-1.00000,0,0,0,303,0,176,-1,-1,146873000,7050,'true','true','true','true','true',0,0,0,0,0,3574,3,20,14150,'3552-1;'),
(14157,'Vesper Nagan','Haste','lrhand','true',1800,1,1,'fine_steel','s84',429,15,'ancient',8,2.00000,0,0,0,350,0,176,-1,-1,146873000,7050,'true','true','true','true','true',0,0,0,0,0,0,0,0,14121,'8297-1;'),
(14158,'Vesper Nagan','Health','lrhand','true',1800,1,1,'fine_steel','s84',429,15,'ancient',8,2.00000,0,0,0,350,0,176,-1,-1,146873000,7050,'true','true','true','true','true',0,0,0,0,0,0,0,0,14122,'3013-5;'),
(14159,'Vesper Nagan','Focus','lrhand','true',1800,1,1,'fine_steel','s84',429,15,'ancient',8,2.00000,0,0,0,350,0,176,-1,-1,146873000,7050,'true','true','true','true','true',0,0,0,0,0,0,0,0,14123,'8295-1;'),
(14363,'Icarus Sawsword {PvP}','','rhand','true',1520,1,1,'fine_steel','s80',363,10,'sword',8,0.00000,0,0,0,379,0,163,-1,-1,103439000,4965,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3650-1;'),
(14364,'Icarus Disperser {PvP}','','rhand','true',1520,1,1,'fine_steel','s80',318,5,'dagger',12,-3.00000,0,0,0,433,0,163,-1,-1,103439000,4965,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3651-1;3652-1;'),
(14365,'Icarus Spirit {PvP}','','rhand','true',1520,1,1,'fine_steel','s80',290,10,'sword',8,0.00000,0,0,0,379,0,217,-1,-1,103439000,4965,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3654-1;'),
(14366,'Icarus Heavy Arms {PvP}','','lrhand','true',1740,1,1,'fine_steel','s80',442,10,'bigsword',8,0.00000,0,0,0,325,0,163,-1,-1,103439000,4965,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3653-1;'),
(14367,'Icarus Trident {PvP}','','lrhand','true',2010,1,1,'fine_steel','s80',363,10,'pole',8,-3.00000,0,0,0,325,0,163,-1,-1,103439000,4965,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3599-1;3653-1;'),
(14368,'Icarus Hammer {PvP}','','rhand','true',1740,1,1,'fine_steel','s80',363,20,'blunt',4,4.00000,0,0,0,379,0,163,-1,-1,103439000,4965,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3650-1;'),
(14369,'Icarus Hand {PvP}','','lrhand','true',1550,1,1,'fine_steel','s80',442,5,'dualfist',4,4.00000,0,0,0,325,0,163,-1,-1,103439000,4965,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3650-1;'),
(14370,'Icarus Hall {PvP}','','rhand','true',1080,1,1,'fine_steel','s80',290,20,'blunt',4,4.00000,0,0,0,379,0,217,-1,-1,103439000,4965,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3654-1;'),
(14371,'Icarus Spitter {PvP}','','lrhand','true',1520,1,1,'fine_steel','s80',689,5,'bow',12,-3.00000,0,0,0,293,11,163,-1,-1,103439000,4965,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3655-1;'),
(14372,'Icarus Stinger {PvP}','','rhand','true',1280,1,1,'fine_steel','s80',329,40,'rapier',10,-1.00000,0,0,0,406,0,163,-1,-1,103439000,4965,'false','false','true','false','true',3426,1,0,0,0,0,0,0,0,'3650-1;'),
(14373,'Icarus Wingblade {PvP}','','lrhand','true',1800,1,1,'fine_steel','s80',393,15,'ancient',8,2.00000,0,0,0,350,0,163,-1,-1,103439000,4965,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3653-1;'),
(14374,'Icarus Shooter {PvP}','','rhand','true',1580,1,1,'fine_steel','s80',422,10,'crossbow',10,-1.00000,0,0,0,303,0,163,-1,-1,103439000,4965,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3655-1;'),
(14375,'Icarus Dual Sword {PvP}','','lrhand','true',1520,1,1,'fine_steel','s80',442,10,'dual',8,0.00000,0,0,0,325,0,163,-1,-1,103439000,4965,'false','false','true','false','true',3411,1,0,0,0,0,0,0,0,'3656-1;'),
(14376,'Icarus Sawsword {PvP}','Focus','rhand','true',1520,1,1,'fine_steel','s80',363,10,'sword',8,0.00000,0,0,0,379,0,163,-1,-1,103439000,4965,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3566-2;3650-1;'),
(14377,'Icarus Sawsword {PvP}','Health','rhand','true',1520,1,1,'fine_steel','s80',363,10,'sword',8,0.00000,0,0,0,379,0,163,-1,-1,103439000,4965,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3013-5;3650-1;'),
(14378,'Icarus Sawsword {PvP}','Light','rhand','true',1520,1,1,'fine_steel','s80',363,10,'sword',8,0.00000,0,0,0,379,0,163,-1,-1,103439000,4965,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3498-1;3650-1;'),
(14379,'Icarus Heavy Arms {PvP}','Focus','lrhand','true',1740,1,1,'fine_steel','s80',442,10,'bigsword',8,0.00000,0,0,0,325,0,163,-1,-1,103439000,4965,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3566-2;3653-1;'),
(14380,'Icarus Heavy Arms {PvP}','Health','lrhand','true',1740,1,1,'fine_steel','s80',442,10,'bigsword',8,0.00000,0,0,0,325,0,163,-1,-1,103439000,4965,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3013-5;3653-1;'),
(14381,'Icarus Heavy Arms {PvP}','Light','lrhand','true',1740,1,1,'fine_steel','s80',442,10,'bigsword',8,0.00000,0,0,0,325,0,163,-1,-1,103439000,4965,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3498-1;3653-1;'),
(14382,'Icarus Spirit {PvP}','Acumen','rhand','true',1520,1,1,'fine_steel','s80',290,10,'sword',8,0.00000,0,0,0,379,0,217,-1,-1,103439000,4965,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3047-3;3654-1;'),
(14383,'Icarus Spirit {PvP}','Mana Up','rhand','true',1520,1,1,'fine_steel','s80',290,10,'sword',8,0.00000,0,0,0,379,0,217,-1,-1,103439000,4965,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3014-3;3654-1;'),
(14384,'Icarus Spirit {PvP}','Conversion','rhand','true',1520,1,1,'fine_steel','s80',290,10,'sword',8,0.00000,0,0,0,379,0,217,-1,-1,103439000,4965,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3048-3;3654-1;'),
(14385,'Icarus Spitter {PvP}','Cheap Shot','lrhand','true',1520,1,1,'fine_steel','s80',689,5,'bow',12,-3.00000,0,0,0,293,11,163,-1,-1,103439000,4965,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3552-1;3655-1;'),
(14386,'Icarus Spitter {PvP}','Guidance','lrhand','true',1520,1,1,'fine_steel','s80',689,5,'bow',12,-3.00000,0,0,0,293,11,163,-1,-1,103439000,4965,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3573-1;3655-1;'),
(14387,'Icarus Spitter {PvP}','Focus','lrhand','true',1520,1,1,'fine_steel','s80',689,5,'bow',12,-3.00000,0,0,0,293,11,163,-1,-1,103439000,4965,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3567-2;3655-1;'),
(14388,'Icarus Disperser {PvP}','Focus','rhand','true',1520,1,1,'fine_steel','s80',318,5,'dagger',12,-3.00000,0,0,0,433,0,163,-1,-1,103439000,4965,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3567-2;3651-1;3652-1;'),
(14389,'Icarus Disperser {PvP}','Evasion','rhand','true',1520,1,1,'fine_steel','s80',318,5,'dagger',12,-3.00000,0,0,0,433,0,163,-1,-1,103439000,4965,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3009-8;3651-1;3652-1;'),
(14390,'Icarus Disperser {PvP}','Critical Damage','rhand','true',1520,1,1,'fine_steel','s80',318,5,'dagger',12,-3.00000,0,0,0,433,0,163,-1,-1,103439000,4965,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3066-4;3651-1;3652-1;'),
(14391,'Icarus Trident {PvP}','Anger','lrhand','true',2010,1,1,'fine_steel','s80',363,10,'pole',8,-3.00000,0,0,0,325,0,163,-1,-1,103439000,4965,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3600-10;3653-1;'),
(14392,'Icarus Trident {PvP}','Critical Stun','lrhand','true',2010,1,1,'fine_steel','s80',363,10,'pole',8,-3.00000,0,0,0,325,0,163,-1,-1,103439000,4965,'false','false','true','false','true',0,0,0,0,0,3070,3,48,0,'3552-2;3653-1;'),
(14393,'Icarus Trident {PvP}','Light','lrhand','true',2010,1,1,'fine_steel','s80',363,10,'pole',8,-3.00000,0,0,0,325,0,163,-1,-1,103439000,4965,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3599-1;3498-1;3653-1;'),
(14394,'Icarus Hammer {PvP}','Anger','rhand','true',1740,1,1,'fine_steel','s80',363,20,'blunt',4,4.00000,0,0,0,379,0,163,-1,-1,103439000,4965,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3057-3;3650-1;'),
(14395,'Icarus Hammer {PvP}','Health','rhand','true',1740,1,1,'fine_steel','s80',363,20,'blunt',4,4.00000,0,0,0,379,0,163,-1,-1,103439000,4965,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3013-5;3650-1;'),
(14396,'Icarus Hammer {PvP}','Rsk. Focus','rhand','true',1740,1,1,'fine_steel','s80',363,20,'blunt',4,4.00000,0,0,0,379,0,163,-1,-1,103439000,4965,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3027-7;3650-1;'),
(14397,'Icarus Hall {PvP}','Mana Up','rhand','true',1080,1,1,'fine_steel','s80',290,20,'blunt',4,4.00000,0,0,0,379,0,217,-1,-1,103439000,4965,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3014-3;3654-1;'),
(14398,'Icarus Hall {PvP}','Conversion','rhand','true',1080,1,1,'fine_steel','s80',290,20,'blunt',4,4.00000,0,0,0,379,0,217,-1,-1,103439000,4965,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3048-3;3654-1;'),
(14399,'Icarus Hall {PvP}','Acumen','rhand','true',1080,1,1,'fine_steel','s80',290,20,'blunt',4,4.00000,0,0,0,379,0,217,-1,-1,103439000,4965,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3047-3;3654-1;'),
(14400,'Icarus Hand {PvP}','Rsk. Evasion','lrhand','true',1550,1,1,'fine_steel','s80',442,5,'dualfist',4,4.00000,0,0,0,325,0,163,-1,-1,103439000,4965,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3069-1;3651-1;3652-1;'),
(14401,'Icarus Hand {PvP}','Focus','lrhand','true',1550,1,1,'fine_steel','s80',442,5,'dualfist',4,4.00000,0,0,0,325,0,163,-1,-1,103439000,4965,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3565-2;3651-1;3652-1;'),
(14402,'Icarus Hand {PvP}','Haste','lrhand','true',1550,1,1,'fine_steel','s80',442,5,'dualfist',4,4.00000,0,0,0,325,0,163,-1,-1,103439000,4965,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'8297-1;3651-1;3652-1;'),
(14403,'Icarus Stinger {PvP}','Focus','rhand','true',1280,1,1,'fine_steel','s80',329,40,'rapier',10,-1.00000,0,0,0,406,0,163,-1,-1,103439000,4965,'false','false','true','false','true',3426,1,0,0,0,0,0,0,0,'3566-2;3650-1;'),
(14404,'Icarus Stinger {PvP}','Health','rhand','true',1280,1,1,'fine_steel','s80',329,40,'rapier',10,-1.00000,0,0,0,406,0,163,-1,-1,103439000,4965,'false','false','true','false','true',3426,1,0,0,0,0,0,0,0,'3013-5;3650-1;'),
(14405,'Icarus Stinger {PvP}','Light','rhand','true',1280,1,1,'fine_steel','s80',329,40,'rapier',10,-1.00000,0,0,0,406,0,163,-1,-1,103439000,4965,'false','false','true','false','true',3426,1,0,0,0,0,0,0,0,'3498-1;3650-1;'),
(14406,'Icarus Wingblade {PvP}','Focus','lrhand','true',1800,1,1,'fine_steel','s80',393,15,'ancient',8,2.00000,0,0,0,350,0,163,-1,-1,103439000,4965,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3566-2;3653-1;'),
(14407,'Icarus Wingblade {PvP}','Health','lrhand','true',1800,1,1,'fine_steel','s80',393,15,'ancient',8,2.00000,0,0,0,350,0,163,-1,-1,103439000,4965,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3013-5;3653-1;'),
(14408,'Icarus Wingblade {PvP}','Light','lrhand','true',1800,1,1,'fine_steel','s80',393,15,'ancient',8,2.00000,0,0,0,350,0,163,-1,-1,103439000,4965,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3498-1;3653-1;'),
(14409,'Icarus Shooter {PvP}','Cheap Shot','rhand','true',1580,1,1,'fine_steel','s80',422,10,'crossbow',10,-1.00000,0,0,0,303,0,163,-1,-1,103439000,4965,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3552-1;3655-1;'),
(14410,'Icarus Shooter {PvP}','Guidance','rhand','true',1580,1,1,'fine_steel','s80',422,10,'crossbow',10,-1.00000,0,0,0,303,0,163,-1,-1,103439000,4965,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3573-1;3655-1;'),
(14411,'Icarus Shooter {PvP}','Focus','rhand','true',1580,1,1,'fine_steel','s80',422,10,'crossbow',10,-1.00000,0,0,0,303,0,163,-1,-1,103439000,4965,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3567-2;3655-1;'),
(14412,'Icarus Dual Sword - Destruction {PvP}','','lrhand','true',1520,1,1,'fine_steel','s80',442,10,'dual',8,0.00000,0,0,0,325,0,163,-1,-1,103439000,4965,'false','false','true','false','true',3411,1,0,0,0,0,0,0,0,'3656-1;'),
(14413,'Icarus Disperser - Confusion {PvP}','','rhand','true',1520,1,1,'fine_steel','s80',318,5,'dagger',12,-3.00000,0,0,0,433,0,163,-1,-1,103439000,4965,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3651-1;3652-1;'),
(14414,'Icarus Disperser - Confusion {PvP}','Focus','rhand','true',1520,1,1,'fine_steel','s80',318,5,'dagger',12,-3.00000,0,0,0,433,0,163,-1,-1,103439000,4965,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3567-2;3651-1;3652-1;'),
(14415,'Icarus Disperser - Confusion {PvP}','Evasion','rhand','true',1520,1,1,'fine_steel','s80',318,5,'dagger',12,-3.00000,0,0,0,433,0,163,-1,-1,103439000,4965,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3009-8;3651-1;3652-1;'),
(14416,'Icarus Disperser - Confusion {PvP}','Critical Damage','rhand','true',1520,1,1,'fine_steel','s80',318,5,'dagger',12,-3.00000,0,0,0,433,0,163,-1,-1,103439000,4965,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3066-4;3651-1;3652-1;'),
(14417,'Icarus Sawsword - Destruction {PvP}','','rhand','true',1520,1,1,'fine_steel','s80',363,10,'sword',8,0.00000,0,0,0,379,0,163,-1,-1,103439000,4965,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3650-1;'),
(14418,'Icarus Sawsword - Destruction {PvP}','Focus','rhand','true',1520,1,1,'fine_steel','s80',363,10,'sword',8,0.00000,0,0,0,379,0,163,-1,-1,103439000,4965,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3566-2;3650-1;'),
(14419,'Icarus Sawsword - Destruction {PvP}','Health','rhand','true',1520,1,1,'fine_steel','s80',363,10,'sword',8,0.00000,0,0,0,379,0,163,-1,-1,103439000,4965,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3013-5;3650-1;'),
(14420,'Icarus Sawsword - Destruction {PvP}','Light','rhand','true',1520,1,1,'fine_steel','s80',363,10,'sword',8,0.00000,0,0,0,379,0,163,-1,-1,103439000,4965,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3498-1;3650-1;'),
(14421,'Icarus Shooter - Concentration {PvP}','','rhand','true',1580,1,1,'fine_steel','s80',422,10,'crossbow',10,-1.00000,0,0,0,303,0,163,-1,-1,103439000,4965,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3655-1;'),
(14422,'Icarus Shooter - Concentration {PvP}','Cheap Shot','rhand','true',1580,1,1,'fine_steel','s80',422,10,'crossbow',10,-1.00000,0,0,0,303,0,163,-1,-1,103439000,4965,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3552-1;3655-1;'),
(14423,'Icarus Shooter - Concentration {PvP}','Guidance','rhand','true',1580,1,1,'fine_steel','s80',422,10,'crossbow',10,-1.00000,0,0,0,303,0,163,-1,-1,103439000,4965,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3573-1;3655-1;'),
(14424,'Icarus Shooter - Concentration {PvP}','Focus','rhand','true',1580,1,1,'fine_steel','s80',422,10,'crossbow',10,-1.00000,0,0,0,303,0,163,-1,-1,103439000,4965,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3567-2;3655-1;'),
(14425,'Icarus Stinger - Destruction {PvP}','','rhand','true',1280,1,1,'fine_steel','s80',329,40,'rapier',10,-1.00000,0,0,0,406,0,163,-1,-1,103439000,4965,'false','false','true','false','true',3426,1,0,0,0,0,0,0,0,'3650-1;'),
(14426,'Icarus Stinger - Destruction {PvP}','Focus','rhand','true',1280,1,1,'fine_steel','s80',329,40,'rapier',10,-1.00000,0,0,0,406,0,163,-1,-1,103439000,4965,'false','false','true','false','true',3426,1,0,0,0,0,0,0,0,'3566-2;3650-1;'),
(14427,'Icarus Stinger - Destruction {PvP}','Health','rhand','true',1280,1,1,'fine_steel','s80',329,40,'rapier',10,-1.00000,0,0,0,406,0,163,-1,-1,103439000,4965,'false','false','true','false','true',3426,1,0,0,0,0,0,0,0,'3013-5;3650-1;'),
(14428,'Icarus Stinger - Destruction {PvP}','Light','rhand','true',1280,1,1,'fine_steel','s80',329,40,'rapier',10,-1.00000,0,0,0,406,0,163,-1,-1,103439000,4965,'false','false','true','false','true',3426,1,0,0,0,0,0,0,0,'3498-1;3650-1;'),
(14429,'Icarus Spirit - Nature {PvP}','','rhand','true',1520,1,1,'fine_steel','s80',290,10,'sword',8,0.00000,0,0,0,379,0,217,-1,-1,103439000,4965,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3654-1;3852-3;'),
(14430,'Icarus Spirit - Nature {PvP}','Acumen','rhand','true',1520,1,1,'fine_steel','s80',290,10,'sword',8,0.00000,0,0,0,379,0,217,-1,-1,103439000,4965,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3047-3;3654-1;3852-3;'),
(14431,'Icarus Spirit - Nature {PvP}','Mana Up','rhand','true',1520,1,1,'fine_steel','s80',290,10,'sword',8,0.00000,0,0,0,379,0,217,-1,-1,103439000,4965,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3014-3;3654-1;3852-3;'),
(14432,'Icarus Spirit - Nature {PvP}','Conversion','rhand','true',1520,1,1,'fine_steel','s80',290,10,'sword',8,0.00000,0,0,0,379,0,217,-1,-1,103439000,4965,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3048-3;3654-1;3852-3;'),
(14433,'Icarus Spitter - Concentration {PvP}','','lrhand','true',1520,1,1,'fine_steel','s80',689,5,'bow',12,-3.00000,0,0,0,293,11,163,-1,-1,103439000,4965,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3655-1;'),
(14434,'Icarus Spitter - Concentration {PvP}','Cheap Shot','lrhand','true',1520,1,1,'fine_steel','s80',689,5,'bow',12,-3.00000,0,0,0,293,11,163,-1,-1,103439000,4965,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3552-1;3655-1;'),
(14435,'Icarus Spitter - Concentration {PvP}','Guidance','lrhand','true',1520,1,1,'fine_steel','s80',689,5,'bow',12,-3.00000,0,0,0,293,11,163,-1,-1,103439000,4965,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3573-1;3655-1;'),
(14436,'Icarus Spitter - Concentration {PvP}','Focus','lrhand','true',1520,1,1,'fine_steel','s80',689,5,'bow',12,-3.00000,0,0,0,293,11,163,-1,-1,103439000,4965,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3567-2;3655-1;'),
(14437,'Icarus Wingblade - Lightning {PvP}','','lrhand','true',1800,1,1,'fine_steel','s80',393,15,'ancient',8,2.00000,0,0,0,350,0,163,-1,-1,103439000,4965,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3653-1;'),
(14438,'Icarus Wingblade - Lightning {PvP}','Focus','lrhand','true',1800,1,1,'fine_steel','s80',393,15,'ancient',8,2.00000,0,0,0,350,0,163,-1,-1,103439000,4965,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3566-2;3653-1;'),
(14439,'Icarus Wingblade - Lightning {PvP}','Health','lrhand','true',1800,1,1,'fine_steel','s80',393,15,'ancient',8,2.00000,0,0,0,350,0,163,-1,-1,103439000,4965,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3013-5;3653-1;'),
(14440,'Icarus Wingblade - Lightning {PvP}','Light','lrhand','true',1800,1,1,'fine_steel','s80',393,15,'ancient',8,2.00000,0,0,0,350,0,163,-1,-1,103439000,4965,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3498-1;3653-1;'),
(14441,'Icarus Trident - Thunder {PvP}','','lrhand','true',2010,1,1,'fine_steel','s80',363,10,'pole',8,-3.00000,0,0,0,325,0,163,-1,-1,103439000,4965,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3599-1;3653-1;'),
(14442,'Icarus Trident - Thunder {PvP}','Anger','lrhand','true',2010,1,1,'fine_steel','s80',363,10,'pole',8,-3.00000,0,0,0,325,0,163,-1,-1,103439000,4965,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3600-10;3653-1;'),
(14443,'Icarus Trident - Thunder {PvP}','Critical Stun','lrhand','true',2010,1,1,'fine_steel','s80',363,10,'pole',8,-3.00000,0,0,0,325,0,163,-1,-1,103439000,4965,'false','false','true','false','true',0,0,0,0,0,3070,3,48,0,'3552-2;3653-1;'),
(14444,'Icarus Trident - Thunder {PvP}','Light','lrhand','true',2010,1,1,'fine_steel','s80',363,10,'pole',8,-3.00000,0,0,0,325,0,163,-1,-1,103439000,4965,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3599-1;3498-1;3653-1;'),
(14445,'Icarus Hammer - Earth {PvP}','','rhand','true',1740,1,1,'fine_steel','s80',363,20,'blunt',4,4.00000,0,0,0,379,0,163,-1,-1,103439000,4965,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3650-1;3884-2;'),
(14446,'Icarus Hammer - Earth {PvP}','Anger','rhand','true',1740,1,1,'fine_steel','s80',363,20,'blunt',4,4.00000,0,0,0,379,0,163,-1,-1,103439000,4965,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3057-3;3650-1;3884-2;'),
(14447,'Icarus Hammer - Earth {PvP}','Health','rhand','true',1740,1,1,'fine_steel','s80',363,20,'blunt',4,4.00000,0,0,0,379,0,163,-1,-1,103439000,4965,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3013-5;3650-1;3884-2;'),
(14448,'Icarus Hammer - Earth {PvP}','Rsk. Focus','rhand','true',1740,1,1,'fine_steel','s80',363,20,'blunt',4,4.00000,0,0,0,379,0,163,-1,-1,103439000,4965,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3027-7;3650-1;3884-2;'),
(14449,'Icarus Hand - Destruction {PvP}','','lrhand','true',1550,1,1,'fine_steel','s80',442,5,'dualfist',4,4.00000,0,0,0,325,0,163,-1,-1,103439000,4965,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3651-1;3652-1;'),
(14450,'Icarus Hand - Destruction {PvP}','Rsk. Evasion','lrhand','true',1550,1,1,'fine_steel','s80',442,5,'dualfist',4,4.00000,0,0,0,325,0,163,-1,-1,103439000,4965,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3069-1;3651-1;3652-1;'),
(14451,'Icarus Hand - Destruction {PvP}','Focus','lrhand','true',1550,1,1,'fine_steel','s80',442,5,'dualfist',4,4.00000,0,0,0,325,0,163,-1,-1,103439000,4965,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3565-2;3651-1;3652-1;'),
(14452,'Icarus Hand - Destruction {PvP}','Haste','lrhand','true',1550,1,1,'fine_steel','s80',442,5,'dualfist',4,4.00000,0,0,0,325,0,163,-1,-1,103439000,4965,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'8297-1;3651-1;3652-1;'),
(14453,'Icarus Heavy Arms - Lightning {PvP}','','lrhand','true',1740,1,1,'fine_steel','s80',442,10,'bigsword',8,0.00000,0,0,0,325,0,163,-1,-1,103439000,4965,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3653-1;'),
(14454,'Icarus Heavy Arms - Lightning {PvP}','Focus','lrhand','true',1740,1,1,'fine_steel','s80',442,10,'bigsword',8,0.00000,0,0,0,325,0,163,-1,-1,103439000,4965,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3566-2;3653-1;'),
(14455,'Icarus Heavy Arms - Lightning {PvP}','Health','lrhand','true',1740,1,1,'fine_steel','s80',442,10,'bigsword',8,0.00000,0,0,0,325,0,163,-1,-1,103439000,4965,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3013-5;3653-1;'),
(14456,'Icarus Heavy Arms - Lightning {PvP}','Light','lrhand','true',1740,1,1,'fine_steel','s80',442,10,'bigsword',8,0.00000,0,0,0,325,0,163,-1,-1,103439000,4965,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3498-1;3653-1;'),
(14457,'Icarus Hall - Hail {PvP}','','rhand','true',1080,1,1,'fine_steel','s80',290,20,'blunt',4,4.00000,0,0,0,379,0,217,-1,-1,103439000,4965,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3654-1;'),
(14458,'Icarus Hall - Hail {PvP}','Mana Up','rhand','true',1080,1,1,'fine_steel','s80',290,20,'blunt',4,4.00000,0,0,0,379,0,217,-1,-1,103439000,4965,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3014-3;3654-1;'),
(14459,'Icarus Hall - Hail {PvP}','Conversion','rhand','true',1080,1,1,'fine_steel','s80',290,20,'blunt',4,4.00000,0,0,0,379,0,217,-1,-1,103439000,4965,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3048-3;3654-1;'),
(14460,'Icarus Hall - Hail {PvP}','Acumen','rhand','true',1080,1,1,'fine_steel','s80',290,20,'blunt',4,4.00000,0,0,0,379,0,217,-1,-1,103439000,4965,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3047-3;3654-1;'),
(14461,'Icarus Dual Daggers {PvP}','','lrhand','true',2100,1,1,'fine_steel','s80',332,10,'dualdagger',12,-3.00000,0,0,0,433,0,169,-1,-1,121780000,5845,'false','false','true','false','true',3044,20,0,0,0,0,0,0,0,'3651-1;3652-1;'),
(14462,'Vesper Dual Sword {PvP}','','lrhand','true',1520,1,1,'fine_steel','s84',482,10,'dual',8,0.00000,0,0,0,325,0,176,-1,-1,146873000,7050,'false','false','true','false','true',3411,1,0,0,0,0,0,0,0,'3656-1;'),
(14463,'Vesper Cutter {PvP}','','rhand','true',1520,1,1,'fine_steel','s84',396,10,'sword',8,0.00000,0,0,0,379,0,176,-1,-1,146873000,7050,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3650-1;'),
(14464,'Vesper Slasher {PvP}','','lrhand','true',1740,1,1,'fine_steel','s84',482,10,'bigsword',8,0.00000,0,0,0,325,0,176,-1,-1,146873000,7050,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3653-1;'),
(14465,'Vesper Buster {PvP}','','rhand','true',1520,1,1,'fine_steel','s84',317,10,'sword',8,0.00000,0,0,0,379,0,234,-1,-1,146873000,7050,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3654-1;'),
(14466,'Vesper Shaper {PvP}','','rhand','true',1520,1,1,'fine_steel','s84',346,5,'dagger',12,-3.00000,0,0,0,433,0,176,-1,-1,146873000,7050,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3651-1;3652-1;'),
(14467,'Vesper Fighter {PvP}','','lrhand','true',1550,1,1,'fine_steel','s84',482,5,'dualfist',4,4.00000,0,0,0,325,0,176,-1,-1,146873000,7050,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3653-1;'),
(14468,'Vesper Stormer {PvP}','','lrhand','true',2010,1,1,'fine_steel','s84',396,10,'pole',8,-3.00000,0,0,0,325,0,176,-1,-1,146873000,7050,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3599-1;3650-1;'),
(14469,'Vesper Avenger {PvP}','','rhand','true',1740,1,1,'fine_steel','s84',396,20,'blunt',4,4.00000,0,0,0,379,0,176,-1,-1,146873000,7050,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3650-1;'),
(14470,'Vesper Retributer {PvP}','','lrhand','true',1740,1,1,'fine_steel','s84',482,20,'bigblunt',4,4.00000,0,0,0,325,0,176,-1,-1,146873000,7050,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3653-1;'),
(14471,'Vesper Caster {PvP}','','rhand','true',1080,1,1,'fine_steel','s84',317,20,'blunt',4,4.00000,0,0,0,379,0,234,-1,-1,146873000,7050,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3654-1;'),
(14472,'Vesper Singer {PvP}','','lrhand','true',1080,1,1,'fine_steel','s84',386,20,'bigblunt',4,4.00000,0,0,0,325,0,257,-1,-1,146873000,7050,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3654-1;'),
(14473,'Vesper Thrower {PvP}','','lrhand','true',1520,1,1,'fine_steel','s84',724,5,'bow',12,-3.00000,0,0,0,293,12,176,-1,-1,146873000,7050,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3655-1;'),
(14474,'Vesper Pincer {PvP}','','rhand','true',1280,1,1,'fine_steel','s84',359,40,'rapier',10,-1.00000,0,0,0,406,0,176,-1,-1,146873000,7050,'false','false','true','false','true',3426,1,0,0,0,0,0,0,0,'3650-1;'),
(14475,'Vesper Sheutjeh {PvP}','','rhand','true',1580,1,1,'fine_steel','s84',444,10,'crossbow',10,-1.00000,0,0,0,303,0,176,-1,-1,146873000,7050,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3655-1;'),
(14476,'Vesper Nagan {PvP}','','lrhand','true',1800,1,1,'fine_steel','s84',429,15,'ancient',8,2.00000,0,0,0,350,0,176,-1,-1,146873000,7050,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3653-1;'),
(14477,'Vesper Dual Daggers {PvP}','','lrhand','true',2050,1,1,'fine_steel','s84',360,10,'dualdagger',12,-3.00000,0,0,0,433,0,181,-1,-1,171530000,8233,'false','false','true','false','true',3044,20,0,0,0,0,0,0,0,'3651-1;3652-1;'),
(14478,'Vesper Cutter {PvP}','Haste','rhand','true',1520,1,1,'fine_steel','s84',396,10,'sword',8,0.00000,0,0,0,379,0,176,-1,-1,146873000,7050,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'8297-1;3650-1;'),
(14479,'Vesper Cutter {PvP}','Health','rhand','true',1520,1,1,'fine_steel','s84',396,10,'sword',8,0.00000,0,0,0,379,0,176,-1,-1,146873000,7050,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3013-5;3650-1;'),
(14480,'Vesper Cutter {PvP}','Focus','rhand','true',1520,1,1,'fine_steel','s84',396,10,'sword',8,0.00000,0,0,0,379,0,176,-1,-1,146873000,7050,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'8295-1;3650-1;'),
(14481,'Vesper Slasher {PvP}','Haste','lrhand','true',1740,1,1,'fine_steel','s84',482,10,'bigsword',8,0.00000,0,0,0,325,0,176,-1,-1,146873000,7050,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'8297-1;3653-1;'),
(14482,'Vesper Slasher {PvP}','Health','lrhand','true',1740,1,1,'fine_steel','s84',482,10,'bigsword',8,0.00000,0,0,0,325,0,176,-1,-1,146873000,7050,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3013-5;3653-1;'),
(14483,'Vesper Slasher {PvP}','Focus','lrhand','true',1740,1,1,'fine_steel','s84',482,10,'bigsword',8,0.00000,0,0,0,325,0,176,-1,-1,146873000,7050,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'8295-1;3653-1;'),
(14484,'Vesper Buster {PvP}','Mana Up','rhand','true',1520,1,1,'fine_steel','s84',317,10,'sword',8,0.00000,0,0,0,379,0,234,-1,-1,146873000,7050,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3014-3;3654-1;'),
(14485,'Vesper Buster {PvP}','Acumen','rhand','true',1520,1,1,'fine_steel','s84',317,10,'sword',8,0.00000,0,0,0,379,0,234,-1,-1,146873000,7050,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3047-3;3654-1;'),
(14486,'Vesper Buster {PvP}','Magic Hold','rhand','true',1520,1,1,'fine_steel','s84',317,10,'sword',8,0.00000,0,0,0,379,0,234,-1,-1,146873000,7050,'false','false','true','false','true',0,0,3577,1,20,0,0,0,0,'3552-1;3654-1;'),
(14487,'Vesper Shaper {PvP}','Crt. Damage','rhand','true',1520,1,1,'fine_steel','s84',346,5,'dagger',12,-3.00000,0,0,0,433,0,176,-1,-1,146873000,7050,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3572-2;3651-1;3652-1;'),
(14488,'Vesper Shaper {PvP}','HP Drain','rhand','true',1520,1,1,'fine_steel','s84',346,5,'dagger',12,-3.00000,0,0,0,433,0,176,-1,-1,146873000,7050,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3568-1;3651-1;3652-1;'),
(14489,'Vesper Shaper {PvP}','Haste','rhand','true',1520,1,1,'fine_steel','s84',346,5,'dagger',12,-3.00000,0,0,0,433,0,176,-1,-1,146873000,7050,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'8297-1;3651-1;3652-1;'),
(14490,'Vesper Fighter {PvP}','Focus','lrhand','true',1550,1,1,'fine_steel','s84',482,5,'dualfist',4,4.00000,0,0,0,325,0,176,-1,-1,146873000,7050,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'8289-1;3651-1;3652-1;'),
(14491,'Vesper Fighter {PvP}','Health','lrhand','true',1550,1,1,'fine_steel','s84',482,5,'dualfist',4,4.00000,0,0,0,325,0,176,-1,-1,146873000,7050,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3013-5;3651-1;3652-1;'),
(14492,'Vesper Fighter {PvP}','Crt. Stun','lrhand','true',1550,1,1,'fine_steel','s84',482,5,'dualfist',4,4.00000,0,0,0,325,0,176,-1,-1,146873000,7050,'false','false','true','false','true',0,0,0,0,0,3571,1,43,0,'3552-1;3651-1;3652-1;'),
(14493,'Vesper Stormer {PvP}','Health','lrhand','true',2010,1,1,'fine_steel','s84',396,10,'pole',8,-3.00000,0,0,0,325,0,176,-1,-1,146873000,7050,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3013-4;3653-1;'),
(14494,'Vesper Stormer {PvP}','Guidance','lrhand','true',2010,1,1,'fine_steel','s84',396,10,'pole',8,-3.00000,0,0,0,325,0,176,-1,-1,146873000,7050,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3602-10;3653-1;'),
(14495,'Vesper Stormer {PvP}','Haste','lrhand','true',2010,1,1,'fine_steel','s84',396,10,'pole',8,-3.00000,0,0,0,325,0,176,-1,-1,146873000,7050,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3599-1;8297-1;3653-1;'),
(14496,'Vesper Avenger {PvP}','HP Drain','rhand','true',1740,1,1,'fine_steel','s84',396,20,'blunt',4,4.00000,0,0,0,379,0,176,-1,-1,146873000,7050,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3568-1;3650-1;'),
(14497,'Vesper Avenger {PvP}','Health','rhand','true',1740,1,1,'fine_steel','s84',396,20,'blunt',4,4.00000,0,0,0,379,0,176,-1,-1,146873000,7050,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3013-5;3650-1;'),
(14498,'Vesper Avenger {PvP}','HP Regeneration','rhand','true',1740,1,1,'fine_steel','s84',396,20,'blunt',4,4.00000,0,0,0,379,0,176,-1,-1,146873000,7050,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3569-1;3650-1;'),
(14499,'Vesper Retributer {PvP}','HP Regeneration','lrhand','true',1740,1,1,'fine_steel','s84',482,20,'bigblunt',4,4.00000,0,0,0,325,0,176,-1,-1,146873000,7050,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3569-1;3653-1;'),
(14500,'Vesper Retributer {PvP}','Health','lrhand','true',1740,1,1,'fine_steel','s84',482,20,'bigblunt',4,4.00000,0,0,0,325,0,176,-1,-1,146873000,7050,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3013-5;3653-1;'),
(14501,'Vesper Retributer {PvP}','HP Drain','lrhand','true',1740,1,1,'fine_steel','s84',482,20,'bigblunt',4,4.00000,0,0,0,325,0,176,-1,-1,146873000,7050,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3568-1;3653-1;'),
(14502,'Vesper Caster {PvP}','Acumen','rhand','true',1080,1,1,'fine_steel','s84',317,20,'blunt',4,4.00000,0,0,0,379,0,234,-1,-1,146873000,7050,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3047-3;3654-1;'),
(14503,'Vesper Caster {PvP}','MP Regeneration','rhand','true',1080,1,1,'fine_steel','s84',317,20,'blunt',4,4.00000,0,0,0,379,0,234,-1,-1,146873000,7050,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3576-2;3654-1;'),
(14504,'Vesper Caster {PvP}','Mana Up','rhand','true',1080,1,1,'fine_steel','s84',317,20,'blunt',4,4.00000,0,0,0,379,0,234,-1,-1,146873000,7050,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3014-3;3654-1;'),
(14505,'Vesper Singer {PvP}','Empower','lrhand','true',1080,1,1,'fine_steel','s84',386,20,'bigblunt',4,4.00000,0,0,0,325,0,257,-1,-1,146873000,7050,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3575-2;3654-1;'),
(14506,'Vesper Singer {PvP}','MP Regeneration','lrhand','true',1080,1,1,'fine_steel','s84',386,20,'bigblunt',4,4.00000,0,0,0,325,0,257,-1,-1,146873000,7050,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3576-2;3654-1;'),
(14507,'Vesper Singer {PvP}','Magic Hold','lrhand','true',1080,1,1,'fine_steel','s84',386,20,'bigblunt',4,4.00000,0,0,0,325,0,257,-1,-1,146873000,7050,'false','false','true','false','true',0,0,3577,1,20,0,0,0,0,'3552-1;3654-1;'),
(14508,'Vesper Thrower {PvP}','Cheap Shot','lrhand','true',1520,1,1,'fine_steel','s84',724,5,'bow',12,-3.00000,0,0,0,293,12,176,-1,-1,146873000,7050,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3552-1;3655-1;'),
(14509,'Vesper Thrower {PvP}','Focus','lrhand','true',1520,1,1,'fine_steel','s84',724,5,'bow',12,-3.00000,0,0,0,293,12,176,-1,-1,146873000,7050,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'8298-1;3655-1;'),
(14510,'Vesper Thrower {PvP}','Crt. Slow','lrhand','true',1520,1,1,'fine_steel','s84',724,5,'bow',12,-3.00000,0,0,0,293,12,176,-1,-1,146873000,7050,'false','false','true','false','true',0,0,0,0,0,3574,3,20,0,'3552-1;3655-1;'),
(14511,'Vesper Pincer {PvP}','Haste','rhand','true',1280,1,1,'fine_steel','s84',359,40,'rapier',10,-1.00000,0,0,0,406,0,176,-1,-1,146873000,7050,'false','false','true','false','true',3426,1,0,0,0,0,0,0,0,'8297-1;3650-1;'),
(14512,'Vesper Pincer {PvP}','Health','rhand','true',1280,1,1,'fine_steel','s84',359,40,'rapier',10,-1.00000,0,0,0,406,0,176,-1,-1,146873000,7050,'false','false','true','false','true',3426,1,0,0,0,0,0,0,0,'3013-5;3650-1;'),
(14513,'Vesper Pincer {PvP}','Focus','rhand','true',1280,1,1,'fine_steel','s84',359,40,'rapier',10,-1.00000,0,0,0,406,0,176,-1,-1,146873000,7050,'false','false','true','false','true',3426,1,0,0,0,0,0,0,0,'8296-1;3650-1;'),
(14514,'Vesper Sheutjeh {PvP}','Cheap Shot','rhand','true',1580,1,1,'fine_steel','s84',444,10,'crossbow',10,-1.00000,0,0,0,303,0,176,-1,-1,146873000,7050,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3552-1;3655-1;'),
(14515,'Vesper Sheutjeh {PvP}','Focus','rhand','true',1580,1,1,'fine_steel','s84',444,10,'crossbow',10,-1.00000,0,0,0,303,0,176,-1,-1,146873000,7050,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'8296-1;3655-1;'),
(14516,'Vesper Sheutjeh {PvP}','Crt. Slow','rhand','true',1580,1,1,'fine_steel','s84',444,10,'crossbow',10,-1.00000,0,0,0,303,0,176,-1,-1,146873000,7050,'false','false','true','false','true',0,0,0,0,0,3574,3,20,0,'3552-1;3655-1;'),
(14517,'Vesper Nagan {PvP}','Haste','lrhand','true',1800,1,1,'fine_steel','s84',429,15,'ancient',8,2.00000,0,0,0,350,0,176,-1,-1,146873000,7050,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'8297-1;3653-1;'),
(14518,'Vesper Nagan {PvP}','Health','lrhand','true',1800,1,1,'fine_steel','s84',429,15,'ancient',8,2.00000,0,0,0,350,0,176,-1,-1,146873000,7050,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3013-5;3653-1;'),
(14519,'Vesper Nagan {PvP}','Focus','lrhand','true',1800,1,1,'fine_steel','s84',429,15,'ancient',8,2.00000,0,0,0,350,0,176,-1,-1,146873000,7050,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'8295-1;3653-1;'),
(14526,'Dynasty Dual Daggers - Great Gale','','lrhand','true',2150,1,1,'fine_steel','s80',304,10,'dualdagger',12,-3.00000,0,0,0,433,0,157,-1,-1,87901000,4219,'true','true','true','true','true',3044,20,0,0,0,0,0,0,0,'3859-2;'),
(14527,'Icarus Dual Daggers - Confusion','','lrhand','true',2100,1,1,'fine_steel','s80',332,10,'dualdagger',12,-3.00000,0,0,0,433,0,169,-1,-1,121780000,5845,'true','true','true','true','true',3044,20,0,0,0,0,0,0,0,'0-0;'),
(14528,'Dynasty Dual Daggers - Great Gale {PvP}','','lrhand','true',2150,1,1,'fine_steel','s80',304,10,'dualdagger',12,-3.00000,0,0,0,433,0,157,-1,-1,87901000,4219,'false','false','true','false','true',3044,20,0,0,0,0,0,0,0,'3651-1;3652-1;3859-2;'),
(14529,'Icarus Dual Daggers - Confusion {PvP}','','lrhand','true',2100,1,1,'fine_steel','s80',332,10,'dualdagger',12,-3.00000,0,0,0,433,0,169,-1,-1,121780000,5845,'false','false','true','false','true',3044,20,0,0,0,0,0,0,0,'3651-1;3652-1;'),
(14558,'Dynasty Dual Daggers {PvP}','','lrhand','true',2150,1,1,'fine_steel','s80',304,10,'dualdagger',12,-3.00000,0,0,0,433,0,157,-1,-1,87901000,4219,'false','false','true','false','true',3044,20,0,0,0,0,0,0,0,'3651-1;3652-1;'),
(14560,'Dagger of Val Turner Family','','rhand','false',713,1,1,'fine_steel','s',271,5,'dagger',12,-3.00000,0,0,0,433,0,119,-1,-1,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(14561,'Slasher of Val Turner Family','','lrhand','false',1035,1,1,'fine_steel','s',376,10,'bigsword',8,0.00000,0,0,0,325,0,119,-1,-1,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,14578,'0-0;'),
(14562,'Sword of Ashton Family','','rhand','false',975,1,1,'fine_steel','s',310,10,'sword',8,0.00000,0,0,0,379,0,119,-1,-1,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,14579,'0-0;'),
(14563,'Claw of Ashton Family','','lrhand','false',1013,1,1,'fine_steel','s',376,5,'dualfist',4,4.00000,0,0,0,325,0,119,-1,-1,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(14564,'Slasher of Esthus Family','','lrhand','false',1035,1,1,'fine_steel','s',376,10,'bigsword',8,0.00000,0,0,0,325,0,119,-1,-1,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,14580,'0-0;'),
(14565,'Great Hammer of Esthus Family','','lrhand','false',1365,1,1,'fine_steel','s',376,20,'bigblunt',4,4.00000,0,0,0,325,0,119,-1,-1,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(14566,'Staff of Dake Family','','lrhand','false',683,1,1,'fine_steel','s',247,20,'bigblunt',4,4.00000,0,0,0,325,0,212,-1,-1,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(14567,'Hall of Dake Family','','rhand','false',975,1,1,'fine_steel','s',203,20,'blunt',4,4.00000,0,0,0,379,0,193,-1,-1,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(14568,'Bow of Cadmus Family','','lrhand','false',1238,1,1,'fine_steel','s',640,5,'bow',12,-3.00000,0,0,0,293,11,119,-1,-1,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,14581,'0-0;'),
(14569,'Mace of Cadmus Family','','rhand','false',1178,1,1,'fine_steel','s',310,20,'blunt',4,4.00000,0,0,0,379,0,119,-1,-1,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(14570,'Dual Sword of Hunter Family','','lrhand','false',1560,1,1,'fine_steel','s',376,10,'dual',8,0.00000,0,0,0,325,0,119,-1,-1,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(14571,'Spear of Hunter Family','','lrhand','false',1350,1,1,'fine_steel','s',310,10,'pole',8,-3.00000,0,0,0,325,0,119,-1,-1,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(14572,'Staff of Abygail Family','','lrhand','false',683,1,1,'fine_steel','s',247,20,'bigblunt',4,4.00000,0,0,0,325,0,212,-1,-1,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(14573,'Great Hammer of Abygail Family','','lrhand','false',1365,1,1,'fine_steel','s',376,20,'bigblunt',4,4.00000,0,0,0,325,0,119,-1,-1,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(14574,'Spear of Halter Family','','lrhand','false',1350,1,1,'fine_steel','s',310,10,'pole',8,-3.00000,0,0,0,325,0,119,-1,-1,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(14575,'Dagger of Halter Family','','rhand','false',713,1,1,'fine_steel','s',271,5,'dagger',12,-3.00000,0,0,0,433,0,119,-1,-1,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(14576,'Mace of Orwen Family','','rhand','false',1178,1,1,'fine_steel','s',310,20,'blunt',4,4.00000,0,0,0,379,0,119,-1,-1,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(14577,'Claw of Orwen Family','','lrhand','false',1013,1,1,'fine_steel','s',376,5,'dualfist',4,4.00000,0,0,0,325,0,119,-1,-1,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(14578,'Slicer of Val Turner Family','','lrhand','false',1350,1,1,'fine_steel','s',334,15,'ancient',8,2.00000,0,0,0,350,0,119,-1,-1,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,14561,'0-0;'),
(14579,'Epee of Ashton Family','','rhand','false',975,1,1,'fine_steel','s',281,40,'rapier',10,-1.00000,0,0,0,406,0,119,-1,-1,0,0,'false','false','true','false','true',3426,1,0,0,0,0,0,0,14562,'0-0;'),
(14580,'Slicer of Esthus Family','','lrhand','false',1350,1,1,'fine_steel','s',334,15,'ancient',8,2.00000,0,0,0,350,0,119,-1,-1,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,14564,'0-0;'),
(14581,'Estoc of Cadmus Family','','rhand','false',1200,1,1,'fine_steel','s',392,10,'crossbow',10,-1.00000,0,0,0,303,0,119,-1,-1,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,14568,'0-0;'),
(14606,'Gracia Soldier Two-Handed Sword','','lrhand','false',2180,2,2,'fine_steel','d',78,10,'bigsword',8,0.00000,0,0,0,325,0,39,-1,-1,0,1373,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(14621,'Santa Claus\' Sirra Blade','','rhand','false',1300,0,0,'fine_steel','none',51,10,'sword',8,0.00000,0,0,0,379,0,38,-1,-1,0,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(14622,'Santa Claus\' Sword of Ipos','','lrhand','false',1820,0,0,'fine_steel','none',62,10,'bigsword',8,0.00000,0,0,0,325,0,38,-1,-1,0,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,14634,'0-0;'),
(14623,'Santa Claus\' Barakiel Axe','','rhand','false',1550,0,0,'fine_steel','none',51,20,'blunt',4,4.00000,0,0,0,379,0,38,-1,-1,0,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(14624,'Santa Claus\' Behemoth Tuning Fork','','lrhand','false',1890,0,0,'fine_steel','none',62,20,'bigblunt',4,4.00000,0,0,0,325,0,38,-1,-1,0,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(14625,'Santa Claus\' Naga Storm','','rhand','false',930,0,0,'fine_steel','none',45,5,'dagger',12,-3.00000,0,0,0,433,0,38,-1,-1,0,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(14626,'Santa Claus\' Tiphon Spear','','lrhand','false',1820,0,0,'fine_steel','none',51,10,'pole',8,-3.00000,0,0,0,325,0,38,-1,-1,0,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'3599-1;'),
(14627,'Santa Claus\' Shyeed Bow','','lrhand','false',1640,0,0,'fine_steel','none',116,5,'bow',12,-3.00000,0,0,0,227,10,42,-1,-1,0,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,14633,'0-0;'),
(14628,'Santa Claus\' Sobekk Hurricane','','lrhand','false',1330,0,0,'fine_steel','none',41,5,'dualfist',4,4.00000,0,0,0,325,0,38,-1,-1,0,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(14629,'Santa Claus\' Themis Tongue','','rhand','false',820,0,0,'fine_steel','none',41,10,'sword',8,0.00000,0,0,0,379,0,51,-1,-1,0,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,14632,'0-0;'),
(14630,'Santa Claus\' Hand of Cabrio','','rhand','false',1510,0,0,'fine_steel','none',50,20,'blunt',4,4.00000,0,0,0,379,0,51,-1,-1,0,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(14631,'Santa Claus\' Daimon Crystal','','lrhand','false',880,0,0,'fine_steel','none',62,20,'bigblunt',4,4.00000,0,0,0,325,0,56,-1,-1,0,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(14632,'Santa Claus\' Eclair Bijou','','rhand','false',1300,0,0,'fine_steel','none',46,40,'rapier',10,-1.00000,0,0,0,406,0,38,-1,-1,0,0,'true','true','true','true','true',3426,1,0,0,0,0,0,0,14629,'0-0;'),
(14633,'Santa Claus\' Screaming Vengeance','','rhand','false',1640,0,0,'fine_steel','none',56,10,'crossbow',10,-1.00000,0,0,0,303,0,38,-1,-1,0,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,14627,'0-0;'),
(14634,'Santa Claus\' Durendal','','lrhand','false',1820,0,0,'fine_steel','none',65,15,'ancient',8,2.00000,0,0,0,350,0,38,-1,-1,0,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,14622,'0-0;'),
(14674,'Santa Claus\' Tallum Blade*Damascus','','lrhand','false',1890,0,0,'fine_steel','none',61,10,'dual',8,0.00000,0,0,0,325,0,51,-1,-1,0,0,'true','true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(14774,'Wild Rose Pig Candy','14 day limited period','lrhand','false',0,0,0,'wood','none',1,10,'pole',8,0.00000,0,0,0,379,0,1,-1,20160,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(14780,'Baguette\'s Bread Sword','','rhand','true',1350,1,1,'wood','none',0,0,'sword',8,0.00000,0,0,0,0,0,0,-1,-1,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(14781,'Baguette\'s Dagger','','rhand','false',1130,1,1,'wood','none',0,0,'dagger',12,-3.00000,0,0,0,0,0,0,-1,-1,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(14782,'Baguette\'s Two-handed Sword','','lrhand','true',2250,2,2,'wood','none',0,0,'bigsword',8,0.00000,0,0,0,0,0,0,-1,-1,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(14783,'Baguette\'s Mace','','rhand','false',1640,3,3,'wood','none',0,0,'blunt',4,4.00000,0,0,0,0,0,0,-1,-1,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(14784,'Baguette\'s Two-handed Hammer','','lrhand','true',2080,2,2,'wood','none',0,0,'bigblunt',8,-3.00000,0,0,0,0,0,0,-1,-1,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(14785,'Baguette\'s Spear','','lrhand','false',2120,2,2,'wood','none',0,0,'pole',8,-3.00000,0,0,0,0,0,0,-1,-1,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(14786,'Baguette\'s Bow','','lrhand','false',1790,8,2,'wood','none',0,0,'bow',12,-3.00000,0,0,0,0,6,0,-1,-1,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(14787,'Baguette\'s Fist','','lrhand','false',1520,3,3,'wood','none',0,0,'dualfist',4,4.00000,0,0,0,0,0,0,-1,-1,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(14788,'Baguette\'s Magic Sword','','rhand','true',830,1,1,'wood','none',0,0,'sword',8,0.00000,0,0,0,0,0,0,-1,-1,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(14789,'Baguette\'s Staff','','rhand','false',990,3,3,'wood','none',0,0,'blunt',4,4.00000,0,0,0,0,0,0,-1,-1,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(14790,'Baguette\'s Two-handed Staff','','lrhand','false',340,2,2,'wood','none',0,0,'bigblunt',4,4.00000,0,0,0,0,0,0,-1,-1,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(14791,'Baguette\'s Shield','','lhand','false',460,0,0,'wood','none',0,0,'none',0,0.00000,-8,90,20,0,0,0,-1,-1,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(14792,'Baguette\'s Rapier','','rhand','true',1520,2,2,'wood','none',0,0,'rapier',10,-1.00000,0,0,0,0,0,0,-1,-1,0,0,'false','false','false','false','false',3426,1,0,0,0,0,0,0,0,'0-0;'),
(14793,'Baguette\'s Ancient Sword','','lrhand','true',1800,1,1,'wood','none',0,0,'ancient',8,2.00000,0,0,0,0,0,0,-1,-1,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(14794,'Baguette\'s Crossbow','','rhand','true',1580,1,1,'wood','none',0,0,'crossbow',10,-1.00000,0,0,0,0,0,0,-1,-1,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(14795,'Baguette\'s Dualsword','','lrhand','true',1520,1,1,'wood','none',0,0,'dual',8,0.00000,0,0,0,0,0,0,-1,-1,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(14797,'Baguette\'s Two-handed Dagger','','lrhand','true',2150,1,1,'wood','none',0,0,'dualdagger',12,-3.00000,0,0,0,0,0,0,-1,-1,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(14982,'Dark Crystal Shield of Friendship','30 day limited period','lhand','true',1190,0,0,'wood','a',0,0,'none',0,0.00000,-8,243,20,0,0,0,-1,43200,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(14987,'Avadon Shield of Friendship','30 day limited period','lhand','true',1210,0,0,'wood','b',0,0,'none',0,0.00000,-8,216,20,0,0,0,-1,43200,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(15007,'Doom Shield of Friendship','30 day limited period','lhand','true',1200,0,0,'wood','b',0,0,'none',0,0.00000,-8,230,20,0,0,0,-1,43200,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(15016,'Full Plate Shield of Friendship','30 day limited period','lhand','true',1220,0,0,'wood','c',0,0,'none',0,0.00000,-8,203,20,0,0,0,-1,43200,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(15026,'Brigandine Shield of Friendship','30 day limited period','lhand','true',1320,0,0,'wood','d',0,0,'none',0,0.00000,-8,142,20,0,0,0,-1,43200,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(15031,'Friendship Shield of Nightmare','30 day limited period','lhand','true',1180,0,0,'wood','a',0,0,'none',0,0.00000,-8,256,20,0,0,0,-1,43200,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(15032,'Sword of Miracles of Friendship','30 day limited period','rhand','true',840,1,1,'wood','a',186,10,'sword',8,0.00000,0,0,0,379,0,152,-1,43200,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(15033,'Wizard\'s Tear of Friendship','30 day limited period','rhand','true',1350,1,1,'wood','b',155,10,'sword',8,0.00000,0,0,0,379,0,132,-1,43200,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(15034,'Homunkulus\'s Sword of Friendship','30 day limited period','rhand','true',950,3,3,'wood','c',111,10,'sword',8,0.00000,0,0,0,379,0,101,-1,43200,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(15035,'Friendship Staff of Life','30 day limited period','rhand','true',1180,3,3,'wood','d',74,20,'blunt',4,4.00000,0,0,0,379,0,72,-1,43200,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(15036,'Naga Storm of Friendship','30 day limited period','rhand','true',930,1,1,'wood','a',220,5,'dagger',12,-3.00000,0,0,0,433,0,121,-1,43200,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(15037,'Kris of Friendship','30 day limited period','rhand','true',980,1,1,'wood','b',153,5,'dagger',12,-3.00000,0,0,0,433,0,91,-1,43200,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(15038,'Dark Screamer of Friendship','30 day limited period','rhand','true',1010,3,3,'wood','c',122,5,'dagger',12,-3.00000,0,0,0,433,0,76,-1,43200,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(15039,'Mithril Dagger of Friendship','30 day limited period','rhand','true',1060,3,3,'wood','d',80,5,'dagger',12,-3.00000,0,0,0,433,0,54,-1,43200,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(15040,'Shyeed\'s Bow of Friendship','30 day limited period','lrhand','true',1640,2,1,'wood','a',570,5,'bow',12,-3.00000,0,0,0,227,10,133,-1,43200,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(15041,'Friendship Bow of Peril','30 day limited period','lrhand','true',1700,3,1,'wood','b',400,5,'bow',12,-3.00000,0,0,0,293,9,99,-1,43200,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(15042,'Eminence Bow of Friendship','30 day limited period','lrhand','true',1720,10,3,'wood','c',323,5,'bow',12,-3.00000,0,0,0,293,8,83,-1,43200,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(15043,'Light Crossbow of Friendship','30 day limited period','rhand','true',1810,10,3,'wood','d',191,5,'crossbow',12,-3.00000,0,0,0,293,6,54,-1,43200,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(15044,'Barakiel\'s Axe of Friendship','30 day limited period','rhand','true',1550,1,1,'wood','a',251,20,'blunt',4,4.00000,0,0,0,379,0,121,-1,43200,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(15045,'Art of Battle Axe of Friendship','30 day limited period','rhand','true',1570,1,1,'wood','b',194,20,'blunt',4,4.00000,0,0,0,379,0,99,-1,43200,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(15046,'Yaksa Mace of Friendship','30 day limited period','rhand','true',1640,3,3,'wood','c',156,20,'blunt',4,4.00000,0,0,0,379,0,83,-1,43200,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(15047,'Bonebreaker of Friendship','30 day limited period','rhand','true',1720,3,3,'wood','d',92,20,'blunt',4,4.00000,0,0,0,379,0,54,-1,43200,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(15048,'Sirra\'s Blade of Friendship','30 day limited period','rhand','true',1300,1,1,'wood','a',251,10,'sword',8,0.00000,0,0,0,379,0,121,-1,43200,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(15049,'Friendship Sword of Damascus','30 day limited period','rhand','true',1350,1,1,'wood','b',194,10,'sword',8,0.00000,0,0,0,379,0,99,-1,43200,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(15050,'Samurai Longsword of Friendship','30 day limited period','rhand','true',1380,3,3,'wood','c',156,10,'sword',8,0.00000,0,0,0,379,0,83,-1,43200,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(15051,'Elven Long Sword of Friendship','30 day limited period','rhand','true',1440,3,3,'wood','d',92,10,'sword',8,0.00000,0,0,0,379,0,54,-1,43200,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(15052,'Friendship Sword of Ipos','30 day limited period','lrhand','true',1820,1,1,'wood','a',305,10,'bigsword',8,0.00000,0,0,0,325,0,121,-1,43200,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(15053,'Guardian Sword of Friendship','30 day limited period','lrhand','true',1930,1,1,'wood','b',236,10,'bigsword',8,0.00000,0,0,0,325,0,99,-1,43200,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(15054,'Berserker Blade of Friendship','30 day limited period','lrhand','true',1380,3,3,'wood','c',190,10,'bigsword',8,0.00000,0,0,0,325,0,83,-1,43200,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(15055,'Claymore of Friendship','30 day limited period','lrhand','true',2090,3,3,'wood','d',112,10,'bigsword',8,0.00000,0,0,0,325,0,54,-1,43200,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(15056,'Sobekk\'s Hurricane of Friendship','30 day limited period','lrhand','true',1330,1,1,'wood','a',305,5,'dualfist',4,4.00000,0,0,0,325,0,121,-1,43200,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(15057,'Bellion Cestus of Friendship','30 day limited period','lrhand','true',1390,1,1,'wood','b',236,5,'dualfist',4,4.00000,0,0,0,325,0,99,-1,43200,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(15058,'Great Pata of Friendship','30 day limited period','lrhand','true',1460,3,3,'wood','c',190,5,'dualfist',4,4.00000,0,0,0,325,0,83,-1,43200,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(15059,'Scallop Jamadhr of Friendship','30 day limited period','lrhand','true',1520,3,3,'wood','d',112,5,'dualfist',4,4.00000,0,0,0,325,0,54,-1,43200,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(15060,'Tallum Blade*Damascus of Friendship','30 day limited period','lrhand','true',1890,1,1,'wood','a',305,10,'dual',8,0.00000,0,0,0,325,0,121,-1,43200,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(15061,'Samurai Long Sword*Samurai Long Sword of Friendship','30 day limited period','lrhand','true',2080,1,1,'wood','b',236,10,'dual',8,0.00000,0,0,0,325,0,99,-1,43200,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(15062,'Spirit Sword*Raid Sword of Friendship','30 day limited period','lrhand','true',2260,3,3,'wood','c',190,10,'dual',8,0.00000,0,0,0,325,0,83,-1,43200,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(15063,'Bastard Sword*Elven Sword of Friendship','30 day limited period','lrhand','true',2460,3,3,'wood','d',107,10,'dual',8,0.00000,0,0,0,325,0,51,-1,43200,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(15064,'Tiphon\'s Spear of Friendship','30 day limited period','lrhand','true',1820,1,1,'wood','a',251,10,'pole',8,-3.00000,0,0,0,325,0,121,-1,43200,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(15065,'Lance of Friendship','30 day limited period','lrhand','true',1920,1,1,'wood','b',194,10,'pole',8,-3.00000,0,0,0,325,0,99,-1,43200,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(15066,'Orcish Poleaxe of Friendship','30 day limited period','lrhand','true',1950,3,3,'wood','c',156,10,'pole',8,-3.00000,0,0,0,325,0,83,-1,43200,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(15067,'Glaive of Friendship','30 day limited period','lrhand','true',2050,3,3,'wood','d',92,10,'pole',8,-3.00000,0,0,0,325,0,54,-1,43200,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(15068,'Durendal of Friendship','30 day limited period','lrhand','true',1820,1,1,'wood','a',272,15,'ancient',8,2.00000,0,0,0,350,0,121,-1,43200,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(15069,'Dismantler of Friendship','30 day limited period','lrhand','true',1930,1,1,'wood','b',210,15,'ancient',8,2.00000,0,0,0,350,0,99,-1,43200,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(15070,'Saber Tooth of Friendship','30 day limited period','lrhand','true',1950,3,3,'wood','c',169,15,'ancient',8,2.00000,0,0,0,350,0,83,-1,43200,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(15071,'General\'s Katzbalger of Friendship','30 day limited period','lrhand','true',2010,3,3,'wood','d',100,15,'ancient',8,2.00000,0,0,0,350,0,54,-1,43200,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(15072,'Eclair Bijou of Friendship','30 day limited period','rhand','true',1300,1,1,'wood','a',228,40,'rapier',10,-1.00000,0,0,0,406,0,121,-1,43200,0,0,'false','false','false','false','false',3426,1,0,0,0,0,0,0,0,'0-0;'),
(15073,'Colichemarde of Friendship','30 day limited period','rhand','true',1350,1,1,'wood','b',176,40,'rapier',10,-1.00000,0,0,0,406,0,99,-1,43200,0,0,'false','false','false','false','false',3426,1,0,0,0,0,0,0,0,'0-0;'),
(15074,'Admiral\'s Estoc of Friendship','30 day limited period','rhand','true',1380,3,3,'wood','c',141,40,'rapier',10,-1.00000,0,0,0,406,0,83,-1,43200,0,0,'false','false','false','false','false',3426,1,0,0,0,0,0,0,0,'0-0;'),
(15075,'Grand Epee of Friendship','30 day limited period','rhand','true',1440,3,3,'wood','d',83,40,'rapier',10,-1.00000,0,0,0,406,0,54,-1,43200,0,0,'false','false','false','false','false',3426,1,0,0,0,0,0,0,0,'0-0;'),
(15076,'Screaming Vengeance of Friendship','30 day limited period','rhand','true',1640,1,1,'wood','a',318,10,'crossbow',10,-1.00000,0,0,0,303,0,121,-1,43200,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(15077,'Hell Hound of Friendship','30 day limited period','rhand','true',1700,2,1,'wood','b',245,10,'crossbow',10,-1.00000,0,0,0,303,0,99,-1,43200,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(15078,'Sharpshooter of Friendship','30 day limited period','rhand','true',1740,6,3,'wood','c',198,10,'crossbow',10,-1.00000,0,0,0,303,0,83,-1,43200,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(15079,'Cranequin of Friendship','30 day limited period','rhand','true',1810,6,3,'wood','d',117,10,'crossbow',10,-1.00000,0,0,0,303,0,54,-1,43200,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(15096,'Dark Crystal Shield of Friendship','10 day limited period','lhand','true',1190,0,0,'wood','a',0,0,'none',0,0.00000,-8,243,20,0,0,0,-1,14400,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(15101,'Avadon Shield of Friendship','10 day limited period','lhand','true',1210,0,0,'wood','b',0,0,'none',0,0.00000,-8,216,20,0,0,0,-1,14400,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(15121,'Doom Shield of Friendship','10 day limited period','lhand','true',1200,0,0,'wood','b',0,0,'none',0,0.00000,-8,230,20,0,0,0,-1,14400,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(15130,'Full Plate Shield of Friendship','10 day limited period','lhand','true',1220,0,0,'wood','c',0,0,'none',0,0.00000,-8,203,20,0,0,0,-1,14400,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(15140,'Brigandine Shield of Friendship','10 day limited period','lhand','true',1320,0,0,'wood','d',0,0,'none',0,0.00000,-8,142,20,0,0,0,-1,14400,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(15145,'Friendship Shield of Nightmare','10 day limited period','lhand','true',1180,0,0,'wood','a',0,0,'none',0,0.00000,-8,256,20,0,0,0,-1,14400,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(15146,'Sword of Miracles of Friendship','10 day limited period','rhand','true',840,1,1,'wood','a',186,10,'sword',8,0.00000,0,0,0,379,0,152,-1,14400,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(15147,'Wizard\'s Tear of Friendship','10 day limited period','rhand','true',1350,1,1,'wood','b',155,10,'sword',8,0.00000,0,0,0,379,0,132,-1,14400,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(15148,'Homunkulus\'s Sword of Friendship','10 day limited period','rhand','true',950,3,3,'wood','c',111,10,'sword',8,0.00000,0,0,0,379,0,101,-1,14400,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(15149,'Friendship Staff of Life','10 day limited period','rhand','true',1180,3,3,'wood','d',74,20,'blunt',4,4.00000,0,0,0,379,0,72,-1,14400,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(15150,'Naga Storm of Friendship','10 day limited period','rhand','true',930,1,1,'wood','a',220,5,'dagger',12,-3.00000,0,0,0,433,0,121,-1,14400,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(15151,'Kris of Friendship','10 day limited period','rhand','true',980,1,1,'wood','b',153,5,'dagger',12,-3.00000,0,0,0,433,0,91,-1,14400,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(15152,'Dark Screamer of Friendship','10 day limited period','rhand','true',1010,3,3,'wood','c',122,5,'dagger',12,-3.00000,0,0,0,433,0,76,-1,14400,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(15153,'Mithril Dagger of Friendship','10 day limited period','rhand','true',1060,3,3,'wood','d',80,5,'dagger',12,-3.00000,0,0,0,433,0,54,-1,14400,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(15154,'Shyeed\'s Bow of Friendship','10 day limited period','lrhand','true',1640,2,1,'wood','a',570,5,'bow',12,-3.00000,0,0,0,227,10,133,-1,14400,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(15155,'Friendship Bow of Peril','10 day limited period','lrhand','true',1700,3,1,'wood','b',400,5,'bow',12,-3.00000,0,0,0,293,9,99,-1,14400,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(15156,'Eminence Bow of Friendship','10 day limited period','lrhand','true',1720,10,3,'wood','c',323,5,'bow',12,-3.00000,0,0,0,293,8,83,-1,14400,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(15157,'Light Crossbow of Friendship','10 day limited period','rhand','true',1810,10,3,'wood','d',191,5,'crossbow',12,-3.00000,0,0,0,293,6,54,-1,14400,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(15158,'Barakiel\'s Axe of Friendship','10 day limited period','rhand','true',1550,1,1,'wood','a',251,20,'blunt',4,4.00000,0,0,0,379,0,121,-1,14400,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(15159,'Art of Battle Axe of Friendship','10 day limited period','rhand','true',1570,1,1,'wood','b',194,20,'blunt',4,4.00000,0,0,0,379,0,99,-1,14400,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(15160,'Yaksa Mace of Friendship','10 day limited period','rhand','true',1640,3,3,'wood','c',156,20,'blunt',4,4.00000,0,0,0,379,0,83,-1,14400,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(15161,'Bonebreaker of Friendship','10 day limited period','rhand','true',1720,3,3,'wood','d',92,20,'blunt',4,4.00000,0,0,0,379,0,54,-1,14400,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(15162,'Sirra\'s Blade of Friendship','10 day limited period','rhand','true',1300,1,1,'wood','a',251,10,'sword',8,0.00000,0,0,0,379,0,121,-1,14400,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(15163,'Friendship Sword of Damascus','10 day limited period','rhand','true',1350,1,1,'wood','b',194,10,'sword',8,0.00000,0,0,0,379,0,99,-1,14400,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(15164,'Samurai Longsword of Friendship','10 day limited period','rhand','true',1380,3,3,'wood','c',156,10,'sword',8,0.00000,0,0,0,379,0,83,-1,14400,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(15165,'Elven Long Sword of Friendship','10 day limited period','rhand','true',1440,3,3,'wood','d',92,10,'sword',8,0.00000,0,0,0,379,0,54,-1,14400,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(15166,'Friendship Sword of Ipos','10 day limited period','lrhand','true',1820,1,1,'wood','a',305,10,'bigsword',8,0.00000,0,0,0,325,0,121,-1,14400,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(15167,'Guardian Sword of Friendship','10 day limited period','lrhand','true',1930,1,1,'wood','b',236,10,'bigsword',8,0.00000,0,0,0,325,0,99,-1,14400,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(15168,'Berserker Blade of Friendship','10 day limited period','lrhand','true',1380,3,3,'wood','c',190,10,'bigsword',8,0.00000,0,0,0,325,0,83,-1,14400,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(15169,'Claymore of Friendship','10 day limited period','lrhand','true',2090,3,3,'wood','d',112,10,'bigsword',8,0.00000,0,0,0,325,0,54,-1,14400,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(15170,'Sobekk\'s Hurricane of Friendship','10 day limited period','lrhand','true',1330,1,1,'wood','a',305,5,'dualfist',4,4.00000,0,0,0,325,0,121,-1,14400,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(15171,'Bellion Cestus of Friendship','10 day limited period','lrhand','true',1390,1,1,'wood','b',236,5,'dualfist',4,4.00000,0,0,0,325,0,99,-1,14400,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(15172,'Great Pata of Friendship','10 day limited period','lrhand','true',1460,3,3,'wood','c',190,5,'dualfist',4,4.00000,0,0,0,325,0,83,-1,14400,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(15173,'Scallop Jamadhr of Friendship','10 day limited period','lrhand','true',1520,3,3,'wood','d',112,5,'dualfist',4,4.00000,0,0,0,325,0,54,-1,14400,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(15174,'Tallum Blade*Damascus of Friendship','10 day limited period','lrhand','true',1890,1,1,'wood','a',305,10,'dual',8,0.00000,0,0,0,325,0,121,-1,14400,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(15175,'Samurai Long Sword*Samurai Long Sword of Friendship','10 day limited period','lrhand','true',2080,1,1,'wood','b',236,10,'dual',8,0.00000,0,0,0,325,0,99,-1,14400,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(15176,'Spirit Sword*Raid Sword of Friendship','10 day limited period','lrhand','true',2260,3,3,'wood','c',190,10,'dual',8,0.00000,0,0,0,325,0,83,-1,14400,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(15177,'Bastard Sword*Elven Sword of Friendship','10 day limited period','lrhand','true',2460,3,3,'wood','d',107,10,'dual',8,0.00000,0,0,0,325,0,51,-1,14400,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(15178,'Tiphon\'s Spear of Friendship','10 day limited period','lrhand','true',1820,1,1,'wood','a',251,10,'pole',8,-3.00000,0,0,0,325,0,121,-1,14400,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(15179,'Lance of Friendship','10 day limited period','lrhand','true',1920,1,1,'wood','b',194,10,'pole',8,-3.00000,0,0,0,325,0,99,-1,14400,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(15180,'Orcish Poleaxe of Friendship','10 day limited period','lrhand','true',1950,3,3,'wood','c',156,10,'pole',8,-3.00000,0,0,0,325,0,83,-1,14400,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(15181,'Glaive of Friendship','10 day limited period','lrhand','true',2050,3,3,'wood','d',92,10,'pole',8,-3.00000,0,0,0,325,0,54,-1,14400,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(15182,'Durendal of Friendship','10 day limited period','lrhand','true',1820,1,1,'wood','a',272,15,'ancient',8,2.00000,0,0,0,350,0,121,-1,14400,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(15183,'Dismantler of Friendship','10 day limited period','lrhand','true',1930,1,1,'wood','b',210,15,'ancient',8,2.00000,0,0,0,350,0,99,-1,14400,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(15184,'Saber Tooth of Friendship','10 day limited period','lrhand','true',1950,3,3,'wood','c',169,15,'ancient',8,2.00000,0,0,0,350,0,83,-1,14400,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(15185,'General\'s Katzbalger of Friendship','10 day limited period','lrhand','true',2010,3,3,'wood','d',100,15,'ancient',8,2.00000,0,0,0,350,0,54,-1,14400,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(15186,'Eclair Bijou of Friendship','10 day limited period','rhand','true',1300,1,1,'wood','a',228,40,'rapier',10,-1.00000,0,0,0,406,0,121,-1,14400,0,0,'false','false','false','false','false',3426,1,0,0,0,0,0,0,0,'0-0;'),
(15187,'Colichemarde of Friendship','10 day limited period','rhand','true',1350,1,1,'wood','b',176,40,'rapier',10,-1.00000,0,0,0,406,0,99,-1,14400,0,0,'false','false','false','false','false',3426,1,0,0,0,0,0,0,0,'0-0;'),
(15188,'Admiral\'s Estoc of Friendship','10 day limited period','rhand','true',1380,3,3,'wood','c',141,40,'rapier',10,-1.00000,0,0,0,406,0,83,-1,14400,0,0,'false','false','false','false','false',3426,1,0,0,0,0,0,0,0,'0-0;'),
(15189,'Grand Epee of Friendship','10 day limited period','rhand','true',1440,3,3,'wood','d',83,40,'rapier',10,-1.00000,0,0,0,406,0,54,-1,14400,0,0,'false','false','false','false','false',3426,1,0,0,0,0,0,0,0,'0-0;'),
(15190,'Screaming Vengeance of Friendship','10 day limited period','rhand','true',1640,1,1,'wood','a',318,10,'crossbow',10,-1.00000,0,0,0,303,0,121,-1,14400,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(15191,'Hell Hound of Friendship','10 day limited period','rhand','true',1700,2,1,'wood','b',245,10,'crossbow',10,-1.00000,0,0,0,303,0,99,-1,14400,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(15192,'Sharpshooter of Friendship','10 day limited period','rhand','true',1740,6,3,'wood','c',198,10,'crossbow',10,-1.00000,0,0,0,303,0,83,-1,14400,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(15193,'Cranequin of Friendship','10 day limited period','rhand','true',1810,6,3,'wood','d',117,10,'crossbow',10,-1.00000,0,0,0,303,0,54,-1,14400,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(15280,'NPC use clear 1HS','','rhand','false',1560,2,2,'wood','s80',24,10,'sword',8,0.00000,0,0,0,379,0,17,-1,-1,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(15281,'NPC use clear 2HS','','lrhand','true',2180,2,2,'wood','s80',78,10,'bigsword',8,0.00000,0,0,0,325,0,39,-1,-1,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(15300,'NPC exclusive transparent dual','','lrhand','true',2080,1,1,'wood','s80',282,10,'dual',8,0.00000,0,0,0,325,0,114,-1,-1,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(15301,'NPC exclusive transparent pole','','lrhand','false',1950,3,3,'wood','s80',156,10,'pole',8,-3.00000,0,0,0,325,0,83,-1,-1,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(15302,'NPC exclusive transparent bow','','lrhand','true',1830,6,2,'wood','s80',114,5,'bow',12,-3.00000,0,0,0,227,4,35,-1,-1,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(15303,'NPC exclusive transparent claw','','lrhand','false',1013,1,1,'wood','s80',376,5,'dualfist',4,4.00000,0,0,0,325,0,119,-1,-1,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(15304,'NPC exclusive transparent bowgun','','rhand','true',1850,4,2,'wood','s80',64,10,'crossbow',10,-1.00000,0,0,0,303,0,32,-1,-1,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(15305,'NPC exclusive transparent rapier','','rhand','true',1520,2,2,'wood','s80',36,40,'rapier',10,-1.00000,0,0,0,406,0,26,-1,-1,0,0,'false','false','false','false','false',3426,1,0,0,0,0,0,0,0,'0-0;'),
(15306,'NPC exclusive transparent dual dagger','','lrhand','true',2150,1,1,'wood','s80',304,10,'dualdagger',12,-3.00000,0,0,0,433,0,157,-1,-1,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(15310,'Sacred Sword of Einhasad','','rhand','false',150,0,0,'wood','s',7,10,'sword',8,0.00000,0,0,0,379,0,5,-1,-1,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(15313,'PC cafe\' exclusive - Forgotten Blade','Weapons for PC Cafe Use','rhand','true',1300,1,1,'wood','s',281,10,'sword',8,0.00000,0,0,0,379,0,132,-1,-1,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(15314,'For PC cafe use -  Basalt Battlehammer','Weapons for PC Cafe Use','rhand','true',1570,1,1,'wood','s',281,20,'blunt',4,4.00000,0,0,0,379,0,132,-1,-1,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(15315,'For PC cafe use - Imperial Staff','Weapons for PC Cafe Use','lrhand','true',910,1,1,'wood','s',274,20,'bigblunt',4,4.00000,0,0,0,325,0,193,-1,-1,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(15316,'For PC cafe use - Angel Slayer','Weapons for PC Cafe Use','rhand','true',950,1,1,'wood','s',246,5,'dagger',12,-3.00000,0,0,0,433,0,132,-1,-1,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(15317,'For PC cafe use - Dragon Hunter Axe','Weapons for PC Cafe Use','lrhand','true',1820,1,1,'wood','s',342,20,'bigblunt',4,4.00000,0,0,0,325,0,132,-1,-1,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(15318,'For PC cafe use - Saint Spear','Weapons for PC Cafe Use','lrhand','true',1800,1,1,'wood','s',281,10,'pole',8,-3.00000,0,0,0,325,0,132,-1,-1,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(15319,'For PC cafe use - Demon Splinter','Weapons for PC Cafe Use','lrhand','true',1350,1,1,'wood','s',342,5,'dualfist',4,4.00000,0,0,0,325,0,132,-1,-1,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(15320,'For PC cafe use - Heaven\'s Divider','Weapons for PC Cafe Use','lrhand','true',1380,1,1,'wood','s',342,10,'bigsword',8,0.00000,0,0,0,325,0,132,-1,-1,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(15321,'For PC cafe use - Arcana Macw','Weapons for PC Cafe Use','rhand','true',1300,1,1,'wood','s',225,20,'blunt',4,4.00000,0,0,0,379,0,175,-1,-1,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(15322,'For PC cafe use - Draconic Bow','Weapons for PC Cafe Use','lrhand','true',1650,1,1,'wood','s',581,5,'bow',12,-3.00000,0,0,0,293,11,132,-1,-1,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(15323,'For PC cafe use - Laevateinn','Weapons for PC Cafe Use','rhand','true',1300,1,1,'wood','s',255,40,'rapier',10,-1.00000,0,0,0,406,0,132,-1,-1,0,0,'false','false','false','false','false',3426,1,0,0,0,0,0,0,0,'0-0;'),
(15324,'For PC cafe use - Gram','Weapons for PC Cafe Use','lrhand','true',1800,1,1,'wood','s',304,15,'ancient',8,2.00000,0,0,0,350,0,132,-1,-1,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(15325,'For PC cafe use - Sarnga','Weapons for PC Cafe Use','rhand','true',1600,1,1,'wood','s',356,10,'crossbow',10,-1.00000,0,0,0,303,0,132,-1,-1,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(15326,'For PC cafe use - Tallum Blade *Dark Legion','Weapons for PC Cafe Use','lrhand','true',2080,1,1,'wood','s',342,10,'dual',8,0.00000,0,0,0,325,0,132,-1,-1,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(15342,'Aqua Elf Transforming Harp','60 day limited period','rhand','false',0,0,0,'wood','none',1,10,'sword',8,0.00000,0,0,0,379,0,1,-1,86400,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'2994-1;'),
(15344,'Aqua Elf Transforming Harp - Event','60 day limited period','rhand','false',0,0,0,'wood','none',1,10,'sword',8,0.00000,0,0,0,379,0,1,-1,86400,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'2994-1;'),
(15403,'PC Cafe Use - Berserker Blade','Weapon for PC Cafe Use','none','true',1380,3,3,'wood','none',190,10,'none',8,0.00000,0,0,0,325,0,83,-1,-1,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(15436,'Halloween Transformation Stick','7 day limited period','none','false',10,0,0,'wood','none',1,10,'none',0,0.00000,0,0,0,379,0,1,-1,10080,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(16870,'Dark Crystal Shield of Friendship','90 day limited period','none','true',1190,0,0,'wood','none',0,0,'none',0,0.00000,-8,243,20,0,0,0,-1,129600,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(16875,'Avadon Shield of Friendship','90 day limited period','none','true',1210,0,0,'wood','none',0,0,'none',0,0.00000,-8,216,20,0,0,0,-1,129600,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(16895,'Doom Shield of Friendship','90 day limited period','none','true',1200,0,0,'wood','none',0,0,'none',0,0.00000,-8,230,20,0,0,0,-1,129600,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(16904,'Full Plate Shield of Friendship','90 day limited period','none','true',1220,0,0,'wood','none',0,0,'none',0,0.00000,-8,203,20,0,0,0,-1,129600,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(16914,'Brigandine Shield of Friendship','90 day limited period','none','true',1320,0,0,'wood','none',0,0,'none',0,0.00000,-8,142,20,0,0,0,-1,129600,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(16919,'Friendship Shield of Nightmare','90 day limited period','none','true',1180,0,0,'wood','none',0,0,'none',0,0.00000,-8,256,20,0,0,0,-1,129600,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(16920,'Sword of Miracles of Friendship','90 day limited period','none','true',840,1,1,'wood','none',186,10,'none',8,0.00000,0,0,0,379,0,152,-1,129600,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(16921,'Wizard\'s Tear of Friendship','90 day limited period','none','true',1350,1,1,'wood','none',155,10,'none',8,0.00000,0,0,0,379,0,132,-1,129600,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(16922,'Homunkulus\'s Sword of Friendship','90 day limited period','none','true',950,3,3,'wood','none',111,10,'none',8,0.00000,0,0,0,379,0,101,-1,129600,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(16923,'Friendship Staff of Life','90 day limited period','none','true',1180,3,3,'wood','none',74,20,'none',4,4.00000,0,0,0,379,0,72,-1,129600,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(16924,'Naga Storm of Friendship','90 day limited period','none','true',930,1,1,'wood','none',220,5,'none',12,-3.00000,0,0,0,433,0,121,-1,129600,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(16925,'Kris of Friendship','90 day limited period','none','true',980,1,1,'wood','none',153,5,'none',12,-3.00000,0,0,0,433,0,91,-1,129600,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(16926,'Dark Screamer of Friendship','90 day limited period','none','true',1010,3,3,'wood','none',122,5,'none',12,-3.00000,0,0,0,433,0,76,-1,129600,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(16927,'Mithril Dagger of Friendship','90 day limited period','none','true',1060,3,3,'wood','none',80,5,'none',12,-3.00000,0,0,0,433,0,54,-1,129600,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(16928,'Shyeed\'s Bow of Friendship','90 day limited period','none','true',1640,2,1,'wood','none',570,5,'none',12,-3.00000,0,0,0,227,10,133,-1,129600,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(16929,'Friendship Bow of Peril','90 day limited period','none','true',1700,3,1,'wood','none',400,5,'none',12,-3.00000,0,0,0,293,9,99,-1,129600,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(16930,'Eminence Bow of Friendship','90 day limited period','none','true',1720,10,3,'wood','none',323,5,'none',12,-3.00000,0,0,0,293,8,83,-1,129600,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(16931,'Light Crossbow of Friendship','90 day limited period','none','true',1810,10,3,'wood','none',191,5,'none',12,-3.00000,0,0,0,293,6,54,-1,129600,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(16932,'Barakiel\'s Axe of Friendship','90 day limited period','none','true',1550,1,1,'wood','none',251,20,'none',4,4.00000,0,0,0,379,0,121,-1,129600,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(16933,'Art of Battle Axe of Friendship','90 day limited period','none','true',1570,1,1,'wood','none',194,20,'none',4,4.00000,0,0,0,379,0,99,-1,129600,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(16934,'Yaksa Mace of Friendship','90 day limited period','none','true',1640,3,3,'wood','none',156,20,'none',4,4.00000,0,0,0,379,0,83,-1,129600,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(16935,'Bonebreaker of Friendship','90 day limited period','none','true',1720,3,3,'wood','none',92,20,'none',4,4.00000,0,0,0,379,0,54,-1,129600,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(16936,'Sirra\'s Blade of Friendship','90 day limited period','none','true',1300,1,1,'wood','none',251,10,'none',8,0.00000,0,0,0,379,0,121,-1,129600,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(16937,'Friendship Sword of Damascus','90 day limited period','none','true',1350,1,1,'wood','none',194,10,'none',8,0.00000,0,0,0,379,0,99,-1,129600,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(16938,'Samurai Longsword of Friendship','90 day limited period','none','true',1380,3,3,'wood','none',156,10,'none',8,0.00000,0,0,0,379,0,83,-1,129600,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(16939,'Elven Long Sword of Friendship','90 day limited period','none','true',1440,3,3,'wood','none',92,10,'none',8,0.00000,0,0,0,379,0,54,-1,129600,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(16940,'Friendship Sword of Ipos','90 day limited period','none','true',1820,1,1,'wood','none',305,10,'none',8,0.00000,0,0,0,325,0,121,-1,129600,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(16941,'Guardian Sword of Friendship','90 day limited period','none','true',1930,1,1,'wood','none',236,10,'none',8,0.00000,0,0,0,325,0,99,-1,129600,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(16942,'Berserker Blade of Friendship','90 day limited period','none','true',1380,3,3,'wood','none',190,10,'none',8,0.00000,0,0,0,325,0,83,-1,129600,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(16943,'Claymore of Friendship','90 day limited period','none','true',2090,3,3,'wood','none',112,10,'none',8,0.00000,0,0,0,325,0,54,-1,129600,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(16944,'Sobekk\'s Hurricane of Friendship','90 day limited period','none','true',1330,1,1,'wood','none',305,5,'none',4,4.00000,0,0,0,325,0,121,-1,129600,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(16945,'Bellion Cestus of Friendship','90 day limited period','none','true',1390,1,1,'wood','none',236,5,'none',4,4.00000,0,0,0,325,0,99,-1,129600,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(16946,'Great Pata of Friendship','90 day limited period','none','true',1460,3,3,'wood','none',190,5,'none',4,4.00000,0,0,0,325,0,83,-1,129600,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(16947,'Scallop Jamadhr of Friendship','90 day limited period','none','true',1520,3,3,'wood','none',112,5,'none',4,4.00000,0,0,0,325,0,54,-1,129600,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(16948,'Tallum Blade*Damascus of Friendship','90 day limited period','none','true',1890,1,1,'wood','none',305,10,'none',8,0.00000,0,0,0,325,0,121,-1,129600,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(16949,'Samurai Long Sword*Samurai Long Sword of Friendship','90 day limited period','none','true',2080,1,1,'wood','none',236,10,'none',8,0.00000,0,0,0,325,0,99,-1,129600,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(16950,'Spirit Sword*Raid Sword of Friendship','90 day limited period','none','true',2260,3,3,'wood','none',190,10,'none',8,0.00000,0,0,0,325,0,83,-1,129600,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(16951,'Bastard Sword*Elven Sword of Friendship','90 day limited period','none','true',2460,3,3,'wood','none',107,10,'none',8,0.00000,0,0,0,325,0,51,-1,129600,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(16952,'Tiphon\'s Spear of Friendship','90 day limited period','none','true',1820,1,1,'wood','none',251,10,'none',8,-3.00000,0,0,0,325,0,121,-1,129600,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(16953,'Lance of Friendship','90 day limited period','none','true',1920,1,1,'wood','none',194,10,'none',8,-3.00000,0,0,0,325,0,99,-1,129600,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(16954,'Orcish Poleaxe of Friendship','90 day limited period','none','true',1950,3,3,'wood','none',156,10,'none',8,-3.00000,0,0,0,325,0,83,-1,129600,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(16955,'Glaive of Friendship','90 day limited period','none','true',2050,3,3,'wood','none',92,10,'none',8,-3.00000,0,0,0,325,0,54,-1,129600,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(16956,'Durendal of Friendship','90 day limited period','none','true',1820,1,1,'wood','none',272,15,'none',8,2.00000,0,0,0,350,0,121,-1,129600,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(16957,'Dismantler of Friendship','90 day limited period','none','true',1930,1,1,'wood','none',210,15,'none',8,2.00000,0,0,0,350,0,99,-1,129600,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(16958,'Saber Tooth of Friendship','90 day limited period','none','true',1950,3,3,'wood','none',169,15,'none',8,2.00000,0,0,0,350,0,83,-1,129600,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(16959,'General\'s Katzbalger of Friendship','90 day limited period','none','true',2010,3,3,'wood','none',100,15,'none',8,2.00000,0,0,0,350,0,54,-1,129600,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(16960,'Eclair Bijou of Friendship','90 day limited period','none','true',1300,1,1,'wood','none',228,40,'none',10,-1.00000,0,0,0,406,0,121,-1,129600,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(16961,'Colichemarde of Friendship','90 day limited period','none','true',1350,1,1,'wood','none',176,40,'none',10,-1.00000,0,0,0,406,0,99,-1,129600,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(16962,'Admiral\'s Estoc of Friendship','90 day limited period','none','true',1380,3,3,'wood','none',141,40,'none',10,-1.00000,0,0,0,406,0,83,-1,129600,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(16963,'Grand Epee of Friendship','90 day limited period','none','true',1440,3,3,'wood','none',83,40,'none',10,-1.00000,0,0,0,406,0,54,-1,129600,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(16964,'Screaming Vengeance of Friendship','90 day limited period','none','true',1640,1,1,'wood','none',318,10,'none',10,-1.00000,0,0,0,303,0,121,-1,129600,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(16965,'Hell Hound of Friendship','90 day limited period','none','true',1700,2,1,'wood','none',245,10,'none',10,-1.00000,0,0,0,303,0,99,-1,129600,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(16966,'Sharpshooter of Friendship','90 day limited period','none','true',1740,6,3,'wood','none',198,10,'none',10,-1.00000,0,0,0,303,0,83,-1,129600,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(16967,'Cranequin of Friendship','90 day limited period','none','true',1810,6,3,'wood','none',117,10,'none',10,-1.00000,0,0,0,303,0,54,-1,129600,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(20109,'Sword of Revolution - Event','4 Hour Expiration Period','rhand','false',483,3,3,'fine_steel','d',79,10,'sword',8,0.00000,0,0,0,379,0,47,-1,240,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'21017-1;'),
(20110,'Titan Sword - Event','4 Hour Expiration Period','lrhand','false',673,3,3,'fine_steel','d',96,10,'bigsword',8,0.00000,0,0,0,325,0,47,-1,240,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'21018-1;'),
(20111,'Maingauche - Event','4 Hour Expiration Period','rhand','false',357,3,3,'fine_steel','d',69,5,'dagger',12,-3.00000,0,0,0,433,0,47,-1,240,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'21019-1;'),
(20112,'Tarbar - Event','4 Hour Expiration Period','rhand','false',577,3,3,'fine_steel','d',79,20,'blunt',4,4.00000,0,0,0,379,0,47,-1,240,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'21020-1;'),
(20113,'Titan Hammer - Event','4 Hour Expiration Period','lrhand','false',700,3,3,'steel','d',96,20,'bigblunt',4,4.00000,0,0,0,325,0,47,-1,240,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'21021-1;'),
(20114,'Priest Mace - Event','4 Hour Expiration Period','rhand','false',573,3,3,'steel','d',63,20,'blunt',4,4.00000,0,0,0,379,0,63,-1,240,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'21022-1;'),
(20115,'Goat Head Staff - Event','4 Hour Expiration Period','lrhand','false',333,3,3,'wood','d',77,20,'bigblunt',4,4.00000,0,0,0,325,0,63,-1,240,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'21023-1;'),
(20116,'Bich\'Hwa - Event','4 Hour Expiration Period','lrhand','false',503,3,3,'fine_steel','d',96,5,'dualfist',4,4.00000,0,0,0,325,0,47,-1,240,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'21024-1;'),
(20117,'Strengthened Long Bow - Event','4 Hour Expiration Period','lrhand','false',607,10,3,'steel','d',179,5,'bow',12,-3.00000,0,0,0,227,5,51,-1,240,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'21025-1;'),
(20118,'Winged Spear - Event','4 Hour Expiration Period','lrhand','false',687,3,3,'fine_steel','d',79,10,'pole',8,-3.00000,0,0,0,325,0,47,-1,240,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3599-1;21026-1;'),
(20119,'Artisan\'s Sword*Artisan\'s Sword - Event','4 Hour Expiration Period','lrhand','false',827,3,3,'fine_steel','d',96,10,'dual',8,0.00000,0,0,0,325,0,47,-1,240,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'21027-1;'),
(20120,'Epee - Event','4 Hour Expiration Period','rhand','false',483,3,3,'wood','d',72,40,'rapier',10,-1.00000,0,0,0,406,0,47,-1,240,0,0,'false','false','true','false','true',3426,1,0,0,0,0,0,0,0,'21028-1;'),
(20121,'Katzbalger - Event','4 Hour Expiration Period','lrhand','false',673,3,3,'wood','d',86,15,'ancient',8,2.00000,0,0,0,350,0,47,-1,240,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'21029-1;'),
(20122,'Arm Breaker - Event','4 Hour Expiration Period','rhand','false',607,6,3,'wood','d',100,10,'crossbow',10,-1.00000,0,0,0,303,0,47,-1,240,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'21030-1;'),
(20123,'Samurai Longsword - Event','4 Hour Expiration Period','rhand','false',460,3,3,'oriharukon','c',156,10,'sword',8,0.00000,0,0,0,379,0,83,-1,240,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'21017-1;'),
(20124,'Berserker Blade - Event','4 Hour Expiration Period','lrhand','false',460,3,3,'oriharukon','c',190,10,'bigsword',8,0.00000,0,0,0,325,0,83,-1,240,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'21018-1;'),
(20125,'Crystal Dagger - Event','4 Hour Expiration Period','rhand','false',333,3,3,'crystal','c',136,5,'dagger',12,-3.00000,0,0,0,433,0,83,-1,240,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'21019-1;'),
(20126,'Yaksa Mace - Event','4 Hour Expiration Period','rhand','false',547,3,3,'fine_steel','c',156,20,'blunt',4,4.00000,0,0,0,379,0,83,-1,240,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'21020-1;'),
(20127,'Dwarven Hammer - Event','4 Hour Expiration Period','lrhand','false',670,3,3,'steel','c',190,20,'bigblunt',4,4.00000,0,0,0,325,0,83,-1,240,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'21021-1;'),
(20128,'Ecliptic Axe - Event','4 Hour Expiration Period','rhand','false',547,3,3,'fine_steel','c',125,20,'blunt',4,4.00000,0,0,0,379,0,111,-1,240,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'21022-1;'),
(20129,'Demon\'s Staff - Event','4 Hour Expiration Period','lrhand','false',330,3,3,'wood','c',152,20,'bigblunt',4,4.00000,0,0,0,325,0,111,-1,240,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'21023-1;'),
(20130,'Great Pata - Event','4 Hour Expiration Period','lrhand','false',487,3,3,'chrysolite','c',190,5,'dualfist',4,4.00000,0,0,0,325,0,83,-1,240,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'21024-1;'),
(20131,'Eminence Bow - Event','4 Hour Expiration Period','lrhand','false',573,10,3,'chrysolite','c',323,5,'bow',12,-3.00000,0,0,0,293,8,83,-1,240,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'21025-1;'),
(20132,'Orcish Poleaxe - Event','4 Hour Expiration Period','lrhand','false',650,3,3,'blood_steel','c',156,10,'pole',8,-3.00000,0,0,0,325,0,83,-1,240,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3599-1;21026-1;'),
(20133,'Katana*Katana - Event','4 Hour Expiration Period','lrhand','false',757,3,3,'fine_steel','c',190,10,'dual',8,0.00000,0,0,0,325,0,83,-1,240,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'21027-1;'),
(20134,'Admiral\'s Estoc - Event','4 Hour Expiration Period','rhand','false',460,3,3,'wood','c',141,40,'rapier',10,-1.00000,0,0,0,406,0,83,-1,240,0,0,'false','false','true','false','true',3426,1,0,0,0,0,0,0,0,'21028-1;'),
(20135,'Saber Tooth - Event','4 Hour Expiration Period','lrhand','false',650,3,3,'wood','c',169,15,'ancient',8,2.00000,0,0,0,350,0,83,-1,240,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'21029-1;'),
(20136,'Sharpshooter - Event','4 Hour Expiration Period','rhand','false',580,6,3,'wood','c',198,10,'crossbow',10,-1.00000,0,0,0,303,0,83,-1,240,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'21030-1;'),
(20137,'Sword of Damascus - Event','4 Hour Expiration Period','rhand','false',450,1,1,'damascus','b',194,10,'sword',8,0.00000,0,0,0,379,0,99,-1,240,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'21017-1;'),
(20138,'Guardian Sword - Event','4 Hour Expiration Period','lrhand','false',643,1,1,'steel','b',236,10,'bigsword',8,0.00000,0,0,0,325,0,99,-1,240,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'21018-1;'),
(20139,'Demon\'s Dagger - Event','4 Hour Expiration Period','rhand','false',323,1,1,'blood_steel','b',170,5,'dagger',12,-3.00000,0,0,0,433,0,99,-1,240,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'21019-1;'),
(20140,'Art of Battle Axe - Event','4 Hour Expiration Period','rhand','false',523,1,1,'chrysolite','b',194,20,'blunt',4,4.00000,0,0,0,379,0,99,-1,240,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'21020-1;'),
(20141,'Star Buster - Event','4 Hour Expiration Period','lrhand','false',643,1,1,'fine_steel','b',236,20,'bigblunt',4,4.00000,0,0,0,325,0,99,-1,240,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'21021-1;'),
(20142,'Kaim Vanul\'s Bones - Event','4 Hour Expiration Period','rhand','false',523,1,1,'bone','b',155,20,'blunt',4,4.00000,0,0,0,379,0,132,-1,240,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'21022-1;'),
(20143,'Staff of Evil Spirits - Event','4 Hour Expiration Period','lrhand','false',310,1,1,'wood','b',189,20,'bigblunt',4,4.00000,0,0,0,325,0,132,-1,240,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'21023-1;'),
(20144,'Bellion Cestus - Event','4 Hour Expiration Period','lrhand','false',463,1,1,'mithril','b',236,5,'dualfist',4,4.00000,0,0,0,325,0,99,-1,240,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'21024-1;'),
(20145,'Bow of Peril - Event','4 Hour Expiration Period','lrhand','false',567,3,1,'blood_steel','b',400,5,'bow',12,-3.00000,0,0,0,293,9,99,-1,240,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'21025-1;'),
(20146,'Lance - Event','4 Hour Expiration Period','lrhand','false',640,1,1,'blood_steel','b',194,10,'pole',8,-3.00000,0,0,0,325,0,99,-1,240,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3599-1;21026-1;'),
(20147,'Samurai Long Sword*Samurai Long Sword - Event','4 Hour Expiration Period','lrhand','false',693,1,1,'fine_steel','b',236,10,'dual',8,0.00000,0,0,0,325,0,99,-1,240,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'21027-1;'),
(20148,'Colichemarde - Event','4 Hour Expiration Period','rhand','false',450,1,1,'wood','b',176,40,'rapier',10,-1.00000,0,0,0,406,0,99,-1,240,0,0,'false','false','true','false','true',3426,1,0,0,0,0,0,0,0,'21028-1;'),
(20149,'Dismantler - Event','4 Hour Expiration Period','lrhand','false',643,1,1,'wood','b',210,15,'ancient',8,2.00000,0,0,0,350,0,99,-1,240,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'21029-1;'),
(20150,'Hell Hound - Event','4 Hour Expiration Period','rhand','false',567,2,1,'wood','b',245,10,'crossbow',10,-1.00000,0,0,0,303,0,99,-1,240,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'21030-1;'),
(20151,'Dark Legion - Event','4 Hour Expiration Period','rhand','false',440,1,1,'fine_steel','a',232,10,'sword',8,0.00000,0,0,0,379,0,114,-1,240,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'21017-1;'),
(20152,'Dragon Slayer - Event','4 Hour Expiration Period','lrhand','false',613,1,1,'bone','a',282,10,'bigsword',8,0.00000,0,0,0,325,0,114,-1,240,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'21018-1;'),
(20153,'Soul Separator - Event','4 Hour Expiration Period','rhand','false',317,1,1,'oriharukon','a',203,5,'dagger',12,-3.00000,0,0,0,433,0,114,-1,240,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'21019-1;'),
(20154,'Elysian - Event','4 Hour Expiration Period','rhand','false',527,1,1,'oriharukon','a',232,20,'blunt',4,4.00000,0,0,0,379,0,114,-1,240,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'21020-1;'),
(20155,'Doom Crusher - Event','4 Hour Expiration Period','lrhand','false',633,1,1,'fine_steel','a',282,20,'bigblunt',4,4.00000,0,0,0,325,0,114,-1,240,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'21021-1;'),
(20156,'Flaming Dragon Skull - Event','4 Hour Expiration Period','rhand','false',510,1,1,'fine_steel','a',186,20,'blunt',4,4.00000,0,0,0,379,0,152,-1,240,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'21022-1;'),
(20157,'Branch of the Mother Tree - Event','4 Hour Expiration Period','lrhand','false',300,1,1,'wood','a',226,20,'bigblunt',4,4.00000,0,0,0,325,0,152,-1,240,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'21023-1;'),
(20158,'Dragon Grinder - Event','4 Hour Expiration Period','lrhand','false',450,1,1,'adamantaite','a',282,5,'dualfist',4,4.00000,0,0,0,325,0,114,-1,240,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'21024-1;'),
(20159,'Soul Bow - Event','4 Hour Expiration Period','lrhand','false',553,2,1,'oriharukon','a',528,5,'bow',12,-3.00000,0,0,0,227,10,125,-1,240,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'21025-1;'),
(20160,'Tallum Glaive - Event','4 Hour Expiration Period','lrhand','false',613,1,1,'chrysolite','a',232,10,'pole',8,-3.00000,0,0,0,325,0,114,-1,240,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3599-1;21026-1;'),
(20161,'Damascus*Damascus - Event','4 Hour Expiration Period','lrhand','false',693,1,1,'fine_steel','a',282,10,'dual',8,0.00000,0,0,0,325,0,114,-1,240,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'21027-1;'),
(20162,'Lacerator - Event','4 Hour Expiration Period','rhand','false',440,1,1,'wood','a',210,40,'rapier',10,-1.00000,0,0,0,406,0,114,-1,240,0,0,'false','false','true','false','true',3426,1,0,0,0,0,0,0,0,'21028-1;'),
(20163,'Undertaker - Event','4 Hour Expiration Period','lrhand','false',613,1,1,'wood','a',251,15,'ancient',8,2.00000,0,0,0,350,0,114,-1,240,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'21029-1;'),
(20164,'Reaper - Event','4 Hour Expiration Period','rhand','false',553,1,1,'wood','a',294,10,'crossbow',10,-1.00000,0,0,0,303,0,114,-1,240,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'21030-1;'),
(20165,'Forgotten Blade - Event','4 Hour Expiration Period','rhand','false',433,1,1,'adamantaite','s',281,10,'sword',8,0.00000,0,0,0,379,0,132,-1,240,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'21017-1;'),
(20166,'Heaven\'s Divider - Event','4 Hour Expiration Period','lrhand','false',460,1,1,'adamantaite','s',342,10,'bigsword',8,0.00000,0,0,0,325,0,132,-1,240,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'21018-1;'),
(20167,'Angel Slayer - Event','4 Hour Expiration Period','rhand','false',317,1,1,'adamantaite','s',246,5,'dagger',12,-3.00000,0,0,0,433,0,132,-1,240,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'21019-1;'),
(20168,'Basalt Battlehammer - Event','4 Hour Expiration Period','rhand','false',523,1,1,'adamantaite','s',281,20,'blunt',4,4.00000,0,0,0,379,0,132,-1,240,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'21020-1;'),
(20169,'Dragon Hunter Axe - Event','4 Hour Expiration Period','lrhand','false',607,1,1,'adamantaite','s',342,20,'bigblunt',4,4.00000,0,0,0,325,0,132,-1,240,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'21021-1;'),
(20170,'Arcana Mace - Event','4 Hour Expiration Period','rhand','false',433,1,1,'adamantaite','s',225,20,'blunt',4,4.00000,0,0,0,379,0,175,-1,240,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'21022-1;'),
(20171,'Imperial Staff - Event','4 Hour Expiration Period','lrhand','false',303,1,1,'adamantaite','s',274,20,'bigblunt',4,4.00000,0,0,0,325,0,175,-1,240,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'21023-1;'),
(20172,'Demon Splinter - Event','4 Hour Expiration Period','lrhand','false',450,1,1,'adamantaite','s',342,5,'dualfist',4,4.00000,0,0,0,325,0,132,-1,240,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'21024-1;'),
(20173,'Draconic Bow - Event','4 Hour Expiration Period','lrhand','false',550,1,1,'adamantaite','s',581,5,'bow',12,-3.00000,0,0,0,293,11,132,-1,240,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'21025-1;'),
(20174,'Saint Spear - Event','4 Hour Expiration Period','lrhand','false',600,1,1,'adamantaite','s',281,10,'pole',8,-3.00000,0,0,0,325,0,132,-1,240,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3599-1;21026-1;'),
(20175,'Tallum Blade*Dark Legion - Event','4 Hour Expiration Period','lrhand','false',693,1,1,'adamantaite','s',342,10,'dual',8,0.00000,0,0,0,325,0,132,-1,240,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'21027-1;'),
(20176,'Laevateinn - Event','4 Hour Expiration Period','rhand','false',433,1,1,'wood','s',255,40,'rapier',10,-1.00000,0,0,0,406,0,132,-1,240,0,0,'false','false','true','false','true',3426,1,0,0,0,0,0,0,0,'21028-1;'),
(20177,'Gram - Event','4 Hour Expiration Period','lrhand','false',600,1,1,'wood','s',304,15,'ancient',8,2.00000,0,0,0,350,0,132,-1,240,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'21029-1;'),
(20178,'Sarnga - Event','4 Hour Expiration Period','rhand','false',533,1,1,'wood','s',356,10,'crossbow',10,-1.00000,0,0,0,303,0,132,-1,240,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'21030-1;'),
(20255,'Baguette Sword','7 Day Expiration Period','rhand','false',500,3,3,'fine_steel','none',1,10,'sword',8,0.00000,0,0,0,379,0,2,-1,10080,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'21042-1;'),
(20256,'Baguette Dagger','7 Day Expiration Period','rhand','false',500,3,3,'fine_steel','none',1,5,'dagger',12,-3.00000,0,0,0,433,0,2,-1,10080,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'21042-1;'),
(20257,'Baguette Dual Sword','7 Day Expiration Period','lrhand','false',500,3,3,'fine_steel','none',1,10,'dual',8,0.00000,0,0,0,325,0,2,-1,10080,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'21042-1;'),
(20258,'Baguette Mace','7 Day Expiration Period','rhand','false',500,3,3,'fine_steel','none',1,20,'blunt',4,4.00000,0,0,0,379,0,2,-1,10080,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'21042-1;'),
(20259,'Baguette Heavy Hammer','7 Day Expiration Period','lrhand','false',500,3,3,'fine_steel','none',1,20,'bigblunt',4,4.00000,0,0,0,325,0,2,-1,10080,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'21042-1;'),
(20260,'Baguette Spear','7 Day Expiration Period','lrhand','false',500,3,3,'fine_steel','none',1,10,'pole',8,-3.00000,0,0,0,325,0,2,-1,10080,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'3599-1;21042-1;'),
(20261,'Baguette Bow','7 Day Expiration Period','lrhand','false',500,10,3,'fine_steel','none',1,5,'bow',12,-3.00000,0,0,0,227,5,3,-1,10080,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'21042-1;'),
(20262,'Baguette Fist','7 Day Expiration Period','lrhand','false',500,3,3,'fine_steel','none',1,5,'dualfist',4,4.00000,0,0,0,325,0,2,-1,10080,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'21042-1;'),
(20263,'Baguette Magic Sword','7 Day Expiration Period','rhand','false',500,3,3,'fine_steel','none',1,10,'sword',8,0.00000,0,0,0,379,0,2,-1,10080,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'21042-1;'),
(20264,'Baguette Staff','7 Day Expiration Period','rhand','false',500,3,3,'fine_steel','none',1,20,'blunt',4,4.00000,0,0,0,379,0,2,-1,10080,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'21042-1;'),
(20265,'Baguette Great Staff','7 Day Expiration Period','lrhand','false',500,3,3,'fine_steel','none',1,20,'bigblunt',4,4.00000,0,0,0,325,0,2,-1,10080,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'21042-1;'),
(20266,'Baguette Shield','7 Day Expiration Period','lhand','false',500,0,0,'wood','none',0,0,'none',0,0.00000,-8,5,20,0,0,0,-1,10080,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(20267,'Baguette Rapier','7 Day Expiration Period','rhand','false',500,3,3,'fine_steel','none',1,40,'rapier',10,-1.00000,0,0,0,406,0,3,-1,10080,0,0,'false','false','true','false','true',3426,1,0,0,0,0,0,0,0,'21042-1;'),
(20268,'Baguette Ancient Sword','7 Day Expiration Period','lrhand','false',500,3,3,'fine_steel','none',1,15,'ancient',8,2.00000,0,0,0,350,0,3,-1,10080,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'21042-1;'),
(20269,'Baguette Crossbow','7 Day Expiration Period','rhand','false',500,6,3,'fine_steel','none',1,10,'crossbow',10,-1.00000,0,0,0,303,0,3,-1,10080,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'21042-1;'),
(20270,'Baguette\'s Dualsword','7 Day Expiration Period','lrhand','false',500,3,3,'fine_steel','none',1,10,'dual',8,0.00000,0,0,0,325,0,2,-1,10080,0,0,'false','false','true','false','true',0,0,0,0,0,0,0,0,0,'21042-1;'),
(20600,'Twilight Staff','Dance of Shadow - 7 day limited period','lrhand','false',0,0,0,'wood','none',1,10,'bigblunt',8,0.00000,0,0,0,379,0,1,-1,10080,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(20639,'Standard Item - Elven Long Sword','','rhand','false',100,3,3,'wood','d',92,10,'sword',8,0.00000,0,0,0,379,0,54,-1,-1,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(20640,'Standard Item - Light Crossbow','','rhand','false',100,10,3,'wood','d',191,5,'crossbow',12,-3.00000,0,0,0,293,6,54,-1,-1,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(20641,'Standard Item - Knight\'s Sword*Elven Sword','','lrhand','false',100,3,3,'wood','d',107,10,'dual',8,0.00000,0,0,0,325,0,51,-1,-1,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(20644,'Standard Item - Plate Shield','','lhand','false',100,0,0,'wood','d',0,0,'none',0,0.00000,-8,154,20,0,0,0,-1,-1,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(20649,'Standard Item - Ghost Staff','','lrhand','false',100,3,3,'wood','d',90,20,'bigblunt',4,4.00000,0,0,0,325,0,79,-1,-1,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(20867,'Kadomas Transformation Stick','7 day limited period','lrhand','false',150,0,0,'wood','none',1,10,'none',8,0.00000,0,0,0,379,0,1,-1,10080,0,0,'false','false','false','false','false',0,0,0,0,0,0,0,0,0,'21169-1;');

-- Fixes all improper weapon slotting.
UPDATE `weapon` SET bodypart = "rhand" WHERE (weaponType = "dagger") or (weaponType = "sword") or (weaponType = "rapier") or (weaponType = "crossbow");
UPDATE `weapon` SET bodypart = "lrhand" WHERE (weaponType = "pole") or (weaponType = "bow") or (weaponType = "ancient") or (weaponType = "bigsword") or (weaponType = "bigblunt") or (weaponType = "dualfist") or (weaponType = "dual") or (weaponType = "dualdagger");

UPDATE `weapon` SET time = "240" WHERE (additionalname LIKE '%4 hour%') or (additionalname LIKE '%4-hour%');
UPDATE `weapon` SET time = "10080" WHERE (additionalname LIKE '%7 Day%') or (additionalname LIKE '%7-Day%');
UPDATE `weapon` SET time = "14400" WHERE (additionalname LIKE '%10 Day%') or (additionalname LIKE '%10-Day%');
UPDATE `weapon` SET time = "20160" WHERE (additionalname LIKE '%14 Day%') or (additionalname LIKE '%14-Day%');
UPDATE `weapon` SET time = "43200" WHERE (additionalname LIKE '%30 Day%') or (additionalname LIKE '%30-Day%');
UPDATE `weapon` SET time = "86400" WHERE (additionalname LIKE '%60 Day%') or (additionalname LIKE '%60-Day%');
UPDATE `weapon` SET time = "129600" WHERE (additionalname LIKE '%90 Day%') or (additionalname LIKE '%90-Day%');

-- Ensures that all rapiers have the rapier skill, then sets the Infinity Rapier one to 0 (since it's called via the Infinity SA)
UPDATE `weapon` SET enchant4_skill_id = "3426", enchant4_skill_lvl = "1" WHERE weaponType = "rapier";
UPDATE `weapon` SET enchant4_skill_id = "0", enchant4_skill_lvl = "0" WHERE item_id = "9388";

-- Weapons that are limited should not be able to be changed as far as I know. I do not know if changing a weapon will reset the timer on it. Until tested, this entry should remain. Just to be safe. ;)
UPDATE `weapon` SET change_weaponId = "0" WHERE (duration > 0) or (time > 0);

-- Despite this change not being EXACTLY retail-like, I find it maintains proper logic. It also prevents any possible exploit that might come from having retail information (prices and crystal counts) on NPC items.
UPDATE `weapon` SET crystallizable = "false", crystal_type = "none", price = "0", crystal_count = "0" WHERE name LIKE '%NPC Item %';

-- PvP weapons can not be changed via the Kamael skill, or traded, or dropped, or shipped, or sold. Just like augmented items but with more restrictions.
UPDATE `weapon` SET change_weaponId = "0", sellable = "false", dropable = "false", tradeable = "false" WHERE name LIKE '%{PvP}%';