/*
 * Decompiled with CFR 0.152.
 */
package javolution.context;

import javolution.context.AllocatorContext;
import javolution.context.ConcurrentException;
import javolution.context.ConcurrentThread;
import javolution.context.Context;
import javolution.context.LocalContext;
import javolution.context.ObjectFactory;
import javolution.lang.Configurable;
import javolution.lang.MathLib;
import javolution.lang.Reflection;

public abstract class ConcurrentContext
extends Context {
    public static final Configurable<Integer> MAXIMUM_CONCURRENCY = new Configurable(new Integer(ConcurrentContext.availableProcessors() - 1)){

        protected void notifyChange(Object oldValue, Object newValue) {
            CONCURRENCY.setDefault(newValue);
        }
    };
    public static final Configurable<Class<? extends ConcurrentContext>> DEFAULT = new Configurable(Default.class){};
    private static final LocalContext.Reference CONCURRENCY = new LocalContext.Reference<Integer>(MAXIMUM_CONCURRENCY.get());

    private static int availableProcessors() {
        Reflection.Method availableProcessors = Reflection.getInstance().getMethod("java.lang.Runtime.availableProcessors()");
        if (availableProcessors != null) {
            Integer processors = (Integer)availableProcessors.invoke(Runtime.getRuntime());
            return processors;
        }
        return 1;
    }

    protected ConcurrentContext() {
    }

    public static void enter() {
        Context.enter(DEFAULT.get());
    }

    public static void enter(boolean condition) {
        if (condition) {
            ConcurrentContext.enter();
        }
    }

    public static void exit() {
        Context.exit(ConcurrentContext.class);
    }

    public static void exit(boolean condition) {
        if (condition) {
            ConcurrentContext.exit();
        }
    }

    public static void setConcurrency(int concurrency) {
        concurrency = MathLib.max(0, concurrency);
        concurrency = MathLib.min(MAXIMUM_CONCURRENCY.get(), concurrency);
        CONCURRENCY.set(new Integer(concurrency));
    }

    public static int getConcurrency() {
        return (Integer)CONCURRENCY.get();
    }

    public static void execute(Runnable logic) {
        ConcurrentContext ctx = (ConcurrentContext)Context.getCurrentContext();
        ctx.executeAction(logic);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void execute(Runnable ... logics) {
        ConcurrentContext.enter();
        ConcurrentContext ctx = (ConcurrentContext)ConcurrentContext.getCurrentContext();
        try {
            for (int i = 0; i < logics.length; ++i) {
                ctx.executeAction(logics[i]);
            }
        }
        finally {
            ConcurrentContext.exit();
        }
    }

    protected abstract void executeAction(Runnable var1);

    static {
        ObjectFactory.setInstance(new ObjectFactory(){

            protected Object create() {
                return new Default();
            }
        }, Default.class);
    }

    static final class Default
    extends ConcurrentContext {
        private static final ConcurrentThread[] _Executors = new ConcurrentThread[((Integer)MAXIMUM_CONCURRENCY.get()).intValue()];
        private int _concurrency;
        private volatile Throwable _error;
        private int _initiated;
        private int _completed;

        Default() {
        }

        @Override
        protected void enterAction() {
            this._concurrency = ConcurrentContext.getConcurrency();
        }

        @Override
        protected void executeAction(Runnable logic) {
            if (this._error != null) {
                return;
            }
            int i = this._concurrency;
            while (--i >= 0) {
                if (!_Executors[i].execute(logic, this)) continue;
                ++this._initiated;
                return;
            }
            logic.run();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void exitAction() {
            try {
                if (this._initiated != 0) {
                    Default default_ = this;
                    synchronized (default_) {
                        while (this._initiated != this._completed) {
                            try {
                                this.wait();
                            }
                            catch (InterruptedException e) {
                                throw new ConcurrentException(e);
                            }
                        }
                    }
                }
                if (this._error != null) {
                    if (this._error instanceof RuntimeException) {
                        throw (RuntimeException)this._error;
                    }
                    if (this._error instanceof Error) {
                        throw (Error)this._error;
                    }
                    throw new ConcurrentException(this._error);
                }
            }
            finally {
                this._error = null;
                this._initiated = 0;
                this._completed = 0;
            }
        }

        void started() {
            Context.setConcurrentContext(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void completed() {
            Default default_ = this;
            synchronized (default_) {
                ++this._completed;
                this.notify();
            }
            AllocatorContext.getCurrentAllocatorContext().deactivate();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void error(Throwable error) {
            Default default_ = this;
            synchronized (default_) {
                if (this._error == null) {
                    this._error = error;
                }
            }
        }

        static {
            for (int i = 0; i < _Executors.length; ++i) {
                Default._Executors[i] = new ConcurrentThread();
                _Executors[i].start();
            }
        }
    }
}

