/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver;

import com.l2jserver.Config;
import com.l2jserver.gameserver.LoginServerThread;
import com.l2jserver.gameserver.cache.HtmCache;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.CreatureSay;
import com.l2jserver.gameserver.network.serverpackets.NpcHtmlMessage;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.script.DateRange;
import com.l2jserver.gameserver.util.Broadcast;
import com.l2jserver.util.StringUtil;
import com.l2jserver.util.Util;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javolution.io.UTF8StreamWriter;
import javolution.util.FastList;

public class Announcements {
    private static Logger _log = Logger.getLogger(Announcements.class.getName());
    private List<String> _announcements = new FastList();
    private List<List<Object>> _eventAnnouncements = new FastList();

    private Announcements() {
        this.loadAnnouncements();
    }

    public static Announcements getInstance() {
        return SingletonHolder._instance;
    }

    public void loadAnnouncements() {
        this._announcements.clear();
        File file = new File(Config.DATAPACK_ROOT, "data/announcements.txt");
        if (file.exists()) {
            this.readFromDisk(file);
        } else {
            _log.warning("data/announcements.txt doesn't exist");
        }
    }

    public void showAnnouncements(L2PcInstance activeChar) {
        int i;
        for (i = 0; i < this._announcements.size(); ++i) {
            String announcement = this._announcements.get(i);
            if (announcement.indexOf(37) >= 0) {
                announcement = announcement.replaceFirst("%server_name%", LoginServerThread.getInstance().getServerName());
            }
            CreatureSay cs = new CreatureSay(0, 10, activeChar.getName(), announcement);
            activeChar.sendPacket(cs);
        }
        for (i = 0; i < this._eventAnnouncements.size(); ++i) {
            List<Object> entry = this._eventAnnouncements.get(i);
            DateRange validDateRange = (DateRange)entry.get(0);
            String[] msg = (String[])entry.get(1);
            Date currentDate = new Date();
            if (!validDateRange.isValid() || !validDateRange.isWithinRange(currentDate)) continue;
            SystemMessage sm = new SystemMessage(SystemMessageId.S1);
            for (int j = 0; j < msg.length; ++j) {
                sm.addString(msg[j]);
            }
            activeChar.sendPacket(sm);
        }
    }

    public void addEventAnnouncement(DateRange validDateRange, String[] msg) {
        FastList entry = new FastList();
        entry.add(validDateRange);
        entry.add(msg);
        this._eventAnnouncements.add((List<Object>)entry);
    }

    public void listAnnouncements(L2PcInstance activeChar) {
        String content = HtmCache.getInstance().getHtmForce(activeChar.getHtmlPrefix(), "data/html/admin/announce.htm");
        NpcHtmlMessage adminReply = new NpcHtmlMessage(5);
        adminReply.setHtml(content);
        StringBuilder replyMSG = StringUtil.startAppend(500, "<br>");
        for (int i = 0; i < this._announcements.size(); ++i) {
            StringUtil.append(replyMSG, "<table width=260><tr><td width=220>", this._announcements.get(i), "</td><td width=40><button value=\"Delete\" action=\"bypass -h admin_del_announcement ", String.valueOf(i), "\" width=60 height=21 back=\"L2UI_ct1.button_df\" fore=\"L2UI_ct1.button_df\"></td></tr></table>");
        }
        adminReply.replace((CharSequence)"%announces%", replyMSG.toString());
        activeChar.sendPacket(adminReply);
    }

    public void addAnnouncement(String text) {
        this._announcements.add(text);
        this.saveToDisk();
    }

    public void delAnnouncement(int line) {
        this._announcements.remove(line);
        this.saveToDisk();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readFromDisk(File file) {
        BufferedReader lnr = null;
        try {
            int i = 0;
            String line = null;
            lnr = Util.utf8BufferedReader(file);
            while ((line = lnr.readLine()) != null) {
                this._announcements.add(line);
                ++i;
            }
            if (Config.DEBUG) {
                _log.info("Announcements: Loaded " + i + " Announcements.");
            }
        }
        catch (IOException e1) {
            _log.log(Level.SEVERE, "Error reading announcements: ", e1);
        }
        finally {
            try {
                lnr.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveToDisk() {
        File file = new File("data/announcements.txt");
        UTF8StreamWriter save = null;
        try {
            save = Util.utf8StreamWriter(file);
            for (int i = 0; i < this._announcements.size(); ++i) {
                save.write(this._announcements.get(i));
                save.write("\r\n");
            }
        }
        catch (IOException e) {
            _log.log(Level.SEVERE, "Saving to the announcements file has failed: ", e);
        }
        finally {
            try {
                save.close();
            }
            catch (Exception exception) {}
        }
    }

    public void announceToAll(String text) {
        Broadcast.announceToOnlinePlayers(text);
    }

    public void announceToAll(SystemMessage sm) {
        Broadcast.toAllOnlinePlayers(sm);
    }

    public void announceToInstance(SystemMessage sm, int instanceId) {
        Broadcast.toPlayersInInstance(sm, instanceId);
    }

    public void handleAnnounce(String command, int lengthToTrim) {
        try {
            String text = command.substring(lengthToTrim);
            SingletonHolder._instance.announceToAll(text);
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    private static class SingletonHolder {
        protected static final Announcements _instance = new Announcements();

        private SingletonHolder() {
        }
    }
}

