/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.datatables;

import com.l2jserver.Config;
import com.l2jserver.L2DatabaseFactory;
import com.l2jserver.gameserver.model.L2AccessLevel;
import gnu.trove.TIntObjectHashMap;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AccessLevels {
    private static Logger _log = Logger.getLogger(AccessLevels.class.getName());
    public static final int _masterAccessLevelNum = Config.MASTERACCESS_LEVEL;
    public static L2AccessLevel _masterAccessLevel = new L2AccessLevel(_masterAccessLevelNum, "Master Access", Config.MASTERACCESS_NAME_COLOR, Config.MASTERACCESS_TITLE_COLOR, null, true, true, true, true, true, true, true, true);
    public static final int _userAccessLevelNum = 0;
    public static L2AccessLevel _userAccessLevel = new L2AccessLevel(0, "User", -1, -1, null, false, false, false, true, false, true, true, true);
    private TIntObjectHashMap<L2AccessLevel> _accessLevels;

    public static AccessLevels getInstance() {
        return SingletonHolder._instance;
    }

    private AccessLevels() {
        this.loadAccessLevels();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadAccessLevels() {
        this._accessLevels = new TIntObjectHashMap();
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement stmt = con.prepareStatement("SELECT * FROM `access_levels` ORDER BY `accessLevel` DESC");
            ResultSet rset = stmt.executeQuery();
            int accessLevel = 0;
            String name = null;
            int nameColor = 0;
            int titleColor = 0;
            String childs = null;
            boolean isGm = false;
            boolean allowPeaceAttack = false;
            boolean allowFixedRes = false;
            boolean allowTransaction = false;
            boolean allowAltG = false;
            boolean giveDamage = false;
            boolean takeAggro = false;
            boolean gainExp = false;
            while (rset.next()) {
                accessLevel = rset.getInt("accessLevel");
                name = rset.getString("name");
                if (accessLevel == 0) {
                    _log.warning("AccessLevels: Access level with name " + name + " is using reserved user access level " + 0 + ". Ignoring it!");
                    continue;
                }
                if (accessLevel == _masterAccessLevelNum) {
                    _log.warning("AccessLevels: Access level with name " + name + " is using reserved master access level " + _masterAccessLevelNum + ". Ignoring it!");
                    continue;
                }
                if (accessLevel < 0) {
                    _log.warning("AccessLevels: Access level with name " + name + " is using banned access level state(below 0). Ignoring it!");
                    continue;
                }
                try {
                    nameColor = Integer.decode("0x" + rset.getString("nameColor"));
                }
                catch (NumberFormatException nfe) {
                    try {
                        nameColor = Integer.decode("0xFFFFFF");
                    }
                    catch (NumberFormatException nfe2) {
                        // empty catch block
                    }
                }
                try {
                    titleColor = Integer.decode("0x" + rset.getString("titleColor"));
                }
                catch (NumberFormatException nfe) {
                    try {
                        titleColor = Integer.decode("0xFFFF77");
                    }
                    catch (NumberFormatException nfe2) {
                        // empty catch block
                    }
                }
                childs = rset.getString("childAccess");
                isGm = rset.getBoolean("isGm");
                allowPeaceAttack = rset.getBoolean("allowPeaceAttack");
                allowFixedRes = rset.getBoolean("allowFixedRes");
                allowTransaction = rset.getBoolean("allowTransaction");
                allowAltG = rset.getBoolean("allowAltg");
                giveDamage = rset.getBoolean("giveDamage");
                takeAggro = rset.getBoolean("takeAggro");
                gainExp = rset.getBoolean("gainExp");
                this._accessLevels.put(accessLevel, (Object)new L2AccessLevel(accessLevel, name, nameColor, titleColor, childs.isEmpty() ? null : childs, isGm, allowPeaceAttack, allowFixedRes, allowTransaction, allowAltG, giveDamage, takeAggro, gainExp));
            }
            rset.close();
            stmt.close();
        }
        catch (SQLException e) {
            _log.log(Level.WARNING, "AccessLevels: Error loading from database:" + e.getMessage(), e);
        }
        finally {
            L2DatabaseFactory.close(con);
        }
        _log.info("AccessLevels: Loaded " + this._accessLevels.size() + " from database.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public L2AccessLevel getAccessLevel(int accessLevelNum) {
        L2AccessLevel accessLevel = null;
        TIntObjectHashMap<L2AccessLevel> tIntObjectHashMap = this._accessLevels;
        synchronized (tIntObjectHashMap) {
            accessLevel = (L2AccessLevel)this._accessLevels.get(accessLevelNum);
        }
        return accessLevel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBanAccessLevel(int accessLevel) {
        TIntObjectHashMap<L2AccessLevel> tIntObjectHashMap = this._accessLevels;
        synchronized (tIntObjectHashMap) {
            if (accessLevel > -1) {
                return;
            }
            this._accessLevels.put(accessLevel, (Object)new L2AccessLevel(accessLevel, "Banned", -1, -1, null, false, false, false, false, false, false, false, false));
        }
    }

    public void reloadAccessLevels() {
        this.loadAccessLevels();
    }

    private static class SingletonHolder {
        protected static final AccessLevels _instance = new AccessLevels();

        private SingletonHolder() {
        }
    }
}

