/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor.instance;

import com.l2jserver.gameserver.MonsterRace;
import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.idfactory.IdFactory;
import com.l2jserver.gameserver.model.L2ItemInstance;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.knownlist.RaceManagerKnownList;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.ActionFailed;
import com.l2jserver.gameserver.network.serverpackets.DeleteObject;
import com.l2jserver.gameserver.network.serverpackets.InventoryUpdate;
import com.l2jserver.gameserver.network.serverpackets.L2GameServerPacket;
import com.l2jserver.gameserver.network.serverpackets.MonRaceInfo;
import com.l2jserver.gameserver.network.serverpackets.NpcHtmlMessage;
import com.l2jserver.gameserver.network.serverpackets.PlaySound;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.templates.chars.L2NpcTemplate;
import com.l2jserver.gameserver.util.Broadcast;
import java.util.List;
import javolution.util.FastList;

public class L2RaceManagerInstance
extends L2Npc {
    public static final int LANES = 8;
    public static final int WINDOW_START = 0;
    private static List<Race> _history;
    private static List<L2RaceManagerInstance> _managers;
    protected static int _raceNumber;
    private static final long SECOND = 1000L;
    private static final long MINUTE = 60000L;
    private static int _minutes;
    private static final int ACCEPTING_BETS = 0;
    private static final int WAITING = 1;
    private static final int STARTING_RACE = 2;
    private static final int RACE_END = 3;
    private static int _state;
    protected static final int[][] _codes;
    private static boolean _notInitialized;
    protected static MonRaceInfo _packet;
    protected static final int[] _cost;

    public L2RaceManagerInstance(int objectId, L2NpcTemplate template) {
        super(objectId, template);
        this.setInstanceType(L2Object.InstanceType.L2RaceManagerInstance);
        if (_notInitialized) {
            _notInitialized = false;
            _history = new FastList();
            _managers = new FastList();
            ThreadPoolManager s = ThreadPoolManager.getInstance();
            s.scheduleGeneralAtFixedRate(new Announcement(SystemMessageId.MONSRACE_TICKETS_AVAILABLE_FOR_S1_RACE), 0L, 600000L);
            s.scheduleGeneralAtFixedRate(new Announcement(SystemMessageId.MONSRACE_TICKETS_NOW_AVAILABLE_FOR_S1_RACE), 30000L, 600000L);
            s.scheduleGeneralAtFixedRate(new Announcement(SystemMessageId.MONSRACE_TICKETS_AVAILABLE_FOR_S1_RACE), 60000L, 600000L);
            s.scheduleGeneralAtFixedRate(new Announcement(SystemMessageId.MONSRACE_TICKETS_NOW_AVAILABLE_FOR_S1_RACE), 90000L, 600000L);
            s.scheduleGeneralAtFixedRate(new Announcement(SystemMessageId.MONSRACE_TICKETS_STOP_IN_S1_MINUTES), 120000L, 600000L);
            s.scheduleGeneralAtFixedRate(new Announcement(SystemMessageId.MONSRACE_TICKETS_STOP_IN_S1_MINUTES), 180000L, 600000L);
            s.scheduleGeneralAtFixedRate(new Announcement(SystemMessageId.MONSRACE_TICKETS_STOP_IN_S1_MINUTES), 240000L, 600000L);
            s.scheduleGeneralAtFixedRate(new Announcement(SystemMessageId.MONSRACE_TICKETS_STOP_IN_S1_MINUTES), 300000L, 600000L);
            s.scheduleGeneralAtFixedRate(new Announcement(SystemMessageId.MONSRACE_TICKETS_STOP_IN_S1_MINUTES), 360000L, 600000L);
            s.scheduleGeneralAtFixedRate(new Announcement(SystemMessageId.MONSRACE_S1_TICKET_SALES_CLOSED), 420000L, 600000L);
            s.scheduleGeneralAtFixedRate(new Announcement(SystemMessageId.MONSRACE_S2_BEGINS_IN_S1_MINUTES), 420000L, 600000L);
            s.scheduleGeneralAtFixedRate(new Announcement(SystemMessageId.MONSRACE_S2_BEGINS_IN_S1_MINUTES), 480000L, 600000L);
            s.scheduleGeneralAtFixedRate(new Announcement(SystemMessageId.MONSRACE_S1_BEGINS_IN_30_SECONDS), 510000L, 600000L);
            s.scheduleGeneralAtFixedRate(new Announcement(SystemMessageId.MONSRACE_S1_COUNTDOWN_IN_FIVE_SECONDS), 530000L, 600000L);
            s.scheduleGeneralAtFixedRate(new Announcement(SystemMessageId.MONSRACE_BEGINS_IN_S1_SECONDS), 535000L, 600000L);
            s.scheduleGeneralAtFixedRate(new Announcement(SystemMessageId.MONSRACE_BEGINS_IN_S1_SECONDS), 536000L, 600000L);
            s.scheduleGeneralAtFixedRate(new Announcement(SystemMessageId.MONSRACE_BEGINS_IN_S1_SECONDS), 537000L, 600000L);
            s.scheduleGeneralAtFixedRate(new Announcement(SystemMessageId.MONSRACE_BEGINS_IN_S1_SECONDS), 538000L, 600000L);
            s.scheduleGeneralAtFixedRate(new Announcement(SystemMessageId.MONSRACE_BEGINS_IN_S1_SECONDS), 539000L, 600000L);
            s.scheduleGeneralAtFixedRate(new Announcement(SystemMessageId.MONSRACE_RACE_START), 540000L, 600000L);
        }
        _managers.add(this);
    }

    @Override
    public final RaceManagerKnownList getKnownList() {
        return (RaceManagerKnownList)super.getKnownList();
    }

    @Override
    public void initKnownList() {
        this.setKnownList(new RaceManagerKnownList(this));
    }

    public void makeAnnouncement(SystemMessageId type) {
        SystemMessage sm = new SystemMessage(type);
        switch (type.getId()) {
            case 816: 
            case 817: {
                if (_state != 0) {
                    _state = 0;
                    this.startRace();
                }
                sm.addNumber(_raceNumber);
                break;
            }
            case 818: 
            case 820: 
            case 823: {
                sm.addNumber(_minutes);
                sm.addNumber(_raceNumber);
                --_minutes;
                break;
            }
            case 819: {
                sm.addNumber(_raceNumber);
                _state = 1;
                _minutes = 2;
                break;
            }
            case 821: 
            case 822: 
            case 825: {
                sm.addNumber(_raceNumber);
                _minutes = 5;
                break;
            }
            case 826: {
                _state = 3;
                sm.addNumber(MonsterRace.getInstance().getFirstPlace());
                sm.addNumber(MonsterRace.getInstance().getSecondPlace());
            }
        }
        this.broadcast(sm);
        if (type == SystemMessageId.MONSRACE_RACE_START) {
            _state = 2;
            this.startRace();
            _minutes = 5;
        }
    }

    protected void broadcast(L2GameServerPacket pkt) {
        for (L2RaceManagerInstance manager : _managers) {
            if (manager.isDead()) continue;
            Broadcast.toKnownPlayers(manager, pkt);
        }
    }

    public void sendMonsterInfo() {
        this.broadcast(_packet);
    }

    private void startRace() {
        MonsterRace race = MonsterRace.getInstance();
        if (_state == 2) {
            PlaySound SRace = new PlaySound(1, "S_Race", 0, 0, 0, 0, 0);
            this.broadcast(SRace);
            PlaySound SRace2 = new PlaySound(0, "ItemSound2.race_start", 1, 121209259, 12125, 182487, -3559);
            this.broadcast(SRace2);
            _packet = new MonRaceInfo(_codes[1][0], _codes[1][1], race.getMonsters(), race.getSpeeds());
            this.sendMonsterInfo();
            ThreadPoolManager.getInstance().scheduleGeneral(new RunRace(), 5000L);
        } else {
            race.newRace();
            race.newSpeeds();
            _packet = new MonRaceInfo(_codes[0][0], _codes[0][1], race.getMonsters(), race.getSpeeds());
            this.sendMonsterInfo();
        }
    }

    @Override
    public void onBypassFeedback(L2PcInstance player, String command) {
        if (command.startsWith("BuyTicket") && _state != 0) {
            player.sendPacket(new SystemMessage(SystemMessageId.MONSRACE_TICKETS_NOT_AVAILABLE));
            command = "Chat 0";
        }
        if (command.startsWith("ShowOdds") && _state == 0) {
            player.sendPacket(new SystemMessage(SystemMessageId.MONSRACE_NO_PAYOUT_INFO));
            command = "Chat 0";
        }
        if (command.startsWith("BuyTicket")) {
            int val = Integer.parseInt(command.substring(10));
            if (val == 0) {
                player.setRace(0, 0);
                player.setRace(1, 0);
            }
            if (val == 10 && player.getRace(0) == 0 || val == 20 && player.getRace(0) == 0 && player.getRace(1) == 0) {
                val = 0;
            }
            this.showBuyTicket(player, val);
        } else if (command.equals("ShowOdds")) {
            this.showOdds(player);
        } else if (command.equals("ShowInfo")) {
            this.showMonsterInfo(player);
        } else if (!command.equals("calculateWin") && !command.equals("viewHistory")) {
            super.onBypassFeedback(player, command);
        }
    }

    public void showOdds(L2PcInstance player) {
        if (_state == 0) {
            return;
        }
        int npcId = this.getTemplate().npcId;
        NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
        String filename = this.getHtmlPath(npcId, 5);
        html.setFile(player.getHtmlPrefix(), filename);
        for (int i = 0; i < 8; ++i) {
            int n = i + 1;
            String search = "Mob" + n;
            html.replace((CharSequence)search, MonsterRace.getInstance().getMonsters()[i].getTemplate().name);
        }
        html.replace((CharSequence)"1race", _raceNumber);
        html.replace((CharSequence)"%objectId%", this.getObjectId());
        player.sendPacket(html);
        player.sendPacket(ActionFailed.STATIC_PACKET);
    }

    public void showMonsterInfo(L2PcInstance player) {
        int npcId = this.getTemplate().npcId;
        NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
        String filename = this.getHtmlPath(npcId, 6);
        html.setFile(player.getHtmlPrefix(), filename);
        for (int i = 0; i < 8; ++i) {
            int n = i + 1;
            String search = "Mob" + n;
            html.replace((CharSequence)search, MonsterRace.getInstance().getMonsters()[i].getTemplate().name);
        }
        html.replace((CharSequence)"%objectId%", this.getObjectId());
        player.sendPacket(html);
        player.sendPacket(ActionFailed.STATIC_PACKET);
    }

    public void showBuyTicket(L2PcInstance player, int val) {
        if (_state != 0) {
            return;
        }
        int npcId = this.getTemplate().npcId;
        NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
        if (val < 10) {
            String search;
            String filename = this.getHtmlPath(npcId, 2);
            html.setFile(player.getHtmlPrefix(), filename);
            for (int i = 0; i < 8; ++i) {
                int n = i + 1;
                search = "Mob" + n;
                html.replace((CharSequence)search, MonsterRace.getInstance().getMonsters()[i].getTemplate().name);
            }
            search = "No1";
            if (val == 0) {
                html.replace((CharSequence)search, "");
            } else {
                html.replace((CharSequence)search, val);
                player.setRace(0, val);
            }
        } else if (val < 20) {
            if (player.getRace(0) == 0) {
                return;
            }
            String filename = this.getHtmlPath(npcId, 3);
            html.setFile(player.getHtmlPrefix(), filename);
            html.replace((CharSequence)"0place", player.getRace(0));
            String search = "Mob1";
            String replace = MonsterRace.getInstance().getMonsters()[player.getRace((int)0) - 1].getTemplate().name;
            html.replace((CharSequence)search, replace);
            search = "0adena";
            if (val == 10) {
                html.replace((CharSequence)search, "");
            } else {
                html.replace((CharSequence)search, _cost[val - 11]);
                player.setRace(1, val - 10);
            }
        } else if (val == 20) {
            if (player.getRace(0) == 0 || player.getRace(1) == 0) {
                return;
            }
            String filename = this.getHtmlPath(npcId, 4);
            html.setFile(player.getHtmlPrefix(), filename);
            html.replace((CharSequence)"0place", player.getRace(0));
            String search = "Mob1";
            String replace = MonsterRace.getInstance().getMonsters()[player.getRace((int)0) - 1].getTemplate().name;
            html.replace((CharSequence)search, replace);
            search = "0adena";
            int price = _cost[player.getRace(1) - 1];
            html.replace((CharSequence)search, price);
            search = "0tax";
            int tax = 0;
            html.replace((CharSequence)search, tax);
            search = "0total";
            int total = price + tax;
            html.replace((CharSequence)search, total);
        } else {
            if (player.getRace(0) == 0 || player.getRace(1) == 0) {
                return;
            }
            int ticket = player.getRace(0);
            int priceId = player.getRace(1);
            if (!player.reduceAdena("Race", _cost[priceId - 1], this, true)) {
                return;
            }
            player.setRace(0, 0);
            player.setRace(1, 0);
            SystemMessage sm = new SystemMessage(SystemMessageId.ACQUIRED_S1_S2);
            sm.addNumber(_raceNumber);
            sm.addItemName(4443);
            player.sendPacket(sm);
            L2ItemInstance item = new L2ItemInstance(IdFactory.getInstance().getNextId(), 4443);
            item.setCount(1L);
            item.setEnchantLevel(_raceNumber);
            item.setCustomType1(ticket);
            item.setCustomType2(_cost[priceId - 1] / 100);
            player.getInventory().addItem("Race", item, player, this);
            InventoryUpdate iu = new InventoryUpdate();
            iu.addItem(item);
            L2ItemInstance adenaupdate = player.getInventory().getItemByItemId(57);
            iu.addModifiedItem(adenaupdate);
            player.sendPacket(iu);
            return;
        }
        html.replace((CharSequence)"1race", _raceNumber);
        html.replace((CharSequence)"%objectId%", this.getObjectId());
        player.sendPacket(html);
        player.sendPacket(ActionFailed.STATIC_PACKET);
    }

    static {
        _raceNumber = 4;
        _minutes = 5;
        _state = 3;
        _codes = new int[][]{{-1, 0}, {0, 15322}, {13765, -1}};
        _notInitialized = true;
        _cost = new int[]{100, 500, 1000, 5000, 10000, 20000, 50000, 100000};
    }

    class RunEnd
    implements Runnable {
        RunEnd() {
        }

        @Override
        public void run() {
            L2RaceManagerInstance.this.makeAnnouncement(SystemMessageId.MONSRACE_FIRST_PLACE_S1_SECOND_S2);
            L2RaceManagerInstance.this.makeAnnouncement(SystemMessageId.MONSRACE_S1_RACE_END);
            ++_raceNumber;
            DeleteObject obj = null;
            for (int i = 0; i < 8; ++i) {
                obj = new DeleteObject(MonsterRace.getInstance().getMonsters()[i]);
                L2RaceManagerInstance.this.broadcast(obj);
            }
        }
    }

    class RunRace
    implements Runnable {
        RunRace() {
        }

        @Override
        public void run() {
            _packet = new MonRaceInfo(_codes[2][0], _codes[2][1], MonsterRace.getInstance().getMonsters(), MonsterRace.getInstance().getSpeeds());
            L2RaceManagerInstance.this.sendMonsterInfo();
            ThreadPoolManager.getInstance().scheduleGeneral(new RunEnd(), 30000L);
        }
    }

    public class Race {
        private Info[] _info;

        public Race(Info[] pInfo) {
            this._info = pInfo;
        }

        public Info getLaneInfo(int lane) {
            return this._info[lane];
        }

        public class Info {
            private int _id;
            private int _place;
            private int _odds;
            private int _payout;

            public Info(int pId, int pPlace, int pOdds, int pPayout) {
                this._id = pId;
                this._place = pPlace;
                this._odds = pOdds;
                this._payout = pPayout;
            }

            public int getId() {
                return this._id;
            }

            public int getOdds() {
                return this._odds;
            }

            public int getPayout() {
                return this._payout;
            }

            public int getPlace() {
                return this._place;
            }
        }
    }

    class Announcement
    implements Runnable {
        private SystemMessageId _type;

        public Announcement(SystemMessageId pType) {
            this._type = pType;
        }

        @Override
        public void run() {
            L2RaceManagerInstance.this.makeAnnouncement(this._type);
        }
    }
}

