/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.olympiad;

import com.l2jserver.gameserver.datatables.DoorTable;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.util.L2FastList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

class OlympiadStadium {
    private static final Logger _log = Logger.getLogger(OlympiadStadium.class.getName());
    private boolean _freeToUse = true;
    private static DoorTable _doorTable;
    private int[] _coords = new int[3];
    private int[] _doors = new int[2];
    private List<L2PcInstance> _spectators;

    public boolean isFreeToUse() {
        return this._freeToUse;
    }

    public void setStadiaBusy() {
        this._freeToUse = false;
    }

    public void setStadiaFree() {
        this._freeToUse = true;
    }

    public int[] getCoordinates() {
        return this._coords;
    }

    public int[] getDoorID() {
        return this._doors;
    }

    public OlympiadStadium(int x, int y, int z, int d1, int d2) {
        this._coords[0] = x;
        this._coords[1] = y;
        this._coords[2] = z;
        this._doors[0] = d1;
        this._doors[1] = d2;
        this._spectators = new L2FastList().shared();
    }

    public void openDoors() {
        _doorTable = DoorTable.getInstance();
        try {
            _doorTable.getDoor(this.getDoorID()[0]).openMe();
            _doorTable.getDoor(this.getDoorID()[1]).openMe();
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "", e);
        }
    }

    public void closeDoors() {
        _doorTable = DoorTable.getInstance();
        try {
            _doorTable.getDoor(this.getDoorID()[0]).closeMe();
            _doorTable.getDoor(this.getDoorID()[1]).closeMe();
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "", e);
        }
    }

    protected void addSpectator(int id, L2PcInstance spec, boolean storeCoords) {
        spec.enterOlympiadObserverMode(this.getCoordinates()[0] + 1200, this.getCoordinates()[1], this.getCoordinates()[2], id, storeCoords);
        this._spectators.add(spec);
    }

    protected List<L2PcInstance> getSpectators() {
        return this._spectators;
    }

    protected void removeSpectator(L2PcInstance spec) {
        if (this._spectators != null && this._spectators.contains(spec)) {
            this._spectators.remove(spec);
        }
    }
}

