/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.zone.type;

import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.zone.L2ZoneType;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;

public class L2MotherTreeZone
extends L2ZoneType {
    private int _enterMsg;
    private int _leaveMsg;
    private int _mpRegen;
    private int _hpRegen;

    public L2MotherTreeZone(int id) {
        super(id);
    }

    @Override
    public void setParameter(String name, String value) {
        if (name.equals("enterMsgId")) {
            this._enterMsg = Integer.valueOf(value);
        } else if (name.equals("leaveMsgId")) {
            this._leaveMsg = Integer.valueOf(value);
        } else if (name.equals("MpRegenBonus")) {
            this._mpRegen = Integer.valueOf(value);
        } else if (name.equals("HpRegenBonus")) {
            this._hpRegen = Integer.valueOf(value);
        } else {
            super.setParameter(name, value);
        }
    }

    @Override
    protected void onEnter(L2Character character) {
        if (character instanceof L2PcInstance) {
            L2PcInstance player = (L2PcInstance)character;
            player.setInsideZone((byte)3, true);
            if (this._enterMsg != 0) {
                player.sendPacket(new SystemMessage(this._enterMsg));
            }
        }
    }

    @Override
    protected void onExit(L2Character character) {
        if (character instanceof L2PcInstance) {
            L2PcInstance player = (L2PcInstance)character;
            player.setInsideZone((byte)3, false);
            if (this._leaveMsg != 0) {
                player.sendPacket(new SystemMessage(this._leaveMsg));
            }
        }
    }

    @Override
    public void onDieInside(L2Character character) {
    }

    @Override
    public void onReviveInside(L2Character character) {
    }

    public int getMpRegenBonus() {
        return this._mpRegen;
    }

    public int getHpRegenBonus() {
        return this._hpRegen;
    }
}

