/*
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program. If not, see <http://www.gnu.org/licenses/>.
 */
package events.SquashEvent;

import com.l2jserver.gameserver.instancemanager.QuestManager;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.L2Skill;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2MonsterInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.quest.Quest;
import com.l2jserver.gameserver.model.quest.QuestState;
import com.l2jserver.gameserver.network.clientpackets.Say2;
import com.l2jserver.gameserver.network.serverpackets.CreatureSay;
import com.l2jserver.util.Rnd;

/**
 * @author Gnacik
 * @version 1.0
 * @see Warning! Mostly that event is custom!
 */
public class SquashEvent extends Quest
{
	private static final int MANAGER = 31860;

	private static final int NECTAR_SKILL = 2005;

	private static final int[] CHRONO_LIST = {
		4202,5133,5817,7058,8350
	};

	private static final int[] SQUASH_LIST = {
		12774,12775,12776,
		12777,12778,12779,
		13016,13017
	};

	private static final String[] SPAWN_TEXT = {
		"ttbAĂ񂾂H",
		"AMălN^[Ă݂ȁI",
		"Ă񂾂HŉĂ񂾂񂾁HႦƂłv̂H",
		"EPPPbA悭ĂÁׂ`B_H͉mȂ`B",
		"|i̓lN^[ƃAi^̈ň炿܂I",
		"̂܂܂ƃA^VA܂ꂽӖA邵Ȃ̂ˁB߂DDD",
		"GbwIAo܂IdĂ݂II",
		"AĂĂ݂I肭Α哖A_nY`I",
	};

	private static final String[] NOCHRONO_TEXT = {
		"lȁISŉÎIII",
		"ǂUBłnG|B",
		"͂oĂ݂`BȂ񂶂ቴAAႤH",
		"̒x̗͂ŉ낤ƌ̂H",
		"悭IA邩`B",
		"قAƉĂ݂IƉĂ݂I",
		"HȂȂ邶ˁ`I",
		"ȂĂ݂I",
		"ĂȂAP疜Afi邼IDDDĂ邩H",
	//	"You cannot kill me without Chrono",
	//	"Hehe...keep trying...",
	//	"Nice try...",
	//	"Tired ?",
	//	"Go go ! haha..."
	};

	private static final String[] CHRONO_TEXT = {
		"mbĂȁII",
		"`DDDȂăXeLȃn[j[A`",
		"񂤂`BƕĂłˁ`",
		"Iς肱̉łȂƂˁI",
		"킟IƂĂXeLȉF`II",
		"C`AĂI",
		"`̂YYĊꂻI",
		"AǂFˁI",
		"[I|i`II",
		"AȁH",
		"f炵TEhȁI",
		"A̘aIōIƕĂI",
		"Nm̃TEhɎ䂩邱̐SI",
		"y͗ǂÂȁB̂Ă낤H",
		"˂A˂Aȉ̂ĂH",
		"ꂾĨTEh񂾁IOA~[WVɂȂĂ݂ȂH",
		"aƍ킹Ă݂II",
		"`ÂYYĂI",
		"A^VƂ̎voA؂ɂĂˁ`B",
		"ĤH{CŉȁI",
	//	"Arghh... Chrono weapon...",
	//	"My end is coming...",
	//	"Please leave me !",
	//	"Heeellpppp...",
	//	"Somebody help me please..."
	};
	private static final String[] NECTAR_TEXT = {
		"ƂIƗ~񂾁II",
		"IȂIAInĂ炩Ă̂H",
		"IƂIڂĂ邶ȂI",
		"Aǂ`BƂB񂾂ǂȂĂ`B",
		"I傫ȂAȂI",
		"Aʂ̂ƍlĂłHȂ񂶂AAi^̈̓A^Vɓ`ĂȂ́IƈāI",
		"Ai^̈Ȃ́IꂶAA^VނႤI",
		"DDDM̂Sg삯́I",
		"ƂAAi^̈Ă̒x̂̂Ȃ́`H",
		"Â܂܎񂶂܂ACe͏oȂ񂾂IȂɃlN^[ܑ̖̂H",
		"͂lN^[́A|ĩlN^[ōIEwwwI",
		"llAĉ`BlN^[߂Ɏł܂ȂĐn`B",
		"AꐅŔ߂̂H̖́H",
		"EFbAybybÍIꂪ{ɃlN^[Ƃ̂H",
	//	"Yummy... Nectar...",
	//	"Plase give me more...",
	//	"Hmmm.. More.. I need more...",
	//	"I will like you more if you give me more...",
	//	"Hmmmmmmm...",
	//	"My favourite..."
	};

	private static final int[][] DROPLIST =
	{
		// must be sorted by npcId !
		// npcId, itemId, chance
		// Young Squash
		{ 12774,  1060, 100 },	// Lesser Healing potion
		{ 12774,  1062,  50 },	// Haste potion
		// High Quality Squash
		{ 12775,  1539, 100 },	// Greater Healing potion
		{ 12775,  1375,  70 },	// Greater Swift Attack Potion
		{ 12775,  1459,  50 },	// Crystal c-grade
		// Low Quality Squash
		{ 12776,  1061, 100 },	// Healing potion
		{ 12776,  1062,  70 },	// Haste potion
		{ 12776,  1458,  50 },	// Crystal d-grade

		// Large Young Squash
		{ 12777,  1061, 100 },	// Healing potion
		{ 12777,  1374,  50 },	// Greater Haste potion
		// High Quality Large
		{ 12778,  1539, 100 },	// Greater Healing potion
		{ 12778,  6036,  70 },	// Greater Magic Haste Potion
		{ 12778,  1459,  40 },	// Crystal c-grade
		// Low Quality Large
		{ 12779,  6035,  70 },	// Magic Haste Potion
		{ 12779,  1458,  50 },	// Crystal d-grade

		// King
		{ 13016,  1540, 100 },	// Quick Healing Potion
		{ 13016,  1460,  40 },	// Crystal b-grade
		{ 13016,  5234,  20 },	// Mystery Potion
		// Emperor
		{ 13017,  1540, 100 },	// Quick Healing Potion
		{ 13017, 20004,  40 },	// Energy Ginseng
		{ 13017,  1461,  20 },	// Crystal a-grade
		{ 13017,  5234,  10 }	// Mystery Potion
	};

	@Override
	public String onAttack(L2Npc npc, L2PcInstance attacker, int damage, boolean isPet)
	{
		switch (npc.getNpcId())
		{
			case 12774:
			case 12775:
			case 12776:
			case 13016:
				if (isChronoAttack(npc, attacker, damage, isPet))
					chronoText(npc);
				else
					noChronoText(npc);
				break;
			case 12777:
			case 12778:
			case 12779:
			case 13017:
				if (isChronoAttack(npc, attacker, damage, isPet))
				{
					chronoText(npc);
					npc.setIsInvul(false);
				//	npc.getStatus().reduceHp(10, attacker);
				}
				else
				{
					noChronoText(npc);
					npc.setIsInvul(true);
					npc.setCurrentHp(npc.getMaxHp());
				}
				break;
		}
		return super.onAttack(npc, attacker, damage, isPet);
	}
	private boolean isChronoAttack(L2Npc npc, L2PcInstance attacker, int damage, boolean isPet)
	{
		if (isPet)
			return false;
		return attacker.getActiveWeaponItem() != null && contains(CHRONO_LIST, attacker.getActiveWeaponItem().getItemId());
	}

	@Override
	public String onSkillSee(L2Npc npc, L2PcInstance caster, L2Skill skill, L2Object[] targets, boolean isPet)
	{
		if (skill.getId() == NECTAR_SKILL && targets[0] == npc)
	//	if (contains(targets,npc) && contains(SQUASH_LIST,npc.getNpcId()) && (skill.getId() == NECTAR_SKILL))
		{
			switch(npc.getNpcId())
			{
				case 12774:
					randomSpawn(12775, 12776, npc, true);
					break;
				case 12777:
					randomSpawn(12778, 12779, npc, true);
					break;
				case 12775:
					randomSpawn(13016, npc, true);
					break;
				case 12778:
					randomSpawn(13017, npc, true);
					break;
			}
		}
		return super.onSkillSee(npc,caster,skill,targets,isPet);
	}

	@Override
	public String onKill(L2Npc npc, L2PcInstance killer, boolean isPet)
	{
		switch(npc.getNpcId())
		{
			case 12774:
			case 12775:
			case 12777:
			case 12778:
				npc.broadcastPacket(new CreatureSay(npc.getObjectId(), Say2.ALL, npc.getName(), "哖FII"));
				break;
			case 12776:
			case 12779:
				npc.broadcastPacket(new CreatureSay(npc.getObjectId(), Say2.ALL, npc.getName(), "S~oI"));
				break;
			case 13016:
			case 13017:
				npc.broadcastPacket(new CreatureSay(npc.getObjectId(), Say2.ALL, npc.getName(), "`A悩́`IȂ́`Ał܂]邱Ƃł邩ȁHƂĂꂠˁB"));
				break;
		}
		dropItem(npc, killer);
		return super.onKill(npc, killer, isPet);
	}

	@Override
	public String onSpawn(L2Npc npc)
	{
		npc.setIsImmobilized(true);
		npc.disableCoreAI(true);
		npc.getStatus().stopHpMpRegeneration();
		((L2MonsterInstance)npc).setOnKillDelay(500);	//Default 5000ms.
		switch(npc.getNpcId())
		{
			case 12774:
			case 12777:
				npc.broadcastPacket(new CreatureSay(npc.getObjectId(), Say2.ALL, npc.getName(), SPAWN_TEXT[Rnd.get(SPAWN_TEXT.length)]));
		}
		return null;
		// return super.onSpawn(npc);
	}

	private static final void dropItem(L2Npc mob, L2PcInstance player)
	{
		final int npcId = mob.getNpcId();
		final int chance = Rnd.get(100);
		for (int i = 0; i < DROPLIST.length; i++)
		{
			int[] drop = DROPLIST[i];
			if (npcId == drop[0])
			{
				if (chance < drop[2])
				{
					if (drop[1] > 20000)
						((L2MonsterInstance)mob).dropItem(player, drop[1], 2);
					else
						((L2MonsterInstance)mob).dropItem(player, drop[1], Rnd.get(2, 6));
					continue;
				}
			}
			if (npcId < drop[0])
				return; // not found
		}
	}

	private void randomSpawn(int lower, int higher, L2Npc npc, boolean delete)
	{
		int _random = Rnd.get(100);
		if (_random < 10)				// 0..9 = 10% ǎ
			spawnNext(lower, npc);
		else if (_random < 30)			// 10..29 = 20% sǂ
			spawnNext(higher, npc);
		else							// 30..99 = 70% 
			nectarText(npc);
	}

	private void randomSpawn(int npcId, L2Npc npc, boolean delete)
	{
		if (Rnd.get(100) < 10)
			spawnNext(npcId, npc);		// 0..9 = 10% ǎ
		else
			nectarText(npc);
	}

	private void chronoText(L2Npc npc)
	{
		if (Rnd.get(100) < 20)
			npc.broadcastPacket(new CreatureSay(npc.getObjectId(), Say2.ALL, npc.getName(), CHRONO_TEXT[Rnd.get(CHRONO_TEXT.length)]));
	}
	private void noChronoText(L2Npc npc)
	{
		if (Rnd.get(100) < 20)
			npc.broadcastPacket(new CreatureSay(npc.getObjectId(), Say2.ALL, npc.getName(), NOCHRONO_TEXT[Rnd.get(NOCHRONO_TEXT.length)]));
	}
	private void nectarText(L2Npc npc)
	{
	/*	if (Rnd.get(100) < 30)	*/
			npc.broadcastPacket(new CreatureSay(npc.getObjectId(), Say2.ALL, npc.getName(), NECTAR_TEXT[Rnd.get(NECTAR_TEXT.length)]));
	}

	private void spawnNext(int npcId, L2Npc npc)
	{
		addSpawn(npcId, npc.getX(), npc.getY(), npc.getZ(), npc.getHeading(), false, 90000);
		npc.deleteMe();
	}

	public static <T> boolean contains(T[] array, T obj)
	{
		for (int i = 0; i < array.length; i++)
		{
			if (array[i] == obj)
			{
				return true;
			}
		}
		return false;
	}

	public static boolean contains(int[] array, int obj)
	{
		for (int i = 0; i < array.length; i++)
		{
			if (array[i] == obj)
			{
				return true;
			}
		}
		return false;
	}

	public SquashEvent(int questId, String name, String descr)
	{
		super(questId, name, descr);

		for (int mob : SQUASH_LIST)
		{
			addAttackId(mob);
			addKillId(mob);
			addSpawnId(mob);
			addSkillSeeId(mob);
		}

		addStartNpc(MANAGER);
		addFirstTalkId(MANAGER);
		addTalkId(MANAGER);
	}

	@Override
	public String onFirstTalk(L2Npc npc, L2PcInstance player)
	{
		String htmltext = "";
		QuestState st = player.getQuestState(getName());
		if (st == null)
		{
			Quest q = QuestManager.getInstance().getQuest(getName());
			st = q.newQuestState(player);
		}
		switch (npc.getNpcId())
		{
			case MANAGER: return "31860.htm";
		}
		throw new AssertionError();
	}

	@Override
	public String onEvent(String event, QuestState qs)
	{
		// 31860-1.htm
		return event;
	}

	public static void main(String[] args)
	{
		new SquashEvent(-1,"SquashEvent","events");
	}
}