/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.configurator;

import com.l2jserver.configurator.JIPTextField;
import com.l2jserver.i18n.LanguageControl;
import com.l2jserver.images.ImagesTable;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javolution.util.FastList;

public class ConfigUserInterface
extends JFrame
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private JTabbedPane _tabPane = new JTabbedPane();
    private List<ConfigFile> _configs = new FastList();
    private ResourceBundle _bundle;

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            // empty catch block
        }
        final ResourceBundle bundle = ResourceBundle.getBundle("configurator.Configurator", Locale.getDefault(), LanguageControl.INSTANCE);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ConfigUserInterface cui = new ConfigUserInterface(bundle);
                cui.setVisible(true);
            }
        });
    }

    public ConfigUserInterface(ResourceBundle bundle) {
        this.setBundle(bundle);
        try {
            String fontName = bundle.getString("fontName");
            String fontSize = bundle.getString("fontSize");
            Font font = new Font(fontName, 0, Integer.parseInt(fontSize));
            UIDefaults defaultTable = UIManager.getLookAndFeelDefaults();
            for (Object o : defaultTable.keySet()) {
                if (!o.toString().endsWith(".font")) continue;
                UIManager.put(o, font);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        this.setTitle(bundle.getString("toolName"));
        this.setDefaultCloseOperation(3);
        this.setSize(750, 500);
        this.setLayout(new GridBagLayout());
        GridBagConstraints cons = new GridBagConstraints();
        cons.fill = 2;
        cons.gridx = 0;
        cons.gridy = 0;
        cons.weighty = 0.0;
        cons.weightx = 1.0;
        JMenuBar menubar = new JMenuBar();
        JMenu fileMenu = new JMenu(bundle.getString("fileMenu"));
        JMenu helpMenu = new JMenu(bundle.getString("helpMenu"));
        JMenuItem exitItem = new JMenuItem(bundle.getString("exitItem"));
        exitItem.setActionCommand("exit");
        exitItem.addActionListener(this);
        fileMenu.add(exitItem);
        JMenuItem aboutItem = new JMenuItem(bundle.getString("aboutItem"));
        aboutItem.setActionCommand("about");
        aboutItem.addActionListener(this);
        helpMenu.add(aboutItem);
        menubar.add(fileMenu);
        menubar.add(helpMenu);
        this.setJMenuBar(menubar);
        JToolBar toolBar = new JToolBar();
        toolBar.setFloatable(false);
        toolBar.setRollover(true);
        toolBar.add(this.createToolButton("disk.png", bundle.getString("save"), "save"));
        this.add((Component)toolBar, cons);
        ++cons.gridy;
        cons.fill = 1;
        cons.weighty = 1.0;
        this.loadConfigs();
        this.buildInterface();
        this.add((Component)this._tabPane, cons);
    }

    private JButton createToolButton(String image, String text, String action) {
        JButton button = new JButton(text, ImagesTable.getImage(image));
        button.setActionCommand(action);
        button.addActionListener(this);
        return button;
    }

    private void buildInterface() {
        ToolTipManager.sharedInstance().setDismissDelay(Integer.MAX_VALUE);
        ToolTipManager.sharedInstance().setInitialDelay(0);
        ToolTipManager.sharedInstance().setReshowDelay(0);
        GridBagConstraints cons = new GridBagConstraints();
        cons.fill = 0;
        cons.anchor = 23;
        cons.insets = new Insets(2, 2, 2, 2);
        for (ConfigFile cf : this.getConfigs()) {
            JPanel panel = new JPanel(){

                @Override
                public void scrollRectToVisible(Rectangle r) {
                }
            };
            panel.setLayout(new GridBagLayout());
            cons.gridy = 0;
            cons.weighty = 0.0;
            for (ConfigFile.ConfigComment cc : cf.getConfigProperties()) {
                if (!(cc instanceof ConfigFile.ConfigProperty)) continue;
                ConfigFile.ConfigProperty cp = (ConfigFile.ConfigProperty)cc;
                cons.gridx = 0;
                JLabel keyLabel = new JLabel(cp.getDisplayName() + ':', ImagesTable.getImage("help.png"), 2);
                String comments = "<b>" + cp.getName() + ":</b><br>" + cp.getComments();
                comments = comments.replace("\r\n", "<br>");
                comments = "<html>" + comments + "</html>";
                keyLabel.setToolTipText(comments);
                cons.weightx = 0.0;
                panel.add((Component)keyLabel, cons);
                ++cons.gridx;
                JComponent valueComponent = cp.getValueComponent();
                valueComponent.setToolTipText(comments);
                cons.weightx = 1.0;
                panel.add((Component)valueComponent, cons);
                ++cons.gridx;
                ++cons.gridy;
            }
            ++cons.gridy;
            cons.weighty = 1.0;
            panel.add((Component)new JLabel(), cons);
            this._tabPane.addTab(cf.getName(), new JScrollPane(panel));
        }
    }

    private void loadConfigs() {
        File configsDir = new File("config");
        for (File file : configsDir.listFiles()) {
            if (!file.getName().endsWith(".properties") || !file.isFile() || !file.canWrite()) continue;
            try {
                this.parsePropertiesFile(file);
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(this, this.getBundle().getString("errorReading") + file.getName(), this.getBundle().getString("error"), 0);
                System.exit(3);
            }
        }
    }

    private void parsePropertiesFile(File file) throws IOException {
        String line;
        LineNumberReader lnr = new LineNumberReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
        StringBuilder commentBuffer = new StringBuilder(256);
        ConfigFile cf = new ConfigFile(file);
        while ((line = lnr.readLine()) != null) {
            if ((line = line.trim()).startsWith("#")) {
                if (commentBuffer.length() > 0) {
                    commentBuffer.append("\r\n");
                }
                commentBuffer.append(line.substring(1));
                continue;
            }
            if (line.length() == 0) {
                if (commentBuffer.length() > 0) {
                    cf.addConfigComment(commentBuffer.toString());
                }
                commentBuffer.setLength(0);
                continue;
            }
            if (line.indexOf(61) < 0) continue;
            String[] kv = line.split("=");
            String key = kv[0].trim();
            String value = "";
            if (kv.length > 1) {
                value = kv[1].trim();
            }
            if (line.indexOf(92) >= 0) {
                while ((line = lnr.readLine()) != null && line.indexOf(92) >= 0) {
                    value = value + "\r\n" + line;
                }
                value = value + "\r\n" + line;
            }
            String comments = commentBuffer.toString();
            commentBuffer.setLength(0);
            cf.addConfigProperty(key, this.parseValue(value), comments);
        }
        this.getConfigs().add(cf);
        lnr.close();
    }

    private Object parseValue(String value) {
        String[] parts;
        if (value.equalsIgnoreCase("false") || value.equalsIgnoreCase("true")) {
            return Boolean.parseBoolean(value);
        }
        if (value.equals("localhost")) {
            value = "127.0.0.1";
        }
        if ((parts = value.split("\\.")).length == 4) {
            boolean ok = true;
            for (int i = 0; i < 4 && ok; ++i) {
                try {
                    int parseInt = Integer.parseInt(parts[i]);
                    if (parseInt >= 0 && parseInt <= 255) continue;
                    ok = false;
                    continue;
                }
                catch (NumberFormatException e) {
                    ok = false;
                }
            }
            if (ok) {
                try {
                    InetAddress address = InetAddress.getByName(value);
                    return address;
                }
                catch (UnknownHostException e) {
                    // empty catch block
                }
            }
        }
        return value;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        StringBuilder errors = new StringBuilder(256);
        if (cmd.equals("save")) {
            for (ConfigFile cf : this.getConfigs()) {
                try {
                    cf.save();
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                    errors.append(this.getBundle().getString("errorSaving") + cf.getName()).append(".properties. ").append(this.getBundle().getString("reason") + e1.getLocalizedMessage()).append("\r\n");
                }
            }
            if (errors.length() == 0) {
                JOptionPane.showMessageDialog(this, this.getBundle().getString("success"), "OK", 1);
            } else {
                JOptionPane.showMessageDialog(this, errors, this.getBundle().getString("error"), 0);
                System.exit(2);
            }
        } else if (cmd.equals("exit")) {
            System.exit(0);
        } else if (cmd.equals("about")) {
            JOptionPane.showMessageDialog(this, this.getBundle().getString("credits") + "\nhttp://www.l2jserver.com\n\n" + this.getBundle().getString("icons") + "\n\n" + this.getBundle().getString("language") + '\n' + this.getBundle().getString("translation"), this.getBundle().getString("aboutItem"), 1, ImagesTable.getImage("l2jserverlogo.png"));
        }
    }

    public void setConfigs(List<ConfigFile> configs) {
        this._configs = configs;
    }

    public List<ConfigFile> getConfigs() {
        return this._configs;
    }

    public static String unCamelize(String keyName) {
        Pattern p = Pattern.compile("\\p{Lu}");
        Matcher m = p.matcher(keyName);
        StringBuffer sb = new StringBuffer();
        int last = 0;
        while (m.find()) {
            if (m.start() != last + 1) {
                m.appendReplacement(sb, " " + m.group());
            }
            last = m.start();
        }
        m.appendTail(sb);
        return sb.toString().trim();
    }

    public void setBundle(ResourceBundle bundle) {
        this._bundle = bundle;
    }

    public ResourceBundle getBundle() {
        return this._bundle;
    }

    public static enum ValueType {
        BOOLEAN(Boolean.class),
        DOUBLE(Double.class),
        INTEGER(Integer.class),
        IPv4(Inet4Address.class),
        STRING(String.class);

        private final Class<?> _type;

        private ValueType(Class<?> type) {
            this._type = type;
        }

        public Class<?> getType() {
            return this._type;
        }

        public static ValueType firstTypeMatch(Object value) {
            for (ValueType vt : ValueType.values()) {
                if (vt.getType() != value.getClass()) continue;
                return vt;
            }
            throw new NoSuchElementException("No match for: " + value.getClass().getName());
        }
    }

    static class ConfigFile {
        private File _file;
        private String _name;
        private final List<ConfigComment> _configs = new FastList();

        public ConfigFile(File file) {
            this._file = file;
            int lastIndex = file.getName().lastIndexOf(46);
            this.setName(file.getName().substring(0, lastIndex));
        }

        public void addConfigProperty(String name, Object value, ValueType type, String comments) {
            this._configs.add(new ConfigProperty(name, value, type, comments));
        }

        public void addConfigComment(String comment) {
            this._configs.add(new ConfigComment(comment));
        }

        public void addConfigProperty(String name, Object value, String comments) {
            this.addConfigProperty(name, value, ValueType.firstTypeMatch(value), comments);
        }

        public List<ConfigComment> getConfigProperties() {
            return this._configs;
        }

        public void setName(String name) {
            this._name = name;
        }

        public String getName() {
            return this._name;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void save() throws IOException {
            BufferedWriter bufWriter = null;
            try {
                bufWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this._file), "UTF-8"));
                for (ConfigComment cc : this._configs) {
                    cc.save(bufWriter);
                }
            }
            finally {
                if (bufWriter != null) {
                    bufWriter.close();
                }
            }
        }

        class ConfigProperty
        extends ConfigComment {
            private String _propname;
            private Object _value;
            private ValueType _type;
            private JComponent _component;

            public ConfigProperty(String name, Object value, ValueType type, String comments) {
                super(comments);
                if (!type.getType().isAssignableFrom(value.getClass())) {
                    throw new IllegalArgumentException("Value Instance Type doesn't match the type argument.");
                }
                this._propname = name;
                this._type = type;
                this._value = value;
            }

            public String getName() {
                return this._propname;
            }

            public String getDisplayName() {
                return ConfigUserInterface.unCamelize(this._propname);
            }

            public void setName(String name) {
                this._propname = name;
            }

            public Object getValue() {
                return this._value;
            }

            public void setValue(String value) {
                this._value = value;
            }

            public ValueType getType() {
                return this._type;
            }

            public void setType(ValueType type) {
                this._type = type;
            }

            public JComponent getValueComponent() {
                if (this._component == null) {
                    this._component = this.createValueComponent();
                }
                return this._component;
            }

            public JComponent createValueComponent() {
                switch (this.getType()) {
                    case BOOLEAN: {
                        boolean bool = (Boolean)this.getValue();
                        JCheckBox checkBox = new JCheckBox();
                        checkBox.setSelected(bool);
                        return checkBox;
                    }
                    case IPv4: {
                        return new JIPTextField((Inet4Address)this.getValue());
                    }
                }
                String val = this.getValue().toString();
                JTextArea textArea = new JTextArea(val);
                textArea.setFont(UIManager.getFont("TextField.font"));
                int rows = 1;
                for (int i = 0; i < val.length(); ++i) {
                    if (val.charAt(i) != '\\') continue;
                    ++rows;
                }
                textArea.setRows(rows);
                textArea.setColumns(Math.max(val.length() / rows, 20));
                return textArea;
            }

            @Override
            public void save(Writer writer) throws IOException {
                String value;
                if (this.getValueComponent() instanceof JCheckBox) {
                    value = Boolean.toString(((JCheckBox)this.getValueComponent()).isSelected());
                    value = value.substring(0, 1).toUpperCase() + value.substring(1);
                } else if (this.getValueComponent() instanceof JIPTextField) {
                    value = ((JIPTextField)this.getValueComponent()).getText();
                } else if (this.getValueComponent() instanceof JTextArea) {
                    value = ((JTextArea)this.getValueComponent()).getText();
                } else {
                    throw new IllegalStateException("Unhandled component value");
                }
                StringBuilder sb = new StringBuilder(256);
                sb.append('#');
                sb.append(this.getComments().replace("\r\n", "\r\n#"));
                sb.append("\r\n");
                sb.append(this.getName());
                sb.append(" = ");
                sb.append(value);
                sb.append("\r\n\r\n");
                writer.write(sb.toString());
            }
        }

        class ConfigComment {
            private String _comments;

            public ConfigComment(String comments) {
                this._comments = comments;
            }

            public String getComments() {
                return this._comments;
            }

            public void setComments(String comments) {
                this._comments = comments;
            }

            public void save(Writer writer) throws IOException {
                StringBuilder sb = new StringBuilder(256);
                sb.append('#');
                sb.append(this.getComments().replace("\r\n", "\r\n#"));
                sb.append("\r\n\r\n");
                writer.write(sb.toString());
            }
        }
    }
}

