/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.instancemanager;

import com.l2jserver.L2DatabaseFactory;
import com.l2jserver.gameserver.model.entity.Auction;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javolution.util.FastList;

public class AuctionManager {
    protected static final Logger _log = Logger.getLogger(AuctionManager.class.getName());
    private List<Auction> _auctions;
    private static final String[] ITEM_INIT_DATA = new String[]{"(22, 0, 'NPC', 'NPC Clan', 'ClanHall', 22, 0, '\u30e0\u30fc\u30f3\u30b9\u30c8\u30fc\u30f3 \u30db\u30fc\u30eb', 1, 20000000, 0, 1164841200000)", "(23, 0, 'NPC', 'NPC Clan', 'ClanHall', 23, 0, '\u30aa\u30cb\u30ad\u30b9 \u30db\u30fc\u30eb', 1, 20000000, 0, 1164841200000)", "(24, 0, 'NPC', 'NPC Clan', 'ClanHall', 24, 0, '\u30c8\u30d1\u30fc\u30ba \u30db\u30fc\u30eb', 1, 20000000, 0, 1164841200000)", "(25, 0, 'NPC', 'NPC Clan', 'ClanHall', 25, 0, '\u30eb\u30d3\u30fc \u30db\u30fc\u30eb', 1, 20000000, 0, 1164841200000)", "(26, 0, 'NPC', 'NPC Clan', 'ClanHall', 26, 0, '\u30af\u30ea\u30b9\u30bf\u30eb \u30db\u30fc\u30eb', 1, 20000000, 0, 1164841200000)", "(27, 0, 'NPC', 'NPC Clan', 'ClanHall', 27, 0, '\u30aa\u30cb\u30ad\u30b9 \u30db\u30fc\u30eb', 1, 20000000, 0, 1164841200000)", "(28, 0, 'NPC', 'NPC Clan', 'ClanHall', 28, 0, '\u30b5\u30d5\u30a1\u30a4\u30a2 \u30db\u30fc\u30eb', 1, 20000000, 0, 1164841200000)", "(29, 0, 'NPC', 'NPC Clan', 'ClanHall', 29, 0, '\u30e0\u30fc\u30f3\u30b9\u30c8\u30fc\u30f3 \u30db\u30fc\u30eb', 1, 20000000, 0, 1164841200000)", "(30, 0, 'NPC', 'NPC Clan', 'ClanHall', 30, 0, '\u30a8\u30e1\u30e9\u30eb\u30c9 \u30db\u30fc\u30eb', 1, 20000000, 0, 1164841200000)", "(31, 0, 'NPC', 'NPC Clan', 'ClanHall', 31, 0, '\u30d6\u30e9\u30c3\u30af \u30d0\u30e9\u30c3\u30af', 1, 8000000, 0, 1164841200000)", "(32, 0, 'NPC', 'NPC Clan', 'ClanHall', 32, 0, '\u30ec\u30c3\u30c9 \u30d0\u30e9\u30c3\u30af', 1, 8000000, 0, 1164841200000)", "(33, 0, 'NPC', 'NPC Clan', 'ClanHall', 33, 0, '\u30b0\u30ea\u30fc\u30f3 \u30d0\u30e9\u30c3\u30af', 1, 8000000, 0, 1164841200000)", "(36, 0, 'NPC', 'NPC Clan', 'ClanHall', 36, 0, '\u30b4\u30fc\u30eb\u30c7\u30f3 \u30e9\u30a6\u30f3\u30b8', 1, 50000000, 0, 1164841200000)", "(37, 0, 'NPC', 'NPC Clan', 'ClanHall', 37, 0, '\u30b7\u30eb\u30d0\u30fc \u30e9\u30a6\u30f3\u30b8', 1, 50000000, 0, 1164841200000)", "(38, 0, 'NPC', 'NPC Clan', 'ClanHall', 38, 0, '\u30df\u30b9\u30ea\u30eb \u30e9\u30a6\u30f3\u30b8', 1, 50000000, 0, 1164841200000)", "(39, 0, 'NPC', 'NPC Clan', 'ClanHall', 39, 0, '\u30b7\u30eb\u30d0\u30fc \u30cf\u30a6\u30b9', 1, 50000000, 0, 1164841200000)", "(40, 0, 'NPC', 'NPC Clan', 'ClanHall', 40, 0, '\u30b4\u30fc\u30eb\u30c7\u30f3 \u30cf\u30a6\u30b9', 1, 50000000, 0, 1164841200000)", "(41, 0, 'NPC', 'NPC Clan', 'ClanHall', 41, 0, '\u30d6\u30ed\u30f3\u30ba \u30e9\u30a6\u30f3\u30b8', 1, 50000000, 0, 1164841200000)", "(42, 0, 'NPC', 'NPC Clan', 'ClanHall', 42, 0, '\u30b4\u30fc\u30eb\u30c7\u30f3 \u30e9\u30a6\u30f3\u30b8', 1, 50000000, 0, 1164841200000)", "(43, 0, 'NPC', 'NPC Clan', 'ClanHall', 43, 0, '\u30b7\u30eb\u30d0\u30fc \u30e9\u30a6\u30f3\u30b8', 1, 50000000, 0, 1164841200000)", "(44, 0, 'NPC', 'NPC Clan', 'ClanHall', 44, 0, '\u30df\u30b9\u30ea\u30eb \u30e9\u30a6\u30f3\u30b8', 1, 50000000, 0, 1164841200000)", "(45, 0, 'NPC', 'NPC Clan', 'ClanHall', 45, 0, '\u30d6\u30ed\u30f3\u30ba \u30e9\u30a6\u30f3\u30b8', 1, 50000000, 0, 1164841200000)", "(46, 0, 'NPC', 'NPC Clan', 'ClanHall', 46, 0, '\u30b7\u30eb\u30d0\u30fc \u30cf\u30a6\u30b9', 1, 50000000, 0, 1164841200000)", "(47, 0, 'NPC', 'NPC Clan', 'ClanHall', 47, 0, '\u30e0\u30fc\u30f3\u30b9\u30c8\u30fc\u30f3 \u30db\u30fc\u30eb', 1, 50000000, 0, 1164841200000)", "(48, 0, 'NPC', 'NPC Clan', 'ClanHall', 48, 0, '\u30aa\u30cb\u30ad\u30b9 \u30db\u30fc\u30eb', 1, 50000000, 0, 1164841200000)", "(49, 0, 'NPC', 'NPC Clan', 'ClanHall', 49, 0, '\u30a8\u30e1\u30e9\u30eb\u30c9 \u30db\u30fc\u30eb', 1, 50000000, 0, 1164841200000)", "(50, 0, 'NPC', 'NPC Clan', 'ClanHall', 50, 0, '\u30b5\u30d5\u30a1\u30a4\u30a2 \u30db\u30fc\u30eb', 1, 50000000, 0, 1164841200000)", "(51, 0, 'NPC', 'NPC Clan', 'ClanHall', 51, 0, '\u30e2\u30f3\u30c8 \u30e9\u30a6\u30f3\u30b8', 1, 50000000, 0, 1164841200000)", "(52, 0, 'NPC', 'NPC Clan', 'ClanHall', 52, 0, '\u30b7\u30e5\u30c6\u30eb\u30f3 \u30e9\u30a6\u30f3\u30b8', 1, 50000000, 0, 1164841200000)", "(53, 0, 'NPC', 'NPC Clan', 'ClanHall', 53, 0, '\u30f4\u30a7\u30cc\u30b9 \u30e9\u30a6\u30f3\u30b8', 1, 50000000, 0, 1164841200000)", "(54, 0, 'NPC', 'NPC Clan', 'ClanHall', 54, 0, '\u30de\u30eb\u30b9 \u30e9\u30a6\u30f3\u30b8', 1, 50000000, 0, 1164841200000)", "(55, 0, 'NPC', 'NPC Clan', 'ClanHall', 55, 0, '\u30a2\u30c7\u30b9 \u30e9\u30a6\u30f3\u30b8', 1, 50000000, 0, 1164841200000)", "(56, 0, 'NPC', 'NPC Clan', 'ClanHall', 56, 0, '\u30d7\u30eb\u30fc\u30c8 \u30e9\u30a6\u30f3\u30b8', 1, 50000000, 0, 1164841200000)", "(57, 0, 'NPC', 'NPC Clan', 'ClanHall', 57, 0, '\u30c8\u30e9\u30f4\u30a1\u30f3 \u30e9\u30a6\u30f3\u30b8', 1, 50000000, 0, 1164841200000)", "(58, 0, 'NPC', 'NPC Clan', 'ClanHall', 58, 0, '\u30a2\u30a4\u30bc\u30f3 \u30db\u30fc\u30eb', 1, 50000000, 0, 1164841200000)", "(59, 0, 'NPC', 'NPC Clan', 'ClanHall', 59, 0, '\u30d9\u30a2\u30e1\u30bf\u30eb \u30db\u30fc\u30eb', 1, 50000000, 0, 1164841200000)", "(60, 0, 'NPC', 'NPC Clan', 'ClanHall', 60, 0, '\u30d2\u30fc\u30c8\u30e1\u30bf\u30eb \u30db\u30fc\u30eb', 1, 50000000, 0, 1164841200000)", "(61, 0, 'NPC', 'NPC Clan', 'ClanHall', 61, 0, '\u30c1\u30bf\u30f3 \u30db\u30fc\u30eb', 1, 50000000, 0, 1164841200000)"};
    private static final int[] ItemInitDataId = new int[]{22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61};

    public static final AuctionManager getInstance() {
        return SingletonHolder._instance;
    }

    private AuctionManager() {
        _log.info("Initializing AuctionManager");
        this._auctions = new FastList();
        this.load();
    }

    public void reload() {
        this._auctions.clear();
        this.load();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void load() {
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("SELECT id FROM auction ORDER BY id");
            ResultSet rs = statement.executeQuery();
            while (rs.next()) {
                this._auctions.add(new Auction(rs.getInt("id")));
            }
            statement.close();
            _log.info("Loaded: " + this.getAuctions().size() + " auction(s)");
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Exception: AuctionManager.load(): " + e.getMessage(), e);
        }
        finally {
            L2DatabaseFactory.close(con);
        }
    }

    public final Auction getAuction(int auctionId) {
        int index = this.getAuctionIndex(auctionId);
        if (index >= 0) {
            return this.getAuctions().get(index);
        }
        return null;
    }

    public final int getAuctionIndex(int auctionId) {
        for (int i = 0; i < this.getAuctions().size(); ++i) {
            Auction auction = this.getAuctions().get(i);
            if (auction == null || auction.getId() != auctionId) continue;
            return i;
        }
        return -1;
    }

    public final List<Auction> getAuctions() {
        return this._auctions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initNPC(int id) {
        int i;
        Connection con = null;
        for (i = 0; i < ItemInitDataId.length && ItemInitDataId[i] != id; ++i) {
        }
        if (i >= ItemInitDataId.length || ItemInitDataId[i] != id) {
            _log.warning("Clan Hall auction not found for Id :" + id);
            return;
        }
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("INSERT INTO `auction` VALUES " + ITEM_INIT_DATA[i]);
            statement.execute();
            statement.close();
            this._auctions.add(new Auction(id));
            _log.info("Created auction for ClanHall: " + id);
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "Exception: Auction.initNPC(): " + e.getMessage(), e);
        }
        finally {
            L2DatabaseFactory.close(con);
        }
    }

    private static class SingletonHolder {
        protected static final AuctionManager _instance = new AuctionManager();

        private SingletonHolder() {
        }
    }
}

