/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor;

import com.l2jserver.gameserver.ai.CtrlIntention;
import com.l2jserver.gameserver.ai.L2CharacterAI;
import com.l2jserver.gameserver.ai.L2SummonAI;
import com.l2jserver.gameserver.datatables.ItemTable;
import com.l2jserver.gameserver.instancemanager.TerritoryWarManager;
import com.l2jserver.gameserver.model.L2ItemInstance;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.L2Party;
import com.l2jserver.gameserver.model.L2Skill;
import com.l2jserver.gameserver.model.L2WorldRegion;
import com.l2jserver.gameserver.model.actor.L2Attackable;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.L2Playable;
import com.l2jserver.gameserver.model.actor.instance.L2DoorInstance;
import com.l2jserver.gameserver.model.actor.instance.L2MerchantSummonInstance;
import com.l2jserver.gameserver.model.actor.instance.L2NpcInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PetInstance;
import com.l2jserver.gameserver.model.actor.instance.L2SummonInstance;
import com.l2jserver.gameserver.model.actor.knownlist.SummonKnownList;
import com.l2jserver.gameserver.model.actor.stat.SummonStat;
import com.l2jserver.gameserver.model.actor.status.SummonStatus;
import com.l2jserver.gameserver.model.base.Experience;
import com.l2jserver.gameserver.model.itemcontainer.PetInventory;
import com.l2jserver.gameserver.model.olympiad.Olympiad;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.AbstractNpcInfo;
import com.l2jserver.gameserver.network.serverpackets.ActionFailed;
import com.l2jserver.gameserver.network.serverpackets.ExPartyPetWindowAdd;
import com.l2jserver.gameserver.network.serverpackets.ExPartyPetWindowDelete;
import com.l2jserver.gameserver.network.serverpackets.ExPartyPetWindowUpdate;
import com.l2jserver.gameserver.network.serverpackets.L2GameServerPacket;
import com.l2jserver.gameserver.network.serverpackets.PetDelete;
import com.l2jserver.gameserver.network.serverpackets.PetInfo;
import com.l2jserver.gameserver.network.serverpackets.PetItemList;
import com.l2jserver.gameserver.network.serverpackets.PetStatusUpdate;
import com.l2jserver.gameserver.network.serverpackets.RelationChanged;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.network.serverpackets.TeleportToLocation;
import com.l2jserver.gameserver.taskmanager.DecayTaskManager;
import com.l2jserver.gameserver.templates.chars.L2NpcTemplate;
import com.l2jserver.gameserver.templates.item.L2EtcItem;
import com.l2jserver.gameserver.templates.item.L2Weapon;
import java.util.Collection;

public abstract class L2Summon
extends L2Playable {
    private L2PcInstance _owner;
    private int _attackRange = 36;
    private boolean _follow = true;
    private boolean _previousFollowStatus = true;
    private int _chargedSoulShot;
    private int _chargedSpiritShot;

    public L2Summon(int objectId, L2NpcTemplate template, L2PcInstance owner) {
        super(objectId, template);
        this.setInstanceType(L2Object.InstanceType.L2Summon);
        this.setInstanceId(owner.getInstanceId());
        this._showSummonAnimation = true;
        this._owner = owner;
        this._ai = new L2SummonAI(new AIAccessor());
        this.setXYZInvisible(owner.getX() + 20, owner.getY() + 20, owner.getZ() + 100);
    }

    @Override
    public void onSpawn() {
        super.onSpawn();
        if (!(this instanceof L2MerchantSummonInstance)) {
            this.setFollowStatus(true);
            this.updateAndBroadcastStatus(0);
            this.getOwner().sendPacket(new RelationChanged(this, this.getOwner().getRelation(this.getOwner()), false));
            for (L2PcInstance player : this.getOwner().getKnownList().getKnownPlayersInRadius(800L)) {
                player.sendPacket(new RelationChanged(this, this.getOwner().getRelation(player), this.isAutoAttackable(player)));
            }
            L2Party party = this.getOwner().getParty();
            if (party != null) {
                party.broadcastToPartyMembers(this.getOwner(), new ExPartyPetWindowAdd(this));
            }
        }
        this.setShowSummonAnimation(false);
    }

    @Override
    public final SummonKnownList getKnownList() {
        return (SummonKnownList)super.getKnownList();
    }

    @Override
    public void initKnownList() {
        this.setKnownList(new SummonKnownList(this));
    }

    @Override
    public SummonStat getStat() {
        return (SummonStat)super.getStat();
    }

    @Override
    public void initCharStat() {
        this.setStat(new SummonStat(this));
    }

    @Override
    public SummonStatus getStatus() {
        return (SummonStatus)super.getStatus();
    }

    @Override
    public void initCharStatus() {
        this.setStatus(new SummonStatus(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public L2CharacterAI getAI() {
        L2CharacterAI ai = this._ai;
        if (ai == null) {
            L2Summon l2Summon = this;
            synchronized (l2Summon) {
                if (this._ai == null) {
                    this._ai = new L2SummonAI(new AIAccessor());
                }
                return this._ai;
            }
        }
        return ai;
    }

    @Override
    public L2NpcTemplate getTemplate() {
        return (L2NpcTemplate)super.getTemplate();
    }

    public abstract int getSummonType();

    @Override
    public final void stopAllEffects() {
        super.stopAllEffects();
        this.updateAndBroadcastStatus(1);
    }

    @Override
    public final void stopAllEffectsExceptThoseThatLastThroughDeath() {
        super.stopAllEffectsExceptThoseThatLastThroughDeath();
        this.updateAndBroadcastStatus(1);
    }

    @Override
    public void updateAbnormalEffect() {
        Collection<L2PcInstance> plrs = this.getKnownList().getKnownPlayers().values();
        for (L2PcInstance player : plrs) {
            player.sendPacket(new AbstractNpcInfo.SummonInfo(this, player, 1));
        }
    }

    public boolean isMountable() {
        return false;
    }

    public long getExpForThisLevel() {
        if (this.getLevel() >= Experience.LEVEL.length) {
            return 0L;
        }
        return Experience.LEVEL[this.getLevel()];
    }

    public long getExpForNextLevel() {
        if (this.getLevel() >= Experience.LEVEL.length - 1) {
            return 0L;
        }
        return Experience.LEVEL[this.getLevel() + 1];
    }

    public final int getKarma() {
        return this.getOwner() != null ? this.getOwner().getKarma() : 0;
    }

    public final byte getPvpFlag() {
        return this.getOwner() != null ? this.getOwner().getPvpFlag() : (byte)0;
    }

    public final int getTeam() {
        return this.getOwner() != null ? this.getOwner().getTeam() : 0;
    }

    public final L2PcInstance getOwner() {
        return this._owner;
    }

    public final int getNpcId() {
        return this.getTemplate().npcId;
    }

    public int getMaxLoad() {
        return 0;
    }

    public short getSoulShotsPerHit() {
        if (this.getTemplate().getAIDataStatic().getSoulShot() > 0) {
            return (short)this.getTemplate().getAIDataStatic().getSoulShot();
        }
        return 1;
    }

    public short getSpiritShotsPerHit() {
        if (this.getTemplate().getAIDataStatic().getSpiritShot() > 0) {
            return (short)this.getTemplate().getAIDataStatic().getSpiritShot();
        }
        return 1;
    }

    public void setChargedSoulShot(int shotType) {
        this._chargedSoulShot = shotType;
    }

    public void setChargedSpiritShot(int shotType) {
        this._chargedSpiritShot = shotType;
    }

    public void followOwner() {
        this.setFollowStatus(true);
    }

    @Override
    public boolean doDie(L2Character killer) {
        if (!super.doDie(killer)) {
            return false;
        }
        if (this instanceof L2MerchantSummonInstance) {
            return true;
        }
        L2PcInstance owner = this.getOwner();
        if (owner != null) {
            Collection<L2Character> KnownTarget = this.getKnownList().getKnownCharacters();
            for (L2Character TgMob : KnownTarget) {
                L2Attackable.AggroInfo info;
                if (!(TgMob instanceof L2Attackable) || ((L2Attackable)TgMob).isDead() || (info = (L2Attackable.AggroInfo)((L2Attackable)TgMob).getAggroList().get((Object)this)) == null) continue;
                ((L2Attackable)TgMob).addDamageHate(owner, info.getDamage(), info.getHate());
            }
        }
        if (this.isPhoenixBlessed() && this.getOwner() != null) {
            this.getOwner().reviveRequest(this.getOwner(), null, true);
        }
        DecayTaskManager.getInstance().addDecayTask(this);
        return true;
    }

    public boolean doDie(L2Character killer, boolean decayed) {
        if (!super.doDie(killer)) {
            return false;
        }
        if (!decayed) {
            DecayTaskManager.getInstance().addDecayTask(this);
        }
        return true;
    }

    public void stopDecay() {
        DecayTaskManager.getInstance().cancelDecayTask(this);
    }

    @Override
    public void onDecay() {
        this.deleteMe(this._owner);
    }

    @Override
    public void broadcastStatusUpdate() {
        super.broadcastStatusUpdate();
        this.updateAndBroadcastStatus(1);
    }

    public void deleteMe(L2PcInstance owner) {
        owner.sendPacket(new PetDelete(this.getSummonType(), this.getObjectId()));
        if (this.getInventory() != null) {
            this.getInventory().destroyAllItems("pet deleted", this.getOwner(), this);
        }
        this.decayMe();
        this.getKnownList().removeAllKnownObjects();
        owner.setPet(null);
        super.deleteMe();
    }

    public void unSummon(L2PcInstance owner) {
        if (this.isVisible() && !this.isDead()) {
            this.getAI().stopFollow();
            owner.sendPacket(new PetDelete(this.getSummonType(), this.getObjectId()));
            L2Party party = owner.getParty();
            if (party != null) {
                party.broadcastToPartyMembers(owner, new ExPartyPetWindowDelete(this));
            }
            this.store();
            this.giveAllToOwner();
            owner.setPet(null);
            if (this.hasAI()) {
                this.getAI().stopAITask();
            }
            this.stopAllEffects();
            L2WorldRegion oldRegion = this.getWorldRegion();
            this.decayMe();
            if (oldRegion != null) {
                oldRegion.removeFromZones(this);
            }
            this.getKnownList().removeAllKnownObjects();
            this.setTarget(null);
            for (int itemId : owner.getAutoSoulShot()) {
                String handler = ((L2EtcItem)ItemTable.getInstance().getTemplate(itemId)).getHandlerName();
                if (!handler.contains("Beast")) continue;
                owner.disableAutoShot(itemId);
            }
        }
    }

    public int getAttackRange() {
        return this._attackRange;
    }

    public void setAttackRange(int range) {
        if (range < 36) {
            range = 36;
        }
        this._attackRange = range;
    }

    public void setFollowStatus(boolean state) {
        this._follow = state;
        if (this._follow) {
            this.getAI().setIntention(CtrlIntention.AI_INTENTION_FOLLOW, this.getOwner());
        } else {
            this.getAI().setIntention(CtrlIntention.AI_INTENTION_IDLE, null);
        }
    }

    public boolean getFollowStatus() {
        return this._follow;
    }

    @Override
    public boolean isAutoAttackable(L2Character attacker) {
        return this._owner.isAutoAttackable(attacker);
    }

    public int getChargedSoulShot() {
        return this._chargedSoulShot;
    }

    public int getChargedSpiritShot() {
        return this._chargedSpiritShot;
    }

    public int getControlObjectId() {
        return 0;
    }

    public L2Weapon getActiveWeapon() {
        return null;
    }

    @Override
    public PetInventory getInventory() {
        return null;
    }

    protected void doPickupItem(L2Object object) {
    }

    public void giveAllToOwner() {
    }

    public void store() {
    }

    @Override
    public L2ItemInstance getActiveWeaponInstance() {
        return null;
    }

    @Override
    public L2Weapon getActiveWeaponItem() {
        return null;
    }

    @Override
    public L2ItemInstance getSecondaryWeaponInstance() {
        return null;
    }

    @Override
    public L2Weapon getSecondaryWeaponItem() {
        return null;
    }

    @Override
    public boolean isInvul() {
        return this._isInvul || this._isTeleporting || this.getOwner().isSpawnProtected();
    }

    @Override
    public L2Party getParty() {
        if (this._owner == null) {
            return null;
        }
        return this._owner.getParty();
    }

    @Override
    public boolean isInParty() {
        if (this._owner == null) {
            return false;
        }
        return this._owner.getParty() != null;
    }

    public void useMagic(L2Skill skill, boolean forceUse, boolean dontMove) {
        if (skill == null || this.isDead()) {
            return;
        }
        if (skill.isPassive()) {
            return;
        }
        if (this.isCastingNow()) {
            return;
        }
        this.getOwner().setCurrentPetSkill(skill, forceUse, dontMove);
        L2Object target = null;
        switch (skill.getTargetType()) {
            case TARGET_OWNER_PET: {
                target = this.getOwner();
                break;
            }
            case TARGET_PARTY: 
            case TARGET_AURA: 
            case TARGET_FRONT_AURA: 
            case TARGET_BEHIND_AURA: 
            case TARGET_SELF: {
                target = this;
                break;
            }
            default: {
                target = skill.getFirstOfTargetList(this);
            }
        }
        if (target == null) {
            if (this.getOwner() != null) {
                this.getOwner().sendPacket(new SystemMessage(SystemMessageId.TARGET_CANT_FOUND));
            }
            return;
        }
        if (this.isSkillDisabled(skill)) {
            if (this.getOwner() != null) {
                this.getOwner().sendPacket(new SystemMessage(SystemMessageId.PET_SKILL_CANNOT_BE_USED_RECHARCHING));
            }
            return;
        }
        if (this.getCurrentMp() < (double)(this.getStat().getMpConsume(skill) + this.getStat().getMpInitialConsume(skill))) {
            if (this.getOwner() != null) {
                this.getOwner().sendPacket(new SystemMessage(SystemMessageId.NOT_ENOUGH_MP));
            }
            return;
        }
        if (this.getCurrentHp() <= (double)skill.getHpConsume()) {
            if (this.getOwner() != null) {
                this.getOwner().sendPacket(new SystemMessage(SystemMessageId.NOT_ENOUGH_HP));
            }
            return;
        }
        if (skill.isOffensive()) {
            if (this.isInsidePeaceZone(this, target) && this.getOwner() != null && !this.getOwner().getAccessLevel().allowPeaceAttack()) {
                this.sendPacket(new SystemMessage(SystemMessageId.TARGET_IN_PEACEZONE));
                return;
            }
            if (this.getOwner() != null && this.getOwner().isInOlympiadMode() && !this.getOwner().isOlympiadStart()) {
                this.sendPacket(ActionFailed.STATIC_PACKET);
                return;
            }
            if (target.getActingPlayer() != null && this.getOwner().getSiegeState() > 0 && this.getOwner().isInsideZone((byte)2) && target.getActingPlayer().getSiegeState() == this.getOwner().getSiegeState() && target.getActingPlayer() != this.getOwner() && target.getActingPlayer().getSiegeSide() == this.getOwner().getSiegeSide()) {
                if (TerritoryWarManager.getInstance().isTWInProgress()) {
                    this.sendPacket(new SystemMessage(SystemMessageId.YOU_CANNOT_ATTACK_A_MEMBER_OF_THE_SAME_TERRITORY));
                } else {
                    this.sendPacket(new SystemMessage(SystemMessageId.FORCED_ATTACK_IS_IMPOSSIBLE_AGAINST_SIEGE_SIDE_TEMPORARY_ALLIED_MEMBERS));
                }
                this.sendPacket(ActionFailed.STATIC_PACKET);
                return;
            }
            if (target instanceof L2DoorInstance) {
                if (!((L2DoorInstance)target).isAttackable(this.getOwner())) {
                    return;
                }
            } else {
                if (!target.isAttackable() && this.getOwner() != null && !this.getOwner().getAccessLevel().allowPeaceAttack()) {
                    return;
                }
                if (!target.isAutoAttackable(this) && !forceUse && skill.getTargetType() != L2Skill.SkillTargetType.TARGET_AURA && skill.getTargetType() != L2Skill.SkillTargetType.TARGET_FRONT_AURA && skill.getTargetType() != L2Skill.SkillTargetType.TARGET_BEHIND_AURA && skill.getTargetType() != L2Skill.SkillTargetType.TARGET_CLAN && skill.getTargetType() != L2Skill.SkillTargetType.TARGET_ALLY && skill.getTargetType() != L2Skill.SkillTargetType.TARGET_PARTY && skill.getTargetType() != L2Skill.SkillTargetType.TARGET_SELF) {
                    return;
                }
            }
        }
        this.getAI().setIntention(CtrlIntention.AI_INTENTION_CAST, skill, target);
    }

    @Override
    public void setIsImmobilized(boolean value) {
        super.setIsImmobilized(value);
        if (value) {
            this._previousFollowStatus = this.getFollowStatus();
            if (this._previousFollowStatus) {
                this.setFollowStatus(false);
            }
        } else {
            this.setFollowStatus(this._previousFollowStatus);
        }
    }

    public void setOwner(L2PcInstance newOwner) {
        this._owner = newOwner;
    }

    @Override
    public void sendDamageMessage(L2Character target, int damage, boolean mcrit, boolean pcrit, boolean miss) {
        if (miss || this.getOwner() == null) {
            return;
        }
        if (target.getObjectId() != this.getOwner().getObjectId()) {
            SystemMessage sm;
            if (pcrit || mcrit) {
                if (this instanceof L2SummonInstance) {
                    this.getOwner().sendPacket(new SystemMessage(SystemMessageId.CRITICAL_HIT_BY_SUMMONED_MOB));
                } else {
                    this.getOwner().sendPacket(new SystemMessage(SystemMessageId.CRITICAL_HIT_BY_PET));
                }
            }
            if (this.getOwner().isInOlympiadMode() && target instanceof L2PcInstance && ((L2PcInstance)target).isInOlympiadMode() && ((L2PcInstance)target).getOlympiadGameId() == this.getOwner().getOlympiadGameId()) {
                Olympiad.getInstance().notifyCompetitorDamage(this.getOwner(), damage, this.getOwner().getOlympiadGameId());
            }
            if (target.isInvul() && !(target instanceof L2NpcInstance)) {
                sm = new SystemMessage(SystemMessageId.ATTACK_WAS_BLOCKED);
            } else {
                sm = new SystemMessage(SystemMessageId.C1_GAVE_C2_DAMAGE_OF_S3);
                sm.addNpcName(this);
                sm.addCharName(target);
                sm.addNumber(damage);
            }
            this.getOwner().sendPacket(sm);
        }
    }

    @Override
    public void reduceCurrentHp(double damage, L2Character attacker, L2Skill skill) {
        super.reduceCurrentHp(damage, attacker, skill);
        if (this.getOwner() != null && attacker != null) {
            SystemMessage sm = new SystemMessage(SystemMessageId.C1_RECEIVED_DAMAGE_OF_S3_FROM_C2);
            sm.addNpcName(this);
            sm.addCharName(attacker);
            sm.addNumber((int)damage);
            this.getOwner().sendPacket(sm);
        }
    }

    @Override
    public void doCast(L2Skill skill) {
        L2PcInstance actingPlayer = this.getActingPlayer();
        if (!actingPlayer.checkPvpSkill(this.getTarget(), skill, true) && !actingPlayer.getAccessLevel().allowPeaceAttack()) {
            actingPlayer.sendPacket(new SystemMessage(SystemMessageId.TARGET_IS_INCORRECT));
            actingPlayer.sendPacket(ActionFailed.STATIC_PACKET);
            return;
        }
        super.doCast(skill);
    }

    @Override
    public boolean isInCombat() {
        return this.getOwner().isInCombat();
    }

    @Override
    public L2PcInstance getActingPlayer() {
        return this.getOwner();
    }

    @Override
    public final void broadcastPacket(L2GameServerPacket mov) {
        mov.setInvisible(this.getOwner().getAppearance().getInvisible());
        super.broadcastPacket(mov);
    }

    @Override
    public final void broadcastPacket(L2GameServerPacket mov, int radiusInKnownlist) {
        mov.setInvisible(this.getOwner().getAppearance().getInvisible());
        super.broadcastPacket(mov, radiusInKnownlist);
    }

    public void updateAndBroadcastStatus(int val) {
        L2Party party;
        if (this.getOwner() == null) {
            return;
        }
        this.getOwner().sendPacket(new PetInfo(this, val));
        this.getOwner().sendPacket(new PetStatusUpdate(this));
        if (this.isVisible()) {
            this.broadcastNpcInfo(val);
        }
        if ((party = this.getOwner().getParty()) != null) {
            party.broadcastToPartyMembers(this.getOwner(), new ExPartyPetWindowUpdate(this));
        }
        this.updateEffectIcons(true);
    }

    public void broadcastNpcInfo(int val) {
        Collection<L2PcInstance> plrs = this.getKnownList().getKnownPlayers().values();
        for (L2PcInstance player : plrs) {
            if (player == null || player == this.getOwner() && !(this instanceof L2MerchantSummonInstance)) continue;
            player.sendPacket(new AbstractNpcInfo.SummonInfo(this, player, val));
        }
    }

    public boolean isHungry() {
        return false;
    }

    @Override
    public final boolean isAttackingNow() {
        return this.isInCombat();
    }

    public int getWeapon() {
        return 0;
    }

    public int getArmor() {
        return 0;
    }

    public int getPetSpeed() {
        return this.getTemplate().baseRunSpd;
    }

    @Override
    public void sendInfo(L2PcInstance activeChar) {
        if (activeChar.equals(this.getOwner()) && !(this instanceof L2MerchantSummonInstance)) {
            activeChar.sendPacket(new PetInfo(this, 0));
            this.updateEffectIcons(true);
            if (this instanceof L2PetInstance) {
                activeChar.sendPacket(new PetItemList((L2PetInstance)this));
            }
        } else {
            activeChar.sendPacket(new AbstractNpcInfo.SummonInfo(this, activeChar, 0));
        }
    }

    @Override
    public void onTeleported() {
        super.onTeleported();
        this.getOwner().sendPacket(new TeleportToLocation(this, this.getPosition().getX(), this.getPosition().getY(), this.getPosition().getZ(), this.getPosition().getHeading()));
    }

    @Override
    public String toString() {
        return super.toString() + " Owner: " + this.getOwner();
    }

    public class AIAccessor
    extends L2Character.AIAccessor {
        protected AIAccessor() {
        }

        public L2Summon getSummon() {
            return L2Summon.this;
        }

        public boolean isAutoFollow() {
            return L2Summon.this.getFollowStatus();
        }

        public void doPickupItem(L2Object object) {
            L2Summon.this.doPickupItem(object);
        }
    }
}

