/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor.stat;

import com.l2jserver.Config;
import com.l2jserver.gameserver.model.L2ItemInstance;
import com.l2jserver.gameserver.model.L2Skill;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.skills.Calculator;
import com.l2jserver.gameserver.skills.Env;
import com.l2jserver.gameserver.skills.Stats;
import com.l2jserver.gameserver.templates.item.L2Weapon;
import com.l2jserver.gameserver.templates.item.L2WeaponType;

public class CharStat {
    private L2Character _activeChar;
    private long _exp = 0L;
    private int _sp = 0;
    private byte _level = 1;

    public CharStat(L2Character activeChar) {
        this._activeChar = activeChar;
    }

    public final double calcStat(Stats stat, double init, L2Character target, L2Skill skill) {
        if (this._activeChar == null || stat == null) {
            return init;
        }
        int id = stat.ordinal();
        Calculator c = this._activeChar.getCalculators()[id];
        if (c == null || c.size() == 0) {
            return init;
        }
        Env env = new Env();
        env.player = this._activeChar;
        env.target = target;
        env.skill = skill;
        env.value = init;
        c.calc(env);
        if (env.value <= 0.0) {
            switch (stat) {
                case MAX_HP: 
                case MAX_MP: 
                case MAX_CP: 
                case MAGIC_DEFENCE: 
                case POWER_DEFENCE: 
                case POWER_ATTACK: 
                case MAGIC_ATTACK: 
                case POWER_ATTACK_SPEED: 
                case MAGIC_ATTACK_SPEED: 
                case SHIELD_DEFENCE: 
                case STAT_CON: 
                case STAT_DEX: 
                case STAT_INT: 
                case STAT_MEN: 
                case STAT_STR: 
                case STAT_WIT: {
                    env.value = 1.0;
                }
            }
        }
        return env.value;
    }

    public int getAccuracy() {
        if (this._activeChar == null) {
            return 0;
        }
        return (int)Math.round(this.calcStat(Stats.ACCURACY_COMBAT, 0.0, null, null));
    }

    public L2Character getActiveChar() {
        return this._activeChar;
    }

    public final float getAttackSpeedMultiplier() {
        if (this._activeChar == null) {
            return 1.0f;
        }
        return (float)(1.1 * (double)this.getPAtkSpd() / (double)this._activeChar.getTemplate().basePAtkSpd);
    }

    public final int getCON() {
        if (this._activeChar == null) {
            return 1;
        }
        return (int)this.calcStat(Stats.STAT_CON, this._activeChar.getTemplate().baseCON, null, null);
    }

    public final double getCriticalDmg(L2Character target, double init) {
        return this.calcStat(Stats.CRITICAL_DAMAGE, init, target, null);
    }

    public int getCriticalHit(L2Character target, L2Skill skill) {
        if (this._activeChar == null) {
            return 1;
        }
        int criticalHit = (int)Math.round(this.calcStat(Stats.CRITICAL_RATE, this._activeChar.getTemplate().baseCritRate, target, skill) * 10.0 + 0.5);
        if ((criticalHit /= 10) > Config.MAX_PCRIT_RATE) {
            criticalHit = Config.MAX_PCRIT_RATE;
        }
        return criticalHit;
    }

    public final int getDEX() {
        if (this._activeChar == null) {
            return 1;
        }
        return (int)this.calcStat(Stats.STAT_DEX, this._activeChar.getTemplate().baseDEX, null, null);
    }

    public int getEvasionRate(L2Character target) {
        if (this._activeChar == null) {
            return 1;
        }
        int val = (int)Math.round(this.calcStat(Stats.EVASION_RATE, 0.0, target, null));
        if (val > Config.MAX_EVASION && !this._activeChar.isGM()) {
            val = Config.MAX_EVASION;
        }
        return val;
    }

    public long getExp() {
        return this._exp;
    }

    public void setExp(long value) {
        this._exp = value;
    }

    public int getINT() {
        if (this._activeChar == null) {
            return 1;
        }
        return (int)this.calcStat(Stats.STAT_INT, this._activeChar.getTemplate().baseINT, null, null);
    }

    public byte getLevel() {
        return this._level;
    }

    public void setLevel(byte value) {
        this._level = value;
    }

    public final int getMagicalAttackRange(L2Skill skill) {
        if (this._activeChar == null) {
            return 1;
        }
        if (skill != null) {
            return (int)this.calcStat(Stats.MAGIC_ATTACK_RANGE, skill.getCastRange(), null, skill);
        }
        return this._activeChar.getTemplate().baseAtkRange;
    }

    public int getMaxCp() {
        if (this._activeChar == null) {
            return 1;
        }
        return (int)this.calcStat(Stats.MAX_CP, this._activeChar.getTemplate().baseCpMax, null, null);
    }

    public int getMaxHp() {
        if (this._activeChar == null) {
            return 1;
        }
        return (int)this.calcStat(Stats.LIMIT_HP, this.getMaxVisibleHp(), null, null);
    }

    public int getMaxVisibleHp() {
        if (this._activeChar == null) {
            return 1;
        }
        return (int)this.calcStat(Stats.MAX_HP, this._activeChar.getTemplate().baseHpMax, null, null);
    }

    public int getMaxMp() {
        if (this._activeChar == null) {
            return 1;
        }
        return (int)this.calcStat(Stats.MAX_MP, this._activeChar.getTemplate().baseMpMax, null, null);
    }

    public int getMAtk(L2Character target, L2Skill skill) {
        Stats stat;
        if (this._activeChar == null) {
            return 1;
        }
        float bonusAtk = 1.0f;
        if (Config.L2JMOD_CHAMPION_ENABLE && this._activeChar.isChampion()) {
            bonusAtk = Config.L2JMOD_CHAMPION_ATK;
        }
        if (this._activeChar.isRaid()) {
            bonusAtk = (float)((double)bonusAtk * Config.RAID_MATTACK_MULTIPLIER);
        }
        double attack = (float)this._activeChar.getTemplate().baseMAtk * bonusAtk;
        Stats stats = stat = skill == null ? null : skill.getStat();
        if (stat != null) {
            switch (stat) {
                case AGGRESSION: {
                    attack += (double)this._activeChar.getTemplate().baseAggression;
                    break;
                }
                case BLEED: {
                    attack += (double)this._activeChar.getTemplate().baseBleed;
                    break;
                }
                case POISON: {
                    attack += (double)this._activeChar.getTemplate().basePoison;
                    break;
                }
                case STUN: {
                    attack += (double)this._activeChar.getTemplate().baseStun;
                    break;
                }
                case ROOT: {
                    attack += (double)this._activeChar.getTemplate().baseRoot;
                    break;
                }
                case MOVEMENT: {
                    attack += (double)this._activeChar.getTemplate().baseMovement;
                    break;
                }
                case CONFUSION: {
                    attack += (double)this._activeChar.getTemplate().baseConfusion;
                    break;
                }
                case SLEEP: {
                    attack += (double)this._activeChar.getTemplate().baseSleep;
                }
            }
        }
        if (skill != null) {
            attack += skill.getPower();
        }
        return (int)this.calcStat(Stats.MAGIC_ATTACK, attack, target, skill);
    }

    public int getMAtkSpd() {
        double val;
        if (this._activeChar == null) {
            return 1;
        }
        float bonusSpdAtk = 1.0f;
        if (Config.L2JMOD_CHAMPION_ENABLE && this._activeChar.isChampion()) {
            bonusSpdAtk = Config.L2JMOD_CHAMPION_SPD_ATK;
        }
        if ((val = this.calcStat(Stats.MAGIC_ATTACK_SPEED, (float)this._activeChar.getTemplate().baseMAtkSpd * bonusSpdAtk, null, null)) > (double)Config.MAX_MATK_SPEED && !this._activeChar.isGM()) {
            val = Config.MAX_MATK_SPEED;
        }
        if (val > (double)Config.LIMIT_MATK_SPD && this._activeChar instanceof L2PcInstance) {
            val = Config.LIMIT_MATK_SPD;
        }
        return (int)val;
    }

    public final int getMCriticalHit(L2Character target, L2Skill skill) {
        if (this._activeChar == null) {
            return 1;
        }
        double mrate = this.calcStat(Stats.MCRITICAL_RATE, this._activeChar.getTemplate().baseMCritRate, target, skill);
        if (mrate > (double)Config.MAX_MCRIT_RATE) {
            mrate = Config.MAX_MCRIT_RATE;
        }
        return (int)mrate;
    }

    public int getMDef(L2Character target, L2Skill skill) {
        if (this._activeChar == null) {
            return 1;
        }
        double defence = this._activeChar.getTemplate().baseMDef;
        if (this._activeChar.isRaid()) {
            defence *= Config.RAID_MDEFENCE_MULTIPLIER;
        }
        return (int)this.calcStat(Stats.MAGIC_DEFENCE, defence, target, skill);
    }

    public final int getMEN() {
        if (this._activeChar == null) {
            return 1;
        }
        return (int)this.calcStat(Stats.STAT_MEN, this._activeChar.getTemplate().baseMEN, null, null);
    }

    public float getMovementSpeedMultiplier() {
        if (this._activeChar == null) {
            return 1.0f;
        }
        int baseRunSpd = this._activeChar.getTemplate().baseRunSpd;
        if (baseRunSpd == 0) {
            return 1.0f;
        }
        return (float)this.getRunSpeed() / (float)baseRunSpd;
    }

    public float getMoveSpeed() {
        if (this._activeChar == null) {
            return 1.0f;
        }
        if (this._activeChar.isRunning()) {
            return this.getRunSpeed();
        }
        return this.getWalkSpeed();
    }

    public final double getMReuseRate(L2Skill skill) {
        if (this._activeChar == null) {
            return 1.0;
        }
        return this.calcStat(Stats.MAGIC_REUSE_RATE, this._activeChar.getTemplate().baseMReuseRate, null, skill);
    }

    public final double getPReuseRate(L2Skill skill) {
        if (this._activeChar == null) {
            return 1.0;
        }
        return this.calcStat(Stats.P_REUSE, this._activeChar.getTemplate().baseMReuseRate, null, skill);
    }

    public int getPAtk(L2Character target) {
        if (this._activeChar == null) {
            return 1;
        }
        float bonusAtk = 1.0f;
        if (Config.L2JMOD_CHAMPION_ENABLE && this._activeChar.isChampion()) {
            bonusAtk = Config.L2JMOD_CHAMPION_ATK;
        }
        if (this._activeChar.isRaid()) {
            bonusAtk = (float)((double)bonusAtk * Config.RAID_PATTACK_MULTIPLIER);
        }
        return (int)this.calcStat(Stats.POWER_ATTACK, (float)this._activeChar.getTemplate().basePAtk * bonusAtk, target, null);
    }

    public final double getPAtkAnimals(L2Character target) {
        return this.calcStat(Stats.PATK_ANIMALS, 1.0, target, null);
    }

    public final double getPAtkDragons(L2Character target) {
        return this.calcStat(Stats.PATK_DRAGONS, 1.0, target, null);
    }

    public final double getPAtkInsects(L2Character target) {
        return this.calcStat(Stats.PATK_INSECTS, 1.0, target, null);
    }

    public final double getPAtkMonsters(L2Character target) {
        return this.calcStat(Stats.PATK_MONSTERS, 1.0, target, null);
    }

    public final double getPAtkPlants(L2Character target) {
        return this.calcStat(Stats.PATK_PLANTS, 1.0, target, null);
    }

    public final double getPAtkGiants(L2Character target) {
        return this.calcStat(Stats.PATK_GIANTS, 1.0, target, null);
    }

    public final double getPAtkMCreatures(L2Character target) {
        return this.calcStat(Stats.PATK_MCREATURES, 1.0, target, null);
    }

    public int getPAtkSpd() {
        int val;
        if (this._activeChar == null) {
            return 1;
        }
        float bonusAtk = 1.0f;
        if (Config.L2JMOD_CHAMPION_ENABLE && this._activeChar.isChampion()) {
            bonusAtk = Config.L2JMOD_CHAMPION_SPD_ATK;
        }
        if ((val = (int)Math.round(this.calcStat(Stats.POWER_ATTACK_SPEED, (float)this._activeChar.getTemplate().basePAtkSpd * bonusAtk, null, null))) > Config.LIMIT_PATK_SPD && this._activeChar instanceof L2PcInstance) {
            val = Config.LIMIT_PATK_SPD;
        }
        return val;
    }

    public final double getPDefAnimals(L2Character target) {
        return this.calcStat(Stats.PDEF_ANIMALS, 1.0, target, null);
    }

    public final double getPDefDragons(L2Character target) {
        return this.calcStat(Stats.PDEF_DRAGONS, 1.0, target, null);
    }

    public final double getPDefInsects(L2Character target) {
        return this.calcStat(Stats.PDEF_INSECTS, 1.0, target, null);
    }

    public final double getPDefMonsters(L2Character target) {
        return this.calcStat(Stats.PDEF_MONSTERS, 1.0, target, null);
    }

    public final double getPDefPlants(L2Character target) {
        return this.calcStat(Stats.PDEF_PLANTS, 1.0, target, null);
    }

    public final double getPDefGiants(L2Character target) {
        return this.calcStat(Stats.PDEF_GIANTS, 1.0, target, null);
    }

    public int getPDef(L2Character target) {
        if (this._activeChar == null) {
            return 1;
        }
        return (int)this.calcStat(Stats.POWER_DEFENCE, this._activeChar.isRaid() ? (double)this._activeChar.getTemplate().basePDef * Config.RAID_PDEFENCE_MULTIPLIER : (double)this._activeChar.getTemplate().basePDef, target, null);
    }

    public final int getPhysicalAttackRange() {
        if (this._activeChar == null) {
            return 1;
        }
        if (this._activeChar.isTransformed()) {
            return this._activeChar.getTemplate().baseAtkRange;
        }
        L2Weapon weaponItem = this._activeChar.getActiveWeaponItem();
        if (weaponItem != null && weaponItem.getItemType() == L2WeaponType.POLE) {
            return (int)this.calcStat(Stats.POWER_ATTACK_RANGE, 66.0, null, null);
        }
        return (int)this.calcStat(Stats.POWER_ATTACK_RANGE, this._activeChar.getTemplate().baseAtkRange, null, null);
    }

    public final double getWeaponReuseModifier(L2Character target) {
        return this.calcStat(Stats.ATK_REUSE, 1.0, target, null);
    }

    public int getRunSpeed() {
        if (this._activeChar == null) {
            return 1;
        }
        double baseRunSpd = this._activeChar.getTemplate().baseRunSpd;
        if (baseRunSpd == 0.0) {
            return 0;
        }
        return (int)Math.round(this.calcStat(Stats.RUN_SPEED, baseRunSpd, null, null));
    }

    public final int getShldDef() {
        return (int)this.calcStat(Stats.SHIELD_DEFENCE, 0.0, null, null);
    }

    public int getSp() {
        return this._sp;
    }

    public void setSp(int value) {
        this._sp = value;
    }

    public final int getSTR() {
        if (this._activeChar == null) {
            return 1;
        }
        return (int)this.calcStat(Stats.STAT_STR, this._activeChar.getTemplate().baseSTR, null, null);
    }

    public int getWalkSpeed() {
        if (this._activeChar == null) {
            return 1;
        }
        double baseWalkSpd = this._activeChar.getTemplate().baseWalkSpd;
        if (baseWalkSpd == 0.0) {
            return 0;
        }
        return (int)this.calcStat(Stats.WALK_SPEED, baseWalkSpd, null, null);
    }

    public final int getWIT() {
        if (this._activeChar == null) {
            return 1;
        }
        return (int)this.calcStat(Stats.STAT_WIT, this._activeChar.getTemplate().baseWIT, null, null);
    }

    public final int getMpConsume(L2Skill skill) {
        if (skill == null) {
            return 1;
        }
        double mpConsume = skill.getMpConsume();
        if (skill.isDance() && Config.DANCE_CONSUME_ADDITIONAL_MP && this._activeChar != null && this._activeChar.getDanceCount() > 0) {
            mpConsume += (double)(this._activeChar.getDanceCount() * skill.getNextDanceMpCost());
        }
        mpConsume = this.calcStat(Stats.MP_CONSUME, mpConsume, null, skill);
        if (skill.isDance()) {
            return (int)this.calcStat(Stats.DANCE_MP_CONSUME_RATE, mpConsume, null, null);
        }
        if (skill.isMagic()) {
            return (int)this.calcStat(Stats.MAGICAL_MP_CONSUME_RATE, mpConsume, null, null);
        }
        return (int)this.calcStat(Stats.PHYSICAL_MP_CONSUME_RATE, mpConsume, null, null);
    }

    public final int getMpInitialConsume(L2Skill skill) {
        if (skill == null) {
            return 1;
        }
        double mpConsume = this.calcStat(Stats.MP_CONSUME, skill.getMpInitialConsume(), null, skill);
        if (skill.isDance()) {
            return (int)this.calcStat(Stats.DANCE_MP_CONSUME_RATE, mpConsume, null, null);
        }
        if (skill.isMagic()) {
            return (int)this.calcStat(Stats.MAGICAL_MP_CONSUME_RATE, mpConsume, null, null);
        }
        return (int)this.calcStat(Stats.PHYSICAL_MP_CONSUME_RATE, mpConsume, null, null);
    }

    public byte getAttackElement() {
        L2ItemInstance weaponInstance = this._activeChar.getActiveWeaponInstance();
        if (weaponInstance != null && weaponInstance.getAttackElementType() >= 0) {
            return weaponInstance.getAttackElementType();
        }
        int tempVal = 0;
        int[] stats = new int[]{0, 0, 0, 0, 0, 0};
        int returnVal = -2;
        stats[0] = (int)this.calcStat(Stats.FIRE_POWER, this._activeChar.getTemplate().baseFire, null, null);
        stats[1] = (int)this.calcStat(Stats.WATER_POWER, this._activeChar.getTemplate().baseWater, null, null);
        stats[2] = (int)this.calcStat(Stats.WIND_POWER, this._activeChar.getTemplate().baseWind, null, null);
        stats[3] = (int)this.calcStat(Stats.EARTH_POWER, this._activeChar.getTemplate().baseEarth, null, null);
        stats[4] = (int)this.calcStat(Stats.HOLY_POWER, this._activeChar.getTemplate().baseHoly, null, null);
        stats[5] = (int)this.calcStat(Stats.DARK_POWER, this._activeChar.getTemplate().baseDark, null, null);
        for (int x = 0; x < 6; x = (int)((byte)(x + 1))) {
            if (stats[x] <= tempVal) continue;
            returnVal = x;
            tempVal = stats[x];
        }
        return (byte)returnVal;
    }

    public int getAttackElementValue(byte attackAttribute) {
        switch (attackAttribute) {
            case 0: {
                return (int)this.calcStat(Stats.FIRE_POWER, this._activeChar.getTemplate().baseFire, null, null);
            }
            case 1: {
                return (int)this.calcStat(Stats.WATER_POWER, this._activeChar.getTemplate().baseWater, null, null);
            }
            case 2: {
                return (int)this.calcStat(Stats.WIND_POWER, this._activeChar.getTemplate().baseWind, null, null);
            }
            case 3: {
                return (int)this.calcStat(Stats.EARTH_POWER, this._activeChar.getTemplate().baseEarth, null, null);
            }
            case 4: {
                return (int)this.calcStat(Stats.HOLY_POWER, this._activeChar.getTemplate().baseHoly, null, null);
            }
            case 5: {
                return (int)this.calcStat(Stats.DARK_POWER, this._activeChar.getTemplate().baseDark, null, null);
            }
        }
        return 0;
    }

    public int getDefenseElementValue(byte defenseAttribute) {
        switch (defenseAttribute) {
            case 0: {
                return (int)this.calcStat(Stats.FIRE_RES, this._activeChar.getTemplate().baseFireRes, null, null);
            }
            case 1: {
                return (int)this.calcStat(Stats.WATER_RES, this._activeChar.getTemplate().baseWaterRes, null, null);
            }
            case 2: {
                return (int)this.calcStat(Stats.WIND_RES, this._activeChar.getTemplate().baseWindRes, null, null);
            }
            case 3: {
                return (int)this.calcStat(Stats.EARTH_RES, this._activeChar.getTemplate().baseEarthRes, null, null);
            }
            case 4: {
                return (int)this.calcStat(Stats.HOLY_RES, this._activeChar.getTemplate().baseHolyRes, null, null);
            }
            case 5: {
                return (int)this.calcStat(Stats.DARK_RES, this._activeChar.getTemplate().baseDarkRes, null, null);
            }
        }
        return 0;
    }
}

