/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.gameserver.model.PartyMatchRoom;
import com.l2jserver.gameserver.model.PartyMatchRoomList;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import com.l2jserver.gameserver.network.serverpackets.ExManagePartyRoomMember;
import com.l2jserver.gameserver.network.serverpackets.JoinParty;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;

public final class RequestAnswerJoinParty
extends L2GameClientPacket {
    private static final String _C__2A_REQUESTANSWERPARTY = "[C] 2A RequestAnswerJoinParty";
    private int _response;

    @Override
    protected void readImpl() {
        this._response = this.readD();
    }

    @Override
    protected void runImpl() {
        L2PcInstance player = ((L2GameClient)this.getClient()).getActiveChar();
        if (player == null) {
            return;
        }
        L2PcInstance requestor = player.getActiveRequester();
        if (requestor == null) {
            return;
        }
        requestor.sendPacket(new JoinParty(this._response));
        if (this._response == 1) {
            PartyMatchRoom room;
            PartyMatchRoomList list;
            if (requestor.isInParty() && requestor.getParty().getMemberCount() >= 9) {
                SystemMessage sm = new SystemMessage(SystemMessageId.PARTY_FULL);
                player.sendPacket(sm);
                requestor.sendPacket(sm);
                return;
            }
            player.joinParty(requestor.getParty());
            if (requestor.isInPartyMatchRoom() && player.isInPartyMatchRoom()) {
                PartyMatchRoom room2;
                PartyMatchRoomList list2 = PartyMatchRoomList.getInstance();
                if (list2 != null && list2.getPlayerRoomId(requestor) == list2.getPlayerRoomId(player) && (room2 = list2.getPlayerRoom(requestor)) != null) {
                    ExManagePartyRoomMember packet = new ExManagePartyRoomMember(player, room2, 1);
                    for (L2PcInstance member : room2.getPartyMembers()) {
                        if (member == null) continue;
                        member.sendPacket(packet);
                    }
                }
            } else if (requestor.isInPartyMatchRoom() && !player.isInPartyMatchRoom() && (list = PartyMatchRoomList.getInstance()) != null && (room = list.getPlayerRoom(requestor)) != null) {
                room.addMember(player);
                ExManagePartyRoomMember packet = new ExManagePartyRoomMember(player, room, 1);
                for (L2PcInstance member : room.getPartyMembers()) {
                    if (member == null) continue;
                    member.sendPacket(packet);
                }
                player.setPartyRoom(room.getId());
                player.broadcastUserInfo();
            }
        } else {
            requestor.sendPacket(new SystemMessage(SystemMessageId.PLAYER_DECLINED));
            if (requestor.isInParty() && requestor.getParty().getMemberCount() == 1) {
                requestor.setParty(null);
            }
        }
        if (requestor.isInParty()) {
            requestor.getParty().setPendingInvitation(false);
        }
        player.setActiveRequester(null);
        requestor.onTransactionResponse();
    }

    @Override
    public String getType() {
        return _C__2A_REQUESTANSWERPARTY;
    }
}

