/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.skills.effects;

import com.l2jserver.gameserver.ai.CtrlEvent;
import com.l2jserver.gameserver.model.L2Effect;
import com.l2jserver.gameserver.model.actor.instance.L2MonsterInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.skills.Env;
import com.l2jserver.gameserver.skills.Formulas;
import com.l2jserver.gameserver.templates.effects.EffectTemplate;
import com.l2jserver.gameserver.templates.skills.L2EffectType;

public class EffectSpoil
extends L2Effect {
    public EffectSpoil(Env env, EffectTemplate template) {
        super(env, template);
    }

    @Override
    public L2EffectType getEffectType() {
        return L2EffectType.SPOIL;
    }

    @Override
    public boolean onStart() {
        if (!(this.getEffector() instanceof L2PcInstance)) {
            return false;
        }
        if (!(this.getEffected() instanceof L2MonsterInstance)) {
            return false;
        }
        L2MonsterInstance target = (L2MonsterInstance)this.getEffected();
        if (target == null) {
            return false;
        }
        if (target.isSpoil()) {
            this.getEffector().sendPacket(new SystemMessage(SystemMessageId.ALREADY_SPOILED));
            return false;
        }
        boolean spoil = false;
        if (!target.isDead()) {
            spoil = Formulas.calcMagicSuccess(this.getEffector(), target, this.getSkill());
            if (spoil) {
                target.setSpoil(true);
                target.setIsSpoiledBy(this.getEffector().getObjectId());
                this.getEffector().sendPacket(new SystemMessage(SystemMessageId.SPOIL_SUCCESS));
            }
            target.getAI().notifyEvent(CtrlEvent.EVT_ATTACKED, this.getEffector());
        }
        return true;
    }

    @Override
    public boolean onActionTime() {
        return false;
    }
}

