/*
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program. If not, see <http://www.gnu.org/licenses/>.
 */
package events.SquashEvent;

import java.util.Arrays;
import java.util.Comparator;

import javolution.util.FastMap;

import com.l2jserver.gameserver.instancemanager.QuestManager;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.L2Skill;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2ChronoMonsterInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.quest.Quest;
import com.l2jserver.gameserver.model.quest.QuestState;
import com.l2jserver.gameserver.network.clientpackets.Say2;
import com.l2jserver.gameserver.network.serverpackets.CreatureSay;
import com.l2jserver.gameserver.templates.item.L2Weapon;
import com.l2jserver.util.Rnd;

/**
 * @author Gnacik
 * @version 1.0
 * @see Warning! Mostly that event is custom!
 */
public class SquashEvent extends Quest
{
	private static final String qn = "SquashEvent";

	private static final int MANAGER = 31860;

	private static final int NECTAR_SKILL = 2005;

	private static final long DESPAWN_FIRST = 180000;
	private static final long DESPAWN_NEXT = 90000;

	private static final int DAMAGE_MAX = 12;
	private static final int DAMAGE_DEFAULT = 5;

	private static final int[] CHRONO_LIST = {
		4202,5133,5817,7058,8350
	};

	private static final int[] SQUASH_LIST = {
		12774,12775,12776,
		12777,12778,12779,
		13016,13017
	};

	private static final String[] SPAWN_TEXT = {
		"ttbAĂ񂾂H",
		"AMălN^[Ă݂ȁI",
		"Ă񂾂HŉĂ񂾂񂾁HႦƂłv̂H",
		"EPPPbA悭ĂÁׂ`B_H͉mȂ`B",
		"|i̓lN^[ƃAi^̈ň炿܂I",
		"GbwIAo܂IdĂ݂II",
		"AĂĂ݂I肭Α哖A_nY`I",
	};
	private static final String[] GROWUP_TEXT = {
		"lȁISŉÎIII",
		"悭IA邩`B",
		"ȂĂ݂I",
	};
	private static final String[] KILL_TEXT = {
		"哖FII",
		"nYɂȂI",
		"S~oI",
		"̎𖳑ʂɂȂI",
		"`A悩́`IȂ́`Ał܂]邱Ƃł邩ȁHƂĂꂠˁB",
		"IꂽIgg````B",
		"NAAAbII邱Ƃł̂ɁDDDI",
	};

	private static final String[] NOCHRONO_TEXT = {
		"lȁISŉÎIII",
		"ǂUBłnG|B",
		"͂oĂ݂`BȂ񂶂ቴAAႤH",
		"̒x̗͂ŉ낤ƌ̂H",
		"قAƉĂ݂IƉĂ݂I",
		"HȂȂ邶ˁ`I",
		"ȂĂ݂I",
		"ĂȂAP疜Afi邼IDDDĂ邩H",
	//	"You cannot kill me without Chrono",
	//	"Hehe...keep trying...",
	//	"Nice try...",
	//	"Tired ?",
	//	"Go go ! haha..."
	};

	private static final String[] CHRONO_TEXT = {
		"mbĂȁII",
		"`DDDȂăXeLȃn[j[A`",
		"񂤂`BƕĂłˁ`",
		"Iς肱̉łȂƂˁI",
		"킟IƂĂXeLȉF`II",
		"C`AĂI",
		"`̂YYĊꂻI",
		"AǂFˁI",
		"[I|i`II",
		"AȁH",
		"f炵TEhȁI",
		"f炵TEhImbĂI",
		"A̘aIōIƕĂI",
		"Nm̃TEhɎ䂩邱̐SI",
		"y͗ǂÂȁB̂Ă낤H",
		"˂A˂Aȉ̂ĂH",
		"ꂾĨTEh񂾁IOA~[WVɂȂĂ݂ȂH",
		"aƍ킹Ă݂II",
		"`ÂYYĂI",
		"A^VƂ̎voA؂ɂĂˁ`B",
		"ĤH{CŉȁI",
		"낻͂oĂB30bΓꂻI",
	//	"Arghh... Chrono weapon...",
	//	"My end is coming...",
	//	"Please leave me !",
	//	"Heeellpppp...",
	//	"Somebody help me please..."
	};
	private static final String[] NECTAR_TEXT = {
		"ƂIƗ~񂾁II",
		"IȂIAInĂ炩Ă̂H",
		"IƂIڂĂ邶ȂI",
		"Aǂ`BƂB񂾂ǂȂĂ`B",
		"I傫ȂAȂI",
		"I̔p̂IH",
		"Aʂ̂ƍlĂłHȂ񂶂AAi^̈̓A^Vɓ`ĂȂ́IƈāI",
		"Ai^̈Ȃ́IꂶAA^VނႤI",
		"DDDM̂Sg삯́I",
		"ƂAAi^̈Ă̒x̂̂Ȃ́`H",
		"Â܂܎񂶂܂ACe͏oȂ񂾂IȂɃlN^[ܑ̖̂H",
		"͂lN^[́A|ĩlN^[ōIEwwwI",
		"llAĉ`BlN^[߂Ɏł܂ȂĐn`B",
		"AꐅŔ߂̂H̖́H",
		"EFbAybybÍIꂪ{ɃlN^[Ƃ̂H",
	//	"Yummy... Nectar...",
	//	"Plase give me more...",
	//	"Hmmm.. More.. I need more...",
	//	"I will like you more if you give me more...",
	//	"Hmmmmmmm...",
	//	"My favourite..."
	};

	private static final int[][] DROPLIST =
	{
		// <DEL>must be sorted by npcId !</DEL>
		// npcId, chance, itemId,qty [,itemId,qty...]

		// Young Squash
		{ 12774,100,  6391,2 },		// Nectar

		// Low Quality Squash
		{ 12776,100,  6391,50 },	// Nectar

		// High Quality Squash
		{ 12775,100,  6391,100 },	// Nectar

		// King
		{ 13016,100,  6391,150 },	// Nectar

		// Large Young Squash
		{ 12777,100, 14701,2,		//͏uԑ̗͉񕜍
					 14700,2 },		//̗͉͑񕜍

		// Low Quality Large
		{ 12779, 50,   729,4,		//틭XN[FAO[h
					   730,4,		//hXN[FAO[h
					  6569,2,		//jꂽ틭XN[FAO[h
					  6570,2 },		//jꂽhXN[FAO[h
		{ 12779, 30,  6622,1 },		//l̔`
		{ 12779, 10,  8750,1 },		//㋉ ̐΁Fx67
		{ 12779, 10,  8751,1 },		//㋉ ̐΁Fx70
		{ 12779, 99, 14701,4,		//͏uԑ̗͉񕜍
					 14700,4 },		//̗͉͑񕜍
		{ 12779, 50,  1461,4 },		//NX^FAO[h
		{ 12779, 30,  1462,3 },		//NX^FSO[h
		{ 12779, 50,  2133,4 },		//WFXg[FAO[h
		{ 12779, 30,  2134,3 },		//WFXg[FSO[h

		// High Quality Large
		{ 12778,  7,  9570,1,		//bh \E Xg[FXebv14
					  9571,1,		//u[ \E Xg[FXebv14
					  9572,1,		//O[ \E Xg[FXebv14
					 10480,1,		//bh \E Xg[FXebv15
					 10481,1,		//u[ \E Xg[FXebv15
					 10482,1,		//O[ \E Xg[FXebv15
					 13071,1,		//bh \E Xg[FXebv16
					 13072,1,		//u[ \E Xg[FXebv16
					 13073,1 },		//O[ \E Xg[FXebv16
		{ 12778, 35,   729,4,		//틭XN[FAO[h
					   730,4,		//hXN[FAO[h
					   959,3,		//틭XN[FSO[h
					   960,3,		//hXN[FSO[h
					  6569,2,		//jꂽ틭XN[FAO[h
					  6570,2,		//jꂽhXN[FAO[h
					  6577,1,		//jꂽ틭XN[FSO[h
					  6578,1 },		//jꂽhXN[FSO[h
		{ 12778, 28,  6622,3,		//l̔`
					  9625,2,		//l̔`FYp
					  9626,2,		//l̔`FC
					  9627,2 },		//l̔`Fn
		{ 12778, 14,  8750,10 },	//㋉ ̐΁Fx67
		{ 12778, 14,  8751,8 },		//㋉ ̐΁Fx70
		{ 12778, 14,  8752,6 },		//㋉ ̐΁Fx76
		{ 12778, 14,  9575,4 },		//㋉ ̐΁Fx80
		{ 12778, 14, 10485,2 },		//㋉ ̐΁Fx82
		{ 12778, 14, 14168,1 },		//㋉̐΁Fx84
		{ 12778, 21,  8760,1,		//ŏ㋉̐΁Fx67
					  8761,1,		//ŏ㋉̐΁Fx70
					  8762,1,		//ŏ㋉̐΁Fx76
					  9576,1,		//ŏ㋉̐΁Fx80
					 10486,1,		//ŏ㋉̐΁Fx82
					 14169,1 },		//ŏ㋉̐΁Fx84
		{ 12778, 21, 14683,1,		//͐̔FcO[h
					 14684,1,		//͐̔FCO[h
					 14685,1,		//͐̔FBO[h
					 14686,1,		//͐̔FAO[h
					 14687,1,		//͐̔FSO[h
					 14689,1,		//͐_̔FcO[h
					 14690,1,		//͐_̔FCO[h
					 14691,1,		//͐_̔FBO[h
					 14692,1,		//͐_̔FAO[h
					 14693,1,		//͐_̔FSO[h
					 14695,1,		//͓u̔FcO[h
					 14696,1,		//͓u̔FCO[h
					 14697,1,		//͓u̔FBO[h
					 14698,1,		//͓u̔FAO[h
					 14699,1 },		//͓u̔FSO[h
		{ 12778, 99, 14701,9,		//͏uԑ̗͉񕜍
					 14700,9 },		//̗͉͑񕜍
		{ 12778, 63,  1461,8 },		//NX^FAO[h
		{ 12778, 49,  1462,5 },		//NX^FSO[h
		{ 12778, 63,  2133,6 },		//WFXg[FAO[h
		{ 12778, 49,  2134,4 },		//WFXg[FSO[h

		// Emperor
		{ 13017, 10,  9570,1,		//bh \E Xg[FXebv14
					  9571,1,		//u[ \E Xg[FXebv14
					  9572,1,		//O[ \E Xg[FXebv14
					 10480,1,		//bh \E Xg[FXebv15
					 10481,1,		//u[ \E Xg[FXebv15
					 10482,1,		//O[ \E Xg[FXebv15
					 13071,1,		//bh \E Xg[FXebv16
					 13072,1,		//u[ \E Xg[FXebv16
					 13073,1 },		//O[ \E Xg[FXebv16
		{ 13017, 50,   729,4,		//틭XN[FAO[h
					   730,4,		//hXN[FAO[h
					   959,3,		//틭XN[FSO[h
					   960,3,		//hXN[FSO[h
					  6569,2,		//jꂽ틭XN[FAO[h
					  6570,2,		//jꂽhXN[FAO[h
					  6577,1,		//jꂽ틭XN[FSO[h
					  6578,1 },		//jꂽhXN[FSO[h
		{ 13017, 40,  6622,3,		//l̔`
					  9625,2,		//l̔`FYp
					  9626,2,		//l̔`FC
					  9627,2 },		//l̔`Fn
		{ 13017, 20,  8750,10 },	//㋉ ̐΁Fx67
		{ 13017, 20,  8751,8 },		//㋉ ̐΁Fx70
		{ 13017, 20,  8752,6 },		//㋉ ̐΁Fx76
		{ 13017, 20,  9575,4 },		//㋉ ̐΁Fx80
		{ 13017, 20, 10485,2 },		//㋉ ̐΁Fx82
		{ 13017, 20, 14168,1 },		//㋉̐΁Fx84
		{ 13017, 30,  8760,1,		//ŏ㋉̐΁Fx67
					  8761,1,		//ŏ㋉̐΁Fx70
					  8762,1,		//ŏ㋉̐΁Fx76
					  9576,1,		//ŏ㋉̐΁Fx80
					 10486,1,		//ŏ㋉̐΁Fx82
					 14169,1 },		//ŏ㋉̐΁Fx84
		{ 13017, 30, 14683,1,		//͐̔FcO[h
					 14684,1,		//͐̔FCO[h
					 14685,1,		//͐̔FBO[h
					 14686,1,		//͐̔FAO[h
					 14687,1,		//͐̔FSO[h
					 14689,1,		//͐_̔FcO[h
					 14690,1,		//͐_̔FCO[h
					 14691,1,		//͐_̔FBO[h
					 14692,1,		//͐_̔FAO[h
					 14693,1,		//͐_̔FSO[h
					 14695,1,		//͓u̔FcO[h
					 14696,1,		//͓u̔FCO[h
					 14697,1,		//͓u̔FBO[h
					 14698,1,		//͓u̔FAO[h
					 14699,1 },		//͓u̔FSO[h
		{ 13017, 99, 14701,12,		//͏uԑ̗͉񕜍
					 14700,12 },	//̗͉͑񕜍
		{ 13017, 90,  1461,8 },		//NX^FAO[h
		{ 13017, 70,  1462,5 },		//NX^FSO[h
		{ 13017, 90,  2133,6 },		//WFXg[FAO[h
		{ 13017, 70,  2134,4 },		//WFXg[FSO[h
	};

	class TheInstance
	{
		int nectar;
	//	int numatk;
	//	int tmpatk;
		long despawnTime;
	}
	FastMap<L2ChronoMonsterInstance, TheInstance> _monsterInstances = new FastMap<L2ChronoMonsterInstance, TheInstance>().shared();
	private TheInstance create(L2ChronoMonsterInstance mob)
	{
		TheInstance mons = new TheInstance();
		_monsterInstances.put(mob, mons);
		return mons;
	}
	private TheInstance get(L2ChronoMonsterInstance mob)
	{
		return _monsterInstances.get(mob);
	}
	private void remove(L2ChronoMonsterInstance mob)
	{
		cancelQuestTimer("countdown", mob, null);
		cancelQuestTimer("despawn", mob, null);
		_monsterInstances.remove(mob);
	}

	@Override
	public String onAdvEvent(String event, L2Npc npc, L2PcInstance player)
	{
		if (event == "countdown")
		{
			final L2ChronoMonsterInstance mob = (L2ChronoMonsterInstance)npc;
			final TheInstance self = get(mob);
			int timeLeft = (int)((self.despawnTime - System.currentTimeMillis()) / 1000);
			if (timeLeft == 30)
				autoChat(mob, "30bAOƂIToI");
			else if (timeLeft == 20)
				autoChat(mob, "20bAOƂIToI");
			else if (timeLeft == 10)
				autoChat(mob, "Ac10bI9...8...7...");
			else if (timeLeft == 0)
			{
				if (self.nectar == 0)
					autoChat(mob, "̂܂܂ƃA^VA܂ꂽӖA邵Ȃ̂ˁB߂DDD");
				else
					autoChat(mob, "悭IA邩`B");
			}
			else if ((timeLeft % 60) == 0)
			{
				if (self.nectar == 0)
					autoChat(mob, "lN^[Ȃ"+timeLeft/60+"ɋA邼I");
			}
		}
		else if (event == "despawn")
		{
			remove((L2ChronoMonsterInstance)npc);
			npc.deleteMe();
		}
		else
			return super.onAdvEvent(event, npc, player);
		return null;
	}

	@Override
	public String onAttack(L2Npc npc, L2PcInstance attacker, int damage, boolean isPet)
	{
		final L2ChronoMonsterInstance mob = (L2ChronoMonsterInstance)npc;
		L2Weapon weapon;
		final boolean isChronoAttack
			= !isPet
			&& (weapon = attacker.getActiveWeaponItem()) != null && contains(CHRONO_LIST, weapon.getItemId());
		switch (mob.getNpcId())
		{
			case 12774:
			case 12775:
			case 12776:
			case 13016:
				if (isChronoAttack)
				{
					chronoText(mob);
				}
				else
				{
					noChronoText(mob);
				}
				break;
			case 12777:
			case 12778:
			case 12779:
			case 13017:
				if (isChronoAttack)
				{
					mob.setIsInvul(false);
					if (damage == 0)
						mob.getStatus().reduceHp(DAMAGE_DEFAULT, attacker);
					else if (damage > DAMAGE_MAX)
						mob.getStatus().setCurrentHp(mob.getStatus().getCurrentHp() + damage - DAMAGE_MAX);
					chronoText(mob);
				}
				else
				{
					mob.setIsInvul(true);
					mob.setCurrentHp(mob.getMaxHp());
					noChronoText(mob);
				}
				break;
			default:
				throw new RuntimeException();
		}
		mob.getStatus().stopHpMpRegeneration();
		return super.onAttack(npc, attacker, damage, isPet);
	}

	@Override
	public String onSkillSee(L2Npc npc, L2PcInstance caster, L2Skill skill, L2Object[] targets, boolean isPet)
	{
		if (skill.getId() == NECTAR_SKILL && targets[0] == npc)
		{
			final L2ChronoMonsterInstance mob = (L2ChronoMonsterInstance)npc;
			switch(mob.getNpcId())
			{
				case 12774:
					randomSpawn(12776, 12775, 13016, mob);
					break;
				case 12777:
					randomSpawn(12779, 12778, 13017, mob);
					break;
				case 12775:
					randomSpawn(13016, mob);
					break;
				case 12778:
					randomSpawn(13017, mob);
					break;
				case 12776:
				case 12779:
					autoChat(mob, "S~oI");
					break;
			}
		}
		return null;
	//	return super.onSkillSee(npc,caster,skill,targets,isPet);
	}

	@Override
	public String onKill(L2Npc npc, L2PcInstance killer, boolean isPet)
	{
		final L2ChronoMonsterInstance mob = (L2ChronoMonsterInstance)npc;
		remove(mob);
		autoChat(mob, KILL_TEXT[Rnd.get(KILL_TEXT.length)]);
		dropItem(mob, killer);
		return super.onKill(npc, killer, isPet);
	}

	@Override
	public String onSpawn(L2Npc npc)
	{
		assert npc instanceof L2ChronoMonsterInstance;
		
		final L2ChronoMonsterInstance mob = (L2ChronoMonsterInstance)npc;
		mob.setOnKillDelay(1500);	//Default 5000ms.
		final TheInstance self = create(mob);
		switch(mob.getNpcId())
		{
			case 12774:
			case 12777:
				npc.broadcastPacket(new CreatureSay(npc.getObjectId(), Say2.ALL, npc.getName(), SPAWN_TEXT[Rnd.get(SPAWN_TEXT.length)]));
				startQuestTimer("countdown", 10000, mob, null, true);
				startQuestTimer("despawn", DESPAWN_FIRST, mob, null);
				self.nectar = 0;
				self.despawnTime = System.currentTimeMillis() + DESPAWN_FIRST;
				autoChat(mob, SPAWN_TEXT[Rnd.get(SPAWN_TEXT.length)]);
				break;
			case 12775:
			case 12776:
			case 12778:
			case 12779:
			case 13016:
			case 13017:
				startQuestTimer("countdown", 10000, mob, null, true);
				startQuestTimer("despawn", DESPAWN_NEXT, mob, null);
				self.nectar = 5;
				self.despawnTime = System.currentTimeMillis() + DESPAWN_NEXT;
				autoChat(mob, GROWUP_TEXT[Rnd.get(GROWUP_TEXT.length)]);
				break;
			default:
				throw new RuntimeException();
		}
		return null;
		// return super.onSpawn(npc);
	}

	static {
		Arrays.sort(DROPLIST, new Comparator<int[]>() {
			public int compare(int[] a, int[] b) { return a[0] - b[0]; }
		});
	}
	private static final void dropItem(L2ChronoMonsterInstance mob, L2PcInstance player)
	{
		final int npcId = mob.getNpcId();
		for (int[] drop : DROPLIST)
		{
			// npcId   = drop[0]
			// chance  = drop[1]
			// itemId  = drop[2,4,6,8...]
			// itemQty = drop[3,5,7,9...]
			if (npcId == drop[0])
			{
				final int chance = Rnd.get(100);
				if (chance < drop[1])
				{
					int i = 2 + 2 * Rnd.get((drop.length - 2) / 2);
					int itemId = drop[i + 0];
					int itemQty = drop[i + 1];
					if (itemQty > 1) itemQty = Rnd.get(1, itemQty);
					mob.dropItem(mob.getOwner(), itemId, itemQty);
					continue;
				}
			}
			if (npcId < drop[0])
				return; // not found
		}
	}

	private void randomSpawn(int bad, int good, int king, L2ChronoMonsterInstance mob)
	{
		final TheInstance self = get(mob);
		if (++self.nectar == 5)
		{
			int _random = Rnd.get(100);
			if ((_random -= 10) < 0)		// 10% cǎ
				spawnNext(king, mob);
			else if ((_random -= 40) < 0)	// 40% cǎ
				spawnNext(good, mob);
			else							// 50% csǂ
				spawnNext(bad, mob);
		}
		else
		{
			nectarText(mob);
		}
	}

	private void randomSpawn(int king, L2ChronoMonsterInstance mob)
	{
		final TheInstance self = get(mob);
		if (++self.nectar > 5 && self.nectar <= 15 && Rnd.get(100) < 10)	// 10% ǎȁǎ
			spawnNext(king, mob);
		else
			nectarText(mob);
	}

	private void autoChat(L2ChronoMonsterInstance mob, String text)
	{
		mob.broadcastPacket(new CreatureSay(mob.getObjectId(), Say2.ALL, mob.getName(), text));
	}
	private void chronoText(L2ChronoMonsterInstance mob)
	{
		if (Rnd.get(100) < 20)
			autoChat(mob, CHRONO_TEXT[Rnd.get(CHRONO_TEXT.length)]);
	}
	private void noChronoText(L2ChronoMonsterInstance mob)
	{
		if (Rnd.get(100) < 20)
			autoChat(mob, NOCHRONO_TEXT[Rnd.get(NOCHRONO_TEXT.length)]);
	}
	private void nectarText(L2ChronoMonsterInstance npc)
	{
	/*	if (Rnd.get(100) < 30)	*/
		autoChat(npc, NECTAR_TEXT[Rnd.get(NECTAR_TEXT.length)]);
	}

	private void spawnNext(int npcId, L2ChronoMonsterInstance oldMob)
	{
		remove(oldMob);
		L2ChronoMonsterInstance newMob = (L2ChronoMonsterInstance)addSpawn(npcId, oldMob.getX(), oldMob.getY(), oldMob.getZ(), oldMob.getHeading(), false, 0);
		newMob.setOwner(oldMob.getOwner());
		newMob.setTitle(oldMob.getTitle());
		oldMob.deleteMe();
	}

	public static <T> boolean contains(T[] array, T obj)
	{
		for (int i = 0; i < array.length; i++)
		{
			if (array[i] == obj)
			{
				return true;
			}
		}
		return false;
	}

	public static boolean contains(int[] array, int obj)
	{
		for (int i = 0; i < array.length; i++)
		{
			if (array[i] == obj)
			{
				return true;
			}
		}
		return false;
	}

	public SquashEvent(int questId, String name, String descr)
	{
		super(questId, name, descr);

		for (int mob : SQUASH_LIST)
		{
			addAttackId(mob);
			addKillId(mob);
			addSpawnId(mob);
			addSkillSeeId(mob);
		}

		addStartNpc(MANAGER);
		addFirstTalkId(MANAGER);
		addTalkId(MANAGER);
	}

	@Override
	public String onFirstTalk(L2Npc npc, L2PcInstance player)
	{
//		String htmltext = "";
		QuestState st = player.getQuestState(getName());
		if (st == null)
		{
			Quest q = QuestManager.getInstance().getQuest(getName());
			st = q.newQuestState(player);
		}
		switch (npc.getNpcId())
		{
			case MANAGER: return "31860.htm";
		}
		throw new RuntimeException();
	}

	@Override
	public String onEvent(String event, QuestState qs)
	{
		// 31860-1.htm
		return event;
	}

	public static void main(String[] args)
	{
		new SquashEvent(-1, qn, "events");
	}
}