/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.instancemanager;

import com.l2jserver.gameserver.GameTimeController;
import com.l2jserver.gameserver.instancemanager.RaidBossSpawnManager;
import com.l2jserver.gameserver.model.L2Spawn;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2RaidBossInstance;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javolution.util.FastMap;

public class DayNightSpawnManager {
    private static Logger _log = Logger.getLogger(DayNightSpawnManager.class.getName());
    private List<L2Spawn> _dayCreatures = new ArrayList<L2Spawn>();
    private List<L2Spawn> _nightCreatures = new ArrayList<L2Spawn>();
    private Map<L2Spawn, L2RaidBossInstance> _bosses = new FastMap();

    public static DayNightSpawnManager getInstance() {
        return SingletonHolder._instance;
    }

    private DayNightSpawnManager() {
        _log.info("DayNightSpawnManager: Day/Night handler initialized");
    }

    public void addDayCreature(L2Spawn spawnDat) {
        this._dayCreatures.add(spawnDat);
    }

    public void addNightCreature(L2Spawn spawnDat) {
        this._nightCreatures.add(spawnDat);
    }

    public void spawnDayCreatures() {
        this.spawnCreatures(this._nightCreatures, this._dayCreatures, "night", "day");
    }

    public void spawnNightCreatures() {
        this.spawnCreatures(this._dayCreatures, this._nightCreatures, "day", "night");
    }

    private void spawnCreatures(List<L2Spawn> unSpawnCreatures, List<L2Spawn> spawnCreatures, String UnspawnLogInfo, String SpawnLogInfo) {
        try {
            int i;
            if (!unSpawnCreatures.isEmpty()) {
                i = 0;
                for (L2Spawn spawn : unSpawnCreatures) {
                    if (spawn == null) continue;
                    spawn.stopRespawn();
                    L2Npc last = spawn.getLastSpawn();
                    if (last == null) continue;
                    last.deleteMe();
                    ++i;
                }
                _log.info("DayNightSpawnManager: Removed " + i + " " + UnspawnLogInfo + " creatures");
            }
            i = 0;
            for (L2Spawn spawnDat : spawnCreatures) {
                if (spawnDat == null) continue;
                spawnDat.startRespawn();
                spawnDat.doSpawn();
                ++i;
            }
            _log.info("DayNightSpawnManager: Spawned " + i + " " + SpawnLogInfo + " creatures");
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Error while spawning creatures: " + e.getMessage(), e);
        }
    }

    private void changeMode(int mode) {
        if (this._nightCreatures.isEmpty() && this._dayCreatures.isEmpty()) {
            return;
        }
        switch (mode) {
            case 0: {
                this.spawnDayCreatures();
                this.specialNightBoss(0);
                break;
            }
            case 1: {
                this.spawnNightCreatures();
                this.specialNightBoss(1);
                break;
            }
            default: {
                _log.warning("DayNightSpawnManager: Wrong mode sent");
            }
        }
    }

    public DayNightSpawnManager trim() {
        ((ArrayList)this._nightCreatures).trimToSize();
        ((ArrayList)this._dayCreatures).trimToSize();
        return this;
    }

    public void notifyChangeMode() {
        try {
            if (GameTimeController.getInstance().isNowNight()) {
                this.changeMode(1);
            } else {
                this.changeMode(0);
            }
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Error while notifyChangeMode(): " + e.getMessage(), e);
        }
    }

    public void cleanUp() {
        this._nightCreatures.clear();
        this._dayCreatures.clear();
        this._bosses.clear();
    }

    private void specialNightBoss(int mode) {
        try {
            for (L2Spawn spawn : this._bosses.keySet()) {
                L2RaidBossInstance boss = this._bosses.get(spawn);
                if (boss == null && mode == 1) {
                    boss = (L2RaidBossInstance)spawn.doSpawn();
                    RaidBossSpawnManager.getInstance().notifySpawnNightBoss(boss);
                    this._bosses.remove(spawn);
                    this._bosses.put(spawn, boss);
                    continue;
                }
                if (boss == null && mode == 0) continue;
                if (boss.getNpcId() == 25328 && boss.getRaidStatus().equals((Object)RaidBossSpawnManager.StatusEnum.ALIVE)) {
                    this.handleHellmans(boss, mode);
                }
                return;
            }
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Error while specialNoghtBoss(): " + e.getMessage(), e);
        }
    }

    private void handleHellmans(L2RaidBossInstance boss, int mode) {
        switch (mode) {
            case 0: {
                boss.deleteMe();
                _log.info("DayNightSpawnManager: Deleting Hellman raidboss");
                break;
            }
            case 1: {
                boss.spawnMe();
                _log.info("DayNightSpawnManager: Spawning Hellman raidboss");
            }
        }
    }

    public L2RaidBossInstance handleBoss(L2Spawn spawnDat) {
        if (this._bosses.containsKey(spawnDat)) {
            return this._bosses.get(spawnDat);
        }
        if (GameTimeController.getInstance().isNowNight()) {
            L2RaidBossInstance raidboss = (L2RaidBossInstance)spawnDat.doSpawn();
            this._bosses.put(spawnDat, raidboss);
            return raidboss;
        }
        this._bosses.put(spawnDat, null);
        return null;
    }

    private static class SingletonHolder {
        protected static final DayNightSpawnManager _instance = new DayNightSpawnManager();

        private SingletonHolder() {
        }
    }
}

