/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.instancemanager;

import com.l2jserver.Config;
import com.l2jserver.L2DatabaseFactory;
import com.l2jserver.gameserver.model.itemauction.ItemAuctionInstance;
import gnu.trove.TIntObjectHashMap;
import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public final class ItemAuctionManager {
    private static final Logger _log = Logger.getLogger(ItemAuctionManager.class.getName());
    private final TIntObjectHashMap<ItemAuctionInstance> _managerInstances = new TIntObjectHashMap();
    private final AtomicInteger _auctionIds = new AtomicInteger(1);

    public static final ItemAuctionManager getInstance() {
        return SingletonHolder._instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ItemAuctionManager() {
        if (!Config.ALT_ITEM_AUCTION_ENABLED) {
            _log.log(Level.INFO, "ItemAuctionManager: Disabled by config.");
            return;
        }
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("SELECT auctionId FROM item_auction ORDER BY auctionId DESC LIMIT 0, 1");
            ResultSet rset = statement.executeQuery();
            if (rset.next()) {
                this._auctionIds.set(rset.getInt(1) + 1);
            }
        }
        catch (SQLException e) {
            _log.log(Level.SEVERE, "ItemAuctionManager: Failed loading auctions.", e);
        }
        finally {
            L2DatabaseFactory.close(con);
        }
        File file = new File(Config.DATAPACK_ROOT + "/data/ItemAuctions.xml");
        if (!file.exists()) {
            _log.log(Level.WARNING, "ItemAuctionManager: Missing ItemAuctions.xml!");
            return;
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        factory.setIgnoringComments(true);
        try {
            Document doc = factory.newDocumentBuilder().parse(file);
            for (Node na = doc.getFirstChild(); na != null; na = na.getNextSibling()) {
                if (!"list".equalsIgnoreCase(na.getNodeName())) continue;
                for (Node nb = na.getFirstChild(); nb != null; nb = nb.getNextSibling()) {
                    if (!"instance".equalsIgnoreCase(nb.getNodeName())) continue;
                    NamedNodeMap nab = nb.getAttributes();
                    int instanceId = Integer.parseInt(nab.getNamedItem("id").getNodeValue());
                    if (this._managerInstances.containsKey(instanceId)) {
                        throw new Exception("Dublicated instanceId " + instanceId);
                    }
                    ItemAuctionInstance instance = new ItemAuctionInstance(instanceId, this._auctionIds, nb);
                    this._managerInstances.put(instanceId, (Object)instance);
                }
            }
            _log.log(Level.INFO, "ItemAuctionManager: Loaded " + this._managerInstances.size() + " instance(s).");
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "ItemAuctionManager: Failed loading auctions from xml.", e);
        }
    }

    public final void shutdown() {
        ItemAuctionInstance[] instances;
        for (ItemAuctionInstance instance : instances = (ItemAuctionInstance[])this._managerInstances.getValues((Object[])new ItemAuctionInstance[this._managerInstances.size()])) {
            instance.shutdown();
        }
    }

    public final ItemAuctionInstance getManagerInstance(int instanceId) {
        return (ItemAuctionInstance)this._managerInstances.get(instanceId);
    }

    public final int getNextAuctionId() {
        return this._auctionIds.getAndIncrement();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void deleteAuction(int auctionId) {
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("DELETE FROM item_auction WHERE auctionId=?");
            statement.setInt(1, auctionId);
            statement.execute();
            statement.close();
            statement = con.prepareStatement("DELETE FROM item_auction_bid WHERE auctionId=?");
            statement.setInt(1, auctionId);
            statement.execute();
            statement.close();
        }
        catch (SQLException e) {
            _log.log(Level.SEVERE, "L2ItemAuctionManagerInstance: Failed deleting auction: " + auctionId, e);
        }
        finally {
            L2DatabaseFactory.close(con);
        }
    }

    private static class SingletonHolder {
        protected static final ItemAuctionManager _instance = new ItemAuctionManager();

        private SingletonHolder() {
        }
    }
}

