/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model;

import com.l2jserver.gameserver.templates.StatsSet;
import com.l2jserver.util.Rnd;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class ChanceCondition {
    protected static final Logger _log = Logger.getLogger(ChanceCondition.class.getName());
    public static final int EVT_HIT = 1;
    public static final int EVT_CRIT = 2;
    public static final int EVT_CAST = 4;
    public static final int EVT_PHYSICAL = 8;
    public static final int EVT_MAGIC = 16;
    public static final int EVT_MAGIC_GOOD = 32;
    public static final int EVT_MAGIC_OFFENSIVE = 64;
    public static final int EVT_ATTACKED = 128;
    public static final int EVT_ATTACKED_HIT = 256;
    public static final int EVT_ATTACKED_CRIT = 512;
    public static final int EVT_HIT_BY_SKILL = 1024;
    public static final int EVT_HIT_BY_OFFENSIVE_SKILL = 2048;
    public static final int EVT_HIT_BY_GOOD_MAGIC = 4096;
    public static final int EVT_EVADED_HIT = 8192;
    public static final int EVT_ON_START = 16384;
    public static final int EVT_ON_ACTION_TIME = 32768;
    public static final int EVT_ON_EXIT = 65536;
    private final TriggerType _triggerType;
    private final int _chance;
    private final int _mindmg;
    private final byte[] _elements;
    private final boolean _pvpOnly;

    private ChanceCondition(TriggerType trigger, int chance, int mindmg, byte[] elements, boolean pvpOnly) {
        this._triggerType = trigger;
        this._chance = chance;
        this._mindmg = mindmg;
        this._elements = elements;
        this._pvpOnly = pvpOnly;
    }

    public static ChanceCondition parse(StatsSet set) {
        try {
            TriggerType trigger = set.getEnum("chanceType", TriggerType.class, null);
            int chance = set.getInteger("activationChance", -1);
            int mindmg = set.getInteger("activationMinDamage", -1);
            String elements = set.getString("activationElements", null);
            boolean pvpOnly = set.getBool("pvpChanceOnly", false);
            if (trigger != null) {
                return new ChanceCondition(trigger, chance, mindmg, ChanceCondition.parseElements(elements), pvpOnly);
            }
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "", e);
        }
        return null;
    }

    public static ChanceCondition parse(String chanceType, int chance, int mindmg, String elements, boolean pvpOnly) {
        try {
            if (chanceType == null) {
                return null;
            }
            TriggerType trigger = Enum.valueOf(TriggerType.class, chanceType);
            if (trigger != null) {
                return new ChanceCondition(trigger, chance, mindmg, ChanceCondition.parseElements(elements), pvpOnly);
            }
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "", e);
        }
        return null;
    }

    public static final byte[] parseElements(String list) {
        if (list == null) {
            return null;
        }
        String[] valuesSplit = list.split(",");
        byte[] elements = new byte[valuesSplit.length];
        for (int i = 0; i < valuesSplit.length; ++i) {
            elements[i] = Byte.parseByte(valuesSplit[i]);
        }
        Arrays.sort(elements);
        return elements;
    }

    public boolean trigger(int event, int damage, byte element, boolean playable) {
        if (this._pvpOnly && !playable) {
            return false;
        }
        if (this._elements != null && Arrays.binarySearch(this._elements, element) < 0) {
            return false;
        }
        if (this._mindmg > -1 && this._mindmg > damage) {
            return false;
        }
        return this._triggerType.check(event) && (this._chance < 0 || Rnd.get(100) < this._chance);
    }

    public String toString() {
        return "Trigger[" + this._chance + ";" + this._triggerType.toString() + "]";
    }

    public static enum TriggerType {
        ON_HIT(1),
        ON_CRIT(2),
        ON_CAST(4),
        ON_PHYSICAL(8),
        ON_MAGIC(16),
        ON_MAGIC_GOOD(32),
        ON_MAGIC_OFFENSIVE(64),
        ON_ATTACKED(128),
        ON_ATTACKED_HIT(256),
        ON_ATTACKED_CRIT(512),
        ON_HIT_BY_SKILL(1024),
        ON_HIT_BY_OFFENSIVE_SKILL(2048),
        ON_HIT_BY_GOOD_MAGIC(4096),
        ON_EVADED_HIT(8192),
        ON_START(16384),
        ON_ACTION_TIME(32768),
        ON_EXIT(65536);

        private final int _mask;

        private TriggerType(int mask) {
            this._mask = mask;
        }

        public final boolean check(int event) {
            return (this._mask & event) != 0;
        }
    }
}

