/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model;

import com.l2jserver.gameserver.datatables.AccessLevels;
import com.l2jserver.gameserver.model.L2AccessLevel;

public class L2AdminCommandAccessRight {
    private String _adminCommand = null;
    private L2AccessLevel[] _accessLevels = null;

    public L2AdminCommandAccessRight(String adminCommand, String accessLevels) {
        this._adminCommand = adminCommand;
        String[] accessLevelsSplit = accessLevels.split(",");
        int numLevels = accessLevelsSplit.length;
        this._accessLevels = new L2AccessLevel[numLevels];
        for (int i = 0; i < numLevels; ++i) {
            try {
                this._accessLevels[i] = AccessLevels.getInstance().getAccessLevel(Integer.parseInt(accessLevelsSplit[i]));
                continue;
            }
            catch (NumberFormatException nfe) {
                this._accessLevels[i] = null;
            }
        }
    }

    public String getAdminCommand() {
        return this._adminCommand;
    }

    public boolean hasAccess(L2AccessLevel characterAccessLevel) {
        for (int i = 0; i < this._accessLevels.length; ++i) {
            L2AccessLevel accessLevel = this._accessLevels[i];
            if (accessLevel == null || accessLevel.getLevel() != characterAccessLevel.getLevel() && !characterAccessLevel.hasChildAccess(accessLevel)) continue;
            return true;
        }
        return false;
    }
}

