/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor;

import com.l2jserver.Config;
import com.l2jserver.gameserver.GameTimeController;
import com.l2jserver.gameserver.GeoData;
import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.ai.CtrlEvent;
import com.l2jserver.gameserver.ai.CtrlIntention;
import com.l2jserver.gameserver.ai.L2AttackableAI;
import com.l2jserver.gameserver.ai.L2CharacterAI;
import com.l2jserver.gameserver.datatables.DoorTable;
import com.l2jserver.gameserver.datatables.ItemTable;
import com.l2jserver.gameserver.datatables.MapRegionTable;
import com.l2jserver.gameserver.datatables.SkillTable;
import com.l2jserver.gameserver.handler.ISkillHandler;
import com.l2jserver.gameserver.handler.SkillHandler;
import com.l2jserver.gameserver.instancemanager.DimensionalRiftManager;
import com.l2jserver.gameserver.instancemanager.InstanceManager;
import com.l2jserver.gameserver.instancemanager.TerritoryWarManager;
import com.l2jserver.gameserver.instancemanager.TownManager;
import com.l2jserver.gameserver.model.ChanceSkillList;
import com.l2jserver.gameserver.model.CharEffectList;
import com.l2jserver.gameserver.model.FusionSkill;
import com.l2jserver.gameserver.model.IChanceSkillTrigger;
import com.l2jserver.gameserver.model.L2CharPosition;
import com.l2jserver.gameserver.model.L2Effect;
import com.l2jserver.gameserver.model.L2ItemInstance;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.L2Party;
import com.l2jserver.gameserver.model.L2Skill;
import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.L2WorldRegion;
import com.l2jserver.gameserver.model.Location;
import com.l2jserver.gameserver.model.actor.L2Attackable;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.L2Playable;
import com.l2jserver.gameserver.model.actor.L2Summon;
import com.l2jserver.gameserver.model.actor.L2Trap;
import com.l2jserver.gameserver.model.actor.instance.L2DoorInstance;
import com.l2jserver.gameserver.model.actor.instance.L2MinionInstance;
import com.l2jserver.gameserver.model.actor.instance.L2NpcWalkerInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PetInstance;
import com.l2jserver.gameserver.model.actor.instance.L2RiftInvaderInstance;
import com.l2jserver.gameserver.model.actor.knownlist.CharKnownList;
import com.l2jserver.gameserver.model.actor.position.CharPosition;
import com.l2jserver.gameserver.model.actor.stat.CharStat;
import com.l2jserver.gameserver.model.actor.status.CharStatus;
import com.l2jserver.gameserver.model.entity.Instance;
import com.l2jserver.gameserver.model.itemcontainer.Inventory;
import com.l2jserver.gameserver.model.quest.Quest;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.AbstractNpcInfo;
import com.l2jserver.gameserver.network.serverpackets.ActionFailed;
import com.l2jserver.gameserver.network.serverpackets.Attack;
import com.l2jserver.gameserver.network.serverpackets.ChangeMoveType;
import com.l2jserver.gameserver.network.serverpackets.ChangeWaitType;
import com.l2jserver.gameserver.network.serverpackets.FlyToLocation;
import com.l2jserver.gameserver.network.serverpackets.L2GameServerPacket;
import com.l2jserver.gameserver.network.serverpackets.MagicSkillCanceld;
import com.l2jserver.gameserver.network.serverpackets.MagicSkillLaunched;
import com.l2jserver.gameserver.network.serverpackets.MagicSkillUse;
import com.l2jserver.gameserver.network.serverpackets.MoveToLocation;
import com.l2jserver.gameserver.network.serverpackets.Revive;
import com.l2jserver.gameserver.network.serverpackets.ServerObjectInfo;
import com.l2jserver.gameserver.network.serverpackets.SetupGauge;
import com.l2jserver.gameserver.network.serverpackets.StatusUpdate;
import com.l2jserver.gameserver.network.serverpackets.StopMove;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.network.serverpackets.TeleportToLocation;
import com.l2jserver.gameserver.pathfinding.AbstractNodeLoc;
import com.l2jserver.gameserver.pathfinding.PathFinding;
import com.l2jserver.gameserver.skills.AbnormalEffect;
import com.l2jserver.gameserver.skills.Calculator;
import com.l2jserver.gameserver.skills.Formulas;
import com.l2jserver.gameserver.skills.Stats;
import com.l2jserver.gameserver.skills.effects.EffectChanceSkillTrigger;
import com.l2jserver.gameserver.skills.funcs.Func;
import com.l2jserver.gameserver.skills.l2skills.L2SkillAgathion;
import com.l2jserver.gameserver.skills.l2skills.L2SkillMount;
import com.l2jserver.gameserver.skills.l2skills.L2SkillSummon;
import com.l2jserver.gameserver.taskmanager.AttackStanceTaskManager;
import com.l2jserver.gameserver.templates.chars.L2CharTemplate;
import com.l2jserver.gameserver.templates.chars.L2NpcTemplate;
import com.l2jserver.gameserver.templates.item.L2Weapon;
import com.l2jserver.gameserver.templates.item.L2WeaponType;
import com.l2jserver.gameserver.templates.skills.L2EffectType;
import com.l2jserver.gameserver.templates.skills.L2SkillType;
import com.l2jserver.gameserver.util.Util;
import com.l2jserver.util.Point3D;
import com.l2jserver.util.Rnd;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import javolution.util.FastList;
import javolution.util.FastMap;
import javolution.util.WeakFastSet;

public abstract class L2Character
extends L2Object {
    public static final Logger _log = Logger.getLogger(L2Character.class.getName());
    private Set<L2Character> _attackByList;
    private volatile boolean _isCastingNow = false;
    private volatile boolean _isCastingSimultaneouslyNow = false;
    private L2Skill _lastSkillCast;
    private L2Skill _lastSimultaneousSkillCast;
    private boolean _isAfraid = false;
    private boolean _isConfused = false;
    private boolean _isFallsdown;
    private boolean _isMuted = false;
    private boolean _isPhysicalMuted = false;
    private boolean _isPhysicalAttackMuted = false;
    private boolean _isDead = false;
    private boolean _isImmobilized = false;
    private boolean _isOverloaded = false;
    private boolean _isParalyzed = false;
    private boolean _isDisarmed = false;
    private boolean _isPendingRevive = false;
    private boolean _isRooted = false;
    private boolean _isRunning = false;
    private boolean _isNoRndWalk = false;
    private boolean _isSleeping = false;
    private boolean _isStunned = false;
    private boolean _isBetrayed = false;
    protected boolean _showSummonAnimation = false;
    protected boolean _isTeleporting = false;
    protected boolean _isInvul = false;
    private boolean _isMortal = true;
    private boolean _isFlying = false;
    private CharStat _stat;
    private CharStatus _status;
    private L2CharTemplate _template;
    private String _title;
    private double _hpUpdateIncCheck = 0.0;
    private double _hpUpdateDecCheck = 0.0;
    private double _hpUpdateInterval = 0.0;
    private Calculator[] _calculators;
    protected final Map<Integer, L2Skill> _skills;
    private ChanceSkillList _chanceSkills;
    protected FusionSkill _fusionSkill;
    public static final byte ZONE_PVP = 0;
    public static final byte ZONE_PEACE = 1;
    public static final byte ZONE_SIEGE = 2;
    public static final byte ZONE_MOTHERTREE = 3;
    public static final byte ZONE_CLANHALL = 4;
    public static final byte ZONE_LANDING = 5;
    public static final byte ZONE_NOLANDING = 6;
    public static final byte ZONE_WATER = 7;
    public static final byte ZONE_JAIL = 8;
    public static final byte ZONE_MONSTERTRACK = 9;
    public static final byte ZONE_CASTLE = 10;
    public static final byte ZONE_SWAMP = 11;
    public static final byte ZONE_NOSUMMONFRIEND = 12;
    public static final byte ZONE_FORT = 13;
    public static final byte ZONE_NOSTORE = 14;
    public static final byte ZONE_TOWN = 15;
    public static final byte ZONE_SCRIPT = 16;
    public static final byte ZONE_NOHQ = 17;
    public static final byte ZONE_DANGERAREA = 18;
    public static final byte ZONE_ALTERED = 19;
    private final byte[] _zones = new byte[20];
    protected byte _zoneValidateCounter = (byte)4;
    private L2Character _debugger = null;
    private int _AbnormalEffects;
    protected CharEffectList _effects = new CharEffectList(this);
    private int _SpecialEffects;
    protected Map<Integer, Long> _disabledSkills;
    private boolean _allSkillsDisabled;
    protected MoveData _move;
    private int _heading;
    private L2Object _target;
    private int _attackEndTime;
    private int _attacking;
    private int _disableBowAttackEndTime;
    private int _disableCrossBowAttackEndTime;
    private int _castEndTime;
    private int _castInterruptTime;
    private static final Calculator[] NPC_STD_CALCULATOR = Formulas.getStdNPCCalculators();
    protected L2CharacterAI _ai;
    protected Future<?> _skillCast;
    protected Future<?> _skillCast2;
    private boolean _AIdisabled = false;

    public boolean isDebug() {
        return this._debugger != null;
    }

    public void setDebug(L2Character d) {
        this._debugger = d;
    }

    public void sendDebugPacket(L2GameServerPacket pkt) {
        if (this._debugger != null) {
            this._debugger.sendPacket(pkt);
        }
    }

    public void sendDebugMessage(String msg) {
        if (this._debugger != null) {
            this._debugger.sendMessage(msg);
        }
    }

    public Inventory getInventory() {
        return null;
    }

    public boolean destroyItemByItemId(String process, int itemId, long count, L2Object reference, boolean sendMessage) {
        return true;
    }

    public boolean destroyItem(String process, int objectId, long count, L2Object reference, boolean sendMessage) {
        return true;
    }

    public final boolean isInsideZone(byte zone) {
        Instance instance = InstanceManager.getInstance().getInstance(this.getInstanceId());
        switch (zone) {
            case 0: {
                if (instance != null && instance.isPvPInstance()) {
                    return true;
                }
                return this._zones[0] > 0 && this._zones[1] == 0;
            }
            case 1: {
                if (instance == null || !instance.isPvPInstance()) break;
                return false;
            }
        }
        return this._zones[zone] > 0;
    }

    public final void setInsideZone(byte zone, boolean state) {
        if (state) {
            byte by = zone;
            this._zones[by] = (byte)(this._zones[by] + 1);
        } else {
            byte by = zone;
            this._zones[by] = (byte)(this._zones[by] - 1);
            if (this._zones[zone] < 0) {
                this._zones[zone] = 0;
            }
        }
    }

    public boolean isTransformed() {
        return false;
    }

    public void untransform() {
    }

    public boolean isGM() {
        return false;
    }

    public L2Character(int objectId, L2CharTemplate template) {
        super(objectId);
        this.setInstanceType(L2Object.InstanceType.L2Character);
        this.initCharStat();
        this.initCharStatus();
        this._template = template;
        if (this instanceof L2DoorInstance) {
            this._calculators = Formulas.getStdDoorCalculators();
            this._skills = null;
        } else if (template != null && this instanceof L2Npc) {
            this._calculators = NPC_STD_CALCULATOR;
            this._skills = ((L2NpcTemplate)template).getSkills();
            if (this._skills != null) {
                for (Map.Entry<Integer, L2Skill> skill : this._skills.entrySet()) {
                    this.addStatFuncs(skill.getValue().getStatFuncs(null, this));
                }
            }
        } else {
            this._calculators = new Calculator[Stats.NUM_STATS];
            if (this instanceof L2Summon) {
                this._skills = ((L2NpcTemplate)template).getSkills() == null ? new FastMap().shared() : ((L2NpcTemplate)template).getSkills();
                if (this._skills != null) {
                    for (Map.Entry<Integer, L2Skill> skill : this._skills.entrySet()) {
                        this.addStatFuncs(skill.getValue().getStatFuncs(null, this));
                    }
                }
            } else {
                this._skills = new FastMap().shared();
            }
            Formulas.addFuncsToNewCharacter(this);
        }
        this.setIsInvul(true);
    }

    protected void initCharStatusUpdateValues() {
        this._hpUpdateIncCheck = this.getMaxVisibleHp();
        this._hpUpdateInterval = this._hpUpdateIncCheck / 352.0;
        this._hpUpdateDecCheck = this._hpUpdateIncCheck - this._hpUpdateInterval;
    }

    public void onDecay() {
        L2WorldRegion reg = this.getWorldRegion();
        this.decayMe();
        if (reg != null) {
            reg.removeFromZones(this);
        }
    }

    @Override
    public void onSpawn() {
        super.onSpawn();
        this.revalidateZone(true);
    }

    public void onTeleported() {
        if (!this.isTeleporting()) {
            return;
        }
        this.spawnMe(this.getPosition().getX(), this.getPosition().getY(), this.getPosition().getZ());
        this.setIsTeleporting(false);
        if (this._isPendingRevive) {
            this.doRevive();
        }
    }

    public void addAttackerToAttackByList(L2Character player) {
    }

    public void broadcastPacket(L2GameServerPacket mov) {
        Collection<L2PcInstance> plrs = this.getKnownList().getKnownPlayers().values();
        for (L2PcInstance player : plrs) {
            if (player == null) continue;
            player.sendPacket(mov);
        }
    }

    public void broadcastPacket(L2GameServerPacket mov, int radiusInKnownlist) {
        Collection<L2PcInstance> plrs = this.getKnownList().getKnownPlayers().values();
        for (L2PcInstance player : plrs) {
            if (player == null || !this.isInsideRadius(player, radiusInKnownlist, false, false)) continue;
            player.sendPacket(mov);
        }
    }

    protected boolean needHpUpdate(int barPixels) {
        double currentHp = this.getCurrentHp();
        double maxHp = this.getMaxVisibleHp();
        if (currentHp <= 1.0 || maxHp < (double)barPixels) {
            return true;
        }
        if (currentHp <= this._hpUpdateDecCheck || currentHp >= this._hpUpdateIncCheck) {
            if (currentHp == maxHp) {
                this._hpUpdateIncCheck = currentHp + 1.0;
                this._hpUpdateDecCheck = currentHp - this._hpUpdateInterval;
            } else {
                double doubleMulti = currentHp / this._hpUpdateInterval;
                int intMulti = (int)doubleMulti;
                this._hpUpdateDecCheck = this._hpUpdateInterval * (double)(doubleMulti < (double)intMulti ? intMulti-- : intMulti);
                this._hpUpdateIncCheck = this._hpUpdateDecCheck + this._hpUpdateInterval;
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void broadcastStatusUpdate() {
        if (this.getStatus().getStatusListener().isEmpty()) {
            return;
        }
        if (!this.needHpUpdate(352)) {
            return;
        }
        if (Config.DEBUG) {
            _log.fine("Broadcast Status Update for " + this.getObjectId() + "(" + this.getName() + "). HP: " + this.getCurrentHp());
        }
        StatusUpdate su = new StatusUpdate(this);
        su.addAttribute(9, (int)this.getCurrentHp());
        Set<L2Character> set = this.getStatus().getStatusListener();
        synchronized (set) {
            for (L2Character temp : this.getStatus().getStatusListener()) {
                if (temp == null) continue;
                temp.sendPacket(su);
            }
        }
    }

    public void sendMessage(String text) {
    }

    public void teleToLocation(int x, int y, int z, int heading, boolean allowRandomOffset) {
        this.stopMove(null, false);
        this.abortAttack();
        this.abortCast();
        this.setIsTeleporting(true);
        this.setTarget(null);
        this.getAI().setIntention(CtrlIntention.AI_INTENTION_ACTIVE);
        if (Config.OFFSET_ON_TELEPORT_ENABLED && allowRandomOffset) {
            x += Rnd.get(-Config.MAX_OFFSET_ON_TELEPORT, Config.MAX_OFFSET_ON_TELEPORT);
            y += Rnd.get(-Config.MAX_OFFSET_ON_TELEPORT, Config.MAX_OFFSET_ON_TELEPORT);
        }
        z += 5;
        if (Config.DEBUG) {
            _log.fine("Teleporting to: " + x + ", " + y + ", " + z);
        }
        this.broadcastPacket(new TeleportToLocation(this, x, y, z, heading));
        this.decayMe();
        this.getPosition().setXYZ(x, y, z);
        if (heading != 0) {
            this.getPosition().setHeading(heading);
        }
        if (!(this instanceof L2PcInstance) || ((L2PcInstance)this).getClient() != null && ((L2PcInstance)this).getClient().isDetached()) {
            this.onTeleported();
        }
        this.revalidateZone(true);
    }

    public void teleToLocation(int x, int y, int z) {
        this.teleToLocation(x, y, z, this.getHeading(), false);
    }

    public void teleToLocation(int x, int y, int z, boolean allowRandomOffset) {
        this.teleToLocation(x, y, z, this.getHeading(), allowRandomOffset);
    }

    public void teleToLocation(Location loc, boolean allowRandomOffset) {
        int x = loc.getX();
        int y = loc.getY();
        int z = loc.getZ();
        if (this instanceof L2PcInstance && DimensionalRiftManager.getInstance().checkIfInRiftZone(this.getX(), this.getY(), this.getZ(), true)) {
            L2PcInstance player = (L2PcInstance)this;
            player.sendMessage("You have been sent to the waiting room.");
            if (player.isInParty() && player.getParty().isInDimensionalRift()) {
                player.getParty().getDimensionalRift().usedTeleport(player);
            }
            int[] newCoords = DimensionalRiftManager.getInstance().getRoom((byte)0, (byte)0).getTeleportCoords();
            x = newCoords[0];
            y = newCoords[1];
            z = newCoords[2];
        }
        this.teleToLocation(x, y, z, this.getHeading(), allowRandomOffset);
    }

    public void teleToLocation(MapRegionTable.TeleportWhereType teleportWhere) {
        this.teleToLocation(MapRegionTable.getInstance().getTeleToLocation(this, teleportWhere), true);
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void doAttack(L2Character target) {
        boolean wasSSCharged;
        if (Config.DEBUG) {
            _log.fine(this.getName() + " doAttack: target=" + target);
        }
        if (!this.isAlikeDead() && target != null) {
            if (this instanceof L2Npc && target.isAlikeDead() || !this.getKnownList().knowsObject(target)) {
                this.getAI().setIntention(CtrlIntention.AI_INTENTION_ACTIVE);
                this.sendPacket(ActionFailed.STATIC_PACKET);
                return;
            }
            if (this instanceof L2PcInstance) {
                if (target.isDead()) {
                    this.getAI().setIntention(CtrlIntention.AI_INTENTION_ACTIVE);
                    this.sendPacket(ActionFailed.STATIC_PACKET);
                    return;
                }
                L2PcInstance actor = (L2PcInstance)this;
                if (actor.isMounted() && actor.getMountNpcId() == 12621 || actor.isTransformed() && !actor.getTransformation().canDoMeleeAttack()) {
                    this.sendPacket(ActionFailed.STATIC_PACKET);
                    return;
                }
            }
        }
        if (this.isAttackingDisabled()) {
            return;
        }
        if (this instanceof L2PcInstance) {
            if (((L2PcInstance)this).inObserverMode()) {
                this.sendPacket(new SystemMessage(SystemMessageId.OBSERVERS_CANNOT_PARTICIPATE));
                this.sendPacket(ActionFailed.STATIC_PACKET);
                return;
            }
            if (target.getActingPlayer() != null && ((L2PcInstance)this).getSiegeState() > 0 && this.isInsideZone((byte)2) && target.getActingPlayer().getSiegeState() == ((L2PcInstance)this).getSiegeState() && target.getActingPlayer() != this && target.getActingPlayer().getSiegeSide() == ((L2PcInstance)this).getSiegeSide()) {
                if (TerritoryWarManager.getInstance().isTWInProgress()) {
                    this.sendPacket(new SystemMessage(SystemMessageId.YOU_CANNOT_ATTACK_A_MEMBER_OF_THE_SAME_TERRITORY));
                } else {
                    this.sendPacket(new SystemMessage(SystemMessageId.FORCED_ATTACK_IS_IMPOSSIBLE_AGAINST_SIEGE_SIDE_TEMPORARY_ALLIED_MEMBERS));
                }
                this.sendPacket(ActionFailed.STATIC_PACKET);
                return;
            }
            if (target.isInsidePeaceZone((L2PcInstance)this)) {
                this.getAI().setIntention(CtrlIntention.AI_INTENTION_ACTIVE);
                this.sendPacket(ActionFailed.STATIC_PACKET);
                return;
            }
            if (((L2PcInstance)this).getActiveWeaponItem() != null && ((L2PcInstance)this).getActiveWeaponItem().getItemId() == 9819) {
                this.sendPacket(new SystemMessage(SystemMessageId.THAT_WEAPON_CANT_ATTACK));
                this.sendPacket(ActionFailed.STATIC_PACKET);
                return;
            }
        } else if (this.isInsidePeaceZone(this, (L2Object)target)) {
            this.getAI().setIntention(CtrlIntention.AI_INTENTION_ACTIVE);
            this.sendPacket(ActionFailed.STATIC_PACKET);
            return;
        }
        this.stopEffectsOnAction();
        L2ItemInstance weaponInst = this.getActiveWeaponInstance();
        L2Weapon weaponItem = this.getActiveWeaponItem();
        if (weaponItem != null && weaponItem.getItemType() == L2WeaponType.ROD) {
            this.sendPacket(new SystemMessage(SystemMessageId.CANNOT_ATTACK_WITH_FISHING_POLE));
            this.getAI().setIntention(CtrlIntention.AI_INTENTION_IDLE);
            this.sendPacket(ActionFailed.STATIC_PACKET);
            return;
        }
        if (!GeoData.getInstance().canSeeTarget((L2Object)this, target)) {
            this.sendPacket(new SystemMessage(SystemMessageId.CANT_SEE_TARGET));
            this.getAI().setIntention(CtrlIntention.AI_INTENTION_ACTIVE);
            this.sendPacket(ActionFailed.STATIC_PACKET);
            return;
        }
        if (weaponItem != null && !this.isTransformed()) {
            if (weaponItem.getItemType() == L2WeaponType.BOW && this instanceof L2PcInstance) {
                if (!this.checkAndEquipArrows()) {
                    this.getAI().setIntention(CtrlIntention.AI_INTENTION_IDLE);
                    this.sendPacket(ActionFailed.STATIC_PACKET);
                    this.sendPacket(new SystemMessage(SystemMessageId.NOT_ENOUGH_ARROWS));
                    return;
                }
                if (this._disableBowAttackEndTime > GameTimeController.getGameTicks()) {
                    ThreadPoolManager.getInstance().scheduleAi(new NotifyAITask(CtrlEvent.EVT_READY_TO_ACT), 1000L);
                    this.sendPacket(ActionFailed.STATIC_PACKET);
                    return;
                }
                int saMpConsume = (int)this.getStat().calcStat(Stats.MP_CONSUME, 0.0, null, null);
                int mpConsume = saMpConsume == 0 ? weaponItem.getMpConsume() : saMpConsume;
                mpConsume = (int)this.calcStat(Stats.BOW_MP_CONSUME_RATE, mpConsume, null, null);
                if (this.getCurrentMp() < (double)mpConsume) {
                    ThreadPoolManager.getInstance().scheduleAi(new NotifyAITask(CtrlEvent.EVT_READY_TO_ACT), 1000L);
                    this.sendPacket(new SystemMessage(SystemMessageId.NOT_ENOUGH_MP));
                    this.sendPacket(ActionFailed.STATIC_PACKET);
                    return;
                }
                if (mpConsume > 0) {
                    this.getStatus().reduceMp(mpConsume);
                }
                this._disableBowAttackEndTime = 50 + GameTimeController.getGameTicks();
            }
            if (weaponItem.getItemType() == L2WeaponType.CROSSBOW) {
                if (this instanceof L2PcInstance) {
                    if (target.isInsidePeaceZone((L2PcInstance)this)) {
                        this.getAI().setIntention(CtrlIntention.AI_INTENTION_ACTIVE);
                        this.sendPacket(ActionFailed.STATIC_PACKET);
                        return;
                    }
                    if (!this.checkAndEquipBolts()) {
                        this.getAI().setIntention(CtrlIntention.AI_INTENTION_IDLE);
                        this.sendPacket(ActionFailed.STATIC_PACKET);
                        this.sendPacket(new SystemMessage(SystemMessageId.NOT_ENOUGH_BOLTS));
                        return;
                    }
                    if (this._disableCrossBowAttackEndTime > GameTimeController.getGameTicks()) {
                        ThreadPoolManager.getInstance().scheduleAi(new NotifyAITask(CtrlEvent.EVT_READY_TO_ACT), 1000L);
                        this.sendPacket(ActionFailed.STATIC_PACKET);
                        return;
                    }
                    this._disableCrossBowAttackEndTime = 50 + GameTimeController.getGameTicks();
                } else if (this instanceof L2Npc && this._disableCrossBowAttackEndTime > GameTimeController.getGameTicks()) {
                    return;
                }
            }
        }
        target.getKnownList().addKnownObject(this);
        if (Config.ALT_GAME_TIREDNESS) {
            this.setCurrentCp(this.getCurrentCp() - 10.0);
        }
        if (this instanceof L2PcInstance) {
            ((L2PcInstance)this).rechargeAutoSoulShot(true, false, false);
        } else if (this instanceof L2Summon) {
            ((L2Summon)this).getOwner().rechargeAutoSoulShot(true, false, true);
        }
        if (this instanceof L2Summon && (!(this instanceof L2PetInstance) || weaponInst == null)) {
            wasSSCharged = ((L2Summon)this).getChargedSoulShot() != 0;
        } else {
            boolean bl = wasSSCharged = weaponInst != null && weaponInst.getChargedSoulshot() != 0;
        }
        if (this instanceof L2Attackable && ((L2Npc)this).useSoulShot()) {
            wasSSCharged = true;
        }
        int timeAtk = this.calculateTimeBetweenAttacks(target, weaponItem);
        int timeToHit = timeAtk / 2;
        this._attackEndTime = GameTimeController.getGameTicks();
        this._attackEndTime += timeAtk / 100;
        --this._attackEndTime;
        int ssGrade = 0;
        if (weaponItem != null) {
            ssGrade = weaponItem.getItemGradeSPlus();
        }
        Attack attack = new Attack(this, target, wasSSCharged, ssGrade);
        this.setAttackingBodypart();
        this.setHeading(Util.calculateHeadingFrom(this, target));
        int reuse = this.calculateReuseTime(target, weaponItem);
        boolean hitted = weaponItem == null || this.isTransformed() ? this.doAttackHitSimple(attack, target, timeToHit) : (weaponItem.getItemType() == L2WeaponType.BOW ? this.doAttackHitByBow(attack, target, timeAtk, reuse) : (weaponItem.getItemType() == L2WeaponType.CROSSBOW ? this.doAttackHitByCrossBow(attack, target, timeAtk, reuse) : (weaponItem.getItemType() == L2WeaponType.POLE ? this.doAttackHitByPole(attack, target, timeToHit) : (this.isUsingDualWeapon() ? this.doAttackHitByDual(attack, target, timeToHit) : this.doAttackHitSimple(attack, target, timeToHit)))));
        L2PcInstance player = this.getActingPlayer();
        if (player != null) {
            AttackStanceTaskManager.getInstance().addAttackStanceTask(player);
        }
        if (player != null && player.getPet() != target) {
            player.updatePvPStatus(target);
        }
        if (!hitted) {
            this.abortAttack();
        } else {
            if (this instanceof L2Summon && (!(this instanceof L2PetInstance) || weaponInst == null)) {
                ((L2Summon)this).setChargedSoulShot(0);
            } else if (weaponInst != null) {
                weaponInst.setChargedSoulshot(0);
            }
            if (player != null) {
                if (player.isCursedWeaponEquipped()) {
                    if (!target.isInvul()) {
                        target.setCurrentCp(0.0);
                    }
                } else if (player.isHero() && target instanceof L2PcInstance && ((L2PcInstance)target).isCursedWeaponEquipped()) {
                    target.setCurrentCp(0.0);
                }
            }
        }
        if (attack.hasHits()) {
            this.broadcastPacket(attack);
        }
        ThreadPoolManager.getInstance().scheduleAi(new NotifyAITask(CtrlEvent.EVT_READY_TO_ACT), timeAtk + reuse);
    }

    private boolean doAttackHitByBow(Attack attack, L2Character target, int sAtk, int reuse) {
        int damage1 = 0;
        byte shld1 = 0;
        boolean crit1 = false;
        boolean miss1 = Formulas.calcHitMiss(this, target);
        this.reduceArrowCount(false);
        this._move = null;
        if (!miss1) {
            shld1 = Formulas.calcShldUse(this, target);
            crit1 = Formulas.calcCrit(this.getStat().getCriticalHit(target, null), target);
            damage1 = (int)Formulas.calcPhysDam(this, target, null, shld1, crit1, false, attack.soulshot);
            double range = Math.sqrt(this.getDistanceSq(target));
            if (range < 1600.0) {
                double dmgmod = 1.0 - (1.0 - range / 800.0) * 0.35;
                if (dmgmod > 1.0) {
                    dmgmod = 2.0 - dmgmod;
                }
                if (dmgmod > 0.0) {
                    damage1 = (int)((double)damage1 * dmgmod);
                }
            } else {
                damage1 = (int)((double)damage1 * 0.65);
            }
        }
        if (this instanceof L2PcInstance) {
            this.sendPacket(new SystemMessage(SystemMessageId.GETTING_READY_TO_SHOOT_AN_ARROW));
            SetupGauge sg = new SetupGauge(1, sAtk + reuse);
            this.sendPacket(sg);
        }
        ThreadPoolManager.getInstance().scheduleAi(new HitTask(target, damage1, crit1, miss1, attack.soulshot, shld1), sAtk);
        this._disableBowAttackEndTime = (sAtk + reuse) / 100 + GameTimeController.getGameTicks();
        attack.hit(attack.createHit(target, damage1, miss1, crit1, shld1));
        return !miss1;
    }

    private boolean doAttackHitByCrossBow(Attack attack, L2Character target, int sAtk, int reuse) {
        int damage1 = 0;
        byte shld1 = 0;
        boolean crit1 = false;
        boolean miss1 = Formulas.calcHitMiss(this, target);
        this.reduceArrowCount(true);
        this._move = null;
        if (!miss1) {
            shld1 = Formulas.calcShldUse(this, target);
            crit1 = Formulas.calcCrit(this.getStat().getCriticalHit(target, null), target);
            damage1 = (int)Formulas.calcPhysDam(this, target, null, shld1, crit1, false, attack.soulshot);
        }
        if (this instanceof L2PcInstance) {
            this.sendPacket(new SystemMessage(SystemMessageId.CROSSBOW_PREPARING_TO_FIRE));
            SetupGauge sg = new SetupGauge(1, sAtk + reuse);
            this.sendPacket(sg);
        }
        if (this instanceof L2Attackable) {
            if (((L2Attackable)this)._soulshotcharged) {
                ThreadPoolManager.getInstance().scheduleAi(new HitTask(target, damage1, crit1, miss1, true, shld1), sAtk);
            } else {
                ThreadPoolManager.getInstance().scheduleAi(new HitTask(target, damage1, crit1, miss1, false, shld1), sAtk);
            }
        } else {
            ThreadPoolManager.getInstance().scheduleAi(new HitTask(target, damage1, crit1, miss1, attack.soulshot, shld1), sAtk);
        }
        this._disableCrossBowAttackEndTime = (sAtk + reuse) / 100 + GameTimeController.getGameTicks();
        attack.hit(attack.createHit(target, damage1, miss1, crit1, shld1));
        return !miss1;
    }

    private boolean doAttackHitByDual(Attack attack, L2Character target, int sAtk) {
        int damage1 = 0;
        int damage2 = 0;
        byte shld1 = 0;
        byte shld2 = 0;
        boolean crit1 = false;
        boolean crit2 = false;
        boolean miss1 = Formulas.calcHitMiss(this, target);
        boolean miss2 = Formulas.calcHitMiss(this, target);
        if (!miss1) {
            shld1 = Formulas.calcShldUse(this, target);
            crit1 = Formulas.calcCrit(this.getStat().getCriticalHit(target, null), target);
            damage1 = (int)Formulas.calcPhysDam(this, target, null, shld1, crit1, true, attack.soulshot);
            damage1 /= 2;
        }
        if (!miss2) {
            shld2 = Formulas.calcShldUse(this, target);
            crit2 = Formulas.calcCrit(this.getStat().getCriticalHit(target, null), target);
            damage2 = (int)Formulas.calcPhysDam(this, target, null, shld2, crit2, true, attack.soulshot);
            damage2 /= 2;
        }
        if (this instanceof L2Attackable) {
            if (((L2Attackable)this)._soulshotcharged) {
                ThreadPoolManager.getInstance().scheduleAi(new HitTask(target, damage1, crit1, miss1, true, shld1), sAtk / 2);
                ThreadPoolManager.getInstance().scheduleAi(new HitTask(target, damage2, crit2, miss2, true, shld2), sAtk);
            } else {
                ThreadPoolManager.getInstance().scheduleAi(new HitTask(target, damage1, crit1, miss1, false, shld1), sAtk / 2);
                ThreadPoolManager.getInstance().scheduleAi(new HitTask(target, damage2, crit2, miss2, false, shld2), sAtk);
            }
        } else {
            ThreadPoolManager.getInstance().scheduleAi(new HitTask(target, damage1, crit1, miss1, attack.soulshot, shld1), sAtk / 2);
            ThreadPoolManager.getInstance().scheduleAi(new HitTask(target, damage2, crit2, miss2, attack.soulshot, shld2), sAtk);
        }
        attack.hit(attack.createHit(target, damage1, miss1, crit1, shld1), attack.createHit(target, damage2, miss2, crit2, shld2));
        return !miss1 || !miss2;
    }

    private boolean doAttackHitByPole(Attack attack, L2Character target, int sAtk) {
        int maxRadius = this.getPhysicalAttackRange();
        int maxAngleDiff = (int)this.getStat().calcStat(Stats.POWER_ATTACK_ANGLE, 120.0, null, null);
        if (Config.DEBUG) {
            _log.info("doAttackHitByPole: Max radius = " + maxRadius);
            _log.info("doAttackHitByPole: Max angle = " + maxAngleDiff);
        }
        int attackRandomCountMax = (int)this.getStat().calcStat(Stats.ATTACK_COUNT_MAX, 0.0, null, null) - 1;
        int attackcount = 0;
        boolean hitted = this.doAttackHitSimple(attack, target, 100.0, sAtk);
        double attackpercent = 85.0;
        Collection<L2Object> objs = this.getKnownList().getKnownObjects().values();
        for (L2Object obj : objs) {
            L2Character temp;
            if (obj == target || !(obj instanceof L2Character) || obj instanceof L2PetInstance && this instanceof L2PcInstance && ((L2PetInstance)obj).getOwner() == (L2PcInstance)this || !Util.checkIfInRange(maxRadius, this, obj, false) || Math.abs(obj.getZ() - this.getZ()) > 650 || !this.isFacing(obj, maxAngleDiff) || this instanceof L2Attackable && obj instanceof L2PcInstance && this.getTarget() instanceof L2Attackable || this instanceof L2Attackable && obj instanceof L2Attackable && ((L2Attackable)this).getEnemyClan() == null && ((L2Attackable)this).getIsChaos() == 0 || this instanceof L2Attackable && obj instanceof L2Attackable && !((L2Attackable)this).getEnemyClan().equals(((L2Attackable)obj).getClan()) && ((L2Attackable)this).getIsChaos() == 0 || (temp = (L2Character)obj).isAlikeDead() || temp != this.getAI().getAttackTarget() && !temp.isAutoAttackable(this)) continue;
            hitted |= this.doAttackHitSimple(attack, temp, attackpercent, sAtk);
            attackpercent /= 1.15;
            if (++attackcount <= attackRandomCountMax) continue;
            break;
        }
        return hitted;
    }

    private boolean doAttackHitSimple(Attack attack, L2Character target, int sAtk) {
        return this.doAttackHitSimple(attack, target, 100.0, sAtk);
    }

    private boolean doAttackHitSimple(Attack attack, L2Character target, double attackpercent, int sAtk) {
        int damage1 = 0;
        byte shld1 = 0;
        boolean crit1 = false;
        boolean miss1 = Formulas.calcHitMiss(this, target);
        if (!miss1) {
            shld1 = Formulas.calcShldUse(this, target);
            crit1 = Formulas.calcCrit(this.getStat().getCriticalHit(target, null), target);
            damage1 = (int)Formulas.calcPhysDam(this, target, null, shld1, crit1, false, attack.soulshot);
            if (attackpercent != 100.0) {
                damage1 = (int)((double)damage1 * attackpercent / 100.0);
            }
        }
        if (this instanceof L2Attackable) {
            if (((L2Attackable)this)._soulshotcharged) {
                ThreadPoolManager.getInstance().scheduleAi(new HitTask(target, damage1, crit1, miss1, true, shld1), sAtk);
            } else {
                ThreadPoolManager.getInstance().scheduleAi(new HitTask(target, damage1, crit1, miss1, false, shld1), sAtk);
            }
        } else {
            ThreadPoolManager.getInstance().scheduleAi(new HitTask(target, damage1, crit1, miss1, attack.soulshot, shld1), sAtk);
        }
        attack.hit(attack.createHit(target, damage1, miss1, crit1, shld1));
        return !miss1;
    }

    public void doCast(L2Skill skill) {
        this.beginCast(skill, false);
    }

    public void doSimultaneousCast(L2Skill skill) {
        this.beginCast(skill, true);
    }

    private void beginCast(L2Skill skill, boolean simultaneously) {
        SystemMessage sm;
        int initmpcons;
        boolean effectWhileCasting;
        if (!this.checkDoCastConditions(skill)) {
            if (simultaneously) {
                this.setIsCastingSimultaneouslyNow(false);
            } else {
                this.setIsCastingNow(false);
            }
            if (this instanceof L2PcInstance) {
                this.getAI().setIntention(CtrlIntention.AI_INTENTION_ACTIVE);
            }
            return;
        }
        this.stopEffectsOnAction();
        if (skill.useSoulShot()) {
            if (this instanceof L2PcInstance) {
                ((L2PcInstance)this).rechargeAutoSoulShot(true, false, false);
            } else if (this instanceof L2Summon) {
                ((L2Summon)this).getOwner().rechargeAutoSoulShot(true, false, true);
            }
        } else if (skill.useSpiritShot()) {
            if (this instanceof L2PcInstance) {
                ((L2PcInstance)this).rechargeAutoSoulShot(false, true, false);
            } else if (this instanceof L2Summon) {
                ((L2Summon)this).getOwner().rechargeAutoSoulShot(false, true, true);
            }
        }
        L2Character target = null;
        L2Object[] targets = skill.getTargetList(this);
        boolean doit = false;
        switch (skill.getTargetType()) {
            case TARGET_AREA_SUMMON: {
                target = this.getPet();
                break;
            }
            case TARGET_AURA: 
            case TARGET_FRONT_AURA: 
            case TARGET_BEHIND_AURA: 
            case TARGET_GROUND: {
                target = this;
                break;
            }
            case TARGET_SELF: 
            case TARGET_PET: 
            case TARGET_SUMMON: 
            case TARGET_OWNER_PET: 
            case TARGET_PARTY: 
            case TARGET_CLAN: 
            case TARGET_PARTY_CLAN: 
            case TARGET_ALLY: {
                doit = true;
            }
            default: {
                if (targets.length == 0) {
                    if (simultaneously) {
                        this.setIsCastingSimultaneouslyNow(false);
                    } else {
                        this.setIsCastingNow(false);
                    }
                    if (this instanceof L2PcInstance) {
                        this.sendPacket(ActionFailed.STATIC_PACKET);
                        this.getAI().setIntention(CtrlIntention.AI_INTENTION_ACTIVE);
                    }
                    return;
                }
                switch (skill.getSkillType()) {
                    case BUFF: 
                    case HEAL: 
                    case COMBATPOINTHEAL: 
                    case MANAHEAL: 
                    case REFLECT: {
                        doit = true;
                    }
                }
                target = doit ? (L2Character)targets[0] : (L2Character)this.getTarget();
            }
        }
        if (target == null) {
            if (simultaneously) {
                this.setIsCastingSimultaneouslyNow(false);
            } else {
                this.setIsCastingNow(false);
            }
            if (this instanceof L2PcInstance) {
                this.sendPacket(ActionFailed.STATIC_PACKET);
                this.getAI().setIntention(CtrlIntention.AI_INTENTION_ACTIVE);
            }
            return;
        }
        int magicId = skill.getId();
        int displayId = skill.getDisplayId();
        int level = skill.getLevel();
        if (level < 1) {
            level = 1;
        }
        int hitTime = skill.getHitTime();
        int coolTime = skill.getCoolTime();
        boolean bl = effectWhileCasting = skill.getSkillType() == L2SkillType.FUSION || skill.getSkillType() == L2SkillType.SIGNET_CASTTIME;
        if (!effectWhileCasting) {
            hitTime = Formulas.calcAtkSpd(this, skill, hitTime);
            if (coolTime > 0) {
                coolTime = Formulas.calcAtkSpd(this, skill, coolTime);
            }
        }
        int shotSave = 0;
        L2ItemInstance weaponInst = this.getActiveWeaponInstance();
        if (weaponInst != null) {
            if (skill.isMagic() && !effectWhileCasting && skill.getTargetType() != L2Skill.SkillTargetType.TARGET_SELF && (weaponInst.getChargedSpiritshot() == 2 || weaponInst.getChargedSpiritshot() == 1)) {
                hitTime = (int)(0.7 * (double)hitTime);
                coolTime = (int)(0.7 * (double)coolTime);
                switch (skill.getSkillType()) {
                    case BUFF: 
                    case MANAHEAL: 
                    case MANARECHARGE: 
                    case RESURRECT: 
                    case RECALL: {
                        weaponInst.setChargedSpiritshot(0);
                    }
                }
            }
            if (skill.useSoulShot()) {
                shotSave = weaponInst.getChargedSoulshot();
            } else if (skill.useSpiritShot()) {
                shotSave = weaponInst.getChargedSpiritshot();
            }
        }
        if (this instanceof L2Npc && ((L2Npc)this).useSpiritShot()) {
            hitTime = (int)(0.7 * (double)hitTime);
            coolTime = (int)(0.7 * (double)coolTime);
        }
        if (skill.isStaticHitTime()) {
            hitTime = skill.getHitTime();
            coolTime = skill.getCoolTime();
        } else if (skill.getHitTime() >= 500 && hitTime < 500) {
            hitTime = 500;
        }
        if (this.isCastingSimultaneouslyNow() && simultaneously) {
            ThreadPoolManager.getInstance().scheduleAi(new UsePotionTask(this, skill), 100L);
            return;
        }
        if (simultaneously) {
            this.setIsCastingSimultaneouslyNow(true);
        } else {
            this.setIsCastingNow(true);
        }
        this._castEndTime = 10 + GameTimeController.getGameTicks() + (coolTime + hitTime) / 100;
        if (!simultaneously) {
            this._castInterruptTime = -2 + GameTimeController.getGameTicks() + hitTime / 100;
            this.setLastSkillCast(skill);
        } else {
            this.setLastSimultaneousSkillCast(skill);
        }
        int reuseDelay = skill.isStaticReuse() ? skill.getReuseDelay() : (skill.isMagic() ? (int)((double)skill.getReuseDelay() * this.getStat().getMReuseRate(skill)) : (int)((double)skill.getReuseDelay() * this.getStat().getPReuseRate(skill)));
        boolean skillMastery = Formulas.calcSkillMastery(this, skill);
        if (reuseDelay > 30000 && !skillMastery) {
            this.addTimeStamp(skill, reuseDelay);
        }
        if ((initmpcons = this.getStat().getMpInitialConsume(skill)) > 0) {
            this.getStatus().reduceMp(initmpcons);
            StatusUpdate su = new StatusUpdate(this);
            su.addAttribute(11, (int)this.getCurrentMp());
            this.sendPacket(su);
        }
        if (reuseDelay > 10) {
            if (skillMastery) {
                reuseDelay = 100;
                if (this.getActingPlayer() != null) {
                    sm = new SystemMessage(SystemMessageId.SKILL_READY_TO_USE_AGAIN);
                    this.getActingPlayer().sendPacket(sm);
                    sm = null;
                }
            }
            this.disableSkill(skill, reuseDelay);
        }
        if (target != this) {
            this.setHeading(Util.calculateHeadingFrom(this, target));
        }
        if (effectWhileCasting) {
            if (skill.getItemConsumeId() > 0 && !this.destroyItemByItemId("Consume", skill.getItemConsumeId(), skill.getItemConsume(), null, true)) {
                this.sendPacket(new SystemMessage(SystemMessageId.NOT_ENOUGH_ITEMS));
                if (simultaneously) {
                    this.setIsCastingSimultaneouslyNow(false);
                } else {
                    this.setIsCastingNow(false);
                }
                if (this instanceof L2PcInstance) {
                    this.getAI().setIntention(CtrlIntention.AI_INTENTION_ACTIVE);
                }
                return;
            }
            if ((skill.getSoulConsumeCount() > 0 || skill.getMaxSoulConsumeCount() > 0) && this instanceof L2PcInstance && !((L2PcInstance)this).decreaseSouls(skill.getSoulConsumeCount(), skill)) {
                if (simultaneously) {
                    this.setIsCastingSimultaneouslyNow(false);
                } else {
                    this.setIsCastingNow(false);
                }
                return;
            }
            if (skill.getSkillType() == L2SkillType.FUSION) {
                this.startFusionSkill(target, skill);
            } else {
                this.callSkill(skill, targets);
            }
        }
        this.broadcastPacket(new MagicSkillUse(this, target, displayId, level, hitTime, reuseDelay));
        if (!skill.isPotion() && this instanceof L2PcInstance && magicId != 1312) {
            sm = new SystemMessage(SystemMessageId.USE_S1);
            sm.addSkillName(skill);
            this.sendPacket(sm);
        }
        if (this instanceof L2Playable) {
            if (!effectWhileCasting && skill.getItemConsumeId() > 0 && !this.destroyItemByItemId("Consume", skill.getItemConsumeId(), skill.getItemConsume(), null, true)) {
                this.getActingPlayer().sendPacket(new SystemMessage(SystemMessageId.NOT_ENOUGH_ITEMS));
                this.abortCast();
                return;
            }
            if (skill.getReferenceItemId() > 0 && ItemTable.getInstance().getTemplate(skill.getReferenceItemId()).getBodyPart() == 0x400000) {
                for (L2ItemInstance item : this.getInventory().getItemsByItemId(skill.getReferenceItemId())) {
                    if (!item.isEquipped()) continue;
                    item.decreaseMana(false, skill.getReuseDelay() / 60000);
                    break;
                }
            }
        }
        if (skill.getFlyType() != null && this instanceof L2PcInstance) {
            ThreadPoolManager.getInstance().scheduleEffect(new FlyToLocationTask(this, target, skill), 50L);
        }
        MagicUseTask mut = new MagicUseTask(targets, skill, hitTime, coolTime, simultaneously, shotSave);
        if (hitTime > 410) {
            Future<?> future;
            if (this instanceof L2PcInstance && !effectWhileCasting) {
                this.sendPacket(new SetupGauge(0, hitTime));
            }
            if (skill.getHitCounts() > 0 && (hitTime = hitTime * skill.getHitTimings()[0] / 100) < 410) {
                hitTime = 410;
            }
            if (effectWhileCasting) {
                mut.phase = 2;
            }
            if (simultaneously) {
                future = this._skillCast2;
                if (future != null) {
                    future.cancel(true);
                    this._skillCast2 = null;
                }
                this._skillCast2 = ThreadPoolManager.getInstance().scheduleEffect(mut, hitTime - 400);
            } else {
                future = this._skillCast;
                if (future != null) {
                    future.cancel(true);
                    this._skillCast = null;
                }
                this._skillCast = ThreadPoolManager.getInstance().scheduleEffect(mut, hitTime - 400);
            }
        } else {
            mut.hitTime = 0;
            this.onMagicLaunchedTimer(mut);
        }
    }

    protected boolean checkDoCastConditions(L2Skill skill) {
        L2ItemInstance requiredItems;
        if (skill == null || this.isSkillDisabled(skill) || skill.getFlyType() != null && this.isMovementDisabled()) {
            this.sendPacket(ActionFailed.STATIC_PACKET);
            return false;
        }
        if (this.getCurrentMp() < (double)(this.getStat().getMpConsume(skill) + this.getStat().getMpInitialConsume(skill))) {
            this.sendPacket(new SystemMessage(SystemMessageId.NOT_ENOUGH_MP));
            this.sendPacket(ActionFailed.STATIC_PACKET);
            return false;
        }
        if (this.getCurrentHp() <= (double)skill.getHpConsume()) {
            this.sendPacket(new SystemMessage(SystemMessageId.NOT_ENOUGH_HP));
            this.sendPacket(ActionFailed.STATIC_PACKET);
            return false;
        }
        if (!skill.isPotion()) {
            if (skill.isMagic()) {
                if (this.isMuted()) {
                    this.sendPacket(ActionFailed.STATIC_PACKET);
                    return false;
                }
            } else {
                if (this.isPhysicalMuted()) {
                    this.sendPacket(ActionFailed.STATIC_PACKET);
                    return false;
                }
                if (this.isPhysicalAttackMuted()) {
                    this.sendPacket(ActionFailed.STATIC_PACKET);
                    return false;
                }
            }
        }
        if (skill.getSkillType() == L2SkillType.SIGNET || skill.getSkillType() == L2SkillType.SIGNET_CASTTIME) {
            L2WorldRegion region = this.getWorldRegion();
            if (region == null) {
                return false;
            }
            boolean canCast = true;
            if (skill.getTargetType() == L2Skill.SkillTargetType.TARGET_GROUND && this instanceof L2PcInstance) {
                Point3D wp = ((L2PcInstance)this).getCurrentSkillWorldPosition();
                if (!region.checkEffectRangeInsidePeaceZone(skill, wp.getX(), wp.getY(), wp.getZ())) {
                    canCast = false;
                }
            } else if (!region.checkEffectRangeInsidePeaceZone(skill, this.getX(), this.getY(), this.getZ())) {
                canCast = false;
            }
            if (!canCast) {
                SystemMessage sm = new SystemMessage(SystemMessageId.S1_CANNOT_BE_USED);
                sm.addSkillName(skill);
                this.sendPacket(sm);
                return false;
            }
        }
        if (!skill.getWeaponDependancy(this)) {
            this.sendPacket(ActionFailed.STATIC_PACKET);
            return false;
        }
        if (skill.getItemConsumeId() > 0 && this.getInventory() != null && ((requiredItems = this.getInventory().getItemByItemId(skill.getItemConsumeId())) == null || requiredItems.getCount() < (long)skill.getItemConsume())) {
            if (skill.getSkillType() == L2SkillType.SUMMON) {
                SystemMessage sm = new SystemMessage(SystemMessageId.SUMMONING_SERVITOR_COSTS_S2_S1);
                sm.addItemName(skill.getItemConsumeId());
                sm.addNumber(skill.getItemConsume());
                this.sendPacket(sm);
                return false;
            }
            this.sendPacket(new SystemMessage(SystemMessageId.THERE_ARE_NOT_ENOUGH_NECESSARY_ITEMS_TO_USE_THE_SKILL));
            return false;
        }
        return true;
    }

    public void addTimeStamp(L2Skill skill, long reuse) {
    }

    public void startFusionSkill(L2Character target, L2Skill skill) {
        if (skill.getSkillType() != L2SkillType.FUSION) {
            return;
        }
        if (this._fusionSkill == null) {
            this._fusionSkill = new FusionSkill(this, target, skill);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean doDie(L2Character killer) {
        L2Character l2Character = this;
        synchronized (l2Character) {
            if (this.isDead()) {
                return false;
            }
            this.setCurrentHp(0.0);
            this.setIsDead(true);
        }
        this.setTarget(null);
        this.stopMove(null);
        this.getStatus().stopHpMpRegeneration();
        if (this instanceof L2Playable && ((L2Playable)this).isPhoenixBlessed()) {
            if (((L2Playable)this).getCharmOfLuck()) {
                ((L2Playable)this).stopCharmOfLuck(null);
            }
            if (((L2Playable)this).isNoblesseBlessed()) {
                ((L2Playable)this).stopNoblesseBlessing(null);
            }
        } else if (this instanceof L2Playable && ((L2Playable)this).isNoblesseBlessed()) {
            ((L2Playable)this).stopNoblesseBlessing(null);
            if (((L2Playable)this).getCharmOfLuck()) {
                ((L2Playable)this).stopCharmOfLuck(null);
            }
        } else {
            this.stopAllEffectsExceptThoseThatLastThroughDeath();
        }
        if (this instanceof L2PcInstance && ((L2PcInstance)this).getAgathionId() != 0) {
            ((L2PcInstance)this).setAgathionId(0);
        }
        this.calculateRewards(killer);
        this.broadcastStatusUpdate();
        if (this.hasAI()) {
            this.getAI().notifyEvent(CtrlEvent.EVT_DEAD);
        }
        if (this.getWorldRegion() != null) {
            this.getWorldRegion().onDeath(this);
        }
        this.getAttackByList().clear();
        if (this instanceof L2Summon && ((L2Summon)this).isPhoenixBlessed() && ((L2Summon)this).getOwner() != null) {
            ((L2Summon)this).getOwner().reviveRequest(((L2Summon)this).getOwner(), null, true);
        }
        if (this instanceof L2PcInstance) {
            if (((L2Playable)this).isPhoenixBlessed()) {
                ((L2PcInstance)this).reviveRequest((L2PcInstance)this, null, false);
            } else if (((L2PcInstance)this).getCharmOfCourage() && ((L2PcInstance)this).isInSiege()) {
                ((L2PcInstance)this).reviveRequest((L2PcInstance)this, null, false);
            }
        }
        try {
            if (this._fusionSkill != null) {
                this.abortCast();
            }
            for (L2Character character : this.getKnownList().getKnownCharacters()) {
                if (character.getFusionSkill() == null || character.getFusionSkill().getTarget() != this) continue;
                character.abortCast();
            }
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "deleteMe()", e);
        }
        return true;
    }

    public void deleteMe() {
        this.setDebug(null);
        if (this.hasAI()) {
            this.getAI().stopAITask();
        }
    }

    protected void calculateRewards(L2Character killer) {
    }

    public void doRevive() {
        if (!this.isDead()) {
            return;
        }
        if (!this.isTeleporting()) {
            this.setIsPendingRevive(false);
            this.setIsDead(false);
            boolean restorefull = false;
            if (this instanceof L2Playable && ((L2Playable)this).isPhoenixBlessed()) {
                restorefull = true;
                ((L2Playable)this).stopPhoenixBlessing(null);
            }
            if (restorefull) {
                this._status.setCurrentCp(this.getCurrentCp());
                this._status.setCurrentHp(this.getMaxHp());
                this._status.setCurrentMp(this.getMaxMp());
            } else {
                this._status.setCurrentHp((double)this.getMaxHp() * Config.RESPAWN_RESTORE_HP);
            }
            this.broadcastPacket(new Revive(this));
            if (this.getWorldRegion() != null) {
                this.getWorldRegion().onRevive(this);
            }
        } else {
            this.setIsPendingRevive(true);
        }
    }

    public void doRevive(double revivePower) {
        this.doRevive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public L2CharacterAI getAI() {
        L2CharacterAI ai = this._ai;
        if (ai == null) {
            L2Character l2Character = this;
            synchronized (l2Character) {
                if (this._ai == null) {
                    this._ai = new L2CharacterAI(new AIAccessor());
                }
                return this._ai;
            }
        }
        return ai;
    }

    public void setAI(L2CharacterAI newAI) {
        L2CharacterAI oldAI = this.getAI();
        if (oldAI != null && oldAI != newAI && oldAI instanceof L2AttackableAI) {
            ((L2AttackableAI)oldAI).stopAITask();
        }
        this._ai = newAI;
    }

    public boolean hasAI() {
        return this._ai != null;
    }

    public boolean isRaid() {
        return false;
    }

    public void setIsRaid(boolean isRaid) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Set<L2Character> getAttackByList() {
        if (this._attackByList != null) {
            return this._attackByList;
        }
        L2Character l2Character = this;
        synchronized (l2Character) {
            if (this._attackByList == null) {
                this._attackByList = new WeakFastSet(true);
            }
        }
        return this._attackByList;
    }

    public final L2Skill getLastSimultaneousSkillCast() {
        return this._lastSimultaneousSkillCast;
    }

    public void setLastSimultaneousSkillCast(L2Skill skill) {
        this._lastSimultaneousSkillCast = skill;
    }

    public final L2Skill getLastSkillCast() {
        return this._lastSkillCast;
    }

    public void setLastSkillCast(L2Skill skill) {
        this._lastSkillCast = skill;
    }

    public final boolean isNoRndWalk() {
        return this._isNoRndWalk;
    }

    public final void setIsNoRndWalk(boolean value) {
        this._isNoRndWalk = value;
    }

    public final boolean isAfraid() {
        return this._isAfraid;
    }

    public final void setIsAfraid(boolean value) {
        this._isAfraid = value;
    }

    public final boolean isAllSkillsDisabled() {
        return this._allSkillsDisabled || this.isStunned() || this.isSleeping() || this.isParalyzed();
    }

    public boolean isAttackingDisabled() {
        return this.isFlying() || this.isStunned() || this.isSleeping() || this._attackEndTime > GameTimeController.getGameTicks() || this.isAlikeDead() || this.isParalyzed() || this.isPhysicalAttackMuted() || this.isCoreAIDisabled() || this.isFallsdown();
    }

    public final Calculator[] getCalculators() {
        return this._calculators;
    }

    public final boolean isConfused() {
        return this._isConfused;
    }

    public final void setIsConfused(boolean value) {
        this._isConfused = value;
    }

    public boolean isAlikeDead() {
        return this._isDead;
    }

    public final boolean isDead() {
        return this._isDead;
    }

    public final void setIsDead(boolean value) {
        this._isDead = value;
    }

    public final boolean isFallsdown() {
        return this._isFallsdown;
    }

    public final void setIsFallsdown(boolean value) {
        this._isFallsdown = value;
    }

    public boolean isImmobilized() {
        return this._isImmobilized;
    }

    public void setIsImmobilized(boolean value) {
        this._isImmobilized = value;
    }

    public final boolean isMuted() {
        return this._isMuted;
    }

    public final void setIsMuted(boolean value) {
        this._isMuted = value;
    }

    public final boolean isPhysicalMuted() {
        return this._isPhysicalMuted;
    }

    public final void setIsPhysicalMuted(boolean value) {
        this._isPhysicalMuted = value;
    }

    public final boolean isPhysicalAttackMuted() {
        return this._isPhysicalAttackMuted;
    }

    public final void setIsPhysicalAttackMuted(boolean value) {
        this._isPhysicalAttackMuted = value;
    }

    public boolean isMovementDisabled() {
        return this.isStunned() || this.isRooted() || this.isSleeping() || this.isOverloaded() || this.isParalyzed() || this.isImmobilized() || this.isAlikeDead() || this.isTeleporting() || this.isFallsdown();
    }

    public final boolean isOutOfControl() {
        return this.isConfused() || this.isAfraid();
    }

    public final boolean isOverloaded() {
        return this._isOverloaded;
    }

    public final void setIsOverloaded(boolean value) {
        this._isOverloaded = value;
    }

    public final boolean isParalyzed() {
        return this._isParalyzed;
    }

    public final void setIsParalyzed(boolean value) {
        this._isParalyzed = value;
    }

    public final boolean isPendingRevive() {
        return this.isDead() && this._isPendingRevive;
    }

    public final void setIsPendingRevive(boolean value) {
        this._isPendingRevive = value;
    }

    public final boolean isDisarmed() {
        return this._isDisarmed;
    }

    public final void setIsDisarmed(boolean value) {
        this._isDisarmed = value;
    }

    public L2Summon getPet() {
        return null;
    }

    public final boolean isRooted() {
        return this._isRooted;
    }

    public final void setIsRooted(boolean value) {
        this._isRooted = value;
    }

    public boolean isRunning() {
        return this._isRunning;
    }

    public final void setIsRunning(boolean value) {
        this._isRunning = value;
        if (this.getRunSpeed() != 0) {
            this.broadcastPacket(new ChangeMoveType(this));
        }
        if (this instanceof L2PcInstance) {
            ((L2PcInstance)this).broadcastUserInfo();
        } else if (this instanceof L2Summon) {
            ((L2Summon)this).broadcastStatusUpdate();
        } else if (this instanceof L2Npc) {
            Collection<L2PcInstance> plrs = this.getKnownList().getKnownPlayers().values();
            for (L2PcInstance player : plrs) {
                if (player == null) continue;
                if (this.getRunSpeed() == 0) {
                    player.sendPacket(new ServerObjectInfo((L2Npc)this, player));
                    continue;
                }
                player.sendPacket(new AbstractNpcInfo.NpcInfo((L2Npc)this, player));
            }
        }
    }

    public final void setRunning() {
        if (!this.isRunning()) {
            this.setIsRunning(true);
        }
    }

    public final boolean isSleeping() {
        return this._isSleeping;
    }

    public final void setIsSleeping(boolean value) {
        this._isSleeping = value;
    }

    public final boolean isStunned() {
        return this._isStunned;
    }

    public final void setIsStunned(boolean value) {
        this._isStunned = value;
    }

    public final boolean isBetrayed() {
        return this._isBetrayed;
    }

    public final void setIsBetrayed(boolean value) {
        this._isBetrayed = value;
    }

    public final boolean isTeleporting() {
        return this._isTeleporting;
    }

    public void setIsTeleporting(boolean value) {
        this._isTeleporting = value;
    }

    public void setIsInvul(boolean b) {
        this._isInvul = b;
    }

    public boolean isInvul() {
        return this._isInvul || this._isTeleporting;
    }

    public void setIsMortal(boolean b) {
        this._isMortal = b;
    }

    public boolean isMortal() {
        return this._isMortal;
    }

    public boolean isUndead() {
        return false;
    }

    public final boolean isFlying() {
        return this._isFlying;
    }

    public final void setIsFlying(boolean mode) {
        this._isFlying = mode;
    }

    @Override
    public CharKnownList getKnownList() {
        return (CharKnownList)super.getKnownList();
    }

    @Override
    public void initKnownList() {
        this.setKnownList(new CharKnownList(this));
    }

    public CharStat getStat() {
        return this._stat;
    }

    public void initCharStat() {
        this._stat = new CharStat(this);
    }

    public final void setStat(CharStat value) {
        this._stat = value;
    }

    public CharStatus getStatus() {
        return this._status;
    }

    public void initCharStatus() {
        this._status = new CharStatus(this);
    }

    public final void setStatus(CharStatus value) {
        this._status = value;
    }

    @Override
    public CharPosition getPosition() {
        return (CharPosition)super.getPosition();
    }

    @Override
    public void initPosition() {
        this.setObjectPosition(new CharPosition(this));
    }

    public L2CharTemplate getTemplate() {
        return this._template;
    }

    protected final void setTemplate(L2CharTemplate template) {
        this._template = template;
    }

    public final String getTitle() {
        return this._title;
    }

    public final void setTitle(String value) {
        this._title = value == null ? "" : (value.length() > 16 ? value.substring(0, 15) : value);
    }

    public final void setWalking() {
        if (this.isRunning()) {
            this.setIsRunning(false);
        }
    }

    public final int getAbnormalEffects() {
        return this._AbnormalEffects;
    }

    public void addEffect(L2Effect newEffect) {
        this._effects.queueEffect(newEffect, false);
    }

    public final void removeEffect(L2Effect effect) {
        this._effects.queueEffect(effect, true);
    }

    public final void startAbnormalEffect(AbnormalEffect mask) {
        this._AbnormalEffects |= mask.getMask();
        this.updateAbnormalEffect();
    }

    public final void startSpecialEffect(AbnormalEffect mask) {
        this._SpecialEffects |= mask.getMask();
        this.updateAbnormalEffect();
    }

    public final void startAbnormalEffect(int mask) {
        this._AbnormalEffects |= mask;
        this.updateAbnormalEffect();
    }

    public final void startSpecialEffect(int mask) {
        this._SpecialEffects |= mask;
        this.updateAbnormalEffect();
    }

    public final void startConfused() {
        this.setIsConfused(true);
        this.getAI().notifyEvent(CtrlEvent.EVT_CONFUSED);
        this.updateAbnormalEffect();
    }

    /*
     * Enabled aggressive block sorting
     */
    public final void startFakeDeath() {
        if (!(this instanceof L2PcInstance)) {
            return;
        }
        this.setIsFallsdown(true);
        boolean isFakeDeath = true;
        if (Config.FAILD_FAKEDEATH) {
            if (this.getAttackByList() == null || this.getAttackByList().size() == 0) {
                if (Rnd.get(100) < 25) {
                    isFakeDeath = false;
                }
            } else {
                boolean isRaid = false;
                int highestLevel = this.getLevel();
                for (L2Character atkChar : this.getAttackByList()) {
                    if (atkChar.isRaid()) {
                        isRaid = true;
                        break;
                    }
                    if (atkChar.getLevel() <= highestLevel) continue;
                    highestLevel = atkChar.getLevel();
                }
                if (isRaid) {
                    isFakeDeath = false;
                } else {
                    int _diff = highestLevel - this.getLevel();
                    switch (_diff) {
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: {
                            if (Rnd.get(100) >= 5) break;
                            isFakeDeath = false;
                            break;
                        }
                        case 6: {
                            if (Rnd.get(100) >= 10) break;
                            isFakeDeath = false;
                            break;
                        }
                        case 7: {
                            if (Rnd.get(100) >= 15) break;
                            isFakeDeath = false;
                            break;
                        }
                        case 8: {
                            if (Rnd.get(100) >= 20) break;
                            isFakeDeath = false;
                            break;
                        }
                        case 9: {
                            if (Rnd.get(100) >= 25) break;
                            isFakeDeath = false;
                            break;
                        }
                        default: {
                            if (_diff <= 9 || Rnd.get(100) >= 50) break;
                            isFakeDeath = false;
                        }
                    }
                }
            }
        }
        ((L2PcInstance)this).setIsFakeDeath(isFakeDeath);
        this.abortAttack();
        this.abortCast();
        this.stopMove(null);
        this.getAI().notifyEvent(CtrlEvent.EVT_FAKE_DEATH);
        this.broadcastPacket(new ChangeWaitType(this, 2));
    }

    public final void startFear() {
        this.setIsAfraid(true);
        this.getAI().notifyEvent(CtrlEvent.EVT_AFRAID);
        this.updateAbnormalEffect();
    }

    public final void startMuted() {
        this.setIsMuted(true);
        this.abortCast();
        this.getAI().notifyEvent(CtrlEvent.EVT_MUTED);
        this.updateAbnormalEffect();
    }

    public final void startPsychicalMuted() {
        this.setIsPhysicalMuted(true);
        this.getAI().notifyEvent(CtrlEvent.EVT_MUTED);
        this.updateAbnormalEffect();
    }

    public final void startRooted() {
        this.setIsRooted(true);
        this.stopMove(null);
        this.getAI().notifyEvent(CtrlEvent.EVT_ROOTED);
        this.updateAbnormalEffect();
    }

    public final void startSleeping() {
        this.setIsSleeping(true);
        this.abortAttack();
        this.abortCast();
        this.stopMove(null);
        this.getAI().notifyEvent(CtrlEvent.EVT_SLEEPING);
        this.updateAbnormalEffect();
    }

    public final void startStunning() {
        this.setIsStunned(true);
        this.abortAttack();
        this.abortCast();
        this.stopMove(null);
        this.getAI().notifyEvent(CtrlEvent.EVT_STUNNED);
        if (!(this instanceof L2Summon)) {
            this.getAI().setIntention(CtrlIntention.AI_INTENTION_IDLE);
        }
        this.updateAbnormalEffect();
    }

    public final void startParalyze() {
        this.setIsParalyzed(true);
        this.abortAttack();
        this.abortCast();
        this.stopMove(null);
        this.getAI().notifyEvent(CtrlEvent.EVT_PARALYZED);
        this.updateAbnormalEffect();
    }

    public final void startBetray() {
        this.setIsBetrayed(true);
        this.getAI().notifyEvent(CtrlEvent.EVT_BETRAYED);
        this.updateAbnormalEffect();
    }

    public final void stopBetray() {
        this.stopEffects(L2EffectType.BETRAY);
        this.setIsBetrayed(false);
        this.updateAbnormalEffect();
    }

    public final void stopAbnormalEffect(AbnormalEffect mask) {
        this._AbnormalEffects &= ~mask.getMask();
        this.updateAbnormalEffect();
    }

    public final void stopSpecialEffect(AbnormalEffect mask) {
        this._SpecialEffects &= ~mask.getMask();
        this.updateAbnormalEffect();
    }

    public final void stopAbnormalEffect(int mask) {
        this._AbnormalEffects &= ~mask;
        this.updateAbnormalEffect();
    }

    public final void stopSpecialEffect(int mask) {
        this._SpecialEffects &= ~mask;
        this.updateAbnormalEffect();
    }

    public void stopAllEffects() {
        this._effects.stopAllEffects();
    }

    public void stopAllEffectsExceptThoseThatLastThroughDeath() {
        this._effects.stopAllEffectsExceptThoseThatLastThroughDeath();
    }

    public final void stopConfused(L2Effect effect) {
        if (effect == null) {
            this.stopEffects(L2EffectType.CONFUSION);
        } else {
            this.removeEffect(effect);
        }
        this.setIsConfused(false);
        if (!(this instanceof L2PcInstance)) {
            this.getAI().notifyEvent(CtrlEvent.EVT_THINK);
        }
        this.updateAbnormalEffect();
    }

    public final void stopSkillEffects(int skillId) {
        this._effects.stopSkillEffects(skillId);
    }

    public final void stopSkillEffects(L2SkillType skillType, int negateLvl) {
        this._effects.stopSkillEffects(skillType, negateLvl);
    }

    public final void stopSkillEffects(L2SkillType skillType) {
        this._effects.stopSkillEffects(skillType, -1);
    }

    public final void stopEffects(L2EffectType type) {
        this._effects.stopEffects(type);
    }

    public final void stopEffectsOnAction() {
        this._effects.stopEffectsOnAction();
    }

    public final void stopEffectsOnDamage(boolean awake) {
        this._effects.stopEffectsOnDamage(awake);
    }

    public final void stopFakeDeath(boolean removeEffects) {
        if (removeEffects) {
            this.stopEffects(L2EffectType.FAKE_DEATH);
        }
        this.setIsFallsdown(false);
        if (this instanceof L2PcInstance) {
            ((L2PcInstance)this).setIsFakeDeath(false);
            ((L2PcInstance)this).setRecentFakeDeath(true);
        }
        ChangeWaitType revive = new ChangeWaitType(this, 3);
        this.broadcastPacket(revive);
        this.broadcastPacket(new Revive(this));
    }

    public final void stopFear(boolean removeEffects) {
        if (removeEffects) {
            this.stopEffects(L2EffectType.FEAR);
        }
        this.setIsAfraid(false);
        this.updateAbnormalEffect();
    }

    public final void stopMuted(boolean removeEffects) {
        if (removeEffects) {
            this.stopEffects(L2EffectType.MUTE);
        }
        this.setIsMuted(false);
        this.updateAbnormalEffect();
    }

    public final void stopPsychicalMuted(boolean removeEffects) {
        if (removeEffects) {
            this.stopEffects(L2EffectType.PHYSICAL_MUTE);
        }
        this.setIsPhysicalMuted(false);
        this.updateAbnormalEffect();
    }

    public final void stopRooting(boolean removeEffects) {
        if (removeEffects) {
            this.stopEffects(L2EffectType.ROOT);
        }
        this.setIsRooted(false);
        if (!(this instanceof L2PcInstance)) {
            this.getAI().notifyEvent(CtrlEvent.EVT_THINK);
        }
        this.updateAbnormalEffect();
    }

    public final void stopSleeping(boolean removeEffects) {
        if (removeEffects) {
            this.stopEffects(L2EffectType.SLEEP);
        }
        this.setIsSleeping(false);
        if (!(this instanceof L2PcInstance)) {
            this.getAI().notifyEvent(CtrlEvent.EVT_THINK);
        }
        this.updateAbnormalEffect();
    }

    public final void stopStunning(boolean removeEffects) {
        if (removeEffects) {
            this.stopEffects(L2EffectType.STUN);
        }
        this.setIsStunned(false);
        if (!(this instanceof L2PcInstance)) {
            this.getAI().notifyEvent(CtrlEvent.EVT_THINK);
        }
        this.updateAbnormalEffect();
    }

    public final void stopParalyze(boolean removeEffects) {
        if (removeEffects) {
            this.stopEffects(L2EffectType.PARALYZE);
        }
        this.setIsParalyzed(false);
        if (!(this instanceof L2PcInstance)) {
            this.getAI().notifyEvent(CtrlEvent.EVT_THINK);
        }
        this.updateAbnormalEffect();
    }

    public final void stopTransformation(boolean removeEffects) {
        if (removeEffects) {
            this.stopEffects(L2EffectType.TRANSFORMATION);
        }
        if (this instanceof L2PcInstance && ((L2PcInstance)this).getTransformation() != null) {
            ((L2PcInstance)this).untransform();
        }
        if (!(this instanceof L2PcInstance)) {
            this.getAI().notifyEvent(CtrlEvent.EVT_THINK);
        }
        this.updateAbnormalEffect();
    }

    public abstract void updateAbnormalEffect();

    public final void updateEffectIcons() {
        this.updateEffectIcons(false);
    }

    public void updateEffectIcons(boolean partyOnly) {
    }

    public int getAbnormalEffect() {
        int ae = this._AbnormalEffects;
        if (!this.isFlying() && this.isStunned()) {
            ae |= AbnormalEffect.STUN.getMask();
        }
        if (!this.isFlying() && this.isRooted()) {
            ae |= AbnormalEffect.ROOT.getMask();
        }
        if (this.isSleeping()) {
            ae |= AbnormalEffect.SLEEP.getMask();
        }
        if (this.isConfused()) {
            ae |= AbnormalEffect.FEAR.getMask();
        }
        if (this.isMuted()) {
            ae |= AbnormalEffect.MUTED.getMask();
        }
        if (this.isPhysicalMuted()) {
            ae |= AbnormalEffect.MUTED.getMask();
        }
        if (this.isAfraid()) {
            ae |= AbnormalEffect.SKULL_FEAR.getMask();
        }
        return ae;
    }

    public int getSpecialEffect() {
        int se = this._SpecialEffects;
        if (this.isFlying() && this.isStunned()) {
            se |= AbnormalEffect.S_AIR_STUN.getMask();
        }
        if (this.isFlying() && this.isRooted()) {
            se |= AbnormalEffect.S_AIR_ROOT.getMask();
        }
        return se;
    }

    public final L2Effect[] getAllEffects() {
        return this._effects.getAllEffects();
    }

    public final L2Effect getFirstEffect(int skillId) {
        return this._effects.getFirstEffect(skillId);
    }

    public final L2Effect getFirstEffect(L2Skill skill) {
        return this._effects.getFirstEffect(skill);
    }

    public final L2Effect getFirstEffect(L2EffectType tp) {
        return this._effects.getFirstEffect(tp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addStatFunc(Func f) {
        if (f == null) {
            return;
        }
        Calculator[] calculatorArray = this._calculators;
        synchronized (this._calculators) {
            int stat;
            if (this._calculators == NPC_STD_CALCULATOR) {
                this._calculators = new Calculator[Stats.NUM_STATS];
                for (int i = 0; i < Stats.NUM_STATS; ++i) {
                    if (NPC_STD_CALCULATOR[i] == null) continue;
                    this._calculators[i] = new Calculator(NPC_STD_CALCULATOR[i]);
                }
            }
            if (this._calculators[stat = f.stat.ordinal()] == null) {
                this._calculators[stat] = new Calculator();
            }
            this._calculators[stat].addFunc(f);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public final void addStatFuncs(Func[] funcs) {
        FastList modifiedStats = new FastList();
        for (Func f : funcs) {
            modifiedStats.add((Object)f.stat);
            this.addStatFunc(f);
        }
        this.broadcastModifiedStats((FastList<Stats>)modifiedStats);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeStatFunc(Func f) {
        if (f == null) {
            return;
        }
        int stat = f.stat.ordinal();
        Calculator[] calculatorArray = this._calculators;
        synchronized (this._calculators) {
            if (this._calculators[stat] == null) {
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return;
            }
            this._calculators[stat].removeFunc(f);
            if (this._calculators[stat].size() == 0) {
                this._calculators[stat] = null;
            }
            if (this instanceof L2Npc) {
                int i;
                for (i = 0; i < Stats.NUM_STATS && Calculator.equalsCals(this._calculators[i], NPC_STD_CALCULATOR[i]); ++i) {
                }
                if (i >= Stats.NUM_STATS) {
                    this._calculators = NPC_STD_CALCULATOR;
                }
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    public final void removeStatFuncs(Func[] funcs) {
        FastList modifiedStats = new FastList();
        for (Func f : funcs) {
            modifiedStats.add((Object)f.stat);
            this.removeStatFunc(f);
        }
        this.broadcastModifiedStats((FastList<Stats>)modifiedStats);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeStatsOwner(Object owner) {
        FastList<Stats> modifiedStats = null;
        int i = 0;
        Calculator[] calculatorArray = this._calculators;
        synchronized (this._calculators) {
            for (Calculator calc : this._calculators) {
                if (calc != null) {
                    if (modifiedStats != null) {
                        modifiedStats.addAll(calc.removeOwner(owner));
                    } else {
                        modifiedStats = calc.removeOwner(owner);
                    }
                    if (calc.size() == 0) {
                        this._calculators[i] = null;
                    }
                }
                ++i;
            }
            if (this instanceof L2Npc) {
                for (i = 0; i < Stats.NUM_STATS && Calculator.equalsCals(this._calculators[i], NPC_STD_CALCULATOR[i]); ++i) {
                }
                if (i >= Stats.NUM_STATS) {
                    this._calculators = NPC_STD_CALCULATOR;
                }
            }
            if (owner instanceof L2Effect) {
                if (!((L2Effect)owner).preventExitUpdate) {
                    this.broadcastModifiedStats(modifiedStats);
                }
            } else {
                this.broadcastModifiedStats(modifiedStats);
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    private void broadcastModifiedStats(FastList<Stats> stats) {
        if (stats == null || stats.isEmpty()) {
            return;
        }
        boolean broadcastFull = false;
        StatusUpdate su = null;
        for (Stats stat : stats) {
            if (this instanceof L2Summon && ((L2Summon)this).getOwner() != null) {
                ((L2Summon)this).updateAndBroadcastStatus(1);
                break;
            }
            if (stat == Stats.POWER_ATTACK_SPEED) {
                if (su == null) {
                    su = new StatusUpdate(this);
                }
                su.addAttribute(18, this.getPAtkSpd());
                continue;
            }
            if (stat == Stats.MAGIC_ATTACK_SPEED) {
                if (su == null) {
                    su = new StatusUpdate(this);
                }
                su.addAttribute(24, this.getMAtkSpd());
                continue;
            }
            if (stat == Stats.MAX_HP && this instanceof L2Attackable) {
                if (su == null) {
                    su = new StatusUpdate(this);
                }
                su.addAttribute(10, this.getMaxVisibleHp());
                continue;
            }
            if (stat == Stats.LIMIT_HP) {
                this.getStatus().setCurrentHp(this.getCurrentHp());
                continue;
            }
            if (stat != Stats.RUN_SPEED) continue;
            broadcastFull = true;
        }
        if (this instanceof L2PcInstance) {
            if (broadcastFull) {
                ((L2PcInstance)this).updateAndBroadcastStatus(2);
            } else {
                ((L2PcInstance)this).updateAndBroadcastStatus(1);
                if (su != null) {
                    this.broadcastPacket(su);
                }
            }
        } else if (this instanceof L2Npc) {
            if (broadcastFull) {
                Collection<L2PcInstance> plrs = this.getKnownList().getKnownPlayers().values();
                for (L2PcInstance player : plrs) {
                    if (player == null) continue;
                    if (this.getRunSpeed() == 0) {
                        player.sendPacket(new ServerObjectInfo((L2Npc)this, player));
                        continue;
                    }
                    player.sendPacket(new AbstractNpcInfo.NpcInfo((L2Npc)this, player));
                }
            } else if (su != null) {
                this.broadcastPacket(su);
            }
        } else if (su != null) {
            this.broadcastPacket(su);
        }
    }

    public final int getHeading() {
        return this._heading;
    }

    public final void setHeading(int heading) {
        this._heading = heading;
    }

    public final int getXdestination() {
        MoveData m = this._move;
        if (m != null) {
            return m._xDestination;
        }
        return this.getX();
    }

    public final int getYdestination() {
        MoveData m = this._move;
        if (m != null) {
            return m._yDestination;
        }
        return this.getY();
    }

    public final int getZdestination() {
        MoveData m = this._move;
        if (m != null) {
            return m._zDestination;
        }
        return this.getZ();
    }

    public boolean isInCombat() {
        return this.getAI().getAttackTarget() != null || this.getAI().isAutoAttacking();
    }

    public final boolean isMoving() {
        return this._move != null;
    }

    public final boolean isOnGeodataPath() {
        MoveData m = this._move;
        if (m == null) {
            return false;
        }
        if (m.onGeodataPathIndex == -1) {
            return false;
        }
        return m.onGeodataPathIndex != m.geoPath.size() - 1;
    }

    public final boolean isCastingNow() {
        return this._isCastingNow;
    }

    public void setIsCastingNow(boolean value) {
        this._isCastingNow = value;
    }

    public final boolean isCastingSimultaneouslyNow() {
        return this._isCastingSimultaneouslyNow;
    }

    public void setIsCastingSimultaneouslyNow(boolean value) {
        this._isCastingSimultaneouslyNow = value;
    }

    public final boolean canAbortCast() {
        return this._castInterruptTime > GameTimeController.getGameTicks();
    }

    public int getCastInterruptTime() {
        return this._castInterruptTime;
    }

    public boolean isAttackingNow() {
        return this._attackEndTime > GameTimeController.getGameTicks();
    }

    public final boolean isAttackAborted() {
        return this._attacking <= 0;
    }

    public final void abortAttack() {
        if (this.isAttackingNow()) {
            this._attacking = 0;
            this.sendPacket(ActionFailed.STATIC_PACKET);
        }
    }

    public final int getAttackingBodyPart() {
        return this._attacking;
    }

    public final void abortCast() {
        if (this.isCastingNow() || this.isCastingSimultaneouslyNow()) {
            L2Effect mog;
            Future<?> future = this._skillCast;
            if (future != null) {
                future.cancel(true);
                this._skillCast = null;
            }
            if ((future = this._skillCast2) != null) {
                future.cancel(true);
                this._skillCast2 = null;
            }
            if (this.getFusionSkill() != null) {
                this.getFusionSkill().onCastAbort();
            }
            if ((mog = this.getFirstEffect(L2EffectType.SIGNET_GROUND)) != null) {
                mog.exit();
            }
            if (this._allSkillsDisabled) {
                this.enableAllSkills();
            }
            this.setIsCastingNow(false);
            this.setIsCastingSimultaneouslyNow(false);
            this._castInterruptTime = 0;
            if (this instanceof L2PcInstance) {
                this.getAI().notifyEvent(CtrlEvent.EVT_FINISH_CASTING);
            }
            this.broadcastPacket(new MagicSkillCanceld(this.getObjectId()));
            this.sendPacket(ActionFailed.STATIC_PACKET);
        }
    }

    public boolean updatePosition(int gameTicks) {
        double dz;
        boolean isFloating;
        double dy;
        double dx;
        MoveData m = this._move;
        if (m == null) {
            return true;
        }
        if (!this.isVisible()) {
            this._move = null;
            return true;
        }
        if (m._moveTimestamp == 0) {
            m._moveTimestamp = m._moveStartTime;
            m._xAccurate = this.getX();
            m._yAccurate = this.getY();
        }
        if (m._moveTimestamp == gameTicks) {
            return false;
        }
        int xPrev = this.getX();
        int yPrev = this.getY();
        int zPrev = this.getZ();
        if (Config.COORD_SYNCHRONIZE == 1) {
            dx = m._xDestination - xPrev;
            dy = m._yDestination - yPrev;
        } else {
            dx = (double)m._xDestination - m._xAccurate;
            dy = (double)m._yDestination - m._yAccurate;
        }
        boolean bl = isFloating = this.isFlying() || this.isInsideZone((byte)7);
        if (Config.GEODATA > 0 && Config.COORD_SYNCHRONIZE == 2 && !isFloating && !m.disregardingGeodata && GameTimeController.getGameTicks() % 10 == 0 && GeoData.getInstance().hasGeo(xPrev, yPrev)) {
            short geoHeight = GeoData.getInstance().getSpawnHeight(xPrev, yPrev, zPrev - 30, zPrev + 30, this.getObjectId());
            dz = m._zDestination - geoHeight;
            if (this instanceof L2PcInstance && Math.abs(((L2PcInstance)this).getClientZ() - geoHeight) > 200 && Math.abs(((L2PcInstance)this).getClientZ() - geoHeight) < 1500) {
                dz = m._zDestination - zPrev;
            } else if (this.isInCombat() && Math.abs(dz) > 200.0 && dx * dx + dy * dy < 40000.0) {
                dz = m._zDestination - zPrev;
            } else {
                zPrev = geoHeight;
            }
        } else {
            dz = m._zDestination - zPrev;
        }
        double delta = dx * dx + dy * dy;
        delta = delta < 10000.0 && dz * dz > 2500.0 && !isFloating ? Math.sqrt(delta) : Math.sqrt(delta + dz * dz);
        double distFraction = Double.MAX_VALUE;
        if (delta > 1.0) {
            double distPassed = this.getStat().getMoveSpeed() * (float)(gameTicks - m._moveTimestamp) / 10.0f;
            distFraction = distPassed / delta;
        }
        if (distFraction > 1.0) {
            super.getPosition().setXYZ(m._xDestination, m._yDestination, m._zDestination);
        } else {
            m._xAccurate += dx * distFraction;
            m._yAccurate += dy * distFraction;
            super.getPosition().setXYZ((int)m._xAccurate, (int)m._yAccurate, zPrev + (int)(dz * distFraction + 0.5));
        }
        this.revalidateZone(false);
        m._moveTimestamp = gameTicks;
        return distFraction > 1.0;
    }

    public void revalidateZone(boolean force) {
        if (this.getWorldRegion() == null) {
            return;
        }
        if (force) {
            this._zoneValidateCounter = (byte)4;
        } else {
            this._zoneValidateCounter = (byte)(this._zoneValidateCounter - 1);
            if (this._zoneValidateCounter < 0) {
                this._zoneValidateCounter = (byte)4;
            } else {
                return;
            }
        }
        this.getWorldRegion().revalidateZones(this);
    }

    public void stopMove(L2CharPosition pos) {
        this.stopMove(pos, false);
    }

    public void stopMove(L2CharPosition pos, boolean updateKnownObjects) {
        this._move = null;
        if (pos != null) {
            this.getPosition().setXYZ(pos.x, pos.y, pos.z);
            this.setHeading(pos.heading);
            this.revalidateZone(true);
        }
        this.broadcastPacket(new StopMove(this));
        if (Config.MOVE_BASED_KNOWNLIST && updateKnownObjects) {
            this.getKnownList().findObjects();
        }
    }

    public boolean isShowSummonAnimation() {
        return this._showSummonAnimation;
    }

    public void setShowSummonAnimation(boolean showSummonAnimation) {
        this._showSummonAnimation = showSummonAnimation;
    }

    public void setTarget(L2Object object) {
        if (object != null && !object.isVisible()) {
            object = null;
        }
        if (object != null && object != this._target) {
            this.getKnownList().addKnownObject(object);
            object.getKnownList().addKnownObject(this);
        }
        this._target = object;
    }

    public final int getTargetId() {
        if (this._target != null) {
            return this._target.getObjectId();
        }
        return -1;
    }

    public final L2Object getTarget() {
        return this._target;
    }

    protected void moveToLocation(int x, int y, int z, int offset) {
        double cos;
        double sin;
        boolean verticalMovementOnly;
        float speed = this.getStat().getMoveSpeed();
        if (speed <= 0.0f || this.isMovementDisabled()) {
            return;
        }
        int curX = super.getX();
        int curY = super.getY();
        int curZ = super.getZ();
        double dx = x - curX;
        double dy = y - curY;
        double dz = z - curZ;
        double distance = Math.sqrt(dx * dx + dy * dy);
        boolean bl = verticalMovementOnly = this.isFlying() && distance == 0.0 && dz != 0.0;
        if (verticalMovementOnly) {
            distance = Math.abs(dz);
        }
        if (Config.GEODATA > 0 && this.isInsideZone((byte)7) && distance > 700.0) {
            double divider = 700.0 / distance;
            x = curX + (int)(divider * dx);
            y = curY + (int)(divider * dy);
            z = curZ + (int)(divider * dz);
            dx = x - curX;
            dy = y - curY;
            dz = z - curZ;
            distance = Math.sqrt(dx * dx + dy * dy);
        }
        if (Config.DEBUG) {
            _log.fine("distance to target:" + distance);
        }
        if (offset > 0 || distance < 1.0) {
            if ((offset = (int)((double)offset - Math.abs(dz))) < 5) {
                offset = 5;
            }
            if (distance < 1.0 || distance - (double)offset <= 0.0) {
                if (Config.DEBUG) {
                    _log.fine("already in range, no movement needed.");
                }
                this.getAI().notifyEvent(CtrlEvent.EVT_ARRIVED);
                return;
            }
            sin = dy / distance;
            cos = dx / distance;
            x = curX + (int)((distance -= (double)(offset - 5)) * cos);
            y = curY + (int)(distance * sin);
        } else {
            sin = dy / distance;
            cos = dx / distance;
        }
        MoveData m = new MoveData();
        m.onGeodataPathIndex = -1;
        m.disregardingGeodata = false;
        if (!(Config.GEODATA <= 0 || this.isFlying() || this.isInsideZone((byte)7) && !this.isInsideZone((byte)2) || this instanceof L2NpcWalkerInstance)) {
            boolean isInVehicle;
            boolean bl2 = isInVehicle = this instanceof L2PcInstance && ((L2PcInstance)this).getVehicle() != null;
            if (isInVehicle) {
                m.disregardingGeodata = true;
            }
            double originalDistance = distance;
            int originalX = x;
            int originalY = y;
            int originalZ = z;
            int gtx = originalX - L2World.MAP_MIN_X >> 4;
            int gty = originalY - L2World.MAP_MIN_Y >> 4;
            if (Config.GEODATA == 2 && (!(this instanceof L2Attackable) || !((L2Attackable)this).isReturningToSpawnPoint()) || this instanceof L2PcInstance && (!isInVehicle || !(distance > 1500.0)) || this instanceof L2Summon && this.getAI().getIntention() != CtrlIntention.AI_INTENTION_FOLLOW || this.isAfraid() || this instanceof L2RiftInvaderInstance) {
                if (this.isOnGeodataPath()) {
                    try {
                        if (gtx == this._move.geoPathGtx && gty == this._move.geoPathGty) {
                            return;
                        }
                        this._move.onGeodataPathIndex = -1;
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                }
                if (curX < L2World.MAP_MIN_X || curX > L2World.MAP_MAX_X || curY < L2World.MAP_MIN_Y || curY > L2World.MAP_MAX_Y) {
                    _log.warning("Character " + this.getName() + " outside world area, in coordinates x:" + curX + " y:" + curY);
                    this.getAI().setIntention(CtrlIntention.AI_INTENTION_IDLE);
                    if (this instanceof L2PcInstance) {
                        ((L2PcInstance)this).logout();
                    } else {
                        if (this instanceof L2Summon) {
                            return;
                        }
                        this.onDecay();
                    }
                    return;
                }
                Location destiny = GeoData.getInstance().moveCheck(curX, curY, curZ, x, y, z, this.getInstanceId());
                x = destiny.getX();
                y = destiny.getY();
                z = destiny.getZ();
                dx = x - curX;
                dy = y - curY;
                dz = z - curZ;
                double d = distance = verticalMovementOnly ? Math.abs(dz * dz) : Math.sqrt(dx * dx + dy * dy);
            }
            if (Config.GEODATA == 2 && originalDistance - distance > 30.0 && distance < 2000.0 && !this.isAfraid() && (this instanceof L2Playable && !isInVehicle || this instanceof L2MinionInstance || this.isInCombat())) {
                m.geoPath = PathFinding.getInstance().findPath(curX, curY, curZ, originalX, originalY, originalZ, this.getInstanceId(), this instanceof L2Playable);
                if (m.geoPath == null || m.geoPath.size() < 2) {
                    if (this instanceof L2PcInstance || !(this instanceof L2Playable) && !(this instanceof L2MinionInstance) && Math.abs(z - curZ) > 140 || this instanceof L2Summon && !((L2Summon)this).getFollowStatus()) {
                        this.getAI().setIntention(CtrlIntention.AI_INTENTION_IDLE);
                        return;
                    }
                    m.disregardingGeodata = true;
                    x = originalX;
                    y = originalY;
                    z = originalZ;
                    distance = originalDistance;
                } else {
                    m.onGeodataPathIndex = 0;
                    m.geoPathGtx = gtx;
                    m.geoPathGty = gty;
                    m.geoPathAccurateTx = originalX;
                    m.geoPathAccurateTy = originalY;
                    x = m.geoPath.get(m.onGeodataPathIndex).getX();
                    y = m.geoPath.get(m.onGeodataPathIndex).getY();
                    z = m.geoPath.get(m.onGeodataPathIndex).getZ();
                    if (DoorTable.getInstance().checkIfDoorsBetween(curX, curY, curZ, x, y, z, this.getInstanceId())) {
                        m.geoPath = null;
                        this.getAI().setIntention(CtrlIntention.AI_INTENTION_IDLE);
                        return;
                    }
                    for (int i = 0; i < m.geoPath.size() - 1; ++i) {
                        if (!DoorTable.getInstance().checkIfDoorsBetween(m.geoPath.get(i), m.geoPath.get(i + 1), this.getInstanceId())) continue;
                        m.geoPath = null;
                        this.getAI().setIntention(CtrlIntention.AI_INTENTION_IDLE);
                        return;
                    }
                    dx = x - curX;
                    dy = y - curY;
                    dz = z - curZ;
                    distance = verticalMovementOnly ? Math.abs(dz * dz) : Math.sqrt(dx * dx + dy * dy);
                    sin = dy / distance;
                    cos = dx / distance;
                }
            }
            if (distance < 1.0 && (Config.GEODATA == 2 || this instanceof L2Playable || this instanceof L2RiftInvaderInstance || this.isAfraid())) {
                if (this instanceof L2Summon) {
                    ((L2Summon)this).setFollowStatus(false);
                }
                this.getAI().setIntention(CtrlIntention.AI_INTENTION_IDLE);
                return;
            }
        }
        if ((this.isFlying() || this.isInsideZone((byte)7)) && !verticalMovementOnly) {
            distance = Math.sqrt(distance * distance + dz * dz);
        }
        int ticksToMove = 1 + (int)(10.0 * distance / (double)speed);
        m._xDestination = x;
        m._yDestination = y;
        m._zDestination = z;
        m._heading = 0;
        if (!verticalMovementOnly) {
            this.setHeading(Util.calculateHeadingFrom(cos, sin));
        }
        if (Config.DEBUG) {
            _log.fine("dist:" + distance + "speed:" + speed + " ttt:" + ticksToMove + " heading:" + this.getHeading());
        }
        m._moveStartTime = GameTimeController.getGameTicks();
        this._move = m;
        GameTimeController.getInstance().registerMovingObject(this);
        if (ticksToMove * 100 > 3000) {
            ThreadPoolManager.getInstance().scheduleAi(new NotifyAITask(CtrlEvent.EVT_ARRIVED_REVALIDATE), 2000L);
        }
    }

    public boolean moveToNextRoutePoint() {
        if (!this.isOnGeodataPath()) {
            this._move = null;
            return false;
        }
        float speed = this.getStat().getMoveSpeed();
        if (speed <= 0.0f || this.isMovementDisabled()) {
            this._move = null;
            return false;
        }
        MoveData md = this._move;
        if (md == null) {
            return false;
        }
        MoveData m = new MoveData();
        m.onGeodataPathIndex = md.onGeodataPathIndex + 1;
        m.geoPath = md.geoPath;
        m.geoPathGtx = md.geoPathGtx;
        m.geoPathGty = md.geoPathGty;
        m.geoPathAccurateTx = md.geoPathAccurateTx;
        m.geoPathAccurateTy = md.geoPathAccurateTy;
        if (md.onGeodataPathIndex == md.geoPath.size() - 2) {
            m._xDestination = md.geoPathAccurateTx;
            m._yDestination = md.geoPathAccurateTy;
            m._zDestination = md.geoPath.get(m.onGeodataPathIndex).getZ();
        } else {
            m._xDestination = md.geoPath.get(m.onGeodataPathIndex).getX();
            m._yDestination = md.geoPath.get(m.onGeodataPathIndex).getY();
            m._zDestination = md.geoPath.get(m.onGeodataPathIndex).getZ();
        }
        double dx = m._xDestination - super.getX();
        double dy = m._yDestination - super.getY();
        double distance = Math.sqrt(dx * dx + dy * dy);
        if (distance != 0.0) {
            this.setHeading(Util.calculateHeadingFrom(this.getX(), this.getY(), m._xDestination, m._yDestination));
        }
        int ticksToMove = 1 + (int)(10.0 * distance / (double)speed);
        m._heading = 0;
        m._moveStartTime = GameTimeController.getGameTicks();
        if (Config.DEBUG) {
            _log.fine("time to target:" + ticksToMove);
        }
        this._move = m;
        GameTimeController.getInstance().registerMovingObject(this);
        if (ticksToMove * 100 > 3000) {
            ThreadPoolManager.getInstance().scheduleAi(new NotifyAITask(CtrlEvent.EVT_ARRIVED_REVALIDATE), 2000L);
        }
        MoveToLocation msg = new MoveToLocation(this);
        this.broadcastPacket(msg);
        return true;
    }

    public boolean validateMovementHeading(int heading) {
        MoveData m = this._move;
        if (m == null) {
            return true;
        }
        boolean result = true;
        if (m._heading != heading) {
            result = m._heading == 0;
            m._heading = heading;
        }
        return result;
    }

    @Deprecated
    public final double getDistance(int x, int y) {
        double dx = x - this.getX();
        double dy = y - this.getY();
        return Math.sqrt(dx * dx + dy * dy);
    }

    @Deprecated
    public final double getDistance(int x, int y, int z) {
        double dx = x - this.getX();
        double dy = y - this.getY();
        double dz = z - this.getZ();
        return Math.sqrt(dx * dx + dy * dy + dz * dz);
    }

    public final double getDistanceSq(L2Object object) {
        return this.getDistanceSq(object.getX(), object.getY(), object.getZ());
    }

    public final double getDistanceSq(int x, int y, int z) {
        double dx = x - this.getX();
        double dy = y - this.getY();
        double dz = z - this.getZ();
        return dx * dx + dy * dy + dz * dz;
    }

    public final double getPlanDistanceSq(L2Object object) {
        return this.getPlanDistanceSq(object.getX(), object.getY());
    }

    public final double getPlanDistanceSq(int x, int y) {
        double dx = x - this.getX();
        double dy = y - this.getY();
        return dx * dx + dy * dy;
    }

    public final boolean isInsideRadius(L2Object object, int radius, boolean checkZ, boolean strictCheck) {
        return this.isInsideRadius(object.getX(), object.getY(), object.getZ(), radius, checkZ, strictCheck);
    }

    public final boolean isInsideRadius(int x, int y, int radius, boolean strictCheck) {
        return this.isInsideRadius(x, y, 0, radius, false, strictCheck);
    }

    public final boolean isInsideRadius(int x, int y, int z, int radius, boolean checkZ, boolean strictCheck) {
        double dx = x - this.getX();
        double dy = y - this.getY();
        double dz = z - this.getZ();
        if (strictCheck) {
            if (checkZ) {
                return dx * dx + dy * dy + dz * dz < (double)(radius * radius);
            }
            return dx * dx + dy * dy < (double)(radius * radius);
        }
        if (checkZ) {
            return dx * dx + dy * dy + dz * dz <= (double)(radius * radius);
        }
        return dx * dx + dy * dy <= (double)(radius * radius);
    }

    public void setAttackingBodypart() {
        this._attacking = 12;
    }

    protected boolean checkAndEquipArrows() {
        return true;
    }

    protected boolean checkAndEquipBolts() {
        return true;
    }

    public void addExpAndSp(long addToExp, int addToSp) {
    }

    public abstract L2ItemInstance getActiveWeaponInstance();

    public abstract L2Weapon getActiveWeaponItem();

    public abstract L2ItemInstance getSecondaryWeaponInstance();

    public abstract L2Weapon getSecondaryWeaponItem();

    protected void onHitTimer(L2Character target, int damage, boolean crit, boolean miss, boolean soulshot, byte shld) {
        if (target == null || this.isAlikeDead() || this instanceof L2Npc && ((L2Npc)this).isEventMob) {
            this.getAI().notifyEvent(CtrlEvent.EVT_CANCEL);
            return;
        }
        if (this instanceof L2Npc && target.isAlikeDead() || target.isDead() || !this.getKnownList().knowsObject(target) && !(this instanceof L2DoorInstance)) {
            this.getAI().notifyEvent(CtrlEvent.EVT_CANCEL);
            this.sendPacket(ActionFailed.STATIC_PACKET);
            return;
        }
        if (miss) {
            if (target.hasAI()) {
                target.getAI().notifyEvent(CtrlEvent.EVT_EVADED, this);
            }
            if (target.getChanceSkills() != null) {
                target.getChanceSkills().onEvadedHit(this);
            }
            if (target instanceof L2PcInstance) {
                SystemMessage sm = new SystemMessage(SystemMessageId.C1_EVADED_C2_ATTACK);
                sm.addPcName((L2PcInstance)target);
                sm.addCharName(this);
                target.sendPacket(sm);
            }
            if (this instanceof L2PcInstance) {
                this.sendPacket(new SystemMessage(SystemMessageId.C1_ATTACK_WENT_ASTRAY).addPcName((L2PcInstance)this));
            }
        }
        if (!this.isAttackAborted()) {
            L2Weapon activeWeapon;
            if (target.isRaid() && target.giveRaidCurse() && !Config.RAID_DISABLE_CURSE && this.getLevel() > target.getLevel() + 8) {
                L2Skill skill = SkillTable.FrequentSkill.RAID_CURSE2.getSkill();
                if (skill != null) {
                    this.abortAttack();
                    this.abortCast();
                    this.getAI().setIntention(CtrlIntention.AI_INTENTION_IDLE);
                    skill.getEffects(target, this);
                } else {
                    _log.warning("Skill 4515 at level 1 is missing in DP.");
                }
                damage = 0;
            }
            this.sendDamageMessage(target, damage, false, crit, miss);
            if (target instanceof L2PcInstance) {
                L2PcInstance enemy = (L2PcInstance)target;
                enemy.getAI().clientStartAutoAttack();
            }
            if (!miss && damage > 0) {
                L2PcInstance owner;
                double reflectPercent;
                L2Weapon weapon = this.getActiveWeaponItem();
                boolean isBow = weapon != null && (weapon.getItemType() == L2WeaponType.BOW || weapon.getItemType() == L2WeaponType.CROSSBOW);
                int reflectedDamage = 0;
                if (!(isBow || target.isInvul() || target.isRaid() && this.getActingPlayer() != null && this.getActingPlayer().getLevel() > target.getLevel() + 8 || !((reflectPercent = target.getStat().calcStat(Stats.REFLECT_DAMAGE_PERCENT, 0.0, null, null)) > 0.0))) {
                    reflectedDamage = (int)(reflectPercent / 100.0 * (double)damage);
                    damage -= reflectedDamage;
                    if (reflectedDamage > target.getMaxHp()) {
                        reflectedDamage = target.getMaxHp();
                    }
                }
                target.reduceCurrentHp(damage, this, null);
                if (reflectedDamage > 0) {
                    this.reduceCurrentHp(reflectedDamage, target, true, false, null);
                }
                if (!isBow) {
                    int maxCanAbsorb;
                    int absorbDamage;
                    double absorbPercent = this.getStat().calcStat(Stats.ABSORB_DAMAGE_PERCENT, 0.0, null, null);
                    if (absorbPercent > 0.0) {
                        absorbDamage = (int)(absorbPercent / 100.0 * (double)damage);
                        maxCanAbsorb = (int)((double)this.getMaxHp() - this.getCurrentHp());
                        if (absorbDamage > maxCanAbsorb) {
                            absorbDamage = maxCanAbsorb;
                        }
                        if (absorbDamage > 0) {
                            this.setCurrentHp(this.getCurrentHp() + (double)absorbDamage);
                        }
                    }
                    if ((absorbPercent = this.getStat().calcStat(Stats.ABSORB_MANA_DAMAGE_PERCENT, 0.0, null, null)) > 0.0) {
                        absorbDamage = (int)(absorbPercent / 100.0 * (double)damage);
                        maxCanAbsorb = (int)((double)this.getMaxMp() - this.getCurrentMp());
                        if (absorbDamage > maxCanAbsorb) {
                            absorbDamage = maxCanAbsorb;
                        }
                        if (absorbDamage > 0) {
                            this.setCurrentMp(this.getCurrentMp() + (double)absorbDamage);
                        }
                    }
                }
                if (target.hasAI()) {
                    target.getAI().notifyEvent(CtrlEvent.EVT_ATTACKED, this);
                }
                this.getAI().clientStartAutoAttack();
                if (this instanceof L2Summon && (owner = ((L2Summon)this).getOwner()) != null) {
                    owner.getAI().clientStartAutoAttack();
                }
                if (!target.isRaid() && Formulas.calcAtkBreak(target, damage)) {
                    target.breakAttack();
                    target.breakCast();
                }
                if (this._chanceSkills != null) {
                    this._chanceSkills.onHit(target, damage, false, crit);
                }
                if (target.getChanceSkills() != null) {
                    target.getChanceSkills().onHit(this, damage, true, crit);
                }
            }
            if ((activeWeapon = this.getActiveWeaponItem()) != null) {
                activeWeapon.getSkillEffects(this, target, crit);
            }
            return;
        }
        if (!this.isCastingNow() && !this.isCastingSimultaneouslyNow()) {
            this.getAI().notifyEvent(CtrlEvent.EVT_CANCEL);
        }
    }

    public void breakAttack() {
        if (this.isAttackingNow()) {
            this.abortAttack();
            if (this instanceof L2PcInstance) {
                this.sendPacket(ActionFailed.STATIC_PACKET);
                this.sendPacket(new SystemMessage(SystemMessageId.ATTACK_FAILED));
            }
        }
    }

    public void breakCast() {
        if (this.isCastingNow() && this.canAbortCast() && this.getLastSkillCast() != null && this.getLastSkillCast().isMagic()) {
            this.abortCast();
            if (this instanceof L2PcInstance) {
                this.sendPacket(new SystemMessage(SystemMessageId.CASTING_INTERRUPTED));
            }
        }
    }

    protected void reduceArrowCount(boolean bolts) {
    }

    @Override
    public void onForcedAttack(L2PcInstance player) {
        L2PcInstance target;
        if (this.isInsidePeaceZone(player)) {
            player.sendPacket(new SystemMessage(SystemMessageId.TARGET_IN_PEACEZONE));
            player.sendPacket(ActionFailed.STATIC_PACKET);
            return;
        }
        if (player.isInOlympiadMode() && player.getTarget() != null && player.getTarget() instanceof L2Playable && ((target = player.getTarget() instanceof L2Summon ? ((L2Summon)player.getTarget()).getOwner() : (L2PcInstance)player.getTarget()) == null || target.isInOlympiadMode() && (!player.isOlympiadStart() || player.getOlympiadGameId() != target.getOlympiadGameId()))) {
            player.sendPacket(ActionFailed.STATIC_PACKET);
            return;
        }
        if (player.getTarget() != null && !player.getTarget().isAttackable() && !player.getAccessLevel().allowPeaceAttack()) {
            player.sendPacket(ActionFailed.STATIC_PACKET);
            return;
        }
        if (player.isConfused()) {
            player.sendPacket(ActionFailed.STATIC_PACKET);
            return;
        }
        if (!GeoData.getInstance().canSeeTarget((L2Object)player, this)) {
            player.sendPacket(new SystemMessage(SystemMessageId.CANT_SEE_TARGET));
            player.sendPacket(ActionFailed.STATIC_PACKET);
            return;
        }
        player.getAI().setIntention(CtrlIntention.AI_INTENTION_ATTACK, this);
    }

    public boolean isInsidePeaceZone(L2PcInstance attacker) {
        return this.isInsidePeaceZone(attacker, (L2Object)this);
    }

    public boolean isInsidePeaceZone(L2PcInstance attacker, L2Object target) {
        return !attacker.getAccessLevel().allowPeaceAttack() && this.isInsidePeaceZone((L2Object)attacker, target);
    }

    public boolean isInsidePeaceZone(L2Object attacker, L2Object target) {
        if (target == null) {
            return false;
        }
        if (!(target instanceof L2Playable) || !(attacker instanceof L2Playable)) {
            return false;
        }
        if (InstanceManager.getInstance().getInstance(this.getInstanceId()).isPvPInstance()) {
            return false;
        }
        if (TerritoryWarManager.PLAYER_WITH_WARD_CAN_BE_KILLED_IN_PEACEZONE && TerritoryWarManager.getInstance().isTWInProgress() && target instanceof L2PcInstance && ((L2PcInstance)target).isCombatFlagEquipped()) {
            return false;
        }
        if (Config.ALT_GAME_KARMA_PLAYER_CAN_BE_KILLED_IN_PEACEZONE) {
            if (target.getActingPlayer() != null && target.getActingPlayer().getKarma() > 0) {
                return false;
            }
            if (attacker.getActingPlayer() != null && attacker.getActingPlayer().getKarma() > 0 && target.getActingPlayer() != null && target.getActingPlayer().getPvpFlag() > 0) {
                return false;
            }
            if (attacker instanceof L2Character && target instanceof L2Character) {
                return ((L2Character)target).isInsideZone((byte)1) || ((L2Character)attacker).isInsideZone((byte)1);
            }
            if (attacker instanceof L2Character) {
                return TownManager.getTown(target.getX(), target.getY(), target.getZ()) != null || ((L2Character)attacker).isInsideZone((byte)1);
            }
        }
        if (attacker instanceof L2Character && target instanceof L2Character) {
            return ((L2Character)target).isInsideZone((byte)1) || ((L2Character)attacker).isInsideZone((byte)1);
        }
        if (attacker instanceof L2Character) {
            return TownManager.getTown(target.getX(), target.getY(), target.getZ()) != null || ((L2Character)attacker).isInsideZone((byte)1);
        }
        return TownManager.getTown(target.getX(), target.getY(), target.getZ()) != null || TownManager.getTown(attacker.getX(), attacker.getY(), attacker.getZ()) != null;
    }

    public boolean isInActiveRegion() {
        L2WorldRegion region = this.getWorldRegion();
        return region != null && region.isActive();
    }

    public boolean isInParty() {
        return false;
    }

    public L2Party getParty() {
        return null;
    }

    public int calculateTimeBetweenAttacks(L2Character target, L2Weapon weapon) {
        double atkSpd = 0.0;
        if (weapon != null && !this.isTransformed()) {
            switch (weapon.getItemType()) {
                case BOW: {
                    atkSpd = this.getStat().getPAtkSpd();
                    return (int)(517500.0 / atkSpd);
                }
                case CROSSBOW: {
                    atkSpd = this.getStat().getPAtkSpd();
                    return (int)(414000.0 / atkSpd);
                }
                case DAGGER: {
                    atkSpd = this.getStat().getPAtkSpd();
                    break;
                }
                default: {
                    atkSpd = this.getStat().getPAtkSpd();
                    break;
                }
            }
        } else {
            atkSpd = this.getPAtkSpd();
        }
        return Formulas.calcPAtkSpd(this, target, atkSpd);
    }

    public int calculateReuseTime(L2Character target, L2Weapon weapon) {
        if (weapon == null || this.isTransformed()) {
            return 0;
        }
        int reuse = weapon.getAttackReuseDelay();
        if (reuse == 0) {
            return 0;
        }
        reuse = (int)((double)reuse * this.getStat().getWeaponReuseModifier(target));
        double atkSpd = this.getStat().getPAtkSpd();
        switch (weapon.getItemType()) {
            case BOW: 
            case CROSSBOW: {
                return (int)((double)(reuse * 345) / atkSpd);
            }
        }
        return (int)((double)(reuse * 312) / atkSpd);
    }

    public boolean isUsingDualWeapon() {
        return false;
    }

    public L2Skill addSkill(L2Skill newSkill) {
        L2Skill oldSkill = null;
        if (newSkill != null) {
            oldSkill = this._skills.put(newSkill.getId(), newSkill);
            if (oldSkill != null) {
                if (oldSkill.triggerAnotherSkill()) {
                    this.removeSkill(oldSkill.getTriggeredId(), true);
                }
                this.removeStatsOwner(oldSkill);
            }
            this.addStatFuncs(newSkill.getStatFuncs(null, this));
            if (oldSkill != null && this._chanceSkills != null) {
                this.removeChanceSkill(oldSkill.getId());
            }
            if (newSkill.isChance()) {
                this.addChanceTrigger(newSkill);
            }
        }
        return oldSkill;
    }

    public L2Skill removeSkill(L2Skill skill) {
        if (skill == null) {
            return null;
        }
        return this.removeSkill(skill.getId(), true);
    }

    public L2Skill removeSkill(L2Skill skill, boolean cancelEffect) {
        if (skill == null) {
            return null;
        }
        return this.removeSkill(skill.getId(), cancelEffect);
    }

    public L2Skill removeSkill(int skillId) {
        return this.removeSkill(skillId, true);
    }

    public L2Skill removeSkill(int skillId, boolean cancelEffect) {
        L2Skill oldSkill = this._skills.remove(skillId);
        if (oldSkill != null) {
            L2Effect e;
            if (oldSkill.triggerAnotherSkill() && oldSkill.getTriggeredId() > 0) {
                this.removeSkill(oldSkill.getTriggeredId(), true);
            }
            if (oldSkill.getSkillType() != L2SkillType.TRANSFORMDISPEL) {
                if (this.getLastSkillCast() != null && this.isCastingNow() && oldSkill.getId() == this.getLastSkillCast().getId()) {
                    this.abortCast();
                }
                if (this.getLastSimultaneousSkillCast() != null && this.isCastingSimultaneouslyNow() && oldSkill.getId() == this.getLastSimultaneousSkillCast().getId()) {
                    this.abortCast();
                }
            }
            if ((cancelEffect || oldSkill.isToggle()) && ((e = this.getFirstEffect(oldSkill)) == null || e.getEffectType() != L2EffectType.TRANSFORMATION)) {
                this.removeStatsOwner(oldSkill);
                this.stopSkillEffects(oldSkill.getId());
            }
            if (oldSkill instanceof L2SkillAgathion && this instanceof L2PcInstance && ((L2PcInstance)this).getAgathionId() > 0) {
                ((L2PcInstance)this).setAgathionId(0);
                ((L2PcInstance)this).broadcastUserInfo();
            }
            if (oldSkill instanceof L2SkillMount && this instanceof L2PcInstance && ((L2PcInstance)this).isMounted()) {
                ((L2PcInstance)this).dismount();
            }
            if (oldSkill.isChance() && this._chanceSkills != null) {
                this.removeChanceSkill(oldSkill.getId());
            }
            if (oldSkill instanceof L2SkillSummon && oldSkill.getId() == 710 && this instanceof L2PcInstance && ((L2PcInstance)this).getPet() != null && ((L2PcInstance)this).getPet().getNpcId() == 14870) {
                ((L2PcInstance)this).getPet().unSummon((L2PcInstance)this);
            }
        }
        return oldSkill;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChanceSkill(int id) {
        if (this._chanceSkills == null) {
            return;
        }
        ChanceSkillList chanceSkillList = this._chanceSkills;
        synchronized (chanceSkillList) {
            for (IChanceSkillTrigger trigger : this._chanceSkills.keySet()) {
                if (!(trigger instanceof L2Skill) || ((L2Skill)trigger).getId() != id) continue;
                this._chanceSkills.remove(trigger);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChanceTrigger(IChanceSkillTrigger trigger) {
        if (this._chanceSkills == null) {
            L2Character l2Character = this;
            synchronized (l2Character) {
                if (this._chanceSkills == null) {
                    this._chanceSkills = new ChanceSkillList(this);
                }
            }
        }
        this._chanceSkills.put(trigger, trigger.getTriggeredChanceCondition());
    }

    public void removeChanceEffect(EffectChanceSkillTrigger effect) {
        if (this._chanceSkills == null) {
            return;
        }
        this._chanceSkills.remove(effect);
    }

    public void onStartChanceEffect(byte element) {
        if (this._chanceSkills == null) {
            return;
        }
        this._chanceSkills.onStart(element);
    }

    public void onActionTimeChanceEffect(byte element) {
        if (this._chanceSkills == null) {
            return;
        }
        this._chanceSkills.onActionTime(element);
    }

    public void onExitChanceEffect(byte element) {
        if (this._chanceSkills == null) {
            return;
        }
        this._chanceSkills.onExit(element);
    }

    public final L2Skill[] getAllSkills() {
        if (this._skills == null) {
            return new L2Skill[0];
        }
        return this._skills.values().toArray(new L2Skill[this._skills.values().size()]);
    }

    public ChanceSkillList getChanceSkills() {
        return this._chanceSkills;
    }

    public int getSkillLevel(int skillId) {
        L2Skill skill = this.getKnownSkill(skillId);
        if (skill == null) {
            return -1;
        }
        return skill.getLevel();
    }

    public final L2Skill getKnownSkill(int skillId) {
        if (this._skills == null) {
            return null;
        }
        return this._skills.get(skillId);
    }

    public int getBuffCount() {
        return this._effects.getBuffCount();
    }

    public int getDanceCount() {
        return this._effects.getDanceCount();
    }

    public void onMagicLaunchedTimer(MagicUseTask mut) {
        L2Skill skill = mut.skill;
        L2Object[] targets = mut.targets;
        if (skill == null || targets == null) {
            this.abortCast();
            return;
        }
        if (targets.length == 0) {
            switch (skill.getTargetType()) {
                case TARGET_AURA: 
                case TARGET_FRONT_AURA: 
                case TARGET_BEHIND_AURA: {
                    break;
                }
                default: {
                    this.abortCast();
                    return;
                }
            }
        }
        int escapeRange = 0;
        if (skill.getEffectRange() > escapeRange) {
            escapeRange = skill.getEffectRange();
        } else if (skill.getCastRange() < 0 && skill.getSkillRadius() > 80) {
            escapeRange = skill.getSkillRadius();
        }
        if (targets.length > 0 && escapeRange > 0) {
            int _skiprange = 0;
            int _skipgeo = 0;
            int _skippeace = 0;
            FastList targetList = new FastList(targets.length);
            for (L2Object target : targets) {
                if (!(target instanceof L2Character)) continue;
                if (!Util.checkIfInRange(escapeRange, this, target, true)) {
                    ++_skiprange;
                    continue;
                }
                if (skill.getSkillRadius() > 0 && skill.isOffensive() && Config.GEODATA > 0 && !GeoData.getInstance().canSeeTarget((L2Object)this, target)) {
                    ++_skipgeo;
                    continue;
                }
                if (skill.isOffensive() && !skill.isNeutral()) {
                    if (this instanceof L2PcInstance) {
                        if (((L2Character)target).isInsidePeaceZone((L2PcInstance)this)) {
                            ++_skippeace;
                            continue;
                        }
                    } else if (((L2Character)target).isInsidePeaceZone(this, target)) {
                        ++_skippeace;
                        continue;
                    }
                }
                targetList.add((L2Character)target);
            }
            if (targetList.isEmpty()) {
                if (this instanceof L2PcInstance) {
                    if (_skiprange > 0) {
                        this.sendPacket(new SystemMessage(SystemMessageId.DIST_TOO_FAR_CASTING_STOPPED));
                    } else if (_skipgeo > 0) {
                        this.sendPacket(new SystemMessage(SystemMessageId.CANT_SEE_TARGET));
                    } else if (_skippeace > 0) {
                        this.sendPacket(new SystemMessage(SystemMessageId.A_MALICIOUS_SKILL_CANNOT_BE_USED_IN_PEACE_ZONE));
                    }
                }
                this.abortCast();
                return;
            }
            mut.targets = targetList.toArray(new L2Character[targetList.size()]);
        }
        if (mut.simultaneously && !this.isCastingSimultaneouslyNow() || !mut.simultaneously && !this.isCastingNow() || this.isAlikeDead() && !skill.isPotion()) {
            this.getAI().notifyEvent(CtrlEvent.EVT_CANCEL);
            return;
        }
        int magicId = skill.getDisplayId();
        int level = this.getSkillLevel(skill.getId());
        if (level < 1) {
            level = 1;
        }
        if (!skill.isPotion()) {
            this.broadcastPacket(new MagicSkillLaunched(this, magicId, level, targets));
        }
        mut.phase = 2;
        if (mut.hitTime == 0) {
            this.onMagicHitTimer(mut);
        } else {
            this._skillCast = ThreadPoolManager.getInstance().scheduleEffect(mut, 400L);
        }
    }

    public void onMagicHitTimer(MagicUseTask mut) {
        L2Skill skill = mut.skill;
        L2Object[] targets = mut.targets;
        if (skill == null || targets == null) {
            this.abortCast();
            return;
        }
        if (this.getFusionSkill() != null) {
            if (mut.simultaneously) {
                this._skillCast2 = null;
                this.setIsCastingSimultaneouslyNow(false);
            } else {
                this._skillCast = null;
                this.setIsCastingNow(false);
            }
            this.getFusionSkill().onCastAbort();
            this.notifyQuestEventSkillFinished(skill, targets[0]);
            return;
        }
        L2Effect mog = this.getFirstEffect(L2EffectType.SIGNET_GROUND);
        if (mog != null) {
            if (mut.simultaneously) {
                this._skillCast2 = null;
                this.setIsCastingSimultaneouslyNow(false);
            } else {
                this._skillCast = null;
                this.setIsCastingNow(false);
            }
            mog.exit();
            this.notifyQuestEventSkillFinished(skill, targets[0]);
            return;
        }
        try {
            L2ItemInstance weaponInst;
            for (L2Object tgt : targets) {
                if (!(tgt instanceof L2Playable)) continue;
                L2Character target = (L2Character)tgt;
                if (skill.getSkillType() == L2SkillType.BUFF) {
                    SystemMessage smsg = new SystemMessage(SystemMessageId.YOU_FEEL_S1_EFFECT);
                    smsg.addSkillName(skill);
                    target.sendPacket(smsg);
                }
                if (!(this instanceof L2PcInstance) || !(target instanceof L2Summon)) continue;
                ((L2Summon)target).updateAndBroadcastStatus(1);
            }
            StatusUpdate su = new StatusUpdate(this);
            boolean isSendStatus = false;
            double mpConsume = this.getStat().getMpConsume(skill);
            if (mpConsume > 0.0) {
                if (mpConsume > this.getCurrentMp()) {
                    this.sendPacket(new SystemMessage(SystemMessageId.NOT_ENOUGH_MP));
                    this.abortCast();
                    return;
                }
                this.getStatus().reduceMp(mpConsume);
                su.addAttribute(11, (int)this.getCurrentMp());
                isSendStatus = true;
            }
            if (skill.getHpConsume() > 0) {
                double consumeHp = this.calcStat(Stats.HP_CONSUME_RATE, skill.getHpConsume(), null, null);
                if (consumeHp + 1.0 >= this.getCurrentHp()) {
                    consumeHp = this.getCurrentHp() - 1.0;
                }
                this.getStatus().reduceHp(consumeHp, this, true);
                su.addAttribute(9, (int)this.getCurrentHp());
                isSendStatus = true;
            }
            if (skill.getCpConsume() > 0) {
                double consumeCp = skill.getCpConsume();
                if (consumeCp + 1.0 >= this.getCurrentHp()) {
                    consumeCp = this.getCurrentHp() - 1.0;
                }
                this.getStatus().reduceCp((int)consumeCp);
                su.addAttribute(33, (int)this.getCurrentCp());
                isSendStatus = true;
            }
            if (isSendStatus) {
                this.sendPacket(su);
            }
            if (this instanceof L2PcInstance) {
                int charges = ((L2PcInstance)this).getCharges();
                if (skill.getMaxCharges() == 0 && charges < skill.getNumCharges()) {
                    SystemMessage sm = new SystemMessage(SystemMessageId.S1_CANNOT_BE_USED);
                    sm.addSkillName(skill);
                    this.sendPacket(sm);
                    this.abortCast();
                    return;
                }
                if (skill.getNumCharges() > 0) {
                    if (skill.getMaxCharges() > 0) {
                        ((L2PcInstance)this).increaseCharges(skill.getNumCharges(), skill.getMaxCharges());
                    } else {
                        ((L2PcInstance)this).decreaseCharges(skill.getNumCharges());
                    }
                }
                if (!(skill.getSoulConsumeCount() <= 0 && skill.getMaxSoulConsumeCount() <= 0 || ((L2PcInstance)this).decreaseSouls(skill.getSoulConsumeCount() > 0 ? skill.getSoulConsumeCount() : skill.getMaxSoulConsumeCount(), skill))) {
                    this.abortCast();
                    return;
                }
            }
            if (mut.count > 0 && (weaponInst = this.getActiveWeaponInstance()) != null) {
                if (mut.skill.useSoulShot()) {
                    weaponInst.setChargedSoulshot(mut.shots);
                } else if (mut.skill.useSpiritShot()) {
                    weaponInst.setChargedSpiritshot(mut.shots);
                }
            }
            this.callSkill(mut.skill, mut.targets);
        }
        catch (NullPointerException e) {
            _log.log(Level.WARNING, "", e);
        }
        if (mut.hitTime > 0) {
            ++mut.count;
            if (mut.count < skill.getHitCounts()) {
                int hitTime = mut.hitTime * skill.getHitTimings()[mut.count] / 100;
                if (mut.simultaneously) {
                    this._skillCast2 = ThreadPoolManager.getInstance().scheduleEffect(mut, hitTime);
                } else {
                    this._skillCast = ThreadPoolManager.getInstance().scheduleEffect(mut, hitTime);
                }
                return;
            }
        }
        mut.phase = 3;
        if (mut.hitTime == 0 || mut.coolTime == 0) {
            this.onMagicFinalizer(mut);
        } else if (mut.simultaneously) {
            this._skillCast2 = ThreadPoolManager.getInstance().scheduleEffect(mut, mut.coolTime);
        } else {
            this._skillCast = ThreadPoolManager.getInstance().scheduleEffect(mut, mut.coolTime);
        }
    }

    public void onMagicFinalizer(MagicUseTask mut) {
        L2Object target;
        if (mut.simultaneously) {
            this._skillCast2 = null;
            this.setIsCastingSimultaneouslyNow(false);
            return;
        }
        this._skillCast = null;
        this.setIsCastingNow(false);
        this._castInterruptTime = 0;
        L2Skill skill = mut.skill;
        L2Object l2Object = target = mut.targets.length > 0 ? mut.targets[0] : null;
        if (skill.nextActionIsAttack() && this.getTarget() instanceof L2Character && this.getTarget() != this && this.getTarget() == target && (this.getAI() == null || this.getAI().getNextIntention() == null || this.getAI().getNextIntention().getCtrlIntention() != CtrlIntention.AI_INTENTION_MOVE_TO)) {
            this.getAI().setIntention(CtrlIntention.AI_INTENTION_ATTACK, target);
        }
        if (skill.isOffensive() && !skill.isNeutral() && skill.getSkillType() != L2SkillType.UNLOCK && skill.getSkillType() != L2SkillType.DELUXE_KEY_UNLOCK) {
            this.getAI().clientStartAutoAttack();
        }
        this.getAI().notifyEvent(CtrlEvent.EVT_FINISH_CASTING);
        this.notifyQuestEventSkillFinished(skill, target);
        if (this instanceof L2PcInstance) {
            L2PcInstance currPlayer = (L2PcInstance)this;
            L2PcInstance.SkillDat queuedSkill = currPlayer.getQueuedSkill();
            currPlayer.setCurrentSkill(null, false, false);
            if (queuedSkill != null) {
                currPlayer.setQueuedSkill(null, false, false);
                ThreadPoolManager.getInstance().executeTask(new QueuedMagicUseTask(currPlayer, queuedSkill.getSkill(), queuedSkill.isCtrlPressed(), queuedSkill.isShiftPressed()));
            }
        }
    }

    protected void notifyQuestEventSkillFinished(L2Skill skill, L2Object target) {
    }

    public Map<Integer, Long> getDisabledSkills() {
        return this._disabledSkills;
    }

    public void enableSkill(L2Skill skill) {
        if (skill == null || this._disabledSkills == null) {
            return;
        }
        this._disabledSkills.remove(skill.getReuseHashCode());
    }

    public void disableSkill(L2Skill skill, long delay) {
        if (skill == null) {
            return;
        }
        if (this._disabledSkills == null) {
            this._disabledSkills = Collections.synchronizedMap(new FastMap());
        }
        this._disabledSkills.put(skill.getReuseHashCode(), delay > 10L ? System.currentTimeMillis() + delay : Long.MAX_VALUE);
    }

    public boolean isSkillDisabled(L2Skill skill) {
        if (skill == null) {
            return true;
        }
        return this.isSkillDisabled(skill.getReuseHashCode());
    }

    public boolean isSkillDisabled(int reuseHashcode) {
        if (this.isAllSkillsDisabled()) {
            return true;
        }
        if (this._disabledSkills == null) {
            return false;
        }
        Long timeStamp = this._disabledSkills.get(reuseHashcode);
        if (timeStamp == null) {
            return false;
        }
        if (timeStamp < System.currentTimeMillis()) {
            this._disabledSkills.remove(reuseHashcode);
            return false;
        }
        return true;
    }

    public void disableAllSkills() {
        if (Config.DEBUG) {
            _log.fine("all skills disabled");
        }
        this._allSkillsDisabled = true;
    }

    public void enableAllSkills() {
        if (Config.DEBUG) {
            _log.fine("all skills enabled");
        }
        this._allSkillsDisabled = false;
    }

    public void callSkill(L2Skill skill, L2Object[] targets) {
        block50: {
            try {
                L2Object target2;
                ISkillHandler handler = SkillHandler.getInstance().getSkillHandler(skill.getSkillType());
                L2Weapon activeWeapon = this.getActiveWeaponItem();
                if (skill.isToggle() && this.getFirstEffect(skill.getId()) != null) {
                    return;
                }
                block17: for (L2Object trg : targets) {
                    if (!(trg instanceof L2Character)) continue;
                    target2 = (L2Character)trg;
                    L2Character targetsAttackTarget = null;
                    L2Character targetsCastTarget = null;
                    if (((L2Character)target2).hasAI()) {
                        targetsAttackTarget = ((L2Character)target2).getAI().getAttackTarget();
                        targetsCastTarget = ((L2Character)target2).getAI().getCastTarget();
                    }
                    if (!Config.RAID_DISABLE_CURSE && (((L2Character)target2).isRaid() && ((L2Character)target2).giveRaidCurse() && this.getLevel() > ((L2Character)target2).getLevel() + 8 || !skill.isOffensive() && targetsAttackTarget != null && targetsAttackTarget.isRaid() && targetsAttackTarget.giveRaidCurse() && targetsAttackTarget.getAttackByList().contains(target2) && this.getLevel() > targetsAttackTarget.getLevel() + 8 || !skill.isOffensive() && targetsCastTarget != null && targetsCastTarget.isRaid() && targetsCastTarget.giveRaidCurse() && targetsCastTarget.getAttackByList().contains(target2) && this.getLevel() > targetsCastTarget.getLevel() + 8)) {
                        L2Skill tempSkill;
                        if (skill.isMagic()) {
                            tempSkill = SkillTable.FrequentSkill.RAID_CURSE.getSkill();
                            if (tempSkill != null) {
                                this.abortAttack();
                                this.abortCast();
                                this.getAI().setIntention(CtrlIntention.AI_INTENTION_IDLE);
                                tempSkill.getEffects((L2Character)target2, this);
                            } else if (_log.isLoggable(Level.WARNING)) {
                                _log.log(Level.WARNING, "Skill 4215 at level 1 is missing in DP.");
                            }
                        } else {
                            tempSkill = SkillTable.FrequentSkill.RAID_CURSE2.getSkill();
                            if (tempSkill != null) {
                                this.abortAttack();
                                this.abortCast();
                                this.getAI().setIntention(CtrlIntention.AI_INTENTION_IDLE);
                                tempSkill.getEffects((L2Character)target2, this);
                            } else if (_log.isLoggable(Level.WARNING)) {
                                _log.log(Level.WARNING, "Skill 4515 at level 1 is missing in DP.");
                            }
                        }
                        return;
                    }
                    if (skill.isOverhit() && target2 instanceof L2Attackable) {
                        ((L2Attackable)target2).overhitEnabled(true);
                    }
                    switch (skill.getSkillType()) {
                        case COMMON_CRAFT: 
                        case DWARVEN_CRAFT: {
                            continue block17;
                        }
                        default: {
                            if (activeWeapon != null && !((L2Character)target2).isDead() && activeWeapon.getSkillEffects(this, (L2Character)target2, skill).length > 0 && this instanceof L2PcInstance) {
                                SystemMessage sm = new SystemMessage(SystemMessageId.S1_HAS_BEEN_ACTIVATED);
                                sm.addSkillName(skill);
                                this.sendPacket(sm);
                            }
                            if (this._chanceSkills != null) {
                                this._chanceSkills.onSkillHit((L2Character)target2, false, skill.isMagic(), skill.isOffensive(), skill.getElement());
                            }
                            if (((L2Character)target2).getChanceSkills() == null) continue block17;
                            ((L2Character)target2).getChanceSkills().onSkillHit(this, true, skill.isMagic(), skill.isOffensive(), skill.getElement());
                        }
                    }
                }
                if (handler != null) {
                    handler.useSkill(this, skill, targets);
                } else {
                    skill.useSkill(this, targets);
                }
                L2PcInstance player = this.getActingPlayer();
                if (player != null) {
                    block18: for (L2Object target2 : targets) {
                        if (!(target2 instanceof L2Character) || skill.isNeutral()) continue;
                        if (skill.isOffensive()) {
                            if (target2 instanceof L2PcInstance || target2 instanceof L2Summon || target2 instanceof L2Trap) {
                                if (skill.getSkillType() != L2SkillType.SIGNET && skill.getSkillType() != L2SkillType.SIGNET_CASTTIME) {
                                    L2PcInstance owner;
                                    if (target2 instanceof L2PcInstance) {
                                        ((L2PcInstance)target2).getAI().clientStartAutoAttack();
                                    } else if (target2 instanceof L2Summon && ((L2Character)target2).hasAI() && (owner = ((L2Summon)target2).getOwner()) != null) {
                                        owner.getAI().clientStartAutoAttack();
                                    }
                                    if (player.getPet() != target2 && !(this instanceof L2Trap)) {
                                        player.updatePvPStatus((L2Character)target2);
                                    }
                                }
                            } else if (target2 instanceof L2Attackable) {
                                switch (skill.getId()) {
                                    case 51: 
                                    case 511: {
                                        break;
                                    }
                                    default: {
                                        ((L2Character)target2).addAttackerToAttackByList(this);
                                    }
                                }
                            }
                            if (!((L2Character)target2).hasAI()) continue;
                            switch (skill.getSkillType()) {
                                case AGGREDUCE: 
                                case AGGREDUCE_CHAR: 
                                case AGGREMOVE: {
                                    break;
                                }
                                default: {
                                    ((L2Character)target2).getAI().notifyEvent(CtrlEvent.EVT_ATTACKED, this);
                                    break;
                                }
                            }
                            continue;
                        }
                        if (target2 instanceof L2PcInstance) {
                            if (target2.equals(this) || target2.equals(player) || ((L2PcInstance)target2).getPvpFlag() <= 0 && ((L2PcInstance)target2).getKarma() <= 0) continue;
                            player.updatePvPStatus();
                            continue;
                        }
                        if (!(target2 instanceof L2Attackable)) continue;
                        switch (skill.getSkillType()) {
                            case SUMMON: 
                            case BEAST_FEED: 
                            case UNLOCK: 
                            case DELUXE_KEY_UNLOCK: 
                            case UNLOCK_SPECIAL: {
                                continue block18;
                            }
                            default: {
                                player.updatePvPStatus();
                            }
                        }
                    }
                    Collection<L2Object> objs = player.getKnownList().getKnownObjects().values();
                    for (L2Object spMob : objs) {
                        L2Npc npcMob;
                        if (!(spMob instanceof L2Npc) || !(npcMob = (L2Npc)spMob).isInsideRadius(player, 1000, true, true) || npcMob.getTemplate().getEventQuests(Quest.QuestEventType.ON_SKILL_SEE) == null) continue;
                        for (Quest quest : npcMob.getTemplate().getEventQuests(Quest.QuestEventType.ON_SKILL_SEE)) {
                            quest.notifySkillSee(npcMob, player, skill, targets, this instanceof L2Summon);
                        }
                    }
                }
                if (!skill.isOffensive()) break block50;
                block13 : switch (skill.getSkillType()) {
                    case AGGREDUCE: 
                    case AGGREDUCE_CHAR: 
                    case AGGREMOVE: {
                        break block50;
                    }
                    default: {
                        L2Object[] arr$ = targets;
                        int len$ = arr$.length;
                        int i$ = 0;
                        while (i$ < len$) {
                            target2 = arr$[i$];
                            if (target2 instanceof L2Character && ((L2Character)target2).hasAI()) {
                                ((L2Character)target2).getAI().notifyEvent(CtrlEvent.EVT_ATTACKED, this);
                            }
                            ++i$;
                            break block13;
                        }
                        break block50;
                    }
                }
                {
                    continue;
                    break;
                }
            }
            catch (Exception e) {
                _log.log(Level.WARNING, this.getClass().getSimpleName() + ": callSkill() failed.", e);
            }
        }
    }

    public boolean isBehind(L2Object target) {
        double maxAngleDiff = 60.0;
        if (target == null) {
            return false;
        }
        if (target instanceof L2Character) {
            double angleTarget;
            L2Character target1 = (L2Character)target;
            double angleChar = Util.calculateAngleFrom(this, target1);
            double angleDiff = angleChar - (angleTarget = Util.convertHeadingToDegree(target1.getHeading()));
            if (angleDiff <= -360.0 + maxAngleDiff) {
                angleDiff += 360.0;
            }
            if (angleDiff >= 360.0 - maxAngleDiff) {
                angleDiff -= 360.0;
            }
            if (Math.abs(angleDiff) <= maxAngleDiff) {
                if (Config.DEBUG) {
                    _log.info("Char " + this.getName() + " is behind " + target.getName());
                }
                return true;
            }
        } else {
            _log.fine("isBehindTarget's target not an L2 Character.");
        }
        return false;
    }

    public boolean isBehindTarget() {
        return this.isBehind(this.getTarget());
    }

    public boolean isInFrontOf(L2Character target) {
        double maxAngleDiff = 60.0;
        if (target == null) {
            return false;
        }
        double angleTarget = Util.calculateAngleFrom(target, this);
        double angleChar = Util.convertHeadingToDegree(target.getHeading());
        double angleDiff = angleChar - angleTarget;
        if (angleDiff <= -360.0 + maxAngleDiff) {
            angleDiff += 360.0;
        }
        if (angleDiff >= 360.0 - maxAngleDiff) {
            angleDiff -= 360.0;
        }
        return Math.abs(angleDiff) <= maxAngleDiff;
    }

    public boolean isFacing(L2Object target, int maxAngle) {
        if (target == null) {
            return false;
        }
        double maxAngleDiff = maxAngle / 2;
        double angleTarget = Util.calculateAngleFrom(this, target);
        double angleChar = Util.convertHeadingToDegree(this.getHeading());
        double angleDiff = angleChar - angleTarget;
        if (angleDiff <= -360.0 + maxAngleDiff) {
            angleDiff += 360.0;
        }
        if (angleDiff >= 360.0 - maxAngleDiff) {
            angleDiff -= 360.0;
        }
        return Math.abs(angleDiff) <= maxAngleDiff;
    }

    public boolean isInFrontOfTarget() {
        L2Object target = this.getTarget();
        if (target instanceof L2Character) {
            return this.isInFrontOf((L2Character)target);
        }
        return false;
    }

    public double getLevelMod() {
        return 1.0;
    }

    public final void setSkillCast(Future<?> newSkillCast) {
        this._skillCast = newSkillCast;
    }

    public final void forceIsCasting(int newSkillCastEndTick) {
        this.setIsCastingNow(true);
        this._castInterruptTime = newSkillCastEndTick - 4;
    }

    public void updatePvPFlag(int value) {
    }

    public final int getRandomDamage(L2Character target) {
        L2Weapon weaponItem = this.getActiveWeaponItem();
        if (weaponItem == null) {
            return 5 + (int)Math.sqrt(this.getLevel());
        }
        return weaponItem.getRandomDamage();
    }

    public int getAttackEndTime() {
        return this._attackEndTime;
    }

    public long getCastEndTimeLeftMilli() {
        int t;
        if (this.isCastingNow() && (t = this._castEndTime - GameTimeController.getGameTicks()) > 0) {
            return (long)t * 100L;
        }
        return 0L;
    }

    public abstract int getLevel();

    public final double calcStat(Stats stat, double init, L2Character target, L2Skill skill) {
        return this.getStat().calcStat(stat, init, target, skill);
    }

    public int getAccuracy() {
        return this.getStat().getAccuracy();
    }

    public final float getAttackSpeedMultiplier() {
        return this.getStat().getAttackSpeedMultiplier();
    }

    public int getCON() {
        return this.getStat().getCON();
    }

    public int getDEX() {
        return this.getStat().getDEX();
    }

    public final double getCriticalDmg(L2Character target, double init) {
        return this.getStat().getCriticalDmg(target, init);
    }

    public int getCriticalHit(L2Character target, L2Skill skill) {
        return this.getStat().getCriticalHit(target, skill);
    }

    public int getEvasionRate(L2Character target) {
        return this.getStat().getEvasionRate(target);
    }

    public int getINT() {
        return this.getStat().getINT();
    }

    public final int getMagicalAttackRange(L2Skill skill) {
        return this.getStat().getMagicalAttackRange(skill);
    }

    public final int getMaxCp() {
        return this.getStat().getMaxCp();
    }

    public int getMAtk(L2Character target, L2Skill skill) {
        return this.getStat().getMAtk(target, skill);
    }

    public int getMAtkSpd() {
        return this.getStat().getMAtkSpd();
    }

    public int getMaxMp() {
        return this.getStat().getMaxMp();
    }

    public int getMaxHp() {
        return this.getStat().getMaxHp();
    }

    public final int getMCriticalHit(L2Character target, L2Skill skill) {
        return this.getStat().getMCriticalHit(target, skill);
    }

    public int getMDef(L2Character target, L2Skill skill) {
        return this.getStat().getMDef(target, skill);
    }

    public int getMEN() {
        return this.getStat().getMEN();
    }

    public double getMReuseRate(L2Skill skill) {
        return this.getStat().getMReuseRate(skill);
    }

    public float getMovementSpeedMultiplier() {
        return this.getStat().getMovementSpeedMultiplier();
    }

    public int getPAtk(L2Character target) {
        return this.getStat().getPAtk(target);
    }

    public double getPAtkAnimals(L2Character target) {
        return this.getStat().getPAtkAnimals(target);
    }

    public double getPAtkDragons(L2Character target) {
        return this.getStat().getPAtkDragons(target);
    }

    public double getPAtkInsects(L2Character target) {
        return this.getStat().getPAtkInsects(target);
    }

    public double getPAtkMonsters(L2Character target) {
        return this.getStat().getPAtkMonsters(target);
    }

    public double getPAtkPlants(L2Character target) {
        return this.getStat().getPAtkPlants(target);
    }

    public double getPAtkGiants(L2Character target) {
        return this.getStat().getPAtkGiants(target);
    }

    public double getPAtkMCreatures(L2Character target) {
        return this.getStat().getPAtkMCreatures(target);
    }

    public double getPDefAnimals(L2Character target) {
        return this.getStat().getPDefAnimals(target);
    }

    public double getPDefDragons(L2Character target) {
        return this.getStat().getPDefDragons(target);
    }

    public double getPDefInsects(L2Character target) {
        return this.getStat().getPDefInsects(target);
    }

    public double getPDefMonsters(L2Character target) {
        return this.getStat().getPDefMonsters(target);
    }

    public double getPDefPlants(L2Character target) {
        return this.getStat().getPDefPlants(target);
    }

    public double getPDefGiants(L2Character target) {
        return this.getStat().getPDefGiants(target);
    }

    public int getMaxVisibleHp() {
        return this.getStat().getMaxVisibleHp();
    }

    public int getPAtkSpd() {
        return this.getStat().getPAtkSpd();
    }

    public int getPDef(L2Character target) {
        return this.getStat().getPDef(target);
    }

    public final int getPhysicalAttackRange() {
        return this.getStat().getPhysicalAttackRange();
    }

    public int getRunSpeed() {
        return this.getStat().getRunSpeed();
    }

    public final int getShldDef() {
        return this.getStat().getShldDef();
    }

    public int getSTR() {
        return this.getStat().getSTR();
    }

    public final int getWalkSpeed() {
        return this.getStat().getWalkSpeed();
    }

    public int getWIT() {
        return this.getStat().getWIT();
    }

    public void addStatusListener(L2Character object) {
        this.getStatus().addStatusListener(object);
    }

    public void reduceCurrentHp(double i, L2Character attacker, L2Skill skill) {
        this.reduceCurrentHp(i, attacker, true, false, skill);
    }

    public void reduceCurrentHpByDOT(double i, L2Character attacker, L2Skill skill) {
        this.reduceCurrentHp(i, attacker, !skill.isToggle(), true, skill);
    }

    public void reduceCurrentHp(double i, L2Character attacker, boolean awake, boolean isDOT, L2Skill skill) {
        if (Config.L2JMOD_CHAMPION_ENABLE && this.isChampion() && Config.L2JMOD_CHAMPION_HP != 0) {
            this.getStatus().reduceHp(i / (double)Config.L2JMOD_CHAMPION_HP, attacker, awake, isDOT, false);
        } else {
            this.getStatus().reduceHp(i, attacker, awake, isDOT, false);
        }
    }

    public void reduceCurrentMp(double i) {
        this.getStatus().reduceMp(i);
    }

    public void removeStatusListener(L2Character object) {
        this.getStatus().removeStatusListener(object);
    }

    protected void stopHpMpRegeneration() {
        this.getStatus().stopHpMpRegeneration();
    }

    public final double getCurrentCp() {
        return this.getStatus().getCurrentCp();
    }

    public final void setCurrentCp(Double newCp) {
        this.setCurrentCp((double)newCp);
    }

    public final void setCurrentCp(double newCp) {
        this.getStatus().setCurrentCp(newCp);
    }

    public final double getCurrentHp() {
        return this.getStatus().getCurrentHp();
    }

    public final void setCurrentHp(double newHp) {
        this.getStatus().setCurrentHp(newHp);
    }

    public final void setCurrentHpMp(double newHp, double newMp) {
        this.getStatus().setCurrentHpMp(newHp, newMp);
    }

    public final double getCurrentMp() {
        return this.getStatus().getCurrentMp();
    }

    public final void setCurrentMp(Double newMp) {
        this.setCurrentMp((double)newMp);
    }

    public final void setCurrentMp(double newMp) {
        this.getStatus().setCurrentMp(newMp);
    }

    public boolean isChampion() {
        return false;
    }

    public int getMaxBuffCount() {
        return Config.BUFFS_MAX_AMOUNT + Math.max(0, this.getSkillLevel(1405));
    }

    public void sendDamageMessage(L2Character target, int damage, boolean mcrit, boolean pcrit, boolean miss) {
    }

    public FusionSkill getFusionSkill() {
        return this._fusionSkill;
    }

    public void setFusionSkill(FusionSkill fb) {
        this._fusionSkill = fb;
    }

    public byte getAttackElement() {
        return this.getStat().getAttackElement();
    }

    public int getAttackElementValue(byte attackAttribute) {
        return this.getStat().getAttackElementValue(attackAttribute);
    }

    public int getDefenseElementValue(byte defenseAttribute) {
        return this.getStat().getDefenseElementValue(defenseAttribute);
    }

    public final void startPhysicalAttackMuted() {
        this.setIsPhysicalAttackMuted(true);
        this.abortAttack();
    }

    public final void stopPhysicalAttackMuted(L2Effect effect) {
        if (effect == null) {
            this.stopEffects(L2EffectType.PHYSICAL_ATTACK_MUTE);
        } else {
            this.removeEffect(effect);
        }
        this.setIsPhysicalAttackMuted(false);
    }

    public void disableCoreAI(boolean val) {
        this._AIdisabled = val;
    }

    public boolean isCoreAIDisabled() {
        return this._AIdisabled;
    }

    public boolean isRaidMinion() {
        return false;
    }

    public void setIsRaidMinion(boolean val) {
    }

    public boolean giveRaidCurse() {
        return true;
    }

    private static class UsePotionTask
    implements Runnable {
        private L2Character _activeChar;
        private L2Skill _skill;

        UsePotionTask(L2Character activeChar, L2Skill skill) {
            this._activeChar = activeChar;
            this._skill = skill;
        }

        @Override
        public void run() {
            try {
                this._activeChar.doSimultaneousCast(this._skill);
            }
            catch (Exception e) {
                _log.log(Level.WARNING, "", e);
            }
        }
    }

    public static class MoveData {
        public int _moveStartTime;
        public int _moveTimestamp;
        public int _xDestination;
        public int _yDestination;
        public int _zDestination;
        public double _xAccurate;
        public double _yAccurate;
        public double _zAccurate;
        public int _heading;
        public boolean disregardingGeodata;
        public int onGeodataPathIndex;
        public List<AbstractNodeLoc> geoPath;
        public int geoPathAccurateTx;
        public int geoPathAccurateTy;
        public int geoPathGtx;
        public int geoPathGty;
    }

    public class AIAccessor {
        public L2Character getActor() {
            return L2Character.this;
        }

        public void moveTo(int x, int y, int z, int offset) {
            L2Character.this.moveToLocation(x, y, z, offset);
        }

        public void moveTo(int x, int y, int z) {
            L2Character.this.moveToLocation(x, y, z, 0);
        }

        public void stopMove(L2CharPosition pos) {
            L2Character.this.stopMove(pos);
        }

        public void doAttack(L2Character target) {
            L2Character.this.doAttack(target);
        }

        public void doCast(L2Skill skill) {
            L2Character.this.doCast(skill);
        }

        public NotifyAITask newNotifyTask(CtrlEvent evt) {
            return new NotifyAITask(evt);
        }

        public void detachAI() {
            L2Character.this._ai = null;
        }
    }

    class FlyToLocationTask
    implements Runnable {
        private final L2Object _tgt;
        private final L2Character _actor;
        private final L2Skill _skill;

        public FlyToLocationTask(L2Character actor, L2Object target, L2Skill skill) {
            this._actor = actor;
            this._tgt = target;
            this._skill = skill;
        }

        @Override
        public void run() {
            try {
                FlyToLocation.FlyType _flyType = FlyToLocation.FlyType.valueOf(this._skill.getFlyType());
                L2Character.this.broadcastPacket(new FlyToLocation(this._actor, this._tgt, _flyType));
                L2Character.this.setXYZ(this._tgt.getX(), this._tgt.getY(), this._tgt.getZ());
            }
            catch (Exception e) {
                _log.log(Level.SEVERE, "Failed executing FlyToLocationTask.", e);
            }
        }
    }

    public class NotifyAITask
    implements Runnable {
        private final CtrlEvent _evt;

        NotifyAITask(CtrlEvent evt) {
            this._evt = evt;
        }

        @Override
        public void run() {
            try {
                L2Character.this.getAI().notifyEvent(this._evt, null);
            }
            catch (Exception e) {
                _log.log(Level.WARNING, "NotifyAITask failed. " + e.getMessage() + " Actor " + L2Character.this, e);
            }
        }
    }

    private static class QueuedMagicUseTask
    implements Runnable {
        L2PcInstance _currPlayer;
        L2Skill _queuedSkill;
        boolean _isCtrlPressed;
        boolean _isShiftPressed;

        public QueuedMagicUseTask(L2PcInstance currPlayer, L2Skill queuedSkill, boolean isCtrlPressed, boolean isShiftPressed) {
            this._currPlayer = currPlayer;
            this._queuedSkill = queuedSkill;
            this._isCtrlPressed = isCtrlPressed;
            this._isShiftPressed = isShiftPressed;
        }

        @Override
        public void run() {
            try {
                this._currPlayer.useMagic(this._queuedSkill, this._isCtrlPressed, this._isShiftPressed);
            }
            catch (Exception e) {
                _log.log(Level.SEVERE, "Failed executing QueuedMagicUseTask.", e);
            }
        }
    }

    class MagicUseTask
    implements Runnable {
        L2Object[] targets;
        L2Skill skill;
        int count;
        int hitTime;
        int coolTime;
        int phase;
        boolean simultaneously;
        int shots;

        public MagicUseTask(L2Object[] tgts, L2Skill s, int hit, int coolT, boolean simultaneous, int shot) {
            this.targets = tgts;
            this.skill = s;
            this.count = 0;
            this.phase = 1;
            this.hitTime = hit;
            this.coolTime = coolT;
            this.simultaneously = simultaneous;
            this.shots = shot;
        }

        @Override
        public void run() {
            try {
                switch (this.phase) {
                    case 1: {
                        L2Character.this.onMagicLaunchedTimer(this);
                        break;
                    }
                    case 2: {
                        L2Character.this.onMagicHitTimer(this);
                        break;
                    }
                    case 3: {
                        L2Character.this.onMagicFinalizer(this);
                        break;
                    }
                }
            }
            catch (Exception e) {
                _log.log(Level.SEVERE, "Failed executing MagicUseTask.", e);
                if (this.simultaneously) {
                    L2Character.this.setIsCastingSimultaneouslyNow(false);
                }
                L2Character.this.setIsCastingNow(false);
            }
        }
    }

    class HitTask
    implements Runnable {
        L2Character _hitTarget;
        int _damage;
        boolean _crit;
        boolean _miss;
        byte _shld;
        boolean _soulshot;

        public HitTask(L2Character target, int damage, boolean crit, boolean miss, boolean soulshot, byte shld) {
            this._hitTarget = target;
            this._damage = damage;
            this._crit = crit;
            this._shld = shld;
            this._miss = miss;
            this._soulshot = soulshot;
        }

        @Override
        public void run() {
            try {
                L2Character.this.onHitTimer(this._hitTarget, this._damage, this._crit, this._miss, this._soulshot, this._shld);
            }
            catch (Exception e) {
                _log.log(Level.SEVERE, "Failed executing HitTask.", e);
            }
        }
    }
}

