/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor.instance;

import com.l2jserver.gameserver.GeoData;
import com.l2jserver.gameserver.ai.CtrlIntention;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.serverpackets.ActionFailed;
import com.l2jserver.gameserver.network.serverpackets.MyTargetSelected;
import com.l2jserver.gameserver.network.serverpackets.StatusUpdate;
import com.l2jserver.gameserver.network.serverpackets.ValidateLocation;
import com.l2jserver.gameserver.templates.chars.L2NpcTemplate;

public class L2FlameTowerInstance
extends L2Npc {
    public L2FlameTowerInstance(int objectId, L2NpcTemplate template) {
        super(objectId, template);
        this.setInstanceType(L2Object.InstanceType.L2FlameTowerInstance);
        this.setIsInvul(false);
    }

    @Override
    public boolean isAttackable() {
        return this.getCastle() != null && this.getCastle().getCastleId() > 0 && this.getCastle().getSiege().getIsInProgress();
    }

    @Override
    public boolean isAutoAttackable(L2Character attacker) {
        return attacker != null && attacker instanceof L2PcInstance && this.getCastle() != null && this.getCastle().getCastleId() > 0 && this.getCastle().getSiege().getIsInProgress() && this.getCastle().getSiege().checkIsAttacker(((L2PcInstance)attacker).getClan());
    }

    @Override
    public void onForcedAttack(L2PcInstance player) {
        this.onAction(player);
    }

    @Override
    public void onAction(L2PcInstance player, boolean interact) {
        if (!this.canTarget(player)) {
            return;
        }
        if (this != player.getTarget()) {
            player.setTarget(this);
            MyTargetSelected my = new MyTargetSelected(this.getObjectId(), player.getLevel() - this.getLevel());
            player.sendPacket(my);
            StatusUpdate su = new StatusUpdate(this);
            su.addAttribute(9, (int)this.getStatus().getCurrentHp());
            su.addAttribute(10, this.getMaxHp());
            player.sendPacket(su);
            player.sendPacket(new ValidateLocation(this));
        } else if (interact && this.isAutoAttackable(player) && Math.abs(player.getZ() - this.getZ()) < 100 && GeoData.getInstance().canSeeTarget((L2Object)player, this)) {
            player.getAI().setIntention(CtrlIntention.AI_INTENTION_ATTACK, this);
        }
        player.sendPacket(ActionFailed.STATIC_PACKET);
    }

    @Override
    public boolean doDie(L2Character killer) {
        if (this.getCastle().getSiege().getIsInProgress()) {
            this.getCastle().getSiege().disableTraps();
        }
        return super.doDie(killer);
    }
}

